<?php

/*******************************
 * Auth.php
 * Authentication Library
 * handles the session and login mechanics of authentication.
 * actual authentication is handled by various back-ends. 
 * 
 * Sessions must be enabled. Uses two session variables:
 *  username     -- used to store the authenticated user name.
 *  sessionalive -- used to confirm that sessions are working.
 * 
 * Example web app structure using Auth:

$users = new SqliteUserBackend();
$auth = new Auth($users,'authenticate');

include('header.php');
$username = $auth->login("Program Name");
$action   = $_GET['action'];
If ($action == 'logout')
	$auth->logout("Program Name");
elseif ($username != '')
	handle_request();
include('footer.php');

******************************/

class Auth {

var $auth_object;
var $auth_function;
var $skip = array("PHPSESSID","login","password","firsttime","auth");

function Auth(&$object,$function) {
	$this->auth_object = $object;
	$this->auth_function = $function;
}

/*
 * this function is used to prevent session-fixation attacks.
 * it must be called BEFORE session_start. 
 * Basically, if this is a login request then we change the 
 * session id to be something new. This is because the session
 * id might be an id which someone else has 'fixed' on the client's
 * machine and we want to generate a new one which they don't know about.
 */
function init() {
	if(isset($_REQUEST['login']) && isset($_REQUEST['password'])) {
		$random_token = md5(uniqid(rand(),1));
		session_id($random_token);
	}
	elseif(isset($_SERVER['REMOTE_USER']) && $this->type == 'external') {
		$random_token = md5(uniqid(rand(),1));
		session_id($random_token);
	}
}

function logout() {
	$_SESSION['username'] = NULL;
}

function getLoginForm($title='',$error='') {
	$action = preg_replace('/\?.*$/', '', $_SERVER['REQUEST_URI']);
	$action = htmlspecialchars($action);
	$logintext = _("Login");
	$ret = "
	<center>
	<FORM ACTION='$action' METHOD='POST'>
	<table cellpadding='8'>
		<tr><td colspan='2'><b>$title</b></td></tr>
		<tr>
			<td align='right'>user: </td>
			<td><INPUT TYPE='text' NAME='login' value=''></td>
		</tr>
		<tr>
			<td align='right'>password: </td>
			<td><INPUT TYPE='password' NAME='password' value=''></td>
		</tr>
		<tr>
			<td colspan='2'>
				<font color='red'>$error</font>
			</td>
		</tr>
		<tr>
			<td colspan='2' align='right'>
				<input type='hidden' name='firsttime' value='false'>
				<input type='hidden' name='auth' value='login'>
				<input type='submit' value='$logintext'>
	";
	foreach($_REQUEST as $arg => $value) {
		if (in_array($arg,$this->skip)) continue;	
		if ($arg == 'data') {
			$value = &getraw('data');
		}
		$arg = htmlspecialchars($arg);
		$value = htmlentities($value);
		$ret .= "<input type='hidden' name='$arg' value=\"";
		$ret .= $value;
		$ret .= "\"> \n";
	}
	$ret .= '</td>
		</tr>
	</table>
	</FORM>
	</center>';
	return $ret;
}

function username() {
	return $_SESSION['username'];
}

function login(&$error) {
	$login     = get('login');
	$password  = get('password');
	$firsttime = get('firsttime',true);
	
	if ($firsttime) {
		$_SESSION['sessionalive'] = true;
	}
	elseif (!$_SESSION['session_alive']) {
		$error = "Cookies are not enabled. You must enable cookies to login.";
		return false;
	}
	
	$ok = $this->authenticate($login, $password, $error);
	if (!$ok) {
		if ($error == '')
			$error = 'User or password was incorrect';
		return false;
	}
	else {
		$_SESSION['username'] = $login;
		return true;
	}
}

function authenticate($user,$pass,&$error) {
	if (!method_exists($this->auth_object,$this->auth_function))
		die(_("No authentication type set"));
	$object = & $this->auth_object;
	$function = $this->auth_function;
	return $object->$function($user,$pass,$error);
}	

/*
function getredirect() {
	$action = preg_replace('/\?.*$/', '', $_SERVER['REQUEST_URI']);
	$action .= "?";
	foreach($_REQUEST as $arg => $value) {
		if (in_array($arg,$this->skip)) continue;	
		$action .= "$arg=$value&";
	}
	return preg_replace("'[\?\&]$'","",$action);
}
*/
	
} // end class Auth

return;
?>
