<?php

class Changes {
	var $_basePage;
    var $_modifiedTimes;
    var $_maxResults;
  
    function Changes($page, $maxResults=15) {
    	$this->_basePage = $page;
    	$this->_maxResults = $maxResults;
    }
    
	function modifiedTimes() {   
		if ( isset($this->_modifiedTimes) ) {
			return $this->_modifiedTimes;
		}
		else {
			$this->modifiedTimes = array();
			$this->_findModifiedTimes($this->_basePage);
			krsort($this->_modifiedTimes);
			return $this->_modifiedTimes;
		}
	}
	
	function _findModifiedTimes($page) {
		if ( $page->mtime and $page->mtime != 1 ) {
			$this->_modifiedTimes[$page->mtime] = $page;
		}
		$children = $page->children();
		foreach($children as $child) {
		if ($child->get('index') == true)
			$this->_findModifiedTimes($child);
		}
	}
	
	function results($mode='HTML') {
		$times = $this->modifiedTimes();
		
		$current_date;
		$count = 0;
		$root = $GLOBALS['root']; // hackish

		
		$results_title = $this->resultsTitle();		
		$str = "<h2>$results_title</h2>";
		$str .= '<table id="recent_changes">';
		foreach ($times as $time => $page) {
			if ( ++$count > $this->_maxResults ) {
				break;
			}
			$date = date("Y-m-d", $time);
			if ( $date != $current_date ) {
				$str .= "<tr class=\"daybreak\"><td>$date</td></tr>";
				$current_date = $date;
			}
			$path = $page->path;
			$title = $page->get('title');
			if ($title == '') $title = "Untitled";
			$str .= "<tr><td><a href=\"$root$path\">$title</a><br /><span class=\"path\">$path</span></td></tr>";
		}
		$str .= "</table";
		return $str;
	}
	
	# um, i'm not so sure about the wisdom of a templating
	# system that relies on global variables
	function resultsRss() {
		$times = $this->modifiedTimes();
		$rss_items = array();
		$count = 0;
		$root = $GLOBALS['root']; // hackish

		foreach ($times as $time => $page) {
			if ( ++$count > $this->_maxResults ) {
				break;
			}
			$title = $page->get('title');
			if ($title == '') $title = "Untitled";
			
			$rss_items[] = array(
				'title' => $title,
				'link'	=> 'http://' . $_SERVER['HTTP_HOST'] . $root . $page->path,
				'description' => $path->path,
				'date' => date("Y-m-d\TH:M", $time));
		}
		
		$GLOBALS['rss_items'] = $rss_items;
		
		$channel = array(
			'title' => $this->resultsTitle(),
			'link'	=> 'http://' . $_SERVER['HTTP_HOST'] . $root . $this->_basePage->path,
			'description' => '');
		
		if ( count($rss_items) ) {
			$channel['dc:date'] = $rss_items[0]['date'];
		}
			
		$GLOBALS['rss_channel'] = $channel;
		
	}
	
	function resultsTitle() {
		$rc = _('Recent Changes');
		if ( ! $this->_basePage->path and 
			$sitename = $this->_basePage->prop->getGlobal('sitename')
		) {
			$results_title = "$rc: $sitename";
		}
		elseif ( $title = $this->_basePage->get('title') ) {
			$results_title = "$rc: $title";
		}
		else {
			$results_title = $rc;
		}
		return $results_title;
	}
}

return;
?>
