SET (BALL_HAS_FFTW TRUE)
SET (BALL_HAS_FFTW_H TRUE)

INCLUDE_DIRECTORIES(${FFTW_INCLUDE})

#If the libraries are set, set the default traits to the favoured
#precision (in our case float is prefered
IF (FFTWL_FOUND)
	SET(BALL_HAS_FFTW_LONG_DOUBLE TRUE)
	SET(FFTW_LIBRARIES ${FFTWL_LIB} ${FFTW_LIBRARIES})
	SET(BALL_FFTW_DEFAULT_TRAITS LongDoubleTraits)
ENDIF()

IF (FFTWD_FOUND)
	SET(BALL_HAS_FFTW_DOUBLE TRUE)
	SET(FFTW_LIBRARIES ${FFTWD_LIB} ${FFTW_LIBRARIES})
	SET(BALL_FFTW_DEFAULT_TRAITS DoubleTraits)
	MESSAGE(STATUS "Falling back to double complex precision")
ENDIF()

IF (FFTWF_FOUND)
	SET(BALL_HAS_FFTW_FLOAT TRUE)
	SET(FFTW_LIBRARIES ${FFTWF_LIB} ${FFTW_LIBRARIES})
	SET(BALL_FFTW_DEFAULT_TRAITS FloatTraits)
	MESSAGE(STATUS "Falling back to long double complex precision")
ENDIF()

#The user may override these settings
IF (BALL_COMPLEX_PRECISION STREQUAL "float")
	IF (FFTWF_FOUND)
		SET(BALL_FFTW_DEFAULT_TRAITS FloatTraits)
	ELSE()
		MESSAGE(SEND_ERROR "FFTW library needed for desired complex precision is not available! (see BALL_COMPLEX_PRECISION)")
	ENDIF()
ELSEIF(BALL_COMPLEX_PRECISION STREQUAL "double")
	IF (FFTWD_FOUND)
		SET(BALL_FFTW_DEFAULT_TRAITS DoubleTraits)
	ELSE()
		MESSAGE(SEND_ERROR "FFTW library needed for desired complex precision is not available! (see BALL_COMPLEX_PRECISION)")
	ENDIF()
ELSEIF(BALL_COMPLEX_PRECISION STREQUAL "long double")
	IF (FFTWL_FOUND)
		SET(BALL_FFTW_DEFAULT_TRAITS LongDoubleTraits)
	ELSE()
		MESSAGE(SEND_ERROR "FFTW library needed for desired complex precision is not available! (see BALL_COMPLEX_PRECISION)")
	ENDIF()
ENDIF()

#However we still have to make some settings depending on the selected precision
IF (BALL_FFTW_DEFAULT_TRAITS STREQUAL "FloatTraits")
	SET(BALL_COMPLEX_PRECISION "float")
ELSEIF (BALL_FFTW_DEFAULT_TRAITS STREQUAL "DoubleTraits")
	SET(BALL_COMPLEX_PRECISION "double")
ELSEIF (BALL_FFTW_DEFAULT_TRAITS STREQUAL "LongDoubleTraits")
	SET(BALL_COMPLEX_PRECISION "long double")
ELSE()
	MESSAGE(SEND_ERROR "Installed FFTW library features no suitable complex precision (neither float nor double nor long double)")
ENDIF()
