#include <bakery/App/Dialog_OfferSave.h>
#include <bakery/App/App_Gtk.h>
#include <gtkmm/box.h>
#include <gtkmm/stock.h>
#include <libintl.h>

namespace Bakery
{


Dialog_OfferSave::Dialog_OfferSave(const Glib::ustring& file_uri)
: Gtk::MessageDialog( App_Gtk::util_bold_message(gettext("Close without Saving")), true /* use markup */, Gtk::MESSAGE_QUESTION, Gtk::BUTTONS_NONE)
{
  set_title(""); //The HIG says that alert dialogs should not have titles. The default comes from the message type.

  Glib::ustring message = gettext("This document has unsaved changes. Would you like to save the document?");
  if(!file_uri.empty())
    message += gettext("\n\nDocument:\n") + Glib::filename_display_basename(file_uri); //TODO: Can we use filename_display_basename() with a URI?

  set_secondary_text(message);

  add_button(gettext("Discard"), BUTTON_Discard);
  add_button(Gtk::Stock::CANCEL, BUTTON_Cancel);
  add_button(Gtk::Stock::SAVE, BUTTON_Save);
}

Dialog_OfferSave::~Dialog_OfferSave()
{

}


} //namespace
