/***************************************************************************
 *   Copyright (C) 2004 by Thomas Lbking                                  *
 *   thomas@home                                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qlayout.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qpainter.h>
//#include <qpalette.h> 
#include <qsettings.h>
#include <qslider.h>
#include <qspinbox.h>
#include <qstringlist.h>
#include <qlabel.h>
#include <qpixmap.h>

#include <kapplication.h>
#include <kcolorbutton.h>
// #include <kconfig.h>
#include <kimageeffect.h>
#include <klocale.h>
#include <kglobal.h>
#include <kparts/genericfactory.h>

#include "kstyle_baghira_config.h"
//#include "icon.h"
#include "preview.h"

#define _ENDIAN_ QImage::LittleEndian
//#define _ENDIAN_ QImage::BigEndian
#include "../ppc.h"

#define CLAMP(x,l,u) x < l ? l :\
		     x > u ? u :\
		     x

#define SATURATION_COLOR(/*S,*/R,G,B) \
    grey = (299 * R + 587 * G + 114 * B) / 1000; \
    delta = 255 - grey; \
    grey = (grey *(10 - 5)) / 10; \
    iGrey = 255 - grey;\
    destR = (iGrey * (srcR - delta) + grey * R) / 255; \
    destG = (iGrey * (srcG - delta) + grey * G) / 255; \
    destB = (iGrey * (srcB - delta) + grey * B) / 255; 

#define SATURATION_COLOR2(S,R,G,B) \
   int max = 255+0.65*(100-S); \
   destR = CLAMP((srcR + R - 128), 0, max); \
   destG = CLAMP((srcG + G - 128), 0, max); \
   destB = CLAMP((srcB + B - 128), 0, max); \
   destR = (S*destR + (100-S)*R)/100; \
   destG = (S*destG + (100-S)*G)/100; \
   destB = (S*destB + (100-S)*B)/100;
   
#define COLOR_SPACE(R,G,B) \
    if ( R < 0 ) R = 0; else if ( R > 255 ) R = 255; \
    if ( G < 0 ) G = 0; else if ( G > 255 ) G = 255; \
    if ( B < 0 ) B = 0; else if ( B > 255 ) B = 255;

/*
  Internal class to get access to protected About members (to keep About itself autogeneratable)
*/
class AboutAccess : public About
{
    friend class kstyle_baghira_config;
public:
    AboutAccess( QWidget* parent=0, const char* name=0, WFlags f = 0 )
	: About( parent, name, false, f ){}
};


void kstyle_baghira_config::openHtml1()
{
   QStringList args;
   args << "exec" << "http://baghira.sf.net/";
   kapp->kdeinitExec("kfmclient", args);
}

void kstyle_baghira_config::openHtml2()
{
   QStringList args;
   args << "exec" << "http://www.sf.net/projects/baghira/files/";
   kapp->kdeinitExec("kfmclient", args);
}

void kstyle_baghira_config::startBab()
{
   kapp->kdeinitExec("bab");
}

QImage* kstyle_baghira_config::tintButton(QImage &src, QColor c)
{
    QImage *dest = new QImage( src.width(), src.height(), 32, 0, _ENDIAN_ );
    dest->setAlphaBuffer( true );
    unsigned int *data = ( unsigned int * ) src.bits();
    unsigned int *destData = ( unsigned int* ) dest->bits();
    int total = src.width() * src.height();
    int red, green, blue;
    int destR, destG, destB, alpha;
    int srcR = c.red();
    int srcG = c.green();
    int srcB = c.blue();
    int hue, s, v;
    c.getHsv( &hue, &s, &v );
    int sq = CLAMP((int)((45.0/128.0)*s+55),0,100);
    // float srcPercent, destPercent;
    for ( int current = 0 ; current < total ; ++current ) {
#if HAVE_PPC
        alpha = qBlue( data[ current ] );
        blue = qAlpha( data[ current ] );
    	green = qRed( data[ current ] );
    	red = qGreen( data[ current ] );
#else
        alpha = qAlpha( data[ current ] );
        blue = qBlue( data[ current ] );
    	red = qRed( data[ current ] );
    	green = qGreen( data[ current ] );
#endif
	SATURATION_COLOR2(sq, red, green, blue);
	// force back to valid colorspace !
	COLOR_SPACE(destR, destG, destB);
	destData[ current ] = qRgba( destR, destG, destB, alpha );
    }
    return ( dest );
}

QImage* kstyle_baghira_config::tintBrush( QImage &img, QColor c/*, int saturation */)
{
    QImage *dest = new QImage( img.width(), img.height(), 32, 0, _ENDIAN_ );
    unsigned int *data = ( unsigned int * ) img.bits();
    unsigned int *destData = ( unsigned int* ) dest->bits();
    int total = img.width() * img.height();
    int current;
    int delta;
    int red, green, blue, grey, iGrey;
    int destR, destG, destB, alpha;
 
    int srcR = c.red();
    int srcG = c.green();
    int srcB = c.blue();
    
    
    // float srcPercent, destPercent;
    for ( current = 0 ; current < total ; ++current ) {
#if HAVE_PPC
        alpha = qBlue( data[ current ] );
        blue = qAlpha( data[ current ] );
    	green = qRed( data[ current ] );
    	red = qGreen( data[ current ] );
#else
        alpha = qAlpha( data[ current ] );
        blue = qBlue( data[ current ] );
    	red = qRed( data[ current ] );
    	green = qGreen( data[ current ] );
#endif
	SATURATION_COLOR(/*saturation,*/ red, green, blue);
	// force back to valid colorspace !
	COLOR_SPACE(destR, destG, destB);
	destData[ current ] = qRgba( destR, destG, destB, alpha );
    }
    return ( dest );
}

void kstyle_baghira_config::sliderButtonRedChanged(int value)
{
	sliderButtonRedValue = value;
	dialog_->valueButtonRed->setNum(value);
	dialog_->pixmapButtonPreview->setPixmap(*tintButton(baseImage, QColor(sliderButtonRedValue, sliderButtonGreenValue, sliderButtonBlueValue)));
	dialog_->pixmapButtonPreview->repaint(false);
}

void kstyle_baghira_config::sliderButtonGreenChanged(int value)
{
	sliderButtonGreenValue = value;
	dialog_->valueButtonGreen->setNum(value);
	dialog_->pixmapButtonPreview->setPixmap(*tintButton(baseImage, QColor(sliderButtonRedValue, sliderButtonGreenValue, sliderButtonBlueValue)));
	dialog_->pixmapButtonPreview->repaint(false);
}

void kstyle_baghira_config::sliderButtonBlueChanged(int value)
{
	sliderButtonBlueValue = value;
	dialog_->valueButtonBlue->setNum(value);
	dialog_->pixmapButtonPreview->setPixmap(*tintButton(baseImage, QColor(sliderButtonRedValue, sliderButtonGreenValue, sliderButtonBlueValue)));
	dialog_->pixmapButtonPreview->repaint(false);
}

void kstyle_baghira_config::sliderBrushRedChanged(int value)
{
	sliderBrushRedValue = value;
	dialog_->pixmapBrushPreview->setPixmap(*tintBrush(baseImage2, QColor(sliderBrushRedValue, sliderBrushGreenValue, sliderBrushBlueValue/*, sliderBrushSaturationValue*/)));
	dialog_->pixmapBrushPreview->repaint(false);
	emit changed(true);
}

void kstyle_baghira_config::sliderBrushGreenChanged(int value)
{
	sliderBrushGreenValue = value;
	dialog_->pixmapBrushPreview->setPixmap(*tintBrush(baseImage2, QColor(sliderBrushRedValue, sliderBrushGreenValue, sliderBrushBlueValue/*, sliderBrushSaturationValue*/)));
	dialog_->pixmapBrushPreview->repaint(false);
	emit changed(true);
}

void kstyle_baghira_config::sliderBrushBlueChanged(int value)
{
	sliderBrushBlueValue = value;
	dialog_->pixmapBrushPreview->setPixmap(*tintBrush(baseImage2, QColor(sliderBrushRedValue, sliderBrushGreenValue, sliderBrushBlueValue/*, sliderBrushSaturationValue*/)));
	dialog_->pixmapBrushPreview->repaint(false);
	emit changed(true);
}

// void kstyle_baghira_config::sliderBrushSaturationChanged(int value)
// {
// 	sliderBrushSaturationValue = value;
// 	dialog_->pixmapBrushPreview->setPixmap(*tintBrush(baseImage2, QColor(sliderBrushRedValue, sliderBrushGreenValue, sliderBrushBlueValue), sliderBrushSaturationValue));
// 	dialog_->pixmapBrushPreview->repaint(false);
// 	emit changed(true);
// }

typedef KGenericFactory<kstyle_baghira_config, QWidget> kstyle_baghira_configFactory;
K_EXPORT_COMPONENT_FACTORY( kcm_kstyle_baghira_config, kstyle_baghira_configFactory("kcmkstyle_baghira_config"))

kstyle_baghira_config::kstyle_baghira_config(QWidget *parent, const char *name, const QStringList&)
    : QWidget(parent, name )//, myAboutData(0)
{
    if (parent) parent->setCaption("Configure Your Cat");
    QVBoxLayout *layout = new QVBoxLayout(this);
    dialog_ = new Config(this);
    // preview stuff
    baseImage = baghira_findImage("button-base");
    
    layout->addWidget(dialog_);
    
    dialog_->show();
    help_ = new Help(dialog_);
    about_ = new About(dialog_);
    
    // get some nicer pix =)
    QLabel* icon = new QLabel( about_ );
    QPixmap blendPixmap(130,134);
    if (about_->paletteBackgroundPixmap()){
       QPainter p(&blendPixmap);
       p.drawTiledPixmap(0,0, 130, 134, *about_->paletteBackgroundPixmap());
    }
    else 
       blendPixmap.fill(about_->paletteBackgroundColor());
    QImage blendImage = blendPixmap.convertToImage();
    blendImage.convertDepth(32);
    QImage iconImage = baghira_findImage( "AboutBaghira" );
    icon->setPixmap( KImageEffect::blend( blendImage, iconImage, 0.0f));
//    icon->setCursor( QCursor( 13 ) );
//    icon->setMouseTracking( TRUE );
    ((AboutAccess*)about_)->layout4->addWidget( icon );
    QSpacerItem* spacer_2 = new QSpacerItem( 121, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    ((AboutAccess*)about_)->layout4->addItem( spacer_2 );
    about_->setFixedSize (380, 430);
    
    // load settings
    load();
    
    dialog_->pixmapButtonPreview->setPixmap(*tintButton(baseImage, QColor(sliderButtonRedValue, sliderButtonGreenValue, sliderButtonBlueValue)));
    
    // connections
    connect(dialog_->buttonHelp, SIGNAL(clicked()), 
             help_, SLOT(exec()));
    connect(dialog_->buttonAbout, SIGNAL(clicked()),
             about_, SLOT(exec()));
    connect(about_->buttonInfo, SIGNAL(clicked()),
             this, SLOT(openHtml1()));
    connect(about_->buttonDownload, SIGNAL(clicked()),
             this, SLOT(openHtml2()));
    connect(help_->startBAB, SIGNAL(clicked()),
             this, SLOT(startBab()));
    connect(dialog_->defaultStyle, SIGNAL(activated(int)),
             this, SLOT(configChanged()));
    connect(dialog_->stippleBackground, SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->bevelHighlights, SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->stippleContrast, SIGNAL(valueChanged (int)),
             this, SLOT(configChanged()));
    connect(dialog_->shadowGroups,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->shadowIntensity, SIGNAL(valueChanged (int)),
             this, SLOT(configChanged()));
    connect(dialog_->centerTabs,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->useRectButtons,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->colorMode, SIGNAL(activated(int)),
             this, SLOT(configChanged()));
    connect(dialog_->inactiveColorType, SIGNAL(activated(int)),
             this, SLOT(configChanged()));
    connect(dialog_->animateSlider,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->shadowSlider,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->squeezeSlider,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->roundToolButtons,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->unhoveredToolButtons,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->drawTreeLines,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->useCustomExpanderColor,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));             
     connect(dialog_->treeLineMode, SIGNAL(activated(int)),
             this, SLOT(configChanged()));
     connect(dialog_->expanderMode, SIGNAL(activated(int)),
             this, SLOT(configChanged()));
    connect(dialog_->useCustomExpanderColor,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->useRectLVH,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->stippleKicker,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->removeKickerBevel,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->roundTasks,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->useCustomKickerColor,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
    connect(dialog_->showProgressValue,  SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
     connect(dialog_->progressType, SIGNAL(activated(int)),
             this, SLOT(configChanged()));
     connect(dialog_->menuBackground, SIGNAL(activated(int)),
             this, SLOT(configChanged()));             
    connect(dialog_->menuOpacity, SIGNAL(valueChanged (int)),
             this, SLOT(configChanged()));
    connect(dialog_->shadowMenuText, SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
     connect(dialog_->menuColorMode, SIGNAL(activated(int)),
             this, SLOT(configChanged()));
    connect(dialog_->useCustomColors, SIGNAL(stateChanged(int)),
             this, SLOT(configChanged()));
             
     connect(dialog_->customInactiveColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->treeLineColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->customExpanderColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->customKickerColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->menuTextColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->menuColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->menuColor2, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->radioOffColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->radioOnColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->checkOffColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->checkOnColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->sliderColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->hoverSliderColorColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->pressedSliderColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->inactiveTabColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
     connect(dialog_->activeTabColor, SIGNAL(changed(const QColor &)),
             this, SLOT(configChanged()));
	     
     connect(dialog_->sliderButtonRed, SIGNAL(valueChanged (int)),
             this, SLOT(sliderButtonRedChanged(int)));
     connect(dialog_->sliderButtonGreen, SIGNAL(valueChanged (int)),
             this, SLOT(sliderButtonGreenChanged(int)));
     connect(dialog_->sliderButtonBlue, SIGNAL(valueChanged (int)),
             this, SLOT(sliderButtonBlueChanged(int)));    

     connect(dialog_->sliderBrushRed, SIGNAL(valueChanged (int)),
             this, SLOT(sliderBrushRedChanged(int)));
     connect(dialog_->sliderBrushGreen, SIGNAL(valueChanged (int)),
             this, SLOT(sliderBrushGreenChanged(int)));
     connect(dialog_->sliderBrushBlue, SIGNAL(valueChanged (int)),
             this, SLOT(sliderBrushBlueChanged(int)));   
//      connect(dialog_->sliderBrushSaturation, SIGNAL(valueChanged (int)),
//              this, SLOT(sliderBrushSaturationChanged(int)));
	     
    /*QGroupBox* transGroup;
    QGroupBox* shadowBox;
    QGroupBox* effectBox;*/

};


kstyle_baghira_config::~kstyle_baghira_config()
{
}


void kstyle_baghira_config::load()
{
   //QSettings settings;
//    KConfig config("baghirarc");
   QSettings config;
   config.beginGroup("/baghira/BAB");
   // general Design
    dialog_->defaultStyle->setCurrentItem(config.readNumEntry("defaultState", 0 ));
    config.endGroup();
    config.beginGroup("/baghira/Style");
    dialog_->stippleBackground->setChecked( config.readBoolEntry( "Design_StippleBackground", true));
    dialog_->stippleContrast->setValue( config.readNumEntry( "Design_StippleContrast", 3));
    dialog_->shadowGroups->setChecked( config.readBoolEntry( "Design_ShadowGroupBoxes", true));
    dialog_->shadowIntensity->setValue( config.readNumEntry( "Design_GroupBoxeShadowDarkness", 6));
    dialog_->bevelHighlights->setChecked( config.readBoolEntry( "Design_BevelAsHighlight", true));
    dialog_->colorMode->setCurrentItem(config.readNumEntry("Design_ButtonStyle", 0));
    dialog_->inactiveColorType->setCurrentItem(config.readNumEntry( "Design_InactiveButtonStyle", 1));
    dialog_->customInactiveColor->setColor(QColor(config.readNumEntry("Design_InactiveButtonColor",(int)colorGroup().background().rgb())));
    dialog_->useRectButtons->setChecked( config.readBoolEntry( "Design_RectangularButtons", false));
    dialog_->centerTabs->setChecked( config.readBoolEntry( "Design_CenterTabs", true));
    // button color stuff
    QColor tmpColor = QColor(config.readNumEntry("Design_ButtonColor",(int)colorGroup().button().rgb()));
    dialog_->sliderButtonRed->setValue(sliderButtonRedValue = tmpColor.red());
    dialog_->sliderButtonGreen->setValue(sliderButtonGreenValue = tmpColor.green());
    dialog_->sliderButtonBlue->setValue(sliderButtonBlueValue = tmpColor.blue());
    dialog_->valueButtonRed->setNum(sliderButtonRedValue);
    dialog_->valueButtonGreen->setNum(sliderButtonGreenValue);
    dialog_->valueButtonBlue->setNum(sliderButtonBlueValue);
    
    // special Widgets
    //ListViews
    dialog_->useRectLVH->setChecked( config.readBoolEntry( "Special_UseFlatLVH", false));
    dialog_->drawTreeLines->setChecked( config.readBoolEntry( "Special_DrawTreeLines", false));
    dialog_->treeLineMode->setCurrentItem(config.readNumEntry( "Special_TreelineStyle", 0));
    dialog_->treeLineColor->setColor( QColor( config.readNumEntry( "Special_TreelineColor", (int) colorGroup().mid().rgb())));
    dialog_->expanderMode->setCurrentItem(config.readNumEntry( "Special_ExpanderStyle", 0));
    dialog_->useCustomExpanderColor->setChecked( config.readBoolEntry( "Special_CustomExpanderColor", false));
    dialog_->customExpanderColor->setColor( QColor( config.readNumEntry( "Special_ExpanderColor", (int) colorGroup().text().rgb())));
    //Kicker
    dialog_->stippleKicker->setChecked( config.readBoolEntry( "Special_StippleKicker", true));
    dialog_->removeKickerBevel->setChecked( config.readBoolEntry( "Special_RemoveKickerBevel", true));
    dialog_->roundTasks->setChecked( config.readBoolEntry( "Special_RoundTaskbuttons", false));
    dialog_->useCustomKickerColor->setChecked( config.readBoolEntry( "Special_CustomKickerColor", false));
    dialog_->customKickerColor->setColor( QColor( config.readNumEntry( "Special_KickerColor", (int) colorGroup().background().rgb())));
    //Scrollbars
    dialog_->animateSlider->setChecked( config.readBoolEntry( "Special_AnimateSlider", true));
    dialog_->shadowSlider->setChecked( config.readBoolEntry( "Special_ShadowSlider", false));
    dialog_->squeezeSlider->setChecked( config.readBoolEntry( "Special_SqueezeSlider", false));
    //Progress
    dialog_->progressType->setCurrentItem( config.readNumEntry( "Special_ProgressStyle", 0));
    dialog_->showProgressValue->setChecked( config.readBoolEntry( "Special_ShowProgressValue", false));
    //Toolbars
    dialog_->roundToolButtons->setChecked( config.readBoolEntry( "Special_RoundToolButtons", true));
    dialog_->unhoveredToolButtons->setChecked( config.readBoolEntry( "Special_UnhoveredToolButtons", false));
    
    // menus
    dialog_->menuBackground->setCurrentItem( config.readNumEntry( "Menu_Background", 0));
    dialog_->menuOpacity->setValue( config.readNumEntry( "Menu_Opacity", 70));
    //Look
    dialog_->shadowMenuText->setChecked( config.readBoolEntry( "Menu_ShadowText", true));
    dialog_->menuColorMode->setCurrentItem(config.readNumEntry("Menu_ColorStyle"));
    dialog_->menuTextColor->setColor( QColor( config.readNumEntry( "Menu_TextColor", (int) colorGroup().text().rgb())));
    dialog_->menuColor->setColor( QColor( config.readNumEntry( "Menu_Color1", (int) colorGroup().background().rgb())));
    dialog_->menuColor2->setColor( QColor( config.readNumEntry( "Menu_Color2", (int) colorGroup().background().dark(130).rgb())));

    // custom colors
    dialog_->useCustomColors->setChecked( config.readBoolEntry( "Colors_UseCustomColors", false));
    dialog_->radioOffColor->setColor( QColor( config.readNumEntry( "Colors_RadioOff", ( int ) colorGroup().background().rgb())));
    dialog_->radioOnColor->setColor( QColor( config.readNumEntry( "Colors_RadioOn", ( int ) colorGroup().button().rgb())));
    dialog_->checkOffColor->setColor( QColor( config.readNumEntry( "Colors_CheckOff", ( int ) colorGroup().background().rgb())));
    dialog_->checkOnColor->setColor( QColor( config.readNumEntry( "Colors_CheckOn", ( int ) colorGroup().button().rgb())));
    dialog_->sliderColor->setColor( QColor( config.readNumEntry( "Colors_Slider", ( int ) colorGroup().button().rgb())));
    dialog_->hoverSliderColorColor->setColor(QColor(config.readNumEntry("Colors_SliderHovered",(int)colorGroup().button().rgb())));
    dialog_->pressedSliderColor->setColor(QColor(config.readNumEntry("Colors_SliderPressed",(int) colorGroup().button().dark(110).rgb())));
    dialog_->sliderGrooveColor->setColor(QColor(config.readNumEntry("Colors_SliderGroove",(int)colorGroup().background().rgb())));
    dialog_->inactiveTabColor->setColor(QColor(config.readNumEntry("Colors_TabInactive",(int) colorGroup().background().rgb())));
    dialog_->activeTabColor->setColor(QColor(config.readNumEntry("Colors_TabActive",(int)colorGroup().button().rgb())));
    dialog_->tintBrush->setChecked( config.readBoolEntry( "Colors_TintBrushedMetal", false));
    brushTint = QColor(config.readNumEntry("Colors_BrushTint",(int)colorGroup().background().rgb()));
//    dialog_->brushTintSaturaion->setValue(settings.readNumEntry( "/qt/Baghira/brushTintSaturation", 3));
    baseImage2 = baghira_findImage("brush-me");
    dialog_->pixmapBrushPreview->setPixmap(*tintBrush(baseImage2, brushTint));
    dialog_->sliderBrushRed->setValue(sliderBrushRedValue = brushTint.red());
    dialog_->sliderBrushGreen->setValue(sliderBrushGreenValue = brushTint.green());
    dialog_->sliderBrushBlue->setValue(sliderBrushBlueValue = brushTint.blue());
    config.endGroup();


}


void kstyle_baghira_config::defaults()
{
    dialog_->defaultStyle->setCurrentItem(0);
    dialog_->stippleBackground->setChecked( true);
    dialog_->stippleContrast->setValue( 30);
    dialog_->shadowGroups->setChecked( true);
    dialog_->shadowIntensity->setValue( 50);
    dialog_->bevelHighlights->setChecked( true );
    dialog_->centerTabs->setChecked( true);
    dialog_->useRectButtons->setChecked( false);
    dialog_->colorMode->setCurrentItem(0);
    dialog_->inactiveColorType->setCurrentItem(1);
    dialog_->customInactiveColor->setColor(colorGroup().background().rgb());
    // button color stuff
    dialog_->sliderButtonRed->setValue(sliderButtonRedValue = colorGroup().button().red());
    dialog_->sliderButtonGreen->setValue(sliderButtonGreenValue = colorGroup().button().green());
    dialog_->sliderButtonBlue->setValue(sliderButtonBlueValue = colorGroup().button().blue());
    dialog_->valueButtonRed->setNum(sliderButtonRedValue);
    dialog_->valueButtonGreen->setNum(sliderButtonGreenValue);
    dialog_->valueButtonBlue->setNum(sliderButtonBlueValue);
    
    // special Widgets
//    dialog_->animateSlider;
    dialog_->shadowSlider->setChecked( false);
    dialog_->squeezeSlider->setChecked( false);
    dialog_->roundToolButtons->setChecked( true);
    dialog_->unhoveredToolButtons->setChecked( false);
    dialog_->drawTreeLines->setChecked( false);
    dialog_->useCustomExpanderColor->setChecked( false);
    dialog_->treeLineMode->setCurrentItem(0);
    dialog_->treeLineColor->setColor( colorGroup().mid().rgb());
    dialog_->expanderMode->setCurrentItem(0);
    dialog_->customExpanderColor->setColor( colorGroup().text().rgb());
    dialog_->useRectLVH->setChecked( false);
    dialog_->stippleKicker->setChecked( true);
    dialog_->removeKickerBevel->setChecked( true);
    dialog_->roundTasks->setChecked( false);
    dialog_->useCustomKickerColor->setChecked( false);
    dialog_->customKickerColor->setColor( colorGroup().background().rgb());
    dialog_->showProgressValue->setChecked( false);
    dialog_->progressType->setCurrentItem( 0);
    
    // menus
//    dialog_->transGroup;
    dialog_->menuBackground->setCurrentItem(0);
    dialog_->menuOpacity->setValue( 70);
    dialog_->shadowMenuText->setChecked( true);
    dialog_->menuColorMode->setCurrentItem(0);
    dialog_->menuTextColor->setColor( colorGroup().text().rgb());
    dialog_->menuColor->setColor( colorGroup().background().rgb());
    dialog_->menuColor2->setColor( colorGroup().background().dark(130).rgb());
    
    // custom colors
    dialog_->useCustomColors->setChecked( false);
    dialog_->radioOffColor->setColor( colorGroup().background().rgb());
    dialog_->radioOnColor->setColor( colorGroup().button().rgb());
    dialog_->checkOffColor->setColor( colorGroup().background().rgb());
    dialog_->checkOnColor->setColor( colorGroup().button().rgb());
    dialog_->sliderColor->setColor( colorGroup().button().rgb());
    dialog_->hoverSliderColorColor->setColor(colorGroup().button().rgb());
    dialog_->pressedSliderColor->setColor(colorGroup().button().dark(110).rgb());
    dialog_->sliderGrooveColor->setColor(colorGroup().background().rgb());
    dialog_->inactiveTabColor->setColor(colorGroup().background().rgb());
    dialog_->activeTabColor->setColor(colorGroup().button().rgb());
    dialog_->tintBrush->setChecked( false);
    emit changed(true);
}


void kstyle_baghira_config::save()
{
    QSettings *config = new QSettings;
//     KConfig *config = new KConfig("baghirarc");
    config->beginGroup("/baghira/BAB");
    //General Design
    config->writeEntry("defaultState", dialog_->defaultStyle->currentItem());
    config->endGroup();
    config->beginGroup("/baghira/Style");
    config->writeEntry("Design_Default", dialog_->defaultStyle->currentItem());
    config->writeEntry("Design_StippleBackground", dialog_->stippleBackground->isOn());
    config->writeEntry("Design_StippleContrast", dialog_->stippleContrast->value());
    config->writeEntry("Design_ShadowGroupBoxes", dialog_->shadowGroups->isOn());
    config->writeEntry("Design_GroupBoxeShadowDarkness", dialog_->shadowIntensity->value());
    config->writeEntry("Design_BevelAsHighlight", dialog_->bevelHighlights->isOn());
    config->writeEntry("Design_ButtonStyle", dialog_->colorMode->currentItem());
    config->writeEntry("Design_InactiveButtonStyle", dialog_->inactiveColorType->currentItem());
    config->writeEntry("Design_InactiveButtonColor", (int)dialog_->customInactiveColor->color().rgb());
    config->writeEntry("Design_CenterTabs", dialog_->centerTabs->isOn());
    config->writeEntry("Design_RectangularButtons", dialog_->useRectButtons->isOn());
    //button color stuff
    config->writeEntry("Design_ButtonColor", (int)(QColor(sliderButtonRedValue, sliderButtonGreenValue, sliderButtonBlueValue).rgb()));
    
    // special Widgets
    //listviews
//    dialog_->animateSlider;
    config->writeEntry("Special_UseFlatLVH", dialog_->useRectLVH->isOn());
    config->writeEntry("Special_DrawTreeLines", dialog_->drawTreeLines->isOn());
    config->writeEntry("Special_TreelineStyle", dialog_->treeLineMode->currentItem());
    config->writeEntry("Special_TreelineColo", (int)dialog_->treeLineColor->color().rgb());
    config->writeEntry("Special_ExpanderStyle", dialog_->expanderMode->currentItem());
    config->writeEntry("Special_CustomExpanderColor", dialog_->useCustomExpanderColor->isOn());
    config->writeEntry("Special_ExpanderColor", (int)dialog_->customExpanderColor->color().rgb());
    //Kicker
    config->writeEntry("Special_StippleKicker", dialog_->stippleKicker->isOn());
    config->writeEntry("Special_RemoveKickerBevel", dialog_->removeKickerBevel->isOn());
    config->writeEntry("Special_RoundTaskbuttons", dialog_->roundTasks->isOn());
    config->writeEntry("Special_CustomKickerColor", dialog_->useCustomKickerColor->isOn());
    config->writeEntry("Special_KickerColor", (int)dialog_->customKickerColor->color().rgb());
    //Srollbars
    config->writeEntry("Special_AnimateSlider", dialog_->animateSlider->isOn());
    config->writeEntry("Special_ShadowSlider", dialog_->shadowSlider->isOn());
    config->writeEntry("Special_SqueezeSlider", dialog_->squeezeSlider->isOn());
    //Progress
    config->writeEntry("Special_ProgressStyle", dialog_->progressType->currentItem());
    config->writeEntry("Special_ShowProgressValue", dialog_->showProgressValue->isOn());
    //Toolbars
    config->writeEntry("Special_RoundToolButtons", dialog_->roundToolButtons->isOn());
    config->writeEntry("Special_UnhoveredToolButtons", dialog_->unhoveredToolButtons->isOn());

    // menus
    config->writeEntry("Menu_Background", dialog_->menuBackground->currentItem());
    config->writeEntry("Menu_Opacity", dialog_->menuOpacity->value());
    //Look
    config->writeEntry("Menu_ShadowText", dialog_->shadowMenuText->isOn());
    config->writeEntry("Menu_ColorStyle", dialog_->menuColorMode->currentItem());
    config->writeEntry("Menu_TextColor", (int)dialog_->menuTextColor->color().rgb());
    config->writeEntry("Menu_Color1", (int)dialog_->menuColor->color().rgb());
    config->writeEntry("Menu_Color2", (int)dialog_->menuColor2->color().rgb());
    
    // custom colors
    config->writeEntry("Colors_UseCustomColors", dialog_->useCustomColors->isOn());
    config->writeEntry("Colors_RadioOff", (int)dialog_->radioOffColor->color().rgb());
    config->writeEntry("Colors_RadioOn", (int)dialog_->radioOnColor->color().rgb());
    config->writeEntry("Colors_CheckOff",(int) dialog_->checkOffColor->color().rgb());
    config->writeEntry("Colors_CheckOn", (int)dialog_->checkOnColor->color().rgb());
    config->writeEntry("Colors_Slider",(int) dialog_->sliderColor->color().rgb());
    config->writeEntry("Colors_SliderHovered", (int)dialog_->hoverSliderColorColor->color().rgb());
    config->writeEntry("Colors_SliderPressed", (int)dialog_->pressedSliderColor->color().rgb());
    config->writeEntry("Colors_SliderGroove",(int) dialog_->sliderGrooveColor->color().rgb());
    config->writeEntry("Colors_TabInactive",(int) dialog_->inactiveTabColor->color().rgb());
    config->writeEntry("Colors_TabActive", (int)dialog_->activeTabColor->color().rgb());
    config->writeEntry("Colors_TintBrushedMetal", dialog_->tintBrush->isOn());
    config->writeEntry("Colors_BrushTint",(int)qRgb(sliderBrushRedValue, sliderBrushGreenValue, sliderBrushBlueValue));
    config->endGroup();
    delete config;
    emit changed(true);
}


void kstyle_baghira_config::configChanged()
{
   dialog_->statusWarning->setText("Config changed");
   emit changed(true);
}


QString kstyle_baghira_config::quickHelp() const
{
    return i18n("Configure Your Cat");
}


//////////////////////////////////////////////////////////////////////////////
// Plugin Stuff                                                             //
//////////////////////////////////////////////////////////////////////////////
    
extern "C"
{   
    QWidget* allocate_kstyle_config(QWidget* parent){
         return(new kstyle_baghira_config(parent, "BaghiraConfig"));
    }
}   

#include "kstyle_baghira_config.moc"
