//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_43.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot43(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[43] = {1.426258777782621e-02,1.283915237081303e-01,3.568002033807567e-01,6.997913412113433e-01,1.157821775192210e+00,
    1.731505841456103e+00,2.421619967150520e+00,3.229108565674753e+00,4.155091344523005e+00,5.200872166021917e+00,6.367949636363226e+00,7.658029640022649e+00,
    9.073040086841704e+00,1.061514820019272e+01,1.228678074995874e+01,1.409064772776473e+01,1.602977007962204e+01,1.810751226047194e+01,2.032762056634084e+01,
    2.269426844714387e+01,2.521211032635819e+01,2.788634588071833e+01,3.072279730365451e+01,3.372800284827631e+01,3.690933100466788e+01,4.027512114018172e+01,
    4.383485851612566e+01,4.759939459548447e+01,5.158122796253278e+01,5.579486778684822e+01,6.025731193114589e+01,6.498868787506589e+01,7.001313085081209e+01,
    7.536001795590981e+01,8.106575532568164e+01,8.717646077656829e+01,9.375217070623445e+01,1.008738075119675e+02,1.086555578806382e+02,1.172690294356232e+02,
    1.269971077732338e+02,1.383816515706110e+02,1.528192203308403e+02};
  constexpr double aw[43] = {2.354761530400102e-01,2.101477122383245e-01,1.673459142985755e-01,1.188742415350856e-01,7.529144666132209e-02,
    4.249363723989420e-02,2.135442231953533e-02,9.546194547879545e-03,3.792002394490030e-03,1.336721046210252e-03,4.175427354854966e-04,1.153755734390231e-04,
    2.814808395266499e-05,6.050232141409069e-06,1.142978302485967e-06,1.892689346408208e-07,2.739018738039680e-08,3.452519916383315e-09,3.776504323563274e-10,
    3.569931854671538e-11,2.902972807299139e-12,2.020235351444652e-13,1.196279387759704e-14,5.988574617048902e-16,2.515979389219083e-17,8.798325007697671e-19,
    2.537044116717297e-20,5.968046428770866e-22,1.131225287180773e-23,1.703162410675256e-25,2.002938790748378e-27,1.803696413432014e-29,1.214548767136704e-31,
    5.941043927414663e-34,2.036854118874406e-36,4.677768845419749e-39,6.784808497979015e-42,5.742116416618364e-45,2.536583356400502e-48,4.949857686869416e-52,
    3.245015342920119e-56,4.247738285372129e-61,2.962904515147007e-67};
  constexpr double x[16512] = {  6.519167249251522e-04, -3.745441272445724e-06,  1.613362694299856e-08, -6.174815797865894e-11,  2.214372019354118e-13,
 -7.618466983648579e-16,  2.546351098509868e-18, -8.329827645687222e-21,  2.679688543462093e-23, -8.504694593369975e-26,  2.668918370633010e-28, -8.295032354066725e-31,
  5.862266484323309e-03, -3.359356520099631e-05,  1.439582174692016e-07, -5.462155160075992e-10,  1.933332287158811e-12, -6.529626097981379e-15,  2.128520887633950e-17,
 -6.738594435506514e-20,  2.078695511794800e-22, -6.256954021027813e-25,  1.837708746703487e-27, -5.259365963700324e-30,  1.625640978688441e-02, -9.267687084262684e-05,
  3.930341209289746e-07, -1.465290632378416e-09,  5.048531656020530e-12, -1.639864292823422e-14,  5.061408778229682e-17, -1.486053351804337e-19,  4.131220777652662e-22,
 -1.074250558503020e-24,  2.543872838103860e-27, -5.135462580985856e-30,  3.178135572275895e-02, -1.797817012992931e-04,  7.505173709710837e-07, -2.723510002900043e-09,
  8.993176635306317e-12, -2.739180471102167e-14,  7.674114314145346e-17, -1.938682955619013e-19,  4.178339398191400e-22, -6.331903672221691e-25, -1.872809589480159e-28,
  6.872969981399987e-30,  5.235792144239057e-02, -2.931179129150071e-04,  1.197885089875326e-06, -4.187973514258042e-09,  1.300916171243560e-11, -3.586482739216862e-14,
  8.456364433682867e-17, -1.494172498288397e-19,  6.479039230107076e-23,  1.011428801124887e-24, -6.239226582828495e-27,  2.526949668276753e-29,  7.788109555497377e-02,
 -4.303546527933732e-04,  1.711790215244667e-06, -5.699761991421679e-09,  1.626230661340549e-11, -3.831231912307144e-14,  6.264087262855082e-17,  8.158366439113203e-21,
 -6.208034877779582e-22,  3.275765365658597e-24, -1.176697982635459e-26,  3.169440631823005e-29,  1.082205212812591e-01, -5.886670183961422e-04,  2.265141199325805e-06,
 -7.087678080635102e-09,  1.796353036189026e-11, -3.217889439332152e-14,  7.420619947849732e-18,  2.555757886635283e-19, -1.397550316864465e-21,  4.803284498780522e-24,
 -1.115064803278217e-26,  8.934708782888628e-30,  1.432210981551128e-01, -7.647927253575498e-04,  2.828358567163022e-06, -8.183190651712399e-09,  1.748705401425590e-11,
 -1.651380050823492e-14, -7.450973887706048e-17,  5.231760835403053e-19, -1.881844299345942e-21,  4.139090245528110e-24, -1.049254283982121e-27, -4.068125400146174e-29,
  1.827037007372821e-01, -9.550977169988545e-04,  3.370752120967048e-06, -8.835358202313589e-09,  1.446985333196828e-11,  7.666039565523027e-15, -1.668928757713437e-16,
  7.133339844141283e-19, -1.707880346984230e-21,  6.361240391065601e-25,  1.605494516290138e-26, -8.834917775741808e-29,  2.264660124549310e-01, -1.155649473322399e-03,
  3.861956877357423e-06, -8.924499109136160e-09,  8.878789540067619e-12,  3.738745308230356e-14, -2.470442792694344e-16,  7.320246730267335e-19, -7.099143638926523e-22,
 -4.904301687747895e-24,  3.155033592267501e-26, -9.291543112096815e-29,  2.742834723087156e-01, -1.362296621612613e-03,  4.273362788045857e-06, -8.373467453593437e-09,
  1.035809813680723e-12,  6.812099309014028e-14, -2.911899557945593e-16,  5.236045404593818e-19,  9.540007294607645e-22, -1.027687617881318e-23,  3.461333123586309e-26,
 -3.022089620962697e-29,  3.259103317928961e-01, -1.570753318108090e-03,  4.579473084185625e-06, -7.155576392655096e-09, -8.403147479541068e-12,  9.451049827526435e-14,
 -2.806370240613530e-16,  9.696123618967596e-20,  2.800551300399934e-21, -1.270301334358143e-23,  1.866033607713349e-26,  8.191638641557798e-29,  3.810808189512425e-01,
 -1.776686763253864e-03,  4.759128747011203e-06, -5.298473221330412e-09, -1.851402686540264e-11,  1.113093213789613e-13, -2.072306872532304e-16, -4.668226352847825e-19,
  4.159612753142060e-21, -1.013918322248913e-23, -1.333071365047578e-26,  1.836404294094602e-28,  4.395104060408657e-01, -1.975806134251366e-03,  4.796542070596983e-06,
 -2.883591583452340e-09, -2.820800656926843e-11,  1.143573996043288e-13, -7.664784325171113e-17, -1.029733746836444e-18,  4.412540431416278e-21, -2.458714949484815e-24,
 -4.821673133849652e-26,  2.039124353234915e-28,  5.008971767969087e-01, -2.163951170132516e-03,  4.682090355183340e-06, -4.116195967728115e-11, -3.636006317995152e-11,
  1.014198361356695e-13,  9.145522200065901e-17, -1.432232332446892e-18,  3.244274024905571e-21,  8.113161124995057e-24, -6.805265992951460e-26,  1.066595277932728e-28,
  5.649232887833644e-01, -2.337178628155041e-03,  4.412831144747749e-06,  3.058876340306248e-09, -4.194699550511393e-11,  7.272676627993605e-14,  2.666894858726134e-16,
 -1.539237033358329e-18,  8.089397930528675e-22,  1.763330258063786e-23, -5.924374863338487e-26, -7.724892682240569e-29,  6.312565257801178e-01, -2.491844847272745e-03,
  3.992712686878253e-06,  6.219378926594458e-09, -4.417759952029356e-11,  3.110333229541319e-14,  4.139947156649446e-16, -1.283042681081225e-18, -2.265892930684109e-21,
  2.197558255872293e-23, -2.075321639697295e-26, -2.566711664739014e-28,  6.995519345955740e-01, -2.624682705601665e-03,  3.432466939901195e-06,  9.230943910975903e-09,
 -4.259830640137570e-11, -1.835060032169546e-14,  5.012168502164421e-16, -6.895751118733646e-19, -5.053566073683070e-21,  1.864350945490819e-23,  3.342925174289954e-26,
 -3.272143412708522e-28,  7.694535401108847e-01, -2.732871344443969e-03,  2.749186899833429e-06,  1.188811701368776e-08, -3.716035440861771e-11, -6.899115192441441e-14,
  5.064729377897006e-16,  1.212347867020600e-19, -6.629987648854207e-21,  8.044344727277048e-24,  7.963167709623895e-26, -2.334572483006181e-28,  8.405961317598717e-01,
 -2.814097151188518e-03,  1.965604633297189e-06,  1.400554714779215e-08, -2.823915562842177e-11, -1.136565396422716e-13,  4.235523798133156e-16,  9.626649854323615e-19,
 -6.398409679640234e-21, -6.408434874942716e-24,  9.555600132110960e-26, -8.228957993745844e-30,  9.126071140334189e-01, -2.866604646249197e-03,  1.109100520021250e-06,
  1.543277011010633e-08, -1.660239246113040e-11, -1.458172466870104e-13,  2.640059576548836e-16,  1.629312981177716e-18, -4.317806631151942e-21, -1.950086414215085e-23,
  7.160036252842949e-26,  2.382029716932518e-28,  9.851084129746932e-01, -2.889236103381069e-03,  2.104871691058897e-07,  1.606639152295308e-08, -3.329811197600104e-12,
 -1.606522209443234e-13,  5.531733558046575e-17,  1.952741395776034e-18, -9.454429123143640e-22, -2.627685426423908e-23,  1.645073866002094e-26,  3.764690537602522e-28,
  1.057718430009482e+00, -2.881458945733475e-03, -6.973773527095039e-07,  1.585863707392779e-08,  1.030614325285481e-11, -1.558616244881327e-13, -1.645364091550326e-16,
  1.848515754087725e-18,  2.729943781441442e-21, -2.408187211256067e-23, -4.632269971346279e-26,  3.312067346576632e-28,  1.130054033842764e+00, -2.843380198599124e-03,
 -1.581083522729591e-06,  1.482152422441064e-08,  2.298458754780367e-11, -1.320697052494117e-13, -3.549666267396302e-16,  1.340600942682599e-18,  5.610579619395865e-21,
 -1.369558680964578e-23, -8.926845675407558e-26,  1.252367977224439e-28,  1.201732580557947e+00, -2.775747539981800e-03, -2.408202146800121e-06,  1.302626290893067e-08,
  3.348771175651867e-11, -9.274179313538581e-14, -4.813285348799235e-16,  5.555631606940391e-19,  6.854726580792650e-21,  9.609956804440600e-25, -9.417868190911042e-26,
 -1.325802292138433e-28,  1.272373951489427e+00, -2.679936767086402e-03, -3.148781679323451e-06,  1.059788509140458e-08,  4.084073463945405e-11, -4.362488397835013e-14,
 -5.221958675997128e-16, -3.120429924140899e-19,  6.153691719730636e-21,  1.443179850117300e-23, -6.063361117051818e-26, -3.091461629636145e-28,  1.341602597913687e+00,
 -2.557925785211818e-03, -3.776739437395169e-06,  7.705502082246671e-09,  4.442273920782590e-11,  8.193658949983877e-15, -4.736827899141106e-16, -1.053079272583218e-18,
  3.821566983373531e-21,  2.194853798575597e-23, -5.631114869550880e-27, -3.215544585458073e-28,  1.409049581130658e+00, -2.412255519284092e-03, -4.271079138443893e-06,
  4.548960510825616e-09,  4.403436428919091e-11,  5.544577686096293e-14, -3.498301047809857e-16, -1.500349645121568e-18,  6.677234645466093e-22,  2.130299522935173e-23,
  4.532977625577506e-26, -1.798488851730557e-28,  1.474354596097985e+00, -2.245978440904951e-03, -4.616874616725895e-06,  1.342980462335500e-09,  3.991373884219646e-11,
  9.185737718737603e-14, -1.790043879913708e-16, -1.571724041608828e-18, -2.297394634177335e-21,  1.357246639345607e-23,  7.088079292453348e-26,  2.577300238948410e-29,
  1.537167966448312e+00, -2.062595688463628e-03, -4.805970074867184e-06, -1.699915535213580e-09,  3.269864939893064e-11,  1.131316507993184e-13,  2.794219284680663e-18,
 -1.287575415469672e-18, -4.211951230827953e-21,  2.433188947833763e-24,  6.352514816561738e-26,  1.824903951872609e-28,  1.597152598476015e+00, -1.865984027540737e-03,
 -4.837360358152823e-06, -4.386257449735116e-09,  2.333987385815171e-11,  1.175696984373561e-13,  1.600914879666189e-16, -7.582472510176091e-19, -4.639239297347854e-21,
 -7.564291373644768e-24,  3.171234699280284e-26,  2.197669770947699e-28,  1.653985881536719e+00, -1.660314146499675e-03, -4.717229909235252e-06, -6.556845732999341e-09,
  1.297697993685580e-11,  1.062239098835379e-13,  2.656141388233348e-16, -1.464917288956925e-19, -3.674540357426754e-21, -1.293762362462036e-23, -6.203187249824285e-27,
  1.425028573250004e-28,  1.707361522271895e+00, -1.449962001000414e-03, -4.458645553977105e-06, -8.099038640716774e-09,  2.792815953462886e-12,  8.256586221457318e-14,
  3.056842088406059e-16,  3.826769277143303e-19, -1.854048982948837e-21, -1.256368494883951e-23, -3.224159285625678e-26,  1.615070510902239e-29,  1.756991300162887e+00,
 -1.239415104792622e-03, -4.080915279586651e-06, -8.955056255301455e-09, -6.134265361006507e-12,  5.174019304094290e-14,  2.821354329422427e-16,  7.088626112521784e-19,
  8.580250820511827e-23, -7.805621286797542e-24, -3.751042799470571e-26, -8.123094711708901e-29,  1.802606732146350e+00, -1.033175806793322e-03, -3.608641837713024e-06,
 -9.125584385346979e-09, -1.296111852293616e-11,  1.955194458208922e-14,  2.104436251098056e-16,  7.857731178262971e-19,  1.495923939615736e-21, -1.538655138216012e-24,
 -2.495939453257056e-26, -1.062001366802135e-28,  1.843960634404301e+00, -8.356636911948441e-04, -3.070515475103770e-06, -8.668363943240695e-09, -1.717642137224760e-11,
 -8.617316155636220e-15,  1.147146755140966e-16,  6.453801604110198e-19,  2.035238789240478e-21,  3.356173622181584e-24, -5.516226039438746e-27, -6.749131256992446e-29,
  1.880828570015687e+00, -6.511192841807970e-04, -2.497903540355077e-06, -7.691885801075605e-09, -1.865077158394300e-11, -2.875898236540114e-14,  2.094336797057504e-17,
  3.773646160650010e-19,  1.745592250665746e-21,  5.265655562188073e-24,  9.312679373483692e-27, -8.049157554693026e-30,  1.913010172036985e+00, -4.835112445431456e-04,
 -1.923305400208489e-06, -6.344739283677571e-09, -1.763414738161842e-11, -3.887611975675151e-14, -4.965318189934409e-17,  9.246601880780051e-20,  9.668544154818957e-22,
  4.313144002645926e-24,  1.370203381626937e-26,  3.033366240237865e-29,  1.940330333180019e+00, -3.364491525168791e-04, -1.378748408974701e-06, -4.801546014314872e-09,
 -1.470177563503097e-11, -3.919817401054931e-14, -8.550954905452300e-17, -1.168301950804179e-19,  1.447001568517244e-22,  1.908984354217412e-24,  9.259079781233250e-27,
  3.311537543937177e-29,  1.962640257390960e+00, -2.131038812234010e-04, -8.942041288350414e-07, -3.246714699961458e-09, -1.065648362562196e-11, -3.194315476846532e-14,
 -8.660975859406347e-17, -2.047499533052187e-19, -3.761836834076436e-22, -2.558558086610333e-25,  2.053044049913282e-27,  1.418232660161141e-29,  1.979818385534615e+00,
 -1.161372805542328e-04, -4.961030991526537e-07, -1.857447435981741e-09, -6.401543117575870e-12, -2.068839799545495e-14, -6.306079956896741e-17, -1.808580316921788e-19,
 -4.825809917751198e-22, -1.166223995120112e-24, -2.383899259442250e-27, -3.177007629810310e-30,  1.991771321241644e+00, -4.764203775029374e-05, -2.060190388574399e-07,
 -7.874872024480720e-10, -2.801989165687233e-12, -9.487736312465302e-15, -3.090442433317889e-17, -9.735806003797167e-20, -2.972785967818021e-22, -8.796876757944593e-25,
 -2.516692157465147e-27, -6.924931191856891e-30,  1.998436486796352e+00, -9.083005476387360e-06, -3.954428366415482e-08, -1.528748687129906e-10, -5.533460161402358e-13,
 -1.919775279105339e-15, -6.463580739410531e-18, -2.127270889114099e-20, -6.875232370434128e-23, -2.188653218031252e-25, -6.876669552438548e-28, -2.135463447450624e-30,
  6.371884885382986e-04, -3.619277074386823e-06,  1.541341474305007e-08, -5.832381536977981e-11,  2.067929892206636e-13, -7.034389536177935e-16,  2.324674941644672e-18,
 -7.519323234718859e-21,  2.391887987090734e-23, -7.506652508478607e-26,  2.329553702408100e-28, -7.160227099023741e-31,  5.730154772157179e-03, -3.246760168746325e-05,
  1.375850098113143e-07, -5.162998119290430e-10,  1.807699182165030e-12, -6.040691422848787e-15,  1.948824031513017e-17, -6.108077272861304e-20,  1.866137251419810e-22,
 -5.566158027198523e-25,  1.621041435662957e-27, -4.604207629149226e-30,  1.589188139366570e-02, -8.960158312898958e-05,  3.759246792671770e-07, -1.387073296277681e-09,
  4.732376712934045e-12, -1.523237740722281e-14,  4.663254072788249e-17, -1.359849943956579e-19,  3.762270878763554e-22, -9.769160488368032e-25,  2.325315935596258e-27,
 -4.797440620245490e-30,  3.107403360803169e-02, -1.739058856620645e-04,  7.186808364786966e-07, -2.583903613751952e-09,  8.463326441104813e-12, -2.561366723546784e-14,
  7.149658661140365e-17, -1.808632120545055e-19,  3.949724965809502e-22, -6.351367585058003e-25,  7.813128897545796e-29,  5.247661376282279e-30,  5.120430259072033e-02,
 -2.837323702378610e-04,  1.148854969763790e-06, -3.985456446072439e-09,  1.231182290838072e-11, -3.388523786727697e-14,  8.041413014743076e-17, -1.468074336450140e-19,
  9.696734453272053e-23,  7.829839348102369e-25, -5.209651186695570e-27,  2.161176147270633e-29,  7.618663857394949e-02, -4.169295540034105e-04,  1.644929231364893e-06,
 -5.445613334324198e-09,  1.551110139275531e-11, -3.680833601030379e-14,  6.260828328675886e-17, -9.908663671803067e-21, -5.110190770629039e-22,  2.832207314222436e-24,
 -1.043004870481033e-26,  2.906988227763495e-29,  1.059015636369322e-01, -5.708812601064825e-04,  2.181792360980900e-06, -6.805398197280761e-09,  1.732228761814800e-11,
 -3.191982287261017e-14,  1.397602587495067e-17,  2.135356146456976e-19, -1.232557027773179e-21,  4.366067780950170e-24, -1.068883228313252e-26,  1.187086459769938e-29,
  1.402065657494372e-01, -7.425539192008230e-04,  2.731827836008355e-06, -7.906132296294319e-09,  1.714004764514546e-11, -1.813291451632658e-14, -6.068155113547052e-17,
  4.653297673799735e-19, -1.733995619545641e-21,  4.064400912945828e-24, -2.612184415265687e-27, -3.065153901253174e-29,  1.789365759860446e-01, -9.285518511529943e-04,
  3.266121301378213e-06, -8.602824930836922e-09,  1.458470586303867e-11,  3.894140477515246e-15, -1.476803712050109e-16,  6.591647788237172e-19, -1.674324138535744e-21,
  1.204192370389427e-24,  1.243663164327736e-26, -7.624802163729810e-29,  2.219045310915320e-01, -1.125179724459650e-03,  3.755738902973492e-06, -8.776771709056678e-09,
  9.568894278575876e-12,  3.170162899418138e-14, -2.268904816315494e-16,  7.067181681802874e-19, -8.647288722537864e-22, -3.722996425700712e-24,  2.754439914952606e-26,
 -8.887911399821677e-29,  2.689020237745358e-01, -1.328511262903816e-03,  4.173024359973955e-06, -8.346369806888477e-09,  2.329548033486281e-12,  6.131148257798233e-14,
 -2.761553659189271e-16,  5.484774578935753e-19,  6.085982851187373e-22, -8.922835755468267e-24,  3.299970835261015e-26, -4.244778952989567e-29,  3.197000432256067e-01,
 -1.534463145473862e-03,  4.492860659782839e-06, -7.275269923379048e-09, -6.580019928837408e-12,  8.781749822950186e-14, -2.767351456884138e-16,  1.794125603840530e-19,
  2.357472736295089e-21, -1.189260618818984e-23,  2.166648372786658e-26,  5.534548070778661e-29,  3.740498083856548e-01, -1.738872928394175e-03,  4.693842299084791e-06,
 -5.577162566468491e-09, -1.633855826502866e-11,  1.061936330727318e-13, -2.184937322532525e-16, -3.396427698454844e-19,  3.786880616143519e-21, -1.051858367954285e-23,
 -5.832258241233406e-27,  1.571660364293305e-28,  4.316836964204512e-01, -1.937579709534003e-03,  4.759306128991215e-06, -3.316731970589218e-09, -2.594150742827866e-11,
  1.121877219117039e-13, -1.035194292225362e-16, -8.903034409135010e-19,  4.291459597849499e-21, -4.209488660554939e-24, -3.937059259799086e-26,  1.972571566725091e-28,
  4.923162686756283e-01, -2.126506158136163e-03,  4.678173132260670e-06, -6.065899596839649e-10, -3.431290380032169e-11,  1.031455140242244e-13,  5.284636980675001e-17,
 -1.324258089841005e-18,  3.488553241578994e-21,  5.492737720364099e-24, -6.279003892461396e-26,  1.311720297114384e-28,  5.556453960845179e-01, -2.301740449783935e-03,
  4.445559835529187e-06,  2.399693864358674e-09, -4.043192814601914e-11,  7.861362547794178e-14,  2.240453904146133e-16, -1.503657315173217e-18,  1.400396365735009e-21,
  1.521003437846083e-23, -6.157111892856461e-26, -2.941255839511668e-29,  6.213534855692917e-01, -2.459616581173092e-03,  4.063126427647379e-06,  5.518041363871123e-09,
 -4.345912334902966e-11,  4.060063439680609e-14,  3.771720660396464e-16, -1.343074844486365e-18, -1.492317126466333e-21,  2.093268320406101e-23, -3.106241284794862e-26,
 -2.114897476159007e-28,  6.891088084067264e-01, -2.596791495194573e-03,  3.539138816450986e-06,  8.547081613782458e-09, -4.284668209814578e-11, -6.570738158893109e-15,
  4.797473258001214e-16, -8.403204842007622e-19, -4.361773980768612e-21,  1.969578886305951e-23,  1.927932912703217e-26, -3.142522370198686e-28,  7.585669308179749e-01,
 -2.710317427816765e-03,  2.888233517279031e-06,  1.128317392602619e-08, -3.841847166883411e-11, -5.681875150794590e-14,  5.069450767089149e-16, -8.569725586174865e-20,
 -6.285629089563712e-21,  1.101367590952036e-23,  6.859662574292921e-26, -2.661640215704004e-28,  8.293722461838038e-01, -2.797707898035181e-03,  2.130887039932819e-06,
  1.353609666954230e-08, -3.040857090806050e-11, -1.031911505760592e-13,  4.476110789976588e-16,  7.549604387829803e-19, -6.560576725659955e-21, -2.612746050096050e-24,
  9.375969957861165e-26, -7.254708634871422e-29,  9.011596072826443e-01, -2.856995804304209e-03,  1.292604849132364e-06,  1.514416055707801e-08, -1.945176405347353e-11,
 -1.389498961562129e-13,  3.075908596477950e-16,  1.480482895789414e-18, -4.965916933173653e-21, -1.644460027959508e-23,  8.077226988641812e-26,  1.777602087264971e-28,
  9.735560558017383e-01, -2.886782168574487e-03,  4.028584593232769e-07,  1.598750083969430e-08, -6.525171996928379e-12, -1.586727712386207e-13,  1.094294176221374e-16,
  1.907510866752254e-18, -1.875618003543442e-21, -2.529266263047823e-23,  3.260731464010707e-26,  3.556813509347975e-28,  1.046182645088886e+00, -2.886274184920206e-03,
 -5.061878332555594e-07,  1.599840071566830e-08,  7.153662032258976e-12, -1.591803386648848e-13, -1.116876656673426e-16,  1.921674327614340e-18,  1.833252056671837e-21,
 -2.563296074807033e-23, -3.099783041181410e-26,  3.632954292185681e-28,  1.118656350705550e+00, -2.855311385498781e-03, -1.401107341279413e-06,  1.516769671730321e-08,
  2.026114476382488e-11, -1.401186544384389e-13, -3.149952262444051e-16,  1.511573648688601e-18,  5.054774063833490e-21, -1.713629541387573e-23, -8.228198688155388e-26,
  1.917758765012430e-28,  1.190592061827976e+00, -2.794378932896246e-03, -2.248735398754340e-06,  1.354660569277828e-08,  3.151874520394638e-11, -1.040822163499309e-13,
 -4.627018924971428e-16,  7.747305258196910e-19,  6.820268438653042e-21, -2.905075246628579e-24, -9.867135860944419e-26, -7.034944405426340e-29,  1.261604644943308e+00,
 -2.704607284103749e-03, -3.017717353020048e-06,  1.124367335645170e-08,  3.984231921242820e-11, -5.623971682572540e-14, -5.281016023597843e-16, -1.073065048476168e-19,
  6.626354047335507e-21,  1.174029819142607e-23, -7.377200186371607e-26, -2.858836870103642e-28,  1.331311069629637e+00, -2.587757745233377e-03, -3.680005449239301e-06,
  8.416949445276347e-09,  4.447061464117248e-11, -3.514016009897152e-15, -5.013386347289904e-16, -9.182184138263409e-19,  4.604175470996738e-21,  2.143225016588237e-23,
 -2.036629909095500e-26, -3.466475681963870e-28,  1.399332584524795e+00, -2.446193743696921e-03, -4.212229235714334e-06,  5.261911254599343e-09,  4.505593333800921e-11,
  4.654887208700985e-14, -3.914230622674285e-16, -1.466378447024998e-18,  1.465217786899570e-21,  2.294212295893452e-23,  3.623595253394242e-26, -2.334482747925834e-28,
  1.465296929915969e+00, -2.282837980207785e-03, -4.596867303725078e-06,  1.996048936140782e-09,  4.170431971620736e-11,  8.702533629700250e-14, -2.239645295652036e-16,
 -1.636874313331822e-18, -1.757601014972991e-21,  1.641680031645625e-23,  7.098613059103617e-26, -2.223852143708743e-29,  1.528840571762631e+00, -2.101115979053802e-03,
 -4.823155346404561e-06, -1.158644967559774e-09,  3.495895450211338e-11,  1.127509551624662e-13, -3.512809186515348e-17, -1.420450460473003e-18, -4.076720823522419e-21,
  5.130526310920064e-24,  7.121999134664055e-26,  1.657601109031643e-28,  1.589610940444340e+00, -1.904886922292696e-03, -4.887676567888769e-06, -3.993807080411286e-09,
  2.572788234680039e-11,  1.211401051916536e-13,  1.367431044136238e-16, -9.107958770270737e-19, -4.886340638674042e-21, -6.096988429846916e-24,  4.177887941560888e-26,
  2.370506553736614e-28,  1.647268656150755e+00, -1.698363020927486e-03, -4.794595042620723e-06, -6.331873506769172e-09,  1.516480278334346e-11,  1.125357091015175e-13,
  2.597958903576793e-16, -2.715641388379527e-19, -4.143162069035229e-21, -1.305066371892562e-23,  7.942293791187626e-28,  1.758583512893848e-28,  1.701489721653280e+00,
 -1.486019031533601e-03, -4.555510113003037e-06, -8.040740918270540e-09,  4.518328864965796e-12,  9.002373165828662e-14,  3.154987897885528e-16,  3.158635930019413e-19,
 -2.329318430065884e-21, -1.383182675564077e-23, -3.097541851528482e-26,  4.225292044636718e-29,  1.751967662266149e+00, -1.272493857180889e-03, -4.188929485412542e-06,
 -9.044551415060627e-09, -5.030140832471045e-12,  5.874966135983513e-14,  3.019776768963005e-16,  7.068157656072397e-19, -2.230557104970095e-22, -9.376035336304610e-24,
 -4.096635622614296e-26, -7.518714503104119e-29,  1.798415592169764e+00, -1.062486463430395e-03, -3.719379303845860e-06, -9.329551974939689e-09, -1.251776331502933e-11,
  2.487196231257508e-14,  2.331056914781597e-16,  8.325543987309298e-19,  1.421406088515278e-21, -2.633703006963037e-24, -2.987148779095227e-26, -1.169672107461231e-28,
  1.840568185984507e+00, -8.606485805469750e-04, -3.176189964638816e-06, -8.944409590007455e-09, -1.731973394876830e-11, -5.639846817144314e-15,  1.337149321070422e-16,
  7.123923124887675e-19,  2.151335289508029e-21,  3.071890071015503e-24, -8.806229663935642e-27, -8.235814922612254e-29,  1.878183534619714e+00, -6.714768395498762e-04,
 -2.592015526409290e-06, -7.994868565104677e-09, -1.922003558578318e-11, -2.812305725396378e-14,  3.232060818733831e-17,  4.363276545061565e-19,  1.941755336466122e-21,
  5.628823707801092e-24,  8.786392672682547e-27, -1.620123890642844e-29,  1.911044865122279e+00, -4.992070912262493e-04, -2.001161015174606e-06, -6.633169623642520e-09,
 -1.842335813609473e-11, -4.003308407520799e-14, -4.660687049757335e-17,  1.259981376710446e-19,  1.132317149345496e-21,  4.888176917277283e-24,  1.505487113698272e-26,
  3.105206936828541e-29,  1.938962105952957e+00, -3.477136731914787e-04, -1.437804566609124e-06, -5.043158738739980e-09, -1.550652339473747e-11, -4.128906876955132e-14,
 -8.870511090118253e-17, -1.110258043798094e-19,  2.204535808798993e-22,  2.309846072680262e-24,  1.081844441000484e-26,  3.784385341646326e-29,  1.961773283692648e+00,
 -2.204163044203559e-04, -9.342091813695014e-07, -3.422444255655317e-09, -1.131660450002024e-11, -3.409195315215140e-14, -9.251255193515275e-17, -2.169180800683521e-19,
 -3.837576544170704e-22, -1.603386164613041e-25,  2.746503784201323e-27,  1.743627745447770e-29,  1.979345755096471e+00, -1.201970360334025e-04, -5.190209420163688e-07,
 -1.963266254491441e-09, -6.830865040908419e-12, -2.226440995458475e-14, -6.834746512206544e-17, -1.969910422035981e-19, -5.263146272855303e-22, -1.264316145445338e-24,
 -2.518980932504198e-27, -2.939192099783003e-30,  1.991577395841681e+00, -4.932876627578672e-05, -2.157442712728432e-07, -8.338783128485662e-10, -2.999387444150439e-12,
 -1.026325973564387e-14, -3.376853374288567e-17, -1.073977157842535e-19, -3.308352009963001e-22, -9.867142536111652e-25, -2.841402753722260e-27, -7.854134655541183e-30,
  1.998399510231015e+00, -9.406851223357022e-06, -4.143319822442959e-08, -1.620442046092521e-10, -5.933423440473532e-13, -2.082304930234170e-15, -7.091241070110176e-18,
 -2.360434795500515e-20, -7.715011212302632e-23, -2.483477405582926e-25, -7.889384898904284e-28, -2.476731930899854e-30,  6.229536402898712e-04, -3.498714101768850e-06,
  1.473292644338017e-08, -5.512471645795362e-11,  1.932655149384909e-13, -6.500891911634216e-16,  2.124455763020783e-18, -6.795418809506107e-21,  2.137689205773494e-23,
 -6.634876559579564e-26,  2.036384977421807e-28, -6.190633292465612e-31,  5.602447169034057e-03, -3.139122132535280e-05,  1.315590450915250e-07, -4.883182925581035e-10,
  1.691427410657201e-12, -5.592840077156782e-15,  1.785865620166255e-17, -5.541761554191095e-20,  1.676954737754988e-22, -4.956522896529972e-25,  1.431284990785826e-27,
 -4.034126692530444e-30,  1.553938622564442e-02, -8.665950077107955e-05,  3.597242480038326e-07, -1.313732910934046e-09,  4.438619455936043e-12, -1.415755881516262e-14,
  4.298834917410582e-17, -1.244908866505657e-19,  3.426823821708763e-22, -8.880244822970142e-25,  2.121753454474215e-27, -4.455552222482303e-30,  3.038971578143272e-02,
 -1.682782026544031e-04,  6.884698647898777e-07, -2.452497042295727e-09,  7.967809371123125e-12, -2.395711207039937e-14,  6.660593378603466e-17, -1.685889009132293e-19,
  3.722157280802862e-22, -6.278008486956228e-25,  2.791024908944689e-28,  3.933972585664366e-30,  5.008745655527893e-02, -2.747295344045361e-04,  1.102189399019550e-06,
 -3.793785448550068e-09,  1.165308650056813e-11, -3.200425075528736e-14,  7.635092462925854e-17, -1.432918970700045e-19,  1.216240992887118e-22,  5.926464226794839e-25,
 -4.330409570713842e-27,  1.842763967249886e-29,  7.454483124219073e-02, -4.040273459918127e-04,  1.581046907707132e-06, -5.203243530996949e-09,  1.478992902726019e-11,
 -3.531082297453814e-14,  6.211667225645524e-17, -2.470798715199627e-20, -4.162680357804891e-22,  2.439813750728504e-24, -9.208688963152938e-27,  2.645405537547525e-29,
  1.036524366519712e-01, -5.537489170598253e-04,  2.101769519541971e-06, -6.533328587807263e-09,  1.668770727728997e-11, -3.151696490259610e-14,  1.942588449368828e-17,
  1.765271878391155e-19, -1.082942787450284e-21,  3.949593588824765e-24, -1.012086309221591e-26,  1.379842212581622e-29,  1.372794649967742e-01, -7.210741568246017e-04,
  2.638587480820668e-06, -7.634867610180861e-09,  1.676384931643555e-11, -1.943905665506197e-14, -4.840730943058863e-17,  4.121603548451179e-19, -1.589859326597493e-21,
  3.935516228422725e-24, -3.771158303180708e-27, -2.228809108168361e-29,  1.752739783143523e-01, -9.028318445999944e-04,  3.164289497187015e-06, -8.369032982886665e-09,
  1.462860926141643e-11,  5.652799083386413e-16, -1.299666900176601e-16,  6.063696730856976e-19, -1.622796520801234e-21,  1.637934710372341e-24,  9.332346008390528e-27,
 -6.501044693029280e-29,  2.174632407170956e-01, -1.095552449241225e-03,  3.651356239249713e-06, -8.618886334960130e-09,  1.015005932117914e-11,  2.649047145289819e-14,
 -2.075084481338205e-16,  6.771074819179138e-19, -9.798534317841530e-22, -2.697898344226591e-24,  2.375074592277968e-26, -8.336244157401568e-29,  2.636541138030741e-01,
 -1.295526969257754e-03,  4.073130872354934e-06, -8.299642050351452e-09,  3.490754490943485e-12,  5.486995511854012e-14, -2.605718411443293e-16,  5.630639854498734e-19,
  3.106605106183844e-22, -7.642935952868139e-24,  3.093400329546156e-26, -5.087095460618570e-29,  3.136335211400700e-01, -1.498871131770160e-03,  4.404982534433840e-06,
 -7.366858448785038e-09, -4.889637091651672e-12,  8.124427246923641e-14, -2.707185909720585e-16,  2.481731520171545e-19,  1.945461590125497e-21, -1.098422645382248e-23,
  2.358647971539567e-26,  3.254953869093729e-29,  3.671689882209638e-01, -1.701594178344360e-03,  4.625417003322491e-06, -5.821876424778158e-09, -1.426782512946167e-11,
  1.008490057147043e-13, -2.263643788187741e-16, -2.245532581521936e-19,  3.405608258354513e-21, -1.062132445552880e-23,  5.045258474219740e-28,  1.309973037261607e-28,
  4.240092646708799e-01, -1.899671350119313e-03,  4.717088544770804e-06, -3.713989241671691e-09, -2.372453729489009e-11,  1.094194810981952e-13, -1.265502029225321e-16,
 -7.556885426528993e-19,  4.113635262885632e-21, -5.613823546432992e-24, -3.093062807747142e-26,  1.856800515655540e-28,  4.838850357434001e-01, -2.089119065338741e-03,
  4.667668279346455e-06, -1.139036604392689e-09, -3.224024790121313e-11,  1.039816564555946e-13,  1.735635292118968e-17, -1.209933684518544e-18,  3.642524163041063e-21,
  3.101975060129625e-24, -5.662823731304480e-26,  1.476407995302010e-28,  5.465097302534705e-01, -2.266071661958521e-03,  4.470527489280000e-06,  1.765639131886713e-09,
 -3.880926678200793e-11,  8.349103872743924e-14,  1.826492801580138e-16, -1.450560735814117e-18,  1.903432089512805e-21,  1.273413391801065e-23, -6.191753321711464e-26,
  1.264080463555660e-29,  6.115804320355930e-01, -2.426858459803474e-03,  4.125199202615348e-06,  4.829670449837228e-09, -4.255966042527182e-11,  4.919678191101745e-14,
  3.390088889322674e-16, -1.379028950712429e-18, -7.632233216778054e-22,  1.951779162394666e-23, -3.934155117890818e-26, -1.647559826941530e-28,  6.787789017639904e-01,
 -2.568079785006977e-03,  3.637588181577374e-06,  7.861100697446354e-09, -4.286494206540289e-11,  4.645737621470221e-15,  4.543717772764683e-16, -9.684303411971552e-19,
 -3.642123511643705e-21,  2.019639656032498e-23,  5.914545247753369e-27, -2.918368465858682e-28,  7.477727155030480e-01, -2.686680499229736e-03,  3.019908068868215e-06,
  1.066004721558100e-08, -3.943349008604702e-11, -4.470320806289730e-14,  5.017928384565286e-16, -2.799872839558818e-19, -5.842634511074861e-21,  1.351635674151948e-23,
  5.638679345663718e-26, -2.868485328237987e-28,  8.182165256487809e-01, -2.780019493231310e-03,  2.290334780318643e-06,  1.303363939532636e-08, -3.236337788951795e-11,
 -9.221860222436711e-14,  4.658018118681872e-16,  5.442335612050995e-19, -6.588058823896552e-21,  1.056227977487634e-24,  8.926739656691101e-26, -1.304014897504313e-28,
  8.897534489546493e-01, -2.845933545213528e-03,  1.472377036518272e-06,  1.481111521166924e-08, -2.215367747703183e-11, -1.310887543885767e-13,  3.467351805715866e-16,
  1.312739202323004e-18, -5.498052584367868e-21, -1.307611129335588e-23,  8.718074831439886e-26,  1.130803527311629e-28,  9.620165850904842e-01, -2.882793915872281e-03,
  5.939778403898568e-07,  1.585787116710872e-08, -9.668076713394817e-12, -1.554131553859646e-13,  1.618645305919193e-16,  1.833204333479968e-18, -2.758985598860523e-21,
 -2.368440402007124e-23,  4.755992649829252e-26,  3.219757230397258e-28,  1.034630667649255e+00, -2.889554061364886e-03, -3.136257536549558e-07,  1.608726321588823e-08,
  3.947639189502206e-12, -1.612093914559226e-13, -5.719973614206256e-17,  1.965366181553259e-18,  8.920606611806248e-22, -2.654664237423933e-23, -1.454946854698635e-26,
  3.820604774426968e-28,  1.107213847687254e+00, -2.865786899331453e-03, -1.217243679531916e-06,  1.546906000654410e-08,  1.738669303318680e-11, -1.471529653620975e-13,
 -2.705037946133699e-16,  1.662838322229829e-18,  4.380828129563903e-21, -2.024021033967916e-23, -7.246446711888396e-26,  2.534161812252485e-28,  1.179379607761770e+00,
 -2.811710168000897e-03, -2.083220958399850e-06,  1.403365691578562e-08,  2.932793645908458e-11, -1.149022142192088e-13, -4.379751399285551e-16,  9.905391756882249e-19,
  6.644076454782219e-21, -6.893977865905632e-24, -1.002723917812304e-25, -1.553711351237635e-30,  1.250738802029526e+00, -2.728198579457724e-03, -2.879007760755522e-06,
  1.187146287899182e-08,  3.859066253462385e-11, -6.892587980305628e-14, -5.280782395462207e-16,  1.109056786679202e-19,  6.992944686567098e-21,  8.547608748977856e-24,
 -8.559725967874566e-26, -2.494778177571223e-28,  1.320901815313946e+00, -2.616781688877531e-03, -3.574737336939235e-06,  9.127254858552831e-09,  4.427801957452909e-11,
 -1.583730937558896e-14, -5.248713837205460e-16, -7.587272050412133e-19,  5.357349048787720e-21,  2.030745496695669e-23, -3.597882261373304e-26, -3.610822602422240e-28,
  1.389480831177992e+00, -2.479626683259283e-03, -4.144731900066581e-06,  5.989729737134088e-09,  4.588967415366714e-11,  3.666808629539398e-14, -4.316992049702447e-16,
 -1.406018096533002e-18,  2.314607092865121e-21,  2.417061876394938e-23,  2.480982596286175e-26, -2.854437634121061e-28,  1.456092196004370e+00, -2.319505634410410e-03,
 -4.568854653940829e-06,  2.676934365460539e-09,  4.338733206654394e-11,  8.109440794953762e-14, -2.704916764517822e-16, -1.683116302919259e-18, -1.115864521690627e-21,
  1.922092809614765e-23,  6.881856529634184e-26, -7.737002660097675e-29,  1.520358862953589e+00, -2.139747156932215e-03, -4.833628796715768e-06, -5.813211352539448e-10,
  3.720224589282343e-11,  1.114160588454324e-13, -7.669530868703602e-17, -1.547386666741352e-18, -3.839048565120577e-21,  8.118156285136136e-24,  7.796930329193421e-26,
  1.393581755121842e-28,  1.581912896524422e+00, -1.944172854344567e-03, -4.933051870538407e-06, -3.562609224166257e-09,  2.818134497772027e-11,  1.240980525059690e-13,
  1.090211612346206e-16, -1.070327463993194e-18, -5.073201071151105e-21, -4.213286388980151e-24,  5.249272530841134e-26,  2.488982430318496e-28,  1.640398015375538e+00,
 -1.737019413129100e-03, -4.869046340413806e-06, -6.070895035320948e-09,  1.747717280403876e-11,  1.186641497332698e-13,  2.502654620210379e-16, -4.116406352761817e-19,
 -4.610457116237551e-21, -1.285400050128527e-23,  9.291298852906421e-27,  2.104881804734363e-28,  1.695472148187859e+00, -1.522847699492980e-03, -4.651504488283038e-06,
 -7.953629599434130e-09,  6.395194072742976e-12,  9.769294141328329e-14,  3.232228966198531e-16,  2.331232991756792e-19, -2.849038603373434e-21, -1.502481701750773e-23,
 -2.844567521727377e-26,  7.361614838475404e-29,  1.746809974769175e+00, -1.306440707839244e-03, -4.297906927241166e-06, -9.115233233403394e-09, -3.781075438298896e-12,
  6.623348578429211e-14,  3.216155547711469e-16,  6.939548131051000e-19, -5.908616460446603e-22, -1.107810678106858e-23, -4.406048145755413e-26, -6.463675009740188e-29,
  1.794105422446789e+00, -1.092692681367606e-03, -3.832518210813418e-06, -9.525544687004490e-09, -1.196246430881231e-11,  3.075128088558628e-14,  2.570380476526586e-16,
  8.762815264605276e-19,  1.303817762807186e-21, -3.934466565763345e-24, -3.523798292955066e-26, -1.267436410132447e-28,  1.837074086187145e+00, -8.864921502975308e-04,
 -3.285188712794543e-06, -9.222246421191602e-09, -1.739878296730379e-11, -2.183445829134510e-15,  1.546418129956466e-16,  7.829290944702380e-19,  2.254666195147354e-21,
  2.642381574781420e-24, -1.279085695458370e-26, -9.906118811018219e-29,  1.875455539966599e+00, -6.926019877540376e-04, -2.689817485643190e-06, -8.306842394981264e-09,
 -1.977371310299922e-11, -2.719354555355883e-14,  4.543862680154225e-17,  5.017722958834068e-19,  2.150521579633348e-21,  5.963154871928020e-24,  7.855065774504758e-27,
 -2.651826021610867e-29,  1.909015506904954e+00, -5.155398438818735e-04, -2.082554308282870e-06, -6.934408147341219e-09, -1.923489783665708e-11, -4.110505231224032e-14,
 -4.254434562581040e-17,  1.651667765395930e-19,  1.319460856875346e-21,  5.517746366203271e-24,  1.642322712790543e-26,  3.099605812565919e-29,  1.937547857068860e+00,
 -3.594624626342545e-04, -1.499838726046945e-06, -5.297986077133392e-09, -1.635384134624468e-11, -4.345441903832276e-14, -9.170195458465266e-17, -1.025539540635874e-19,
  3.118121957468261e-22,  2.777384652682594e-24,  1.259641734579767e-26,  4.305182786556004e-29,  1.960876406607405e+00, -2.280573859258965e-04, -9.763878036341731e-07,
 -3.609087366614128e-09, -1.202114573714516e-11, -3.638653107827943e-14, -9.875888918289266e-17, -2.292679116938442e-19, -3.873575666942877e-22, -3.403755514743331e-26,
  3.596928307750364e-27,  2.133451220298253e-29,  1.978856510740619e+00, -1.244453327754346e-04, -5.432508885322014e-07, -2.076213435973348e-09, -7.293013424098632e-12,
 -2.397288401901182e-14, -7.410598581614625e-17, -2.145810498084793e-19, -5.736739051299917e-22, -1.367556395188358e-24, -2.640087114968080e-27, -2.534090533742073e-30,
  1.991376564320786e+00, -5.109557832977777e-05, -2.260456714577505e-07, -8.835557120579207e-10, -3.213006989820934e-12, -1.111102010144105e-14, -3.692938444570326e-17,
 -1.185754190389542e-19, -3.684887318774984e-22, -1.107582855668205e-24, -3.209708873776280e-27, -8.909061064399662e-30,  1.998361207347497e+00, -9.746259546408167e-06,
 -4.343609444573931e-08, -1.718803277216495e-10, -6.367453528174958e-13, -2.260713235828419e-15, -7.788114811582070e-18, -2.622251029356379e-20, -8.668595257252342e-23,
 -2.821980193806679e-25, -9.064905436671449e-28, -2.877148607184798e-30,  6.091903941609053e-04, -3.383445078844536e-06,  1.408956307667857e-08, -5.213377552862393e-11,
  1.807585788148504e-13, -6.013103668394257e-16,  1.943412711727410e-18, -6.148054806081794e-21,  1.912862429066146e-23, -5.872263960951964e-26,  1.782719620646978e-28,
 -5.360784273548817e-31,  5.478950754751396e-03, -3.036173652680174e-05,  1.258579853570501e-07, -4.621275375856859e-10,  1.583734064790661e-12, -5.182262361064587e-15,
  1.637948488061877e-17, -5.032614463114127e-20,  1.508411234814646e-22, -4.417998229211966e-25,  1.264952600620496e-27, -3.537734189636514e-30,  1.519840564333675e-02,
 -8.384357982336851e-05,  3.443763949489585e-07, -1.244925315474491e-09,  4.165509418904546e-12, -1.316645719641444e-14,  3.965143465635508e-17, -1.140205500639005e-19,
  3.121948265226775e-22, -8.069753990902428e-25,  1.933157660113776e-27, -4.118306254621766e-30,  2.972743511120650e-02, -1.628860322083610e-04,  6.597892753038302e-07,
 -2.328759957169457e-09,  7.504277061852662e-12, -2.241389039628979e-14,  6.204881677265098e-17, -1.570371376283281e-19,  3.498545494469133e-22, -6.135028875589204e-25,
  4.281036563753729e-28,  2.877150962070983e-30,  4.900588953180630e-02, -2.660909992807376e-04,  1.057761865934077e-06, -3.612358539041552e-09,  1.103100307368845e-11,
 -3.021951629197071e-14,  7.239621709907142e-17, -1.390904573052643e-19,  1.400291660598785e-22,  4.348046607179551e-25, -3.581782622747534e-27,  1.566658963128592e-29,
  7.295362877146966e-02, -3.916247567064208e-04,  1.520004775053770e-06, -4.972173659382013e-09,  1.409855708749601e-11, -3.382975127745500e-14,  6.125107092572207e-17,
 -3.669209124148013e-20, -3.347913659655389e-22,  2.093990600961582e-24, -8.100982649266965e-27,  2.391277386600549e-29,  1.014705791082087e-01, -5.372438693524724e-04,
  2.024950881670849e-06, -6.271341042659419e-09,  1.606241086457514e-11, -3.099521784505384e-14,  2.390431253032942e-17,  1.440710630780600e-19, -9.478945244583938e-22,
  3.557286418386315e-24, -9.486259732196607e-27,  1.493202142202261e-29,  1.344368119170994e-01, -7.003274007947178e-04,  2.548565375258776e-06, -7.369815571311559e-09,
  1.636435604904962e-11, -2.046796530844243e-14, -3.755799549573247e-17,  3.635208115415806e-19, -1.451112760825595e-21,  3.767184471963106e-24, -4.595279813685070e-27,
 -1.539956307621940e-29,  1.717126491385668e-01, -8.779152634375769e-04,  3.065265287507229e-06, -8.135048598693839e-09,  1.461006801372507e-11, -2.355991549168267e-15,
 -1.137060053453897e-16,  5.554502719479276e-19, -1.557772668195076e-21,  1.957111440399994e-24,  6.701180386703787e-27, -5.475637436650535e-29,  2.131388015331311e-01,
 -1.066752506515924e-03,  3.548920633577585e-06, -8.452511120173623e-09,  1.063158373343629e-11,  2.173415029847547e-14, -1.890017477791575e-16,  6.443744735536116e-19,
 -1.060744463239112e-21, -1.819377042869368e-24,  2.022247354127710e-26, -7.689492775725594e-29,  2.585365466948658e-01, -1.263339274390659e-03,  3.973905408384903e-06,
 -8.235345193951710e-09,  4.526898138075619e-12,  4.880629797155153e-14, -2.447065605036181e-16,  5.688371141200490e-19,  5.723154723954764e-23, -6.452091791720820e-24,
  2.857022979578855e-26, -5.609406399274539e-29,  3.077079547346169e-01, -1.463986089471526e-03,  4.316163312342196e-06, -7.432444091141519e-09, -3.329126417181506e-12,
  7.483708844757035e-14, -2.629563098934724e-16,  3.042855403552348e-19,  1.567302844915871e-21, -1.001800382802064e-23,  2.458572320199515e-26,  1.347166042448133e-29,
  3.604361704378602e-01, -1.664874021871604e-03,  4.554250373875759e-06, -6.034322885798099e-09, -1.230561960674782e-11,  9.535277251014287e-14, -2.311835492966589e-16,
 -1.216769567486306e-19,  3.024924731545654e-21, -1.049333614014051e-23,  5.712625631606542e-27,  1.059822096449378e-28,  4.164857615315981e-01, -1.862119201108052e-03,
  4.670314781581778e-06, -4.076246671889302e-09, -2.156815756988138e-11,  1.061430448986219e-13, -1.458985666176341e-16, -6.275088303021402e-19,  3.891198275060963e-21,
 -6.691894202357510e-24, -2.308341354859352e-26,  1.705266658204443e-28,  4.756031434359735e-01, -2.051841004065468e-03,  4.650973446601954e-06, -1.638232153525110e-09,
 -3.015912492354061e-11,  1.040049304477587e-13, -1.487619375044765e-17, -1.092010435537947e-18,  3.715018595842532e-21,  9.699743080439883e-25, -4.990491086058776e-26,
  1.568397951997504e-28,  5.375170915004628e-01, -2.230233119100770e-03,  4.488045307425295e-06,  1.158273923981028e-09, -3.709886274524842e-11,  8.739452239222015e-14,
  1.429518359038658e-16, -1.382792298421782e-18,  2.317514912893987e-21,  1.027950884956312e-23, -6.055471886227360e-26,  4.819681351275787e-29,  6.019393521977942e-01,
 -2.393636540642755e-03,  4.179103386489274e-06,  4.157016265927233e-09, -4.149750184006498e-11,  5.686751974775256e-14,  3.001575411089195e-16, -1.392526923241226e-18,
 -9.053083444493271e-23,  1.781285408727832e-23, -4.556831373363350e-26, -1.185117478382634e-28,  6.685653650324851e-01, -2.538613395120868e-03,  3.727811315219273e-06,
  7.176587995432898e-09, -4.266523969563492e-11,  1.521277059527817e-14,  4.257335417404800e-16, -1.073324136678885e-18, -2.913814464865667e-21,  2.018448764774426e-23,
 -6.292037041903358e-27, -2.619451039028754e-28,  7.370751069721111e-01, -2.662020342034189e-03,  3.144015627677388e-06,  1.002261015910405e-08, -4.020786620177616e-11,
 -3.277491807797802e-14,  4.914118041916000e-16, -4.587557712038879e-19, -5.318521887843997e-21,  1.551594481202367e-23,  4.352780192275697e-26, -2.957593519223241e-28,
  8.071340709815920e-01, -2.761080139338589e-03,  2.443572685180878e-06,  1.250168253150113e-08, -3.409484605720421e-11, -8.088025920582002e-14,  4.780994612580623e-16,
  3.347010647164843e-19, -6.487284511701684e-21,  4.496962036212034e-24,  8.240939302384134e-26, -1.797947138204101e-28,  8.783943896851958e-01, -2.833449817448288e-03,
  1.647898645326271e-06,  1.443614644827350e-08, -2.468936333398560e-11, -1.223463213226745e-13,  3.809628318514732e-16,  1.129951285186002e-18, -5.905000128920340e-21,
 -9.508789446899251e-24,  9.070468668134657e-26,  4.713231485823639e-29,  9.504961142484928e-01, -2.877283779820806e-03,  7.832423172953808e-07,  1.567854416884190e-08,
 -1.273338947948346e-11, -1.509232005259844e-13,  2.118328210043026e-16,  1.731668718774267e-18, -3.574079003701848e-21, -2.151114368761876e-23,  6.077573976351088e-26,
  2.770665716471121e-28,  1.023068657216075e+00, -2.891290050431687e-03, -1.203062102740899e-07,  1.612457610880951e-08,  7.141937858284735e-13, -1.619194826409188e-13,
 -1.914119841021438e-18,  1.978541978831861e-18, -7.001921605420946e-23, -2.679003194268992e-23,  2.412764547889186e-27,  3.865570880435550e-28,  1.095732406218422e+00,
 -2.874777830591385e-03, -1.030044056566751e-06,  1.572336599007467e-08,  1.438256307339409e-11, -1.530711943945752e-13, -2.220951078014025e-16,  1.790829845067421e-18,
  3.602844693838209e-21, -2.289928786819308e-23, -6.009740093893839e-26,  3.071964553822040e-28,  1.168100513139406e+00, -2.827694521250751e-03, -1.912079252179263e-06,
  1.448395828423500e-08,  2.692714777460587e-11, -1.250570284112590e-13, -4.073063205217407e-16,  1.198405719308782e-18,  6.323873325295126e-21, -1.088504050910542e-23,
 -9.875140913467997e-26,  7.107351364551652e-29,  1.239780860493762e+00, -2.750650423899482e-03, -2.732893220299950e-06,  1.247719823891322e-08,  3.708578949813442e-11,
 -8.153694657114357e-14, -5.217986134175607e-16,  3.389218434620850e-19,  7.236504949493365e-21,  4.917733917855755e-24, -9.553891963256909e-26, -2.004038374147939e-28,
  1.310378203397792e+00, -2.644929464272346e-03, -3.460972277316696e-06,  9.832477903952908e-09,  4.383368640763015e-11, -2.866911794650681e-14, -5.436079099651434e-16,
 -5.759038828073210e-19,  6.058668319779969e-21,  1.854904093597969e-23, -5.195528748208276e-26, -3.628988754043429e-28,  1.379496481644445e+00, -2.512484497428734e-03,
 -4.068427393250966e-06,  6.729255257282530e-09,  4.651628591147646e-11,  2.584406314965018e-14, -4.698987373564475e-16, -1.317862299881709e-18,  3.199453345401029e-21,
  2.489737046853880e-23,  1.117988488190630e-26, -3.331610597425744e-28,  1.446741292059542e+00, -2.355916056545994e-03, -4.532513921862241e-06,  3.383737975163355e-09,
  4.494046684387370e-11,  7.403370384613812e-14, -3.180110724920836e-16, -1.707229136777496e-18, -3.753414850952700e-22,  2.188801427663243e-23,  6.409170471151348e-26,
 -1.383064550977614e-28,  1.511722506592738e+00, -2.178433803081041e-03, -4.836960064939120e-06,  3.162638056165886e-11,  3.940858020377426e-11,  1.090418593660567e-13,
 -1.216937356229907e-16, -1.664946833798586e-18, -3.489269581122214e-21,  1.134949657057923e-23,  8.332945225148602e-26,  1.025204790088248e-28,  1.574057016590243e+00,
 -1.983800419725068e-03, -4.973015435529986e-06, -3.091720373735549e-09,  3.068694825561702e-11,  1.263364605231205e-13,  7.675940976529157e-17, -1.234669959124699e-18,
 -5.184426619981334e-21, -1.892606822860856e-24,  6.357485607081529e-26,  2.534817432222952e-28,  1.633371578545235e+00, -1.776258250554039e-03, -4.940139908229857e-06,
 -5.771951884540272e-09,  1.990949794480425e-11,  1.245151136042778e-13,  2.366050929281808e-16, -5.664887092095882e-19, -5.064186043100832e-21, -1.228687469868118e-23,
  1.931743656023045e-26,  2.451229740208993e-28,  1.689305731497218e+00, -1.560439618885371e-03, -4.746268256606717e-06, -7.835252113476507e-09,  8.427099728108154e-12,
  1.055178107685335e-13,  3.283911394566622e-16,  1.330871204273657e-19, -3.409538111738016e-21, -1.608744486367815e-23, -2.441840892107246e-26,  1.103145495719462e-28,
  1.741514751353527e+00, -1.341262419472645e-03, -4.407607618731286e-06, -9.164707132836272e-09, -2.377656750435808e-12,  7.418291056387249e-14,  3.407191727065610e-16,
  6.683207891503415e-19, -1.022044236197816e-21, -1.289312880165130e-23, -4.657433510349068e-26, -4.865581913615004e-29,  1.789672602959383e+00, -1.123813258028053e-03,
 -3.947951739062852e-06, -9.711680308142083e-09, -1.128373837908886e-11,  3.721919835215987e-14,  2.821347439825831e-16,  9.154543432580146e-19,  1.135438432363370e-21,
 -5.458039112460054e-24, -4.099920986730099e-26, -1.347696989946064e-28,  1.833474846992010e+00, -9.132210622681797e-04, -3.397526720159899e-06, -9.500767045823153e-09,
 -1.740351967094576e-11,  1.799258880361199e-15,  1.775874637293288e-16,  8.564928379401735e-19,  2.339483923466447e-21,  2.038261374362990e-24, -1.754967392913585e-26,
 -1.175278952602250e-28,  1.872641455968704e+00, -7.145246754490465e-04, -2.791415613253683e-06, -8.627508600610767e-09, -2.030549968568596e-11, -2.592644626680136e-14,
  6.048437544065034e-17,  5.740819115954815e-19,  2.370537301870597e-21,  6.250436370435101e-24,  6.415475411338050e-27, -3.936660639254606e-29,  1.906919492176455e+00,
 -5.325384246633722e-04, -2.167641060776949e-06, -7.248797138302243e-09, -2.006680947393460e-11, -4.206566125879749e-14, -3.729777605126419e-17,  2.106971879838948e-19,
  1.530251081605029e-21,  6.201710184184531e-24,  1.776682596277497e-26,  2.987297651288344e-29,  1.936085600783822e+00, -3.717199908515551e-04, -1.565013597623556e-06,
 -5.566720779878567e-09, -1.724516455632574e-11, -4.568850060684905e-14, -9.441802698422866e-17, -9.087514332264547e-20,  4.213388350712078e-22,  3.320764331550400e-24,
  1.461390414966822e-26,  4.872685674415402e-29,  1.959948275878098e+00, -2.360450504553589e-04, -1.020875320316759e-06, -3.807378532807306e-09, -1.277310571171494e-11,
 -3.883517921452023e-14, -1.053519021229662e-16, -2.416532776677576e-19, -3.857550627698136e-22,  1.299251738819256e-25,  4.635103517447637e-27,  2.599039893999373e-29,
  1.978349876753717e+00, -1.288930189051755e-04, -5.688817198525418e-07, -2.196836027129771e-09, -7.790754127423146e-12, -2.582564754048274e-14, -8.037880886232680e-17,
 -2.337469172236314e-19, -6.248321895692557e-22, -1.475223949466195e-24, -2.738746840034760e-27, -1.909182660212785e-30,  1.991168496870028e+00, -5.294724552083946e-05,
 -2.369642810795948e-07, -9.367908963196765e-10, -3.444366419115136e-12, -1.203853687208791e-14, -4.042075457155765e-17, -1.310305921124477e-19, -4.107702659631497e-22,
 -1.244152543064449e-24, -3.627489224598184e-27, -1.010573346255938e-29,  1.998321514019770e+00, -1.010217525596842e-05, -4.556131159594525e-08, -1.824403785866379e-10,
 -6.838898984945915e-13, -2.456761854678521e-15, -8.562759028147477e-18, -2.916626041869532e-20, -9.752946525038997e-23, -3.211225379954775e-25, -1.043161524229342e-27,
 -3.347766692451328e-30,  5.958781529144738e-04, -3.273182726935822e-06,  1.348092178105335e-08, -4.933537102569616e-11,  1.691851961028440e-13, -5.566669443307207e-16,
  1.779528545271332e-18, -5.568431630209123e-21,  1.713747983648865e-23, -5.204177598116290e-26,  1.562891729428623e-28, -4.649351510602907e-31,  5.359483012657621e-03,
 -2.937663173069503e-05,  1.204611409841629e-07, -4.375960651551358e-10,  1.483908512048587e-12, -4.805533221306744e-15,  1.503560653239410e-17, -4.574423645121503e-20,
  1.358107880335556e-22, -3.941832851713963e-25,  1.119023662511767e-27, -3.105190753918732e-30,  1.486844830562521e-02, -8.114721174275342e-05,  3.298286547756396e-07,
 -1.180333157956745e-09,  3.911443742988986e-12, -1.225203109132180e-14,  3.659445956277021e-17, -1.044805580785296e-19,  2.844928006287278e-22, -7.331761267622752e-25,
  1.759185674295579e-27, -3.791633898578691e-30,  2.908627346239937e-02, -1.577174908712801e-04,  6.325500313116470e-07, -2.212198307479708e-09,  7.070541261655581e-12,
 -2.097623848150517e-14,  5.780521639755900e-17, -1.461916331372562e-19,  3.281047708603040e-22, -5.941096868326131e-25,  5.354017173294765e-28,  2.031514549691671e-30,
  4.795817936139925e-02, -2.577993424571633e-04,  1.015452897085814e-06, -3.440604522657791e-09,  1.044367505754075e-11, -2.852822162247381e-14,  6.856658097458907e-17,
 -1.343854236088636e-19,  1.532627048624720e-22,  3.045920555357941e-25, -2.946219302608500e-27,  1.328075603809426e-29,  7.141107728254928e-02, -3.796995989382356e-04,
  1.461670082705303e-06, -4.751930005008391e-09,  1.343657313232317e-11, -3.237319725475198e-14,  6.008460434427610e-17, -4.625980136147888e-20, -2.649934379972656e-22,
  1.790271850911406e-24, -7.102598234135548e-27,  2.149078889851792e-29,  9.935353232910073e-02, -5.213409645970478e-04,  1.951216428332358e-06, -6.019269221077640e-09,
  1.544855307429946e-11, -3.037641831038680e-14,  2.753238296451656e-17,  1.157154987244142e-19, -8.265021621827240e-22,  3.191168082151284e-24, -8.815896617979092e-27,
  1.545067339349570e-29,  1.316757254964559e-01, -6.802882092479202e-04,  2.461684908313794e-06, -7.111306356695587e-09,  1.594678069780862e-11, -2.125233741896717e-14,
 -2.800938336628034e-17,  3.192184061458531e-19, -1.318950056092158e-21,  3.571557403766832e-24, -5.145302648339402e-27, -9.798898970579237e-30,  1.682494196700859e-01,
 -8.537796540503369e-04,  2.969045249809899e-06, -7.901807554357961e-09,  1.453688967364719e-11, -4.903870454682300e-15, -9.884034563141523e-17,  5.067760316903551e-19,
 -1.483046916074896e-21,  2.179761772554776e-24,  4.498463006046814e-27, -4.553993644112708e-29,  2.089279359704627e-01, -1.038763938725438e-03,  3.448524694963490e-06,
 -8.279168709954333e-09,  1.102234770104251e-11,  1.741072742308391e-14, -1.714432471987634e-16,  6.095323102474354e-19, -1.112478795617455e-21, -1.076113336866737e-24,
  1.699167039807747e-26, -6.990363165269972e-29,  2.535461480311605e-01, -1.231942024237285e-03,  3.875547041594597e-06, -8.155419497041492e-09,  5.445584832682668e-12,
  4.312446988165064e-14, -2.287868560487203e-16,  5.671677938025109e-19, -1.550768523404430e-22, -5.359581686031863e-24,  2.603642254746412e-26, -5.869097776595866e-29,
  3.019205029927780e-01, -1.429814334272159e-03,  4.226702677014719e-06, -7.474076080132970e-09, -1.894776142554672e-12,  6.863371788899844e-14, -2.537870220612427e-16,
  3.488595288611137e-19,  1.224454915580253e-21, -9.027543581403627e-24,  2.482408870472757e-26, -2.075190015959230e-30,  3.538490792110722e-01, -1.628732870534990e-03,
  4.480719113373424e-06, -6.216258785280792e-09, -1.045426911667082e-11,  8.977407474183771e-14, -2.332917625606240e-16, -3.087072512002877e-20,  2.652337688921515e-21,
 -1.017855359123498e-23,  9.857149962629736e-27,  8.273671292858877e-29,  4.091116918978703e-01, -1.824958049161772e-03,  4.619398700806776e-06, -4.404550281203218e-09,
 -1.948166376586058e-11,  1.024444782933248e-13, -1.617629605375799e-16, -5.070088420737420e-19,  3.635432824954092e-21, -7.470188378718687e-24, -1.595894934286822e-26,
  1.530167390486908e-28,  4.674700591163150e-01, -2.014719897007168e-03,  4.628487937361106e-06, -2.104166915961229e-09, -2.808500376665097e-11,  1.032944386255768e-13,
 -4.378557627320970e-17, -9.729428185527965e-19,  3.715681596045800e-21, -8.869334210593483e-25, -4.291969563548261e-26,  1.597093408769231e-28,  5.286680417084186e-01,
 -2.194283116397650e-03,  4.498441352305832e-06,  5.788486436352577e-10, -3.531975532949592e-11,  9.036945371242848e-14,  1.053242247190421e-16, -1.303173612766254e-18,
  2.644571366962118e-21,  7.908692058490269e-24, -5.777673336011521e-26,  7.694637530521100e-29,  5.924319718046880e-01, -2.360015375174827e-03,  4.225042585711961e-06,
  3.502533189796447e-09, -4.029127111033089e-11,  6.360366404032657e-14,  2.612200693536481e-16, -1.385524900770051e-18,  5.167863187380990e-22,  1.589900351065867e-23,
 -4.980333935104667e-26, -7.447724127808725e-29,  6.584710855052479e-01, -2.508458006641774e-03,  3.809846318523848e-06,  6.496922961106708e-09, -4.226129414514810e-11,
  2.505987146690255e-14,  3.944838415131006e-16, -1.155010457323853e-18, -2.194389789914152e-21,  1.971236060106250e-23, -1.705704762371222e-26, -2.266551786335149e-28,
  7.264780760721040e-01, -2.636398113942440e-03,  3.260407425957371e-06,  9.374676407341866e-09, -4.074656334906530e-11, -2.115388098607284e-14,  4.762701652899275e-16,
 -6.197007308179158e-19, -4.731746820835228e-21,  1.699663908758125e-23,  3.052218355758398e-26, -2.936821550181448e-28,  7.961297844656875e-01, -2.740940869767180e-03,
  2.590268416553357e-06,  1.194385036126365e-08, -3.559706878664120e-11, -6.931669866328897e-14,  4.845935676259639e-16,  1.303181817923908e-19, -6.268079712648559e-21,
  7.622737620336316e-24,  7.359158235557910e-26, -2.192969174761653e-28,  8.670880442190892e-01, -2.819580591450046e-03,  1.818683112899598e-06,  1.402204836822709e-08,
 -2.704240755470701e-11, -1.128451933928466e-13,  4.099095764368927e-16,  9.362173654054410e-19, -6.181684050049725e-21, -5.858272224029880e-24,  9.135229371755959e-26,
 -1.720279680723451e-29,  9.390006973859307e-01, -2.870268962172025e-03,  9.700637718657215e-07,  1.545095469906103e-08, -1.569715595417763e-11, -1.452709942003000e-13,
  2.586054182079370e-16,  1.605399902272129e-18, -4.301921805569744e-21, -1.885158554649807e-23,  7.180953077731636e-26,  2.231997841187688e-28,  1.011502797532625e+00,
 -2.891478572240321e-03,  7.315044212126573e-08,  1.611011241591292e-08, -2.520173007561790e-12, -1.613017742571772e-13,  5.330902436057326e-17,  1.960922107384778e-18,
 -1.028639524834992e-21, -2.635524635802144e-23,  1.925377403470759e-26,  3.765785350455892e-28,  1.084218014380850e+00, -2.882259783883485e-03, -8.400848566231524e-07,
  1.592872326929940e-08,  1.127196200105281e-11, -1.577875079066613e-13, -1.704648792007321e-16,  1.892494200655065e-18,  2.738582824526857e-21, -2.501927079754523e-23,
 -4.558631338674958e-26,  3.504706283117723e-28,  1.156760252652333e+00, -2.842288794565434e-03, -1.735770972530089e-06,  1.489426421196601e-08,  2.433108821897553e-11,
 -1.344072378169265e-13, -3.709821684494647e-16,  1.393744934493010e-18,  5.861861668383519e-21, -1.475090524257553e-23, -9.400725089735939e-26,  1.444175108668267e-28,
  1.228735494845701e+00, -2.771904705150570e-03, -2.579662614149877e-06,  1.305684823318691e-08,  3.533072340684641e-11, -9.391993154651284e-14, -5.090455862483437e-16,
  5.725688133074488e-19,  7.342784030414971e-21,  9.368635079003658e-25, -1.030634918965169e-25, -1.398705994038830e-28,  1.299743874021436e+00, -2.672133408996884e-03,
 -3.338795740406412e-06,  1.052851588219171e-08,  4.312864778829375e-11, -4.188670144148349e-14, -5.569215877556940e-16, -3.717744434059463e-19,  6.685199239623005e-21,
  1.615403811192559e-23, -6.770525254063237e-26, -3.505818518764849e-28,  1.369381978148793e+00, -2.544696224652036e-03, -3.983195728242639e-06,  7.477025806741982e-09,
  4.691746588051446e-11,  1.413609149135158e-14, -5.052303365820675e-16, -1.201082034950214e-18,  4.100159946646657e-21,  2.503882370561351e-23, -4.403101210587588e-27,
 -3.737386983572187e-28,  1.437245382176705e+00, -2.392001414934819e-03, -4.487547306824031e-06,  4.114199883098086e-09,  4.634094240637409e-11,  6.582719733881817e-14,
 -3.658597302345653e-16, -1.706150808896073e-18,  4.571349519501487e-22,  2.431109236245057e-23,  5.658956013282152e-26, -2.031606565762144e-28,  1.502931397772999e+00,
 -2.217117081767431e-03, -4.832725914924010e-06,  6.794356004599131e-10,  4.155637127413174e-11,  1.055495711096479e-13, -1.698093825078395e-16, -1.769414800656024e-18,
 -3.019722473405686e-21,  1.475965914875651e-23,  8.683177260947853e-26,  5.489324680302491e-29,  1.566042023731339e+00, -2.023724406315323e-03, -5.007086459616142e-06,
 -2.580427365657409e-09,  3.322920240488321e-11,  1.277450454959146e-13,  3.985941041387018e-17, -1.401149162246472e-18, -5.204103001486884e-21,  8.728349209791432e-25,
  7.466417983977656e-26,  2.489143332015375e-28,  1.626187072533410e+00, -1.816050816887535e-03, -5.007408855186654e-06, -5.433174693811390e-09,  2.245520429005811e-11,
  1.299845806860716e-13,  2.184093455070379e-16, -7.354490800953111e-19, -5.489915290230745e-21, -1.128857193936308e-23,  3.083836837108149e-26,  2.781348091612846e-28,
  1.682987440701385e+00, -1.598783401693978e-03, -4.839411248602441e-06, -7.683106407796956e-09,  1.061650564649981e-11,  1.134310448738053e-13,  3.305017549757972e-16,
  1.453722514064102e-20, -4.004989398690546e-21, -1.695514945442249e-23, -1.866202618638872e-26,  1.521543178161626e-28,  1.736078482675312e+00, -1.376963717411612e-03,
 -4.517761942242548e-06, -9.190429787047473e-09, -8.107311531959385e-13,  8.258058895288975e-14,  3.589019153989212e-16,  6.278255449593164e-19, -1.520191791038810e-21,
 -1.479283376699705e-23, -4.824819927006408e-26, -2.630063151797666e-29,  1.785113440356438e+00, -1.155866042765199e-03, -4.065549361251565e-06, -9.885888360211090e-09,
 -1.046954541654470e-11,  4.430193745082676e-14,  3.082442787718578e-16,  9.483163178246103e-19,  9.079837035695093e-22, -7.218405996436540e-24, -4.705811023319660e-26,
 -1.401029898966398e-28,  1.829766873579719e+00, -9.408620423245122e-04, -3.513204702310611e-06, -9.778695598256723e-09, -1.732292698676495e-11,  6.357661877357446e-15,
  2.026273568497801e-16,  9.323844189500787e-19,  2.398926740872966e-21,  1.227056316744249e-24, -2.315657062158235e-26, -1.375670619976305e-28,  1.869738031077853e+00,
 -7.372756827318254e-04, -2.896911885089263e-06, -8.956460333202009e-09, -2.080816515408832e-11, -2.427314827446404e-14,  7.765482925019223e-17,  6.535852359831451e-19,
  2.599714897713540e-21,  6.467997210934476e-24,  4.347775676436784e-27, -5.513368852899900e-29,  1.904754097521907e+00, -5.502330178298230e-04, -2.256580955302142e-06,
 -7.576643123906757e-09, -2.091656681333724e-11, -4.288426898046319e-14, -3.067814604352842e-17,  2.633771027796975e-19,  1.766615966137552e-21,  6.938037591779395e-24,
  1.903099660281843e-26,  2.731929323748739e-29,  1.934573250817359e+00, -3.845120631653462e-04, -1.633500338306343e-06, -5.850077530249726e-09, -1.818179264200797e-11,
 -4.798342914016543e-14, -9.675497006785399e-17, -7.536242217298183e-20,  5.519411002058195e-22,  3.949967370595144e-24,  1.689070502767696e-26,  5.482962741699724e-29,
  1.958987467326546e+00, -2.443983414057583e-04, -1.067816163429638e-06, -4.018101557315963e-09, -1.357564900795694e-11, -4.144620959884072e-14, -1.122900404875370e-16,
 -2.538844907219642e-19, -3.774507738562418e-22,  3.397632613688171e-25,  5.897156409467845e-27,  3.153354171532123e-29,  1.977825032566765e+00, -1.335516798255893e-04,
 -5.960090552012621e-07, -2.325727277297407e-09, -8.327100018234038e-12, -2.783558714213821e-14, -8.721178290050568e-17, -2.546125695006671e-19, -6.799302053408443e-22,
 -1.586209083612871e-24, -2.803883351400772e-27, -9.980386046015290e-31,  1.990952843916138e+00, -5.488888124748968e-05, -2.485445506571434e-07, -9.938809082633335e-10,
 -3.695143170848264e-12, -1.305418901469981e-14, -4.428057439027786e-17, -1.449207693733658e-19, -4.582822127100332e-22, -1.398532080234882e-24, -4.101361494968175e-27,
 -1.146171546546362e-29,  1.998280362204662e+00, -1.047561271318702e-05, -4.781790797540963e-08, -1.937871488444313e-10, -7.351482158646298e-13, -2.672431578445908e-15,
 -9.424904565150729e-18, -3.248052046372196e-20, -1.098778664894083e-22, -3.659515604896839e-25, -1.202323365854798e-27, -3.901854578670879e-30,  5.829974311372597e-04,
 -3.167658263439612e-06,  1.290477908190646e-08, -4.671520601224777e-11,  1.584666279373427e-13, -5.157689720952508e-16,  1.631016776468508e-18, -5.048840670266473e-21,
  1.537174502431621e-23, -4.618069594303354e-26,  1.372096035617076e-28, -4.038438525192530e-31,  5.243871167038081e-03, -2.843355076998948e-05,  1.153493341089434e-07,
 -4.146032346616150e-10,  1.391305128756527e-12, -4.459570445909050e-15,  1.381353790228080e-17, -4.161696224566265e-20,  1.223940111867944e-22, -3.520401331055925e-25,
  9.908803217257847e-28, -2.727996761176164e-30,  1.454904848963653e-02, -7.856419290135520e-05,  3.160322210400960e-07, -1.119663640322841e-09,  3.674954044403745e-12,
 -1.140786471416061e-14,  3.379258372509611e-17, -9.578583772749397e-20,  2.593257163107004e-22, -6.660523113142523e-25,  1.599278695331829e-27, -3.479508626239120e-30,
  2.846535884600391e-02, -1.527613843533033e-04,  6.066688196829434e-07, -2.102351838098848e-09,  6.664564229648187e-12, -1.963686686044417e-14,  5.385565670361549e-17,
 -1.360301922635707e-19,  3.071219266337235e-22, -5.711152303059195e-25,  6.094269312698188e-28,  1.359044737940432e-30,  4.694297170590495e-02, -2.498380704062602e-04,
  9.751496931470480e-07, -3.277982095631727e-09,  9.889264722680433e-12, -2.692721363710931e-14,  6.487394353042112e-17, -1.293272118440266e-19,  1.622418163171319e-22,
  1.978029034428741e-25, -2.408201414554595e-27,  1.122567639325887e-29,  6.991530955684591e-02, -3.682307248694185e-04,  1.405915719909902e-06, -4.542046653016871e-09,
  1.280341986855731e-11, -3.094761062375074e-14,  5.867992138121907e-17, -5.376141822971191e-20, -2.054358524710420e-22,  1.524399036050748e-24, -6.207607761715839e-27,
  1.921663675469659e-29,  9.729893634077533e-02, -5.060160020202105e-04,  1.880448329518734e-06, -5.776915647412692e-09,  1.484787991877896e-11, -2.967964559273756e-14,
  3.041893705345980e-17,  9.103881663485467e-20, -7.178032574942090e-22,  2.852173408537782e-24, -8.133476860996221e-27,  1.550203874633479e-29,  1.289934252394073e-01,
 -6.609317676882856e-04,  2.377865986226348e-06, -6.859591809092596e-09,  1.551571153513991e-11, -2.182195719385368e-14, -1.964311601267792e-17,  2.790287413956656e-19,
 -1.194169665133879e-21,  3.358518637669156e-24, -5.473953412045663e-27, -5.309029731191818e-30,  1.648812108118196e-01, -8.304026330481706e-04,  2.875615459462204e-06,
 -7.670126097696319e-09,  1.441621254636488e-11, -7.111051045894994e-15, -8.530299925813226e-17,  4.606050318780291e-19, -1.401796781837520e-21,  2.322106008941757e-24,
  2.678278483533291e-27, -3.736602032493237e-29,  2.048274316595362e-01, -1.011570118144881e-03,  3.350243598407183e-06, -8.100243262383678e-09,  1.133077736415943e-11,
  1.349683837059658e-14, -1.548796559417734e-16,  5.734384331310651e-19, -1.139706937343587e-21, -4.558524921296420e-25,  1.407369370899311e-26, -6.272389285423887e-29,
  2.486797710501121e-01, -1.201327563203642e-03,  3.778232294252519e-06, -8.061683175462698e-09,  6.254448092574733e-12,  3.782342173698084e-14, -2.130032346194102e-16,
  5.593141458919169e-19, -3.299007451519521e-22, -4.370055006310134e-24,  2.343633613893317e-26, -5.918937800695517e-29,  2.962683042759995e-01, -1.396359881697032e-03,
  4.136876101058900e-06, -7.493738644806050e-09, -5.821978234102461e-13,  6.266418034084993e-14, -2.435178923914754e-16,  3.830334499778371e-19,  9.172792837249912e-22,
 -8.040249692068789e-24,  2.445111475510014e-26, -1.436761129325933e-29,  3.474053629620558e-01, -1.593188207131523e-03,  4.405178663182740e-06, -6.369467577294036e-09,
 -8.714799519074704e-12,  8.417395504026064e-14, -2.330224000248212e-16,  4.822406753770778e-20,  2.293825964997778e-21, -9.717827888042466e-24,  1.302568063194119e-26,
  6.167111899288137e-29,  4.018854280572002e-01, -1.788219422659223e-03,  4.564740775153739e-06, -4.700081317271057e-09, -1.747268033707911e-11,  9.840470542150644e-14,
 -1.743717665763830e-16, -3.950881802651706e-19,  3.356588478524379e-21, -7.979364685209316e-24, -9.636914078221458e-27,  1.342142825088971e-28,  4.594850648404369e-01,
 -1.977800476049679e-03,  4.600609738659854e-06, -2.537065983618705e-09, -2.603176089534277e-11,  1.019300709036283e-13, -6.937043267477495e-17, -8.548694909973724e-19,
  3.654540665776812e-21, -2.463543886549803e-24, -3.592866378637861e-26,  1.572772082895701e-28,  5.199629149163260e-01, -2.158277269624766e-03,  4.502056894769848e-06,
  2.831678279267831e-11, -3.348999355848521e-11,  9.246917884166027e-14,  7.005979380373473e-17, -1.214430910922538e-18,  2.888565148946304e-21,  5.672289029145887e-24,
 -5.388335561204605e-26,  9.892813256513570e-29,  5.830597618362042e-01, -2.326057773296463e-03,  4.263248067829932e-06,  2.868376919307889e-09, -3.895963553194584e-11,
  6.940979301074247e-14,  2.227401631342467e-16, -1.360220067955114e-18,  1.052613949189292e-21,  1.385353752482684e-23, -5.217513222199092e-26, -3.401320175177312e-29,
  6.484986886119479e-01, -2.477678837485527e-03,  3.883770485264545e-06,  5.825255111038099e-09, -4.166807840246867e-11,  3.413211576942277e-14,  3.612660968455391e-16,
 -1.214027131772103e-18, -1.499327731552787e-21,  1.884181829468319e-23, -2.618846595027322e-26, -1.880221176557994e-28,  7.159853469265294e-01, -2.609875981281911e-03,
  3.368979906122965e-06,  8.719961629033445e-09, -4.105682760940905e-11, -9.948153283670859e-15,  4.568922423597712e-16, -7.611160529891015e-19, -4.100981507415629e-21,
  1.796191257005409e-23,  1.782794444284080e-26, -2.818367073858187e-28,  7.852083592109032e-01, -2.719655201271513e-03,  2.730133602602802e-06,  1.136383933519928e-08,
 -3.686692073148140e-11, -5.766505811078536e-14,  4.854795696072142e-16, -6.532098842993035e-20, -5.943086406962587e-21,  1.036415472898482e-23,  6.326962826178176e-26,
 -2.480773440002919e-28,  8.558398758527718e-01, -2.804365591769361e-03,  1.984278899203321e-06,  1.357185764688177e-08, -2.919892604182571e-11, -1.027153172055355e-13,
  4.333275773385016e-16,  7.357317811756707e-19, -6.327155865662978e-21, -2.237395603549090e-24,  8.925362446074763e-26, -7.729215718469747e-29,  9.275363105141696e-01,
 -2.861771294344256e-03,  1.153873555844787e-06,  1.517690906189618e-08, -1.853695247250437e-11, -1.385412123478605e-13,  3.015313883209275e-16,  1.457452439191375e-18,
 -4.926666524447067e-21, -1.580014155125964e-23,  8.032391803030922e-26,  1.630049343008125e-28,  9.999392767289674e-01, -2.890121013429138e-03,  2.661236713318314e-07,
  1.604406946876899e-08, -5.728989877014439e-12, -1.593680779753748e-13,  1.076126240461016e-16,  1.913005725975407e-18, -1.959625863415423e-21, -2.525976640056367e-23,
  3.534593566924594e-26,  3.526689413277954e-28,  1.072676748481097e+00, -2.888213059236937e-03, -6.479628792053820e-07,  1.608362455777899e-08,  8.079640052390641e-12,
 -1.612337283053848e-13, -1.163858920863007e-16,  1.965396604034223e-18,  1.808875989733118e-21, -2.652431977867508e-23, -2.944302131637985e-26,  3.810796796715737e-28,
  1.145364466172499e+00, -2.855453626982067e-03, -1.554794256165229e-06,  1.526158634793627e-08,  2.155717612657646e-11, -1.428218313595633e-13, -3.294161240803051e-16,
  1.572115949107377e-18,  5.264868081339049e-21, -1.836298446144526e-23, -8.608114153295986e-26,  2.151514034097685e-28,  1.217607607117124e+00, -2.791905814433737e-03,
 -2.419652807224052e-06,  1.360645475186941e-08,  3.333158967098064e-11, -1.059180885469554e-13, -4.897247584524009e-16,  8.072710330287009e-19,  7.301003274983346e-21,
 -3.288753551674948e-24, -1.077068265415235e-25, -6.981601667918166e-29,  1.289002736292306e+00, -2.698326743567400e-03, -3.208343205901177e-06,  1.121114305113523e-08,
  4.215653653676417e-11, -5.535304415941069e-14, -5.642527766003745e-16, -1.490958043045564e-19,  7.214340544220084e-21,  1.314426213373433e-23, -8.258424737131492e-26,
 -3.232150481536309e-28,  1.359140048411670e+00, -2.576190114537634e-03, -3.888960176686949e-06,  8.229297058197180e-09,  4.707628852665104e-11,  1.622656896451745e-15,
 -5.368886834191456e-16, -1.055521314296864e-18,  4.994333461967691e-21,  2.452399519001420e-23, -2.156109695742547e-26, -4.042812556694758e-28,  1.427605906362084e+00,
 -2.427691610181394e-03, -4.433686321482998e-06,  4.865694029776025e-09,  4.756582249788045e-11,  5.647577399026385e-14, -4.132925771077457e-16, -1.677101081460634e-18,
  1.370746886191701e-21,  2.637638517600465e-23,  4.619170505211879e-26, -2.694806598163764e-28,  1.493985673635648e+00, -2.255734813932697e-03, -4.820514377118805e-06,
  1.360987006032528e-09,  4.362254115020446e-11,  1.008692182708007e-13, -2.206211514656547e-16, -1.856870256964327e-18, -2.425421675088241e-21,  1.826484558669259e-23,
  8.800327141907260e-26, -3.347178939221462e-30,  1.557866829626602e+00, -2.063895725720189e-03, -5.034777141737454e-06, -2.028282620148569e-09,  3.579039471268059e-11,
  1.282121173595294e-13, -1.695247891314078e-18, -1.566580081998091e-18, -5.116315643894564e-21,  4.074724862738581e-24,  8.531720372619903e-26,  2.333572494156733e-28,
  1.618842346688475e+00, -1.856364572908065e-03, -5.070364559516800e-06, -5.052816449821920e-09,  2.510554199213866e-11,  1.349590761650201e-13,  1.952980341320823e-16,
 -9.173660331254214e-19, -5.871068495843398e-21, -9.801288419432723e-24,  4.374020255475292e-26,  3.075340573319493e-28,  1.676514296906125e+00, -1.637864417886033e-03,
 -4.930513080689842e-06, -7.494662505409667e-09,  1.296440267936179e-11,  1.213529206510888e-13,  3.290218533401549e-16, -1.235187838575854e-19, -4.627076888254337e-21,
 -1.755437264188162e-23, -1.096076938408170e-26,  1.985963964167308e-28,  1.730497644999962e+00, -1.413547045505843e-03, -4.628068894608518e-06, -9.189714711599751e-09,
  9.284104477978589e-13,  9.139918185903597e-14,  3.757172595644113e-16,  5.702844739887988e-19, -2.087678022388796e-21, -1.673774013770346e-23, -4.878133437395548e-26,
  3.339572599046026e-30,  1.780424172139902e+00, -1.188867738017415e-03, -4.185154531828706e-06, -1.004590174250795e-08, -9.507361358003594e-12,  5.202146429217921e-14,
  3.351621861794797e-16,  9.728385964902627e-19,  6.127461018390051e-22, -9.224784059124592e-24, -5.327189189271114e-26, -1.416055913396065e-28,  1.825946464317272e+00,
 -9.694417577428451e-04, -3.632206973895742e-06, -1.005457194524940e-08, -1.714498355560360e-11,  1.154270825106652e-14,  2.298141356675249e-16,  1.009665882090960e-18,
  2.424913094512072e-21,  1.735490322457135e-25, -2.967372841921719e-26, -1.588309439949247e-28,  1.866741889027667e+00, -7.608865839351613e-04, -3.006402667792112e-06,
 -9.293167023469317e-09, -2.127345912879871e-11, -2.218021093590591e-14,  9.715510320402408e-17,  7.405301827455433e-19,  2.835060176243489e-21,  6.588028289992884e-24,
  1.514853182991865e-27, -7.421418461921854e-29,  1.902516476212212e+00, -5.686550990794296e-04, -2.349537089270933e-06, -7.918207054972853e-09, -2.178098359554898e-11,
 -4.352542559902871e-14, -2.247353379025636e-17,  3.240543278052473e-19,  2.030367115397241e-21,  7.722167657806173e-24,  2.014330238754886e-26,  2.288907868861291e-29,
  1.933008614874388e+00, -3.978658887987781e-04, -1.705478800389321e-06, -6.148790409479030e-09, -1.916484245000320e-11, -5.032873820403622e-14, -9.859551350719218e-17,
 -5.528989872144940e-20,  7.068997023704638e-22,  4.675723309897504e-24,  1.944411224426807e-26,  6.128350837095455e-29,  1.957992478229269e+00, -2.531374961261352e-04,
 -1.117364479896466e-06, -4.242092202566409e-09, -1.443210561936601e-11, -4.422782762266690e-14, -1.195657245410485e-16, -2.657188623477229e-19, -3.606222069977024e-22,
  6.052545434325831e-25,  7.425292813211440e-27,  3.811077506018698e-29,  1.977281109692972e+00, -1.384336952088814e-04, -6.247359307316210e-07, -2.463530764525335e-09,
 -8.905332983543404e-12, -3.001673192203661e-14, -9.465428286671291e-17, -2.773057041678620e-19, -7.390600039404866e-22, -1.698895719086877e-24, -2.821129670665557e-27,
  2.830892785921377e-31,  1.990729234697812e+00, -5.692596923977100e-05, -2.608346619493735e-07, -1.055151021175080e-09, -3.967191735292818e-12, -1.416732100473888e-14,
 -4.855146679920798e-17, -1.604240295680409e-19, -5.117078521168104e-22, -1.573110837708486e-24, -4.638749071556904e-27, -1.299604776732353e-29,  1.998237679651703e+00,
 -1.086766186395808e-05, -5.021573246834245e-08, -2.059897159483597e-10, -7.909345966393682e-13, -2.909952574629008e-15, -1.038563312639808e-17, -3.621702893440176e-20,
 -1.239608374177722e-22, -4.176626582095078e-25, -1.387989068792426e-27, -4.555369530982366e-30,  5.705297840278590e-04, -3.066620028135647e-06,  1.235907575896945e-08,
 -4.426018323915581e-11,  1.485315226348418e-13, -4.782668948214948e-16,  1.496293205044437e-18, -4.582519437303121e-21,  1.380389561079101e-23, -4.103165468754024e-26,
  1.206250066695121e-28, -3.513000890818678e-31,  5.131951568927279e-03, -2.753028528084061e-05,  1.105047745535599e-07, -3.930382593977766e-10,  1.305336820248855e-12,
 -4.141597701297487e-15,  1.270124344328368e-17, -3.789570813261068e-20,  1.104059902932460e-22, -3.147054109172838e-25,  8.782526335006416e-28, -2.398809710580384e-30,
  1.423976452780728e-02, -7.608869645839312e-05,  3.029416640420677e-07, -1.062646463727413e-09,  3.454694481780289e-12, -1.062811074591172e-14,  3.122323983045601e-17,
 -8.785900866510198e-20,  2.364632219542574e-22, -6.050549823417013e-25,  1.452737074789753e-27, -3.184429030461954e-30,  2.786386275137331e-02, -1.480071633207195e-04,
  5.820676594551223e-07, -1.998791756614735e-09,  6.284449393071719e-12, -1.838894551793338e-14,  5.018134523819232e-17, -1.265264413377605e-19,  2.870134524819203e-22,
 -5.457077672435250e-25,  6.570827347140275e-28,  8.281743653987985e-31,  4.595897643693145e-02, -2.421915665074916e-04,  9.367457761409016e-07, -3.123978839190743e-09,
  9.365999939819792e-12, -2.541310033080240e-14,  6.132640932909227e-17, -1.240391971008646e-19,  1.677429072013706e-22,  1.108141891138796e-25, -1.954085389607254e-27,
  9.460639004036040e-30,  6.846454096845846e-02, -3.571979813651048e-04,  1.352620109392827e-06, -4.342067558742917e-09,  1.219842527620009e-11, -2.955805016866439e-14,
  5.709048418100884e-17, -5.950361867550083e-20, -1.548289796874361e-22,  1.292372051695752e-24, -5.409110518733956e-27,  1.710657711176705e-29,  9.530452610281512e-02,
 -4.912457135630332e-04,  1.812531280403779e-06, -5.544057824527776e-09,  1.426178100807777e-11, -2.892150497487823e-14,  3.266144406668002e-17,  6.965050452547011e-20,
 -6.208172899310920e-22,  2.540410749477524e-24, -7.456819033916377e-27,  1.520660798868295e-29,  1.263872286095644e-01, -6.422339132546877e-04,  2.297025914434511e-06,
 -6.614854972223124e-09,  1.507516903250244e-11, -2.220384624170651e-14, -1.234742656031773e-17,  2.427071704701904e-19, -1.077250350189258e-21,  3.135994759914700e-24,
 -5.626455513592571e-27, -1.766403006546667e-30,  1.616050327180857e-01, -8.077619657254312e-04,  2.784952860844638e-06, -7.440711405472385e-09,  1.425453759128107e-11,
 -9.008550729962696e-15, -7.302136664979976e-17,  4.171026602235892e-19, -1.316648857851194e-21,  2.398534891977940e-24,  1.195322521565625e-27, -3.020400685811648e-29,
  2.008341438424892e-01, -9.851538798329202e-04,  3.254136702324640e-06, -7.916987908657172e-09,  1.156482222304516e-11,  9.968269350882049e-15, -1.393356916254065e-16,
  5.368086169673087e-19, -1.146630501493873e-21,  5.400381017334629e-26,  1.147094760864675e-26, -5.561112872345825e-29,  2.439343023013494e-01, -1.171486908718783e-03,
  3.682116601389815e-06, -7.955832713312016e-09,  6.961057516596366e-12,  3.289794171521059e-14, -1.975126243201208e-16,  5.464160164341546e-19, -4.709743137503798e-22,
 -3.484459371872050e-24,  2.085171071834664e-26, -5.806112497899177e-29,  2.907484851421299e-01, -1.363624637496515e-03,  4.046935686169405e-06, -7.493341385663945e-09,
  6.135262407528795e-13,  5.695150630838266e-14, -2.324241907714526e-16,  4.079425483461025e-19,  6.452554494800950e-22, -7.077806545416342e-24,  2.360284048289511e-26,
 -2.373749583856622e-29,  3.411026057323230e-01, -1.558254756722123e-03,  4.327963003629764e-06, -6.495739793785656e-09, -7.087094913302081e-12,  7.860559566747625e-14,
 -2.306963390001568e-16,  1.161345526870143e-19,  1.953964670575572e-21, -9.148199652510397e-24,  1.531988142756396e-26,  4.302037985258208e-29,  3.948052224985968e-01,
 -1.751931704850197e-03,  4.506726622834531e-06, -4.964130376876852e-09, -1.554726991981362e-11,  9.409890301336482e-14, -1.839741334808478e-16, -2.923366469205088e-19,
  3.063764555954416e-21, -8.252382109548666e-24, -4.153891069758805e-27,  1.150128354072531e-28,  4.516472700823252e-01, -1.941124303640019e-03,  4.567732856969549e-06,
 -2.937363707395758e-09, -2.401167931184647e-11,  9.999106765901806e-14, -9.168477648294549e-17, -7.396071203043784e-19,  3.541637289701888e-21, -3.763980828331508e-24,
 -2.914199377043098e-26,  1.505917627406729e-28,  5.114018282260481e-01, -2.122268423449210e-03,  4.499242951239928e-06, -4.926480587489857e-10, -3.162649523172938e-11,
  9.375318418584956e-14,  3.737758901914158e-17, -1.119136743509434e-18,  3.055067131189215e-21,  3.609035953362545e-24, -4.916621961903079e-26,  1.144623895135864e-28,
  5.738239458896457e-01, -2.291824596356612e-03,  4.293975181963793e-06,  2.256405895794738e-09, -3.752104543757769e-11,  7.430277559826025e-14,  1.851976622072426e-16,
 -1.318961842700541e-18,  1.513514622353624e-21,  1.174752508099473e-23, -5.286392624893410e-26,  1.889407474685799e-30,  6.386505403808022e-01, -2.446340340191692e-03,
  3.949697432458054e-06,  5.164486438985995e-09, -4.090151102475088e-11,  4.238978654665219e-14,  3.267020785632065e-16, -1.251370386801487e-18, -8.417649003047798e-22,
  1.764056675416460e-23, -3.358222201011351e-26, -1.479732477251263e-28,  7.056003936160564e-01, -2.582516762619276e-03,  3.469673333928918e-06,  8.062048965318635e-09,
 -4.114793683583291e-11,  7.472982007898379e-16,  4.338418053050787e-16, -8.818877132204792e-19, -3.444457231359750e-21,  1.843238308763526e-23,  5.842012134382578e-27,
 -2.617595527901194e-28,  7.743742699279653e-01, -2.697278779507587e-03,  2.862924439342430e-06,  1.076537425564972e-08, -3.790396448455455e-11, -4.605662481234244e-14,
  4.810475268550595e-16, -2.490632858942800e-19, -5.527109688605349e-21,  1.267059547941685e-23,  5.192267588871358e-26, -2.658946433361304e-28,  8.446551819956986e-01,
 -2.787848005939599e-03,  2.144272150477595e-06,  1.308881203045493e-08, -3.114768359627236e-11, -9.209117843956304e-14,  4.510862617292320e-16,  5.326554531699122e-19,
 -6.344408560109989e-21,  1.248419723510006e-24,  8.464660292237365e-26, -1.308848093172473e-28,  9.161088333662488e-01, -2.851817064274107e-03,  1.334126790744068e-06,
  1.485855797321825e-08, -2.123219790216007e-11, -1.308330729136850e-13,  3.400518964862025e-16,  1.291331249343806e-18, -5.436078826625808e-21, -1.246232883887528e-23,
  8.610259444466948e-26,  9.932712244059666e-29,  9.883842674852241e-01, -2.887223708247152e-03,  4.579978429840585e-07,  1.592706513879256e-08, -8.886225858899535e-12,
 -1.561505208255175e-13,  1.601642845605720e-16,  1.836050719756585e-18, -2.839877300872273e-21, -2.354548487089064e-23,  5.010146508267453e-26,  3.160845742704460e-28,
  1.061114753971889e+00, -2.892622796597670e-03, -4.542905935593217e-07,  1.618696845176635e-08,  4.831520424928682e-12, -1.633609651732552e-13, -6.068938907153318e-17,
  2.007808498018621e-18,  8.368980600167719e-22, -2.736079179210516e-23, -1.226093199763458e-26,  3.974944585663482e-28,  1.133918942825352e+00, -2.867153781139111e-03,
 -1.369681343243383e-06,  1.558323541532115e-08,  1.862534090140006e-11, -1.501811837205874e-13, -2.831422219058108e-16,  1.729369802549129e-18,  4.544283149189209e-21,
 -2.159728698838863e-23, -7.516180407508443e-26,  2.799311886298949e-28,  1.206402316086927e+00, -2.810601025975413e-03, -2.253247469990545e-06,  1.412218284985298e-08,
  3.109766071696245e-11, -1.173739785043316e-13, -4.638740752861550e-16,  1.038172634054769e-18,  7.104520764736849e-21, -7.636211321842318e-24, -1.091051184062142e-25,
  7.150726200824323e-30,  1.278158963944769e+00, -2.723443976692315e-03, -3.069801380929597e-06,  1.187605441835164e-08,  4.091385342969758e-11, -6.891870617253365e-14,
 -5.651290011279868e-16,  8.866948433334656e-20,  7.624748197948381e-21,  9.567906778500646e-24, -9.592317037572076e-26, -2.806142083467380e-28,  1.348773708092027e+00,
 -2.606893987072471e-03, -3.785690511805670e-06,  8.982067483614214e-09,  4.697759122956095e-11, -1.159845821120664e-14, -5.640744851683132e-16, -8.817784606448312e-19,
  5.857327701607845e-21,  2.329954137547742e-23, -3.979122959476335e-26, -4.220417380916390e-28,  1.417824589106908e+00, -2.462914527273213e-03, -4.370696189288218e-06,
  5.635228514589837e-09,  4.859237347814934e-11,  4.599909233472213e-14, -4.594921614234976e-16, -1.617712134420871e-18,  2.350521163379301e-21,  2.796761273091484e-23,
  3.289717231134135e-26, -3.343008519087710e-28,  1.484885726535632e+00, -2.294221584878431e-03, -4.799929175978969e-06,  2.074781222203637e-09,  4.558272239781493e-11,
  9.494226372777046e-14, -2.735964218071996e-16, -1.923285247776157e-18, -1.704735413778497e-21,  2.176267385523399e-23,  8.639242430293085e-26, -7.138464980944435e-29,
  1.549530550140312e+00, -2.104261370639825e-03, -5.055596083996964e-06, -1.435139821289900e-09,  3.835058224555732e-11,  1.276267194847717e-13, -4.782473704596401e-17,
 -1.727276829217081e-18, -4.905787718859032e-21,  7.685434175541073e-24,  9.501300104024309e-26,  2.051537265726895e-28,  1.611335388462856e+00, -1.897162989118932e-03,
 -5.128498351745097e-06, -4.629288776449230e-09,  2.784940340153261e-11,  1.393164509197758e-13,  1.669310649458973e-16, -1.110521171576328e-18, -6.189092397694038e-21,
 -7.773629250231547e-24,  5.781391525344665e-26,  3.309925145501200e-28,  1.669883386655964e+00, -1.677664552777457e-03, -5.019122969335583e-06, -7.267388035161290e-09,
  1.547005723825753e-11,  1.291906247950680e-13,  3.233948926387296e-16, -2.817632235860739e-19, -5.264688357156925e-21, -1.780351956073713e-23, -1.131651611461108e-27,
  2.486773534062179e-28,  1.724768709841022e+00, -1.451012308305016e-03, -4.738194418763530e-06, -9.159741054001190e-09,  2.847818206322431e-12,  1.005998924182880e-13,
  3.906566801872762e-16,  4.934621510011155e-19, -2.725229332176945e-21, -1.867556011003409e-23, -4.783492163743294e-26,  4.107159407459098e-29,  1.775600971683848e+00,
 -1.222833681599726e-03, -4.306582284145096e-06, -1.018924974124874e-08, -8.384276655194216e-12,  6.039412436087685e-14,  3.626232500753268e-16,  9.867095813069372e-19,
  2.408017587212997e-22, -1.147961826135683e-23, -5.944329818554394e-26, -1.379400510913227e-28,  1.822009811269220e+00, -9.989866768826466e-04, -3.754499140094535e-06,
 -1.032673540142084e-08, -1.685663876546721e-11,  1.740626096640836e-14,  2.591703663763868e-16,  1.087119930209031e-18,  2.408053023356603e-21, -1.159603502986990e-24,
 -3.714379053530752e-26, -1.807715163568788e-28,  1.863649525756171e+00, -7.853896965305710e-04, -3.119977132993375e-06, -9.636957275930942e-09, -2.169201268775611e-11,
 -1.958919934283079e-14,  1.191957542161654e-16,  8.350517410450283e-19,  3.072474929015430e-21,  6.576890851433917e-24, -2.237563677772589e-27, -9.698922385171643e-29,
  1.900203652987387e+00, -5.878374604929523e-04, -2.446675361310319e-06, -8.273692945656179e-09, -2.265611174649316e-11, -4.394830387160189e-14, -1.244749618826047e-17,
  3.936314150195347e-19,  2.323094814755099e-21,  8.546222714918881e-24,  2.100965791311449e-26,  1.604232778324591e-29,  1.931389388889102e+00, -4.118101513160967e-04,
 -1.781137744935972e-06, -6.463609533667513e-09, -2.019519164429568e-11, -5.271089075211565e-14, -9.980053326437992e-17, -2.982039200792481e-20,  8.898931299160110e-22,
  5.509372106072940e-24,  2.228698556767707e-26,  6.796117663647311e-29,  1.956961722382226e+00, -2.622840261756707e-04, -1.169684770846324e-06, -4.480240811426282e-09,
 -1.534596724222902e-11, -4.718796829308022e-14, -1.271637074774772e-16, -2.768494134512140e-19, -3.330628746178754e-22,  9.379995005539792e-25,  9.268568020605723e-27,
  4.588661815644013e-29,  1.976717188428079e+00, -1.435523008226511e-04, -6.551734300657181e-07, -2.610944887316371e-09, -9.529027633404255e-12, -3.238433915802118e-14,
 -1.027592908863932e-16, -3.019559150666876e-19, -8.022441717279337e-22, -1.811013403758609e-24, -2.771977563955787e-27,  2.039455496338770e-30,  1.990497275722463e+00,
 -5.906439481391020e-05, -2.738868843778972e-07, -1.120957732622595e-09, -4.262564138722503e-12, -1.538836265397267e-14, -5.328136035949639e-17, -1.777417516517401e-19,
 -5.718220319443973e-22, -1.770592278052661e-24, -5.247942674662749e-27, -1.472907355187202e-29,  1.998193389587646e+00, -1.127949487714077e-05, -5.276550418050038e-08,
 -2.191241578044026e-10, -8.517107172667948e-13, -3.171839219943040e-15, -1.145758351071255e-17, -4.043546962137234e-20, -1.400463185652961e-22, -4.774088810844490e-25,
 -1.604943363980123e-27, -5.327538936785575e-30,  5.584577414469001e-04, -2.969832224787298e-06,  1.184190313338825e-08, -4.195829315854766e-11,  1.393151542477614e-13,
 -4.438470018614287e-16,  1.373951210927235e-18, -4.163527183771635e-21,  1.241000750983078e-23, -3.650198643869715e-26,  1.061879493730191e-28, -3.060368820789567e-31,
  5.023569126372036e-03, -2.666476405863407e-05,  1.059109470023594e-07, -3.727993172008462e-10,  1.225469236894476e-12, -3.849111819500117e-15,  1.168796948288586e-17,
 -3.453740781087030e-20,  9.968430182008427e-23, -2.815988038661838e-25,  7.791712182460994e-28, -2.111285751328465e-30,  1.394017735309930e-02, -7.371524639371246e-05,
  2.905146722325512e-07, -1.009031955921817e-09,  3.249430915245960e-12, -9.907438298157392e-15,  2.886592694950829e-17, -8.062975118539512e-20,  2.156942018487490e-22,
 -5.496650063162060e-25,  1.318776619547366e-27, -2.907793655097520e-30,  2.728099764937366e-02, -1.434448822111271e-04,  5.586735375326799e-07, -1.901118547224718e-09,
  5.928432330944492e-12, -1.722608624530787e-14,  4.676427007653042e-17, -1.176512025003550e-19,  2.678486581540427e-22, -5.188255251747764e-25,  6.840061947542960e-28,
  4.127506458675858e-31,  4.500496422719146e-02, -2.348450418448352e-04,  9.001406492612250e-07, -2.978110136467195e-09,  8.872178099064428e-12, -2.398233395235679e-14,
  5.792895738406331e-17, -1.186218944169915e-19,  1.704213577379602e-22,  4.051394925747054e-26, -1.571934036796755e-27,  7.948795665389715e-30,  6.705706559318063e-02,
 -3.465821662085238e-04,  1.301667078780637e-06, -4.151548172370156e-09,  1.162082831848349e-11, -2.820839009347620e-14,  5.536172442946529e-17, -6.375406094235429e-20,
 -1.120220794897101e-22,  1.090478238231296e-24, -4.699701400782903e-27,  1.516773757638482e-29,  9.336812781957238e-02, -4.770077425717943e-04,  1.747352768971723e-06,
 -5.320453554924271e-09,  1.369133637186954e-11, -2.811639014474293e-14,  3.434687786651714e-17,  5.119136155714988e-20, -5.345714553300071e-22,  2.255374630616941e-24,
 -6.798965109275251e-27,  1.466163080677521e-29,  1.238545483864490e-01, -6.241711523751639e-04,  2.219080170448382e-06, -6.377218742334665e-09,  1.462865949050141e-11,
 -2.242242744714409e-14, -6.017572241238027e-18,  2.099979565578387e-19, -9.684163832304509e-22,  2.910242901123185e-24, -5.641170741752966e-27,  9.771176361342230e-31,
  1.584179840618243e-01, -7.858356340441765e-04,  2.697026516147710e-06, -7.214171505804857e-09,  1.405776317155336e-11, -1.062559798544685e-14, -6.191931868127873e-17,
  3.763581959245474e-19, -1.229743890949425e-21,  2.421661832323918e-24,  6.209945008906348e-30, -2.399892233292689e-29,  1.969449972787254e-01, -9.594976420059075e-04,
  3.160249074641982e-06, -7.730532487858181e-09,  1.173194311656354e-11,  6.800439077496307e-15, -1.248178443028341e-16,  5.002314393753118e-19, -1.136998347617649e-21,
  4.659461528622145e-25,  9.176136234936159e-27, -4.875277501060242e-29,  2.393066666257074e-01, -1.142409914113019e-03,  3.587335762836359e-06, -7.839444509022235e-09,
  7.572843319732068e-12,  2.833942119502227e-14, -1.824417113393967e-16,  5.294938032749082e-19, -5.820118462319289e-22, -2.700870481190393e-24,  1.834484109887789e-26,
 -5.571787794313885e-29,  2.853581684164454e-01, -1.331608580897901e-03,  3.957111105000933e-06, -7.474711883308129e-09,  1.697710857849318e-12,  5.151249869515076e-14,
 -2.207497434593324e-16,  4.246939434352369e-19,  4.071766105710967e-22, -6.156758912521702e-24,  2.240000827107159e-26, -3.054418446993492e-29,  3.349383378708948e-01,
 -1.523944658360965e-03,  4.249384673542941e-06, -6.596856016254611e-09, -5.570051488099890e-12,  7.311467028625037e-14, -2.266178422315044e-16,  1.735137322881784e-19,
  1.636070733045413e-21, -8.502480822455288e-24,  1.684847496342781e-26,  2.687556891088701e-29,  3.878692202476960e-01, -1.716120257524345e-03,  4.445725841436814e-06,
 -5.198073360635272e-09, -1.371005258374214e-11,  8.959610185423212e-14, -1.908318279167829e-16, -1.990720587949642e-19,  2.764856523779963e-21, -8.322927729586890e-24,
  4.890380932352205e-28,  9.613303362520895e-29,  4.439556243327122e-01, -1.904729814243348e-03,  4.530244959407356e-06, -3.305678374843323e-09, -2.203547410742972e-11,
  9.755479866098095e-14, -1.108290226932389e-16, -6.286549543286490e-19,  3.386724235548026e-21, -4.799858818525754e-24, -2.272428957749266e-26,  1.406685194727312e-28,
  5.029846930218611e-01, -2.086306586583393e-03,  4.490357037347745e-06, -9.836331866360128e-10, -2.974494157487539e-11,  9.428537022765288e-14,  7.427314328840700e-18,
 -1.019665300887080e-18,  3.150836733799644e-21,  1.746353182713864e-24, -4.389793246308179e-26,  1.240824300765323e-28,  5.647255083367010e-01, -2.257374578694972e-03,
  4.317499820396967e-06,  1.668186657448497e-09, -3.599350400244194e-11,  7.831019737441588e-14,  1.490054568998351e-16, -1.264170175379666e-18,  1.898470083280876e-21,
  9.644060410831676e-24, -5.208562127497659e-26,  3.259662388539434e-29,  6.289287510621072e-01, -2.414505923453001e-03,  4.007774049249949e-06,  4.517258687561420e-09,
 -3.997815817856531e-11,  4.980770938488278e-14,  2.913801491484678e-16, -1.268417181235394e-18, -2.323454926303150e-22,  1.617883514633540e-23, -3.921470616360787e-26,
 -1.082272480841540e-28,  6.953264382599115e-01, -2.554383585067492e-03,  3.562470021879167e-06,  7.404358661581571e-09, -4.103093072395431e-11,  1.085134629650925e-14,
  4.077057817446900e-16, -9.814702843208717e-19, -2.779394159003240e-21,  1.844312717845667e-23, -5.111026839483113e-27, -2.351824725786016e-28,  7.636317651271057e-01,
 -2.673869021850764e-03,  2.988441777059918e-06,  1.015216632478162e-08, -3.871031190162715e-11, -3.461472022493125e-14,  4.716689073218487e-16, -4.182547595989157e-19,
 -5.036430855874617e-21,  1.451065577383309e-23,  4.002830683798096e-26, -2.730510549412633e-28,  8.335390809356436e-01, -2.770074174061742e-03,  2.298288855291879e-06,
  1.257630737974650e-08, -3.288015670362395e-11, -8.110901271128029e-14,  4.631696653453487e-16,  3.309948267478174e-19, -6.240036311908153e-21,  4.505115254938688e-24,
  7.785790860901534e-26, -1.762105316887103e-28,  9.047240319765585e-01, -2.840436810249041e-03,  1.510306314702830e-06,  1.449836487754037e-08, -2.376442142740601e-11,
 -1.222579875504824e-13,  3.737111450456041e-16,  1.110870550034748e-18, -5.821848320580917e-21, -8.949788553383827e-24,  8.905596159622191e-26,  3.505204079412753e-29,
  9.768439073512516e-01, -2.882797879335937e-03,  6.481672114503054e-07,  1.576012758050758e-08, -1.196668902680573e-11, -1.517007026798162e-13,  2.101769228583760e-16,
  1.732025655467381e-18, -3.648209170163282e-21, -2.127650855328968e-23,  6.300200742923451e-26,  2.687071358561910e-28,  1.049538225873001e+00, -2.895479081414654e-03,
 -2.596911684336383e-07,  1.623807504227408e-08,  1.554301145981918e-12, -1.641407732964371e-13, -4.244373523538437e-18,  2.018769087371272e-18, -1.526875167873958e-22,
 -2.749991621449552e-23,  5.315076139063559e-27,  3.989173862775458e-28,  1.122429603973442e+00, -2.877358401083672e-03, -1.180994755431438e-06,  1.585685941272503e-08,
  1.555776710584555e-11, -1.563798352063565e-13, -2.328049053361098e-16,  1.861791709262937e-18,  3.715790143157939e-21, -2.434027254385225e-23, -6.158167845147513e-26,
  3.356025340767439e-28,  1.195124945010798e+00, -2.827940864682285e-03, -2.080875298483512e-06,  1.460037103501630e-08,  2.864133752618045e-11, -1.281327244426746e-13,
 -4.316697380677971e-16,  1.260278573634646e-18,  6.751351860608385e-21, -1.197052232410155e-23, -1.070221771997905e-25,  8.786084949209851e-29,  1.267216989362824e+00,
 -2.747421318097526e-03, -2.923408867922172e-06,  1.251891349600220e-08,  3.940019319192911e-11, -8.242414695314874e-14, -5.591840018252759e-16,  3.374087900044590e-19,
  7.897294690583263e-21,  5.499853937869465e-24, -1.070627478809350e-25, -2.234222560568376e-28,  1.338286261742760e+00, -2.636735616471479e-03, -3.673405912875393e-06,
  9.731109633178734e-09,  4.660835702305407e-11, -2.541058016991164e-14, -5.860165033313947e-16, -6.812670870552806e-19,  6.662966531234874e-21,  2.133456302127674e-23,
 -5.847670338743924e-26, -4.246229082009307e-28,  1.407903446882811e+00, -2.497596322743226e-03, -4.298380202438834e-06,  6.419451931528838e-09,  4.939845614003120e-11,
  3.443716732983021e-14, -5.035820683481797e-16, -1.526162010186000e-18,  3.377330505496054e-21,  2.897119674129223e-23,  1.684502968520316e-26, -3.942423989518293e-28,
  1.475632216703674e+00, -2.332508888384093e-03, -4.770594404014328e-06,  2.818920361955898e-09,  4.741151382031316e-11,  8.772430902041220e-14, -3.280896375465763e-16,
 -1.964641976619285e-18, -8.600322226634032e-22,  2.513362789520441e-23,  8.159935502280707e-26, -1.476757726136627e-28,  1.541032521031559e+00, -2.144764401160332e-03,
 -5.069052120024238e-06, -8.011893529920213e-10,  4.088763073687799e-11,  1.258811037504562e-13, -9.833935903060039e-17, -1.879084729552540e-18, -4.558628892880043e-21,
  1.165512683669436e-23,  1.031646097749951e-25,  1.629865527439574e-28,  1.603664339681882e+00, -1.938405393635326e-03, -5.181283650224554e-06, -4.161200989717275e-09,
  3.067316051484937e-11,  1.429270396931540e-13,  1.330250365181293e-16, -1.312574610301870e-18, -6.423759516815447e-21, -5.164697721794782e-24,  7.274156196124165e-26,
  3.458998504302919e-28,  1.663091876358688e+00, -1.718161964207444e-03, -5.104759876600521e-06, -6.998777944910467e-09,  1.813074457045020e-11,  1.368378006803138e-13,
  3.130506555016968e-16, -4.604744999208145e-19, -5.903653914486035e-21, -1.761466548966704e-23,  1.095519593141320e-26,  3.009345805365922e-28,  1.718888154656143e+00,
 -1.489356600375109e-03, -4.847769862409403e-06, -9.097566051219608e-09,  4.954639217077651e-12,  1.101309672711812e-13,  4.031490369355129e-16,  3.951327059292460e-19,
 -3.431437699714027e-21, -2.053979319502627e-23, -4.503856189208464e-26,  8.750745060238728e-29,  1.770639954163317e+00, -1.257777609465822e-03, -4.429616754063294e-06,
 -1.031325284302890e-08, -7.087123911634131e-12,  6.942908896486665e-14,  3.902935300021904e-16,  9.873323436120615e-19, -2.167044826924438e-22, -1.397622910647612e-23,
 -6.531197476288843e-26, -1.275786185124501e-28,  1.817953001308319e+00, -1.029522909603192e-03, -3.880025590711208e-06, -1.059330815631365e-08, -1.644380227079596e-11,
  2.400028035830665e-14,  2.906801199930406e-16,  1.163206999873389e-18,  2.337587953240367e-21, -2.810898143180072e-24, -4.557999122160938e-26, -2.025916286555548e-28,
  1.860457306559499e+00, -8.108180164966809e-04, -3.237715456702633e-06, -9.987000167196893e-09, -2.205323745241208e-11, -1.643659584611113e-14,  1.439890921684859e-16,
  9.371331582393104e-19,  3.306534924363722e-21,  6.394450130636296e-24, -7.079689222486312e-27, -1.237965778642123e-28,  1.897812518750841e+00, -6.078142299948672e-04,
 -2.548163711233619e-06, -8.643234791554352e-09, -2.353712782539376e-11, -4.410609320207873e-14, -3.376543220148981e-19,  4.730564933714425e-19,  2.646032012464458e-21,
  9.398056300141562e-24,  2.150994327672290e-26,  6.133958792305613e-30,  1.929713150983942e+00, -4.263750805925577e-04, -1.860675009114261e-06, -6.795296705980656e-09,
 -2.127341178909094e-11, -5.511271578646216e-14, -1.002057542610052e-16,  2.007609605261524e-21,  1.105015852098160e-21,  6.462637526158482e-24,  2.542516389561476e-26,
  7.466771089012938e-29,  1.955893524834099e+00, -2.718608028206939e-04, -1.224952561889911e-06, -4.733494840552047e-09, -1.632087987458972e-11, -5.033408917040862e-14,
 -1.350590930044045e-16, -2.868914822840872e-19, -2.921115604800533e-22,  1.351710751537040e-24,  1.148365952756698e-26,  5.504285119080036e-29,  1.976132294292937e+00,
 -1.489216556225428e-04, -6.874413710672243e-07, -2.768727749421511e-09, -1.020207673313766e-11, -3.495498124328377e-14, -1.115834144702558e-16, -3.286920586422634e-19,
 -8.694090497699533e-22, -1.919451299807038e-24, -2.632722100286317e-27,  4.402952165129712e-30,  1.990256549092028e+00, -6.131047912781045e-05, -2.877579694211491e-07,
 -1.191692105831376e-09, -4.583532978098961e-12, -1.672896461707482e-14, -5.852418447253332e-17, -1.971017326771307e-19, -6.395031125678759e-22, -1.994029710098190e-24,
 -5.938150955369111e-27, -1.668210142701039e-29,  1.998147410373097e+00, -1.171237345568760e-05, -5.547890118792134e-08, -2.332743585091014e-10, -9.179917155787345e-13,
 -3.460930284619442e-15, -1.265519221397620e-17, -4.520480322761888e-20, -1.584474192143833e-22, -5.465527042154170e-25, -1.858901782005199e-27, -6.241574903315122e-30,
  5.467647467895817e-04, -2.877073767270735e-06,  1.135149062845062e-08, -3.979851342320277e-11,  1.307587464919266e-13, -4.122274288779018e-16,  1.262740279983573e-18,
 -3.786637934230128e-21,  1.116925532729982e-23, -3.251186870576760e-26,  9.360225834812378e-29, -2.669853411533399e-31,  4.918576775530771e-03, -2.583504327544434e-05,
  1.015525083158400e-07, -3.537927486183941e-10,  1.151215606259301e-12, -3.579853818958454e-15,  1.076409847461361e-17, -3.150387294456019e-20,  9.008606047199417e-23,
 -2.522134526470320e-25,  6.919264118355222e-28, -1.859942467690789e-30,  1.364988914408197e-02, -7.143869352303613e-05,  2.787118150856861e-07, -9.585893640305061e-10,
  3.058031058085658e-12, -9.240985623707969e-15,  2.670202129060926e-17, -7.403420842282583e-20,  1.968256520154593e-22, -4.993955911487296e-25,  1.196570343439208e-27,
 -2.650190927189674e-30,  2.671601465460940e-02, -1.390651608604933e-04,  5.364180697662344e-07, -1.808959925954121e-09,  5.594872130939881e-12, -1.614232309541959e-14,
  4.358726254466083e-17, -1.093735790470801e-19,  2.496668713635322e-22, -4.912028703749961e-25,  6.947862962203571e-28,  9.115234458657261e-32,  4.407976333329716e-02,
 -2.277844886727878e-04,  8.652394700137622e-07, -2.839918039134485e-09,  8.406168524359215e-12, -2.263127875774974e-14,  5.468402969512441e-17, -1.131565501022032e-19,
  1.708287318064462e-22, -1.576358885192880e-26, -1.251347267862275e-27,  6.657106647009221e-30,  6.569125249040149e-02, -3.363649854360196e-04,  1.252945714866307e-06,
 -3.970056683775028e-09,  1.106980079210401e-11, -2.690150013524445e-14,  5.353207523075365e-17, -6.674566042976191e-20, -7.599267977918486e-23,  9.153052956553728e-25,
 -4.071815879743375e-27,  1.340059898253788e-29,  9.148765534061583e-02, -4.632806205908084e-04,  1.684803284117979e-06, -5.105845553561486e-09,  1.313735824322467e-11,
 -2.727672461160503e-14,  3.555258710129599e-17,  3.533293279060231e-20, -4.581195609538476e-22,  1.996117446916943e-24, -6.169122717477303e-27,  1.394470750552017e-29,
  1.213928899634693e-01, -6.067206726392243e-04,  2.143943077944594e-06, -6.146753688388639e-09,  1.417922530695737e-11, -2.249969640903039e-14, -5.560395674316580e-19,
  1.806415065649580e-19, -8.676928721697741e-22,  2.686111353508419e-24, -5.550296751909948e-27,  3.053545895419506e-30,  1.553172510491194e-01, -7.646018950937133e-04,
  2.611798738500141e-06, -6.991024629570177e-09,  1.383122151597436e-11, -1.198957152731477e-14, -5.191911955963834e-17,  3.383993497206502e-19, -1.142799151773746e-21,
  2.402418344746383e-24, -9.296561571345576e-28, -1.868028648153946e-29,  1.931569876928176e-01, -9.345835145771073e-04,  3.068612925220530e-06, -7.541891401752449e-09,
  1.183910896682669e-11,  3.968795122016432e-15, -1.113177362337032e-16,  4.641826376485249e-19, -1.114116754600390e-21,  7.920257844608826e-25,  7.175000365730023e-27,
 -4.227973614176137e-29,  2.347938315065253e-01, -1.114085419978235e-03,  3.494007368750619e-06, -7.713977610691055e-09,  8.097035385035916e-12,  2.413654058973005e-14,
 -1.678902610840679e-16,  5.094506019991286e-19, -6.666177055109791e-22, -2.015216576329049e-24,  1.596124720935748e-26, -5.251066483761398e-29,  2.800944805452514e-01,
 -1.300309940001961e-03,  3.867610619551115e-06, -7.439590300443771e-09,  2.675950861740541e-12,  4.635847568506793e-14, -2.087080010903873e-16,  4.343475082475411e-19,
  2.013234465971880e-22, -5.289141152683406e-24,  2.094735529157743e-26, -3.515274035491503e-29,  3.289100460363844e-01, -1.490267635892393e-03,  4.169734979615502e-06,
 -6.674572247773708e-09, -4.161723443545147e-12,  6.773978059484568e-14, -2.210715739847999e-16,  2.211026953117016e-19,  1.342358768939629e-21, -7.809089788860138e-24,
  1.772159107083248e-26,  1.321446354072047e-29,  3.810754706903295e-01, -1.680807552887807e-03,  4.382091118661738e-06, -5.403349389220225e-09, -1.196433118484519e-11,
  8.495897097365340e-14, -1.952121602795863e-16, -1.153789307831096e-19,  2.466553523663214e-21, -8.224147335872623e-24,  4.318809954212743e-27,  7.812956610527522e-29,
  4.364089294961926e-01, -1.868652373463514e-03,  4.488525315593480e-06, -3.642787480394434e-09, -2.011234029740686e-11,  9.469575480795353e-14, -1.269412674180933e-16,
 -5.232080267805360e-19,  3.199028231930889e-21, -5.588501904658266e-24, -1.679695247612733e-26,  1.284502237409989e-28,  4.947112263989147e-01, -2.050438891972350e-03,
  4.475760158405551e-06, -1.444466408985439e-09, -2.785970512970913e-11,  9.413245789701532e-14, -1.970464173836210e-17, -9.181607335285902e-19,  3.183430330894557e-21,
  1.012738647184546e-25, -3.832418085136040e-26,  1.284680509391511e-28,  5.557652031381795e-01, -2.222764177170687e-03,  4.334114965453836e-06,  1.105002620679768e-09,
 -3.439436909543635e-11,  8.146873853119873e-14,  1.145085520467550e-16, -1.198262973593446e-18,  2.208572202889203e-21,  7.597142635687875e-24, -5.007669477611827e-26,
  5.780081288719540e-29,  6.193351798159819e-01, -2.382237698584720e-03,  4.058177321177856e-06,  3.885945266257588e-09, -3.891495162369684e-11,  5.637433176144186e-14,
  2.558457281811632e-16, -1.266844597432889e-18,  3.208139926047752e-22,  1.452635922340599e-23, -4.313226990629613e-26, -7.023835605896412e-29,  6.851664504414122e-01,
 -2.525539556188825e-03,  3.647392214558255e-06,  6.750122117170781e-09, -4.071832972969424e-11,  2.029707234359948e-14,  3.790788634503145e-16, -1.059846825600419e-18,
 -2.121534661872783e-21,  1.804064964029804e-23, -1.478491568686126e-26, -2.039156560464668e-28,  7.529848607436566e-01, -2.649484761495006e-03,  3.106530717974170e-06,
  9.527873732224785e-09, -3.929044640435593e-11, -2.345291863392063e-14,  4.577820516996473e-16, -5.707768966790978e-19, -4.488122424912162e-21,  1.587162455848501e-23,
  2.804017382178563e-26, -2.703177728647997e-28,  8.224964998768796e-01, -2.751093263215525e-03,  2.445996480922772e-06,  1.203785415094437e-08, -3.439054144275857e-11,
 -6.990411949327102e-14,  4.696705599739347e-16,  1.344938208977302e-19, -6.023766840646490e-21,  7.453101334065162e-24,  6.928036247029792e-26, -2.120396757165315e-28,
  8.933875421458359e-01, -2.827665084755032e-03,  1.681926225036761e-06,  1.409907036919758e-08, -2.611748102151529e-11, -1.129369924396012e-13,  4.021638097798307e-16,
  9.201057411351978e-19, -6.079717821260879e-21, -5.375232218539577e-24,  8.921916705805189e-26, -2.706225999214900e-29,  9.653242793821121e-01, -2.876859539183467e-03,
  8.360407500560612e-07,  1.554467875701502e-08, -1.494640350064511e-11, -1.460883776327255e-13,  2.569276920026539e-16,  1.603536253525919e-18, -4.366096462388213e-21,
 -1.853586546738840e-23,  7.362348866357763e-26,  2.129166480245778e-28,  1.037953388850335e+00, -2.896777009824782e-03, -6.479335339215994e-08,  1.623669499927392e-08,
 -1.724961128430974e-12, -1.635657964084918e-13,  5.206441803045080e-17,  1.998118345597600e-18, -1.134652242837894e-21, -2.693919077917088e-23,  2.262217640640118e-26,
  3.853343691097189e-28,  1.110902485232758e+00, -2.886041237743392e-03, -9.893230419078398e-07,  1.608047729065044e-08,  1.237858571339325e-11, -1.613289805438790e-13,
 -1.791450110331845e-16,  1.966231315444458e-18,  2.798887875352388e-21, -2.649437303936167e-23, -4.580407578561305e-26,  3.794032456342399e-28,  1.183781007912456e+00,
 -2.843879457174181e-03, -1.903007634803938e-06,  1.503758073386610e-08,  2.597806498464983e-11, -1.380453591799629e-13, -3.934279564981693e-16,  1.468609595971084e-18,
  6.244506717252735e-21, -1.615017046852806e-23, -1.013706688333885e-25,  1.687472012452320e-28,  1.256181495944523e+00, -2.770197094344616e-03, -2.769456239335955e-06,
  1.313540327556946e-08,  3.761841958745323e-11, -9.570248408364752e-14, -5.461748008618155e-16,  5.924455508575914e-19,  8.016013797072497e-21,  1.040535243419758e-24,
 -1.153911279584907e-25, -1.531545740031012e-28,  1.327681302186995e+00, -2.665643136658201e-03, -3.552177457977802e-06,  1.047200744392626e-08,  4.595808381243443e-11,
 -3.967909607352541e-14, -6.019949396093968e-16, -4.562512814950869e-19,  7.384429628102258e-21,  1.862479342499984e-23, -7.690673840438133e-26, -4.101835770985224e-28,
  1.397844794419504e+00, -2.531661746283003e-03, -4.216583965213859e-06,  7.214666208558860e-09,  4.996294567396959e-11,  2.185158717036734e-14, -5.446440425754309e-16,
 -1.401304875149499e-18,  4.428095613098093e-21,  2.928218475693805e-23, -1.670586362233540e-27, -4.456646621714626e-28,  1.466226084255827e+00, -2.370525309038746e-03,
 -4.732159393365930e-06,  3.591093895220316e-09,  4.908279023612107e-11,  7.918778636482823e-14, -3.833444734938394e-16, -1.977070222011576e-18,  1.017473046635302e-22,
  2.824378182829471e-23,  7.330912912294150e-26, -2.298980353332585e-28,  1.532372313654563e+00, -2.185343963357762e-03, -5.074658563147644e-06, -1.269926993315818e-10,
  4.337730615985886e-11,  1.228735191634802e-13, -1.529271647109432e-16, -2.017437960217413e-18, -4.063178274065476e-21,  1.590946741723434e-23,  1.091377633227275e-25,
  1.060523526882644e-28,  1.595827513383923e+00, -1.980046839072622e-03, -5.228178580100880e-06, -3.647401546092737e-09,  3.356052969751708e-11,  1.456552362046113e-13,
  9.337132862569856e-17, -1.520518311446189e-18, -6.553627282269548e-21, -1.948675188435653e-24,  8.808582351447698e-26,  3.494596508790085e-28,  1.656137027676450e+00,
 -1.759330842376808e-03, -5.186913038104995e-06, -6.686388540873952e-09,  2.094147558443914e-11,  1.441743671157526e-13,  2.974179595263605e-16, -6.594260704582768e-19,
 -6.526561845222740e-21, -1.689613940267531e-23,  2.535312814129210e-26,  3.533440630633435e-28,  1.712852474649432e+00, -1.528573923950689e-03, -4.956390610597805e-06,
 -9.000141633081471e-09,  7.254843421697416e-12,  1.199262052048672e-13,  4.125618764781138e-16,  2.731565371032507e-19, -4.202228634333451e-21, -2.224866563342215e-23,
 -4.000121540394610e-26,  1.429534217886626e-28,  1.765537183472075e+00, -1.293711398447129e-03, -4.554008654641374e-06, -1.041501984944454e-08, -5.602638504495865e-12,
  7.912661055020407e-14,  4.177624556460874e-16,  9.718325816096505e-19, -7.681831966529806e-22, -1.669612788510425e-23, -7.054662809043890e-26, -1.088309207155179e-28,
  1.813772017905882e+00, -1.061076026835943e-03, -4.008706794966548e-06, -1.085217867643224e-08, -1.589135204051528e-11,  3.137578698734666e-14,  3.242793312653399e-16,
  1.236021050534033e-18,  2.201373113331126e-21, -4.818574769750814e-24, -5.495405257365572e-26, -2.231927449684230e-28,  1.857161463534402e+00, -8.372051383574889e-04,
 -3.359686784547320e-06, -1.034228492067438e-08, -2.234522388206565e-11, -1.265381398508511e-14,  1.717443010726842e-16,  1.046559646743412e-18,  3.530245132291545e-21,
  5.993486971652045e-24, -1.319491611157375e-26, -1.548896959982918e-28,  1.895339825199017e+00, -6.286208840745498e-04, -2.654171191722884e-06, -9.026881572274209e-09,
 -2.441820703705500e-11, -4.394536330931978e-14,  1.414539801613095e-17,  5.633091649813462e-19,  2.999880757565963e-21,  1.026011644465033e-23,  2.149317129796904e-26,
 -7.595256425577865e-30,  1.927977355138371e+00, -4.415925258952400e-04, -1.944297614547881e-06, -7.144619903611890e-09, -2.239968934373168e-11, -5.751276144259177e-14,
 -9.961808110432640e-17,  4.129342053213952e-20,  1.356786311404793e-21,  7.547280941928558e-24,  2.885404306379247e-26,  8.111948450530297e-29,  1.954786116266673e+00,
 -2.818921480131565e-04, -1.283355102940004e-06, -5.002861239472648e-09, -1.736063176644867e-11, -5.367291096248392e-14, -1.432149446513329e-16, -2.953668962277730e-19,
 -2.345706151699406e-22,  1.862532726946019e-24,  1.413559346649547e-26,  6.577674342633058e-29,  1.975525394196343e+00, -1.545569145805983e-04, -7.216690537305198e-07,
 -2.937702465456521e-09, -1.092871837213710e-11, -3.774663207037552e-14, -1.211868179013080e-16, -3.576386475174962e-19, -9.403504400571348e-22, -2.020025121378313e-24,
 -2.373156372151078e-27,  7.538367275317112e-30,  1.990006610685168e+00, -6.367101675856049e-05, -3.025095874088740e-07, -1.267783502234087e-09, -4.932617340032553e-12,
 -1.820215167446564e-14, -6.434065740466000e-17, -2.187617088703953e-19, -7.157462312749922e-22, -2.246863707687503e-24, -6.719531428135615e-27, -1.887683502650596e-29,
  1.998099655128422e+00, -1.216765689815412e-05, -5.836865956544586e-08, -2.485329180702056e-10, -9.903531320231434e-13, -3.780435364740025e-15, -1.399497460497434e-17,
 -5.060484094063584e-20, -1.795306713512235e-22, -6.267070122252360e-25, -2.156704677773814e-27, -7.325554501437819e-30,  5.354351002820499e-04, -2.788137220572222e-06,
  1.088619447396874e-08, -3.777071859039421e-11,  1.228088717208177e-13, -3.831546406741505e-16,  1.161547311831445e-18, -3.447248345647552e-21,  1.006348490122943e-23,
 -2.899243619015054e-26,  8.261504221323580e-29, -2.332421243832912e-31,  4.816834989319004e-03, -2.503929748185633e-05,  9.741519398905036e-08, -3.359323333066983e-10,
  1.082132111340030e-12, -3.331783208222038e-15,  9.921020784473402e-18, -2.876120831678198e-20,  8.148545298765078e-23, -2.261062866596394e-25,  6.150330347049490e-28,
 -1.640040278799815e-30,  1.336852206228528e-02, -6.925419333090281e-05,  2.674963255423114e-07, -9.111052975756847e-10,  2.879455530106473e-12, -8.624317172405441e-15,
  2.471460317733302e-17, -6.801442567042194e-20,  1.796814930497892e-22, -4.537933550366763e-25,  1.085278986127980e-27, -2.411622478771610e-30,  2.616820133586993e-02,
 -1.348591487457536e-04,  5.152371857523307e-07, -1.721968930965505e-09,  5.282243149901957e-12, -1.513209166900020e-14,  4.063403296290810e-17, -1.016618051450170e-19,
  2.324840681218346e-22, -4.634084727379681e-25,  6.931464154308852e-28, -1.544584028418209e-31,  4.318225655954801e-02, -2.209966364422813e-04,  8.319527371471519e-07,
 -2.708970105518174e-09,  7.966413666284377e-12, -2.135626578514161e-14,  5.159202659512034e-17, -1.077082183967506e-19,  1.694277731023673e-22, -6.029618222515790e-26,
 -9.832978409788456e-28,  5.556175695399309e-30,  6.436554215324763e-02, -3.265290118920247e-04,  1.206350204919185e-06, -3.797174945280261e-09,  1.054446581334372e-11,
 -2.563940231026215e-14,  5.163388807411786e-17, -6.868052056813027e-20, -4.583571366779791e-23,  7.637424191201251e-25, -3.517977929068571e-27,  1.180093911480501e-29,
  8.966110665700074e-02, -4.500437427008614e-04,  1.624776472251633e-06, -4.899965429634212e-09,  1.260042822130783e-11, -2.641318249050763e-14,  3.634714197732816e-17,
  2.177643092227182e-20, -3.905553809170402e-22,  1.761386518517846e-24, -5.573457641774295e-27,  1.311700114371402e-29,  1.189998486086166e-01, -5.898603496393635e-04,
  2.071528391730483e-06, -5.923485095590548e-09,  1.372949178237724e-11, -2.245539556392404e-14,  4.127429625348900e-18,  1.543799790726551e-19, -7.749522120268807e-22,
  2.467271937181866e-24, -5.380576000258291e-27,  4.578908085068481e-30,  1.523001062173157e-01, -7.440393309239911e-04,  2.529226116412963e-06, -6.771707971054389e-09,
  1.357971596788594e-11, -1.312598095777099e-14, -4.294296996551361e-17,  3.032048690885284e-19, -1.057166830877383e-21,  2.350177072907501e-24, -1.649559610354132e-27,
 -1.416896730945723e-29,  1.894671828105759e-01, -9.103933966138574e-04,  2.979248943959592e-06, -7.351971462496872e-09,  1.189280067690630e-11,  1.449134410688382e-15,
 -9.881508587082360e-17,  4.290389691957532e-19, -1.080869679956289e-21,  1.043622650918438e-24,  5.448568823719326e-27, -3.627694019318224e-29,  2.303928108380826e-01,
 -1.086501394270844e-03,  3.402232186913259e-06, -7.580777321150438e-09,  8.540615241611235e-12,  2.027587649690252e-14, -1.539343426672367e-16,  4.870768361594294e-19,
 -7.282204603971481e-22, -1.421896614510840e-24,  1.373229782264484e-26, -4.873226480312952e-29,  2.749545582645589e-01, -1.269725358804056e-03,  3.778622153564845e-06,
 -7.389625739891169e-09,  3.554018591879195e-12,  4.149598217488873e-14, -1.964835676580744e-16,  4.379019429979199e-19,  2.561495692914677e-23, -4.483117315270897e-24,
  1.933373662380929e-26, -3.791776488098600e-29,  3.230151825203004e-01, -1.457231166409798e-03,  4.089284367594885e-06, -6.730607546360034e-09, -2.859459546897864e-12,
  6.251295244809902e-14, -2.143206036446372e-16,  2.596978761006867e-19,  1.074099141372757e-21, -7.092086285300439e-24,  1.804641379329043e-26,  1.929801250309135e-30,
  3.744219388559886e-01, -1.646013311528293e-03,  4.316157595919453e-06, -5.581440750912784e-09, -1.031221942432842e-11,  8.024375864861961e-14, -1.973819882858366e-16,
 -4.114656430766138e-20,  2.174376304182958e-21, -7.987667133942670e-24,  7.383357049115788e-27,  6.140476146251057e-29,  4.290058520207873e-01, -1.832924352456177e-03,
  4.442943031044479e-06, -3.949603911044897e-09, -1.825001876265882e-11,  9.148474391640210e-14, -1.401890341171432e-16, -4.241769524223862e-19,  2.987074679027783e-21,
 -6.151288427118295e-24, -1.144202534112084e-26,  1.147796404026324e-28,  4.865809627043652e-01, -2.014709580060689e-03,  4.455814050610322e-06, -1.875194726497564e-09,
 -2.598380800572833e-11,  9.336254883812556e-14, -4.398846260248197e-17, -8.165174131956778e-19,  3.160848079378155e-21, -1.318368683499716e-24, -3.265864528374788e-26,
  1.283848987662861e-28,  5.469435632061225e-01, -2.188047447843099e-03,  4.344127359703841e-06,  5.678657717887197e-10, -3.274018763648535e-11,  8.382255263828216e-14,
  8.198501932818797e-17, -1.123593948402319e-18,  2.446684090801100e-21,  5.651127853627404e-24, -4.708075710425741e-26,  7.747752048974364e-29,  6.098714403629123e-01,
 -2.349596251712619e-03,  4.101111083878738e-06,  3.272647522770367e-09, -3.772892721520122e-11,  6.209060067853167e-14,  2.205940149023530e-16, -1.248549755825678e-18,
  8.120595259677916e-22,  1.274982652053123e-23, -4.543881589950338e-26, -3.516504951111862e-29,  6.751231479101912e-01, -2.496047453983942e-03,  3.724499689722820e-06,
  6.102360471790130e-09, -4.022385020511862e-11,  2.903178066339397e-14,  3.485494282854732e-16, -1.117475620281362e-18, -1.484788835518259e-21,  1.727971328571786e-23,
 -2.301281556812247e-26, -1.697428097936146e-28,  7.424373351778879e-01, -2.624185896611734e-03,  3.217079759116113e-06,  8.896065351626478e-09, -3.965101321394684e-11,
 -1.267362436135143e-14,  4.398769263104686e-16, -7.050613976993268e-19, -3.899397140429045e-21,  1.675814072792199e-23,  1.636939486074168e-26, -2.588401898897795e-28,
  8.115321643035901e-01, -2.730956930866607e-03,  2.587105088487564e-06,  1.147703417100962e-08, -3.567570931819228e-11, -5.860835149049300e-14,  4.707817805615317e-16,
 -5.345764751314110e-20, -5.707898723673078e-21,  1.002941835525052e-23,  5.934855838014463e-26, -2.377032403590692e-28,  8.821048539046690e-01, -2.813540191747077e-03,
  1.848534974591136e-06,  1.366365353750682e-08, -2.827772904321129e-11, -1.029980439890465e-13,  4.251788581796330e-16,  7.231440352223245e-19, -6.209433839295599e-21,
 -1.847609936135050e-24,  8.674311300972818e-26, -8.453480080463226e-29,  9.538313932436174e-01, -2.869429353827467e-03,  1.021046748348109e-06,  1.528251216822488e-08,
 -1.780295572164385e-11, -1.393997084703812e-13,  2.997745329645199e-16,  1.453730148451762e-18, -4.978282225737767e-21, -1.542133949547013e-23,  8.165468030241002e-26,
  1.514348287067446e-28,  1.026366477116701e+00, -2.896516712566202e-03,  1.297737085977192e-07,  1.618301192265715e-08, -4.979274845511411e-12, -1.616498745617712e-13,
  1.073590478100531e-16,  1.946499895116853e-18, -2.084152808483692e-21, -2.570240671716549e-23,  3.901421701727650e-26,  3.575125666048070e-28,  1.099343717657664e+00,
 -2.893180838837525e-03, -7.952761524681672e-07,  1.625250730928566e-08,  9.113519234863943e-12, -1.649585794393169e-13, -1.229823488921489e-16,  2.040214623149294e-18,
  1.816226139771545e-21, -2.798282682420712e-23, -2.840182360573650e-26,  4.091449078395755e-28,  1.172376194512560e+00, -2.858374861434742e-03, -1.720155504371916e-06,
  1.543064386635076e-08,  2.312618021503852e-11, -1.469721619884186e-13, -3.496022420008666e-16,  1.658364645992397e-18,  5.592114424626797e-21, -2.003335908529724e-23,
 -9.222533593648401e-26,  2.460456816986256e-28,  1.245057408805857e+00, -2.791712162756797e-03, -2.608285485764183e-06,  1.372127954127460e-08,  3.557478145325713e-11,
 -1.085826292310225e-13, -5.259959406264257e-16,  8.486547121805364e-19,  7.968976962072715e-21, -3.686732879695738e-24, -1.203821790997352e-25, -7.218448047886163e-29,
  1.316962708235539e+00, -2.693545464797831e-03, -3.422130134329392e-06,  1.120019927276034e-08,  4.501912887667507e-11, -5.425297551462354e-14, -6.113653887826842e-16,
 -2.098502063592081e-19,  7.995272488014937e-21,  1.519580977988966e-23, -9.430538870695957e-26, -3.776329513748245e-28,  1.387651249629230e+00, -2.565034495570310e-03,
 -4.125199442185423e-06,  8.016846337571953e-09,  5.026617156852793e-11,  8.326276321660337e-15, -5.817386349707271e-16, -1.242791299484932e-18,  5.476209622164505e-21,
  2.881062785579950e-23, -2.219317766089621e-26, -4.848647322974148e-28,  1.456668560394793e+00, -2.408196744135393e-03, -4.684303725453639e-06,  4.388569900760388e-09,
  5.057006525478038e-11,  6.932455054228239e-14, -4.385000885582643e-16, -1.957001220280292e-18,  1.168641231686014e-21,  3.094888811350294e-23,  6.132630140081947e-26,
 -3.149468107934572e-28,  1.523549750514051e+00, -2.225935343509487e-03, -5.071937856688504e-06,  5.864850820008491e-10,  4.579342489771580e-11,  1.185112751429418e-13,
 -2.111435753942423e-16, -2.137445321572652e-18, -3.410914518303780e-21,  2.034823414910115e-23,  1.122774678452275e-25,  3.424187819976003e-29,  1.587823411147877e+00,
 -2.022037992410162e-03, -5.268629101526036e-06, -3.087021379199849e-09,  3.649247234663368e-11,  1.473615162574413e-13,  4.785526663502158e-17, -1.730646821844746e-18,
 -6.556668424728787e-21,  1.880278140667362e-24,  1.032847364281381e-25,  3.388295665240029e-28,  1.649016213866390e+00, -1.801141175618405e-03, -5.265042925754280e-06,
 -6.327875909216357e-09,  2.389472333329295e-11,  1.510666766712211e-13,  2.759402639457685e-16, -8.777811881296966e-19, -7.112684914018416e-21, -1.555609219763045e-23,
  4.201331426338012e-26,  4.032810121924646e-28,  1.706658195723705e+00, -1.568654896521625e-03, -5.063614944843152e-06, -8.864335647328340e-09,  9.752920184224381e-12,
  1.299035247823303e-13,  4.182051262106357e-16,  1.255745665430780e-19, -5.030300051964095e-21, -2.370461069469251e-23, -3.232744157168403e-26,  2.072805565233051e-28,
  1.760288680209974e+00, -1.330644788697270e-03, -4.679472732796470e-06, -1.049144785102053e-08, -3.917655972044931e-12,  8.947609240746277e-14,  4.445353274548774e-16,
  9.370802100069346e-19, -1.421122560441545e-21, -1.960604933389966e-23, -7.473891489477236e-26, -7.989598132332815e-29,  1.809462743688369e+00, -1.093670857722415e-03,
 -4.140436398612973e-06, -1.110098541498705e-08, -1.518316556322235e-11,  3.958157824118958e-14,  3.598449201272776e-16,  1.303245701593212e-18,  1.985920014147134e-21,
 -7.218674961907127e-24, -6.518175751163283e-26, -2.411221730608807e-28,  1.853758093374736e+00, -8.645851579393291e-04, -3.485946943375924e-06, -1.070159896303019e-08,
 -2.255464112735240e-11, -8.167345967285127e-15,  2.026611513544887e-16,  1.162863944269663e-18,  3.734776226522398e-21,  5.319259858053897e-24, -2.077496109069292e-26,
 -1.903832945725319e-28,  1.892782179416178e+00, -6.502942523257963e-04, -2.764866847523095e-06, -9.424580135105186e-09, -2.529238429094562e-11, -4.340540710545893e-14,
  3.131870672087360e-17,  6.653801545548770e-19,  3.384594148816883e-21,  1.110810861863066e-23,  2.077233020390581e-26, -2.602402296215738e-29,  1.926179324564048e+00,
 -4.574960295435381e-04, -2.032221801483763e-06, -7.512346392245004e-09, -2.357373280803741e-11, -5.988455546894248e-14, -9.781155008710772e-17,  8.928765808385092e-20,
  1.650139752120739e-21,  8.774598273028422e-24,  3.255411985773945e-26,  8.691816834887563e-29,  1.953637626999930e+00, -2.924039310781727e-04, -1.345092095242425e-06,
 -5.289408592097847e-09, -1.846913557061142e-11, -5.721009511774508e-14, -1.515794135153178e-16, -3.016853394767049e-19, -1.566122438552439e-22,  2.489388307430718e-24,
  1.729835191974549e-26,  7.829728702113918e-29,  1.974895392294187e+00, -1.604743077589120e-04, -7.579960744020622e-07, -3.118762914914707e-09, -1.171356483503141e-11,
 -4.077875042461420e-14, -1.316330359419450e-16, -3.889110017845719e-19, -1.014689911900633e-21, -2.107185975976012e-24, -1.954962216062781e-27,  1.165098136560977e-29,
  1.989746988181888e+00, -6.615331696075186e-05, -3.182088117000157e-07, -1.349703754310530e-09, -5.312611982764869e-12, -1.982249616004311e-14, -7.079917904831802e-17,
 -2.430133229026178e-19, -8.016779290644640e-22, -2.532960174606418e-24, -7.603189443931683e-27, -2.133447205762082e-29,  1.998050031325750e+00, -1.264681099806432e-05,
 -6.144868403011975e-08, -2.650021809984000e-10, -1.069438850754388e-12, -4.133988622776728e-15, -1.549585409197208e-17, -5.672810731501687e-20, -2.037259086026778e-22,
 -7.197846766289650e-25, -2.506554357136025e-27, -8.613506165034103e-30,  5.244539063396970e-04, -2.702827827974442e-06,  1.044448743876190e-08, -3.586559890291932e-11,
  1.154169159583484e-13, -3.564003331619582e-16,  1.069380325846554e-18, -3.141298218924142e-21,  9.076848326663797e-24, -2.588418689093813e-26,  7.301001848317732e-29,
 -2.040424955821405e-31,  4.718211320604155e-03, -2.427581132360612e-05,  9.348573286595081e-08, -3.191386364277378e-10,  1.017813753234450e-12, -3.103055178865868e-15,
  9.151021798661808e-18, -2.627930059584614e-20,  7.377159578457811e-23, -2.028896670879134e-25,  5.472000141306696e-28, -1.447480067863121e-30,  1.309571707485541e-02,
 -6.715718547169157e-05,  2.568339003059756e-07, -8.663823079974113e-10,  2.712749729610171e-12, -8.053384615397808e-15,  2.288829918902478e-17, -6.251782808527816e-20,
  1.641013642404379e-22, -4.124383547920255e-25,  9.840728996956506e-28, -2.191674312966528e-30,  2.563687966470472e-02, -1.308184916595565e-04,  4.950708357723438e-07,
 -1.639822141346569e-09,  4.989127195403856e-12, -1.419020780592996e-14,  3.788918537086359e-17, -9.448390401458961e-20,  2.162982529100731e-22, -4.358767945447639e-25,
  6.820965000413674e-28, -3.387677563614729e-31,  4.231137839269454e-02, -2.144689102751341e-04,  8.001959916069655e-07, -2.584858227768772e-09,  7.551429311528900e-12,
 -2.015363672298521e-14,  4.865172236263249e-17, -1.023283905087757e-19,  1.666054233065976e-22, -9.502534449966967e-26, -7.599759829810636e-28,  4.620017376075474e-30,
  6.307844312190297e-02, -3.170576450930498e-04,  1.161779668596916e-06, -3.632499122550781e-09,  1.004391338062795e-11, -2.442340693453581e-14,  4.969424459609908e-17,
 -6.973351718352768e-20, -2.075277490078775e-23,  6.329730914965677e-25, -3.030972453756955e-27,  1.036133594019622e-29,  8.788656049840211e-02, -4.372773417861705e-04,
  1.567169249542044e-06, -4.702537107979510e-09,  1.208093021893567e-11, -2.553488937040891e-14,  3.679114555598401e-17,  1.025130374235477e-20, -3.310216151781262e-22,
  1.549732158864295e-24, -5.015753545646026e-27,  1.222606070357766e-29,  1.166731067066365e-01, -5.735687494584814e-04,  2.001749802564329e-06, -5.707399287875842e-09,
  1.328171044858872e-11, -2.230718721073840e-14,  8.115949565125353e-18,  1.309615342493453e-19, -6.899526781919975e-22,  2.256424312944567e-24, -5.153985355319219e-27,
  5.653946533369764e-30,  1.493639070495419e-01, -7.241268905938037e-04,  2.449260436678270e-06, -6.556585851422509e-09,  1.330755827823817e-11, -1.405848042407285e-14,
 -3.491422271903319e-17,  2.707153491163671e-19, -9.738876960038115e-22,  2.272890292080847e-24, -2.187209828366775e-27, -1.038235353962541e-29,  1.858727230261020e-01,
 -8.869090634650794e-04,  2.892167545300288e-06, -7.161579630439960e-09,  1.189902075814746e-11, -7.821428378720556e-16, -8.728029396733366e-17,  3.950913065624132e-19,
 -1.039745858008997e-21,  1.231294514300645e-24,  3.974969618337439e-27, -3.079277032241201e-29,  2.261006681555276e-01, -1.059645061501580e-03,  3.312095502537023e-06,
 -7.441079478400952e-09,  8.910279423353300e-12,  1.674243323436801e-14, -1.406293974431006e-16,  4.630566592554594e-19, -7.700274127158559e-22, -9.142961993748725e-25,
  1.167768524730114e-26, -4.462146037979453e-29,  2.699355546180729e-01, -1.239850055488013e-03,  3.690314399263270e-06, -7.326374131210503e-09,  4.337775205791432e-12,
  3.692746035610475e-14, -1.842340553065226e-16,  4.362853091617240e-19, -1.222634983040331e-22, -3.743603547385553e-24,  1.763285178343151e-26, -3.917202666085078e-29,
  3.172511739033408e-01, -1.424840645187749e-03,  4.008282929097427e-06, -6.766633761557798e-09, -1.660029358209225e-12,  5.746016946019913e-14, -2.066052556825660e-16,
  2.901233192488831e-19,  8.317719188386591e-22, -6.371356430677796e-24,  1.792400324908123e-26, -7.145680528337461e-30,  3.679065161407212e-01, -1.611754644543754e-03,
  4.248242460245790e-06, -5.733854900071788e-09, -8.754769733886875e-12,  7.550036469069968e-14, -1.976027651310756e-16,  2.389458865376829e-20,  1.892745472493486e-21,
 -7.642882978854206e-24,  9.745283891302599e-27,  4.622636269959658e-29,  4.217449347033707e-01, -1.797575215350793e-03,  4.393855559511560e-06, -4.227153305208306e-09,
 -1.645487634241364e-11,  8.798827736903463e-14, -1.507616438888978e-16, -3.322124099504688e-19,  2.758568920863965e-21, -6.512170118471561e-24, -6.706980318557556e-27,
  1.003836101766871e-28,  4.785932651029338e-01, -1.979160003097811e-03,  4.430878681053131e-06, -2.276062575991953e-09, -2.412890726959971e-11,  9.204385291598554e-14,
 -6.544375900362502e-17, -7.163707774910264e-19,  3.091226532159026e-21, -2.512601277083253e-24, -2.708040996115857e-26,  1.246319867535125e-28,  5.382609102068633e-01,
 -2.153275948687054e-03,  4.347854331302909e-06,  5.753075133051917e-11, -3.104656201561125e-11,  8.542168790000468e-14,  5.164853584416057e-17, -1.042401520622179e-18,
  2.617090682528936e-21,  3.840678540058513e-24, -4.333718363971773e-26,  9.183502907911845e-29,  6.005389074934196e-01, -2.316640442040892e-03,  4.136802756386393e-06,
  2.679195009974587e-09, -3.643698741930273e-11,  6.696869222995101e-14,  1.860649108188718e-16, -1.215573190229200e-18,  1.238051551985531e-21,  1.091083877563610e-23,
 -4.628250833779304e-26, -3.860886450466162e-30,  6.651989984845630e-01, -2.465969437022735e-03,  3.793887129728261e-06,  5.463867734202539e-09, -3.956212249663209e-11,
  3.701669422778815e-14,  3.166870951381755e-16, -1.155227395223414e-18, -8.809938609636930e-22,  1.622021273642228e-23, -2.970414036313076e-26, -1.343333877496164e-28,
  7.319927257218191e-01, -2.598033048049122e-03,  3.320019520580077e-06,  8.260188001132724e-09, -3.980058480983807e-11, -2.367017564971522e-15,  4.184797456870782e-16,
 -8.200850291478606e-19, -3.287017692632422e-21,  1.719019307645182e-23,  5.370391461671910e-27, -2.400321486911756e-28,  8.006505887042323e-01, -2.709718981411682e-03,
  2.721367935240588e-06,  1.089745850930136e-08, -3.673511515810365e-11, -4.734784080186714e-14,  4.667852534324407e-16, -2.298960779431975e-19, -5.306678564789271e-21,
  1.218891680242256e-23,  4.851444467804790e-26, -2.530757306822118e-28,  8.708812970744642e-01, -2.798103901045223e-03,  2.009717990136263e-06,  1.319529109882497e-08,
 -3.023412312249495e-11, -9.257326602429797e-14,  4.426397931243285e-16,  5.240393733626379e-19, -6.214531113952543e-21,  1.532238045299452e-24,  8.187948704930539e-26,
 -1.352826040542628e-28,  9.423711669347953e-01, -2.860532470941059e-03,  1.202637110078470e-06,  1.497576533861239e-08, -2.051580207105752e-11, -1.317351579539852e-13,
  3.381698106362766e-16,  1.286184709248455e-18, -5.473224360158784e-21, -1.204070608853535e-23,  8.690846065814673e-26,  8.715199548982299e-29,  1.014783714319949e+00,
 -2.894703337394743e-03,  3.233856561341326e-07,  1.607763792565224e-08, -8.182134038569532e-12, -1.584276131926705e-13,  1.607905653905575e-16,  1.865333731467768e-18,
 -2.977657476551714e-21, -2.383830694344618e-23,  5.389505382827583e-26,  3.169444359444030e-28,  1.087759508242250e+00, -2.898760700511272e-03, -5.994805057217235e-07,
  1.637178940435916e-08,  5.789489055077534e-12, -1.672190140071191e-13, -6.519547076962833e-17,  2.082032043926256e-18,  7.927843365623714e-22, -2.875350848574509e-23,
 -1.002866141521361e-26,  4.233584464300046e-28,  1.160916353889972e+00, -2.871389370522802e-03, -1.532866099027816e-06,  1.577670746520188e-08,  2.010669519486630e-11,
 -1.547858754860893e-13, -3.007761323001482e-16,  1.825083572615505e-18,  4.807314920564271e-21, -2.348460162309607e-23, -7.982671815366964e-26,  3.160230474961790e-28,
  1.233849883841857e+00, -2.811910318343998e-03, -2.440288815272396e-06,  1.427242552086801e-08,  3.327896287418853e-11, -1.208927239897463e-13, -4.986901139395516e-16,
  1.100604378896486e-18,  7.749046497490136e-21, -8.539914373066336e-24, -1.216317275480491e-25,  1.633637870940485e-29,  1.306134640681432e+00, -2.720372738756114e-03,
 -3.283444300248249e-06,  1.191102616681589e-08,  4.378701719609208e-11, -6.896686495539078e-14, -6.135824477157503e-16,  5.399155319797569e-20,  8.470539298039114e-21,
  1.110492838529545e-23, -1.098683094613869e-25, -3.267944949769037e-28,  1.377325737048813e+00, -2.597637602414723e-03, -4.024168727028823e-06,  8.821667236791921e-09,
  5.029036755243368e-11, -6.032275631934738e-15, -6.139289920793074e-16, -1.051171242406050e-18,  6.492195177633708e-21,  2.748806194176057e-23, -4.410628813754221e-26,
 -5.083168349992777e-28,  1.446961177642996e+00, -2.445446665959833e-03, -4.626742309094470e-06,  5.208192527528572e-09,  5.184690403319539e-11,  5.814826752511446e-14,
 -4.926018650259654e-16, -1.901333304687039e-18,  2.323388921825183e-21,  3.309983314725831e-23,  4.560829821953026e-26, -3.989930504393571e-28,  1.514564920526967e+00,
 -2.266470061021051e-03, -5.060426597457053e-06,  1.337845791757943e-09,  4.810806745861530e-11,  1.127140217382930e-13, -2.724038196711795e-16, -2.234005710346654e-18,
 -2.597394827683210e-21,  2.484515240141215e-23,  1.119423832767579e-25, -5.168828060614081e-29,  1.579650740807818e+00, -2.064325051984685e-03, -5.302072666031869e-06,
 -2.479518477006636e-09,  3.944714066930428e-11,  1.479049281797134e-13, -3.524203918627056e-18, -1.938551033690655e-18, -6.411079984075146e-21,  6.303048410161310e-24,
  1.176535956523769e-25,  3.113071325326023e-28,  1.641726937039738e+00, -1.843558525787610e-03, -5.338582697607569e-06, -5.921038667217966e-09,  2.698015664968318e-11,
  1.573680840708463e-13,  2.480942357508259e-16, -1.113987542867826e-18, -7.638053942810517e-21, -1.350711709060406e-23,  6.075805528052257e-26,  4.475153795061655e-28,
  1.700301888618908e+00, -1.609586450396190e-03, -5.168963186992145e-06, -8.686958162894438e-09,  1.245154732997655e-11,  1.399636543323418e-13,  4.193376803650955e-16,
 -4.927938625048627e-20, -5.904555550997430e-21, -2.479451714514488e-23, -2.163967245700424e-26,  2.797808481669280e-28,  1.754890430821151e+00, -1.368585085845267e-03,
 -4.805685245909688e-06, -1.053922567772598e-08, -2.019349748481904e-12,  1.004539874751578e-13,  4.700266521947008e-16,  8.797279910910194e-19, -2.181499944831547e-21,
 -2.265479420003634e-23, -7.740027094572536e-26, -3.894484687264043e-29,  1.805020963853112e+00, -1.127331262757556e-03, -4.275078129456342e-06, -1.133710124086497e-08,
 -1.430217942959357e-11,  4.866266933523250e-14,  3.971827153487494e-16,  1.362112962857516e-18,  1.676519754003565e-21, -1.004247792974781e-23, -7.610626859002665e-26,
 -2.545242601916266e-28,  1.850243155595245e+00, -8.929925557404131e-04, -3.616535880050009e-06, -1.106350441064047e-08, -2.266664147083013e-11, -2.899080311021340e-15,
  2.369220677028026e-16,  1.285263232284739e-18,  3.909189432036807e-21,  4.309313456504129e-24, -3.001227933806413e-26, -2.301832613177918e-28,  1.890136038470338e+00,
 -6.728725121595204e-04, -2.880418375466398e-06, -9.836155749908541e-09, -2.615140202129864e-11, -4.241757654891274e-14,  5.152689474337985e-17,  7.802431708391584e-19,
  3.799106394331444e-21,  1.190944932307185e-23,  1.911911872187831e-26, -5.014960186214231e-29,  1.924316244785364e+00, -4.741209004860742e-04, -2.124672970913558e-06,
 -7.899234231112278e-09, -2.479466407530474e-11, -6.219576406224670e-14, -9.452290937809951e-17,  1.474051866108979e-19,  1.990399440480670e-21,  1.015471422487459e-23,
  3.648527230912736e-26,  9.151918438160772e-29,  1.952446080598609e+00, -3.034236713152298e-04, -1.410376442166152e-06, -5.594268917125985e-09, -1.965040331199858e-11,
 -6.094984587322527e-14, -1.600823004113087e-16, -3.051225179467154e-19, -5.367192464132781e-23,  3.254345668418327e-24,  2.105525506221724e-26,  9.281856180173361e-29,
  1.974241125518823e+00, -1.666912261812280e-04, -7.965732118756567e-07, -3.312879971169171e-09, -1.256163308414938e-11, -4.407235710915379e-14, -1.429886305342266e-16,
 -4.226088212900446e-19, -1.091819383361574e-21, -2.173657704593421e-24, -1.329732984495520e-27,  1.699573579411658e-29,  1.989477178915035e+00, -6.876524900672443e-05,
 -3.349286558544943e-07, -1.437971834290657e-09, -5.726620210245026e-12, -2.160631420233887e-14, -7.797684152506913e-17, -2.701865810513527e-19, -8.985721363666834e-22,
 -2.856647450294369e-24, -8.601127886564099e-27, -2.407433996594077e-29,  1.997998440343530e+00, -1.315141788004030e-05, -6.473417172695150e-08, -2.827954010025939e-10,
 -1.155970198951175e-12, -4.525711091496963e-15, -1.717954815769345e-17, -6.368204976591476e-20, -2.315381128543687e-22, -8.280586458609822e-25, -2.918305453789775e-27,
 -1.014675314385912e-29,  5.138070246584064e-04, -2.620962616625372e-06,  1.002494948838786e-08, -3.407458715443457e-11,  1.085386021553992e-13, -3.317587009460499e-16,
  9.853542376091368e-19, -2.865201820816868e-21,  8.195491828784840e-24, -2.313563284037393e-26,  6.460192169555776e-29, -1.787379737739464e-31,  4.622579977217343e-03,
 -2.354297191022545e-05,  8.975176931441686e-08, -3.033384177368087e-10,  9.578906439798244e-13, -2.892000343525195e-15,  8.447182429651418e-18, -2.403137106924157e-20,
  6.684667262736098e-23, -1.822241592977835e-25,  4.873041933331200e-28, -1.278714912327041e-30,  1.283113285611576e-02, -6.514337480224822e-05,  2.466925164294866e-07,
 -8.242375921869833e-10,  2.557036448155971e-12, -7.524491486904910e-15,  2.120913838633571e-17, -5.749673684354068e-20,  1.499394307293452e-22, -3.749433766006230e-25,
  8.921473369855865e-28, -1.989647223719236e-30,  2.512140409274275e-02, -1.269353006460931e-04,  4.758627183694681e-07, -1.562218017570440e-09,  4.714206135618258e-12,
 -1.331184612580834e-14,  3.533821607123295e-17, -8.780819096127174e-20,  2.010938084069711e-22, -4.089340173080301e-25,  6.640597144012518e-28, -4.738417199559927e-31,
  4.146611229810874e-02, -2.081893917745816e-04,  7.698895315565184e-07, -2.467197462184086e-09,  7.159804009022297e-12, -1.901977864139352e-14,  4.586061278199262e-17,
 -9.705723571250834e-20,  1.626840857352385e-22, -1.216021207119004e-25, -5.746451579688157e-28,  3.825787302848646e-30,  6.182852875473956e-02, -3.079350724635868e-04,
  1.119137983454174e-06, -3.475640117226877e-09,  9.567213403566545e-12, -2.325423032774926e-14,  4.773567274633092e-17, -7.005554439593005e-20, -4.174196993194861e-26,
  5.204621914054613e-25, -2.603959670551491e-27,  9.072315905135798e-30,  8.616217303472831e-02, -4.249624620589355e-04,  1.511881876142352e-06, -4.513279754417732e-09,
  1.157907958408111e-11, -2.464960422150894e-14,  3.693800147588768e-17,  5.135722954128405e-22, -2.787154041733151e-22,  1.359591725611774e-24, -4.497955858514882e-27,
  1.130826659048101e-29,  1.144104309988649e-01, -5.578251274106983e-04,  1.934521370151684e-06, -5.498449284638295e-09,  1.283779897256026e-11, -2.207082256707589e-14,
  1.148570470716867e-17,  1.101434612071535e-19, -6.123701523847959e-22,  2.055473448316098e-24, -4.888386222139634e-27,  6.365181135365309e-30,  1.465060944352007e-01,
 -7.048439252175366e-04,  2.371849512872584e-06, -6.345957289169933e-09,  1.301860535726811e-11, -1.480890800923059e-14, -2.775831901820651e-17,  2.408424077215960e-19,
 -8.937396260158588e-22,  2.177234742435332e-24, -2.572676498118284e-27, -7.238138116353744e-30,  1.823708217396621e-01, -8.641122443011870e-04,  2.807370020957005e-06,
 -6.971430560504668e-09,  1.186330744474426e-11, -2.747836944148894e-15, -7.667667588473667e-17,  3.625567915938916e-19, -9.928701225559280e-22,  1.364690573314827e-24,
  2.730852795260305e-27, -2.584727573601021e-29,  2.219145193691463e-01, -1.033503021421476e-03,  3.223668403531863e-06, -7.296015241198163e-09,  9.212412737262890e-12,
  1.352010303039074e-14, -1.280131105727533e-16,  4.379755333841479e-19, -7.949959647863975e-22, -4.852086432938621e-25,  9.807685982760359e-27, -4.036840461418283e-29,
  2.650346443598424e-01, -1.210677971787857e-03,  3.602837941353806e-06, -7.251297431534470e-09,  5.033094938883962e-12,  3.265187304377704e-14, -1.720921501305064e-16,
  4.303493088393072e-19, -2.447539316420363e-22, -3.072852676500838e-24,  1.590438012078719e-26, -3.921911687450704e-29,  3.116154290608005e-01, -1.393099546100489e-03,
  3.926961019822714e-06, -6.784267204008935e-09, -5.597385679217960e-13,  5.260192543895890e-14, -1.981426683994667e-16,  3.132077421325009e-19,  6.152121401319629e-22,
 -5.662903921222657e-24,  1.744713958177489e-26, -1.421786837796469e-29,  3.615270304563020e-01, -1.578046198106277e-03,  4.178644740028006e-06, -5.862108484086974e-09,
 -7.292098607888732e-12,  7.077251962780697e-14, -1.961265717559057e-16,  8.013910775270933e-20,  1.625070975939821e-21, -7.216486163930805e-24,  1.147637882758530e-26,
  3.274744395953223e-29,  4.146246081232973e-01, -1.762631617509770e-03,  4.341607478950486e-06, -4.476552781482888e-09, -1.473199642047441e-11,  8.426813126835327e-14,
 -1.588633167290789e-16, -2.477326093202905e-19,  2.520327240699980e-21, -6.696393816321482e-24, -2.609992898539941e-27,  8.586656919605754e-29,  4.707473370869004e-01,
 -1.943828648396639e-03,  4.401310009399227e-06, -2.647490034389358e-09, -2.230530405456248e-11,  9.024358920395890e-14, -8.413229836236708e-17, -6.190972234812534e-19,
  2.982580813520285e-21, -3.487911022474903e-24, -2.173347675325904e-26,  1.179986676892636e-28,  5.297173647035502e-01, -2.118498666995474e-03,  4.345620800141051e-06,
 -4.254891730492753e-10, -2.932804736825329e-11,  8.632058524348970e-14,  2.365219710203380e-17, -9.567688541295284e-19,  2.725155144397025e-21,  2.191122165672121e-24,
 -3.907204143607922e-26,  1.012612004139560e-28,  5.913387243324971e-01, -2.283427226178256e-03,  4.165500099573179e-06,  2.107149343474752e-09, -3.505569028578740e-11,
  7.103064445697288e-14,  1.526400112041104e-16, -1.170028029621940e-18,  1.597553253338853e-21,  9.064408215375707e-24, -4.584250544938674e-26,  2.311596875089464e-29,
  6.553962230701348e-01, -2.435366776337448e-03,  3.855681317310663e-06,  4.837198357053320e-09, -3.874841797015572e-11,  4.422637350835008e-14,  2.840321278046120e-16,
 -1.174316609263644e-18, -3.197827522707782e-22,  1.492424627773136e-23, -3.483796605251312e-26, -9.917499317220851e-29,  7.216543263324896e-01, -2.571087228711605e-03,
  3.415321104047957e-06,  7.623537605237166e-09, -3.974940897253459e-11,  7.389634698482454e-15,  3.941379921802006e-16, -9.153468390408691e-19, -2.666787498359486e-21,
  1.720064811022166e-23, -4.668540029048617e-27, -2.154679096921335e-28,  7.898560686761934e-01, -2.687435019898997e-03,  2.848581581623472e-06,  1.030272717169158e-08,
 -3.757066232127159e-11, -3.624101045108114e-14,  4.580392809915984e-16, -3.923363765131313e-19, -4.835652990443063e-21,  1.390448550266850e-23,  3.722438653292236e-26,
 -2.585260350943277e-28,  8.597220280095810e-01, -2.781401143771069e-03,  2.165099791517248e-06,  1.269731519402593e-08, -3.197828221087198e-11, -8.179623223974273e-14,
  4.545415133838900e-16,  3.266766151558104e-19, -6.101972572704776e-21,  4.675234539139585e-24,  7.496122616692871e-26, -1.777065415401715e-28,  9.309494092645741e-01,
 -2.850198314935480e-03,  1.380291292956397e-06,  1.462688773715575e-08, -2.306653130400123e-11, -1.232070919856171e-13,  3.716706349685806e-16,  1.104783378503689e-18,
 -5.843364642833832e-21, -8.506671625079825e-24,  8.932535188730867e-26,  2.295134038090916e-29,  1.003211293583745e+00, -2.891346990426110e-03,  5.154279913617761e-07,
  1.592160258808039e-08, -1.130792494490304e-11, -1.539534321210434e-13,  2.115600266335603e-16,  1.756760327718213e-18, -3.793800890970929e-21, -2.141797500037456e-23,
  6.674832532800494e-26,  2.657431829307709e-28,  1.076156119895589e+00, -2.902769378551279e-03, -4.025738275998389e-07,  1.643760103235680e-08,  2.434194660279115e-12,
 -1.680822341519134e-13, -6.699360770545329e-18,  2.090798195023568e-18, -2.450657592574469e-22, -2.878149987502814e-23,  8.614739955264113e-27,  4.213912008385332e-28,
  1.149407476987740e+00, -2.882889786070812e-03, -1.341718747658212e-06,  1.607327431349046e-08,  1.694301714903215e-11, -1.613746938606156e-13, -2.476514444893780e-16,
  1.964802568120794e-18,  3.907913414292545e-21, -2.638125665786991e-23, -6.457458033470097e-26,  3.752138896269377e-28,  1.222564295183373e+00, -2.830738688491064e-03,
 -2.265906794417053e-06,  1.478490677701661e-08,  3.074406242443487e-11, -1.324637806793084e-13, -4.644545150542198e-16,  1.342718899506239e-18,  7.354453763466041e-21,
 -1.336377885546797e-23, -1.188888551913255e-25,  1.086223826423618e-28,  1.295201536525055e+00, -2.746056763856515e-03, -3.136356539758067e-06,  1.259978470153527e-08,
  4.226070231471632e-11, -8.364373467496406e-14, -6.082219873930597e-16,  3.305700473135414e-19,  8.787915943850889e-21,  6.441498076275668e-24, -1.228057224552875e-25,
 -2.585208898495918e-28,  1.366871489679034e+00, -2.629393847641806e-03, -3.913487445741305e-06,  9.624537816911886e-09,  5.002012018372965e-11, -2.109538809940060e-14,
 -6.403072000300365e-16, -8.279723175591687e-19,  7.444590481674576e-21,  2.527367336544560e-23, -6.664707390304645e-26, -5.129377446532409e-28,  1.437105778945218e+00,
 -2.482196424710528e-03, -4.559230447933263e-06,  6.046386426706256e-09,  5.288738084691776e-11,  4.569648889286668e-14, -5.446168786604936e-16, -1.807603025991060e-18,
  3.543373326008308e-21,  3.454935747419091e-23,  2.629476070520925e-26, -4.776102368996062e-28,  1.505418193829944e+00, -2.306876002897083e-03, -5.039680891353338e-06,
  2.125232474168884e-09,  5.029185933071733e-11,  1.054171691731776e-13, -3.359790231042313e-16, -2.301953456879944e-18, -1.623173424604860e-21,  2.924924808484011e-23,
  1.075462454468908e-25, -1.499705599540146e-28,  1.571308434437770e+00, -2.106849695885248e-03, -5.327942411308437e-06, -1.824722902426894e-09,  4.239987799002948e-11,
  1.471460544616154e-13, -6.063505720816293e-17, -2.139140667456899e-18, -6.096267949927971e-21,  1.127084598300824e-23,  1.303959985766945e-25,  2.645586098712834e-28,
  1.634266846292814e+00, -1.886543817375235e-03, -5.406940185875712e-06, -5.463864860132674e-09,  3.018438984155362e-11,  1.629199951466466e-13,  2.134112064103006e-16,
 -1.365677124711839e-18, -8.075716863666789e-21, -1.067192811360561e-23,  8.125491054360415e-26,  4.822553144899795e-28,  1.693780184263863e+00, -1.651351526769615e-03,
 -5.271917191338696e-06, -8.464793268469179e-09,  1.535123583027558e-11,  1.499890197981972e-13,  4.151773838352260e-16, -2.526484229521513e-19, -6.809564220530455e-21,
 -2.539099789529515e-23, -7.606998085623909e-27,  3.590166267117340e-28,  1.749338397963630e+00, -1.407536843195111e-03, -4.932281504073584e-06, -1.055484149772162e-08,
  1.044875768772836e-13,  1.120215524099706e-13,  4.935548410024325e-16,  7.962708303512536e-19, -3.053078523517340e-21, -2.577002804826497e-23, -7.796316178412845e-26,
  1.576009072153492e-29,  1.800442370542117e+00, -1.162079881448577e-03, -4.412462522826334e-06, -1.155761908648959e-08, -1.323048308401877e-11,  5.865843115016742e-14,
  4.360142926977778e-16,  1.409367520537108e-18,  1.257471137843758e-21, -1.331322876900525e-23, -8.747950061071549e-26, -2.611019693044070e-28,  1.846612471264671e+00,
 -9.224620586566167e-04, -3.751474809144774e-06, -1.142631308887457e-08, -2.266477317236228e-11,  3.233167945944493e-15,  2.746823067851076e-16,  1.412587204203217e-18,
  4.040160730969368e-21,  2.893657328151750e-24, -4.108901354692567e-26, -2.738989727086131e-28,  1.887397704053308e+00, -6.963951718208785e-04, -3.000990536108433e-06,
 -1.026129012323242e-08, -2.698554480838899e-11, -4.090463048406681e-14,  7.514118199044236e-17,  9.088171988385163e-19,  4.241003442367653e-21,  1.262151245315766e-23,
  1.625891962747246e-26, -8.107725315034090e-29,  1.922385156427293e+00, -4.915042869759557e-04, -2.221885513751525e-06, -8.306021899229811e-09, -2.606089187254695e-11,
 -6.440724040743577e-14, -8.944685382054171e-17,  2.172366871955801e-19,  2.383218008726842e-21,  1.169561821858063e-23,  4.057951964621384e-26,  9.419407346482154e-29,
  1.951209387056211e+00, -3.149806466846953e-04, -1.479435018917638e-06, -5.918638999590458e-09, -2.090851252126599e-11, -6.489442205986429e-14, -1.686309568885696e-16,
 -3.047946999527801e-19,  7.967157448455792e-23,  4.182993479285517e-24,  2.549896737318072e-26,  1.095490616777065e-28,  1.973561358750291e+00, -1.732263151006966e-04,
 -8.375633912113484e-07, -3.521108230021904e-09, -1.347837668642685e-11, -4.765010145812543e-14, -1.553226406203549e-16, -4.588077595497086e-19, -1.170831121422257e-21,
 -2.209986547273636e-24, -4.365537901973617e-28,  2.388822097266153e-29,  1.989196647531486e+00, -7.151529205753274e-05, -3.527486701192384e-07, -1.533159081602713e-09,
 -6.178090923986562e-12, -2.357188777677470e-14, -8.596057194805978e-17, -3.006548427622098e-19, -1.007867442320273e-21, -3.222750028243796e-24, -9.726123426254286e-27,
 -2.711188739451904e-29,  1.997944776979663e+00, -1.368318688469644e-05, -6.824175090735808e-08, -3.020380617681431e-10, -1.250756390102292e-12, -4.960283030017585e-15,
 -1.907102190928725e-17, -7.159166412872078e-20, -2.635616482317813e-22, -9.542349219681945e-25, -3.403821222536801e-27, -1.197557806982936e-29,  5.034810247394274e-04,
 -2.542369574460489e-06,  9.626259276467930e-09, -3.238979276341281e-11,  1.021335648311253e-13, -3.090440242831961e-16,  9.086784255092635e-19, -2.615788458064993e-21,
  7.407288409712552e-24, -2.070215601063411e-26,  5.723180924079220e-29, -1.567777577128992e-31,  4.529821426288948e-03, -2.283926177890073e-05,  8.620179214926698e-08,
 -2.884640968684110e-10,  9.020246817326427e-13, -2.697106718003685e-15,  7.803291349118039e-18, -2.199358400394587e-20,  6.062431453395251e-23, -1.638122789182788e-25,
  4.343677492551721e-28, -1.130674031898155e-30,  1.257444476215862e-02, -6.320871382154509e-05,  2.370422627728178e-07, -7.845018087097535e-10,  2.411509159057314e-12,
 -7.034261118285271e-15,  1.966442155464364e-17, -5.290792295034373e-20,  1.370632259203919e-22, -3.409527200895051e-25,  8.087327289085095e-28, -1.804655462176857e-30,
  2.462115974903331e-02, -1.232021230386302e-04,  4.575600271448735e-07, -1.488875356770955e-09,  4.456254936963845e-12, -1.249251875759099e-14,  3.296749990387126e-17,
 -8.160365121632159e-20,  1.868449976385888e-22, -3.828193443941383e-25,  6.409776280006485e-28, -5.695721657573727e-31,  4.064548816824118e-02, -2.021467820597007e-04,
  7.409581413572093e-07, -2.355624873837889e-09,  6.790197879974790e-12, -1.795115109583001e-14,  4.321520475873143e-17, -9.192550728606512e-20,  1.579313420277119e-22,
 -1.414273360885395e-25, -4.215101117660162e-28,  3.153496867253544e-30,  6.061443415168544e-02, -2.991462319848583e-04,  1.078333606555837e-06, -3.326223799021678e-09,
  9.113426542625926e-12, -2.213209638280917e-14,  4.577677664106020e-17, -6.977643670442355e-20,  1.691306267371021e-23,  4.239394483740895e-25, -2.230545434301904e-27,
  7.923218805538982e-30,  8.448617468461242e-02, -4.130809321228689e-04,  1.458817997987692e-06, -4.331910263269666e-09,  1.109494876362358e-11, -2.376388345291204e-14,
  3.683463309918916e-17, -7.655963008681123e-21, -2.328911842525163e-22,  1.189353962061443e-24, -4.020615938150381e-27,  1.039092276206472e-29,  1.122096698346125e-01,
 -5.426094235791233e-04,  1.869757891981147e-06, -5.296559845739233e-09,  1.239937773701787e-11, -2.176030474384210e-14,  1.430623817543785e-17,  9.169438742479542e-20,
 -5.418239160223884e-22,  1.865682081780565e-24, -4.598123047200710e-27,  6.786172044040033e-30,  1.437241910029673e-01, -6.861702167373373e-04,  2.296937926513253e-06,
 -6.140062989986109e-09,  1.271629503359034e-11, -1.539734468022607e-14, -2.140348872876447e-17,  2.134763914066606e-19, -8.172809207115371e-22,  2.068756094204193e-24,
 -2.832465125226479e-27, -4.656978720295082e-30,  1.789587654032758e-01, -8.419846907902517e-04,  2.724849603567601e-06, -6.782153894148348e-09,  1.179075222290166e-11,
 -4.469802206550037e-15, -6.696236801007560e-17,  3.315899478185281e-19, -9.420368985073278e-22,  1.452515134688914e-24,  1.692479052597233e-27, -2.143915851656158e-29,
  2.178315350440782e-01, -1.008061357662015e-03,  3.137009006068601e-06, -7.146616232386255e-09,  9.453070064053841e-12,  1.059205993283551e-14, -1.161080597175082e-16,
  4.123284985767718e-19, -8.058185762156434e-22, -1.271705202064264e-25,  8.125171673511571e-27, -3.612052122682675e-29,  2.602490287774787e-01, -1.182201913338764e-03,
  3.516326383761637e-06, -7.165763941252983e-09,  5.645801323965935e-12,  2.866527586917789e-14, -1.601677936436983e-16,  4.208666372671106e-19, -3.443396206319824e-22,
 -2.470987925129767e-24,  1.419536516633058e-26, -3.832935329735987e-29,  3.061053465367864e-01, -1.362009576725371e-03,  3.845529967026581e-06, -6.785062071669468e-09,
  4.454667707669174e-13,  4.795378021832243e-14, -1.891269315226221e-16,  3.297660633214067e-19,  4.237432605527357e-22, -4.979209765172107e-24,  1.669902438381341e-26,
 -1.951366761543981e-29,  3.552812557990468e-01, -1.544900298927258e-03,  4.107645280509352e-06, -5.967713342119989e-09, -5.923507474632395e-12,  6.609804808666107e-14,
 -1.931930536487903e-16,  1.280758823742945e-19,  1.373854917535224e-21, -6.732190952270559e-24,  1.265301877771228e-26,  2.102684648618571e-29,  4.076432016649879e-01,
 -1.728117512584087e-03,  4.286529513788758e-06, -4.698991178282906e-09, -1.308527669608860e-11,  8.038106372251880e-14, -1.647070661628494e-16, -1.709522720559741e-19,
  2.278250030405982e-21, -6.729437486193160e-24,  8.546714381216243e-28,  7.171159070142631e-29,  4.630422338589004e-01, -1.908751178456791e-03,  4.367458009551144e-06,
 -2.990051334820347e-09, -2.052197290950649e-11,  8.802706061672935e-14, -1.001508390849179e-16, -5.258214451777176e-19,  2.842597108748998e-21, -4.255861009520068e-24,
 -1.672795633769827e-26,  1.092314189246089e-28,  5.213128565424079e-01, -2.083761969940363e-03,  4.337756484551385e-06, -8.809047251598817e-10, -2.759807788942458e-11,
  8.657668011915489e-14, -1.906702445413550e-18, -8.685946121745525e-19,  2.776994158027532e-21,  7.191260392246168e-25, -3.449134349420290e-26,  1.062713803126236e-28,
  5.822718102552498e-01, -2.250011508156061e-03,  4.187468040227788e-06,  1.557811213591118e-09, -3.360106632885868e-11,  7.430694098314332e-14,  1.206414772373399e-16,
 -1.114036720285804e-18,  1.891174090506016e-21,  7.257971558276500e-24, -4.431644729496981e-26,  4.547864649126571e-29,  6.457167997051377e-01, -2.404299610272670e-03,
  3.910038208045668e-06,  4.224659073150638e-09, -3.779839004450602e-11,  5.064790448492054e-14,  2.510868061479155e-16, -1.176230171765312e-18,  1.914468880159123e-22,
  1.345350459153945e-23, -3.845393215711532e-26, -6.552699961566388e-29,  7.114251866993544e-01, -2.543409527385971e-03,  3.502994129835537e-06,  6.989234478888983e-09,
 -3.950914658216887e-11,  1.653231729286092e-14,  3.674062878140296e-16, -9.908305650482976e-19, -2.053136132800630e-21,  1.683249471739503e-23, -1.352999586449660e-26,
 -1.867794470017872e-28,  7.791526744142713e-01, -2.664162106787547e-03,  2.968585528842321e-06,  9.696391252490746e-09, -3.818653129209523e-11, -2.539690620872026e-14,
  4.449646610034232e-16, -5.388031511154717e-19, -4.311028350285894e-21,  1.516641347950163e-23,  2.589896462648802e-26, -2.548434590267937e-28,  8.486320175884035e-01,
 -2.763479692867942e-03,  2.314345600770035e-06,  1.217317071881022e-08, -3.350448928952129e-11, -7.079936149234062e-14,  4.609841113967406e-16,  1.346691967779555e-19,
 -5.881672650372449e-21,  7.506872782457117e-24,  6.638003920791145e-26, -2.107389605004415e-28,  9.195718032085608e-01, -2.838460352152285e-03,  1.553519839868222e-06,
  1.423860489409232e-08, -2.543907685429697e-11, -1.139371774206726e-13,  3.999456265748124e-16,  9.135863299007346e-19, -6.085214868736871e-21, -4.931823705939859e-24,
  8.896951404888595e-26, -3.845612682895630e-29,  9.916553578632904e-01, -2.886462637461455e-03,  7.053009910715538e-07,  1.571633558270729e-08, -1.433230870146915e-11,
 -1.483001318723532e-13,  2.589375803008167e-16,  1.623559109077400e-18, -4.514124671999069e-21, -1.853113737519077e-23,  7.716172211922084e-26,  2.064988816392008e-28,
  1.064539851055764e+00, -2.905200557664618e-03, -2.051998407760448e-07,  1.644966612971585e-08, -9.243245699669572e-13, -1.675423508907398e-13,  5.157811687882316e-17,
  2.066480493004328e-18, -1.270564437825365e-21, -2.807023274870757e-23,  2.681780298795672e-26,  4.034472495649132e-28,  1.137855678092538e+00, -2.892847657678146e-03,
 -1.147320427932082e-06,  1.631823864712037e-08,  1.366061234229403e-11, -1.666449184036800e-13, -1.910323655031312e-16,  2.074194855981625e-18,  2.915806783132830e-21,
 -2.861959298331721e-23, -4.701106018806948e-26,  4.206477599576129e-28,  1.211206221108999e+00, -2.848148110150545e-03, -2.085625834985728e-06,  1.525502517733342e-08,
  2.798649844868060e-11, -1.431334188709710e-13, -4.236423968298746e-16,  1.569457041125421e-18,  6.789157597780402e-21, -1.799653400010377e-23, -1.120795303934105e-25,
  2.004564888772028e-28,  1.284168101402648e+00, -2.770531463871255e-03, -2.981159859931636e-06,  1.326178354069179e-08,  4.044276908979437e-11, -9.809803388317975e-14,
 -5.950010596110641e-16,  6.145247441927764e-19,  8.928861589329688e-21,  1.325391982610718e-24, -1.323890590588590e-25, -1.747438401622564e-28,  1.356292049112781e+00,
 -2.660226201446636e-03, -3.793207708362700e-06,  1.042064212976297e-08,  4.944280347404852e-11, -3.671321874156343e-14, -6.600223904327215e-16, -5.757462813201489e-19,
  8.301044684106519e-21,  2.215968459454770e-23, -8.893178165357279e-26, -4.963591294572898e-28,  1.427104525478992e+00, -2.518365591617700e-03, -4.481568809462711e-06,
  6.899168814987970e-09,  5.366657404872683e-11,  3.203229749214443e-14, -5.934541481191005e-16, -1.674154034642442e-18,  4.800824784317375e-21,  3.515981663550177e-23,
  3.729702623238193e-27, -5.459741088541072e-28,  1.496110235961373e+00, -2.347077602204913e-03, -5.009281987116141e-06,  2.946308846436711e-09,  5.231432082001418e-11,
  9.657534913898035e-14, -4.009967691618743e-16, -2.336231942417182e-18, -4.946400495866927e-22,  3.338797337195715e-23,  9.860471798740003e-26, -2.577282235668809e-28,
  1.562795666472369e+00, -2.149549066062613e-03, -5.345671894163905e-06, -1.122881310046059e-09,  4.532328289122395e-11,  1.449504291674958e-13, -1.231938224634373e-16,
 -2.326700877633777e-18, -5.593991418559894e-21,  1.670113752424112e-23,  1.406257672868508e-25,  1.968827768647418e-28,  1.626633756646104e+00, -1.930053144841774e-03,
 -5.469500470924959e-06, -4.954582666169113e-09,  3.349075873791647e-11,  1.675534632667544e-13,  1.715012842386746e-16, -1.629577842419168e-18, -8.396220212198117e-21,
 -6.990018282606173e-24,  1.029940315100713e-25,  5.032515410561925e-28,  1.687089790357301e+00, -1.693928767354151e-03, -5.371920253120242e-06, -8.194636719755472e-09,
  1.844995494540523e-11,  1.598429178420589e-13,  4.049148945599341e-16, -4.852060648506079e-19, -7.725088440254301e-21, -2.535494217758402e-23,  1.001947647461761e-26,
  4.426747090368786e-28,  1.743628532188757e+00, -1.447501524708024e-03, -5.058853532028548e-06, -1.053459528190499e-08,  2.465116957435319e-12,  1.241224969828946e-13,
  5.143389000275907e-16,  6.831294038510999e-19, -4.036590913956432e-21, -2.885524708630157e-23, -7.578848751769510e-26,  8.570398244221042e-29,  1.795722568278688e+00,
 -1.197937853117086e-03, -4.552383485106809e-06, -1.175933941114024e-08, -1.194945305458082e-11,  6.960040112445664e-14,  4.759629340576806e-16,  1.441240354403213e-18,
  7.124403546987484e-22, -1.704209270410940e-23, -9.894218591753062e-26, -2.580975097708186e-28,  1.842861722339523e+00, -9.530284776669840e-04, -3.890763052907511e-06,
 -1.178806025524946e-08, -2.253090644428154e-11,  1.031486614572409e-14,  3.160579989372666e-16,  1.543197504293033e-18,  4.111720438234562e-21,  9.954693039249879e-25,
 -5.416167509158694e-26, -3.207368833462913e-28,  1.884563317215831e+00, -7.209030395981975e-04, -3.126743285232446e-06, -1.069949666368095e-08, -2.778346128375815e-11,
 -3.878011992389081e-14,  1.025571920872630e-16,  1.051917204444577e-18,  4.706127007889488e-21,  1.318968767297551e-23,  1.186652905191673e-26, -1.199956154525413e-28,
  1.920382947716109e+00, -5.096852473456047e-04, -2.324102502729137e-06, -8.733415738123351e-09, -2.736996500288301e-11, -6.647195521154102e-14, -8.223096769248687e-17,
  3.005577358065797e-19,  2.834478463798593e-21,  1.340187573791994e-23,  4.473198682427259e-26,  9.398650378627137e-29,  1.949925335531871e+00, -3.271060087059640e-04,
 -1.552509454642297e-06, -6.263781096837562e-09, -2.224756156073809e-11, -6.904354153156608e-14, -1.771054176085000e-16, -2.996292022733311e-19,  2.498295635794660e-22,
  5.304805441962758e-24,  3.073091779929566e-26,  1.286754397350522e-28,  1.972854779598532e+00, -1.800995753099326e-04, -8.811427314032297e-07, -3.744593258923079e-09,
 -1.446971891804896e-11, -5.153631154551412e-14, -1.687057620968022e-16, -4.975484786150530e-19, -1.250429666021095e-21, -2.203983757399371e-24,  8.009463768991522e-28,
  3.271773408402579e-29,  1.988904823443884e+00, -7.441259006714359e-05, -3.717556043520864e-07, -1.635895060218241e-09, -6.670860401876134e-12, -2.573971592423949e-14,
 -9.484842280344876e-17, -3.348403811068265e-19, -1.131185465351598e-21, -3.636615315604390e-24, -1.099149585705279e-26, -3.045578604995885e-29,  1.997888928918778e+00,
 -1.424396662931298e-05, -7.198963650924636e-08, -3.228693770219958e-10, -1.354706529496857e-12, -5.443028101245667e-15, -2.119902193620954e-17, -8.060262064112680e-20,
 -3.004973974310298e-22, -1.101541365622845e-24, -3.977411586535980e-27, -1.416128939581688e-29,  4.934631435752725e-04, -2.466886892142054e-06,  9.247186387831621e-09,
 -3.080394228241746e-11,  9.616497012100510e-14, -2.880885354056442e-16,  8.386458474448353e-19, -2.390250982518899e-21,  6.701608491021634e-24, -1.854503659996770e-26,
  5.076311393206597e-29, -1.376932597153422e-31,  4.439822025630875e-03, -2.216325240215930e-05,  8.282506966420835e-08, -2.744532690472201e-10,  8.499065661009334e-13,
 -2.517003683856689e-15,  7.213767493617501e-18, -2.014470341546094e-20,  5.502818934077976e-23, -1.473930775075102e-25,  3.875387186288716e-28, -1.000697299570635e-30,
  1.232534387306906e-02, -6.134938640363420e-05,  2.278551850426605e-07, -7.470179964477806e-10,  2.275425916806229e-12, -6.579607564483735e-15,  1.824260242929414e-17,
 -4.871219732097014e-20,  1.253525440862086e-22, -3.101406504083011e-25,  7.331011859742222e-28, -1.635700728078474e-30,  2.413556074930006e-02, -1.196119154503894e-04,
  4.401132154361449e-07, -1.419531856033598e-09,  4.214135123070394e-12, -1.172805451362108e-14,  3.076426739952487e-17, -7.584021720401727e-20,  1.735187704440575e-22,
 -3.577024663383072e-25,  6.143974216798972e-28, -6.340501581394651e-31,  3.984857991469151e-02, -1.963303669128976e-04,  7.133308342823672e-07, -2.249798404224406e-09,
  6.441340951204739e-12, -1.694430688659094e-14,  4.071125671113863e-17, -8.695615970446984e-20,  1.525683118499629e-22, -1.556868187218549e-25, -2.955975254390224e-28,
  2.585727371134149e-30,  5.943485322412975e-02, -2.906767762790036e-04,  1.039279394281167e-06, -3.183891079840869e-09,  8.681613162129305e-12, -2.105682396571039e-14,
  4.383278891395331e-17, -6.900758616979247e-20,  3.065007568500190e-23,  3.413807760981975e-25, -1.904818638841664e-27,  6.902838345035441e-30,  8.285686703213882e-02,
 -4.016153378150021e-04,  1.407884661101640e-06, -4.158145359582386e-09,  1.062848985442799e-11, -2.288322832182842e-14,  3.652215147449057e-17, -1.445357385182255e-20,
 -1.928615253247001e-22,  1.037407316008442e-24, -3.583250381815578e-27,  9.494027044962402e-30,  1.100687504459306e-01, -5.279022556353924e-04,  1.807375215025459e-06,
 -5.101631956907273e-09,  1.196780323534550e-11, -2.138804414325897e-14,  1.664079130526515e-17,  7.539574609239489e-20, -4.778973720987168e-22,  1.687800390585146e-24,
 -4.294564007898279e-27,  6.978869116976268e-30,  1.410157993500396e-01, -6.680860010919189e-04,  2.224467687727682e-06, -5.939091774747043e-09,  1.240368048294110e-11,
 -1.584218760588278e-14, -1.578125353919107e-17,  1.884927775173631e-19, -7.448884899424129e-22,  1.952008327381421e-24, -2.989689287830591e-27, -2.564268818240220e-30,
  1.756339133080715e-01, -8.205082376100043e-04,  2.644592444611866e-06, -6.594301249788699e-09,  1.168601985825351e-11, -5.968842482511100e-15, -5.809193817071091e-17,
  3.022927079966486e-19, -8.887442884542572e-22,  1.502529029633941e-24,  8.365268704826568e-28, -1.755159515729649e-29,  2.138489422646834e-01, -9.833057368220245e-04,
  3.052163616924443e-06, -6.993819913770797e-09,  9.637965420248094e-12,  7.941092971966671e-15, -1.049241271597176e-16,  3.865287452530328e-19, -8.049184158382627e-22,
  1.672779707984746e-25,  6.627356885226685e-27, -3.198850731922681e-29,  2.555759399719521e-01, -1.154413681045816e-03,  3.430897466818451e-06, -7.071049551499161e-09,
  6.181614326602049e-12,  2.496133652164000e-14, -1.485504026108459e-16,  4.085307943454672e-19, -4.234771810453492e-22, -1.936478440433132e-24,  1.254172115758315e-26,
 -3.673820928164549e-29,  3.007183213097994e-01, -1.331570827498483e-03,  3.764182846239025e-06, -6.770505455157239e-09,  1.359907053716092e-12,  4.352690645234162e-14,
 -1.797296832332772e-16,  3.405849854865961e-19,  2.562968894617674e-22, -4.329629553555561e-24,  1.575267599384064e-26, -2.326702927122873e-29,  3.491669212373916e-01,
 -1.512327099278930e-03,  4.035506875891103e-06, -6.052164391935588e-09, -4.647597632508993e-12,  6.150919574904464e-14, -1.890271705687613e-16,  1.682608030560165e-19,
  1.140801087381815e-21, -6.210628064240700e-24,  1.335246160781851e-26,  1.104892199020749e-29,  4.007989540981131e-01, -1.694054266469265e-03,  4.228937784769680e-06,
 -4.895710895354036e-09, -1.151753120989582e-11,  7.637866885954784e-14, -1.685094118830004e-16, -1.019118986745255e-19,  2.037329412185419e-21, -6.636159006545734e-24,
  3.711446635129928e-27,  5.828704139026363e-29,  4.554768735241950e-01, -1.873960485892538e-03,  4.329664945720311e-06, -3.304453991116604e-09, -1.878660795594977e-11,
  8.545689734983513e-14, -1.136242558718001e-16, -4.374296258720133e-19,  2.678473804838686e-21, -4.831780050608349e-24, -1.214251052554335e-26,  9.901007747217468e-29,
  5.130471353934083e-01, -2.049109576627864e-03,  4.324593322768550e-06, -1.308632277057492e-09, -2.586891990417172e-11,  8.624912771004283e-14, -2.498121151338612e-17,
 -7.795736682326609e-19,  2.779181812263118e-21, -5.664028847466351e-25, -2.977651751697458e-26,  1.074602326872974e-28,  5.733388693522470e-01, -2.216446014469546e-03,
  4.202985595918316e-06,  1.032230099748261e-09, -3.208846386738909e-11,  7.683508788502412e-14,  9.033256036829186e-17, -1.049676428297448e-18,  2.121086567856822e-21,
  5.530879965776713e-24, -4.190924535069009e-26,  6.317720317513237e-29,  6.361624685389938e-01, -2.372826723078386e-03,  3.957139929133011e-06,  3.628304734720834e-09,
 -3.672783337363259e-11,  5.627990354131346e-14,  2.183087935250211e-16, -1.162656591567886e-18,  6.474770944524017e-22,  1.186705809829662e-23, -4.064155963805638e-26,
 -3.439471672441400e-29,  7.013081125431900e-01, -2.515060809385730e-03,  3.583084502684436e-06,  6.360202842995536e-09, -3.909260593881201e-11,  2.501028078390463e-14,
  3.388334893169271e-16, -1.046955391640385e-18, -1.458806322905557e-21,  1.613598555181334e-23, -2.106794483222407e-26, -1.555651177047964e-28,  7.685442455715106e-01,
 -2.639958417373339e-03,  3.081261419764544e-06,  9.081918077404306e-09, -3.858897830255064e-11, -1.491386977817876e-14,  4.280302119347787e-16, -6.678420337609067e-19,
 -3.749067100308625e-21,  1.598101436075831e-23,  1.491642563783985e-26, -2.431470882342320e-28,  8.376160405048384e-01, -2.744389832793114e-03,  2.457162440631499e-06,
  1.162637301840721e-08, -3.480964369469999e-11, -5.971149452475009e-14,  4.621640329616619e-16, -4.872651709433763e-20, -5.565936128998387e-21,  9.969094088579453e-24,
  5.656267584464690e-26, -2.338533401210091e-28,  9.082438902587449e-01, -2.825355829581933e-03,  1.721867460859660e-06,  1.381387954473480e-08, -2.761987576607549e-11,
 -1.040536611098342e-13,  4.227780491826442e-16,  7.167012330618721e-19, -6.199265785094536e-21, -1.423881156197711e-24,  8.601792775647166e-26, -9.467442750750509e-29,
  9.801219807728615e-01, -2.880069966959845e-03,  8.924243736022752e-07,  1.546364343191893e-08, -1.723257098440668e-11, -1.415570318622316e-13,  3.022789614437666e-16,
  1.469045532751704e-18, -5.123669029398550e-21, -1.528163056363129e-23,  8.484428364120256e-26,  1.421076452041486e-28,  1.052917015112252e+00, -2.906053077962994e-03,
 -8.002888935421058e-09,  1.640815699667623e-08, -4.258133738861678e-12, -1.656156584765590e-13,  1.087201164586859e-16,  2.009895235368917e-18, -2.257582704279682e-21,
 -2.665113253806966e-23,  4.389752506014774e-26,  3.705677639759123e-28,  1.126267175430916e+00, -2.901239484779924e-03, -9.503008835648911e-07,  1.650991607516147e-08,
  1.028662088686914e-11, -1.705231862164446e-13, -1.318058920897931e-16,  2.150689679141742e-18,  1.856206105381819e-21, -3.011998788560305e-23, -2.779438999671869e-26,
  4.500474753878395e-28,  1.199781428492498e+00, -2.864093484370291e-03, -1.899975044657977e-06,  1.567937075074730e-08,  2.502583964884835e-11, -1.527495783504989e-13,
 -3.767595155185017e-16,  1.775497649905220e-18,  6.062949247444715e-21, -2.227721037841891e-23, -1.013202681328669e-25,  2.874383345296025e-28,  1.273039300212077e+00,
 -2.793733330826018e-03, -2.818203192213701e-06,  1.389240271068016e-08,  3.833956881540650e-11, -1.121392850312507e-13, -5.737944295530776e-16,  8.999762916199523e-19,
  8.879652047642933e-21, -4.096388234061222e-24, -1.379981307022362e-25, -7.844672259908268e-29,  1.345591263857852e+00, -2.690058285269553e-03, -3.663440525987185e-06,
  1.120498726927086e-08,  4.854898609806993e-11, -5.271647875873034e-14, -6.723096296030071e-16, -2.980775864390114e-19,  9.029585948654950e-21,  1.817548407441642e-23,
 -1.099929428852234e-25, -4.571836768423546e-28,  1.416959903014128e+00, -2.553872341098599e-03, -4.393608200771710e-06,  7.762169692512083e-09,  5.416108870244751e-11,
  1.724541136684003e-14, -6.379894786517655e-16, -1.500294818467051e-18,  6.063317862302083e-21,  3.481163160515795e-23, -2.152667586832917e-26, -5.991319747207090e-28,
  1.486642021238054e+00, -2.386996062495164e-03, -4.968842121056059e-06,  3.798244877010675e-09,  5.414428557047110e-11,  8.616580137563219e-14, -4.664468775451651e-16,
 -2.332091878843990e-18,  7.752886757794690e-22,  3.707227440842767e-23,  8.478514474896770e-26, -3.709451321137454e-28,  1.554111871812003e+00, -2.192355792416328e-03,
 -5.354700349196261e-06, -3.746998664803279e-10,  4.818734595917801e-11,  1.411923728140435e-13, -1.907493375381021e-16, -2.494987622203638e-18, -4.889634544764514e-21,
  2.247469442735029e-23,  1.474009936858334e-25,  1.074952402867697e-28,  1.618825668708881e+00, -1.974037603035798e-03, -5.525629084082381e-06, -4.391714397060816e-09,
  3.687913464067023e-11,  1.710913921880454e-13,  1.220796885102369e-16, -1.901444549757572e-18, -8.568345342322109e-21, -2.425112034114297e-24,  1.252716408975573e-25,
  5.059739386397636e-28,  1.680227509180843e+00, -1.737292207187253e-03, -5.468377505250752e-06, -7.873339697243238e-09,  2.174274449732195e-11,  1.693690724835409e-13,
  3.877318436662475e-16, -7.468963961847061e-19, -8.625730521104364e-21, -2.453960556934832e-23,  3.136524628807647e-26,  5.274412650357060e-28,  1.737756785005045e+00,
 -1.488477149971119e-03, -5.184947913657811e-06, -1.047461688485174e-08,  5.072477986167152e-12,  1.366805852000654e-13,  5.314978442988186e-16,  5.367615849680146e-19,
 -5.128820746445665e-21, -3.178719501868780e-23, -7.018105584198747e-26,  1.719136530600739e-28,  1.790857080576715e+00, -1.234924509647657e-03, -4.694594721216832e-06,
 -1.193876018074330e-08, -1.043993438752104e-11,  8.150974974169174e-14,  5.165390319604023e-16,  1.453436350081405e-18,  2.498078952721039e-23, -2.122330289272447e-23,
 -1.100037068506256e-25, -2.423031693662299e-28,  1.838986451699696e+00, -9.847265189587837e-04, -4.034374559362311e-06, -1.214647728113992e-08, -2.224517830602537e-11,
  1.843365792781879e-14,  3.611118221770500e-16,  1.674899365896431e-18,  4.105030307012956e-21, -1.467489220204881e-24, -6.934073179735136e-26, -3.693756047860139e-28,
  1.881628853257720e+00, -7.464381768473198e-04, -3.257829591045617e-06, -1.115009280276800e-08, -2.853197438694803e-11, -3.594784403103782e-14,  1.341911907444359e-16,
  1.210191019000772e-18,  5.188105934666306e-21,  1.354529497151137e-23,  5.563379464543085e-27, -1.681324000613373e-28,  1.918306346702951e+00, -5.287048176724064e-04,
 -2.431575218786224e-06, -9.182074868643727e-09, -2.871840296631910e-11, -6.833380321699078e-14, -7.247046512088042e-17,  3.993338978163100e-19,  3.350141815596847e-21,
  1.527293769549189e-23,  4.878979599008454e-26,  8.966211760577833e-29,  1.948591586615076e+00, -3.398329036332028e-04, -1.629856918294599e-06, -6.631022827790738e-09,
 -2.367161180121246e-11, -7.339365836045403e-14, -1.853526446511497e-16, -2.883304044628934e-19,  4.643493136402426e-22,  6.653465261329937e-24,  3.685984596338948e-26,
  1.503386628888078e-28,  1.972119992763022e+00, -1.873324731894509e-04, -9.275016832453004e-07, -3.984579382718540e-09, -1.554208664990765e-11, -5.575702069750378e-14,
 -1.832091786611434e-16, -5.388225405339583e-19, -1.328821421273177e-21, -2.140038149117034e-24,  2.478166835851011e-27,  4.396263229077933e-29,  1.988601098051696e+00,
 -7.746701228293438e-05, -3.920441454159960e-07, -1.746874126389808e-09, -7.209199424003244e-12, -2.813279887438226e-14, -1.047510263852661e-16, -3.732205444634127e-19,
 -1.270349987315396e-21, -4.104128283942967e-24, -1.241072443271392e-26, -3.410381089840944e-29,  1.997830776148658e+00, -1.483575838855152e-05, -7.599780494829946e-08,
 -3.454439968811359e-10, -1.468843438812244e-12, -5.980011477282872e-15, -2.359670587847327e-17, -9.088499300726101e-20, -3.431734335978397e-22, -1.273835981560071e-24,
 -4.656372777854131e-27, -1.677879167958903e-29,  4.837412462481296e-04, -2.394362264297880e-06,  8.886584260438268e-09, -2.931032565893564e-11,  9.059917599906523e-14,
 -2.687405295396128e-16,  7.746235016729371e-19, -2.186101105192329e-21,  6.069122852543179e-24, -1.663062639682288e-26,  4.507831885952147e-29, -1.210852053430947e-31,
  4.352473680084305e-03, -2.151359819284228e-05,  7.961159019898884e-08, -2.612482660856292e-10,  8.012531163791039e-13, -2.350447700437944e-15,  6.673591577116948e-18,
 -1.846579199697979e-20,  4.999077283158222e-23, -1.327374523272860e-25,  3.460742001005052e-28, -8.864788691117554e-31,  1.208353609781741e-02, -5.956179271999487e-05,
  2.191051432413058e-07, -7.116405863509745e-10,  2.148103810372026e-12, -6.157709247291809e-15,  1.693317991115704e-17, -4.487403536280373e-20,  1.146983926517001e-22,
 -2.822096493772853e-25,  6.645701824880229e-28, -1.481727049214725e-30,  2.366404860957329e-02, -1.161580185807835e-04,  4.234757776219325e-07, -1.353942777043120e-09,
  3.986788644201365e-12, -1.101457869554208e-14,  2.871657533748429e-17, -7.048896541976371e-20,  1.610770001928905e-22, -3.336978475669498e-25,  5.855440591104412e-28,
 -6.738777361176128e-31,  3.907450319565775e-02, -1.907299839318133e-04,  6.869406086466367e-07, -2.149395768592471e-09,  6.112031127454002e-12, -1.599590756317751e-14,
  3.834397724136735e-17, -8.216571771356280e-20,  1.467768274980902e-22, -1.653820977856261e-25, -1.926490705028042e-28,  2.107353479940469e-30,  5.828853590560557e-02,
 -2.825130381360805e-04,  1.001892422042606e-06, -3.048297857942438e-09,  8.270840662057343e-12, -2.002790190570689e-14,  4.191605380598308e-17, -6.784427608802013e-20,
  4.163900324499429e-23,  2.709886184006094e-25, -1.621364461483013e-27,  5.999886776245005e-30,  8.127261985228010e-02, -3.905489950280325e-04,  1.358992302746327e-06,
 -3.991703363269947e-09,  1.017955436234236e-11, -2.201221693527249e-14,  3.603647132629080e-17, -2.005445706453073e-20, -1.579964697535012e-22,  9.021753569702761e-25,
 -3.184628886712363e-27,  8.631754419218446e-30,  1.079856762557573e-01, -5.136849093720470e-04,  1.747290496722630e-06, -4.913546805227910e-09,  1.154419844297387e-11,
 -2.096500528558911e-14,  1.854667566097208e-17,  6.104265098732640e-20, -4.201544739403646e-22,  1.522175225132538e-24, -3.986581952244518e-27,  6.994967422167207e-30,
  1.383786001888084e-01, -6.505719863993029e-04,  2.154378822041462e-06, -5.743186468976351e-09,  1.208346308363391e-11, -1.616023353280443e-14, -1.082676721722205e-17,
  1.657574332631121e-19, -6.767911658716691e-22,  1.830684879094948e-24, -3.064304979673900e-27, -8.912190524566848e-31,  1.723936971447175e-01, -7.996648554664383e-04,
  2.566578510429864e-06, -6.408352878090733e-09,  1.155337014726554e-11, -7.264642173296627e-15, -5.001773049922384e-17,  2.747233574647597e-19, -8.342275858939181e-22,
  1.521578514818895e-24,  1.406673869245357e-28, -1.415699024808579e-29,  2.099640261207475e-01, -9.592214985162951e-04,  2.969167830489906e-06, -6.838475085755559e-09,
  9.772467124106276e-12,  5.549884320223445e-15, -9.446067126282052e-17,  3.609161888219138e-19, -7.944531916615784e-22,  4.053973114430605e-25,  5.307286279377743e-27,
 -2.805213541847085e-29,  2.510126446296725e-01, -1.127304193588737e-03,  3.346654164739669e-06, -6.968339757283210e-09,  6.646107333319257e-12,  2.153180088133049e-14,
 -1.373110662160166e-16,  3.939578076473895e-19, -4.845446633212880e-22, -1.466553777718768e-24,  1.096976512305136e-26, -3.464662449972385e-29,  2.954517509744645e-01,
 -1.301781914441313e-03,  3.683095309329866e-06, -6.742013747531765e-09,  2.188086699729210e-12,  3.932861765596617e-14, -1.701010594070127e-16,  3.464121775550282e-19,
  1.115179296652123e-22, -3.720803629043292e-24,  1.467086502861428e-26, -2.570830751165198e-29,  3.431817193223761e-01, -1.480334720408386e-03,  3.962474535983339e-06,
 -6.116929300716884e-09, -3.462378166850661e-12,  5.703300153765899e-14, -1.838376614562169e-16,  2.012929923164402e-19,  9.269258648451204e-22, -5.669369497451991e-24,
  1.364997593915339e-26,  2.741744189015223e-30,  3.940900236912915e-01, -1.660460776418897e-03,  4.169133266828956e-06, -5.067991384444700e-09, -1.003059408674583e-11,
  7.230734795879140e-14, -1.704859041377981e-16, -4.050634149037694e-20,  1.801683834660976e-21, -6.440146262859972e-24,  5.998639289323546e-27,  4.585709927270799e-29,
  4.480500480372143e-01, -1.839486761163828e-03,  4.288263894103030e-06, -3.591518773034324e-09, -1.710568255900623e-11,  8.259246034759793e-14, -1.246990986352536e-16,
 -3.545869800016772e-19,  2.496807813922370e-21, -5.233568424534670e-24, -8.027647654629683e-27,  8.793265368968680e-29,  5.049197813628755e-01, -2.014582549890307e-03,
  4.306463118192996e-06, -1.708774951649479e-09, -2.415164908560954e-11,  8.539766457193809e-14, -4.556885156312338e-17, -6.911867430947037e-19,  2.738488654459911e-21,
 -1.663277713234597e-24, -2.508186990198877e-26,  1.054594646910529e-28,  5.645403993463026e-01, -2.182781193213996e-03,  4.212342930339676e-06,  5.312162329038587e-10,
 -3.053242258343630e-11,  7.865822045432698e-14,  6.191952636204402e-17, -9.789337158373664e-19,  2.290732325433604e-21,  3.914305068998959e-24, -3.882353386965682e-26,
  7.635810349103027e-29,  6.267347376482661e-01, -2.341005347648531e-03,  3.997191750687660e-06,  3.049937838552315e-09, -3.555246436341299e-11,  6.113138671292874e-14,
  1.861064516802250e-16, -1.135418100860927e-18,  1.045142022010414e-21,  1.021958867991014e-23, -4.152884902014147e-26, -6.522086435041747e-30,  6.913056670752213e-01,
 -2.486101435980227e-03,  3.655671957201250e-06,  5.739154576664887e-09, -3.851347978722261e-11,  3.278576308368382e-14,  3.089512867260049e-16, -1.084518333686314e-18,
 -8.946432672067041e-22,  1.516583524008044e-23, -2.720452104480784e-26, -1.233139394787575e-28,  7.580343874669806e-01, -2.614882909224948e-03,  3.186531841677803e-06,
  8.462659761884141e-09, -3.878611090639242e-11, -4.878561045098690e-15,  4.077382433831546e-16, -7.785125992940359e-19, -3.165544633063017e-21,  1.636867160858184e-23,
  4.600333309797216e-27, -2.247868437402102e-28,  8.266786658954280e-01, -2.724184022436040e-03,  2.593299731522609e-06,  1.106046672048917e-08, -3.589316728280656e-11,
 -4.865570954854751e-14,  4.583630990373323e-16, -2.206780261059077e-19, -5.168846474432959e-21,  1.202121830369627e-23,  4.594755087995207e-26, -2.470392391928012e-28,
  8.969710558646317e-01, -2.810925490830671e-03,  1.884915635392203e-06,  1.335587066859726e-08, -2.959797274517413e-11, -9.368861670120161e-14,  4.400653893414436e-16,
  5.181595731878490e-19, -6.189734251849277e-21,  1.918506174667243e-24,  8.074394811278358e-26, -1.437344178785987e-28,  9.686171480342221e-01, -2.872193216883326e-03,
  1.076241654552769e-06,  1.516568098854644e-08, -1.998793069765879e-11, -1.338277493049448e-13,  3.410388633838852e-16,  1.296951965670072e-18, -5.611390593467712e-21,
 -1.178233141092942e-23,  8.963584461890155e-26,  7.558803902547529e-29,  1.041293919808367e+00, -2.905330918471377e-03,  1.883774189882539e-07,  1.631368909863514e-08,
 -7.539841543091164e-12, -1.623400879325737e-13,  1.638441472898496e-16,  1.922671577193983e-18, -3.181601484447397e-21, -2.458179750242945e-23,  5.923380578133962e-26,
  3.245535222975402e-28,  1.114648271038333e+00, -2.908046878125761e-03, -7.513074209025085e-07,  1.664706700709776e-08,  6.849431924962141e-12, -1.729581924708450e-13,
 -7.091931400900971e-17,  2.192563634356929e-18,  7.566929680765551e-22, -3.083091213039450e-23, -7.664844387601546e-27,  4.619816432425195e-28,  1.188295855886375e+00,
 -2.878534103188914e-03, -1.709522474084130e-06,  1.605487024559379e-08,  2.188456268682137e-11, -1.611740842433008e-13, -3.244553706415872e-16,  1.955924332090899e-18,
  5.191284331226974e-21, -2.605336480021141e-23, -8.692019314172670e-26,  3.652599475859837e-28,  1.261820345951902e+00, -2.815601867938921e-03, -2.647890171918809e-06,
  1.448715444151435e-08,  3.596127882346852e-11, -1.255760249694340e-13, -5.446468045650021e-16,  1.180695350028498e-18,  8.632267452488315e-21, -9.654946645009599e-24,
 -1.391652780044247e-25,  2.644577593154072e-29,  1.334773285777368e+00, -2.718814850600838e-03, -3.524357615125583e-06,  1.197245747564879e-08,  4.733279736865246e-11,
 -6.891883968184705e-14, -6.765184590168485e-16,  4.507126375692383e-22,  9.600008789500225e-21,  1.339005329851929e-23, -1.288270164175892e-25, -3.951996531086023e-28,
  1.406674726668943e+00, -2.588633870004683e-03, -4.295254050886064e-06,  8.630660565699526e-09,  5.434959498562340e-11,  1.452640520039185e-15, -6.770944536284954e-16,
 -1.286435607229325e-18,  7.294577884590541e-21,  3.341195647018884e-23, -4.869936694774382e-26, -6.323305437884478e-28,  1.477014845139717e+00, -2.426549629553524e-03,
 -4.918010492465908e-06,  4.677709592568517e-09,  5.575038496713145e-11,  7.419155263296030e-14, -5.311930139046831e-16, -2.285308407782069e-18,  2.166696245816924e-21,
  4.010365130587768e-23,  6.595577463834365e-26, -4.845228795677574e-28,  1.545256763744270e+00, -2.235198060968190e-03, -5.354478446784758e-06,  4.186156509736296e-10,
  5.095966688627814e-11,  1.357591804311660e-13, -2.626697566138913e-16, -2.637365147258278e-18, -3.973557205786839e-21,  2.843425480290175e-23,  1.497706681676361e-25,
 -3.187950403744336e-30,  1.610840788966744e+00, -2.018443145873856e-03, -5.574675874741958e-06, -3.774133088005692e-09,  4.032578879526432e-11,  1.733513911884630e-13,
  6.499464386565302e-17, -2.176018034242551e-18, -8.560122741721211e-21,  3.026899994825768e-24,  1.471830178570383e-25,  4.858678653142890e-28,  1.673190256630914e+00,
 -1.781410972819986e-03, -5.560656877580534e-06, -7.497858813333587e-09,  2.522132300211012e-11,  1.783916824235822e-13,  3.628236054313279e-16, -1.036765585497311e-18,
 -9.480757618146728e-21, -2.279645504949796e-23,  5.638633865898419e-26,  6.089177944416838e-28,  1.731719123395099e+00, -1.530457922895536e-03, -5.310063891027135e-06,
 -1.037089050767078e-08,  7.934766144445300e-12,  1.495972631980189e-13,  5.440536560179709e-16,  3.538046108528784e-19, -6.321604683959669e-21, -3.441409318131778e-23,
 -6.041509524587182e-26,  2.747075788763813e-28,  1.785841357836818e+00, -1.273057039228613e-03, -4.838806061000895e-06, -1.209207017509134e-08, -8.682476272545358e-12,
  9.439439461105707e-14,  5.571254075011091e-16,  1.441141494261569e-18, -8.207581859914613e-22, -2.582852289003212e-23, -1.200233151620080e-25, -2.101159632575523e-28,
  1.834982063997382e+00, -1.017590565872933e-03, -4.182254088094192e-06, -1.249896364767234e-08, -2.178596320300673e-11,  2.767788288040015e-14,  4.098361110779460e-16,
  1.804847100874788e-18,  3.998227652417175e-21, -4.580526553235993e-24, -8.666433052847905e-26, -4.178248458867542e-28,  1.878590116843007e+00, -7.730438321725166e-04,
 -3.394392900668845e-06, -1.161216919837306e-08, -2.921588179684929e-11, -3.230141934955155e-14,  1.704743355278513e-16,  1.384040009038525e-18,  5.677811017119804e-21,
  1.360343440985841e-23, -3.082730173496102e-27, -2.266834865250259e-28,  1.916151913225514e+00, -5.486060748835662e-04, -2.544562479393482e-06, -9.652593199860555e-09,
 -3.010150144003878e-11, -6.992628238347563e-14, -5.970286589830804e-17,  5.157198826438537e-19,  3.936025297425710e-21,  1.730095968962051e-23,  5.253863158325191e-26,
  7.965318317331167e-29,  1.947205664093141e+00, -3.531965998958666e-04, -1.711750897126030e-06, -7.021756013556329e-09, -2.518461388145290e-11, -7.793708993842422e-14,
 -1.931797532009086e-16, -2.693409211673991e-19,  7.320703138531488e-22,  8.267109695598178e-24,  4.399908596605283e-26,  1.745999970599932e-28,  1.971355513933414e+00,
 -1.949480602419934e-04, -9.768462638914756e-07, -4.242418014140200e-09, -1.670244444854706e-11, -6.033996078155213e-14, -1.989029442316854e-16, -5.825543408165308e-19,
 -1.403576757126631e-21, -1.998271531639814e-24,  4.713836596522184e-27,  5.820814326350960e-29,  1.988284821707954e+00, -8.068921997385910e-05, -4.137177381040149e-07,
 -1.866862797818213e-09, -7.797866444354120e-12, -3.077695921522767e-14, -1.157932303854119e-16, -4.163345355856715e-19, -1.427406291065086e-21, -4.631706693708124e-24,
 -1.399684807135584e-26, -3.803705044716828e-29,  1.997770190320204e+00, -1.546073095932049e-05, -8.028819078011415e-08, -3.699339519491485e-10, -1.594319602766151e-12,
 -6.578154385939498e-15, -2.630238628676981e-17, -1.026377157319287e-19, -3.925700078619317e-22, -1.475739227326521e-24, -5.461653467380902e-27, -1.991978866402678e-29,
  4.743037892140252e-04, -2.324652244894870e-06,  8.543383720757517e-09, -2.790274764244492e-11,  8.540542808811891e-14, -2.508626905348422e-16,  7.160440548812847e-19,
 -2.001130564730294e-21,  5.501633066742448e-24, -1.492964445121471e-26,  4.007615173283566e-29, -1.066128544249553e-31,  4.267673520928968e-03, -2.088903096417641e-05,
  7.655200772627744e-08, -2.487957580899802e-10,  7.558048597653663e-13, -2.196309563777819e-15,  6.178245507461539e-18, -1.693994679583380e-20,  4.545227719567864e-23,
 -1.196440808230263e-25,  3.093258596320355e-28, -7.860186599248377e-31,  1.184874133725470e-02, -5.784253525632404e-05,  2.107676804589791e-07, -6.782344978554278e-10,
  2.028913918598632e-12, -5.765985063023634e-15,  1.572660033415289e-17, -4.136123405286907e-20,  1.050020095495198e-22, -2.568885629394055e-25,  6.025041644516943e-28,
 -1.341660914186733e-30,  2.320609075719713e-02, -1.128341337087572e-04,  4.076040458754935e-07, -1.291879705629450e-09,  3.773232143085411e-12, -1.034849366534592e-14,
  2.681327271920146e-17, -6.552224943110088e-20,  1.494782549838319e-22, -3.108763847001225e-25,  5.553799142321433e-28, -6.944277851178017e-31,  3.832241327095910e-02,
 -1.853359915798402e-04,  6.617242169632678e-07, -2.054113387956852e-09,  5.801131898321693e-12, -1.510273459561938e-14,  3.610818852630232e-17, -7.756543269670718e-20,
  1.407055774718267e-22, -1.713570630874155e-25, -1.090263067580769e-28,  1.705282255433216e-30,  5.717428549748706e-02, -2.746419974787541e-04,  9.660938053310070e-07,
 -2.919114856177765e-09,  7.880189420850442e-12, -1.904455314532257e-14,  4.003644861824807e-17, -6.636775371593960e-20,  5.028861893240991e-23,  2.111721315032395e-25,
 -1.375260297236082e-27,  5.203322891632059e-30,  7.973186824477607e-02, -3.798659226829694e-04,  1.312054723215172e-06, -3.832305657444711e-09,  9.747910464813311e-12,
 -2.115462208714910e-14,  3.540887563156373e-17, -2.461454822640133e-20, -1.277217884656996e-22,  7.821419076495791e-25, -2.823002511402610e-27,  7.813688529985716e-30,
  1.059585242278191e-01, -4.999393273298447e-04,  1.689422421071526e-06, -4.732169291690731e-09,  1.112948034321116e-11, -2.050084446938171e-14,  2.007566275530483e-17,
  4.844430495209047e-20, -3.681525535218347e-22,  1.368841287558211e-24, -3.680976605680260e-27,  6.877214212134030e-30,  1.358103504297508e-01, -6.336093667191445e-04,
  2.086609889590754e-06, -5.552449280354914e-09,  1.175802353415819e-11, -1.636676867660006e-14, -6.479022841285952e-18,  1.451308823936880e-19, -6.130984725996400e-22,
  1.707739630486531e-24, -3.073380489778400e-27,  4.245838508208253e-31,  1.692356203656175e-01, -7.794366972577077e-04,  2.490782400505056e-06, -6.224723959859588e-09,
  1.139668074583648e-11, -8.375726600668911e-15, -4.269097471283761e-17,  2.489044257498557e-19, -7.794913818744470e-22,  1.515643273662717e-24, -4.160485436403036e-28,
 -1.122078036047643e-29,  2.061741308506255e-01, -9.357937369130319e-04,  2.888047559490668e-06, -6.681347422569163e-09,  9.861598022952813e-12,  3.401238198059659e-15,
 -8.470846053848489e-17,  3.357658199923069e-19, -7.763250156077346e-22,  5.941074578178256e-25,  4.155074744508190e-27, -2.436565505395239e-29,  2.465564473219440e-01,
 -1.100863601254447e-03,  3.263685755113349e-06, -6.858732287079250e-09,  7.044672939969378e-12,  1.836690717323549e-14, -1.265046738929476e-16,  3.776893893732416e-19,
 -5.298034745799766e-22, -1.057557802666781e-24,  9.497704173261727e-27, -3.222264748578681e-29,  2.903030413658482e-01, -1.272640115112174e-03,  3.602426448088395e-06,
 -6.700930289739514e-09,  2.934622034811879e-12,  3.536287019581270e-14, -1.603709008696815e-16,  3.479485854316550e-19, -1.214499103836435e-23, -3.157061362232353e-24,
  1.350645211251255e-26, -2.705655004808525e-29,  3.373233139294823e-01, -1.448929393351375e-03,  3.888775866697453e-06, -6.163439821217764e-09, -2.365366106482504e-12,
  5.269169905712154e-14, -1.778161254797298e-16,  2.277945494328031e-19,  7.326663485979587e-22, -5.123052704070406e-24,  1.361672849710266e-26, -4.006731645933003e-30,
  3.875144978418746e-01, -1.627353593730945e-03,  4.107401435123039e-06, -5.217134298914748e-09, -8.625422845809790e-12,  6.820837854205188e-14, -1.708474294011984e-16,
  1.348806769244457e-20,  1.574612709206235e-21, -6.163250267008002e-24,  7.764121152422465e-27,  3.459460914609390e-29,  4.407604338550206e-01, -1.805357571189784e-03,
  4.243577498758387e-06, -3.852160723432942e-09, -1.548451942487900e-11,  7.948939309069920e-14, -1.335376872409373e-16, -2.777582713844002e-19,  2.303521377024982e-21,
 -5.480646531711860e-24, -4.409518930516311e-27,  7.650753386709633e-29,  4.969302156026874e-01, -1.980219306004550e-03,  4.283695412884812e-06, -2.081603535187586e-09,
 -2.245614901247670e-11,  8.408161373717454e-14, -6.370556737434118e-17, -6.046977770484783e-19,  2.661659588154734e-21, -2.574925073188740e-24, -2.053375808672353e-26,
  1.009025727245370e-28,  5.558767008665517e-01, -2.149065136171623e-03,  4.215838563438244e-06,  5.535436104445581e-11, -2.894657438644830e-11,  7.982377030253472e-14,
  3.555471673282852e-17, -9.036686065255322e-19,  2.404531283722715e-21,  2.431490308515776e-24, -3.525197087084678e-26,  8.532122119007418e-29,  6.174348895932408e-01,
 -2.308890992454058e-03,  4.030419071638738e-06,  2.491111376478162e-09, -3.428772527659889e-11,  6.522054878142565e-14,  1.548359901026362e-16, -1.096407789761693e-18,
  1.383145013865794e-21,  8.560079078982857e-24, -4.127091210819603e-26,  1.760002376562868e-29,  6.814201735381242e-01, -2.456591004169117e-03,  3.720867433338874e-06,
  5.128577118209071e-09, -3.778609051082226e-11,  3.983345749031975e-14,  2.782644946851212e-16, -1.104631461151110e-18, -3.694817550160987e-22,  1.397860832812300e-23,
 -3.192387545249766e-26, -9.134786509864888e-29,  7.476264686023519e-01, -2.588995000643784e-03,  3.284358773878266e-06,  7.841825497888172e-09, -3.878764745951784e-11,
  4.634675238661095e-15,  3.846104569115530e-16, -8.703651153906129e-19, -2.575284314451079e-21,  1.636147754507974e-23, -4.788389345949003e-27, -2.012440396884550e-28,
  8.158242493212541e-01, -2.702916555207981e-03,  2.722549404928417e-06,  1.047898640403971e-08, -3.675686968182390e-11, -3.774742151030845e-14,  4.499359351322946e-16,
 -3.788235556275666e-19, -4.705637158278940e-21,  1.363997031323721e-23,  3.496313438284527e-26, -2.507481682979544e-28,  8.857585160489969e-01, -2.795213273259632e-03,
  2.042284714892241e-06,  1.286789130250333e-08, -3.136506952265377e-11, -8.297524203682835e-14,  4.518156081252984e-16,  3.218033449132018e-19, -6.064172126742626e-21,
  5.009211869045751e-24,  7.349673052250289e-26, -1.841689999384801e-28,  9.571467396850730e-01, -2.862860968145701e-03,  1.256224132149033e-06,  1.482491834932580e-08,
 -2.257980130774364e-11, -1.252276985594383e-13,  3.747808149461819e-16,  1.111298168815736e-18, -5.970392890157263e-21, -8.149871660757946e-24,  9.150839143518687e-26,
  9.899292021521070e-30,  1.029676846794787e+00, -2.903043138158486e-03,  3.833114604951307e-07,  1.616730895918971e-08, -1.074302295317307e-11, -1.577741160842501e-13,
  2.161239746851292e-16,  1.807185487110446e-18, -4.020600809055159e-21, -2.194284855915893e-23,  7.230021662897640e-26,  2.678368017341261e-28,  1.103005330067131e+00,
 -2.913256678624654e-03, -5.509994661999733e-07,  1.672891303760263e-08,  3.378229959083392e-12, -1.739218451145255e-13, -9.355582262944414e-18,  2.198999788068431e-18,
 -3.538416989929537e-22, -3.073143518844340e-23,  1.259476578057401e-26,  4.559582690361052e-28,  1.176755595361504e+00, -2.891433944248365e-03, -1.514870806848340e-06,
  1.637883125209657e-08,  1.858774100172134e-11, -1.682859407076272e-13, -2.675093907436249e-16,  2.106400328793781e-18,  4.194838954012085e-21, -2.918862015108669e-23,
 -6.937075837744875e-26,  4.299873699289990e-28,  1.250516686812868e+00, -2.836080019864975e-03, -2.470677184563773e-06,  1.504174431657267e-08,  3.332188072539365e-11,
 -1.382199798436210e-13, -5.077799686239721e-16,  1.450296486244064e-18,  8.185061100893357e-21, -1.516637182625929e-23, -1.356128535189342e-25,  1.352593740934081e-28,
  1.323842564590355e+00, -2.746422269527652e-03, -3.376192519391674e-06,  1.271787367330509e-08,  4.579223832998011e-11, -8.512000859499622e-14, -6.721398491760928e-16,
  3.143364619743152e-19,  9.985312363985731e-21,  7.912317221035859e-24, -1.444500933014912e-25, -3.115288600779189e-28,  1.396252143920171e+00, -2.622566851201938e-03,
 -4.186470496572876e-06,  9.499591818565061e-09,  5.421336847525431e-11, -1.520239491700813e-14, -7.096688514012136e-16, -1.034194515214665e-18,  8.455594912949181e-21,
  3.090298927223665e-23, -7.681530408437682e-26, -6.413828641723658e-28,  1.467230335510580e+00, -2.465653911164585e-03, -4.856479276801285e-06,  5.580872126848772e-09,
  5.710159283194224e-11,  6.068424259143279e-14, -5.939905493564393e-16, -2.192408895858887e-18,  3.652481998840624e-21,  4.228310759721380e-23,  4.223026352247661e-26,
 -5.924402899128587e-28,  1.536230351497656e+00, -2.277999729958871e-03, -5.344474508608139e-06,  1.255323914959024e-09,  5.360575811539954e-11,  1.285555703280924e-13,
 -3.381340171066814e-16, -2.746987079500583e-18, -2.842457305659469e-21,  3.438529405438041e-23,  1.468332744118576e-25, -1.332950407687080e-28,  1.602677550568203e+00,
 -2.063210478705817e-03, -5.615979567557652e-06, -3.101120762558316e-09,  4.380332073160048e-11,  1.741493095118133e-13,  2.559254262867022e-19, -2.447021065056726e-18,
 -8.340134112967352e-21,  9.329995198441191e-24,  1.676285553277500e-25,  4.386916158111735e-28,  1.665975082438617e+00, -1.826248990686154e-03, -5.648090693729001e-06,
 -7.065312350467156e-09,  2.887370259821549e-11,  1.867160718820422e-13,  3.294268288795857e-16, -1.352791532825413e-18, -1.025417097049105e-20, -1.998291334292870e-23,
  8.482089230326425e-26,  6.816024527922011e-28,  1.725511545846150e+00, -1.573433846499667e-03, -5.433651799112129e-06, -1.021928629913817e-08,  1.105796366006711e-11,
  1.627494095659191e-13,  5.509386786562417e-16,  1.312499844936503e-19, -7.600791857014051e-21, -3.655512312994906e-23, -4.577164397213989e-26,  3.934076087688382e-28,
  1.780670786646718e+00, -1.312350120451267e-03, -4.984679729892231e-06, -1.221514654584277e-08, -6.657628879842928e-12,  1.082457673508981e-13,  5.969631787690645e-16,
  1.399056137762117e-18, -1.839106675417848e-21, -3.080052230819745e-23, -1.281950059071615e-25, -1.576518299981079e-28,  1.830843827441379e+00, -1.051654428985899e-03,
 -4.334313058214223e-06, -1.284255873131094e-08, -2.112987750323382e-11,  3.813465857098593e-14,  4.621332637330879e-16,  1.929446167957043e-18,  3.766374407111705e-21,
 -8.428495096596641e-24, -1.060655527500961e-25, -4.632737511831654e-28,  1.875442737421317e+00, -8.007643538062013e-04, -3.536564217651535e-06, -1.208455568446575e-08,
 -2.981774931815166e-11, -2.772401573986769e-14,  2.118444485274749e-16,  1.573521066348911e-18,  6.162733056992705e-21,  1.326089707456795e-23, -1.455405101915764e-26,
 -2.967072313978641e-28,  1.913916030629511e+00, -5.694341935690100e-04, -2.663329731413638e-06, -1.014547810739043e-08, -3.151311007091005e-11, -7.117104645177809e-14,
 -4.340280689655828e-17,  6.520502367934635e-19,  4.597491809262392e-21,  1.946803405593594e-23,  5.568679258509686e-26,  6.200020067820768e-29,  1.945764946196592e+00,
 -3.672346216900209e-04, -1.798481953575478e-06, -7.437434189303879e-09, -2.679031479286554e-11, -8.266096787676848e-14, -2.003460789058991e-16, -2.407976583230211e-19,
  1.063286929149273e-21,  1.018842933521580e-23,  5.226207130253142e-26,  2.013935646157126e-28,  1.970559763191638e+00, -2.029711029124477e-04, -1.029399394643416e-06,
 -4.519576526547165e-09, -1.795832811099557e-11, -6.531451007522110e-14, -2.158537929090493e-16, -6.285781079004594e-19, -1.471458414084399e-21, -1.753505678217827e-24,
  7.655154410286224e-27,  7.616666634755386e-29,  1.987955300405358e+00, -8.409074009469938e-05, -4.368894998177997e-07, -1.996708027152547e-09, -8.442167594174490e-12,
 -3.370120466430599e-14, -1.281159318988965e-16, -4.647908015584185e-19, -1.604639827305145e-21, -5.226266612814532e-24, -1.576156332193593e-26, -4.221184352760673e-29,
  1.997707034044645e+00, -1.612123719677243e-05, -8.488490830123826e-08, -3.965308719007723e-10, -1.732435595820947e-12, -7.245368102502709e-15, -2.936041123674354e-17,
 -1.160939226969756e-19, -4.498498155560471e-22, -1.712796007056935e-24, -6.418678679462616e-27, -2.369678244694134e-29,  4.651397860656406e-04, -2.257621652077321e-06,
  8.216587074133501e-09, -2.657548380117497e-11,  8.055558703314780e-14, -2.343306049635075e-16,  6.623984852397850e-19, -1.833377337048458e-21,  4.991925378182832e-24,
 -1.341657602809025e-26,  3.566921364901369e-29, -9.398497914189644e-32,  4.185323606610902e-03, -2.028835480666991e-05,  7.363759199469881e-08, -2.370463917932905e-10,
  7.133238604415698e-13, -2.053563034397006e-15,  5.723658745078284e-18, -1.555206694538384e-20,  4.135971590436216e-23, -1.079358942595247e-25,  2.767274180509305e-28,
 -6.975806071453514e-31,  1.162069270100830e-02, -5.618840583695248e-05,  2.028199020402378e-07, -6.466743123168595e-10,  1.917276720752268e-12, -5.402072724040637e-15,
  1.461416890447914e-17, -3.814459938375234e-20,  9.617394803216020e-23, -2.339307160586869e-25,  5.463146517579900e-28, -1.214440077915863e-30,  2.276117913270366e-02,
 -1.096343007540867e-04,  3.924570012658799e-07, -1.233129399997211e-09,  3.572551600890444e-12, -9.726460271709905e-15,  2.504396375143741e-17, -6.091378247675974e-20,
  1.386791894439469e-22, -2.892748950394373e-25,  5.246539523354483e-28, -7.000602565793358e-31,  3.759150297724335e-02, -1.801392400327568e-04,  6.376219476904235e-07,
 -1.963665359383608e-09,  5.507569858473789e-12, -1.426169699160237e-14,  3.399845994330562e-17, -7.316225709099470e-20,  1.344753560597410e-22, -1.743210447262522e-25,
 -4.162664973170295e-29,  1.368211379814068e-30,  5.609095614397918e-02, -2.670512497493353e-04,  9.318085232318650e-07, -2.796027374881531e-09,  7.508757551801482e-12,
 -1.810578944439055e-14,  3.820175051504374e-17, -6.464706482240744e-20,  5.695385425823147e-23,  1.605277845809245e-25, -1.162059674921086e-27,  4.502574958197715e-30,
  7.823310987556585e-02, -3.695508159933965e-04,  1.266989041587407e-06, -3.679677898681714e-09,  9.333258048180985e-12, -2.031351614779042e-14,  3.466653032082906e-17,
 -2.827226664652419e-20, -1.015164842261408e-22,  6.758680621665122e-25, -2.496282662028979e-27,  7.045835386110117e-30,  1.039854422652244e-01, -4.866480958576284e-04,
  1.633691375130165e-06, -4.557351124837702e-09,  1.072438479410060e-11, -2.000403798467135e-14,  2.127437993003030e-17,  3.742404723669811e-20, -3.214521576834466e-22,
  1.227596549617371e-24, -3.382841007131607e-27,  6.660632603782683e-30,  1.333088812171834e-01, -6.171798319111528e-04,  2.021098442731755e-06, -5.366946692962979e-09,
  1.142945113237360e-11, -1.647566225314244e-14, -2.680952814102679e-18,  1.264717188123681e-19, -5.538252393706056e-22,  1.585496728988901e-24, -3.031381949112446e-27,
  1.439003559644717e-30,  1.661572573750727e-01, -7.598061379877995e-04,  2.417174092385942e-06, -6.043770533709442e-09,  1.121947054144410e-11, -9.319446469082441e-15,
 -3.606268853214914e-17,  2.248295810957937e-19, -7.253397029389377e-22,  1.489896804294487e-24, -8.529520730570589e-28, -8.704413772339141e-30,  2.024766606743059e-01,
 -9.130073742908302e-04,  2.808819999451651e-06, -6.523124969672819e-09,  9.910039853177180e-12,  1.478266127839283e-15, -7.565137902306057e-17,  3.112956671945503e-19,
 -7.521945147496916e-22,  7.398916323176501e-25,  3.158920971897268e-27, -2.096267521759363e-29,  2.422046933659874e-01, -1.075081391348619e-03,  3.182068853814180e-06,
 -6.743240216276008e-09,  7.382496520315215e-12,  1.545575024027768e-14, -1.161719395360918e-16,  3.601971192759920e-19, -5.613719903613446e-22, -7.052448354243906e-25,
  8.137029734791978e-27, -2.960395581217142e-29,  2.852696116539375e-01, -1.244141497554843e-03,  3.522319679460581e-06, -6.648524091234267e-09,  3.604178910697632e-12,
  3.163073403685541e-14, -1.506501376055371e-16,  3.458434068921235e-19, -1.163633243735770e-22, -2.640805900511063e-24,  1.230300836372894e-26, -2.751428123339227e-29,
  3.315893475439268e-01, -1.418115596312918e-03,  3.814621545158126e-06, -6.193084665177120e-09, -1.353678374843501e-12,  4.850313367040355e-14, -1.711366225672910e-16,
  2.483936688951733e-19,  5.579826604568845e-22, -4.583575723136943e-24,  1.331833214377466e-26, -9.334821940499079e-30,  3.810704022104113e-01, -1.594747048580963e-03,
  4.044012079404923e-06, -5.344450280688450e-09, -7.302199502672884e-12,  6.411806322564452e-14, -1.697972488451564e-16,  6.038837505206776e-20,  1.358664892690293e-21,
 -5.825278864002105e-24,  9.061615092240845e-27,  2.459501776764631e-29,  4.336066022578275e-01, -1.771597947023706e-03,  4.195916948279237e-06, -4.087371361226950e-09,
 -1.392736829309901e-11,  7.619930798506080e-14, -1.403128080745031e-16, -2.072300980220089e-19,  2.103823917465439e-21, -5.593060385630494e-24, -1.293919866515918e-27,
  6.515172800132602e-29,  4.890777108480311e-01, -1.946055640507234e-03,  4.256615589615048e-06, -2.427537517965902e-09, -2.079112817078649e-11,  8.235903512149281e-14,
 -7.945969752337721e-17, -5.211577684813154e-19,  2.555231848136661e-21, -3.309274306641627e-24, -1.623115078531927e-26,  9.439702838342160e-29,  5.473478869906221e-01,
 -2.115343522531741e-03,  4.213776755373613e-06, -3.949811080938948e-10, -2.734357012452461e-11,  8.038221697264262e-14,  1.134048780783599e-17, -8.255877576228252e-19,
  2.467604923326711e-21,  1.098272363023907e-24, -3.137142853538681e-26,  9.047740097653575e-29,  6.082639886188406e-01, -2.276537292400591e-03,  4.057064457823927e-06,
  1.953134621703527e-09, -3.294861330103658e-11,  6.857349437479394e-14,  1.248002871892704e-16, -1.047533262814766e-18,  1.661836549386695e-21,  6.930945894148185e-24,
 -4.003924902923949e-26,  3.771336994010329e-29,  6.716537187451156e-01, -2.426588107965325e-03,  3.778810330760794e-06,  4.530725345873825e-09, -3.692514815084336e-11,
  4.613976913446367e-14,  2.472431382511016e-16, -1.108656964044242e-18,  1.098776694158275e-22,  1.263039846480978e-23, -3.526389866640726e-26, -6.078273247483248e-29,
  7.373236194377816e-01, -2.562354262807635e-03,  3.374741726148969e-06,  7.222457772149962e-09, -3.860466725673032e-11,  1.356411380387987e-14,  3.591746930205978e-16,
 -9.434038266031781e-19, -1.991782202518714e-21,  1.600064019125821e-23, -1.305515685380712e-26, -1.740381316949107e-28,  8.050569261083624e-01, -2.680643220073064e-03,
  2.844745558940597e-06,  9.885419711519255e-09, -3.740477863958084e-11, -2.709279652942106e-14,  4.372963692065162e-16, -5.212989469357085e-19, -4.192076946078282e-21,
  1.481869677969745e-23,  2.400923240152412e-26, -2.458176052463307e-28,  8.746113052655049e-01, -2.778265990337855e-03,  2.193635516083594e-06,  1.235336599035494e-08,
 -3.291552131504061e-11, -7.204528305589597e-14,  4.581404130124255e-16,  1.311860869777287e-19, -5.832966297746088e-21,  7.777209588338322e-24,  6.467819631373924e-26,
 -2.150496821784547e-28,  9.457165131748609e-01, -2.852105907833720e-03,  1.431874452173513e-06,  1.444410399873992e-08, -2.499200009221235e-11, -1.158813975966361e-13,
  4.031833565909754e-16,  9.162574457964545e-19, -6.197967460036228e-21, -4.499454634359201e-24,  9.055971106876879e-26, -5.222517544712153e-29,  1.018072031501911e+00,
 -2.899203775648060e-03,  5.761846661518102e-07,  1.597047549272274e-08, -1.384261498414534e-11, -1.519951742615952e-13,  2.648092919882574e-16,  1.666467289636430e-18,
 -4.755814911365954e-21, -1.883367353784478e-23,  8.268822467576698e-26,  2.033141292135040e-28,  1.091344759707292e+00, -2.916861031986570e-03, -3.500429704919445e-07,
  1.675514592045903e-08, -9.747588617664787e-14, -1.734098124598188e-13,  5.189249117173362e-17,  2.170111703851893e-18, -1.446319715291258e-21, -2.983208713631255e-23,
  3.220126611779294e-26,  4.324515378905530e-28,  1.165166873240491e+00, -2.902761928897846e-03, -1.316652551946421e-06,  1.664898083858098e-08,  1.516267145601010e-11,
 -1.739842361803901e-13, -2.068124616129044e-16,  2.223324946914541e-18,  3.098804747782745e-21, -3.156954957776580e-23, -4.932337129157010e-26,  4.783248067033907e-28,
  1.239133991584300e+00, -2.855114584388328e-03, -2.287070683272426e-06,  1.555213139880895e-08,  3.043905389479345e-11, -1.498903438910694e-13, -4.635942273294234e-16,
  1.702449236494648e-18,  7.543155907982602e-21, -2.043992418206885e-23, -1.272806444986842e-25,  2.428334658308147e-28,  1.312803840396820e+00, -2.772809031316917e-03,
 -3.219240989009874e-06,  1.343605745990801e-08,  4.392942508451331e-11, -1.011094183410692e-13, -6.588302842933558e-16,  6.372836962290827e-19,  1.016310992524519e-20,
  1.889160887547202e-24, -1.559582361763277e-25, -2.086861551423299e-28,  1.385695635736234e+00, -2.655587917897561e-03, -4.067283968147308e-06,  1.036363864030128e-08,
  5.373681679810664e-11, -3.255035588532553e-14, -7.346754912242191e-16, -7.464634107344288e-19,  9.506020908541188e-21,  2.726928427235046e-23, -1.047366292630718e-25,
 -6.230471532128950e-28,  1.457290462385933e+00, -2.504222244778489e-03, -4.783989572200614e-06,  6.503411911298112e-09,  5.816782183293405e-11,  4.570644425858627e-14,
 -6.535108300242351e-16, -2.050901143881189e-18,  5.198529083751594e-21,  4.342170728278022e-23,  1.400274967607049e-26, -6.880228916803188e-28,  1.527032957228769e+00,
 -2.320680497304348e-03, -5.324181122318237e-06,  2.133117688107174e-09,  5.608943907155623e-11,  1.195082719228924e-13, -4.161289799565402e-16, -2.817020195191385e-18,
 -1.500660580284567e-21,  4.009934839951581e-23,  1.378053972236235e-25, -2.793044009571649e-28,  1.594334634464450e+00, -2.108274989948368e-03, -5.648873023241251e-06,
 -2.372427241384283e-09,  4.728066412817159e-11,  1.733034522523224e-13, -7.193711136794895e-17, -2.707200618673843e-18, -7.879093075326284e-21,  1.640061510563878e-23,
  1.853363355831052e-25,  3.609277531546352e-28,  1.658579191526150e+00, -1.871764711049045e-03, -5.729977979191601e-06, -6.573042518751686e-09,  3.268382398293802e-11,
  1.941300589108144e-13,  2.868516636593571e-16, -1.691720567260841e-18, -1.090508877349983e-20, -1.597203142341978e-23,  1.161418403732215e-25,  7.389633865823525e-28,
  1.719130099943899e+00, -1.617390326818012e-03, -5.555111926225621e-06, -1.001559981167644e-08,  1.444532756246704e-11,  1.759873256621373e-13,  5.510083750772191e-16,
 -1.333483411000902e-19, -8.945214729432743e-21, -3.800166711843063e-23, -2.558924009529012e-26,  5.260254895498119e-28,  1.775340700604943e+00, -1.352815526543029e-03,
 -5.131826620961002e-06, -1.230355765926042e-08, -4.346308157384445e-12,  1.230352560484316e-13,  6.351390098341815e-16,  1.321461592327527e-18, -3.041712554899836e-21,
 -3.604636919975910e-23, -1.335390370964451e-25, -8.093634741836458e-29,  1.826566876649633e+00, -1.086951061625347e-03, -4.490425059534535e-06, -1.317391399474851e-08,
 -2.025182727817430e-11,  4.988745938163914e-14,  5.177934047687456e-16,  2.044255907542253e-18,  3.381558294696245e-21, -1.309082139322453e-23, -1.273329363454929e-25,
 -5.019385473895752e-28,  1.872182165049157e+00, -8.296450769178215e-04, -3.684458750911302e-06, -1.256578388446584e-08, -3.031770119525369e-11, -2.208832501831039e-14,
  2.587347550650384e-16,  1.778227530057545e-18,  6.626289525562231e-21,  1.239432463850597e-23, -2.937371664805081e-26, -3.789747333380206e-28,  1.911594897279111e+00,
 -5.912364944510497e-04, -2.788147865793704e-06, -1.066112531815950e-08, -3.294538010132727e-11, -7.197633732823945e-14, -2.297726909160190e-17,  8.108183765843878e-19,
  5.339027611724424e-21,  2.174273251461815e-23,  5.784667588745606e-26,  3.429434808433747e-29,  1.944266656298291e+00, -3.819868884784228e-04, -1.890358442655221e-06,
 -7.879568450872064e-09, -2.849214197562006e-11, -8.754598316713042e-14, -2.065539416673744e-16, -2.004826453322112e-19,  1.469910902928998e-21,  1.246454300907368e-23,
  6.175538418169495e-26,  2.304614332441943e-28,  1.969731057872629e+00, -2.114282235449845e-04, -1.085402348386310e-06, -4.817647651796788e-09, -1.931787657584209e-11,
 -7.071158018959161e-14, -2.341222221640984e-16, -6.766087750708824e-19, -1.528208796283508e-21, -1.374005127591607e-24,  1.148387386535943e-26,  9.870037042111546e-29,
  1.987611792152448e+00, -8.768404668175970e-05, -4.616832405358301e-07, -2.137346496050526e-09, -9.148024398019656e-12, -3.693813740501922e-14, -1.418781264700672e-16,
 -5.192749935244496e-19, -1.804592897606264e-21, -5.895143917604077e-24, -1.771390308416839e-26, -4.654863175858796e-29,  1.997641160120884e+00, -1.681983243482507e-05,
 -8.981450163448451e-08, -4.254485215335880e-10, -1.884661412768043e-12, -7.990710985076447e-15, -3.282220890680287e-17, -1.315273542862406e-19, -5.163947323438674e-22,
 -1.991674419621641e-24, -7.558370895524740e-27, -2.824807578069493e-29,  4.562387755844605e-04, -2.193143018243069e-06,  7.905262697726191e-09, -2.532324067243193e-11,
  7.602388390102646e-14, -2.190314419413478e-16,  6.132296092469092e-19, -1.681096192183518e-21,  4.533644604926672e-24, -1.206915891958545e-26,  3.178197176711306e-29,
 -8.295230009983428e-32,  4.105330643191583e-03, -1.971044134707761e-05,  7.086018281075160e-08, -2.259544618709473e-10,  6.735917637326426e-13, -1.921274677736707e-15,
  5.306160764667847e-18, -1.428864938279155e-20,  3.766608695386330e-23, -9.745701689190425e-26,  2.477838443626563e-28, -6.196567322729512e-31,  1.139913577440770e-02,
 -5.459637357747083e-05,  1.952403642425090e-07, -6.168435165225063e-10,  1.812657919676075e-12, -5.063809123963223e-15,  1.358796949154059e-17, -3.519766201124071e-20,
  8.813322914090045e-23, -2.131120461604657e-25,  4.954592718645574e-28, -1.099033713483207e-30,  2.232882887650496e-02, -1.065528777960141e-04,  3.779960981784853e-07,
 -1.177492721696822e-09,  3.383897345624317e-12, -9.145380187761140e-15,  2.339896909141325e-17, -5.663868063176446e-20,  1.286356281630087e-22, -2.689038168377018e-25,
  4.939422264049714e-28, -6.943017786025691e-31,  3.688100081639310e-02, -1.751310437226494e-04,  6.145774190915150e-07, -1.877782467005528e-09,  5.230332105465310e-12,
 -1.346983601574467e-14,  3.200921664372212e-17, -6.895966348232188e-20,  1.281835400516512e-22, -1.748687381271398e-25,  1.219048045772440e-29,  1.086408302378538e-30,
  5.503745043075593e-02, -2.597289756956156e-04,  8.989652453288835e-07, -2.678734976950695e-09,  7.155664649369551e-12, -1.721045787222898e-14,  3.641795503205925e-17,
 -6.274067237463419e-20,  6.194220453275667e-23,  1.178207747163751e-25, -9.777682018894926e-28,  3.887683812978226e-30,  7.677490232436847e-02, -3.595890201378566e-04,
  1.223715638335916e-06, -3.533551002813889e-09,  8.935241766802609e-12, -1.949136417743350e-14,  3.383295132104397e-17, -3.115017194418238e-20, -7.890980090015039e-23,
  5.820028798865666e-25, -2.202179682363257e-27,  6.331450827250463e-30,  1.020646466634153e-01, -4.737944309021309e-04,  1.580019590694513e-06, -4.388933536539772e-09,
  1.032948892595925e-11, -1.948200084229325e-14,  2.218470354408766e-17,  2.781912679747827e-20, -2.796244204287426e-22,  1.098064060599882e-24, -3.095876325292438e-27,
  6.373641938774999e-30,  1.308720959325443e-01, -6.012655740597392e-04,  1.957781427667982e-06, -5.186713908119632e-09,  1.109957116737347e-11, -1.649946134860605e-14,
  6.205562567507973e-19,  1.096392936101281e-19, -4.989124667956641e-22,  1.465748924169261e-24, -2.950460104839213e-27,  2.201455688138149e-30,  1.631562525712675e-01,
 -7.407558089989875e-04,  2.345719617725995e-06, -5.865795048405080e-09,  1.102492313454917e-11, -1.011198177627744e-14, -3.008440021640789e-17,  2.024695969550103e-19,
 -6.724038331682964e-22,  1.448773931285406e-24, -1.187633351348772e-27, -6.567630283681712e-30,  1.988690803472642e-01, -8.908472271423598e-04,  2.731494527726029e-06,
 -6.364423543916385e-09,  9.922140913805156e-12, -2.354661198861886e-16, -6.726791549533821e-17,  2.876742594411191e-19, -7.234977265193460e-22,  8.487365292321240e-25,
  2.305918764927936e-27, -1.786047055356960e-29,  2.379547712806303e-01, -1.049946485484026e-03,  3.101868410250624e-06, -6.622795447844594e-09,  7.664536604207972e-12,
  1.278659872677983e-14, -1.063412982951204e-16,  3.418873119674833e-19, -5.812088520623624e-22, -4.050224180350791e-25,  6.893788408396167e-27, -2.690089124526411e-29,
  2.803488989365635e-01, -1.216281042120154e-03,  3.442903640454947e-06, -6.585989475229653e-09,  4.201419396070937e-12,  2.813082884259177e-14, -1.410322815784872e-16,
  3.406912883161699e-19, -2.028657608284758e-22, -2.172870141282282e-24,  1.109561877297784e-26, -2.726433366405335e-29,  3.259774480045390e-01, -1.387896187929325e-03,
  3.740205871783556e-06, -6.207203780852011e-09, -4.241153401105533e-13,  4.448118385338608e-14, -1.639557019179950e-16,  2.637109101277935e-19,  4.024523194974218e-22,
 -4.060338906294413e-24,  1.281395087020089e-26, -1.339564172678924e-29,  3.747557093537764e-01, -1.562653375733323e-03,  3.979219267360789e-06, -5.451247337397591e-09,
 -6.060428039322875e-12,  6.006794145806086e-14, -1.675287086622382e-16,  1.005822026268594e-19,  1.155715671377028e-21, -5.443826647061919e-24,  9.947599375743331e-27,
  1.589040381027402e-29,  4.265870293037670e-01, -1.738230478882016e-03,  4.145581158384147e-06, -4.298202170889891e-09, -1.243748867929457e-11,  7.276959243614423e-14,
 -1.452030470519434e-16, -1.431339133104209e-19,  1.902203210551256e-21, -5.590747229146716e-24,  1.329738979030574e-27,  5.419379578155737e-29,  4.813614018229617e-01,
 -1.912124768289450e-03,  4.225543199261131e-06, -2.747126535165567e-09, -1.916415251220684e-11,  8.028601872818799e-14, -9.292612792175886e-17, -4.414138040450656e-19,
  2.425392286014314e-21, -3.877691378143086e-24, -1.224725019364952e-26,  8.650375855702506e-29,  5.389538929712462e-01, -2.081659582794336e-03,  4.206465078422065e-06,
 -8.196099860531228e-10, -2.573503026231417e-11,  8.038594212080910e-14, -1.066621988055904e-17, -7.462261457028440e-19,  2.485522075147397e-21, -7.620167533080173e-26,
 -2.733899428169779e-26,  9.230891923249455e-29,  5.992228884052204e-01, -2.243995883059017e-03,  4.077384765088217e-06,  1.437081446001939e-09, -3.154953515528121e-11,
  7.122295887788815e-14,  9.624918543377108e-17, -9.906678197011401e-19,  1.882968457822866e-21,  5.367580713976745e-24, -3.801212673026358e-26,  5.376330120526635e-29,
  6.620081575294547e-01, -2.396150121968193e-03,  3.829665688481814e-06,  3.947617201592058e-09, -3.594552504855472e-11,  5.170190331465484e-14,  2.163163554730495e-16,
 -1.098142724473935e-18,  5.386153179646698e-22,  1.117486766784354e-23, -3.730662456863704e-26, -3.250712104303498e-29,  7.271287323677285e-01, -2.535020127879584e-03,
  3.457715615990186e-06,  6.607412614046803e-09, -3.824935767233656e-11,  2.186064874665438e-14,  3.319528601013205e-16, -9.980397437573491e-19, -1.426926819885601e-21,
  1.533382126670886e-23, -2.007154950558169e-26, -1.446448442932088e-28,  7.943806060358178e-01, -2.657420967057177e-03,  2.959763688420942e-06,  9.283173411194662e-09,
 -3.784294197490160e-11, -1.678749962961832e-14,  4.209033468088081e-16, -6.467454654552126e-19, -3.643896011480444e-21,  1.556590564978149e-23,  1.344194585435476e-26,
 -2.333811234993664e-28,  8.635342655491822e-01, -2.760133003286240e-03,  2.338670405726398e-06,  1.181578869203067e-08, -3.424628359214991e-11, -6.102665053796398e-14,
  4.592459953829435e-16, -5.050878028945462e-20, -5.508762826351378e-21,  1.016820737221581e-23,  5.471922236637046e-26, -2.359857518970565e-28,  9.343320874618640e-01,
 -2.839964565730710e-03,  1.602729712332971e-06,  1.402622504262959e-08, -2.721090233880064e-11, -1.059196711920253e-13,  4.260424779059269e-16,  7.160243982540707e-19,
 -6.295454652363769e-21, -9.400653407522513e-25,  8.700026470252583e-26, -1.084176238971517e-28,  1.006485643492872e+00, -2.893831709398192e-03,  7.664023253517391e-07,
  1.572503528398982e-08, -1.681527614219256e-11, -1.450976185208266e-13,  3.092424897937787e-16,  1.504087667785589e-18, -5.372318528666897e-21, -1.536735804549289e-23,
  9.012345851434881e-26,  1.341543695977545e-28,  1.079672987898642e+00, -2.918857418300904e-03, -1.491047522189545e-07,  1.672592895685278e-08, -3.548327328642818e-12,
 -1.714414475675510e-13,  1.118482013471699e-16,  2.106931393130606e-18, -2.492598306434526e-21, -2.817403037282779e-23,  5.041295435670160e-26,  3.928599282526031e-28,
  1.153536029878336e+00, -2.912492140088829e-03, -1.115524810306568e-06,  1.686349777471355e-08,  1.163844765056553e-11, -1.781905555108898e-13, -1.433444261549980e-16,
  2.303963660963537e-18,  1.931954901584460e-21, -3.311144352028096e-23, -2.755620272008273e-26,  5.078386224609356e-28,  1.227678133461169e+00, -2.872656599803171e-03,
 -2.097623797716065e-06,  1.601458596822693e-08,  2.733398351238448e-11, -1.604180208445003e-13, -4.126638112007626e-16,  1.931096952098379e-18,  6.718529326409479e-21,
 -2.528707110581775e-23, -1.143404485070882e-25,  3.438383111733917e-28,  1.301662134215380e+00, -2.797906238902416e-03, -3.053860571628545e-06,  1.412189836812589e-08,
  4.175075284565449e-11, -1.166704486492219e-13, -6.364317215519339e-16,  9.623714176191665e-19,  1.011692306746009e-20, -4.498990112030544e-24, -1.625881894376112e-25,
 -9.053485134901266e-29,  1.375009015719516e+00, -2.687614174307277e-03, -3.937786174458761e-06,  1.121725515870327e-08,  5.290797597170849e-11, -5.039812874750535e-14,
 -7.511762600371880e-16, -4.274251538258173e-19,  1.040580219571808e-20,  2.254340389347711e-23, -1.312102860300185e-25, -5.753841760010041e-28,  1.447197546253918e+00,
 -2.542166112095057e-03, -4.700337165039096e-06,  7.440538745724488e-09,  5.892055996372354e-11,  2.935332618576227e-14, -7.083717022684089e-16, -1.859489894564500e-18,
  6.764274583078440e-21,  4.335226555529976e-23, -1.803132166111881e-26, -7.643198291658782e-28,  1.517665232231774e+00, -2.363156122312788e-03, -5.293122079652744e-06,
  3.049100506361339e-09,  5.837332230539939e-11,  1.085706024846084e-13, -4.954533914283798e-16, -2.840907003641187e-18,  3.876047060887301e-23,  4.532022778130773e-23,
  1.220968819292601e-25, -4.359467579763949e-28,  1.585810990733963e+00, -2.153566727619454e-03, -5.672689201602788e-06, -1.588328146603788e-09,  5.072318359472541e-11,
  1.706394488125176e-13, -1.511694300093924e-16, -2.948424740785700e-18, -7.151671622840794e-21,  2.410154459667091e-23,  1.989041173717364e-25,  2.502501235528069e-28,
  1.650999966425641e+00, -1.917910853498320e-03, -5.805587550541002e-06, -6.018683292127581e-09,  3.663122681120000e-11,  2.004061502785199e-13,  2.345183319552720e-16,
 -2.048922324816762e-18, -1.138851025404298e-20, -1.066395610286289e-23,  1.495153377480717e-25,  7.736307276265814e-28,  1.712570901565776e+00, -1.662307769729525e-03,
 -5.673793898330430e-06, -9.755599951314890e-09,  1.809684109737605e-11,  1.891331057410926e-13,  5.430603662084732e-16, -4.416339794456225e-19, -1.032574447164698e-20,
 -3.852085490555899e-23,  6.714278640813111e-28,  6.689462267448352e-28,  1.769846392786887e+00, -1.394461700018095e-03, -5.279802638495809e-06, -1.235257236082807e-08,
 -1.730234665550003e-12,  1.387103685007281e-13,  6.705747820936227e-16,  1.202327870602781e-18, -4.436130849926824e-21, -4.143047732637909e-23, -1.349038331787032e-25,
  2.381138550602714e-29,  1.822146216713633e+00, -1.123512238157214e-03, -4.650421036315808e-06, -1.348926635972181e-08, -1.912511008575688e-11,  6.301312711776605e-14,
  5.764693994034223e-16,  2.143898694468539e-18,  2.813202935779437e-21, -1.863482601839043e-23, -1.500645538805417e-25, -5.289251304898262e-28,  1.868803666718499e+00,
 -8.597321822627295e-04, -3.838172094934208e-06, -1.305404648047246e-08, -3.069321278494786e-11, -1.525684244325070e-14,  3.115589682276399e-16,  1.997146946351038e-18,
  7.047073295138540e-21,  1.085888253419906e-23, -4.808883780720195e-26, -4.737662376351321e-28,  1.909184517894466e+00, -6.140624820949889e-04, -2.919291705592293e-06,
 -1.119978950036577e-08, -3.438847955318136e-11, -7.223531161012495e-14,  2.238399376117380e-18,  9.946399678335855e-19,  6.163681626261473e-21,  2.407585905806779e-23,
  5.851385688934290e-26, -6.372887903299904e-30,  1.942707853043453e+00, -3.974958599968114e-04, -1.987707167500906e-06, -8.349721233615723e-09, -3.029305998677505e-11,
 -9.256489257164951e-14, -2.114379610252393e-16, -1.457687991041096e-19,  1.965623589834434e-21,  1.514653084346575e-23,  7.256847602873616e-26,  2.612663361076913e-28,
  1.968867604837345e+00, -2.203480533792602e-04, -1.145116312774832e-06, -5.138359366505472e-09, -2.078986080252449e-11, -7.656342238945764e-14, -2.537586579966012e-16,
 -7.262052726557281e-19, -1.568287379279306e-21, -8.199561290771902e-25,  1.642342375809615e-26,  1.268455190741937e-28,  1.987253503007129e+00, -9.148265087348208e-05,
 -4.882346010901137e-07, -2.289815060938223e-09, -9.922050186654918e-12, -4.052441533190969e-14, -1.572591869817371e-16, -5.805584038263198e-19, -2.030077431719194e-21,
 -6.645951995054486e-24, -1.985833761514344e-26, -5.091664113611431e-29,  1.997572410684950e+00, -1.755929503514525e-05, -9.510622740282888e-08, -4.569257046603150e-10,
 -2.052661205964735e-12, -8.824572872324663e-15, -3.674752914763609e-17, -1.492600628796088e-19, -5.938504966828385e-22, -2.320410104290687e-24, -8.918418038229012e-27,
 -3.374404029323699e-29,  4.475907919090420e-04, -2.131096081527901e-06,  7.608540089011975e-09, -2.414111962346735e-11,  7.178670049475842e-14, -2.048627788510080e-16,
  5.681263791653348e-19, -1.542733005282845e-21,  4.121185164202759e-24, -1.086794376703000e-26,  2.834905732375171e-29, -7.330113439771700e-32,  4.027605723053961e-03,
 -1.915422535785092e-05,  6.821214808368751e-08, -2.154776119844186e-10,  6.364080324967052e-13, -1.798594779723876e-15,  4.922438886879449e-18, -1.313760902040621e-20,
  3.432965888432307e-23, -8.807010731455673e-26,  2.220620170972213e-28, -5.509362190534489e-31,  1.118382793187422e-02, -5.306357369288289e-05,  1.880089715841345e-07,
 -5.886338099929147e-10,  1.714564639019675e-12, -4.749212535360640e-15,  1.264079201109122e-17, -3.249641895688503e-20,  8.080656048053058e-23, -1.942292908910348e-25,
  4.494400579299298e-28, -9.944559964087831e-31,  2.190857709478064e-02, -1.035845219465348e-04,  3.641851010962375e-07, -1.124783643686126e-09,  3.206479404400347e-12,
 -8.602379189788407e-15,  2.186928632918520e-17, -5.267347544024439e-20,  1.193033992574169e-22, -2.497534383562042e-25,  4.636811643693405e-28, -6.799946374454238e-31,
  3.619016915053212e-02, -1.703031554841953e-04,  5.925373847108673e-07, -1.796211235293430e-09,  4.968463567457832e-12, -1.272432756278001e-14,  3.013482709341224e-17,
 -6.495833137098974e-20,  1.219078990379244e-22, -1.734973630940748e-25,  5.466826261628058e-29,  8.515107329391200e-31,  5.401271710171101e-02, -2.526639125254054e-04,
  8.674961627168556e-07, -2.566951120020859e-09,  6.820054678538050e-12, -1.635728017694642e-14,  3.468955203199288e-17, -6.069788074489079e-20,  6.551948433363855e-23,
  8.196751107644032e-26, -8.188145938116147e-28,  3.349386086374931e-30,  7.535586053658559e-02, -3.499665044352769e-04,  1.182158087299685e-06, -3.393661936086035e-09,
  8.553462348297052e-12, -1.869010637614581e-14,  3.292842660473053e-17, -3.335651976793670e-20, -5.947793919239375e-23,  4.992892154584862e-25, -1.938308600780525e-27,
  5.671710384451571e-30,  1.001944196220292e-01, -4.613621627887907e-04,  1.528331255461403e-06, -4.226749657899435e-09,  9.945231258052187e-12, -1.894119616754110e-14,
  2.284414282904315e-17,  1.948027294781560e-20, -2.422564252219910e-22,  9.797421157369252e-25, -2.822659839153221e-27,  6.039065484430268e-30,  1.284979681780742e-01,
 -5.858492908914991e-04,  1.896595535354504e-06, -5.011758862126797e-09,  1.076997041609386e-11, -1.644948531605529e-14,  3.474715083643324e-18,  9.449578882075978e-20,
 -4.482448578207990e-22,  1.349844582896696e-24, -2.840728213270984e-27,  2.755197293903648e-30,  1.602303192617280e-01, -7.222686270561038e-04,  2.276381673944247e-06,
 -5.691051541013868e-09,  1.081591008140080e-11, -1.076836115830839e-14, -2.470871613024050e-17,  1.817774678259514e-19, -6.211676397599901e-22,  1.396041411190026e-24,
 -1.435905600341877e-27, -4.770158157559567e-30,  1.953489154638778e-01, -8.692980653427265e-04,  2.656073538549922e-06, -6.205791989277892e-09,  9.901926338185751e-12,
 -1.755824876672512e-15, -5.953245158431051e-17,  2.650275200021663e-19, -6.914646064539642e-22,  9.261013568399815e-25,  1.582691845679913e-27, -1.506369891801773e-29,
  2.338041148684952e-01, -1.025447329078850e-03,  3.023138659161820e-06, -6.498252458632179e-09,  7.895511155521429e-12,  1.034716842694036e-14, -9.703066084755071e-17,
  3.231062884169170e-19, -5.911041219929743e-22, -1.521460054274462e-25,  5.769713227479635e-27, -2.419973020432889e-29,  2.755383623593637e-01, -1.189052756125170e-03,
  3.364293082469223e-06, -6.514446509085487e-09,  4.730956826283557e-12,  2.485972352121973e-14, -1.315949717730365e-16,  3.330313337285191e-19, -2.733875965819695e-22,
 -1.752838290202848e-24,  9.911787726254120e-27, -2.646830712121452e-29,  3.204852347238285e-01, -1.358272535860978e-03,  3.665707383292110e-06, -6.207083900097951e-09,
  4.267640255142185e-13,  4.063617758475484e-14, -1.564127740338866e-16,  2.743483419849503e-19,  2.653553850553976e-22, -3.560513031352602e-24,  1.215585872687642e-26,
 -1.634792090868114e-29,  3.685683468557133e-01, -1.531082840014039e-03,  3.913261438212673e-06, -5.538820742392618e-09, -4.899027140118424e-12,  5.608504883158335e-14,
 -1.642235536017905e-16,  1.345074849481804e-19,  9.670477865344202e-22, -5.034216496409021e-24,  1.047881757450945e-26,  8.462876476395540e-30,  4.197001053916854e-01,
 -1.705275416942716e-03,  4.092856144583105e-06, -4.485749441004463e-09, -1.101723542867476e-11,  6.924331918728456e-14, -1.483887674220706e-16, -8.546893714986881e-20,
  1.702440173233256e-21, -5.492956319385392e-24,  3.484668942155847e-27,  4.388015689640760e-29,  4.737802954602177e-01, -1.878457376191282e-03,  4.190790507344480e-06,
 -3.041032434191912e-09, -1.758169076820536e-11,  7.791611465211403e-14, -1.042207564646745e-16, -3.661220557803923e-19,  2.277871668140842e-21, -4.293993694044140e-24,
 -8.631866293948454e-27,  7.772336030522700e-29,  5.306944860696504e-01, -2.048054081312867e-03,  4.194212186330133e-06, -1.218529570741314e-09, -2.413151734173499e-11,
  7.988819862268825e-14, -3.044890920528548e-17, -6.669364464039580e-19,  2.464072999922229e-21, -1.088630725523435e-24, -2.328961663439157e-26,  9.133447208870270e-29,
  5.903122402760956e-01, -2.211316297474463e-03,  4.091648375305173e-06,  9.438007594009811e-10, -3.010418709908151e-11,  7.320705192933752e-14,  6.938104147417684e-17,
 -9.276096937464011e-19,  2.049438216034808e-21,  3.898248807430772e-24, -3.536636019870970e-26,  6.586456808424961e-29,  6.524851180142793e-01, -2.365333007649695e-03,
  3.873621333002378e-06,  3.381032767253393e-09, -3.486205003930321e-11,  5.652682888678390e-14,  1.858680699616694e-16, -1.074760650921792e-18,  9.137754721252172e-22,
  9.661683167899432e-24, -3.816806460102735e-26, -7.177234451887840e-30,  7.170444628289647e-01, -2.507051614978511e-03,  3.533348433048920e-06,  5.999343873925384e-09,
 -3.773476408820598e-11,  2.948752049367937e-14,  3.034502964691155e-16, -1.035035991252165e-18, -8.908138040784342e-22,  1.441254892134733e-23, -2.577185720135068e-26,
 -1.144291926463396e-28,  7.837989693469047e-01, -2.633307580488903e-03,  3.067519527692401e-06,  8.675542810209201e-09, -3.807920787095796e-11, -6.915781108149554e-15,
  4.012468759977942e-16, -7.543001941330029e-19, -3.076274482698778e-21,  1.590328541609651e-23,  3.562742639208753e-27, -2.147725678139650e-28,  8.525320369944956e-01,
 -2.740865886045953e-03,  2.477133886904843e-06,  1.125868191250244e-08, -3.535681357701752e-11, -5.004128445477571e-14,  4.554217469877586e-16, -2.205304318435243e-19,
 -5.105849297461285e-21,  1.214534042983255e-23,  4.405661878495568e-26, -2.470901585283122e-28,  9.229989282107782e-01, -2.826477027951727e-03,  1.768364076479348e-06,
  1.357446542403777e-08, -2.922553932010138e-11, -9.547683939382602e-14,  4.432704397472892e-16,  5.146897820409078e-19, -6.267942829370052e-21,  2.429681029825030e-24,
  8.113464864337708e-26, -1.567810932311698e-28,  9.949237674507102e-01, -2.886950480715687e-03,  9.533940623312098e-07,  1.543319246207098e-08, -1.963970151986519e-11,
 -1.371903376552586e-13,  3.488719988094392e-16,  1.324027932659328e-18, -5.859421074607281e-21, -1.166513831719745e-23,  9.447327954870708e-26,  6.359809124173429e-29,
  1.067996442015191e+00, -2.919248636418301e-03,  5.115313132037030e-08,  1.664189082200764e-08, -6.945584696555346e-12, -1.680590974678664e-13,  1.695760847759778e-16,
  2.011362136153067e-18, -3.466533443248510e-21, -2.582661421360831e-23,  6.656815189643228e-26,  3.394000373338303e-28,  1.141869498657520e+00, -2.920603996975037e-03,
 -9.121636970866999e-07,  1.702103757235693e-08,  8.045490673950976e-12, -1.808508119367441e-13, -7.814838911117511e-17,  2.346545280592094e-18,  7.255287050229389e-22,
 -3.376256829172671e-23, -4.932390876252764e-27,  5.171216270289608e-28,  1.216155172360208e+00, -2.888661702453381e-03, -1.902932271406103e-06,  1.642574351752767e-08,
  2.403108538266291e-11, -1.696496814799993e-13, -3.557261627909232e-16,  2.130673073771649e-18,  5.729765969759680e-21, -2.953081534552131e-23, -9.719594086128532e-26,
  4.331219750771534e-28,  1.290422736546649e+00, -2.821648098831781e-03, -2.880469383109030e-06,  1.477042305249161e-08,  3.926697118393522e-11, -1.315850650584831e-13,
 -6.049862719610944e-16,  1.282260782174222e-18,  9.837273924736505e-21, -1.104494582314383e-23, -1.637736905713620e-25,  3.786894312598994e-29,  1.364196427162515e+00,
 -2.718563727472406e-03, -3.798136392062862e-06,  1.205473615691868e-08,  5.171895920408876e-11, -6.853163399510285e-14, -7.583678628755115e-16, -8.251575239704448e-20,
  1.111697602546783e-20,  1.680928685204491e-23, -1.549321937132808e-25, -4.980565141608704e-28,  1.436954264568496e+00, -2.579395598633570e-03, -4.605377992570203e-06,
  8.387023276753044e-09,  5.933353246257908e-11,  1.175351178811388e-14, -7.571737804960125e-16, -1.618268235889827e-18,  8.303711234490520e-21,  4.194151204385932e-23,
 -5.287307298951268e-26, -8.145733886242689e-28,  1.508128172148367e+00, -2.405338703886397e-03, -5.250859544681390e-06,  3.999771865139339e-09,  6.041938960522935e-11,
  9.572685674564186e-14, -5.747296607324386e-16, -2.812659971356639e-18,  1.753146143473427e-21,  4.977328510300926e-23,  9.938753931675076e-26, -5.962380274024044e-28,
  1.577105859901199e+00, -2.199010426327328e-03, -5.686767808031327e-06, -7.496805456674021e-10,  5.409287483363138e-11,  1.659957084380066e-13, -2.367877731392707e-16,
 -3.161841015476486e-18, -6.138511651861880e-21,  3.223789160193118e-23,  2.068625563662611e-25,  1.060158559820966e-28,  1.643234990661295e+00, -1.964634180502653e-03,
 -5.874161948697210e-06, -5.400233117954990e-09,  4.069077308246594e-11,  2.053046596867584e-13,  1.719973572712515e-16, -2.418275984071396e-18, -1.165652011157445e-20,
 -3.998851315469187e-24,  1.837706824455515e-25,  7.777303522167505e-28,  1.705830155692865e+00, -1.708161175313583e-03, -5.788996692404749e-06, -9.435085938624331e-09,
  2.200863767466681e-11,  2.019795479219271e-13,  5.258605895324432e-16, -7.941804680937345e-19, -1.170452387619790e-20, -3.786196934537790e-23,  3.334944405231135e-26,
  8.166406836882185e-28,  1.764183129969889e+00, -1.437293298646748e-03, -5.428105197461585e-06, -1.235717688745078e-08,  1.207548645879326e-12,  1.551906890995700e-13,
  7.020209516698935e-16,  1.035470529880479e-18, -6.024167472096452e-21, -4.676801004078526e-23, -1.309826925547329e-25,  1.597878235956183e-28,  1.817576728628693e+00,
 -1.161368192497105e-03, -4.814084163340560e-06, -1.378441372008100e-08, -1.772158273707890e-11,  7.757825278617213e-14,  6.376495014583027e-16,  2.221983227747738e-18,
  2.028652878540086e-21, -2.510709484581222e-23, -1.736167763908440e-25, -5.381293067964001e-28,  1.865302323315071e+00, -8.910725222617455e-04, -3.997775901554933e-06,
 -1.354715323114729e-08, -3.091891277535038e-11, -7.082556720793886e-15,  3.706920479617726e-16,  2.228494172453726e-18,  7.398068098090442e-21,  8.487806485333178e-24,
 -7.124327860506460e-26, -5.806042547778362e-28,  1.906680694764942e+00, -6.379638690322178e-04, -3.057038112623892e-06, -1.176155002382988e-08, -3.583027408202571e-11,
 -7.182428614350588e-14,  3.298315941823161e-17,  1.206195751207236e-18,  7.072336279432104e-21,  2.639532587045338e-23,  5.704428304147798e-26, -6.344318456338622e-29,
  1.941085419889672e+00, -4.138066861646349e-04, -2.090873945475488e-06, -8.849497544506575e-09, -3.219539460612373e-11, -9.768074982716561e-14, -2.145527878750491e-16,
 -7.356117293422812e-20,  2.566002981322457e-21,  1.828847149890617e-23,  8.475895098492155e-26,  2.928762479233760e-28,  1.967967492108021e+00, -2.297613985341736e-04,
 -1.208824074681615e-06, -5.483585204021490e-09, -2.238370776827727e-11, -8.290332854135857e-14, -2.747984659979790e-16, -7.767244840612448e-19, -1.584547972542995e-21,
 -4.163909019155101e-26,  2.274711680945368e-26,  1.618373602416157e-28,  1.986879582731082e+00, -9.550120056017585e-05, -5.166923244419166e-07, -2.455262498228210e-09,
 -1.077163630114689e-11, -4.450127086505853e-14, -1.744613836258100e-16, -6.495067139903758e-19, -2.284181098684328e-21, -7.486348470001039e-24, -2.219208387361446e-26,
 -5.511294046932712e-29,  1.997500616272510e+00, -1.834264934393047e-05, -1.007923747519458e-07, -4.912295949959127e-10, -2.238322026849483e-12, -9.758892037992448e-15,
 -4.120592221874477e-17, -1.696716992833487e-19, -6.841811721427304e-22, -2.708707265653668e-24, -1.054485109133504e-26, -4.039498447900961e-29,  4.391863366607866e-04,
 -2.071367315225297e-06,  7.325605327615537e-09, -2.302458404663347e-11,  6.782237184091646e-14, -1.917315556752992e-16,  5.267188532183111e-19, -1.416902314129722e-21,
  3.749596765557273e-24, -9.795917183115914e-27,  2.531382026234969e-29, -6.484805300612423e-32,  3.952064080521471e-03, -1.861870068834499e-05,  6.568634529438155e-08,
 -2.055765626425315e-10,  6.015883554783560e-13, -1.684749216449679e-15,  4.569500839213094e-18, -1.208812030267400e-20,  3.131334610224348e-23, -7.965404745694315e-26,
  1.991826492908059e-28, -4.902787923509404e-31,  1.097453769348693e-02, -5.158729709473277e-05,  1.811068821511775e-07, -5.619444703719724e-10,  1.622541959658345e-12,
 -4.456466466222625e-15,  1.176606670042330e-17, -3.001909928013290e-20,  7.412761887972765e-23, -1.770982543466305e-25,  4.078012631738496e-28, -8.997747454402171e-31,
  2.149998169933443e-02, -1.007241714830620e-04,  3.509899328487384e-07, -1.074828330131948e-09,  3.039563180630455e-12, -8.094791385805854e-15,  2.044655045778609e-17,
 -4.899610321750462e-20,  1.106389661472985e-22, -2.317989186708097e-25,  4.341948805623979e-28, -6.594201878600300e-31,  3.551830249740519e-02, -1.656477422124260e-04,
  5.714515499523751e-07, -1.718713025355842e-09,  4.721064302994326e-12, -1.202248264729652e-14,  2.836967300145531e-17, -6.115672140939910e-20,  1.157098324384154e-22,
 -1.706214080835416e-25,  8.770876214941180e-29,  6.563480254308722e-31,  5.301574888841547e-02, -2.458453263945864e-04,  8.373368236809554e-07, -2.460402748365347e-09,
  6.501098139891054e-12, -1.554488599010860e-14,  3.301976426766531e-17, -5.856008560139862e-20,  6.791497401584866e-23,  5.201931711663119e-26, -6.820190649270151e-28,
  2.879153235377562e-30,  7.397465437735819e-02, -3.406698370996364e-04,  1.142243079195024e-06, -3.259754338081099e-09,  8.187486347616338e-12, -1.791123091525144e-14,
  3.197039617637138e-17, -3.498670982143408e-20, -4.284063191214902e-23,  4.265658678118765e-25, -1.702268397579567e-27,  5.066246969016032e-30,  9.837310681924287e-02,
 -4.493357202220009e-04,  1.478552597541249e-06, -4.070626590293371e-09,  9.571929718451570e-12, -1.838723554334857e-14,  2.328620957771046e-17,  1.227112132826625e-20,
 -2.089549437908434e-22,  8.720445583987070e-25, -2.564871102315077e-27,  5.675023652170805e-30,  1.261845397521467e-01, -5.709141865715221e-04,  1.837477506574881e-06,
 -4.842065851085119e-09,  1.044202076874447e-11, -1.633591829922923e-14,  5.926933890749426e-18,  8.090777818779317e-20, -4.016654127921676e-22,  1.238763883300098e-24,
 -2.710524332129622e-27,  3.137736806426799e-30,  1.573772384718458e-01, -7.043278187797881e-04,  2.209120175964319e-06, -5.519750446961062e-09,  1.059501362486457e-11,
 -1.130249322647473e-14, -1.988975602949369e-17,  1.626927554810564e-19, -5.719903475779041e-22,  1.334868629396851e-24, -1.611833005522535e-27, -3.272934562774569e-30,
  1.919137525371333e-01, -8.483446648867162e-04,  2.582553216084036e-06, -6.047717251687426e-09,  9.853110344811601e-12, -3.098023592575079e-15, -5.241636527989615e-17,
  2.434450545923910e-19, -6.571382312368372e-22,  9.769091702277740e-25,  9.758777375987594e-28, -1.256754904303877e-29,  2.297502049551345e-01, -1.001571973423769e-03,
  2.945924026314772e-06, -6.370392223709858e-09,  8.079888908124901e-12,  8.124855327801812e-15, -8.824901709992376e-17,  3.041458267958685e-19, -5.926766676967718e-22,
  5.812869489698112e-26,  4.763209768894886e-27, -2.156598206598645e-29,  2.708354867913689e-01, -1.162449781390023e-03,  3.286589756394305e-06, -6.434942091992248e-09,
  5.197318471838899e-12,  2.181229853051546e-14, -1.224015259882506e-16,  3.233475559798025e-19, -3.296310118341637e-22, -1.379330235229510e-24,  8.772383621653110e-27,
 -2.526627362337307e-29,  3.151103244037998e-01, -1.329244640287139e-03,  3.591289512201694e-06, -6.193955221958448e-09,  1.202575201959087e-12,  3.697529645853682e-14,
 -1.486307500327781e-16,  2.808812547364529e-19,  1.457497216368974e-22, -3.089317612899714e-24,  1.138935568449495e-26, -1.834892804764500e-29,  3.625062049577156e-01,
 -1.500043860574777e-03,  3.846361608796082e-06, -5.608444375027891e-09, -3.816417381211045e-12,  5.219221035481473e-14, -1.600507713949889e-16,  1.626348140783724e-19,
  7.934329111553509e-22, -4.609529233858871e-24,  1.071035464137859e-26,  2.256847520500644e-30,  4.129441444118275e-01, -1.672750776458159e-03,  4.038014568524720e-06,
 -4.651140480986182e-09, -9.668145149026868e-12,  6.565924556435388e-14, -1.500487195233525e-16, -3.412428862053797e-20,  1.507641869840188e-21, -5.317813947952479e-24,
  5.203270753147415e-27,  3.438362904920101e-29,  4.663332808887470e-01, -1.845081686376429e-03,  4.152661251056753e-06, -3.310012151149380e-09, -1.604916986694614e-11,
  7.529989121496099e-14, -1.134753637586708e-16, -2.957636126501413e-19,  2.117872600915497e-21, -4.573570220251407e-24, -5.414264452783888e-27,  6.848822021259417e-29,
  5.225692754243635e-01, -2.014565315873112e-03,  4.177325786447736e-06, -1.591897631264613e-09, -2.254252784720750e-11,  7.894220179722334e-14, -4.802635322248434e-17,
 -5.888851424833027e-19,  2.409075174369633e-21, -1.940651218776887e-24, -1.933517306456513e-26,  8.807966273595809e-29,  5.815325017764471e-01, -2.178545884555242e-03,
  4.100132568371673e-06,  4.739286710523730e-10, -2.862545961425264e-11,  7.456805088966885e-14,  4.434530279460339e-17, -8.600494708031792e-19,  2.165035146116728e-21,
  2.544285648282435e-24, -3.227065492573847e-26,  7.426501060778179e-29,  6.430860076116734e-01, -2.334191142445546e-03,  3.910885034414643e-06,  2.832516462947216e-09,
 -3.368932427988622e-11,  6.063015804305716e-14,  1.562343298347711e-16, -1.040249574596169e-18,  1.234100558297330e-21,  8.135361232018618e-24, -3.798812215170837e-26,
  1.477481728116648e-29,  7.070732314662359e-01, -2.478507075521275e-03,  3.601738738671525e-06,  5.400691445552295e-09, -3.707454770858150e-11,  3.641980640490297e-14,
  2.741467319298404e-16, -1.055448681279977e-18, -3.916505448258975e-22,  1.328982280628709e-23, -3.014704077467382e-26, -8.459524746077798e-29,  7.733154640466083e-01,
 -2.608361362906078e-03,  3.167967547822744e-06,  8.065684810935784e-09, -3.812299023816774e-11,  2.450104781694997e-15,  3.788344591062398e-16, -8.435712773033800e-19,
 -2.503409145592628e-21,  1.586337170119448e-23, -5.388257834577617e-27, -1.914315116463122e-28,  8.416090495798745e-01, -2.720518087488380e-03,  2.608812705680668e-06,
  1.068555773338874e-08, -3.624893187099496e-11, -3.920330786884504e-14,  4.470275062740336e-16, -3.766031252259449e-19, -4.639528365085883e-21,  1.368898153192138e-23,
  3.311222846458499e-26, -2.489183431686684e-28,  9.117223341743828e-01, -2.811686631692968e-03,  1.928390879862607e-06,  1.309216301859816e-08, -3.102764059792476e-11,
 -8.468797508765029e-14,  4.548912485090682e-16,  3.161272286363561e-19, -6.123832475729183e-21,  5.524867940814774e-24,  7.333928692996486e-26, -1.959551397860858e-28,
  9.833923849426947e-01, -2.878588082490327e-03,  1.136617922055281e-06,  1.509747393165774e-08, -2.229688715003521e-11, -1.283940858060530e-13,  3.832618540159876e-16,
  1.130540915901690e-18, -6.210857783507984e-21, -7.850726802346150e-24,  9.574562556857102e-26, -5.236004677179711e-30,  1.056321527701351e+00, -2.918042743726387e-03,
  2.500788940916746e-07,  1.650411205031502e-08, -1.026157497521339e-11, -1.633268287601392e-13,  2.242052717727888e-16,  1.886098972128538e-18, -4.344928670073068e-21,
 -2.288349772196809e-23,  8.011784491232880e-26,  2.749461732204498e-28,  1.130173784375667e+00, -2.927082383819053e-03, -7.072585096278314e-07,  1.712074975965443e-08,
  4.415049578005926e-12, -1.819364338880533e-13, -1.230282148160124e-17,  2.350321306140545e-18, -4.880055711940272e-22, -3.350662920857447e-23,  1.764739523070242e-26,
  5.058833451912888e-28,  1.204571335874847e+00, -2.903090449259619e-03, -1.703629780083701e-06,  1.678265371162449e-08,  2.055765265528679e-11, -1.774514925915077e-13,
 -2.936653292478865e-16,  2.296304147822071e-18,  4.601478215951051e-21, -3.301471023830707e-23, -7.646714151830898e-26,  5.060584941256536e-28,  1.279091194001785e+00,
 -2.843972398045528e-03, -2.699544043966823e-06,  1.537686492087491e-08,  3.649316346062338e-11, -1.456387368584940e-13, -5.647446303761010e-16,  1.589432913888345e-18,
  9.322494828728352e-21, -1.752361131184570e-23, -1.591925352803571e-25,  1.705394218914647e-28,  1.353262337944948e+00, -2.748356234310388e-03, -3.648562972711163e-06,
  1.287028547546044e-08,  5.016634105908296e-11, -8.671947366025613e-14, -7.556156942381597e-16,  2.816723919813417e-19,  1.160553923792813e-20,  1.020281119808772e-23,
 -1.746226403885404e-25, -3.925335334330228e-28,  1.426563656339309e+00, -2.615819895359687e-03, -4.499033175872315e-06,  9.337238155433258e-09,  5.938337179994519e-11,
 -6.930992047975442e-15, -7.985415597899303e-16, -1.328869968676431e-18,  9.766823380638860e-21,  3.910190440269325e-23, -8.924027422700689e-26, -8.327530742985855e-28,
  1.498423130949356e+00, -2.447137016617037e-03, -5.197001341671807e-06,  4.981022307416792e-09,  6.218965239300492e-11,  8.099631228228782e-14, -6.524241980804327e-16,
 -2.727176714510981e-18,  3.609797255978323e-21,  5.317767972479756e-23,  6.969899435531444e-26, -7.516711585223219e-28,  1.568218794036848e+00, -2.244525590039419e-03,
 -5.690462584795335e-06,  1.420255079864589e-10,  5.734867892399104e-11,  1.592293560724952e-13, -3.278834790986607e-16, -3.338101188612710e-18, -4.828330494541148e-21,
  4.055602669366186e-23,  2.077598454670866e-25, -7.026120736163717e-29,  1.635282072968768e+00, -2.011875305988751e-03, -5.934922269036910e-06, -4.716131500038148e-09,
  4.483244278055253e-11,  2.085778249093624e-13,  9.905236761999614e-17, -2.792102687364852e-18, -1.165997583063605e-20,  4.029316594645411e-24,  2.173883372594441e-25,
  7.433743902832125e-28,  1.698904178839647e+00, -1.754919735205109e-03, -5.899969389240950e-06, -9.049953624025684e-09,  2.617240993397413e-11,  2.142897854273968e-13,
  4.981772561181675e-16, -1.190203395536898e-18, -1.303448998098660e-20, -3.576621011799532e-23,  7.249436237579511e-26,  9.614507324040406e-28,  1.758346168728949e+00,
 -1.481310714379159e-03, -5.576169978302648e-06, -1.231210071804367e-08,  4.482076591787989e-12,  1.723637351963423e-13,  7.280550750137164e-16,  8.147641510105920e-19,
 -7.800001974840652e-21, -5.181932998711459e-23, -1.203502076983784e-25,  3.290993377092107e-28,  1.812853176253961e+00, -1.200547214506270e-03, -4.981144446754337e-06,
 -1.405469375439737e-08, -1.601190815380605e-11,  9.363487856755226e-14,  7.006281651375415e-16,  2.271051914548693e-18,  9.941070553023765e-22, -3.252273072447356e-23,
 -1.970500286611093e-25, -5.222056239308549e-28,  1.861673027344984e+00, -9.237134102912438e-04, -4.163313005505689e-06, -1.404248396223174e-08, -3.096640421597851e-11,
  2.589839286846997e-15,  4.364459347875481e-16,  2.469519348443511e-18,  7.645870277006855e-21,  5.093293239045584e-24, -9.933715447650491e-26, -6.979159262698638e-28,
  1.904079018898873e+00, -6.629945830034668e-04, -3.201663651421717e-06, -1.234627133040614e-08, -3.725597224415293e-11, -7.060094137605905e-14,  7.007100066179821e-17,
  1.448147904625303e-18,  8.062777174932025e-21,  2.860009547151338e-23,  5.263061708591212e-26, -1.408937946806561e-28,  1.939396054038996e+00, -4.309673610531100e-04,
 -2.200224050951758e-06, -9.380533080355185e-09, -3.420061848626584e-11, -1.028448222472741e-13, -2.153591403269869e-16,  1.976518076536404e-20,  3.288604164345160e-21,
  2.194577945916640e-23,  9.833203238119884e-26,  3.238142658110717e-28,  1.967028679811754e+00, -2.397014199682142e-04, -1.276831830473404e-06, -5.855354895534925e-09,
 -2.410951717596958e-11, -8.976519562621638e-14, -2.972555182417726e-16, -8.272637560357357e-19, -1.567844017868717e-21,  1.022748973035831e-24,  3.078742998929769e-26,
  2.051335082677927e-28,  1.986489120024311e+00, -9.975559079198170e-05, -5.472196765289935e-07, -2.634962715183080e-09, -1.170504929795457e-11, -4.891509319665033e-14,
 -1.937126501336422e-16, -7.270887812063396e-19, -2.570262842255111e-21, -8.423673812533118e-24, -2.470133520491094e-26, -5.883394110020312e-29,  1.997425594784167e+00,
 -1.917319137691386e-05, -1.069086282522606e-07, -5.286595636420060e-10, -2.443787283567947e-12, -1.080741096274638e-14, -4.627850366420747e-17, -1.932107282343407e-19,
 -7.897356709927922e-22, -3.168310288599225e-24, -1.249401071212963e-26, -4.846104584244330e-29,  4.310163528818411e-04, -2.013849491989065e-06,  7.055696912508137e-09,
 -2.196942955378407e-11,  6.411100843245390e-14, -1.795531428339407e-16,  4.886737538885450e-19, -1.302367688120301e-21,  3.414502685215250e-24, -8.838178246303777e-27,
  2.262709986257104e-29, -5.743538017542389e-32,  3.878624863155811e-03, -1.810291649163326e-05,  6.327608608228054e-08, -1.962148632756007e-10,  5.689632096309979e-13,
 -1.579032171333559e-15,  4.244641485548419e-18, -1.113047748170681e-20,  2.858416185700803e-23, -7.210193228306000e-26,  1.788133013890909e-28, -4.366917961003398e-31,
  1.077104412169188e-02, -5.016498071623458e-05,  1.745164201974288e-07, -5.366817717347897e-10,  1.536169763727116e-12, -4.183905017629189e-15,  1.095780464262744e-17,
 -2.774595172422314e-20,  6.803639381265455e-23, -1.615521671671670e-25,  3.701268800654174e-28, -8.141163811513240e-31,  2.110262031656039e-02, -9.796702915207990e-05,
  3.383785334990372e-07, -1.027464282904547e-09,  2.882465437195248e-12, -7.620144387113989e-15,  1.912299490021612e-17, -4.558587682659222e-20,  1.025998970004116e-22,
 -2.150043180645912e-25,  4.057175400359990e-28, -6.344009573838650e-31,  3.486472592025971e-02, -1.611573619452196e-04,  5.512723992432983e-07, -1.645063174434711e-09,
  4.487286806518208e-12, -1.136174639690080e-14,  2.670820454360124e-17, -5.755155412799621e-20,  1.096371144248340e-22, -1.665852742179091e-25,  1.129218011157963e-28,
  4.947824267086565e-31,  5.204558044702592e-02, -2.392629861895992e-04,  8.084259744601474e-07, -2.358829855166281e-09,  6.197993625110643e-12, -1.477184070777739e-14,
  3.141075316737711e-17, -5.636186825167015e-20,  6.932600257966374e-23,  2.714742132945771e-26, -5.645607431909242e-28,  2.469198598392611e-30,  7.263000628533688e-02,
 -3.316861606338997e-04,  1.103900338541576e-06, -3.131578999752393e-09,  7.836854532465484e-12, -1.715583812318585e-14,  3.097379305588931e-17, -3.612462362760650e-20,
 -2.865769355654963e-23,  3.627669977644248e-25, -1.491700107482609e-27,  4.513578631635678e-30,  9.659911505131681e-02, -4.377001137039128e-04,  1.430611946783460e-06,
 -3.920387203675854e-09,  9.209797744391153e-12, -1.782497068605737e-14,  2.354077029105350e-17,  6.067541777951951e-21, -1.793488777185190e-22,  7.743327886474657e-25,
 -2.323481271350195e-27,  5.295715993655768e-30,  1.239299186260277e-01, -5.564439702267892e-04,  1.780364395727756e-06, -4.677598792359565e-09,  1.011690103156751e-11,
 -1.616789882961670e-14,  8.018962166930568e-18,  6.874736278891019e-20, -3.589874658216827e-22,  1.133184901365361e-24, -2.566653894016816e-27,  3.381313131786654e-30,
  1.545948576641401e-01, -6.869169408905771e-04,  2.143892752392532e-06, -5.352063051933465e-09,  1.036454870348510e-11, -1.172720697079055e-14, -1.558347647518834e-17,
  1.451452468174168e-19, -5.251268005445657e-22,  1.267896226276588e-24, -1.727803575138586e-27, -2.038943547044847e-30,  1.885612388793730e-01, -8.279718546818445e-04,
  2.510924247785083e-06, -5.890629245620842e-09,  9.779109936870925e-12, -4.276562293567356e-15, -4.588896699918915e-17,  2.229858235425960e-19, -6.213939972798494e-22,
  1.005554949072445e-24,  4.724849994662053e-28, -1.036035724874113e-29,  2.257905708140865e-01, -9.783081506938524e-04,  2.870259986424805e-06, -6.239926244097300e-09,
  8.221884990218128e-12,  6.106931999530889e-15, -7.999788686532094e-17,  2.852486166076764e-19, -5.873763552540080e-22,  2.304299512754030e-25,  3.870199318938092e-27,
 -1.904756855243638e-29,  2.662377860845065e-01, -1.136464494755758e-03,  3.209883281314737e-06, -6.348451584007821e-09,  5.604915082269763e-12,  1.898207122568810e-14,
 -1.135024636903277e-16,  3.120704425214019e-19, -3.732349060438306e-22, -1.050248167775487e-24,  7.692575246829885e-27, -2.377739638666863e-29,  3.098503362685670e-01,
 -1.300811251983164e-03,  3.517101279963253e-06, -6.168989103605839e-09,  1.907049088823988e-12,  3.350296193124796e-14, -1.407168808142828e-16,  2.838521201483978e-19,
  4.253625389424275e-23, -2.650296919781686e-24,  1.055295282527985e-26, -1.954926162855517e-29,  3.565671436967752e-01, -1.469543133115838e-03,  3.778727675382014e-06,
 -5.661363407710006e-09, -2.810602315703329e-12,  4.840835582006703e-14, -1.551658952776354e-16,  1.854523610024168e-19,  6.352108003737901e-22, -4.180699838886078e-24,
  1.069422235374898e-26, -2.810123016948249e-30,  4.063173924698253e-01, -1.640672445858911e-03,  3.981315441458414e-06, -4.795521216643379e-09, -8.391021894684140e-12,
  6.205188678257094e-14, -1.503572532995204e-16,  1.110016233668173e-20,  1.320287800269082e-21, -5.082017816309419e-24,  6.524108322548880e-27,  2.581321072297790e-29,
  4.590191391491271e-01, -1.812023528844389e-03,  4.111449596177992e-06, -3.554901538151614e-09, -1.457103799358728e-11,  7.248461065151740e-14, -1.208329548200302e-16,
 -2.306621342199612e-19,  1.950027012015642e-21, -4.732620914838619e-24, -2.606247669185990e-27,  5.915956169329736e-29,  5.145777218905579e-01, -1.981229132677338e-03,
  4.156110816246391e-06, -1.940015401236376e-09, -2.097650099951250e-11,  7.760034542360344e-14, -6.344739502884019e-17, -5.130543186595314e-19,  2.326212157178577e-21,
 -2.637915558884807e-24, -1.556470704957550e-26,  8.305339357001226e-29,  5.728839455355814e-01, -2.145729747878016e-03,  4.103121048499126e-06,  2.790198581677269e-11,
 -2.712536552859304e-11,  7.535126618807294e-14,  2.124588440663931e-17, -7.895454683465117e-19,  2.234198095566944e-21,  1.320527741933623e-24, -2.888054629841832e-26,
  7.930965236704532e-29,  6.338120196601031e-01, -2.302777171443583e-03,  3.941681705818912e-06,  2.303382009794741e-09, -3.244155999273919e-11,  6.403498077715952e-14,
  1.277021655681725e-16, -9.963640411866470e-19,  1.499830844263746e-21,  6.634503842896040e-24, -3.692111096301367e-26,  3.312235851134213e-29,  6.972172272757432e-01,
 -2.449443959068785e-03,  3.663013047002674e-06,  4.813673270805955e-09, -3.628275559651360e-11,  4.264371458696546e-14,  2.444889349848180e-16, -1.060566065279336e-18,
  6.425779574328355e-23,  1.201799984934811e-23, -3.323685997733857e-26, -5.615297936527114e-29,  7.629333044374702e-01, -2.582640832212780e-03,  3.261099153436703e-06,
  7.456594797104519e-09, -3.798502564321155e-11,  1.125016531599374e-14,  3.541783988427610e-16, -9.146006869041143e-19, -1.938167997685485e-21,  1.548702665531830e-23,
 -1.323498200540842e-26, -1.648160376974668e-28,  8.307695163421939e-01, -2.699144594602017e-03,  2.733535504572822e-06,  1.009988133688811e-08, -3.692665030239944e-11,
 -2.861749894264440e-14,  4.344798935736280e-16, -5.169489062407433e-19, -4.125512465070931e-21,  1.479577553065875e-23,  2.227517599855358e-26, -2.423875674817667e-28,
  9.005074248266204e-01, -2.795639645205968e-03,  2.082464217255051e-06,  1.258276648489352e-08, -3.261162281345000e-11, -7.368630655968005e-14,  4.610331706293983e-16,
  1.238956553118930e-19, -5.874297119869440e-21,  8.276668112560408e-24,  6.403812102539708e-26, -2.251412768441185e-28,  9.718973570923520e-01, -2.868776716978704e-03,
  1.315564015298394e-06,  1.472069081259661e-08, -2.477033903493795e-11, -1.188386327764189e-13,  4.120973087342904e-16,  9.280089887100229e-19, -6.424779414507366e-21,
 -4.044849052567841e-24,  9.407975683006119e-26, -6.952345501091131e-29,  1.044654608036015e+00, -2.915252952612981e-03,  4.470363271938484e-07,  1.631410458525614e-08,
 -1.347010895853594e-11, -1.573286227653427e-13,  2.749502101404455e-16,  1.734521297498887e-18, -5.108322673428457e-21, -1.945762090855070e-23,  9.065033556696691e-26,
  2.028302804471158e-28,  1.118455441212000e+00, -2.931917731550829e-03, -5.015057367368800e-07,  1.716228700969486e-08,  7.786849234914591e-13, -1.814448668963558e-13,
  5.310743209580961e-17,  2.315584650168504e-18, -1.676241571008393e-21, -3.236328052120646e-23,  3.929458463075390e-26,  4.749587739597537e-28,  1.192932999018535e+00,
 -2.915908600545111e-03, -1.500382698895764e-06,  1.708282312161155e-08,  1.694343240111201e-11, -1.837123815633077e-13, -2.274899777560260e-16,  2.423989258419756e-18,
  3.363417084428007e-21, -3.561095354053931e-23, -5.296008773317113e-26,  5.588672704213413e-28,  1.267673294062215e+00, -2.864820960818437e-03, -2.511616785484600e-06,
  1.593673264134180e-08,  3.344862643250821e-11, -1.586254748245485e-13, -5.161675343930748e-16,  1.876447185954165e-18,  8.579188195103358e-21, -2.370246843061542e-23,
 -1.487999560525193e-25,  3.009167294337690e-28,  1.342211533223885e+00, -2.776913457343271e-03, -3.489363995684372e-06,  1.365808993415281e-08,  4.825146079864076e-11,
 -1.047173523761164e-13, -7.424841643714911e-16,  6.575467621749515e-19,  1.184328105258733e-20,  2.909196232062572e-24, -1.891080298155089e-25, -2.621706968815684e-28,
  1.416029124637886e+00, -2.651347838418597e-03, -4.381293494809787e-06,  1.028520984826063e-08,  5.905027605399345e-11, -2.650589867740800e-14, -8.311680889642104e-16,
 -9.945694207949673e-19,  1.110142798732812e-20,  3.480215835797536e-23, -1.256116152284485e-25, -8.141135614056384e-28,  1.488551833455141e+00, -2.488456905235012e-03,
 -5.131208235950985e-06,  5.988139689461937e-09,  6.364688662532332e-11,  6.443663966912462e-14, -7.268767105360244e-16, -2.580562065321174e-18,  5.566013590625536e-21,
  5.526129493973841e-23,  3.345424966217898e-26, -8.925843955506333e-28,  1.559149677406568e+00, -2.290026635560924e-03, -5.683149186675607e-06,  1.084621432688234e-09,
  6.044691889802110e-11,  1.502224975175955e-13, -4.232825320622981e-16, -3.467653085887684e-18, -3.219998816027580e-21,  4.874630757771099e-23,  2.002657847167326e-25,
 -2.745106346577025e-28,  1.627139272197055e+00, -2.059568546286186e-03, -5.987073927218056e-06, -3.965338136327417e-09,  4.902122224877112e-11,  2.099749683525914e-13,
  1.568395999607222e-17, -3.161159943758403e-18, -1.135069425787214e-20,  1.335899314852242e-23,  2.485130412825555e-25,  6.633100167257390e-28,  1.691789423077009e+00,
 -1.802546439316206e-03, -6.005912778850185e-06, -8.596271270003266e-09,  3.057482024512877e-11,  2.257978308932250e-13,  4.588230241099149e-16, -1.627263581989611e-18,
 -1.425931447099509e-20, -3.198018575599662e-23,  1.177700106797243e-25,  1.093500295773710e-27,  1.752330773506474e+00, -1.526509567717883e-03, -5.723368052273215e-06,
 -1.221185268440323e-08,  8.105779199230328e-12,  1.900808567718797e-13,  7.470871806934883e-16,  5.344187593999074e-19, -9.748142389236161e-21, -5.628638413547281e-23,
 -1.015234273176453e-25,  5.321448520429978e-28,  1.807970214974742e+00, -1.241075202251245e-03, -5.151273097317689e-06, -1.429496741447066e-08, -1.396589529161183e-11,
  1.112154853406455e-13,  7.644758629116465e-16,  2.282564735618300e-18, -3.240216903807782e-22, -4.085243663991359e-23, -2.190753961313351e-25, -4.726445238078238e-28,
  1.857910481585843e+00, -9.577023686745513e-04, -4.334791969576935e-06, -1.453693892078010e-08, -3.080411603579900e-11,  1.392208816804914e-14,  5.090395652923930e-16,
  2.716291821167287e-18,  7.749975540660125e-21,  4.693302273582014e-25, -1.327698487403889e-25, -8.226215035849158e-28,  1.901374861184871e+00, -6.892107535123214e-04,
 -3.353441742404639e-06, -1.295355734112413e-08, -3.864773486596313e-11, -6.840253911227294e-14,  1.143888683883883e-16,  1.723022963775141e-18,  9.128527742854283e-21,
  3.055318779224229e-23,  4.427951039025419e-26, -2.431890491511750e-28,  1.937636254748019e+00, -4.490288797636254e-04, -2.316142493500289e-06, -9.944478564285140e-09,
 -3.630909164115227e-11, -1.079941510772438e-13, -2.132080738827851e-16,  1.384287925591889e-19,  4.152963440227180e-21,  2.617257710959546e-23,  1.132125318225276e-25,
  3.518667652595924e-28,  1.966048990374457e+00, -2.502038284366173e-04, -1.349471125268335e-06, -6.255865199872349e-09, -2.597806777016991e-11, -9.718291503850751e-14,
 -3.211139613281397e-16, -8.765894506203832e-19, -1.506548576144817e-21,  2.449662628146446e-24,  4.094622056988763e-26,  2.584323873580509e-28,  1.986081137294278e+00,
 -1.042630862150836e-04, -5.799960353710636e-07, -2.830329612910229e-09, -1.273154048263628e-11, -5.381807985005412e-14, -2.152695918493290e-16, -8.143850420567475e-19,
 -2.891932364487222e-21, -9.464411282848494e-24, -2.735602484428338e-26, -6.163676660294858e-29,  1.997347150341902e+00, -2.005451760080941e-05, -1.134944801193139e-07,
 -5.695515852294818e-10, -2.671495764340456e-12, -1.198597848491797e-14, -5.206006514968662e-17, -2.204080027846716e-19, -9.133291831836642e-22, -3.713463433815186e-24,
 -1.483500330107080e-26, -5.826464682799052e-29,  4.230722006517828e-04, -1.958441279954687e-06,  6.798101940405364e-09, -2.097175687125437e-11,  6.063433609181289e-14,
 -1.682505093101930e-16,  4.536905409579716e-19, -1.198024535238300e-21,  3.112028847234776e-24, -7.981660425831072e-27,  2.024617745785470e-29, -5.092739659661473e-32,
  3.807210917599143e-03, -1.760597372310615e-05,  6.097510367411492e-08, -1.873586661892334e-10,  5.383765604179184e-13, -1.480799605744241e-15,  3.945413233397424e-18,
 -1.025597129169578e-20,  2.611273879167174e-23, -6.531931977447960e-26,  1.606623310089489e-28, -3.893104517843946e-31,  1.057313625535546e-02, -4.879419850951744e-05,
  1.682209954311634e-07, -5.127584511238391e-10,  1.455059857696860e-12, -3.929999599807522e-15,  1.021054395135692e-17, -2.565905244752907e-20,  6.247858802635366e-23,
 -1.474401493671864e-25,  3.360380039507331e-28, -7.366681794409231e-31,  2.071608926100000e-02, -9.530854656180534e-05,  3.263207290964788e-07, -9.825395500193234e-10,
  2.734550566901601e-12, -7.176145404160426e-15,  1.789141351636978e-17, -4.242344458996765e-20,  9.514520415160473e-23, -1.993258182450954e-25,  3.784116319978832e-28,
 -6.063850322395520e-31,  3.422879350669640e-02, -1.568249422879087e-04,  5.319550332663263e-07, -1.575050178284094e-09,  4.266333346246548e-12, -1.073969587135290e-14,
  2.514498334530388e-17, -5.413820774270586e-20,  1.037262172124085e-22, -1.616740986460501e-25,  1.316672555575945e-28,  3.615688230143350e-31,  5.110128639754866e-02,
 -2.329071385624315e-04,  7.807054053951112e-07, -2.261985024100462e-09,  5.909968861843529e-12, -1.403666878431912e-14,  2.986379595234215e-17, -5.413195172768609e-20,
  6.992201367446635e-23,  6.629250354631969e-27, -4.639453010708247e-28,  2.112461892631244e-30,  7.132068902351427e-02, -3.230031679093008e-04,  1.067062535615972e-06,
 -3.008894217126710e-09,  7.501089063871593e-12, -1.642469692479370e-14,  2.995134834437094e-17, -3.684385262842994e-20, -1.662562841510237e-23,  3.069195699566979e-25,
 -1.304328161299145e-27,  4.011445584250708e-30,  9.487090993931482e-02, -4.264409185447126e-04,  1.384439776008821e-06, -3.775851691491970e-09,  8.858958632054933e-12,
 -1.725857690330957e-14,  2.363437857484526e-17,  7.569051157297385e-22, -1.530906760388197e-22,  6.859408554397579e-25, -2.098910357866234e-27,  4.912098481867650e-30,
  1.217322769305229e-01, -5.424228525100332e-04,  1.725193797510416e-06, -4.518304151344114e-09,  9.795616973555505e-12, -1.595360572928368e-14,  9.789055168360152e-18,
  5.789295773184437e-20, -3.200045114981483e-22,  1.033540427742698e-24, -2.414610396742054e-27,  3.513405913007448e-30,  1.518810893841514e-01, -6.700198966913368e-04,
  2.080655190358108e-06, -5.188125598490843e-09,  1.012658408278678e-11, -1.205429876735546e-14, -1.174790053775365e-17,  1.290580022426945e-19, -4.807453129694786e-22,
  1.197301165679636e-24, -1.794631970989603e-27, -1.033752761623250e-30,  1.852890823069184e-01, -8.081645578642203e-04,  2.441172480729391e-06, -5.734905492981737e-09,
  9.683059600502402e-12, -5.305187667759863e-15, -3.991828537075158e-17,  2.036832068108191e-19, -5.849582977153312e-22,  1.015925807352974e-24,  6.014608577965642e-29,
 -8.425743981029893e-30,  2.219227913053040e-01, -9.556433422913315e-04,  2.796173872446878e-06, -6.107500614915549e-09,  8.325460140622633e-12,  4.280710990469659e-15,
 -7.227261938957409e-17,  2.666135821856709e-19, -5.764898364785630e-22,  3.691852231205367e-25,  3.084826628275204e-27, -1.667778684996595e-29,  2.617428059447982e-01,
 -1.111088601738565e-03,  3.134251990945333e-06, -6.255880872305563e-09,  5.958016575569599e-12,  1.636148528600209e-14, -1.049369727932095e-16,  2.995793515618284e-19,
 -4.057529458007098e-22, -7.629864985847877e-25,  6.682726054352625e-27, -2.210118273662002e-29,  3.047028968359033e-01, -1.272969984757306e-03,  3.443278012387097e-06,
 -6.133296635149577e-09,  2.543980483947105e-12,  3.022119962648531e-14, -1.327637375905216e-16,  2.837664825853032e-19, -4.548553095987935e-23, -2.245584492023595e-24,
  9.678750524634247e-27, -2.008924148769570e-29,  3.507489995595929e-01, -1.439585749365119e-03,  3.710552795680924e-06, -5.698788239078795e-09, -1.879243116798924e-12,
  4.474884712643066e-14, -1.497106938479075e-16,  2.034532643983576e-19,  4.923640704912489e-22, -3.756661158585655e-24,  1.047838773917403e-26, -6.838049361580414e-30,
  3.998180361744366e-01, -1.609054296657690e-03,  3.923003968383859e-06, -4.920045141512070e-09, -7.186020761747609e-12,  5.845164932350171e-14, -1.494820924327142e-16,
  5.047457799290430e-20,  1.142285117290185e-21, -4.800643667286284e-24,  7.489325399871494e-27,  1.822431335476097e-29,  4.518365526034498e-01, -1.779306421528613e-03,
  4.067439281818412e-06, -3.776600245582594e-09, -1.315083305958958e-11,  6.951401053423090e-14, -1.264436101791726e-16, -1.710024508270855e-19,  1.778378772800214e-21,
 -4.787520825167465e-24, -2.052791007124232e-28,  5.002839920928063e-29,  5.067191477915669e-01, -1.948078955103537e-03,  4.130867822577984e-06, -2.263310831471512e-09,
 -1.944084198822793e-11,  7.591354140645673e-14, -7.678586509947591e-17, -4.402480856945406e-19,  2.220905225272430e-21, -3.189199099903704e-24, -1.204557420101428e-26,
  7.673011299718572e-29,  5.643666683364418e-01, -2.112910703616933e-03,  4.100901638629791e-06, -3.940273260565949e-10, -2.561498997108503e-11,  7.560399512157192e-14,
  1.451289492128748e-19, -7.175065846380618e-19,  2.261791895093318e-21,  2.359148507719359e-25, -2.533487307105880e-26,  8.140714811721551e-29,  6.246641406107276e-01,
 -2.271141881196502e-03,  3.966250677001837e-06,  1.794719785373328e-09, -3.113244268263670e-11,  6.677068839669522e-14,  1.005097883222503e-16, -9.448298805576424e-19,
  1.712483263098928e-21,  5.191395859489848e-24, -3.512726557302636e-26,  4.781822073346352e-29,  6.874784116428166e-01, -2.419918600445623e-03,  3.717323131721577e-06,
  4.240280901786998e-09, -3.537360646072098e-11,  4.815572166713122e-14,  2.148850590642885e-16, -1.051848392494703e-18,  4.724521258402379e-22,  1.064701922872856e-23,
 -3.512090338921838e-26, -2.990126255789099e-29,  7.526554708363006e-01, -2.556204434304867e-03,  3.346940625619070e-06,  6.851087435366673e-09, -3.767712788433294e-11,
  1.943664380732112e-14,  3.277842879518863e-16, -9.678173997921612e-19, -1.391836589872854e-21,  1.482088399492983e-23, -1.986450939945535e-26, -1.363273880039899e-28,
  8.200174278902630e-01, -2.676801600153332e-03,  2.851172055801124e-06,  9.505037510616483e-09, -3.739597253524092e-11, -1.837809638049755e-14,  4.182382755405494e-16,
 -6.402916314021189e-19, -3.579365173394774e-21,  1.547703878311833e-23,  1.188794738357947e-26, -2.286847827175207e-28,  8.893591292979204e-01, -2.778384937131054e-03,
  2.230280016036315e-06,  1.204979269910717e-08, -3.397452853610565e-11, -6.260083047979719e-14,  4.619187676794056e-16, -5.883988637462397e-20, -5.532675862249686e-21,
  1.063375075452123e-23,  5.367802783827927e-26, -2.440905280631113e-28,  9.604444082756702e-01, -2.857552526330804e-03,  1.489757682833549e-06,  1.430589699688962e-08,
 -2.704622415518155e-11, -1.086598270977732e-13,  4.351865068109088e-16,  7.208054713062240e-19, -6.503553694977731e-21, -3.602935961817130e-25,  8.973009758915832e-26,
 -1.268739330589275e-28,  1.033001983193971e+00, -2.910897485574501e-03,  6.414098205563411e-07,  1.607378496962681e-08, -1.654685758755746e-11, -1.501661120711326e-13,
  3.211280572475116e-16,  1.560563331194311e-18, -5.741580260525349e-21, -1.567537381198646e-23,  9.790653487704444e-26,  1.266196571104280e-28,  1.106721050463921e+00,
 -2.935106051103277e-03, -2.956030082136280e-07,  1.714580596350271e-08, -2.832250735900289e-12, -1.793993780613939e-13,  1.170200918171360e-16,  2.243647139035359e-18,
 -2.808108501633732e-21, -3.038666671704031e-23,  5.918091305575005e-26,  4.262357219659101e-28,  1.181246662923560e+00, -2.927087359067539e-03, -1.293884399469249e-06,
  1.732425069193217e-08,  1.322014256229939e-11, -1.883467164991213e-13, -1.583068271803896e-16,  2.510746606656271e-18,  2.049316826147790e-21, -3.722700196367443e-23,
 -2.762361281599214e-26,  5.888754088545787e-28,  1.256175048063044e+00, -2.884140079301913e-03, -2.317271748625153e-06,  1.644587591723492e-08,  3.015664934471534e-11,
 -1.703528158777602e-13, -4.599198437206573e-16,  2.136207955144502e-18,  7.622289008436272e-21, -2.935305783994427e-23, -1.328447668953975e-25,  4.222896784639460e-28,
  1.331049105896241e+00, -2.804159822021060e-03, -3.320907006983026e-06,  1.441239736224496e-08,  4.598063041385747e-11, -1.222731672403874e-13, -7.187618472637319e-16,
  1.036727520967258e-18,  1.180946301131143e-20, -4.842892968274309e-24, -1.974029263973663e-25, -1.121411342239899e-28,  1.405354436877507e+00, -2.685888482003917e-03,
 -4.252223178977135e-06,  1.122468074653343e-08,  5.831863429985420e-11, -4.674684410580448e-14, -8.538615593667932e-16, -6.203166731328050e-19,  1.225535697984788e-20,
  2.907551982226190e-23, -1.602951347379333e-25, -7.557257627861920e-28,  1.478516386162673e+00, -2.529201736799185e-03, -5.053201066908823e-06,  7.015827709351967e-09,
  6.475542813891830e-11,  4.614650196951322e-14, -7.963384146885135e-16, -2.370439890796948e-18,  7.569707866301797e-21,  5.577766106918400e-23, -8.482893474983831e-27,
 -1.008707219268316e-27,  1.549898746416511e+00, -2.335423101076145e-03, -5.664233557024657e-06,  2.075222574003456e-09,  6.334186330819044e-11,  1.388886179114493e-13,
 -5.215446961131479e-16, -3.541096618464196e-18, -1.324441573503666e-21,  5.645028285554070e-23,  1.832906821276678e-25, -4.998418671800735e-28,  1.618804922708297e+00,
 -2.107641821019582e-03, -6.029813381781846e-06, -3.147412959824947e-09,  5.321710627365074e-11,  2.092487038831059e-13, -7.782733157064519e-17, -3.514713783341368e-18,
 -1.068411774605129e-20,  2.384838887656965e-23,  2.749986703905482e-25,  5.317090803944945e-28,  1.684482501596694e+00, -1.850997699197734e-03, -6.105981931300404e-06,
 -8.070364620403817e-09,  3.519693288871383e-11,  2.362102323124621e-13,  4.067054315104483e-16, -2.100976871793940e-18, -1.531389954713428e-20, -2.627328147240344e-23,
  1.683582534762950e-25,  1.200792734312537e-27,  1.746132236747504e+00, -1.572880181018154e-03, -5.869003508299410e-06, -1.205076864920062e-08,  1.208771910314867e-11,
  2.081533654040482e-13,  7.573738130875196e-16,  1.893232463899545e-19, -1.184130077477293e-20, -5.981210792697040e-23, -7.305232808649785e-26,  7.669056857772614e-28,
  1.802922402246918e+00, -1.282975168557287e-03, -5.324076741588827e-06, -1.449960869402459e-08, -1.155294656615200e-11,  1.303272557746164e-13,  8.280091334950125e-16,
  2.246934458762376e-18, -1.957244824060909e-21, -5.000757333220028e-23, -2.380078789104581e-25, -3.800058559274979e-28,  1.854009198836985e+00, -9.930868306143386e-04,
 -4.512181021134844e-06, -1.502688709254632e-08, -3.039719946835412e-11,  2.707971287042622e-14,  5.885625366229454e-16,  2.963463350833940e-18,  7.662213172590431e-21,
 -5.602812213471627e-24, -1.717633618573768e-25, -9.496535057321340e-28,  1.898563363656099e+00, -7.166706733066784e-04, -3.512639229264982e-06, -1.358269933197773e-08,
 -3.998424955429497e-11, -6.504423381349175e-14,  1.668907511038434e-16,  2.033053253397287e-18,  1.025741647913630e-20,  3.207384152792059e-23,  3.079260850960056e-26,
 -3.751541522787501e-28,  1.935802311007321e+00, -4.680453967053685e-04, -2.439034081523716e-06, -1.054297951856469e-08, -3.851974922268994e-11, -1.130487130502797e-13,
 -2.073234853335556e-16,  2.873037424745776e-19,  5.180485496698655e-21,  3.101776292307454e-23,  1.292073312611865e-25,  3.738429398142194e-28,  1.965026097903141e+00,
 -2.613070954831249e-04, -1.427100922317310e-06, -6.687490725189387e-09, -2.800080929213734e-11, -1.051895384879456e-13, -3.463177543672119e-16, -9.230485770882124e-19,
 -1.385974330696803e-21,  4.333198518625829e-24,  5.370554995867200e-26,  3.236813149438152e-28,  1.985654584908693e+00, -1.090424569649979e-04, -6.152186694894106e-07,
 -3.042933810146356e-09, -1.386146921527034e-11, -5.926896316263297e-14, -2.394207166847557e-16, -9.125949046825537e-19, -3.253005954188665e-21, -1.061339971831474e-23,
 -3.010260608319810e-26, -6.288708951867767e-29,  1.997265072023454e+00, -2.099055723510732e-05, -1.205936992627827e-07, -6.142833196663442e-10, -2.924227242821127e-12,
 -1.331290748277243e-14, -5.866160449190979e-17, -2.518932292840240e-19, -1.058343062928959e-21, -4.361480638333153e-24, -1.765277383315457e-26, -7.020620066134421e-29,
  4.153456342606731e-04, -1.905046868174768e-06,  6.552152594584869e-09, -2.002794716889319e-11,  5.737555156673636e-14, -1.577534794951543e-16,  4.214979356297294e-19,
 -1.102885026030799e-21,  2.838742199916985e-24, -7.214892237838262e-27,  1.813388287225695e-29, -4.520713185319478e-32,  3.737748588917474e-03, -1.712702188913367e-05,
  5.877752290458122e-08, -1.789765203060630e-10,  5.096846858696745e-13, -1.389463400086384e-15,  3.669599688628043e-18, -9.456780002749171e-21,  2.387290833986994e-23,
 -5.922270638562058e-26,  1.444736496459769e-28, -3.473808528385168e-31,  1.038061257857678e-02, -4.747265306373290e-05,  1.622050284358241e-07, -4.900932190588295e-10,
  1.378853348638672e-12, -3.693346877269212e-15,  9.519301078768642e-18, -2.374213106992426e-20,  5.740507158989654e-23, -1.346257799824862e-25,  3.051901428242065e-28,
 -6.666785750112899e-31,  2.034000256928746e-02, -9.274440958782545e-05,  3.147881095792320e-07, -9.399119915756617e-10,  2.595227132003775e-12, -6.760668239303614e-15,
  1.674512389603317e-17, -3.949074006051511e-20,  8.823557989811022e-23, -1.847142813542149e-25,  3.523828637971858e-28, -5.765157370808265e-31,  3.360988693127839e-02,
 -1.526437601015066e-04,  5.134570157491431e-07, -1.508474915741519e-09,  4.057453355116203e-12, -1.015403697571939e-14,  2.367471531066444e-17, -5.091104753651476e-20,
  9.800427372407764e-23, -1.561230043294308e-25,  1.450915603419003e-28,  2.522314343761249e-31,  5.018197946053760e-02, -2.267684841741675e-04,  7.541198026627929e-07,
 -2.169632957712267e-09,  5.636281333105376e-12, -1.333787308238353e-14,  2.837943773289642e-17, -5.189403440587059e-20,  6.984816124977639e-23, -1.016400176384066e-26,
 -3.779736291186267e-28,  1.802578345285668e-30,  7.004552352430703e-02, -3.146090789641065e-04,  1.031665194814400e-06, -2.891466038762285e-09,  7.179699618460384e-12,
 -1.571829435952157e-14,  2.891386340660770e-17, -3.720881950902310e-20, -6.474357168053579e-24,  2.581394147137402e-25, -1.137988589254869e-27,  3.557072856490451e-30,
  9.318701370432972e-02, -4.155442576138958e-04,  1.339968724906793e-06, -3.636838908921084e-09,  8.519458295297157e-12, -1.669162882511495e-14,  2.359058649858953e-17,
 -3.762682146015024e-21, -1.298569558166631e-22,  6.061948257526197e-25, -1.891156831871944e-27,  4.532464473329017e-30,  1.195898489597810e-01, -5.288355404852923e-04,
  1.671904040349680e-06, -4.364113560999423e-09,  9.479019696681520e-12, -1.570033978701099e-14,  1.127215834186826e-17,  4.822979546239089e-20, -2.844981396511812e-22,
  9.400664087451794e-25, -2.258773477307529e-27,  3.557249509160940e-30,  1.492339098472197e-01, -6.536209491824168e-04,  2.019361833070719e-06, -5.028043062369347e-09,
  9.882962497887297e-12, -1.229458393678490e-14, -8.343269797605304e-18,  1.143498694624021e-19, -4.389432574680635e-22,  1.124857290892006e-24, -1.821680612903573e-27,
 -2.258177162050735e-31,  1.820950506895846e-01, -7.889078280824361e-04,  2.373279523704103e-06, -5.580875521402772e-09,  9.567826623878917e-12, -6.196870375396794e-15,
 -3.447171944362130e-17,  1.855494847465163e-19, -5.484263112534552e-22,  1.011429566239712e-24, -2.727142680088920e-28, -6.744326557398277e-30,  2.181444957528502e-01,
 -9.335648409092777e-04,  2.723685636076330e-06, -5.973700081580261e-09,  8.394322893042085e-12,  2.633678798695401e-15, -6.506354683354445e-17,  2.484009773785116e-19,
 -5.611489095020517e-22,  4.785621565342664e-25,  2.400043179524962e-27, -1.447799809613981e-29,  2.573481264423167e-01, -1.086313223517882e-03,  3.059763753123877e-06,
 -6.158068781971741e-09,  6.260733169944843e-12,  1.394216581641365e-14, -9.673430059976815e-17,  2.862054965672901e-19, -4.286385403261707e-22, -5.146072393659249e-25,
  5.749223651727197e-27, -2.031914235644463e-29,  2.996656442505793e-01, -1.245717422109159e-03,  3.369942067461661e-06, -6.087927981812928e-09,  3.117183604417243e-12,
  2.712997891820197e-14, -1.248502840099642e-16,  2.810904770329315e-19, -1.195712965641656e-22, -1.876149765478254e-24,  8.792945207562914e-27, -2.009662889509435e-29,
  3.450495916654187e-01, -1.410175313229636e-03,  3.642015836699797e-06, -5.721889568817879e-09, -1.019726627282985e-12,  4.122580907425602e-14, -1.438131813642793e-16,
  2.171253228294023e-19,  3.645871990107360e-22, -3.344518786132052e-24,  1.010617463834627e-26, -9.936832005346603e-30,  3.934442104839823e-01, -1.577908294092284e-03,
  3.863311516856196e-06, -5.025863581650808e-09, -6.052728324087134e-12,  5.488501148138358e-14, -1.475826209038129e-16,  8.432179517541046e-20,  9.750290536009131e-22,
 -4.487046255098677e-24,  8.142510796016584e-27,  1.162883233890927e-29,  4.447841140122533e-01, -1.746951656529999e-03,  4.020902939872785e-06, -3.976057729606561e-09,
 -1.179125459022253e-11,  6.642817847906330e-14, -1.304608623045462e-16, -1.168493775190075e-19,  1.606386983694245e-21, -4.754307317956528e-24,  1.802505061570743e-27,
  4.131941101665411e-29,  4.989927465306940e-01, -1.915145824634018e-03,  4.101891539256340e-06, -2.562322313494740e-09, -1.794195720786675e-11,  7.393067883163283e-14,
 -8.813573124549685e-17, -3.711026080107313e-19,  2.098216160458587e-21, -3.605566945805791e-24, -8.825247405531449e-27,  6.953752717067772e-29,  5.559806003174305e-01,
 -2.080129256210829e-03,  4.093764152620209e-06, -7.917770206126833e-10, -2.410446026587930e-11,  7.537457567187088e-14, -1.893184969813549e-17, -6.451819299625235e-19,
  2.252907688931195e-21, -7.057952307027976e-25, -2.175364925357606e-26,  8.099995068119330e-29,  6.156431576754466e-01, -2.239334094956430e-03,  3.984843068832382e-06,
  1.307406196102614e-09, -2.977501673896051e-11,  6.887181591316245e-14,  7.484793150389702e-17, -8.873070228967673e-19,  1.874621558603870e-21,  3.831917468192971e-24,
 -3.276549776936193e-26,  5.896449539101074e-29,  6.778585231877622e-01, -2.389986028561893e-03,  3.764843299496596e-06,  3.682278345578381e-09, -3.436129490876666e-11,
  5.296159482474557e-14,  1.857006384571777e-16, -1.030870517536188e-18,  8.302059644541034e-22,  9.222996738859205e-24, -3.590919309345653e-26, -6.425174561810061e-30,
  7.424847104061120e-01, -2.529110273007203e-03,  3.425550857933146e-06,  6.251781385026668e-09, -3.721194572840253e-11,  2.697373442878097e-14,  3.001409098062255e-16,
 -1.003983916522808e-18, -8.739549428765017e-22,  1.391489186000781e-23, -2.522318247717995e-26, -1.072494208196968e-28,  8.093565482329356e-01, -2.653546178033520e-03,
  2.961632112458627e-06,  8.904300515529149e-09, -3.766467415424426e-11, -8.567941112352563e-15,  3.987908578493302e-16, -7.458441352072541e-19, -3.016009215094900e-21,
  1.575668446436882e-23,  2.236631536852409e-27, -2.091708130405418e-28,  8.782821766471514e-01, -2.759973639269082e-03,  2.371576605896061e-06,  1.149678553630757e-08,
 -3.511591993168021e-11, -5.155418840080646e-14,  4.578529936294153e-16, -2.293673005134345e-19, -5.113832717706483e-21,  1.256272655812012e-23,  4.270552839600937e-26,
 -2.530582436262961e-28,  9.490391109426236e-01, -2.844955299828943e-03,  1.658762149750482e-06,  1.385634576033626e-08, -2.911346264868620e-11, -9.799666465196733e-14,
  4.524583890564933e-16,  5.131651113795729e-19, -6.453401574208801e-21,  3.102280115711894e-24,  8.304478329601139e-26, -1.754310778275192e-28,  1.021369870765049e+00,
 -2.904999391536446e-03,  8.326090283545659e-07,  1.578544189790939e-08, -1.946967914971860e-11, -1.419559451300191e-13,  3.621722126615449e-16,  1.368569125945235e-18,
 -6.234264795432711e-21, -1.167035190603234e-23,  1.017853265262745e-25,  4.989095177009225e-29,  1.094977198246907e+00, -2.936648918445342e-03, -9.024308412483095e-08,
  1.707195980949739e-08, -6.387121588213319e-12, -1.758481780978921e-13,  1.784231911388036e-16,  2.136777462489883e-18, -3.855058535698688e-21, -2.766212193947583e-23,
  7.658176999922155e-26,  3.625083201325081e-28,  1.169518932677495e+00, -2.936603561860333e-03, -1.084849169405272e-06,  1.750545508589092e-08,  9.420941986205509e-12,
 -1.912963038456329e-13, -8.729052641556716e-17,  2.554719661456412e-18,  6.955350918471280e-22, -3.781024822068059e-23, -1.496280135420125e-27,  5.946995475343849e-28,
  1.244602672518412e+00, -2.901880911368052e-03, -2.117140518108390e-06,  1.690054694045207e-08,  2.664419535575655e-11, -1.806465761869303e-13, -3.968571858103796e-16,
  2.362226594603883e-18,  6.474706930428663e-21, -3.426272240407883e-23, -1.118660460122153e-25,  5.282515123925019e-28,  1.319780444842164e+00, -2.830022968164517e-03,
 -3.143627805645550e-06,  1.512759711198227e-08,  4.336523533631691e-11, -1.391326238753328e-13, -6.844799541259462e-16,  1.410310044174580e-18,  1.149222875582767e-20,
 -1.279041661227372e-23, -1.987856464111583e-25,  5.078952101265365e-29,  1.394543722745895e+00, -2.719351698406528e-03, -4.111962894944544e-06,  1.214918086860975e-08,
  5.717759673133310e-11, -6.740271121963297e-14, -8.655918615794742e-16, -2.126987588980732e-19,  1.317888265305022e-20,  2.202485286273206e-23, -1.915183919515552e-25,
 -6.569245873400216e-28,  1.468319286151241e+00, -2.569272908841803e-03, -4.962767580760055e-06,  8.058237524185239e-09,  6.548201012162024e-11,  2.626713514354142e-14,
 -8.590186117214461e-16, -2.096235262311629e-18,  9.560651087253999e-21,  5.452392614473953e-23, -5.479603482158087e-26, -1.089864921690709e-27,  1.540466608588048e+00,
 -2.380619923337429e-03, -5.633160696040960e-06,  3.110200698649480e-09,  6.598641712994391e-11,  1.251788747707462e-13, -6.209734234576763e-16, -3.549595532519276e-18,
  8.338082749637089e-22,  6.327282919007141e-23,  1.561116591906190e-25, -7.364815683240760e-28,  1.610277660060392e+00, -2.156016611613230e-03, -6.062335812769821e-06,
 -2.262595097893561e-09,  5.737523440234799e-11,  2.061621405980184e-13, -1.808813482865043e-16, -3.840703096398467e-18, -9.622394603482965e-21,  3.526535494528215e-23,
  2.944902292500828e-25,  3.450573052833581e-28,  1.676980215734493e+00, -1.900222996202394e-03, -6.199289841583220e-06, -7.468910721408320e-09,  4.001369210575284e-11,
  2.452090344793290e-13,  3.408851334043261e-16, -2.604750528040351e-18, -1.612556667729306e-20, -1.845872206480567e-23,  2.228722855356893e-25,  1.269556660608418e-27,
  1.739745901175794e+00, -1.620407035304798e-03, -6.012311727673510e-06, -1.182307198328811e-08,  1.643275571049884e-11,  2.263491233488453e-13,  7.570426415132601e-16,
 -2.245436445529083e-19, -1.403832017035672e-20, -6.198409239966249e-23, -3.364287573670185e-26,  1.028183131337296e-27,  1.797704210208372e+00, -1.326266700890849e-03,
 -5.499091557195147e-06, -1.466250251271780e-08, -8.742627088865299e-12,  1.509456376462071e-13,  8.897625331863317e-16,  2.153630373481784e-18, -3.932567754078192e-21,
 -5.982361046688796e-23, -2.517343484222474e-25, -2.343629014493589e-28,  1.849963502962968e+00, -1.029913791112570e-03, -4.695401360416319e-06, -1.550811333665747e-08,
 -2.970748684600207e-11,  4.222840815368746e-14,  6.749319214746845e-16,  3.204017009987346e-18,  7.326438406478225e-21, -1.334558224196294e-23, -2.162632582023763e-25,
 -1.071423313564902e-27,  1.895639430967656e+00, -7.454347297791008e-04, -3.679512278933562e-06, -1.423261674100347e-08, -4.124027323927460e-11, -6.031758452192182e-14,
  2.285866429105961e-16,  2.379967821159344e-18,  1.142984992712706e-20,  3.292905708441499e-23,  1.075544410037720e-26, -5.417364149443819e-28,  1.933890288588424e+00,
 -4.880743833217314e-04, -2.569323211242679e-06, -1.117765056431731e-08, -4.082972819157022e-11, -1.179081417662527e-13, -1.967829556113178e-16,  4.719754400058382e-19,
  6.394159330147440e-21,  3.651935168806689e-23,  1.459561074838622e-25,  3.852800798973758e-28,  1.963957516690296e+00, -2.730526815026888e-04, -1.510109800876285e-06,
 -7.152794473964652e-09, -3.018983503027162e-11, -1.138161609213527e-13, -3.727574560352433e-16, -9.644600574830404e-19, -1.187678096222728e-21,  6.788521155863615e-24,
  6.963848951666818e-26,  4.030659408220188e-28,  1.985208334874964e+00, -1.141141296246315e-04, -6.531047293425267e-07, -3.274521460446249e-09, -1.510644153678225e-11,
 -6.533381660722306e-14, -2.664898485812430e-16, -1.023042213509411e-18, -3.657428179981767e-21, -1.187270668873361e-23, -3.285415945513806e-26, -6.168895184348011e-29,
  1.997179132459570e+00, -2.198560856315583e-05, -1.282548659417910e-07, -6.632799842631333e-10, -3.205155883602336e-12, -1.480939919074559e-14, -6.621336471789245e-17,
 -2.884149820788419e-19, -1.228847617372842e-21, -5.133453193128937e-24, -2.105195687263669e-26, -8.478393897688380e-29,  4.078287808260119e-04, -1.853575618997915e-06,
  6.317222916369086e-09, -1.913463958504996e-11,  5.431919218805708e-14, -1.479980686026942e-16,  3.918508404191438e-19, -1.016064858308314e-21,  2.591597097849095e-24,
 -6.527790973199617e-27,  1.625783079911061e-29, -4.017365130703830e-32,  3.670167532484928e-03, -1.666525602597342e-05,  5.667783260299163e-08, -1.710391828184809e-10,
  4.827551117363188e-13, -1.304486092039559e-15,  3.415192180220588e-18, -8.725873094949493e-21,  2.184133140490194e-23, -5.373819798468591e-26,  1.300221745348762e-28,
 -3.102453144513705e-31,  1.019328052187063e-02, -4.619816779699722e-05,  1.564538817204625e-07, -4.686103101594452e-10,  1.307218250283930e-12, -3.472657826035784e-15,
  8.879526757172812e-18, -2.198041338645968e-20,  5.277138550014544e-23, -1.229857741531539e-25,  2.772705456823654e-28, -6.034560972175201e-31,  1.997399109057336e-02,
 -9.027052472120181e-05,  3.037539151617772e-07, -8.994485990296641e-10,  2.463944655177568e-12, -6.371741142896213e-15,  1.567793215086606e-17, -3.677092561188057e-20,
  8.183355018974795e-23, -1.711172707833793e-25,  3.276922653359870e-28, -5.456891348509667e-31,  3.300741409699391e-02, -1.486074223801010e-04,  4.957382293108353e-07,
 -1.445149914510527e-09,  3.859940890634217e-12, -9.602600689504827e-15,  2.229227505985359e-17, -4.786369749219290e-20,  9.249073228070017e-23, -1.501249935139261e-25,
  1.541591316634058e-28,  1.629558359233759e-31,  4.928680868648157e-02, -2.208381551018835e-04,  7.286166057177940e-07, -2.081549998781448e-09,  5.376218544363464e-12,
 -1.267395084007309e-14,  2.695762180863189e-17, -4.966751548736044e-20,  6.922847989684114e-23, -2.377858169681120e-26, -3.047121034899055e-28,  1.533837878623865e-30,
  6.880337682596030e-02, -3.064926185457649e-04,  9.976466006018508e-07, -2.779068422828774e-09,  6.872188583210144e-12, -1.503687893229621e-14,  2.787045210030583e-17,
 -3.727579723752588e-20,  2.035897048748717e-24,  2.156263741691321e-25, -9.906470452294533e-28,  3.147372409501930e-30,  9.154600301198902e-02, -4.049967839612411e-04,
  1.297133609050043e-06, -3.503167518699072e-09,  8.191276582722431e-12, -1.612716892107473e-14,  2.343023434638297e-17, -7.583152741661437e-21, -1.093485128346802e-22,
  5.344274545200438e-25, -1.699903611690105e-27,  4.162938653506586e-30,  1.175009291984579e-01, -5.156672310868784e-04,  1.620434350108766e-06, -4.214946160290213e-09,
  9.167822417868139e-12, -1.541460086629464e-14,  1.250010253765250e-17,  3.965020157691099e-20, -2.522443634309157e-22,  8.528429133028347e-25, -2.102584653056770e-27,
  3.532331573236367e-30,  1.466513574788831e-01, -6.377047311722069e-04,  1.959965933961477e-06, -4.871892614927737e-09,  9.635319733880831e-12, -1.245795116040732e-14,
 -5.332132622139051e-18,  1.009375323762844e-19, -3.997605627767381e-22,  1.051990824032387e-24, -1.816990126999449e-27,  4.133892167413759e-31,  1.789769713643640e-01,
 -7.701868811716499e-04,  2.307223298001736e-06, -5.428825014620235e-09,  9.436026723395381e-12, -6.963796569663163e-15, -2.951657324124647e-17,  1.685797672286038e-19,
 -5.122786583135169e-22,  9.950286671227867e-25, -5.367777564170522e-28, -5.295065652835732e-30,  2.144533645862018e-01, -9.120598067051896e-04,  2.652808559868667e-06,
 -5.839052041067535e-09,  8.431934174308838e-12,  1.153603839780820e-15, -5.835699913829680e-17,  2.307371829869906e-19, -5.423406112730920e-22,  5.624306327652498e-25,
  1.808078772675877e-27, -1.246001267146030e-29,  2.530513641861134e-01, -1.062128977489031e-03,  2.986476758725485e-06, -6.055789749663144e-09,  6.517001290799784e-12,
  1.171514211813104e-14, -8.891505535036350e-17,  2.722353167824847e-19, -4.432355517924236e-22, -3.019837417523351e-25,  4.895230815195139e-27, -1.849666999027759e-29,
  2.947362322027461e-01, -1.219049218045565e-03,  3.297203567015720e-06, -6.033872384858929e-09,  3.630454137143568e-12,  2.422752610837850e-14, -1.170429983460429e-16,
  2.762496903242394e-19, -1.809940633303594e-22, -1.542022752754419e-24,  7.916411993827821e-27, -1.968541580471899e-29,  3.394667274917995e-01, -1.381314053145786e-03,
  3.573281875386781e-06, -5.731794508436920e-09, -2.292268176983618e-13,  3.784845669259922e-14, -1.375878867257314e-16,  2.269427902214554e-19,  2.513488755359149e-22,
 -2.949743566781360e-24,  9.615969663194682e-27, -1.222009305790238e-29,  3.871940061104227e-01, -1.547244607572324e-03,  3.802455695017810e-06, -5.114117216451093e-09,
 -4.990239085416443e-12,  5.137473942105970e-14, -1.448086280723774e-16,  1.130019426966112e-19,  8.194654823920048e-22, -4.152836994430493e-24,  8.526994809862198e-27,
  6.004616600468664e-30,  4.378603352566656e-01, -1.714978391142825e-03,  3.972101575415637e-06, -4.154260425378650e-09, -1.049423729083399e-11,  6.326350752380265e-14,
 -1.330385947335369e-16, -6.816615039003115e-20,  1.436945597165073e-21, -4.648283761102237e-24,  3.439500552648625e-27,  3.319682832143941e-29,  4.913975920177744e-01,
 -1.882458452392420e-03,  4.069469656237226e-06, -2.837683047155097e-09, -1.648529917333268e-11,  7.169819572939383e-14, -9.760656849215916e-17, -3.060987771159990e-19,
  1.962778614820483e-21, -3.899622292429680e-24, -5.933553485160878e-27,  6.184915824870759e-29,  5.477255142386749e-01, -2.047423590320985e-03,  4.081998451008722e-06,
 -1.165419135816322e-09, -2.260293368758726e-11,  7.471154735512865e-14, -3.599261795761940e-17, -5.736564216453282e-19,  2.212690224662745e-21, -1.505251734492621e-24,
 -1.823715074895961e-26,  7.853902342678629e-29,  6.067496668527540e-01, -2.207400588435076e-03,  3.997719290351174e-06,  8.421146968651789e-10, -2.838159378816095e-11,
  7.037692829105637e-14,  5.086213041104984e-17, -8.253596673645003e-19,  1.989628167095811e-21,  2.575719079434475e-24, -2.998753028007036e-26,  6.678057467176244e-29,
  6.683590833327813e-01, -2.359699797051158e-03,  3.805767667707768e-06,  3.141203879796802e-09, -3.325981609272503e-11,  5.707533655443382e-14,  1.572561333093775e-16,
 -9.992688757497177e-19,  1.136368138447958e-21,  7.787193672732638e-24, -3.573294029565288e-26,  1.389488475813857e-29,  7.324235390310085e-01, -2.501415858791287e-03,
  3.497018931983763e-06,  5.661087825701967e-09, -3.660272865135886e-11,  3.383707313111534e-14,  2.717116964791088e-16, -1.024138941807875e-18, -3.922395207340416e-22,
  1.282005984175010e-23, -2.931040630640133e-26, -7.870425220962777e-29,  7.987904118852470e-01, -2.629435969181216e-03,  3.064863919719045e-06,  8.300807591831162e-09,
 -3.774206888330227e-11,  7.420542665401850e-16,  3.766413459041311e-16, -8.332809158234381e-19, -2.449315175563438e-21,  1.566884137548646e-23, -6.454670010372652e-27,
 -1.852877490665793e-28,  8.672810874885136e-01, -2.740458806742001e-03,  2.506134805469747e-06,  1.092727667676122e-08, -3.603773293907705e-11, -4.066084645238985e-14,
  4.492099257629448e-16, -3.854659548408856e-19, -4.633516153854946e-21,  1.404770890890367e-23,  3.154607703342318e-26, -2.527332724838802e-28,  9.376868716488828e-01,
 -2.831028161995431e-03,  1.822180652186937e-06,  1.337544536439521e-08, -3.096376215091050e-11, -8.698844960960565e-14,  4.639571574995203e-16,  3.090684435857061e-19,
 -6.283898952202921e-21,  6.257600523102893e-24,  7.444076965828666e-26, -2.139286896613279e-28,  1.009764386880046e+00, -2.897586326492932e-03,  1.020073115435338e-06,
  1.545169897136508e-08, -2.221889085719758e-11, -1.328268759285470e-13,  3.976416582267027e-16,  1.163139280629019e-18, -6.580784340427747e-21, -7.577092952372734e-24,
  1.023392325451882e-25, -2.398190600632602e-29,  1.083230453349696e+00, -2.936553412022252e-03,  1.138920187315190e-07,  1.694188289918774e-08, -9.856493241620305e-12,
 -1.708629024412657e-13,  2.363805760061684e-16,  1.998103348410919e-18, -4.792105909105576e-21, -2.430128322264282e-23,  9.091172551654263e-26,  2.872708373702427e-28,
  1.157756494491430e+00, -2.944439822264265e-03, -8.740058556924742e-07,  1.762549327228717e-08,  5.579867950731545e-12, -1.925316324874016e-13, -1.565119202241439e-17,
  2.555237525584450e-18, -6.604353867863363e-22, -3.735044296157845e-23,  2.435260247145658e-26,  5.763311835496812e-28,  1.232962568931475e+00, -2.917999839870303e-03,
 -1.911896952706068e-06,  1.729745600690975e-08,  2.294149169154183e-11, -1.893551974054053e-13, -3.280054880491914e-16,  2.548865374864598e-18,  5.166552882604999e-21,
 -3.824581570894912e-23, -8.666975442892033e-26,  6.131494448115362e-28,  1.308411220988205e+00, -2.854434287815124e-03, -2.958028258012777e-06,  1.579830126348699e-08,
  4.042171901501503e-11, -1.550452028645172e-13, -6.399228774929770e-16,  1.769166780244078e-18,  1.088963562202991e-20, -2.064781156091569e-23, -1.928605872104957e-25,
  2.186383123917338e-28,  1.383601469695572e+00, -2.751648798370036e-03, -3.960731820733840e-06,  1.305210809205443e-08,  5.562156725836794e-11, -8.820004942637752e-14,
 -8.655349467543861e-16,  2.201789483521931e-19,  1.382725690748423e-20,  1.382376387937723e-23, -2.175354688268684e-25, -5.196173712887928e-28,  1.457963427849080e+00,
 -2.608570410428000e-03, -4.859768802663219e-06,  9.109012956362646e-09,  6.579662039931462e-11,  4.982720948015841e-15, -9.131385077689319e-16, -1.759406394790174e-18,
  1.147236550700495e-20,  5.135864034148149e-23, -1.037381425998346e-25, -1.126800171728776e-27,  1.530854260281626e+00, -2.425517786123212e-03, -5.589423688688927e-06,
  4.185168532806780e-09,  6.833293518625142e-11,  1.090880097081635e-13, -7.196379150413400e-16, -3.485330910252447e-18,  3.215583951477499e-21,  6.879932340861770e-23,
  1.184962045217049e-25, -9.719698937044575e-28,  1.601556446726792e+00, -2.204607984966318e-03, -6.083843729848845e-06, -1.311878447900057e-09,  6.144618042888362e-11,
  2.004969724313295e-13, -2.925246502355369e-16, -4.126007668077664e-18, -8.137755409735252e-21,  4.728133609865784e-23,  3.045459573473161e-25,  1.030749536722815e-28,
  1.669279583335143e+00, -1.950164563447120e-03, -6.284912248232473e-06, -6.789039541513469e-09,  4.499347392579232e-11,  2.524562216755652e-13,  2.606408690037715e-16,
 -3.129570434000712e-18, -1.661606159859802e-20, -8.417712924376174e-24,  2.792916474514807e-25,  1.284895508575701e-27,  1.733167184265305e+00, -1.669068216421912e-03,
 -6.152458466852350e-06, -1.152294792599066e-08,  2.114064802239986e-11,  2.443898686705274e-13,  7.441294786948930e-16, -7.096391221861890e-19, -1.628233027366237e-20,
 -6.234384613644198e-23,  1.768640123784372e-26,  1.306851115777151e-27,  1.792310040544648e+00, -1.370965374387492e-03, -5.675777441723145e-06, -1.477705277321952e-08,
 -5.505369085055585e-12,  1.730072781904012e-13,  9.479646716661163e-16,  1.991369534241186e-18, -6.269446014808959e-21, -7.004276119623390e-23, -2.577066992348536e-25,
 -2.601252103504859e-29,  1.845767531444478e+00, -1.068229401813930e-03, -4.884319833054963e-06, -1.597576549708218e-08, -2.869353350337516e-11,  5.952931044774876e-14,
  7.678419688580469e-16,  3.429012232851921e-18,  6.678625808817905e-21, -2.297170784518714e-23, -2.658155822009504e-25, -1.177269775838811e-27,  1.892597722218643e+00,
 -7.755653005990453e-04, -3.854301526383995e-06, -1.490179043445168e-08, -4.238614811231513e-11, -5.398940846264635e-14,  3.005248320744080e-16,  2.764723172957999e-18,
  1.261677612087026e-20,  3.282494784179901e-23, -1.745990437990798e-26, -7.476104163872336e-28,  1.931896016465340e+00, -5.091767827882966e-04, -2.707453309192484e-06,
 -1.185004319789527e-08, -4.323392369760670e-11, -1.224479717865230e-13, -1.804971915618628e-16,  6.987836468324701e-19,  7.818031660622404e-21,  4.269656766658271e-23,
  1.628678395919788e-25,  3.800920293164851e-28,  1.962840588770073e+00, -2.854852818840307e-04, -1.598918277187299e-06, -7.654537751756801e-09, -3.255782859779277e-11,
 -1.230904471672969e-13, -4.002536363582292e-16, -9.979816811390270e-19, -8.886344025679552e-22,  9.955703595220065e-24,  8.941883398800658e-26,  4.989687110710105e-28,
  1.984741173882458e+00, -1.195003550560117e-04, -6.938934784228703e-07, -3.527035420901827e-09, -1.647946575169347e-11, -7.208694454931209e-14, -2.968396522221812e-16,
 -1.147177476293700e-18, -4.109145091120816e-21, -1.324003763017357e-23, -3.547691067961143e-26, -5.679069496787462e-29,  1.997089086277002e+00, -2.304437981754564e-05,
 -1.365319823060813e-07, -7.170211523987871e-10, -3.517912911210042e-12, -1.650004764669183e-14, -7.486849259727124e-17, -3.308650865925313e-19, -1.429753367677859e-21,
 -6.055130359068653e-24, -2.516171052147519e-26, -1.026189678067479e-28,  4.005141202501794e-04, -1.803941745231422e-06,  6.092725834221216e-09, -1.828871073459753e-11,
  5.145101810900581e-14, -1.389258877471697e-16,  3.645276066878954e-19, -9.367716244761198e-22,  2.367888587536770e-24, -5.911484710260321e-27,  1.458976715044529e-29,
 -3.573975874922553e-32,  3.604400537524512e-03, -1.621991389082646e-05,  5.467086014124143e-08, -1.635194470667706e-10,  4.574656464525343e-13, -1.225376147130024e-15,
  3.180368823644468e-18, -8.056926019030339e-21,  1.999717375995113e-23, -4.880035044748326e-26,  1.171098793622600e-28, -2.773297537930000e-31,  1.001095599351271e-02,
 -4.496867967899475e-05,  1.509537959399293e-07, -4.482390703762676e-10,  1.239847297713473e-12, -3.266747797168130e-15,  8.287066129328213e-18, -2.036047922417129e-20,
  4.853729100300074e-23, -1.124087658368624e-25,  2.519955993363328e-28, -5.463673872392568e-31,  1.961770162978862e-02, -8.788300629365447e-05,  2.931929305909226e-07,
 -8.610248639136272e-10,  2.340190645053399e-12, -6.007535494915500e-15,  1.468409934440965e-17, -3.424833218602703e-20,  7.590356370373889e-23, -1.584806353093820e-25,
  3.043659918686427e-28, -5.146014650530429e-31,  3.242080785095784e-02, -1.447098482469195e-04,  4.787607398776402e-07, -1.384898656952878e-09,  3.673132175424340e-12,
 -9.083338794824565e-15,  2.099272346107583e-17, -4.498926328802862e-20,  8.719874864347958e-23, -1.438376751716530e-25,  1.596793458785198e-28,  9.049468770579712e-32,
  4.841495777331979e-02, -2.151076933629882e-04,  7.041458704929822e-07, -1.997523649809156e-09,  5.129098000960293e-12, -1.204340674357117e-14,  2.559780101635304e-17,
 -4.746812525732246e-20,  6.816867265389370e-23, -3.468823356193741e-26, -2.424647920975296e-28,  1.301138369253863e-30,  6.759316009726854e-02, -2.986429944116497e-04,
  9.649477020474839e-07, -2.671483317700958e-09,  6.578055439069406e-12, -1.438049848220517e-14,  2.682875584005760e-17, -3.709383137756244e-20,  9.117536865561331e-24,
  1.786588900943927e-25, -8.604090537891138e-28,  2.779096265710150e-30,  8.994650688653838e-02, -3.947856634176901e-04,  1.255871416201528e-06, -3.374656966459559e-09,
  7.874337292205780e-12, -1.556776932354340e-14,  2.317171873846059e-17, -1.078724626188452e-20, -9.128987545222054e-23,  4.699890261466870e-25, -1.524604059627790e-27,
  3.807893479632222e-30,  1.154638703774925e-01, -5.029036033764883e-04,  1.570724987293919e-06, -4.070710676191639e-09,  8.862615756160366e-12, -1.510216025713511e-14,
  1.350180432204603e-17,  3.205369041900337e-20, -2.230185938912801e-22,  7.718285014852293e-25, -1.948701707363733e-27,  3.454863524166264e-30,  1.441315314202447e-01,
 -6.222562527156570e-04,  1.902419971070052e-06, -4.719726789110530e-09,  9.385102601113137e-12, -1.255341837367832e-14, -2.679380827515905e-18,  8.873715899661414e-20,
 -3.631913085026792e-22,  9.798305748648292e-25, -1.787412492379893e-27,  9.093782164024168e-31,  1.759327304309177e-01, -7.519871226162703e-04,  2.242978539913789e-06,
 -5.278999712133637e-09,  9.290039719752317e-12, -7.617370985671301e-15, -2.502048757303224e-17,  1.527554100130514e-19, -4.768967767609628e-22,  9.692770466470640e-25,
 -7.417834308657536e-28, -4.056301177298613e-30,  2.108471297679487e-01, -8.911153179682757e-04,  2.583549921852693e-06, -5.704030453611345e-09,  8.441513829105130e-12,
 -1.713783679028927e-16, -5.213618926408273e-17,  2.137191628215870e-19, -5.209183612328852e-22,  6.243416723334345e-25,  1.300814981078984e-27, -1.062816570405559e-29,
  2.488501741893482e-01, -1.038526051636383e-03,  2.914440277281765e-06, -5.949756688774227e-09,  6.730573628559397e-12,  9.671040383517741e-15, -8.149240997257051e-17,
  2.579140678611158e-19, -4.507736598047571e-22, -1.219160865515174e-25,  4.121351338468200e-27, -1.668501427157190e-29,  2.899123334547480e-01, -1.192960192053130e-03,
  3.225161124928255e-06, -5.972058721070614e-09,  4.087537281745944e-12,  2.151061041889221e-14, -1.093970118230730e-16,  2.696291069458887e-19, -2.310140729429092e-22,
 -1.242494614103311e-24,  7.065321497136831e-27, -1.895544628899083e-29,  3.339982081592099e-01, -1.353002930253993e-03,  3.504502740261132e-06, -5.729583623437196e-09,
  4.952402200017992e-13,  3.462341357341209e-14, -1.311363253004661e-16,  2.333600539210506e-19,  1.519472722512639e-22, -2.576370862903325e-24,  9.041168094138421e-27,
 -1.380041057778765e-29,  3.810654764835097e-01, -1.517071720115266e-03,  3.740640524188497e-06, -5.185928786617663e-09, -3.997227342745719e-12,  4.794012841196322e-14,
 -1.412994564096003e-16,  1.368990612442673e-19,  6.761531541789324e-22, -3.807921665430909e-24,  8.684543488626435e-27,  1.304045311855698e-30,  4.310636556890783e-01,
 -1.683403742441882e-03,  3.921284193938712e-06, -4.312220100585841e-09, -9.261024802738890e-12,  6.005271981600618e-14, -1.343284466356076e-16, -2.483202774828731e-20,
  1.272415362049645e-21, -4.483729409291245e-24,  4.734128851227320e-27,  2.577155773701643e-29,  4.839326478710626e-01, -1.850043279789781e-03,  4.033881771811251e-06,
 -3.090106189623153e-09, -1.507541894280496e-11,  6.925975507844733e-14, -1.053194106197056e-16, -2.455766662119455e-19,  1.818754858092312e-21, -4.084849521540963e-24,
 -3.385144293154487e-27,  5.398100020593669e-29,  5.396010347505317e-01, -2.014829577599306e-03,  4.065892682756431e-06, -1.515164479564411e-09, -2.111860090107534e-11,
  7.366292211624311e-14, -5.107282389816119e-17, -5.038514544696952e-19,  2.146193443406959e-21, -2.166720264519421e-24, -1.486600728682432e-26,  7.446345782925463e-29,
  5.979840812513755e-01, -2.175386025034973e-03,  4.005146676168772e-06,  3.993281020295821e-10, -2.696368271069679e-11,  7.132757061426812e-14,  2.865573621154211e-17,
 -7.604336072520923e-19,  2.061486279986128e-21,  1.436602743725747e-24, -2.693343380961523e-26,  7.157163747073389e-29,  6.589814025029855e-01, -2.329111836553375e-03,
  3.840307480084488e-06,  2.618374502268404e-09, -3.208281193160151e-11,  6.051808772495729e-14,  1.298258837629502e-16, -9.586940157976568e-19,  1.391174892206622e-21,
  6.375344587915454e-24, -3.473591136439993e-26,  3.086503426731267e-29,  7.224742441566322e-01, -2.473177877376174e-03,  3.561461577430554e-06,  5.081202641093804e-09,
 -3.586310467922226e-11,  4.001304302192433e-14,  2.429278148891484e-16, -1.029538814441593e-18,  4.741857951618666e-23,  1.158648825404732e-23, -3.217085467977961e-26,
 -5.162407826872270e-29,  7.883223222051180e-01, -2.604528880622972e-03,  3.160852430852723e-06,  7.697536273173428e-09, -3.763876732485834e-11,  9.493126497241875e-15,
  3.522965414567929e-16, -9.026990664169278e-19, -1.891778997466534e-21,  1.525532839852066e-23, -1.402553471299422e-26, -1.584751385822153e-28,  8.563601669762572e-01,
 -2.719895079299320e-03,  2.633777553793636e-06,  1.034474901903843e-08, -3.674409830097842e-11, -3.002560413605803e-14,  4.364187008159761e-16, -5.254251001435953e-19,
 -4.107748533086296e-21,  1.508911475107161e-23,  2.058688218939597e-26, -2.441496503646460e-28,  9.263929183657414e-01, -2.815817245822591e-03,  1.979658029833081e-06,
  1.286671455456652e-08, -3.259159693494944e-11, -7.577212517830764e-14,  4.698337411739948e-16,  1.121437745799711e-19, -6.007379491001620e-21,  9.038010567000355e-24,
  6.437742885072034e-26, -2.417036674371446e-28,  9.981915282791127e-01, -2.888690302031943e-03,  1.203274532688170e-06,  1.507547358423904e-08, -2.477748032651568e-11,
 -1.229166813210152e-13,  4.272259741697177e-16,  9.489765323876864e-19, -6.780317626343597e-21, -3.525166268041956e-24,  9.976133933826998e-26, -9.201066761339429e-29,
  1.071487345432341e+00, -2.934832004075259e-03,  3.161366703286134e-07,  1.675716788328964e-08, -1.321258114567677e-11, -1.645365168266049e-13,  2.900542277546489e-16,
  1.831483556880287e-18, -5.598666827752385e-21, -2.043597757316527e-23,  1.017500144707959e-25,  2.044708166346373e-28,  1.145966092402986e+00, -2.950584620368790e-03,
 -6.620913397609989e-07,  1.768396995620682e-08,  1.731256707555253e-12, -1.920523239079737e-13,  5.539906778928359e-17,  2.512826741320136e-18, -1.981499206129132e-21,
 -3.587971244157690e-23,  4.888345705216515e-26,  5.351187126822377e-28,  1.221261302254120e+00, -2.932458787994865e-03, -1.702251390272034e-06,  1.763381990802970e-08,
  1.908153832404091e-11, -1.963535228986509e-13, -2.545340869268373e-16,  2.691550358003239e-18,  3.733983630341390e-21, -4.115359056750955e-23, -5.828645638013463e-26,
  6.724876208219188e-28,  1.296947371260218e+00, -2.877329441714679e-03, -2.764673142988890e-06,  1.641942461742601e-08,  3.717144633612762e-11, -1.697702745034838e-13,
 -5.856298884726793e-16,  2.104274847998687e-18,  1.001021905037925e-20, -2.812096614992271e-23, -1.796011457913697e-25,  3.827069196216152e-28,  1.372532515925885e+00,
 -2.782693164064002e-03, -3.798828713320220e-06,  1.392681550365015e-08,  5.365059738147556e-11, -1.088485099240220e-13, -8.531127291816260e-16,  6.688924002245517e-19,
  1.416321111302291e-20,  4.713226451078557e-24, -2.367435643227361e-25, -3.484044355128589e-28,  1.447452107457555e+00, -2.646993431789076e-03, -4.744144784051634e-06,
  1.016134940386519e-08,  6.567335277583511e-11, -1.748060235496580e-14, -9.569905858974428e-16, -1.363606008868559e-18,  1.323463310321866e-20,  4.621791774876413e-23,
 -1.531911090364543e-25, -1.112047807409468e-27,  1.521063102881502e+00, -2.470013541431554e-03, -5.532572836273774e-06,  5.294978227954365e-09,  7.033414746679390e-11,
  9.065957521413782e-14, -8.154082391462741e-16, -3.341976674138584e-18,  5.766763331821493e-21,  7.261749781447687e-23,  7.081058829678156e-26, -1.191657344776757e-27,
  1.592640597578254e+00, -2.253324689529491e-03, -6.093556454079315e-06, -2.970812856273746e-10,  6.537641107831012e-11,  1.920622730790705e-13, -4.114259031304161e-16,
 -4.356826716882546e-18, -6.216009432587377e-21,  5.947100709570694e-23,  3.027989386484909e-25, -1.904259110423112e-28,  1.661377868304390e+00, -2.000757111316775e-03,
 -6.361893711195274e-06, -6.028441964832032e-09,  5.009774288249169e-11,  2.575997829966377e-13,  1.655393549380496e-16, -3.663866799771897e-18, -1.670446740303059e-20,
  3.874489766260003e-24,  3.349332387393550e-25,  1.231778222893697e-27,  1.726391604935767e+00, -1.718834857661986e-03, -6.288539920304745e-06, -1.114463267532036e-08,
  2.620511395179104e-11,  2.619495944608891e-13,  7.166293438552366e-16, -1.266329740180751e-18, -1.849935699441588e-20, -6.040295278128685e-23,  8.141702446511918e-26,
  1.589221611485584e-27,  1.786734241794893e+00, -1.417082118820206e-03, -5.853512350676435e-06, -1.483620284870166e-08, -1.813322883293889e-12,  1.964024591523297e-13,
  1.000521060214360e-15,  1.748415394812705e-18, -8.976119704503576e-21, -8.029705739737073e-23, -2.529730297298221e-25,  2.534993744600235e-28,  1.841415239671089e+00,
 -1.108078504709836e-03, -5.078740975308357e-06, -1.642430300938235e-08, -2.731076692995046e-11,  7.913297568564841e-14,  8.667067878596951e-16,  3.627341590945396e-18,
  5.647540867793580e-21, -3.466535639305507e-23, -3.194201476613353e-25, -1.252948738675959e-27,  1.889432643274647e+00, -8.071266071670580e-04, -4.037226371486628e-06,
 -1.558818807033714e-08, -4.338729953686704e-11, -4.580115784322123e-14,  3.837656913546900e-16,  3.187163914586099e-18,  1.377734328846214e-20,  3.139860238162039e-23,
 -5.567041058211821e-26, -9.965753866730400e-28,  1.929815072628861e+00, -5.314171585775128e-04, -2.853885842881990e-06, -1.256160584121397e-08, -4.572446532144262e-11,
 -1.265153770611160e-13, -1.571885454581095e-16,  9.748435730781128e-19,  9.476346109390934e-21,  4.953907244102539e-23,  1.790406456748199e-25,  3.501642148508172e-28,
  1.961672470452024e+00, -2.986530921788085e-04, -1.693981238209165e-06, -8.195688965714574e-09, -3.511797694439867e-11, -1.330347126415977e-13, -4.285361716915539e-16,
 -1.019948330981021e-18, -4.602643755206047e-22,  1.400390722884937e-23,  1.138279884238732e-25,  6.138784029726895e-28,  1.984251795636075e+00, -1.252253951405895e-04,
 -7.378487939163589e-07, -3.802639057154761e-09, -1.799512665438720e-11, -7.961185683025292e-14, -3.308751538957329e-16, -1.286575004571592e-18, -4.611909364762512e-21,
 -1.470651425670470e-23, -3.777194718622233e-26, -4.645935413085247e-29,  1.996994668367644e+00, -2.417203529400454e-05, -1.454851708864463e-07, -7.760486406150701e-10,
 -3.866660304348776e-12, -1.841344071426542e-14, -8.480745271082164e-17, -3.803083895776856e-19, -1.666997774966837e-21, -7.158017228335971e-24, -3.014179299092723e-26,
 -1.244869535669494e-28,  3.933944664232059e-04, -1.756064010118717e-06,  5.878110427821318e-09, -1.748725600939372e-11,  4.875790581270773e-14, -1.304836108549183e-16,
  3.393276078932767e-19, -8.642945760596558e-22,  2.165211653323974e-24, -5.358158559426058e-27,  1.310500856331182e-29, -3.183004956638612e-32,  3.540383361490126e-03,
 -1.579027334850314e-05,  5.275174795763064e-08, -1.563919851276006e-10,  4.337035058539621e-13, -1.151683704277309e-15,  2.963475831578735e-18, -7.444244705862895e-21,
  1.832182047235794e-23, -4.435115765210196e-26,  1.055623607422517e-28, -2.481328240638789e-31,  9.833462939004502e-03, -4.378223244458669e-05,  1.456918308648972e-07,
 -4.289135776474988e-10,  1.176455951521596e-12, -3.074527490998618e-15,  7.738122663288563e-18, -1.887013403936469e-20,  4.466636088547639e-23, -1.027941927142305e-25,
  2.291083261512977e-28, -4.948346435359578e-31,  1.927079614036266e-02, -8.557816451918864e-05,  2.830813866989669e-07, -8.245241923792509e-10,  2.223487840198101e-12,
 -5.666355271756768e-15,  1.375830964101149e-17, -3.190839703110756e-20,  7.041203046910482e-23, -1.467497403070910e-25,  2.824032276558740e-28, -4.837882987138025e-31,
  3.184952477001149e-02, -1.409452520024086e-04,  4.624886691959682e-07, -1.327554924527693e-09,  3.496403226937104e-12, -8.594319253919761e-15,  1.977131950731853e-17,
 -4.228051442282667e-20,  8.213635432734938e-23, -1.373889925627331e-25,  1.623296430768326e-28,  3.208560328459378e-32,  4.756564346770745e-02, -2.095690305109181e-04,
  6.806601383559267e-07, -1.917352094817421e-09,  4.894266949429419e-12, -1.144476352943267e-14,  2.429903262678825e-17, -4.530847171670175e-20,  6.675855627496280e-23,
 -4.330318609852963e-26, -1.897477924132874e-28,  1.099935899095881e-30,  6.641382674756151e-02, -2.910498763962550e-04,  9.335120167895942e-07, -2.568500678201686e-09,
  6.296800436778526e-12, -1.374903318913324e-14,  2.579513411862496e-17, -3.670557188169283e-20,  1.495831819570128e-23,  1.465883043684652e-25, -7.455244179975774e-28,
  2.448950227023225e-30,  8.838720469439175e-02, -3.848985572699563e-04,  1.216121291839185e-06, -3.251128305392189e-09,  7.568517011567484e-12, -1.501558747183924e-14,
  2.283123951368799e-17, -1.344925687126304e-20, -7.542852586083619e-23,  4.122551019207881e-25, -1.364551188373465e-27,  3.470297372342752e-30,  1.134770815628974e-01,
 -4.905308097985476e-04,  1.522717360697624e-06, -3.931307272415366e-09,  8.563881621066352e-12, -1.476812820508629e-14,  1.430346691611569e-17,  2.534692013381453e-20,
 -1.965994835668775e-22,  6.968888214600828e-25, -1.799133144493594e-27,  3.338215054360859e-30,  1.416725900083820e-01, -6.072609061848624e-04,  1.846675925128855e-06,
 -4.571576366782547e-09,  9.133585787317294e-12, -1.258918902607014e-14, -3.522451287726173e-19,  7.766570622862071e-20, -3.291936079582892e-22,  9.092528523742818e-25,
 -1.738742096794899e-27,  1.284732100739642e-30,  1.729602719449648e-01, -7.342941711756209e-04,  2.180517257929577e-06, -5.131609059073761e-09,  9.132025056091147e-12,
 -8.168229299392298e-15, -2.095178287470864e-17,  1.380469605914509e-19, -4.425769450622112e-22,  9.363581428651157e-25, -8.965183328054784e-28, -3.006529396327320e-30,
  2.073235750291644e-01, -8.707184166556944e-04,  2.515911613882235e-06, -5.569059637488443e-09,  8.426048645828448e-12, -1.352699807281754e-15, -4.638197874670302e-17,
  1.974185537210140e-19, -4.976136167449914e-22,  6.675195405625334e-25,  8.700739582499802e-28, -8.981091721797067e-30,  2.447422514487969e-01, -1.015494273001514e-03,
  2.843695377385704e-06, -5.840623984383170e-09,  6.905012769704825e-12,  7.800248720557362e-15, -7.447320380536074e-17,  2.434494993394505e-19, -4.523674213900187e-22,
  2.877842670607272e-26,  3.426209285853572e-27, -1.492323099499976e-29,  2.851916429996411e-01, -1.167444418280177e-03,  3.153902565740651e-06, -5.903356529269302e-09,
  4.492101240497004e-12,  1.897480274782429e-14, -1.019572360102988e-16,  2.615739084341014e-19, -2.708554271260328e-22, -9.762934208537231e-25,  6.251758860023652e-27,
 -1.799266160448069e-29,  3.286418332918543e-01, -1.325241742112821e-03,  3.435817583465737e-06, -5.716288805114088e-09,  1.156767518912948e-12,  3.155501695089496e-14,
 -1.245476240869622e-16,  2.368069666016547e-19,  6.555814898528888e-23, -2.227198166637735e-24,  8.410301567085619e-27, -1.478579310163537e-29,  3.750566442804848e-01,
 -1.487396536070803e-03,  3.678056692223446e-06, -5.242396912378585e-09, -3.072014049799978e-12,  4.459726024424532e-14, -1.371834962639687e-16,  1.564096837720820e-19,
  5.453237243205140e-22, -3.460583104402932e-24,  8.654407348823998e-27, -2.538455717330197e-30,  4.243924501003637e-01, -1.652242884312687e-03,  3.868687561291537e-06,
 -4.450963382072985e-09, -8.092242401728174e-12,  5.682494680192024e-14, -1.344776944612785e-16,  1.334127932055129e-20,  1.114664485105337e-21, -4.273703054669205e-24,
  5.718659351704419e-27,  1.910888841900487e-29,  4.765967763608802e-01, -1.817924546854916e-03,  3.995398517779502e-06, -3.320370889724300e-09, -1.371602405841353e-11,
  6.665601538101274e-14, -1.114030223925993e-16, -1.897510098102262e-19,  1.669814368471923e-21, -4.175058052354614e-24, -1.182039463959303e-27,  4.619147382668773e-29,
  5.316066476080624e-01, -1.982380796780016e-03,  4.045731712339977e-06, -1.841347283410527e-09, -1.965870288380399e-11,  7.227556486964486e-14, -6.423167778338867e-17,
 -4.365297391674847e-19,  2.058264264472097e-21, -2.697312305337749e-24, -1.170208302842668e-26,  6.918497799461883e-29,  5.893466396361390e-01, -2.143332909373139e-03,
  4.007397277634972e-06, -2.064814763892959e-11, -2.553193988388042e-11,  7.176729743251389e-14,  8.293469475862790e-18, -6.938402776706894e-19,  2.094578521000197e-21,
  4.230548696588199e-25, -2.372850953630668e-26,  7.369923750407710e-29,  6.497265868757247e-01, -2.298272328218993e-03,  3.868688489774765e-06,  2.114892664710766e-09,
 -3.084343941952313e-11,  6.331702078703218e-14,  1.036383058356051e-16, -9.107694669717205e-19,  1.596043801882341e-21,  5.017312417809654e-24, -3.306673985920181e-26,
  4.445352576359595e-29,  7.126388885150543e-01, -2.444451978965151e-03,  3.619020559047616e-06,  4.514102037703572e-09, -3.500687364824890e-11,  4.549793343509815e-14,
  2.141828834939843e-16, -1.021599952116230e-18,  4.408903607434736e-22,  1.026172941156832e-23, -3.388577342515321e-26, -2.673805417975597e-29,  7.779553509037213e-01,
 -2.578882799808684e-03,  3.249617274268523e-06,  7.097285580596774e-09, -3.736643416179123e-11,  1.763859918651509e-14,  3.262551639084709e-16, -9.545703471503394e-19,
 -1.354290758307704e-21,  1.456313149952417e-23, -2.037749369602040e-26, -1.300990147615517e-28,  8.455234991355668e-01, -2.698338347278270e-03,  2.754369120822535e-06,
  9.752603176745884e-09, -3.724113617628616e-11, -1.974244467833875e-14,  4.199492015126924e-16, -6.480435673236008e-19, -3.552270125070790e-21,  1.570185927865612e-23,
  1.016384323821157e-26, -2.285891767196422e-28,  9.151622891192327e-01, -2.799371355389145e-03,  2.130881788142256e-06,  1.233373880759046e-08, -3.399413592565867e-11,
 -6.447983987889575e-14,  4.703347956228800e-16, -7.441064361092271e-20, -5.638276306211347e-21,  1.139463874802862e-23,  5.333046318716760e-26, -2.586695223093426e-28,
  9.866571554432347e-01, -2.878347405683883e-03,  1.381722280800726e-06,  1.465993292459692e-08, -2.713125454894539e-11, -1.123690093973816e-13,  4.507460961317658e-16,
  7.307370062583005e-19, -6.836538488780691e-21,  3.660652924733056e-25,  9.436503179907075e-26, -1.517351757267116e-28,  1.059754343747361e+00, -2.931502408029415e-03,
  5.158469549713742e-07,  1.651983603604940e-08, -1.642965207178545e-11, -1.569807329552860e-13,  3.387226599270882e-16,  1.641356693312118e-18, -6.259163646659512e-21,
 -1.621131411612901e-23,  1.088546611973659e-25,  1.182432864697610e-28,  1.134154504722456e+00, -2.955032340959157e-03, -4.498439551504512e-07,  1.768103771014562e-08,
 -2.090836945419399e-12, -1.898867804850293e-13,  1.246792764328820e-16,  2.429174512378567e-18, -3.232448259004299e-21, -3.347020306466179e-23,  7.114388666983554e-26,
  4.736492894055496e-28,  1.209505578181467e+00, -2.945225486068660e-03, -1.488944321614844e-06,  1.790740189390074e-08,  1.509954803909417e-11, -2.015458615538159e-13,
 -1.777234447880559e-16,  2.786941982511840e-18,  2.217724898217132e-21, -4.288206384487911e-23, -2.791302415540688e-26,  7.032465524283575e-28,  1.285395080526832e+00,
 -2.898648846753766e-03, -2.564186054536366e-06,  1.698626152497088e-08,  3.364044509195186e-11, -1.830831426462633e-13, -5.223874861372278e-16,  2.407053359696164e-18,
  8.873028595888552e-21, -3.492244079132816e-23, -1.593684447053905e-25,  5.341719079682786e-28,  1.361342040822829e+00, -2.812400886305845e-03, -3.626631893872137e-06,
  1.476670413178541e-08,  5.127066228315744e-11, -1.290471626496781e-13, -8.280263030089822e-16,  1.122975683824504e-18,  1.415924981488470e-20, -5.006500225338702e-24,
 -2.478001027371624e-25, -1.504778574330862e-28,  1.436789024849657e+00, -2.684441016877173e-03, -4.615919562219935e-06,  1.120806613489588e-08,  6.509122402087684e-11,
 -4.085719884474385e-14, -9.890012886779853e-16, -9.147536477337630e-19,  1.477653372735936e-20,  3.912844814201394e-23, -2.007634860823459e-25, -1.040780796185815e-27,
  1.511094957149842e+00, -2.514000703540600e-03, -5.462224714306786e-06,  6.433735417764476e-09,  7.194417947305923e-11,  6.999015841597931e-14, -9.060037841788025e-16,
 -3.115172002724764e-18,  8.418806154539002e-21,  7.434310193558528e-23,  1.409946684725126e-26, -1.379517226673510e-27,  1.583529804823484e+00, -2.302069330438441e-03,
 -6.090720385052423e-06,  7.790929007127647e-10,  6.910892557281244e-11,  1.807037418447393e-13, -5.358634231931643e-16, -4.519168208977910e-18, -3.859929069058198e-21,
  7.131908387457936e-23,  2.871529147066052e-25, -5.268647233837709e-28,  1.653272611153468e+00, -2.051927606858040e-03, -6.429255014276610e-06, -5.185482214272914e-09,
  5.528084705656254e-11,  2.602814888327695e-13,  5.550749153132869e-17, -4.193488236429591e-18, -1.631106557577847e-20,  1.832232427148879e-23,  3.864736106023441e-25,
  1.096377150581175e-27,  1.719414812469590e+00, -1.769670587432005e-03, -6.419583943587101e-06, -1.068251771675047e-08,  3.161287069847349e-11,  2.786543349501847e-13,
  6.725627956745214e-16, -1.892331100051397e-18, -2.059765479189073e-20, -5.566722184969376e-23,  1.573200393567970e-25,  1.856650907649395e-27,  1.780971129278635e+00,
 -1.464622541497882e-03, -6.031586968035630e-06, -1.483247091583042e-08,  2.358637427945040e-12,  2.209672343442981e-13,  1.045007053201734e-15,  1.413003154310845e-18,
 -1.204537286908882e-20, -9.009367516647942e-23, -2.342615009465851e-25,  6.100059692808834e-28,  1.836900407230325e+00, -1.149504099787614e-03, -5.278398461107952e-06,
 -1.684744893445639e-08, -2.551177065813131e-11,  1.011719029200638e-13,  9.705966322784719e-16,  3.785521086467797e-18,  4.156200615346717e-21, -4.855700737423414e-23,
 -3.753638570326435e-25, -1.280253535308134e-27,  1.886138339773517e+00, -8.401845187239738e-04, -4.228478331733105e-06, -1.628918136641357e-08, -4.420372860002001e-11,
 -3.546904843846798e-14,  4.793448750236612e-16,  3.645604029133773e-18,  1.485629021975954e-20,  2.821152691514385e-23, -1.058255596435522e-25, -1.290687217890896e-27,
  1.927642769325671e+00, -5.548638330419353e-04, -3.009098798871943e-06, -1.331363480195151e-08, -4.829010289932965e-11, -1.299243902299378e-13, -1.253693923836387e-16,
  1.308032567964489e-18,  1.139223244493946e-20,  5.699261669362529e-23,  1.931628511724092e-25,  2.849088972483946e-28,  1.960450117754599e+00, -3.126080931361934e-04,
 -1.795790471220850e-06, -8.779430695581807e-09, -3.788383962718067e-11, -1.436634491240910e-13, -4.572185520252140e-16, -1.025676682212341e-18,  1.326896778624987e-22,
  1.913573767245620e-23,  1.437563441437537e-25,  7.502251072829008e-28,  1.983738792400964e+00, -1.313157307163598e-04, -7.852619704057268e-07, -4.103742996512978e-09,
 -1.966978008158584e-11, -8.800232610656051e-14, -3.690470819006601e-16, -1.442922386560848e-18, -5.168990877755720e-21, -1.625359971613024e-23, -3.945053757332453e-26,
 -2.831365251154848e-29,  1.996895591961411e+00, -2.537424745279325e-05, -1.551814752210670e-07, -8.409756770344932e-10, -4.256177641140465e-12, -2.058287775921855e-14,
 -9.624336503180410e-17, -4.380191867415840e-19, -1.947776221373354e-21, -8.480745862125547e-24, -3.619021097039395e-26, -1.513582090033356e-28,  3.864629495832383e-04,
 -1.709865448334807e-06,  5.672859406655412e-09, -1.672757250039844e-11,  4.622775172150245e-14, -1.226224965210531e-16,  3.160690819751268e-19, -7.979956079623446e-22,
  1.981425614762747e-24, -4.860921705124353e-27,  1.178196086679587e-29, -2.837926035908853e-32,  3.478054574537941e-03, -1.537564993857437e-05,  5.091593188832750e-08,
 -1.496332037500142e-10,  4.113645186631843e-13, -1.082996745518590e-15,  2.763010815722341e-18, -6.882698657050342e-21,  1.679862439892589e-23, -4.033916771546100e-26,
  9.522584858391578e-29, -2.222165681445855e-31,  9.660632926767332e-03, -4.263697026198042e-05,  1.406558107182102e-07, -4.105722930907992e-10,  1.116780574118695e-12,
 -2.894994755705057e-15,  7.229225485322197e-18, -1.749829297034974e-20,  4.112560913764175e-23, -9.405127883045543e-26,  2.083760016808813e-28, -4.483327660902879e-31,
  1.893295096324344e-02, -8.335249429592792e-05,  2.733968687245865e-07, -7.898373621927634e-10,  2.113391656258340e-12, -5.346627256431639e-15,  1.289564020914658e-17,
 -2.973760085476237e-20,  6.532732146212190e-23, -1.358704151748614e-25,  2.617825210711306e-28, -4.536569077370484e-31,  3.129304401213914e-02, -1.373081271613799e-04,
  4.468880749877035e-07, -1.272962179401811e-09,  3.329167582068009e-12, -8.133721358784198e-15,  1.862352758723943e-17, -3.973003208246649e-20,  7.730743451545992e-23,
 -1.308820956915394e-25,  1.626752562901504e-28, -1.462033895201409e-32,  4.673811404583820e-02, -2.042144682563148e-04,  6.581143107722969e-07, -1.840843726865263e-09,
  4.671101928345379e-12, -1.087657048447175e-14,  2.306005898384179e-17, -4.319851394817699e-20,  6.507420090571009e-23, -4.997815753912641e-26, -1.452657854078311e-28,
  9.261940474417041e-31,  6.526437061888506e-02, -2.837033762464979e-04,  9.032855351375360e-07, -2.469918428072049e-09,  6.027927656447293e-12, -1.314222427769849e-14,
  2.477483292889931e-17, -3.614802091208987e-20,  1.972387051141524e-23,  1.188330734001762e-25, -6.443873436918053e-28,  2.153676026685938e-30,  8.686682419669228e-02,
 -3.753236050881962e-04,  1.177824515597735e-06, -3.132404888038301e-09,  7.273652903935259e-12, -1.447241607945295e-14,  2.242302606312618e-17, -1.563575214895720e-20,
 -6.153388873554336e-23,  3.606317874393393e-25, -1.218932887810700e-27,  3.152003330987343e-30,  1.115390262812110e-01, -4.785354666114705e-04,  1.476354120146664e-06,
 -3.796629186465501e-09,  8.272005798372548e-12, -1.441701664586302e-14,  1.492877830143801e-17,  1.944354019844908e-20, -1.727718328648651e-22,  6.278201989884625e-25,
 -1.655354401398650e-27,  3.193308381738423e-30,  1.392727492407096e-01, -5.927044692490694e-04,  1.792685524579927e-06, -4.427453005413133e-09,  8.881887588424393e-12,
 -1.257270782763605e-14,  1.679741752309135e-18,  6.764193326651231e-20, -2.976979673998864e-22,  8.409212331941634e-25, -1.675841397100446e-27,  1.559257103803795e-30,
  1.700575970242134e-01, -7.170938790230075e-04,  2.119809147616840e-06, -4.986829610177884e-09,  8.963936993093685e-12, -8.626257774390286e-15, -1.727972564119491e-17,
  1.244166772095903e-19, -4.095429381115989e-22,  8.981226577636065e-25, -1.008837500074844e-27, -2.124968271357032e-30,  2.038805359322394e-01, -8.508561491618558e-04,
  2.449890715260969e-06, -5.434517925886187e-09,  8.388301515698954e-12, -2.401311608113769e-15, -4.107353398267168e-17,  1.818853801317454e-19, -4.730476228309142e-22,
  6.948639282224662e-25,  5.078354378596364e-28, -7.513217762132972e-30,  2.407253322617819e-01, -9.930231705333778e-04,  2.774275610650149e-06, -5.728990565099051e-09,
  7.043687872230261e-12,  6.093056972114103e-15, -6.785894139171456e-17,  2.290155143731788e-19, -4.490181920734914e-22,  1.531962627187702e-25,  2.806943997827485e-27,
 -1.324004978134291e-29,  2.805718808743953e-01, -1.142495309025911e-03,  3.083505628571724e-06, -5.828577421053879e-09,  4.847715615041208e-12,  1.661470771570466e-14,
 -9.475945828434915e-17,  2.523909238392883e-19, -3.016886121124408e-22, -7.417355162066828e-25,  5.484321606314756e-27, -1.686979124530735e-29,  3.233954054729087e-01,
 -1.298029221747311e-03,  3.367353473876272e-06, -5.692891874460121e-09,  1.758514425470431e-12,  2.864560637592153e-14, -1.178992570913772e-16,  2.376856049764696e-19,
 -8.724029459417154e-24, -1.903974829219123e-24,  7.747296790496086e-27, -1.527721994793535e-29,  3.691655075293765e-01, -1.458224486539483e-03,  3.614881874805556e-06,
 -5.284590939769470e-09, -2.212628435649120e-12,  4.135926914760073e-14, -1.325779739798927e-16,  1.719332824243615e-19,  4.269381954539129e-22, -3.117595661456123e-24,
  8.472676073166055e-27, -5.600026991118481e-30,  4.178450362958986e-01, -1.621509145919085e-03,  3.814536082384861e-06, -4.571522430206106e-09, -6.987967620874165e-12,
  5.360585488813441e-14, -1.336275744838792e-16,  4.659457451075471e-20,  9.651148753786791e-22, -4.029926954349469e-24,  6.427373864212340e-27,  1.323627183736333e-29,
  4.693887470669834e-01, -1.786124366909127e-03,  3.954280846518803e-06, -3.529309281318338e-09, -1.241004021617962e-11,  6.392448544361801e-14, -1.159906119391893e-16,
 -1.387270676865765e-19,  1.519130620863979e-21, -4.183927147201694e-24,  6.838869333216477e-28,  3.868389575026946e-29,  5.237417087811347e-01, -1.950108565623489e-03,
  4.021795728985172e-06, -2.144410220320363e-09, -1.822955916572026e-11,  7.059468048632627e-14, -7.554761604773627e-17, -3.723034240469855e-19,  1.953453321952081e-21,
 -3.106262211880293e-24, -8.789936595895813e-27,  6.307703031789410e-29,  5.808374151254353e-01, -2.111281557826479e-03,  4.004745817362494e-06, -4.176720724849929e-10,
 -2.409613795245087e-11,  7.174079204306259e-14, -1.019466677773517e-17, -6.267469171360522e-19,  2.093506741956091e-21, -4.611213486317542e-25, -2.048139734593344e-26,
  7.355515120010520e-29,  6.405955455945882e-01, -2.267229597791133e-03,  3.891148435132447e-06,  1.631654937030577e-09, -2.955426093336531e-11,  6.550425074822911e-14,
  7.887714523306242e-17, -8.570573427312462e-19,  1.753360538790380e-21,  3.737028403366027e-24, -3.087239960420414e-26,  5.476276600140976e-29,  7.029193146506587e-01,
 -2.415292588541329e-03,  3.669860030478938e-06,  3.961541330491572e-09, -3.404781842255957e-11,  5.029699125858061e-14,  1.858292638007786e-16, -1.001844196664572e-18,
  7.856930284858269e-22,  8.889504298849542e-24, -3.456400314845486e-26, -4.572291624267560e-30,  7.676923386646424e-01, -2.552555326047508e-03,  3.331210518104475e-06,
  6.502661077143789e-09, -3.693754917893193e-11,  2.514356890405986e-14,  2.989981036576044e-16, -9.896872921397856e-19, -8.459923206368729e-22,  1.364200782707662e-23,
 -2.546951372301894e-26, -1.013961991310887e-28,  8.347749425145115e-01, -2.675845425430497e-03,  2.867813936323925e-06,  9.154127426777014e-09, -3.753673118404745e-11,
 -9.893726858319165e-15,  4.002979902253575e-16, -7.526128051194346e-19, -2.982056473517080e-21,  1.591311474334627e-23,  5.528285893567231e-28, -2.074827244956942e-28,
  9.039998219924833e-01, -2.781741622055884e-03,  2.275582643976643e-06,  1.178012810477400e-08, -3.517112484349069e-11, -5.323680157098263e-14,  4.657898230963818e-16,
 -2.478828983009111e-19, -5.192439907641167e-21,  1.329756026841816e-23,  4.176773540496578e-26, -2.652569969240067e-28,  9.751669768931555e-01, -2.866597497307775e-03,
  1.554964633802624e-06,  1.420844809548699e-08, -2.926892597808694e-11, -1.013302584977333e-13,  4.681510578082580e-16,  5.128931320427317e-19, -6.757167713714379e-21,
  3.991761039885116e-24,  8.655849010603321e-26, -2.013182516931325e-28,  1.048037836554193e+00, -2.926587384790433e-03,  7.124056059861030e-07,  1.623230159188687e-08,
 -1.948436984495211e-11, -1.483230353883533e-13,  3.817948492163547e-16,  1.432574752873867e-18, -6.763373023491864e-21, -1.177844576957322e-23,  1.121649022139445e-25,
  3.264821083533464e-29,  1.122328520432258e+00, -2.957783258955637e-03, -2.379969589545736e-07,  1.761738791731130e-08, -5.853205218798133e-12, -1.860910564782340e-13,
  1.910710307677402e-16,  2.307046035301908e-18, -4.381327042487968e-21, -3.022955885335719e-23,  9.031893838794558e-26,  3.955429987881536e-28,  1.197702219483184e+00,
 -2.956273685996743e-03, -1.272739640447488e-06,  1.811654223093812e-08,  1.103233333424870e-11, -2.048682250601262e-13, -9.892879105836094e-17,  2.833054333407347e-18,
  6.613564287158996e-22, -4.337729979618329e-23,  3.157317956627352e-27,  7.040897121574931e-28,  1.273760761664419e+00, -2.918338127031778e-03, -2.357244410978238e-06,
  1.749455762742903e-08,  2.985902917262216e-11, -1.947807919767050e-13, -4.512123688417275e-16,  2.669693036556389e-18,  7.507108917449644e-21, -4.078690306361717e-23,
 -1.329030533537558e-25,  6.647129323692538e-28,  1.350035552857374e+00, -2.840691397148274e-03, -3.444598097999699e-06,  1.556531904505918e-08,  4.849380327773318e-11,
 -1.484915094280287e-13, -7.902804308043221e-16,  1.571265684462883e-18,  1.379957088642599e-20, -1.498847915461280e-23, -2.497302245462797e-25,  6.471465397483523e-29,
  1.425978282784729e+00, -2.720812751908560e-03, -4.475205175833063e-06,  1.224169117868911e-08,  6.403492653165289e-11, -6.484591107899377e-14, -1.007794299912419e-15,
 -4.210041041210636e-19,  1.602987258911190e-20,  3.021588382169950e-23, -2.439231089326315e-25, -9.115343425430416e-28,  1.500952075461123e+00, -2.557370014573709e-03,
 -5.378070961163881e-06,  7.594830208686523e-09,  7.311964435224812e-11,  4.723228605467935e-14, -9.890545555984271e-16, -2.802961235358913e-18,  1.109026293209546e-20,
  7.364794382179798e-23, -4.987689757640824e-26, -1.519253052541452e-27,  1.574224162080607e+00, -2.350738629516523e-03, -6.074619930495604e-06,  1.913006300226571e-09,
  7.258408193209550e-11,  1.663130720418242e-13, -6.637278911120115e-16, -4.599440986171430e-18, -1.092241650935525e-21,  8.223548096511461e-23,  2.560015236015814e-25,
 -8.925260311500459e-28,  1.644961660298954e+00, -2.103595117832496e-03, -6.486001930900458e-06, -4.259312215655730e-09,  6.048998596080570e-11,  2.601463941859816e-13,
 -6.909657490929501e-17, -4.701814213124418e-18, -1.536211109196242e-20,  3.468583292011073e-23,  4.300371426029593e-25,  8.677140036737437e-28,  1.712232617610246e+00,
 -1.821530991972698e-03, -6.544552620334644e-06, -1.013126944834645e-08,  3.734268804588813e-11,  2.940837334209535e-13,  6.100581102213651e-16, -2.582141752887003e-18,
 -2.246806326708826e-20, -4.766950282658673e-23,  2.442362465532862e-25,  2.085540077858661e-27,  1.775015007813130e+00, -1.513586209509785e-03, -6.209199902564435e-06,
 -1.475800264112811e-08,  7.031750446655351e-12,  2.464755565108861e-13,  1.078674673154415e-15,  9.739084838246091e-19, -1.544984046799275e-20, -9.880492475041826e-23,
 -1.981322078037316e-25,  1.045004156017143e-27,  1.832216646466483e+00, -1.192546742042822e-03, -5.482946005975876e-06, -1.723814781568830e-08, -2.324673341528760e-11,
  1.257514644738597e-13,  1.078169113168951e-15,  3.887542974620169e-18,  2.124362288058605e-21, -6.469138930330261e-23, -4.310424649647895e-25, -1.236893455798350e-27,
  1.882708691027548e+00, -8.748062991732775e-04, -4.428213353713214e-06, -1.700145532169699e-08, -4.478951706781009e-11, -2.268522177460745e-14,  5.882235906188776e-16,
  4.136321385567331e-18,  1.578115129756779e-20,  2.274620432478626e-23, -1.699057005581636e-25, -1.629066912571309e-27,  1.925374137771449e+00, -5.795890112936768e-04,
 -3.173584510168853e-06, -1.410721461405522e-08, -5.091549160131191e-11, -1.324506126983630e-13, -8.332155081717902e-17,  1.706925799337865e-18,  1.358580328897693e-20,
  6.494033758402369e-23,  2.033941268127506e-25,  1.708107072883184e-28,  1.959170270657548e+00, -3.274063562741379e-04, -1.904877263980147e-06, -9.409164241723777e-09,
 -4.086916196623749e-11, -1.549801640750856e-13, -4.857661921073251e-16, -1.009231384031763e-18,  9.334454733097961e-22,  2.559148098544682e-23,  1.801951167281935e-25,
  9.101047860668880e-28,  1.983200645668529e+00, -1.378002932833114e-04, -8.364548639999490e-07, -4.433035167316552e-09, -2.152176938356742e-11, -9.736352066580568e-14,
 -4.118547644425833e-16, -1.617998721471193e-18, -5.782756909432175e-21, -1.784887468455891e-23, -4.010096622973071e-26,  8.969963116353760e-31,  1.996791546477172e+00,
 -2.665725588995587e-05, -1.656957793372053e-07, -9.124975814528927e-10, -4.691964666044684e-12, -2.304722855037042e-14, -1.094284738227266e-16, -5.055258942091323e-19,
 -2.280828310484285e-21, -1.007079058714618e-23, -4.355285652154254e-26, -1.844484043055126e-28,  3.797129997539444e-04, -1.665273106358772e-06,  5.476486784592383e-09,
 -1.600714338826874e-11,  4.384938487110160e-14, -1.152979587441267e-16,  2.945872109274357e-19, -7.373013090038177e-22,  1.814622980562232e-24, -4.413692333812270e-27,
  1.060170447974516e-29, -2.533087034917864e-32,  3.417355413393117e-03, -1.497539460916642e-05,  4.915912115378569e-08, -1.432211124119525e-10,  3.903524047208270e-13,
 -1.018937644888910e-15,  2.577607854016578e-18, -6.367661596924638e-21,  1.541268443959674e-23, -3.671871099284176e-26,  8.596459794277804e-29, -1.991983952305119e-31,
  9.492304758314953e-03, -4.153113182194927e-05,  1.358342735271344e-07, -3.931577401035701e-10,  1.060576762478519e-12, -2.727227132242259e-15,  6.757199798819997e-18,
 -1.623487617313805e-20,  3.788515555482850e-23, -8.609810997907389e-26,  1.895879005480274e-28, -4.063864147161402e-31,  1.860385610928348e-02, -8.120266471599599e-05,
  2.641182309110405e-07, -7.568620190480312e-10,  2.009487821819280e-12, -5.046891950001473e-15,  1.209153287947047e-17, -2.772340548985309e-20,  6.061973832820638e-23,
 -1.257896741318086e-25,  2.424668210545501e-28, -4.245131183423350e-31,  3.075086622986465e-02, -1.337932314198428e-04,  4.319268383109726e-07, -1.220972981682063e-09,
  3.170874120210426e-12, -7.699830752593554e-15,  1.754502102857760e-17, -3.733032837340441e-20,  7.271254403802548e-23, -1.243994846884175e-25,  1.611860032184791e-28,
 -5.162085549405405e-32,  4.593164786981218e-02, -1.990366600683484e-04,  6.364655295906684e-07, -1.767816684010393e-09,  4.459008167494570e-12, -1.033741016188127e-14,
  2.187937580611645e-17, -4.114597144665466e-20,  6.317979792756435e-23, -5.501946722146483e-26, -1.078908156273269e-28,  7.763335866418965e-31,  6.414382425731026e-02,
 -2.765940282216141e-04,  8.742166248994749e-07, -2.375542377868275e-09,  5.770947531825311e-12, -1.255969892140811e-14,  2.377213334468625e-17, -3.545320333924740e-20,
  2.356000954850695e-23,  9.487304203673395e-26, -5.555335244229163e-28,  1.890108263457890e-30,  8.538413967013594e-02, -3.660494077733095e-04,  1.140924470124278e-06,
 -3.018312941227194e-09,  6.989549546471584e-12, -1.393972790696349e-14,  2.195954401474837e-17, -1.740625693465495e-20, -4.939616710603397e-23,  3.145590291879428e-25,
 -1.086875616746412e-27,  2.853985871948156e-30,  1.096482206845882e-01, -4.669046436521848e-04,  1.431579230773178e-06, -3.666564175102296e-09,  7.987289328415189e-12,
 -1.405279724639601e-14,  1.539910387612600e-17,  1.426395867143001e-20, -1.513287268387634e-22,  5.643689130843393e-25, -1.518407633875211e-27,  3.028970491432730e-30,
  1.369302812311490e-01, -5.785731060164313e-04,  1.740400460545174e-06, -4.287351621929636e-09,  8.630984535444694e-12, -1.251071529860098e-14,  3.444806817872617e-18,
  5.858716944412670e-20, -2.686143023634953e-22,  7.753214487573918e-25, -1.602759052324799e-27,  1.750170849552270e-30,  1.672227628801203e-01, -7.003723487250313e-04,
  2.060821967099369e-06, -4.844808194111150e-09,  8.787539352684950e-12, -9.000618501069235e-15, -1.397472979375038e-17,  1.118206644508994e-19, -3.779573435199031e-22,
  8.561250749498003e-25, -1.085704964045237e-27, -1.391952670246644e-30,  2.005158997795413e-01, -8.315156026716942e-04,  2.385480023393341e-06, -5.300741170309118e-09,
  8.330821409653396e-12, -3.327650237626625e-15, -3.618888374701083e-17,  1.671513955034559e-19, -4.477429422879872e-22,  7.089595755518284e-25,  2.063937664939829e-28,
 -6.216000642579339e-30,  2.367971953024114e-01, -9.711020326149487e-04,  2.706207658573117e-06, -5.615403006998387e-09,  7.149773906029908e-12,  4.539773784732371e-15,
 -6.164669000643908e-17,  2.147557319089113e-19, -4.416181946326047e-22,  2.542968273817705e-25,  2.259625755374834e-27, -1.165560799855379e-29,  2.760507946502866e-01,
 -1.118105692671498e-03,  3.014038652178548e-06, -5.748476801478769e-09,  5.157834184723275e-12,  1.442416996633417e-14, -8.783138963627852e-17,  2.423505567737698e-19,
 -3.246180498820137e-22, -5.368536677641750e-25,  4.768680025731763e-27, -1.564734325950392e-29,  3.182567343131499e-01, -1.271363131896643e-03,  3.299226003040925e-06,
 -5.660323825854643e-09,  2.303669378129368e-12,  2.589579379477910e-14, -1.112578540518587e-16,  2.363682371740208e-19, -7.185159639465515e-23, -1.607579551572051e-24,
  7.071822285269572e-27, -1.536707129682354e-29,  3.633900452961338e-01, -1.429559631989959e-03,  3.551281112843113e-06, -5.313546730079807e-09, -1.416864274738264e-12,
  3.823660978553638e-14, -1.275889828681100e-16,  1.838644512389567e-19,  3.207388395259708e-22, -2.784360182974733e-24,  8.171889379677539e-27, -7.964112373497364e-30,
  4.114196822764593e-01, -1.591214110712591e-03,  3.759041785111587e-06, -4.674926721047375e-09, -5.947797990727619e-12,  5.041780648192343e-14, -1.319120050011954e-16,
  7.520767702750081e-20,  8.247913275481372e-22, -3.762737399399089e-24,  6.895067767120056e-27,  8.150791225080251e-30,  4.623072452267897e-01, -1.754662806337035e-03,
  3.910779468123733e-06, -3.717794482497187e-09, -1.115967508728941e-11,  6.109945273334335e-14, -1.192169864329045e-16, -9.251634836813234e-20,  1.369392503245648e-21,
 -4.124647434544476e-24,  2.228570184239903e-27,  3.161073425552708e-29,  5.160054534156217e-01, -1.918041983275487e-03,  3.994359032656046e-06, -2.424889950776174e-09,
 -1.683660530875152e-11,  6.866340181742630e-14, -8.511422884062535e-17, -3.116446687308764e-19,  1.835950574179815e-21, -3.404270956972578e-24, -6.158669132999279e-27,
  5.646796267624965e-29,  5.724563239748370e-01, -2.079270084766018e-03,  3.997467813134096e-06, -7.917508775289706e-10, -2.266515125534461e-11,  7.129308236113997e-14,
 -2.680927577987867e-17, -5.601721189896928e-19,  2.062935680890717e-21, -1.216119718792434e-24, -1.728324947556704e-26,  7.153918196041628e-29,  6.315889983673884e-01,
 -2.236030029437401e-03,  3.907934629293888e-06,  1.169362254403812e-09, -2.822715594594144e-11,  6.711578702525967e-14,  5.568359875237614e-17, -7.990307544670735e-19,
  1.866267867926728e-21,  2.552667948796380e-24, -2.829294472983931e-26,  6.200005298616997e-29,  6.933171501624807e-01, -2.385752737341604e-03,  3.714163890904462e-06,
  3.425056592942515e-09, -3.299953585363153e-11,  5.442340116308393e-14,  1.581758238356762e-16, -9.718485381109208e-19,  1.080834326796393e-21,  7.508775001555891e-24,
 -3.433324615977145e-26,  1.453946836226182e-29,  7.575358968004863e-01, -2.525603520479989e-03,  3.405714278168795e-06,  5.916063683713626e-09, -3.636517677727591e-11,
  3.198437590456337e-14,  2.709802355342169e-16, -1.009106101868869e-18, -3.742174343078793e-22,  1.254231479585986e-23, -2.931138415266855e-26, -7.343480952945064e-29,
  8.241181271197510e-01, -2.652473737497778e-03,  2.974055080221377e-06,  8.552471368016639e-09, -3.764029461268765e-11, -5.497070595725175e-16,  3.779749212372179e-16,
 -8.388858233907214e-19, -2.410921688936660e-21,  1.575980606523769e-23, -8.034802306235428e-27, -1.823170235598843e-28,  8.929101465088559e-01, -2.762981158287835e-03,
  2.413534577207607e-06,  1.120947691708501e-08, -3.612472863490375e-11, -4.215945704031117e-14,  4.565970219146849e-16, -4.060819631349068e-19, -4.686467038453084e-21,
  1.473505152299812e-23,  3.012828510261682e-26, -2.623300831422713e-28,  9.637265347428106e-01, -2.853483885909991e-03,  1.722591305841359e-06,  1.372454735253721e-08,
 -3.118213728144727e-11, -8.994657870647547e-14,  4.795111179440421e-16,  2.996131837874670e-19, -6.553388752978415e-21,  7.264829176060168e-24,  7.681610745585252e-26,
 -2.395907633848727e-28,  1.036344111384566e+00, -2.920114511365274e-03,  9.052264812763167e-07,  1.589733104258923e-08, -2.235607865298777e-11, -1.387034310443857e-13,
  4.188193888567086e-16,  1.210229689683489e-18, -7.106514483887821e-21, -7.287459486420183e-24,  1.117925073372684e-25, -4.856847765774434e-29,  1.110494915748187e+00,
 -2.958843473210875e-03, -2.727216536395196e-08,  1.749423288681822e-08, -9.524022972471653e-12, -1.807470069631003e-13,  2.535470436764365e-16,  2.150161114974622e-18,
 -5.400601346815227e-21, -2.629459105675721e-23,  1.057707418521592e-25,  3.051796289858197e-28,  1.185858141587127e+00, -2.965583320402386e-03, -1.054417586823200e-06,
  1.826017864037707e-08,  6.917657534873842e-12, -2.062896588612056e-13, -1.954121685148400e-17,  2.829317046621445e-18, -8.905409416146116e-22, -4.263775106059470e-23,
  3.361119799455047e-26,  6.754389672889164e-28,  1.262051033902964e+00, -2.936348521658925e-03, -2.144573643311165e-06,  1.794057467268203e-08,  2.586131163498560e-11,
 -2.046871182271876e-13, -3.733254915906418e-16,  2.885460443311967e-18,  5.950437721117126e-21, -4.548568020036830e-23, -1.012892751463718e-25,  7.671219168622831e-28,
  1.338618874979165e+00, -2.867488088628081e-03, -3.253260163867501e-06,  1.631644657944662e-08,  4.533812493664358e-11, -1.668809625435906e-13, -7.401975952960102e-16,
  2.002300134309939e-18,  1.308145858782181e-20, -2.485563978719425e-23, -2.420144885557035e-25,  2.860290215666955e-28,  1.415024383311497e+00, -2.756009481758069e-03,
 -4.322204592380213e-06,  1.325455754073210e-08,  6.249548642090469e-11, -8.911553174885116e-14, -1.012251369057729e-15,  1.073975801106113e-19,  1.693280700545159e-20,
  1.970734114749895e-23, -2.801571671846903e-25, -7.267145442667350e-28,  1.490637151636429e+00, -2.600010078585375e-03, -5.279886588365128e-06,  8.770986025460917e-09,
  7.382077745393574e-11,  2.259571692424928e-14, -1.062173960953522e-15, -2.406169152509252e-18,  1.368930771597789e-20,  7.028837113478427e-23, -1.186595669760081e-25,
 -1.595638677123561e-27,  1.564724187230362e+00, -2.399223774832578e-03, -6.044588939720356e-06,  3.100052379471865e-09,  7.574060859397745e-11,  1.488370450533529e-13,
 -7.925428916633825e-16, -4.585132183956394e-18,  2.042085076831722e-21,  9.157944086233841e-23,  2.084544699804160e-25, -1.268630618353902e-27,  1.636443203837476e+00,
 -2.155670732378968e-03, -6.531135358754654e-06, -3.249984863860065e-09,  6.566538519884830e-11,  2.568539916562969e-13, -2.074178025292185e-16, -5.170033366514661e-18,
 -1.379539316072230e-20,  5.256161865505619e-23,  4.613617611956915e-25,  5.395174013315287e-28,  1.704841025759243e+00, -1.874363104610107e-03, -6.662346354241145e-06,
 -9.485963589770707e-09,  4.336449401126821e-11,  3.077747701597486e-13,  5.274489602397714e-16, -3.326509100612171e-18, -2.398570192117397e-20, -3.601113680149890e-23,
  3.398681747447477e-25,  2.247895664232983e-27,  1.768860197374142e+00, -1.563965896397774e-03, -6.385453633205145e-06, -1.460464372927126e-08,  1.222204945781397e-11,
  2.726317763450627e-13,  1.098477507576955e-15,  4.211708703151959e-19, -1.913708335263948e-20, -1.056659157956698e-22, -1.412111764469709e-25,  1.553651629000190e-27,
  1.827357413599974e+00, -1.237243863836593e-03, -5.691947814626196e-06, -1.758853226462912e-08, -2.046409646435991e-11,  1.529391458548620e-13,  1.187597588694887e-15,
  3.914828071428096e-18, -5.277051146988102e-22, -8.298829183550288e-23, -4.827856657524787e-25, -1.096797165958205e-27,  1.879137305068476e+00, -9.110602879054729e-04,
 -4.636542988716401e-06, -1.772090977306437e-08, -4.509236871805099e-11, -7.120280826806673e-15,  7.112234523871240e-16,  4.652961719908909e-18,  1.645942444183842e-20,
  1.440787439103392e-23, -2.497599174444106e-25, -2.006336358015537e-27,  1.923003912408035e+00, -6.056688846366856e-04, -3.347846695496161e-06, -1.494314606702029e-08,
 -5.358036645607219e-11, -1.338254599567332e-13, -2.907846485148663e-17,  2.180659298754292e-18,  1.607148719515457e-20,  7.317890998695711e-23,  2.072273690646989e-25,
 -8.982574415772508e-30,  1.957829436090164e+00, -3.431083704143114e-04, -2.021815039295410e-06, -1.008851063430064e-08, -4.408761682645729e-11, -1.669733760849801e-13,
 -5.134575993485500e-16, -9.631478919664712e-19,  1.994605276296750e-21,  3.365272812664178e-23,  2.242127589217978e-25,  1.094844173210561e-27,  1.982635715842932e+00,
 -1.447107233644273e-04, -8.917834184765565e-07, -4.793514486636044e-09, -2.357166518935414e-11, -1.078131978106113e-13, -4.598482052208949e-16, -1.813636711147237e-18,
 -6.454073887873976e-21, -1.944027308379165e-23, -3.914417165692846e-26,  4.558332060146290e-29,  1.996682195122228e+00, -2.802793420632895e-05, -1.771118658358395e-07,
 -9.914042328069836e-10, -5.180362694250951e-12, -2.585196351880207e-14, -1.246620054356147e-16, -5.846659485906537e-19, -2.676793428274158e-21, -1.198661711648820e-23,
 -5.253565896006881e-26, -2.252826834069601e-28,  3.731383311843739e-04, -1.622217800723514e-06,  5.288535733665848e-09, -1.532362366491540e-11,  4.161248772661353e-14,
 -1.084691811889667e-16,  2.747324096020730e-19, -6.816959459346461e-22,  1.663102160843557e-24, -4.011097981044845e-27,  9.547636493972757e-30, -2.263591791312965e-32,
  3.358229643970887e-03, -1.458889160472249e-05,  4.747727986140986e-08, -1.371352023918232e-10,  3.705781187857557e-13, -9.591600565239852e-16,  2.406024124307648e-18,
 -5.894958795219099e-21,  1.415064978712866e-23, -3.344922569504200e-26,  7.765860784025986e-29, -1.787442178757525e-31,  9.328324101282644e-03, -4.046304481727346e-05,
  1.312164241711467e-07, -3.766162089840703e-10,  1.007617823118573e-12, -2.570375075235266e-15,  6.319140088426985e-18, -1.507071437444026e-20,  3.491792203413365e-23,
 -7.886079667697152e-26,  1.725531703256834e-28, -3.685671598597908e-31,  1.828321458225744e-02, -7.912550923506522e-05,  2.552255169275434e-07, -7.255022092881272e-10,
  1.911390189373215e-12, -4.765795142405321e-15,  1.134176753103051e-17, -2.585419290762191e-20,  5.626146050926017e-23, -1.164562578111974e-25,  2.244074330781280e-28,
 -3.965837378780532e-31,  3.022251254202196e-02, -1.303955724955617e-04,  4.175745577084362e-07, -1.171448440678587e-09,  3.021004986474591e-12, -7.291034403338049e-15,
  1.653168264705474e-17, -3.507394170702028e-20,  6.834958564145283e-23, -1.180065338932209e-25,  1.582505168907961e-28, -8.061682477877635e-32,  4.514555201571836e-02,
 -1.940285937116634e-04,  6.156730628339535e-07, -1.698098395873470e-09,  4.257418868221655e-12, -9.825903589127458e-15,  2.075528982663157e-17, -3.915667761553317e-20,
  6.112928653153004e-23, -5.869134235612292e-26, -7.664326000156867e-29,  6.471833923891590e-31,  6.305125726032734e-02, -2.697127704498415e-04,  8.462559374218801e-07,
 -2.285186106267448e-09,  5.525378910670380e-12, -1.200099179798973e-14,  2.279048233281539e-17, -3.464876650534614e-20,  2.659484651662861e-23,  7.424387791462322e-26,
 -4.776351811575579e-28,  1.655211167325700e-30,  8.393797009506632e-02, -3.570650108791980e-04,  1.105366603662487e-06, -2.908682038493345e-09,  6.715984921718246e-12,
 -1.341871579998544e-14,  2.145168330755042e-17, -1.881389834130024e-20, -3.882508862148462e-23,  2.735123583320339e-25, -9.674786758857661e-28,  2.576533291731927e-30,
  1.078032317579169e-01, -4.556258535728625e-04,  1.388338030994961e-06, -3.540995786791219e-09,  7.709958769202945e-12, -1.367895490745832e-14,  1.573367173556581e-17,
  9.735051427399276e-21, -1.320730462625154e-22,  5.062467777816611e-25, -1.388986931472899e-27,  2.852243319368130e-30,  1.346435126649954e-01, -5.648533665665325e-04,
  1.689772574558803e-06, -4.151252551181352e-09,  8.381724946787515e-12, -1.240930060366102e-14,  4.969017063558753e-18,  5.042587676245420e-20, -2.418377810620809e-22,
  7.127917192979916e-25, -1.522839310166204e-27,  1.872309327021020e-30,  1.644538817875061e-01, -6.841159473649973e-04,  2.003521875960701e-06, -4.705664846169935e-09,
  8.604419713260103e-12, -9.299778790892406e-15, -1.100850312529333e-17,  1.002106673848918e-19, -3.479315965894644e-22,  8.116582315103658e-25, -1.133249069890713e-27,
 -7.891957718617016e-31,  1.972276053848900e-01, -8.126839374341365e-04,  2.322668543372438e-06, -5.168026079641696e-09,  8.255953904986299e-12, -4.141615990205602e-15,
 -3.170538825733396e-17,  1.532330613741004e-19, -4.221345387675834e-22,  7.120911577029518e-25, -4.153440661915349e-29, -5.078937520064620e-30,  2.329556624778254e-01,
 -9.497199595639779e-04,  2.639511942156508e-06, -5.500358632121205e-09,  7.226253027250472e-12,  3.130823317366291e-15, -5.582987951901283e-17,  2.007868924438867e-19,
 -4.309561361763424e-22,  3.348667909741571e-25,  1.779598587331845e-27, -1.018302555623676e-29,  2.716261616223895e-01, -1.094267886217644e-03,  2.945561237847635e-06,
 -5.663755833617759e-09,  5.425781564045027e-12,  1.239645600863005e-14, -8.119365360745716e-17,  2.316890412411317e-19, -3.406738704860674e-22, -3.595037372454076e-25,
  4.108089608744130e-27, -1.437477638638838e-29,  3.132236401523316e-01, -1.245240354387705e-03,  3.231539896797401e-06, -5.619464624153777e-09,  2.795417889535491e-12,
  2.330471365449906e-14, -1.046800515625019e-16,  2.331962945786244e-19, -1.247953117595719e-22, -1.338182848062890e-24,  6.399687728955948e-27, -1.513828044544975e-29,
  3.577282229676274e-01, -1.401404761669857e-03,  3.487407235168744e-06, -5.330263306852163e-09, -6.823308212443436e-13,  3.523732206290214e-14, -1.223117105487508e-16,
  1.925866700349486e-19,  2.262960331720811e-22, -2.465050247340553e-24,  7.780855719853317e-27, -9.716262417619124e-30,  4.051146130234196e-01, -1.561367715194087e-03,
  3.702404396489888e-06, -4.762195885065836e-09, -4.970915281728051e-12,  4.728004734208846e-14, -1.294566642938063e-16,  9.948751371991211e-20,  6.943714834443131e-22,
 -3.481088818877905e-24,  7.155867880969147e-27,  3.826053059084234e-30,  4.553508797564018e-01, -1.723557968301684e-03,  3.865134425395741e-06, -3.886729623825771e-09,
 -9.966482925005377e-12,  5.821197476719510e-14, -1.212161411028283e-16, -5.105177845996262e-20,  1.222827004802336e-21, -4.009651754934848e-24,  3.473633324013403e-27,
  2.507901057601696e-29,  5.083970046068252e-01, -1.886207981655486e-03,  3.963688989637615e-06, -2.683403329263434e-09, -1.548443767353182e-11,  6.652247169244876e-14,
 -9.303650903543048e-17, -2.548979151793199e-19,  1.709543145171411e-21, -3.602928732660928e-24, -3.823993583245522e-27,  4.963768368860973e-29,  5.642031343868519e-01,
 -2.047334403111784e-03,  3.985837874025864e-06, -1.143026562928248e-09, -2.124695594108026e-11,  7.046885641401183e-14, -4.157739743910410e-17, -4.949859859581287e-19,
  2.007461694747771e-21, -1.845430072882844e-24, -1.420778760793016e-26,  6.804121932906643e-29,  6.227074833710597e-01, -2.204717998350777e-03,  3.919301680512986e-06,
  7.285314122565306e-10, -2.687325313435775e-11,  6.819054472317614e-14,  3.415911479785830e-17, -7.380528379307450e-19,  1.938464454432269e-21,  1.477011179203881e-24,
 -2.545753009149494e-26,  6.644891509734448e-29,  6.838338135785450e-01, -2.355883915353661e-03,  3.752133177053607e-06,  2.905968846167445e-09, -3.187528856098894e-11,
  5.789722845543787e-14,  1.314870350568695e-16, -9.332002879104361e-19,  1.326629632651639e-21,  6.153154514542724e-24, -3.333198907381612e-26,  3.043716834767217e-29,
  7.474884098705594e-01, -2.498083675661683e-03,  3.473238213415376e-06,  5.339682087876316e-09, -3.566274790819022e-11,  3.814789770660290e-14,  2.426238467140849e-16,
 -1.014088815155198e-18,  5.549514530011670e-23,  1.131313371819596e-23, -3.195571805216172e-26, -4.709060556545356e-29,  8.135564525878773e-01, -2.628281014064091e-03,
  3.073072479930102e-06,  7.950623444032323e-09, -3.756252020584563e-11,  8.231629157428209e-15,  3.534907865637283e-16, -9.070349110099299e-19, -1.851214160298218e-21,
  1.528600652123345e-23, -1.545279546831581e-26, -1.545521802358440e-28,  8.818976763976502e-01, -2.743144712938836e-03,  2.544554418404763e-06,  1.062532698388795e-08,
 -3.685934095660607e-11, -3.135402041266535e-14,  4.432084640488732e-16, -5.473513517843172e-19, -4.137070521417840e-21,  1.571208438543625e-23,  1.880541504468854e-26,
 -2.510865256523102e-28,  9.523411915766017e-01, -2.839052991375620e-03,  1.884235056380194e-06,  1.321186941521793e-08, -3.286542803328278e-11, -7.836107656123174e-14,
  4.850077920651593e-16,  9.466115129128693e-20, -6.239168203735300e-21,  1.011798490883538e-23,  6.564898993605444e-26, -2.660489490624348e-28,  1.024679336301806e+00,
 -2.912115915704077e-03,  1.093758525426702e-06,  1.551799843192012e-08, -2.502701954285743e-11, -1.282710373753674e-13,  4.494887841596717e-16,  9.794811601941353e-19,
 -7.289091721965502e-21, -2.880813148422868e-24,  1.080034197323142e-25, -1.221735906341101e-28,  1.098660431045784e+00, -2.958224790376708e-03,  1.816261560909816e-07,
  1.731327973077190e-08, -1.307333978559461e-11, -1.739597972052452e-13,  3.111957446049382e-16,  1.963037310002427e-18, -6.268073541134809e-21, -2.182361692808981e-23,
  1.170651078824574e-25,  2.073836954410621e-28,  1.173980327640635e+00, -2.973140604511792e-03, -8.347675083149820e-07,  1.833785619287245e-08,  2.793568734042925e-12,
 -2.058126253349943e-13,  5.905212518681841e-17,  2.776577163797311e-18, -2.394267181069695e-21, -4.071352533887787e-23,  6.219161248032498e-26,  6.194135707947842e-28,
  1.250272699638445e+00, -2.952637243093712e-03, -1.926940655801262e-06,  1.832114674054127e-08,  2.168462006147728e-11, -2.126574378646502e-13, -2.901181571319129e-16,
  3.048960181817688e-18,  4.248371826251683e-21, -4.883936541307681e-23, -6.589410831575157e-26,  8.358359623476614e-28,  1.327098127579601e+00, -2.892718908365187e-03,
 -3.053223558842074e-06,  1.701421030844731e-08,  4.182764019627940e-11, -1.839265223463756e-13, -6.784203757290100e-16,  2.404750084060158e-18,  1.201602435246074e-20,
 -3.422028002800917e-23, -2.246477046361519e-25,  5.013694969317611e-28,  1.403932221266248e+00, -2.789934044984674e-03, -4.157213421733552e-06,  1.423890899423152e-08,
  6.047079797077459e-11, -1.133116732477180e-13, -1.001567446356869e-15,  6.583773365465050e-19,  1.743344329889265e-20,  7.927133837815951e-24, -3.071483773038386e-25,
 -4.928097586102110e-28,  1.480153328112602e+00, -2.641808059474859e-03, -5.167537595254430e-06,  9.954326718022246e-09,  7.401257846730181e-11, -3.653128525695654e-15,
 -1.123040815562159e-15, -1.928679051488606e-18,  1.611726934033737e-20,  6.413184904529572e-23, -1.891700945165638e-25, -1.595986545268963e-27,  1.555030843685919e+00,
 -2.447410863088738e-03, -6.000022446855523e-06,  4.334639090200292e-09,  7.851679141120188e-11,  1.282858964285079e-13, -9.195053019765370e-16, -4.465542155472647e-18,
  5.474586840188772e-21,  9.869249437268725e-23,  1.445489482489162e-25, -1.631948993278248e-27,  1.627715801471098e+00, -2.208057565124792e-03, -6.563662789232162e-06,
 -2.158562627369014e-09,  7.074070920186673e-11,  2.500908258141509e-13, -3.580489812452364e-16, -5.577609281845048e-18, -1.156634223301884e-20,  7.137209375330763e-23,
  4.760482051973185e-25,  1.121309407453102e-28,  1.697236272140077e+00, -1.928104934431388e-03, -6.771809656917655e-06, -8.742233172082745e-09,  4.963857967146374e-11,
  3.192280066058286e-13,  4.233860545001555e-16, -4.111974951575883e-18, -2.501329919914446e-20, -2.041103513342347e-23,  4.406119871360880e-25,  2.312607935732599e-27,
  1.762501061828858e+00, -1.615746800243674e-03, -6.559351456407553e-06, -1.436403471986546e-08,  1.793890212211737e-11,  2.990639998892165e-13,  1.101118064553337e-15,
 -2.530260765524235e-19, -2.302476946585791e-20, -1.097834037649337e-22, -6.051658276044846e-26,  2.122606550977821e-27,  1.822316022712317e+00, -1.283629019422951e-03,
 -5.904868697143809e-06, -1.788990171931291e-08, -1.711143336458148e-11,  1.827520659914947e-13,  1.296500129772627e-15,  3.846322638028207e-18, -3.873917302600453e-21,
 -1.031968176504725e-22, -5.257085731154754e-25, -8.310452104455296e-28,  1.875417515118017e+00, -9.490155051816585e-04, -4.853524344945109e-06, -1.844255410969746e-08,
 -4.505321842656050e-11,  1.157240037031799e-14,  8.489433968123222e-16,  5.185854409243718e-18,  1.677593751954278e-20,  2.534292037345443e-24, -3.468663606666397e-25,
 -2.410657135413474e-27,  1.920526514800033e+00, -6.331837066251766e-04, -3.532396551801795e-06, -1.582186008507038e-08, -5.625859786986172e-11, -1.337300357658151e-13,
  3.958744720235305e-17,  2.738692828464723e-18,  1.885439966475170e-20,  8.138884483768532e-23,  2.013351616061027e-25, -2.749329972537382e-28,  1.956423869571276e+00,
 -3.597793892653858e-04, -2.147221974103956e-06, -1.082130681685143e-08, -4.755245633286646e-11, -1.796115799610976e-13, -5.393371247606614e-16, -8.781078507455580e-19,
  3.379688766742514e-21,  4.364461203145631e-23,  2.769075367447576e-25,  1.304339893722439e-27,  1.982042230835087e+00, -1.520816587598786e-04, -9.516416194891047e-07,
 -5.188528577459474e-09, -2.584252943970498e-11, -1.194829319516073e-13, -5.136287957739620e-16, -2.031661918409946e-18, -7.181466374869474e-21, -2.094826264108162e-23,
 -3.577469967682538e-26,  1.116964119037132e-28,  1.996567172206396e+00, -2.949386597432342e-05, -1.895236359553813e-07, -1.078594654746964e-09, -5.728698638601083e-12,
 -2.905039241137297e-14, -1.422997349386670e-16, -6.776534224990890e-19, -3.148653143812642e-21, -1.430037885239679e-23, -6.351991468748397e-26, -2.757766279845171e-28,
  3.667329277225362e-04, -1.580633892770850e-06,  5.108576601843235e-09, -1.467482706245156e-11,  3.950752431804019e-14, -1.020987702563038e-16,  2.563687992553905e-19,
 -6.307152659235118e-22,  1.525343521231572e-24, -3.648389210274271e-27,  8.605160654837937e-30, -2.025200252419009e-32,  3.300623432159580e-03, -1.421555649611209e-05,
  4.586660989836577e-08, -1.313563358583018e-10,  3.519592534811998e-13, -9.033461065415491e-16,  2.247127928805807e-18, -5.460820282345637e-21,  1.300054688202979e-23,
 -3.049466902484095e-26,  7.020161898312375e-29, -1.605626186677175e-31,  9.168543143809198e-03, -3.943112078402518e-05,  1.267920908322319e-07, -3.608974849022492e-10,
  9.576933764402950e-13, -2.423655786310153e-15,  5.912385837045203e-18, -1.399746367722071e-20,  3.219935750267809e-23, -7.227271973958423e-26,  1.570988258178202e-28,
 -3.344908844390418e-31,  1.797074173996286e-02, -7.711801645668765e-05,  2.466998856932824e-07, -6.956679463368599e-10,  1.818738708621593e-12, -4.502080101735380e-15,
  1.064243715869745e-17, -2.411920620605706e-20,  5.222647549415728e-23, -1.078210352630993e-25,  2.075470680014386e-28, -3.700355086434782e-31,  2.970752356051066e-02,
 -1.271103947896462e-04,  4.038024497443679e-07, -1.124257698592573e-09,  2.879073615361555e-12, -6.905815593991350e-15,  1.557960291006382e-17, -3.295351240391863e-20,
  6.421437107875347e-23, -1.117544925169014e-25,  1.541882342876347e-28, -1.030600378246226e-31,  4.437916096977596e-02, -1.891835746754309e-04,  5.956981958597715e-07,
 -1.631525142478194e-09,  4.065794392679427e-12, -9.340714205588998e-15,  1.968596723024162e-17, -3.723488470258063e-20,  5.896776643434212e-23, -6.122150629541152e-26,
 -5.067492263208899e-29,  5.359329219755016e-31,  6.198577469731940e-02, -2.630509270305607e-04,  8.193563152374535e-07, -2.198670811691180e-09,  5.290750714083525e-12,
 -1.146556369930937e-14,  2.183260768697071e-17, -3.375851565755262e-20,  2.894070086119626e-23,  5.653173154283730e-26, -4.094948542695885e-28,  1.446099105044983e-30,
  8.252717740964813e-02, -3.483598882554556e-04,  1.071098387517316e-06, -2.803345482798998e-09,  6.452715651880494e-12, -1.291032842547952e-14,  2.090892877462154e-17,
 -1.990600989262479e-20, -2.964861178464372e-23,  2.370034210022166e-25, -8.598408915183684e-28,  2.319401282033915e-30,  1.060026755698216e-01, -4.446870406721735e-04,
  1.346577276177108e-06, -3.419804478263732e-09,  7.440175433268834e-12, -1.329853692222009e-14,  1.594974921455313e-17,  5.789831380651899e-21, -1.148184759375691e-22,
  4.531435760835268e-25, -1.267510792660553e-27,  2.668652865959834e-30,  1.324108232584983e-01, -5.515321850810521e-04,  1.640754021664706e-06, -4.019123495910184e-09,
  8.134841444330600e-12, -1.227395229095440e-14,  6.276373039258487e-18,  4.308604207434293e-20, -2.172536522990345e-22,  6.535488968996362e-25, -1.438822132014004e-27,
  1.938338877609576e-30,  1.617491200028817e-01, -6.683113180920480e-04,  1.947873740298155e-06, -4.569495518739192e-09,  8.416002985766506e-12, -9.531543517607853e-15,
 -8.354147821294785e-18,  8.953556406219668e-20, -3.195348130071925e-22,  7.657854793020104e-25, -1.156826938775354e-27, -2.999479804288909e-31,  1.940136427235222e-01,
 -7.943484152762501e-04,  2.261441938521954e-06, -5.036633387927121e-09,  8.165852036173669e-12, -4.852561773200496e-15, -2.760012970276453e-17,  1.401341811185325e-19,
 -3.965802566065208e-22,  7.062616484716876e-25, -2.427424756865310e-28, -4.090380190194046e-30,  2.291985995839589e-01, -9.288659114050069e-04,  2.574203194535346e-06,
 -5.384308570515071e-09,  7.275917702465747e-12,  1.856823876329408e-15, -5.039900958659555e-17,  1.872020660032013e-19, -4.177238790157591e-22,  3.974967875535442e-25,
  1.361757514469398e-27, -8.829809488232684e-30,  2.672957907193705e-01, -1.070973762616691e-03,  2.878124887546374e-06, -5.575063588781426e-09,  5.654743264869951e-12,
  1.052441310831069e-14, -7.486070892592754e-17,  2.206109031625049e-19, -3.508071682645345e-22, -2.074519168317606e-25,  3.503849619866859e-27, -1.309176324442664e-29,
  3.082939574128575e-01, -1.219656974614317e-03,  3.164389626412574e-06, -5.571143475166665e-09,  3.236915324708659e-12,  2.087025233304972e-14, -9.821336113225361e-17,
  2.284801611243503e-19, -1.685215444519959e-22, -1.095392968578629e-24,  5.743267549099803e-27, -1.466405562543864e-29,  3.521779971440057e-01, -1.373761489487556e-03,
  3.423401316758329e-06, -5.335700275814745e-09, -6.498515133451404e-15,  3.236728854630501e-14, -1.168308207227011e-16,  1.984674817444581e-19,  1.430497398805585e-22,
 -2.162762253959082e-24,  7.324633815815496e-27, -1.094091216512908e-29,  3.989280168906419e-01, -1.531978346739812e-03,  3.644811498701764e-06, -4.834333542658324e-09,
 -4.056145804382286e-12,  4.420891223796749e-14, -1.263783797048369e-16,  1.197577990734941e-19,  5.742348658709088e-22, -3.192599315088628e-24,  7.242337580151806e-27,
  2.183309942824728e-31,  4.485181909307811e-01, -1.692826079350654e-03,  3.817574794295235e-06, -4.037037908670089e-09, -8.831428799096998e-12,  5.528992335875184e-14,
 -1.221192614784847e-16, -1.420200681896301e-20,  1.081230125339986e-21, -3.850425904279806e-24,  4.444518271177157e-27,  1.915630518525353e-29,  5.009153819516644e-01,
 -1.854631384550886e-03,  3.930045149148851e-06, -2.920634373133433e-09, -1.417686367446527e-11,  6.421001068438575e-14, -9.942746070453790e-17, -2.022931914140094e-19,
  1.577592435206749e-21, -3.714222383451888e-24, -1.790386446180239e-27,  4.281714510972334e-29,  5.560774752922872e-01, -2.015508237829062e-03,  3.970128168759706e-06,
 -1.471761640378222e-09, -1.984864277526950e-11,  6.931187740144071e-14, -5.454839812432731e-17, -4.319140834126230e-19,  1.931506507354174e-21, -2.355154105274067e-24,
 -1.131205569352391e-26,  6.342752957023019e-29,  6.139513653905794e-01, -2.173335821019082e-03,  3.925509356313369e-06,  3.095074931552880e-10, -2.550288154679745e-11,
  6.876942945958856e-14,  1.436869317850747e-17, -6.753619818911623e-19,  1.974019215998763e-21,  5.179379709105009e-25, -2.248165232785396e-26,  6.844248716784905e-29,
  6.744705207788607e-01, -2.325735944437106e-03,  3.783983519016673e-06,  2.405390449608148e-09, -3.068787797439347e-11,  6.074435464081288e-14,  1.059832397158590e-16,
 -8.874583844782225e-19,  1.524503404580364e-21,  4.850621432487760e-24, -3.170237521287121e-26,  4.311037122447055e-29,  7.375520391796502e-01, -2.470051105489158e-03,
  3.533916950766875e-06,  4.775488520691276e-09, -3.484385758269109e-11,  4.363070426411018e-14,  2.143136682367202e-16, -1.006046918165643e-18,  4.393269597074567e-22,
  1.000072982458719e-23, -3.348923697332173e-26, -2.303778591461933e-29,  8.030930875348896e-01, -2.603325005841319e-03,  3.164880861469470e-06,  7.351392384452135e-09,
 -3.731513944344563e-11,  1.640445420307810e-14,  3.273462679065797e-16, -9.576011143532118e-19, -1.313605612955703e-21,  1.454037813822811e-23, -2.161727531277962e-26,
 -1.255535424892350e-28,  8.709666037293168e-01, -2.722288331567300e-03,  2.668501009067765e-06,  1.003113335596731e-08, -3.738136780487807e-11, -2.091535966938372e-14,
  4.261151636778246e-16, -6.705635958593608e-19, -3.560514409275556e-21,  1.624823405775480e-23,  8.134330498281640e-27, -2.329517929989030e-28,  9.410161187018965e-01,
 -2.823353995586082e-03,  2.039572740128977e-06,  1.267411774435892e-08, -3.431614810813599e-11, -6.671129012587116e-14,  4.849213945580252e-16, -9.868068498591999e-20,
 -5.830523289319165e-21,  1.250464380242545e-23,  5.357652469887457e-26, -2.808097336155005e-28,  1.013049542280698e+00, -2.902627982044790e-03,  1.277489176824228e-06,
  1.509763773615362e-08, -2.748247803642303e-11, -1.171806245412222e-13,  4.736390303762013e-16,  7.453929673326050e-19, -7.316512823395686e-21,  1.312332903296727e-24,
  1.011917630757896e-25, -1.855934448351172e-28,  1.086831748346688e+00, -2.955944561340673e-03,  3.880170233267500e-07,  1.707669679726355e-08, -1.647351668166526e-11,
 -1.658548773730053e-13,  3.632411208928436e-16,  1.750808379640792e-18, -6.967506303285094e-21, -1.698801781680283e-23,  1.239838646849696e-25,  1.070957978073374e-28,
  1.162075803280597e+00, -2.978938079834720e-03, -6.145805664867168e-07,  1.834972653662280e-08, -1.302264409928357e-12, -2.034724379063148e-13,  1.355070380168184e-16,
  2.677041771830120e-18, -3.808804472206688e-21, -3.770268390120591e-23,  8.776888310703763e-26,  5.396408860244647e-28,  1.238432719920539e+00, -2.967167780631950e-03,
 -1.705146670827809e-06,  1.863372643890276e-08,  1.736883042731315e-11, -2.185821018862433e-13, -2.031115264021734e-16,  3.156340612648618e-18,  2.451688699102375e-21,
 -5.072754775912202e-23, -2.828538951573411e-26,  8.673431571775599e-28,  1.315479709135310e+00, -2.916316922822096e-03, -2.845161774433141e-06,  1.765316330760001e-08,
  3.799196233525402e-11, -1.993583645642526e-13, -6.059014915410219e-16,  2.767864459098391e-18,  1.062821142671507e-20, -4.270522452297428e-23, -1.981620081862714e-25,
  6.985575599027697e-28,  1.392707074811710e+00, -2.822492017353061e-03, -3.980620313661213e-06,  1.518701325453344e-08,  5.796600812176221e-11, -1.370648598969351e-13,
 -9.752969251911854e-16,  1.218404563663424e-18,  1.749315192546054e-20, -4.714625314982508e-24, -3.229528014842675e-25, -2.202472195015318e-28,  1.469504200203427e+00,
 -2.682650436287049e-03, -5.040987669480703e-06,  1.113646174199269e-08,  7.366592190802713e-11, -3.119378652906479e-14, -1.169487413569210e-15, -1.377583251699123e-18,
  1.827304681356795e-20,  5.517907200600698e-23, -2.578545702261561e-25, -1.511602694036279e-27,  1.545145559704450e+00, -2.495181436424941e-03, -5.940388496304224e-06,
  5.610192347894108e-09,  8.085181659157733e-11,  1.047404623375736e-13, -1.041546630747836e-15, -4.232539037044019e-18,  9.113377423915967e-21,  1.029391630462794e-22,
  6.542092707856137e-26, -1.956017469079254e-27,  1.618778416216680e+00, -2.260650860133763e-03, -6.582611031958265e-06, -9.872174634853976e-10,  7.564373834642806e-11,
  2.395842552469734e-13, -5.189912813969423e-16, -5.902945804096756e-18, -8.654324619322405e-21,  9.036634536294145e-23,  4.698903416852721e-25, -4.057524795048484e-28,
  1.689414858743341e+00, -1.982685048572806e-03, -6.871738783361601e-06, -7.896428101596157e-09,  5.611495662656370e-11,  3.279166478238116e-13,  2.969597360234736e-16,
 -4.920557048323663e-18, -2.540639367018861e-20, -7.601174922329260e-25,  5.414637022530851e-25,  2.247564917777085e-27,  1.755932040837534e+00, -1.668905742292365e-03,
 -6.729795715369487e-06, -1.402773014157537e-08,  2.418343076308140e-11,  3.253188952895692e-13,  1.083121868850939e-15, -1.053327916202940e-18, -2.699643133362833e-20,
 -1.101595864818242e-22,  4.612042731068105e-26,  2.727933115244352e-27,  1.817085662912442e+00, -1.331731049644802e-03, -6.121064023253445e-06, -1.813271736684808e-08,
 -1.313659605028742e-11,  2.151428459350571e-13,  1.401873829686436e-15,  3.658792381320739e-18, -7.975329302204663e-21, -1.248447496674610e-22, -5.536222566827197e-25,
 -4.096606073724805e-28,  1.871542377805778e+00, -9.887411719820623e-04, -5.079148741987204e-06, -1.916039653746629e-08, -4.460594898527914e-11,  3.375013405692741e-14,
  1.001656326981706e-15,  5.721251617494152e-18,  1.659076045108681e-20, -1.358308805548914e-23, -4.619978716394084e-25, -2.821396373013974e-27,  1.917936037296626e+00,
 -6.622178334620189e-04, -3.727747718555989e-06, -1.674331550052013e-08, -5.891712220278894e-11, -1.317887965387468e-13,  1.251690093880613e-16,  3.390438307865582e-18,
  2.192553207100221e-20,  8.909847504137717e-23,  1.814097027436251e-25, -6.511083078709605e-28,  1.954949555417421e+00, -3.774897996729575e-04, -2.281763535786840e-06,
 -1.161159538693399e-08, -5.127605078279927e-11, -1.928369631630278e-13, -5.621579287489199e-16, -7.425645648881323e-19,  5.164704524390664e-21,  5.593548126001621e-23,
  3.393245093931337e-25,  1.536085188960185e-27,  1.981418273437388e+00, -1.599510563189901e-04, -1.016465927539884e-06, -5.621815907194476e-09, -2.836020399828552e-11,
 -1.325193360691152e-13, -5.738479045158566e-16, -2.273800118510341e-18, -7.959947722859739e-21, -2.225529759430416e-23, -2.888253576130046e-26,  2.072208297938292e-28,
  1.996446080131534e+00, -3.106343120646611e-05, -2.030365193485991e-07, -1.175094116972991e-09, -6.345456267588445e-12, -3.270515695591182e-14, -1.627656596510980e-16,
 -7.871624756193980e-19, -3.712282625713401e-21, -1.710130349507910e-23, -7.698162592996345e-26, -3.383382788108178e-28,  3.604910290592090e-04, -1.540459078656074e-06,
  4.936205080971157e-09, -1.405871407839751e-11,  3.752567496165295e-14, -9.615244278871784e-17,  2.393728443480063e-19, -5.839410179028559e-22,  1.399988331428848e-24,
 -3.321364863295255e-27,  7.761417619757704e-30, -1.814244860819159e-32,  3.244485222217699e-03, -1.385483434243254e-05,  4.432353509979956e-08, -1.258666440788788e-10,
  3.344194956320768e-13, -8.512038572226914e-16,  2.099887954072088e-18, -5.061839277901169e-21,  1.195162618423391e-23, -2.782300355124270e-26,  6.349934738562406e-29,
 -1.443999468618384e-31,  9.012820268877111e-03, -3.843385027856448e-05,  1.225516845795163e-07, -3.459545972453434e-10,  9.106080787628773e-13, -2.286347602561542e-15,
  5.534499509022729e-18, -1.300752874926600e-20,  2.970718858762653e-23, -6.627385390663200e-26,  1.430678492906397e-28, -3.038155924997021e-31,  1.766616469102898e-02,
 -7.517732148976215e-05,  2.385235422147463e-07, -6.672748083397102e-10,  1.731197550140196e-12, -4.254580342330976e-15,  9.989924559658057e-18, -2.250849303983959e-20,
  4.849049659897864e-23, -9.983729985339763e-26,  1.918221174061299e-28, -3.449914512768768e-31,  2.920545846885229e-02, -1.239331668195903e-04,  3.905832555510490e-07,
 -1.079277445026732e-09,  2.744622854031625e-12, -6.542748980221732e-15,  1.468507621920277e-17, -3.096184198317339e-20,  6.030108231697274e-23, -1.056830461078984e-25,
  1.492594065922442e-28, -1.201955787896069e-31,  4.363183538905138e-02, -1.844952104521673e-04,  5.765041277345040e-07, -1.567941626633053e-09,  3.883621385284881e-12,
 -8.880550735229505e-15,  1.866947415641015e-17, -3.538352662129227e-20,  5.673272108901780e-23, -6.280613194928371e-26, -2.925418625128067e-29,  4.400862109654285e-31,
  6.094651560016161e-02, -2.566001908677068e-04,  7.934727016410609e-07, -2.115825140212615e-09,  5.066603250050430e-12, -1.095281755604248e-14,  2.090061879775695e-17,
 -3.280289119928805e-20,  3.069582543772503e-23,  4.136815863774172e-26, -3.500385962936565e-28,  1.260043707516597e-30,  8.115066482876239e-02, -3.399239260473412e-04,
  1.038069269406640e-06, -2.702140611009227e-09,  6.199481557978954e-12, -1.241530211237075e-14,  2.033951439144592e-17, -2.072469414812249e-20, -2.171163077272578e-23,
  2.045795661816383e-25, -7.630812967262979e-28,  2.081932889372136e-30,  1.042452155689590e-01, -4.340765694284013e-04,  1.306245169749947e-06, -3.302868590926797e-09,
  7.178043682953796e-12, -1.291419801218463e-14,  1.606280977940107e-17,  2.367092067744371e-21, -9.939011481358582e-23,  4.047368199561150e-25, -1.154183635856161e-27,
  2.482438707793493e-30,  1.302306442283866e-01, -5.385968767599195e-04,  1.593297411282658e-06, -3.890921284456991e-09,  7.890962477967490e-12, -1.210960667041564e-14,
  7.388911364212404e-18,  3.649942907960136e-20, -1.947412020819026e-22,  5.977107890864609e-25, -1.352934083118150e-27,  1.958962410093056e-30,  1.591066966412587e-01,
 -6.529453893563241e-04,  1.893841406532939e-06, -4.436374579824506e-09,  8.223564322060662e-12, -9.703089400384344e-15, -5.986222977420913e-18,  7.974259337847011e-20,
 -2.928015116065434e-22,  7.193701519832414e-25, -1.161094168159373e-27,  9.091979655592207e-32,  1.908720524749721e-01, -7.764964246621438e-04,  2.201782943972300e-06,
 -4.906790847223565e-09,  8.062487282033773e-12, -5.469290417754299e-15, -2.385023362014031e-17,  1.278482093753276e-19, -3.713705990199113e-22,  6.932127246038109e-25,
 -4.034982955324411e-28, -3.238183527090090e-30,  2.255239167791464e-01, -9.085287512063637e-04,  2.510290997211402e-06, -5.267660760602806e-09,  7.301375242971882e-12,
  7.086506306691471e-16, -4.534227012375425e-17,  1.740736352504893e-19, -4.025237651761276e-22,  4.445680183931936e-25,  1.000767744407483e-27, -7.599088850033628e-30,
  2.630575241539977e-01, -1.048214813105191e-03,  2.811773615418859e-06, -5.482999331496028e-09,  5.847758720688268e-12,  8.800606877756210e-15, -6.884170154232666e-17,
  2.092915268864780e-19, -3.558880819030007e-22, -7.844474535374032e-26,  2.955705360618556e-27, -1.182947741159633e-29,  3.034655376252832e-01, -1.194608361147384e-03,
  3.097860014010895e-06, -5.516139496104479e-09,  3.631264059424453e-12,  1.858925674309036e-14, -9.189703368758734e-17,  2.224996119889531e-19, -2.039744011840231e-22,
 -8.783847693700312e-25,  5.111926719523314e-27, -1.400803769119833e-29,  3.467373201550359e-01, -1.346630346116421e-03,  3.359393163691121e-06, -5.330775935464698e-09,
  6.132603583811912e-13,  2.963048124660265e-14, -1.112209522054349e-16,  2.018549108413372e-19,  7.034560742056144e-23, -1.879663677934446e-24,  6.824636547679132e-27,
 -1.171902287850710e-29,  3.928580516080057e-01, -1.503052939899228e-03,  3.586438753454586e-06, -4.892322070866256e-09, -3.202016472138694e-12,  4.121804197856664e-14,
 -1.227847840054697e-16,  1.363502516623640e-19,  4.645096917894317e-22, -2.903626830023204e-24,  7.184834013415370e-27, -2.728127860991361e-30,  4.418076577134348e-01,
 -1.662481577958844e-03,  3.768318497540489e-06, -4.169653691725733e-09, -7.754951497716483e-12,  5.235807212229411e-14, -1.220531113796594e-16,  1.821537547981872e-20,
  9.460033168068690e-22, -3.657388768411563e-24,  5.168886345717678e-27,  1.387693277469474e-29,  4.935595098513238e-01, -1.823334973166808e-03,  3.893678511365511e-06,
 -3.137322068409865e-09, -1.291695589605422e-11,  6.176136173441083e-14, -1.044050878058493e-16, -1.539598805993821e-19,  1.443027415381759e-21, -3.750128680131870e-24,
 -5.321224834430427e-29,  3.618999447446700e-29,  5.480788450542022e-01, -1.983823150996546e-03,  3.950607063860684e-06, -1.778325142708334e-09, -1.847644067132253e-11,
  6.786449571138308e-14, -6.579001508472290e-17, -3.715444055361086e-19,  1.839234910731969e-21, -2.753362194660523e-24, -8.637687434394859e-27,  5.803101153722348e-29,
  6.053208441235960e-01, -2.141923721972818e-03,  3.926820600861535e-06, -8.752306696742788e-11, -2.412553925076469e-11,  6.889450569306214e-14, -3.655481849148703e-18,
 -6.120626933204471e-19,  1.977205207959742e-21, -3.209892567899035e-25, -1.946549866634641e-26,  6.833990950841114e-29,  6.652282918857576e-01, -2.295356871458427e-03,
  3.809942684232216e-06,  1.924233353460454e-09, -2.944953851660859e-11,  6.299543167741818e-14,  8.184191154877502e-17, -8.361211638115494e-19,  1.676785227145770e-21,
  3.623497534991267e-24, -2.958420891048454e-26,  5.267124912848860e-29,  7.277287270756573e-01, -2.441559955876376e-03,  3.587907478121605e-06,  4.225237632257272e-09,
 -3.392208034343757e-11,  4.843811252272681e-14,  1.863934441551774e-16, -9.864881629396512e-19,  7.750560480889120e-22,  8.647365184816378e-24, -3.402393119577698e-26,
 -1.752142701485235e-30,  7.927309700184280e-01, -2.577663214170576e-03,  3.249527501245289e-06,  6.757392529875878e-09, -3.691068161317795e-11,  2.393473810704841e-14,
  3.000223840421293e-16, -9.914384133414687e-19, -8.069696691414921e-22,  1.357377641665768e-23, -2.650137416134058e-26, -9.653987342821984e-29,  8.601208943934758e-01,
 -2.700469025039624e-03,  2.785273975818012e-06,  9.430234059257245e-09, -3.769899243597813e-11, -1.092623769236853e-14,  4.058325414660939e-16, -7.750979389951388e-19,
 -2.972132226150423e-21,  1.637518587726872e-23, -1.615564022162939e-27, -2.094746447815987e-28,  9.297562858104200e-01, -2.806438487304699e-03,  2.188325818231311e-06,
  1.211501659242386e-08, -3.553432372754682e-11, -5.512698639769974e-14,  4.796167443100264e-16, -2.776654388343282e-19, -5.344777079158007e-21,  1.439872774366941e-23,
  4.110068745991228e-26, -2.845324475329322e-28,  1.001460606816809e+00, -2.891691031321466e-03,  1.455947191450746e-06,  1.463979343392786e-08, -2.971086305406463e-11,
 -1.055892211160646e-13,  4.912448103136735e-16,  5.127847102440982e-19, -7.198526541910911e-21,  5.180632309909188e-24,  9.184865637367454e-26, -2.370025841437300e-28,
  1.075015469548427e+00, -2.952025473445477e-03,  5.912480418396489e-07,  1.678707362391723e-08, -1.969959800815498e-11, -1.565745440318470e-13,  4.090572423898512e-16,
  1.519027700952140e-18, -7.488937027601647e-21, -1.196359086649857e-23,  1.265229423414754e-25,  9.057789007832488e-30,  1.150151611345182e+00, -2.982974599713399e-03,
 -3.946425158537199e-07,  1.829653663901400e-08, -5.333196357247565e-12, -1.993357843928655e-13,  2.085589080520774e-16,  2.534165658817231e-18, -5.097436594804611e-21,
 -3.374490198316339e-23,  1.094008190384088e-25,  4.409592651837413e-28,  1.226538188844094e+00, -2.979910144623431e-03, -1.480019585530889e-06,  1.887641991819532e-08,
  1.295563883795115e-11, -2.223890761252694e-13, -1.139112941239160e-16,  3.205431965492852e-18,  6.143405323566844e-22, -5.109495708440307e-23,  9.864389025187292e-27,
  8.604229387048695e-28,  1.303770274679138e+00, -2.938220839389389e-03, -2.629810648584880e-06,  1.822837429387018e-08,  3.386584860028310e-11, -2.129330399841892e-13,
 -5.238815117264309e-16,  3.081902474895103e-18,  8.956030599901283e-21, -4.996512179339182e-23, -1.636103968562907e-25,  8.662461480000235e-28,  1.381354593004223e+00,
 -2.853592453011027e-03, -3.792905965862315e-06,  1.609127995406696e-08,  5.499372892398450e-11, -1.599995932704159e-13, -9.333880408096893e-16,  1.772962785152117e-18,
  1.708934676221772e-20, -1.774029859387756e-23, -3.261630715918203e-25,  7.712729459777102e-29,  1.458693817239307e+00, -2.722423807731175e-03, -4.900303760809712e-06,
  1.230858857205028e-08,  7.275859384548939e-11, -5.965651595879164e-14, -1.199589724029194e-15, -7.631808060578937e-19,  2.005820193529749e-20,  4.357907341713197e-23,
 -3.208883801231380e-25, -1.339063105392915e-27,  1.535070245363069e+00, -2.542413113284529e-03, -5.865239793098109e-06,  6.919182053630821e-09,  8.268724014175213e-11,
  7.835760201984177e-14, -1.155415222824600e-15, -3.881286275382390e-18,  1.284479734555371e-20,  1.037532641464050e-22, -2.659036397230786e-26, -2.212950956993584e-27,
  1.609630445492547e+00, -2.313338200240818e-03, -6.587040064065737e-06,  2.606823469675249e-10,  8.029732915549302e-11,  2.251169152557973e-13, -6.876362273997431e-16,
 -6.124250585280210e-18, -5.068650701031091e-21,  1.086356291397153e-22,  4.392729946128286e-25, -9.958043841945845e-28,  1.681373592808146e+00, -2.038022223410500e-03,
 -6.960891337369165e-06, -6.945783391783941e-09,  6.273292575387713e-11,  3.332986337009879e-13,  1.478288687483960e-16, -5.729628916024861e-18, -2.502053772814996e-20,
  2.282261783955589e-23,  6.360377595560999e-25,  2.022643170697911e-27,  1.749147684979294e+00, -1.723410357565100e-03, -6.895587613866567e-06, -1.358734366591997e-08,
  3.094684897635632e-11,  3.508586372598557e-13,  1.040942053528026e-15, -1.980064039681087e-18, -3.089840467266000e-20, -1.057344879828569e-22,  1.795500534231222e-25,
  3.333401557033400e-27,  1.811659419004833e+00, -1.381573166354131e-03, -6.339769735278676e-06, -1.830661774665855e-08, -8.489158495689051e-12,  2.499840269579232e-13,
  1.500040780026466e-15,  3.327371590328582e-18, -1.287122459678125e-20, -1.471862193337407e-22, -5.590461723072915e-25,  1.955147748413664e-28,  1.867504673497816e+00,
 -1.030306133708877e-03, -5.313329014050387e-06, -1.986733000137419e-08, -4.367726534034960e-11,  5.977163315218533e-14,  1.169183651903679e-15,  6.240515618781391e-18,
  1.573814630232288e-20, -3.466240769245716e-23, -5.947784334849528e-25, -3.206524405049066e-27,  1.915226226620562e+00, -6.928597189040975e-04, -3.934409908475919e-06,
 -1.770687870102705e-08, -6.151474555865187e-11, -1.275632580128069e-13,  2.304157415741464e-16,  4.144712313156708e-18,  2.525552997439452e-20,  9.564166693096921e-23,
  1.420126692485416e-25, -1.164694061425146e-27,  1.953402185438418e+00, -3.963155095320701e-04, -2.426154846708821e-06, -1.246360587594911e-08, -5.526928731990053e-11,
 -2.065576219285782e-13, -5.803137629092249e-16, -5.423191011666663e-19,  7.439638633883221e-21,  7.093228084620708e-23,  4.123208357170104e-25,  1.783774235666296e-27,
  1.980761767337117e+00, -1.683605512789776e-04, -1.086740245118929e-06, -6.097552736580346e-09, -3.115362311988978e-11, -1.470852135799458e-13, -6.412022861067223e-16,
 -2.541540508167470e-18, -8.779409166946784e-21, -2.319167162131173e-23, -1.695026444980716e-26,  3.428077177759492e-28,  1.996318486011265e+00, -3.274590497197493e-05,
 -2.177691065530754e-07, -1.282074231580191e-09, -7.040480318379478e-12, -3.689003384293983e-14, -1.865662757881777e-16, -9.164305602952919e-19, -4.387139047910257e-21,
 -2.049995026926676e-23, -9.351588297341051e-26, -4.159962697115364e-28,  3.544071177833014e-04, -1.501634193451459e-06,  4.771040512352089e-09, -1.347338099710325e-11,
  3.565877691212394e-14, -9.059874472626942e-17,  2.236321337059740e-19, -5.409961065174880e-22,  1.285820219027735e-24, -3.026307408089056e-27,  7.005048779723791e-30,
 -1.627561366175980e-32,  3.189765622278011e-03, -1.350619797472285e-05,  4.284468658799228e-08, -1.206494339348970e-10,  3.178881308325767e-13, -8.024650155229600e-16,
  1.963363629045454e-18, -4.694935239861904e-21,  1.099422621315345e-23, -2.540575018150850e-26,  5.746791457888193e-29, -1.300362776976231e-31,  8.861019747316720e-03,
 -3.746979836616581e-05,  1.184861618426814e-07, -3.317435885410804e-10,  8.661804514733499e-13, -2.157784888494536e-15,  5.183246575919970e-18, -1.209399361520809e-20,
  2.742119328967909e-23, -6.081016568714425e-26,  1.303173750640706e-28, -2.762397969050756e-31,  1.736922172521894e-02, -7.330069784048952e-05,  2.306796730759100e-07,
 -6.402435646988869e-10,  1.648453368213920e-12, -4.022212933695732e-15,  9.380880565550517e-18, -2.101285183556530e-20,  4.503087156526083e-23, -9.246098794535857e-26,
  1.771642521789659e-28, -3.215454171367390e-31,  2.871589414955539e-02, -1.208595693771410e-04,  3.778911530241171e-07, -1.036391460738078e-09,  2.617223183400208e-12,
 -6.200495755658393e-15,  1.384459572599773e-17, -2.909193909462824e-20,  5.660264730182890e-23, -9.982251360103191e-26,  1.436733397384277e-28, -1.331000982368681e-31,
  4.290296092343405e-02, -1.799573956252796e-04,  5.580558726526983e-07, -1.507200560779029e-09,  3.710411845868615e-12, -8.444169171249029e-15,  1.770381036497075e-17,
 -3.360444537198372e-20,  5.445507277894621e-23, -6.361424137934725e-26, -1.175316175670775e-29,  3.574169495222368e-31,  5.993265152105376e-02, -2.503526072179794e-04,
  7.685620524467162e-07, -2.036484994883744e-09,  4.852489229623380e-12, -1.046211219814850e-14,  1.999609480550542e-17, -3.179939360769882e-20,  3.194595383512466e-23,
  2.842531753999223e-26, -2.983091084229159e-28,  1.094469537460743e-30,  7.980737522613361e-02, -3.317474070823606e-04,  1.006230623576505e-06, -2.604909030319219e-09,
  5.956009617956866e-12, -1.193418917458523e-14,  1.975056234763392e-17, -2.130734426954790e-20, -1.487470879521603e-23,  1.758227029051380e-25, -6.763552012594065e-28,
  1.863148706467778e-30,  1.025295609266087e-01, -4.237832128282950e-04,  1.267291383377387e-06, -3.190065201539408e-09,  6.923618364207216e-12, -1.252824147936823e-14,
  1.608668971657374e-17, -5.889631277952270e-22, -8.562477670683856e-23,  3.606992405291582e-25, -1.049048055815469e-27,  2.296745367357214e-30,  1.281014567758526e-01,
 -5.260351336918469e-04,  1.547355928056891e-06, -3.766593451679886e-09,  7.650622907692096e-12, -1.192069366068616e-14,  8.326812641324752e-18,  3.060171588271834e-20,
 -1.741769698732421e-22,  5.453150246310937e-25, -1.266970435755964e-27,  1.943111331187872e-30,  1.565248825202142e-01, -6.380053820701151e-04,  1.841387946454225e-06,
 -4.306357110606058e-09,  8.028241325242752e-12, -9.821000401773145e-15, -3.880776041180289e-18,  7.077835223872861e-20, -2.677383272257913e-22,  6.731021877762209e-25,
 -1.150076962764354e-27,  3.968853955857961e-31,  1.878009254721101e-01, -7.591155025839265e-04,  2.143671745377700e-06, -4.778696044633276e-09,  7.947660534599001e-12,
 -6.000058961364083e-15, -2.043312987482089e-17,  1.163602605457744e-19, -3.467377526072223e-22,  6.744460650064922e-25, -5.295340268371008e-28, -2.510217660231184e-30,
  2.219295688927328e-01, -8.886972842699843e-04,  2.447780280756544e-06, -5.150782867748197e-09,  7.305053451104525e-12, -3.225155882800956e-16, -4.064608158751055e-17,
  1.614560380865972e-19, -3.858762780200054e-22,  4.782465846469476e-25,  6.912331073652671e-28, -6.490689179303294e-30,  2.589092388339275e-01, -1.025982204755887e-03,
  2.746544531279584e-06, -5.388114895166309e-09,  6.007716864037824e-12,  7.217439284075951e-15, -6.314124430082444e-17,  1.978797458027407e-19, -3.567061190605675e-22,
  2.973583735705628e-26,  2.462194166052477e-27, -1.061185775575899e-29,  2.987362521450064e-01, -1.170089240539706e-03,  3.032026827898652e-06, -5.455182719240749e-09,
  3.981494604501382e-12,  1.645772239551453e-14, -8.576290445959941e-17,  2.155047532021087e-19, -2.320621907340775e-22, -6.860117933582174e-25,  4.512432140228397e-27,
 -1.322478089587644e-29,  3.414041442159144e-01, -1.320010867139353e-03,  3.295501817040226e-06, -5.316365999400107e-09,  1.179635817793795e-12,  2.702919534680709e-14,
 -1.055473028687251e-16,  2.030749524840033e-19,  7.465825813579346e-24, -1.617135322299057e-24,  6.298821749492731e-27, -1.212647058951809e-29,  3.869028499037109e-01,
 -1.474597070661720e-03,  3.527450183904472e-06, -4.937118232006236e-09, -2.406806460264093e-12,  3.831860590422355e-14, -1.187741971725088e-16,  1.495972602307093e-19,
  3.651165346606206e-22, -2.619366608170382e-24,  7.011079747599542e-27, -5.076663394934404e-30,  4.352177047296025e-01, -1.632537204151189e-03,  3.717572219289856e-06,
 -4.285514547997120e-09, -6.737024321596094e-12,  4.943821835860109e-14, -1.211387741757292e-16,  4.642183853022467e-20,  8.181931536058919e-22, -3.439831031131409e-24,
  5.675287844666040e-27,  9.247949429439463e-30,  4.863282255408973e-01, -1.792339556961323e-03,  3.854830936487925e-06, -3.334249062521300e-09, -1.170710862531656e-11,
  5.920900241038476e-14, -1.080897693223524e-16, -1.099404866517397e-19,  1.308351056847767e-21, -3.722290617002898e-24,  1.399261098203496e-27,  2.989578594320378e-29,
  5.402066200508513e-01, -1.952308577104791e-03,  3.927537927134703e-06, -2.063179082960189e-09, -1.713574904874818e-11,  6.616725325241053e-14, -7.538462938550947e-17,
 -3.143366151361811e-19,  1.734494614754973e-21, -3.049508424989160e-24, -6.212523009683474e-27,  5.214498458424987e-29,  5.968159625873494e-01, -2.110519815759544e-03,
  3.923499711611123e-06, -4.625190392132203e-10, -2.274987772513304e-11,  6.860825473296150e-14, -1.991022394940900e-17, -5.491214317917807e-19,  1.952355436803081e-21,
 -1.039896440748342e-24, -1.649325641225350e-26,  6.650632527054073e-29,  6.561079585430523e-01, -2.264792880650729e-03,  3.830248229977911e-06,  1.463218878791572e-09,
 -2.817185232921644e-11,  6.468487658021047e-14,  5.919972771330179e-17, -7.806006256636546e-19,  1.786509075157985e-21,  2.488641039165662e-24, -2.711017402513456e-26,
  5.932671561264901e-29,  7.180202019627855e-01, -2.412663036292260e-03,  3.635386540944598e-06,  3.690468164463412e-09, -3.291080535085894e-11,  5.258317602001572e-14,
  1.591639283647113e-16, -9.569679634629814e-19,  1.061896715890208e-21,  7.290459352911391e-24, -3.368858509828226e-26,  1.647592695916379e-29,  7.824728090410058e-01,
 -2.551352640149040e-03,  3.327089824487433e-06,  6.171032926068083e-09, -3.636224325309248e-11,  3.079967802190313e-14,  2.719725430423139e-16, -1.009655345472093e-18,
 -3.383422671600709e-22,  1.243711053127129e-23, -3.012795119568611e-26, -6.854830012431263e-29,  8.493642848806952e-01, -2.677744449331241e-03,  2.894812163562925e-06,
  8.825823622565443e-09, -3.782192853678798e-11, -1.456893014438416e-15,  3.828867153696019e-16, -8.608041013355536e-19, -2.385939420436937e-21,  1.613402387559143e-23,
 -1.024393476975727e-26, -1.822310291640583e-28,  9.185664520650000e-01, -2.788360105042686e-03,  2.330260356306592e-06,  1.153826953034970e-08, -3.652248299344539e-11,
 -4.372831713765292e-14,  4.695276984112315e-16, -4.401117731395449e-19, -4.799838290913518e-21,  1.579351980297893e-23,  2.868435187155232e-26, -2.783169185685600e-28,
  9.899182388555853e-01, -2.879348981371230e-03,  1.628704868153352e-06,  1.414817034877175e-08, -3.170371943031638e-11, -9.365288271744804e-14,  5.024108133812891e-16,
  2.861038273153405e-19, -6.948519219686213e-21,  8.633761027842721e-24,  8.052842064126006e-26, -2.753539639212075e-28,  1.063218095566939e+00, -2.946495302325445e-03,
  7.907001909062940e-07,  1.644737550857546e-08, -2.272961151062693e-11, -1.462742199502279e-13,  4.481771874427989e-16,  1.273466564993624e-18, -7.828685527164124e-21,
 -6.922244804501506e-24,  1.248773607517610e-25, -8.246411052886166e-29,  1.138214786757813e+00, -2.985255257816067e-03, -1.757266786110622e-07,  1.817960751217786e-08,
 -9.264210330753781e-12, -1.934984146593458e-13,  2.770554993551695e-16,  2.352491238684757e-18, -6.229100151864165e-21, -2.901300949922877e-23,  1.263779711093781e-25,
  3.290430875719835e-28,  1.214596307088413e+00, -2.990841048062705e-03, -1.252405979707166e-06,  1.904800988104855e-08,  8.487792808783671e-12, -2.240453956650171e-13,
 -2.415953134251067e-17,  3.195809800605910e-18, -1.208941583216996e-21, -4.995360420643317e-23,  4.688077188867291e-26,  8.161996626181262e-28,  1.291976712280007e+00,
 -2.958375479049734e-03, -2.407961702752991e-06,  1.873550534422749e-08,  2.948860615164397e-11, -2.244399973321950e-13, -4.338549128613965e-16,  3.338529534152909e-18,
  7.049050741997030e-21, -5.570628435050661e-23, -1.225106522336358e-25,  9.947914288255660e-28,  1.369880780421100e+00, -2.883148612024625e-03, -3.594640702023088e-06,
  1.694438052585324e-08,  5.157406154290093e-11, -1.817440755493762e-13, -8.762029530966045e-16,  2.307097510735239e-18,  1.621749550960761e-20, -3.062896058091344e-23,
 -3.160407151210104e-25,  3.829265854759302e-28,  1.447726680407850e+00, -2.761015736100206e-03, -4.745660329975334e-06,  1.346161082312270e-08,  7.127621176606874e-11,
 -8.862920936099120e-14, -1.211755171524094e-15, -9.880523090883269e-20,  2.138243570412334e-20,  2.963511239532780e-23, -3.744300479562334e-25, -1.081141064994283e-27,
  1.524807306827456e+00, -2.588980310826442e-03, -5.774224896709677e-06,  8.253172380646288e-09,  8.396854441825433e-11,  4.937341039905270e-14, -1.257777840542749e-15,
 -3.410890084626018e-18,  1.653678405226077e-20,  1.006866407702920e-22, -1.279293765680917e-25, -2.375764119129566e-27,  1.600271751140033e+00, -2.365999831065733e-03,
 -6.576057819708986e-06,  1.580503057095059e-09,  8.462066601146285e-11,  2.065413019343305e-13, -8.607744360671306e-16, -6.220578799638928e-18, -8.537270568335053e-22,
  1.251457101953160e-22,  3.816110526957310e-25, -1.629519584221880e-27,  1.673109626532182e+00, -2.094025180767502e-03, -7.037997928603579e-06, -5.888592191808883e-09,
  6.942091884866710e-11,  3.348318358936443e-13, -2.365043968176246e-17, -6.512062110207566e-18, -2.372047248817022e-20,  4.993764387714419e-23,  7.167353030080994e-25,
  1.613497698533979e-27,  1.742142694106788e+00, -1.779218291406990e-03, -7.055428933157624e-06, -1.303472021673396e-08,  3.820876487863582e-11,  3.750607560941292e-13,
  9.710971344898646e-16, -3.028032819072192e-18, -3.453867309620496e-20, -9.544985710943495e-23,  3.387397938918402e-25,  3.889614039217213e-27,  1.806030295978030e+00,
 -1.433171958101603e-03, -6.560092697428152e-06, -1.840046001008335e-08, -3.122183564138214e-12,  2.870514105365476e-13,  1.586613695506080e-15,  2.826427198145740e-18,
 -1.856836305773862e-20, -1.691527660438470e-22, -5.333745345315628e-25,  1.006676065520045e-27,  1.863296909142231e+00, -1.073778176820259e-03, -5.555885438872495e-06,
 -2.055501775289663e-08, -4.218678650997004e-11,  8.998443906268054e-14,  1.350746820852180e-15,  6.719297027663277e-18,  1.402714100515827e-20, -6.137463564521479e-23,
 -7.431231119447257e-25, -3.519971153637323e-27,  1.912390467589036e+00, -7.252018521017046e-04, -4.152880975078940e-06, -1.871118314732835e-08, -6.400082512349095e-11,
 -1.205461149425038e-13,  3.583069587707304e-16,  5.008964019552677e-18,  2.878684793596308e-20,  1.001101589076525e-22,  7.646232527282496e-26, -1.844733467342001e-27,
  1.951777136045126e+00, -4.163383535414987e-04, -2.581162760952167e-06, -1.338172506924251e-08, -5.954079556985731e-11, -2.206379925444566e-13, -5.917582489511215e-16,
 -2.600525852690130e-19,  1.030966384367439e-20,  8.906916390126676e-23,  4.963579539821212e-25,  2.035349858692652e-27,  1.980070461609329e+00, -1.773558586810415e-04,
 -1.163001477963942e-06, -6.620405244990773e-09, -3.425514751179554e-11, -1.633605477419047e-13, -7.164248564357677e-16, -2.835938365606504e-18, -9.622418433061015e-21,
 -2.351665230075343e-23,  2.081247406513929e-27,  5.325773237643295e-28,  1.996183917868514e+00, -3.455157009610743e-05, -2.338550434657240e-07, -1.400876623335018e-09,
 -7.825220343426049e-12, -4.169211766185226e-14, -2.143080777170528e-16, -1.069386308050086e-18, -5.197122250398497e-21, -2.463356416685788e-23, -1.138675658696043e-25,
 -5.125599829894205e-28,  };
  constexpr double w[16512] = {  7.218567281902774e-02, -2.188612894972682e-04,  6.953792037798706e-07, -2.289846170232396e-09,  7.725704362475621e-12,
 -2.645181298627928e-14,  9.126017015142256e-17, -3.157608592268133e-19,  1.092394107238100e-21, -3.772040480039224e-24,  1.298717340485783e-26, -4.456331452949312e-29,
  7.190785771144186e-02, -3.090186544869631e-04,  1.546722522124852e-06, -7.812851083844009e-09,  3.843675703589410e-11, -1.836726493297038e-13,  8.556491585132425e-16,
 -3.901218688205679e-18,  1.746291198796861e-20, -7.692812616589292e-23,  3.341265728489503e-25, -1.432934232588827e-27,  7.135677144698878e-02, -4.868095894117139e-04,
  3.559136853892940e-06, -2.406565043159182e-08,  1.522688528612028e-10, -9.160343481707044e-13,  5.294562279175018e-15, -2.960623392688449e-17,  1.609616760889707e-19,
 -8.540138827023081e-22,  4.434759843622781e-24, -2.259094166816089e-26,  7.054134059671978e-02, -7.472917279526468e-04,  7.325858251449722e-06, -6.299760374114801e-08,
  4.951027554053300e-10, -3.639235127609355e-12,  2.536969844338591e-14, -1.693062443569776e-16,  1.088925329614701e-18, -6.783836629480127e-21,  4.109568919127556e-23,
 -2.428233261380300e-25,  6.947456087725551e-02, -1.083308040186934e-03,  1.367343689458404e-05, -1.460663216360990e-07,  1.396494659013839e-09, -1.229622518146549e-11,
  1.014642044442485e-13, -7.938538028186368e-16,  5.938493077854585e-18, -4.273843789494995e-20,  2.973362870670217e-22, -2.007210719017224e-24,  6.817304915994440e-02,
 -1.485776903752063e-03,  2.359182543659715e-05, -3.076690396776804e-07,  3.521423887979617e-09, -3.659532045537650e-11,  3.525299532915886e-13, -3.191769752052238e-15,
  2.742796578399892e-17, -2.253450394244504e-19,  1.780039307953763e-21, -1.357812670000441e-23,  6.665648562671085e-02, -1.944050894429303e-03,  3.815058673087196e-05,
 -5.985045507229553e-07,  8.093765769628103e-09, -9.809952946924338e-11,  1.091154015053168e-12, -1.131466488497621e-14,  1.106052981090980e-16, -1.027734101767249e-18,
  9.135151892427496e-21, -7.806056629300731e-23,  6.494697584640143e-02, -2.446323366511123e-03,  5.840805502287557e-05, -1.088072872045928e-06,  1.719191221401819e-08,
 -2.405931677775575e-10,  3.061511694967983e-12, -3.604630368063402e-14,  3.975801199093499e-16, -4.145792259991828e-18,  4.115911745860111e-20, -3.911818727607454e-22,
  6.306836541507604e-02, -2.980060073807512e-03,  8.532062210755804e-05, -1.865583375872381e-06,  3.410073475376650e-08, -5.461808202597667e-10,  7.887189447806383e-12,
 -1.046554093895787e-13,  1.293281453231734e-15, -1.503306580872520e-17,  1.656352834012105e-19, -1.740182545133719e-21,  6.104554033522450e-02, -3.532432985614443e-03,
  1.196589966546471e-04, -3.038716365085060e-06,  6.368436966601514e-08, -1.158176556890661e-09,  1.884344833476357e-11, -2.799063452058442e-13,  3.851152126472892e-15,
 -4.960686588689554e-17,  6.031699446257741e-19, -6.967196025251589e-21,  5.890374462320851e-02, -4.090734968749844e-03,  1.619373727017503e-04, -4.729941323186274e-06,
  1.127253551096399e-07, -2.310894106846802e-09,  4.208300199215870e-11, -6.955572984186348e-13,  1.059472289860479e-14, -1.504207037432525e-16,  2.008087521868053e-18,
 -2.537799065686019e-20,  5.666794304113006e-02, -4.642756884622126e-03,  2.123600729575454e-04, -7.070399335926583e-06,  1.901620547724330e-07, -4.364940904286067e-09,
  8.843052394307542e-11, -1.617209393077556e-12,  2.712866854507013e-14, -4.224463627506969e-16,  6.162978269222311e-18, -8.483577840487831e-20,  5.436225179948493e-02,
 -5.177112533401215e-03,  2.707885733303323e-04, -1.019166464064539e-05,  3.071519700527102e-07, -7.844696581463790e-09,  1.758036436506227e-10, -3.538805019128494e-12,
  6.505874513796335e-14, -1.106064179067708e-15,  1.755713806795885e-17, -2.621517717245584e-19,  5.200945410254051e-02, -5.683501353695597e-03,  3.367300512504587e-04,
 -1.421596993469311e-05,  4.768958362936918e-07, -1.347262541857379e-08,  3.322073708130580e-10, -7.324268081074373e-12,  1.468952353897142e-13, -2.714817211508565e-15,
  4.669755890381637e-17, -7.533773281253471e-19,  4.963061106097878e-02, -6.152903436292533e-03,  4.093469080405896e-04, -1.924567871470860e-05,  7.141766049824728e-07,
 -2.219335494184417e-08,  5.990861696549857e-10, -1.439946483456480e-11,  3.136879437732029e-13, -6.276470727812896e-15,  1.165387647012528e-16, -2.023990034182414e-18,
  4.724477229036324e-02, -6.577705851421420e-03,  4.874852434923327e-04, -2.535289412121817e-05,  1.034596648171056e-06, -3.517950632156038e-08,  1.034620156844129e-09,
 -2.699077405305988e-11,  6.360324619868255e-13, -1.372439117786483e-14,  2.740631395473351e-16, -5.106050518114961e-18,  4.486878488169480e-02, -6.951763207694183e-03,
  5.697191167039289e-04, -3.257009987755535e-05,  1.453532063313643e-06, -5.381147580489463e-08,  1.716352090304514e-09, -4.839285959558476e-11,  1.228688035246759e-12,
 -2.848631192611958e-14,  6.096301914295090e-16, -1.214338040291756e-17,  4.251719469242690e-02, -7.270398535518538e-03,  6.544066714771172e-04, -4.088264067933433e-05,
  1.984859925126424e-06, -7.962496446134495e-08,  2.742375189200596e-09, -8.323083643656974e-11,  2.268273884970758e-12, -5.630150613347024e-14,  1.286924018347288e-15,
 -2.731889946835358e-17,  4.020223025917875e-02, -7.530352895249893e-03,  7.397538503865106e-04, -5.022368366721092e-05,  2.639547540776507e-06, -1.142230271979276e-07,
  4.230247676893844e-09, -1.376635950923392e-10,  4.012353004340594e-12, -1.062576364883219e-13,  2.585702464573663e-15, -5.831414726205820e-17,  3.793385715158645e-02,
 -7.729693521763387e-03,  8.238814410616430e-04, -6.047208380416162e-05,  3.424217587293191e-06, -1.591534974097523e-07,  6.312870589559404e-09, -2.194597129146737e-10,
  6.816776763631252e-12, -1.919706727489712e-13,  4.957570692426078e-15, -1.184243905222502e-16,  3.571988923790879e-02, -7.867690883962983e-03,  9.048915319673278e-04,
 -7.145333190256910e-05,  4.339816079442775e-06, -2.157573518329550e-07,  9.130794845148421e-09, -3.378700495412227e-10,  1.114669749281606e-11, -3.327377787970418e-13,
  9.091269820859428e-15, -2.293531653972215e-16,  3.356614300097218e-02, -7.944674871981630e-03,  9.809300241737078e-04, -8.294352197586540e-05,  5.380509767884450e-06,
 -2.849982728212354e-07,  1.282080873044638e-08, -5.032264716738833e-10,  1.757553488677631e-11, -5.543866490356887e-13,  1.597846810871687e-14, -4.245119315550598e-16,
  3.147662155481772e-02, -7.961879576669445e-03,  1.050242563657409e-03, -9.467605797556600e-05,  6.532925964745715e-06, -3.672876595513264e-07,  1.750116386591642e-08,
 -7.262173597541402e-10,  2.676585003951647e-11, -8.894493791022914e-13,  2.696438567407632e-14, -7.523480945406439e-16,  2.945371616531511e-02, -7.921284962215782e-03,
  1.111222041546496e-03, -1.063506462390035e-04,  7.775822758932692e-06, -4.623220208386201e-07,  2.325436398432703e-08, -1.016828148365447e-09,  3.942695076601359e-11,
 -1.376237466592625e-12,  4.376118690351759e-14, -1.278849609233654e-15,  2.749841466373732e-02, -7.825462318167558e-03,  1.162446583899661e-03, -1.176439994670173e-04,
  9.080244198962181e-06, -5.689506021446588e-07,  3.010898435849011e-08, -1.382986293032444e-09,  5.624638050481100e-11, -2.056422315416315e-12,  6.839807861682699e-14,
 -2.088007723307392e-15,  2.561050796611338e-02, -7.677428860190035e-03,  1.202707660136535e-03, -1.282216140984062e-04,  1.041017709868659e-05, -6.850900436502582e-07,
  3.802242164335075e-08, -1.829008442642782e-09,  7.779621586482625e-11, -2.970860706900934e-12,  1.030829512824122e-13, -3.278790069458214e-15,  2.378878780525246e-02,
 -7.480515352624608e-03,  1.231028539941759e-03, -1.377499727478034e-04,  1.172368764094265e-05, -8.076998809785126e-07,  4.686671393341058e-08, -2.354004199948427e-09,
  1.044199560937945e-10, -4.153656800267124e-12,  1.499583678532869e-13, -4.957239141422159e-15,  2.203123061323815e-02, -7.238249243109121e-03,  1.246673799788340e-03,
 -1.459085594568462e-04,  1.297448056168244e-05, -9.328280765064565e-07,  5.641956124221754e-08, -2.950435317777576e-09,  1.361110286938217e-10, -5.624803610289470e-12,
  2.107507431619133e-13, -7.222803539860659e-15,  2.033516416334928e-02, -6.954254592524579e-03,  1.249150915230354e-03, -1.524011474409990e-04,  1.411379432391692e-05,
 -1.055729993391511e-06,  6.636239271846503e-08, -3.603051676252291e-09,  1.723985985584719e-10, -7.382148683346261e-12,  2.863347187961561e-13, -1.014899377069622e-14,
  1.869741503045295e-02, -6.632169086520745e-03,  1.238205179394972e-03, -1.569659150724660e-04,  1.509252432739343e-05, -1.171057904087931e-06,  7.628678213998054e-08,
 -4.288418541029874e-09,  2.122593995745844e-10, -9.393804840573607e-12,  3.762617051709858e-13, -1.375986404997887e-14,  1.711443612754822e-02, -6.275577638427199e-03,
  1.213809276206264e-03, -1.593840544572255e-04,  1.586345382554691e-05, -1.273111906468996e-06,  8.570975794411052e-08, -4.975210104512392e-09,  2.540747743108949e-10,
 -1.159238672366729e-11,  4.783268355711675e-13, -1.800543064244296e-14,  1.558241451798822e-02, -5.887961529832462e-03,  1.176148828769360e-03, -1.594866478317747e-04,
  1.638346886753941e-05, -1.356137609679116e-06,  9.409766878212641e-08, -5.625373876155999e-09,  2.956494144926703e-10, -1.387251129701675e-11,  5.882653921806630e-13,
 -2.274057531027635e-14,  1.409736040135054e-02, -5.472661664202048e-03,  1.125605161316330e-03, -1.571596917774182e-04,  1.661563849625439e-05, -1.414651649839681e-06,
  1.008973499310415e-07, -6.196175957727458e-09,  3.343023590288267e-10, -1.609279555319717e-11,  6.996716255406443e-13, -2.771280252627261e-14,  1.265517865201396e-02,
 -5.032854302766537e-03,  1.062736379287847e-03, -1.523472418817609e-04,  1.653105329236362e-05, -1.443773355886578e-06,  1.055724952015577e-07, -6.643029798625358e-09,
  3.670321397130707e-10, -1.808310302207532e-11,  8.042153960948706e-13, -3.256401130838614e-14,  1.125172458696866e-02, -4.571537579604084e-03,  9.882577067261045e-04,
 -1.450527272507010e-04,  1.611033250900556e-05, -1.439539892718006e-06,  1.076424708354744e-07, -6.922904655424202e-09,  3.907476460168921e-10, -1.965707456876616e-11,
  8.921945538770527e-13, -3.684996682506200e-14,  9.882845791535035e-03, -4.091527124158174e-03,  9.030218405592322e-04, -1.353385436092379e-04,  1.534473073226858e-05,
 -1.399182979769032e-06,  1.067203903980357e-07, -6.998019420453484e-09,  4.025458098577071e-10, -2.062912678165032e-11,  9.534074494941817e-13, -4.007845604658362e-14,
  8.544411882416270e-03, -3.595459229082422e-03,  8.079999020406260e-04, -1.233240758992593e-04,  1.423679755373298e-05, -1.321347687317462e-06,  1.025471529394938e-07,
 -6.839466059525511e-09,  4.000082733718549e-10, -2.083425395045881e-11,  9.782689786295389e-13, -4.176356350046085e-14,  7.232334101101549e-03, -3.085800177782912e-03,
  7.042633998850345e-04, -1.091823282767296e-04,  1.280056672725279e-05, -1.206237604923450e-06,  9.501834841712144e-08, -6.430384548693223e-09,  3.814833797247484e-10,
 -2.014828604857128e-11,  9.590368300873002e-13, -4.148978391010511e-14,  5.942576767732508e-03, -2.564860626501498e-03,  5.929674881071445e-04, -9.313535581991476e-05,
  1.106127376763553e-05, -1.055675548258201e-06,  8.420144048739195e-08, -5.768333088661543e-09,  3.463183195516529e-10, -1.850588111384533e-11,  8.909747018991199e-13,
 -3.897664339043000e-14,  4.671163578722550e-03, -2.034814599074349e-03,  4.753357784251578e-04, -7.544871229096768e-05,  9.054623424084822e-06, -8.730746766512567e-07,
  7.034141183125278e-08, -4.866563627867780e-09,  2.950096962465458e-10, -1.591356950826936e-11,  7.732668033172775e-13, -3.413294895459074e-14,  3.414187994350071e-03,
 -1.497725664946135e-03,  3.526475244884883e-04, -5.642523096793534e-05,  6.825659613808629e-06, -6.633219497154456e-07,  5.385410473627694e-08, -3.754022279398073e-09,
  2.292492938074176e-10, -1.245566984385647e-11,  6.095196305799272e-13, -2.709033030687209e-14,  2.167894819011649e-03, -9.556086896933699e-04,  2.262339976755414e-04,
 -3.639942962257244e-05,  4.427425862320949e-06, -4.325932900707781e-07,  3.530849343317768e-08, -2.474090144077750e-09,  1.518578616379126e-10, -8.291997504992393e-12,
  4.077511012556020e-13, -1.820892083655482e-14,  9.301080611609621e-04, -4.110900456472059e-04,  9.761779348464851e-05, -1.575433033664979e-05,  1.922121429317784e-06,
 -1.883706751779953e-07,  1.542029035894973e-08, -1.083634806843087e-09,  6.670100700186367e-11, -3.652207993193847e-12,  1.800804007743725e-13, -8.063083122059539e-15,
  7.132118261460732e-02, -2.134061065398543e-04,  6.686256365963363e-07, -2.170351123797736e-09,  7.217874292928116e-12, -2.436383643548726e-14,  8.288853758679323e-17,
 -2.828803924570190e-19,  9.654977749459042e-22, -3.289709683179100e-24,  1.117817432893765e-26, -3.785845884075128e-29,  7.069595127771236e-02, -2.970097084773267e-04,
  1.456540529294251e-06, -7.226170864084014e-09,  3.496012769768609e-11, -1.643872027919811e-13,  7.538397852693292e-16, -3.384255023643733e-18,  1.491962358990953e-20,
 -6.474274422484472e-23,  2.770501859450435e-25, -1.170804267483583e-27,  6.946470697992466e-02, -4.594515775479938e-04,  3.284383894469892e-06, -2.176928190429475e-08,
  1.351546057165680e-10, -7.983577409738789e-13,  4.533309917400643e-15, -2.491498866831211e-17,  1.331844676932029e-19, -6.950038293048419e-22,  3.550609746667723e-24,
 -1.779849545548595e-26,  6.766478268679856e-02, -6.915794034005463e-04,  6.615117897947551e-06, -5.562669892514350e-08,  4.280422258784587e-10, -3.083526520294396e-12,
  2.108239446912261e-14, -1.380706350691576e-16,  8.718913376659369e-19, -5.335261609282433e-21,  3.175768444665645e-23, -1.844391921421942e-25,  6.534951531756410e-02,
 -9.805697485915893e-04,  1.204699784051673e-05, -1.255646823853480e-07,  1.173226335475374e-09, -1.010768922634336e-11,  8.168085942355356e-14, -6.263061397660071e-16,
  4.594294079042069e-18, -3.243968122782212e-20,  2.215190857171219e-22, -1.468349637790242e-24,  6.258531038117068e-02, -1.310905369047746e-03,  2.021511089967246e-05,
 -2.567505023708444e-07,  2.867368199317253e-09, -2.911488870609452e-11,  2.743201610777822e-13, -2.431220607937165e-15,  2.046517555845033e-17, -1.647982584980841e-19,
  1.276548228137672e-21, -9.553129143584531e-24,  5.944812753126318e-02, -1.665513288756609e-03,  3.168511907789480e-05, -4.833782926747185e-07,  6.369921079413371e-09,
 -7.534543376548675e-11,  8.187988776788744e-13, -8.302957517456417e-15,  7.943268608506108e-17, -7.228030905621821e-19,  6.295320367531496e-21, -5.273705094252895e-23,
  5.601966798140086e-02, -2.026951593007760e-03,  4.685486545218594e-05, -8.478239288837307e-07,  1.303994226344008e-08, -1.779181219369893e-10,  2.209978340869425e-12,
 -2.542483641003350e-14,  2.742380125514321e-16, -2.798497185847896e-18,  2.720616127504073e-20, -2.533400665271530e-22,  5.238354939586682e-02, -2.378535699388667e-03,
  6.587759539905071e-05, -1.397993822714497e-06,  2.485488748191985e-08, -3.878337812380866e-10,  5.463185824578284e-12, -7.078690092240868e-14,  8.549357436061995e-16,
 -9.719991537995232e-18,  1.048182815185791e-19, -1.078455600077597e-21,  4.862172980482550e-02, -2.705310316690336e-03,  8.861657712697699e-05, -2.182936618993090e-06,
  4.447396830105516e-08, -7.875539380244703e-10,  1.249293444601040e-11, -1.811269223218311e-13,  2.434578856405666e-15, -3.066064667628166e-17,  3.647435953798346e-19,
 -4.124636952113755e-21,  4.481139479027275e-02, -2.994798188475486e-03,  1.146357161633503e-04, -3.247193955851290e-06,  7.520848809238233e-08, -1.500797818212317e-09,
  2.663879337588430e-11, -4.296165785360109e-13,  6.391217844530665e-15, -8.869531753039932e-17,  1.158208772129966e-18, -1.432696294836029e-20,  4.102245959489186e-02,
 -3.237486762626713e-03,  1.432253278720494e-04, -4.624679139522366e-06,  1.208717403916651e-07, -2.700409552031885e-09,  5.331713495077808e-11, -9.513028835891949e-13,
  1.558395921387625e-14, -2.371787557387078e-16,  3.384291346548086e-18, -4.559502678864502e-20,  3.731576884897683e-02, -3.427044614992347e-03,  1.734574789038880e-04,
 -6.333021263241620e-06,  1.855005966595102e-07, -4.611647325954412e-09,  1.007269695024102e-10, -1.978249569357440e-12,  3.551759595284778e-14, -5.901879557298412e-16,
  9.163386921770180e-18, -1.339181375274298e-19,  3.374200978336430e-02, -3.560286787543606e-03,  2.042619188769757e-04, -8.369270427620862e-06,  2.729658664800737e-07,
 -7.508289446149749e-09,  1.804817627324806e-10, -3.883122008448473e-12,  7.607075469436803e-14, -1.374355719231929e-15,  2.312704259912511e-17, -3.652568634608830e-19,
  3.034129701183119e-02, -3.636929258189839e-03,  2.345119534439763e-04, -1.070764611318296e-05,  3.865130533192868e-07, -1.169967467421467e-08,  3.079928335449515e-10,
 -7.226704497127798e-12,  1.538241830378844e-13, -3.009703040708148e-15,  5.468576093437156e-17, -9.300327116181320e-19,  2.714334285294213e-02, -3.659185976330393e-03,
  2.631096685062351e-04, -1.329968028236737e-05,  5.282932726510070e-07, -1.750814844822384e-08,  5.024116814539071e-10, -1.280106062525942e-11,  2.948753786313360e-13,
 -6.224717411800691e-15,  1.216890955947264e-16, -2.220987656428696e-18,  2.416809883938070e-02, -3.631267067958820e-03,  2.890614209162095e-04, -1.607673344650499e-05,
  6.989514118477400e-07, -2.523813370349384e-08,  7.859627107797081e-10, -2.165670781419329e-11,  5.378103936978189e-13, -1.220468652648716e-14,  2.558334424548211e-16,
 -4.994700131618321e-18,  2.142674134987204e-02, -3.558834857777966e-03,  3.115369935073155e-04, -1.895451979886840e-05,  8.973333514782017e-07, -3.513981012583314e-08,
  1.182569165104166e-09, -3.510046613510986e-11,  9.362588346784110e-13, -2.276168470540201e-14,  5.099261906851146e-16, -1.061591060869473e-17,  1.892287521862738e-02,
 -3.448466954217477e-03,  3.299087325623506e-04, -2.183902468255719e-05,  1.120357489880821e-06, -4.737175998007494e-08,  1.715785775368860e-09, -5.465162463573454e-11,
  1.560246670644052e-12, -4.050053121027139e-14,  9.666260116572974e-16, -2.139401545632637e-17,  1.665384062139361e-02, -3.307164824896521e-03,  3.437698433291540e-04,
 -2.463306657709963e-05,  1.363071629489049e-06, -6.196759248663146e-08,  2.406181687008565e-09, -8.194829339691896e-11,  2.495461103929851e-12, -6.894019103870667e-14,
  1.747555117036003e-15, -4.099913663347069e-17,  1.461202693515693e-02, -3.141934058219675e-03,  3.529334288045589e-04, -2.724275105472054e-05,  1.618889547238780e-06,
 -7.881132922093657e-08,  3.268439247405450e-09, -1.186030204871645e-10,  3.839622549438984e-12, -1.125387454493757e-13,  3.020823033988981e-15, -7.491012584128017e-17,
  1.278611915658107e-02, -2.959450561692933e-03,  3.574155869885081e-04, -2.958316680295995e-05,  1.879977367016929e-06, -9.762526086497446e-08,  4.308520519784870e-09,
 -1.660158319530401e-10,  5.695457805702660e-12, -1.765671538895742e-13,  5.004220908690884e-15, -1.308024601904342e-16,  1.116222488995917e-02, -2.765816526667119e-03,
  3.574068549590367e-04, -3.158284962323691e-05,  2.137742171766105e-06, -1.179722941886116e-07,  5.521283381035735e-09, -2.251620329039525e-10,  8.160270352775406e-12,
 -2.667866695237543e-13,  7.960924039229418e-15, -2.187398762075813e-16,  9.724850660610063e-03, -2.566401820678927e-03,  3.532365554896550e-04, -3.318674946579791e-05,
  2.383366351850884e-06, -1.392728369669784e-07,  6.888894604643100e-09, -2.963794014725876e-10,  1.131273502201061e-11, -3.889086429430257e-13,  1.218476538826390e-14,
 -3.510045722294675e-16,  8.457713949643468e-03, -2.365760813735332e-03,  3.453343014340363e-04, -3.435764110350387e-05,  2.608331262800105e-06, -1.608343854697919e-07,
  8.380294386076736e-09, -3.791831203714140e-10,  1.519818602835201e-11, -5.478516793329899e-13,  1.797320744604476e-14, -5.414036303086910e-16,  7.344391185758243e-03,
 -2.167611397202830e-03,  3.341922248900314e-04, -3.507609277711872e-05,  2.804881495371994e-06, -1.818904970669096e-07,  9.951833318757169e-09, -4.721359577031227e-10,
  1.981418215296354e-11, -7.468540862716293e-13,  2.558805100484102e-14, -8.039373966789120e-16,  6.368811863716822e-03, -1.974861761169595e-03,  3.203306057972845e-04,
 -3.533923231213746e-05,  2.966394018767969e-06, -2.016449494169375e-07,  1.154905394461530e-08, -5.727958266303172e-10,  2.509839930555653e-11, -9.865408616008882e-13,
  3.520644658521100e-14, -1.150813199560967e-15,  5.515615300034695e-03, -1.789670879574091e-03,  3.042686372243264e-04, -3.515862138922139e-05,  3.087631827586820e-06,
 -2.193166719332416e-07,  1.310945072768864e-08, -6.777538551688421e-10,  3.092084431833437e-11, -1.264074839089573e-12,  4.686746472691280e-14, -1.589925818917832e-15,
  4.770389846819926e-03, -1.613530105843708e-03,  2.865012012888110e-04, -3.455756963057588e-05,  3.164876888572908e-06, -2.341814239714458e-07,  1.456593609085039e-08,
 -7.827650932256929e-10,  3.708199564267491e-11, -1.572533168422554e-12,  6.042174721818752e-14, -2.122081148961994e-15,  4.119815334132922e-03, -1.447355341937330e-03,
  2.674818151214656e-04, -3.356820080849250e-05,  3.195950134834461e-06, -2.456070362658416e-07,  1.585067917837796e-08, -8.829628652485402e-10,  4.331781450056188e-11,
 -1.900638633599105e-12,  7.549301760653665e-14, -2.738377506780971e-15,  3.551728769188738e-03, -1.291581531256956e-03,  2.476113744952705e-04, -3.222853649978715e-05,
  3.180135778503377e-06, -2.530801314627678e-07,  1.689897182715179e-08, -9.731382978984379e-10,  4.931174366289489e-11, -2.232940595425791e-12,  9.146004454106158e-14,
 -3.418243031568522e-15,  3.055131486963757e-03, -1.146253461810103e-03,  2.272319754488735e-04, -3.057980073039749e-05,  3.118032881929895e-06, -2.562233990537766e-07,
  1.765280775591153e-08, -1.048059998564432e-09,  5.471295582790379e-11, -2.550487376256713e-12,  1.074658667775823e-13, -4.128627163152517e-15,  2.620153514578728e-03,
 -1.011108869138083e-03,  2.066249112889641e-04, -2.866408363206963e-05,  3.011359161861216e-06, -2.548035550125411e-07,  1.806392496906314e-08, -1.102805867514071e-09,
  5.915936148331552e-11, -2.831969002680448e-12,  1.224578712294229e-13, -4.824744259195764e-15,  2.237988256621256e-03, -8.856515020129723e-04,  1.860118915809724e-04,
 -2.652244113587465e-05,  2.862731053100213e-06, -2.487309540125540e-07,  1.809614359238898e-08, -1.133079562597800e-09,  6.230334059103184e-11, -3.055246387504217e-12,
  1.352581326256946e-13, -5.452573789606587e-15,  1.900807993772633e-03, -7.692131261390572e-04,  1.655585750064004e-04, -2.419345648206396e-05,  2.675440992582159e-06,
 -2.380523857999359e-07,  1.772691763096691e-08, -1.135487623045709e-09,  6.383788288859876e-11, -3.199129916003553e-12,  1.446589470182701e-13, -5.953061187865606e-15,
  1.601668280109650e-03, -6.610044059506920e-04,  1.453796149665426e-04, -2.171225030117736e-05,  2.453248591423891e-06, -2.229388710845070e-07,  1.694809763327992e-08,
 -1.107758776861781e-09,  6.352081943588874e-11, -3.245234550425427e-12,  1.495344604064095e-13, -6.267679630892158e-15,  1.334407217190783e-03, -5.601552639549593e-04,
  1.255445565413974e-04, -1.910989952031929e-05,  2.200197624787078e-06, -2.036703079303162e-07,  1.576596381068825e-08, -1.048893465184805e-09,  6.119507263538936e-11,
 -3.179724323714147e-12,  1.489563704506771e-13, -6.344756649323755e-15,  1.093543814520432e-03, -4.657457276310939e-04,  1.060840739179175e-04, -1.641321023294172e-05,
  1.920466195713617e-06, -1.806186620075029e-07,  1.420063173233876e-08, -9.592381581794695e-10,  5.680328374428015e-11, -2.994767279181449e-12,  1.423003330790980e-13,
 -6.145788653494167e-15,  8.741782310945207e-04, -3.768285016791147e-04,  8.699618500765423e-05, -1.364478418850432e-05,  1.618253452085593e-06, -1.542311095525266e-07,
  1.228495510057035e-08, -8.404848828173252e-10,  5.039572365426551e-11, -2.689550245052239e-12,  1.293301469327883e-13, -5.650897076210364e-15,  6.718956973842230e-04,
 -2.924446437895478e-04,  6.825222484135632e-05, -1.082332189442531e-05,  1.297703251806992e-06, -1.250142096630285e-07,  1.006305615394286e-08, -6.956011750504438e-10,
  4.213098841471778e-11, -2.270747021990246e-12,  1.102489663029349e-13, -4.862639364363820e-15,  4.826759221922056e-04, -2.116340963843042e-04,  4.980256181214580e-05,
 -7.964125656154554e-06,  9.628645146057873e-07, -9.351997978614898e-08,  7.588618346024096e-09, -5.286999534696239e-10,  3.226960927680484e-11, -1.752390160701113e-12,
  8.571051898751984e-14, -3.807576855098423e-15,  3.028171584466606e-04, -1.334463072614130e-04,  3.158297305199744e-05, -5.079909916488419e-06,  6.177028912007662e-07,
 -6.033601634820181e-08,  4.923189717499124e-09, -3.448701579498603e-10,  2.116178679357796e-11, -1.155184713482510e-12,  5.678934694965058e-14, -2.535350292952117e-15,
  1.290509343049718e-04, -5.703007334362638e-05,  1.354024676746721e-05, -2.184874529100153e-06,  2.665239662451073e-07, -2.611548587707146e-08,  2.137506477272890e-09,
 -1.501857452753057e-10,  9.242934901653665e-12, -5.060175968238454e-13,  2.494652531537327e-14, -1.116810093939956e-15,  7.047809397565521e-02, -2.081593513831377e-04,
  6.432586018219413e-07, -2.058657893869216e-09,  6.749866830351336e-12, -2.246617452768190e-14,  7.538322258470335e-17, -2.537961943374475e-19,  8.547309255652875e-22,
 -2.874170021255025e-24,  9.639784519631041e-27, -3.222959757461296e-29,  6.953068100639771e-02, -2.856949749278374e-04,  1.373077254096209e-06, -6.692159040633491e-09,
  3.184589964968560e-11, -1.473802878299598e-13,  6.654289331503031e-16, -2.942076839194153e-18,  1.277654830022150e-20, -5.462552684313396e-23,  2.303491588507567e-25,
 -9.594085356715732e-28,  6.767784669306354e-02, -4.341858461118424e-04,  3.035618958500981e-06, -1.972886282823851e-08,  1.202213323810811e-10, -6.974703193298857e-13,
  3.891782419862774e-15, -2.102745797641434e-17,  1.105427578316368e-19, -5.674780448280671e-22,  2.852769404852683e-24, -1.407511800174563e-26,  6.500023773657257e-02,
 -6.412166289332383e-04,  5.986740029320578e-06, -4.924515601240468e-08,  3.711338974484697e-10, -2.620957111422577e-12,  1.757980974421224e-14, -1.130130839419278e-16,
  7.008588309238122e-19, -4.213479805353854e-21,  2.464925203726031e-23, -1.407384616828721e-25,  6.161087647288397e-02, -8.899164531801510e-04,  1.064650972419393e-05,
 -1.083094562442063e-07,  9.893369870010503e-10, -8.342195415793267e-12,  6.603846567519131e-14, -4.963826514236590e-16,  3.571530629655244e-18, -2.474755346097865e-20,
  1.659101104664192e-22, -1.080094044019210e-24,  5.764666315794471e-02, -1.160770622140016e-03,  1.739125493774611e-05, -2.151951606217345e-07,  2.345753667064003e-09,
 -2.327924172934831e-11,  2.145882664434612e-13, -1.862170941947221e-15,  1.535853866801834e-17, -1.212481289801875e-19,  9.212204900980709e-22, -6.764989768424045e-24,
  5.325860287220318e-02, -1.433609836306626e-03,  2.644961843368669e-05, -3.925212793562979e-07,  5.042081421576479e-09, -5.821923767536531e-11,  6.183119751242353e-13,
 -6.133048319076104e-15,  5.743578945504235e-17, -5.119432838082252e-19,  4.369991920692119e-21, -3.589671801029479e-23,  4.860177782925111e-02, -1.689514199437595e-03,
  3.782410088725103e-05, -6.649952665280801e-07,  9.959066738792850e-09, -1.325158287408287e-10,  1.607176050199541e-12, -1.807114738244212e-14,  1.906611807656496e-16,
 -1.904454340791891e-18,  1.813381587463476e-20, -1.654771663699240e-22,  4.382602212879091e-02, -1.912404466873826e-03,  5.125312901090490e-05, -1.055867180134346e-06,
  1.826353518216863e-08, -2.777068103641390e-10,  3.816831923925363e-12, -4.830301307334533e-14,  5.702904762252949e-16, -6.342993018998988e-18,  6.695993437927119e-20,
 -6.748131014161654e-22,  3.906807393704561e-02, -2.090160939907272e-03,  6.621946637843373e-05, -1.582649052447862e-06,  3.135190764228343e-08, -5.407060858410031e-10,
  8.364327025284941e-12, -1.183856663581888e-13,  1.554828695162566e-15, -1.914795587761847e-17,  2.228998745617487e-19, -2.468065994161848e-21,  3.444572061245929e-02,
 -2.215195328119407e-03,  8.200114842796212e-05, -2.252957844766680e-06,  5.071946395376366e-08, -9.853660833382367e-10,  1.705002539202671e-11, -2.683483630556975e-13,
  3.899527545287362e-15, -5.290417310207412e-17,  6.758436809135311e-19, -8.183939759852640e-21,  3.005416400136020e-02, -2.284485714451047e-03,  9.775329847752126e-05,
 -3.061406432175409e-06,  7.776297402428681e-08, -1.691128700250192e-09,  3.254440849622273e-11, -5.665847649841950e-13,  9.065000473728342e-15, -1.348547165867703e-16,
  1.882237781814390e-18, -2.482143370912772e-20,  2.596456210556623e-02, -2.299154905988705e-03,  1.126046660734184e-04, -3.988278296854108e-06,  1.135442661956754e-07,
 -2.747822083714607e-09,  5.849833284836507e-11, -1.121020325003310e-12,  1.965701024074077e-14, -3.192741599624821e-16,  4.848954389123389e-18, -6.936505555025072e-20,
  2.222448513031794e-02, -2.263718550317579e-03,  1.257520243737467e-04, -5.000341574267578e-06,  1.585573577287449e-07, -4.246418790250201e-09,  9.950720764104477e-11,
 -2.089303376183149e-12,  3.997966239407393e-14, -7.061179452355923e-16,  1.162448262055301e-17, -1.797294866038114e-19,  1.885987906618377e-02, -2.185148244042749e-03,
  1.365382124613295e-04, -6.053701834219206e-06,  2.125467034031860e-07, -6.266584406506939e-09,  1.608713446157391e-10, -3.684726641023217e-12,  7.663182067600959e-14,
 -1.466147778092598e-15,  2.606832792989047e-17, -4.341227238715358e-19,  1.587806326431520e-02, -2.071888880881653e-03,  1.445044807427112e-04, -7.098185419465970e-06,
  2.744169144988363e-07, -8.862827359721579e-09,  2.481287533954569e-10, -6.174149551855701e-12,  1.390157111191337e-13, -2.870651360636562e-15,  5.493598095293912e-17,
 -9.821603527878553e-19,  1.327129162588271e-02, -1.932945044080436e-03,  1.494134926114032e-04, -8.082482667644966e-06,  3.422568143158736e-07, -1.205169901503474e-08,
  3.663872912197619e-10, -9.864765347774012e-12,  2.395768017340461e-13, -5.321001316301157e-15,  1.092384434780523e-16, -2.090063556931999e-18,  1.102046310328587e-02,
 -1.777116488375122e-03,  1.512445698593046e-04, -8.959207500837485e-06,  4.134778262591266e-07, -1.580256708808159e-08,  5.195375614425597e-10, -1.507828039280116e-11,
  3.935787884146479e-13, -9.370298805373741e-15,  2.057117869500877e-16, -4.199370582644854e-18,  9.098655634781972e-03, -1.612425602463994e-03,  1.501666446614642e-04,
 -9.689136109133790e-06,  4.850445722080001e-07, -2.003394457980695e-08,  7.094703241322914e-10, -2.211369753528564e-11,  6.182558830608566e-13, -1.572728346778504e-14,
  3.680836761315255e-16, -7.993516564517442e-18,  7.474258570222991e-03, -1.445746451693832e-03,  1.464964925799899e-04, -1.024412037329776e-05,  5.537595570585663e-07,
 -2.461633650374405e-08,  9.354388240902069e-10, -3.120280431747928e-11,  9.312815137391853e-13, -2.523271306262611e-14,  6.276924206213810e-16, -1.445993602803752e-17,
  6.113576002729752e-03, -1.282619462792856e-03,  1.406502195359442e-04, -1.060845926769626e-05,  6.165570499641305e-07, -2.938133726992069e-08,  1.193690958607452e-09,
 -4.246485384831866e-11,  1.348633412369160e-12, -3.880130620421285e-14,  1.022955627710062e-15, -2.492860279343142e-17,  4.982856313424957e-03, -1.127219528030902e-03,
  1.330950326546948e-04, -1.077878459103754e-05,  6.707640847189901e-07, -3.413558319957011e-08,  1.477451610337954e-09, -5.586806228902148e-11,  1.882087509829168e-12,
 -5.732809238150284e-14,  1.597250737611113e-15, -4.106358517621376e-17,  4.049766084521736e-03, -9.824378405566278e-04,  1.243065636333192e-04, -1.076272575945828e-05,
  7.142968467398784e-07, -3.867739266847225e-08,  1.777272982291245e-09, -7.120503255455320e-11,  2.536696034112264e-12, -8.156564300972009e-14,  2.394982307447181e-15,
 -6.478488136193929e-17,  3.284368227056527e-03, -8.500374425834719e-04,  1.147349567191776e-04, -1.057673775971447e-05,  7.457751619666524e-07, -4.281364586538714e-08,
  2.081705938554220e-09, -8.808711395125889e-11,  3.308662226458161e-12, -1.119863862686086e-13,  3.455950809331091e-15, -9.810530574387690e-17,  2.659686745728706e-03,
 -7.308470387334456e-04,  1.047809997362330e-04, -1.024350688902754e-05,  7.645526964663059e-07, -4.637466352264746e-08,  2.378193138306975e-09, -1.059595232818467e-10,
  4.183995433897363e-12, -1.486499670358340e-13,  4.808538752405411e-15, -1.428815351338596e-16,  2.151947844460024e-03, -6.249648737131605e-04,  9.478203148546634e-05,
 -9.789308329910400e-06,  7.706728691497037e-07, -4.922542234974153e-08,  2.654055416945197e-09, -1.241355514800954e-10,  5.138219534487934e-12, -1.910976966880511e-13,
  6.462594971072086e-15, -2.004973622219269e-16,  1.740583485755580e-03, -5.319525445221603e-04,  8.500631548880506e-05, -9.241604221939428e-06,  7.647686515719728e-07,
 -5.127221584960680e-08,  2.897439891143857e-09, -1.418451546997673e-10,  6.137240038281604e-12, -2.382937619525820e-13,  8.403127102546026e-15, -2.715165860728130e-16,
  1.408073242662886e-03, -4.510061971799212e-04,  7.565402039343675e-05, -8.627067486020841e-06,  7.479279441267354e-07, -5.246464933487298e-08,  3.098118548172674e-09,
 -1.582912811137886e-10,  7.139289587355045e-12, -2.886264128595452e-13,  1.058593439969702e-14, -3.553577963451450e-16,  1.139686789571523e-03, -3.810988770825935e-04,
  6.686280619550155e-05, -7.970116975895048e-06,  7.215456654846689e-07, -5.279350295711355e-08,  3.248061947313431e-09, -1.727066917556116e-10,  8.097708497178826e-12,
 -3.399732471886566e-13,  1.293610822073826e-14, -4.500492267102117e-16,  9.231752199707146e-04, -3.210925496064628e-04,  5.871616322630815e-05, -7.291967716999984e-06,
  6.871802587234111e-07, -5.228542383217816e-08,  3.341754633520712e-09, -1.844047304470720e-10,  8.964207846187909e-12, -3.898249612907381e-13,  1.534993334553321e-14,
 -5.521165199540171e-16,  7.484462147758288e-04, -2.698215010800638e-04,  5.125296681962794e-05, -6.610142507629265e-06,  6.464273632441467e-07, -5.099559848847582e-08,
  3.376258242513734e-09, -1.928191540574476e-10,  9.692222950674354e-12, -4.354535624821098e-13,  1.770022274243188e-14, -6.566400724104715e-16,  6.072468199797371e-04,
 -2.261506842357479e-04,  4.447709336026331e-05, -5.938358300986865e-06,  6.008181361559763e-07, -4.899953990972480e-08,  3.351058881381100e-09, -1.975302846422398e-10,
  1.023999318080245e-11, -4.741055493159732e-13,  1.984461553534958e-14, -7.574946576449521e-16,  4.928685690745493e-04, -1.890133885239969e-04,  3.836631995753175e-05,
 -5.286688863553414e-06,  5.517450088948381e-07, -4.638495813945097e-08,  3.267754202329773e-09, -1.982769224755514e-10,  1.057308453835976e-11, -5.031986687874199e-13,
  2.163595944792956e-14, -8.477570672782779e-16,  3.998828697083057e-04, -1.574327055219149e-04,  3.288005599442760e-05, -4.661908635794654e-06,  5.004140323451443e-07,
 -4.324443687566569e-08,  3.129642579186637e-09, -1.949552959225421e-10,  1.066618119908555e-11, -5.205024125652835e-13,  2.293365171369290e-14, -9.202427811184938e-16,
  3.239097142796842e-04, -1.305308973368977e-04,  2.796571005920355e-05, -4.067935686376729e-06,  4.478205583464321e-07, -3.966937081681960e-08,  2.941273972543693e-09,
 -1.876076030192264e-10,  1.050408731535920e-11, -5.242866105310506e-13,  2.361475165489506e-14, -9.681145541523808e-16,  2.614195222217930e-04, -1.075301774366990e-04,
  2.356367741515614e-05, -3.506309129320157e-06,  3.947437456385329e-07, -3.574537415460681e-08,  2.708012530537642e-09, -1.764033562174021e-10,  1.008198100912141e-11,
 -5.134281521288796e-13,  2.358378865705217e-14, -9.854968815304899e-16,  2.095659122439651e-04, -8.774773304213749e-05,  1.961104902013593e-05, -2.976654623128752e-06,
  3.417550426047422e-07, -3.154917580244153e-08,  2.435647981102394e-09, -1.616168338033139e-10,  9.405036030063178e-12, -4.874718087130916e-13,  2.278042608876630e-14,
 -9.680310874354963e-16,  1.660461011396398e-04, -7.058715560577447e-05,  1.604420617257279e-05, -2.477108201602639e-06,  2.892361156143375e-07, -2.714688171924163e-08,
  2.130079219187368e-09, -1.436036021961112e-10,  8.487568094605254e-12, -4.466463530247954e-13,  2.118444555926427e-14, -9.133149572277017e-16,  1.289851521681872e-04,
 -5.552785774367338e-05,  1.280048956755736e-05, -2.004682500975827e-06,  2.374024034559045e-07, -2.259340730169256e-08,  1.797081196589772e-09, -1.227784658606099e-10,
  7.351874156091806e-12, -3.918410481459000e-13,  1.881782880831344e-14, -8.211858789386268e-16,  9.684024023817931e-05, -4.211357127488633e-05,  9.819132251678652e-06,
 -1.555570293226794e-06,  1.863293962746230e-07, -1.793285623554255e-08,  1.442156606156705e-09, -9.959649203856952e-11,  6.026920573140855e-12, -3.245499073944820e-13,
  1.574399292925013e-14, -6.938245120000429e-16,  6.832138166369926e-05, -2.994068359769742e-05,  7.041642382910240e-06, -1.125389760115851e-06,  1.359798834092060e-07,
 -1.319965098248821e-08,  1.070468707092412e-09, -7.453816596030267e-11,  4.547014459618145e-12, -2.467923283819441e-13,  1.206446757751392e-14, -5.356750687765438e-16,
  4.232646067561234e-05, -1.864736306414912e-05,  4.411915160393160e-06, -7.093997045047365e-07,  8.623352859227408e-08, -8.420471476249649e-09,  6.868655538377162e-10,
 -4.810037683889305e-11,  2.950633496924444e-12, -1.610225956108871e-13,  7.913654567476411e-15, -3.532040834418058e-16,  1.791186699468472e-05, -7.914454967383062e-06,
  1.878763868441706e-06, -3.031090943092633e-07,  3.696881451503570e-08, -3.621801680263675e-09,  2.963889679784973e-10, -2.082150874867448e-11,  1.281218377410765e-12,
 -7.013092806798556e-14,  3.456890754891715e-15, -1.547346844401712e-16,  6.965559479746866e-02, -2.031102957054024e-04,  6.191881785842590e-07, -1.954158674518976e-09,
  6.318075280427882e-12, -2.073925501269751e-14,  6.864480853261599e-17, -2.280285931708346e-19,  7.578730270036334e-22, -2.515487429041592e-24,  8.328821707582321e-27,
 -2.749358691244915e-29,  6.840937367907601e-02, -2.750231369605944e-04,  1.295734017178874e-06, -6.205364973004946e-09,  2.905155548932012e-11, -1.323540867235551e-13,
  5.884912580208337e-16, -2.562992650038880e-18,  1.096619417934981e-20, -4.620287948075601e-23,  1.920277325089224e-25, -7.884073030731523e-28,  6.598821862599348e-02,
 -4.108162078063379e-04,  2.809969430782109e-06, -1.791203510113481e-08,  1.071602519946690e-10, -6.107511626869896e-13,  3.349615834536625e-15, -1.779608972397861e-17,
  9.202664496718616e-20, -4.648462773189440e-22,  2.299948309942519e-24, -1.117108659506760e-26,  6.252755387378266e-02, -5.955893678481309e-04,  5.429768603026528e-06,
 -4.370447473908306e-08,  3.226901226218209e-10, -2.234613410140329e-12,  1.470791446811974e-14, -9.283375273784241e-17,  5.655241452887911e-19, -3.341006755818502e-21,
  1.921345175079688e-23, -1.078727217810300e-25,  5.821368716195781e-02, -8.096862728376640e-04,  9.436533322811111e-06, -9.373320488325158e-08,  8.372799257492242e-10,
 -6.911921765135983e-12,  5.361448381205491e-14, -3.951549109212881e-16,  2.789446675967733e-18, -1.897225073301242e-20,  1.249005492629730e-22, -7.987647019545489e-25,
  5.326634222138900e-02, -1.031365555933802e-03,  1.501960134220492e-05, -1.811247354930724e-07,  1.927717399857942e-09, -1.870306892860923e-11,  1.687194320653747e-13,
 -1.433968700013382e-15,  1.159091708325673e-17, -8.972938287478379e-20,  6.688467678129426e-22, -4.820820377674152e-24,  4.791935155499939e-02, -1.239565994421515e-03,
  2.218743895969884e-05, -3.204116327248961e-07,  4.013187043273426e-09, -4.524866210341010e-11,  4.697709649457168e-13, -4.559110348314781e-15,  4.180541888557522e-17,
 -3.650832574114930e-19,  3.054983281225483e-21, -2.461230140266552e-23,  4.240194189253754e-02, -1.416320913457948e-03,  3.071911447645169e-05, -5.249173722156330e-07,
  7.656798459363430e-09, -9.938475416441744e-11,  1.177214481634012e-12, -1.294006303562164e-14,  1.335737552746092e-16, -1.306281780224232e-18,  1.218495199604909e-20,
 -1.089865818585051e-22,  3.692270321139076e-02, -1.548485297188948e-03,  4.016768533274731e-05, -8.035318333398502e-07,  1.352571259450238e-08, -2.004643406468648e-10,
  2.688883742947673e-12, -3.324334391639587e-14,  3.837606896599215e-16, -4.176500518296445e-18,  4.316852289948278e-20, -4.262057972822119e-22,  3.165769876849508e-02,
 -1.628600866353557e-03,  4.991307317689401e-05, -1.157657894219663e-06,  2.230328773767154e-08, -3.746978554074999e-10,  5.653601444216804e-12, -7.813177837933208e-14,
  1.002847139552326e-15, -1.207909371151655e-17,  1.376184340438524e-19, -1.492254269375919e-21,  2.674340211315084e-02, -1.654897457618480e-03,  5.924998520804725e-05,
 -1.579193585301235e-06,  3.456156809640022e-08, -6.538191726113700e-10,  1.103042177549453e-11, -1.694505707342697e-13,  2.405654949925098e-15, -3.191068150867023e-17,
  3.988629093759021e-19, -4.728755546807013e-21,  2.227439628668084e-02, -1.630574674807032e-03,  6.748955526535827e-05, -2.050198422217965e-06,  5.061814970715091e-08,
 -1.071671054244492e-09,  2.010372674724081e-11, -3.415493433610141e-13,  5.337656789109691e-15, -7.762429644986607e-17,  1.059909371495411e-18, -1.368257395828761e-20,
  1.830516771370275e-02, -1.562600212398533e-03,  7.405275654655399e-05, -2.544457004380037e-06,  7.041167038280222e-08, -1.658861548176846e-09,  3.442404382681233e-11,
 -6.437227327330113e-13,  1.102494122383563e-14, -1.750464136942921e-16,  2.600675066600579e-18, -3.641802293893646e-20,  1.485494655028876e-02, -1.460291822921213e-03,
  7.853842984277883e-05, -3.030654800289963e-06,  9.343019920232055e-08, -2.436310872948424e-09,  5.565613423021640e-11, -1.140435123336537e-12,  2.131677038358430e-14,
 -3.680685625158208e-16,  5.928062491810686e-18, -8.972994026943818e-20,  1.191440210917732e-02, -1.333925714956365e-03,  8.075676964570350e-05, -3.476485712908258e-06,
  1.187158233595558e-07, -3.409043524572171e-09,  8.533896899351552e-11, -1.908053076615101e-12,  3.877087724161898e-14, -7.253320195403664e-16,  1.261975198386784e-17,
 -2.057876721899686e-19,  9.453063774343518e-03, -1.193552804273834e-03,  8.072768128712383e-05, -3.852830428661679e-06,  1.449501707847356e-07, -4.561758999683339e-09,
  1.245905993568845e-10, -3.027378719709554e-12,  6.662214333879362e-14, -1.345686335957684e-15,  2.520806614982007e-17, -4.414401572239628e-19,  7.426542321368851e-03,
 -1.048126972135367e-03,  7.865036069686601e-05, -4.137205620364257e-06,  1.706056071076986e-07, -5.857434516392762e-09,  1.738149249697649e-10, -4.572305317010526e-12,
  1.085837314191284e-13, -2.360033065432065e-15,  4.744688609323341e-17, -8.895724949171554e-19,  5.782902510989790e-03, -9.049753078365069e-04,  7.485449756589047e-05,
 -4.315934346504845e-06,  1.941316969276603e-07, -7.239542315809380e-09,  2.324774959108040e-10, -6.596133082539338e-12,  1.684598625427368e-13, -3.927045594263461e-15,
  8.447189826865924e-17, -1.690645663076597e-18,  4.467821701088183e-03, -7.695822022412192e-04,  6.974445468269564e-05, -4.384828279945159e-06,  2.141403231900184e-07,
 -8.637612607032038e-09,  2.990086699562768e-10, -9.118083887757301e-12,  2.495966330225866e-13, -6.220976876613034e-15,  1.427469780859447e-16, -3.041160277836424e-18,
  3.428415346280724e-03, -6.456229288808853e-04,  6.374623903544116e-05, -4.348498115680280e-06,  2.295563657336121e-07, -9.975106317500472e-09,  3.708663228004159e-10,
 -1.211295518473646e-11,  3.542486799799352e-13, -9.411357774223116e-15,  2.297016707081497e-16, -5.194783700024523e-18,  2.615793883684745e-03, -5.351676106727353e-04,
  5.726408128911687e-05, -4.218642695002365e-06,  2.397117343449347e-07, -1.117809825287756e-08,  4.447546381380200e-10, -1.550645838422569e-11,  4.829780727509086e-13,
 -1.363652488056162e-14,  3.530136293531951e-16, -8.451871431466135e-18,  1.986530527182976e-03, -4.389787583988734e-04,  5.065003565436992e-05, -4.011776235243708e-06,
  2.443747727006625e-07, -1.218321149971619e-08,  5.169610509040414e-10, -1.917767006711030e-11,  6.342129216044860e-13, -1.897498443761509e-14,  5.195697253265007e-16,
 -1.313452562180035e-17,  1.503273095395029e-03, -3.568386890435208e-04,  4.418701559285391e-05, -3.746843695587494e-06,  2.437204263267543e-07, -1.294355315987460e-08,
  5.837498696622979e-10, -2.296850632959785e-11,  8.040707448959371e-13, -2.541992545616675e-14,  7.342309348668656e-16, -1.954715734491590e-17,  1.134739579969512e-03,
 -2.878610716392273e-04,  3.808354815043180e-05, -3.443080963783493e-06,  2.382560939420730e-07, -1.343194417095137e-08,  6.417438622246813e-10, -2.669865237515029e-11,
  9.865006583804334e-13, -3.286223689354607e-14,  9.986014920146218e-16, -2.792619440932632e-17,  8.553131097648837e-04, -2.307589229332964e-04,  3.247737682955062e-05,
 -3.118343182256351e-06,  2.287224861024392e-07, -1.364133745861427e-08,  6.882340705065107e-10, -3.018334105478761e-11,  1.173733236766565e-12, -4.108605072445580e-14,
  1.310036353159905e-15, -3.838610363972033e-17,  6.444120753905010e-04, -1.840566563331430e-04,  2.744474217695455e-05, -2.787990484419854e-06,  2.159884385418835e-07,
 -1.358282599295268e-08,  7.213786965430464e-10, -3.325100569676397e-11,  1.356965607011093e-12, -4.977845657626885e-14,  1.661098603553071e-15, -5.087116336072705e-17,
  4.857667878466826e-04, -1.462449779248310e-04,  2.301246902731026e-05, -2.464312239806583e-06,  2.009548590568430e-07, -1.328196255402340e-08,  7.402771682628892e-10,
 -3.575814501211254e-11,  1.527167637147141e-12, -5.855226337142669e-14,  2.039603201834132e-15, -6.512260955084995e-17,  3.666925836590854e-04, -1.158844424065925e-04,
  1.917061620193693e-05, -2.156400527384610e-06,  1.844775798113306e-07, -1.277422293197497e-08,  7.449287731628952e-10, -3.759955558149387e-11,  1.675881454302472e-12,
 -6.697825175242206e-14,  2.429274779322983e-15, -8.066867542730142e-17,  2.774147116628920e-04, -9.166697569488959e-05,  1.588416938999835e-05, -1.870350825345328e-06,
  1.673134039377980e-07, -1.210037670751681e-08,  7.361018984203218e-10, -3.871313589135447e-11,  1.795900677246073e-12, -7.462184351320743e-14,  2.810933667093966e-15,
 -9.684112744081372e-17,  2.104739831295637e-04, -7.244558713510754e-05,  1.310292509309023e-05, -1.609665190460670e-06,  1.500891369169756e-07, -1.130234821140961e-08,
  7.151480462306302e-10, -3.907947022542559e-11,  1.881750228793181e-12, -8.107877341812301e-14,  3.164033994718961e-15, -1.128171690242295e-16,  1.602236921932980e-04,
 -5.724178346256292e-05,  1.076924077153622e-05, -1.375749941347958e-06,  1.332903701760307e-07, -1.041992357787742e-08,  6.837949804042788e-10, -3.871716002901760e-11,
  1.929931288123155e-12, -8.600510535948601e-14,  3.468329720015205e-15, -1.276812125239287e-16,  1.224164836723932e-04, -4.523864773022224e-05,  8.823689845326496e-06,
 -1.168425955388507e-06,  1.172652570931090e-07, -9.488444025191092e-09,  6.439477695406394e-10, -3.767529059200824e-11,  1.938937887884678e-12, -8.913845107732547e-14,
  3.705444652407664e-15, -1.404979935087365e-16,  9.387311643350845e-05, -3.576572627866479e-05,  7.208873653125428e-06, -9.863973616122619e-07,  1.022382145534012e-07,
 -8.537455508891715e-09,  5.975178573907371e-10, -3.602450842062810e-11,  1.909083847888275e-12, -9.030907291959471e-14,  3.860164017128227e-15, -1.503873523000896e-16,
  7.222194885507190e-05, -2.828012865205609e-05,  5.871738043247851e-06, -8.276487710074121e-07,  8.832899826974353e-08, -7.590174396765307e-09,  5.462910962434438e-10,
 -3.384801488455882e-11,  1.842197333511748e-12, -8.944125743840727e-14,  3.921332454269919e-15, -1.565917355394413e-16,  5.569719915851167e-05, -2.234677082309140e-05,
  4.764756673896298e-06, -6.897599311073257e-07,  7.557354648641610e-08, -6.663575323357836e-09,  4.918376919313052e-10, -3.123345993909866e-11,  1.741245417608118e-12,
 -8.654663521034668e-14,  3.882318363785485e-15, -1.585296366635485e-16,  4.298464277201960e-05, -1.761954314328011e-05,  3.846309210562291e-06, -5.701394153985218e-07,
  6.394405458770348e-08, -5.768898973364157e-09,  4.354611579625971e-10, -2.826634783681384e-11,  1.609945420730195e-12, -8.171185883857361e-14,  3.741071336598994e-15,
 -1.558311173501663e-16,  3.310471980696326e-05, -1.382435042586381e-05,  3.080525736978867e-06, -4.661863841668410e-07,  5.336672851925214e-08, -4.912398966084503e-09,
  3.781798694245664e-10, -2.502522254511809e-11,  1.452407559143471e-12, -7.508324808462944e-14,  3.499847670312338e-15, -1.483545282446610e-16,  2.532459245607634e-05,
 -1.074440536446943e-05,  2.436806004463188e-06, -3.753928077597086e-07,  4.373646205309867e-08, -4.096183978324461e-09,  3.207333660054676e-10, -2.157863024262966e-11,
  1.272838562423858e-12, -6.685078133171998e-14,  3.164704614155720e-15, -1.361860197339776e-16,  1.909224782042300e-05, -8.207798816635387e-06,  1.889163793097226e-06,
 -2.953991254340114e-07,  3.492826107315151e-08, -3.319052734032592e-09,  2.636056602278129e-10, -1.798367693829315e-11,  1.075321611522226e-12, -5.723331422364218e-14,
  2.744868411180857e-15, -1.196250818988140e-16,  1.398714582658677e-05, -6.077164592763446e-06,  1.415497706609730e-06, -2.240152748863371e-07,  2.680561673930854e-08,
 -2.577258637881229e-09,  2.070589188886557e-10, -1.428590819430451e-11,  8.636762857810155e-13, -4.646630029546134e-14,  2.252069536960914e-15, -9.916010968806691e-17,
  9.683115074091305e-06, -4.241158724385871e-06,  9.968528248840821e-07, -1.592174253216546e-07,  1.922627285887620e-08, -1.865176290598447e-09,  1.511727008992912e-10,
 -1.052023173440545e-11,  6.413948714088242e-13, -3.479274303141244e-14,  1.699919278374545e-15, -7.543806550278771e-17,  5.920311428086950e-06, -2.607500094478741e-06,
  6.167251142165346e-07, -9.913125012567937e-08,  1.204624226232977e-08, -1.175897696384302e-09,  9.588812578174269e-11, -6.712804188480181e-12,  4.116571719638809e-13,
 -2.245818620158738e-14,  1.103404837779118e-15, -4.923299965263885e-17,  2.487007618564056e-06, -1.098734394784177e-06,  2.607775869659494e-07, -4.206507428489698e-08,
  5.129591860261109e-09, -5.024549024674532e-10,  4.111122064460049e-11, -2.887602022320214e-12,  1.776544314137302e-13, -9.722796062289096e-15,  4.791780509788538e-16,
 -2.144518413357334e-17,  6.885291449474425e-02, -1.982489023293187e-04,  5.963314059492306e-07, -1.856300360581338e-09,  5.919261581614835e-12, -1.916573817991623e-14,
  6.258636630178120e-17, -2.051635704903548e-19,  6.730319306228036e-22, -2.205304156670656e-24,  7.209412914398594e-27, -2.350018813385544e-29,  6.732955216446632e-02,
 -2.649474166295951e-04,  1.223973653926526e-06, -5.760973051899494e-09,  2.654009739162221e-11, -1.190532938262340e-13,  5.214004579241972e-16, -2.237270082563357e-18,
  9.433185015096915e-21, -3.917263053436799e-23,  1.604944415052532e-25, -6.496706876308515e-28,  6.438859195133409e-02, -3.891679832376833e-04,  2.604922997850176e-06,
 -1.629098698006593e-08,  9.571043142539078e-11, -5.360219512994325e-13,  2.890158745545402e-15, -1.510215109546350e-17,  7.683621805798789e-20, -3.819693643021048e-22,
  1.860439858202273e-24, -8.897540634798394e-27,  6.022887074658542e-02, -5.541645383480348e-04,  4.934878110078874e-06, -3.888064016184370e-08,  2.813273224510224e-10,
 -1.910876721667482e-12,  1.234484877820554e-14, -7.652187829889640e-17,  4.580097800603061e-19, -2.659583025633273e-21,  1.503835516089543e-23, -8.304135310616606e-26,
  5.511911109444834e-02, -7.384755298155944e-04,  8.387768477398683e-06, -8.137630842801892e-08,  7.110623266395889e-10, -5.748457811663600e-12,  4.370363668358827e-14,
 -3.159211586196655e-16,  2.188504863815607e-18, -1.461410133792606e-20,  9.449735196606630e-23, -5.937910923157669e-25,  4.936813262319492e-02, -9.194054574808185e-04,
  1.301949846698737e-05, -1.530666717981652e-07,  1.591101029882145e-09, -1.509651320861648e-11,  1.333099670578427e-13, -1.109968034224389e-15,  8.795150068609093e-18,
 -6.678117293352473e-20,  4.884807177182134e-22, -3.456422118699041e-24,  4.329319046528978e-02, -1.076419657257771e-03,  1.869977315074311e-05, -2.628686753116932e-07,
  3.211351406692637e-09, -3.536620216774115e-11,  3.590255011142219e-13, -3.410007030209544e-15,  3.062382063879786e-17, -2.620832800042464e-19,  2.150357077580609e-21,
 -1.699477890828292e-23,  3.719102325096927e-02, -1.193823051940351e-03,  2.509422044885274e-05, -4.168900946791592e-07,  5.924610166059135e-09, -7.503677252228250e-11,
  8.682841527988695e-13, -9.332695328542802e-15,  9.427589978412194e-17, -9.028587693383132e-19,  8.252143701017959e-21, -7.236091887364895e-23,  3.131519560555766e-02,
 -1.262317749934615e-03,  3.170201483625054e-05, -6.159816016416106e-07,  1.009298479759939e-08, -1.458410770600540e-10,  1.909570865984661e-12, -2.306893373261893e-14,
  2.604414291066282e-16, -2.773988177541040e-18,  2.807874267919160e-20, -2.716403358828719e-22,  2.586179217022349e-02, -1.279322453675112e-03,  3.793698846475516e-05,
 -8.540680207701478e-07,  1.600615702286488e-08, -2.620041727345632e-10,  3.856705360662627e-12, -5.205224545692493e-14,  6.530588109097936e-16, -7.694671532564159e-18,
  8.581477892133339e-20, -9.114209777114220e-22,  2.096386337830030e-02, -1.248205894353704e-03,  4.322858593800832e-05, -1.117905148301450e-06,  2.378899521159365e-08,
 -4.382862837611679e-10,  7.210639321701482e-12, -1.081367810010657e-13,  1.500064194634419e-15, -1.945822735561032e-17,  2.380044234417698e-19, -2.762964169227841e-21,
  1.669360154975430e-02, -1.176773080826619e-03,  4.711601657572470e-05, -1.388494849696437e-06,  3.332476069551994e-08, -6.869575157796332e-10,  1.256366775071952e-11,
 -2.083227337695915e-13,  3.180396861597695e-15, -4.521975642050619e-17,  6.041029179687886e-19, -7.634898873800896e-21,  1.307027942276528e-02, -1.075417701936631e-03,
  4.931418386959126e-05, -1.643878265650785e-06,  4.421995648786739e-08, -1.014284772567012e-09,  2.051844215447028e-11, -3.744419569871718e-13,  6.264278546614952e-15,
 -9.723289773533527e-17,  1.413278994804607e-18, -1.937436133922483e-20,  1.007159355947735e-02, -9.553232428434916e-04,  4.974035865422269e-05, -1.862618038141891e-06,
  5.582675623859515e-08, -1.417448605291434e-09,  3.156824239293106e-11, -6.312980875273269e-13,  1.152696970669611e-14, -1.945845310792270e-16,  3.066169954203949e-18,
 -4.543756381370722e-20,  7.646161627955528e-03, -8.269918383401302e-04,  4.850199140130621e-05, -2.027117843443180e-06,  6.732241002098425e-08, -1.882856721953220e-09,
  4.596112800017934e-11, -1.003101657818884e-12,  1.991443944692124e-14, -3.643003979797260e-16,  6.202265469396446e-18, -9.903442476105236e-20,  5.725373452545449e-03,
 -6.992463947824733e-04,  4.585500157402481e-05, -2.126041190699020e-06,  7.782833084481160e-08, -2.386522100247902e-09,  6.358213785617319e-11, -1.508589667438857e-12,
  3.244623064685188e-14, -6.410271597293443e-16,  1.175360330494089e-17, -2.015999943718097e-19,  4.233408758236261e-03, -5.787265242157688e-04,  4.214642883704121e-05,
 -2.155405444517744e-06,  8.654081785682342e-08, -2.896617941000742e-09,  8.388885589231338e-11, -2.155786707196908e-12,  5.005673844055588e-14, -1.064582536182859e-15,
  2.095740349361798e-17, -3.850022762044874e-19,  3.094848534608091e-03, -4.698073413321116e-04,  3.775538114516766e-05, -2.118308783268611e-06,  9.284386593812219e-08,
 -3.377710425041739e-09,  1.059245855341413e-10, -2.937714079228490e-12,  7.339718495628714e-14, -1.675082748030734e-15,  3.529928131833379e-17, -6.925745479771353e-19,
  2.239811822586387e-03, -3.748212833766575e-04,  3.304299380321030e-05, -2.023569274767618e-06,  9.638173138141780e-08, -3.795722228215196e-09,  1.284133603883597e-10,
 -3.830306040495381e-12,  1.026392535569395e-13, -2.506046247068107e-15,  5.636870681222927e-17, -1.177930539996400e-18,  1.606894017864160e-03, -2.944529240148757e-04,
  2.831739653417289e-05, -1.883737324367110e-06,  9.708134122025157e-08, -4.122536994140070e-09,  1.499190583216779e-10, -4.793320848373237e-12,  1.373296589684079e-13,
 -3.576627770520741e-15,  8.562948091173585e-17, -1.900740577735024e-18,  1.144364349695384e-03, -2.281938547847443e-04,  2.381509207461173e-05, -1.712969485963652e-06,
  9.512760114785356e-08, -4.339333360586225e-09,  1.690345564470032e-10, -5.774283284071499e-12,  1.763381997596108e-13, -4.884672319988166e-15,  1.241350422867174e-16,
 -2.919269114330620e-18,  8.101285968838775e-04, -1.747757371294271e-04,  1.969672739901710e-05, -1.525157638870542e-06,  9.090432384929908e-08, -4.438138590200407e-09,
  1.845611548026474e-10, -6.714719582438363e-12,  2.179211262147765e-13, -6.402355245703532e-15,  1.722423075435102e-16, -4.280383319897149e-18,  5.709213284933640e-04,
 -1.325332398826280e-04,  1.605337017777118e-05, -1.332551694121123e-06,  8.491795327806314e-08, -4.421560945693224e-09,  1.956441255261109e-10, -7.557400163018202e-12,
  2.598934950903955e-13, -8.075712100822824e-15,  2.293889819442245e-16, -6.008665100564885e-18,  4.011023147394103e-04, -9.967733552397913e-05,  1.291894707746485e-05,
 -1.144953608482001e-06,  7.772064386037341e-08, -4.301051114801291e-09,  2.018440088865420e-10, -8.253144235154539e-12,  2.998778040642986e-13, -9.828483569472335e-15,
  2.939921894914794e-16, -8.096859388623517e-18,  2.813277172249014e-04, -7.447993080458639e-05,  1.028502995124412e-05, -9.694349166379922e-07,  6.984512352816872e-08,
 -4.094267886823214e-09,  2.031399051415195e-10, -8.765969813980663e-12,  3.355797225586413e-13, -1.156968416922775e-14,  3.635017489674506e-16, -1.049991236536036e-17,
  1.972700919444050e-04, -5.538275483940529e-05,  8.115181755233610e-06, -8.104558646341850e-07,  6.175817743431512e-08, -3.822164795074094e-09,  1.998754127463636e-10,
 -9.075872196192935e-12,  3.650392029270864e-13, -1.320346571784736e-14,  4.346067233763239e-16, -1.313423167441030e-17,  1.384832574717032e-04, -4.104834775332947e-05,
  6.357192966146767e-06, -6.702393471613053e-07,  5.383430998581914e-08, -3.506311803578413e-09,  1.926667772410529e-10, -9.179100860035566e-12,  3.868157024617435e-13,
 -1.463942207861166e-14,  5.035596670971995e-16, -1.588270180091648e-17,  9.745182552697225e-05, -3.037109894308007e-05,  4.952495732967804e-06, -5.492641070112355e-07,
  4.634726437981255e-08, -3.166785780388412e-09,  1.822953674731018e-10, -9.086308527937301e-12,  4.000848617892934e-13, -1.580154715582836e-14,  5.665591929171066e-16,
 -1.860473977176811e-17,  6.882887803537830e-05, -2.246369935424569e-05,  3.842725109833026e-06, -4.467727892108786e-07,  3.947495425799213e-08, -2.820770892326230e-09,
  1.696038882245586e-10, -8.819259820898897e-12,  4.046444602332973e-13, -1.663452952157499e-14,  6.201237665974265e-16, -2.114964175829346e-17,  4.884481354449517e-05,
 -1.663073793808513e-05,  2.973797996524674e-06, -3.612274028485079e-07,  3.331279656917398e-08, -2.481851597915609e-09,  1.554099188735959e-10, -8.406883049605755e-12,
  4.008443384748758e-13, -1.710675630727511e-14,  6.613981072238746e-16, -2.337091659224861e-17,  3.486118188253118e-05, -1.233754900885379e-05,  2.298053201472586e-06,
 -2.906781209647032e-07,  2.789095259352927e-08, -2.159878376924098e-09,  1.404436827607355e-10, -7.881364340994506e-12,  3.894650791567322e-13, -1.721009497618870e-14,
  6.883536337048139e-16, -2.513932028575183e-17,  2.504129754063206e-05, -9.179358465964306e-06,  1.775012893856780e-06, -2.330365274754498e-07,  2.319206157111653e-08,
 -1.861240495840551e-09,  1.253111016752862e-10, -7.274789714119122e-12,  3.715730020306166e-13, -1.695705951939504e-14,  6.998691204025278e-16, -2.635281223665829e-17,
  1.811141892013913e-05, -6.853473634410335e-06,  1.371254645259621e-06, -1.862604628112683e-07,  1.916726195854193e-08, -1.589378806675097e-09,  1.104790811916371e-10,
 -6.616612658108189e-12,  3.483758884753741e-13, -1.637626486876620e-14,  6.957004357593912e-16, -2.694244657088618e-17,  1.319012387978146e-05, -5.135686900445260e-06,
  1.059776135869390e-06, -1.484657840974738e-07,  1.574936587590695e-08, -1.345397903911425e-09,  9.627778976626372e-11, -5.932019767726019e-12,  3.210972061223787e-13,
 -1.550712930508860e-14,  6.763643748245304e-16, -2.687405531035175e-17,  9.667846096917613e-06, -3.861087097682750e-06,  8.191247927106424e-07, -1.179828017561749e-07,
  1.286285577484217e-08, -1.128675195104142e-09,  8.291413739389475e-11, -5.241117163844447e-12,  2.908788911426980e-13, -1.439465613195872e-14,  6.429693930039193e-16,
 -2.614627927652065e-17,  7.122616089727988e-06, -2.908936383213931e-06,  6.324698018984961e-07, -9.337407578534238e-08,  1.043088891343656e-08, -9.374030595438631e-10,
  7.049120973875082e-11, -4.558774284958301e-12,  2.587158072396482e-13, -1.308489397849958e-14,  5.970261837954140e-16, -2.478594657870160e-17,  5.261537381668456e-06,
 -2.191028977653055e-06,  4.867206363112709e-07, -7.342742899478590e-08,  8.379766817911011e-09, -7.690326210733853e-10,  5.902954204573104e-11, -3.894931370976345e-12,
  2.254198637195643e-13, -1.162141690760249e-14,  5.402657094422559e-16, -2.284196457617526e-17,  3.880329921062577e-06, -1.642886747144352e-06,  3.717443323896096e-07,
 -5.713468626727089e-08,  6.641419868335486e-09, -6.206111649913941e-10,  4.848740403424878e-11, -3.255186798109449e-12,  1.916087240246247e-13, -1.004293727414961e-14,
  4.744841615525344e-16, -2.037882422116789e-17,  2.835428070952127e-06, -1.217183178370617e-06,  2.796998557612423e-07, -4.366349838513461e-08,  5.154437767941679e-09,
 -4.890200479790684e-10,  3.877844287260357e-11, -2.641513393700256e-12,  1.577128423510874e-13, -8.381996284660980e-15,  4.014257605150830e-16, -1.747059581395737e-17,
  2.024725182954283e-06, -8.788682748901319e-07,  2.044876420588583e-07, -3.232699739930980e-08,  3.864099220118306e-09, -3.711277266833569e-10,  2.978596790541956e-11,
 -2.052995068686984e-12,  1.239947576889770e-13, -6.664577700387922e-15,  3.227069592181953e-16, -1.419600883583900e-17,  1.374222635692351e-06, -6.015608016149715e-07,
  1.413017835699782e-07, -2.255407492131093e-08,  2.721759766530021e-09, -2.638756596905231e-10,  2.137385462820600e-11, -1.486518761784668e-12,  9.057573019746380e-14,
 -4.910457380003072e-15,  2.397806109228637e-16, -1.063493826245829e-17,  8.286876697727696e-07, -3.648711993186919e-07,  8.626972816200554e-08, -1.386201598136211e-08,
  1.683903744840032e-09, -1.643187156694443e-10,  1.339480987068302e-11, -9.374163519315012e-13,  5.746768612823368e-14, -3.134186581211126e-15,  1.539394176691386e-16,
 -6.866557166188347e-18,  3.454416890294981e-07, -1.525891928733683e-07,  3.620973845154381e-08, -5.839815108757893e-09,  7.120041792423577e-10, -6.973000397913135e-11,
  5.704356599508150e-12, -4.005975233429034e-13,  2.464180862598138e-14, -1.348386298300976e-15,  6.644276565262378e-17, -2.973099321663161e-18,  6.806932134433938e-02,
 -1.935657720710951e-04,  5.746116604783779e-07, -1.764578991055368e-09,  5.550514508368834e-12, -1.773023808119304e-14,  5.713175492803379e-17, -1.848431070334286e-19,
  5.985920554065947e-22, -1.936573424554700e-24,  6.251688352173649e-27, -2.012585274775329e-29,  6.628891820071177e-02, -2.554251118451921e-04,  1.157313397120818e-06,
 -5.354720815837845e-09,  2.427926441134580e-11, -1.072585552723797e-13,  4.627794804710312e-16, -1.956786370271595e-18,  8.131958183007302e-21, -3.328964937625475e-23,
  1.344762151607534e-25, -5.367851228019484e-28,  6.287239637995314e-02, -3.690853243545549e-04,  2.418277407899699e-06, -1.484175375410839e-08,  8.565076262849926e-11,
 -4.714668350708837e-13,  2.499752053520449e-15, -1.284977566944696e-17,  6.433561751243311e-20, -3.148245473287968e-22,  1.509800004937205e-24, -7.111053616859059e-27,
  5.808832004207106e-02, -5.164780666100531e-04,  4.494106895944938e-06, -3.466974538087323e-08,  2.459071985412866e-10, -1.638740026608798e-12,  1.039381901075807e-14,
 -6.328817381134702e-17,  3.722664690560916e-19, -2.125201293215295e-21,  1.181781587936668e-23, -6.419599859943057e-26,  5.229349064827070e-02, -6.750944176210885e-04,
  7.475897493533427e-06, -7.086494608267617e-08,  6.059044610045902e-10, -4.798267659349919e-12,  3.576412247288022e-14, -2.536253935628749e-16,  1.724578273285581e-18,
 -1.130916031631233e-20,  7.184148121419018e-23, -4.436504251004919e-25,  4.588777179244251e-02, -8.221857580417494e-04,  1.132601595224229e-05, -1.298606831358902e-07,
  1.318803155827968e-09, -1.224031359247204e-11,  1.058349263197611e-13, -8.634966675558731e-16,  6.708930959038874e-18, -4.997567158555550e-20,  3.587980024372912e-22,
 -2.492914047275420e-24,  3.926789611662007e-02, -9.386165492973626e-04,  1.583172947474456e-05, -2.167080529962126e-07,  2.582996941484850e-09, -2.779277548121449e-11,
  2.759567749610454e-13, -2.565763745044056e-15,  2.257233892944428e-17, -1.893548948048619e-19,  1.523692533125678e-21, -1.181558298645692e-23,  3.278768835646158e-02,
 -1.011575636181796e-03,  2.061421645686698e-05, -3.330530505549608e-07,  4.612738567999609e-09, -5.702073705544267e-11,  6.447385279418451e-13, -6.777953178144904e-15,
  6.701949059254780e-17, -6.286647390195463e-19,  5.631412013721181e-21, -4.842058314697297e-23,  2.672994480897696e-02, -1.035729982212187e-03,  2.519041135804736e-05,
 -4.755421197425673e-07,  7.586641955016178e-09, -1.069058476460084e-10,  1.366725492133027e-12, -1.613726311848349e-14,  1.782100763923822e-16, -1.858052589694033e-18,
  1.842189025428496e-20, -1.746611082720817e-22,  2.129224466118473e-02, -1.012836006941568e-03,  2.906687283842993e-05, -6.353171441094540e-07,  1.158482697541471e-08,
 -1.848054149865322e-10,  2.654473911433832e-12, -3.499525182506446e-14,  4.292506181027352e-16, -4.948417080575221e-18,  5.403110503757380e-20, -5.621650568575812e-22,
  1.658606419338746e-02, -9.501758954618395e-04,  3.183606168832714e-05, -7.989439185644180e-07,  1.653407688163238e-08, -2.967276777011343e-10,  4.761370016607953e-12,
 -6.971947141321974e-14,  9.451642913848475e-16, -1.199110076161454e-17,  1.435488136132394e-19, -1.631993585652034e-21,  1.264638292962476e-02, -8.583751702199643e-04,
  3.324797259774167e-05, -9.506229335425675e-07,  2.218202560262658e-08, -4.452780123794817e-10,  7.940513080206029e-12, -1.285197814506669e-13,  1.916981810555420e-15,
 -2.665130422312931e-17,  3.483888373809488e-19, -4.311206364886383e-21,  9.447847853616414e-03, -7.491666156863435e-04,  3.324116026208299e-05, -1.075083529852748e-06,
  2.811409282772591e-08, -6.278849815296760e-10,  1.238332159138534e-11, -2.205567428668462e-13,  3.604584035457125e-15, -5.470165503521420e-17,  7.779171502882008e-19,
 -1.044086980691522e-20,  6.923488093384301e-03, -6.335352940203741e-04,  3.193135738177079e-05, -1.160352076978080e-06,  3.381312426249214e-08, -8.359595482172469e-10,
  1.815139170305682e-11, -3.542753124487196e-13,  6.319347660510821e-15, -1.042970132605817e-16,  1.607991087448837e-18, -2.333004673680274e-20,  4.982682117191817e-03,
 -5.204810684332161e-04,  2.956770140889768e-05, -1.199676937139869e-06,  3.874726618893046e-08, -1.055417326654706e-09,  2.512192827861038e-11, -5.352025466694898e-13,
  1.038127419822101e-14, -1.856969577225030e-16,  3.093675363434930e-18, -4.837044924170639e-20,  3.526193063144914e-03, -4.164394879964278e-04,  2.647279574067422e-05,
 -1.192215601071715e-06,  4.246255595139064e-08, -1.268574216497263e-09,  3.296677880770913e-11, -7.637399605012782e-13,  1.605318503336989e-14, -3.102012132122253e-16,
  5.567001722262715e-18, -9.352181402464818e-20,  2.457246666900573e-03, -3.252576885580148e-04,  2.298293735237892e-05, -1.142489357711121e-06,  4.465634412118618e-08,
 -1.456980053937013e-09,  4.117672763666451e-11, -1.033626983239920e-12,  2.346436683417684e-14, -4.882620285233662e-16,  9.411211488414931e-18, -1.693911920981278e-19,
  1.688578528276297e-03, -2.485479797620453e-04,  1.940051793822904e-05, -1.058935482752026e-06,  4.521526848285425e-08, -1.604464280522388e-09,  4.912909402040114e-11,
 -1.331655690140312e-12,  3.254360817936801e-14, -7.270339410712407e-16,  1.500773796978961e-17, -2.886197219009271e-19,  1.146005394836942e-03, -1.862316141816543e-04,
  1.596443488878362e-05, -9.520458996973490e-07,  4.421324605680792e-08, -1.699636587882057e-09,  5.618320134973753e-11, -1.638888139527409e-12,  4.298292494967781e-14,
 -1.027906460606421e-15,  2.266069406768546e-17, -4.644049489418543e-19,  7.693757259918301e-04, -1.371180893018427e-04,  1.283865304417129e-05, -8.325656892803495e-07,
  4.187608940518630e-08, -1.737301148241605e-09,  6.178019848234821e-11, -1.933184202739869e-12,  5.424684448891398e-14, -1.384707822516337e-15,  3.251311993768786e-17,
 -7.082247832887688e-19,  5.117969154960115e-04, -9.941731641322372e-05,  1.011522007948305e-05, -7.100873710942162e-07,  3.852635886886697e-08, -1.718596935449420e-09,
  6.552370115715286e-11, -2.192460443949148e-12,  6.562975528729246e-14, -1.783181331714239e-15,  4.447577486933869e-17, -1.027125468326599e-18,  3.379161051489332e-04,
 -7.113388573355685e-05,  7.826399723978951e-06, -5.921938456544877e-07,  3.452370988728958e-08, -1.650027000821085e-09,  6.722497129968011e-11, -2.397911311665079e-12,
  7.635006139930972e-14, -2.202027453298878e-15,  5.818950013163138e-17, -1.421177883104291e-18,  2.218381022061963e-04, -5.033317147212841e-05,  5.960740571851478e-06,
 -4.841399244540608e-07,  3.021319985896556e-08, -1.541775169980427e-09,  6.690740719832150e-11, -2.536484683761279e-12,  8.565979009483862e-14, -2.615378958417731e-15,
  7.303519050802418e-17, -1.881783037744835e-18,  1.450632592007548e-04, -3.529437225256036e-05,  4.479108482916788e-06, -3.889563250822577e-07,  2.588886954500494e-08,
 -1.405784219582222e-09,  6.477575570421469e-11, -2.602165362521241e-12,  9.294522888211676e-14, -2.996186916886347e-15,  8.819327118140589e-17, -2.391364702716470e-18,
  9.465826754585133e-05, -2.457716007541390e-05,  3.328264404584493e-06, -3.078177111145125e-07,  2.177456787449172e-08, -1.254004809982615e-09,  6.116249554999059e-11,
 -2.595967837375530e-12,  9.779847061471401e-14, -3.319775813272635e-15,  1.027415114865901e-16, -2.924658415584824e-18,  6.174839158835546e-05, -1.703027949968784e-05,
  2.450968580327457e-06, -2.405242106961084e-07,  1.801993062801726e-08, -1.097077667068729e-09,  5.646606375322480e-11, -2.524850803246275e-12,  1.000490647631108e-13,
 -3.566835533706320e-15,  1.157704988266541e-16, -3.451400913867101e-18,  4.034004626475622e-05, -1.176644194735665e-05,  1.792594810577450e-06, -1.859821921560291e-07,
  1.470723274313786e-08, -9.435475977629969e-10,  5.109365271550668e-11, -2.399957248960324e-12,  9.975562623447315e-14, -3.725326292099726e-15,  1.264929995495826e-16,
 -3.939879189658545e-18,  2.643926612502462e-05, -8.121632964785268e-06,  1.304806946546851e-06, -1.426148633686950e-07,  1.186435413696218e-08, -7.995748515591946e-10,
  4.541692415614613e-11, -2.234631200190019e-12,  9.716587478490711e-14, -3.791086436298681e-15,  1.343270275761349e-16, -4.360620578928215e-18,  1.741371545633920e-05,
 -5.610721336656019e-06,  9.470646196017403e-07, -1.086729647406753e-07,  9.479779033631713e-09, -6.690292456936599e-10,  3.974406071773787e-11, -2.042591866128977e-12,
  9.265823818014791e-14, -3.767242650421609e-15,  1.389407099238599e-16, -4.689532619928430e-18,  1.154361336010836e-05, -3.886151870605535e-06,  6.867082315089315e-07,
 -8.244415206792134e-08,  7.516766610417085e-09, -5.538248682002903e-10,  3.430750929278030e-11, -1.836510839265464e-12,  8.667862804170149e-14, -3.662743323759655e-15,
  1.402568250490077e-16, -4.909998693100288e-18,  7.712805384976297e-06, -2.702854164326296e-06,  4.982378783076609e-07, -6.237585245228764e-08,  5.925096014387249e-09,
 -4.543641480204720e-10,  2.926422753153735e-11, -1.627091982625406e-12,  7.968334386650487e-14, -3.490432264935988e-15,  1.384232411684543e-16, -5.013719802336485e-18,
  5.200230487234828e-06, -1.890192215242606e-06,  3.622296574731418e-07, -4.713275782810091e-08,  4.649815088058999e-09, -3.699917826448411e-10,  2.470424485029457e-11,
 -1.422634912059199e-12,  7.209487482411392e-14, -3.265060852991769e-15,  1.337605770464678e-16, -5.000371895428891e-18,  3.541320730764833e-06, -1.330508989429558e-06,
  2.641742143849453e-07, -3.561005392118279e-08,  3.637107201175794e-09, -2.993961653628291e-10,  2.066351740288305e-11, -1.228988794705038e-12,  6.427312553645764e-14,
 -3.001540402124876e-15,  1.266998307379321e-16, -4.876352435507928e-18,  2.437023032236554e-06, -9.432537453491708e-07,  1.933977695364303e-07, -2.692004952022749e-08,
  2.837754992701768e-09, -2.409286812752150e-10,  1.713789119718717e-11, -1.049773162190446e-12,  5.650126242410578e-14, -2.713609289358711e-15,  1.177211700682491e-16,
 -4.652988741557525e-18,  1.694660851746698e-06, -6.735385715516782e-07,  1.421390890317476e-07, -2.036531366382463e-08,  2.208802937083454e-09, -1.928350757160564e-10,
  1.409604511144018e-11, -8.867458141002715e-13,  4.898334988551062e-14, -2.412969607093135e-15,  1.073018038143804e-16, -4.344579836604542e-18,  1.189772695601802e-06,
 -4.840521813674532e-07,  1.048017637332160e-07, -1.540708392955942e-08,  1.713993353172359e-09, -1.534075269947487e-10,  1.149026562931248e-11, -7.402206567541579e-13,
  4.185015246674766e-14, -2.108858573210959e-15,  9.587712052348757e-17, -3.966572666339581e-18,  8.416103813430827e-07, -3.494337338214679e-07,  7.737145193151824e-08,
 -1.163419415842774e-08,  1.323449101515721e-09, -1.210727464524278e-10,  9.264657752099652e-12, -6.094681277918808e-13,  3.516959990860188e-14, -1.807967915914146e-15,
  8.381602655559789e-17, -3.534069668109369e-18,  5.974522952959669e-07, -2.524031361257865e-07,  5.697429592776967e-08, -8.735232034205614e-09,  1.012953424209696e-09,
 -9.443279608328665e-11,  7.360886970256121e-12, -4.930592224525234e-13,  2.895905968624836e-14, -1.514606035966956e-15,  7.140912131036035e-17, -3.060759978222926e-18,
  4.225662746792183e-07, -1.811203023227453e-07,  4.154903313742958e-08, -6.474973647188155e-09,  7.630633394360788e-10, -7.227362460851664e-11,  5.721808824082984e-12,
 -3.891366629468549e-13,  2.319740424911809e-14, -1.231003448197094e-15,  5.886710766060067e-17, -2.558282004028524e-18,  2.937743799414227e-07, -1.273902859913871e-07,
  2.960678999875153e-08, -4.675155151442772e-09,  5.582010450806663e-10, -5.355330329063492e-11,  4.293437354169242e-12, -2.956122297053810e-13,  1.783567369366455e-14,
 -9.576814557992993e-16,  4.632649030087306e-17, -2.035969731001184e-18,  1.953036332105506e-07, -8.544244818405765e-08,  2.005625997072152e-08, -3.199128148060838e-09,
  3.858010328135232e-10, -3.737874439648433e-11,  3.025698342841075e-12, -2.102986567103884e-13,  1.280581689503080e-14, -6.938294297918403e-16,  3.385993092014166e-17,
 -1.500910341237788e-18,  1.160818334687850e-07, -5.109473998766000e-08,  1.207647531461633e-08, -1.939772263009759e-09,  2.355510939976494e-10, -2.297738008956290e-11,
  1.872398154570342e-12, -1.309920980564047e-13,  8.027679409877630e-15, -4.376709398499204e-16,  2.148978420618322e-17, -9.582609021085789e-19,  4.799973053714789e-08,
 -2.119918314840597e-08,  5.029703829159008e-09, -8.110282923282783e-10,  9.886426353398193e-11, -9.680482029479770e-12,  7.917814598309293e-13, -5.559417262490185e-14,
  3.419140722837092e-15, -1.870609623786233e-16,  9.215990803065979e-18, -4.123163177936137e-19,  6.730412003108474e-02, -1.890520953134152e-04,  5.539580966297545e-07,
 -1.678534818778778e-09,  5.209213063039222e-12, -1.641908147257615e-14,  5.221417075897414e-17, -1.667570435549556e-19,  5.331712465372046e-22, -1.703341236056350e-24,
  5.430720689523198e-27, -1.726873717703125e-29,  6.528533692202283e-02, -2.464171865101871e-04,  1.095318671191671e-06, -4.982828603056770e-09,  2.224086979230843e-11,
 -9.678099414278764e-14,  4.114595583263094e-16, -1.714744857032867e-18,  7.024923310273778e-21, -2.835450217244116e-23,  1.129515522721528e-25, -4.446746434179533e-28,
  6.143365151880585e-02, -3.504289083065962e-04,  2.248097902446712e-06, -1.354363484357316e-08,  7.679338246363931e-11, -4.155677430808714e-13,  2.167156547810869e-15,
 -1.096130444374434e-17,  5.401762513862206e-20, -2.602513526222064e-22,  1.229110810335710e-24, -5.702261627393275e-27,  5.609176983703539e-02, -4.821248781871198e-04,
  4.100637787643131e-06, -3.098445422808893e-08,  2.154900453778911e-10, -1.409274643747273e-12,  8.777643747574516e-15, -5.251377851527941e-17,  3.036289092323110e-19,
 -1.704470186315755e-21,  9.323235798129908e-24, -4.983117237414209e-26,  4.970756502094729e-02, -6.185309509924357e-04,  6.680662842439981e-06, -6.189386806622779e-08,
  5.179779766675222e-10, -4.019268041701644e-12,  2.937776095288442e-14, -2.044343873865397e-16,  1.364793060856999e-18, -8.790919821364827e-21,  5.487445971908126e-23,
 -3.331024948986650e-25,  4.277085857615121e-02, -7.374699765098823e-04,  9.886639842148897e-06, -1.105880784633684e-07,  1.097557522270798e-09, -9.967719168060051e-12,
  8.441072436257973e-14, -6.750280739050898e-16,  5.143727207451046e-18, -3.759904708725863e-20,  2.650094222452896e-22, -1.808373254005514e-24,  3.575120675703588e-02,
 -8.217021475603981e-04,  1.346195958106227e-05, -1.794901327066966e-07,  2.087948463309327e-09, -2.195618993699007e-11,  2.132813316289474e-13, -1.941701019773999e-15,
  1.673790200289886e-17, -1.376636613530633e-19,  1.086635250260882e-21, -8.269606330635314e-24,  2.904756477533847e-02, -8.614752988896784e-04,  1.702532607434181e-05,
 -2.675922317789186e-07,  3.612857741823954e-09, -4.360151702473795e-11,  4.818656210750984e-13, -4.955816889909705e-15,  4.797624399291665e-17, -4.408977969174390e-19,
  3.871489341280389e-21, -3.264773567296340e-23,  2.295664300066440e-02, -8.551207827035886e-04,  2.014704525249721e-05, -3.696213515580182e-07,  5.743025309011638e-09,
 -7.893921912231561e-11,  9.855975129570798e-13, -1.137634851757846e-14,  1.229187744102840e-16, -1.254769561519611e-18,  1.218787875989330e-20, -1.132704595364831e-22,
  1.766179115810574e-02, -8.079051372413871e-04,  2.244360402821210e-05, -4.763745449469423e-07,  8.453797212121218e-09, -1.314550827928162e-10,  1.842845572399350e-12,
 -2.373642680588480e-14,  2.847017684882693e-16, -3.211761639272329e-18,  3.434021414703124e-20, -3.500734609755954e-22,  1.323981937724183e-02, -7.297531909961704e-04,
  2.365860187109700e-05, -5.762732762041846e-07,  1.160023282928313e-08, -2.028252974982336e-10,  3.174917959614290e-12, -4.539966866032884e-14,  6.015823534386018e-16,
 -7.465765882388374e-18,  8.748626078635889e-20, -9.742050713791786e-22,  9.680305922563893e-03, -6.326029344346093e-04,  2.370656324886702e-05, -6.577098512516553e-07,
  1.492309094547128e-08, -2.917553635179574e-10,  5.073750092924341e-12, -8.017005680356896e-14,  1.168481838831958e-15, -1.588664077406988e-17,  2.032331438392159e-19,
 -2.462762081581079e-21,  6.910991627046809e-03, -5.280533303995144e-04,  2.267179435002180e-05, -7.114583490742599e-07,  1.808852456490137e-08, -3.933833774829482e-10,
  7.564656963723911e-12, -1.315100333063968e-13,  2.099831208668909e-15, -3.115830743628140e-17,  4.335750806678965e-19, -5.697823172398552e-21,  4.823545970383472e-03,
 -4.257162615937229e-04,  2.076981595321126e-05, -7.324282276570418e-07,  2.075161431001801e-08, -4.995825524366759e-10,  1.057637533454307e-11, -2.014834093438513e-13,
  3.511123771520390e-15, -5.666000734828268e-17,  8.547435798133358e-19, -1.214236805807283e-20,  3.295669741041669e-03, -3.323988992396575e-04,  1.828840226117079e-05,
 -7.203196923861473e-07,  2.262494347231181e-08, -6.001965107659568e-10,  1.393090892713647e-11, -2.897077558011583e-13,  5.490449778580495e-15, -9.603536600934540e-17,
  1.565622511176090e-18, -2.397001101871720e-20,  2.207467223884985e-03, -2.520148667401253e-04,  1.552699355685003e-05, -6.791428485843529e-07,  2.353216656504892e-08,
 -6.849002714628092e-10,  1.736035901250618e-11, -3.926851020023644e-13,  8.066200229470600e-15, -1.524436436342447e-16,  2.677684335197876e-18, -4.405673608888572e-20,
  1.451728453750677e-03, -1.859962191470763e-04,  1.274877836189422e-05, -6.159089260938267e-07,  2.343288767122448e-08, -7.451549423070980e-10,  2.054884678320819e-11,
 -5.038167225528907e-13,  1.118078011290003e-14, -2.276210604321615e-16,  4.295465557824692e-18, -7.574377258102822e-20,  9.389197849511583e-04, -1.339520549003795e-04,
  1.015238815192247e-05, -5.389747730243030e-07,  2.241563707071937e-08, -7.757091067627989e-10,  2.318875707981096e-11, -6.142042644448607e-13,  1.468036364892202e-14,
 -3.210020496277053e-16,  6.490107805842210e-18, -1.223284024999079e-19,  5.982432942795237e-04, -9.436325523725751e-05,  7.863169050965954e-06, -4.565023348596877e-07,
  2.066560597128793e-08, -7.752842653919220e-10,  2.503573958028403e-11, -7.140757722075104e-13,  1.832671250083875e-14, -4.291958885695376e-16,  9.272153160086294e-18,
 -1.863304004596649e-19,  3.762085420058215e-04, -6.517786387334879e-05,  5.939389867681950e-06, -3.753423011493301e-07,  1.841955893611399e-08, -7.463682503413033e-10,
  2.594799769869982e-11, -7.944643518596308e-13,  2.183019516862566e-14, -5.460459262974385e-16,  1.257182752037250e-17, -2.686859546801162e-19,  2.339454328029726e-04,
 -4.424632719760310e-05,  4.387004317566017e-06, -3.004552703066872e-07,  1.592093245440223e-08, -6.943051521470542e-10,  2.590139458342750e-11, -8.486956733942369e-13,
  2.489621010229040e-14, -6.633318549774454e-16,  1.623416298333423e-17, -3.680916988773845e-19,  1.441465996458988e-04, -2.959205125348038e-05,  3.177103643954108e-06,
 -2.348199559447669e-07,  1.338472287048996e-08, -6.260229129564532e-10,  2.497988096706941e-11, -8.733268438880081e-13,  2.727307933812634e-14, -7.719742823293442e-16,
  2.003245841177428e-17, -4.807188829014849e-19,  8.818566442954593e-05, -1.954522519692255e-05,  2.261925039087990e-06, -1.796840661837439e-07,  1.097663983249489e-08,
 -5.487547537868255e-10,  2.334749041887341e-11, -8.683729631398855e-13,  2.878962087517684e-14, -8.634463844550412e-16,  2.369812574581232e-17, -6.004314808230766e-19,
  5.368106129584712e-05, -1.277987839063389e-05,  1.587257825796766e-06, -1.349906049886195e-07,  8.806286522304917e-09, -4.690199248268880e-10,  2.121160607010528e-11,
 -8.368728869472343e-13,  2.937456205923456e-14, -9.310476099693583e-16,  2.696005135495084e-17, -7.195000580138422e-19,  3.258509979962011e-05, -8.292566245268776e-06,
  1.100701788303838e-06, -9.983900986637163e-08,  6.931078285391380e-09, -3.919925052291626e-10,  1.878705114860805e-11, -7.840047598774442e-13,  2.905579286829941e-14,
 -9.707589161824865e-16,  2.958406984707705e-17, -8.296591482951862e-19,  1.976737993609179e-05, -5.352806606314800e-06,  7.562469012427863e-07, -7.288932458243077e-08,
  5.366481981853009e-09, -3.212599051727161e-10,  1.626783445681340e-11, -7.160256140752015e-13,  2.794287001637340e-14, -9.815409449881959e-16,  3.140374382897136e-17,
 -9.232633649797388e-19,  1.201077410243559e-05, -3.445484396164150e-06,  5.160964202101519e-07, -5.266653251936771e-08,  4.098513705837653e-09, -2.588884545118001e-10,
  1.380968443146292e-11, -6.392824702366064e-13,  2.619951240463926e-14, -9.650958189286374e-16,  3.233680117664737e-17, -9.942858893856867e-19,  7.325471416562059e-06,
 -2.216782630404442e-06,  3.507094583918406e-07, -3.775907522330408e-08,  3.095576577545594e-09, -2.056794659200202e-10,  1.152321324269692e-11, -5.594588639980620e-13,
  2.401355572170480e-14, -9.252356773772734e-16,  3.238586981254829e-17, -1.038967504206477e-18,  4.494391411682117e-06, -1.428886998452912e-06,  2.378772198473658e-07,
 -2.692714752978118e-08,  2.318031020127240e-09, -1.615049436600523e-10,  9.475429612425612e-12, -4.811220765355783e-13,  2.157045410013134e-14, -8.670579932330855e-16,
  3.162601199267725e-17, -1.056033022870912e-18,  2.779489312775262e-06, -9.247545978025852e-07,  1.614115479241363e-07, -1.914484234064500e-08,  1.724976346167070e-09,
 -1.256400727947590e-10,  7.696491792594049e-12, -4.075546183454811e-13,  1.903394959211797e-14, -7.961197055148666e-16,  3.018393700364370e-17, -1.046503409198062e-18,
  1.735979230358606e-06, -6.021356617090974e-07,  1.098016612945436e-07, -1.360003810880312e-08,  1.278432612267599e-09, -9.704359113615591e-11,  6.188764396845001e-12,
 -3.408040652022607e-13,  1.653499385626798e-14, -7.177502211658221e-16,  2.821435946065499e-17, -1.013212873861991e-18,  1.096849515589370e-06, -3.951787028388351e-07,
  7.502299753286461e-08, -9.671383325959766e-09,  9.454611985491173e-10, -7.456653761364907e-11,  4.935965471425399e-12, -2.818684289540595e-13,  1.416808093139999e-14,
 -6.365749594919164e-16,  2.587810932218820e-17, -9.601755977052864e-19,  7.020772259346063e-07, -2.618104761716837e-07,  5.156760443270417e-08, -6.895957233051668e-09,
  6.988478635863291e-10, -5.709012969861240e-11,  3.911061884442629e-12, -2.309411009174614e-13,  1.199308949294047e-14, -5.562592343633830e-16,  2.332495453708484e-17,
 -8.919394333975795e-19,  4.557170393022106e-07, -1.752908218519390e-07,  3.569937627196502e-08, -4.935952250302797e-09,  5.169040709272231e-10, -4.360448793182694e-11,
  3.082331366636430e-12, -1.876586880431770e-13,  1.004045794169798e-14, -4.794396681422410e-16,  2.068233459848428e-17, -8.130284965774426e-19,  3.001019265879505e-07,
 -1.186709211110124e-07,  2.490558438727467e-08, -3.548752571790534e-09,  3.828108390654952e-10, -3.324371423974587e-11,  2.417544804460718e-12, -1.513172137010936e-13,
  8.317774864397486e-15, -4.077897599976256e-16,  1.804978537739096e-17, -7.275306171052923e-19,  2.004197693312171e-07, -8.121156074523931e-08,  1.750553270085536e-08,
 -2.562145284643240e-09,  2.837916539334190e-10, -2.529214978142815e-11,  1.886525626252663e-12, -1.210412028830342e-13,  6.816382879137736e-15, -3.421637089798888e-16,
  1.549796158816157e-17, -6.388435005161168e-19,  1.355231290529247e-07, -5.609438866191625e-08,  1.237794506480113e-08, -1.854857565888827e-09,  2.102857967667686e-10,
 -1.917381362852937e-11,  1.462463250837603e-12, -9.590361589575721e-14,  5.517148045610483e-15, -2.827713625176558e-16,  1.307081793329808e-17, -5.495632429076120e-19,
  9.245860582438357e-08, -3.897104488274068e-08,  8.774453999595488e-09, -1.341844270769358e-09,  1.552096765782623e-10, -1.443364532094492e-11,  1.122359350667549e-12,
 -7.500236960060429e-14,  4.395011444915320e-15, -2.293507104769839e-16,  1.078955735744171e-17, -4.614826170262782e-19,  6.320625648177003e-08, -2.704784437389955e-08,
  6.193638386338420e-09, -9.634643911349009e-10,  1.133393629345705e-10, -1.071612029044894e-11,  8.469263043257125e-13, -5.750247934033778e-14,  3.422265019628510e-15,
 -1.813179650265005e-16,  8.657225939745813e-18, -3.756622700351866e-19,  4.272897952440878e-08, -1.850917913938370e-08,  4.296641062844500e-09, -6.776653968521979e-10,
  8.081597728010645e-11, -7.744431365363941e-12,  6.201772292774801e-13, -4.265320806061410e-14,  2.570684239575251e-15, -1.378863920817478e-16,  6.663184792019128e-18,
 -2.925418063668916e-19,  2.779739564603523e-08, -1.215333788609768e-08,  2.850793194379395e-09, -4.543990041082134e-10,  5.475981830001669e-11, -5.301775574045642e-12,
  4.288705901162554e-13, -2.978841868619497e-14,  1.812737585935227e-15, -9.815296570651804e-17,  4.787029470440905e-18, -2.120659912732511e-19,  1.627341921653529e-08,
 -7.160575554153299e-09,  1.691805103025439e-09, -2.716418280417835e-10,  3.297371064157929e-11, -3.215305548001033e-12,  2.619158100080662e-13, -1.831695562113433e-14,
  1.122136999974180e-15, -6.115813401913533e-17,  3.001872062134928e-18, -1.338137806009807e-19,  6.672284529785676e-09, -2.946347436703193e-09,  6.989182881392679e-10,
 -1.126775335654507e-10,  1.373276612847794e-11, -1.344416050553614e-12,  1.099413250670709e-13, -7.718001809821870e-15,  4.745845894590900e-16, -2.595983800420134e-17,
  1.278745486127651e-18, -5.720015469707440e-20,  6.655664937871270e-02, -1.846996078281140e-04,  5.343051429616066e-07, -1.597747929079353e-09,  4.892994358405332e-12,
 -1.522009899075238e-14,  4.777490629586139e-17, -1.506362042685007e-19,  4.755847750577448e-22, -1.500566535966323e-24,  4.725661396149777e-27, -1.484469299408064e-29,
  6.431682293058665e-02, -2.378879070974734e-04,  1.037597670474550e-06, -4.641938981316527e-09,  2.040023855203677e-11, -8.745762982215128e-14,  3.664464155839964e-16,
 -1.505444373805643e-18,  6.080984979391543e-21, -2.420447482020267e-23,  9.509835703531741e-26, -3.693092420256825e-28,  6.006690481414437e-02, -3.330739455664808e-04,
  2.092681051497898e-06, -1.237870653598731e-08,  6.897825887785989e-11, -3.670519860084525e-13,  1.883096351390831e-15, -9.373626093614628e-18,  4.547626406702137e-20,
 -2.157578602289544e-22,  1.003675996865169e-24, -4.587444728004169e-27,  5.422660572510024e-02, -4.507504865340745e-04,  3.748617016791762e-06, -2.775113227754005e-08,
  1.892975284146280e-10, -1.215212127722574e-12,  7.434548460530685e-15, -4.371153079817862e-17,  2.484841046581752e-19, -1.371942503045006e-21,  7.383141685804532e-24,
 -3.883511802726245e-26,  4.733581903956612e-02, -5.679215336238243e-04,  5.985128574267183e-06, -5.421285575498857e-08,  4.442039385925007e-10, -3.378234596941103e-12,
  2.422031101950141e-14, -1.654280324827794e-16,  1.084536154228426e-18, -6.863205727450607e-21,  4.210618518374603e-23, -2.512952788073769e-25,  3.997116256388740e-02,
 -6.634010162973316e-04,  8.658709492131614e-06, -9.451802855471813e-08,  9.170218222228539e-10, -8.151252723413871e-12,  6.762457410211911e-14, -5.301860441474820e-16,
  3.963234127958842e-18, -2.843411701312094e-20,  1.967935986979134e-22, -1.319159656450564e-24,  3.266690821128678e-02, -7.220857293342264e-04,  1.149488284751159e-05,
 -1.493352807537384e-07,  1.695902810263959e-09, -1.743362130915291e-11,  1.657231730918927e-13, -1.477656962959283e-15,  1.248397148577084e-17, -1.006900397520028e-19,
  7.798080321860288e-22, -5.825340615582465e-24,  2.585503661851841e-02, -7.371968342322082e-04,  1.413419024838478e-05, -2.161786339546642e-07,  2.846073381313859e-09,
 -3.354207760756820e-11,  3.624078174207987e-13, -3.647246623191151e-15,  3.457668331705363e-17, -3.113744186896324e-19,  2.680742554117557e-21, -2.217577032865339e-23,
  1.983247839797948e-02, -7.102362872804400e-04,  1.621470496787737e-05, -2.891788120689961e-07,  4.377114276168770e-09, -5.870145883373351e-11,  7.159548449442769e-13,
 -8.080559833816764e-15,  8.544031212484228e-17, -8.541169752299312e-19,  8.129321095469557e-21, -7.407138204653050e-23,  1.475606501354522e-02, -6.491081006083507e-04,
  1.745912219214262e-05, -3.599522621306213e-07,  6.218043686609549e-09, -9.427080074112139e-11,  1.290118760006425e-12, -1.623830415194100e-14,  1.904904661716548e-16,
 -2.103318411150704e-18,  2.202541471289361e-20, -2.200342309243836e-22,  1.065962694514852e-02, -5.652736236896597e-04,  1.773539784999188e-05, -4.193775326076311e-07,
  8.213010968670955e-09, -1.399323530045397e-10,  2.137200849963986e-12, -2.984974878166023e-14,  3.866750387880802e-16, -4.694870026340697e-18,  5.386187692043995e-20,
 -5.875544238359830e-22,  7.484408906004234e-03, -4.708654062649611e-04,  1.707361862302548e-05, -4.596985421719467e-07,  1.014364068890610e-08, -1.931744663675827e-10,
  3.276556736064367e-12, -5.055050489761207e-14,  7.200418389377397e-16, -9.574932279392406e-18,  1.198865847939458e-19, -1.422803673869433e-21,  5.113687595153822e-03,
 -3.764484562743549e-04,  1.563999384606330e-05, -4.762465405441891e-07,  1.177335310353298e-08, -2.493538911115888e-10,  4.675765254812804e-12, -7.935156300892579e-14,
  1.237990084720155e-15, -1.796365598478233e-17,  2.446160290471135e-19, -3.147828305876660e-21,  3.404403163840766e-03, -2.897482847311176e-04,  1.368304284117509e-05,
 -4.682557263808221e-07,  1.289972962453220e-08, -3.024241086690948e-10,  6.242787721175717e-12, -1.160863309554713e-13,  1.976478153045910e-15, -3.118755765335967e-17,
  4.603785425021504e-19, -6.403890627451676e-21,  2.211563017341116e-03, -2.153196900430844e-04,  1.147251752958252e-05, -4.386240046582587e-07,  1.339784741796372e-08,
 -3.461515860664447e-10,  7.834591606319884e-12, -1.590456082035594e-13,  2.945066776026656e-15, -5.037305889789229e-17,  8.036200383415971e-19, -1.204807906218121e-20,
  1.404053544985261e-03, -1.549076310850615e-04,  9.248583673217477e-06, -3.928462903762635e-07,  1.324167775451285e-08, -3.754425312078827e-10,  9.281768088819504e-12,
 -2.049849602258595e-13,  4.114779949947042e-15, -7.605671465890913e-17,  1.307534581329100e-18, -2.106983156023533e-20,  8.726133131386004e-04, -1.081755836408064e-04,
  7.190879914992960e-06, -3.375672634724710e-07,  1.249952159382571e-08, -3.873651321407417e-10,  1.042238651215378e-11, -2.495706169408297e-13,  5.414008901913067e-15,
 -1.078274612163176e-16,  1.992085237617153e-18, -3.441220520814283e-20,  5.318569680492019e-04, -7.351488555615685e-05,  5.408629227612324e-06, -2.792130991824299e-07,
  1.130854923620724e-08, -3.815843950701265e-10,  1.113474635742273e-11, -2.881675556395091e-13,  6.735517359667714e-15, -1.441381479894645e-16,  2.854066498905876e-18,
 -5.271853652645722e-20,  3.185198536153190e-04, -4.874477334141999e-05,  3.947044442579353e-06, -2.230177871081286e-07,  9.839064146933346e-09, -3.601526956474741e-10,
  1.135939430345148e-11, -3.167429668915737e-13,  7.953770719313762e-15, -1.823869567818881e-16,  3.860681067952286e-18, -7.606566929503347e-20,  1.878158581377414e-04,
 -3.161620039267480e-05,  2.802867787100664e-06, -1.725577923571138e-07,  8.259762823171701e-09, -3.268108652657299e-10,  1.110512625164156e-11, -3.326198324399472e-13,
  8.948017585981320e-15, -2.192828696916017e-16,  4.949543567801994e-18, -1.037699025271200e-19,  1.092741719864459e-04, -2.011195631305955e-05,  1.942400962477163e-06,
 -1.297377775963789e-07,  6.712053730181181e-09, -2.860711254017580e-10,  1.043941809554425e-11, -3.348805838840119e-13,  9.624529204388938e-15, -2.514094432434968e-16,
  6.036120640671441e-18, -1.343446000215855e-19,  6.287458555125419e-05, -1.258092773321495e-05,  1.317469924251639e-06, -9.507579541445015e-08,  5.296706426240910e-09,
 -2.423526902459084e-10,  9.468319300524649e-12, -3.243517620655323e-13,  9.931957817300620e-15, -2.758322568503055e-16,  7.027120274127044e-18, -1.656468452694998e-19,
  3.586177884216103e-05, -7.759863329813536e-06,  8.771458818872812e-07, -6.811989651293782e-08,  4.071872531461747e-09, -1.993548731836488e-10,  8.312800525680899e-12,
 -3.032355964916391e-13,  9.866450284179951e-15, -2.905860999562815e-16,  7.836331784745533e-18, -1.951899286789424e-19,  2.032607747697187e-05, -4.732236790434623e-06,
  5.749120546060523e-07, -4.786341827965351e-08,  3.059037675984275e-09, -1.597362920194138e-10,  7.087811990186274e-12, -2.745418215972952e-13,  9.466613667633853e-15,
 -2.949273852221825e-16,  8.398725557147414e-18, -2.205441805766133e-19,  1.147729534691097e-05, -2.861238928128084e-06,  3.720517286759883e-07, -3.308116029028498e-08,
  2.252850321189738e-09, -1.250705671487953e-10,  5.887889106684167e-12, -2.414923323381143e-13,  8.801244684789128e-15, -2.893190440761645e-16,  8.679432010433317e-18,
 -2.397228931012390e-19,  6.473132308512679e-06, -1.720018455464450e-06,  2.384256351065969e-07, -2.255903534379392e-08,  1.631470068373000e-09, -9.599339969926748e-11,
  4.780357601740922e-12, -2.070337815761697e-13,  7.954042627723058e-15, -2.751938178485639e-16,  8.676049971926920e-18, -2.514610056598650e-19,  3.656107844572309e-06,
 -1.030918267717045e-06,  1.517474568922964e-07, -1.522395198765325e-08,  1.165335174402894e-09, -7.244376044203256e-11,  3.805045000250436e-12, -1.735279789467550e-13,
  7.009259459883051e-15, -2.545904733766827e-16,  8.414762461295818e-18, -2.553337110469210e-19,  2.073469790525996e-06, -6.177933957345070e-07,  9.619820371426419e-08,
 -1.019733139936848e-08,  8.234724179605944e-10, -5.391927943446008e-11,  2.978316978027801e-12, -1.426264127905356e-13,  6.040932106927917e-15, -2.297670189746308e-16,
  7.942226084881270e-18, -2.517118245190200e-19,  1.183816442097165e-06, -3.711827216188155e-07,  6.091479515757906e-08, -6.799116578338353e-09,  5.773511379739726e-10,
 -3.969553920050645e-11,  2.299134199277647e-12, -1.152918830617946e-13,  5.106721148356047e-15, -2.028730826575873e-16,  7.315786102876050e-18, -2.415919463107411e-19,
  6.821554301621027e-07, -2.241919379425838e-07,  3.863500345089836e-08, -4.525158001656850e-09,  4.027539909047217e-10, -2.898752846351768e-11,  1.755309884288944e-12,
 -9.191205142782242e-14,  4.246033554691671e-15, -1.757264264739137e-16,  6.594308431771328e-18, -2.263608388347460e-19,  3.976915844039578e-07, -1.364723979643872e-07,
  2.460770136981956e-08, -3.014199516069423e-09,  2.802813443466794e-10, -2.105214350584156e-11,  1.328852916067010e-12, -7.245179592867257e-14,  3.481318149811888e-15,
 -1.497019783402932e-16,  5.831139629519664e-18, -2.075536081493379e-19,  2.350947876765267e-07, -8.392295201305511e-08,  1.577727627825178e-08, -2.014255546435097e-09,
  1.950523589571967e-10, -1.524195727001171e-11,  9.999281016894577e-13, -5.660468212705776e-14,  2.821192089326837e-15, -1.257157743506702e-16,  5.069796152010745e-18,
 -1.866502948771901e-19,  1.411956554080463e-07, -5.224221448992302e-08,  1.020409634799605e-08, -1.353247792455587e-09,  1.360269419836405e-10, -1.102431782566574e-11,
  7.494216768338086e-13, -4.392034493016576e-14,  2.264219944095094e-15, -1.042737994301275e-16,  4.342238500013252e-18, -1.649343035407687e-19,  8.628901372775244e-08,
 -3.297493269359851e-08,  6.668513651218768e-09, -9.155737191815557e-10,  9.522356567017414e-11, -7.979024974320380e-12,  5.603482635714487e-13, -3.389874398905250e-14,
  1.802517709117147e-15, -8.555471882590101e-17,  3.669139413073202e-18, -1.434164929451166e-19,  5.371190286356303e-08, -2.112673521747813e-08,  4.408302905560440e-09,
 -6.245093962873509e-10,  6.698545582366339e-11, -5.784902169487639e-12,  4.184198075896443e-13, -2.605187091594740e-14,  1.424726504711482e-15, -6.950145654559532e-17,
  3.061404397407086e-18, -1.228151666982963e-19,  3.405883595684268e-08, -1.374254142961214e-08,  2.948566800181064e-09, -4.295586768883284e-10,  4.736249177777533e-11,
 -4.202241897899775e-12,  3.120801952407122e-13, -1.993854903543736e-14,  1.118199619143924e-15, -5.590512443708784e-17,  2.522264479257153e-18, -1.035756843545075e-19,
  2.197628106612106e-08, -9.066559547752847e-09,  1.993470224657490e-09, -2.976485245871942e-10,  3.362473409575872e-11, -3.055246572468359e-12,  2.322457802608264e-13,
 -1.517959088557692e-14,  8.704401008653022e-16, -4.447287147101814e-17,  2.049431875536178e-18, -8.591268602564639e-20,  1.438492261373845e-08, -6.048575043435436e-09,
  1.358213707104477e-09, -2.071476828948777e-10,  2.389698341620738e-11, -2.216513611939846e-12,  1.719185528364228e-13, -1.146012584773832e-14,  6.699233681886035e-16,
 -3.487728444182078e-17,  1.637004350315840e-18, -6.986076501420213e-20,  9.490585829320063e-09, -4.054422591919622e-09,  9.266616165813294e-10, -1.438743493885608e-10,
  1.689318164686942e-11, -1.594290110458257e-12,  1.257744928545309e-13, -8.524510442045094e-15,  5.064671027287250e-16, -2.678870676328785e-17,  1.276971481826807e-18,
 -5.532370865812676e-20,  6.230814219789218e-09, -2.696049152712447e-09,  6.250722902994345e-10, -9.846266783745539e-11,  1.172775556393686e-11, -1.122480095119435e-12,
  8.978169702718998e-14, -6.167632730648079e-15,  3.712977877836672e-16, -1.989361743440383e-17,  9.602949340347691e-19, -4.211665768425132e-20,  3.962502884539879e-09,
 -1.731312701098097e-09,  4.058115066246949e-10, -6.463544649150700e-11,  7.783470628948777e-12, -7.530365344442481e-13,  6.087104717889132e-14, -4.225017089539408e-15,
  2.569326318452850e-16, -1.390265705912074e-17,  6.776059259704529e-19, -2.999895736166950e-20,  2.283229090030411e-09, -1.004313689018919e-09,  2.371936202206726e-10,
 -3.806956044783155e-11,  4.619327186554326e-12, -4.502619429097304e-13,  3.666398736698699e-14, -2.563122479971277e-15,  1.569651351278050e-16, -8.551768874376168e-18,
  4.196057700587439e-19, -1.869825945603168e-20,  9.278709418836929e-10, -4.096601383936532e-10,  9.715891960779974e-11, -1.566059533178935e-11,  1.908286918347340e-12,
 -1.867818840162388e-13,  1.527138448071095e-14, -1.071864257054741e-15,  6.589722915150776e-17, -3.603921059660538e-18,  1.774918184191427e-19, -7.938048605720882e-21,
  6.582628024975509e-02, -1.805005504273491e-04,  5.155920479616933e-07, -1.521834340449281e-09,  4.599725393754708e-12, -1.412244393118842e-14,  4.376228637869523e-17,
 -1.362465750465888e-19,  4.248152302961423e-22, -1.323972627946933e-24,  4.119035801652665e-27, -1.278403334322758e-29,  6.338152773981412e-02, -2.298045198405389e-04,
  9.837966132044413e-07, -4.329064485414943e-09,  1.873572906545490e-11, -7.914753597122659e-14,  3.268923156165093e-16, -1.324091096935654e-18,  5.274353948533881e-21,
 -2.070644662159934e-23,  8.025308424665875e-26, -3.074794949948068e-28,  5.876717691865506e-02, -3.169084553785672e-04,  1.950523948906488e-06, -1.133141352174574e-08,
  6.206872328126261e-11, -3.248496791821619e-13,  1.639893543966169e-15, -8.035291831197571e-18,  3.838551673124203e-20, -1.793724271513243e-22,  8.220369912765354e-25,
 -3.702267620754301e-27,  5.248154289704363e-02, -4.220439019605711e-04,  3.433004256371422e-06, -2.490751164561674e-08,  1.666828969156040e-10, -1.050615198728142e-12,
  6.314909333413990e-15, -3.649646100279554e-17,  2.040226457500700e-19, -1.108142678938083e-21,  5.868338333490550e-24, -3.038303470406000e-26,  4.515593883882735e-02,
 -5.225268358987945e-04,  5.375086415646799e-06, -4.761603412045838e-08,  3.820962702136656e-10, -2.848826458253935e-12,  2.003925271368556e-14, -1.343714735219861e-16,
  8.652898225378037e-19, -5.380884614391019e-21,  3.245231907873990e-23, -1.904592990527025e-25,  3.744925097400578e-02, -5.984306168360628e-04,  7.607419867887126e-06,
 -8.106649853033291e-08,  7.690944439993890e-10, -6.692968599897960e-12,  5.441121625293659e-14, -4.183280199475051e-16,  3.068343646002225e-18, -2.161130975894823e-20,
  1.469031953368516e-22, -9.675336100844433e-25,  2.995175191507580e-02, -6.368586362478620e-04,  9.854823401622422e-06, -1.247874081933282e-07,  1.383872452786925e-09,
 -1.391076176156518e-11,  1.294368454977043e-13, -1.130615088344813e-15,  9.363858630863525e-18, -7.407983041660519e-20,  5.630277842418319e-22, -4.129375038334901e-24,
  2.311699609102693e-02, -6.337738320413689e-04,  1.179257299223893e-05, -1.755682105822867e-07,  2.254542516784419e-09, -2.595439785937408e-11,  2.742272945222188e-13,
 -2.701217808850168e-15,  2.508320476868583e-17, -2.213930745905591e-19,  1.869208275709353e-21, -1.517104992316529e-23,  1.723056131324616e-02, -5.932921766261064e-04,
  1.312884586124229e-05, -2.276753234824978e-07,  3.358071388401495e-09, -4.395097437546421e-11,  5.237669899502701e-13, -5.781548225067682e-15,  5.983626996993852e-17,
 -5.858904925601963e-19,  5.465260380091645e-21, -4.883101008327075e-23,  1.241383389316998e-02, -5.251546055975627e-04,  1.367946357354047e-05, -2.740076123465080e-07,
  4.608711409806489e-09, -6.813953080702983e-11,  9.105135669054076e-13, -1.120137783912973e-14,  1.285425964220576e-16, -1.389437073298835e-18,  1.425263277186756e-20,
 -1.395550380815072e-22,  8.653320697243828e-03, -4.414825294613922e-04,  1.340726871186908e-05, -3.078325011424329e-07,  5.866206725747726e-09, -9.741329797701531e-11,
  1.451924913197659e-12, -1.981039991751720e-14,  2.509209634016803e-16, -2.981154057063754e-18,  3.348909743694679e-20, -3.579247382669207e-22,  5.842728391275490e-03,
 -3.538509954468969e-04,  1.241616020667166e-05, -3.244737500659952e-07,  6.964092440415661e-09, -1.292066128881592e-10,  2.137852682581417e-12, -3.220887179401554e-14,
  4.484283032066170e-16, -5.833095616122891e-18,  7.149308196571766e-20, -8.310742768342574e-22,  3.826005884120919e-03, -2.713288403053395e-04,  1.090856845107135e-05,
 -3.223542428646757e-07,  7.749315380052857e-09, -1.598572587188976e-10,  2.923362618376261e-12, -4.843601043214065e-14,  7.384389678535656e-16, -1.047917072464833e-17,
  1.396566356267497e-19, -1.759996579656226e-21,  2.433159218164210e-03, -1.996632932560661e-04,  9.126381019345102e-06, -3.030960130861700e-07,  8.119189169888027e-09,
 -1.853780581526561e-10,  3.731511522725464e-12, -6.773604126843217e-14,  1.126852364433546e-15, -1.738787988422269e-17,  2.511800304329093e-19, -3.421401672329157e-21,
  1.505035490064144e-03, -1.414158706792484e-04,  7.296137427834867e-06, -2.707683806101285e-07,  8.043061404001515e-09, -2.023883983125903e-10,  4.466951753538796e-12,
 -8.852274503609478e-14,  1.601653524721713e-15, -2.678961216796094e-17,  4.182441949080101e-19, -6.140399185756775e-21,  9.069648745037951e-04, -9.667458862667085e-05,
  5.592291531583100e-06, -2.306597737551260e-07,  7.562889700561498e-09, -2.088854303851545e-10,  5.036648808534035e-12, -1.086006253876574e-13,  2.130359395071796e-15,
 -3.851159724850890e-17,  6.479931178741604e-19, -1.022659149789144e-20,  5.334318602137060e-04, -6.396290938987752e-05,  4.122655688238915e-06, -1.880273101600888e-07,
  6.775311333169447e-09, -2.046089384028910e-10,  5.370883580113061e-12, -1.255990982655247e-13,  2.663266039181539e-15, -5.188881476980763e-17,  9.384544490782127e-19,
 -1.588059040686116e-20,  3.067972022500968e-04, -4.106986200372873e-05,  2.932319326029442e-06, -1.471697478290085e-07,  5.803708306379755e-09, -1.909255916774497e-10,
  5.437659006810026e-12, -1.374861121966711e-13,  3.142270085816130e-15, -6.580342438625441e-17,  1.275959895875773e-18, -2.309532309941690e-20,  1.729057667707275e-04,
 -2.566135156685589e-05,  2.018518316850969e-06, -1.109708827833403e-07,  4.770202656595610e-09, -1.703359903877305e-10,  5.246499030685347e-12, -1.429952670873720e-13,
  3.512780539303215e-15, -7.886110764023198e-17,  1.635395008397175e-18, -3.158754858842242e-20,  9.570119091727491e-05, -1.564569107266644e-05,  1.348893840317745e-06,
 -8.087622500055057e-08,  3.775006785260573e-09, -1.458132782299861e-10,  4.841785587520014e-12, -1.418394105839199e-13,  3.734991866278213e-15, -8.965967883012573e-17,
  1.983700045428802e-18, -4.079173234168219e-20,  5.214358655023239e-05, -9.334481116569203e-06,  8.777857582472307e-07, -5.715798104020652e-08,  2.886215192790848e-09,
 -1.201876276472562e-10,  4.289211941844912e-12, -1.346697711216571e-13,  3.791129441607983e-15, -9.706916493730487e-17,  2.285838397310097e-18, -4.992962287903757e-20,
  2.803795250345372e-05, -5.465325616345121e-06,  5.579812830538758e-07, -3.930085549030501e-08,  2.139164476278442e-09, -9.572054581598849e-11,  3.660358632782557e-12,
 -1.228290316019060e-13,  3.686931677325869e-15, -1.004400691970185e-16,  2.511513594561585e-18, -5.814195960973332e-20,  1.491754394374758e-05, -3.149593666978770e-06,
  3.475705426697690e-07, -2.637719293717217e-08,  1.542191887063044e-09, -7.391580936467742e-11,  3.019740152239389e-12, -1.080018423910396e-13,  3.447724467420649e-15,
 -9.968662278023152e-17,  2.640679618564957e-18, -6.464599776861819e-20,  7.875018432517750e-06, -1.791927938882459e-06,  2.128383496918745e-07, -1.733800988318069e-08,
  1.085147841509970e-09, -5.553381646411476e-11,  2.416755183550898e-12, -9.187315026918935e-14,  3.111042845071515e-15, -9.523796845367155e-17,  2.666413485807703e-18,
 -6.887419399941513e-20,  4.136709688263861e-06, -1.009624951634692e-06,  1.285437738018738e-07, -1.119869648791284e-08,  7.477859725761483e-10, -4.073478852865906e-11,
  1.882884381359861e-12, -7.587349301150054e-14,  2.718344291257477e-15, -8.789121832730391e-17,  2.594701959689978e-18, -7.055819540140169e-20,  2.168676938958742e-06,
 -5.651271048458388e-07,  7.681988119416851e-08, -7.131738833594635e-09,  5.063930656312273e-10, -2.927238459141613e-11,  1.432998539259354e-12, -6.104362315991048e-14,
  2.307973368194176e-15, -7.862151672854278e-17,  2.441675382664636e-18, -6.974279120724796e-20,  1.138124716459581e-06, -3.152622078650953e-07,  4.557805009629145e-08,
 -4.493130667232470e-09,  3.381444844192051e-10, -2.067880176871476e-11,  1.069032031668097e-12, -4.800964508372792e-14,  1.910594033741935e-15, -6.840269455021832e-17,
  2.229432189834325e-18, -6.673698625358289e-20,  5.997611876664884e-07, -1.758493643437324e-07,  2.693627732239725e-08, -2.809893443729277e-09,  2.234052166716079e-10,
 -1.440929867400920e-11,  7.843896794864806e-13, -3.703579062008873e-14,  1.547301490477587e-15, -5.807469040543777e-17,  1.981706667186144e-18, -6.202516827694334e-20,
  3.183484561350980e-07, -9.839041592875655e-08,  1.590921825343161e-08, -1.750100603220417e-09,  1.465250357138982e-10, -9.937122217777736e-12,  5.679541538773313e-13,
 -2.811602724415154e-14,  1.229906388204026e-15, -4.827135828344997e-17,  1.720339202632665e-18, -5.616648035496685e-20,  1.707221486470165e-07, -5.539701868443052e-08,
  9.420883787037345e-09, -1.089132975192028e-09,  9.571317927250941e-11, -6.804368047635471e-12,  4.071313777140066e-13, -2.107231403494395e-14,  9.625670637213877e-16,
 -3.940350827656186e-17,  1.463030702028803e-18, -4.970611585161271e-20,  9.277397590468230e-08, -3.148291596634050e-08,  5.610708994123795e-09, -6.793615620955308e-10,
  6.246374987976368e-11, -4.640568424370203e-12,  2.898212055716593e-13, -1.563922489829440e-14,  7.439650589225502e-16, -3.168137453840359e-17,  1.222411325501838e-18,
 -4.311258226949069e-20,  5.123017389296163e-08, -1.811238892290490e-08,  3.370531474831210e-09, -4.259868857136222e-10,  4.084585543769242e-11, -3.161308735502161e-12,
  2.054665621212310e-13, -1.152619966743383e-14,  5.694292435861827e-16, -2.515812340771878e-17,  1.006153622461879e-18, -3.674471147992775e-20,  2.881967418991318e-08,
 -1.057618188574497e-08,  2.047783635897663e-09, -2.692251675975915e-10,  2.683316692014779e-11, -2.156760062311884e-12,  1.454378042112777e-13, -8.456973096685521e-15,
  4.326740941104688e-16, -1.977891835950037e-17,  8.177393173054376e-19, -3.084453181644469e-20,  1.655182821172798e-08, -6.282056338509382e-09,  1.261099870613815e-09,
 -1.718817505359942e-10,  1.774841274134865e-11, -1.476794990944802e-12,  1.030064009188854e-13, -6.190220720016745e-15,  3.270374338381419e-16, -1.542531990557595e-17,
  6.575081872995044e-19, -2.554821673198684e-20,  9.720254620332214e-09, -3.801984994000887e-09,  7.885250679467435e-10, -1.110332944869443e-10,  1.183894236305881e-11,
 -1.016500247558062e-12,  7.310845486679051e-14, -4.526927249690218e-15,  2.462463176895372e-16, -1.195002073450116e-17,  5.237125915339326e-19, -2.090673073273001e-20,
  5.841162091261389e-09, -2.346401058679071e-09,  5.009944001739102e-10, -7.263218374387855e-11,  7.970060088010726e-12, -7.038429138985978e-13,  5.203306403545753e-14,
 -3.309610194953814e-15,  1.848093113929743e-16, -9.200838022885480e-18,  4.134151341954592e-19, -1.690928189882315e-20,  3.589835398151087e-09, -1.475948077813646e-09,
  3.232935337414863e-10, -4.808883990570474e-11,  5.412257673641020e-12, -4.899821870818834e-13,  3.711375479772359e-14, -2.417350393921869e-15,  1.381497587655921e-16,
 -7.035203014755524e-18,  3.231638446173899e-19, -1.350499682730891e-20,  2.250588437215739e-09, -9.439236526899741e-10,  2.113628449377848e-10, -3.214479517744408e-11,
  3.697953531331469e-12, -3.420597542179897e-13,  2.646035299094690e-14, -1.759269866987102e-15,  1.025810708913673e-16, -5.327361706890079e-18,  2.494448532607086e-19,
 -1.062045321944949e-20,  1.430793304306632e-09, -6.101506390843559e-10,  1.391762984644993e-10, -2.156537564112291e-11,  2.527121721082736e-12, -2.380347500998911e-13,
  1.874317643467538e-14, -1.267995271167286e-15,  7.519985433636151e-17, -3.970588026939843e-18,  1.889474166009031e-19, -8.172381514336743e-21,  9.110387955896646e-10,
 -3.937429807676836e-10,  9.116911586811235e-11, -1.434221223229636e-11,  1.706056142038960e-12, -1.630803723837989e-13,  1.302769865245894e-14, -8.938568188923335e-16,
  5.374699154093429e-17, -2.876342273243987e-18,  1.386879970839854e-19, -6.075878746932043e-21,  5.657698899464142e-10, -2.470277222563845e-10,  5.785715850640964e-11,
 -9.207930766998039e-12,  1.107966402384481e-12, -1.071117842530898e-13,  8.651804584092363e-15, -6.000760173393840e-16,  3.646583513128590e-17, -1.971791477982242e-18,
  9.603813438709728e-20, -4.248971245811434e-21,  3.206211306492356e-10, -1.409795116571881e-10,  3.328229266237410e-11, -5.339603139656142e-12,  6.476374953559767e-13,
 -6.310201397877548e-14,  5.136242054996622e-15, -3.589270983577682e-16,  2.197225063797488e-17, -1.196644401634388e-18,  5.869373414046894e-20, -2.614546226437470e-21,
  1.290873471305346e-10, -5.698283904756671e-11,  1.351191189892951e-11, -2.177480391718283e-12,  2.652782190260784e-13, -2.596003982013949e-14,  2.122084724488138e-15,
 -1.489151719184016e-16,  9.153398319974217e-18, -5.005042227308745e-19,  2.464502737654290e-20, -1.102007790690467e-21,  6.511241359985569e-02, -1.764476320683800e-04,
  4.977624700742803e-07, -1.450442529140435e-09,  4.327478212744413e-12, -1.311643470581990e-14,  4.013075466037810e-17, -1.233843646554520e-19,  3.799872862216497e-22,
 -1.169924136497556e-24,  3.596166304192114e-27, -1.102891861668598e-29,  6.247772843668455e-02, -2.221369635079387e-04,  9.335955791540728e-07, -4.041542429370920e-09,
  1.722832518606904e-11, -7.172861020738821e-14,  2.920728807451391e-16, -1.166644639611212e-18,  4.583587747591291e-21, -1.775121570948277e-23,  6.787863823684963e-26,
 -2.566218084195096e-28,  5.752991349333628e-02, -3.018317691918574e-04,  1.820297907037696e-06, -1.038822554974937e-08,  5.594777293695972e-11, -2.880590375504899e-13,
  1.431174785957379e-15, -6.904232970325067e-18,  3.248273410052947e-20, -1.495297629399383e-22,  6.752277266556423e-25, -2.997106250839138e-27,  5.084646435256955e-02,
 -3.957316358284728e-04,  3.149448024480327e-06, -2.240078371506865e-08,  1.471070592587682e-10, -9.106177437090119e-13,  5.378721766723891e-15, -3.056321313695556e-17,
  1.680513536456476e-19, -8.981037374382900e-22,  4.681063531752264e-24, -2.386025288486221e-26,  4.314835528158727e-02, -4.817119505995802e-04,  4.838576303892339e-06,
 -4.193339997637956e-08,  3.296398495512869e-10, -2.410074742377277e-12,  1.663707552350112e-14, -1.095465708964433e-16,  6.930563635556708e-19, -4.236055348988486e-21,
  2.511975782810145e-23, -1.450025164993401e-25,  3.517136864771452e-02, -5.412629874660471e-04,  6.704257005508826e-06, -6.976470186897866e-08,  6.473994278879419e-10,
 -5.517242795325848e-12,  4.396331702095856e-14, -3.315333584258342e-16,  2.386593786758663e-18, -1.650581965208290e-20,  1.102191153313431e-22, -7.133909379528838e-25,
  2.755301555035868e-02, -5.636535301583491e-04,  8.481563888218560e-06, -1.047125695636458e-07,  1.134322899313311e-09, -1.115262158124008e-11,  1.016027578441389e-13,
 -8.696270731135868e-16,  7.062089315350568e-18, -5.481311090902555e-20,  4.089156745745346e-22, -2.945075217029219e-24,  2.075805525685389e-02, -5.472845354336544e-04,
  9.886152448449863e-06, -1.433148148524502e-07,  1.795582032179585e-09, -2.019673017911963e-11,  2.087280768306276e-13, -2.012859058355372e-15,  1.831214392396505e-17,
 -1.584507663472813e-19,  1.312194551222136e-21, -1.045142687398080e-23,  1.505135751190749e-02, -4.983390562459155e-04,  1.069218004632199e-05, -1.803467282068064e-07,
  2.592684121885898e-09, -3.312487734918362e-11,  3.857975520919123e-13, -4.165941316332730e-15,  4.221095699087034e-17, -4.049141620994964e-19,  3.702536741572516e-21,
 -3.244545001250472e-23,  1.051290461260499e-02, -4.277140485170631e-04,  1.079240998221114e-05, -2.100820751838416e-07,  3.441258826311142e-09, -4.962862070292107e-11,
  6.476624168696732e-13, -7.789287067911894e-15,  8.745851771187847e-17, -9.256264931300880e-19,  9.302663306473373e-21, -8.929285625748398e-23,  7.080583443175207e-03,
 -3.475413732675948e-04,  1.021779608687375e-05, -2.278394671228379e-07,  4.225772523656052e-09, -6.840669547645098e-11,  9.951912213630815e-13, -1.326750342933343e-14,
  1.643416039106884e-16, -1.910900244120722e-18,  2.102267161324502e-20, -2.201731931510741e-22,  4.603759339797590e-03, -2.683819147297495e-04,  9.114009358665198e-06,
 -2.312133289966834e-07,  4.827618507437237e-09, -8.727474953157908e-11,  1.408887436530800e-12, -2.073152689649484e-14,  2.821621797841288e-16, -3.590831583163512e-18,
  4.308730953463587e-20, -4.906629649890544e-22,  2.893412700951879e-03, -1.976458074736488e-04,  7.689941002746126e-06, -2.205474776238844e-07,  5.156374303181713e-09,
 -1.036143392127682e-10,  1.848151400580665e-12, -2.989914265524298e-14,  4.454927151481938e-16, -6.183535489455741e-18,  8.066091939229431e-20, -9.955945827923138e-22,
  1.760275361092692e-03, -1.392455230978648e-04,  6.160483039518456e-06, -1.985619033633236e-07,  5.172400499148161e-09, -1.150221132054532e-10,  2.257915710154231e-12,
 -4.001393879642804e-14,  6.504746581555453e-16, -9.816007520947315e-18,  1.387750795937988e-19, -1.851195773892564e-21,  1.038257789319365e-03, -9.412952437111640e-05,
  4.702268194116431e-06, -1.693855506916031e-07,  4.893124288055798e-09, -1.199211796648995e-10,  2.581150180769339e-12, -4.993592524877987e-14,  8.828474200548241e-16,
 -1.444098399912153e-17,  2.206426664634166e-19, -3.172291493194016e-21,  5.947466864694771e-04, -6.123027696236734e-05,  3.431298228843170e-06, -1.374175108474105e-07,
  4.382634087908765e-09, -1.179141225055546e-10,  2.772944090353568e-12, -5.837538647832419e-14,  1.119042836540795e-15, -1.978492976056160e-17,  3.258205345119055e-19,
 -5.036087805999750e-21,  3.314951571412891e-04, -3.843489587129656e-05,  2.401508998890589e-06, -1.063983745750754e-07,  3.730577335526602e-09, -1.097759463431932e-10,
  2.811104479046755e-12, -6.419642336684018e-14,  1.330524496083941e-15, -2.535795974577423e-17,  4.489514481680275e-19, -7.441954504904381e-21,  1.801469645468969e-04,
 -2.334674136888580e-05,  1.617257075352266e-06, -7.889717417981711e-08,  3.028990503436879e-09, -9.713509108986553e-11,  2.699819248808523e-12, -6.668402234115448e-14,
  1.490141042185522e-15, -3.053474979723946e-17,  5.797668626026874e-19, -1.028245123812514e-20,  9.566200320413727e-05, -1.376270951946070e-05,  1.051311886574235e-06,
 -5.622239455818220e-08,  2.354294877582412e-09, -8.199542397129402e-11,  2.465918518859181e-12, -6.568539593849441e-14,  1.578352996818265e-15, -3.468595117713621e-17,
  7.046159154429373e-19, -1.334030371453297e-20,  4.975606159284373e-05, -7.896248879460459e-06,  6.618164527588161e-07, -3.863331543556499e-08,  1.757967331140365e-09,
 -6.627374666206405e-11,  2.150017664883985e-12, -6.159111071267968e-14,  1.587261594245014e-15, -3.731761846125373e-17,  8.091761300550236e-19, -1.631788524064010e-20,
  2.541273552252368e-05, -4.422564730490466e-06,  4.047719617557871e-07, -2.568675265327897e-08,  1.265585224876113e-09, -5.147728875038120e-11,  1.796138583053382e-12,
 -5.518364648074422e-14,  1.521329600402321e-15, -3.817309142300713e-17,  8.815046091387262e-19, -1.889323937057915e-20,  1.278009240771693e-05, -2.425509816222442e-06,
  2.413176810514627e-07, -1.658272701034487e-08,  8.815627542696340e-10, -3.856519641197327e-11,  1.443046459908431e-12, -4.742126754405421e-14,  1.394990186392979e-15,
 -3.726826264888874e-17,  9.144568082638320e-19, -2.078591268510231e-20,  6.346642199765121e-06, -1.306749129235355e-06,  1.407161331207585e-07, -1.043106117543201e-08,
  5.962941202303968e-10, -2.796865614351225e-11,  1.119108718251531e-12, -3.923089910936092e-14,  1.228353557482886e-15, -3.485761032920780e-17,  9.067806062711372e-19,
 -2.181217823260646e-20,  3.121771347402708e-06, -6.938640081875852e-07,  8.053399733551659e-08, -6.416205375997109e-09,  3.930930524208090e-10, -1.970814844540280e-11,
  8.408728876910439e-13, -3.136157579677350e-14,  1.042572406389219e-15, -3.135165580754637e-17,  8.627187625199994e-19, -2.191403968318947e-20,  1.525772510414108e-06,
 -3.643587672531097e-07,  4.539781768066681e-08, -3.873318082271522e-09,  2.534891860499204e-10, -1.354359199228043e-11,  6.144369578874751e-13, -2.431684390676668e-14,
  8.561382631982146e-16, -2.721752674926880e-17,  7.904604314984719e-19, -2.115675484759881e-20,  7.434524715321309e-07, -1.898805512527564e-07,  2.529787001271136e-08,
 -2.303277289538301e-09,  1.604992429000888e-10, -9.110963080187050e-12,  4.382721081900612e-13, -1.835626987754714e-14,  6.827457270832280e-16, -2.289163484094826e-17,
  7.000677701933914e-19, -1.970033140585664e-20,  3.623965827916139e-07, -9.855745881828103e-08,  1.398708482112627e-08, -1.354225856753685e-09,  1.001545742877935e-10,
 -6.022473036496046e-12,  3.063125754434814e-13, -1.354121284269988e-14,  5.307249712970958e-16, -1.872194110576028e-17,  6.015080014324688e-19, -1.775716546217694e-20,
  1.773425039248295e-07, -5.113822190373349e-08,  7.701676531503923e-09, -7.902311265470711e-10,  6.182933373322332e-11, -3.926497485016705e-12,  2.105584704038530e-13,
 -9.798234091796261e-15,  4.036293325999608e-16, -1.494383499459807e-17,  5.032199967477869e-19, -1.554908745050504e-20,  8.743630556776048e-08, -2.662272189796733e-08,
  4.239215558744015e-09, -4.593801640573416e-10,  3.790367718278571e-11, -2.534463590191343e-12,  1.428849114141278e-13, -6.980056522294164e-15,  3.014287292015688e-16,
 -1.168360463999809e-17,  4.113723543569635e-19, -1.327367816793150e-20,  4.358880626894736e-08, -1.395754708582730e-08,  2.341231186054744e-09, -2.670335513272241e-10,
  2.316044139191810e-11, -1.625630739494044e-12,  9.607165331466132e-14, -4.913169785328666e-15,  2.218324360954464e-16, -8.978880648782241e-18,  3.297433020220374e-19,
 -1.108437232095947e-20,  2.204914567730899e-08, -7.395802320050684e-09,  1.302096572414739e-09, -1.557813683112507e-10,  1.415672008799792e-11, -1.039847910010487e-12,
  6.422994962983008e-14, -3.429041015012085e-15,  1.614344731508242e-16, -6.805574992832122e-18,  2.600282420300620e-19, -9.084000768447759e-21,  1.135567773708566e-08,
 -3.974555157248889e-09,  7.318074548064657e-10, -9.152311182508941e-11,  8.686114956733648e-12, -6.655928812140540e-13,  4.284206963742517e-14, -2.380807470124084e-15,
  1.165478903999752e-16, -5.103672677949985e-18,  2.023567987914278e-19, -7.328400660800404e-21,  5.973195888653340e-09, -2.173303602496219e-09,  4.169751119320610e-10,
 -5.432601785475908e-11,  5.366808003099476e-12, -4.276595991056612e-13,  2.859759380720037e-14, -1.649398220431059e-15,  8.372012730725002e-17, -3.797753166646227e-18,
  1.558431203660554e-19, -5.835741864792416e-21,  3.217941111979799e-09, -1.212599776886197e-09,  2.415571960147197e-10, -3.267173270083855e-11,  3.348430004101791e-12,
 -2.765813271964534e-13,  1.915460224255489e-14, -1.143158734928307e-15,  5.998916738120269e-17, -2.811030801046925e-18,  1.190603332132260e-19, -4.597722854129309e-21,
  1.779452821159210e-09, -6.919401620648585e-10,  1.425978886029987e-10, -1.995247626081616e-11,  2.114239658990206e-12, -1.804311524743575e-13,  1.290040111406925e-14,
 -7.942183780828897e-16,  4.296107442235099e-17, -2.073525919507656e-18,  9.039277309812538e-20, -3.589999432404197e-21,  1.011401549722017e-09, -4.043828766214712e-10,
  8.590233575771959e-11, -1.239031413925776e-11,  1.352802990004843e-12, -1.188827530411185e-13,  8.746751127427452e-15, -5.537621385962024e-16,  3.078247182567092e-17,
 -1.525784684150897e-18,  6.826372946329071e-20, -2.780488297508144e-21,  5.909114437217627e-10, -2.420742841514603e-10,  5.281403516377669e-11, -7.824684717169746e-12,
  8.772009426649855e-13, -7.911099248937453e-14,  5.969919738762668e-15, -3.874290636082943e-16,  2.206293905495016e-17, -1.119673436359639e-18,  5.126003028968613e-20,
 -2.135179194946216e-21,  3.541859388262359e-10, -1.481522668026942e-10,  3.307599793843379e-11, -5.015353691721970e-12,  5.752785397105658e-13, -5.306054966057003e-14,
  4.093062850368165e-15, -2.713932268587277e-16,  1.578258687413844e-17, -8.175187622007301e-19,  3.818248198149235e-20, -1.621691691246993e-21,  2.166205880148002e-10,
 -9.220242666255701e-11,  2.098751465532786e-11, -3.245165432204879e-12,  3.794919329812885e-13, -3.567235704569415e-14,  2.803304672454384e-15, -1.892786705837357e-16,
  1.120415913784954e-17, -5.904951409458927e-19,  2.804931493949057e-20, -1.211077412491731e-21,  1.335851725334201e-10, -5.766337927162947e-11,  1.333329987335161e-11,
 -2.094610414798991e-12,  2.488198681737582e-13, -2.375251476218918e-14,  1.894980819811353e-15, -1.298517587358477e-16,  7.798129081903981e-18, -4.168182013632104e-19,
  2.007372906565168e-20, -8.784068249021471e-22,  8.091889648769842e-11, -3.530533105030725e-11,  8.262226322831141e-12, -1.313842663951372e-12,  1.579621402734840e-13,
 -1.525861446464867e-14,  1.231525061072637e-15, -8.535110540098110e-17,  5.182783484471759e-18, -2.800396624329269e-19,  1.362986161763092e-20, -6.025997304160935e-22,
  4.506336190316564e-11, -1.980725001301174e-11,  4.674088668630228e-12, -7.495583520347340e-13,  9.087461736071818e-14, -8.850559689055929e-15,  7.201006365347860e-16,
 -5.030112051607770e-17,  3.078032643258794e-18, -1.675693618283055e-19,  8.215908365702062e-21, -3.658461191988447e-22,  1.796672772678319e-11, -7.929596376647662e-12,
  1.879899544632953e-12, -3.028872550709742e-13,  3.689243797232888e-14, -3.609532293884412e-15,  2.949980826314188e-16, -2.069700597649094e-17,  1.271933204497208e-18,
 -6.953514042055897e-20,  3.423275280520027e-21, -1.530434105516587e-22,  6.441447867335873e-02, -1.725339960778366e-04,  4.807641071473870e-07, -1.383250327172903e-09,
  4.074508003608713e-12, -1.219341765324129e-14,  3.684008769702442e-17, -1.118718068336578e-19,  3.403465081877782e-22, -1.035324893800207e-24,  3.144699312847912e-27,
 -9.531237500182929e-30,  6.160381742967855e-02, -2.148576134138664e-04,  8.867048524075217e-07, -3.776995756639907e-09,  1.586128774216709e-11, -6.509485168877192e-14,
  2.613678205641354e-16, -1.029691809214237e-18,  3.990814187012366e-21, -1.524896690243158e-23,  5.753907021539276e-26, -2.146824654332045e-28,  5.635094259949974e-02,
 -2.877532290104841e-04,  1.700825938318893e-06, -9.537348053865569e-09,  5.051500192325617e-11, -2.559180011773229e-13,  1.251634995764666e-15, -5.945949148828280e-18,
  2.755565578665923e-20, -1.249830708063954e-22,  5.562080568696765e-25, -2.433544259897587e-27,  4.931228123800954e-02, -3.715726161027032e-04,  2.894181840096017e-06,
 -2.018603615207658e-08,  1.301192985590165e-10, -7.912186187873720e-13,  4.593624496621410e-15, -2.566869677585398e-17,  1.388515377651100e-19, -7.302772279405602e-22,
  3.747029023401657e-24, -1.880668988231087e-26,  4.129585968501417e-02, -4.449300086930910e-04,  4.365497810617145e-06, -3.702407913059369e-08,  2.851951793899987e-10,
 -2.045220757447288e-12,  1.385864882137076e-14, -8.962663222479163e-17,  5.572062134567606e-19, -3.348113560741914e-21,  1.952552524309614e-23, -1.108793202856148e-25,
  3.310852068821585e-02, -4.908095732816806e-04,  5.925766984113771e-06, -6.023474938436147e-08,  5.468962272694541e-10, -4.565408553455760e-12,  3.566597614610612e-14,
 -2.638766192119689e-16,  1.864719070635783e-18, -1.266620166666315e-20,  8.310462437822812e-23, -5.287103007059981e-25,  2.542656256310852e-02, -5.005348170832506e-04,
  7.326954928020707e-06, -8.822317433985145e-08,  9.338074462120539e-10, -8.982529983955298e-12,  8.014148694806932e-14, -6.722928351589196e-16,  5.354470938135888e-18,
 -4.078189716271038e-20,  2.986935512171025e-22, -2.112918694152608e-24,  1.871685477466267e-02, -4.746150498532482e-04,  8.326252739671051e-06, -1.175628329702225e-07,
  1.437498104509009e-09, -1.580228987742505e-11,  1.597816568387637e-13, -1.508843792306176e-15,  1.345144172377198e-17, -1.141274327698570e-19,  9.272399603049649e-22,
 -7.248919775928311e-24,  1.321630291453018e-02, -4.208003164009032e-04,  8.756582062269947e-06, -1.436977592910981e-07,  2.014064825644045e-09, -2.512536980127960e-11,
  2.860589907198088e-13, -3.022414635748792e-15,  2.998818409660058e-17, -2.818784598429949e-19,  2.527112392141806e-21, -2.172347135426358e-23,  8.959989217122662e-03,
 -3.505929807162398e-04,  8.571577033094167e-06, -1.621867963309290e-07,  2.587971829601123e-09, -3.641407379721588e-11,  4.642050043465477e-13, -5.459000300539724e-15,
  5.998357596137749e-17, -6.217130464161647e-19,  6.122873586517710e-21, -5.762337953351652e-23,  5.838082402276891e-03, -2.756820221016704e-04,  7.848130867039797e-06,
 -1.699908244717793e-07,  3.069215005043564e-09, -4.844392681533859e-11,  6.880402224029418e-13, -8.964189679186652e-15,  1.086078814120567e-16, -1.236143257228764e-18,
  1.332049120601726e-20, -1.367264533662201e-22,  3.660176448336658e-03, -2.053765992239725e-04,  6.750752396123650e-06, -1.662786320819865e-07,  3.378043747471278e-09,
 -5.951546681177830e-11,  9.375271537776019e-13, -1.347613401821781e-14,  1.793285106671998e-16, -2.233055125283341e-18,  2.623639468112731e-20, -2.927212973147598e-22,
  2.210897453925566e-03, -1.454531647956184e-04,  5.477091025719232e-06, -1.524718827756947e-07,  3.467359864275830e-09, -6.787929466189944e-11,  1.181078735951363e-12,
 -1.865910721506129e-14,  2.717452292618024e-16, -3.689722278387688e-18,  4.711520271922887e-20, -5.696350220866504e-22,  1.288547969466219e-03, -9.824317456580773e-05,
  4.206966093154033e-06, -1.316051613901576e-07,  3.334004648486133e-09, -7.221652816885464e-11,  1.382618060410259e-12, -2.392290026962658e-14,  3.800524911577447e-16,
 -5.609325489597343e-18,  7.761785266618278e-20, -1.014049071488782e-21,  7.257662416314107e-04, -6.347351472031484e-05,  3.069963331840525e-06, -1.073406898707494e-07,
  3.015584099720477e-09, -7.198527927543245e-11,  1.511030766306343e-12, -2.853982926804943e-14,  4.930662174074372e-16, -7.887728173207269e-18,  1.179493384513903e-19,
 -1.660797310076941e-21,  3.957558003124368e-04, -3.934208244248217e-05,  2.135550596028303e-06, -8.303626267794173e-08,  2.575878755366836e-09, -6.750902051727650e-11,
  1.548386221878215e-12, -3.182506076269218e-14,  5.961937968438087e-16, -1.030932043891271e-17,  1.661670478163430e-19, -2.515472745441538e-21,  2.093326708431515e-04,
 -2.346098934080682e-05,  1.420803064226290e-06, -6.114190029259765e-08,  2.085816416100383e-09, -5.980207247432082e-11,  1.493874860306134e-12, -3.331384585043854e-14,
  6.748498655739625e-16, -1.258110840781887e-17,  2.180412843837752e-19, -3.540382033359184e-21,  1.076337909967263e-04, -1.349943503057185e-05,  9.070422160236165e-07,
 -4.300385988367061e-08,  1.607062778092412e-09, -5.023210648966225e-11,  1.362413201514848e-12, -3.286999678230496e-14,  7.181139861720757e-16, -1.439767230092028e-17,
  2.676662531498384e-19, -4.651212214940611e-21,  5.392195702034605e-05, -7.516996521573887e-06,  5.574643137693706e-07, -2.899310012497083e-08,  1.182458885546021e-09,
 -4.016078954125449e-11,  1.179109591769648e-12, -3.069202294653749e-14,  7.212979812555282e-16, -1.551505417976514e-17,  3.087062433103854e-19, -5.728420233173443e-21,
  2.638608126881883e-05, -4.063011292801715e-06,  3.309382641988017e-07, -1.880305245997461e-08,  8.339170239936572e-10, -3.067690208738244e-11,  9.721204320400758e-13,
 -2.722726176652992e-14,  6.865955670061016e-16, -1.580729378912841e-17,  3.358719382128631e-19, -6.641384082881359e-21,  1.264586710196230e-05, -2.138398786546441e-06,
  1.904105961944103e-07, -1.177212421822543e-08,  5.657701210263828e-10, -2.247208764808623e-11,  7.664257852818002e-13, -2.303682443304259e-14,  6.218137350302987e-16,
 -1.528731261726620e-17,  3.461155629943539e-19, -7.277715753587625e-21,  5.953133514585172e-06, -1.099468976624563e-06,  1.065520859989421e-07, -7.140828422700438e-09,
  3.706416898160000e-10, -1.584691506958122e-11,  5.800604077087020e-13, -1.866239890281748e-14,  5.378885436143313e-16, -1.408915802983678e-17,  3.391627333130024e-19,
 -7.567863259244237e-21,  2.761286798509101e-06, -5.541248926071499e-07,  5.819926789206887e-08, -4.212304561883561e-09,  2.353477664217099e-10, -1.079898523842630e-11,
  4.230703548773124e-13, -1.453223520253600e-14,  4.461677493670933e-16, -1.242297096339767e-17,  3.172812652322400e-19, -7.497305447000409e-21,  1.266127542389604e-06,
 -2.747280384556224e-07,  3.114338768979468e-08, -2.425599580708742e-09,  1.454069171699157e-10, -7.139242737619393e-12,  2.985326320776407e-13, -1.092008046849545e-14,
  3.562770677118011e-16, -1.052111238387612e-17,  2.844703642721643e-19, -7.103863336133265e-21,  5.759134518521062e-07, -1.344848771160191e-07,  1.638955013878977e-08,
 -1.368801812414975e-09,  8.775923653017341e-11, -4.597017038693784e-12,  2.046154089610258e-13, -7.950133269964348e-15,  2.749692744878369e-16, -8.592318366437716e-18,
  2.454116458772873e-19, -6.463120038810483e-21,  2.608207061186366e-07, -6.525079752848928e-08,  8.515935575504708e-09, -7.600128824356566e-10,  5.194969594430438e-11,
 -2.894733677716414e-12,  1.367741674909088e-13, -5.630201878117758e-15,  2.059320279658136e-16, -6.793558816971051e-18,  2.045182913101474e-19, -5.668237682822655e-21,
  1.180572930706936e-07, -3.150387495009350e-08,  4.386521920027509e-09, -4.169043079454843e-10,  3.028572782135718e-11, -1.789907049997746e-12,  8.952879036585661e-14,
 -3.894369056015830e-15,  1.502642934947484e-16, -5.221022338946302e-18,  1.652965699684176e-19, -4.810719794425639e-21,  5.362022523375546e-08, -1.519777239327821e-08,
  2.249202522792244e-09, -2.268793624066712e-10,  1.746088001090392e-11, -1.091296914514029e-12,  5.762398519753169e-14, -2.641721574296586e-15,  1.072592274762909e-16,
 -3.915791658400529e-18,  1.300778520676187e-19, -3.966607813006185e-21,  2.453643781222753e-08, -7.355978753479460e-09,  1.152873634605805e-09, -1.230056592130557e-10,
  9.997468537651653e-12, -6.588043670399745e-13,  3.662009074055345e-14, -1.764603452352733e-15,  7.519884686914597e-17, -2.877502674683809e-18,  1.000579354548346e-19,
 -3.189704597993732e-21,  1.135862258382981e-08, -3.587303481926041e-09,  5.932164821214435e-10, -6.672027791454253e-11,  5.708605454258224e-12, -3.954343829616485e-13,
  2.307242052779885e-14, -1.165400080420199e-15,  5.198959655240452e-17, -2.079921768418130e-18,  7.552351459040910e-20, -2.511006826756980e-21,  5.341340984974051e-09,
 -1.770009029413013e-09,  3.077093098567540e-10, -3.635826407970593e-11,  3.264226461870378e-12, -2.369571300317038e-13,  1.447012521545697e-14, -7.639949834444915e-16,
  3.558279600608901e-17, -1.484470150469778e-18,  5.614627988472420e-20, -1.942247158735328e-21,  2.561674118339681e-09, -8.872186408088782e-10,  1.615593411663866e-10,
 -1.998557780945895e-11,  1.876621485241757e-12, -1.423158955565287e-13,  9.068574759604434e-15, -4.990504718987343e-16,  2.419913700207346e-17, -1.049959543503619e-18,
  4.125875470159951e-20, -1.481266101544610e-21,  1.257757695154239e-09, -4.535352759188785e-10,  8.619078473278835e-11, -1.112386260396492e-11,  1.088812079092926e-12,
 -8.598661652529755e-14,  5.699902606794082e-15, -3.259695668365807e-16,  1.640969066704878e-17, -7.384448647457740e-19,  3.006754076026309e-20, -1.117445900845061e-21,
  6.344084872878540e-10, -2.372689189453465e-10,  4.688605820717099e-11, -6.290965652304859e-12,  6.397058657739812e-13, -5.243760508182290e-14,  3.604661605383871e-15,
 -2.135794170206927e-16,  1.112949219687014e-17, -5.179684482277578e-19,  2.179328160197224e-20, -8.361844435849674e-22,  3.296858394283308e-10, -1.274100099959089e-10,
  2.608282293718491e-11, -3.625384353705456e-12,  3.816656280940892e-13, -3.236542177594645e-14,  2.299783838489370e-15, -1.407379356805023e-16,  7.568432774006578e-18,
 -3.632202979359457e-19,  1.574679756260376e-20, -6.220454162186121e-22,  1.768825159017242e-10, -7.037444042675555e-11,  1.486955480667479e-11, -2.133277610009697e-12,
  2.316932778823109e-13, -2.025654696284985e-14,  1.482922972305578e-15, -9.342831652324043e-17,  5.168918104555726e-18, -2.550271642082656e-19,  1.135886097542423e-20,
 -4.606541141992774e-22,  9.805120319316208e-11, -4.001526264428578e-11,  8.693854175579841e-12, -1.282662207032753e-12,  1.432046635671116e-13, -1.286317002720129e-14,
  9.668890102734860e-16, -6.250890454172466e-17,  3.546490964406140e-18, -1.793312720623753e-19,  8.181160625377135e-21, -3.396148296250174e-22,  5.608386044886841e-11,
 -2.339313099234242e-11,  5.206407591544245e-12, -7.869844305116782e-13,  8.999180576646068e-14, -8.275341283731623e-15,  6.364788031217423e-16, -4.208125143352753e-17,
  2.440363688983982e-18, -1.260645203915457e-19,  5.872315617070103e-21, -2.487694592591972e-22,  3.294235635723731e-11, -1.399378867282830e-11,  3.178307820820090e-12,
 -4.903515875902683e-13,  5.721668044181473e-14, -5.366870231010122e-15,  4.208727258011610e-16, -2.835933431045472e-17,  1.675367827287322e-18, -8.812641972881196e-20,
  4.178234625832682e-21, -1.800722358826285e-22,  1.964590954316944e-11, -8.469368045143939e-12,  1.955507284024098e-12, -3.067541998287204e-13,  3.638696608009038e-14,
 -3.468616616594781e-15,  2.763448530944286e-16, -1.891074830881835e-17,  1.134175145013509e-18, -6.054517665275718e-20,  2.912179689794021e-21, -1.272794476661055e-22,
  1.159410679841017e-11, -5.054702745305647e-12,  1.181896711694877e-12, -1.877797681102185e-13,  2.255721955970989e-14, -2.177115969066241e-15,  1.755704418597986e-16,
 -1.215813924181217e-17,  7.376987396987114e-19, -3.982920724323931e-20,  1.937080625323748e-21, -8.557916817789323e-23,  6.339597579172671e-12, -2.785424087954085e-12,
  6.570085647699206e-13, -1.053134045464977e-13,  1.276222652681362e-14, -1.242405025976250e-15,  1.010410343283315e-16, -7.055017574083710e-18,  4.315322965649889e-19,
 -2.348324573759483e-20,  1.150922953799057e-21, -5.122953831536600e-23,  2.501784782095181e-12, -1.103954075936329e-12,  2.616630156321925e-13, -4.214970184183312e-14,
  5.132829177531371e-15, -5.020849327116501e-16,  4.102545410671150e-17, -2.877735994333534e-18,  1.768146630064046e-19, -9.664295596031344e-21,  4.756866212169033e-22,
 -2.126221894773217e-23,  6.373193132829914e-02, -1.687531891972695e-04,  4.645483610888837e-07, -1.319962149776029e-09,  3.839233763683398e-12, -1.134564737359119e-14,
  3.385471761310747e-17, -1.015535852149316e-19,  3.052415164823436e-22, -9.175330074943128e-25,  2.754216367430818e-27, -8.250885322720354e-30,  6.075829316499971e-02,
 -2.079410528981604e-04,  8.428617021934314e-07, -3.533299054780723e-09,  1.461985612855568e-11, -5.915406146484852e-14,  2.342448703911828e-16, -9.103427860798693e-19,
  3.481101161390256e-21, -1.312564138062367e-23,  4.887957276005857e-26, -1.800115177319388e-28,  5.522643695794312e-02, -2.745910527954345e-04,  1.591063432418760e-06,
 -8.768477635798131e-09,  4.568404674686541e-11, -2.277809678877027e-13,  1.096846387787188e-15, -5.132065389992601e-18,  2.343221975153056e-20, -1.047360429878270e-22,
  4.594313274378108e-25, -1.981735991748215e-27,  4.787081197208759e-02, -3.493538635807088e-04,  2.663937411506328e-06, -1.822496790191505e-08,  1.153416748741707e-10,
 -6.891175222372962e-13,  3.933351447566739e-15, -2.161870380762507e-17,  1.150713092845926e-19, -5.957174908867725e-22,  3.009552733419158e-24, -1.487650021215970e-26,
  3.958327934442831e-02, -4.117086043363925e-04,  3.947294044389766e-06, -3.277093827461046e-08,  2.474235261125031e-10, -1.740819085989492e-12,  1.158163337532417e-14,
 -7.358285705918264e-17,  4.496314674568542e-19, -2.656565783466506e-21,  1.523902584799332e-23, -8.514817544457479e-26,  3.123571805093997e-02, -4.461525988615014e-04,
  5.252582929490965e-06, -5.217076265716618e-08,  4.635825583126581e-10, -3.791744314566121e-12,  2.904859897040327e-14, -2.109026536847582e-16,  1.463359937608134e-18,
 -9.764498029931961e-21,  6.296156949871757e-23, -3.937991290075742e-25,  2.353529101158587e-02, -4.459128993073885e-04,  6.352315713155667e-06, -7.462102398416816e-08,
  7.719606373653072e-10, -7.266941336935799e-12,  6.351082293732579e-14, -5.223045203004425e-16,  4.080715528073107e-18, -3.050556365977443e-20,  2.193992200960898e-22,
 -1.524654394473619e-24,  1.694320179754004e-02, -4.132797781658326e-04,  7.043706725763912e-06, -9.689640971649602e-08,  1.156614002320737e-09, -1.242941625907013e-11,
  1.229902557135981e-13, -1.137557237382227e-15,  9.940127288843664e-18, -8.271233608640175e-20,  6.594134043942538e-22, -5.060883855590598e-24,  1.166301186947778e-02,
 -3.571332291115842e-04,  7.210110571581862e-06, -1.151466963824729e-07,  1.573879780223421e-09, -1.917577060799685e-11,  2.134695272685343e-13, -2.207373311403455e-15,
  2.145102117973455e-17, -1.976156785276496e-19,  1.737377689041421e-21, -1.465310031261823e-23,  7.683361794887308e-03, -2.891530620223453e-04,  6.851575134116925e-06,
 -1.260484921104355e-07,  1.959757538044965e-09, -2.690958303067699e-11,  3.351712290757389e-13, -3.854915428296632e-15,  4.146056133747161e-17, -4.209195338130641e-19,
  4.062906711700481e-21, -3.749639796251649e-23,  4.849093460319403e-03, -2.202899106628049e-04,  6.073601655895141e-06, -1.278159744014872e-07,  2.247003023532794e-09,
 -3.458791734379103e-11,  4.796794313885339e-13, -6.108643127586892e-15,  7.240445888180789e-17, -8.067974483824623e-19,  8.517045606099542e-21, -8.569300063606100e-23,
  2.935232094983099e-03, -1.585162399292338e-04,  5.044056519178548e-06, -1.206473826295357e-07,  2.385237634211133e-09, -4.096196159804220e-11,  6.297593953060138e-13,
 -8.844097727699371e-15,  1.150859093285922e-16, -1.402462759681301e-18,  1.613648018082232e-20, -1.764147157442828e-22,  1.706337432803331e-03, -1.081059507075341e-04,
  3.940037528526932e-06, -1.064760945968956e-07,  2.355515288192756e-09, -4.493108407088448e-11,  7.627311359880315e-13, -1.176879776098349e-14,  1.675514739267137e-16,
 -2.225713437901809e-18,  2.782461858263706e-20, -3.295567881877264e-22,  9.540337594348320e-04, -7.009673786258222e-05,  2.905378288854020e-06, -8.821801403993117e-08,
  2.173627502818081e-09, -4.586466481909094e-11,  8.564970681042232e-13, -1.447065583588324e-14,  2.246831364586085e-16, -3.243699554238916e-18,  4.393442673834121e-20,
 -5.622066614456574e-22,  5.138620528685056e-04, -4.334376787271505e-05,  2.029571539229488e-06, -6.888129357001826e-08,  1.882006676310188e-09, -4.376004081617867e-11,
  8.958684605569255e-13, -1.652062524116317e-14,  2.789252566550071e-16, -4.364111561315508e-18,  6.387269741170823e-20, -8.808414370958131e-22,  2.671142349150506e-04,
 -2.563363568654919e-05,  1.347641019436087e-06, -5.087271936723372e-08,  1.534969510102669e-09, -3.918704940616670e-11,  8.766121113950650e-13, -1.759164629193049e-14,
  3.220587448559522e-16, -5.446809036014091e-18,  8.592858333849450e-20, -1.274035364097643e-21,  1.342701033765883e-04, -1.454169021923972e-05,  8.534079152266194e-07,
 -3.566722453070754e-08,  1.183781943161205e-09, -3.306736625890400e-11,  8.057689543831205e-13, -1.754633416689586e-14,  3.474003059280276e-16, -6.335119459809602e-18,
  1.074738558691645e-19, -1.709352743454787e-21,  6.540972858764395e-05, -7.936355053617473e-06,  5.171209577817433e-07, -2.382308984605132e-08,  8.664787217952493e-10,
 -2.639569823461738e-11,  6.985431540086815e-13, -1.646101201307789e-14,  3.515690659557961e-16, -6.896300667113349e-18,  1.255267460611521e-19, -2.137054134913728e-21,
  3.095452368463686e-05, -4.179657676292118e-06,  3.008393009065663e-07, -1.521304890634896e-08,  6.041845372524157e-10, -2.000816738346060e-11,  5.734091014003127e-13,
 -1.458363495675894e-14,  3.351675717210516e-16, -7.055798493799594e-18,  1.374961657233863e-19, -2.500443357932131e-21,  1.426776079507805e-05, -2.130745700548675e-06,
  1.686033903131391e-07, -9.321500149586371e-09,  4.028332964213133e-10, -1.445719930521971e-11,  4.474271943848860e-13, -1.225018836739825e-14,  3.022319391605098e-16,
 -6.812809149535701e-18,  1.418309512661346e-19, -2.749565008827041e-21,  6.423405464847426e-06, -1.054895497607656e-06,  9.135046051791400e-08, -5.500459026030497e-09,
  2.577893441660712e-10, -9.996287653938723e-12,  3.331725834150299e-13, -9.795189614156412e-15,  2.588157166084392e-16, -6.233308178588768e-18,  1.383425136970887e-19,
 -2.853312149920251e-21,  2.833219769973724e-06, -5.089288458689340e-07,  4.802229012723628e-08, -3.137538339822385e-09,  1.589501707597034e-10, -6.640047283544033e-12,
  2.376980211646887e-13, -7.485345207579832e-15,  2.113299108364054e-16, -5.426022520226463e-18,  1.281184141163972e-19, -2.805741247588907e-21,  1.228371755585201e-06,
 -2.401220118647769e-07,  2.458655174525893e-08, -1.736759049097309e-09,  9.480430348501824e-11, -4.254184710872977e-12,  1.631321413001090e-13, -5.489043824140661e-15,
  1.652014943248129e-16, -4.512128277613911e-18,  1.131115947851867e-19, -2.624996001337626e-21,  5.253460791262936e-07, -1.112170113836886e-07,  1.230767539917190e-08,
 -9.366784337384467e-10,  5.491987438858652e-11, -2.639678789963584e-12,  1.081421064693432e-13, -3.878408285635474e-15,  1.241467045262429e-16, -3.599159871710000e-18,
  9.559198724456988e-20, -2.346209023212321e-21,  2.224640735025293e-07, -5.076846312255000e-08,  6.048515937407289e-09, -4.942452418536608e-10,  3.103001594944377e-11,
 -1.592937390277374e-12,  6.953690299254088e-14, -2.651567293336195e-15,  9.006137191448059e-17, -2.765325536554369e-18,  7.765163344287833e-20, -2.011626219506264e-21,
  9.364902884673655e-08, -2.293514148571980e-08,  2.930604433003706e-09, -2.562464670872015e-10,  1.717341085907672e-11, -9.389244787823481e-13,  4.355792091550531e-14,
 -1.761573581716224e-15,  6.333863950498488e-17, -2.055169390076924e-18,  6.088498123173117e-20, -1.661385222939168e-21,  3.935476188725291e-08, -1.029847022494807e-08,
  1.406080477079250e-09, -1.311169043328125e-10,  9.351407743843402e-12, -5.429562468078843e-13,  2.669665855614426e-14, -1.142193651306813e-15,  4.337106689570092e-17,
 -1.483749103048124e-18,  4.627380617120451e-20, -1.327241561660422e-21,  1.658230222032548e-08, -4.616977089828432e-09,  6.710856286885409e-10, -6.651511004474936e-11,
  5.032848263654845e-12, -3.094281970126796e-13,  1.608149919335211e-14, -7.260076802402963e-16,  2.904235454289678e-17, -1.045104647609956e-18,  3.423540811867909e-20,
 -1.029936008390836e-21,  7.037451898225077e-09, -2.076176270777091e-09,  3.200959818439294e-10, -3.360938269178758e-11,  2.689513188675096e-12, -1.745841569375709e-13,
  9.564074474493982e-15, -4.544089625568113e-16,  1.910196835532546e-17, -7.213248132876786e-19,  2.476204433993288e-20, -7.796081540349038e-22,  3.022211763718927e-09,
 -9.408911568889293e-10,  1.533093665917488e-10, -1.699504915862176e-11,  1.433780034718074e-12, -9.797217353344043e-14,  5.641338529065814e-15, -2.813214084936279e-16,
  1.239518513934347e-17, -4.899529944688039e-19,  1.758387817527014e-20, -5.780433528821631e-22,  1.319494017956302e-09, -4.317611713409815e-10,  7.408013050990364e-11,
 -8.640718091610920e-12,  7.660582701335811e-13, -5.493475531517624e-14,  3.315172146116147e-15, -1.730360065642001e-16,  7.969809286580900e-18, -3.289155804875552e-19,
  1.231050690923245e-20, -4.215412267257977e-22,  5.884080913192687e-10, -2.015647664954478e-10,  3.628354477664564e-11, -4.437652953947431e-12,  4.120926485838621e-13,
 -3.091642837655340e-14,  1.949530893901108e-15, -1.062001721425232e-16,  5.099178837638732e-18, -2.191378661783362e-19,  8.531496635936508e-21, -3.035489297826894e-22,
  2.692067032777088e-10, -9.616549034687109e-11,  1.809453286547153e-11, -2.312402917528650e-12,  2.241718271063082e-13, -1.753850127176699e-14,  1.152068942348597e-15,
 -6.530580484159731e-17,  3.259491452735979e-18, -1.454619446301689e-19,  5.875085247291491e-21, -2.166375825051705e-22,  1.268940558554113e-10, -4.708549123052540e-11,
  9.226327430527596e-12, -1.227627962224307e-12,  1.238146992417814e-13, -1.006861417444549e-14,  6.867873359047760e-16, -4.038717127632253e-17,  2.089193918880125e-18,
 -9.654199655563556e-20,  4.033966036033166e-21, -1.537441532014131e-22,  6.184850668278798e-11, -2.374754522322921e-11,  4.827659835787487e-12, -6.663698680271227e-13,
  6.967609524110792e-14, -5.869423641045767e-15,  4.143738629115755e-16, -2.519912487108836e-17,  1.346869562552065e-18, -6.425534230425641e-20,  2.769636764610492e-21,
 -1.087975709057531e-22,  3.125882899066102e-11, -1.237235604788138e-11,  2.599497767203768e-12, -3.708481681818145e-13,  4.005572747930720e-14, -3.483185458056842e-15,
  2.536594604742868e-16, -1.589988854412895e-17,  8.753046415348490e-19, -4.297832778988731e-20,  1.905281219885502e-21, -7.691680371422954e-23,  1.640698172432580e-11,
 -6.668984316555391e-12,  1.442575263281063e-12, -2.118986369110457e-13,  2.355566876830061e-14, -2.106939360378744e-15,  1.577223184637916e-16, -1.015589916866203e-17,
  5.739609215992825e-19, -2.891295599390633e-20,  1.314162853778757e-21, -5.435833787415250e-23,  8.938141049338981e-12, -3.717101725305004e-12,  8.245700941332145e-13,
 -1.242291977310359e-13,  1.415960870431194e-14, -1.297944712816077e-15,  9.952000091489840e-17, -6.560034398307914e-18,  3.793130431325783e-19, -1.953871212808934e-20,
  9.076230999297857e-22, -3.834614960307803e-23,  5.033154654949610e-12, -2.133593332992635e-12,  4.834624418543600e-13, -7.441472351105618e-14,  8.663097107598159e-15,
 -8.107596258341070e-16,  6.344038740055291e-17, -4.265591832380386e-18,  2.514697878861742e-19, -1.320072982937851e-20,  6.246317814412716e-22, -2.686843769917629e-23,
  2.898315240233544e-12, -1.247759117474663e-12,  2.876578480771023e-13, -4.505458437517164e-14,  5.336232854310454e-15, -5.079242814592526e-16,  4.040756846255057e-17,
 -2.761239960174215e-18,  1.653770089310243e-19, -8.816361912138332e-21,  4.235043290706579e-22, -1.848604381182152e-23,  1.664338240503511e-12, -7.250205530072340e-13,
  1.693720858122826e-13, -2.688528160560834e-14,  3.226705526628901e-15, -3.111505636883267e-16,  2.507055872960725e-17, -1.734650494207697e-18,  1.051634715945370e-19,
 -5.673318903373531e-21,  2.757029422106099e-22, -1.217108286078720e-23,  8.927408904262584e-13, -3.920811073714887e-13,  9.243861382216810e-14, -1.481020214509946e-14,
  1.793908986994147e-15, -1.745568749108225e-16,  1.418976149396261e-17, -9.903368458936404e-19,  6.054938000367153e-20, -3.293594250311913e-21,  1.613532686041067e-22,
 -7.179197710911707e-24,  3.485245172641994e-13, -1.537625213776469e-13,  3.643731554941215e-14, -5.868148320427384e-15,  7.144405668530357e-16, -6.986989924971614e-17,
  5.707831860924016e-18, -4.002901595291795e-19,  2.458950765649425e-20, -1.343726151561106e-21,  6.612595050250080e-23, -2.955096536339693e-24,  6.306425248004874e-02,
 -1.650991331834513e-04,  4.490700340132988e-07, -1.260306513900983e-09,  3.620221202458615e-12, -1.056618218002333e-14,  3.114314731711544e-17, -9.229378295643086e-20,
  2.741089447888142e-22, -8.142900676939123e-25,  2.415913731601177e-27, -7.154361872275169e-30,  5.993975170784249e-02, -2.013638690061520e-04,  8.018275443475603e-07,
 -3.308548996706067e-09,  1.349099226069627e-11, -5.382589558358429e-14,  2.102463729815411e-16, -8.061455232253797e-19,  3.041943799457706e-21, -1.132002041908848e-23,
  4.161061489751368e-26, -1.512797086046445e-28,  5.415288045499764e-02, -2.622713433729981e-04,  1.490081536996684e-06, -8.072594931281870e-09,  4.138045456366500e-11,
 -2.030996588737308e-13,  9.631036929636066e-16, -4.439179206564554e-18,  1.997253491627157e-20, -8.799003628687329e-23,  3.805131083951008e-25, -1.618414014662475e-27,
  4.651467736976600e-02, -3.288868049399041e-04,  2.455871849520627e-06, -1.648482938704414e-08,  1.024563668463822e-10, -6.015838900201071e-13,  3.376514183370965e-15,
 -1.825754332411397e-17,  9.564343203782652e-20, -4.874685980550421e-22,  2.425213514437490e-24, -1.180862860765517e-26,  3.799720268201234e-02, -3.816385091075930e-04,
  3.576693577813363e-06, -2.907626281001537e-08,  2.152278929597409e-10, -1.486042193943880e-12,  9.709169104904785e-15, -6.061414019171876e-17,  3.641208161831250e-19,
 -2.115806122119076e-21,  1.194071630335091e-23, -6.565985393116210e-26,  2.953135471974715e-02, -4.065155645242841e-04,  4.668652587665580e-06, -4.532415802982926e-08,
  3.942670381989258e-10, -3.160457953050479e-12,  2.374934307103446e-14, -1.692453924386414e-16,  1.153284295127189e-18, -7.561201095579666e-21,  4.792362776212946e-23,
 -2.947398685496971e-25,  2.184788778679860e-02, -3.984767407985488e-04,  5.526430760645866e-06, -6.335426557669252e-08,  6.407519863683446e-10, -5.904377314919156e-12,
  5.056071711848735e-14, -4.077220857033265e-16,  3.125549781670089e-18, -2.293781456647012e-20,  1.620290864862806e-22, -1.106350377013172e-24,  1.539583834656200e-02,
 -3.612844550130425e-04,  5.984272742615929e-06, -8.022912939766003e-08,  9.351380741789367e-10, -9.826505420758940e-12,  9.517810984965264e-14, -8.624305671806692e-16,
  7.388077068527954e-18, -6.030551883787719e-20,  4.718633968813527e-22, -3.555946445541975e-24,  1.034165767220112e-02, -3.045787282627728e-04,  5.967634127113248e-06,
 -9.277407732092548e-08,  1.236965364941018e-09, -1.472273591785805e-11,  1.602924226454743e-13, -1.622521858783351e-15,  1.544650809599646e-17, -1.394931109420569e-19,
  1.202871658659894e-21, -9.955548706948128e-24,  6.627497050773255e-03, -2.398959693508645e-04,  5.510691239661229e-06, -9.859501194305724e-08,  1.493983264779813e-09,
 -2.002375881597875e-11,  2.437361364958409e-13, -2.742227814435120e-15,  2.887428922986273e-17, -2.871864133259199e-19,  2.717395774513685e-21, -2.459745832972271e-23,
  4.056195753637043e-03, -1.772738598701731e-04,  4.734572128804513e-06, -9.682625674193752e-08,  1.657760556195211e-09, -2.489095762191051e-11,  3.371374911668244e-13,
 -4.197395414073927e-15,  4.867990285424076e-17, -5.311487022075875e-19,  5.493963305375082e-21, -5.419199813539839e-23,  2.373542926999141e-03, -1.233633939146276e-04,
  3.800682699304255e-06, -8.829355338970999e-08,  1.699050090694445e-09, -2.844574913798140e-11,  4.269003195360967e-13, -5.858349275987165e-15,  7.455864547269954e-17,
 -8.893093143827652e-19,  1.002182352049405e-20, -1.073765405896594e-22,  1.329684033948522e-03, -8.111815129903944e-05,  2.861739304831358e-06, -7.508423872070697e-08,
  1.616100339770054e-09, -3.004099146383669e-11,  4.976037136218816e-13, -7.499856485203494e-15,  1.043932029378414e-16, -1.356869969276715e-18,  1.660902832916450e-20,
 -1.927354971345379e-22,  7.141794237528382e-04, -5.056003662857259e-05,  2.028433509773767e-06, -5.978586344224819e-08,  1.432855657864653e-09, -2.945529306975498e-11,
  5.365857475693084e-13, -8.853152425566739e-15,  1.343622883929424e-16, -1.897552655346974e-18,  2.516014148163829e-20, -3.153823803677816e-22,  3.683688325032378e-04,
 -2.996123039957134e-05,  1.358181392001799e-06, -4.474341119442279e-08,  1.189000688242707e-09, -2.693078466521250e-11,  5.377508866609884e-13, -9.682716040479749e-15,
  1.597701725907392e-16, -2.445085785376533e-18,  3.502817336693603e-20, -4.731383832664634e-22,  1.827949532758294e-04, -1.692977777240428e-05,  8.619530283965558e-07,
 -3.158866083278904e-08,  9.270457338632489e-10, -2.305451368146420e-11,  5.030117136483003e-13, -9.855945852927323e-15,  1.763398812903378e-16, -2.916994655682602e-18,
  4.504278045601918e-20, -6.541102384042349e-22,  8.744315255549207e-05, -9.148646986752479e-06,  5.202160318984740e-07, -2.111364390396575e-08,  6.817194209591596e-10,
 -1.855262734082555e-11,  4.409802484138765e-13, -9.376780420675985e-15,  1.814490037668213e-16, -3.236599807586725e-18,  5.374806408872060e-20, -8.373496839781707e-22,
  4.041412565567890e-05, -4.742111274193032e-06,  2.995764095629719e-07, -1.340830941581916e-08,  4.745911300331821e-10, -1.408911305199086e-11,  3.637856161663419e-13,
 -8.372501217344807e-15,  1.748022214564372e-16, -3.354583132591625e-18,  5.978033569935081e-20, -9.970710685213740e-22,  1.809041393282633e-05, -2.364996046702499e-06,
  1.651683790599181e-07, -8.119380551556788e-09,  3.139541322059243e-10, -1.013596946741459e-11,  2.835149809432640e-13, -7.044676685909699e-15,  1.583151770316897e-16,
 -3.261472722327783e-18,  6.224066715290308e-20, -1.109182471814061e-21,  7.863867434905141e-06, -1.138472428643837e-06,  8.748860824766982e-08, -4.705393701466216e-09,
  1.981005832059669e-10, -6.934779026057747e-12,  2.095692734143235e-13, -5.608135297176269e-15,  1.353492436617046e-16, -2.986855758353124e-18,  6.091636726440080e-20,
 -1.157667235247238e-21,  3.329417421155841e-06, -5.307696377508492e-07,  4.468312000729095e-08, -2.619514750469691e-09,  1.196881075296305e-10, -4.529933204770924e-12,
  1.475138447572815e-13, -4.241132075078082e-15,  1.096781368330075e-16, -2.587201868962838e-18,  5.627863199057729e-20, -1.138384316329998e-21,  1.377301821969297e-06,
 -2.405020479444537e-07,  2.208661478935028e-08, -1.406303540018617e-09,  6.951524120308885e-11, -2.836523572994625e-12,  9.927817191870275e-14, -3.059338360343879e-15,
  8.458690783099206e-17, -2.128429915321060e-18,  4.928428644179452e-20, -1.059086436633891e-21,  5.586240310046721e-07, -1.063132004457602e-07,  1.060740457506496e-08,
 -7.309985430791468e-10,  3.897149719123632e-11, -1.709655707284463e-12,  6.414964522564780e-14, -2.113812743074578e-15,  6.234769177559709e-17, -1.670010550063601e-18,
  4.108166204873428e-20, -9.361187065926413e-22,  2.229767928076867e-07, -4.602923679328941e-08,  4.970114069636125e-09, -3.694466278959636e-10,  2.117829990610366e-11,
 -9.961122920811538e-13,  3.996764256758908e-14, -1.404926425409880e-15,  4.410870819333705e-17, -1.255042674933183e-18,  3.273448970320297e-20, -7.894506441134562e-22,
  8.794059181279666e-08, -1.960114984869685e-08,  2.281768896810891e-09, -1.823399129844218e-10,  1.120525498983419e-11, -5.635063062638665e-13,  2.411615090984640e-14,
 -9.021820247376251e-16,  3.008236232916822e-17, -9.073270479895432e-19,  2.504127902315240e-20, -6.379356718187429e-22,  3.441658607198041e-08, -8.246239196579102e-09,
  1.031066076555369e-09, -8.828467561163099e-11,  5.798594687324251e-12, -3.109286307244328e-13,  1.415678720820554e-14, -5.622741698079554e-16,  1.986682050297773e-17,
 -6.338174905426340e-19,  1.847193580464964e-20, -4.961127134939189e-22,  1.342667566928762e-08, -3.443365301274850e-09,  4.607467495612524e-10, -4.213300415656185e-11,
  2.948843191395514e-12, -1.681286885663127e-13,  8.122907617371818e-15, -3.416882219606799e-16,  1.276343442809582e-17, -4.297653273978012e-19,  1.319842206002078e-20,
 -3.729585555061580e-22,  5.246522264022125e-09, -1.434115673714721e-09,  2.046140203595380e-10, -1.991726676736863e-11,  1.480933633698237e-12, -8.952674478847487e-14,
  4.577602180325354e-15, -2.034254000513342e-16,  8.014353215211616e-18, -2.841688867374333e-19,  9.176305824471131e-21, -2.722520239900817e-22,  2.063716475945449e-09,
 -5.987756610867988e-10,  9.076470812869667e-11, -9.373697957472961e-12,  7.381789371406328e-13, -4.718000888382888e-14,  2.546136432738814e-15, -1.192287613978000e-16,
  4.942043726764384e-18, -1.840949509272522e-19,  6.236748580627239e-21, -1.938590192066572e-22,  8.213926607347271e-10, -2.519382484620542e-10,  4.042745710020862e-11,
 -4.414896758846699e-12,  3.670804122563405e-13, -2.473204777259488e-14,  1.404792650855890e-15, -6.913404502814489e-17,  3.007315648359029e-18, -1.174048900337857e-19,
  4.163061301169466e-21, -1.352651329518611e-22,  3.325574219696863e-10, -1.073953463989837e-10,  1.817673959061271e-11, -2.091892955592336e-12,  1.830568604912408e-13,
 -1.296212629290439e-14,  7.726964642639148e-16, -3.985443501778113e-17,  1.814605673621120e-18, -7.405642784660702e-20,  2.741834102835799e-21, -9.290447128263972e-23,
  1.376886848071722e-10, -4.662870182130042e-11,  8.293458255777783e-12, -1.002398180049220e-12,  9.201824534571928e-14, -6.826606435730727e-15,  4.258211231708729e-16,
 -2.295331322741086e-17,  1.090887594341584e-18, -4.641814433458232e-20,  1.789829245451983e-21, -6.308975497648988e-23,  5.860068420647952e-11, -2.072841770677071e-11,
  3.859967858612251e-12, -4.882460871149863e-13,  4.685989929287532e-14, -3.630598670556196e-15,  2.362393809385660e-16, -1.326888005026090e-17,  6.563839107153893e-19,
 -2.903994296697136e-20,  1.163073412976071e-21, -4.253872608743884e-23,  2.576457105775285e-11, -9.481486326988920e-12,  1.841570360980828e-12, -2.428995242604869e-13,
  2.428938925757628e-14, -1.958831831130415e-15,  1.325362093154018e-16, -7.732881636242164e-18,  3.969727120691577e-19, -1.820863022996742e-20,  7.553775172039294e-22,
 -2.858881098260425e-23,  1.175412366955249e-11, -4.482537038466353e-12,  9.046117155567102e-13, -1.239587079068614e-13,  1.286905411748379e-14, -1.076560281994274e-15,
  7.549147583284699e-17, -4.560748948443751e-18,  2.422156572324702e-19, -1.148392586270009e-20,  4.920217922627789e-22, -1.921499208423261e-23,  5.584499809752188e-12,
 -2.198346019656886e-12,  4.591600192179049e-13, -6.511892626125519e-14,  6.992959497781688e-15, -6.046719605854093e-16,  4.379317227467825e-17, -2.730405729568637e-18,
  1.495322089583268e-19, -7.305172155675808e-21,  3.222601255304831e-22, -1.294790189633522e-23,  2.769618940222216e-12, -1.121026084879843e-12,  2.413722353895136e-13,
 -3.529139122111638e-14,  3.905379514844772e-15, -3.477710579699862e-16,  2.592137397225072e-17, -1.662100309339022e-18,  9.355028762057305e-20, -4.693838249440294e-21,
  2.125226195864471e-22, -8.757753409195763e-24,  1.434160112510679e-12, -5.945532732336931e-13,  1.314349936609955e-13, -1.973330002724412e-14,  2.241529444711703e-15,
 -2.047859021589121e-16,  1.565097441244185e-17, -1.028398605767191e-18,  5.928085336918206e-20, -3.044459250386630e-21,  1.410108975860750e-22, -5.940724338995038e-24,
  7.727890079140427e-13, -3.268681568461466e-13,  7.388552059711758e-14, -1.134450225124653e-14,  1.317485210170339e-15, -1.230080373734480e-16,  9.602872805485489e-18,
 -6.442203637463171e-19,  3.789540287262357e-20, -1.985041349338003e-21,  9.373274947936883e-23, -4.023758165797263e-24,  4.289927757498418e-13, -1.844202233288102e-13,
  4.244778226135476e-14, -6.637636469602854e-15,  7.849003074194104e-16, -7.459302704470236e-17,  5.925124308399427e-18, -4.042880277135308e-19,  2.417855580270069e-20,
 -1.287150756180033e-21,  6.174454512259004e-23, -2.691551272348981e-24,  2.393895158544277e-13, -1.041946646008039e-13,  2.431777445901154e-14, -3.856374950464500e-15,
  4.623933469005834e-16, -4.454697800913620e-17,  3.586047060622252e-18, -2.479005803557859e-19,  1.501596986086024e-20, -8.093899659157618e-22,  3.930096644463313e-23,
 -1.733572969449363e-24,  1.258447155376267e-13, -5.524558805729418e-14,  1.301856711517554e-14, -2.084759302296446e-15,  2.523959398245146e-16, -2.454761798021096e-17,
  1.994536288140846e-18, -1.391388682899358e-19,  8.503118022158975e-21, -4.623233778579576e-22,  2.263940421062557e-23, -1.006883640293551e-24,  4.857650789106730e-14,
 -2.142676072699348e-14,  5.076373249729008e-15, -8.173486724013822e-16,  9.948823054682879e-17, -9.727382994667940e-18,  7.944721068938804e-19, -5.570387419477598e-20,
  3.421092383482476e-21, -1.869096455489764e-22,  9.196029151073839e-24, -4.108746079631940e-25,  6.241094665388153e-02, -1.615660987248882e-04,  4.342870525917762e-07,
 -1.204033814291190e-09,  3.416167601900843e-12, -9.848792612197790e-15,  2.867744475517779e-17, -8.397327527721897e-20,  2.464607306366427e-22, -7.236620161847415e-25,
  2.122337816597925e-27, -6.213626730954825e-30,  5.914687909767586e-02, -1.951044695247869e-04,  7.633854341303427e-07, -3.101038583878689e-09,  1.246316043126298e-11,
 -4.904021323743817e-14,  1.889780422423344e-16, -7.150149931774326e-19,  2.662846006476285e-21, -9.781376189946765e-24,  3.549532383678339e-26, -1.274132279617585e-28,
  5.312703836199421e-02, -2.507272209068152e-04,  1.397052831410711e-06, -7.441788714599504e-09,  3.753989941215289e-11, -1.814073389916984e-13,  8.472983327295992e-16,
 -3.847936549574926e-18,  1.706253666515192e-20, -7.410289678780317e-23,  3.159765021421424e-25, -1.325377930852746e-27,  4.523720942524732e-02, -3.100041204625751e-04,
  2.267506464744853e-06, -1.493754575632697e-08,  9.119536527631071e-11, -5.263518076155556e-13,  2.905640871145971e-15, -1.545998332486627e-17,  7.972240412740151e-20,
 -4.001016900508302e-22,  1.960619394938863e-24, -9.405222927978672e-27,  3.652574571656986e-02, -3.543642584128296e-04,  3.247499003925029e-06, -2.585827674559841e-08,
  1.877062943946925e-10, -1.272139044716511e-12,  8.164274456476640e-15, -5.009416237459182e-17,  2.958958016394871e-19, -1.691300850633388e-21,  9.392376920677369e-24,
 -5.083654779987039e-26,  2.797669157607697e-02, -3.712392731709541e-04,  4.160622513376573e-06, -3.949212883185186e-08,  3.363944044194716e-10, -2.643408785340100e-12,
  1.948872002849862e-14, -1.363495262383628e-16,  9.126742052749654e-19, -5.880499563360343e-21,  3.664303436869617e-23, -2.216423059910686e-25,  2.033782352501372e-02,
 -3.571405797012900e-04,  4.823998307204146e-06, -5.398469051894825e-08,  5.339296265478060e-10, -4.817333267308995e-12,  4.042900112412722e-14, -3.197551733019320e-16,
  2.405599180904112e-18, -1.733490719949868e-20,  1.202911071385046e-22, -8.071968791800735e-25,  1.404069184552440e-02, -3.170210825616546e-04,  5.105191653616975e-06,
 -6.672280299210513e-08,  7.596247265291331e-10, -7.807175125789593e-12,  7.403783976042389e-14, -6.573907495371135e-16,  5.522210047251132e-18, -4.422574021915178e-20,
  3.396968971850098e-22, -2.514102021653061e-24,  9.212221187408647e-03, -2.609754497417100e-04,  4.964014034379452e-06, -7.514374575445091e-08,  9.775710667098095e-10,
 -1.136935868295342e-11,  1.210884638656448e-13, -1.200089531828166e-15,  1.119468726227244e-17, -9.912204176090827e-20,  8.385201759060718e-22, -6.811608006990348e-24,
  5.749127025986199e-03, -2.001651301227581e-04,  4.458720288615386e-06, -7.760159213029448e-08,  1.146287025038802e-09, -1.499992286882960e-11,  1.784733239989849e-13,
 -1.964640518862438e-15,  2.025651277803353e-17, -1.974187379186477e-19,  1.831502058052217e-21, -1.626315495936611e-23,  3.416084741758353e-03, -1.436291965852658e-04,
  3.716696073635207e-06, -7.388201830512024e-08,  1.232174636484762e-09, -1.805021589459579e-11,  2.388217982185419e-13, -2.907430788701958e-15,  3.299955578274738e-17,
 -3.526288112755515e-19,  3.574417777394724e-21, -3.457142453411943e-23,  1.934789634692970e-03, -9.677376052437708e-05,  2.887156413728805e-06, -6.515466817638433e-08,
  1.220581652773386e-09, -1.992597143482641e-11,  2.919581839689063e-13, -3.915734390880705e-15,  4.874846159963019e-17, -5.692056035455785e-19,  6.283539492324149e-21,
 -6.598809720223421e-23,  1.045858144717524e-03, -6.143047640431641e-05,  2.097968982625386e-06, -5.344945997247040e-08,  1.119470559852325e-09, -2.028189878906437e-11,
  3.278587614377829e-13, -4.827553318065194e-15,  6.570667238927628e-17, -8.357533427593019e-19,  1.001809971219625e-20, -1.139126612916000e-22,  5.403469313767511e-04,
 -3.685316489546689e-05,  1.431172454414672e-06, -4.094959807136597e-08,  9.547178223404929e-10, -1.912283394799529e-11,  3.398641502284215e-13, -5.476577522674219e-15,
  8.125184291316240e-17, -1.122643057835497e-18,  1.457336262693227e-20, -1.789614103842453e-22,  2.672621480921360e-04, -2.095685255921052e-05,  9.196727243740596e-07,
 -2.940983811437225e-08,  7.601576712063199e-10, -1.677301358992256e-11,  3.266941210590547e-13, -5.744131996297752e-15,  9.263882842607121e-17, -1.386800753021059e-18,
  1.944789351183090e-20, -2.573126869618014e-22,  1.267809876887353e-04, -1.132945738210503e-05,  5.585629897140395e-07, -1.987221140990344e-08,  5.672498370746538e-10,
 -1.374204975919198e-11,  2.924456333308569e-13, -5.595035223237271e-15,  9.783535671146164e-17, -1.582983000637188e-18,  2.392637104541535e-20, -3.403303844965706e-22,
  5.779620267140630e-05, -5.839809587663265e-06,  3.216971037555096e-07, -1.267822401339632e-08,  3.982184406053887e-10, -1.055801706345363e-11,  2.447900022794125e-13,
 -5.082590725188304e-15,  9.612649271183881e-17, -1.677213967493917e-18,  2.726401003587957e-20, -4.160547780847205e-22,  2.537732951460144e-05, -2.878697565880536e-06,
  1.762820297797805e-07, -7.664349669626233e-09,  2.639756626949676e-10, -7.636324729408027e-12,  1.923634354557745e-13, -4.323720714559584e-15,  8.824071275329184e-17,
 -1.656649980416897e-18,  2.890251494090013e-20, -4.722565056384280e-22,  1.075896116783322e-05, -1.361283979128276e-06,  9.222205974495243e-08, -4.406169691206826e-09,
  1.658549430222486e-10, -5.219567633306578e-12,  1.424794899429150e-13, -3.458442540674358e-15,  7.599249260714561e-17, -1.531916939290096e-18,  2.862728922643994e-20,
 -4.998977205383271e-22,  4.416310109159493e-06, -6.195377603244694e-07,  4.622264696827457e-08, -2.417779792055199e-09,  9.914430100048949e-11, -3.384748065653128e-12,
  9.986442720934052e-14, -2.611629424796251e-15,  6.164999535141918e-17, -1.331717851187813e-18,  2.660468218649404e-20, -4.955846849913028e-22,  1.760428267355012e-06,
 -2.722968656573814e-07,  2.227706972101450e-08, -1.271143502608925e-09,  5.660797694020935e-11, -2.090680186041298e-12,  6.650451419645281e-14, -1.869498721829705e-15,
  4.730961156541609e-17, -1.092878903828179e-18,  2.329674449169701e-20, -4.620926163688527e-22,  6.837163836929421e-07, -1.159990178106104e-07,  1.036360880287822e-08,
 -6.428558045209190e-10,  3.099639997263000e-11, -1.235080802335423e-12,  4.225400279025351e-14, -1.273882817263624e-15,  3.448566794032671e-17, -8.502425357968045e-19,
  1.930313838466542e-20, -4.069659489814508e-22,  2.596525703840628e-07, -4.808245114968187e-08,  4.672706211759373e-09, -3.140298449564755e-10,  1.634525965188199e-11,
 -7.007917456387278e-13,  2.572233108445332e-14, -8.298123087642731e-16,  2.398058563539191e-17, -6.297750527490127e-19,  1.519909990537867e-20, -3.399905595304538e-22,
  9.679752970377234e-08, -1.947311626602226e-08,  2.050613262117239e-09, -1.488170048363767e-10,  8.337253997570598e-12, -3.836018694788301e-13,  1.506931743537886e-14,
 -5.190275427416969e-16,  1.597803702276886e-17, -4.460725647352666e-19,  1.142259171575396e-20, -2.706127775613156e-22,  3.557348754717100e-08, -7.739556422010837e-09,
  8.798659502802419e-10, -6.872917742825897e-11,  4.132351430709819e-12, -2.034998762065627e-13,  8.535066247839511e-15, -3.131428179892761e-16,  1.024709376486835e-17,
 -3.035026150659641e-19,  8.230288380947112e-21, -2.061275115966421e-22,  1.294659257649626e-08, -3.032963679458494e-09,  3.708837777142236e-10, -3.108289473930544e-11,
  1.999866154161019e-12, -1.051282944762646e-13,  4.695905444356232e-15, -1.831008853544671e-16,  6.355199605580366e-18, -1.992854059268530e-19,  5.711750215831670e-21,
 -1.509421037884670e-22,  4.688855447173595e-09, -1.177747390759971e-09,  1.543590241728291e-10, -1.383510019065169e-11,  9.497660887044873e-13, -5.315159716527648e-14,
  2.522214151379980e-15, -1.042711275400752e-16,  3.830144556642109e-18, -1.268896660503890e-19,  3.836040647499504e-21, -1.067583558205082e-22,  1.698671229308568e-09,
 -4.555701451755707e-10,  6.376669235026874e-11, -6.092761927350914e-12,  4.449599390851372e-13, -2.643687742962163e-14,  1.329308139796220e-15, -5.812544946927844e-17,
  2.254404052734909e-18, -7.873300057379541e-20,  2.505344248563288e-21, -7.328057109323694e-23,  6.189477464266708e-10, -1.765115035746185e-10,  2.629182021480900e-11,
 -2.669325786073615e-12,  2.067647353562147e-13, -1.300577651636648e-14,  6.911207451537556e-16, -3.188352070330063e-17,  1.302602387081900e-18, -4.784789215524797e-20,
  1.599115040958118e-21, -4.905590824796714e-23,  2.281267125115051e-10, -6.889664022305499e-11,  1.088170123052486e-11, -1.170059858357720e-12,  9.583364588311235e-14,
 -6.363483489220563e-15,  3.563926816111247e-16, -1.730155991302627e-17,  7.427361899642256e-19, -2.862728449425381e-20,  1.002564501032719e-21, -3.218532985555321e-23,
  8.555169861321989e-11, -2.725173119098508e-11,  4.547471711008875e-12, -5.161228482447228e-13,  4.455834169144271e-14, -3.114071532846862e-15,  1.832940445336825e-16,
 -9.338450041872900e-18,  4.201490184552164e-19, -1.694975498647584e-20,  6.205412472959255e-22, -2.079913343868453e-23,  3.284003576938075e-11, -1.098903353666893e-11,
  1.930259126605855e-12, -2.304500792506251e-13,  2.090294614390754e-14, -1.532809975858479e-15,  9.453956648327389e-17, -5.040616929805400e-18,  2.370356048165062e-19,
 -9.982837029748953e-21,  3.811024956798501e-22, -1.330412756495927e-23,  1.298014037937305e-11, -4.544388325399287e-12,  8.371166731196739e-13, -1.047588691964528e-13,
  9.949859997310577e-15, -7.631068551100636e-16,  4.916778055725220e-17, -2.735338081665658e-18,  1.340621750409856e-19, -5.878062310737054e-21,  2.333723433458143e-22,
 -8.463441099294955e-24,  5.313086543148695e-12, -1.938356792853578e-12,  3.730263424774695e-13, -4.875368229125583e-14,  4.831893878754738e-15, -3.862984387754485e-16,
  2.591750848009939e-17, -1.499821740404634e-18,  7.638398758934893e-20, -3.476663391712390e-21,  1.431494615584524e-22, -5.378506388884533e-24,  2.264160670285498e-12,
 -8.573049791732358e-13,  1.716881521517789e-13, -2.334755498411217e-14,  2.405843462658220e-15, -1.998019485745262e-16,  1.391193991496361e-17, -8.347219078849778e-19,
  4.403614373629907e-20, -2.074349149429095e-21,  8.831620602139376e-23, -3.428026628214507e-24,  1.009078045028947e-12, -3.949519834192963e-13,  8.198107841341376e-14,
 -1.155489893116582e-14,  1.233337944906455e-15, -1.060153839248700e-16,  7.634014147668308e-18, -4.733049072412157e-19,  2.578008984503028e-20, -1.252802953608711e-21,
  5.498272120301032e-23, -2.198133895973883e-24,  4.718514069426095e-13, -1.901369035214875e-13,  4.074044699900214e-14, -5.927827475236091e-15,  6.528549318216863e-16,
 -5.786597365839406e-17,  4.293559089533118e-18, -2.740943273429076e-19,  1.536117596945883e-20, -7.675309191932250e-22,  3.461081090485551e-23, -1.420663901802803e-24,
  2.317581558215900e-13, -9.576099300526673e-14,  2.109235544141431e-14, -3.155195955596761e-15,  3.571167833170492e-16, -3.251179988513716e-17,  2.476261321866863e-18,
 -1.621699527588301e-19,  9.317867710386053e-21, -4.770281615772744e-22,  2.202702615586641e-23, -9.252344819032765e-25,  1.192688805964216e-13, -5.032982050799766e-14,
  1.134721769289968e-14, -1.737750778560772e-15,  2.012969556640860e-16, -1.874730594650817e-17,  1.459981668093389e-18, -9.771227158521724e-20,  5.734520389991026e-21,
 -2.997112528686320e-22,  1.412128228273781e-23, -6.049118700997392e-25,  6.371782996808322e-14, -2.735003678013446e-14,  6.284444708730998e-15, -9.810309773488502e-16,
  1.158114542582842e-16, -1.098799251408526e-17,  8.714004756921188e-19, -5.936480400168810e-20,  3.544899888352388e-21, -1.884325268833395e-22,  9.025990949185215e-24,
 -3.929045830433999e-25,  3.450427821303250e-14, -1.500461553211871e-14,  3.498387062474856e-15, -5.542220048873164e-16,  6.638682937370199e-17, -6.389440921778083e-18,
  5.138595056529931e-19, -3.548948232430130e-20,  2.147727504769748e-21, -1.156637120463478e-22,  5.611328857486373e-24, -2.473080739817167e-25,  1.775872757585744e-14,
 -7.792508561216476e-15,  1.835357145509340e-15, -2.937569096302433e-16,  3.554604965776647e-17, -3.455403856899848e-18,  2.806184146905177e-19, -1.956644726031408e-20,
  1.195186224891969e-21, -6.495336264998800e-23,  3.179242646866471e-24, -1.413337314584561e-25,  6.773861987855328e-15, -2.987283581270413e-15,  7.075726474552345e-16,
 -1.138991103329965e-16,  1.386054849028493e-17, -1.354882118189483e-18,  1.106323912628673e-19, -7.755123151303384e-21,  4.761779822065814e-22, -2.600991951209504e-23,
  1.279416628579866e-24, -5.715143628414607e-26,  6.177154063762622e-02, -1.581486814607665e-04,  4.201602176940905e-07, -1.150914327785230e-09,  3.225888390810224e-12,
 -9.187881255639580e-15,  2.643280478574095e-17, -7.648749659092310e-20,  2.218733556107370e-22, -6.439896558354795e-25,  1.867166232330595e-27, -5.405162702951488e-30,
  5.837844439714383e-02, -1.891429188973402e-04,  7.273378480368627e-07, -2.909234661510799e-09,  1.152613766003936e-11, -4.473567224549746e-14,  1.700995326172322e-16,
 -6.351745643670375e-19,  2.334978144551376e-21, -8.467574210543648e-24,  3.033942017058424e-26, -1.075423176850830e-28,  5.214593080833414e-02, -2.398980619995016e-04,
  1.311238949835904e-06, -6.869106174286846e-09,  3.410668582545909e-11, -1.623057680422902e-13,  7.468158336153448e-16, -3.342288907197162e-18,  1.460895625640706e-20,
 -6.255675615929097e-23,  2.630556320292644e-25, -1.088343983333396e-27,  4.403237178770916e-02, -2.925570419499355e-04,  2.096675161948004e-06, -1.355898940333384e-08,
  8.133205497462443e-11, -4.615354921016921e-13,  2.506415026370041e-15, -1.312496251816674e-17,  6.663608071650300e-20, -3.293643961951830e-22,  1.589993821510393e-24,
 -7.515739531497781e-27,  3.515835305213158e-02, -3.295762743286535e-04,  2.954413103133214e-06, -2.304833041104944e-08,  1.641146258771520e-10, -1.092011908446600e-12,
  6.885538597646384e-15, -4.153133492368420e-17,  2.412651769042873e-19, -1.356788136376485e-21,  7.415621632583924e-24, -3.951457203245745e-26,  2.655542712027921e-02,
 -3.397622750544715e-04,  3.717345091708343e-06, -3.450859155784405e-08,  2.879105421508364e-10, -2.218378663464488e-12,  1.604989761031853e-14, -1.102662616949640e-16,
  7.251670545591752e-19, -4.592693457938364e-21,  2.814145970107034e-23, -1.674405337128356e-25,  1.898253813144396e-02, -3.210016238642079e-04,  4.224422641050909e-06,
 -4.616276504188918e-08,  4.466033412539291e-10, -3.946321400628998e-12,  3.246598743327489e-14, -2.518975272056934e-16,  1.860225586034874e-18, -1.316512529623678e-20,
  8.976209929613846e-23, -5.920616859776263e-25,  1.284949645293469e-02, -2.791868952829218e-04,  4.372585717148631e-06, -5.572732711207892e-08,  6.198566246539371e-10,
 -6.232564407781116e-12,  5.788301373209285e-14, -5.037336549038582e-16,  4.150159720831000e-18, -3.261758794630820e-20,  2.459858625449132e-22, -1.788278281660761e-24,
  8.242386517862292e-03, -2.246206473996948e-04,  4.149114057343143e-06, -6.117454335376888e-08,  7.767193343909359e-10, -8.829065126707714e-12,  9.200769419657662e-14,
 -8.930244901360127e-16,  8.164143611401429e-18, -7.089098276387430e-20,  5.884283112521754e-22, -4.692443345498674e-24,  5.014320220975792e-03, -1.679298298043459e-04,
  3.628350553766087e-06, -6.144572314256181e-08,  8.850187829554934e-10, -1.130952879521342e-11,  1.315631174701410e-13, -1.417296573299594e-15,  1.431206907407706e-17,
 -1.367034752106938e-19,  1.243676321261299e-21, -1.083528109122477e-23,  2.895859432585814e-03, -1.171323555950429e-04,  2.937425490426414e-06, -5.676950804787680e-08,
  9.224637865825370e-10, -1.318687533462914e-11,  1.704698565492605e-13, -2.029689372740154e-15,  2.254952031009655e-17, -2.360297880286032e-19,  2.345013762471557e-21,
 -2.224282225987583e-23,  1.589369016661377e-03, -7.649992207050045e-05,  2.210463605996474e-06, -4.846713660517568e-08,  8.840878585923406e-10, -1.407571803342593e-11,
  2.013919003796799e-13, -2.640301327619287e-15,  3.215867001889448e-17, -3.676449440636420e-19,  3.976224624984591e-21, -4.093489725248677e-23,  8.300340556423402e-04,
 -4.693606546378036e-05,  1.551927449144347e-06, -3.839752137774523e-08,  7.826890912707095e-10, -1.382301133095644e-11,  2.181001141810894e-13, -3.137843723144319e-15,
  4.176751630746480e-17, -5.199592080918624e-19,  6.104281694775707e-21, -6.802125984558938e-23,  4.130524862557610e-04, -2.713610902355048e-05,  1.020114002842605e-06,
 -2.833787616638908e-08,  6.427811372593158e-10, -1.254609011807291e-11,  2.175659470631224e-13, -3.424452547034741e-15,  4.967175417000502e-17, -6.715186541129676e-19,
  8.535346551909033e-21, -1.026928370258307e-22,  1.961758235309473e-04, -1.482735625127955e-05,  6.299034714380281e-07, -1.955418795140957e-08,  4.916296948375446e-10,
 -1.056866569748614e-11,  2.008096555913264e-13, -3.448031925861796e-15,  5.435583752857765e-17, -7.960219161136917e-19,  1.092829975076450e-20, -1.416418591518170e-22,
  8.908298957977981e-05, -7.679178725514223e-06,  3.665864074725217e-07, -1.266110765298084e-08,  3.515330599582185e-10, -8.296225961069714e-12,  1.722123192626404e-13,
 -3.217211744855617e-15,  5.498374715457254e-17, -8.702237574982253e-19,  1.287546449203694e-20, -1.793925475448342e-22,  3.875467763074663e-05, -3.780663518669824e-06,
  2.017345109540027e-07, -7.719585255732209e-09,  2.358648466081537e-10, -6.092281242534445e-12,  1.377807295841437e-13, -2.793440629104821e-15,  5.163674802340965e-17,
 -8.812932590033821e-19,  1.402344397905744e-20, -2.096223187682373e-22,  1.618845347766933e-05, -1.774689515944404e-06,  1.053240207922148e-07, -4.447765033569007e-09,
  1.490515024940076e-10, -4.201327138014874e-12,  1.032477540057897e-13, -2.266340218724845e-15,  4.521087243099356e-17, -8.303541205722583e-19,  1.418217977421365e-20,
 -2.270126299421700e-22,  6.509080324634907e-06, -7.967631907079978e-07,  5.234767448268800e-08, -2.430391462893674e-09,  8.904451130518329e-11, -2.731314048214749e-12,
  7.275380471985567e-14, -1.725010093480272e-15,  3.705772812057346e-17, -7.309501481880975e-19,  1.337489367125054e-20, -2.288430418548983e-22,  2.526191091344138e-06,
 -3.432504486166232e-07,  2.485565017577004e-08, -1.264162236446152e-09,  5.048145759263848e-11, -1.680473272110905e-12,  4.839983210367777e-14, -1.236799241592505e-15,
  2.855317468782893e-17, -6.036809915275257e-19,  1.181232499831041e-20, -2.156567826141438e-22,  9.492299391059084e-07, -1.423895375373442e-07,  1.131665731274251e-08,
 -6.283321063494075e-10,  2.726588435733952e-11, -9.824409962655249e-13,  3.052179573322339e-14, -8.387530094429040e-16,  2.076705255102343e-17, -4.697264360644635e-19,
  9.811079210739639e-21, -1.908008371920920e-22,  3.464955879966105e-07, -5.708776446276724e-08,  4.959889043348878e-09, -2.996270011744250e-10,  1.408796404145593e-11,
 -5.480206094059337e-13,  1.832195447313958e-14, -5.402898244957553e-16,  1.431796962913512e-17, -3.458205396201675e-19,  7.696500535280595e-21, -1.591678975711970e-22,
  1.233252577186993e-07, -2.220931154025798e-08,  2.101279978595642e-09, -1.376623657176579e-10,  6.993252097181020e-12, -2.929401414349282e-13,  1.051511445957311e-14,
 -3.320226273387158e-16,  9.398696468548527e-18, -2.419468709771561e-19,  5.727444196121311e-21, -1.257432703915455e-22,  4.297280953243997e-08, -8.419987161730563e-09,
  8.643025865314875e-10, -6.121162049245623e-11,  3.350192980178274e-12, -1.507358995341950e-13,  5.795652250427890e-15, -1.955331215741294e-16,  5.900553219021765e-18,
 -1.615869758919180e-19,  4.061314867360891e-21, -9.449487430773553e-23,  1.472451501880346e-08, -3.125122779858543e-09,  3.467801098009592e-10, -2.646632543528603e-11,
  1.556267024505403e-12, -7.501936124510460e-14,  3.082433411169073e-15, -1.108746659486197e-16,  3.559531701856252e-18, -1.034982822412602e-19,  2.756896528735557e-21,
 -6.786123546050499e-23,  4.985113769122792e-09, -1.141148758672655e-09,  1.364012180065281e-10, -1.118341018275723e-11,  7.045317364028442e-13, -3.629265071213786e-14,
  1.589807095774145e-15, -6.083356605126971e-17,  2.073428254902811e-18, -6.388538518750085e-20,  1.800125946683149e-21, -4.679344500359870e-23,  1.676261655584065e-09,
 -4.121224465705618e-10,  5.287671976064283e-11, -4.642832979615369e-12,  3.124761587510002e-13, -1.715670534582052e-14,  7.993090090241129e-16, -3.246306077153926e-17,
  1.172172895892263e-18, -3.819399582765666e-20,  1.136239997296313e-21, -3.113339397816108e-23,  5.629228664020966e-10, -1.480325155828763e-10,  2.031594156723328e-11,
 -1.904388295629152e-12,  1.365370337031411e-13, -7.969149812920513e-15,  3.938846402382298e-16, -1.693964057955925e-17,  6.465486948986684e-19, -2.223209342760571e-20,
  6.968737330614781e-22, -2.008832465192731e-23,  1.899142751528110e-10, -5.320046428393697e-11,  7.782367034098108e-12, -7.763363361725120e-13,  5.911983356873368e-14,
 -3.658076044333341e-15,  1.913247705704199e-16, -8.691860395324812e-18,  3.498670009755692e-19, -1.266781482379864e-20,  4.175015636725514e-22, -1.263568373407321e-23,
  6.476902397549562e-11, -1.924911809764571e-11,  2.990778238041149e-12, -3.164718438269560e-13,  2.552109450616453e-14, -1.669361636268411e-15,  9.214507559138037e-17,
 -4.410831316876450e-18,  1.867906958177950e-19, -7.105092742271672e-21,  2.456658217264007e-22, -7.789443931874457e-24,  2.247452435256228e-11, -7.057629550289964e-12,
  1.160504672305491e-12, -1.298280004253949e-13,  1.105257974773892e-14, -7.620310831009848e-16,  4.426789969510512e-17, -2.226854524154320e-18,  9.896207592066799e-20,
 -3.944944923290963e-21,  1.427631044518576e-22, -4.731673865646210e-24,  7.987575039461135e-12, -2.639642075776191e-12,  4.576720357326934e-13, -5.394629219848160e-14,
  4.832682643486253e-15, -3.501282539209104e-16,  2.134381072058952e-17, -1.125170290474904e-18,  5.233290856481448e-20, -2.180649984862304e-21,  8.239141758503574e-23,
 -2.847567383514054e-24,  2.927184563725399e-12, -1.013847653923248e-12,  1.846597757170783e-13, -2.285234120169562e-14,  2.147002784816679e-15, -1.629343313866016e-16,
  1.039098343726764e-17, -5.723610643812947e-19,  2.778292870714404e-20, -1.206822012699791e-21,  4.748048243878481e-23, -1.706834035819880e-24,  1.113399270542176e-12,
 -4.025208152863414e-13,  7.671919502081993e-14, -9.931697712315929e-15,  9.751744907096833e-16, -7.725890835878988e-17,  5.137998211735664e-18, -2.948005305357834e-19,
  1.488978639976281e-20, -6.722828997507200e-22,  2.746528727513965e-23, -1.024155175422651e-24,  4.422937038409458e-13, -1.662171345147748e-13,  3.302069406324522e-14,
 -4.454680485232937e-15,  4.554570911057812e-16, -3.753830936372025e-17,  2.594483326476307e-18, -1.545560262183244e-19,  8.097014566834027e-21, -3.788407978749679e-22,
  1.602356716990743e-23, -6.180088143708703e-25,  1.845046139041811e-13, -7.177995278452922e-14,  1.480257286704547e-14, -2.072837981680154e-15,  2.198437086486523e-16,
 -1.878036333716880e-17,  1.344204263545350e-18, -8.285232177159251e-20,  4.487167280205715e-21, -2.168530526168445e-22,  9.466129793684293e-24, -3.764743285861328e-25,
  8.116542363109245e-14, -3.255310550731005e-14,  6.939504683413439e-15, -1.004563062464366e-15,  1.100826561887869e-16, -9.709554785162567e-18,  7.170082310132416e-19,
 -4.556115103917457e-20,  2.541929811131196e-21, -1.264545791526187e-22,  5.678107007383762e-24, -2.321093058500021e-25,  3.773227262745849e-14, -1.553627197091929e-14,
  3.408894682461085e-15, -5.079751626673301e-16,  5.727735907983281e-17, -5.195279396182962e-18,  3.942768089082614e-19, -2.573086334800119e-20,  1.473403395656702e-21,
 -7.518156630684988e-23,  3.460392888289865e-24, -1.448991592111365e-25,  1.850784755530185e-14, -7.790823750837528e-15,  1.751711341278205e-15, -2.675290614291824e-16,
  3.090650843971544e-17, -2.870828230423555e-18,  2.229975964430915e-19, -1.488729548425525e-20,  8.715795785806976e-22, -4.544488795517884e-23,  2.136270575489671e-24,
 -9.130705032311746e-26,  9.498590674325418e-15, -4.070586794480834e-15,  9.336573404861065e-16, -1.454855281319758e-16,  1.714416725008000e-17, -1.623781361377424e-18,
  1.285551945114880e-19, -8.743440784245274e-21,  5.212638930720884e-22, -2.766485662679769e-23,  1.323135940501921e-24, -5.751129684115253e-26,  4.984172551254129e-15,
 -2.165384966187341e-15,  5.043349285390983e-16, -7.981265237165254e-17,  9.550201840263636e-18, -9.182167064125341e-19,  7.377150765664758e-20, -5.089984586845965e-21,
  3.077366082508004e-22, -1.655734913567404e-23,  8.025339374921979e-25, -3.533874774109037e-26,  2.508874294602055e-15, -1.100366199087126e-15,  2.590282911068803e-16,
 -4.143605363843973e-17,  5.011267257710791e-18, -4.868833342649780e-19,  3.951998093795085e-20, -2.754176866662835e-21,  1.681510562670850e-22, -9.133866939054030e-24,
  4.468590015375946e-25, -1.985599809847318e-26,  9.450862375402495e-16, -4.166947726652579e-16,  9.867483419006752e-17, -1.587988514000644e-17,  1.931965662638635e-18,
 -1.888050386606348e-19,  1.541306110081529e-20, -1.080168281449510e-21,  6.630859099659405e-23, -3.621086733904779e-24,  1.780791181121954e-25, -7.953003447962436e-27,
  6.114558222638373e-02, -1.548417799105034e-04,  4.066529767412899e-07, -1.100736420151872e-09,  3.048305222510471e-12, -8.578412363181268e-15,  2.438716901038683e-17,
 -6.974452505796518e-20,  1.999787190304093e-22, -5.738471459722655e-25,  1.645026211375167e-27, -4.709207798666776e-30,  5.763329336345478e-02, -1.834607908539091e-04,
  6.935047181066464e-07, -2.731758255203182e-09,  1.067084999764386e-11, -4.085853235023013e-14,  1.533165063130414e-16, -5.651073122472810e-19,  2.050896292088187e-21,
 -7.343536528060184e-24,  2.598316733471974e-26, -9.096066817805257e-29,  5.120680911095275e-02, -2.297288310105797e-04,  1.231979865618385e-06, -6.348425170263651e-09,
  3.103249039250058e-11, -1.454543816569363e-13,  6.594519533890255e-16, -2.908894256421601e-18,  1.253531948769395e-20, -5.293276158865037e-23,  2.195434973920806e-25,
 -8.960661631192769e-28,  4.289469027191040e-02, -2.764130307295644e-04,  1.941480808789315e-06, -1.232837458797212e-08,  7.267431767544549e-11, -4.055610954224477e-13,
  2.167070426545700e-15, -1.117066560546826e-17,  5.584833619824321e-20, -2.719141321208991e-22,  1.293365418805979e-24, -6.025189915570671e-27,  3.388562779414300e-02,
 -3.070042536100354e-04,  2.692895455189184e-06, -2.058861980113976e-08,  1.438370483408383e-10, -9.398842622939214e-13,  5.823794362263971e-15, -3.453834509809795e-17,
  1.973661384982817e-19, -1.092213252748664e-21,  5.876288522670584e-24, -3.083179263765567e-26,  2.525333916573798e-02, -3.116048560355438e-04,  3.329482311110171e-06,
 -3.023703884440468e-08,  2.471577912429470e-10, -1.867753727024958e-12,  1.326393076554896e-14, -8.950268558227681e-17,  5.784340668103161e-19, -3.601634707592109e-21,
  2.170516262966845e-23, -1.270600978286146e-25,  1.776277794787925e-02, -2.893063141386148e-04,  3.710869672715875e-06, -3.960846977866323e-08,  3.749304385225923e-10,
 -3.245463050368618e-12,  2.617964846092050e-14, -1.993083790429217e-16,  1.445088567394195e-18, -1.004620899848881e-20,  6.731470949834198e-23, -4.365083688672095e-25,
  1.179870109125058e-02, -2.467215261164385e-04,  3.759482550905464e-06, -4.673589078202621e-08,  5.080279814162415e-10, -4.998640329724176e-12,  4.547391378917192e-14,
 -3.879611554387057e-16,  3.135580910053897e-18, -2.418896032454240e-20,  1.791434882279012e-22, -1.279499156853108e-24,  7.405921987556318e-03, -1.941655262038092e-04,
  3.484124037100328e-06, -5.004770553787548e-08,  6.203376245853306e-10, -6.893620322815883e-12,  7.030707244069987e-14, -6.684376985615295e-16,  5.990276873704451e-18,
 -5.101935893729462e-20,  4.156031429287993e-22, -3.254110212067494e-24,  4.396303145216736e-03, -1.416278342551929e-04,  2.969020366866371e-06, -4.893600553432104e-08,
  6.874382737203269e-10, -8.580698972981889e-12,  9.761418644195105e-14, -1.029311400630063e-15,  1.018203754584178e-17, -9.533392110229065e-20,  8.506729814690771e-22,
 -7.272875469189481e-24,  2.470343844026286e-03, -9.612566804193361e-05,  2.336715172184510e-06, -4.391564503428777e-08,  6.954260115777204e-10, -9.703283821054503e-12,
  1.225821140819171e-13, -1.427710213220841e-15,  1.552878020082973e-17, -1.592441768708456e-19,  1.550981905555397e-21, -1.442959350725775e-23,  1.315366532301372e-03,
 -6.092196958846665e-05,  1.705227142139177e-06, -3.633442076293265e-08,  6.454721696553039e-10, -1.002438113086184e-11,  1.400808570072277e-13, -1.795500119321036e-15,
  2.139931547722397e-17, -2.395644964554187e-19,  2.538859450569451e-21, -2.562635317172602e-23,  6.644774316685949e-04, -3.617013669014827e-05,  1.158017880242694e-06,
 -2.782913626560256e-08,  5.521691183093308e-10, -9.507638268955611e-12,  1.464431701134000e-13, -2.058949294964842e-15,  2.680658040136758e-17, -3.266592070243734e-19,
  3.756441044233691e-21, -4.102663126642044e-23,  3.189000202610401e-04, -2.017795508238304e-05,  7.343231785291252e-07, -1.980668029469698e-08,  4.371499052276505e-10,
 -8.315693774443958e-12,  1.407230521840007e-13, -2.163792415249223e-15,  3.068883902216467e-17, -4.059938138590805e-19,  5.053307678359601e-21, -5.957447163475192e-23,
  1.456283021281601e-04, -1.060751903648366e-05,  4.362407051807196e-07, -1.314684436065219e-08,  3.215440866791797e-10, -6.734961303452035e-12,  1.248456173042336e-13,
 -2.093646368729419e-15,  3.226440225014979e-17, -4.622727391131340e-19,  6.213432272289931e-21, -7.889618177977240e-23,  6.338944441758815e-05, -5.269893640931468e-06,
  2.435763859185490e-07, -8.166799443437871e-09,  2.205593702819784e-10, -5.071033995470524e-12,  1.026816421186907e-13, -1.873225549662558e-15,  3.129182838232471e-17,
 -4.844712149867049e-19,  7.017055895414632e-21, -9.577156780902336e-23,  2.635277467048139e-05, -2.481384857008727e-06,  1.282382682529125e-07, -4.764421598734482e-09,
  1.416044421113499e-10, -3.563270604420166e-12,  7.860656885406069e-14, -1.556239149919907e-15,  2.811679159044752e-17, -4.694103735124001e-19,  7.311882012208605e-21,
 -1.070638784457743e-22,  1.048665007897929e-05, -1.110655656602956e-06,  6.387045448213337e-08, -2.619471392288845e-09,  8.540489211154881e-11, -2.345530608223132e-12,
  5.623102703565092e-14, -1.205365358374861e-15,  2.350359290664185e-17, -4.222856893932285e-19,  7.060811866018036e-21, -1.107185979538992e-22,  4.004287664232718e-06,
 -4.740284252874223e-07,  3.019621427915199e-08, -1.362108494001250e-09,  4.856820292697329e-11, -1.451883957527485e-12,  3.773521174850725e-14, -8.738968444140243e-16,
  1.835344812302759e-17, -3.541986538438178e-19,  6.345774457175532e-21, -1.063792836203348e-22,  1.471273865075510e-06, -1.935500705205192e-07,  1.359904892193062e-08,
 -6.723664835744412e-10,  2.614182472177388e-11, -8.484219847326008e-13,  2.385040702885132e-14, -5.954644965135501e-16,  1.344310061101660e-17, -2.781535258710085e-19,
  5.330342830428147e-21, -9.537031862856179e-23,  5.217695479253063e-07, -7.586940691129242e-08,  5.855756022843085e-09, -3.162784154742007e-10,  1.337048769516407e-11,
 -4.699205750810092e-13,  1.425578769808025e-14, -3.829089142435168e-16,  9.274459180761786e-18, -2.053743803937038e-19,  4.202522345358949e-21, -8.012150953524925e-23,
  1.792110130957545e-07, -2.865879752303623e-08,  2.420412209777500e-09, -1.423519994327868e-10,  6.524971884274235e-12, -2.477330736518860e-13,  8.092150059479634e-15,
 -2.333581305182547e-16,  6.052573240688445e-18, -1.431846959961791e-19,  3.123364606225890e-21, -6.334994277044178e-23,  5.984017693882322e-08, -1.047441088929239e-08,
  9.643972742700324e-10, -6.156789333107946e-11,  3.051537893166886e-12, -1.248512334756859e-13,  4.381518074784664e-15, -1.353798528691530e-16,  3.752949152304390e-18,
 -9.467955864918076e-20,  2.197934537774416e-21, -4.735072514886417e-23,  1.950621151651720e-08, -3.720381585588368e-09,  3.720839765053732e-10, -2.570559302320777e-11,
  1.373938771673705e-12, -6.043051604207871e-14,  2.273416580187238e-15, -7.510897856372558e-17,  2.221185894480623e-18, -5.965099917371475e-20,  1.471201871837119e-21,
 -3.361006544570139e-23,  6.235802192170378e-09, -1.290308936790857e-09,  1.396835799622100e-10, -1.041123907606490e-11,  5.984784097397321e-13, -2.822902062105045e-14,
  1.135902863314515e-15, -4.004423454713461e-17,  1.260863458008876e-18, -3.597982287819713e-20,  9.411506120389482e-22, -2.276270740728069e-23,  1.964825893886950e-09,
 -4.392149884292228e-10,  5.128899050407783e-11, -4.111889370767958e-12,  2.535252347458233e-13, -1.279262453900982e-14,  5.493436114324732e-16, -2.062116665642301e-17,
  6.899489668962162e-19, -2.088112958986669e-20,  5.782660568592589e-22, -1.478158271782977e-23,  6.135242285886906e-10, -1.475505954215981e-10,  1.852227200755128e-11,
 -1.592425763697526e-12,  1.050237342404914e-13, -5.654974001169078e-15,  2.585515021891017e-16, -1.031204735699193e-17,  3.658788401133825e-19, -1.172140522968864e-20,
  3.430251818538029e-22, -9.250800293080745e-24,  1.909723069978835e-10, -4.921140497606897e-11,  6.618174396419788e-12, -6.083112534972720e-13,  4.279526415435388e-14,
 -2.452615286909404e-15,  1.191075562771504e-16, -5.036050902296111e-18,  1.890813192669132e-19, -6.399106872093521e-21,  1.975152604364306e-22, -5.609304779753110e-24,
  5.963238844395425e-11, -1.639861284851810e-11,  2.354518903397795e-12, -2.306562161717321e-13,  1.725992585011866e-14, -1.050056729851334e-15,  5.403032729287629e-17,
 -2.416147906780713e-18,  9.578161615976081e-20, -3.417119185091307e-21,  1.110182648829679e-22, -3.313666640205372e-24,  1.880546211614133e-11, -5.496488053807157e-12,
  8.396270428308917e-13, -8.738666716848883e-14,  6.934980379479561e-15, -4.466463643455722e-16,  2.428716998189420e-17, -1.145855586953661e-18,  4.784882786148885e-20,
 -1.795492003464317e-21,  6.126844898818381e-23, -1.918035422230517e-24,  6.031773777603631e-12, -1.866228396026228e-12,  3.022215945148827e-13, -3.330878860267049e-14,
  2.794851803993678e-15, -1.900085966626775e-16,  1.088908906654158e-17, -5.406115360060293e-19,  2.372099823128720e-20, -9.339997760403835e-22,  3.339841836303298e-23,
 -1.094186838778066e-24,  1.982216349620232e-12, -6.465771373472961e-13,  1.106000274901833e-13, -1.286445737088862e-14,  1.137647132956549e-15, -8.139683239838333e-17,
  4.902116330589021e-18, -2.554030036725657e-19,  1.174455794287755e-20, -4.840081467445275e-22,  1.809245361669235e-23, -6.188473696195680e-25,  6.724354074914768e-13,
 -2.302952227721622e-13,  4.145356624803553e-14, -5.070733031669595e-15,  4.710360203325071e-16, -3.535573685396723e-17,  2.230872775912572e-18, -1.216187844630523e-19,
  5.844636696972167e-21, -2.514215946137628e-22,  9.798953264854209e-24, -3.490508066344368e-25,  2.372341199418396e-13, -8.495201841914227e-14,  1.602903518748557e-14,
 -2.054437736514277e-15,  1.997665172737040e-16, -1.567757423652393e-17,  1.033083685420514e-18, -5.874899028087059e-20,  2.941757829146394e-21, -1.317128968763360e-22,
  5.337345010147589e-24, -1.974611507439888e-25,  8.766737286749286e-14, -3.268693158411170e-14,  6.439037381416316e-15, -8.614226693571598e-16,  8.735622154567247e-17,
 -7.142721825719139e-18,  4.898710394949972e-19, -2.896389899124769e-20,  1.506371462489172e-21, -6.998302858899257e-23,  2.939770579027928e-24, -1.126314257355609e-25,
  3.415488818962628e-14, -1.320341732595711e-14,  2.704214978608415e-15, -3.761008657788752e-16,  3.962322104047861e-17, -3.362883513537293e-18,  2.391795889380021e-19,
 -1.465188093339772e-20,  7.888021144950155e-22, -3.790037298317064e-23,  1.645148438730890e-24, -6.507261548699088e-26,  1.410303855630933e-14, -5.628369350294842e-15,
  1.193377323183595e-15, -1.718264318411371e-16,  1.873010568383406e-17, -1.643562897321933e-18,  1.207640020107525e-19, -7.636518991279188e-21,  4.240448706483377e-22,
 -2.099853162382475e-23,  9.386871443569123e-25, -3.820607261026518e-26,  6.191462040942605e-15, -2.539930845745190e-15,  5.550444952470075e-16, -8.237478148186728e-17,
  9.251322306591538e-18, -8.358728227401053e-19,  6.319571084830257e-20, -4.109046074223065e-21,  2.344516658288239e-22, -1.192152363540391e-23,  5.468611477862583e-25,
 -2.282410264628382e-26,  2.888492093823373e-15, -1.212737166270563e-15,  2.718909989756897e-16, -4.140453725619619e-17,  4.769712622490117e-18, -4.418176916388968e-19,
  3.422635065951389e-20, -2.278936718715405e-21,  1.330794098844918e-22, -6.921607087471432e-24,  3.245833179495647e-25, -1.384057491178332e-26,  1.421445662799917e-15,
 -6.081195371148578e-16,  1.392185619177424e-16, -2.165221194616956e-17,  2.546736882876629e-18, -2.407676970525956e-19,  1.902755260759812e-20, -1.291869058542181e-21,
  7.688767483860509e-23, -4.073899236582572e-24,  1.945308386195355e-25, -8.442285272722779e-27,  7.216335357462744e-16, -3.132030103706531e-16,  7.286609043219609e-17,
 -1.151833350026749e-17,  1.376728609414221e-18, -1.322234917309851e-19,  1.061184028054590e-20, -7.314227813252687e-22,  4.417662471586453e-23, -2.374525086461786e-24,
  1.149828199873946e-25, -5.058435257750968e-27,  3.548628689159340e-16, -1.555611652818090e-16,  3.659872941148440e-17, -5.851255323103634e-18,  7.072493385550411e-19,
 -6.867654955994234e-20,  5.571392759139446e-21, -3.880677250042766e-22,  2.368040678182619e-23, -1.285651529328766e-24,  6.286706991193169e-26, -2.792120433440590e-27,
  1.319289077928767e-16, -5.815532924423586e-17,  1.376789790467429e-17, -2.215114621558664e-18,  2.694239654341098e-19, -2.632325408001832e-20,  2.148352840439038e-21,
 -1.505221903406393e-22,  9.237895572389842e-24, -5.043570217645293e-25,  2.479760759718827e-26, -1.107203957463227e-27,  6.053263905201601e-02, -1.516405751415430e-04,
  3.937312164766697e-07, -1.053304932899567e-09,  2.882435373048690e-12, -8.015849988544149e-15,  2.252089536359613e-17, -6.366343661164626e-20,  1.804563828147710e-22,
 -5.120071272899859e-25,  1.451343712110758e-27, -4.109124071724382e-30,  5.691034267923161e-02, -1.780410358663561e-04,  6.617216872364809e-07, -2.567367345150630e-09,
  9.889230964843688e-12, -3.736163350751003e-14,  1.383739459368264e-16, -5.035154877190976e-19,  1.804311438518574e-21, -6.379993827932672e-24,  2.229491459704261e-26,
 -7.709324823924801e-29,  5.030713461630700e-02, -2.201694912944521e-04,  1.158684594534993e-06, -5.874344998846313e-09,  2.827530085896830e-11, -1.305612975449191e-13,
  5.833439167617099e-16, -2.536632604741917e-18,  1.077875426398732e-20, -4.489118262702333e-23,  1.836737813590773e-25, -7.396623787632910e-28,  4.181919200215797e-02,
 -2.614537774321152e-04,  1.800258249542025e-06, -1.122775224449320e-08,  6.505886417111169e-11, -3.571115016406980e-13,  1.877908538870989e-15, -9.530652778156651e-18,
  4.693014004590391e-20, -2.251144236674471e-22,  1.055204910799075e-24, -4.845413344669657e-27,  3.269918578200087e-02, -2.864116009085619e-04,  2.459043781823931e-06,
 -1.843033069686286e-08,  1.263622806832946e-10, -8.110391783944279e-13,  4.939538365422970e-15, -2.880890416391821e-17,  1.619697525210033e-19, -8.821992105452627e-22,
  4.673048530694036e-24, -2.414667182685441e-26,  2.405798474580539e-02, -2.863558791881960e-04,  2.989186061530230e-06, -2.656487452763616e-08,  2.127933903562550e-10,
 -1.577514747288757e-12,  1.099863618332252e-14, -7.291012527137717e-17,  4.631435421886726e-19, -2.835710167531947e-21,  1.681087612010749e-23, -9.683821461369798e-26,
  1.666205410010652e-02, -2.614233025894589e-04,  3.269524967609523e-06, -3.409652609722691e-08,  3.158779142626694e-10, -2.679210149207098e-12,  2.119554174552480e-14,
 -1.583678580113294e-16,  1.127594602683991e-18, -7.701850115456626e-21,  5.072536297069055e-23, -3.234416330554148e-25,  1.086860030925528e-02, -2.187580350765730e-04,
  3.244305904794715e-06, -3.935142679017019e-08,  4.181443732256156e-10, -4.027040857859460e-12,  3.589408818316588e-14, -3.002754891890835e-16,  2.381255122331684e-18,
 -1.803447883403602e-20,  1.311884753510175e-22, -9.207213111631935e-25,  6.681427350141654e-03, -1.685360046828043e-04,  2.938834675731309e-06, -4.113959685769626e-08,
  4.979280399098615e-10, -5.410773777773224e-12,  5.401969340460325e-14, -5.031881008548769e-16,  4.421239810458501e-18, -3.694238364547547e-20,  2.953869972020043e-22,
 -2.271280724467614e-24,  3.873824763686930e-03, -1.200498781439473e-04,  2.442506171671736e-06, -3.919179115725637e-08,  5.370948534626821e-10, -6.549939891093305e-12,
  7.288250239557113e-14, -7.524100925147473e-16,  7.292469713115557e-18, -6.694297194197926e-20,  5.859842500557857e-22, -4.917170238863915e-24,  2.120139854339432e-03,
 -7.936451582643382e-05,  1.870567102739817e-06, -3.419415261072207e-08,  5.278111848701029e-10, -7.189769515813435e-12,  8.877996640333021e-14, -1.011681159967441e-15,
  1.077485170491551e-17, -1.082708129242955e-19,  1.033934326872547e-21, -9.436562031855180e-24,  1.096430042505138e-03, -4.886276605515608e-05,  1.325111468405165e-06,
 -2.744389818228447e-08,  4.749002396216476e-10, -7.195667792658672e-12,  9.822514651860933e-14, -1.231123677625034e-15,  1.436017805193147e-17, -1.574508708695333e-19,
  1.635319843907553e-21, -1.618604676359597e-23,  5.364045883548402e-04, -2.810490381787345e-05,  8.713703714536988e-07, -2.034267749894616e-08,  3.929513807763719e-10,
 -6.597786936367746e-12,  9.922200827657399e-14, -1.363494126868249e-15,  1.736610595930985e-17, -2.071767911781145e-19,  2.333989067619386e-21, -2.498758554285654e-23,
  2.485846500914876e-04, -1.514672790538554e-05,  5.336636321206826e-07, -1.397805296656351e-08,  3.002229845999132e-10, -5.566631417034696e-12,  9.193922348867600e-14,
 -1.381202607720171e-15,  1.915680539347701e-17, -2.480302841361601e-19,  3.023461615910592e-21, -3.493030105542753e-23,  1.092901142597407e-04, -7.670452447186881e-06,
  3.053792733838410e-07, -8.934947949146958e-09,  2.126028676733923e-10, -4.339280079380514e-12,  7.848243256884268e-14, -1.285548810274234e-15,  1.936850780634070e-17,
 -2.715234239858269e-19,  3.573431404872854e-21, -4.445623550603790e-23,  4.566194464734022e-05, -3.660215762167613e-06,  1.637910962861415e-07, -5.331304350868120e-09,
  1.400566527207689e-10, -3.137292127773239e-12,  6.197127365200793e-14, -1.104071665345486e-15,  1.802819433736510e-17, -2.730594406389760e-19,  3.871915060670483e-21,
 -5.176940482021541e-23,  1.816494410318382e-05, -1.650471519747863e-06,  8.260303388967514e-08, -2.979538907623519e-09,  8.614091953753867e-11, -2.111742327832486e-12,
  4.544239798785102e-14, -8.785298533638480e-16,  1.551416582874678e-17, -2.533691024157090e-19,  3.863538888326955e-21, -5.541692245704458e-23,  6.895507289436784e-06,
 -7.053366656634136e-07,  3.929710671779302e-08, -1.565061258888314e-09,  4.964199034267576e-11, -1.328310510797447e-12,  3.106455403457652e-14, -6.502787125836801e-16,
  1.239391994440740e-17, -2.178359944180167e-19,  3.565697384193371e-21, -5.477311029676489e-23,  2.503891322779817e-06, -2.865534691392379e-07,  1.769445473779494e-08,
 -7.753727903198661e-10,  2.690368643696691e-11, -7.837357519961475e-13,  1.987399869726391e-14, -4.495219476079990e-16,  9.229048171116448e-18, -1.742556534592426e-19,
  3.056622107221002e-21, -5.020212435837491e-23,  8.721207438198892e-07, -1.110331984300422e-07,  7.567435751018747e-09, -3.636436509793315e-10,  1.376370013090863e-11,
 -4.354400882282793e-13,  1.194629724855215e-14, -2.913758352037214e-16,  6.431988619330875e-18, -1.302343002525150e-19,  2.444015589537221e-21, -4.285083992338990e-23,
  2.922720719552414e-07, -4.117737406736816e-08,  3.085372678236014e-09, -1.620676109716294e-10,  6.673091989881612e-12, -2.287250616840495e-13,  6.774422718261332e-15,
 -1.778248520516465e-16,  4.212877989546765e-18, -9.132067542694714e-20,  1.830514005995719e-21, -3.420883246880128e-23,  9.456739207676251e-08, -1.467121994909287e-08,
  1.204022839539174e-09, -6.891888118321406e-11,  3.078822872435676e-12, -1.140628863532553e-13,  3.639463056841033e-15, -1.026162764262568e-16,  2.604461296597771e-18,
 -6.033768111536978e-20,  1.289820116967137e-21, -2.565357941226691e-23,  2.965531137061746e-08, -5.042657790728400e-09,  4.516247934183714e-10, -2.808573792679427e-11,
  1.357729369426965e-12, -5.424235047541572e-14,  1.860607738948695e-15, -5.624145734309014e-17,  1.526502060281415e-18, -3.773298966237954e-20,  8.588378559353778e-22,
 -1.815216924280929e-23,  9.051434628611111e-09, -1.679501440956326e-09,  1.635795067682986e-10, -1.101938225551269e-11,  5.749675470315586e-13, -2.471334632870169e-14,
  9.094109072747656e-16, -2.941344247884908e-17,  8.522071634200192e-19, -2.243825614785056e-20,  5.429190611940260e-22, -1.217556811229127e-23,  2.701651107594688e-09,
 -5.446842781531394e-10,  5.749642263900502e-11, -4.183319374502291e-12,  2.349888234670475e-13, -1.084156256308789e-14,  4.270841162119736e-16, -1.475139953720797e-17,
  4.554049301318411e-19, -1.275014556763508e-20,  3.274233598599075e-22, -7.779013021225423e-24,  7.926633492605677e-10, -1.729246959549809e-10,  1.971702390426305e-11,
 -1.544935674694829e-12,  9.318638231836009e-14, -4.603992961965997e-15,  1.937372484513513e-16, -7.131780331829559e-18,  2.341604506733934e-19, -6.958829911972626e-21,
  1.893432141004436e-22, -4.758028098827512e-24,  2.299129968033720e-10, -5.405310848128652e-11,  6.635063207809995e-12, -5.582578350275561e-13,  3.606229970836624e-14,
 -1.903412254173265e-15,  8.537033632563281e-17, -3.342412687309243e-18,  1.164886332062572e-19, -3.667865571899516e-21,  1.055568161780866e-22, -2.800899657605976e-24,
  6.633507096260042e-11, -1.673965870590629e-11,  2.204758376719576e-12, -1.986037970578887e-13,  1.370309097482780e-14, -7.707692675173217e-16,  3.676196512665682e-17,
 -1.527519909387062e-18,  5.639458427915104e-20, -1.877751414934601e-21,  5.705217748757703e-23, -1.595698419087092e-24,  1.916635256315409e-11, -5.170760745569935e-12,
  7.282742411667399e-13, -7.002413077609335e-14,  5.146265884968774e-15, -3.076901796407513e-16,  1.556859382385348e-17, -6.850056360584346e-19,  2.673279910764814e-20,
 -9.393614386773486e-22,  3.007343856680462e-23, -8.849438683179919e-25,  5.585705390862369e-12, -1.604599574563341e-12,  2.408484413776672e-13, -2.464194165535851e-14,
  1.923486683956838e-15, -1.219174033264346e-16,  6.527869748524576e-18, -3.034170171198751e-19,  1.248841677753921e-20, -4.621089428859558e-22,  1.555644664663425e-23,
 -4.806498546797397e-25,  1.654550115092683e-12, -5.040711685149981e-13,  8.034885198603100e-14, -8.719532689150162e-15,  7.207400063425362e-16, -4.829370621363800e-17,
  2.729059219844660e-18, -1.336622228059817e-19,  5.788238297239277e-21, -2.250239586623256e-22,  7.947778385832518e-24, -2.572872590668479e-25,  5.021443802555331e-13,
 -1.615822151508307e-13,  2.725330901223147e-14, -3.126520551529097e-15,  2.728064374788708e-16, -1.926697297172800e-17,  1.145850714118014e-18, -5.897692264041468e-20,
  2.680218399653997e-21, -1.091997320191032e-22,  4.036939443106028e-24, -1.366078548849584e-25,  1.574408810795771e-13, -5.328928302925262e-14,  9.474901837076992e-15,
 -1.145048366961217e-15,  1.051206275612325e-16, -7.800594735950987e-18,  4.867769700555212e-19, -2.625382260663046e-20,  1.248618365597226e-21, -5.317318297640212e-23,
  2.052197631668494e-24, -7.241208374385953e-26,  5.142468059169663e-14, -1.823168660112947e-14,  3.403912801376479e-15, -4.317548978015779e-16,  4.155783281355806e-17,
 -3.229399330654205e-18,  2.107753019214308e-19, -1.187550690803547e-20,  5.893161457729746e-22, -2.615633520448884e-23,  1.050978390537054e-24, -3.856429817207815e-26,
  1.764138052797633e-14, -6.523270980497098e-15,  1.273712622708481e-15, -1.689117717765620e-16,  1.698316677974770e-17, -1.377121639678686e-18,  9.368704196975956e-20,
 -5.496019644216616e-21,  2.836732074300271e-22, -1.308193579824733e-23,  5.456072977551333e-25, -2.075922359533231e-26,  6.404584574918031e-15, -2.459321230410005e-15,
  5.000799257205064e-16, -6.905412276789541e-17,  7.224187113767744e-18, -6.089555519221881e-19,  4.302457148826587e-20, -2.618715469494435e-21,  1.401030219500823e-22,
 -6.690937396243686e-24,  2.887283644676191e-25, -1.135542322823304e-26,  2.476476836054822e-15, -9.831826531358681e-16,  2.072832529991421e-16, -2.967685266025260e-17,
  3.217054740727571e-18, -2.807735368032410e-19,  2.052219257196244e-20, -1.291109819609267e-21,  7.133867269531883e-23, -3.515684394519854e-24,  1.564263487979616e-25,
 -6.338006288701147e-27,  1.024344638445681e-15, -4.185801810782948e-16,  9.108080433627596e-17, -1.345969990925270e-17,  1.505293329969612e-18, -1.354497738555415e-19,
  1.019985919445468e-20, -6.606392372536611e-22,  3.755269878328899e-23, -1.902526288834663e-24,  8.696255834839575e-26, -3.617037312184588e-27,  4.535281296472784e-16,
 -1.898901481017759e-16,  4.244328938261256e-17, -6.443724142988618e-18,  7.400796614842586e-19, -6.835292309490096e-20,  5.280018435577354e-21, -3.505917502891498e-22,
  2.041777157767286e-23, -1.059168992861238e-24,  4.954242841383922e-26, -2.107326819335784e-27,  2.135823905927752e-16, -9.120992879738683e-17,  2.083920688186008e-17,
 -3.234540510150593e-18,  3.796943797079661e-19, -3.582673439946668e-20,  2.825998604440369e-21, -1.915177981449392e-22,  1.137812103731619e-23, -6.018225570772147e-25,
  2.868875288536681e-26, -1.242997806290879e-27,  1.047366129453920e-16, -4.540987810577378e-17,  1.055208758729995e-17, -1.666046037153657e-18,  1.989010667437650e-19,
 -1.908092153745031e-20,  1.529660866819726e-21, -1.053170854486634e-22,  6.354201159282939e-24, -3.411892070945759e-25,  1.650491647424767e-26, -7.253892351252348e-28,
  5.025541486639110e-17, -2.201884005140094e-17,  5.177278325838140e-18, -8.272252439201134e-19,  9.992846580202328e-20, -9.697765024506418e-21,  7.862827694246679e-22,
 -5.473685248092274e-23,  3.338292099543512e-24, -1.811452068039851e-25,  8.853207033901920e-27, -3.929988917902003e-28,  1.842683724421458e-17, -8.120813078883367e-18,
  1.922043277527859e-18, -3.091541444448594e-19,  3.759229606410234e-20, -3.671869623951578e-21,  2.995987335256975e-22, -2.098569533405501e-23,  1.287615502611708e-24,
 -7.028188311849064e-26,  3.454690265762092e-27, -1.542137549047524e-28,  5.993229749076671e-02, -1.485405120203443e-04,  3.813630741167365e-07, -1.008439730231797e-09,
  2.727382301018037e-12, -7.496103523640709e-15,  2.081647049622398e-17, -5.817288817318537e-20,  1.630269695817548e-22, -4.574113616605569e-25,  1.282217760157629e-27,
 -3.590877826153476e-30,  5.620857468688398e-02, -1.728678617709185e-04,  6.318385582600437e-07, -2.414941750193726e-09,  9.174098908883244e-12, -3.420352184954027e-14,
  1.250505050299559e-16, -4.492866997454481e-19,  1.589899276214504e-21, -5.552469575554976e-24,  1.916590430682774e-26, -6.547074517032100e-29,  4.944455975657511e-02,
 -2.111744858444741e-04,  1.090823112684021e-06, -5.442092778400428e-09,  2.579851964172600e-11, -1.173758202189199e-13,  5.169138871930069e-16, -2.216213088651204e-18,
  9.287435915139846e-21, -3.815570163231341e-23,  1.540287324365261e-25, -6.120960691366439e-28,  4.080135200171017e-02, -2.475734748706829e-04,  1.671542871497745e-06,
 -1.024158723712946e-08,  5.834656294972241e-11, -3.150815036111968e-13,  1.630912395390605e-15, -8.150807284639357e-18,  3.953706963330115e-20, -1.868787773610260e-22,
  8.633947227361040e-25, -3.908570006310484e-27,  3.159153032264010e-02, -2.675907282389524e-04,  2.249495446352658e-06, -1.653212340365750e-08,  1.112645546284302e-10,
 -7.016124720912677e-13,  4.200922691725233e-15, -2.409992231917344e-17,  1.333340284555381e-19, -7.149089703336063e-22,  3.729054413720073e-24, -1.897977464551454e-26,
  2.295844794021197e-02, -2.636619328407876e-04,  2.689839204625207e-06, -2.339890555808478e-08,  1.837256791366826e-10, -1.336460439256178e-12,  9.150173282874443e-15,
 -5.960101744789860e-17,  3.722009747445843e-19, -2.241334959696347e-21,  1.307314150641495e-23, -7.411797083003657e-26,  1.566619809864302e-02, -2.368217173375243e-04,
  2.889008235714502e-06, -2.944495156046939e-08,  2.670414971772223e-10, -2.219894218540704e-12,  1.722736032966909e-14, -1.263557274381976e-16,  8.836624893135162e-19,
 -5.931267854665573e-21,  3.840443283226985e-23, -2.408344827530513e-25,  1.004263921871515e-02, -1.945845516507034e-04,  2.809716958884680e-06, -3.326134851466961e-08,
  3.455791934658503e-10, -3.258430245944540e-12,  2.846236054131864e-14, -2.335246596900676e-16,  1.817457826746752e-18, -1.351592565203411e-20,  9.658905973314304e-23,
 -6.662429064619481e-25,  6.051358986866828e-03, -1.468723808873950e-04,  2.489605244435028e-06, -3.397254803962381e-08,  4.016137517107714e-10, -4.268537046886989e-12,
  4.172640202860116e-14, -3.808889459443798e-16,  3.281921177341392e-18, -2.690828628367105e-20,  2.112301263375242e-22, -1.595286752906283e-24,  3.429920628698476e-03,
 -1.022543171235824e-04,  2.019732190264450e-06, -3.155794063539139e-08,  4.220087793881854e-10, -5.029275000181795e-12,  5.474970776428620e-14, -5.534782451206062e-16,
  5.257003506840930e-18, -4.732252255495722e-20,  4.064365388573574e-22, -3.347978746590216e-24,  1.830201272644190e-03, -6.590795511458705e-05,  1.506512180141931e-06,
 -2.679274140785462e-08,  4.032155490592921e-10, -5.363348366590147e-12,  6.474659165033308e-14, -7.220151411084063e-16,  7.531219705797384e-18, -7.416801237473015e-20,
  6.945612575490376e-22, -6.219789329801864e-24,  9.202639486595451e-04, -3.946016842085930e-05,  1.037010962497582e-06, -2.087956458673832e-08,  3.520164075826645e-10,
 -5.204813757228320e-12,  6.941745318173040e-14, -8.509382714333285e-16,  9.715708858380789e-18, -1.043503045082687e-19,  1.062333845002053e-21, -1.031227014435154e-23,
  4.365195123460589e-04, -2.201275476199930e-05,  6.610132202656215e-07, -1.499364884192257e-08,  2.820139983823727e-10, -4.618093776642144e-12,  6.781993924179220e-14,
 -9.110463749930150e-16,  1.135296814985950e-17, -1.326162755509657e-19,  1.463832754605756e-21, -1.536424861479159e-23,  1.955790618553668e-04, -1.147444767276019e-05,
  3.914296347465420e-07, -9.957258296344752e-09,  2.081490095149785e-10, -3.762387957401836e-12,  6.065593277281062e-14, -8.904187660037543e-16,  1.207861520115936e-17,
 -1.530719466613998e-19,  1.827640341976935e-21, -2.069434466012317e-23,  8.288902951733371e-05, -5.604454601027594e-06,  2.160067175785120e-07, -6.136330859546175e-09,
  1.420643657583783e-10, -2.825742378749397e-12,  4.987119793866811e-14, -7.979902415785582e-16,  1.175538942741042e-17, -1.612604151564617e-19,  2.078223708130161e-21,
 -2.533389873100336e-23,  3.328465759180058e-05, -2.571985648301409e-06,  1.114259066099747e-07, -3.520998669133464e-09,  8.998181248986977e-11, -1.963874950790243e-12,
  3.784589262267748e-14, -6.585160770321517e-16,  1.051154670368280e-17, -1.557650720983081e-19,  2.162469435139697e-21, -2.832639716639223e-23,  1.268754659773771e-05,
 -1.112097415464624e-06,  5.389565528034778e-08, -1.887358724611362e-09,  5.307744162880476e-11, -1.267680634519416e-12,  2.661053339996564e-14, -5.023911383335435e-16,
  8.671868398954291e-18, -1.385456132881030e-19,  2.068216032254121e-21, -2.906109703761930e-23,  4.600667866442462e-06, -4.543637392976385e-07,  2.452137572370670e-08,
 -9.482792560731106e-10,  2.926055099640352e-11, -7.628058196522846e-13,  1.740222476347803e-14, -3.557369821475446e-16,  6.627228260618468e-18, -1.139470407054992e-19,
  1.825939208257474e-21, -2.747692097836030e-23,  1.590809616290030e-06, -1.759398707026825e-07,  1.052902294245772e-08, -4.481416013735083e-10,  1.512985058453421e-11,
 -4.294757175961556e-13,  1.062502767286454e-14, -2.347079366695492e-16,  4.710480515059170e-18, -8.701234668438261e-20,  1.494304918387768e-21, -2.404443059648408e-23,
  5.259551612409867e-07, -6.477778757479401e-08,  4.281416923120788e-09, -1.999218637799255e-10,  7.365178612996616e-12, -2.271121094394744e-13,  6.080245348453291e-15,
 -1.448645518460878e-16,  3.126560420834451e-18, -6.194549345479115e-20,  1.138324988011932e-21, -1.955646079859174e-23,  1.667787337623132e-07, -2.275623914581187e-08,
  1.654793106597771e-09, -8.451358496762715e-11,  3.388615004420890e-12, -1.132512851600028e-13,  3.274369273328715e-15, -8.398558578799245e-17,  1.945945261454437e-18,
 -4.128605725382380e-20,  8.105885972346075e-22, -1.484727959795915e-23,  5.089638105507582e-08, -7.656487355489548e-09,  6.103436911013209e-10, -3.399198558503668e-11,
  1.479597581385040e-12, -5.347622643339486e-14,  1.666403586533682e-15, -4.593040512034022e-17,  1.140548310782442e-18, -2.587202793534937e-20,  5.419024532330531e-22,
 -1.056753624187770e-23,  1.500586456225117e-08, -2.477462126887326e-09,  2.157424193753319e-10, -1.306474234412426e-11,  6.158268263860556e-13, -2.401691125717863e-14,
  8.050281920213846e-16, -2.380053768358155e-17,  6.323509878983045e-19, -1.531215088881435e-20,  3.416457182980571e-22, -7.083057196662354e-24,  4.292733846966800e-09,
 -7.744585596864760e-10,  7.342446875087126e-11, -4.821009446972552e-12,  2.454807060905821e-13, -1.030781813292429e-14,  3.709152342357546e-16, -1.174129205385428e-17,
  3.332050953353818e-19, -8.599297701943330e-21,  2.040806853010896e-22, -4.491783460190716e-24,  1.197265340754589e-09, -2.350495453757895e-10,  2.418141247216048e-11,
 -1.716696892596771e-12,  9.419503502541983e-14, -4.249258337106771e-15,  1.638196068447792e-16, -5.542063110618676e-18,  1.677047058162965e-19, -4.605414623851787e-21,
  1.160761652922169e-22, -2.708308639655892e-24,  3.272987514400102e-10, -6.963957947758899e-11,  7.748990862884222e-12, -5.931416504529776e-13,  3.498437203905979e-14,
 -1.691711378268297e-15,  6.973281324325131e-17, -2.516437581343608e-18,  8.105327644625018e-20, -2.364520877132206e-21,  6.319271539264731e-23, -1.560645232934311e-24,
  8.821707884189582e-11, -2.026182710661407e-11,  2.430691382017715e-12, -2.000430823968234e-13,  1.265113983649684e-14, -6.542702983117399e-16,  2.877484433857400e-17,
 -1.105491853935886e-18,  3.783146477930054e-20, -1.170364610073833e-21,  3.311143380906819e-23, -8.641923711140073e-25,  2.359529742421361e-11, -5.827121901596147e-12,
  7.512043377853024e-13, -6.628154727311202e-14,  4.483022800030175e-15, -2.473712678964369e-16,  1.158244739181927e-17, -4.727684299445349e-19,  1.715625792870295e-20,
 -5.618141541721363e-22,  1.679678174097891e-23, -4.625167886205815e-25,  6.307118164421957e-12, -1.668221988891672e-12,  2.303473661146011e-13, -2.172644555133230e-14,
  1.567410280407071e-15, -9.205427467567937e-17,  4.578197720173099e-18, -1.981126550124377e-19,  7.608117323114504e-21, -2.632127063424186e-22,  8.300637445349960e-24,
 -2.407171072319936e-25,  1.697825115305087e-12, -4.790623613492673e-13,  7.061369138563242e-14, -7.098280392486818e-15,  5.446995972052278e-16, -3.396093616708372e-17,
  1.789688116684698e-18, -8.191631640931019e-20,  3.321863953747862e-21, -1.211628638219121e-22,  4.022362877667833e-24, -1.226134077748191e-25,  4.640629999184627e-13,
 -1.391278773918020e-13,  2.181612446289581e-14, -2.329885987541010e-15,  1.896191080199214e-16, -1.251640787928173e-17,  6.971159033435337e-19, -3.366749634269260e-20,
  1.438319215907405e-21, -5.518621373022977e-23,  1.924495648269804e-24, -6.153673562489210e-26,  1.299156190524474e-13, -4.121637958282194e-14,  6.850850367580309e-15,
 -7.747524761939362e-16,  6.666775453697199e-17, -4.645437238005521e-18,  2.726981661275634e-19, -1.385987808231377e-20,  6.222206171434698e-22, -2.505290487304421e-23,
  9.156054159328490e-25, -3.064144872590343e-26,  3.759135222659910e-14, -1.256797800289461e-14,  2.206128126203173e-15, -2.632708880880175e-16,  2.387484258482544e-17,
 -1.750719525257285e-18,  1.079984020652742e-19, -5.760174746592281e-21,  2.710065280620057e-22, -1.142073647093297e-23,  4.363249154461905e-25, -1.524512090788021e-26,
  1.134707190264049e-14, -3.980961611433025e-15,  7.351043934455593e-16, -9.223177123589380e-17,  8.783953295765185e-18, -6.755970394945179e-19,  4.365670490900323e-20,
 -2.436026896403203e-21,  1.197583629831610e-22, -5.267272740184031e-24,  2.097841884672716e-25, -7.632301152580709e-27,  3.606154208694877e-15, -1.321874974839605e-15,
  2.557231869721303e-16, -3.360253061007484e-17,  3.348414460362155e-18, -2.691601566037146e-19,  1.815716582102248e-20, -1.056470744661156e-21,  5.409730436680654e-23,
 -2.475603417115270e-24,  1.024803645747557e-25, -3.871020981084384e-27,  1.217191677172480e-15, -4.641079811218355e-16,  9.365974546904848e-17, -1.283614987980340e-17,
  1.333024449075814e-18, -1.115642373614558e-19,  7.827731060257681e-21, -4.732348665074263e-22,  2.515313170369844e-23, -1.193636252899402e-24,  5.119131972828736e-26,
 -2.001319179682359e-27,  4.396924565508618e-16, -1.736014157649535e-16,  3.638200044459244e-17, -5.177889024805839e-18,  5.580318151496496e-19, -4.842705167104256e-20,
  3.520109734529179e-21, -2.202751910388246e-22,  1.210780688565224e-23, -5.936830028633385e-25,  2.628590899276953e-26, -1.059988158620144e-27,  1.709428302509561e-16,
 -6.956495044671497e-17,  1.506877961711744e-17, -2.216803916230251e-18,  2.468259875117988e-19, -2.211432791635067e-20,  1.658312881655257e-21, -1.069707632791215e-22,
  6.056492865064204e-24, -3.056607730373238e-25,  1.391933633631832e-26, -5.768555322583774e-28,  7.166285647070557e-17, -2.991749417653211e-17,  6.665536180071366e-18,
 -1.008703137077267e-18,  1.154861052659922e-19, -1.063324976376397e-20,  8.189125908958881e-22, -5.421670222479135e-23,  3.148508127161152e-24, -1.628777764832394e-25,
  7.598153084375469e-27, -3.223538759141927e-28,  3.223011131258023e-17, -1.373759022407598e-17,  3.132062854470944e-18, -4.851079833722166e-19,  5.682654543381774e-20,
 -5.351015574958091e-21,  4.212457113538047e-22, -2.849249170515254e-23,  1.689556227183418e-24, -8.920188324172142e-26,  4.244658826618605e-27, -1.835906665296146e-28,
  1.524041893597123e-17, -6.600319481029910e-18,  1.531836818824127e-18, -2.415553165495038e-19,  2.880247802242137e-20, -2.759729899191222e-21,  2.209782543483441e-22,
 -1.519684436011246e-23,  9.158593726039803e-25, -4.912349150446912e-26,  2.373810000502898e-27, -1.042211691992313e-28,  7.126456371596397e-18, -3.120642429323523e-18,
  7.332969171969014e-19, -1.170921695478622e-19,  1.413585258717802e-20, -1.371002030207110e-21,  1.110924418167420e-22, -7.729133320261835e-24,  4.711145206340165e-25,
 -2.554971599575596e-26,  1.248023364494753e-27, -5.537103266193572e-29,  2.575214009430807e-18, -1.134637680817941e-18,  2.684737911965560e-19, -4.317105178163206e-20,
  5.248022774679536e-21, -5.124656928532527e-22,  4.180227778521391e-23, -2.927302889073564e-24,  1.795629660773438e-25, -9.798558776849264e-27,  4.815242003428339e-28,
 -2.148941294324588e-29,  5.934416164296318e-02, -1.455372819069030e-04,  3.695187650672183e-07, -9.659743886932193e-10,  2.582327230700269e-12, -7.015479685563369e-15,
  1.925825902353460e-17, -5.320989614317518e-20,  1.474465324936226e-22, -4.091459689469185e-25,  1.134315595490487e-27, -3.142610663627487e-30,  5.552703257677871e-02,
 -1.679266261046927e-04,  6.037179131989703e-07, -2.273469841380355e-09,  8.519050557963820e-12, -3.134770052769944e-14,  1.131537254999994e-16, -4.014656374769243e-19,
  1.403143080637458e-21, -4.840450995579972e-24,  1.650608495507382e-26, -5.570920119536826e-29,  4.861691106075104e-02, -2.027022783333233e-04,  1.027919316403439e-06,
 -5.047443049651148e-09,  2.357020452741872e-11, -1.056821791218563e-13,  4.588223756382007e-16, -1.939854442081758e-18,  8.018536886599555e-21, -3.250096992179794e-23,
  1.294671372615234e-25, -5.077760635386257e-28,  3.983704621814572e-02, -2.346773233028194e-04,  1.554043823880821e-06, -9.356403661644837e-09,  5.241857915298533e-11,
 -2.785412974236997e-13,  1.419436653358521e-15, -6.986920082975731e-18,  3.339176604703510e-20, -1.555505587119741e-22,  7.084470889623520e-25, -3.162270438266666e-27,
  3.055594425848897e-02, -2.503590745982453e-04,  2.061345436568116e-06, -1.485889157378637e-08,  9.818826246373539e-11, -6.084285560461545e-13,  3.582185588380649e-15,
 -2.021778964114222e-17,  1.100925135660200e-19, -5.811953345592247e-22,  2.985791231816102e-24, -1.497130985713531e-26,  2.194512728602369e-02, -2.432183499072997e-04,
  2.425845095500762e-06, -2.066174064459113e-08,  1.590639887960681e-10, -1.135607442869313e-12,  7.636644957980798e-15, -4.888671926341069e-17,  3.001894357807547e-19,
 -1.778233967581043e-21,  1.020669241462969e-23, -5.696279729692286e-26,  1.476299581684932e-02, -2.150536078755598e-04,  2.559909285215402e-06, -2.550615404828085e-08,
  2.265073181611601e-10, -1.845884960497179e-12,  1.405518028776783e-14, -1.012180056991510e-16,  6.954116815382904e-19, -4.587811875465750e-21,  2.920944727228320e-23,
 -1.801791310195860e-25,  9.306855084325086e-03, -1.736140854248948e-04,  2.441720238456924e-06, -2.821842576549981e-08,  2.867440706579194e-10, -2.647650238872485e-12,
  2.266974473241322e-14, -1.824593000282972e-16,  1.393899073206622e-18, -1.018077499170743e-20,  7.148811780588347e-23, -4.847171420460389e-25,  5.501267323451070e-03,
 -1.284831341409131e-04,  2.117839188376465e-06, -2.817870618193228e-08,  3.254512272890734e-10, -3.384054659766774e-12,  3.239706125882585e-14, -2.898639960059131e-16,
  2.449783289457926e-18, -1.971270373570310e-20,  1.519495499241948e-22, -1.127359935839854e-24,  3.050973198431871e-03, -8.750365985985350e-05,  1.678448071063847e-06,
 -2.554403677150080e-08,  3.333998703257560e-10, -3.883710077705378e-12,  4.137215038766048e-14, -4.096413608207562e-16,  3.813681411493737e-18, -3.367089161968778e-20,
  2.837926774233446e-22, -2.295230714331688e-24,  1.588782136954881e-03, -5.503987062778721e-05,  1.220423988685002e-06, -2.112141225237412e-08,  3.099811653350666e-10,
 -4.027082250371156e-12,  4.753809362813734e-14, -5.188681091498390e-16,  5.301618573148893e-18, -5.117860837212181e-20,  4.700767943868514e-22, -4.130942148820531e-24,
  7.775540419900041e-04, -3.207791236817622e-05,  8.170871002610030e-07, -1.599706251405621e-08,  2.628182318746452e-10, -3.792776601416548e-12,  4.943277775452971e-14,
 -5.927526757715061e-16,  6.625878874689501e-18, -6.972180528639337e-20,  6.958479813837881e-22, -6.625651963629676e-24,  3.580049008514183e-04, -1.737412151357097e-05,
  5.053792716133259e-07, -1.113987002631443e-08,  2.040574723253038e-10, -3.259512293270894e-12,  4.675255660762777e-14, -6.140400851900586e-16,  7.487778628502437e-18,
 -8.565523023200033e-20,  9.265042346956030e-22, -9.535004715192098e-24,  1.552603826400096e-04, -8.769586520703313e-06,  2.896764718083613e-07, -7.157512465035002e-09,
  1.456450271840937e-10, -2.566778199015825e-12,  4.039813684877387e-14, -5.795715533210394e-16,  7.690333986246611e-18, -9.540615583470507e-20,  1.115887754250578e-21,
 -1.238499305157337e-23,  6.351033705213756e-05, -4.136210686546589e-06,  1.543355366956412e-07, -4.257283319083337e-09,  9.590761320900288e-11, -1.859291160738836e-12,
  3.202402280800455e-14, -5.006146634712303e-16,  7.211438067950423e-18, -9.681389790827347e-20,  1.221890588323935e-21, -1.459642018391187e-23,  2.454292001304872e-05,
 -1.827804298649175e-06,  7.666026320131989e-08, -2.351804791732544e-09,  5.847025993796940e-11, -1.243464985877993e-12,  2.337985379718020e-14, -3.973422276994433e-16,
  6.200754035879561e-18, -8.990418958583118e-20,  1.222090799509699e-21, -1.568446916796487e-23,  8.976147003749416e-06, -7.588114009020568e-07,  3.560669018393319e-08,
 -1.210520900671636e-09,  3.311533285938781e-11, -7.705679135331189e-13,  1.577957718362517e-14, -2.909350770237122e-16,  4.908915891863941e-18, -7.672565740007147e-20,
  1.121333699959544e-21, -1.543578795433368e-23,  3.113360204779578e-06, -2.967785183227739e-07,  1.551278038743823e-08, -5.824663654507323e-10,  1.748358550264678e-11,
 -4.440553493139196e-13,  9.882174492045298e-15, -1.972736736542465e-16,  3.592279886374268e-18, -6.042223039466142e-20,  9.478816059206699e-22, -1.397333786090880e-23,
  1.026506140236257e-06, -1.096759185811201e-07,  6.359774571915607e-09, -2.628864346147949e-10,  8.635124562535969e-12, -2.388318395177413e-13,  5.764210354820737e-15,
 -1.243524257908079e-16,  2.439555271603014e-18, -4.408607427537705e-20,  7.412313560569402e-22, -1.168463175775803e-23,  3.225831418684203e-07, -3.841917549146101e-08,
  2.461870159595496e-09, -1.116876170448258e-10,  4.004350719963493e-12, -1.203386653516755e-13,  3.143563384402665e-15, -7.315599376325719e-17,  1.543609118366124e-18,
 -2.992371614415008e-20,  5.384241381677523e-22, -9.063435410959631e-24,  9.691235857889028e-08, -1.280075493740439e-08,  9.031079504924203e-10, -4.483473836583226e-11,
  1.750220022833470e-12, -5.702672223801098e-14,  1.609269090162888e-15, -4.032822390528832e-17,  9.137463896073369e-19, -1.897299782561542e-20,  3.648244012021347e-22,
 -6.548941797778812e-24,  2.792899439002422e-08, -4.071972428156067e-09,  3.151882935559249e-10, -1.707440159170366e-11,  7.239823812424922e-13, -2.552180872745117e-14,
  7.765623864705560e-16, -2.092011970707495e-17,  5.081848550375744e-19, -1.128551779615021e-20,  2.315808908389451e-22, -4.427232214469769e-24,  7.750716894837710e-09,
 -1.241788969086125e-09,  1.051015251547063e-10, -6.195609063909678e-12,  2.846720873240903e-13, -1.083487933000417e-14,  3.548084696242846e-16, -1.025770939699355e-17,
  2.667263205368522e-19, -6.325819813446370e-21,  1.383341825350593e-22, -2.812730789079764e-24,  2.080275517931515e-09, -3.647041237922212e-10,  3.364185035462993e-11,
 -2.152173288965054e-12,  1.069058687008111e-13, -4.384083087099755e-15,  1.542212793216610e-16, -4.776705745657140e-18,  1.327441782997981e-19, -3.357184035268271e-21,
  7.812911698657372e-23, -1.687339887115503e-24,  5.426308224261865e-10, -1.036732347242388e-10,  1.038961672049466e-11, -7.193748238152156e-13,  3.854160357317665e-14,
 -1.699427139973388e-15,  6.409818558100062e-17, -2.123274169590149e-18,  6.296020342593091e-20, -1.695428038365901e-21,  4.192980338038083e-23, -9.605329120383961e-25,
  1.383104271025550e-10, -2.868388823507679e-11,  3.113151996096599e-12, -2.326765365138663e-13,  1.341393039772949e-14, -6.346110615447097e-16,  2.561490255522292e-17,
 -9.058529283704710e-19,  2.861352115295218e-20, -8.191461510705378e-22,  2.149658319449315e-23, -5.216096772714677e-25,  3.465796252512495e-11, -7.771711385559354e-12,
  9.106478162656528e-13, -7.327035489904003e-14,  4.534410130542041e-15, -2.296731977246272e-16,  9.900884189193301e-18, -3.731149678852601e-19,  1.253314106456736e-20,
 -3.808195970259278e-22,  1.058814510571099e-23, -2.717309652000955e-25,  8.595355020844669e-12, -2.076019985539928e-12,  2.618010119081898e-13, -2.261427329367078e-14,
  1.498631191886696e-15, -8.108613948040833e-17,  3.725527887268687e-18, -1.493206164114398e-19,  5.324151329555226e-21, -1.714078882561214e-22,  5.040938512347657e-24,
 -1.366122848740567e-25,  2.125433753372457e-12, -5.507966697637609e-13,  7.451611423602491e-14, -6.890794885346616e-15,  4.877424008040945e-16, -2.812440098317482e-17,
  1.374207540551325e-18, -5.845975108413007e-20,  2.208308931046420e-21, -7.519035461872001e-23,  2.334852791153052e-24, -6.670569446602694e-26,  5.282789406010090e-13,
 -1.463152526482337e-13,  2.116632433362748e-14, -2.089297750142239e-15,  1.575312539399412e-16, -9.656538116297036e-18,  5.006205369866312e-19, -2.255454516774556e-20,
  9.007541528129095e-22, -3.237200272981178e-23,  1.059398141518505e-24, -3.184880294724356e-26,  1.331408100401153e-13, -3.925537955641646e-14,  6.051749896345818e-15,
 -6.356823489888857e-16,  5.091222660461112e-17, -3.308949729682284e-18,  1.815574121228581e-19, -8.642419790373410e-21,  3.640833167463724e-22, -1.378133351127330e-23,
  4.743253926356549e-25, -1.497528284505088e-26,  3.434467070580256e-14, -1.073619926195537e-14,  1.757621333723433e-15, -1.958325280645130e-16,  1.661017363155826e-17,
 -1.141366166132586e-18,  6.610281727770658e-20, -3.316101103980289e-21,  1.470027684404624e-22, -5.846891425584247e-24,  2.111667135686685e-25, -6.986200919893114e-27,
  9.157954594226145e-15, -3.022656504672800e-15,  5.235392354153035e-16, -6.166233566589547e-17,  5.520998323585212e-18, -3.998769535906843e-19,  2.437424693960262e-20,
 -1.285048292682870e-21,  5.978502031443748e-23, -2.492225237702735e-24,  9.421680828678392e-26, -3.258520129836613e-27,  2.550152739870375e-15, -8.849117431757590e-16,
  1.615300916348087e-16, -2.003776605527552e-17,  1.887354107087030e-18, -1.436115875131093e-19,  9.184079852212305e-21, -5.073303064202591e-22,  2.469872944710692e-23,
 -1.076081181379716e-24,  4.246657941050657e-26, -1.531342448686107e-27,  7.492536586127271e-16, -2.721418508409510e-16,  5.213801791453849e-17, -6.785502835575523e-18,
  6.698498329063144e-19, -5.335733196744373e-20,  3.567760532598354e-21, -2.058195884098064e-22,  1.045201856960839e-23, -4.744718889670530e-25,  1.948857851301107e-26,
 -7.306056366009880e-28,  2.345862109794813e-16, -8.878396195437518e-17,  1.777502982458241e-17, -2.416909666783247e-18,  2.490636350388267e-19, -2.068884260228445e-20,
  1.441058690283965e-21, -8.650712779170957e-23,  4.566558682569674e-24, -2.152683646135628e-25,  9.172800385673539e-27, -3.563759926156611e-28,  7.897315546258205e-17,
 -3.099949563328254e-17,  6.455830840466298e-18, -9.130503095619136e-19,  9.779911523367634e-20, -8.436621114210861e-21,  6.096987158077251e-22, -3.793824229606199e-23,
  2.073968482205723e-24, -1.011548568818859e-25,  4.455727840256535e-27, -1.787850023794477e-28,  2.878698773370628e-17, -1.166378888143154e-17,  2.514533049824339e-18,
 -3.681625961755559e-19,  4.080156388003401e-20, -3.639022191693960e-21,  2.716797287675353e-22, -1.744981444686139e-23,  9.838665826561059e-25, -4.945348857602066e-26,
  2.243206819579208e-27, -9.261157125158716e-29,  1.139956187168496e-17, -4.744358991962008e-18,  1.053441695008349e-18, -1.588765749968468e-19,  1.812900524669914e-20,
 -1.663770283324809e-21,  1.277280084472415e-22, -8.430272510952662e-24,  4.881030581499511e-25, -2.517701044894908e-26,  1.171176550469313e-27, -4.955159662393699e-29,
  4.885654538522537e-18, -2.078233792497193e-18,  4.727609813406136e-19, -7.305887233144127e-20,  8.539358634971947e-21, -8.023649365028079e-22,  6.303145005129420e-23,
 -4.254643592314383e-24,  2.517915019567655e-25, -1.326790493919486e-26,  6.301655454392972e-28, -2.720640374451162e-29,  2.223690014743054e-18, -9.619007664599128e-19,
  2.229493555671598e-19, -3.511032210492990e-20,  4.181007421319441e-21, -4.000946944904077e-22,  3.199664882844479e-23, -2.197764356722537e-24,  1.322949443130468e-25,
 -7.087681511899639e-27,  3.421171858891853e-28, -1.500421534295891e-29,  1.011958273504861e-18, -4.428725659404080e-19,  1.039989538664731e-19, -1.659542016613051e-20,
  2.002151702613689e-21, -1.940586366565889e-22,  1.571467400665690e-23, -1.092657329463102e-24,  6.656077489934166e-26, -3.607638027073946e-27,  1.761208536788019e-28,
 -7.809597059772768e-30,  3.601119154864534e-19, -1.586252375478354e-19,  3.752263000812780e-20, -6.031954255826379e-21,  7.330535542128697e-22, -7.156173457585078e-23,
  5.835713154381119e-24, -4.085465912536525e-25,  2.505374831397382e-26, -1.366791377221737e-27,  6.714973439167123e-29, -2.995982367552693e-30,  5.876785237928023e-02,
 -1.426268066668654e-04,  3.581704255859617e-07, -9.257550141191426e-10,  2.446521637956615e-12, -6.570640130756496e-15,  1.783228458162015e-17, -4.871878156832792e-20,
  1.335017454208150e-22, -3.664205033982793e-25,  1.004785005743540e-27, -2.754284793900351e-30,  5.486481598494268e-02, -1.632037388782130e-04,  5.772338822073664e-07,
 -2.142036844767533e-09,  7.918368472360960e-12, -2.876198637733893e-14,  1.025159807093898e-16, -3.592303733450636e-19,  1.240203624819590e-21, -4.226710885335492e-24,
  1.424072660059344e-26, -4.749374631260860e-29,  4.782217389476711e-02, -1.947149468122303e-04,  9.695448780365007e-07, -4.686648580757426e-09,  2.156242411471190e-11,
 -9.529428460023027e-14,  4.079297412131383e-16, -1.701024430430076e-18,  6.936576530815676e-21, -2.774272122984387e-23,  1.090678259663413e-25, -4.222467045952698e-28,
  3.892251012473170e-02, -2.226802339129383e-04,  1.446621145328707e-06, -8.560486464930133e-09,  4.717317442603185e-11, -2.467066634905890e-13,  1.237958034906067e-15,
 -6.002772357888222e-18,  2.827019943042469e-20, -1.298102429382160e-22,  5.829085192554639e-25, -2.565915613087585e-27,  2.958639673342104e-02, -2.345557260843018e-04,
  1.892077869995883e-06, -1.338074232424930e-08,  8.683554020857186e-11, -5.288697242903440e-13,  3.062420664439342e-15, -1.700777639567665e-17,  9.116947990047295e-20,
 -4.739631189515566e-22,  2.398528288809160e-24, -1.185017096498141e-26,  2.100955599922032e-02, -2.247617509487538e-04,  2.192455880737655e-06, -1.828890243293179e-08,
  1.380791284633983e-10, -9.677248673232912e-13,  6.393212501224790e-15, -4.023077683259105e-17,  2.429555192754898e-19, -1.416003526134005e-21,  7.999453574784805e-24,
 -4.395453332989368e-26,  1.394188489023442e-02, -1.957397102740481e-04,  2.274418696100264e-06, -2.215997082918924e-08,  1.927456762113072e-10, -1.540200189575588e-12,
  1.150931348638267e-14, -8.139655413393802e-17,  5.495013939671873e-19, -3.563831263623039e-21,  2.231504741073309e-23, -1.354250373795533e-25,  8.649426701752705e-03,
 -1.553606542070061e-04,  2.128970330973576e-06, -2.402623380825940e-08,  2.388426677031956e-10, -2.160162258458363e-12,  1.813395844275528e-14, -1.432059392866715e-16,
  1.074106047771969e-18, -7.706336405118154e-21,  5.318041359085125e-23, -3.545135748079349e-25,  5.019197153631970e-03, -1.128093581728056e-04,  1.808834227307219e-06,
 -2.347329765922230e-08,  2.649311615878252e-10, -2.695677142162555e-12,  2.527952029701105e-14, -2.217429950782629e-16,  1.838542438566950e-18, -1.452230797859636e-20,
  1.099389544379943e-22, -8.014403730815289e-25,  2.725993042990133e-03, -7.521707542732555e-05,  1.401527436508984e-06, -2.078074846928030e-08,  2.647927057735398e-10,
 -3.015674019388076e-12,  3.144304064530535e-14, -3.049904921387902e-16,  2.783649745308226e-18, -2.410939420336087e-20,  1.994490667458478e-22, -1.584041689698261e-24,
  1.386655652433866e-03, -4.621173324675960e-05,  9.942554484936691e-07, -1.674867240987339e-08,  2.397641680727779e-10, -3.042917984018604e-12,  3.513188305401437e-14,
 -3.753942628867551e-16,  3.757965214364604e-18, -3.556631558782064e-20,  3.204643564655341e-22, -2.764051651405805e-24,  6.611938262033726e-04, -2.624296059651908e-05,
  6.480440296155849e-07, -1.233959459221839e-08,  1.975968427891440e-10, -2.783736054146863e-12,  3.546199376063754e-14, -4.160352485255883e-16,  4.553752305484874e-18,
 -4.695402753968802e-20,  4.594796876050151e-22, -4.292080124907768e-24,  2.958201447993249e-04, -1.381488300356063e-05,  3.893216787065547e-07, -8.340899769220419e-09,
  1.488239078653413e-10, -2.319305056264497e-12,  3.249699735777041e-14, -4.173635402473173e-16,  4.981117587185101e-18, -5.580934482571439e-20,  5.916464704248730e-22,
 -5.971034925561874e-24,  1.243240730178340e-04, -6.759704640436497e-06,  2.162308585394010e-07, -5.190252405852452e-09,  1.028218398238276e-10, -1.767040789892141e-12,
  2.715481379674088e-14, -3.807845745752714e-16,  4.943023070408345e-18, -6.003908427258998e-20,  6.879902259437629e-22, -7.485564012594140e-24,  4.914472688644143e-05,
 -3.082365825988184e-06,  1.113514286579534e-07, -2.982823634018312e-09,  6.539439797600920e-11, -1.235756448405600e-12,  2.077419108975616e-14, -3.173090274795066e-16,
  4.470220510897772e-18, -5.873777396523720e-20,  7.260858462890603e-22, -8.500609942205286e-24,  1.829971895808852e-05, -1.313214170227507e-06,  5.332037831924981e-08,
 -1.588162236819317e-09,  3.841527096977079e-11, -7.961174928173653e-13,  1.460582010121762e-14, -2.424721303994790e-16,  3.699630412763186e-18, -5.248823533627529e-20,
  6.986572264159607e-22, -8.785955057617043e-24,  6.429933978550546e-06, -5.241056494262427e-07,  2.381072475562620e-08, -7.858701077751357e-10,  2.091316954091083e-11,
 -4.741343210244244e-13,  9.472134990217084e-15, -1.705626377251303e-16,  2.813297837189787e-18, -4.301986414544612e-20,  6.155696976503287e-22, -8.301772878370594e-24,
  2.136102111148559e-06, -1.964788248184503e-07,  9.945653677828789e-09, -3.625592323939839e-10,  1.058625228732744e-11, -2.619526954988023e-13,  5.686785739822324e-15,
 -1.108619939476459e-16,  1.973286976927763e-18, -3.246993646932142e-20,  4.986802580409037e-22, -7.201808045006523e-24,  6.724718055660198e-07, -6.938699941079091e-08,
  3.897938446649334e-09, -1.564630858592627e-10,  4.999906442724451e-12, -1.347361047843888e-13,  3.172291155210256e-15, -6.683341388306179e-17,  1.281625273125425e-18,
 -2.265794968995608e-20,  3.729594453759964e-22, -5.759752373280795e-24,  2.011343860759111e-07, -2.315540894272750e-08,  1.438204983825261e-09, -6.338043727270563e-11,
  2.211222826949237e-12, -6.475593095307849e-14,  1.650435193708616e-15, -3.751317403016356e-17,  7.737997576269570e-19, -1.467639043549762e-20,  2.585589812883739e-22,
 -4.264344259823938e-24,  5.732453657503673e-08, -7.326635795835416e-09,  5.013503758379083e-10, -2.418868074309344e-11,  9.191699911089626e-13, -2.919327260793805e-14,
  8.039778801200913e-16, -1.968246890503295e-17,  4.360569901551199e-19, -8.860349635738135e-21,  1.668445495058280e-22, -2.934974275917773e-24,  1.562055052463726e-08,
 -2.206197726768162e-09,  1.657596466720242e-10, -8.731882013632349e-12,  3.605839236517715e-13, -1.239568839515453e-14,  3.682184688761545e-16, -9.693778294289625e-18,
  2.303203777881965e-19, -5.006762946637693e-21,  1.006408099618601e-22, -1.885942439838963e-24,  4.085189604922556e-09, -6.348209537886483e-10,  5.220016980840492e-11,
 -2.994429809044632e-12,  1.340776212050785e-13, -4.979078563079036e-15,  1.592570210401322e-16, -4.501402007471557e-18,  1.145317475984290e-19, -2.659950050361724e-21,
  5.700158542528994e-23, -1.136502931548886e-24,  1.029836781719030e-09, -1.753475700040969e-10,  1.573046510333261e-11, -9.801103527252943e-13,  4.747890819907884e-14,
 -1.900979799103368e-15,  6.535576915887801e-17, -1.980174561693547e-18,  5.387426873357667e-20, -1.334919111763013e-21,  3.045804524668121e-23, -6.453254830513636e-25,
  2.514725017615448e-10, -4.672898626980648e-11,  4.559496832976778e-12, -3.077740665515296e-13,  1.609469694131169e-14, -6.934174574426683e-16,  2.557950097891397e-17,
 -8.294315458268477e-19,  2.409396058293356e-20, -6.360615207661274e-22,  1.543139642199784e-23, -3.469980585483492e-25,  5.980999813177058e-11, -1.208246587581915e-11,
  1.278384254713321e-12, -9.325025977772660e-14,  5.252410568753574e-15, -2.430202976826037e-16,  9.601677442487490e-18, -3.326470252072853e-19,  1.030126350295156e-20,
 -2.893139181696244e-22,  7.453133889019159e-24, -1.776383469306705e-25,  1.394141417586271e-11, -3.050179651022469e-12,  3.488975113321387e-13, -2.743098617851479e-14,
  1.660432376981669e-15, -8.233584367746552e-17,  3.477677797686861e-18, -1.285060377319839e-19,  4.235539426137832e-21, -1.263616776077542e-22,  3.451615230074263e-24,
 -8.707565692194608e-26,  3.206957366946281e-12, -7.570257685507413e-13,  9.333218441105218e-14, -7.888388607127631e-15,  5.119428208652901e-16, -2.714870328949751e-17,
  1.223475228349212e-18, -4.813227767890034e-20,  1.685614262277410e-21, -5.333245487134157e-23,  1.542300752757322e-24, -4.112256866651523e-26,  7.336164029495988e-13,
 -1.861409593796354e-13,  2.465859598732670e-14, -2.234399031386113e-15,  1.550907934254234e-16, -8.776102238590555e-18,  4.211074220316159e-19, -1.760349334603104e-20,
  6.538276684275152e-22, -2.190131335646227e-23,  6.694213033446978e-25, -1.883460717230964e-26,  1.683115223915584e-13, -4.572755458575587e-14,  6.488256082093277e-15,
 -6.285329112257282e-16,  4.654011844455966e-17, -2.803487724630129e-18,  1.429129551309984e-19, -6.334846025254928e-21,  2.490491179787769e-22, -8.815524698502097e-24,
  2.842807365743455e-25, -8.425525120355634e-27,  3.908861543499609e-14, -1.132679407802618e-14,  1.715711542066052e-15, -1.771575339664586e-16,  1.395548055243300e-17,
 -8.926164784827207e-19,  4.822587758629004e-20, -2.261622156886681e-21,  9.391143796391679e-23, -3.505454609947333e-24,  1.190298701976812e-25, -3.709114760650329e-27,
  9.281710401457879e-15, -2.857146328622709e-15,  4.604172335626076e-16, -5.051388551080442e-17,  4.220932292830273e-18, -2.858793695730289e-19,  1.632718410404664e-20,
 -8.080782146737499e-22,  3.535707383834474e-23, -1.388615429476995e-24,  4.954047732409405e-26, -1.619663672691776e-27,  2.277637030252593e-15, -7.417130580545283e-16,
  1.266916865801727e-16, -1.471926226578316e-17,  1.300539909463671e-18, -9.299417748887964e-20,  5.598413486633345e-21, -2.916300742531284e-22,  1.341069893362338e-23,
 -5.527792278051525e-25,  2.067044340456672e-26, -7.073776303005923e-28,  5.840815454845953e-16, -2.003584160278184e-16,  3.613497934287804e-17, -4.429673863306014e-18,
  4.124430427826357e-19, -3.103425032740899e-20,  1.963278246270273e-21, -1.073199731741560e-22,  5.171914947585067e-24, -2.231239444650187e-25,  8.721759259625553e-27,
 -3.116147423676028e-28,  1.583242821633199e-16, -5.695498136023641e-17,  1.080107882158581e-17, -1.391631429291778e-18,  1.360378781118621e-19, -1.073350423407700e-20,
  7.111069181134527e-22, -4.065763047544525e-23,  2.046878418066811e-24, -9.214136572712575e-26,  3.753942890667286e-27, -1.396263645057162e-28,  4.587490018105728e-17,
 -1.722686131841229e-17,  3.420166264541250e-18, -4.612050185093148e-19,  4.714388705022933e-20, -3.885363820591669e-21,  2.685712537986987e-22, -1.600342554471028e-23,
  8.387479071075220e-25, -3.926438195005332e-26,  1.661835010089186e-27, -6.414397572434917e-29,  1.435680516162745e-17, -5.600957113593104e-18,  1.158715594757186e-18,
 -1.627991237836742e-19,  1.732556630963501e-20, -1.485224037897467e-21,  1.066814106300102e-22, -6.599022881264548e-24,  3.586829671945881e-25, -1.739708160943414e-26,
  7.621872809062515e-28, -3.042304089961557e-29,  4.894186263544648e-18, -1.973866587060607e-18,  4.233986198535793e-19, -6.168090315975311e-20,  6.802222438804629e-21,
 -6.037777348470854e-22,  4.486696544583902e-23, -2.868773990834510e-24,  1.610407551105804e-25, -8.060222984667847e-27,  3.641033475134858e-28, -1.497211194978261e-29,
  1.826175139710421e-18, -7.575482544683673e-19,  1.676026148093950e-19, -2.518643681995933e-20,  2.863825054949302e-21, -2.619205962961183e-22,  2.004043597822508e-23,
 -1.318404970633777e-24,  7.609320916686770e-26, -3.912962588895762e-27,  1.814804838377678e-28, -7.656180860256933e-30,  7.441465340834611e-19, -3.158640992424412e-19,
  7.168321993478414e-20, -1.105135128425781e-20,  1.288699825506194e-21, -1.208110348497960e-22,  9.469483702646733e-24, -6.378127948990361e-25,  3.766679312413859e-26,
 -1.980767187113255e-27,  9.389112106588815e-29, -4.045820716317854e-30,  3.253848155014737e-19, -1.405759168591328e-19,  3.253733192217361e-20, -5.116839770149912e-21,
  6.084829336898172e-22, -5.814922914321276e-23,  4.644233266687208e-24, -3.185914153510236e-25,  1.915378530547304e-26, -1.024917113420272e-27,  4.941366151700276e-29,
 -2.164653851205336e-30,  1.439068982731075e-19, -6.294041857795943e-20,  1.476993882816763e-20, -2.355232601608675e-21,  2.839500662311002e-22, -2.750319643077821e-23,
  2.225703510352379e-24, -1.546551746221820e-25,  9.415084192637615e-27, -5.099891185458729e-28,  2.488212497290777e-29, -1.102684430325943e-30,  5.038877988719114e-20,
 -2.218988482350837e-20,  5.247437589525128e-21, -8.432978762228857e-22,  1.024538428399870e-22, -9.998724160337443e-24,  8.151374140225457e-25, -5.704975500538961e-26,
  3.497537672334528e-27, -1.907531080319072e-28,  9.369050482779073e-30, -4.179024519919173e-31,  5.820300644852536e-02, -1.398052238875357e-04,  3.472919689481589e-07,
 -8.876391723047925e-10,  2.319280533594079e-12, -6.158563986130205e-15,  1.652603837292873e-17, -4.465025781838478e-20,  1.210057868239881e-22, -3.285502433762327e-25,
  8.911808834626531e-28, -2.417389195369996e-30,  5.422107696083315e-02, -1.586865746592394e-04,  5.522710444060683e-07, -2.019814527144529e-09,  7.366940439993125e-12,
 -2.641795643502251e-14,  9.299102729102666e-17, -3.218724630471478e-19,  1.097811234882303e-21, -3.696751504541314e-24,  1.230767806446417e-26, -4.056556948144490e-29,
  4.705847873353328e-02, -1.871778234103919e-04,  9.153138734638814e-07, -4.356380694092000e-09,  1.975070945868847e-11, -8.605132596459669e-14,  3.632642989573886e-16,
 -1.494226807402699e-18,  6.012089224031320e-21, -2.372989394702762e-23,  9.208522480799972e-26, -3.519471048244603e-28,  3.805430216340693e-02, -2.115057017797623e-04,
  1.348266183396928e-06, -7.843629804003162e-09,  4.252304735569629e-11, -2.189145395443822e-13,  1.081873774027051e-15, -5.168608423113395e-18,  2.399088070400358e-20,
 -1.086035504381778e-22,  4.809045544701337e-25, -2.087936338137338e-27,  2.867746245530953e-02, -2.200385382065637e-04,  1.739508627055465e-06, -1.207215561876489e-08,
  7.695619225003745e-11, -4.607717006573845e-13,  2.624608101375135e-15, -1.434581258150252e-17,  7.571510243941798e-20, -3.876886387271582e-22,  1.932941206736593e-24,
 -9.411263357655009e-27,  2.014424948198085e-02, -2.080638323144980e-04,  1.985631944683868e-06, -1.622650338072793e-08,  1.201721069403565e-10, -8.269717653033094e-13,
  5.368350730843196e-15, -3.321365523085780e-17,  1.973015937282666e-19, -1.131594168223767e-21,  6.293064714104653e-24, -3.404989231848510e-26,  1.319370363657476e-02,
 -1.785578597855344e-04,  2.026032679855030e-06, -1.930820450211662e-08,  1.645290878339724e-10, -1.289451575813995e-12,  9.458263029718462e-15, -6.570401726845703e-17,
  4.359310661613707e-19, -2.779917095137972e-21,  1.712195379006867e-23, -1.022467540417782e-25,  8.060309188667831e-03, -1.394203218878003e-04,  1.862231748379885e-06,
 -2.052802699260042e-08,  1.996858177112602e-10, -1.769422870568411e-12,  1.456644435964744e-14, -1.128915211033378e-16,  8.314846312976334e-19, -5.861226496559937e-21,
  3.975775291178132e-23, -2.606186486087749e-25,  4.595213686942944e-03, -9.939723464249635e-05,  1.550910187715788e-06, -1.963474020875517e-08,  2.166142045272910e-10,
 -2.157280481778304e-12,  1.982146251517723e-14, -1.704902369328637e-16,  1.387073666500079e-18, -1.075689679969511e-20,  7.999158294308982e-23, -5.730543413421614e-25,
  2.446065799188977e-03, -6.493463939855039e-05,  1.175713506339668e-06, -1.698830346705458e-08,  2.113826445020339e-10, -2.354202292965214e-12,  2.403013757007938e-14,
 -2.283876860149955e-16,  2.043962621011119e-18, -1.736947211761161e-20,  1.410614935966969e-22, -1.100338599938537e-24,  1.216530233369550e-03, -3.900075447859902e-05,
  8.144196032888457e-07, -1.335684422511680e-08,  1.865515787364379e-10, -2.313396639852774e-12,  2.612827729802592e-14, -2.733714081979644e-16,  2.681716838931146e-18,
 -2.488757430274576e-20,  2.200178813661601e-22, -1.862865209600648e-24,  5.657235335124128e-04, -2.160111192974338e-05,  5.172405670570113e-07, -9.580883669063398e-09,
  1.495683390014515e-10, -2.057413318963407e-12,  2.562227240805799e-14, -2.941527598671775e-16,  3.153245007024090e-18, -3.186488018491941e-20,  3.057898922620482e-22,
 -2.802712415351925e-24,  2.462086759861479e-04, -1.106346117713145e-05,  3.021143774020538e-07, -6.292101483860903e-09,  1.093762710973514e-10, -1.663304571421573e-12,
  2.277012961591661e-14, -2.860153910048326e-16,  3.341391420722966e-18, -3.667358675135720e-20,  3.810959900604851e-22, -3.772216145788001e-24,  1.003867007553068e-04,
 -5.253494968428984e-06,  1.627579981714867e-07, -3.795746944859770e-09,  7.321910375245735e-11, -1.227216972976007e-12,  1.841682339097302e-14, -2.524630417542306e-16,
  3.206621179407772e-18, -3.813802937211964e-20,  4.282200933098223e-22, -4.568044478954643e-24,  3.839303156430778e-05, -2.318658903220677e-06,  8.109995351963164e-08,
 -2.109897909324999e-09,  4.502134181283222e-11, -8.293975666967236e-13,  1.361039760957825e-14, -2.031481161599018e-16,  2.799232796885798e-18, -3.600393105472603e-20,
  4.359573297264238e-22, -5.002646333940650e-24,  1.379258702358509e-05, -9.535308903794998e-07,  3.748078189592392e-08, -1.083938967243036e-09,  2.551076721866170e-11,
 -5.152409246742521e-13,  9.224442863121381e-15, -1.495993097704069e-16,  2.231941390665042e-18, -3.098799367108729e-20,  4.039352399755653e-22, -4.977724827665792e-24,
  4.661929413643001e-06, -3.663010477501474e-07,  1.611099641804504e-08, -5.162267452214705e-10,  1.336402809513747e-11, -2.952165207742186e-13,  5.754059740788497e-15,
 -1.011980721909670e-16,  1.631823602052088e-18, -2.441469828855558e-20,  3.420576575850306e-22, -4.519780633626616e-24,  1.485357805989616e-06, -1.317917302095595e-07,
  6.459752929584821e-09, -2.286156835474718e-10,  6.493341362557593e-12, -1.565404446172357e-13,  3.315183018972521e-15, -6.311513449858898e-17,  1.098145574850529e-18,
 -1.767781329429840e-20,  2.658064436792072e-22, -3.760715922050575e-24,  4.470799517040824e-07, -4.453451950838981e-08,  2.423289410363543e-09, -9.444729945363021e-11,
  2.936047602423646e-12, -7.708462326036648e-14,  1.770469641815851e-15, -3.642581840793380e-17,  6.827853455436699e-19, -1.180892509378218e-20,  1.902999306926818e-22,
 -2.879125356999853e-24,  1.274421272847061e-07, -1.417661230982697e-08,  8.532826866843851e-10, -3.652205582090599e-11,  1.239751257029320e-12, -3.537683600677772e-14,
  8.796517380323155e-16, -1.952673992385302e-17,  3.937415905016106e-19, -7.306277635490026e-21,  1.260234052727660e-22, -2.036349436683055e-24,  3.450328663888525e-08,
 -4.265264613308770e-09,  2.830038677439465e-10, -1.326687369860613e-11,  4.906672945367688e-13, -1.518858451602053e-14,  4.081694650743716e-16, -9.760859114202144e-18,
  2.114269137553901e-19, -4.203682215303260e-21,  7.751242534540661e-23, -1.336094724559480e-24,  8.901349815951082e-09, -1.217297929275948e-09,  8.874707602017131e-11,
 -4.544882438675917e-12,  1.827441666010705e-13, -6.125039950482947e-15,  1.776004272787414e-16, -4.568447059998948e-18,  1.061530290488379e-19, -2.258545546675666e-21,
  4.446639176500631e-23, -8.167014399173364e-25,  2.196511656650401e-09, -3.308880917754594e-10,  2.642362567343702e-11, -1.474567539398002e-12,  6.432381630022331e-14,
 -2.330109856170894e-15,  7.278048570641575e-17, -2.010825434888528e-18,  5.005399993369166e-20, -1.138182047896976e-21,  2.389783808078552e-23, -4.671570577801861e-25,
  5.206661465728404e-10, -8.605178475323661e-11,  7.504368003680171e-12, -4.552229345180453e-13,  2.149873472434877e-14, -8.401679817636069e-16,  2.822291964928147e-17,
 -8.362850383103674e-19,  2.227038778378808e-20, -5.405372540418572e-22,  1.208918809068936e-23, -2.512348762161904e-25,  1.191402240393509e-10, -2.151935823159822e-11,
  2.043372527967144e-12, -1.344131047078716e-13,  6.858183503249172e-15, -2.886133515964397e-16,  1.040965049659997e-17, -3.303168929641077e-19,  9.397490902691179e-21,
 -2.431492331170333e-22,  5.785480726363865e-24, -1.276720711677168e-25,  2.646327648645136e-11, -5.204168227434048e-12,  5.365038450233039e-13, -3.817668069846398e-14,
  2.100065278113593e-15, -9.499169591935596e-17,  3.672475859072116e-18, -1.246024304405926e-19,  3.781765250759803e-21, -1.041686949120031e-22,  2.633598236850218e-24,
 -6.163893766328546e-26,  5.741756073068872e-12, -1.224853450410608e-12,  1.366948098374249e-13, -1.049650257140613e-14,  6.211763647352750e-16, -3.014254412047437e-17,
  1.246949460988303e-18, -4.516385094906494e-20,  1.460143294589147e-21, -4.275712095290868e-23,  1.147063566567848e-24, -2.843729579017203e-26,  1.225565466293223e-12,
 -2.825606167525499e-13,  3.403751407196938e-14, -2.813386772403025e-15,  1.787194922978656e-16, -9.284939522837525e-18,  4.102481544832957e-19, -1.583523662011495e-20,
  5.444703164912852e-22, -1.692408913298541e-23,  4.810957389208401e-25, -1.261634149601346e-26,  2.593961520650807e-13, -6.439758534945360e-14,  8.348323563057534e-15,
 -7.408382698551029e-16,  5.039986062789917e-17, -2.797431046985107e-18,  1.317579913521310e-19, -5.410025622105120e-21,  1.974921582404908e-22, -6.505701526912458e-24,
  1.956571562946489e-25, -5.419424567600914e-27,  5.492360572485737e-14, -1.462735114336710e-14,  2.034422835936444e-15, -1.933028402957951e-16,  1.404880641217434e-17,
 -8.312085271332244e-19,  4.164510142807150e-20, -1.815404673092676e-21,  7.022870086356362e-23, -2.447381052100201e-24,  7.773954416981551e-26, -2.270625389532433e-27,
  1.174771868207045e-14, -3.343409290848958e-15,  4.972949464824701e-16, -5.044700323091654e-17,  3.906510652364977e-18, -2.457761800794377e-19,  1.306883511318246e-20,
 -6.035262896288811e-22,  2.469095287056705e-23, -9.084848706210259e-25,  3.042159598831938e-26, -9.352874661243985e-28,  2.565472255541384e-15, -7.771536749399065e-16,
  1.231991578497222e-16, -1.330207990588928e-17,  1.094440698919494e-18, -7.302464314776615e-20,  4.110755530112007e-21, -2.006311014976335e-22,  8.660750505688936e-24,
 -3.357258099020198e-25,  1.182675388614166e-26, -3.819540032586531e-28,  5.786012645244670e-16, -1.857934958304834e-16,  3.127829528096135e-17, -3.582694039595075e-18,
  3.122202744697248e-19, -2.202933613174801e-20,  1.309212390411994e-21, -6.735361770194667e-23,  3.060124475255640e-24, -1.246710115972833e-25,  4.609442842650139e-27,
 -1.560249829162286e-28,  1.364149639167600e-16, -4.623353026044709e-17,  8.233973069466418e-18, -9.969588270991346e-19,  9.171572867849141e-20, -6.821162161420593e-21,
  4.266764199227570e-22, -2.307037197087279e-23,  1.100104562126719e-24, -4.697663954876818e-26,  1.818155706084740e-27, -6.433922361755129e-29,  3.404603776911083e-17,
 -1.212427162979067e-17,  2.274860902186780e-18, -2.900259980965780e-19,  2.806188700724438e-20, -2.192179798102550e-21,  1.438407418056971e-22, -8.147667855235610e-24,
  4.064947233474696e-25, -1.813892081363522e-26,  7.327495895765529e-28, -2.703124118143201e-29,  9.108324836487774e-18, -3.392234430972323e-18,  6.675847510523716e-19,
 -8.924211511431321e-20,  9.045020799544066e-21, -7.393162118731306e-22,  5.069686719490066e-23, -2.997539226772806e-24,  1.559257716470845e-25, -7.246365960224567e-27,
  3.045377171333578e-28, -1.167454840237468e-29,  2.643174197765138e-18, -1.024493686208870e-18,  2.104676844395081e-19, -2.936577777082111e-20,  3.104027962657959e-21,
 -2.643383993475248e-22,  1.886564997911758e-23, -1.159742546561850e-24,  6.265761883778633e-26, -3.021345342417267e-27,  1.316204416680727e-28, -5.224942951856933e-30,
  8.404507475679116e-19, -3.373076843248007e-19,  7.196948327070282e-20, -1.042911605941717e-20,  1.144177284291379e-21, -1.010473566330537e-22,  7.472103510932449e-24,
 -4.754927999388525e-25,  2.656909739354978e-26, -1.323858894298139e-27,  5.954307337058442e-29, -2.438161205974860e-30,  2.947285662764603e-19, -1.218381313283140e-19,
  2.685343982343858e-20, -4.020058261709295e-21,  4.553971411663031e-22, -4.149853865198951e-23,  3.163979587833807e-24, -2.074355335278879e-25,  1.193251247904576e-26,
 -6.116263187677654e-28,  2.827785080416158e-29, -1.189346250346408e-30,  1.139164259222061e-19, -4.824382379732935e-20,  1.092113076132412e-20, -1.679465934750470e-21,
  1.953585818930403e-22, -1.826998642421459e-23,  1.428686740604834e-24, -9.600894937760007e-26,  5.657353838749277e-27, -2.968603288915690e-28,  1.404217454416459e-29,
 -6.038599907121017e-31,  4.775704376939222e-20, -2.060516383408786e-20,  4.762186084423975e-21, -7.477938964008092e-22,  8.879616820537060e-23, -8.473636642009157e-24,
  6.758273162600871e-25, -4.629859512083312e-26,  2.779818911307780e-27, -1.485575111438461e-28,  7.153397071732131e-30, -3.129894369073298e-31,  2.049579370317030e-20,
 -8.958382763610891e-21,  2.100685191461032e-21, -3.347305369306874e-22,  4.032614772506653e-23, -3.903169339240100e-24,  3.156443592252906e-25, -2.191790183042481e-26,
  1.333428867362721e-27, -7.218133471736328e-29,  3.519467031601005e-30, -1.558740417953237e-31,  7.055268954235883e-21, -3.106106921142023e-21,  7.343016873825670e-22,
 -1.179700643587352e-22,  1.432792626423103e-23, -1.397866406889239e-24,  1.139252577773772e-25, -7.971010216000979e-27,  4.885339006851416e-28, -2.663661225302715e-29,
  1.307917415156245e-30, -5.832297642956747e-32,  5.764927564233709e-02, -1.370688731950035e-04,  3.368589538226889e-07, -8.514949213869194e-10,  2.199976452155062e-12,
 -5.776514682855376e-15,  1.532831150476555e-17, -4.096064032030868e-20,  1.097948113012724e-22, -2.949411756354481e-25,  7.914035773690121e-28, -2.124695751497457e-30,
  5.359501626994036e-02, -1.543633929758962e-04,  5.287234451014341e-07, -1.906052087183432e-09,  6.860189157273107e-12, -2.429047089834521e-14,  8.445106867013458e-17,
 -2.887801995367076e-19,  9.731760215094901e-22, -3.238347510748349e-24,  1.065513877014212e-26, -3.471145676033654e-29,  4.632408879255246e-02, -1.800591742925338e-04,
  8.648780758482181e-07, -4.053677702043421e-09,  1.811358655926030e-11, -7.781406794703438e-14,  3.239958364250786e-16, -1.314826677965843e-18,  5.220546479706496e-21,
 -2.033833605296115e-23,  7.791428236551212e-26, -2.940235283925901e-28,  3.722927140075784e-02, -2.010848240968709e-04,  1.258084793746676e-06, -7.196924298635561e-09,
  3.839311734767201e-11, -1.946029545427147e-13,  9.473383543340342e-16, -4.459915744584989e-18,  2.040635995259650e-20, -9.108557440072586e-23,  3.977905264491374e-25,
 -1.703703292432593e-27,  2.782425161168672e-02, -2.066816793714270e-04,  1.601737169452634e-06, -1.091128933239123e-08,  6.833948999790024e-11, -4.023398953869562e-13,
  2.254849421582214e-15, -1.213208924101315e-17,  6.305572644127992e-20, -3.180562658158971e-22,  1.562592695333974e-24, -7.498828619829919e-27,  1.934257559385564e-02,
 -1.929261751419331e-04,  1.801926466856519e-06, -1.442936864668617e-08,  1.048492807804306e-10, -7.086136676247242e-13,  4.520965425431010e-15, -2.750600530422304e-17,
  1.607560529090736e-19, -9.074592302212965e-22,  4.968765617548857e-24, -2.647793837922446e-26,  1.251048198916151e-02, -1.632335230811252e-04,  1.809316288608073e-06,
 -1.687031605574031e-08,  1.408687935464935e-10, -1.083041440513710e-12,  7.799696538673328e-15, -5.323159611273969e-17,  3.471696438271534e-19, -2.177214425203361e-21,
  1.319289681775827e-23, -7.753635659541202e-26,  7.530936761668850e-03, -1.254560698942012e-04,  1.633956160978470e-06, -1.759818995266561e-08,  1.675520186614501e-10,
 -1.454937633597265e-12,  1.174833084196732e-14, -8.937425307570758e-17,  6.465422951337877e-19, -4.478636587389093e-21,  2.986665523029208e-23, -1.925518362217804e-25,
  4.221026129912831e-03, -8.787662045290049e-05,  1.334743962438986e-06, -1.648976783083349e-08,  1.778635539162592e-10, -1.734171343803680e-12,  1.561506130041261e-14,
 -1.317284729700873e-16,  1.051818915136172e-18, -8.010048863473511e-21,  5.852098302125060e-23, -4.120688467082988e-25,  2.203924243648740e-03, -5.629025891815224e-05,
  9.906886922646929e-07, -1.395356653615103e-08,  1.695837287557259e-10, -1.847367350989706e-12,  1.846422207833177e-14, -1.719848382769112e-16,  1.509545377317354e-18,
 -1.258872543761875e-20,  1.003821061697112e-22, -7.691850719609447e-25,  1.072610072595204e-03, -3.307909139695955e-05,  6.706232352567814e-07, -1.071052922401022e-08,
  1.459812380593218e-10, -1.769244568924118e-12,  1.955183598241969e-14, -2.003415274749380e-16,  1.926222564106571e-18, -1.753222029928936e-20,  1.520970558593394e-22,
 -1.264363961849681e-24,  4.869203563218328e-04, -1.788531053198134e-05,  4.153716735446145e-07, -7.486172920333099e-09,  1.139569986638433e-10, -1.530893137335690e-12,
  1.864172570359927e-14, -2.094642560114555e-16,  2.199463545960962e-18, -2.178690749496877e-20,  2.050660386768146e-22, -1.844463263000080e-24,  2.063493563398469e-04,
 -8.921164684465514e-06,  2.361007329621146e-07, -4.781037768123385e-09,  8.098395380854915e-11, -1.201962400213132e-12,  1.607939820460102e-14, -1.975695367202838e-16,
  2.259717240553537e-18, -2.429928510360180e-20,  2.475510026852934e-22, -2.403607208421082e-24,  8.171421181896098e-05, -4.115431720916303e-06,  1.234998001141927e-07,
 -2.798790460008336e-09,  5.257715872564683e-11, -8.596051384051593e-13,  1.259949306418970e-14, -1.688698239274560e-16,  2.098946048951348e-18, -2.444788564401538e-20,
  2.690100019301731e-22, -2.813895447507511e-24,  3.027140341398771e-05, -1.760042858621816e-06,  5.960843820164665e-08, -1.506278191159994e-09,  3.128678207419797e-11,
 -5.619709389071305e-13,  9.003164536732831e-15, -1.313336699131436e-16,  1.770253642239156e-18, -2.229052537560199e-20,  2.644158139969495e-22, -2.974296572004045e-24,
  1.050463067654352e-05, -6.994863173515925e-07,  2.661788439153105e-08, -7.474677351584674e-10,  1.711823448735964e-11, -3.369780242363851e-13,  5.887838683059926e-15,
 -9.329155354367151e-17,  1.361114821829809e-18, -1.849497556564350e-20,  2.361173673104926e-22, -2.851539975569725e-24,  3.419864154901242e-06, -2.589613106122936e-07,
  1.102628664716918e-08, -3.430004354658193e-10,  8.638519221241018e-12, -1.859475022413503e-13,  3.536227106240625e-15, -6.074769880810596e-17,  9.577011679470263e-19,
 -1.402046905912245e-20,  1.923441275436251e-22, -2.490283964265200e-24,  1.046383935566119e-06, -8.953364302220770e-08,  4.248927272003866e-09, -1.459819784870512e-10,
  4.033301566412195e-12, -9.473380689341611e-14,  1.957201459433535e-15, -3.639038790256664e-17,  6.189392013624491e-19, -9.747885927996242e-21,  1.435026211772995e-22,
 -1.989143442413832e-24,  3.015264653913090e-07, -2.898679610808041e-08,  1.527534397415711e-09, -5.780229924580427e-11,  1.747920326704247e-12, -4.470931303947221e-14,
  1.001717843966341e-15, -2.012635083796365e-17,  3.687636142030451e-19, -6.239399032575390e-21,  9.843753854875610e-23, -1.459032297201186e-24,  8.202606870711593e-08,
 -8.813346268375956e-09,  5.139486449698443e-10, -2.136234532814167e-11,  7.054852114087099e-13, -1.961456268100290e-14,  4.757944912279966e-16, -1.031461330049820e-17,
  2.033084209167417e-19, -3.690801199104380e-21,  6.232724193801843e-23, -9.866785910412887e-25,  2.112383934851844e-08, -2.524621851403647e-09,  1.623807740689898e-10,
 -7.394887553577169e-12,  2.661460555056963e-13, -8.028626144690297e-15,  2.105148069967695e-16, -4.917048393331240e-18,  1.041242057862791e-19, -2.025595686360726e-21,
  3.657178133063140e-23, -6.176731171360553e-25,  5.166261364242559e-09, -6.837655787284268e-10,  4.835549424198414e-11, -2.406831043975390e-12,  9.421088143065750e-14,
 -3.078177326127647e-15,  8.710932171047079e-17, -2.189117499345641e-18,  4.973995086024233e-20, -1.035679766572758e-21,  1.996959832377768e-23, -3.594470025180842e-25,
  1.204375780342927e-09, -1.757907414148349e-10,  1.362804613064200e-11, -7.396122424107151e-13,  3.142429565114911e-14, -1.110161461014626e-15,  3.385543819204556e-17,
 -9.141571859758818e-19,  2.225873983089966e-20, -4.954873742289314e-22,  1.019178873958546e-23, -1.953060781028852e-25,  2.687629420811897e-10, -4.309218868086877e-11,
  3.651564705169244e-12, -2.155812777046891e-13,  9.922695549597901e-15, -3.783916948440903e-16,  1.241654006113767e-17, -3.597398236117422e-19,  9.374912119711728e-21,
 -2.228459003089167e-22,  4.884503664490791e-24, -9.954803431237105e-26,  5.769115646331273e-11, -1.012272915919988e-11,  9.349678995223133e-13, -5.990919103310040e-14,
  2.981417272490036e-15, -1.225141943056679e-16,  4.319184557881679e-18, -1.340866023996914e-19,  3.735171975402668e-21, -9.469752479371228e-23,  2.209367089376362e-24,
 -4.783717531932328e-26,  1.197834223602599e-11, -2.291699423246356e-12,  2.300748676690682e-13, -1.596374429829580e-14,  8.572748003681190e-16, -3.789506139772792e-17,
  1.433105312229288e-18, -4.760366502816807e-20,  1.415603954333069e-21, -3.823203514198811e-23,  9.483476029360993e-25, -2.179069519573431e-26,  2.420950594532110e-12,
 -5.032233991867312e-13,  5.476233416224564e-14, -4.104960984047418e-15,  2.373973570091886e-16, -1.126834661621546e-17,  4.563864836699420e-19, -1.619677690670374e-20,
  5.134606787521749e-22, -1.475328972530629e-23,  3.886054419887959e-25, -9.464782103197662e-27,  4.797386349190578e-13, -1.079550035576961e-13,  1.269867809892535e-14,
 -1.025923159463834e-15,  6.376118791224457e-17, -3.243760082578653e-18,  1.404612346638033e-19, -5.317418164071189e-21,  1.794392410280631e-22, -5.477639080010889e-24,
  1.530109646539364e-25, -3.945259420983371e-27,  9.396958637431826e-14, -2.281005718832552e-14,  2.891966532776647e-15, -2.511926411182750e-16,  1.674056301822696e-17,
 -9.109751846345622e-19,  4.209742205121130e-20, -1.697111519761868e-21,  6.086571921601685e-23, -1.971008987727070e-24,  5.830476095002239e-26, -1.589314995366644e-27,
  1.836125511177054e-14, -4.790165553944423e-15,  6.526486693068737e-16, -6.078871254334360e-17,  4.334040781042335e-18, -2.517357461744114e-19,  1.239009020485482e-20,
 -5.309269140673369e-22,  2.020149666082188e-23, -6.928165773235436e-25,  2.166862901498262e-26, -6.234869896868501e-28,  3.615523523942222e-15, -1.009926541691424e-15,
  1.474104074671992e-16, -1.468254307284934e-17,  1.117083073918526e-18, -6.909442253392785e-20,  3.614183663047136e-21, -1.642812526952183e-22,  6.618834856730714e-24,
 -2.399565738099938e-25,  7.920902414991237e-27, -2.401699629489040e-28,  7.255559743312307e-16, -2.161517801673802e-16,  3.368776029046591e-17, -3.577535344405587e-18,
  2.896634817483880e-19, -1.903043742219805e-20,  1.055385904086863e-21, -5.077142029747901e-23,  2.161310524807364e-24, -8.265794013067239e-26,  2.874024120367612e-27,
 -9.165290868849222e-29,  1.502150641039110e-16, -4.753277914817097e-17,  7.882187738206921e-18, -8.896039885078680e-19,  7.642393823841228e-20, -5.318110104912212e-21,
  3.118570441016923e-22, -1.583760917108429e-23,  7.106167785748720e-25, -2.860254344785727e-26,  1.045193372358525e-27, -3.497983030562340e-29,  3.250790349471355e-17,
 -1.087915412239675e-17,  1.912212342364063e-18, -2.285574853487608e-19,  2.076420595017979e-20, -1.525655716031559e-21,  9.431820483547387e-23, -5.042160642509274e-24,
  2.378048719465226e-25, -1.004721376316183e-26,  3.848723845351853e-28, -1.348434322771119e-29,  7.455159097960832e-18, -2.626802964370891e-18,  4.873808551031646e-19,
 -6.145570995239331e-20,  5.882779478751924e-21, -4.548043295124563e-22,  2.954311660924370e-23, -1.657194528260281e-24,  8.190221216804930e-26, -3.621445267878270e-27,
  1.450038238697406e-28, -5.303578172457199e-30,  1.837223280641401e-18, -6.783171526432491e-19,  1.322627604097690e-19, -1.751978338081498e-20,  1.759930070288650e-21,
 -1.426121693099614e-22,  9.697592473862178e-24, -5.687458451290605e-25,  2.935299777734766e-26, -1.353762831073568e-27,  5.647464442785250e-29, -2.149549799577431e-30,
  4.931001191989201e-19, -1.898183713625124e-19,  3.870895572094659e-20, -5.361523635906093e-21,  5.626867929913580e-22, -4.758643160530753e-23,  3.373393361489682e-24,
 -2.060245551217348e-25,  1.106066092265539e-26, -5.300808357216104e-28,  2.295521046669126e-29, -9.060247459645371e-31,  1.458514240374575e-19, -5.823396338220786e-20,
  1.235542860899515e-20, -1.780435297630268e-21,  1.942644922108223e-22, -1.706517443138764e-23,  1.255399210717933e-24, -7.948838242180946e-26,  4.420012232680253e-27,
 -2.191995315947115e-28,  9.813921409624569e-30, -4.000846135976169e-31,  4.794051341506392e-20, -1.974537655541982e-20,  4.334418268620431e-21, -6.462694693145897e-22,
  7.292167193369978e-23, -6.619551354350447e-24,  5.028126479665922e-25, -3.284582284826117e-26,  1.882783394173793e-27, -9.617714848252916e-29,  4.431939258054993e-30,
 -1.858077975450267e-31,  1.753200573612379e-20, -7.406956274160725e-21,  1.672278259575151e-21, -2.564795412656460e-22,  2.975607292722826e-23, -2.775690499550959e-24,
  2.165159523757595e-25, -1.451494895058081e-26,  8.532937610661411e-28, -4.467336549386483e-29,  2.108488154662360e-30, -9.047820821076450e-32,  7.031875856067317e-21,
 -3.029700728954496e-21,  6.991186000698681e-22, -1.096084061636774e-22,  1.299525011793682e-23, -1.238238307536756e-24,  9.861231366132972e-26, -6.745927166309136e-27,
  4.044697928875877e-28, -2.158623771737372e-29,  1.038063680381038e-30, -4.536159573164411e-32,  2.923805902328135e-21, -1.277068426408225e-21,  2.992333573585234e-22,
 -4.764373884726081e-23,  5.735391791201482e-24, -5.547104415470028e-25,  4.482570793730498e-26, -3.110399177986793e-27,  1.890962396001001e-28, -1.022919812490690e-29,
  4.984307338638623e-31, -2.206079452122461e-32,  9.885271097759987e-22, -4.350788129895121e-22,  1.028220488731012e-22, -1.651358554108434e-23,  2.004986912671716e-24,
 -1.955484442682024e-25,  1.593204306864285e-26, -1.114371506227583e-27,  6.827771873345576e-29, -3.721632035348717e-30,  1.826868845706618e-31, -8.144081682324217e-33,
  5.710632601258029e-02, -1.344142835794018e-04,  3.268484637040065e-07, -8.171999353095134e-10,  2.088034065520755e-12, -5.422010560781225e-15,  1.422904795247960e-17,
 -3.761116100962177e-20,  9.972491978365889e-23, -2.650772436442542e-25,  7.036470396201662e-28, -1.870056531959063e-30,  5.298587999971922e-02, -1.502232661632616e-04,
  5.064937158625554e-07, -1.800068099045050e-09,  6.394010782373020e-12, -2.235726124456100e-14,  7.678424961410844e-17, -2.594244926773554e-19,  8.639130665676863e-22,
 -2.841169449260320e-24,  9.239844332835462e-27, -2.975536962440785e-29,  4.561738886815191e-02, -1.733299149131866e-04,  8.179228256047702e-07, -3.775900263376039e-09,
  1.663217694119988e-11, -7.046172777992171e-14,  2.894135694480465e-16, -1.158906983112673e-18,  4.541482302496162e-21, -1.746576072578978e-23,  6.606271155007582e-26,
 -2.461827280874176e-28,  3.644452885765558e-02, -1.913554431614870e-04,  1.175282892137548e-06, -6.612576733179894e-09,  3.471867325820830e-11, -1.732944999303746e-13,
  8.311308815959800e-16, -3.856447358684788e-18,  1.739650546650545e-20, -7.657719717375398e-23,  3.298827089296049e-25, -1.393939068308348e-27,  2.702234889038189e-02,
 -1.943735285732464e-04,  1.477105962664480e-06, -9.879403078757974e-09,  6.080747538359783e-11, -3.520820457303114e-13,  1.941760976126652e-15, -1.028605997114161e-17,
  5.265556892002855e-20, -2.616824649295105e-22,  1.267046141134472e-24, -5.994128381448235e-27,  1.859864397351414e-02, -1.791758941477771e-04,  1.638390294460692e-06,
 -1.285951477467576e-08,  9.170253644468902e-11, -6.088000899648392e-13,  3.818165651457059e-15, -2.284831676436505e-17,  1.314010556011113e-19, -7.301870870193391e-22,
  3.937119209651034e-24, -2.066650609272017e-26,  1.188526681691240e-02, -1.495320342023770e-04,  1.619712706441953e-06, -1.478001625752700e-08,  1.209653559735620e-10,
 -9.125481145387537e-13,  6.453650014557635e-15, -4.328071014881525e-17,  2.775204219705795e-19, -1.711899900530750e-21,  1.020728763714477e-23, -5.904966724288207e-26,
  7.053979862934961e-03, -1.131856756081138e-04,  1.437950013893515e-06, -1.513563846357167e-08,  1.410816437342344e-10, -1.200810671732273e-12,  9.512816974251867e-15,
 -7.104963059738856e-17,  5.049189541022432e-19, -3.437678286585774e-21,  2.254188838086093e-23, -1.429561237774178e-25,  3.889687312840479e-03, -7.794430833173703e-05,
  1.152859785639610e-06, -1.390224523155737e-08,  1.466475634195608e-10, -1.400118392607842e-12,  1.235755521641726e-14, -1.022654992541574e-16,  8.015598005032745e-19,
 -5.995386945345189e-21,  4.304174470539479e-23, -2.979399265354186e-25,  1.993615361616041e-03, -4.899105311670445e-05,  8.383804137727597e-07, -1.151327250051055e-08,
  1.367042627015876e-10, -1.456947010487503e-12,  1.426195672115541e-14, -1.302172268190392e-16,  1.121149149928945e-18, -9.176991153450946e-21,  7.186270588175630e-23,
 -5.410130146311076e-25,  9.502623874682919e-04, -2.819103661423381e-05,  5.550210438335632e-07, -8.634201967898591e-09,  1.148680798466067e-10, -1.360893794320857e-12,
  1.471811730814226e-14, -1.477276003209853e-16,  1.392366423078686e-18, -1.243145270909861e-20,  1.058493027086961e-22, -8.640478902328383e-25,  4.214969909354599e-04,
 -1.489285551463481e-05,  3.355407002304672e-07, -5.885354799897281e-09,  8.737630753110819e-11, -1.146590266068456e-12,  1.365460494080399e-14, -1.501937950744447e-16,
  1.545103874930397e-18, -1.500493423911768e-20,  1.385446401240607e-22, -1.223077621594795e-24,  1.741078004490458e-04, -7.241520531270326e-06,  1.857725569050025e-07,
 -3.658384528863678e-09,  6.039470656598067e-11, -8.750138297058903e-13,  1.144081053410712e-14, -1.375332681523364e-16,  1.540314129733773e-18, -1.623043693255410e-20,
  1.621275514438401e-22, -1.544381699720549e-24,  6.703436599259376e-05, -3.248681592771646e-06,  9.444351742594226e-08, -2.080143825880239e-09,  3.806196396297900e-11,
 -6.071123480454125e-13,  8.692666080995063e-15, -1.139290820233105e-16,  1.385949198438333e-18, -1.581168837591211e-20,  1.705228488591153e-22, -1.749261246876182e-24,
  2.408146681639400e-05, -1.347750393024285e-06,  4.420060115167108e-08, -1.085008858928238e-09,  2.194044080905314e-11, -3.842962316608768e-13,  6.011452419620984e-15,
 -8.571492637299837e-17,  1.130327852467350e-18, -1.393530313146356e-20,  1.619599864699047e-22, -1.786053703296652e-24,  8.081719964462064e-06, -5.182319337922578e-07,
  1.909185728764999e-08, -5.206215965043141e-10,  1.160321503681492e-11, -2.226497159043252e-13,  3.797059447068925e-15, -5.878639804799355e-17,  8.388291950581454e-19,
 -1.115640948433144e-20,  1.395071497141017e-22, -1.651279333641606e-24,  2.537350534699236e-06, -1.851206797963473e-07,  7.630348695925629e-09, -2.304459926263607e-10,
  5.646583885831594e-12, -1.184443856395580e-13,  2.197924443099468e-15, -3.688310413791350e-17,  5.685385983308436e-19, -8.144778166772910e-21,  1.094196872496753e-22,
 -1.388185111701684e-24,  7.465154798664106e-07, -6.158128550599803e-08,  2.829225394114875e-09, -9.436433742363236e-11,  2.536142831450246e-12, -5.803856867064866e-14,
  1.169805315766155e-15, -2.124265032862458e-17,  3.532031506651737e-19, -5.442527387929349e-21,  7.844800302425180e-23, -1.065388697642661e-24,  2.062180970216984e-07,
 -1.912593086435472e-08,  9.759591865334179e-10, -3.585285053066019e-11,  1.054600297236719e-12, -2.628028525232795e-14,  5.743859746255083e-16, -1.127003290164139e-17,
  2.018464765941269e-19, -3.341105499493750e-21,  5.160646076958126e-23, -7.493703122871772e-25,  5.360846379636740e-08, -5.561479691028143e-09,  3.141516423931294e-10,
 -1.267886328950814e-11,  4.073260316178791e-13, -1.103350358166048e-14,  2.610865298652029e-16, -5.527367164201960e-18,  1.064952564001209e-19, -1.891326447632622e-21,
  3.126926445450007e-23, -4.849582740631836e-25,  1.314953639879065e-08, -1.518766173387686e-09,  9.466916920137672e-11, -4.187429238121659e-12,  1.466380961396895e-13,
 -4.310349154499490e-15,  1.102640130826447e-16, -2.515343735055487e-18,  5.207040150980591e-20, -9.910546422670076e-22,  1.751938950770096e-23, -2.899048928425688e-25,
  3.052793605334408e-09, -3.908567011998505e-10,  2.680410130022305e-11, -1.296371856949866e-12,  4.938985705070140e-14, -1.572857380105439e-15,  4.343477874987228e-17,
 -1.066277052478541e-18,  2.368819444163708e-20, -4.826503265171795e-22,  9.113324685026524e-24, -1.607452045664148e-25,  6.732080415902667e-10, -9.515895633352720e-11,
  7.159026682130882e-12, -3.777429951490744e-13,  1.562814081597660e-14, -5.383363991386900e-16,  1.602581747260388e-17, -4.228378936532435e-19,  1.006938781303260e-20,
 -2.193981401943228e-22,  4.420425397595327e-24, -8.303008867508688e-26,  1.416014458440044e-10, -2.201338082789834e-11,  1.811804395111501e-12, -1.040676810313515e-13,
  4.666987296532169e-15, -1.736181033638187e-16,  5.563863134344200e-18, -1.575824731390679e-19,  4.017970035617567e-21, -9.351989763089119e-23,  2.008578354584148e-24,
 -4.013826322078168e-26,  2.854537007407234e-11, -4.862785471047328e-12,  4.366783043570119e-13, -2.724515054261159e-14,  1.321996546852458e-15, -5.302935127995740e-17,
  1.826861150115387e-18, -5.547099802870468e-20,  1.512623242062367e-21, -3.756881937542404e-23,  8.592635062379143e-25, -1.825056058993111e-26,  5.545687452022618e-12,
 -1.031566220418332e-12,  1.008034645298071e-13, -6.816923325768621e-15,  3.572342725269781e-16, -1.542660941333637e-17,  5.704873818201012e-19, -1.854689374143972e-20,
  5.402345973096063e-22, -1.430192507811580e-23,  3.479779926272489e-25, -7.847789906763935e-27,  1.044932483168097e-12, -2.115010131669517e-13,  2.243085977509177e-14,
 -1.640572417077293e-15,  9.267612865286315e-17, -4.301273589633281e-18,  1.704951238513839e-19, -5.926672934300127e-21,  1.841713444194213e-22, -5.190849682946952e-24,
  1.342059985245372e-25, -3.210351365791923e-27,  1.923519021784368e-13, -4.221828572203781e-14,  4.846519374974257e-15, -3.825094069240313e-16,  2.324740035180707e-17,
 -1.157603452514614e-18,  4.910537485403201e-20, -1.822519420469367e-21,  6.033892262860725e-23, -1.808291119963247e-24,  4.962006902357936e-26, -1.257547658311460e-27,
  3.488063707686679e-14, -8.272800060844326e-15,  1.025153726118586e-15, -8.710630753753077e-17,  5.683907273874256e-18, -3.030978520340228e-19,  1.373629041073736e-20,
 -5.434685903939372e-22,  1.914150100034626e-23, -6.091148789794525e-25,  1.771624577274219e-26, -4.750900997661411e-28,  6.289785107066313e-15, -1.606271750879513e-15,
  2.142525769460848e-16, -1.955075684516042e-17,  1.366685079273683e-18, -7.789023803608443e-20,  3.764286707097360e-21, -1.584891237923390e-22,  5.928864438522884e-24,
 -2.000222760198433e-25,  6.157386418987703e-27, -1.744712463385627e-28,  1.139839380449893e-15, -3.122777546110100e-16,  4.470077329384052e-17, -4.369001343465877e-18,
  3.264045262023972e-19, -1.983783550998506e-20,  1.020277155056871e-21, -4.562596372119884e-23,  1.809526504625548e-24, -6.461057227107424e-26,  2.101587617192781e-27,
 -6.282084774538899e-29,  2.100512217096048e-16, -6.149871192312321e-17,  9.417075985414301e-18, -9.830371047462638e-19,  7.828425680114155e-20, -5.061490862679808e-21,
  2.763977503915525e-22, -1.309989703950598e-23,  5.496799399427160e-25, -2.073135868934859e-26,  7.111787274616822e-28, -2.238578697056665e-29,  3.987616600414792e-17,
 -1.242626902410646e-17,  2.028467195341785e-18, -2.254493449926947e-19,  1.908202822723761e-20, -1.308922806682380e-21,  7.569845160337054e-23, -3.793146585600440e-24,
  1.680032426372747e-25, -6.677941369649510e-27,  2.410817193536875e-28, -7.974225519273853e-30,  7.908817432508588e-18, -2.611971150958163e-18,  4.528405555927837e-19,
 -5.340179193620633e-20,  4.788512210246878e-21, -3.474170945383721e-22,  2.121689328313862e-23, -1.120909100602397e-24,  5.226488664179876e-26, -2.183889144888027e-27,
  8.276558204789196e-29, -2.869882816366393e-30,  1.663387506721645e-18, -5.795770507980010e-19,  1.062826004814991e-19, -1.324785118275878e-20,  1.253989892816663e-21,
 -9.589949052112859e-23,  6.164254114272992e-24, -3.422775565311659e-25,  1.675034788027362e-26, -7.336177951690268e-28,  2.910432318846645e-29, -1.055041061388241e-30,
  3.767230766297839e-19, -1.378202873319602e-19,  2.661319609349316e-20, -3.491546064164219e-21,  3.474733352598546e-22, -2.790238518579466e-23,  1.880749702129406e-24,
 -1.093676846283298e-25,  5.598148612378167e-27, -2.561348655035408e-28,  1.060283772622558e-29, -4.005616651149382e-31,  9.327116283942032e-20, -3.564519664520064e-20,
  7.212693597187902e-21, -9.913475066310275e-22,  1.032609506388922e-22, -8.669182970766526e-24,  6.102173255395789e-25, -3.701305697768357e-26,  1.973916709895956e-27,
 -9.399219430025298e-29,  4.045010780310518e-30, -1.586925750880752e-31,  2.559209214421296e-20, -1.016225134084368e-20,  2.143341049980740e-21, -3.070382510300748e-22,
  3.330806044220865e-23, -2.909547988154138e-24,  2.128766328020271e-25, -1.340767483460460e-26,  7.417332166944259e-28, -3.660218125922823e-29,  1.630869786906521e-30,
 -6.617694999752039e-32,  7.862654978625022e-21, -3.225788140965801e-21,  7.050920159469150e-22, -1.046830877794765e-22,  1.176265141115229e-23, -1.063434784694346e-24,
  8.045872133573435e-26, -5.235798475404651e-27,  2.990125092374704e-28, -1.521935184226539e-29,  6.988771066290614e-31, -2.920138048056037e-32,  2.713486906308284e-21,
 -1.143466435316291e-21,  2.574331886098974e-22, -3.937128172940945e-23,  4.555082634311185e-24, -4.237560572820994e-25,  3.296793655273618e-26, -2.204487013162788e-27,
  1.292747067555074e-28, -6.751785775967353e-30,  3.179268792120552e-31, -1.361190632181230e-32,  1.038916232501253e-21, -4.469523062955530e-22,  1.029655194823884e-22,
 -1.611614679396477e-23,  1.907613900095835e-24, -1.814743966725496e-25,  1.442998709512028e-26, -9.856412606013705e-28,  5.900983361822186e-29, -3.144811300867225e-30,
  1.510214936384484e-31, -6.590511578980743e-33,  4.178036474079637e-22, -1.823565151268414e-22,  4.269356831512058e-23, -6.792046564788478e-24,  8.169681156233774e-25,
 -7.895194973121103e-26,  6.375090541168335e-27, -4.420246177353976e-28,  2.685299919842672e-29, -1.451574726359099e-30,  7.068034498587501e-32, -3.126222010499532e-33,
  1.386026487302639e-22, -6.098485179949290e-23,  1.440769212266828e-23, -2.313136641562979e-24,  2.807528014086723e-25, -2.737294766255461e-26,  2.229439747386605e-27,
 -1.558884435683609e-28,  9.548281637090437e-30, -5.202889308937409e-31,  2.553207269563832e-32, -1.137866530377496e-33,  5.657383713757595e-02, -1.318381616440580e-04,
  3.172389963641443e-07, -7.846407089539719e-10,  1.982925350637302e-12, -5.092798781937558e-15,  1.321921542691640e-17, -3.456737277401556e-20,  9.066955351032518e-23,
 -2.385095020907013e-25,  6.263551220637176e-28, -1.648235037018711e-30,  5.239295644064540e-02, -1.462560138787407e-04,  4.854922856379255e-07, -1.701243376368949e-09,
  5.964721155486903e-12, -2.059857399406237e-14,  6.989251457750982e-17, -2.333469393681935e-19,  7.679799423667931e-22, -2.496472913721098e-24,  8.025585606099948e-27,
 -2.555164902443708e-29,  4.493687525386270e-02, -1.669633562723769e-04,  7.741633997230552e-07, -3.520692658076337e-09,  1.528985571181190e-11, -6.388933611756239e-14,
  2.589077503266546e-16, -1.023150270008806e-18,  3.957781618395826e-21, -1.502769312156370e-23,  5.612895866895781e-26, -2.065769549472506e-28,  3.569742204879340e-02,
 -1.822613967725373e-04,  1.099154002640157e-06, -6.083756899750540e-09,  3.144382286742204e-11, -1.545826784171432e-13,  7.305470394081150e-16, -3.341436203123472e-18,
  1.486317396419394e-20, -6.453098204340534e-23,  2.742506527351010e-25, -1.143507381813027e-27,  2.626776030150150e-02, -1.830148717731418e-04,  1.364166211653139e-06,
 -8.960379149496334e-09,  5.420947664217773e-11, -3.087538631606978e-13,  1.675991627977399e-15, -8.742522596729396e-18,  4.408711788211958e-20, -2.159054574128661e-22,
  1.030447486314093e-24, -4.806310825985520e-27,  1.790721135172098e-02, -1.666619794862332e-04,  1.492493306125683e-06, -1.148491258622338e-08,  8.039343079232704e-11,
 -5.243892472572511e-13,  3.233535502909871e-15, -1.903536918716506e-17,  1.077428251165390e-19, -5.894862674837875e-22,  3.130495241942590e-24, -1.618914605624102e-26,
  1.131197549058422e-02, -1.372522051269334e-04,  1.453389080093682e-06, -1.298255738122278e-08,  1.041700635619169e-10, -7.712535671409585e-13,  5.357388175102662e-15,
 -3.531212503162601e-17,  2.226554931698279e-19, -1.351195255566924e-21,  7.928983546320161e-24, -4.515837159641320e-26,  6.623145918707510e-03, -1.023719598053439e-04,
  1.269112065078909e-06, -1.305870210813560e-08,  1.191963382038414e-10, -9.946583739541967e-13,  7.732199229032109e-15, -5.670990124887865e-17,  3.959831180357854e-19,
 -2.650293115652109e-21,  1.709145865979281e-23, -1.066389890668059e-25,  3.595352898501753e-03, -6.935087779745128e-05,  9.992365891761305e-07, -1.176471277117078e-08,
  1.213932452388320e-10, -1.135187990753675e-12,  9.823001381266982e-15, -7.976069470495267e-17,  6.137965398934702e-19, -4.509956566297255e-21,  3.182126577551629e-23,
 -2.165759467743695e-25,  1.810239946811313e-03, -4.280156293061738e-05,  7.124401906792352e-07, -9.541688681329376e-09,  1.107125847753485e-10, -1.154645485298027e-12,
  1.107218442456312e-14, -9.911505833694645e-17,  8.372518412847146e-19, -6.727801920224330e-21,  5.174645961725229e-23, -3.828131213371777e-25,  8.457639094503307e-04,
 -2.413601633884895e-05,  4.615982996676247e-07, -6.996184080326964e-09,  9.087187244785306e-11, -1.052646700997435e-12,  1.114366748290584e-14, -1.095842274053201e-16,
  1.012690795218316e-18, -8.870741584422566e-21,  7.414498800844479e-23, -5.944298117493847e-25,  3.668783253786514e-04, -1.246889443455395e-05,  2.726018175353035e-07,
 -4.654318080084141e-09,  6.740785604847673e-11, -8.642211051973650e-13,  1.006723479150928e-14, -1.084208501128562e-16,  1.092934910039313e-18, -1.040738923905215e-20,
  9.428122433055512e-23, -8.170428666256487e-25,  1.478575946780667e-04, -5.915754383839934e-06,  1.471373007055293e-07, -2.818368229188796e-09,  4.535494638829591e-11,
 -6.415740039346071e-13,  8.200309039262682e-15, -9.646220218488881e-17,  1.058030084598398e-18, -1.092620098136226e-20,  1.070328267160449e-22, -1.000407125497164e-24,
  5.540613072311186e-05, -2.583481709923916e-06,  7.276900343461700e-08, -1.557955883696641e-09,  2.777139454180523e-11, -4.322393125473011e-13,  6.046564087633478e-15,
 -7.750699330245802e-17,  9.229589017957713e-19, -1.031494107043798e-20,  1.090456136136989e-22, -1.097160506666193e-24,  1.932292873642125e-05, -1.040795182321922e-06,
  3.305646930231592e-08, -7.883582664729816e-10,  1.552217115975590e-11, -2.651566976221978e-13,  4.050499731038122e-15, -5.646000494120116e-17,  7.285083231786462e-19,
 -8.794852829489849e-21,  1.001605570740025e-22, -1.082988426400465e-24,  6.278741529251095e-06, -3.876396687860814e-07,  1.382598929659854e-08, -3.661522212504323e-10,
  7.942418366499242e-12, -1.485751636183970e-13,  2.473383826197014e-15, -3.742075425869835e-17,  5.222768495921455e-19, -6.799693421644988e-21,  8.329198343933740e-23,
 -9.663666661378806e-25,  1.903391921253243e-06, -1.337664459399563e-07,  5.337302194887473e-09, -1.565029939803639e-10,  3.731123489127088e-12, -7.627453067333020e-14,
  1.381217423247979e-15, -2.264321464585809e-17,  3.413020090696463e-19, -4.784979076095939e-21,  6.295497113114016e-23, -7.827019975115193e-25,  5.391551863772336e-07,
 -4.286636587323364e-08,  1.906456947215118e-09, -6.172817163186833e-11,  1.613850936232921e-12, -3.598505059040769e-14,  7.076297675479604e-16, -1.255069121469778e-17,
  2.040145708766788e-19, -3.075911843524067e-21,  4.341197632619405e-23, -5.776666659352094e-25,  1.429627432446826e-07, -1.278790663672137e-08,  6.317834352857606e-10,
 -2.253054662899065e-11,  6.446344421239063e-13, -1.565022083818952e-14,  3.336758145021712e-16, -6.393740039980332e-18,  1.119367575579412e-19, -1.812698688433660e-21,
  2.741228091306481e-23, -3.899736750470678e-25,  3.556217802488570e-08, -3.560853977661168e-09,  1.948005975814709e-10, -7.632971385569920e-12,  2.385322677184645e-13,
 -6.294750594045859e-15,  1.453001375750858e-16, -3.003935666259595e-18,  5.657248136474072e-20, -9.828951162270764e-22,  1.590918713394439e-23, -2.417239499986659e-25,
  8.319651472645944e-09, -9.282478961501790e-10,  5.606009177362659e-11, -2.408029053738266e-12,  8.203868229634101e-14, -2.349566731314149e-15,  5.863489276944833e-17,
 -1.306272832705410e-18,  2.643321928055695e-20, -4.921994436541461e-22,  8.518655010238604e-24, -1.381061935192702e-25,  1.835930639628604e-09, -2.272832458228057e-10,
  1.511001812368520e-11, -7.099456483461753e-13,  2.632146291423726e-14, -8.168799536242867e-16,  2.201054101740916e-17, -5.277699822279300e-19,  1.146279308013784e-20,
 -2.285247967654223e-22,  4.225151321539433e-24, -7.302391979814380e-26,  3.834800402424698e-10, -5.246766899507972e-11,  3.829199168803022e-12, -1.963819924329471e-13,
  7.909753351891302e-15, -2.656139275350870e-16,  7.717337929084977e-18, -1.989372990359018e-19,  4.632701428606418e-21, -9.878838273465103e-23,  1.949384579656609e-24,
 -3.588597632464465e-26,  7.612325668587270e-11, -1.146804607603125e-11,  9.163899061175122e-13, -5.119329966032988e-14,  2.236216304249497e-15, -8.113571010854006e-17,
  2.538754470635208e-18, -7.027634236834683e-20,  1.752863594274263e-21, -3.994208084612465e-23,  8.404540153948045e-25, -1.646546844463263e-26,  1.442854298406988e-11,
 -2.384942004595206e-12,  2.081286818945735e-13, -1.263930417177831e-14,  5.977659097601899e-16, -2.339972448217371e-17,  7.875122660289633e-19, -2.338231784476295e-20,
  6.240112701552361e-22, -1.517974784846504e-23,  3.402863443789072e-25, -7.088626752520412e-27,  2.625622354561910e-12, -4.745508462899811e-13,  4.511359764581122e-14,
 -2.972204802321157e-15,  1.519343518128095e-16, -6.407341458832285e-18,  2.316306772729982e-19, -7.368123278273998e-21,  2.101643430887846e-22, -5.452372859760393e-24,
  1.300929157951829e-25, -2.878986688742188e-27,  4.616346036004504e-13, -9.092536391146919e-14,  9.392725256512739e-15, -6.699682487004529e-16,  3.695258746512792e-17,
 -1.676286286929820e-18,  6.500518663883640e-20, -2.212603536499804e-21,  6.737667590921882e-23, -1.862218271126856e-24,  4.724477863915646e-26, -1.109672985402153e-27,
  7.899480189980778e-14, -1.689933909053941e-14,  1.892156796098010e-15, -1.458135274802988e-16,  8.661930013868299e-18, -4.219915606034024e-19,  1.752905878444360e-20,
 -6.375818337455394e-22,  2.070212739520997e-23, -6.088825849088885e-25,  1.640749950260926e-26, -4.085916651070758e-28,  1.326741601957065e-14, -3.072387991359476e-15,
  3.718889857020865e-16, -3.089430373094530e-17,  1.972821899171548e-18, -1.030427475269969e-19,  4.577723943435504e-21, -1.776740926830042e-22,  6.143191879071241e-24,
 -1.920270793117172e-25,  5.489557276562834e-27, -1.447743835377091e-28,  2.208204836287663e-15, -5.516275858751014e-16,  7.198681957397057e-17, -6.431770496101471e-18,
  4.405908606248663e-19, -2.462600173831613e-20,  1.168041534658631e-21, -4.829895782977761e-23,  1.775617173689075e-24, -5.890516968539513e-26,  1.784059293709586e-27,
 -4.976318015968429e-29,  3.682144057931791e-16, -9.887039626069749e-17,  1.387053125065908e-17, -1.329514691279874e-18,  9.747960350940396e-20, -5.818411977310899e-21,
  2.940831308049004e-22, -1.293232658316952e-23,  5.046561557601309e-25, -1.773933691887373e-26,  5.683382477697849e-28, -1.674196316407007e-29,  6.227424087979565e-17,
 -1.790598661273233e-17,  2.692173227717061e-18, -2.760805983862710e-19,  2.161167917436516e-20, -1.374387448965322e-21,  7.386503823207305e-23, -3.447378287440319e-24,
  1.425201632591643e-25, -5.298522819343406e-27,  1.792541467156956e-28, -5.567064440741761e-30,  1.082931118494894e-17, -3.321123188810308e-18,  5.333480260874404e-19,
 -5.833964375934333e-20,  4.862256965137400e-21, -3.285926264488392e-22,  1.873208214320238e-23, -9.256959567012119e-25,  4.045379664124116e-26, -1.587264665953316e-27,
  5.658718003360602e-29, -1.849141765578259e-30,  1.965559254894729e-18, -6.402097615987624e-19,  1.094141202229877e-19, -1.272291494369243e-20,  1.125435558718847e-21,
 -8.058546301338844e-23,  4.859211397795052e-24, -2.535820550576348e-25,  1.168420961462393e-26, -4.826468953313803e-28,  1.808915643899540e-29, -6.205299942466717e-31,
  3.784028046144049e-19, -1.303087579024729e-19,  2.360439467424844e-20, -2.906928685190499e-21,  2.719511001609857e-22, -2.056284419000384e-23,  1.307312330248866e-24,
 -7.182344594784947e-26,  3.478975773198042e-27, -1.508624894040850e-28,  5.927754682671303e-30, -2.128934929022698e-31,  7.857842304837643e-20, -2.847080383197415e-20,
  5.441859512151953e-21, -7.067894706283927e-22,  6.965175406452022e-23, -5.540137086905833e-24,  3.700076330326170e-25, -2.132545548234287e-26,  1.082201298293355e-27,
 -4.910281649487016e-29,  2.016269533632654e-30, -7.557907219645923e-32,  1.789922546194446e-20, -6.788266983906418e-21,  1.362369708313852e-21, -1.857363089798506e-22,
  1.919408210189841e-23, -1.599081870928169e-24,  1.117228636717580e-25, -6.727905079985623e-27,  3.563038967189571e-28, -1.685180119123072e-29,  7.204921198807372e-31,
 -2.808768547256528e-32,  4.542961094473841e-21, -1.793492351943068e-21,  3.759002077469889e-22, -5.351330784295217e-23,  5.769904083398775e-24, -5.010365014295700e-25,
  3.644804469050051e-26, -2.282861551388774e-27,  1.256114926927531e-28, -6.166197883072358e-30,  2.733564429286092e-31, -1.103797814906905e-32,  1.300822975873226e-21,
 -5.314762501451760e-22,  1.156450659637986e-22, -1.709213758366225e-23,  1.912075142784228e-24, -1.721243514950038e-25,  1.296854160039494e-26, -8.405092760228820e-28,
  4.781284154517121e-29, -2.424373326334391e-30,  1.109182782821032e-31, -4.618039934760938e-33,  4.224906936324409e-22, -1.775538716676829e-22,  3.985363502510001e-23,
 -6.076857059482610e-24,  7.009983116898792e-25, -6.502656577631482e-26,  5.044942142300761e-27, -3.364319396786137e-28,  1.967722016269147e-29, -1.025094133887163e-30,
  4.815048065934170e-32, -2.056627801941193e-33,  1.540470382387357e-22, -6.616760199122413e-23,  1.521637012249781e-23, -2.377457253810327e-24,  2.809231368318545e-25,
 -2.667940549764766e-26,  2.117923852486360e-27, -1.444332281379789e-28,  8.633691815671472e-30, -4.594204275950495e-31,  2.203013437634624e-32, -9.600203880105407e-34,
  5.981057002800904e-23, -2.608505517719767e-23,  6.101795681931979e-24, -9.698793105182577e-25,  1.165599364776662e-25, -1.125491268750778e-26,  9.080495259878669e-28,
 -6.291042874353920e-29,  3.818836672640687e-30, -2.062760117214562e-31,  1.003662661254250e-32, -4.436067060578899e-34,  1.944804243354981e-23, -8.554440971202800e-24,
  2.020280832682018e-24, -3.242379626207537e-25,  3.933987202677707e-26, -3.834235969812505e-27,  3.121792464674888e-28, -2.182106742034139e-29,  1.336115150334641e-30,
 -7.278177832652133e-32,  3.570477768525284e-33, -1.590731553702587e-34,  5.605150143362414e-02, -1.293373807021504e-04,  3.080103623959424e-07, -7.537118365746939e-10,
  1.884165249283616e-12, -4.786832152185531e-15,  1.229069180632251e-17, -3.179863136614123e-20,  8.251724868497462e-23, -2.148468796939838e-25,  5.581846600424750e-28,
 -1.454765560701831e-30,  5.181557321711010e-02, -1.424521436000814e-04,  4.656366725677437e-07, -1.609014642424532e-09,  5.569008655758291e-12, -1.899686208112730e-14,
  6.368977369619860e-17, -2.101497248820204e-19,  6.836244232050493e-22, -2.196841367870848e-24,  6.981997125002009e-27, -2.197951825577048e-29,  4.428114661650243e-02,
 -1.609349784470852e-04,  7.333418146309376e-07, -3.285949133925972e-09,  1.407195824153641e-11, -5.800550208005499e-14,  2.319542884516816e-16, -9.047410583693793e-19,
  3.455099907109015e-21, -1.295420488443834e-23,  4.778466906198116e-26, -1.737135373760974e-28,  3.498551233247380e-02, -1.737518612933566e-04,  1.029068503453085e-06,
 -5.604467199379022e-09,  2.852019113332181e-11, -1.381206000274730e-13,  6.433108295971784e-16, -2.900961858803721e-18,  1.272597120540995e-20, -5.450439565456874e-23,
  2.285562498215925e-25, -9.404866859827467e-28,  2.555686670007218e-02, -1.725173508101858e-04,  1.261648852754438e-06, -8.140323098190269e-09,  4.841760375591530e-11,
 -2.713150400410235e-13,  1.449837951855634e-15, -7.448537121836367e-18,  3.700817263943446e-20, -1.786243118649344e-22,  8.404550446460284e-25, -3.865610395871002e-27,
  1.726360032696308e-02, -1.552522123774009e-04,  1.362059207191778e-06, -1.027847789311225e-08,  7.064045547818368e-11, -4.528094590748907e-13,  2.745788211053356e-15,
 -1.590430259960468e-17,  8.861359235378329e-20, -4.774291997517553e-22,  2.497548788188325e-24, -1.272669617428313e-26,  1.078527273191608e-02, -1.262210495129213e-04,
  1.307111434990684e-06, -1.143257314200958e-08,  8.995465540926286e-11, -6.537788528521945e-13,  4.461500564827936e-15, -2.890791068471265e-17,  1.792729116817077e-19,
 -1.070475591564369e-21,  6.183250714094303e-24, -3.467543910443604e-26,  6.233015268635681e-03, -9.281490853494352e-05,  1.123225259033956e-06, -1.130113845054099e-08,
  1.010373229879045e-10, -8.267919038679042e-13,  6.308269165227095e-15, -4.544172365795037e-17,  3.118257517256940e-19, -2.052016455369692e-21,  1.301670522699310e-23,
 -7.991613317117402e-26,  3.333087495077674e-03, -6.189031821368403e-05,  8.690040731136531e-07, -9.991962961262094e-09,  1.008769730840804e-10, -9.241577392326866e-13,
  7.841924021715004e-15, -6.248877931043300e-17,  4.722245992293385e-19, -3.409116385234342e-21,  2.364475305974436e-23, -1.582537380456461e-25,  1.649747882225534e-03,
 -3.753159436931983e-05,  6.078505844842710e-07, -7.941484313195341e-09,  9.006695277803991e-11, -9.193985023250925e-13,  8.638308824408081e-15, -7.582950168335997e-17,
  6.285764769526930e-19, -4.959450849188238e-21,  3.747314394764341e-23, -2.724584093678949e-25,  7.561066051083476e-04, -2.075584016624829e-05,  3.857174147182100e-07,
 -5.697107198757044e-09,  7.226262525165131e-11, -8.186329023575793e-13,  8.484788774323642e-15, -8.176279422675414e-17,  7.409717302949067e-19, -6.369069179485026e-21,
  5.226691054453863e-23, -4.116089279452677e-25,  3.210349027804514e-04, -1.049438540202229e-05,  2.226906345594155e-07, -3.701905341681889e-09,  5.231271696448389e-11,
 -6.554066329310028e-13,  7.469569572153225e-15, -7.877869512327816e-17,  7.782929765433642e-19, -7.268340384614673e-21,  6.461254250792565e-23, -5.497423453488031e-25,
  1.263507908231604e-04, -4.862511122211422e-06,  1.172798029893516e-07, -2.185501594114198e-09,  3.429109547862185e-11, -4.736879574732678e-13,  5.919659518192969e-15,
 -6.815150922299733e-17,  7.321971925560371e-19, -7.411715167887584e-21,  7.121213049996068e-23, -6.531893891530667e-25,  4.612796163479842e-05, -2.069166956650063e-06,
  5.647796885086591e-08, -1.175569080192972e-09,  2.041789258380924e-11, -3.101419070317939e-13,  4.239525229183987e-15, -5.315807395027247e-17,  6.197346557945771e-19,
 -6.785895082316216e-21,  7.033095708278985e-23, -6.941551500726569e-25,  1.563420561540070e-05, -8.103338047582813e-07,  2.492704221751549e-08, -5.776403456862447e-10,
  1.107557249198058e-11, -1.845480314831474e-13,  2.753409614612930e-15, -3.752487280924999e-17,  4.738240800521994e-19, -5.602083984021869e-21,  6.252427474229885e-23,
 -6.629301257943567e-25,  4.924347650714298e-06, -2.926532430525917e-07,  1.010612527894935e-08, -2.599452156392977e-10,  5.488534978314318e-12, -1.001038723027495e-13,
  1.626926392284441e-15, -2.405643957999007e-17,  3.284434418766116e-19, -4.186340486382938e-21,  5.023844400424572e-23, -5.713911436904179e-25,  1.443122177386051e-06,
 -9.767052873968156e-08,  3.772407521837808e-09, -1.074030753296731e-10,  2.491531369862950e-12, -4.964261045258275e-14,  8.773245422057120e-16, -1.405195921335227e-17,
  2.071307638003899e-19, -2.842139366778432e-21,  3.662397806981575e-23, -4.462531288964877e-25,  3.940561854734155e-07, -3.018794082545782e-08,  1.299590314526674e-09,
 -4.084882749095860e-11,  1.038934520639919e-12, -2.257271308111936e-14,  4.330911853746027e-16, -7.502972352371815e-18,  1.192424702196404e-19, -1.759164484658824e-21,
  2.431207355901867e-23, -3.169974419313122e-25,  1.004267315308725e-07, -8.661001348789947e-09,  4.142317523808773e-10, -1.433960788379185e-11,  3.990723168144522e-13,
 -9.439022214814533e-15,  1.963226073534571e-16, -3.673843809285289e-18,  6.287425135378742e-20, -9.961455453247995e-22,  1.474895429237723e-23, -2.055709843178193e-25,
  2.393584131916621e-08, -2.312416448488316e-09,  1.224931384486089e-10, -4.659440259076541e-12,  1.416293248004725e-13, -3.641073341326166e-15,  8.198312918415891e-17,
 -1.655140536754569e-18,  3.046839489862735e-20, -5.178644754055252e-22,  8.206277874454658e-24, -1.221525987467529e-25,  5.347963478066864e-09, -5.761680408270748e-10,
  3.370616219337364e-11, -1.405785716331819e-12,  4.658930460538103e-14, -1.299940228547688e-15,  3.164543633644381e-17, -6.884629256094172e-19,  1.361759034683361e-20,
 -2.480612950568741e-22,  4.203221775146354e-24, -6.675989889137855e-26,  1.123280218952227e-09, -1.343984603918178e-10,  8.659237866209116e-12, -3.951669586617186e-13,
  1.425516517443157e-14, -4.310826230448794e-16,  1.133208160858809e-17, -2.653774377521846e-19,  5.634520422645024e-21, -1.099027707454710e-22,  1.989533270401055e-24,
 -3.369040749611564e-26,  2.225287721212568e-10, -2.945562033997782e-11,  2.084712960820875e-12, -1.038906056599727e-13,  4.072816062880892e-15, -1.333047602280338e-16,
  3.779586719819833e-18, -9.517594584397580e-20,  2.167099936703368e-21, -4.522109519869157e-23,  8.738669633212796e-25, -1.576459186141350e-26,  4.174226415976634e-11,
 -6.090683567387095e-12,  4.723346765551669e-13, -2.565500069277014e-14,  1.091279995202902e-15, -3.860765191147071e-17,  1.179287549036270e-18, -3.189951216629842e-20,
  7.781952844692115e-22, -1.735748708514919e-23,  3.577693226712581e-25, -6.870543351474542e-27,  7.448125522743805e-12, -1.193862806887336e-12,  1.012022420155457e-13,
 -5.979744845349407e-15,  2.755610671017848e-16, -1.052368256758085e-17,  3.459079620741028e-19, -1.004058124718660e-20,  2.621859845314487e-22, -6.245518827437088e-24,
  1.371974448812253e-25, -2.802538292924225e-27,  1.270956550163257e-12, -2.230583639830225e-13,  2.061921446362638e-14, -1.322868786357803e-15,  6.593929836469896e-17,
 -2.714721765329585e-18,  9.590774652372850e-20, -2.984199506258260e-21,  8.333104870628932e-23, -2.118070389959727e-24,  4.954701721448569e-26, -1.075713672153898e-27,
  2.087142702063034e-13, -3.997734971480855e-14,  4.020280729130035e-15, -2.795284077921287e-16,  1.504703810716209e-17, -6.669017853338735e-19,  2.529259767632521e-20,
 -8.426811663741182e-22,  2.513800044114563e-23, -6.811305600637178e-25,  1.695210697974946e-26, -3.908507973930888e-28,  3.322655717145340e-14, -6.923456707913723e-15,
  7.556375501153020e-16, -5.682734402190767e-17,  3.298035245380406e-18, -1.571309298163869e-19,  6.388950621460512e-21, -2.276563805544589e-22,  7.247042094921631e-24,
 -2.091141720822085e-25,  5.531913890907076e-27, -1.353230234152360e-28,  5.171446212133590e-15, -1.168456652310624e-15,  1.380641960951516e-16, -1.120749780643447e-17,
  7.000182081169667e-19, -3.579551331728415e-20,  1.558175183417673e-21, -5.930372162683474e-23,  2.012111019725276e-24, -6.175977079450424e-26,  1.734724507004035e-27,
 -4.497686231654833e-29,  7.946585362525164e-16, -1.940412254362689e-16,  2.475827681971637e-17, -2.164625900033275e-18,  1.452288107622900e-19, -7.956763424979241e-21,
  3.702207775189776e-22, -1.502830618401550e-23,  5.427232549180939e-25, -1.769725788845511e-26,  5.271495267159773e-28, -1.446922125965035e-29,  1.219161161330595e-16,
 -3.206102171326891e-17,  4.405244031216709e-18, -4.138461255158537e-19,  2.976191613317246e-20, -1.743712090099624e-21,  8.656977986626521e-23, -3.741807270566554e-24,
  1.436059911692982e-25, -4.967443140288423e-27,  1.566937010586605e-28, -4.547001712588831e-30,  1.891428040118782e-17, -5.337235145307911e-18,  7.873859811020238e-19,
 -7.927420074229685e-20,  6.096521856053347e-21, -3.811394443806370e-22,  2.014952525871198e-23, -9.255938099696266e-25,  3.768359932584854e-26, -1.380383864285111e-27,
  4.603565711386059e-29, -1.410064643031886e-30,  3.010174813659603e-18, -9.078872368257554e-19,  1.433418919991391e-19, -1.542172103594805e-20,  1.264898432009836e-21,
 -8.417242776657652e-23,  4.727478237397679e-24, -2.302866194775820e-25,  9.924979040162729e-27, -3.842296473424148e-28,  1.352137602882902e-29, -4.363378162673482e-31,
  4.993065793812466e-19, -1.602877655668601e-19,  2.698699889028702e-20, -3.092531150891279e-21,  2.697084180530524e-22, -1.904959251633675e-23,  1.133585274030595e-24,
 -5.840664560245515e-26,  2.658183182524302e-27, -1.085010401380476e-28,  4.019846280849834e-30, -1.363667710448903e-31,  8.782545954189653e-20, -2.987334678694704e-20,
  5.342191546905984e-21, -6.496489842039616e-22,  6.003634610964000e-23, -4.485995841375980e-24,  2.819546505365747e-25, -1.531992962732764e-26,  7.341621100720373e-28,
 -3.150822463243959e-29,  1.225687803630786e-30, -4.359584313886512e-32,  1.668383389886545e-20, -5.983724190854275e-21,  1.131506027607831e-21, -1.454133422213970e-22,
  1.418328148848214e-23, -1.116953996050665e-24,  7.388159258525191e-26, -4.218635538378680e-27,  2.121593876566904e-28, -9.542628755360310e-30,  3.885429405232100e-31,
 -1.444588685818631e-32,  3.487202817758726e-21, -1.311845299325994e-21,  2.610142952597006e-22, -3.528186869275101e-23,  3.615780192138969e-24, -2.988091056233852e-25,
  2.071403191149934e-26, -1.237973076531037e-27,  6.508286816621385e-29, -3.056393698419703e-30,  1.297797912744239e-31, -5.025845230715007e-33,  8.163256042339274e-22,
 -3.202939580206435e-22,  6.668619957404646e-23, -9.431040140404222e-24,  1.010341682528430e-24, -8.718694196484282e-26,  6.304088294816060e-27, -3.925333790869855e-28,
  2.147614412233506e-29, -1.048461763107635e-30,  4.623257490180120e-32, -1.857247735755927e-33,  2.171988237197248e-22, -8.835066129437260e-23,  1.913231080440164e-23,
 -2.814223137641061e-24,  3.133531919137681e-25, -2.807983718161983e-26,  2.106325937110596e-27, -1.359309171032304e-28,  7.700511498222827e-30, -3.888929775838972e-31,
  1.772326452520569e-32, -7.351312961021572e-34,  6.619905853944246e-23, -2.774000788789428e-23,  6.206686423090248e-24, -9.433802254992193e-25,  1.084846278489367e-25,
 -1.003277894797053e-26,  7.760754890308542e-28, -5.160607675470870e-29,  3.009962964469419e-30, -1.563838529671149e-31,  7.326480096831410e-33, -3.121437276946846e-34,
  2.292894070585253e-23, -9.832036850711926e-24,  2.256816801803148e-24, -3.519514203457762e-25,  4.151039452740370e-26, -3.935180293811258e-27,  3.118454675827772e-28,
 -2.123042334804570e-29,  1.266986957906099e-30, -6.731178707844213e-32,  3.222728664305397e-33, -1.402279460889181e-34,  8.578492806294235e-24, -3.738259438714081e-24,
  8.736507980320465e-25, -1.387387063341601e-25,  1.665845974698830e-26, -1.607096179850285e-27,  1.295486877865773e-28, -8.967671400237969e-30,  5.439155471395125e-31,
 -2.935635175118004e-32,  1.427261275654580e-33, -6.303565208975868e-35,  2.730964484117060e-24, -1.200855912835527e-24,  2.834991581452616e-25, -4.548227901075002e-26,
  5.516336783742523e-27, -5.374504967470568e-28,  4.374296742024971e-29, -3.056523507725431e-30,  1.870881059749222e-31, -1.018775490426390e-32,  4.996186593059613e-34,
 -2.225199835817810e-35,  5.553902350857030e-02, -1.269089706515302e-04,  2.991435920132192e-07, -7.243153561131551e-10,  1.791307765284170e-12, -4.502248502247198e-15,
  1.143616511680575e-17, -2.927764412010210e-20,  7.516969851658951e-23, -1.937483020923554e-25,  4.979742147020378e-28, -1.285835917689835e-30,  5.125309464545545e-02,
 -1.388027964974272e-04,  4.468508474248742e-07, -1.522868907469289e-09,  5.203892812593139e-12, -1.753651702850013e-14,  5.810032944657445e-17, -1.894870581992072e-19,
  6.093406383302686e-22, -1.935972915047721e-24,  6.083563705443212e-27, -1.893862606503768e-29,  4.364889572942728e-02, -1.552222281609384e-04,  6.952240061537392e-07,
 -3.069784607753828e-09,  1.296552806365487e-11, -5.273051659197975e-14,  2.081018614139702e-16, -8.012850256261266e-19,  3.021388671083876e-21, -1.118727643625166e-23,
  4.076069340638306e-26, -1.463835770378743e-28,  3.430655472551034e-02, -1.657807748263239e-04,  9.644643196419784e-07, -5.169431371799615e-09,  2.590582470316377e-11,
 -1.236115980871221e-13,  5.675022811128512e-16, -2.523438695014205e-18,  1.091886992220458e-20, -4.613872035316928e-23,  1.909286076732076e-25, -7.754589964875706e-28,
  2.488638307761930e-02, -1.628021263670024e-04,  1.168439933608642e-06, -7.407229832162702e-09,  4.332303799524063e-11, -2.388935338780245e-13,  1.256936260671289e-15,
 -6.360993417108904e-18,  3.114397341603773e-20, -1.481754016152558e-22,  6.874288532326817e-25, -3.118264941397667e-27,  1.666362950736699e-02, -1.448305571918799e-04,
  1.245211299911026e-06, -9.217245452026490e-09,  6.220877555381229e-11, -3.919491789598876e-13,  2.337714155328110e-15, -1.332542980962491e-17,  7.309716519070687e-20,
 -3.878863356107483e-22,  1.999146677036808e-24, -1.003932298766952e-26,  1.030046671968211e-02, -1.162894111440349e-04,  1.178142830701880e-06, -1.009234945554616e-08,
  7.788748048012408e-11, -5.558016191575797e-13,  3.726923712311439e-15, -2.374286834244620e-17,  1.448430724454302e-19, -8.511618759382120e-22,  4.840219726569739e-24,
 -2.673155257318453e-26,  5.878905558356995e-03, -8.434528430478203e-05,  9.967910090719523e-07, -9.809015163623280e-09,  8.591795798275393e-11, -6.895991298553533e-13,
  5.165171822175954e-15, -3.655126733811358e-17,  2.465354473909684e-19, -1.595426267201683e-21,  9.956480116150174e-24, -6.015986524775496e-26,  3.098707863183943e-03,
 -5.539180243077452e-05,  7.582063326247537e-07, -8.516136324186384e-09,  8.414252195524304e-11, -7.553474250338154e-13,  6.286571264434995e-15, -4.917150520407461e-17,
  3.649661006364575e-19, -2.589219250345900e-21,  1.765567124821215e-23, -1.162255366535742e-25,  1.508776392534975e-03, -3.302681045625880e-05,  5.206270069464286e-07,
 -6.636935494188499e-09,  7.359127820125811e-11, -7.354400509781415e-13,  6.771778742225067e-15, -5.830433050788602e-17,  4.743571351879863e-19, -3.675503624290551e-21,
  2.728706263522224e-23, -1.950213250159669e-25,  6.788479372997490e-04, -1.792508267652369e-05,  3.237828659697189e-07, -4.661555049922104e-09,  5.775387658867613e-11,
 -6.399891823080718e-13,  6.495600325831298e-15, -6.134973094819366e-17,  5.453251163409541e-19, -4.600417812221967e-21,  3.707234390052603e-23, -2.868250498583045e-25,
  2.823579165758532e-04, -8.877259186823386e-06,  1.828868406466506e-07, -2.960728883411919e-09,  4.083219106055133e-11, -5.000173429267128e-13,  5.576404925198811e-15,
 -5.760484081100795e-17,  5.578573999965520e-19, -5.110148915879705e-21,  4.458447578504455e-23, -3.724913264052117e-25,  1.086234030361773e-04, -4.020522489243450e-06,
  9.405643500558934e-08, -1.705519047072158e-09,  2.609619142910124e-11, -3.520956066502424e-13,  4.302945685497764e-15, -4.849229441079776e-17,  5.103991310308716e-19,
 -5.065119859986301e-21,  4.773963214836435e-23, -4.297870768261007e-25,  3.867285937064166e-05, -1.668654711558202e-06,  4.414318003485204e-08, -8.934456217719477e-10,
  1.512266793013023e-11, -2.242211511319433e-13,  2.995565423204553e-15, -3.674690685651939e-17,  4.194881030091491e-19, -4.500930967710223e-21,  4.574054238042354e-23,
 -4.429129311124398e-25,  1.275171295289901e-05, -6.358904901986548e-07,  1.894753495125509e-08, -4.266970640025772e-10,  7.968446399787527e-12, -1.295316154087596e-13,
  1.887804652653872e-15, -2.515845590591204e-17,  3.109183016054235e-19, -3.600600320393652e-21,  3.938766026396943e-23, -4.095663003871180e-25,  3.897599908552608e-06,
 -2.229281602497496e-07,  7.453907676841640e-09, -1.862330699185135e-10,  3.827953725710656e-12, -6.807946699585968e-14,  1.080336335441714e-15, -1.561413360586920e-17,
  2.085641197819381e-19, -2.602846580871206e-21,  3.060452493267317e-23, -3.412614107450674e-25,  1.105501826858653e-06, -7.203755706857822e-08,  2.693363788715219e-09,
 -7.445877797622985e-11,  1.680870851871802e-12, -3.264460351199670e-14,  5.630956858788892e-16, -8.812545666135865e-18,  1.270449298944032e-19, -1.706309281613527e-21,
  2.153707520233274e-23, -2.572105980591913e-25,  2.913512956837823e-07, -2.150033874463949e-08,  8.958954801677098e-10, -2.733711770427110e-11,  6.764079164545162e-13,
 -1.432076817652629e-14,  2.681030032543147e-16, -4.537091189530811e-18,  7.050318691102422e-20, -1.017832040432183e-21,  1.377526075655035e-23, -1.760056944840694e-25,
  7.145685355721955e-08, -5.939743295497611e-09,  2.749803432467493e-10, -9.239961936836654e-12,  2.501249308245454e-13, -5.763802047316327e-15,  1.169510624735804e-16,
 -2.137419928655749e-18,  3.575960433589041e-20, -5.543147354735439e-22,  8.035821077084809e-24, -1.097380489247664e-25,  1.633982552766508e-08, -1.522512049285477e-09,
  7.808073674236300e-11, -2.883011853687097e-12,  8.523372602867360e-14, -2.134628825753158e-15,  4.688358757034713e-17, -9.243075227885745e-19,  1.663155810147100e-20,
 -2.765457160221032e-22,  4.290320615006040e-24, -6.256543649478024e-26,  3.491337342638353e-09, -3.630612524476358e-10,  2.056903133889212e-11, -8.328452076768659e-13,
  2.684724933608404e-14, -7.297515814329242e-16,  1.732844640115256e-17, -3.681316922723182e-19,  7.117247495179610e-21, -1.268312302567024e-22,  2.103933200473621e-24,
 -3.273755776711574e-26,  6.989188297852720e-10, -8.078560839014159e-11,  5.042969531902800e-12, -2.234822803715769e-13,  7.842911533846239e-15, -2.310759679455830e-16,
  5.925686159947807e-18, -1.355181145372383e-19,  2.812586130349580e-21, -5.367075046502199e-23,  9.512339837371503e-25, -1.578154317542167e-26,  1.314982923836028e-10,
 -1.683144848983910e-11,  1.154825814303524e-12, -5.590795857071912e-14,  2.132859325587525e-15, -6.803045782162762e-17,  1.882008050578324e-18, -4.628957760895824e-20,
  1.030430155439191e-21, -2.103900395987780e-23,  3.981061598784011e-25, -7.037290322311770e-27,  2.333975122728418e-11, -3.296635833214631e-12,  2.480155301851426e-13,
 -1.309354042467499e-14,  5.422181927588040e-16, -1.870058496829210e-17,  5.575134198486976e-19, -1.473397647798857e-20,  3.514963642271305e-22, -7.673091441662112e-24,
  1.549027045241649e-25, -2.915527214036726e-27,  3.925361266129295e-12, -6.097989851287489e-13,  5.018939912494088e-14, -2.884353707093517e-15,  1.294722747629239e-16,
 -4.822577294233006e-18,  1.547792240109986e-19, -4.391194840363312e-21,  1.121734257293539e-22, -2.616089626431610e-24,  5.630525801198460e-26, -1.127631888622367e-27,
  6.288473983675104e-13, -1.071025038207128e-13,  9.622055984924971e-15, -6.009043672486692e-16,  2.919617037035270e-17, -1.173074770310650e-18,  4.048898159921409e-20,
 -1.231989923877519e-21,  3.367083301092453e-23, -8.382853643617954e-25,  1.922121866156927e-26, -4.093176978946197e-28,  9.655502496322501e-14, -1.797315515735159e-14,
  1.758601598358573e-15, -1.191355344395514e-16,  6.256352220920284e-18, -2.708178699980644e-19,  1.004134589343712e-20, -3.273694977675893e-22,  9.563968861401856e-24,
 -2.539772474751310e-25,  6.199301869932525e-27, -1.402703590432186e-28,  1.431263498142083e-14, -2.902829388187263e-15,  3.086464879911173e-16, -2.264045788828393e-17,
  1.283109527451086e-18, -5.975915204660966e-20,  2.377476882730871e-21, -8.296253168888921e-23,  2.588313167150774e-24, -7.324931983448472e-26,  1.901715250677139e-27,
 -4.568394512354312e-29,  2.065701263707859e-15, -4.550564969911213e-16,  5.245597648729903e-17, -4.158569618991076e-18,  2.539315452736380e-19, -1.270643772365049e-20,
  5.417256739566183e-22, -2.020972862578000e-23,  6.726122227062457e-25, -2.026500411985542e-26,  5.590772940178707e-28, -1.424595232587958e-29,  2.931663450845083e-16,
 -6.992189557600166e-17,  8.717186249802256e-18, -7.453628890711776e-19,  4.895169345296062e-20, -2.627596657587336e-21,  1.198779451696670e-22, -4.774926099756925e-24,
  1.693209103352347e-25, -5.424870513586448e-27,  1.588637778222699e-28, -4.289349001551489e-30,  4.138389278969464e-17, -1.065061056320132e-17,  1.432326308523922e-18,
 -1.317993323733755e-19,  9.291583132589502e-21, -5.340677400652070e-22,  2.603138771592907e-23, -1.105392729313472e-24,  4.170481160827012e-26, -1.418993938746050e-27,
  4.405265422344445e-29, -1.258783106395399e-30,  5.887469081455766e-18, -1.629188350213924e-18,  2.356759965154300e-19, -2.328084213403157e-20,  1.757893776795743e-21,
 -1.079784551177472e-22,  5.612345055131406e-24, -2.536253339705139e-25,  1.016404772372428e-26, -3.666824739797191e-28,  1.204980766406917e-29, -3.638610105233266e-31,
  8.568309187015915e-19, -2.539689974747069e-19,  3.939552375573811e-20, -4.166212957971499e-21,  3.360916290335422e-22, -2.201027290524188e-23,  1.217274796441408e-24,
 -5.842088985964073e-26,  2.481948873470100e-27, -9.476073059768973e-29,  3.290267876584662e-30, -1.048099058775456e-31,  1.297199375096839e-19, -4.101504004928939e-20,
  6.798612392655950e-21, -7.672935425801124e-22,  6.593841118998592e-23, -4.591431075467909e-24,  2.694952876901898e-25, -1.370252320598537e-26,  6.156880990863760e-28,
 -2.482180009637128e-29,  9.086747811337822e-31, -3.047072788661447e-32,  2.081010146065745e-20, -6.987350059827225e-21,  1.232826732015346e-21, -1.479549204624539e-22,
  1.349915902750273e-23, -9.962721717487873e-25,  6.187394015333086e-26, -3.323310543760945e-27,  1.574926332468057e-28, -6.686622068461211e-30,  2.574126603313909e-31,
 -9.063913438009071e-33,  3.608250973338055e-21, -1.280304885214090e-21,  2.393863767617711e-22, -3.042454123380198e-23,  2.935688028984031e-24, -2.287870644915992e-25,
  1.498116102628300e-26, -8.471110343106440e-28,  4.220172492112813e-29, -1.880918898374465e-30,  7.591080557653816e-32, -2.798346778131540e-33,  6.901884962778904e-22,
 -2.574258023413118e-22,  5.075449804367657e-23, -6.799065618916116e-24,  6.907003981501928e-25, -5.659633043912438e-26,  3.891210143473162e-27, -2.307137922886619e-28,
  1.203605952525496e-29, -5.610361621978938e-31,  2.365139186090844e-32, -9.095640244468849e-34,  1.485744180679254e-22, -5.791519595829602e-23,  1.197365000859486e-23,
 -1.681595695904552e-24,  1.789267443207101e-25, -1.533876215353666e-26,  1.102003123549822e-27, -6.819424891936882e-29,  3.708725482414751e-30, -1.800121582939616e-31,
  7.893301117709745e-33, -3.153731317738359e-34,  3.661904097744076e-23, -1.482605109063730e-23,  3.194260841081908e-24, -4.674753596495207e-25,  5.179418414679894e-26,
 -4.619009257802069e-27,  3.448663834366185e-28, -2.215532687853646e-29,  1.249615394657935e-30, -6.284115248001218e-32,  2.852156053112938e-33, -1.178339678177762e-34,
  1.044224549361592e-23, -4.362235359756218e-24,  9.727258811662489e-25, -1.473490318104755e-25,  1.688841328456257e-26, -1.556828437619694e-27,  1.200503923657783e-28,
 -7.958698906207554e-30,  4.628335598258560e-31, -2.397826842562176e-32,  1.120268173193302e-33, -4.760167344100807e-35,  3.426681539833258e-24, -1.466740496815985e-24,
  3.360018011197217e-25, -5.229517747174572e-26,  6.155813266428432e-27, -5.824576736347768e-28,  4.607162992099992e-29, -3.130911441968141e-30,  1.865200776270522e-31,
 -9.892559409157945e-33,  4.728544944677971e-34, -2.054224634196731e-35,  1.232878135889117e-24, -5.367863806461952e-25,  1.253281216372079e-25, -1.988310485947266e-26,
  2.385084606851724e-27, -2.298807186651216e-28,  1.851380812437048e-29, -1.280427775451986e-30,  7.759434757425442e-32, -4.184410372343381e-33,  2.032728355095823e-34,
 -8.970498853472291e-36,  3.838021094384597e-25, -1.687076183138918e-25,  3.981337160087581e-26, -6.384844657470490e-27,  7.740893844514736e-28, -7.538996571553199e-29,
  6.133678967788009e-30, -4.284315308566543e-31,  2.621464365728605e-32, -1.426998637791606e-33,  6.995748040855937e-35, -3.114716254566802e-36,  5.503611955442939e-02,
 -1.245501085647005e-04,  2.906208493577032e-07, -6.963601527837964e-10,  1.703942451084868e-12, -4.237352324326776e-15,  1.064904532149494e-17, -2.698007637700567e-20,
  6.854007751921084e-23, -1.749159678318725e-25,  4.447175336836020e-28, -1.138189672764950e-30,  5.070491929874854e-02, -1.352996981388193e-04,  4.290646607245275e-07,
 -1.442338467446843e-09,  4.866687914513756e-12, -1.620363615614577e-14,  5.305752457346703e-17, -1.710578949272959e-19,  5.438322308275187e-22, -1.708503140796074e-24,
  5.308804111195861e-27, -1.634542497261704e-29,  4.303890197251824e-02, -1.498043375736835e-04,  6.595973380560811e-07, -2.870509112894512e-09,  1.195909978866752e-11,
 -4.799473953254882e-14,  1.869610898787387e-16, -7.107419599429458e-19,  2.646506499853220e-21, -9.678660925945123e-24,  3.483588987643397e-26, -1.236055628045548e-28,
  3.365847988456842e-02, -1.583063297889145e-04,  9.048388518552045e-07, -4.773999341217236e-09,  2.356426785574683e-11, -1.108014197743593e-13,  5.014980832653236e-16,
 -2.199201002243338e-18,  9.387503882744923e-21, -3.914239708813893e-23,  1.598664581697576e-25, -6.409621356696823e-28,  2.425332283198273e-02, -1.537987228257807e-04,
  1.083559666117776e-06, -6.750703736641603e-09,  3.883296706010728e-11, -2.107564864081092e-13,  1.092015357183215e-15, -5.444685444582892e-18,  2.627324501051105e-20,
 -1.232372167021743e-22,  5.638143652236152e-25, -2.522702105904046e-27,  1.610355327564985e-02, -1.352949503560333e-04,  1.140327249462876e-06, -8.281690795210006e-09,
  5.490193452721292e-11, -3.400694358199266e-13,  1.995355635623475e-15, -1.119513375983528e-17,  6.047221074959465e-20, -3.161010105278831e-22,  1.605349536813860e-24,
 -7.946092132396283e-27,  9.853421175254217e-03, -1.073283302066921e-04,  1.064160153136944e-06, -8.930435077520149e-09,  6.761465233144288e-11, -4.738363331862264e-13,
  3.122660261375246e-15, -1.956297733479150e-17,  1.174202526619436e-19, -6.791779061823811e-22,  3.802947508186067e-24, -2.068721419274211e-26,  5.556759255760968e-03,
 -7.681942537153137e-05,  8.868967197420693e-07, -8.538260895727053e-09,  7.328711000979731e-11, -5.770752048682387e-13,  4.244069190073586e-15, -2.950912829830140e-17,
  1.956736260004591e-19, -1.245472049300464e-21,  7.647945617553568e-24, -4.548661613254726e-26,  2.888655589801448e-03, -4.971313664692116e-05,  6.636171798119121e-07,
 -7.282959298526776e-09,  7.043930156880362e-11, -6.197531142971330e-13,  5.060177845239948e-15, -3.885708796984065e-17,  2.833232336695379e-19, -1.975597437198324e-21,
  1.324677187290242e-23, -8.578205175670211e-26,  1.384521630003973e-03, -2.916141361068884e-05,  4.475903116852438e-07, -5.568840744075027e-09,  6.038384197368834e-11,
 -5.909074668478828e-13,  5.333287639552009e-15, -4.504704687049054e-17,  3.597793164669294e-19, -2.738170326359950e-21,  1.997687012019349e-23, -1.403681949674286e-25,
  6.119948151650705e-04, -1.554378585162292e-05,  2.729921075686382e-07, -3.831971467566316e-09,  4.638347287890713e-11, -5.028797639739289e-13,  4.999121943686186e-15,
 -4.628595715583324e-17,  4.036160436863538e-19, -3.342361627712599e-21,  2.645334839888977e-23, -2.011065989715171e-25,  2.495647877690683e-04, -7.545888457592123e-06,
  1.509701121049469e-07, -2.380659137505169e-09,  3.204927990447097e-11, -3.836800667181481e-13,  4.188013337543277e-15, -4.238235171159944e-17,  4.023983142573451e-19,
 -3.616248150406955e-21,  3.097042671566168e-23, -2.541190332060188e-25,  9.392595520828464e-05, -3.343338654357475e-06,  7.588004745008240e-08, -1.339134717481751e-09,
  1.998587430101239e-11, -2.634288886745260e-13,  3.148835644335448e-15, -3.474255211262609e-17,  3.583082049765991e-19, -3.486548104661323e-21,  3.224081627208000e-23,
 -2.849269562622760e-25,  3.264201727854318e-05, -1.354598365437310e-06,  3.473738189032881e-08, -6.837764426194571e-10,  1.128108579848801e-11, -1.632956505133383e-13,
  2.132536373000352e-15, -2.559761422239045e-17,  2.861730452692380e-19, -3.009247496476703e-21,  2.999016025409665e-23, -2.849459733000504e-25,  1.048170166521607e-05,
 -5.028062587732594e-07,  1.451401538437232e-08, -3.176859978448047e-10,  5.779166979792805e-12, -9.166297675160690e-14,  1.305152288883968e-15, -1.701102677083910e-17,
  2.057873497094652e-19, -2.334545758930684e-21,  2.503400702620880e-23, -2.553250281057338e-25,  3.112340270929028e-06, -1.712898974512297e-07,  5.545849533147096e-09,
 -1.346058759393829e-10,  2.693791065444719e-12, -4.672238443143307e-14,  7.240190199421214e-16, -1.022961781918576e-17,  1.336986119755567e-19, -1.633887899233338e-21,
  1.882539482176315e-23, -2.058244895585693e-25,  8.553721253899502e-07, -5.365270578711619e-08,  1.941844320667514e-09, -5.213000711996770e-11,  1.145288259705563e-12,
 -2.168324799364204e-14,  3.650943528659714e-16, -5.583564089989627e-18,  7.873346868119569e-20, -1.035146479881884e-21,  1.279912918213521e-23, -1.498331863259641e-25,
  2.178403095224022e-07, -1.548106701141946e-08,  6.243581341326375e-10, -1.849531311981696e-11,  4.452337700555126e-13, -9.186218595347198e-15,  1.678199483635825e-16,
 -2.774430363493487e-18,  4.215714844562958e-20, -5.956105616243271e-22,  7.894510366255121e-24, -9.884959493065963e-26,  5.148096135565586e-08, -4.123247244170604e-09,
  1.847522123110297e-10, -6.025905125709159e-12,  1.586668910120771e-13, -3.562277178850322e-15,  7.051661760646338e-17, -1.258726645697910e-18,  2.058755891196865e-20,
 -3.122499232623953e-22,  4.432321664725140e-24, -5.930667673769210e-26,  1.130886403620799e-08, -1.015954257412786e-09,  5.043453950051166e-11, -1.807501232552326e-12,
  5.197257472910853e-14, -1.267986210128752e-15,  2.716544684682484e-17, -5.229998631785417e-19,  9.198679565795256e-21, -1.496351586014405e-22,  2.272774058209830e-24,
 -3.247103773085613e-26,  2.313913271288629e-09, -2.321612262258613e-10,  1.273521550013993e-11, -5.005436071277550e-13,  1.569313642777736e-14, -4.155263034752142e-16,
  9.624154493635914e-18, -1.996491521227112e-19,  3.772729190794744e-21, -6.576838631047375e-23,  1.068067085976449e-24, -1.628124012434986e-26,  4.420840862518090e-10,
 -4.934249692259740e-11,  2.983491852511591e-12, -1.283684419767937e-13,  4.382045477198436e-15, -1.257761817509862e-16,  3.146157042251860e-18, -7.026074454136153e-20,
  1.425312195204058e-21, -2.660713019153558e-23,  4.616712502360470e-25, -7.503798410042175e-27,  7.910109979586313e-11, -9.785691881076097e-12,  6.506740077776835e-13,
 -3.059457685285282e-14,  1.135590915347214e-15, -3.529284438235250e-17,  9.525050751817752e-19, -2.288010471627370e-20,  4.978885354437316e-22, -9.945854773809690e-24,
  1.842667477491210e-25, -3.191436972517669e-27,  1.330228239020733e-11, -1.817833528762817e-12,  1.326239581089496e-13, -6.803439324745591e-15,  2.742165171498037e-16,
 -9.217846708033791e-18,  2.681669995223223e-19, -6.923095250855655e-21,  1.614855154932616e-22, -3.449650777826667e-24,  6.819938899987079e-26, -1.257927790503263e-27,
  2.111467713003334e-12, -3.177166986376641e-13,  2.537856619375561e-14, -1.418063135568752e-15,  6.198525034416170e-17, -2.251289233660383e-18,  7.053513157050405e-20,
 -1.955493916492051e-21,  4.885810976944538e-23, -1.115384742022269e-24,  2.351614502687568e-26, -4.616651509398455e-28,  3.179524362261143e-13, -5.251858890220131e-14,
  4.583372684209695e-15, -2.785092064468767e-16,  1.318562959303322e-17, -5.168737672271069e-19,  1.742434350827119e-20, -5.183354252672162e-22,  1.386185352949130e-23,
 -3.379607287534578e-25,  7.594074959035770e-27, -1.585867214800803e-28,  4.569636538378149e-14, -8.260969212621905e-15,  7.860358962199227e-16, -5.185869801065369e-17,
  2.655712413049158e-18, -1.122341081340568e-19,  4.067041531213117e-21, -1.297084462835328e-22,  3.710021448573694e-24, -9.653239175248057e-26,  2.310280498331710e-27,
 -5.128822040426378e-29,  6.313237733144612e-15, -1.245417381508268e-15,  1.289292678804982e-16, -9.220086598192831e-18,  5.100315070424458e-19, -2.321094303979787e-20,
  9.031993881291046e-22, -3.085397849599784e-23,  9.430958075683146e-25, -2.616800443331875e-26,  6.665506417152412e-28, -1.571988956746972e-29,  8.455633712358522e-16,
 -1.814783473102458e-16,  2.039602787883071e-17, -1.578251537270262e-18,  9.416809977703233e-20, -4.608924815223980e-21,  1.923704613420321e-22, -7.031728117930030e-24,
  2.294763497623258e-25, -6.784127341108061e-27,  1.837692352224315e-28, -4.600585772598680e-30,  1.108872499828437e-16, -2.581313483533765e-17,  3.142362142190104e-18,
 -2.626155881345115e-19,  1.687392382585881e-20, -8.869467999352217e-22,  3.965812369385291e-23, -1.549343401117645e-24,  5.392469836635837e-26, -1.696865412946880e-27,
  4.883466371175179e-29, -1.296565432237366e-30,  1.440474490734573e-17, -3.625314208904198e-18,  4.768628438775779e-19, -4.295348174905247e-20,  2.966752576413500e-21,
 -1.672051660311275e-22,  7.997302541777412e-24, -3.334746237158572e-25,  1.236281382839100e-26, -4.135821153859257e-28,  1.263137370941744e-29, -3.552764985989772e-31,
  1.878769032954595e-18, -5.094523265281080e-19,  7.221392539112396e-20, -6.994669436881142e-21,  5.182600750755081e-22, -3.126037353942821e-23,  1.596617909865498e-24,
 -7.094591759442596e-26,  2.797305581015197e-27, -9.934482651008337e-29,  3.215475846179941e-30, -9.568276439965845e-32,  2.498689465548780e-19, -7.273152844623950e-20,
  1.107683936166128e-20, -1.150714360171939e-21,  9.124663645156083e-23, -5.877505420630116e-24,  3.199101848193891e-25, -1.511917772755087e-26,  6.328596867969896e-28,
 -2.381868026996728e-29,  8.156474036213972e-31, -2.563655502970623e-32,  3.448675382996212e-20, -1.073215859707782e-20,  1.750240647173914e-21, -1.944233674537485e-22,
  1.645375831885227e-23, -1.128886395310578e-24,  6.532171530847200e-26, -3.275888823405537e-27,  1.452506376597509e-28, -5.781153275988499e-30,  2.090250066509260e-31,
 -6.925715857438741e-33,  5.037313245664166e-21, -1.668516254305127e-21,  2.902692690172225e-22, -3.435875294475858e-23,  3.093220082927241e-24, -2.253593061079120e-25,
  1.382269480220003e-26, -7.335504307047644e-28,  3.436144397118796e-29, -1.442577847578576e-30,  5.493440462047179e-32, -1.914138673225920e-33,  7.954418015635236e-22,
 -2.790712290790364e-22,  5.156482103967974e-23, -6.477652007749991e-24,  6.180026132882969e-25, -4.763859997975404e-26,  3.086598413654449e-27, -1.727577163593847e-28,
  8.521947983018114e-30, -3.762121039086412e-31,  1.504375260769305e-32, -5.496438161751960e-34,  1.388695009826504e-22, -5.132822714699336e-23,  1.002313033081675e-23,
 -1.330016143467429e-24,  1.338713782810741e-25, -1.087181855798576e-26,  7.410401615131977e-28, -4.357108632831339e-29,  2.254744429384890e-30, -1.042815804484709e-31,
  4.363026852748084e-33, -1.665680495181430e-34,  2.740679022327568e-23, -1.060956079626469e-23,  2.177210384618701e-24, -3.035246353114052e-25,  3.206464362480099e-26,
 -2.729694553964915e-27,  1.947940357190984e-28, -1.197581362092728e-29,  6.472008619750987e-31, -3.122214494082436e-32,  1.360980678515712e-33, -5.406779128432819e-35,
  6.237338651647868e-24, -2.512782004639792e-24,  5.384570277979717e-25, -7.837970695791554e-26,  8.638617662859254e-27, -7.664717651289058e-28,  5.694438727747081e-29,
 -3.640821373970473e-30,  2.044022110053705e-31, -1.023307442530602e-32,  4.624347769632637e-34, -1.902512752398383e-35,  1.658885839400888e-24, -6.907238932509903e-25,
  1.534688358344070e-25, -2.316405084763680e-26,  2.645615947121369e-27, -2.430476908848739e-28,  1.867977826453531e-29, -1.234389991176615e-30,  7.156181578665441e-32,
 -3.696266764976322e-33,  1.721860060133578e-34, -7.295778194241274e-36,  5.143176887713173e-25, -2.197251480359288e-25,  5.022823318238953e-26, -7.800931034082817e-27,
  9.163605490065763e-28, -8.652963207963656e-29,  6.830913524013334e-30, -4.633255172158913e-31,  2.755094063842682e-32, -1.458611034856797e-33,  6.959886790949953e-35,
 -3.018502243325346e-36,  1.775652504772725e-25, -7.723936684106630e-26,  1.801517590070261e-26, -2.855120175258560e-27,  3.421380229517371e-28, -3.294334026367976e-29,
  2.650571784201634e-30, -1.831424754378651e-31,  1.108831743836311e-32, -5.974238765791013e-34,  2.899687998525486e-35, -1.278567753820261e-36,  5.398414414432277e-26,
 -2.372132570740280e-26,  5.595755383059263e-27, -8.970220710968143e-28,  1.087097204253670e-28, -1.058322454628576e-29,  8.607081450679048e-31, -6.009662616781989e-32,
  3.675782889947713e-33, -2.000184660186298e-34,  9.802225609731081e-36, -4.362714234069692e-37,  5.454251677632305e-02, -1.222581099366400e-04,  2.824253536374032e-07,
 -6.697614160479435e-10,  1.621691241288143e-12, -3.990598399393852e-15,  9.923386414047457e-18, -2.488420785666597e-20,  6.255158975844758e-23, -1.580896049151719e-25,
  3.975409431792771e-28, -1.009044753174292e-30,  5.017047775993394e-02, -1.319351135483151e-04,  4.122133265041301e-07, -1.366996449392880e-09,  4.554970965180452e-12,
 -1.498581992217784e-14,  4.850257818704651e-17, -1.545997430966174e-19,  4.859813428999834e-22, -1.509857630179784e-24,  4.639598759138288e-27, -1.413022185444018e-29,
  4.245002451900779e-02, -1.446621618324883e-04,  6.262683973944438e-07, -2.686605475462924e-09,  1.104251182272237e-11, -4.373722549929865e-14,  1.681954265032674e-16,
 -6.313700106242328e-19,  2.321899534105019e-21, -8.388150117147679e-24,  2.982814012590261e-26, -1.045806598192833e-28,  3.303937799495345e-02, -1.512905257325801e-04,
  8.497419630946073e-07, -4.414065671120718e-09,  2.146378127726791e-11, -9.947171133449013e-14,  4.439227080226940e-16, -1.920165829113973e-18,  8.086996792835950e-21,
 -3.327782904108931e-23,  1.341618065904977e-25, -5.310664858437638e-28,  2.365496634270513e-02, -1.454440280580357e-04,  1.006144561883560e-06, -6.161723488665337e-09,
  3.486804661972681e-11, -1.862864770449928e-13,  9.506974379725055e-16, -4.670781704891096e-18,  2.221726117803528e-20, -1.027567697555741e-22,  4.636722134676247e-25,
 -2.046667366486840e-27,  1.558000972322815e-02, -1.265554207068021e-04,  1.046001246166798e-06, -7.455171782789357e-09,  4.855512764595535e-11, -2.957338860418218e-13,
  1.707357253508428e-15, -9.430356614583422e-18,  5.016887042441554e-20, -2.583687731912530e-22,  1.293166734605151e-24, -6.309977079468550e-27,  9.440480750503662e-03,
 -9.922601335050625e-05,  9.631859058730707e-07, -7.920521384561193e-09,  5.884509746301491e-11, -4.050626406282317e-13,  2.624024898135950e-15, -1.616906884348132e-17,
  9.550196502874951e-20, -5.438154742392980e-22,  2.998763101903670e-24, -1.606992867230064e-26,  5.263050023405759e-03, -7.011499658602456e-05,  7.911094708024437e-07,
 -7.452733609871846e-09,  6.270074414489290e-11, -4.844644670590683e-13,  3.499134201928570e-15, -2.390962532579534e-17,  1.558927001404570e-19, -9.761275350256285e-22,
  5.898898675999671e-24, -3.453956197258327e-26,  2.699893271739365e-03, -4.473552268413488e-05,  5.825952101691760e-07, -6.248844794507701e-09,  5.917558271761610e-11,
 -5.104025655645178e-13,  4.089104733114262e-15, -3.083337496717533e-17,  2.208947629877756e-19, -1.514180436104973e-21,  9.985235763153045e-24, -6.361856238053584e-26,
  1.274636246297815e-03, -2.583242610157802e-05,  3.861924826044789e-07, -4.690696416795397e-09,  4.974987117322356e-11, -4.768292628727135e-13,  4.219365804853076e-15,
 -3.496839336045772e-17,  2.742146116566640e-19, -2.050236258937257e-21,  1.470181506784424e-23, -1.015776795248124e-25,  5.539131699352927e-04, -1.353189142732628e-05,
  2.311493352513768e-07, -3.164193548804345e-09,  3.742778657157254e-11, -3.970977289534917e-13,  3.867207815003000e-15, -3.510736102234689e-17,  3.003811281154607e-19,
 -2.442172038878281e-21,  1.898672439718902e-23, -1.418546359160977e-25,  2.216274060391607e-04, -6.444231410015454e-06,  1.252423520186582e-07, -1.924177062570776e-09,
  2.529171763569154e-11, -2.960653991148901e-13,  3.163596599442356e-15, -3.136975698232266e-17,  2.920559207098537e-19, -2.575331746813149e-21,  2.165365482190699e-23,
 -1.745203147994914e-25,  8.167208548490496e-05, -2.795515870666446e-06,  6.156766170529513e-08, -1.057712110647257e-09,  1.540045544712213e-11, -1.983423375994840e-13,
  2.319338999213770e-15, -2.505866162649103e-17,  2.532702939136215e-19, -2.416865511822081e-21,  2.193062714081732e-23, -1.902812959594887e-25,  2.773148097818706e-05,
 -1.106683405214504e-06,  2.751565784935942e-08, -5.268518237382132e-10,  8.473877658516542e-12, -1.197731654223550e-13,  1.529241345698378e-15, -1.796437184705861e-17,
  1.967163354316842e-19, -2.027598126606071e-21,  1.981926993126637e-23, -1.847984568744531e-25,  8.680605257110029e-06, -4.005001535456999e-07,  1.120118653477830e-08,
 -2.383329718839181e-10,  4.224102722078172e-12, -6.538215418845684e-14,  9.096619344245543e-16, -1.159730228451540e-17,  1.373515637618036e-19, -1.526625375529793e-21,
  1.604947068406123e-23, -1.605749437070565e-25,  2.506632187788730e-06, -1.327168066345071e-07,  4.161157869949446e-09, -9.812601595351336e-11,  1.912192696731728e-12,
 -3.234918639439222e-14,  4.895859106735817e-16, -6.763100177462403e-18,  8.649960933716888e-20, -1.035258640838295e-21,  1.168977931860370e-23, -1.253312397679768e-25,
  6.682688658882097e-07, -4.033878314559364e-08,  1.413329316774270e-09, -3.684707371037607e-11,  7.879195830242240e-13, -1.454355637089031e-14,  2.390611100397409e-16,
 -3.573136687442034e-18,  4.928734241083277e-20, -6.344016791109235e-22,  7.684850226218697e-24, -8.819205549204211e-26,  1.646543317950078e-07, -1.126553547661282e-08,
  4.397367059521533e-10, -1.264643445612573e-11,  2.962048431211685e-13, -5.956135307947744e-15,  1.061885761397003e-16, -1.715134191063812e-18,  2.548572752316442e-20,
 -3.524086550249118e-22,  4.574903482527318e-24, -5.614182321718581e-26,  3.754051425636278e-08, -2.896187322668003e-09,  1.255903459485363e-10, -3.976011218953767e-12,
  1.018352878580921e-13, -2.227644798202169e-15,  4.302284460768016e-17, -7.500944347380186e-19,  1.199452939922638e-20, -1.780072458855689e-22,  2.474254861224774e-24,
 -3.244023106294285e-26,  7.932308392715153e-09, -6.868211462346126e-10,  3.299947649831239e-11, -1.147832709242538e-12,  3.209925716219472e-14, -7.628940978185194e-16,
  1.594319531638869e-17, -2.997485898222102e-19,  5.153451297876554e-21, -8.201455129107063e-23,  1.219618337296624e-24, -1.707140750262049e-26,  1.556276235285520e-09,
 -1.505956549746410e-10,  7.996980161763555e-12, -3.050683322732260e-13,  9.301795936822085e-15, -2.399108104637345e-16,  5.419771082642013e-18, -1.097839888568461e-19,
  2.027687561259600e-21, -3.457850557430257e-23,  5.497437732171566e-25, -8.209587851417430e-27,  2.841545495420746e-10, -3.061183658219613e-11,  1.792397162718578e-12,
 -7.486367120542714e-14,  2.485545965789458e-15, -6.949409434766160e-17,  1.695496219889150e-18, -3.697235949403755e-20,  7.330629824134380e-22, -1.338647311652075e-23,
  2.273884750621486e-25, -3.620648519801367e-27,  4.841825614305891e-11, -5.786497460762676e-12,  3.727604014909193e-13, -1.701912523435888e-14,  6.145092519434944e-16,
 -1.860612286435924e-17,  4.898328001526967e-19, -1.149008039897956e-20,  2.443972432635196e-22, -4.776100882337208e-24,  8.663150588322748e-26, -1.469995455631487e-27,
  7.725205103003433e-12, -1.020848413870478e-12,  7.219876611215102e-14, -3.597846958814336e-15,  1.411097968936805e-16, -4.622369060486065e-18,  1.312030385240664e-19,
 -3.308299310609113e-21,  7.544177949450913e-23, -1.576853668487363e-24,  3.052549789676018e-26, -5.517049377723945e-28,  1.158829625764579e-12, -1.688005879380812e-13,
  1.308034566913908e-14, -7.103838160464428e-16,  3.022926949576067e-17, -1.070298543383627e-18,  3.272846740118493e-20, -8.864870666577909e-22,  2.165943792880353e-23,
 -4.839356943344098e-25,  9.993220387340811e-27, -1.922841670629259e-28,  1.642327311997976e-13, -2.629286706614443e-14,  2.227957102243982e-15, -1.316761310128002e-16,
  6.072427458164262e-18, -2.321669015384861e-19,  7.642166614291471e-21, -2.222023128568849e-22,  5.813316433777762e-24, -1.387660845693277e-25,  3.055091384095093e-27,
 -6.255256762604207e-29,  2.211962598687195e-14, -3.880961765469363e-15,  3.589130525670056e-16, -2.305043000988201e-17,  1.150661213909275e-18, -4.745984882990295e-20,
  1.680274916399930e-21, -5.240651536995297e-23,  1.467176260474937e-24, -3.739440833661322e-26,  8.772747631479249e-28, -1.910367023184495e-29,  2.851165053015140e-15,
 -5.466905031592542e-16,  5.507113937111474e-17, -3.837512270614980e-18,  2.071103968409702e-19, -9.206141540128435e-21,  3.502568893003659e-22, -1.170918928318540e-23,
  3.505431756902357e-25, -9.533501864269146e-27,  2.381828389949665e-28, -5.513221187968060e-30,  3.546732849942072e-16, -7.410869916416310e-17,  8.115426336835415e-18,
 -6.126120381487641e-19,  3.569878562834729e-20, -1.708211580133154e-21,  6.977214153190255e-23, -2.497922363128966e-24,  7.990373705444103e-26, -2.317109508227652e-27,
  6.160780054666382e-29, -1.514815253159589e-30,  4.300423736327896e-17, -9.763393651326362e-18,  1.159799586606969e-18, -9.468125493728303e-20,  5.948696905551296e-21,
 -3.060402830766490e-22,  1.340500116909483e-23, -5.134317213415572e-25,  1.753240998258206e-26, -5.416442348514561e-28,  1.531370028470867e-29, -3.996620945731441e-31,
  5.142388502600488e-18, -1.264637175012688e-18,  1.625909984679137e-19, -1.432731081947608e-20,  9.689587501079329e-22, -5.351854257520358e-23,  2.510583747464818e-24,
 -1.027520211945395e-25,  3.741426846091535e-27, -1.230123367777033e-28,  3.694538466702719e-30, -1.022459273333048e-31,  6.148383937123058e-19, -1.632458332227065e-19,
  2.265835225967445e-20, -2.150589733974594e-21,  1.562661800052705e-22, -9.250613975537035e-24,  4.640328611778137e-25, -2.026458380632868e-26,  7.857494807281411e-28,
 -2.745848831415813e-29,  8.749852079824091e-31, -2.564744824876179e-32,  7.468536372193464e-20, -2.133243622158966e-20,  3.187538111050728e-21, -3.250727940013795e-22,
  2.532200059926587e-23, -1.603369312291603e-24,  8.584308701718177e-26, -3.993036114320401e-27,  1.645982868497417e-28, -6.103912928884223e-30,  2.060544283347292e-31,
 -6.387639022022106e-33,  9.387433973775865e-21, -2.873185009237283e-21,  4.606905783967160e-22, -5.033724117388749e-23,  4.192588866021384e-24, -2.832658002483926e-25,
  1.614990788439418e-26, -7.984356639122657e-28,  3.491758694112874e-29, -1.371389877581916e-30,  4.895064391827576e-32, -1.601880836442498e-33,  1.246458472448888e-21,
 -4.070128899340012e-22,  6.977121779275158e-23, -8.140537966506126e-24,  7.227174685567028e-25, -5.195001649234322e-26,  3.145295359377065e-27, -1.648370380225682e-28,
  7.628520859715896e-30, -3.165415098218510e-31,  1.191866088544484e-32, -4.107873973726496e-34,  1.788702921496251e-22, -6.201129057902559e-23,  1.131622809232200e-23,
 -1.404290647732522e-24,  1.323976621442135e-25, -1.008953882506965e-26,  6.465251333646188e-28, -3.580146862992501e-29,  1.747907932917077e-30, -7.639757850509890e-32,
  3.025616280871167e-33, -1.095203094739417e-34,  2.842531029429834e-23, -1.040621908071250e-23,  2.011577451954146e-24, -2.642710649175178e-25,  2.634273914674779e-26,
 -2.119292649804817e-27,  1.431470090654957e-28, -8.343029996857734e-30,  4.280908327778093e-31, -1.963732730621005e-32,  8.151103830456660e-34, -3.088115443744129e-35,
  5.127381263316482e-24, -1.970342230774232e-24,  4.011665249401950e-25, -5.549239103753398e-26,  5.817932872113609e-27, -4.916549395497856e-28,  3.483612426462346e-29,
 -2.127008774644194e-30,  1.141859334147295e-31, -5.473196497763970e-33,  2.370973672119897e-34, -9.362758338972703e-36,  1.073941138100465e-24, -4.303623559449076e-25,
  9.169307197714459e-26, -1.327123490304790e-26,  1.454566005318602e-27, -1.283624620741959e-28,  9.486796557991823e-30, -6.034877599853617e-31,  3.371529512757582e-32,
 -1.679922644599346e-33,  7.556876858240670e-35, -3.095260940344619e-36,  2.655243715183284e-25, -1.101718533801992e-25,  2.438483539548104e-26, -3.666506353198145e-27,
  4.171954273404907e-28, -3.818781019802138e-29,  2.924649049227575e-30, -1.926067909582811e-31,  1.112923128522556e-32, -5.730042089910026e-34,  2.661016478560613e-35,
 -1.124146401766339e-36,  7.754863778152694e-26, -3.306250705180050e-26,  7.540906992822806e-27, -1.168533496334028e-27,  1.369618438394723e-28, -1.290511914302306e-29,
  1.016640053304920e-30, -6.881664782667606e-32,  4.084038295425414e-33, -2.158069750924924e-34,  1.027842272455409e-35, -4.449806282337424e-37,  2.563192194068703e-26,
 -1.113873441196302e-26,  2.595138097799488e-27, -4.108363111922245e-28,  4.917859645553036e-29, -4.730247465256949e-30,  3.801976089347597e-31, -2.624368816130913e-32,
  1.587375686356851e-33, -8.544506593314887e-35,  4.143408518477450e-36, -1.825344234639806e-37,  7.599940818741995e-27, -3.338264488748048e-27,  7.871501028459583e-28,
 -1.261294589583167e-28,  1.527910685116111e-29, -1.486848563121705e-30,  1.208724236124858e-31, -8.436214908868112e-33,  5.157952017102661e-34, -2.805634481578984e-35,
  1.374430659254915e-36, -6.114993946779043e-38,  5.405795285520384e-02, -1.200304205382919e-04,  2.745413064877954e-07, -6.444401447299405e-10,  1.544205595697825e-12,
 -3.760577183827854e-15,  9.253817513242026e-18, -2.297063234497606e-20,  5.713620840855455e-23, -1.430415642965394e-25,  3.556840074669119e-28, -8.960259499315115e-31,
  4.964923054682072e-02, -1.287018061884636e-04,  3.962369566110957e-07, -1.296452838579999e-09,  4.266553426746931e-12, -1.387199522363114e-14,  4.438358216545560e-17,
 -1.398833814234005e-19,  4.348224562038567e-22, -1.336128949505597e-24,  4.060634845758511e-27, -1.223477096414291e-29,  4.188119613845447e-02, -1.397780332378100e-04,
  5.950610406453149e-07, -2.516709778626351e-09,  1.020674450481522e-11, -3.990455060604117e-14,  1.515134716030177e-16, -5.616792305071103e-19,  2.040338337101498e-21,
 -7.282163149083289e-24,  2.558712296698386e-26, -8.865716151359160e-29,  3.244748434182172e-02, -1.446987745562838e-04,  7.987698731327279e-07, -4.085999536979281e-09,
  1.957668012813909e-11, -8.943457050438896e-14,  3.936080676404359e-16, -1.679558248188566e-18,  6.980215506757960e-21, -2.835089671076417e-23,  1.128400174775268e-25,
 -4.410469206898731e-28,  2.308883327837328e-02, -1.376814254979169e-04,  9.354321610561643e-07, -5.632443932645071e-09,  3.136029227489971e-11, -1.649620779213157e-13,
  8.293372995113081e-16, -4.015606630639733e-18,  1.883124824086379e-20, -8.589250544371733e-23,  3.823181682325984e-25, -1.665053357208367e-27,  1.508997553749523e-02,
 -1.185324874719307e-04,  9.610122668606689e-07, -6.723467388235525e-09,  4.302972996060477e-11, -2.577527515912261e-13,  1.464452781549622e-15, -7.964308578495723e-18,
  4.173544998670124e-20, -2.117945784167824e-22,  1.044879583899092e-24, -5.026812943933893e-27,  9.058407523843187e-03, -9.188529946770742e-05,  8.735321150300098e-07,
 -7.040536059548143e-09,  5.133865006349251e-11, -3.471908098753349e-13,  2.211290098124234e-15, -1.340440844156147e-17,  7.792354775060355e-20, -4.368960821054290e-22,
  2.372965573838763e-24, -1.252909899104637e-26,  4.994704523071381e-03, -6.412750526206812e-05,  7.073903743170565e-07, -6.522691025570369e-09,  5.379980121952303e-11,
 -4.079860847344195e-13,  2.894530060840024e-15, -1.944058325365369e-17,  1.246569236111537e-19, -7.679801484682725e-22,  4.568133604466579e-24, -2.633661949142783e-26,
  2.529819534667149e-03, -4.035935236452768e-05,  5.129695664621426e-07, -5.378647471162114e-09,  4.988291041110016e-11, -4.218730518792283e-13,  3.317055776904875e-15,
 -2.456498464430622e-17,  1.729465122151675e-19, -1.165614756796338e-21,  7.560958490919167e-24, -4.740354636563520e-26,  1.177147320166896e-03, -2.295519832101170e-05,
  3.343823600407518e-07, -3.965805002082333e-09,  4.115147462278916e-11, -3.863866512676928e-13,  3.352764294198299e-15, -2.726916405201558e-17,  2.099959078906385e-19,
 -1.542725578668779e-21,  1.087497114015440e-23, -7.389430686973932e-26,  5.032571307045536e-04, -1.182497008668460e-05,  1.965254624197043e-07, -2.624157432992232e-09,
  3.033962532459714e-11, -3.150709195516931e-13,  3.006533760555541e-15, -2.676667402621079e-17,  2.247515065011052e-19, -1.794319171664021e-21,  1.370540109845234e-23,
 -1.006472281909111e-25,  1.977172713208412e-04, -5.528198372221760e-06,  1.043974194964256e-07, -1.563035395616208e-09,  2.006364127269707e-11, -2.297032859638754e-13,
  2.403256893686483e-15, -2.335414048395640e-17,  2.132451708122756e-19, -1.845375157250626e-21,  1.523567856107708e-23, -1.206336508671559e-25,  7.140025814951012e-05,
 -2.349838786223738e-06,  5.023183675098915e-08, -8.402382343745330e-10,  1.193782977732756e-11, -1.502568102133823e-13,  1.719199893506430e-15, -1.819194919403314e-17,
  1.802231861201220e-19, -1.686858291435383e-21,  1.502217102257349e-23, -1.279852047567869e-25,  2.370798643124204e-05, -9.097120346510943e-07,  2.193389918180901e-08,
 -4.085983932055630e-10,  6.408097829581140e-12, -8.845842106961019e-14,  1.104399648717807e-15, -1.269895036178891e-17,  1.362274938755540e-19, -1.376527390795533e-21,
  1.319893922871863e-23, -1.207917983588748e-25,  7.241210431497432e-06, -3.212738761732648e-07,  8.707113428669104e-09, -1.801243540252908e-10,  3.110842251052707e-12,
 -4.699696964470398e-14,  6.390181436799608e-16, -7.970107436640992e-18,  9.242575878349749e-20, -1.006625940847587e-21,  1.037660082554061e-23, -1.018549623197994e-25,
  2.035560224809272e-06, -1.036627972556918e-07,  3.147770447696489e-09, -7.212755133090094e-11,  1.368852192805878e-12, -2.259020236030164e-14,  3.339539844196306e-16,
 -4.510967660264533e-18,  5.646710535731625e-20, -6.619482930277116e-22,  7.326041528258134e-24, -7.703222910378232e-26,  5.270024004195762e-07, -3.060673163998811e-08,
  1.038129983077619e-09, -2.628665436395164e-11,  5.471579405901551e-13, -9.847596224953905e-15,  1.580433401919516e-16, -2.308876080549068e-18,  3.115820234931226e-20,
 -3.926759445866241e-22,  4.660607886794283e-24, -5.243797257778989e-26,  1.257696965782255e-07, -8.282331477972267e-09,  3.128917215631379e-10, -8.736477403783762e-12,
  1.991082445580586e-13, -3.902308162624778e-15,  6.790150558987251e-17, -1.071589181852717e-18,  1.557280515015072e-20, -2.107714785194153e-22,  2.680128519042766e-24,
 -3.223661488359604e-26,  2.769809359703399e-08, -2.057667953468182e-09,  8.634809593794144e-11, -2.653398209702723e-12,  6.610796881294489e-14, -1.409057684379111e-15,
  2.655191841668989e-17, -4.521845048679036e-19,  7.069737630789754e-21, -1.026693980354127e-22,  1.397498033220063e-24, -1.795488001529390e-26,  5.636731781844176e-09,
 -4.702277523057533e-10,  2.186378655309429e-11, -7.380679670710039e-13,  2.007376138432236e-14, -4.647627051188401e-16,  9.474590463234686e-18, -1.739607695420210e-19,
  2.923633274082390e-21, -4.552125291889743e-23,  6.627834625026838e-25, -9.089417900730172e-27,  1.061803308792759e-09, -9.905645331422558e-11,  5.091117029836851e-12,
 -1.884845440976117e-13,  5.588848240758221e-15, -1.404059373650018e-16,  3.093685013802120e-18, -6.119046709239261e-20,  1.104634318903288e-21, -1.842755108072034e-23,
  2.868107954143264e-25, -4.195944929825046e-27,  1.855272752956270e-10, -1.928288562915756e-11,  1.093082964953056e-12, -4.431249291953285e-14,  1.430745733252785e-15,
 -3.896361436841311e-17,  9.271482942245556e-19, -1.974044270026515e-20,  3.825345978357318e-22, -6.833097355363280e-24,  1.136250390360493e-25, -1.772348157113838e-27,
  3.014629876652725e-11, -3.478802092573598e-12,  2.170481845548278e-13, -9.620523412622612e-15,  3.378582450964179e-16, -9.964825438916060e-18,  2.558747473760869e-19,
 -5.860680105302792e-21,  1.218388580893475e-22, -2.329157805756643e-24,  4.135898175301628e-26, -6.875168585062125e-28,  4.569709075276501e-12, -5.836260574108763e-13,
  3.999902535709980e-14, -1.935765020317139e-15,  7.386247734237230e-17, -2.357358973978965e-18,  6.527425842946034e-20, -1.607348203807207e-21,  3.582925529636965e-23,
 -7.326662495604691e-25,  1.388665885351921e-26, -2.459049349396000e-28,  6.486910465377146e-13, -9.142028022497348e-14,  6.869529670104911e-15, -3.624976289018439e-16,
  1.501290614924734e-17, -5.180553830837652e-19,  1.545806569124859e-20, -4.089950943092576e-22,  9.770450756861677e-24, -2.136189613570930e-25,  4.319866450132252e-27,
 -8.145633445826446e-29,  8.663810631153476e-14, -1.343526236853812e-14,  1.104863306549825e-15, -6.348756583082262e-17,  2.850996383134059e-18, -1.062833487426213e-19,
  3.415189835370077e-21, -9.703390746741187e-23,  2.482964649248633e-24, -5.801724262073980e-26,  1.251260776221055e-27, -2.511419458543179e-29,  1.094861534582370e-14,
 -1.863139967513186e-15,  1.673814094896134e-16, -1.045964869281581e-17,  5.087787538716267e-19, -2.047365993266149e-20,  7.079720196949681e-22, -2.158805192375801e-23,
  5.914050462494205e-25, -1.476147737893400e-26,  3.393865052865749e-28, -7.247815047343789e-30,  1.318130525387276e-15, -2.454870737916957e-16,  2.404962311483980e-17,
 -1.632158118586783e-18,  8.590436032121267e-20, -3.728208981623175e-21,  1.386344866782420e-22, -4.533977763635766e-24,  1.329012030521897e-25, -3.541674107117623e-27,
  8.676433286092921e-29, -1.970604091426035e-30,  1.524341626861239e-16, -3.098589910548348e-17,  3.304140785488275e-18, -2.431870051168784e-19,  1.383365602428862e-20,
 -6.468814840364184e-22,  2.584573164136828e-23, -9.059270188370207e-25,  2.839475357505041e-26, -8.074097330660968e-28,  2.106462642086337e-29, -5.085432064376595e-31,
  1.710084899400746e-17, -3.783591109828369e-18,  4.382948903995287e-19, -3.493082175189289e-20,  2.144850348108233e-21, -1.079482978604894e-22,  4.629773519567994e-24,
 -1.737763220433164e-25,  5.819609229963025e-27, -1.764467955114888e-28,  4.899001647332149e-30, -1.256366745611019e-31,  1.883114866656210e-18, -4.521653291220336e-19,
  5.678192671660898e-20, -4.891815056507266e-21,  3.237570461486093e-22, -1.751532125832368e-23,  8.054705643066885e-25, -3.234142919556574e-26,  1.156131009872864e-27,
 -3.734253055507409e-29,  1.102464878994057e-30, -3.000922614578028e-32,  2.064029514781138e-19, -5.361715875108315e-20,  7.281980173840936e-21, -6.768284058343631e-22,
  4.820042772657588e-23, -2.798796400216795e-24,  1.378134403192542e-25, -5.911896145311451e-27,  2.253212730162186e-28, -7.744385656553304e-30,  2.428561603657158e-31,
 -7.009216766291133e-33,  2.289007171427398e-20, -6.410717131447691e-21,  9.391418819597332e-22, -9.395958279505451e-23,  7.185502382619545e-24, -4.469916642976766e-25,
  2.352717692901044e-26, -1.076564888939021e-27,  4.368085123929445e-29, -1.595302246690553e-30,  5.306530493490387e-32, -1.621749442186577e-33,  2.617743891454451e-21,
 -7.874043952012099e-22,  1.240426819609772e-22, -1.332272433859692e-23,  1.091420632390940e-24, -7.257320840219437e-26,  4.074554275551691e-27, -1.984814315280815e-28,
  8.557013375717647e-30, -3.314757887642785e-31,  1.167520904447359e-32, -3.771828085536977e-34,  3.154950566336832e-22, -1.014879658239024e-22,  1.713112594589729e-23,
 -1.968907437564051e-24,  1.722742198995741e-25, -1.221072422545381e-26,  7.293565572088198e-28, -3.772811127950431e-29,  1.724173092307417e-30, -7.067883678924686e-32,
  2.630160905872659e-33, -8.962834552076555e-35,  4.105797790835569e-23, -1.405653589848252e-23,  2.531802404535091e-24, -3.101825045321975e-25,  2.888319320049688e-26,
 -2.174827058899127e-27,  1.377556049214073e-28, -7.543462045330872e-30,  3.643360887201493e-31, -1.575929287807445e-32,  6.178689342094090e-34, -2.214905401704911e-35,
  5.923553641836379e-24, -2.146685147149155e-24,  4.105523325026554e-25, -5.337155085971731e-26,  5.266004913935727e-27, -4.194852162195713e-28,  2.806462992240827e-29,
 -1.620668816624267e-30,  8.242074754918809e-32, -3.748383182645899e-33,  1.542992916873307e-34, -5.799005866298279e-36,  9.735511474540731e-25, -3.712064364469065e-25,
  7.495107890503063e-26, -1.028270845329698e-26,  1.069447021334108e-27, -8.967612782265639e-29,  6.306432124303127e-30, -3.822700779017718e-31,  2.037825253684051e-32,
 -9.701765643085268e-34,  4.175319773233094e-35, -1.638400622374897e-36,  1.870295676914642e-25, -7.452698723733335e-26,  1.578215759952382e-26, -2.270449159249486e-27,
  2.473827374840178e-28, -2.170634592310413e-29,  1.595368380280367e-30, -1.009443191688151e-31,  5.610346070705476e-33, -2.781479361954343e-34,  1.245158229026488e-35,
 -5.076320461836272e-37,  4.284052837353612e-26, -1.770913768497725e-26,  3.903655496082094e-27, -5.845690440422081e-28,  6.625135365983232e-29, -6.040898333074142e-30,
  4.609187464418439e-31, -3.024463371508425e-32,  1.741482926977354e-33, -8.935911016667167e-35,  4.136218539298938e-36, -1.741820602072460e-37,  1.174972754088582e-26,
 -4.998533942734941e-27,  1.137326362699808e-27, -1.758156556401302e-28,  2.055853937663295e-29, -1.932674532892387e-30,  1.519139381739101e-31, -1.026094878430106e-32,
  6.076826678825828e-34, -3.204602883980543e-35,  1.523297263947889e-36, -6.582301730046003e-38,  3.708949846052640e-27, -1.610096912032037e-27,  3.746892448895248e-28,
 -5.924777272981031e-29,  7.084032186816778e-30, -6.806150235570255e-31,  5.464538726334836e-32, -3.767982564288800e-33,  2.276758374575097e-34, -1.224307293577538e-35,
  5.931166173206703e-37, -2.610474382581073e-38,  1.070922787491053e-27, -4.702169957780856e-28,  1.108263722742853e-28, -1.775037741991526e-29,  2.149296514197737e-30,
 -2.090622471061379e-31,  1.698831630178464e-32, -1.185192459926210e-33,  7.243369203589746e-35, -3.938405258756225e-36,  1.928599162132933e-37, -8.577273159403713e-39,
  5.358217544203968e-02, -1.178646088281643e-04,  2.669538250067117e-07, -6.203226955935042e-10,  1.471163918752055e-12, -3.546001753287012e-15,  8.635481827168724e-18,
 -2.122199503302664e-20,  5.223357870095511e-23, -1.295726312347271e-25,  3.184828896019524e-28, -7.971093562585667e-31,  4.914066619397969e-02, -1.255930004852081e-04,
  3.810801400647367e-07, -1.230350930757057e-09,  3.999456267843773e-12, -1.285226109955680e-14,  4.065463436293820e-17, -1.267083479083744e-19,  3.895202856060902e-22,
 -1.183973840751697e-24,  3.558947391833582e-27, -1.061030575773580e-29,  4.133141755321676e-02, -1.351356301448297e-04,  5.658146594662650e-07, -2.359594238563659e-09,
  9.443779964431143e-12, -3.644980900152277e-14,  1.366624790060968e-16, -5.003927784593756e-19,  1.795700724006897e-21, -6.332595316086823e-24,  2.198848728861712e-26,
 -7.530215286971701e-29,  3.188116636792613e-02, -1.384995513754811e-04,  7.515598331439567e-07, -3.786584468358161e-09,  1.787877197102037e-11, -8.052798082671710e-14,
  3.495601358900876e-16, -1.471686915416700e-18,  6.036360824704066e-21, -2.420260375427072e-23,  9.511265992205773e-26, -3.671277286810944e-28,  2.255265814561291e-02,
 -1.304600394198906e-04,  8.707479484894879e-07, -5.156028771946562e-09,  2.825132443983194e-11, -1.463418878132068e-13,  7.248921042239269e-16, -3.459666782921641e-18,
  1.599760621984541e-20, -7.196986679760932e-23,  3.160465228734149e-25, -1.358253405835361e-27,  1.463072682241800e-02, -1.111557914281725e-04,  8.842973804877228e-07,
 -6.074395695245118e-09,  3.820883161735486e-11, -2.251377442238931e-13,  1.259058489888675e-15, -6.743114824826038e-18,  3.481275216287930e-20, -1.741082431945235e-22,
  8.467840822031578e-25, -4.017124254724100e-27,  8.704326800193734e-03, -8.522153377507408e-05,  7.937540504107687e-07, -6.271907386290970e-09,  4.489653915807239e-11,
 -2.983558608897398e-13,  1.868636549812919e-15, -1.114521391765531e-17,  6.377883644084653e-20, -3.521490629005852e-22,  1.884214456125265e-24, -9.803492548052680e-27,
  4.749036894821799e-03, -5.876743439422012e-05,  6.340253317503342e-07, -5.723574792298689e-09,  4.629290109775368e-11, -3.446229789677395e-13,  2.402122612784348e-15,
 -1.586079997823621e-17,  1.000373592617222e-19, -6.064866969572987e-22,  3.551439261625231e-24, -2.016361135567145e-26,  2.376199204705039e-03, -3.650081702176472e-05,
  4.529495182936646e-07, -4.643918236432512e-09,  4.218890415314523e-11, -3.499289563108881e-13,  2.700801606837484e-15, -1.964756820059494e-17,  1.359604665429145e-19,
 -9.011167190104491e-22,  5.750626464364666e-24, -3.548346882192815e-26,  1.090390305583432e-03, -2.045986501833995e-05,  2.905017106505630e-07, -3.365077837560423e-09,
  3.417027564792638e-11, -3.143718679877859e-13,  2.675520281659674e-15, -2.135992154851342e-17,  1.615626705502941e-19, -1.166428563340312e-21,  8.084284682331716e-24,
 -5.403172306317161e-26,  4.589132714165227e-04, -1.037092821072858e-05,  1.677522673935018e-07, -2.185455181075697e-09,  2.470302821335423e-11, -2.511511176218276e-13,
  2.348751693460073e-15, -2.051044226394105e-17,  1.690421051688531e-19, -1.325439245106356e-21,  9.948127512879781e-24, -7.181849690185023e-26,  1.771633143323865e-04,
 -4.762917243492614e-06,  8.742507577157296e-08, -1.275845019347639e-09,  1.599712918384737e-11, -1.791584400027969e-13,  1.835669675751482e-15, -1.748526493734149e-17,
  1.566117900234341e-19, -1.330274271287760e-21,  1.078616977739303e-23, -8.391367413189471e-26,  6.274505465161910e-05, -1.985283077639767e-06,  4.120265552811329e-08,
 -6.711943536193557e-10,  9.307186374354079e-12, -1.145090433295831e-13,  1.282203145682183e-15, -1.329065477488202e-17,  1.290793212208677e-19, -1.185208626541701e-21,
  1.036028903856482e-23, -8.668531471609272e-26,  2.039132173545824e-05, -7.522362279293818e-07,  1.759186807916160e-08, -3.188946223226924e-10,  4.877548102698564e-12,
 -6.576946580518265e-14,  8.030795744489798e-16, -9.040218065642325e-18,  9.501984667429425e-20, -9.414123533770700e-22,  8.856179792326351e-24, -7.955981986198377e-26,
  6.082846059964686e-06, -2.594831639636932e-07,  6.815749523118581e-09, -1.371073783951514e-10,  2.307785942594499e-12, -3.403510215959226e-14,  4.523380803836788e-16,
 -5.520210893915344e-18,  6.269045893039703e-20, -6.691365369324536e-22,  6.764252970110358e-24, -6.514989638292844e-26,  1.666275358197457e-06, -8.160213539997647e-08,
  2.400041656541714e-09, -5.344440687916328e-11,  9.879349148390566e-13, -1.590695667975520e-14,  2.297295005439395e-16, -3.034773914275030e-18,  3.718499804527073e-20,
 -4.270177795188785e-22,  4.632683884337157e-24, -4.777899941355790e-26,  4.193797046645822e-07, -2.342835506700963e-08,  7.693299345456954e-10, -1.892176314854382e-11,
  3.834310914800203e-13, -6.729549542260008e-15,  1.054610628327016e-16, -1.506093337253595e-18,  1.988656421274657e-20, -2.454160648229800e-22,  2.854269075655559e-24,
 -3.148850125562886e-26,  9.705197071566643e-08, -6.149794249262038e-09,  2.248540591522804e-10, -6.095842692812286e-12,  1.351918396906625e-13, -2.582749454350148e-15,
  4.386578458707228e-17, -6.764640574889210e-19,  9.615313818618194e-21, -1.273923628092247e-22,  1.586841956120708e-24, -1.870911389997592e-26,  2.067015412376365e-08,
 -1.478201397572398e-09,  6.002511626834629e-11, -1.790381336478697e-12,  4.339263868549105e-14, -9.012460463014143e-16,  1.657114879437675e-17, -2.756796767769804e-19,
  4.214463829665363e-21, -5.989526353503990e-23,  7.984256471723065e-25, -1.005274831813359e-26,  4.056417066010592e-09, -3.259183416566854e-10,  1.466322315608570e-11,
 -4.803785965868150e-13,  1.270668601896288e-14, -2.866004566504735e-16,  5.699510970756421e-18, -1.022006101378089e-19,  1.679085052470226e-21, -2.557879084870740e-23,
  3.646524669221044e-25, -4.899810013536780e-27,  7.346050943584519e-10, -6.604444111241663e-11,  3.284797359040388e-12, -1.180115653546896e-13,  3.402738087350371e-15,
 -8.326506198119942e-17,  1.789410968733339e-18, -3.455956338959695e-20,  6.097878624363274e-22, -9.951212430902801e-24,  1.516290450319179e-25, -2.173174871938539e-27,
  1.229975004053790e-10, -1.232826980998662e-11,  6.764255652852504e-13, -2.661141139428166e-14,  8.355051202300564e-16, -2.216094043384331e-17,  5.142786590283428e-19,
 -1.069098674203775e-20,  2.024737920830967e-22, -3.537751110603933e-24,  5.758756806644323e-26, -8.799384579743664e-28,  1.908489722028946e-11, -2.125531001703898e-12,
  1.284049988307152e-13, -5.524260951702281e-15,  1.886651028871678e-16, -5.419825641309407e-18,  1.357277930676478e-19, -3.035295336496318e-21,  6.166998146585440e-23,
 -1.153177930446266e-24,  2.004524724553774e-26, -3.264188730598052e-28,  2.752324250453618e-12, -3.395576463999596e-13,  2.254369290767183e-14, -1.059274484381993e-15,
  3.931425026132467e-17, -1.222292375107118e-18,  3.301168005339126e-20, -7.937606165074057e-22,  1.729379080677011e-23, -3.459423011075932e-25,  6.419106138211803e-27,
 -1.113603422930856e-28,  3.702434921245606e-13, -5.045393501248920e-14,  3.674889443246224e-15, -1.883612169090451e-16,  7.590412077308444e-18, -2.552212076984212e-19,
  7.429704296295920e-21, -1.919892356930592e-22,  4.483609079870561e-24, -9.591250520064546e-26,  1.899152639364398e-27, -3.508933585276954e-29,  4.666315160356991e-14,
 -7.004911971051522e-15,  5.588039079914521e-16, -3.120748770325743e-17,  1.364218791014779e-18, -4.957529402862791e-20,  1.554688234790462e-21, -4.315521081754175e-23,
  1.079851487757734e-24, -2.469424721648736e-26,  5.216259170916163e-28, -1.026142029109089e-29,  5.540041259847539e-15, -9.137694446188849e-16,  7.970523894809603e-17,
 -4.844300196347883e-18,  2.295228888783012e-19, -9.008203695624758e-21,  3.041566176862897e-22, -9.065037102400773e-24,  2.429443007049525e-25, -5.937036956528259e-27,
  1.337438030324779e-28, -2.800434529622564e-30,  6.237027444774675e-16, -1.127438417215669e-16,  1.073551973715465e-17, -7.092429317183766e-19,  3.638848954593770e-20,
 -1.541318731542252e-21,  5.599821259217605e-23, -1.791061449680612e-24,  5.138832346919227e-26, -1.341498453168785e-27,  3.221670807748534e-29, -7.177802721377757e-31,
  6.712170708772725e-17, -1.326364600078700e-17,  1.376390346831275e-18, -9.871830360364747e-20,  5.479168982980682e-21, -2.502723545653790e-22,  9.777476795006408e-24,
 -3.354108050044377e-25,  1.029739074790430e-26, -2.870228655325050e-28,  7.345327321734656e-30, -1.740626891588402e-31,  6.972714546339899e-18, -1.502271479764068e-18,
  1.695913016467872e-19, -1.318720921712537e-20,  7.909362751063213e-22, -3.892347523699067e-23,  1.633864551406858e-24, -6.007303481895651e-26,  1.972220866706238e-27,
 -5.866250453193531e-29,  1.598923913593000e-30, -4.027959327612732e-32,  7.074486997964414e-19, -1.657249210834597e-19,  2.031328828582215e-20, -1.709855949809096e-21,
  1.106798313425869e-22, -5.861886158890696e-24,  2.641288723283709e-25, -1.039963962490747e-26,  3.648189474319871e-28, -1.157122754998429e-29,  3.356746638122039e-31,
 -8.983568557242952e-33,  7.109671802191833e-20, -1.805479578457376e-20,  2.397640035154762e-21, -2.180855739979890e-22,  1.521249336755510e-23, -8.659450340159618e-25,
  4.183337322202807e-26, -1.761927024664910e-27,  6.597622005594729e-29, -2.229306384097020e-30,  6.876766676372326e-32, -1.953457181814600e-33,  7.196456018506513e-21,
 -1.974617857847864e-21,  2.833991547347266e-22, -2.779707467478538e-23,  2.085645486912378e-24, -1.273895242785076e-25,  6.588128759140115e-27, -2.963995216663584e-28,
  1.183154296269821e-29, -4.253600465476367e-31,  1.393549180187083e-32, -4.196839205267929e-34,  7.482081529730684e-22, -2.210077975566861e-22,  3.418158219423268e-23,
 -3.606293136555250e-24,  2.903957526086748e-25, -1.899271021161907e-26,  1.049477743346377e-27, -5.034430284074828e-29,  2.138599990902288e-30, -8.166975053733845e-32,
  2.837187182110250e-33, -9.044774799079795e-35,  8.173771728806232e-23, -2.588306782969722e-23,  4.299176111985501e-24, -4.864072076680682e-25,  4.191831549593170e-26,
 -2.928013573189549e-27,  1.724454674374011e-28, -8.799912034705193e-30,  3.969217549697465e-31, -1.606653082133924e-32,  5.906235666531337e-34, -1.989094327382477e-35,
  9.627221377810022e-24, -3.252655867663341e-24,  5.778645938931631e-25, -6.985150952009660e-26,  6.420256367268698e-27, -4.773946559564054e-28,  2.987457235659294e-29,
 -1.616922770994497e-30,  7.721910927535522e-32, -3.303941781789771e-33,  1.281815643638891e-34, -4.548610328746765e-36,  1.257669084284460e-24, -4.509169011394757e-25,
  8.527072081601860e-26, -1.096294005187992e-26,  1.070107418284650e-27, -8.436221408522202e-29,  5.587687137935913e-30, -3.195657570338721e-31,  1.610057484498160e-32,
 -7.256494034564248e-34,  2.961130208633800e-35, -1.103549738634173e-36,  1.877425974257286e-25, -7.099390114372231e-26,  1.420854988306433e-26, -1.932388184844611e-27,
  1.992808093473333e-28, -1.657374276729692e-29,  1.156338655724089e-30, -6.955796197526418e-32,  3.680716686472984e-33, -1.739859863838268e-34,  7.436280170317624e-36,
 -2.898645321994568e-37,  3.296575570445516e-26, -1.305738094692299e-26,  2.747218364034453e-27, -3.926876711398203e-28,  4.251916445619869e-29, -3.708221375958155e-30,
  2.709504748222053e-31, -1.704693390549180e-32,  9.422639558903476e-34, -4.646836815114536e-35,  2.069577784661896e-36, -8.395778134721040e-38,  6.970731482043797e-27,
 -2.870035077536927e-27,  6.298966551873254e-28, -9.391841782550945e-29,  1.059914882150075e-29, -9.624831740813889e-31,  7.314557492709247e-32, -4.781240860366699e-33,
  2.742807959892587e-34, -1.402337152541712e-35,  6.468537766996650e-37, -2.714866891453075e-38,  1.789484247595731e-27, -7.595053886699237e-28,  1.723684010297219e-28,
 -2.657758967616608e-29,  3.099983948349406e-30, -2.907135963006914e-31,  2.279690583594977e-32, -1.536278274963222e-33,  9.078104518722963e-35, -4.777046852825344e-36,
  2.266036340670182e-37, -9.772107153348031e-39,  5.380635110402012e-28, -2.333195101467721e-28,  5.422906108484529e-29, -8.564319369078124e-30,  1.022753526221355e-30,
 -9.814650134934171e-32,  7.870892229463055e-33, -5.421145700584181e-34,  3.272090414602391e-35, -1.757676873277452e-36,  8.506337784402488e-38, -3.740161633725454e-39,
  1.510533233084806e-28, -6.629660592144304e-29,  1.561832040154944e-29, -2.500314057538230e-30,  3.026084769368755e-31, -2.942128474829960e-32,  2.389690389483464e-33,
 -1.666439914225771e-34,  1.018017199117027e-35, -5.532899731369012e-37,  2.708297614494714e-38, -1.204010287861686e-39,  5.311494168131397e-02, -1.157583588786655e-04,
  2.596488799669429e-07, -5.973403711953277e-10,  1.402269226006018e-12, -3.345696127014777e-15,  8.063982502224486e-18, -1.962276267307649e-20,  4.779006024387436e-23,
 -1.175084564971750e-25,  2.853559219162785e-28, -7.105772810527908e-31,  4.864429947807111e-02, -1.226023475541601e-04,  3.666915626941977e-07, -1.168364160022022e-09,
  3.751887899302779e-12, -1.191775379793048e-14,  3.727508876568152e-17, -1.148990799995613e-19,  3.493510633524961e-22, -1.050527152376828e-24,  3.123538788363353e-27,
 -9.215926635114712e-30,  4.079975229282304e-02, -1.307198589534908e-04,  5.383826391276914e-07, -2.214152170257873e-09,  8.746480574309085e-12, -3.333175296016018e-14,
  1.234228568685925e-16, -4.464144508903169e-19,  1.582792123815166e-21, -5.515876766905236e-24,  1.892914174023407e-26, -6.407886433459057e-29,  3.133891204705283e-02,
 -1.326640852478898e-04,  7.077854723493749e-07, -3.512966395153486e-09,  1.634887848549246e-11, -7.261197647290259e-14,  3.109312650398146e-16, -1.291760255225336e-18,
  5.229827631169533e-21, -2.070240214776375e-23,  8.034028777300252e-26, -3.062836912584561e-28,  2.204436865970353e-02, -1.237340773105588e-04,  8.114941191179209e-07,
 -4.726508948768059e-09,  2.549090337722273e-11, -1.300513875887362e-13,  6.348156021459001e-16, -2.986870379169698e-18,  1.362054673113507e-20, -6.044660119117121e-23,
  2.619168648532144e-25, -1.110908350516220e-27,  1.419980499479431e-02, -1.043629224278294e-04,  8.149292372246110e-07, -5.497496617788631e-09,  3.399358421474746e-11,
 -1.970657102321007e-13,  1.084949793244061e-15, -5.723186527601135e-18,  2.911422806576021e-20, -1.435236682377992e-22,  6.882446108029155e-25, -3.220055043950360e-27,
  8.375680726623817e-03, -7.916077924792027e-05,  7.226119275486297e-07, -5.598965093753935e-09,  3.935376138690664e-11, -2.570339652676647e-13,  1.583336667324770e-15,
 -9.293386358449558e-18,  5.236022333637118e-20, -2.847483128903724e-22,  1.501143601055032e-24, -7.697669811413448e-27,  4.523693681470140e-03, -5.395787586137638e-05,
  5.695688506984005e-07, -5.035040419336728e-09,  3.994276597641356e-11, -2.919587652056244e-13,  1.999740508166068e-15, -1.298316931140193e-17,  8.056059953748085e-20,
 -4.807052279532765e-22,  2.771565646478499e-24, -1.549880468587833e-26,  2.237105718138218e-03, -3.308916347364352e-05,  4.010525987425357e-07, -4.021541126372413e-09,
  3.579637590527712e-11, -2.912481275753222e-13,  2.207002812977874e-15, -1.577436493056411e-17,  1.073101645917670e-19, -6.995321321402113e-22,  4.392627511980932e-24,
 -2.667963444783599e-26,  1.012955645720523e-03, -1.828853690112245e-05,  2.532044076726820e-07, -2.865357359325755e-09,  2.847938125912421e-11, -2.567887829249852e-13,
  2.143929252125483e-15, -1.680373887144599e-17,  1.248610928483522e-19, -8.860485465624905e-22,  6.038873203617874e-24, -3.970595341439645e-26,  4.199565068489814e-04,
 -9.127455474296125e-06,  1.437419490942569e-07, -1.827512937323093e-09,  2.020017007803682e-11, -2.011028185666686e-13,  1.843530615490838e-15, -1.579353049827775e-17,
  1.277874235875810e-19, -9.842257552356316e-22,  7.259996375917000e-24, -5.153284411419733e-26,  1.594192848430430e-04, -4.120663535072673e-06,  7.353973775896761e-08,
 -1.046319399558090e-09,  1.281761380347651e-11, -1.404525512322021e-13,  1.409599208077425e-15, -1.316337939478598e-17,  1.156731960785421e-19, -9.645693224001983e-22,
  7.682065377219161e-24, -5.873121459994660e-26,  5.541551149846247e-05, -1.685511394351782e-06,  3.397132668457365e-08, -5.390474335290665e-10,  7.296845841930792e-12,
 -8.777181668508968e-14,  9.620077474990467e-16, -9.769725002925383e-18,  9.303478862382417e-20, -8.381547762977123e-22,  7.192696306992835e-24, -5.911212779794113e-26,
  1.764135997599306e-05, -6.255751014756207e-07,  1.419314048733479e-08, -2.504100110272378e-10,  3.736045900356664e-12, -4.921850772727532e-14,  5.878778943609960e-16,
 -6.479774958981004e-18,  6.674276339148935e-20, -6.484589214587508e-22,  5.985848153030903e-24, -5.279388140318856e-26,  5.144367747025072e-06, -2.109587505926906e-07,
  5.371321580513026e-09, -1.050873125831350e-10,  1.724208684994404e-12, -2.482761157890711e-14,  3.225782945263526e-16, -3.852455856648163e-18,  4.285149394552500e-20,
 -4.483118788928650e-22,  4.444915951389035e-24, -4.201281319207808e-26,  1.374555485424436e-06, -6.472078189305482e-08,  1.843948821639250e-09, -3.990963609890511e-11,
  7.186869801562576e-13, -1.129169234552717e-14,  1.593366753859175e-16, -2.058797429312614e-18,  2.469619926749977e-20, -2.778529752334518e-22,  2.955274840588800e-24,
 -2.989894817456991e-26,  3.366723054124019e-07, -1.808706868457923e-08,  5.750458507694548e-10, -1.373921396612457e-11,  2.710746012369693e-13, -4.640059578485142e-15,
  7.101411521547095e-17, -9.915014818693428e-19,  1.281118504174816e-20, -1.548331476214874e-22,  1.764768030182895e-24, -1.909169551367613e-26,  7.563434442612852e-08,
 -4.610373801192363e-09,  1.631468372150668e-10, -4.294676855993948e-12,  9.269360277018241e-14, -1.726329997986431e-15,  2.862182138699433e-17, -4.313500971680968e-19,
  5.997522067130178e-21, -7.779083612213265e-23,  9.493042779675279e-25, -1.097208675207066e-26,  1.559670027731342e-08, -1.073377475716067e-09,  4.217484510670709e-11,
 -1.221063511189902e-12,  2.879059593083862e-14, -5.827190176086146e-16,  1.045543662868650e-17, -1.699257767350564e-19,  2.540266982985972e-21, -3.533246106194686e-23,
  4.612949328255928e-25, -5.692168811552821e-27,  2.955206939107077e-09, -2.286062786928628e-10,  9.951022871483764e-12, -3.163692314506137e-13,  8.138872213095260e-15,
 -1.788397780674188e-16,  3.469556058204342e-18, -6.076234227204596e-20,  9.759373293615623e-22, -1.454674998583692e-23,  2.030613145247141e-25, -2.673514754663494e-27,
  5.151722777645580e-10, -4.461796149182104e-11,  2.147113009688822e-12, -7.484997285793850e-14,  2.098644165019661e-15, -5.001959545147436e-17,  1.048445607084618e-18,
 -1.977241414180694e-20,  3.409989640986471e-22, -5.443853645860456e-24,  8.120817521098103e-26, -1.140245077114521e-27,  8.276611671151469e-11, -7.996739900149844e-12,
  4.245938274733029e-13, -1.620843130533481e-14,  4.948028624429534e-16, -1.278175876031296e-17,  2.892715307647769e-19, -5.871183399341597e-21,  1.086690520103515e-22,
 -1.857247422025960e-24,  2.959451324148681e-26, -4.429744956531076e-28,  1.228028657006483e-11, -1.319355598141114e-12,  7.715167840816286e-14, -3.221128346430902e-15,
  1.069670374882706e-16, -2.992670641876511e-18,  7.308590649819508e-20, -1.595691025248782e-21,  3.168342908843605e-23, -5.794851567373224e-25,  9.860108610831987e-27,
 -1.572813103551589e-28,  1.687246541225683e-12, -2.009714222368600e-13,  1.292106676563979e-14, -5.893292512219890e-16,  2.127107435489257e-17, -6.441287450237260e-19,
  1.696628138597285e-20, -3.983041332574676e-22,  8.480974735419088e-24, -1.659455042048003e-25,  3.014252366905868e-27, -5.122570288359083e-29,  2.153832716620487e-13,
 -2.836457478708508e-14,  2.001799816275328e-15, -9.963398204081575e-17,  3.905629527359453e-18, -1.279364831986064e-19,  3.632858994901798e-21, -9.167020973359732e-23,
  2.092529540686857e-24, -4.379093803714860e-26,  8.489252918833774e-28, -1.536719495287269e-29,  2.565151427696606e-14, -3.725342758668433e-15,  2.881525268341126e-16,
 -1.563456925540032e-17,  6.651181967357405e-19, -2.355488257539452e-20,  7.207559778893108e-22, -1.954203889840529e-23,  4.780817361818714e-25, -1.069799844179100e-26,
  2.212923664744550e-28, -4.266021133594727e-30,  2.864955655666017e-15, -4.577114258315850e-16,  3.874455573429414e-17, -2.289329453172058e-18,  1.056164299312801e-19,
 -4.041597643798534e-21,  1.332073349800812e-22, -3.879390763308558e-24,  1.016863454859483e-25, -2.432467160989574e-27,  5.367827442764626e-29, -1.101798767694515e-30,
  3.019861156298350e-16, -5.294688607815465e-17,  4.897532908776970e-18, -3.148191315317204e-19,  1.573860058404538e-20, -6.503948575668733e-22,  2.307933760203948e-23,
 -7.216942838260865e-25,  2.026218683174349e-26, -5.180125782092929e-28,  1.219208944868680e-29, -2.664000621491087e-31,  3.027705193019231e-17, -5.811750195153800e-18,
  5.865475786883213e-19, -4.097350441019880e-20,  2.217869490132029e-21, -9.891443740275052e-23,  3.777059688287850e-24, -1.267630753928573e-25,  3.810667638364699e-27,
 -1.040842788993979e-28,  2.612059867508062e-30, -6.073967949517118e-32,  2.915085162978311e-18, -6.111074316008540e-19,  6.718594269714075e-20, -5.094267528436659e-21,
  2.982930991064823e-22, -1.434685890314017e-23,  5.891553076038511e-25, -2.121030970384810e-26,  6.823820863647444e-28, -1.990484686434374e-29,  5.324126780738342e-31,
 -1.317072814509664e-32,  2.726833631101334e-19, -6.226899757687634e-20,  7.444561580386198e-21, -6.118785075532699e-22,  3.871558544498687e-23, -2.006301594074176e-24,
  8.853381901904242e-26, -3.416689315856789e-27,  1.175677663583280e-28, -3.660310575903042e-30,  1.042956056785118e-31, -2.743310084847210e-33,  2.513387974888333e-20,
 -6.234460594833854e-21,  8.089435011378367e-22, -7.195926410102766e-23,  4.913560743123478e-24, -2.740374304119441e-25,  1.298150060156606e-26, -5.365418156467876e-28,
  1.972980767154590e-29, -6.551016749306673e-31,  1.986967201484395e-32, -5.553064038028393e-34,  2.321718496562069e-21, -6.236197955259610e-22,  8.761958549867759e-23,
 -8.419645933645657e-24,  6.194178935551594e-25, -3.712525388062178e-26,  1.885441214794070e-27, -8.335743015010054e-29,  3.271930384506613e-30, -1.157380713628968e-31,
  3.732868443675810e-33, -1.107340270400026e-34,  2.193075196844997e-22, -6.356266724104751e-23,  9.644349952581801e-24, -9.988193756206618e-25,  7.900677693220238e-26,
 -5.079357685551895e-27,  2.760755299729091e-28, -1.303484783734288e-29,  5.453026187429815e-31, -2.051905902878635e-32,  7.027386454810186e-34, -2.209686546889240e-35,
  2.168918489685685e-23, -6.755756443012297e-24,  1.103381521753792e-24, -1.228059473877002e-25,  1.041725375299300e-26, -7.166507942212058e-28,  4.159274116942383e-29,
 -2.092710456018554e-30,  9.311541725364392e-32, -3.719914508064789e-33,  1.350244137783253e-34, -4.492025436798485e-36,  2.307623910264348e-24, -7.688688647512989e-25,
  1.346418709139328e-25, -1.604763539393048e-26,  1.455024793970426e-27, -1.067798466985065e-28,  6.598023091904596e-30, -3.527767832257464e-31,  1.665032133177418e-32,
 -7.043623646199481e-34,  2.702867414744666e-35, -9.490358910989054e-37,  2.722660925954737e-25, -9.651589755516722e-26,  1.803595234758853e-26, -2.291908185522930e-27,
  2.211994640871840e-28, -1.724881797000517e-29,  1.130486687143170e-30, -6.399965341843526e-32,  3.192993017415931e-33, -1.425511125429301e-34,  5.764071220080133e-36,
 -2.129284844215479e-37,  3.679897032285535e-26, -1.379343261668946e-26,  2.734898957061645e-27, -3.685384667872998e-28,  3.766732801358492e-29, -3.105693218010468e-30,
  2.148774130832903e-31, -1.282172821929513e-32,  6.732057617631127e-34, -3.158363275294902e-35,  1.340131623082436e-36, -5.187331641302679e-38,  5.884752206662041e-27,
 -2.316004640906405e-27,  4.839304796054252e-28, -6.870255107678829e-29,  7.389655139111758e-30, -6.403388643978972e-31,  4.649778403693215e-32, -2.907895933147408e-33,
  1.598029471027176e-34, -7.836737884545046e-36,  3.471426221963998e-37, -1.400941633279462e-38,  1.144457734075200e-27, -4.691977816042138e-28,  1.024991353438050e-28,
 -1.521232436894889e-29,  1.709063923635807e-30, -1.545190071522893e-31,  1.169337180916601e-32, -7.612309812161707e-34,  4.349657814100137e-35, -2.215408182505861e-36,
  1.018133389546790e-37, -4.257962104325296e-39,  2.740440856034793e-28, -1.160221449095851e-28,  2.625886019316646e-29, -4.037795385898555e-30,  4.697045475012420e-31,
 -4.393396023222554e-32,  3.436494641659752e-33, -2.310200147027731e-34,  1.361913086707987e-35, -7.150258764885250e-37,  3.384305666309396e-38, -1.456347907840525e-39,
  7.827094187760066e-29, -3.390018110506699e-29,  7.868814612677838e-30, -1.241065883281657e-30,  1.480159212412319e-31, -1.418607211345887e-32,  1.136257611803375e-33,
 -7.816732413185697e-35,  4.712554926675205e-36, -2.528613160098046e-37,  1.222399063095545e-38, -5.369123524594476e-40,  2.132791088015268e-29, -9.356657118456429e-30,
  2.203187712276403e-30, -3.525307682504574e-31,  4.264529370424013e-32, -4.144221820479331e-33,  3.364485614105837e-34, -2.345129894009527e-35,  1.431980536606932e-36,
 -7.779363321837641e-38,  3.806285033375688e-39, -1.691428402524586e-40,  5.265601776186212e-02, -1.137094637775729e-04,  2.526132387580631e-07, -5.754290432753386e-10,
  1.337247031636172e-12, -3.158584817890915e-15,  7.535334497242387e-18, -1.815902243235535e-20,  4.375788788144710e-23, -1.066965279151448e-25,  2.557909489643601e-28,
 -6.349826450000386e-31,  4.815966977441448e-02, -1.197238938233100e-04,  3.530236628097312e-07, -1.110193259076168e-09,  3.522224636996665e-12, -1.106052860683023e-14,
  3.420890578405041e-17, -1.043016068896287e-19,  3.136866640728956e-22, -9.333296590557798e-25,  2.745062697000174e-27, -8.017278224576972e-30,  4.028532199681382e-02,
 -1.265167477412406e-04,  5.126309862316429e-07, -2.079384767332174e-09,  8.108483351997008e-12, -3.051405466330940e-14,  1.116035019756792e-16, -3.988014539907002e-19,
  1.397196663909644e-21, -4.812201089965624e-24,  1.632343798486279e-26, -5.462852839764889e-29,  3.081931942387319e-02, -1.271660847568106e-04,  6.671527246102796e-07,
 -3.262608767184195e-09,  1.496842763884190e-11, -6.556541360634860e-14,  2.769971731651599e-16, -1.135735547518503e-18,  4.539280513608139e-21, -1.774284465859731e-23,
  6.800297857844967e-26, -2.560844961426781e-28,  2.156206657617780e-02, -1.174622556990490e-04,  7.571399103860273e-07, -4.338662491168019e-09,  2.303570341217653e-11,
 -1.157720903895004e-13,  5.569719802053036e-16, -2.583899968538172e-18,  1.162183877110180e-20, -5.088558593974621e-23,  2.175891700503631e-25, -9.109494567103451e-28,
  1.379498703300997e-02, -9.809841272397977e-05,  7.520970369131593e-07, -4.983767659468909e-09,  3.030020227127370e-11, -1.728492196682110e-13,  9.370033295403069e-16,
 -4.869152772579824e-18,  2.441057516189773e-20, -1.186310591373516e-22,  5.609790262277814e-25, -2.588843009430700e-27,  8.070188492251886e-03, -7.363830763235040e-05,
  6.590391193174354e-07, -5.008450859044608e-09,  3.457294525316867e-11, -2.219762018640712e-13,  1.345117111320276e-15, -7.770916731901633e-18,  4.311318717493105e-20,
 -2.309657717246616e-22,  1.199863248151774e-24, -6.064832108104185e-27,  4.316607390118266e-03, -4.963256999213315e-05,  5.127982997849656e-07, -4.440180460869151e-09,
  3.455552291159542e-11, -2.480512877347665e-13,  1.669846496742612e-15, -1.066198571982892e-17,  6.509665134941352e-20, -3.823688347547753e-22,  2.171000687375439e-24,
 -1.195935028989452e-26,  2.110873453521676e-03, -3.006446476115503e-05,  3.560472617843480e-07, -3.492664357948327e-09,  3.046722867761228e-11, -2.432143244583656e-13,
  1.809838776810966e-15, -1.271162885403743e-17,  8.502584457190948e-20, -5.452409631138723e-22,  3.369436064553043e-24, -2.014763769484827e-26,  9.436454449065939e-04,
 -1.639306531935165e-05,  2.213932969855118e-07, -2.448129991071624e-09,  2.382225188312726e-11, -2.105569269998648e-13,  1.724880626841957e-15, -1.327514265210549e-17,
  9.692078183667429e-20, -6.761355585752501e-22,  4.532286009098798e-24, -2.932087906756734e-26,  3.856150378118771e-04, -8.060036828265320e-06,  1.236256777012391e-07,
 -1.534225144636386e-09,  1.658699744859608e-11, -1.617334707387224e-13,  1.453609194452877e-15, -1.221935316516016e-17,  9.707846324127068e-20, -7.345890416113077e-22,
  5.326187414119498e-24, -3.717784649187131e-26,  1.440384010487481e-04, -3.579284711935790e-06,  6.212732620562014e-08, -8.619900507071924e-10,  1.031904492783491e-11,
 -1.106568752893911e-13,  1.088021174400561e-15, -9.962834466654264e-18,  8.590871094973212e-20, -7.033868792569509e-22,  5.503342877824788e-24, -4.135323200287134e-26,
  4.917867536854428e-05, -1.437756017005377e-06,  2.814914850296508e-08, -4.351742264510274e-10,  5.751760799369717e-12, -6.765585874190751e-14,  7.259671895720559e-16,
 -7.224579278931644e-18,  6.746867774491445e-20, -5.964750286968088e-22,  5.025943936581871e-24, -4.057684930728652e-26,  1.534846058511815e-05, -5.231035747893136e-07,
  1.151672107136698e-08, -1.977992513945378e-10,  2.879231739548492e-12, -3.706532492513301e-14,  4.331403823074131e-16, -4.675499988978644e-18,  4.720107451922426e-20,
 -4.497906779894704e-22,  4.074694046671747e-24, -3.528785878638175e-26,  4.379102829070560e-06, -1.725985606653081e-07,  4.260680317390776e-09, -8.108581662085202e-11,
  1.297079596973674e-12, -1.823897643103147e-14,  2.317059198004313e-16, -2.708438734529010e-18,  2.951183339124852e-20, -3.026738807794092e-22,  2.943724990876677e-24,
 -2.730850475234243e-26,  1.142397343010698e-06, -5.170527563595214e-08,  1.427197730836790e-09, -3.002764411630614e-11,  5.268496624864928e-13, -8.078552920696158e-15,
  1.113993775799099e-16, -1.408095428384037e-18,  1.653805313244903e-20, -1.823199836574223e-22,  1.901380364153893e-24, -1.887270146274023e-26,  2.725760824925823e-07,
 -1.407894680895536e-08,  4.334120497201262e-10, -1.006049460221687e-11,  1.932872830379943e-13, -3.227241158255784e-15,  4.824190269073417e-17, -6.585937120392614e-19,
  8.328279301088934e-21, -9.858549397273356e-23,  1.101331556925552e-24, -1.168482565158597e-26,  5.950922030763658e-08, -3.488531380540641e-09,  1.194804731049199e-10,
 -3.054216174399979e-12,  6.415992301774094e-14, -1.165000125390216e-15,  1.885714785285929e-17, -2.777594238045655e-19,  3.778150410383861e-21, -4.797956526532484e-23,
  5.736701116552475e-25, -6.500558639364683e-27,  1.189517741880915e-08, -7.875632846536151e-10,  2.994149661511320e-11, -8.414814548024545e-13,  1.930304126873662e-14,
 -3.807571375591853e-16,  6.667142110689065e-18, -1.058662134129620e-19,  1.547730584398644e-21, -2.107020874528880e-23,  2.694448557891348e-25, -3.258740905957490e-27,
  2.178754869664584e-09, -1.622151219439235e-10,  6.831104774059163e-12, -2.107579949369339e-13,  5.273333238933330e-15, -1.128906439571067e-16,  2.136673905905482e-18,
 -3.654827078040241e-20,  5.739134668784014e-22, -8.370493586200525e-24,  1.144188894748646e-25, -1.476151395349709e-27,  3.660814301825495e-10, -3.053102411030083e-11,
  1.421333308739304e-12, -4.807579459478023e-14,  1.310713960620058e-15, -3.042826298275240e-17,  6.220819338759185e-19, -1.145582452924004e-20,  1.931138905278320e-22,
 -3.016023763107911e-24,  4.404806531309753e-26, -6.059307385366999e-28,  5.650798720043875e-11, -5.260636474926524e-12,  2.702423680688866e-13, -1.000899879723619e-14,
  2.970726251254647e-16, -7.473478291564820e-18,  1.649422910289269e-19, -3.268484167857698e-21,  5.912242607844406e-23, -9.883700728202023e-25,  1.541700137693566e-26,
 -2.260531537622320e-28,  8.028260369732661e-12, -8.316588028792847e-13,  4.706349141176817e-14, -1.906531381120166e-15,  6.155444697246917e-17, -1.677049979502101e-18,
  3.993768677202948e-20, -8.512509951138327e-22,  1.651702577161146e-23, -2.954693677744215e-25,  4.921082580025983e-27, -7.689057432759269e-29,  1.052346672329555e-12,
 -1.209571047041296e-13,  7.528507698230356e-15, -3.332320590502533e-16,  1.169483357576102e-17, -3.448866539121252e-19,  8.858552860766312e-21, -2.030275629728714e-22,
  4.224535562137456e-24, -8.084834563523838e-26,  1.437464717254615e-27, -2.392920055586324e-29,  1.276590405763643e-13, -1.623780027436391e-14,  1.109946248517550e-15,
 -5.362965697572330e-17,  2.044560404895259e-18, -6.523391238378131e-20,  1.806576970704712e-21, -4.450903516337398e-23,  9.929508159898968e-25, -2.032608250744076e-26,
  3.857367568913209e-28, -6.840375897422309e-30,  1.438725726428424e-14, -2.020178390275075e-15,  1.514449782301444e-16, -7.980554150433163e-18,  3.303012470111036e-19,
 -1.139691875489484e-20,  3.401974031601387e-22, -9.007838362550643e-24,  2.154158784320482e-25, -4.716018828160338e-27,  9.551533016841694e-29, -1.804156753140770e-30,
  1.513717403428981e-15, -2.340895098477109e-16,  1.922000751210063e-17, -1.103643732732786e-18,  4.955998907454098e-20, -1.848552531801019e-21,  5.945744481154931e-23,
 -1.691603422420461e-24,  4.335724167561822e-26, -1.015022698793250e-27,  2.193757501099832e-29, -4.413286109868570e-31,  1.495833664416754e-16, -2.541954696102880e-17,
  2.282813482371024e-18, -1.427132261682050e-19,  6.949126958959870e-21, -2.800711183187075e-22,  9.703722915703690e-24, -2.965737371853667e-25,  8.145631295236804e-27,
 -2.038892570272081e-28,  4.701890224414977e-30, -1.007332611938968e-31,  1.398830726065502e-17, -2.606307349275408e-18,  2.556669825783710e-19, -1.738566064869038e-20,
  9.173594726659214e-22, -3.993083414314777e-23,  1.489765621762896e-24, -4.889822163440223e-26,  1.438855344653741e-27, -3.850010383706859e-29,  9.471879291971061e-31,
 -2.160722966594057e-32,  1.249509377764489e-18, -2.546726815632510e-19,  2.724971398804625e-20, -2.013577371267473e-21,  1.150477064252462e-22, -5.405435261544974e-24,
  2.170620249436953e-25, -7.648557961860798e-27,  2.410463081343781e-28, -6.892911932751253e-30,  1.808703178833574e-31, -4.392301192348964e-33,  1.078431861878356e-19,
 -2.398664107602159e-20,  2.795151278990921e-21, -2.241846023989735e-22,  1.385770218348441e-23, -7.022899518287652e-25,  3.033567850064253e-26, -1.146957550760626e-27,
  3.869624387814142e-29, -1.182091230893259e-30,  3.307055421986553e-32, -8.546135635424270e-34,  9.120718777712870e-21, -2.207999756826414e-21,  2.797208404271990e-22,
 -2.431805110342724e-23,  1.624459194040743e-24, -8.871562437755247e-26,  4.118776381184376e-27, -1.669725840541354e-28,  6.026717954855552e-30, -1.965519544503074e-31,
  5.859264579609149e-33, -1.610392875904999e-34,  7.688939092179843e-22, -2.020014643760999e-22,  2.776326861025336e-23, -2.611876070818938e-24,  1.882830346746027e-25,
 -1.106696839892324e-26,  5.516238896852861e-28, -2.395300372120301e-29,  9.240544073158662e-31, -3.214544224886160e-32,  1.020208920094675e-33, -2.979730302803643e-35,
  6.595252426199044e-23, -1.874048757175203e-23,  2.787434308260326e-24, -2.831752429399153e-25,  2.198838888687673e-26, -1.388725220342532e-27,  7.420184408360997e-29,
 -3.446306984295119e-30,  1.419091766522365e-31, -5.258985750905727e-33,  1.774767022890324e-34, -5.501834876653433e-36,  5.898278385812722e-24, -1.805702664188767e-24,
  2.897700946740768e-25, -3.170448163988045e-26,  2.645439585545004e-27, -1.791295675590378e-28,  1.023890042625251e-29, -5.076542722865087e-31,  2.227082761220302e-32,
 -8.776525914070553e-34,  3.144004998052637e-35, -1.032756841343153e-36,  5.658577920936188e-25, -1.857904298602781e-25,  3.204659287758300e-26, -3.763585683715106e-27,
  3.364093371627710e-28, -2.435116048174037e-29,  1.484899701100431e-30, -7.838747583136093e-32,  3.654537548246124e-33, -1.527770572992402e-34,  5.795859404403416e-36,
 -2.012727662271275e-37,  6.014607264211129e-26, -2.106703213487581e-26,  3.887766411397882e-27, -4.880025180665027e-28,  4.654163380852753e-29, -3.587818867025368e-30,
  2.325569941752039e-31, -1.302588701359160e-32,  6.432187116242150e-34, -2.843280132680413e-35,  1.138718194258349e-36, -4.167818514386420e-38,  7.336988945526538e-27,
 -2.724553260246839e-27,  5.348901198026303e-28, -7.137928988524863e-29,  7.226779112621944e-30, -5.904283197806610e-31,  4.049179403965852e-32, -2.395663934269116e-33,
  1.247557474830018e-34, -5.806747432677561e-36,  2.445093499917649e-37, -9.394849153675637e-39,  1.064659445547127e-27, -4.161557896726227e-28,  8.632084868217149e-29,
 -1.216625247906630e-29,  1.299406423161184e-30, -1.118320521094161e-31,  8.067244817925771e-33, -5.013115557775541e-34,  2.738077338035179e-35, -1.334814175672971e-36,
  5.879042888118915e-38, -2.359513628240693e-39,  1.896963225271832e-28, -7.741656588193400e-29,  1.682847155310329e-29, -2.485314686683874e-30,  2.778810899121668e-31,
 -2.500700778708492e-32,  1.883933093733524e-33, -1.221108750574239e-34,  6.948158658609874e-36, -3.524581050901635e-37,  1.613457460418689e-38, -6.722263014425721e-40,
  4.221461366634135e-29, -1.782477291318734e-29,  4.022394409590378e-30, -6.167120114754106e-31,  7.153540523884417e-32, -6.672536888284215e-33,  5.205217104532367e-34,
 -3.490145838180285e-35,  2.052350946132282e-36, -1.074901338078231e-37,  5.075701931907251e-39, -2.179253646158862e-40,  1.141904147577368e-29, -4.939462252418056e-30,
  1.144918586616033e-30, -1.803211500429830e-31,  2.147626126263128e-32, -2.055543258443943e-33,  1.644267553373286e-34, -1.129716215910116e-35,  6.802459404580856e-37,
 -3.645640949344450e-38,  1.760364123796225e-39, -7.723386340275558e-41,  3.014641375795854e-30, -1.321932353816510e-30,  3.111117916309906e-31, -4.975491847142362e-32,
  6.015706683862083e-33, -5.843044701384150e-34,  4.741330834483536e-35, -3.303229424282846e-36,  2.016063015504483e-37, -1.094740112822141e-38,  5.353933941831287e-40,
 -2.378127955118267e-41,  };
  int offset = -43;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 43;
    if (std::isnan(t)) {
      fill_n(rr+offset, 43, 0.5);
      fill_n(ww+offset, 43, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 43; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=43; ++j) {
        const int boxof = it*516+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
