//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_32.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot32(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[32] = {1.912751096844681e-02,1.722157241453954e-01,4.787564772774879e-01,9.394832145007335e-01,1.555508231478936e+00,
    2.328337668210397e+00,3.259892256456943e+00,4.352534529330142e+00,5.609103457496148e+00,7.032957798283900e+00,8.628029857405931e+00,1.039889190555262e+01,
    1.235083821771476e+01,1.448998669078027e+01,1.682340536295370e+01,1.935927108726876e+01,2.210707038220600e+01,2.507785654419803e+01,2.828458319497047e+01,
    3.174254379061666e+01,3.546996139617324e+01,3.948879712336818e+01,4.382588636990388e+01,4.851458386741599e+01,5.359723182614860e+01,5.912902793439174e+01,
    6.518442637613580e+01,7.186849935955155e+01,7.933908652882313e+01,8.785611994313348e+01,9.791671642606245e+01,1.107992689470757e+02};
  constexpr double aw[32] = {2.713774249413026e-01,2.329947860626777e-01,1.716858423490840e-01,1.084983493061871e-01,5.873998196409935e-02,
    2.720312895368893e-02,1.075604050987915e-02,3.622586978534457e-03,1.036329099507577e-03,2.509836985130608e-04,5.125929135786279e-05,8.788499230850367e-06,
    1.258340251031190e-06,1.495532936727246e-07,1.465125316476094e-08,1.173616742321534e-09,7.615217250145460e-11,3.959177766947724e-12,1.628340730709826e-13,
    5.218623726590694e-15,1.280093391322481e-16,2.351884710675810e-18,3.152254566503851e-20,2.982862784279876e-22,1.911706883300574e-24,7.861797788926411e-27,
    1.929103595464950e-29,2.549660899112834e-32,1.557390624629720e-35,3.421138011256267e-39,1.679747990108173e-43,5.535706535856872e-49};
  constexpr double x[12288] = {  1.167813462640008e-03, -8.978019385235082e-06,  5.173601091605041e-08, -2.648030004505717e-10,  1.269405021392980e-12,
 -5.835058172145710e-15,  2.604108168884081e-17, -1.136674592684661e-19,  4.875228890583071e-22, -2.061043023851998e-24,  8.606710936748330e-27, -3.555446262555106e-29,
  1.049445112170177e-02, -8.030942810620415e-05,  4.585178715213314e-07, -2.310633330810880e-09,  1.081823399115808e-11, -4.808343170378255e-14,  2.049458573123094e-16,
 -8.414508670315632e-19,  3.330702848015635e-21, -1.268281383535203e-23,  4.619047188819734e-26, -1.590689462693390e-28,  2.906322413327617e-02, -2.203635249981727e-04,
  1.234825443264114e-06, -6.027322376798129e-09,  2.684891708211033e-11, -1.107949284209611e-13,  4.234344963115096e-16, -1.477599592516600e-18,  4.527065671031919e-21,
 -1.083053339515020e-23,  9.431978158145164e-27,  1.048906935843069e-28,  5.670578951882223e-02, -4.240146719539699e-04,  2.309183840315406e-06, -1.072163792292449e-08,
  4.398999346775701e-11, -1.586320973980437e-13,  4.785929158145954e-16, -9.980208518663518e-19, -3.984028914683208e-22,  1.943954932740888e-23, -1.376389807999788e-25,
  6.925287996268804e-28,  9.317128517932322e-02, -6.838009857469822e-04,  3.581738270943483e-06, -1.548742944135919e-08,  5.591595017945366e-11, -1.563756760539719e-13,
  2.192515386257161e-16,  9.921683736835553e-19, -1.068860794514780e-20,  5.894063192153030e-23, -2.322307985923631e-25,  5.968321374074201e-28,  1.381283078268693e-01,
 -9.901880837842503e-04,  4.932439310508344e-06, -1.934454322821784e-08,  5.697474946069358e-11, -8.334185568363285e-14, -3.551392900055035e-16,  3.760884980753001e-18,
 -1.908862687194591e-20,  6.109985958716657e-23, -5.730147470404354e-26, -8.106412979023410e-28,  1.911675417385114e-01, -1.331907386340404e-03,  6.230933646747961e-06,
 -2.139133428639790e-08,  4.371371458593233e-11,  5.651688765698880e-14, -1.062751290946301e-15,  5.665035809670454e-18, -1.635835883204359e-20, -4.459993611781076e-24,
  3.619271509232307e-25, -2.330872572406153e-27,  2.518050304558712e-01, -1.696357950285537e-03,  7.347380224278119e-06, -2.094863621286871e-08,  1.594127804545618e-11,
  2.325967499665853e-13, -1.596406070962107e-15,  5.036067019662115e-18,  1.173757483152554e-21, -1.103255094090636e-22,  6.564811307759699e-25, -1.695864181489934e-27,
  3.194860808471400e-01, -2.070058583732029e-03,  8.163330432154643e-06, -1.767397697889424e-08, -2.293985238354411e-11,  3.949052207042448e-13, -1.650736936271336e-15,
  1.264914780602607e-18,  2.665363488632528e-20, -1.756107598291057e-22,  4.071185048245716e-25,  1.645624970887246e-27,  3.935897857712858e-01, -2.439135116565561e-03,
  8.581794666149568e-06, -1.162876781819933e-08, -6.643284140573274e-11,  4.887338287059834e-13, -1.066804141219266e-15, -4.560800393532621e-18,  4.483892365402781e-20,
 -1.243081848413102e-22, -3.882825171778807e-25,  4.903737683133217e-27,  4.734341478671603e-01, -2.789826244378272e-03,  8.535669013891288e-06, -3.287656457164540e-09,
 -1.061976251634384e-10,  4.723097519337041e-13,  7.073426638269397e-17, -9.920099789783234e-18,  4.109862648791014e-20,  4.407037275407565e-23, -1.156072348499281e-24,
  4.133466788363960e-27,  5.582817826774793e-01, -3.108990384346848e-03,  7.993812929116304e-06,  6.512622688987278e-09, -1.337961545106389e-10,  3.317765366728874e-13,
  1.432623948999282e-15, -1.199532084434425e-17,  1.186886254168780e-20,  2.330935097553225e-22, -1.157140788362161e-24, -1.346238139356208e-27,  6.473461743730579e-01,
 -3.384595535845155e-03,  6.964244650048927e-06,  1.667885544058570e-08, -1.425544616994030e-10,  8.842797411473367e-14,  2.549971563707502e-15, -9.145884823205251e-18,
 -3.070017529887142e-20,  3.062157333349761e-22, -1.745335568215513e-25, -7.142896980101838e-27,  7.397984517533951e-01, -3.606174271280775e-03,  5.494144136729429e-06,
  2.600730402784790e-08, -1.291244989956598e-10, -2.046280538621323e-13,  2.989130586432226e-15, -1.935299434489570e-18, -6.401627563110175e-20,  1.876201823809748e-22,
  1.161290911275585e-24, -7.407011407095566e-27,  8.347746459809142e-01, -3.765226726253698e-03,  3.666607643595150e-06,  3.334967096904627e-08, -9.438238643070511e-11,
 -4.759276088069916e-13,  2.527561238669314e-15,  6.897353855520938e-18, -6.792896858067153e-20, -6.950381043995862e-23,  1.796660151557635e-24, -8.442386093096701e-28,
  9.313833847056646e-01, -3.855555828772486e-03,  1.594364622051507e-06,  3.777528677976376e-08, -4.343770288838384e-11, -6.555109884167498e-13,  1.256802938108389e-15,
  1.360047384722300e-17, -3.746454377140689e-20, -3.066539191969315e-22,  1.135056568721688e-24,  7.203558683924595e-27,  1.028713969939642e+00, -3.873521001056649e-03,
 -5.890746613653762e-07,  3.870568733372781e-08,  1.527762309985217e-11, -6.952568468589868e-13, -4.345458385499792e-16,  1.517540987726882e-17,  1.294417483766031e-20,
 -3.665738212585944e-22, -3.965378547229290e-25,  9.424280223476984e-27,  1.125844779369764e+00, -3.818199157083738e-03, -2.740145236094427e-06,  3.600121974533274e-08,
  7.166474990149340e-11, -5.833783751122173e-13, -1.996576469056649e-15,  1.085561703209691e-17,  5.704778029590859e-20, -2.064074210253226e-22, -1.644357771469285e-24,
  3.650663835266983e-27,  1.221851922922797e+00, -3.691444950828791e-03, -4.716955465225495e-06,  2.998592782099918e-08,  1.160077541570531e-10, -3.484101872020828e-13,
 -2.921326526216220e-15,  2.520811440649327e-18,  7.191917301254674e-20,  6.893674851348765e-23, -1.672171240157110e-24, -4.871928193155161e-27,  1.315818078523456e+00,
 -3.497845822100291e-03, -6.391037216003082e-06,  2.140584656535138e-08,  1.409691914216118e-10, -5.121972067853790e-14, -2.932424070763659e-15, -6.194626647110826e-18,
  5.128258331558096e-20,  2.808837082115604e-22, -5.318606087097410e-25, -8.570704805655111e-27,  1.406841423368017e+00, -3.244571328106358e-03, -7.658111135027574e-06,
  1.132572136170433e-08,  1.430847988307806e-10,  2.326486066644901e-13, -2.083909630663763e-15, -1.165442109598250e-17,  8.646085692685272e-21,  3.036387514708873e-22,
  8.201461654685315e-25, -4.808732844559796e-27,  1.494044569955500e+00, -2.941120400771593e-03, -8.446919664399917e-06,  9.785872680754490e-10,  1.234166598823809e-10,
  4.348690482816842e-13, -7.281031893571960e-16, -1.193114481863220e-17, -3.159528703911947e-20,  1.474742358690304e-22,  1.366069466985337e-24,  2.071617087459817e-27,
  1.576583409890603e+00, -2.598974369304332e-03, -8.725325691483089e-06, -8.409875009702281e-09,  8.721236132488926e-11,  5.136304216531772e-13,  6.327286328347051e-16,
 -7.598472621818077e-18, -4.912692575362174e-20, -6.141352579387250e-23,  8.545893145438493e-25,  5.644460098038495e-27,  1.653655763431087e+00, -2.231167652626392e-03,
 -8.503096334552872e-06, -1.579598509762457e-08,  4.264607072908252e-11,  4.643024268761628e-13,  1.547202710272806e-15, -1.231880412313649e-18, -3.904420500046407e-20,
 -1.826059614732312e-22, -1.059628597645871e-25,  3.692705485430845e-27,  1.724509729245451e+00, -1.851791763983948e-03, -7.831072417613384e-06, -2.046515157412619e-08,
 -1.067410961067008e-12,  3.182535295772514e-13,  1.783136018806987e-15,  4.053939932367331e-18, -1.265230350396957e-20, -1.612459974962970e-22, -6.916561010221817e-25,
 -5.594470866444993e-28,  1.788451627247505e+00, -1.475451485997779e-03, -6.796741166501190e-06, -2.212866254486107e-08, -3.574493403238088e-11,  1.305042064599012e-13,
  1.394369636689462e-15,  6.197738112548980e-18,  1.182575315804986e-20, -5.077849692200412e-23, -5.811060681157618e-25, -2.724738746982270e-27,  1.844853428160621e+00,
 -1.116694583712103e-03, -5.516554312158621e-06, -2.095493759904170e-08, -5.600678318070326e-11, -3.941491626624341e-14,  6.634145123592399e-16,  5.055652739316287e-18,
  2.154264482451039e-20,  4.842965504204473e-23, -1.000075230359132e-25, -1.708456229519307e-27,  1.893159567603077e+00, -7.894380597777391e-04, -4.125635646477017e-06,
 -1.753008680475531e-08, -6.033212748497752e-11, -1.468263172488086e-13, -4.720466613305048e-17,  2.136428078285838e-18,  1.586241369879744e-20,  7.391258985012211e-23,
  2.321871393739088e-25,  2.474085849232083e-28,  1.932893053406410e+00, -5.064145692520915e-04, -2.765771359061153e-06, -1.275373230319741e-08, -5.115542544164598e-11,
 -1.749686494835377e-13, -4.626272666892890e-16, -5.267140266656575e-19,  3.895673879897209e-21,  3.791557723023117e-23,  2.134902478796305e-25,  9.136284706076070e-28,
  1.963660811122022e+00, -2.786619788093513e-04, -1.572746650911378e-06, -7.686392452415596e-09, -3.399529338751248e-11, -1.375436481416287e-13, -5.048519472822045e-16,
 -1.625815927236082e-18, -4.148723606131953e-21, -4.767713347430893e-24,  3.323633538874592e-26,  3.373247385473149e-28,  1.985158426250396e+00, -1.150759645358530e-04,
 -6.641573635608965e-07, -3.372558182256076e-09, -1.584513305560272e-11, -7.029075088506402e-14, -2.969136050033419e-16, -1.196594995991139e-18, -4.586633987888491e-21,
 -1.656779779290999e-23, -5.528935048693362e-26, -1.629345956551488e-28,  1.997177348138193e+00, -2.202036636030645e-05, -1.286606643111374e-07, -6.669597614690096e-10,
 -3.233710647169191e-12, -1.500845187192923e-14, -6.749545734689406e-17, -2.961827251474206e-19, -1.273653293799234e-21, -5.381611545762169e-24, -2.237988453130058e-26,
 -9.168104570136561e-29,  1.132709512275271e-03, -8.576505217677410e-06,  4.867649376959455e-08, -2.453932230984958e-10,  1.158704748070738e-12, -5.246567851735298e-15,
  2.306610529466646e-17, -9.919038512546971e-20,  4.191630837425280e-22, -1.746112496001681e-24,  7.185652118749048e-27, -2.925641546646892e-29,  1.018037814707052e-02,
 -7.674932436369040e-05,  4.317979312633800e-07, -2.144975485837416e-09,  9.903904451551697e-12, -4.343582426151919e-14,  1.828112136127065e-16, -7.418303588032003e-19,
  2.905755155235534e-21, -1.096827899080224e-23,  3.970088482507271e-26, -1.364609323105740e-28,  2.820107925626134e-02, -2.107670949103110e-04,  1.165003696980614e-06,
 -5.614928510270437e-09,  2.473137468009766e-11, -1.011129615575212e-13,  3.840317859059848e-16, -1.338890806519708e-18,  4.144953634007825e-21, -1.037352214643357e-23,
  1.313014011309656e-26,  6.523404848148291e-29,  5.504587950727797e-02, -4.060441116869208e-04,  2.184644522999840e-06, -1.004256459701916e-08,  4.092994547323141e-11,
 -1.474820329685157e-13,  4.505678125987607e-16, -1.000577820158008e-18,  2.093185085182362e-22,  1.450572030201512e-23, -1.099483878838804e-25,  5.694853941822587e-28,
  9.049223316477463e-02, -6.558755028435444e-04,  3.401154791224612e-06, -1.461749966807587e-08,  5.284311560729205e-11, -1.508170227848736e-13,  2.425502587516421e-16,
  6.823412164357931e-19, -8.727632526688447e-21,  5.017515052317599e-23, -2.061248697113372e-25,  5.858007078944042e-28,  1.342450260431226e-01, -9.516417397588446e-04,
  4.705717956880019e-06, -1.844671044773471e-08,  5.523086043805012e-11, -9.066855077756468e-14, -2.580590730921998e-16,  3.184735934186432e-18, -1.693803534474533e-20,
  5.818664630615366e-23, -8.621662456173076e-26, -5.162599328471191e-28,  1.859379982783979e-01, -1.283074733916334e-03,  5.978467108790658e-06, -2.068420511270748e-08,
  4.460153434406680e-11,  3.285510357598921e-14, -9.114641787426313e-16,  5.141599591500257e-18, -1.628202246297787e-20,  8.078284406923122e-24,  2.677359679085512e-25,
 -1.953671544736785e-27,  2.451355712127935e-01, -1.638579766741417e-03,  7.097673854134753e-06, -2.065839402319404e-08,  2.022150439792041e-11,  1.959758747466848e-13,
 -1.455432159756300e-15,  5.014998969749803e-18, -2.343702911832758e-21, -8.560331479832751e-23,  5.787775737231490e-25, -1.813375516925576e-27,  3.113351085418271e-01,
 -2.005605944472164e-03,  7.949294184228084e-06, -1.797996864039669e-08, -1.543458227313285e-11,  3.558031992142440e-13, -1.604305747745642e-15,  2.019948398201582e-18,
  2.063988235818818e-20, -1.581324014670192e-22,  4.608232748069183e-25,  8.250611050884551e-28,  3.839696456909054e-01, -2.371056276190947e-03,  8.436189845971534e-06,
 -1.261492753640331e-08, -5.692372167521880e-11,  4.617560059699623e-13, -1.175110465202919e-15, -3.200145756917502e-18,  4.013414488054381e-20, -1.357578864940537e-22,
 -1.900868280727977e-25,  4.096983559003421e-27,  4.624111238987956e-01, -2.721726867478995e-03,  8.486333936036963e-06, -4.911248411912584e-09, -9.675617954853470e-11,
  4.708239892462249e-13, -1.884393684635519e-16, -8.588121246026057e-18,  4.189766952344085e-20,  1.575372260850079e-24, -9.665624415341955e-25,  4.424954425018909e-27,
  5.459741664080408e-01, -3.044763151704822e-03,  8.059344684515708e-06,  4.426723277143469e-09, -1.268437458801165e-10,  3.621794333498871e-13,  1.103269496963650e-15,
 -1.149027614397965e-17,  1.941708409552390e-20,  1.860886117803471e-22, -1.182071438106708e-24,  1.677010730343922e-28,  6.339204332000650e-01, -3.328119612823249e-03,
  7.150774578128476e-06,  1.441536875597570e-08, -1.401951826325321e-10,  1.464533854995143e-13,  2.281777296041672e-15, -9.953849186950914e-18, -1.987427961325603e-20,
  2.933400721204217e-22, -4.591976628843541e-25, -5.765018263954099e-27,  7.254635875674522e-01, -3.561008175276155e-03,  5.793713344546141e-06,  2.391244687583742e-08,
 -1.325052267277780e-10, -1.337641176930468e-13,  2.907338488845466e-15, -3.867432816426711e-18, -5.650575857719051e-20,  2.274082950118036e-22,  8.255109644864233e-25,
 -7.765253177876848e-27,  8.197749022039454e-01, -3.734319454596038e-03,  4.057439719044138e-06,  3.176676152746382e-08, -1.032799581803211e-10, -4.131960779225013e-13,
  2.689977093455453e-15,  4.697352078803529e-18, -6.915224295022933e-20,  9.887831663290056e-25,  1.712873877221903e-24, -2.914689880542629e-27,  9.159895241667849e-01,
 -3.841000498182429e-03,  2.043071063044256e-06,  3.697716755821104e-08, -5.621618631153544e-11, -6.209233029404891e-13,  1.619238393863072e-15,  1.223432779526801e-17,
 -4.761514420974212e-20, -2.554325520125083e-22,  1.412486720947454e-24,  5.349171747257015e-27,  1.013213406842624e+00, -3.876372629593824e-03, -1.236000701563515e-07,
  3.883846671497809e-08,  1.302802814254982e-12, -7.005524860406682e-13, -5.836353880081152e-18,  1.537623527148431e-17, -4.368152377601287e-22, -3.740149336882710e-22,
  2.646451598313511e-26,  9.696055705227957e-27,  1.110530902839861e+00, -3.838373670735036e-03, -2.301643955316786e-06,  3.705201863247865e-08,  5.954365993366783e-11,
 -6.274497495531623e-13, -1.668267354366467e-15,  1.254991466068961e-17,  4.847789420968522e-20, -2.683120579481724e-22, -1.434970757397348e-24,  5.831218542732721e-27,
  1.207012994580307e+00, -3.727710270100785e-03, -4.346229800491967e-06,  3.178252554942542e-08,  1.083455012907403e-10, -4.174131496933233e-13, -2.818245243973745e-15,
  4.848635097252927e-18,  7.315002724260017e-20, -1.708513735724175e-24, -1.846191007058517e-24, -2.965064145769143e-27,  1.301726119481828e+00, -3.547908398549406e-03,
 -6.120680359262726e-06,  2.364927907326406e-08,  1.392279632413387e-10, -1.234846769747553e-13, -3.081412453911817e-15, -4.396644682141552e-18,  6.091968668977340e-20,
  2.519773549770862e-22, -9.146902520988854e-25, -8.738502839313319e-27,  1.393741524420137e+00, -3.305253328073029e-03, -7.508321893867386e-06,  1.364947424578309e-08,
  1.472114056538247e-10,  1.787604700551225e-13, -2.404674095248485e-15, -1.119696470362009e-17,  2.011173749786152e-20,  3.316799989899447e-22,  5.688067443795089e-25,
 -6.606240567939689e-27,  1.482145060265423e+00, -3.008614562306005e-03, -8.423044994926685e-06,  3.021767853956033e-09,  1.319116679964449e-10,  4.132767451436028e-13,
 -1.075455693587608e-15, -1.284654751744414e-17, -2.528421304372040e-20,  2.035459738917929e-22,  1.427040205664757e-24,  6.333458369456540e-28,  1.566047302576982e+00,
 -2.669156141367862e-03, -8.817530341585670e-06, -6.931546840113424e-09,  9.761866543910652e-11,  5.260833842110728e-13,  3.976800410047641e-16, -9.198820431279347e-18,
 -5.066195075629052e-20, -2.218985773158133e-23,  1.107839087034113e-24,  5.813775131175840e-27,  1.644593860107343e+00, -2.299938312077484e-03, -8.688241196276922e-06,
 -1.503735637089870e-08,  5.229989849816613e-11,  5.008741010416462e-13,  1.494226097194072e-15, -2.586956413083699e-18, -4.565213382493152e-20, -1.832619165244234e-22,
  8.154122537275560e-26,  4.841753669213995e-27,  1.716975709926467e+00, -1.915422461896084e-03, -8.076539025343171e-06, -2.042894667557560e-08,  5.734546705177709e-12,
  3.623596115418685e-13,  1.890067149423044e-15,  3.550812162094100e-18, -1.895933465078236e-20, -1.892090137936443e-22, -7.012203775177759e-25,  1.652644584887776e-28,
  1.782439378217214e+00, -1.530897103278531e-03, -7.065624445095927e-06, -2.267782280978916e-08, -3.278593149141417e-11,  1.660924242996811e-13,  1.572896065148638e-15,
  6.542188999561804e-18,  9.549811810026315e-21, -7.648808374130464e-23, -7.058909516019163e-25, -2.932343190574359e-27,  1.840296770803306e+00, -1.161848143104663e-03,
 -5.773413291188493e-06, -2.185643787238892e-08, -5.662398649028692e-11, -2.171479088460443e-14,  8.148795966215821e-16,  5.771985065431248e-18,  2.319466063736208e-20,
  4.277864158642175e-23, -1.863419808097983e-25, -2.230046594088660e-27,  1.889934449444872e+00, -8.233012229255008e-04, -4.341885619007591e-06, -1.851893320729909e-08,
 -6.327483042599612e-11, -1.471815077202091e-13,  2.013458648375510e-17,  2.688410123903377e-18,  1.869266030113591e-20,  8.337229780393008e-23,  2.395391869566228e-25,
  7.419481910184314e-29,  1.930822153504715e+00, -5.291671034463870e-04, -2.923844514042498e-06, -1.360082210427116e-08, -5.476694518736205e-11, -1.862332708981644e-13,
 -4.754125801418240e-16, -3.784837941229566e-19,  5.424420174181185e-21,  4.730156014143901e-23,  2.568776056976505e-25,  1.060301020677502e-27,  1.962520401759231e+00,
 -2.916223589955561e-04, -1.668339862752652e-06, -8.252998206859770e-09, -3.687109633673337e-11, -1.502215194805434e-13, -5.522572180303324e-16, -1.761033873534955e-18,
 -4.292578731339957e-21, -3.110792487273718e-24,  5.041584839545674e-26,  4.481072540632119e-28,  1.984687233331381e+00, -1.205555255284658e-04, -7.061968724398023e-07,
 -3.637725703811172e-09, -1.732500932632812e-11, -7.783588531684834e-14, -3.325658677305261e-16, -1.353351506500163e-18, -5.224658713712455e-21, -1.892802085918131e-23,
 -6.285258989084278e-26, -1.808788200490413e-28,  1.997087156140621e+00, -2.308256871165392e-05, -1.369848162588391e-07, -7.211914030727369e-10, -3.550774921614156e-12,
 -1.673265116648914e-14, -7.638957468635224e-17, -3.402204265965659e-19, -1.484526726865388e-21, -6.363002220989352e-24, -2.683336143203068e-26, -1.114271089636123e-28,
  1.099164100088995e-03, -8.198564758484905e-06,  4.583964292859303e-08, -2.276642375325846e-10,  1.059091886386126e-12, -4.724849760298435e-15,  2.046749100168716e-17,
 -8.672987566523272e-20,  3.611810213046440e-22, -1.482849211989546e-24,  6.014744788228326e-27, -2.414067419080178e-29,  9.880130316342075e-03, -7.339527038287903e-05,
  4.069810859598225e-07, -1.993231238427255e-09,  9.077432979838515e-12, -3.928745709991559e-14,  1.632845004397026e-16, -6.548688159174605e-19,  2.538089255909248e-21,
 -9.494381688896930e-24,  3.413582755226608e-26, -1.169791783054743e-28,  2.737623349944502e-02, -2.017100054694317e-04,  1.099933620234628e-06, -5.234916292758140e-09,
  2.279832248343963e-11, -9.233141916675414e-14,  3.483443934616969e-16, -1.212121023640030e-18,  3.781567357551517e-21, -9.800099468009362e-24,  1.533081155173256e-26,
  3.633480371072995e-29,  5.345590956428486e-02, -3.890380860611053e-04,  2.067967561676375e-06, -9.410704560287339e-09,  3.808617763098724e-11, -1.370033893686918e-13,
  4.227181360613270e-16, -9.863260562163040e-19,  6.581077782744040e-22,  1.057705262661266e-23, -8.724099617298612e-26,  4.656501721157293e-28,  8.792205869222951e-02,
 -6.293537583273420e-04,  3.230719236031039e-06, -1.379581830753795e-08,  4.988637854090250e-11, -1.447964956709492e-13,  2.580063260812876e-16,  4.304165471952805e-19,
 -7.063594633559717e-21,  4.243780358663470e-23, -1.809651109781351e-25,  5.553587792942871e-28,  1.305123696457782e-01, -9.148665552675969e-04,  4.489598743066546e-06,
 -1.757783091657067e-08,  5.336246981147140e-11, -9.585123448909237e-14, -1.761647819674920e-16,  2.675528612671924e-18, -1.491021402724383e-20,  5.435440214781661e-23,
 -1.037615088555602e-25, -2.917050790882108e-28,  1.808998000002795e-01, -1.236227664817519e-03,  5.734556360281174e-06, -1.996646440299982e-08,  4.505124327848352e-11,
  1.264900352363106e-14, -7.747362228883737e-16,  4.627133113379423e-18, -1.581818481556246e-20,  1.717418199382351e-23,  1.896186066389207e-25, -1.602376436659371e-27,
  2.386932530320973e-01, -1.582784192783060e-03,  6.851837716617148e-06, -2.030534414101526e-08,  2.380303687893644e-11,  1.627193760990560e-13, -1.316494503665902e-15,
  4.895004491253002e-18, -5.028009657683743e-21, -6.405509382230293e-23,  4.986414539421503e-25, -1.812849356025109e-27,  3.034385017624208e-01, -1.942878300369578e-03,
  7.732280949799903e-06, -1.817206495303393e-08, -8.698606560343197e-12,  3.180480663477045e-13, -1.539330623861338e-15,  2.592956589337196e-18,  1.528579409636208e-20,
 -1.391756354430464e-22,  4.823200481364694e-25,  1.802251885443141e-28,  3.746194199431215e-01, -2.304187065424474e-03,  8.279645756467220e-06, -1.345338637899948e-08,
 -4.797715529791651e-11,  4.326186710446405e-13, -1.247477662885316e-15, -1.995179095697810e-18,  3.515122737221818e-20, -1.399992650786234e-22, -2.798657603881618e-26,
  3.273421466864631e-27,  4.516595883036424e-01, -2.654097539934147e-03,  8.418420092885984e-06, -6.384340206438850e-09, -8.740362080612938e-11,  4.635671327197937e-13,
 -4.101790681306419e-16, -7.253568076357594e-18,  4.130556409042215e-20, -3.317690562322145e-23, -7.711411318308657e-25,  4.413797508539048e-27,  5.339243517760703e-01,
 -2.980109853688315e-03,  8.100531767195665e-06,  2.456502667666849e-09, -1.193610445319534e-10,  3.848732452493451e-13,  7.911828673827340e-16, -1.077083032172484e-17,
  2.527047229612654e-20,  1.393346233543815e-22, -1.146746697344861e-24,  1.386804176070856e-27,  6.207234091923617e-01, -3.270259370122527e-03,  7.310406301367221e-06,
  1.219855788316812e-08, -1.367413942050417e-10,  1.978093009992698e-13,  1.995725377947195e-15, -1.042487736323906e-17, -9.701820894403683e-21,  2.703361188240015e-22,
 -6.800588136631356e-25, -4.264780745559416e-27,  7.113140205065395e-01, -3.513546891379280e-03,  6.067866092337194e-06,  2.177471176373421e-08, -1.344925422850447e-10,
 -6.548400040645070e-14,  2.775008088303914e-15, -5.538925264591228e-18, -4.780699133967356e-20,  2.536070856008177e-22,  4.856000932520931e-25, -7.605737688346342e-27,
  8.049049172363496e-01, -3.700363829503785e-03,  4.428464745808121e-06,  3.005171877927394e-08, -1.108889221193638e-10, -3.473078730490531e-13,  2.790620761511324e-15,
  2.497989915084928e-18, -6.791919068686487e-20,  6.640569014955661e-23,  1.545508945121746e-24, -4.624335549357874e-27,  9.006609987624227e-01, -3.822897245957895e-03,
  2.480997660692750e-06,  3.598058560387059e-08, -6.821921213341388e-11, -5.781311198282422e-13,  1.939165818523634e-15,  1.057484255337993e-17, -5.574253476308692e-20,
 -1.948362502893892e-22,  1.601873592967951e-24,  3.230081104041047e-27,  9.977088895437890e-01, -3.875497893553541e-03,  3.421246097509641e-07,  3.874736174588134e-08,
 -1.267483519450943e-11, -6.955401363194507e-13,  4.224846481690582e-16,  1.514786040647026e-17, -1.377998632536397e-20, -3.644884424288649e-22,  4.470999993436234e-25,
  9.317681689189033e-27,  1.095143419397342e+00, -3.854993096859330e-03, -1.851724370186116e-06,  3.790227232173760e-08,  4.662361066454759e-11, -6.631054067816556e-13,
 -1.296679652499197e-15,  1.393611862125113e-17,  3.785264136992692e-20, -3.199996862855050e-22, -1.135744788858707e-24,  7.704892831266027e-27,  1.192035070033441e+00,
 -3.760925735397683e-03, -3.954725585154854e-06,  3.344564338640646e-08,  9.933322105516676e-11, -4.831579556660009e-13, -2.649824399610400e-15,  7.173982524184672e-18,
  7.173369763529556e-20, -7.751535659668526e-23, -1.927483095003600e-24, -6.790485994909169e-28,  1.287438405530047e+00, -3.595701020015767e-03, -5.823617746281426e-06,
  2.585311298681995e-08,  1.360099321787322e-10, -1.986874521374735e-13, -3.175917465986152e-15, -2.309885248480501e-18,  6.924028906487617e-20,  2.077809195228849e-22,
 -1.291997743817915e-24, -8.307425837809466e-27,  1.380401472178701e+00, -3.364624436137721e-03, -7.330288371202895e-06,  1.603021757243983e-08,  1.501845217476571e-10,
  1.173700110282674e-13, -2.707356132237554e-15, -1.035854923087943e-17,  3.238709125962891e-20,  3.481147221671198e-22,  2.408235534874053e-25, -8.265632858565250e-27,
  1.469976114420699e+00, -3.075817378978888e-03, -8.373852378551657e-06,  5.196952573460195e-09,  1.398895152206591e-10,  3.830651062446332e-13, -1.445306047638765e-15,
 -1.352735863354219e-17, -1.692697407542074e-20,  2.606743151770053e-22,  1.416075043605217e-24, -1.192031596590312e-27,  1.555229109272022e+00, -2.740001743504167e-03,
 -8.890988864178975e-06, -5.285047151827631e-09,  1.082139646591311e-10,  5.323532879371852e-13,  1.173602918267648e-16, -1.082373253564832e-17, -5.060170783498112e-20,
  2.721038965930844e-23,  1.360701854998667e-24,  5.610180204319864e-27,  1.635253973263504e+00, -2.370151035327996e-03, -8.863331868565335e-06, -1.411849734346520e-08,
  6.266924866591073e-11,  5.356951690875947e-13,  1.400354352096728e-15, -4.152316521939385e-18, -5.213634011603897e-20, -1.753911458449929e-22,  3.206222236307678e-25,
  6.024505586031507e-27,  1.709183245803134e+00, -1.981013236780764e-03, -8.320888638764316e-06, -2.027671925506841e-08,  1.344302657093238e-11,  4.088392523100433e-13,
  1.979933673227197e-15,  2.829745664500370e-18, -2.627155906038338e-20, -2.168420891423631e-22, -6.732542724077376e-25,  1.151326628956859e-27,  1.776201004058662e+00,
 -1.588519286009860e-03, -7.340789331727624e-06, -2.317370900092963e-08, -2.907158332483115e-11,  2.060718920606934e-13,  1.759901393328071e-15,  6.798021591479309e-18,
  6.256550371630533e-21, -1.073411824475652e-22, -8.374285696146447e-25, -3.022612770913315e-27,  1.835555320750859e+00, -1.209099986000196e-03, -6.041137184258772e-06,
 -2.276477694385154e-08, -5.684918104554803e-11, -1.330550737243784e-16,  9.871064865177181e-16,  6.537214006623590e-18,  2.457531785339110e-20,  3.318997507141511e-23,
 -2.975116737717783e-25, -2.836842563854543e-27,  1.886570342352232e+00, -8.589426508385698e-04, -4.570284183025511e-06, -1.955482643394893e-08, -6.620716962746610e-11,
 -1.457245396877638e-13,  1.042487942038464e-16,  3.336449289387793e-18,  2.186669616330536e-20,  9.294950728579487e-23,  2.374225824981813e-25, -1.869110791830439e-28,
  1.928657648507413e+00, -5.532258827474733e-04, -3.092436937083467e-06, -1.450751371802702e-08, -5.860645971170369e-11, -1.977490820244603e-13, -4.833093097773783e-16,
 -1.755796043552231e-19,  7.323882456012703e-21,  5.855493976502778e-23,  3.069211823544562e-25,  1.215313385566519e-27,  1.961326577192039e+00, -3.053754838495148e-04,
 -1.771016991903508e-06, -8.867708380257915e-09, -4.001214308843826e-11, -1.640830106246667e-13, -6.035030678591765e-16, -1.899758131489142e-18, -4.363163233288985e-21,
 -6.605978630087532e-25,  7.312513941263671e-26,  5.898195600209481e-28,  1.984193428799739e+00, -1.263845449377214e-04, -7.515655942629480e-07, -3.927826492613126e-09,
 -1.896471261680112e-11, -8.629173197525671e-14, -3.729063465854559e-16, -1.531944229674402e-18, -5.953287264684565e-21, -2.160654892221434e-23, -7.120244785177526e-26,
 -1.985198924890501e-28,  1.996992577900302e+00, -2.421405633713513e-05, -1.459913627958888e-07, -7.807839762717067e-10, -3.904561731566783e-12, -1.868590238084960e-14,
 -8.661678558137906e-17, -3.916075145078838e-19, -1.734157652226647e-21, -7.541189499243733e-24, -3.225320478251317e-26, -1.357751486659870e-28,  1.067086370296088e-03,
 -7.842494437841593e-06,  4.320631075233512e-08, -2.114488564910049e-10,  9.693169319849548e-13, -4.261512899273780e-15,  1.819315780539984e-17, -7.598176958985672e-20,
  3.118849239197835e-22, -1.262214648293765e-24,  5.047315091275017e-27, -1.997320846586820e-29,  9.592912855319611e-03, -7.023268609675782e-05,  3.839084880111973e-07,
 -1.854071454084488e-09,  8.329433000621298e-12, -3.557979392364657e-14,  1.460356760387173e-16, -5.788649529526115e-19,  2.219675763483249e-21, -8.226776393636809e-24,
  2.936632897792122e-26, -1.002377988272433e-28,  2.658660313502532e-02, -1.931557487947799e-04,  1.039243765403514e-06, -4.884473216511947e-09,  2.103261696627945e-11,
 -8.436507392930328e-14,  3.160469687443980e-16, -1.096634651304456e-18,  3.440125992198633e-21, -9.161516577156255e-24,  1.644740659705189e-26,  1.558083969755892e-29,
  5.193214384247273e-02, -3.729359046565851e-04,  1.958606717786048e-06, -8.822704378774225e-09,  3.544533891591950e-11, -1.271868512223595e-13,  3.954485041478471e-16,
 -9.598092722231454e-19,  9.807604472430020e-22,  7.470454988655319e-24, -6.872158563508630e-26,  3.787446002889280e-28,  8.545530555347855e-02, -6.041568525091981e-04,
  3.069864042940350e-06, -1.302046359430792e-08,  4.705322013823622e-11, -1.384839029691777e-13,  2.671134855474410e-16,  2.274757510861826e-19, -5.660345072897668e-21,
  3.567619761199426e-23, -1.574208904099711e-25,  5.134754283401898e-28,  1.269234213868193e-01, -8.797791336790196e-04,  4.283723630545546e-06, -1.673957279207827e-08,
  5.140896259715426e-11, -9.923234813164719e-14, -1.076414310719290e-16,  2.228886998991597e-18, -1.303076812297960e-20,  5.000018524144662e-23, -1.127339831323261e-25,
 -1.246598164922647e-28,  1.760451421084990e-01, -1.191297337410978e-03,  5.499288900557117e-06, -1.924458789697186e-08,  4.512848798728124e-11, -4.446527345138900e-15,
 -6.521604294924429e-16,  4.132175258414537e-18, -1.507950407671894e-20,  2.344455000482631e-23,  1.261997572082270e-25, -1.286658237218086e-27,  2.324702119109628e-01,
 -1.528937436732812e-03,  6.610560638865332e-06, -1.990013091223539e-08,  2.675246507386101e-11,  1.327480512932234e-13, -1.182007045735858e-15,  4.700907005522336e-18,
 -6.994026375973697e-21, -4.568525716660505e-23,  4.204569683229176e-25, -1.730030156941483e-27,  2.957893212600325e-01, -1.881894207391667e-03,  7.513584583440051e-06,
 -1.826233663311790e-08, -2.700937256573418e-12,  2.820261420152913e-13, -1.460606431823047e-15,  3.005666471752155e-18,  1.062323830034888e-20, -1.198773640287020e-22,
  4.790836133172528e-25, -3.020038107980580e-28,  3.655341059864852e-01, -2.238608064778640e-03,  8.113879525464022e-06, -1.415344535424014e-08, -3.962806444432755e-11,
  4.021312758506979e-13, -1.288352582154703e-15, -9.509279070462671e-19,  3.012366222682803e-20, -1.384737950691502e-22,  9.852599078419694e-26,  2.486703019051660e-27,
  4.411773750167520e-01, -2.587079700490797e-03,  8.333721302276588e-06, -7.709228654548725e-09, -7.824640573022613e-11,  4.514336900438356e-13, -5.949938933355789e-16,
 -5.956476380828535e-18,  3.960228612887709e-20, -6.019531874244153e-23, -5.815498091064583e-25,  4.171863377249457e-27,  5.221336625082708e-01, -2.915219562418779e-03,
  8.118808221140934e-06,  6.092365388204685e-10, -1.114976332016801e-10,  4.003383347086217e-13,  5.016125311107158e-16, -9.890634246314885e-18,  2.947824061548004e-20,
  9.497433780519981e-23, -1.064677306361723e-24,  2.291797798738508e-27,  6.077602132115021e-01, -3.211227465509389e-03,  7.443800533760400e-06,  1.004484772719764e-08,
 -1.323300215757107e-10,  2.421776656553853e-13,  1.700906029983926e-15, -1.058521243792546e-17, -5.005297996767197e-22,  2.398257416883237e-22, -8.345330009653451e-25,
 -2.766102454430824e-27,  6.973585219295086e-01, -3.463995434747281e-03,  6.316219700309248e-06,  1.961591652618048e-08, -1.351496398170408e-10, -9.092013020042568e-16,
  2.599896146148272e-15, -6.919568827089953e-18, -3.840687003718262e-20,  2.664848989099200e-22,  1.626353217460417e-25, -7.010908344451146e-27,  7.901765580374478e-01,
 -3.663524294988329e-03,  4.778222653432895e-06,  2.822558512985805e-08, -1.171609235362916e-10, -2.797366207830053e-13,  2.830578705718746e-15,  3.743339247938998e-19,
 -6.446860530075622e-20,  1.237515616450401e-22,  1.312619481105896e-24, -5.882037129387904e-27,  8.854118129322022e-01, -3.801341614034951e-03,  2.905842534242514e-06,
  3.479920287029588e-08, -7.929351857912368e-11, -5.282455908273910e-13,  2.209323887193233e-15,  8.691461400355398e-18, -6.157494716869485e-20, -1.285680863496190e-22,
  1.695440317098004e-24,  1.023120349715938e-27,  9.822153105072011e-01, -3.870905523796849e-03,  8.054192861400141e-07,  3.843397203819473e-08, -2.645019471538947e-11,
 -6.803726334355905e-13,  8.385078788804037e-16,  1.450119489414793e-17, -2.648305368697898e-20, -3.386548860426281e-22,  8.373379170386289e-25,  8.325123467039654e-27,
  1.079696716554258e+00, -3.867975919364768e-03, -1.392863994313915e-06,  3.854059735214522e-08,  3.308256766239691e-11, -6.894172484399867e-13, -8.913007193336113e-16,
  1.495500626068803e-17,  2.560080074389591e-20, -3.581972970266886e-22, -7.639062934061162e-25,  9.107374860899066e-27,  1.176930670499250e+00, -3.790931887051758e-03,
 -3.544171754644599e-06,  3.495428720413573e-08,  8.905170235604514e-11, -5.440870051979124e-13, -2.417341919836524e-15,  9.409916762504519e-18,  6.755476841636726e-20,
 -1.544837585208515e-22, -1.902639297878614e-24,  1.830139472176818e-27,  1.272964440198271e+00, -3.641012346862981e-03, -5.500468034799522e-06,  2.799332311222583e-08,
  1.312700460614886e-10, -2.754286822859441e-13, -3.208525271967693e-15,  1.481186994962197e-20,  7.570444672357160e-20,  1.490605790060407e-22, -1.636156582968565e-24,
 -7.227992095966805e-27,  1.366826965993333e+00, -3.422456287488768e-03, -7.123442281960682e-06,  1.844832237216300e-08,  1.518593178791874e-10,  4.904173109392981e-14,
 -2.980993090690415e-15, -9.120526450562685e-18,  4.500103956588098e-20,  3.500479530225706e-22, -1.540202614990304e-25, -9.616357791739062e-27,  1.457539312704150e+00,
 -3.142520124964739e-03, -8.297813190486081e-06,  7.494460788108344e-09,  1.471729857225085e-10,  3.437804193746928e-13, -1.830167435413986e-15, -1.390808014437493e-17,
 -6.541305400536989e-21,  3.156556428845915e-22,  1.317308068770846e-24, -3.343577003910824e-27,  1.544126487434206e+00, -2.811353092836116e-03, -8.943669329932364e-06,
 -3.468400471896928e-09,  1.188637082645509e-10,  5.313514775205013e-13, -2.081488751441235e-16, -1.241633549652600e-17, -4.858434072827373e-20,  8.641429317647238e-23,
  1.594596165419605e-24,  4.936498104246739e-27,  1.625630507959710e+00, -2.441717506203196e-03, -9.026378231242744e-06, -1.302829507126007e-08,  7.370882092160981e-11,
  5.677142376802222e-13,  1.259803942877954e-15, -5.918690585576022e-18, -5.815258990016216e-20, -1.569255912005860e-22,  6.108657532719496e-25,  7.149846876165231e-27,
  1.701124523609847e+00, -2.048549333575756e-03, -8.562640472840198e-06, -1.999360958017499e-08,  2.210089132266732e-11,  4.572060610268361e-13,  2.046186963236680e-15,
  1.859077006787975e-18, -3.454723398667792e-20, -2.424063458153296e-22, -5.957102803980368e-25,  2.421178296560797e-27,  1.769727702352086e+00, -1.648365517704440e-03,
 -7.621521092760225e-06, -2.360352284383626e-08, -2.451225032821166e-11,  2.506124762705466e-13,  1.952420404629348e-15,  6.929677958336830e-18,  1.757339174511566e-21,
 -1.434874956007257e-22, -9.692509104784245e-25, -2.934085876736885e-27,  1.830620510669429e+00, -1.258537247268778e-03, -6.319767773320074e-06, -2.367303409620106e-08,
 -5.659964655954496e-11,  2.584388451455556e-14,  1.181319999008375e-15,  7.340189017625480e-18,  2.552408886298380e-20,  1.859679948083200e-23, -4.371340543207336e-25,
 -3.521247394113542e-27,  1.883059935320867e+00, -8.964617847762354e-04, -4.811393636066497e-06, -2.063728790811777e-08, -6.908865164136257e-11, -1.420192947948508e-13,
  2.079816428029552e-16,  4.091533416462313e-18,  2.538093564155610e-20,  1.021807870304879e-22,  2.214134436168796e-25, -5.619432897836602e-28,  1.926394140508052e+00,
 -5.786779845391232e-04, -3.272285881088817e-06, -1.547748833113651e-08, -6.267768834997592e-11, -2.093789819220214e-13, -4.846100276664636e-16,  9.498907514709387e-20,
  9.666151907917773e-21,  7.194749577936653e-23,  3.638463344109906e-25,  1.371616106946168e-27,  1.960076049338897e+00, -3.199804076999128e-04, -1.881381552287074e-06,
 -9.534961288993667e-09, -4.344303424299114e-11, -1.792211806641319e-13, -6.586502346639078e-16, -2.039141637450055e-18, -4.327590523644895e-21,  2.833420839834078e-24,
  1.028876943359726e-25,  7.700880844732121e-28,  1.983675559596219e+00, -1.325908981620088e-04, -8.005786930867792e-07, -4.245569822280778e-09, -2.078363360687771e-11,
 -9.577848344244768e-14, -4.185888117511909e-16, -1.735461858419205e-18, -6.784538717319823e-21, -2.463423682082422e-23, -8.029893517071514e-26, -2.145509280499923e-28,
  1.996893324935821e+00, -2.542055606652188e-05, -1.557483174675229e-07, -8.463635008693069e-10, -4.299989479367936e-12, -2.090281612440501e-14, -9.840135684720525e-17,
 -4.517054586541592e-19, -2.030378206465880e-21, -8.959197273028969e-24, -3.886625631287140e-26, -1.658767932494727e-28,  1.036391987271170e-03, -7.506736169606778e-06,
  4.075924122055804e-08, -1.965986073461677e-10,  8.882863604955401e-13, -3.849319845224037e-15,  1.619882976081790e-17, -6.669117740957064e-20,  2.698771371674719e-22,
 -1.076846479833748e-24,  4.245873110601935e-27, -1.656862090624554e-29,  9.317986866036430e-03, -6.724820088754556e-05,  3.624363756036419e-07, -1.726308232398591e-09,
  7.651613167571432e-12, -3.226167573417063e-14,  1.307789164512536e-16, -5.123556047603505e-19,  1.943632888759254e-21, -7.135945147326423e-24,  2.527976203146630e-26,
 -8.588092193000529e-29,  2.583024473089623e-02, -1.850706581224278e-04,  9.825948440723998e-07, -4.561047851651975e-09,  1.941874260529853e-11, -7.713627660795034e-14,
  2.868337044282666e-16, -9.916996266799974e-19,  3.122275324843871e-21, -8.494599930148294e-24,  1.679210483383217e-26,  9.585885910629416e-31,  5.047108076609111e-02,
 -3.576810896111616e-04,  1.856054720022977e-06, -8.275422258043181e-09,  3.299435200143720e-11, -1.180148062969989e-13,  3.690500550005978e-16, -9.246212414235097e-19,
  1.204029105727904e-21,  5.032636628650062e-24, -5.369515401188984e-26,  3.065156429865327e-28,  8.308682420667245e-02, -5.802103321655641e-04,  2.918045322916297e-06,
 -1.228941936847626e-08,  4.434806433101014e-11, -1.320160709086669e-13,  2.711316390660252e-16,  6.572228346057235e-20, -4.484024842971012e-21,  2.981746263877386e-23,
 -1.358632646860792e-25,  4.658385931088097e-28,  1.234715917638154e-01, -8.462990125339797e-04,  4.087718125405713e-06, -1.593302653838362e-08,  4.940330023156238e-11,
 -1.011123238340135e-13, -5.080603352538712e-17,  1.839823856944529e-18, -1.131289544827803e-20,  4.541965857667355e-23, -1.154145803628224e-25, -3.987719455308787e-30,
  1.713664961062860e-01, -1.148214503569313e-03,  5.272680596353551e-06, -1.852405558314614e-08,  4.489213233265125e-11, -1.876368220859740e-14, -5.430819284090637e-16,
  3.664003808481998e-18, -1.415750885419699e-20,  2.744441703203147e-23,  7.580241461783842e-26, -1.010855443905046e-27,  2.264587292509320e-01, -1.477000689251831e-03,
  6.374410046626133e-06, -1.945234884075455e-08,  2.913426932360392e-11,  1.059326892776174e-13, -1.053739931943497e-15,  4.453882640070333e-18, -8.353980686489962e-21,
 -3.035241073784591e-23,  3.471772949322559e-25, -1.594201581019506e-27,  2.883805733588261e-01, -1.822662441087298e-03,  7.294357301256406e-06, -1.826230282201301e-08,
  2.596038976453686e-12,  2.480160490763295e-13, -1.372311151321219e-15,  3.280226526634431e-18,  6.648376555770502e-21, -1.010892742564020e-22,  4.578522085757021e-25,
 -6.413168136362664e-28,  3.567084057128306e-01, -2.174386572498033e-03,  7.940493831521186e-06, -1.472484054477157e-08, -3.189625673152644e-11,  3.709956553235984e-13,
 -1.302225984952794e-15, -6.577004486394999e-20,  2.523393345002424e-20, -1.325607297913526e-22,  1.919263768875145e-25,  1.772950634403469e-27,  4.309617807056201e-01,
 -2.520800575203098e-03,  8.233994187656283e-06, -8.889771784300457e-09, -6.937330871785539e-11,  4.352935083319689e-13, -7.443891446829884e-16, -4.728012581625578e-18,
  3.705980165930753e-20, -7.989515779225984e-23, -4.063810948438925e-25,  3.769358147728764e-27,  5.106026894840904e-01, -2.850269568347639e-03,  8.115681376355558e-06,
 -1.110109559599822e-09, -1.033923482167601e-10,  4.091632461472371e-13,  2.383376285000168e-16, -8.900635135852414e-18,  3.215689137055730e-20,  5.460188953697294e-23,
 -9.495820007292276e-25,  2.891327258497827e-27,  5.950351172545700e-01, -3.151230520294225e-03,  7.551801771099293e-06,  7.968433086030120e-09, -1.271022344347661e-10,
  2.794487108816597e-13,  1.405546594829440e-15, -1.046974501871116e-17,  7.506855031371424e-21,  2.044316205916467e-22, -9.249911032781891e-25, -1.369278051815255e-27,
  6.836050386434325e-01, -3.412560853546046e-03,  6.538646529331212e-06,  1.745669882242815e-08, -1.345602223656262e-10,  5.903334640705641e-14,  2.390389685749695e-15,
 -7.994426530538987e-18, -2.876840230087363e-20,  2.670727741932241e-22, -1.264944203023185e-25, -6.086379037105905e-27,  7.756010120442419e-01, -3.623975954663983e-03,
  5.105509556289357e-06,  2.630994299434745e-08, -1.220766541160958e-10, -2.119056082002419e-13,  2.812917097284133e-15, -1.607769673943430e-18, -5.913327703919499e-20,
  1.708191577724251e-22,  1.035201315179755e-24, -6.645369275281561e-27,  8.702555532127724e-01, -3.776446863681848e-03,  3.315481697325553e-06,  3.344894692357605e-08,
 -8.930964757984182e-11, -4.725279487748156e-13,  2.424497058273351e-15,  6.660146450820083e-18, -6.497764354512118e-20, -6.048637548418417e-23,  1.693173207652279e-24,
 -1.098746074760643e-27,  9.667474845919006e-01, -3.862625559687529e-03,  1.263642600572503e-06,  3.790313890230646e-08, -3.982405860404678e-11, -6.554828221805166e-13,
  1.230894247573348e-15,  1.346582871253738e-17, -3.798715712583740e-20, -2.982473945492615e-22,  1.171986438653330e-24,  6.810128461443541e-27,  1.064205467451760e+00,
 -3.877260938940228e-03, -9.276592871487763e-07,  3.895859330149444e-08,  1.911465563685886e-11, -7.057031172790535e-13, -4.630673657392996e-16,  1.556281456178577e-17,
  1.225492475624985e-20, -3.804553360955964e-22, -3.431173645936777e-25,  9.913310265443873e-27,  1.161712925809065e+00, -3.817584080269689e-03, -3.116540397848078e-06,
  3.628900221345850e-08,  7.761238064220351e-11, -5.987028603578916e-13, -2.124539367686772e-15,  1.146820092918239e-17,  6.064971634371739e-20, -2.282262994012890e-22,
 -1.765959292330688e-24,  4.370727323498133e-27,  1.258314560636341e+00, -3.683637151992775e-03, -5.152141556401349e-06,  3.004539646807403e-08,  1.249928940564356e-10,
 -3.521500729034976e-13, -3.173481758428984e-15,  2.509986595822862e-18,  7.982006894818683e-20,  7.771500596071209e-23, -1.918587589727350e-24, -5.508173810106319e-27,
  1.353024626219300e+00, -3.478516951666334e-03, -6.887464373021942e-06,  2.088194716892894e-08,  1.521049189742479e-10, -2.539229556654458e-14, -3.214326268636108e-15,
 -7.480900698103865e-18,  5.738713327224287e-20,  3.351286051864460e-22, -5.982842277158416e-25, -1.048387786639199e-26,  1.444837093955291e+00, -3.208502358936225e-03,
 -8.193532252450727e-06,  9.901714195936012e-09,  1.535777340115246e-10,  2.951704883163164e-13, -2.220745218226618e-15, -1.392574321986460e-17,  5.729081399517781e-21,
  3.647197972683964e-22,  1.118643528436542e-24, -5.710253663411229e-27,  1.532737759460688e+00, -2.883035794478311e-03, -8.973529737340618e-06, -1.481957652396100e-09,
  1.294117277255801e-10,  5.220116596100528e-13, -5.770142408642611e-16, -1.390854287591610e-17, -4.427579360224376e-20,  1.542240816470283e-22,  1.786984045859080e-24,
  3.712479592858750e-27,  1.615718255187743e+00, -2.514532968113901e-03, -9.175261875687127e-06, -1.175653706832523e-08,  8.535092678877730e-11,  5.957455367105547e-13,
  1.067216240088597e-15, -7.864613324602467e-18, -6.328354306107016e-20, -1.259026749356581e-22,  9.471964209903240e-25,  8.097099472157360e-27,  1.692791813938567e+00,
 -2.118003426809002e-03, -8.800131660421913e-06, -1.956415877537505e-08,  3.173963338440301e-11,  5.068060530278572e-13,  2.081420600773513e-15,  6.095747647022987e-19,
 -4.367314990862720e-20, -2.636663228159607e-22, -4.559480274122925e-25,  3.977834323724161e-27,  1.763010493186807e+00, -1.710476925075478e-03, -7.906942711268438e-06,
 -2.395300887561829e-08, -1.901569180325897e-11,  2.998002456498052e-13,  2.146407331880417e-15,  6.895533240503006e-18, -4.136497758348171e-21, -1.847601660734796e-22,
 -1.091906793892269e-24, -2.592808402707186e-27,  1.825483424575955e+00, -1.310247040551279e-03, -6.609255506739691e-06, -2.457288143258151e-08, -5.578212536584642e-11,
  5.675465331762024e-14,  1.398354851177735e-15,  8.163981072877723e-18,  2.583954375255827e-20, -2.202562126731154e-24, -6.082460596672944e-25, -4.263751818839107e-27,
  1.879395510637518e+00, -9.359625297046695e-04, -5.065766345241573e-06, -2.176511756678574e-08, -7.186935338457144e-11, -1.355577439706197e-13,  3.344801063165333e-16,
  4.964232199171346e-18,  2.921163650491720e-20,  1.104015480710679e-22,  1.858463161375494e-25, -1.081244349175697e-27,  1.924025871213694e+00, -6.056165617134750e-04,
 -3.464173032211302e-06, -1.651446234852348e-08, -6.698116778766708e-11, -2.209402567931133e-13, -4.772097946991361e-16,  4.486773029879383e-19,  1.253318053265434e-20,
  8.775261700934695e-23,  4.274757524555569e-25,  1.517703184322585e-27,  1.958765283897770e+00, -3.355012328591910e-04, -2.000092740876820e-06, -1.025960379835861e-08,
 -4.719023905097682e-11, -1.957294620957413e-13, -7.176635616070374e-16, -2.175128196517302e-18, -4.142772488587420e-21,  7.689898840666573e-24,  1.415952902668773e-25,
  9.980511715328383e-28,  1.983132055903750e+00, -1.392051174199475e-04, -8.535857879273170e-07, -4.593995330839412e-09, -2.280373096697461e-11, -1.064331050591045e-13,
 -4.703590654391751e-16, -1.967395036376651e-18, -7.731498593220270e-21, -2.803900204422479e-23, -9.003009190505263e-26, -2.269659893619430e-28,  1.996789084720688e+00,
 -2.670837027927846e-05, -1.663317020502305e-07, -9.186405347374915e-10, -4.742725844071711e-12, -2.342387268126698e-14, -1.120094311789707e-16, -5.221529942536033e-19,
 -2.382745687893573e-21, -1.067022143503742e-23, -4.695650761712060e-26, -2.031906121574189e-28,  1.007002582515153e-03, -7.189863075916897e-06,  3.848285960228624e-08,
 -1.829814112698531e-10,  8.150413227609299e-13, -3.482014973506955e-15,  1.444677954978323e-17, -5.864396806752042e-20,  2.339999141269988e-22, -9.207307091062246e-25,
  3.580215424356056e-27, -1.377957846973365e-29,  9.054664720004048e-03, -6.442953939259090e-05,  3.424344783536000e-07, -1.608878508281071e-09,  7.036639910488613e-12,
 -2.928833561746335e-14,  1.172664370280792e-16, -4.540816605504838e-19,  1.704064080532536e-21, -6.196571907847583e-24,  2.177840545140236e-26, -7.358729552378883e-29,
  2.510534428149592e-02, -1.774236626318837e-04,  9.296767454707680e-07, -4.262324984504804e-09,  1.794266515434158e-11, -7.057446655997544e-14,  2.604198451772483e-16,
 -8.965501881450106e-19,  2.828540153596587e-21, -7.825314597255315e-24,  1.659919857382139e-26, -9.077912682846678e-30,  4.906943678829032e-02, -3.432210739549091e-04,
  1.759840755955581e-06, -7.765922475817448e-09,  3.072055400707393e-11, -1.094637707271241e-13,  3.437244938009514e-16, -8.835827762211635e-19,  1.349624686317342e-21,
  3.136158319927228e-24, -4.156312938568222e-26,  2.468464024253612e-28,  8.081175437529729e-02, -5.574439974038586e-04,  2.774743720357929e-06, -1.160061900856289e-08,
  4.177288384239081e-11, -1.255020877922589e-13,  2.711171420099181e-16, -6.160129394571879e-20, -3.503610167269383e-21,  2.477834310390490e-23, -1.164531479001237e-25,
  4.163921616515709e-28,  1.201506070614676e-01, -8.143487691440398e-04,  3.901197621156327e-06, -1.515880115937223e-08,  4.737282790725989e-11, -1.017529162457462e-13,
 -4.119677643332567e-18,  1.503083250528098e-18, -9.760677554839318e-21,  4.082665410508881e-23, -1.136247328956787e-25,  8.002089914591084e-29,  1.668566103487135e-01,
 -1.106910035758792e-03,  5.054686989168195e-06, -1.780945786164618e-08,  4.439456835421110e-11, -3.061680500251789e-14, -4.466801667008408e-16,  3.227274080428942e-18,
 -1.312498907252749e-20,  2.965911173679019e-23,  3.664557609575377e-26, -7.755955512810975e-28,  2.206512500650158e-01, -1.426931044803260e-03,  6.143844329489320e-06,
 -1.897058353269348e-08,  3.100996686588860e-11,  8.210831031910319e-14, -9.329197409430856e-16,  4.171618072809858e-18, -9.213177100738242e-21, -1.782092389165398e-23,
  2.806068718795520e-25, -1.428367056604290e-27,  2.812052468557313e-01, -1.765183101575280e-03,  7.075616867359018e-06, -1.818284150584027e-08,  7.234555266512537e-12,
  2.162035403735230e-13, -1.278008572811235e-15,  3.438222087596472e-18,  3.331341898428387e-21, -8.341196443847890e-23,  4.244201505063969e-25, -8.604244486428233e-28,
  3.481367767176807e-01, -2.111577537089542e-03,  7.760973062986541e-06, -1.517751849074291e-08, -2.478857396342476e-11,  3.398070258909818e-13, -1.293468771945981e-15,
  6.669836133490960e-19,  2.061699471957137e-20, -1.235131562264665e-22,  2.559374926808255e-25,  1.153205201320490e-27,  4.210096209139271e-01, -2.455373545161591e-03,
  8.120941120765932e-06, -9.931111080688928e-09, -6.085613416564601e-11,  4.159708029565867e-13, -8.606236277852535e-16, -3.590939785632549e-18,  3.392966886475500e-20,
 -9.297536398460052e-23, -2.512753986182038e-25,  3.269587957283126e-27,  4.993313388637372e-01, -2.785424901779150e-03,  8.092705224250521e-06, -2.698692840727664e-09,
 -9.517146118236454e-11,  4.120105756270498e-13,  3.770849521128700e-18, -7.847238673130106e-18,  3.347059077587007e-20,  1.927684886501695e-23, -8.143212237617340e-25,
  3.214499165825028e-27,  5.825515813698018e-01, -3.090467756967800e-03,  7.635411255825504e-06,  5.981242862528978e-09, -1.211995062091935e-10,  3.096976820304837e-13,
  1.116811707017561e-15, -1.011900914658766e-17,  1.418931330187860e-20,  1.666013332580243e-22, -9.576151515891000e-25, -1.468996003567498e-28,  6.700606887550465e-01,
 -3.359450250551390e-03,  6.735257980658942e-06,  1.531621980298550e-08, -1.328244933651718e-10,  1.136213813841289e-13,  2.155092994002433e-15, -8.762662716898643e-18,
 -1.930647404768676e-20,  2.569806266046915e-22, -3.698027998763437e-25, -4.947198259028395e-27,  7.611887486619686e-01, -3.581902504156703e-03,  5.409381486568996e-06,
  2.432646059759191e-08, -1.256443925743722e-10, -1.451436808598487e-13,  2.742385938489155e-15, -3.394230430747984e-18, -5.231001872786723e-20,  2.062643126686854e-22,
  7.350710255325345e-25, -6.918687595902143e-27,  8.552053203695552e-01, -3.748342450279656e-03,  3.707993869890877e-06,  3.194760879086534e-08, -9.816444319687401e-11,
 -4.123387170062504e-13,  2.581636294857526e-15,  4.558963541197997e-18, -6.595300523794144e-20,  5.697151464458343e-24,  1.602260854564991e-24, -2.983676986919945e-27,
  9.513200646811898e-01, -3.850708885639352e-03,  1.714230082462238e-06,  3.716280739882214e-08, -5.260851070897297e-11, -6.215637868432577e-13,  1.589372836070041e-15,
  1.208805136316129e-17, -4.781286386329231e-20, -2.459118885735393e-22,  1.430923609288801e-24,  4.909088958146793e-27,  1.048684547922252e+00, -3.882808077426225e-03,
 -4.587884742597772e-07,  3.915106024549014e-08,  4.924928626936551e-12, -7.115560434749145e-13, -2.389128716095330e-17,  1.573404054447968e-17, -1.582481776359598e-21,
 -3.853660994749194e-22,  9.858404469173084e-26,  1.005112595581354e-26,  1.146395511387149e+00, -3.840754348248432e-03, -2.674025393099667e-06,  3.743235046771115e-08,
  6.515554333009228e-11, -6.456272493205855e-13, -1.777588636580580e-15,  1.326431962994478e-17,  5.121497325652632e-20, -2.943029084160908e-22, -1.520637463662390e-24,
  6.733622389144090e-27,  1.243499908471464e+00, -3.723378669360362e-03, -4.779843226938283e-06,  3.198482965676534e-08,  1.171954503089320e-10, -4.271796057293049e-13,
 -3.067130311606454e-15,  5.093744408597474e-18,  8.118373871946658e-20, -3.239831778363327e-24, -2.112480807008754e-24, -3.221125743572244e-27,  1.339002004333338e+00,
 -3.532573026814425e-03, -6.622309456300445e-06,  2.330730427994010e-08,  1.508097871579882e-10, -1.048312366848710e-13, -3.396306532602344e-15, -5.457007403203683e-18,
  6.890866631763156e-20,  3.018536789752373e-22, -1.067119960077816e-24, -1.070954783506501e-26,  1.431872800074657e+00, -3.273533132341909e-03, -8.059783148534109e-06,
  1.240315732442237e-08,  1.589167409702707e-10,  2.372266975505992e-13, -2.606067022983591e-15, -1.352423232865303e-17,  1.959735535341817e-20,  4.037256237416793e-22,
  8.139984925827191e-25, -8.130189557675200e-27,  1.521061977911437e+00, -2.954859178453981e-03, -8.978547981490219e-06,  6.712642110475794e-10,  1.396811290886073e-10,
  5.033355768753323e-13, -9.853542695094361e-16, -1.522244878420334e-17, -3.740213416867750e-20,  2.284782632444698e-22,  1.912455546140876e-24,  1.890588256949566e-27,
  1.605512459608005e+00, -2.588475247260532e-03, -9.307749146156321e-06, -1.029429034287648e-08,  9.750293307125784e-11,  6.184834740144322e-13,  8.180308899663873e-16,
 -9.954184201211307e-18, -6.704621668669369e-20, -8.067732726605475e-23,  1.318616690414603e-24,  8.718543984528213e-27,  1.684177524474589e+00, -2.189334138537442e-03,
 -9.031511268236691e-06, -1.897251865181190e-08,  4.237582409343023e-11,  5.567981550548857e-13,  2.077473198472101e-15, -9.429847677168830e-19, -5.344655774617547e-20,
 -2.778861316607389e-22, -2.417989906606581e-25,  5.795121958877130e-27,  1.756040247296526e+00, -1.774886909254555e-03, -8.195997211061294e-06, -2.420642769534255e-08,
 -1.248901455897291e-11,  3.536095106219892e-13,  2.336567846076581e-15,  6.648100584393204e-18, -1.160001034748288e-20, -2.305459420493437e-22, -1.192452495496292e-24,
 -1.914549496663535e-27,  1.820134799495455e+00, -1.364315657145443e-03, -6.909441586841067e-06, -2.545441183972129e-08, -5.429242928905413e-11,  9.315145269532205e-14,
  1.638474847181303e-15,  8.984501722332798e-18,  2.527505322098839e-20, -3.050955394706275e-23, -8.126774715341224e-25, -5.028132354747197e-27,  1.875568926242616e+00,
 -9.775531375454710e-04, -5.333935135426969e-06, -2.293623109051773e-08, -7.448841249013951e-11, -1.257528889386259e-13,  4.871725496444266e-16,  5.963926358923013e-18,
  3.330671997841030e-20,  1.166927469170385e-22,  1.236377414699157e-25, -1.778736462150967e-27,  1.921546696930591e+00, -6.341411988889930e-04, -3.668924595087095e-06,
 -1.762212863045192e-08, -7.151323862700444e-11, -2.321941760444731e-13, -4.585327520207172e-16,  9.037176165451756e-19,  1.601649756294531e-20,  1.062247898118738e-22,
  4.969964511481337e-25,  1.635858789451235e-27,  1.957390479231512e+00, -3.520075752062639e-04, -2.127870519482153e-06, -1.104692114344952e-08, -5.128207692365126e-11,
 -2.136989138228708e-13, -7.803731816481437e-16, -2.302083841091905e-18, -3.752686871240461e-21,  1.431165684115905e-23,  1.915772621201393e-25,  1.284470753585667e-27,
  1.982561219942758e+00, -1.462606839723431e-04, -9.109751751295127e-07, -4.976516916115345e-09, -2.504988983198852e-11, -1.184116824856815e-13, -5.290666540476406e-16,
 -2.231668171771795e-18, -8.808153159173315e-21, -3.184224992784791e-23, -1.001750158124591e-25, -2.327612495577850e-28,  1.996679518246283e+00, -2.808444524133248e-05,
 -1.778266369975025e-07, -9.984231587545881e-10, -5.239315887724273e-12, -2.629652678557148e-14, -1.277576218128700e-16, -6.049276552269228e-19, -2.802953365395183e-21,
 -1.274020979791527e-23, -5.688042447102299e-26, -2.495684402536541e-28,  9.788452555266440e-04, -6.890566788580667e-06,  3.636308803770986e-08, -1.704795773511410e-10,
  7.487394923934538e-13, -3.154180161477232e-15,  1.290478780910172e-17, -5.165981540450011e-20,  2.032917418037685e-22, -7.889411443669407e-25,  3.025937682774693e-27,
 -1.148863745324670e-29,  8.802305883922439e-03, -6.176541931391328e-05,  3.237846071672103e-07, -1.500829702557921e-09,  6.478018278083185e-12, -2.662055093597153e-14,
  1.052831983560359e-16, -4.029588445197238e-19,  1.495917116703926e-21, -5.386977288876573e-24,  1.877788779338906e-26, -6.307132063423292e-29,  2.441020727347769e-02,
 -1.701860649710027e-04,  8.802058394917474e-07, -3.986203023639881e-09,  1.659169498194203e-11, -6.461565887934982e-14,  2.365421837264173e-16, -8.104170537899481e-19,
  2.558663879425079e-21, -7.171500622060792e-24,  1.604329332997808e-26, -1.571091622651640e-29,  4.772413131540289e-02, -3.295069197097121e-04,  1.669528042464336e-06,
 -7.291467920960104e-09,  2.861179412964641e-11, -1.015062930875119e-13,  3.196036116854462e-16, -8.388889021953821e-19,  1.435079322638312e-21,  1.675715163928657e-24,
 -3.181594873441441e-26,  1.978142083935800e-28,  7.862550843033289e-02, -5.357917035990716e-04,  2.639464800796256e-06, -1.095198046850646e-08,  3.932770839679170e-11,
 -1.190278505170222e-13,  2.679505825374194e-16, -1.603085418985611e-19, -2.691152324022073e-21,  2.047220394839774e-23, -9.920812223366030e-26,  3.677712863832985e-28,
  1.169544970652346e-01, -7.838540798520607e-04,  3.723772662003656e-06, -1.441710806006738e-08,  4.534001309430322e-11, -1.013807202589739e-13,  3.380861523406317e-17,
  1.213388549355903e-18, -8.371710489548657e-21,  3.637025435500253e-23, -1.087912736791956e-25,  1.355955445109832e-28,  1.625085086602806e-01, -1.067315368672922e-03,
  4.845213361442244e-06, -1.710459604520519e-08,  4.368210741024351e-11, -4.029922976209336e-14, -3.620343239406323e-16,  2.824577908819232e-18, -1.203854439329679e-20,
  3.050296742999263e-23,  6.978132737916669e-27, -5.790769767141759e-28,  2.150403976933798e-01, -1.378682326370283e-03,  5.919224641802142e-06, -1.846246415295386e-08,
  3.243751914527585e-11,  6.108606702847748e-14, -8.203236372323080e-16,  3.868578015260156e-18, -9.667366361872347e-21, -7.801506372252316e-24,  2.216656430758361e-25,
 -1.249848829188828e-27,  2.742563456212547e-01, -1.709448657264299e-03,  6.858254672504448e-06, -1.803412966409547e-08,  1.125975280679443e-11,  1.866959640239766e-13,
 -1.180674420750350e-15,  3.499979558148568e-18,  6.245740328222580e-22, -6.723452931958764e-23,  3.835652684210782e-25, -9.824672954061483e-28,  3.398134797953267e-01,
 -2.050224510380120e-03,  7.576681967487102e-06, -1.552144559425536e-08, -1.830098511160363e-11,  3.090583972875588e-13, -1.266210656573153e-15,  1.257649250444766e-18,
  1.636555731381341e-20, -1.124205165305090e-22,  2.949304525289335e-25,  6.363962729263728e-28,  4.113172844822399e-01, -2.390898637572309e-03,  7.996196416191931e-06,
 -1.083940817072941e-08, -5.275079130563652e-11,  3.942288145114052e-13, -9.464848795404665e-16, -2.560412086838937e-18,  3.043486920653462e-20, -1.003075698608502e-22,
 -1.192999053589385e-25,  2.725860909728973e-27,  4.883188817189794e-01, -2.720838057952947e-03,  8.051456193929225e-06, -4.155582132546866e-09, -8.694751478013238e-11,
  4.095858568478892e-13, -2.008958861027763e-16, -6.771083416863491e-18,  3.361273921017338e-20, -1.042567300314123e-23, -6.701630694504060e-25,  3.303396572675066e-27,
  5.703122855878453e-01, -3.029129853801655e-03,  7.695759874618706e-06,  4.092963373282700e-09, -1.147601799475504e-10,  3.331577620403854e-13,  8.406852231497541e-16,
 -9.576375179335402e-18,  1.949879281604583e-20,  1.284796459263345e-22, -9.411587092035721e-25,  8.565390362855167e-28,  6.567317651588168e-01, -3.304868945874206e-03,
  6.906385329435040e-06,  1.321193300326809e-08, -1.300550420675352e-10,  1.623379823466481e-13,  1.902457202477505e-15, -9.235708148791385e-18, -1.037060544152192e-20,
  2.381965927608670e-22, -5.603445094403703e-25, -3.705633777449450e-27,  7.469494890508728e-01, -3.537494154989083e-03,  5.689152844774469e-06,  2.229646777231757e-08,
 -1.278977394437248e-10, -8.064898346406650e-14,  2.625065912351231e-15, -4.944262849312861e-18, -4.442848532731690e-20,  2.295992964576144e-22,  4.329423198067463e-25,
 -6.746319751996694e-27,  8.402736679949432e-01, -3.717172319512274e-03,  4.081680258385795e-06,  3.031440907613183e-08, -1.057825152339771e-10, -3.490854954022888e-13,
  2.679857717436311e-15,  2.463832369791593e-18, -6.463033344806083e-20,  6.668259738654025e-23,  1.435855157013551e-24, -4.514235035772478e-27,  9.359474597636751e-01,
 -3.835226470492869e-03,  2.154730142357450e-06,  3.622380543069468e-08, -6.463184803331817e-11, -5.795379201133795e-13,  1.905168261876162e-15,  1.042782714765134e-17,
 -5.558894524722543e-20, -1.849694463947387e-22,  1.600721833607739e-24,  2.786960296881411e-27,  1.033148950943403e+00, -3.884598875772860e-03,  1.102772259741773e-08,
  3.911612850371303e-08, -9.276325149855800e-12, -7.068612892839360e-13,  4.138777045081578e-16,  1.546305067363587e-17, -1.527902026242037e-20, -3.726884300787344e-22,
  5.313627595306523e-25,  9.511489271079915e-27,  1.130992578154203e+00, -3.860333072036135e-03, -2.219015525075946e-06,  3.836935030430812e-08,  5.184737463034491e-11,
 -6.836575662115112e-13, -1.384916300164585e-15,  1.472255806824115e-17,  3.960229130560550e-20, -3.485855205465390e-22, -1.179043691838219e-24,  8.714692602715411e-27,
  1.228532391264017e+00, -3.760050941225409e-03, -4.385069256727815e-06,  3.378766235364791e-08,  1.079288140931329e-10, -4.987863715416880e-13, -2.888270339326925e-15,
  7.673218145654340e-18,  7.951896321841573e-20, -8.979946500199084e-23, -2.195698481785093e-24, -5.054034351423246e-28,  1.324767584294244e+00, -3.584391919953548e-03,
 -6.328227730870575e-06,  2.569901175060917e-08,  1.478870015913212e-10, -1.879172506320052e-13, -3.516662075580168e-15, -3.087217375284970e-18,  7.889431357117931e-20,
  2.498441538011989e-22, -1.529453860282043e-24, -1.017274039105853e-26,  1.418650715125716e+00, -3.337372482752512e-03, -7.895544040258319e-06,  1.498025583844111e-08,
  1.630055698606957e-10,  1.702214470808911e-13, -2.973740403882364e-15, -1.265902802294908e-17,  3.462506800721772e-20,  4.284449549093417e-22,  4.054314670941700e-25,
 -1.039685313968811e-26,  1.509098990080831e+00, -3.026616592363507e-03, -8.956755784821724e-06,  2.985263818393537e-09,  1.494761663008782e-10,  4.744452167633242e-13,
 -1.426996455142524e-15, -1.627282599589922e-17, -2.778592331773226e-20,  3.059705107887162e-22,  1.944540837852662e-24, -5.270281649718993e-28,  1.595008890955261e+00,
 -2.663403899031505e-03, -9.421508963736396e-06, -8.634318501853179e-09,  1.100450909132349e-10,  6.345268693482071e-13,  5.089173523435880e-16, -1.213519767951566e-17,
 -6.890795023161705e-20, -2.018085465984943e-23,  1.707162593180865e-24,  8.846968164030795e-27,  1.675274259238969e+00, -2.262484519480024e-03, -9.254737184074897e-06,
 -1.820272130962431e-08,  5.400720383672258e-11,  6.061381088261431e-13,  2.025611397001043e-15, -2.814670405367270e-18, -6.355783084788129e-20, -2.818771131888693e-22,
  5.691692905570351e-26,  7.807069862948595e-27,  1.748807719953793e+00, -1.841619634891723e-03, -8.487429865970653e-06, -2.434656508832223e-08, -4.841220706200105e-12,
  4.118709533049319e-13,  2.516203637926076e-15,  6.134752076725841e-18, -2.077593951273911e-20, -2.796376693154185e-22, -1.254097731253648e-24, -8.097979283560308e-28,
  1.814565030622578e+00, -1.420827613246608e-03, -7.220037963622777e-06, -2.630596274324972e-08, -5.201532224046669e-11,  1.355837860639566e-13,  1.901151700329870e-15,
  9.769010097149629e-18,  2.353625775197260e-20, -6.766080109466480e-23, -1.050195337242700e-24, -5.755886539767558e-27,  1.871571598726699e+00, -1.021346005295641e-03,
 -5.616401574743228e-06, -2.414747188619017e-08, -7.687238365286495e-11, -1.119325196585944e-13,  6.697212857204152e-16,  7.097743077872938e-18,  3.757555515314110e-20,
  1.198214372666830e-22,  2.616240645337334e-26, -2.690189901892213e-27,  1.918950062128500e+00, -6.643582661975884e-04, -3.887410568441903e-06, -1.880407975137242e-08,
 -7.626480555535554e-11, -2.428337231674295e-13, -4.254502015889439e-16,  1.481410137110011e-18,  2.021599983629994e-20,  1.275680840644512e-22,  5.706390960060494e-25,
  1.699915070108466e-27,  1.955947543307336e+00, -3.695750718453749e-04, -2.265501050622771e-06, -1.190266596040313e-08, -5.574863379818836e-11, -2.332144082845202e-13,
 -8.464240649036827e-16, -2.412330928975268e-18, -3.085014224698154e-21,  2.320464237192924e-23,  2.556724486484733e-25,  1.641730083237109e-27,  1.981961213526549e+00,
 -1.537943563312500e-04, -9.731786134944937e-07, -5.396972757886138e-09, -2.755033010587168e-11, -1.318920603159456e-13, -5.956773753343567e-16, -2.532663576775898e-18,
 -1.002906496012453e-20, -3.605352512138917e-23, -1.103512933390910e-25, -2.275186957402531e-28,  1.996564257292970e+00, -2.955644882528872e-05, -1.903286007701590e-07,
 -1.086632200028717e-09, -5.797334467482333e-12, -2.957654091955218e-14, -1.460235290118631e-16, -7.024220655130088e-19, -3.305346175959688e-21, -1.525113792570782e-23,
 -6.908660228538086e-26, -3.073670189883343e-28,  9.518521226628395e-04, -6.607646134263474e-06,  3.438718353902778e-08, -1.589880653595530e-10,  6.886395644937669e-13,
 -2.861113281076725e-15,  1.154527892388335e-17, -4.558650293190106e-20,  1.769520567883092e-22, -6.774317551555568e-25,  2.563264848842935e-27, -9.601898870660184e-30,
  8.560313132636322e-03, -5.924545985126292e-05,  3.063794053914229e-07, -1.401307150062518e-09,  5.969988530056284e-12, -2.422391325176991e-14,  9.464237017331258e-17,
 -3.580526920318680e-19,  1.314862420150990e-21, -4.688615733001424e-24,  1.620563734652686e-26, -5.408193937229326e-29,  2.374324959979532e-02, -1.633313393086224e-04,
  8.339225380592176e-07, -3.730773510067701e-09,  1.535436072259579e-11, -5.920192863120119e-14,  2.149588502452100e-16, -7.325481771477391e-19,  2.311861654181531e-21,
 -6.544965974164278e-24,  1.525343773881520e-26, -1.984086789804202e-29,  4.643227272055474e-02, -3.164930550433518e-04,  1.584711493906435e-06, -6.849511350901067e-09,
  2.665649755930591e-11, -9.411243646430854e-14,  2.967650506665903e-16, -7.922305001484724e-19,  1.474481243944738e-21,  5.647561429899045e-25, -2.402389093828264e-26,
  1.577143739816513e-28,  7.652375556839147e-02, -5.151911617790198e-04,  2.511739064049290e-06, -1.034143387543538e-08,  3.701104844676316e-11, -1.126599770394813e-13,
  2.623618215168820e-16, -2.353684915555677e-19, -2.021808995564149e-21,  1.681371986849069e-23, -8.405212767454540e-26,  3.216474372720797e-28,  1.138775826160320e-01,
 -7.547437410164306e-04,  3.555053268356929e-06, -1.370783365733541e-08,  4.332311329697672e-11, -1.001907069507757e-13,  6.422388736522495e-17,  9.656155886796121e-19,
 -7.139167255590966e-21,  3.214928646824354e-23, -1.020104524093777e-25,  1.695507268865897e-28,  1.583154873395375e-01, -1.029362865049957e-03,  4.644123636102505e-06,
 -1.641257617635572e-08,  4.279542005251568e-11, -4.808151133675169e-14, -2.881742179413322e-16,  2.456921262049840e-18, -1.094109560340466e-20,  3.032234798947865e-23,
 -1.483670526576388e-26, -4.180422799474510e-28,  2.096189854047811e-01, -1.332205818428680e-03,  5.700826024671222e-06, -1.793472358072881e-08,  3.347095519728449e-11,
  4.266298381861072e-14, -7.163650616337680e-16,  3.556335488252644e-18, -9.801392353049470e-21,  1.818280787554135e-26,  1.706216955883365e-25, -1.071096697000169e-27,
  2.675269171585885e-01, -1.655444921514693e-03,  6.643044376051096e-06, -1.782560853156917e-08,  1.471825074016087e-11,  1.595358967781893e-13, -1.082738441583102e-15,
  3.484114202036287e-18, -1.530297686774227e-21, -5.277502909749701e-23,  3.390710794988661e-25, -1.029276330824292e-27,  3.317326226137600e-01, -1.990360602791669e-03,
  7.388866391027783e-06, -1.576645016075478e-08, -1.242056510382004e-11,  2.791474325899127e-13, -1.224256616399561e-15,  1.718916628055048e-18,  1.253632781508701e-20,
 -1.001924369321421e-22,  3.134588640242619e-25,  2.223773825420234e-28,  4.018807858030803e-01, -2.327463114954149e-03,  7.861315573314365e-06, -1.162160087574237e-08,
 -4.509862389501811e-11,  3.707595674994199e-13, -1.005089716263163e-15, -1.644969519038636e-18,  2.676533247696051e-20, -1.028424681479291e-22, -1.142290392544982e-26,
  2.180184438571905e-27,  4.775640043924692e-01, -2.656648905510551e-03,  7.993511554122417e-06, -5.481532880374199e-09, -7.881874344080673e-11,  4.026102904758506e-13,
 -3.755193809095467e-16, -5.706371071328434e-18,  3.278979597075926e-20, -3.434196270613048e-23, -5.263638579401320e-25,  3.206367038075950e-27,  5.583191660040143e-01,
 -2.967398014256933e-03,  7.734081647067790e-06,  2.311112143199392e-09, -1.079165978823425e-10,  3.501910690527507e-13,  5.819262082488989e-16, -8.885586694907221e-18,
  2.345775005707648e-20,  9.182983112897653e-23, -8.857558858928493e-25,  1.622191001175976e-27,  6.436237460514563e-01, -3.249018802993569e-03,  7.052558178838258e-06,
  1.115941871283680e-08, -1.263728000485938e-10,  2.048640183827324e-13,  1.640467883281986e-15, -9.434988941570073e-18, -2.234906969800569e-21,  2.128908706055910e-22,
 -6.958714926696528e-25, -2.461607254381835e-27,  7.328921841613472e-01, -3.490945590554923e-03,  5.944389999652601e-06,  2.024057332896103e-08, -1.288927143631258e-10,
 -1.946158464047335e-14,  2.467985685835519e-15, -6.230955819478541e-18, -3.592153507464800e-20,  2.411163190904376e-22,  1.468807539753984e-25, -6.202463313022709e-27,
  8.254725482047861e-01, -3.683093066460392e-03,  4.435079023166226e-06,  2.856954897089924e-08, -1.121166683059189e-10, -2.841721613868800e-13,  2.720328190988413e-15,
  4.447451802449547e-19, -6.124712034018809e-20,  1.197873916205242e-22,  1.211361003155045e-24, -5.615390225757715e-27,  9.206437566140856e-01, -3.816268330835141e-03,
  2.582836964897886e-06,  3.509954971645997e-08, -7.574277907040426e-11, -5.305168473136328e-13,  2.171331824307804e-15,  8.554997563487242e-18, -6.107160845124676e-20,
 -1.191287820040471e-22,  1.675499254678801e-24,  6.186310135925897e-28,  1.017613699736283e+00, -3.882636673180869e-03,  4.790663566848596e-07,  3.885529524864027e-08,
 -2.327948763053152e-11, -6.918001187744064e-13,  8.380150368576615e-16,  1.476435707063719e-17, -2.821501960016380e-20, -3.433640211421165e-22,  9.263715963181347e-25,
  8.348121983994319e-27,  1.115518676213702e+00, -3.876230415122962e-03, -1.754062648504913e-06,  3.908785974052220e-08,  3.787592391467901e-11, -7.118174776863428e-13,
 -9.568898011797400e-16,  1.578072258278272e-17,  2.630101947605984e-20, -3.876138719071985e-22, -7.619932172060963e-25,  1.013790419973789e-26,  1.213424634668087e+00,
 -3.793481113090008e-03, -3.969597329436673e-06,  3.543102943318454e-08,  9.727877580642393e-11, -5.652427110718368e-13, -2.638402582467333e-15,  1.014915735360454e-17,
  7.470771805512284e-20, -1.772135165844946e-22, -2.153498640464118e-24,  2.443504969537847e-27,  1.310330774469969e+00, -3.633744279524145e-03, -6.005781385202145e-06,
  2.803052713298124e-08,  1.432791639092157e-10, -2.730612963053877e-13, -3.566496512258485e-15, -4.313528048942917e-19,  8.668261393213302e-20,  1.800540696045261e-22,
 -1.950139913290784e-24, -8.812268735170037e-27,  1.405176097892315e+00, -3.399773212324791e-03, -7.700032973878664e-06,  1.761158455231632e-08,  1.656682983148821e-10,
  9.473778908915630e-14, -3.310345458912249e-15, -1.130204232484523e-17,  5.022532480225705e-20,  4.349239847247002e-22, -9.517534026955712e-26, -1.227327446453742e-26,
  1.496849500832331e+00, -3.098085980170339e-03, -8.906276228171259e-06,  5.450776321165596e-09,  1.585852105922043e-10,  4.346398708940936e-13, -1.893321240031004e-15,
 -1.697081917040284e-17, -1.538402113888765e-20,  3.824558261930219e-22,  1.858253834653062e-24, -3.472709543547789e-27,  1.584203918541126e+00, -2.739159517564148e-03,
 -9.514135846091741e-06, -6.771529133697903e-09,  1.228289570125303e-10,  6.424141068954676e-13,  1.382501846657009e-16, -1.433794078862164e-17, -6.831234604641185e-20,
  5.578680524335355e-23,  2.087323495388849e-24,  8.309357236107657e-27,  1.666074883934186e+00, -2.337380519275379e-03, -9.467576624318061e-06, -1.723901360383246e-08,
  6.660850163144378e-11,  6.535678846457046e-13,  1.916808403364509e-15, -5.009734155346766e-18, -7.357604709247754e-20, -2.721154751680119e-22,  4.464122682710798e-25,
  9.897765209697023e-27,  1.741303591190984e+00, -1.910688378110594e-03, -8.779770784888332e-06, -2.435478720884316e-08,  4.013571852579424e-12,  4.742363422433330e-13,
  2.677086370527020e-15,  5.299124740467279e-18, -3.175053124019218e-20, -3.300780429903093e-22, -1.256149614130701e-24,  8.075400202682477e-28,  1.808764180627691e+00,
 -1.479864528673172e-03, -7.540605213984652e-06, -2.711394089112678e-08, -4.882478479715562e-11,  1.845763683592829e-13,  2.184801316976604e-15,  1.047458322427290e-17,
  2.028153834799463e-20, -1.149242531651167e-22, -1.317393246556131e-24, -6.360289929009533e-27,  1.867394487336717e+00, -1.067457369950455e-03, -5.913621842145872e-06,
 -2.539439584512828e-08, -7.893348412385125e-11, -9.333450703763038e-14,  8.859404206573517e-16,  8.369129507272387e-18,  4.187653601321227e-20,  1.181782905874911e-22,
 -1.167637216394470e-25, -3.850000879156962e-27,  1.916228971607781e+00, -6.963812632364212e-04, -4.120542972328425e-06, -2.006370934891212e-08, -8.121983183999920e-11,
 -2.524692685918118e-13, -3.741912950662821e-16,  2.206353137081630e-18,  2.523735158647997e-20,  1.518896828176269e-22,  6.452469292537267e-25,  1.672471108116270e-27,
  1.954432068516522e+00, -3.882859336164498e-04, -2.413842471006617e-06, -1.283308529896283e-08, -6.062158901461404e-11, -2.543494383673185e-13, -9.152109076538779e-16,
 -2.495563161551836e-18, -2.047041669467324e-21,  3.499969382044383e-23,  3.372968626265747e-25,  2.083622253970387e-27,  1.981330044223333e+00, -1.618465392662917e-04,
 -1.040676750664739e-06, -5.859682311597815e-09, -3.033707058807326e-11, -1.470767876068612e-13, -6.712862840706861e-16, -2.875231698954744e-18, -1.140881314831145e-20,
 -4.066265015924780e-23, -1.199407519908121e-25, -2.048287114880938e-28,  1.996442901368962e+00, -3.113285907957586e-05, -2.039448874033887e-07, -1.184319121517588e-09,
 -6.425568020798672e-12, -3.332959862055509e-14, -1.672586426096001e-16, -8.175387814641947e-19, -3.907569769424684e-21, -1.830517849721112e-23, -8.414102680512076e-26,
 -3.795925646885578e-28,  9.259599087940031e-04, -6.339997036316380e-06,  3.254359542669711e-08, -1.484129781624217e-10,  6.340879893940502e-13, -2.598725639779155e-15,
  1.034460154227299e-17, -4.029524661175339e-20,  1.543126571083875e-22, -5.828706753320989e-25,  2.176128364584066e-27, -8.044068306276425e-30,  8.328129109294797e-03,
 -5.686009954957474e-05,  2.901212413641628e-07, -1.309543071127465e-09,  5.507436296605937e-12, -2.206819913145654e-14,  8.518144407384702e-17, -3.185571419071061e-19,
  1.157188375932529e-21, -4.085633299927860e-24,  1.399941019221131e-26, -4.640031915305028e-29,  2.310298924406940e-02, -1.568349479463374e-04,  7.905890905820721e-07,
 -3.494302566951778e-09,  1.422029315016801e-11, -5.428090626599185e-14,  1.954486233619964e-16, -6.622225053598906e-19,  2.087007537867962e-21, -5.953080890994856e-24,
  1.432405283283502e-26, -2.215063681660632e-29,  4.519114537203679e-02, -3.041370296433711e-04,  1.505015500412638e-06, -6.437685844092829e-09,  2.484370327513019e-11,
 -8.725092049225955e-14,  2.752449740283285e-16, -7.448943062925650e-19,  1.479094759421656e-21, -2.675158687770893e-25, -1.782737766458109e-26,  1.250623602331217e-28,
  7.450240678658342e-02, -4.955837401195390e-04,  2.391121664402588e-06, -9.766942942096858e-09,  3.482024643486699e-11, -1.064491512339289e-13,  2.549522594741540e-16,
 -2.910036498663261e-19, -1.473739138884339e-21,  1.372185703457877e-23, -7.085170792320289e-26,  2.789967005259223e-28,  1.109144631449343e-01, -7.269496587002810e-04,
  3.394652452789406e-06, -1.303060186810996e-08,  4.133677392703602e-11, -9.834966041806460e-14,  8.823124068633894e-17,  7.549076920443537e-19, -6.053383676746580e-21,
  2.822433557426975e-23, -9.410747357749220e-26,  1.874171732236794e-28,  1.542711108358747e-01, -9.929861146753787e-04,  4.451248193489968e-06, -1.573589558553269e-08,
  4.177000010623311e-11, -5.421072632267696e-14, -2.241189417741674e-16,  2.124123809893893e-18, -9.864235859855138e-21,  2.940127541601449e-23, -3.027383292926519e-26,
 -2.884879599609576e-28,  2.043800252393692e-01, -1.287450913919182e-03,  5.488847776018054e-06, -1.739326314107480e-08,  3.416017002621905e-11,  2.662975470072658e-14,
 -6.211697211348851e-16,  3.243929490393334e-18, -9.688782268343726e-21,  5.951492870508699e-24,  1.272864833962480e-25, -9.005604552367858e-28,  2.610100773964616e-01,
 -1.603151958865802e-03,  6.430650836289896e-06, -1.756596961953851e-08,  1.765697770679894e-11,  1.347136388772312e-13, -9.861362870176813e-16,  3.407275186508343e-18,
 -3.196995744326746e-21, -4.011875764045417e-23,  2.938095742799210e-25, -1.020330663869344e-27,  3.238881995915895e-01, -1.932009425648266e-03,  7.198655727478641e-06,
 -1.592209490600924e-08, -7.127319084632755e-12,  2.503849152203297e-13, -1.171035584078580e-15,  2.064801189214747e-18,  9.156524397838520e-21, -8.755856696121901e-23,
  3.159222708716778e-25, -9.527698499818261e-29,  3.926958145650880e-01, -2.265142139066775e-03,  7.717767312034233e-06, -1.228518192692329e-08, -3.792789919111792e-11,
  3.461780683615539e-13, -1.039714165160164e-15, -8.476260226471693e-19,  2.307648125021162e-20, -1.015358663443468e-22,  7.298618594140155e-26,  1.663326161769503e-27,
  4.670648588949014e-01, -2.592984756828902e-03,  7.920430553451773e-06, -6.678757013705588e-09, -7.086899691143272e-11,  3.917977716951100e-13, -5.208211905269690e-16,
 -4.680669600231726e-18,  3.120796812618147e-20, -5.263542942036138e-23, -3.900177253053332e-25,  2.972559997543586e-27,  5.465734541653776e-01, -2.905443244205279e-03,
  7.751688356173730e-06,  6.411529519359772e-10, -1.007928162598081e-10,  3.612593779537136e-13,  3.440879453072205e-16, -8.088732472488717e-18,  2.614468392339077e-20,
  5.799984493806254e-23, -8.018829919446792e-25,  2.152531663485908e-27,  6.307413117865209e-01, -3.192096734021125e-03,  7.174481308597215e-06,  9.172281447398382e-09,
 -1.219032183742369e-10,  2.410638945552996e-13,  1.376399696301468e-15, -9.389443655459521e-18,  4.905243333258267e-21,  1.832408079492000e-22, -7.781376087843487e-25,
 -1.296322701166370e-27,  7.190250008148600e-01, -3.442453990832686e-03,  6.174900591666498e-06,  1.817833274634249e-08, -1.287043984600086e-10,  3.755462644901064e-14,
  2.278736053348737e-15, -7.240948690745983e-18, -2.719934448234665e-20,  2.417586899916545e-22, -1.087570925018306e-25, -5.379557093666545e-27,  8.108132648957933e-01,
 -3.646272000548278e-03,  4.766974349794143e-06,  2.673376234384052e-08, -1.171473505848893e-10, -2.189520132860883e-13,  2.706054440244032e-15, -1.437310659217649e-18,
 -5.612422350118325e-20,  1.630779986735456e-22,  9.484988159772406e-25, -6.256849544605079e-27,  9.054226461232250e-01, -3.793942246367516e-03,  2.996419498157760e-06,
  3.380569139676174e-08, -8.581375007987643e-11, -4.757547389032729e-13,  2.382959295468899e-15,  6.545038853829926e-18, -6.415296376788004e-20, -5.218122537705520e-23,
  1.656943960194253e-24, -1.429614996021852e-27,  1.002093760791799e+00, -3.876946463922741e-03,  9.426423998709964e-07,  3.837336677665385e-08, -3.688145559844069e-11,
 -6.668401081015996e-13,  1.236973437276759e-15,  1.367154188685021e-17, -3.982475147066807e-20, -2.994239063826279e-22,  1.258400359881412e-24,  6.670883176278802e-27,
  1.099988673336752e+00, -3.888377486109258e-03, -1.281845670117729e-06,  3.957888771892965e-08,  2.344614759151541e-11, -7.293984876152427e-13, -5.053812793518012e-16,
  1.639409669951586e-17,  1.190833857500158e-20, -4.089022098696007e-22, -2.970404156182122e-25,  1.087600517122403e-26,  1.198189925611447e+00, -3.823511623508007e-03,
 -3.535470143039593e-06,  3.689371193423081e-08,  8.536509223206434e-11, -6.248905961070319e-13, -2.321833250600397e-15,  1.242136717897801e-17,  6.681141050195061e-20,
 -2.603272087120175e-22, -1.980694714679321e-24,  5.390202404250943e-27,  1.295701889603696e+00, -3.680406538636558e-03, -5.655855542696616e-06,  3.027465484068705e-08,
  1.369626438334033e-10, -3.584832699114120e-13, -3.538877691232954e-15,  2.430422215134196e-18,  9.167221161365429e-20,  9.487562169053712e-23, -2.292975528551871e-24,
 -6.643595011816108e-27,  1.391455206766378e+00, -3.460482942844241e-03, -7.472741544290666e-06,  2.027301453795524e-08,  1.667439379761669e-10,  1.168804102627694e-14,
 -3.601959375850231e-15, -9.446132859206184e-18,  6.568000427280580e-20,  4.198969997220590e-22, -6.652393518159106e-25, -1.351433207130395e-26,  1.484315132497551e+00,
 -3.169030773748218e-03, -8.825364310663150e-06,  8.055050783961633e-09,  1.667848894249769e-10,  3.834555637278719e-13, -2.373226099255085e-15, -1.722882337080690e-17,
 -3.231804238257093e-22,  4.527713821372180e-22,  1.633251841785344e-24, -6.801661999015248e-27,  1.573094588115463e+00, -2.815563251309912e-03, -9.583178422136816e-06,
 -4.703440197918119e-09,  1.356766341528163e-10,  6.406699949576640e-13, -2.933952333376726e-16, -1.647499230640084e-17, -6.471598597662861e-20,  1.462556141940990e-22,
  2.426210062252307e-24,  6.947220571355572e-27,  1.656572597373620e+00, -2.413929478004698e-03, -9.667611062090892e-06, -1.606625979180044e-08,  8.012711838284155e-11,
  6.976130579908496e-13,  1.742130771592949e-15, -7.516571808351565e-18, -8.294033369102947e-20, -2.449474636228670e-22,  9.265523553481335e-25,  1.189367961225266e-26,
  1.733518512902602e+00, -1.982093738723096e-03, -9.071318491943158e-06, -2.421115308571009e-08,  1.415217663959282e-11,  5.401407870695197e-13,  2.809382679223502e-15,
  4.083390088157053e-18, -4.452378915183068e-20, -3.790100519031616e-22, -1.174436336390480e-24,  3.006916273621607e-27,  1.802721993815166e+00, -1.541503820323323e-03,
 -7.870528359487964e-06, -2.786265526319443e-08, -4.458478732836017e-11,  2.406001978146083e-13,  2.486478086264778e-15,  1.104667031091648e-17,  1.512708858828749e-20,
 -1.733457089107315e-22, -1.606323759479301e-24, -6.720824691609421e-27,  1.863028079445807e+00, -1.116006879551836e-03, -6.225989840960509e-06, -2.667102739753488e-08,
 -8.056776825270647e-11, -6.910459365611094e-14,  1.139667854335497e-15,  9.775992932868889e-18,  4.600243633650027e-20,  1.097178478009724e-22, -3.167146823822028e-25,
 -5.285868086830247e-27,  1.913375961327146e+00, -7.303311436703141e-04, -4.369272737184489e-06, -2.140408697397105e-08, -8.635352537798784e-11, -2.606120326759255e-13,
 -3.002487083817781e-16,  3.106560056684091e-18,  3.118736997373654e-20,  1.791335611513667e-22,  7.157103940945539e-25,  1.501576634507286e-27,  1.952839304189719e+00,
 -4.082295450343145e-04, -2.573830968820489e-06, -1.384494394343250e-08, -6.593392129791435e-11, -2.771591495457017e-13, -9.857946853616102e-16, -2.538116487190386e-18,
 -5.207374818493438e-22,  5.047673318496064e-23,  4.404948719856263e-25,  2.624782640880678e-27,  1.980665549950892e+00, -1.704616990885915e-04, -1.114005279989157e-06,
 -6.369511216406718e-09, -3.344645514349280e-11, -1.641963766748787e-13, -7.571306865061205e-16, -3.264678288686295e-18, -1.296109068302983e-20, -4.562832614557802e-23,
 -1.279852145562046e-25, -1.554927887234669e-28,  1.996315014270148e+00, -3.282306536884304e-05, -2.187962973224588e-07, -1.292687096112277e-09, -7.134231941205350e-12,
 -3.763326180908060e-14, -1.920042149438444e-16, -9.538085133724026e-19, -4.631389477017283e-21, -2.203002011195090e-23, -1.027595970348478e-25, -4.700881508868708e-28,
  9.011095771792892e-04, -6.086603488209578e-06,  3.082183964788093e-08, -1.386702508883929e-10,  5.845075950020668e-13, -2.363455215732946e-15,  9.282428094792800e-18,
 -3.567684356304487e-20,  1.348144747942885e-22, -5.025071109313832e-25,  1.851435877344936e-27, -6.754597055833465e-30,  8.105233197206841e-03, -5.460052250016482e-05,
  2.749212250812936e-07, -1.224846884724988e-09,  5.085814435541635e-12, -2.012682741737609e-14,  7.675890104319054e-17, -2.837762349975659e-19,  1.019711534856404e-21,
 -3.564482084330106e-24,  1.210593495765538e-26, -3.983694376175407e-29,  2.248803866460022e-02, -1.506741747070510e-04,  7.499875911935697e-07, -3.275214127630248e-09,
  1.318011894974180e-11, -4.980529356523987e-14,  1.778099317487267e-16, -5.987585875378161e-19,  1.882771487921200e-21, -5.399987187971947e-24,  1.332335685240101e-26,
 -2.315566102764978e-29,  4.399819760537192e-02, -2.923992873976357e-04,  1.430091823680287e-06, -6.053794814853402e-09,  2.316308182523795e-11, -8.088999075776396e-14,
  2.550481987668913e-16, -6.978447261372438e-19,  1.457879209024569e-21, -8.787585298983632e-25, -1.292748747082113e-26,  9.858309609590241e-29,  7.255760064542627e-02,
 -4.769142686153867e-04,  2.277191905445695e-06, -9.226521266162238e-09,  3.275176628252695e-11, -1.004329658039359e-13,  2.462144207567630e-16, -3.307831812776952e-19,
 -1.027913946242530e-21,  1.112162150198691e-23, -5.944189063429491e-26,  2.403047990266622e-28,  1.080600043008475e-01, -7.004068130749941e-04,  3.242189041296349e-06,
 -1.238482757272238e-08,  3.939255911218447e-11, -9.599943740997055e-14,  1.068044048659882e-16,  5.767464183516295e-19, -5.103053151972465e-21,  2.462750312513845e-23,
 -8.568949162109036e-26,  1.936032733745420e-28,  1.503692063489739e-01, -9.581201748767440e-04,  4.266390694451042e-06, -1.507652195877544e-08,  4.063663432157538e-11,
 -5.891057533228748e-14, -1.689053335123542e-16,  1.825146802934116e-18, -8.830352001957935e-21,  2.796840239562867e-23, -4.062501610565909e-26, -1.861600569587642e-28,
  1.993167344245361e-01, -1.244365681410114e-03,  5.283423029334828e-06, -1.684321941045881e-08,  3.455086151729102e-11,  1.277683830187323e-14, -5.346414893908051e-16,
  2.938224516726386e-18, -9.391998980810236e-21,  1.029778361464592e-23,  9.117207207152449e-26, -7.435318851125712e-28,  2.546990320006048e-01, -1.552544919448960e-03,
  6.221639104370913e-06, -1.726315750276320e-08,  2.012224035548874e-11,  1.121783965357283e-13, -8.923662927600900e-16,  3.284043973937335e-18, -4.440444508089544e-21,
 -2.925245113163139e-23,  2.498575155737769e-25, -9.722501450003858e-28,  3.162741280539286e-01, -1.875186008250776e-03,  7.007066728628057e-06, -1.599757723918161e-08,
 -2.395827276934168e-12,  2.230041187552238e-13, -1.109575576434558e-15,  2.309802410782560e-18,  6.230185238773314e-21, -7.507953171519482e-23,  3.063440605943951e-25,
 -3.268843578997611e-28,  3.837577827302769e-01, -2.203999488343482e-03,  7.566928117832858e-06, -1.283800222148033e-08, -3.125537463413715e-11,  3.210202166519613e-13,
 -1.053654138168918e-15, -1.669652327504121e-19,  1.949008081098657e-20, -9.729438550264092e-23,  1.356813736920289e-25,  1.195801351313674e-27,  4.568191127365577e-01,
 -2.529960578197952e-03,  7.833738315247286e-06, -7.750695024788766e-09, -6.316807890912821e-11,  3.778363538741426e-13, -6.382036433083080e-16, -3.715093038780911e-18,
  2.906298744790554e-20, -6.571070164371028e-23, -2.661151181355099e-25,  2.647905067960520e-27,  5.350757189526163e-01, -2.843425826006169e-03,  7.749945759592916e-06,
 -9.133571983600704e-10, -9.350289685113322e-11,  3.668959264014381e-13,  1.295871203167579e-16, -7.224693253635808e-18,  2.767915039224014e-20,  2.792589334567425e-23,
 -6.995342003954931e-25,  2.466101471837683e-27,  6.180883673311699e-01, -3.134293394082514e-03,  7.273010649780851e-06,  7.262106009287770e-09, -1.167727830695574e-10,
  2.709662496983796e-13,  1.116641141009714e-15, -9.133028949098416e-18,  1.093078530363853e-20,  1.512884522019686e-22, -8.119943322433274e-25, -2.691045516918620e-28,
  7.053553154909483e-01, -3.392217157684493e-03,  6.380719181417801e-06,  1.612797198232137e-08, -1.274233060708702e-10,  8.972098082881355e-14,  2.065103996815468e-15,
 -7.973360419930226e-18, -1.862880119765970e-20,  2.329598519271804e-22, -3.238700302799594e-25, -4.376777344279743e-27,  7.963064348545513e-01, -3.606885159200660e-03,
  5.076400228289039e-06,  2.482788384486668e-08, -1.208812225254401e-10, -1.546869153215196e-13,  2.641597724493593e-15, -3.132574856201060e-18, -4.963770394146374e-20,
  1.954236734322729e-22,  6.673824201239393e-25, -6.450167692096584e-27,  8.902973552021669e-01, -3.768372261201672e-03,  3.393545902566800e-06,  3.235971613364769e-08,
 -9.474329508124640e-11, -4.165978419650030e-13,  2.537287772286002e-15,  4.474722918362234e-18, -6.485868533934507e-20,  1.228953353022123e-23,  1.553570013110955e-24,
 -3.216116501905782e-27,  9.866039581055307e-01, -3.867574437356525e-03,  1.399147641073831e-06,  3.767830952134841e-08, -4.989116228004901e-11, -6.327127129556759e-13,
  1.600387059084366e-15,  1.223493637863882e-17, -4.963246434589772e-20, -2.437971424898930e-22,  1.508068952835878e-24,  4.632239625456088e-27,  1.084417669394221e+00,
 -3.896727199697448e-03, -8.051312971273854e-07,  3.983681997688364e-08,  8.774232743853133e-12, -7.359898217222508e-13, -4.323552064098058e-17,  1.653828290892840e-17,
 -2.910110165146252e-21, -4.111609810732568e-22,  1.840255778065548e-25,  1.086566025836591e-26,  1.182842147021106e+00, -3.850002236074336e-03, -3.084972452876497e-06,
  3.815666572573705e-08,  7.233942186412251e-11, -6.762086184962119e-13, -1.945618435121010e-15,  1.439460630230348e-17,  5.607819446359622e-20, -3.339920627546227e-22,
 -1.682904774570279e-24,  8.083355608951814e-27,  1.280892122471892e+00, -3.724163520443383e-03, -5.279662740325666e-06,  3.240411425787019e-08,  1.289508842014031e-10,
 -4.422657161546093e-13, -3.429372538940999e-15,  5.400354777757328e-18,  9.337354501861858e-20, -1.889489891960483e-24, -2.524316680546304e-24, -3.768321237120624e-27,
  1.377495315893529e+00, -3.519246429328085e-03, -7.213465687399306e-06,  2.293800519964919e-08,  1.660930906538901e-10, -7.768163093114373e-14, -3.834797384157741e-15,
 -7.108822942043233e-18,  8.017224700938773e-20,  3.812134590039292e-22, -1.271735157702917e-24, -1.389564599247849e-26,  1.471498480544970e+00, -3.239201118373189e-03,
 -8.712449743482919e-06,  1.078170337588502e-08,  1.738454109278714e-10,  3.207235802275729e-13, -2.853241336594822e-15, -1.696640669224559e-17,  1.707109053490710e-20,
  5.110919745502180e-22,  1.257350614893141e-24, -1.028799956034742e-26,  1.561678700173644e+00, -2.892416569234805e-03, -9.626173583271040e-06, -2.430650422761466e-09,
  1.483810676306130e-10,  6.278644478075691e-13, -7.827594127799581e-16, -1.844236736124147e-17, -5.763564719336044e-20,  2.488104438225658e-22,  2.684754714264430e-24,
  4.642994266079911e-27,  1.646761008833826e+00, -2.492018677641584e-03, -9.852246401581550e-06, -1.467041312503228e-08,  9.447885979297941e-11,  7.365908498778307e-13,
  1.493240919572134e-15, -1.030354370002893e-17, -9.096038142411593e-20, -1.968951745690325e-22,  1.488240302430059e-24,  1.356113343564087e-26,  1.725443163351284e+00,
 -2.055821727618961e-03, -9.360125261376695e-06, -2.389459648578218e-08,  2.563761863515181e-11,  6.087640681254798e-13,  2.901656824861577e-15,  2.431557241360804e-18,
 -5.897480157434150e-20, -4.225574638385450e-22, -9.824220362143393e-25,  5.822915601714681e-27,  1.796427915907102e+00, -1.605817194410434e-03, -8.208990773670975e-06,
 -2.853416739127602e-08, -3.915071821780137e-11,  3.040358287671526e-13,  2.801531870684485e-15,  1.141790875391740e-17,  7.658552381110913e-21, -2.435361012556382e-22,
 -1.902915699787048e-24, -6.679225053641286e-27,  1.858462378028294e+00, -1.167117016936916e-03, -6.553817208960408e-06, -2.796958619170507e-08, -8.165329306413707e-11,
 -3.829793626929071e-14,  1.434578333420519e-15,  1.130833968800818e-17,  4.966379852958925e-20,  9.191097787567316e-23, -5.861924134928115e-25, -7.010657306307579e-27,
  1.910383067993024e+00, -7.663366084200999e-04, -4.634584905638005e-06, -2.282780114791040e-08, -9.163017119849838e-11, -2.666552646236983e-13, -1.982834988507441e-16,
  4.213385998053943e-18,  3.816657953582693e-20,  2.089884930800062e-22,  7.742457782024231e-25,  1.116988183783415e-27,  1.951164126613621e+00, -4.295031138743367e-04,
 -2.746487107675345e-06, -1.494554179839982e-08, -7.171945360657242e-11, -3.016711056902899e-13, -1.056796450979039e-15, -2.522068118848668e-18,  1.643074748938183e-21,
  7.059035593349520e-23,  5.699536848333136e-25,  3.279544552247799e-27,  1.979965381806444e+00, -1.796888314533901e-04, -1.193761929002186e-06, -6.931945160106764e-09,
 -3.691974711933546e-11, -1.835128657733536e-13, -8.546023032146148e-16, -3.706715232822319e-18, -1.469730691432020e-20, -5.086178068288533e-23, -1.330409382639333e-25,
 -6.642807137340143e-29,  1.996180120206629e+00, -3.463748411467980e-05, -2.350191032775981e-07, -1.413115893785433e-09, -7.935231194377900e-12, -4.257935193736772e-14,
 -2.209108415637668e-16, -1.115537885722740e-18, -5.503726298178633e-21, -2.658566723568138e-23, -1.258500639108669e-25, -5.837767034176267e-28,  8.772459935333493e-04,
 -5.846529472465869e-06,  2.921238778750401e-08, -1.296845089988643e-10,  5.393878086457433e-13, -2.152193090162038e-15,  8.341252425962157e-18, -3.163849270644338e-20,
  1.179886524738644e-22, -4.340643246656324e-25,  1.578491604652019e-27, -5.684658478372643e-30,  7.891138671865958e-03, -5.245859196407922e-05,  2.606983339487669e-07,
 -1.146596689233869e-09,  4.701074984065651e-12, -1.837639064094942e-14,  6.925135321911057e-17, -2.531084743601021e-19,  8.996997538700888e-22, -3.113586200814421e-24,
  1.047969119204257e-26, -3.422849814068360e-29,  2.189709781417695e-02, -1.448279734887250e-04,  7.119181773715810e-07, -3.072074787214671e-09,  1.222536391380644e-11,
 -4.573240598426895e-14,  1.618596699376252e-16, -5.415194350941930e-19,  1.697718379426050e-21, -4.887511231411649e-24,  1.229983839457227e-26, -2.324294947082541e-29,
  4.285103057175633e-02, -2.812429554256667e-04,  1.359617613762054e-06, -5.695801870365415e-09,  2.160493797441265e-11, -7.499807072066135e-14,  2.361562560995318e-16,
 -6.517904756975141e-19,  1.417920489139276e-21, -1.315736817667350e-24, -9.077110317872638e-27,  7.719332861361082e-29,  7.068568980385445e-02, -4.591308485002373e-04,
  2.169552565311864e-06, -8.718244427912911e-09,  3.080143051326709e-11, -9.463832574797290e-14,  2.365490214353839e-16, -3.577092162090813e-19, -6.678814684271448e-22,
  8.944936997237103e-24, -4.964420905809892e-26,  2.057211954353596e-28,  1.053093257618441e-01, -6.750532026803867e-04,  3.097289901837148e-06, -1.176976209506501e-08,
  3.749941950768688e-11, -9.326000156580976e-14,  1.207958010044041e-16,  4.269893025799154e-19, -4.276106520946446e-21,  2.137019090147848e-23, -7.719128199701497e-26,
  1.915635656648676e-28,  1.466038575696199e-01, -9.247017601016902e-04,  4.089333999523350e-06, -1.443596494150662e-08,  3.942186385209363e-11, -6.238206580393706e-14,
 -1.216081770254484e-16,  1.558357210681999e-18, -7.854484334232362e-21,  2.620445058454357e-23, -4.699562210022746e-26, -1.068824833497744e-28,  1.944225396702861e-01,
 -1.202897358845087e-03,  5.084627528470894e-06, -1.628903113904283e-08,  3.468457424167638e-11,  8.990906987798356e-16, -4.565184266917769e-16,  2.644254505697474e-18,
 -8.963128842480345e-21,  1.333299872631875e-23,  6.161306341606453e-26, -6.029019361693230e-28,  2.485870944909190e-01, -1.503594801819711e-03,  6.016483302501657e-06,
 -1.692438579585510e-08,  2.215900172003210e-11,  9.184808149616844e-14, -8.025474216242454e-16,  3.126946741703888e-18, -5.323763813145483e-21, -2.009352150250320e-23,
  2.086261079932929e-25, -8.986716974416639e-28,  3.088842807879095e-01, -1.819897680117607e-03,  6.815008359200575e-06, -1.600165433969318e-08,  1.803301728988138e-12,
  1.971705132325175e-13, -1.042499633858367e-15,  2.468256199109776e-18,  3.743946791375772e-21, -6.316480614052872e-23,  2.882439550939727e-25, -4.847467977837970e-28,
  3.750618685686319e-01, -2.144088309948064e-03,  7.410078996537654e-06, -1.328809930858118e-08, -2.508787533027348e-11,  2.957436966071394e-13, -1.050116138833587e-15,
  4.018186341904941e-19,  1.609671380553545e-20, -9.093912345282580e-23,  1.791212247560384e-25,  7.893983369640031e-28,  4.468239976776137e-01, -2.467679318018240e-03,
  7.734912423447944e-06, -8.701796193899790e-09, -5.577241293306451e-11,  3.613740332104581e-13, -7.295750148310132e-16, -2.824759735890903e-18,  2.653289896776857e-20,
 -7.413317885549706e-23, -1.577467288356774e-25,  2.272504156698612e-27,  5.238259101967204e-01, -2.781494975417340e-03,  7.730251710230579e-06, -2.350598186491152e-09,
 -8.614974249471784e-11,  3.676793493302361e-13, -6.019015342387605e-17, -6.328060075019757e-18,  2.820744242002176e-20,  2.164254120400395e-24, -5.876340931575253e-25,
  2.592110583245340e-27,  6.056680695589548e-01, -3.075792069092491e-03,  7.349129053414314e-06,  5.438466007098029e-09, -1.111059530988070e-10,  2.947412731430242e-13,
  8.665873483939229e-16, -8.702377350492185e-18,  1.579211049963213e-20,  1.188361852056194e-22, -8.044113845310368e-25,  5.829417024864588e-28,  6.918897153638089e-01,
 -3.340431767227231e-03,  6.562089936563689e-06,  1.410617031771708e-08, -1.251516606824361e-10,  1.365447167130308e-13,  1.834745066039636e-15, -8.438155253939603e-18,
 -1.051896604646745e-20,  2.164703386404316e-22, -4.926802029592121e-25, -3.289974323294808e-27,  7.819619568401869e-01, -3.565115311547695e-03,  5.362639212736603e-06,
  2.287244605504800e-08, -1.233489814753189e-10, -9.251393396865103e-14,  2.532739094325033e-15, -4.603818757814782e-18, -4.219007014573320e-20,  2.164771799280214e-22,
  3.868193063187565e-25, -6.241751297335669e-27,  8.752805850412556e-01, -3.739697009321416e-03,  3.772503009029542e-06,  3.078051477019146e-08, -1.024573629899069e-10,
 -3.544331273014034e-13,  2.633673604303685e-15,  2.418013214277696e-18, -6.333591769136787e-20,  7.115502105512751e-23,  1.379359258794643e-24, -4.635496943951196e-27,
  9.711588898614911e-01, -3.854587215367085e-03,  1.846087283659566e-06,  3.678101694352698e-08, -6.213453520855284e-11, -5.903796401735096e-13,  1.919495627435357e-15,
  1.051827276594458e-17, -5.728010851634988e-20, -1.800451794832475e-22,  1.663316949181487e-24,  2.409225192422036e-27,  1.068820907987867e+00, -3.901254814414801e-03,
 -3.267326376133837e-07,  3.985955003085053e-08, -5.918543552763226e-12, -7.314947371895458e-13,  4.163229698726675e-16,  1.621067737492291e-17, -1.746563321920224e-20,
 -3.944072068429242e-22,  6.481847825390491e-25,  1.011473314564029e-26,  1.167395704827456e+00, -3.872831863045489e-03, -2.620602012753829e-06,  3.920350654834003e-08,
  5.838194724730802e-11, -7.178756508673222e-13, -1.519342382178482e-15,  1.598447489733757e-17,  4.293486844354538e-20, -3.935040448947915e-22, -1.276645434043171e-24,
  1.028365475318876e-26,  1.265913505093538e+00, -3.764811051258751e-03, -4.878740310308752e-06,  3.439215146690198e-08,  1.192965106114495e-10, -5.224192657046281e-13,
 -3.236482018439236e-15,  8.367465237332083e-18,  9.145682701999867e-20, -1.052087380493993e-22, -2.616887383907901e-24, -3.731666379309601e-28,  1.363304721596377e+00,
 -3.575808104135776e-03, -6.922332328373378e-06,  2.557800271178144e-08,  1.636045345486406e-10, -1.718031296669549e-13, -3.995941031934447e-15, -4.334740582487371e-18,
  9.283381526392123e-20,  3.182280332571099e-22, -1.872814826081564e-24, -1.324598936182151e-26,  1.458403163652985e+00, -3.308335446076679e-03, -8.566180956226683e-06,
  1.361066490820077e-08,  1.795370171594912e-10,  2.466241295218052e-13, -3.317823067449699e-15, -1.611698205754184e-17,  3.625740732405528e-20,  5.513265599297162e-22,
  7.299838561085286e-25, -1.363171143261644e-26,  1.549954888617076e+00, -2.969501322634945e-03, -9.640686210194771e-06,  4.270504516184767e-11,  1.607076277924547e-10,
  6.026822023510393e-13, -1.323470078862356e-15, -2.012231970740437e-17, -4.670426030360603e-20,  3.593887344236200e-22,  2.820173289505215e-24,  1.350494074482848e-27,
  1.636634221000761e+00, -2.571513998676844e-03, -1.001872921356663e-05, -1.303905373307225e-08,  1.095439601039194e-10,  7.686316190988631e-13,  1.163014634548020e-15,
 -1.331500835438937e-17, -9.682985817749121e-20, -1.250669969457400e-22,  2.110860755074981e-24,  1.461204044130424e-26,  1.717068309543189e+00, -2.131841746906094e-03,
 -9.643985113318001e-06, -2.338318944702623e-08,  3.851364969531465e-11,  6.789932686158580e-13,  2.940981943798037e-15,  2.939441614209385e-19, -7.482377533989775e-20,
 -4.557673964902532e-22, -6.532310600818737e-25,  9.232264597539490e-27,  1.789871120286330e+00, -1.672868923219597e-03, -8.554946456032589e-06, -2.910817086488747e-08,
 -3.237163138829804e-11,  3.751280640191677e-13,  3.123238298664562e-15,  1.150744759092527e-17, -2.548506672803747e-21, -3.253928593562331e-22, -2.185285942580646e-24,
 -6.038997534809314e-27,  1.853686891781016e+00, -1.220912349952899e-03, -6.897309874361791e-06, -2.928018493662255e-08, -8.204836522341113e-11,  1.140101368884941e-16,
  1.773922724627800e-15,  1.294535945166426e-17,  5.247103890607094e-20,  6.172397298782841e-23, -9.377311534573520e-25, -9.010714711718577e-27,  1.907241797565743e+00,
 -8.045343523131878e-04, -4.917491730097784e-06, -2.433676460556416e-08, -9.700056502882530e-11, -2.698531928610176e-13, -6.203589552593124e-17,  5.561157077965571e-18,
  4.625789512729818e-20,  2.407638396807737e-22,  8.095045908094884e-25,  4.262869853644424e-28,  1.949401006346983e+00, -4.522123720453633e-04, -2.932922308918203e-06,
 -1.614272236711121e-08, -7.801218565294697e-11, -3.278731813867602e-13, -1.126263157117096e-15, -2.424134385313209e-18,  4.631459378644215e-21,  9.649475586655359e-23,
  7.309490711566305e-25,  4.059894250564108e-27,  1.979226984907653e+00, -1.895819887832098e-04, -1.280614393747270e-06, -7.553173840048766e-09, -4.080379779451226e-11,
 -2.053236515187681e-13, -9.652573321545153e-16, -4.207356027818183e-18, -1.662448408804574e-20, -5.620351970767150e-23, -1.329764523242926e-25,  8.082931408722643e-29,
  1.996037699432828e+00, -3.658769153307818e-05, -2.527673416020802e-07, -1.547191346590612e-09, -8.842473612025460e-12, -4.827685470683499e-14, -2.547626825828693e-16,
 -1.307994611638902e-18, -6.557970636709719e-21, -3.217315140893969e-23, -1.545661793211785e-25, -7.269760871891817e-28,  8.543176207245564e-04, -5.618911715245053e-06,
  2.770656889026077e-08, -1.213880716651036e-10,  4.982762365730024e-13, -1.962220933365479e-15,  7.505968518890791e-18, -2.810116354396613e-20,  1.034410853852647e-22,
 -3.756533475088284e-25,  1.348534906362551e-27, -4.794771572230246e-30,  7.685390105115687e-03, -5.042679059832268e-05,  2.473786345305279e-07, -1.074231760587139e-09,
  4.349609830391029e-12, -1.679625004591094e-14,  6.255109087625735e-17, -2.260334617062258e-19,  7.948065145208667e-22, -2.723053888205248e-24,  9.081824789765685e-27,
 -2.943478381591827e-29,  2.132894773796485e-02, -1.392768305276890e-04,  6.761974013434219e-07, -2.883580131409049e-09,  1.134836499809138e-11, -4.202374471903432e-14,
  1.474319178063159e-16, -4.899146925170360e-19,  1.530378430585834e-21, -4.415849571598355e-24,  1.128721405403912e-26, -2.270131696329181e-29,  4.174738789941489e-02,
 -2.706336484890041e-04,  1.293293547426976e-06, -5.361820719717096e-09,  2.016020210442638e-11, -6.954424108719306e-14,  2.185337676610198e-16, -6.072386413343822e-19,
  1.364787864695947e-21, -1.616232670663774e-24, -6.072958484390830e-27,  5.998084681782485e-29,  6.888322830491972e-02, -4.421846675844648e-04,  2.067829097992979e-06,
 -8.240258657058374e-09,  2.896461321169208e-11, -8.908347031938359e-14,  2.262797298484848e-16, -3.742952484963247e-19, -3.795110946898932e-22,  7.130924907100555e-24,
 -4.127886255674463e-26,  1.751730351204013e-28,  1.026577893018292e-01, -6.508297729168846e-04,  2.959591670066161e-06, -1.118453166981852e-08,  3.566410190871893e-11,
 -9.023220637830359e-14,  1.309473075901391e-16,  3.018835862533821e-19, -3.560342812326771e-21,  1.844920514039972e-23, -6.891361616452845e-26,  1.839601614594899e-28,
  1.429693977516416e-01, -8.926693874551152e-04,  3.919845272648715e-06, -1.381534049185119e-08,  3.814842779408419e-11, -6.480459735757237e-14, -8.135379980476033e-17,
  1.321736630517407e-18, -6.945919390960311e-21,  2.424953057419952e-23, -5.031288881529496e-26, -4.675944465010859e-29,  1.896910796249507e-01, -1.162992780286176e-03,
  4.892487606386972e-06, -1.573450480065811e-08,  3.459882323946295e-11, -9.200833429905729e-15, -3.864195222248207e-16,  2.365540224691586e-18, -8.444828804777772e-21,
  1.530448117566558e-23,  3.785758204093266e-26, -4.798074314846946e-28,  2.426677014478936e-01, -1.456269145713171e-03,  5.815575247376823e-06, -1.655616318295230e-08,
  2.381034176077754e-11,  7.361773405638694e-14, -7.174756630486003e-16,  2.946547175509161e-18, -5.906221049699801e-21, -1.251407773728092e-23,  1.709900820701244e-25,
 -8.103804624262792e-28,  3.017125151520718e-01, -1.766144911169557e-03,  6.623287417843969e-06, -1.594258993420507e-08,  5.502171423661617e-12,  1.729913715868564e-13,
 -9.720374068022596e-16,  2.553861066136620e-18,  1.672105705310543e-21, -5.209415370349965e-23,  2.645838155545092e-25, -5.817212233999262e-28,  3.666030576449842e-01,
 -2.085451889987718e-03,  7.248404136841602e-06, -1.364355083959439e-08, -1.942382978287755e-11,  2.707311520568711e-13, -1.032135830977145e-15,  8.659769155851396e-19,
  1.295927842412648e-20, -8.318464447258307e-23,  2.061230416644784e-25,  4.489291019190309e-28,  4.370763569674516e-01, -2.406232331963320e-03,  7.625372073224529e-06,
 -9.537311518893563e-09, -4.872595158835851e-11,  3.430085517560277e-13, -7.971903409276271e-16, -2.019436800015676e-18,  2.377357468791781e-20, -7.855865413651313e-23,
 -6.639405644001475e-26,  1.879265190745968e-27,  5.128234033312827e-01, -2.719788665107363e-03,  7.694016410651437e-06, -3.670302267168974e-09, -7.882442631187399e-11,
  3.642104709060195e-13, -2.247582378363119e-16, -5.428488439083114e-18,  2.788978200195229e-20, -1.905805400720308e-23, -4.736794519183692e-25,  2.565492557178645e-27,
  5.934828586055835e-01, -3.016767756174583e-03,  7.403922439920274e-06,  3.708977620317321e-09, -1.050225725706594e-10,  3.126762074090314e-13,  6.305948682978926e-16,
 -8.134727311671333e-18,  1.949914123377779e-20,  8.738113640812642e-23, -7.635331242487492e-25,  1.243081970429963e-27,  6.786340060373183e-01, -3.287291770120531e-03,
  6.719447069484778e-06,  1.212790248430655e-08, -1.219997318075814e-10,  1.777123995831959e-13,  1.594907097544543e-15, -8.654142565576085e-18, -3.112712465794347e-21,
  1.941902394530820e-22, -6.134066059348130e-25, -2.203909148513542e-27,  7.677889886026444e-01, -3.521149990750354e-03,  5.625216576110404e-06,  2.088731633387814e-08,
 -1.246026017775909e-10, -3.342034359991601e-14,  2.386120809100929e-15, -5.826753294726298e-18, -3.418335762168977e-20,  2.265945610596103e-22,  1.229819489282361e-25,
 -5.703251134512477e-27,  8.603844563455517e-01, -3.708067905271147e-03,  4.131810531250086e-06,  2.908794090543812e-08, -1.089096320409913e-10, -2.906387936742430e-13,
  2.673462084340707e-15,  4.424788541562760e-19, -5.983335718385739e-20,  1.219265023975658e-22,  1.152006021199491e-24, -5.624960239907342e-27,  9.557728487321394e-01,
 -3.838070809511434e-03,  2.281113293461449e-06,  3.569500299544637e-08, -7.345868779755732e-11, -5.409902558703172e-13,  2.187463926792863e-15,  8.594611791170680e-18,
 -6.254462438280511e-20, -1.120532663496476e-22,  1.720048935534688e-24,  1.835726744787540e-28,  1.053213686600543e+00, -3.901958134541998e-03,  1.505331731715023e-07,
  3.964851008452032e-08, -2.041213631832009e-11, -7.161322735343326e-13,  8.603034149640067e-16,  1.543045166953702e-17, -3.109364995641595e-20, -3.599508918204339e-22,
  1.064315577510493e-24,  8.700637054084476e-27,  1.151865448174332e+00, -3.891900134220165e-03, -2.145035060730183e-06,  4.002093117214901e-08,  4.369679045768574e-11,
 -7.488272513779847e-13, -1.054736894804495e-15,  1.712279266010606e-17,  2.796323266176575e-20, -4.350205349710906e-22, -7.881784178067135e-25,  1.179186299332247e-26,
  1.250778859575952e+00, -3.802158522897215e-03, -4.454940263437385e-06,  3.621317373779610e-08,  1.080920386887851e-10, -5.969568795087796e-13, -2.961933630054209e-15,
  1.121331262087395e-17,  8.579089230478687e-20, -2.091454610316380e-22, -2.553283970116407e-24,  3.282966764882702e-27,  1.348892738227769e+00, -3.629914813373462e-03,
 -6.599820627367388e-06,  2.816294095964307e-08,  1.592013927419145e-10, -2.688164593531458e-13, -4.074111532334885e-15, -1.196332624296033e-18,  1.028049823635726e-19,
  2.320972386539195e-22, -2.420850580304776e-24, -1.147868760265617e-26,  1.445033866784037e+00, -3.376162401733503e-03, -8.385469079280740e-06,  1.651823976389521e-08,
  1.836374249371781e-10,  1.617306874726357e-13, -3.749838350170260e-15, -1.463477258281440e-17,  5.647804696221315e-20,  5.676432675737300e-22,  6.507102499471368e-26,
 -1.647884094588744e-26,  1.537922698496963e+00, -3.046580146097913e-03, -9.624354167855281e-06,  2.708535995114591e-09,  1.723971823605304e-10,  5.640016731361391e-13,
 -1.905717971301561e-15, -2.138802955231184e-17, -3.173205203416063e-20,  4.722038394265595e-22,  2.789790050791271e-24, -2.874331652127664e-27,  1.626186917987384e+00,
 -2.652258733489368e-03, -1.016416979036968e-05, -1.116198584682371e-08,  1.251636925715337e-10,  7.917164444407901e-13,  7.462612691028726e-16, -1.646804083096120e-17,
 -9.965634970044539e-20, -2.766209787857665e-23,  2.760217497425003e-24,  1.472110229410912e-26,  1.708384877852677e+00, -2.210104488214168e-03, -9.920425522545465e-06,
 -2.265449935361812e-08,  5.279855416878363e-11,  7.493897176817542e-13,  2.913193688805540e-15, -2.367120799268392e-18, -9.159371405489219e-20, -4.726552340919110e-22,
 -1.627657403494003e-25,  1.312746770374772e-26,  1.783040541584212e+00, -1.742713894955664e-03, -8.907091107325736e-06, -2.956191453364892e-08, -2.409348981979259e-11,
  4.539316306520529e-13,  3.442420884784134e-15,  1.122109945135669e-17, -1.589689820977926e-20, -4.177548810295869e-22, -2.422151796512314e-24, -4.570944380040540e-27,
  1.848690628642510e+00, -1.277518579152327e-03, -7.256540823362396e-06, -3.059050066636789e-08, -8.158999520654977e-11,  4.722930604316925e-14,  2.160177573824113e-15,
  1.465193286454264e-17,  5.391657992418565e-20,  1.564494328531293e-23, -1.382397632135432e-24, -1.123000837200324e-26,  1.903943092905369e+00, -8.450692454357180e-04,
 -5.219023172624783e-06, -2.593197499535771e-08, -1.023990055281609e-10, -2.692980042262899e-13,  1.157477391110284e-16,  7.186358882424527e-18,  5.551015141696734e-20,
  2.732263719123153e-22,  8.055191140052365e-25, -6.885575450392393e-28,  1.947543972629064e+00, -4.764723285269665e-04, -3.134345363018930e-06, -1.744486842703434e-08,
 -8.484534943820907e-11, -3.556978384718020e-13, -1.191499466285783e-15, -2.214339057462581e-18,  8.676945263157073e-21,  1.295643169423053e-22,  9.291730729672052e-25,
  4.972061564634728e-27,  1.978447576990333e+00, -2.002008753834542e-04, -1.375309347371351e-06, -8.240186244418171e-09, -4.515179361282645e-11, -2.299655192706531e-13,
 -1.090822504876399e-15, -4.772728852009648e-18, -1.874215417387952e-20, -6.139052923810014e-23, -1.246933267960736e-25,  3.121554771217793e-28,  1.995887183307635e+00,
 -3.868657620612503e-05, -2.722154891509668e-07, -1.696740324555480e-09, -9.872247539067494e-12, -5.485547337248923e-14, -2.945075077600259e-16, -1.537640171196824e-18,
 -7.835652200088904e-21, -3.904571140488641e-23, -1.903776722846360e-25, -9.078073337914562e-28,  8.322762409566741e-04, -5.402953180713185e-06,  2.629648247327575e-08,
 -1.137200803963924e-10,  4.607713983159687e-13, -1.791157770385018e-15,  6.763516411595975e-18, -2.499741325941072e-20,  9.083976129509319e-23, -3.257032134367584e-25,
  1.154371893951785e-27, -4.052927700194663e-30,  7.487560996506335e-03, -4.849816656355719e-05,  2.348945888803851e-07, -1.007245937953247e-09,  4.028198925291792e-12,
 -1.536818522198193e-14,  5.656397566482525e-17, -2.021004779432028e-19,  7.030148571061282e-22, -2.384430324577514e-24,  7.879195797616042e-27, -2.533580250057885e-29,
  2.078244469728781e-02, -1.340026390577759e-04,  6.426567573792004e-07, -2.708542405652334e-09,  1.054219062504087e-11, -3.864460000152792e-14,  1.343766273796824e-16,
 -4.434009136517247e-19,  1.379296214041096e-21, -3.984080732857764e-24,  1.030821288255799e-26, -2.174475479569279e-29,  4.068514610829159e-02, -2.605392878133330e-04,
  1.230842086496624e-06, -5.050105289415412e-09,  1.882041344099037e-11, -6.449858308948343e-14,  2.021334579706864e-16, -5.645383616976304e-19,  1.302827562594065e-21,
 -1.810653694465531e-24, -3.748513782028764e-27,  4.618300805152263e-29,  6.714695958677319e-02, -4.260298223488799e-04,  1.971668747902576e-06, -7.790786717206104e-09,
  2.723639591279645e-11, -8.377966614467748e-14,  2.156658473913727e-16, -3.826362795886297e-19, -1.507355903570897e-22,  5.625788355914086e-24, -3.417257825030270e-26,
  1.484479537726816e-28,  1.001009871680794e-01, -6.276803324710012e-04,  2.828742050988592e-06, -1.062816978702466e-08,  3.389150580745908e-11, -8.700031724838974e-14,
  1.379011593373778e-16,  1.980629973528768e-19, -2.943866197013755e-21,  1.585146374897122e-23, -6.105484080412942e-26,  1.728093418850038e-28,  1.394604022786398e-01,
 -8.619634843767210e-04,  3.757680354457522e-06, -1.321542832682573e-08,  3.683568220043442e-11, -6.633730882342213e-14, -4.732849582850508e-17,  1.113043364993993e-18,
 -6.109527012560467e-21,  2.220998212557161e-23, -5.134097729735238e-26, -2.286466470227962e-30,  1.851162057466628e-01, -1.124598741935007e-03,  4.706987391248262e-06,
 -1.518287767606187e-08,  3.432727530898563e-11, -1.771009839759380e-14, -3.238829972137101e-16,  2.104374010202758e-18, -7.871401218722528e-21,  1.642889339446140e-23,
  1.913238009125321e-26, -3.741609421660462e-28,  2.369344250838092e-01, -1.410532657195789e-03,  5.619232714787605e-06, -1.616432680358259e-08,  2.511707307627564e-11,
  5.736663032869881e-14, -6.376770399153679e-16,  2.751591941629592e-18, -6.241956947881141e-21, -6.359950554170943e-24,  1.374073360124253e-25, -7.155931145262089e-28,
  2.947526989185266e-01, -1.713922104720163e-03,  6.432614682155316e-06, -1.582811970869830e-08,  8.734526191477793e-12,  1.505249563828227e-13, -9.000478599396183e-16,
  2.579353634946366e-18, -1.911611064468502e-23, -4.204010618586255e-23,  2.377666343911240e-25, -6.302214508934887e-28,  3.583761807141925e-01, -2.028124427803658e-03,
  7.082991186405042e-06, -1.391235198460704e-08, -1.425472465455281e-11,  2.462950118050980e-13, -1.002521372848664e-15,  1.234384163734596e-18,  1.011701267100102e-20,
 -7.463024843443298e-23,  2.195946743848836e-25,  1.739763833202081e-28,  4.275726907251016e-01, -2.345699885259343e-03,  7.506469613077685e-06, -1.026310262427058e-08,
 -4.206125318039309e-11,  3.232807904320223e-13, -8.435119207551190e-16, -1.304289910589910e-18,  2.091654005570782e-20, -7.967544998322119e-23,  7.742724374418256e-27,
  1.493528176209320e-27,  5.020670444490467e-01, -2.658433597128404e-03,  7.642644931193166e-06, -4.873562371727624e-09, -7.160595262715555e-11,  3.570923912802765e-13,
 -3.643892357906514e-16, -4.550430800851498e-18,  2.688954375614754e-20, -3.578240560204973e-23, -3.635816657595244e-25,  2.422775046365129e-27,  5.815344925264254e-01,
 -2.957386431638154e-03,  7.438556825857212e-06,  2.079390809190102e-09, -9.863577923976595e-11,  3.251504234945870e-13,  4.119896665523975e-16, -7.466201416531173e-18,
  2.210970380754973e-20,  5.808523318802211e-23, -6.978508756508436e-25,  1.711653474598740e-27,  6.655932253552967e-01, -3.232986954947127e-03,  6.853393726692319e-06,
  1.020633800926379e-08, -1.180823650978296e-10,  2.130774083381023e-13,  1.352212798455813e-15, -8.646802509211552e-18,  3.415913126369588e-21,  1.680207772422860e-22,
 -6.876554927860577e-25, -1.187174158863744e-27,  7.537959316516473e-01, -3.475179589732927e-03,  5.863890387186079e-06,  1.889138135423963e-08, -1.247121614801486e-10,
  2.177271915229681e-14,  2.208887889952285e-15, -6.789631086944935e-18, -2.599594753140520e-20,  2.267106305118326e-22, -1.114699461977253e-25, -4.920928007804996e-27,
  8.456204620012752e-01, -3.673647242393703e-03,  4.470229970798278e-06,  2.730237115519804e-08, -1.140808733086061e-10, -2.265390266638044e-13,  2.659766556765205e-15,
 -1.393561612239337e-18, -5.467600631172854e-20,  1.628653875598610e-22,  8.910066539348283e-25, -6.165096468717402e-27,  9.404597468585563e-01, -3.818129327166498e-03,
  2.702053695330274e-06,  3.443603571143267e-08, -8.373519191570157e-11, -4.858327463257726e-13,  2.399581210624298e-15,  6.541898076462853e-18, -6.534386696415956e-20,
 -4.371344197807611e-23,  1.681916867810510e-24, -1.877204530008239e-27,  1.037611266616583e+00, -3.898857373285647e-03,  6.238871118991197e-07,  3.920860130007434e-08,
 -3.449394346447986e-11, -6.904244561354151e-13,  1.276540814999695e-15,  1.423705690901880e-17, -4.319815678831417e-20, -3.102603164738512e-22,  1.406058613983109e-24,
  6.760100061142724e-27,  1.136266583935906e+00, -3.907128670819862e-03, -1.661087226606030e-06,  4.059905672324963e-08,  2.850640352988947e-11, -7.683012260849094e-13,
 -5.651629216377836e-16,  1.776199136181319e-17,  1.186255549283601e-20, -4.559073798011202e-22, -2.511980181352283e-25,  1.247278239046852e-26,  1.235501738921457e+00,
 -3.836031343546412e-03, -4.010411540709897e-06,  3.784338313063864e-08,  9.546904001794052e-11, -6.639730472728921e-13, -2.610797030365956e-15,  1.381878924864897e-17,
  7.646792956593556e-20, -3.073108796607154e-22, -2.328653762555394e-24,  6.893330462917298e-27,  1.334269682778862e+00, -3.681318697593461e-03, -6.246776644875471e-06,
  3.066183535969826e-08,  1.528465149762203e-10, -3.666183324210129e-13, -4.060434852839892e-15,  2.207482324234998e-18,  1.093025900512900e-19,  1.259282158605386e-22,
 -2.866738151049120e-24, -8.616604129620853e-27,  1.431396375858093e+00, -3.442403116093420e-03, -8.169530477690721e-06,  1.947729027658687e-08,  1.859400213564083e-10,
  6.704037226437954e-14, -4.131242566850196e-15, -1.250146917541932e-17,  7.677919965399865e-20,  5.550872980940812e-22, -7.073060114616994e-25, -1.845533314692310e-26,
  1.525582661403819e+00, -3.123397237560633e-03, -9.574937975916498e-06,  5.554440654608423e-09,  1.831708118850109e-10,  5.109797905205257e-13, -2.516091485107720e-15,
 -2.211025998304036e-17, -1.276737634111421e-20,  5.798473671843572e-22,  2.556125335781804e-24, -7.847777450601084e-27,  1.615414457682298e+00, -2.734072613681967e-03,
 -1.028557266496758e-05, -9.031882272923114e-09,  1.411379112408257e-10,  8.037329686672513e-13,  2.405195758802597e-16, -1.965041396751045e-17, -9.851072863944455e-20,
  9.546168730972716e-23,  3.387527154658805e-24,  1.355691847998162e-26,  1.699384033156854e+00, -2.290539783540605e-03, -1.018670402740260e-05, -2.168605002279060e-08,
  6.847836788671377e-11,  8.181640727374718e-13,  2.803320253570928e-15, -5.570423288992696e-18, -1.085762417235643e-19, -4.663978424084999e-22,  5.059936684780579e-25,
  1.729009166856931e-26,  1.775924917536325e+00, -1.815395429475333e-03, -9.263832632098290e-06, -2.987018678694914e-08, -1.416358525482416e-11,  5.402479643346805e-13,
  3.747093560606484e-15,  1.045271750883091e-17, -3.272261435480171e-20, -5.180013050937766e-22, -2.571675058144126e-24, -2.027814530069200e-27,  1.843462093582680e+00,
 -1.337061351453572e-03, -7.631418785390116e-06, -3.188542403242751e-08, -8.009272755167951e-11,  1.041916937891571e-13,  2.594589107307950e-15,  1.637459560136249e-17,
  5.335919250766385e-20, -5.021453871606430e-23, -1.927496162612920e-24, -1.354985597983309e-26,  1.900477300863540e+00, -8.880944261436144e-04, -5.540214228980820e-06,
 -2.761322368546523e-08, -1.077398107484943e-10, -2.638954082041411e-13,  3.433569026268753e-16,  9.126195457769166e-18,  6.591496531430658e-20,  3.043922326628994e-22,
  7.405245140205433e-25, -2.373144782958340e-27,  1.945586574672874e+00, -5.024080739079267e-04, -3.352068787271355e-06, -1.886087984572730e-08, -9.225010678792041e-11,
 -3.850018905460615e-13, -1.248858779864548e-15, -1.854429018578054e-18,  1.406567861221016e-20,  1.714037753741241e-22,  1.170370186057128e-24,  6.011099310660923e-27,
  1.977624124474024e+00, -2.116115194096796e-04, -1.478682666509319e-06, -9.000878540005651e-09, -5.002408499037926e-11, -2.578187436591074e-13, -1.233194324592729e-15,
 -5.408769102786186e-18, -2.103785063273465e-20, -6.601032696544348e-23, -1.037427796934259e-25,  6.635730404536538e-28,  1.995727948698612e+00, -4.094851485643402e-05,
 -2.935615986831154e-07, -1.863872363966037e-09, -1.104367831829102e-11, -6.246998773966484e-14, -3.412940692596856e-16, -1.812422943578723e-18, -9.388567393879676e-21,
 -4.752316477553490e-23, -2.351607133797254e-25, -1.136722585550952e-27,  8.110767026447881e-04, -5.197917221382912e-06,  2.497492133141914e-08, -1.066257358425890e-10,
  4.265164454854517e-13, -1.636914554782837e-15,  6.102583920981192e-18, -2.226957144684805e-20,  7.990436545973793e-23, -2.829044038898395e-25,  9.900804801456027e-28,
 -3.433109697384323e-30,  7.297251609605673e-03, -4.666628487722952e-05,  2.231844354966464e-07, -9.451817846158801e-10,  3.733965020242482e-12, -1.407609065864607e-14,
  5.120762976335363e-17, -1.809187225476829e-19,  6.225895582236429e-22, -2.090486030851053e-24,  6.843549420598330e-27, -2.182908054708186e-29,  2.025651477211831e-02,
 -1.289885851803151e-04,  6.111413496608653e-07, -2.545879397644675e-09,  9.800568606433630e-12, -3.556368584357209e-14,  1.225583212802457e-16, -4.014805371051449e-19,
  1.243063736151524e-21, -3.590544517867347e-24,  9.377455167740984e-27, -2.053044845266482e-29,  3.966230572232885e-02, -2.509299333745084e-04,  1.172005852978421e-06,
 -4.759040156053885e-09,  1.757769752430392e-11, -5.983241513292182e-14,  1.869000670061224e-16, -5.239159886871450e-19,  1.235403303179163e-21, -1.923378508674493e-24,
 -1.967906778055669e-27,  3.516602680879469e-29,  6.547380519071469e-02, -4.106231473644851e-04,  1.880739607724922e-06, -7.368131551116709e-09,  2.561169251800750e-11,
 -7.873261864440235e-14,  2.049131398138158e-16, -3.844708287427779e-19,  2.869784108642523e-23,  4.382447210327485e-24, -2.816337594396955e-26,  1.252531160782469e-28,
  9.763473081157915e-02, -6.055514607868673e-04,  2.704400765092316e-06, -1.009964422111954e-08,  3.218499210997011e-11, -8.363427448173970e-14,  1.422105839145624e-16,
  1.125330275914252e-19, -2.415374711801181e-21,  1.355756409848255e-23, -5.373640354750076e-26,  1.596098003514871e-28,  1.360716808657706e-01, -8.325264639778413e-04,
  3.602587485503516e-06, -1.263672288935528e-08,  3.549999047596097e-11, -6.712057757317735e-14, -1.878297313083702e-17,  9.299355281801574e-19, -5.346862998285186e-21,
  2.016453515158631e-23, -5.069941790538028e-26,  2.960236994483432e-29,  1.806919818213244e-01, -1.087662313480469e-03,  4.528075274340079e-06, -1.463687770168695e-08,
  3.389996937700166e-11, -2.480413264517554e-14, -2.683971247715504e-16,  1.862069375437321e-18, -7.269901946692107e-21,  1.689230877508228e-23,  4.687109218301620e-27,
 -2.850694652432772e-28,  2.313809834428957e-01, -1.366347769396912e-03,  5.427707271179823e-06, -1.575408071763997e-08,  2.611748638965671e-11,  4.296417022115838e-14,
 -5.634560678244476e-16,  2.549186873385346e-18, -6.379313367225847e-21, -1.465207656908613e-24,  1.080242194208060e-25, -6.203165093418281e-28,  2.879987330437159e-01,
 -1.663218339923241e-03,  6.243611371887718e-06, -1.566543242209526e-08,  1.153485774999161e-11,  1.297890672946008e-13, -8.280492726733194e-16,  2.556307750259000e-18,
 -1.368106872861914e-21, -3.308971779921831e-23,  2.096711842320387e-25, -6.415830294908189e-28,  3.503759485323457e-01, -1.972131802556822e-03,  6.914832862705461e-06,
 -1.410231528674665e-08, -9.566451210717894e-12,  2.226834134572110e-13, -9.638179405376721e-16,  1.516847690379603e-18,  7.589658056711986e-21, -6.576046677736804e-23,
  2.223402450480991e-25, -3.951245202444242e-29,  4.183091991893368e-01, -2.286151713757221e-03,  7.379484272882974e-06, -1.088546877822227e-08, -3.580065870293390e-11,
  3.026712520075466e-13, -8.710914933246539e-16, -6.806719015894613e-19,  1.806864566263842e-20, -7.815976629662725e-23,  6.541726887122187e-26,  1.133411714184338e-27,
  4.915551952034767e-01, -2.597545306006509e-03,  7.577522038888473e-06, -5.962639581683857e-09, -6.456138148333070e-11,  3.469140519431264e-13, -4.799672581952404e-16,
 -3.713177963307806e-18,  2.536474192685784e-20, -4.825474875315393e-23, -2.616694150466355e-25,  2.198937507799188e-27,  5.698240845222238e-01, -2.897804497832349e-03,
  7.454256629586300e-06,  5.537100266525153e-10, -9.205040589888358e-11,  3.326112238016625e-13,  2.131180052329955e-16, -6.730467807518979e-18,  2.371738196615282e-20,
  3.177518679314788e-23, -6.155392113651438e-25,  2.002022558971608e-27,  6.527716626141369e-01, -3.177701684386380e-03,  6.964679994357204e-06,  8.352793812883005e-09,
 -1.135158099522875e-10,  2.426429388224960e-13,  1.112503627168885e-15, -8.446107603898437e-18,  8.959473288475397e-21,  1.397439461162498e-22, -7.196463042375432e-25,
 -2.897609458221638e-28,  7.399904234612302e-01, -3.427395550557565e-03,  6.078638115798900e-06,  1.690228456314530e-08, -1.237624268425098e-10,  7.241821145956316e-14,
  2.008350482219868e-15, -7.492184323047563e-18, -1.796438687530406e-20,  2.181886888453961e-22, -3.078034323189567e-25, -3.985418386392499e-27,  8.309994274586892e-01,
 -3.636606240695249e-03,  4.786768335263431e-06,  2.544428252156575e-08, -1.179774684087115e-10, -1.633649241852639e-13,  2.597179354144219e-15, -3.043039687428837e-18,
 -4.823732375619237e-20,  1.930180025259723e-22,  6.158234977727912e-25, -6.275857247566121e-27,  9.252330464457718e-01, -3.794883461706550e-03,  3.106937191564989e-06,
  3.302172646902700e-08, -9.286233596744460e-11, -4.262819974149533e-13,  2.553335201391159e-15,  4.438505232355717e-18, -6.573146808793489e-20,  2.136795340474928e-23,
  1.559336188973918e-24, -3.635378935193277e-27,  1.022028784556074e+00, -3.891994683849953e-03,  1.090628984183370e-06,  3.854802749911493e-08, -4.796462277106981e-11,
 -6.551699487116596e-13,  1.654227074448989e-15,  1.268740372313180e-17, -5.328940859016239e-20, -2.487239718117501e-22,  1.654070452246993e-24,  4.472034987543372e-27,
  1.120614586787090e+00, -3.918462031932197e-03, -1.171670933787703e-06,  4.093166368230631e-08,  1.304518127003048e-11, -7.758694201234467e-13, -6.498770880046182e-17,
  1.787812622246964e-17, -4.598553091460225e-21, -4.549744061631345e-22,  2.963766532494077e-25,  1.227145074136107e-26,  1.220096358362204e+00, -3.866273216587778e-03,
 -3.547574794386740e-06,  3.926138399650490e-08,  8.159571216291490e-11, -7.217234040937536e-13, -2.191400902547063e-15,  1.607142801319964e-17,  6.381029686172906e-20,
 -3.933989957927269e-22, -1.952096063402673e-24,  1.013647816289373e-26,  1.319446847776845e+00, -3.729780159929618e-03, -5.864420399857765e-06,  3.304345403084248e-08,
  1.445467080178606e-10, -4.629284362527401e-13, -3.949138040130086e-15,  5.754889297928430e-18,  1.116901260522445e-19,  4.736485338034482e-24, -3.165058830898171e-24,
 -4.805367603164879e-27,  1.417497602670670e+00, -3.506773807964149e-03, -7.917926268696749e-06,  2.245755615274172e-08,  1.862624896182661e-10, -3.601407992891954e-14,
 -4.443930725698863e-15, -9.731874358559344e-18,  9.605427947416231e-20,  5.102324456564836e-22, -1.540983112916903e-24, -1.921246068043994e-26,  1.512936366916918e+00,
 -3.199679551430270e-03, -9.490374248007690e-06,  8.563438361483423e-09,  1.927362454320767e-10,  4.431383557957020e-13, -3.137624097778771e-15, -2.216585972457157e-17,
  9.850047618575443e-21,  6.736146259954204e-22,  2.092877628633118e-24, -1.324449018841919e-26,  1.604312967450921e+00, -2.816751113081772e-03, -1.037987505951597e-05,
 -6.644958211140517e-09,  1.572239041762164e-10,  8.025508232213252e-13, -3.531151618350066e-16, -2.272049136753858e-17, -9.249732267473857e-20,  2.422114373119779e-22,
  3.930106397681228e-24,  1.082778304355102e-26,  1.690057266583306e+00, -2.373054452978389e-03, -1.043981103717824e-05, -2.045589464633356e-08,  8.549971820592680e-11,
  8.831641485113526e-13,  2.596218929803107e-15, -9.308040442815349e-18, -1.248077535572867e-19, -4.297213530883236e-22,  1.357594219316863e-24,  2.136871936882840e-26,
  1.768512840046535e+00, -1.890942858586197e-03, -9.623261920070718e-06, -3.000538111332580e-08, -2.436303985295704e-12,  6.335540540680858e-13,  4.022164232417219e-15,
  9.087257106281387e-18, -5.323454877827033e-20, -6.216203834435161e-22, -2.581214326951205e-24,  1.828503584439079e-27,  1.837989291665916e+00, -1.399664806171474e-03,
 -8.021652615327127e-06, -3.314669432741474e-08, -7.734806665153097e-11,  1.721544113654336e-13,  3.076597899355021e-15,  1.803707947996904e-17,  5.001387605155642e-20,
 -1.399069419524971e-22, -2.573292626321998e-24, -1.576478383556755e-26,  1.896834139229580e+00, -9.337712777037741e-04, -5.882088407667751e-06, -2.937874488417491e-08,
 -1.129133395329142e-10, -2.523397684087776e-13,  6.301070407373722e-16,  1.141627885195975e-17,  7.737524706964694e-20,  3.312708432242247e-22,  5.857568875883901e-25,
 -4.799436692751580e-27,  1.943521839640763e+00, -5.301556343346115e-04, -3.587514777967628e-06, -2.040012703148443e-08, -1.002537882781741e-10, -4.155406901416394e-13,
 -1.293486221312605e-15, -1.296026510354922e-18,  2.114561529560771e-20,  2.238382816122055e-22,  1.459675187658563e-24,  7.152577294139828e-27,  1.976753315667556e+00,
 -2.238870320562019e-04, -1.591671034581617e-06, -9.844175872746063e-09, -5.548909616219626e-11, -2.893110495763652e-13, -1.394427404390420e-15, -6.120737994182799e-18,
 -2.348063874393812e-20, -6.943702063091875e-23, -6.380279381312272e-26,  1.184894239615379e-27,  1.995559311629595e+00, -4.338957533391202e-05, -3.170309806478965e-07,
 -2.051029348514292e-09, -1.237928163110887e-11, -7.130561679626444e-14, -3.965187182183639e-16, -2.142148440165129e-18, -1.128149520529628e-20, -5.801040488464483e-23,
 -2.913148359809066e-25, -1.427185736435942e-27,  7.906766895104415e-04, -5.003122311019710e-06,  2.373530292676286e-08, -1.000556282001070e-10,  3.951937214341002e-13,
 -1.497655326898118e-15,  5.513354827993499e-18, -1.986822705977308e-20,  7.039772404264016e-23, -2.461628828880267e-25,  8.507735631439627e-28, -2.914117949214200e-30,
  7.114086993419407e-03, -4.492518345064864e-05,  2.121916361939305e-07, -8.876254267635887e-10,  3.464334061151325e-12, -1.290571264579807e-14,  4.640987800545108e-17,
 -1.621489675524475e-19,  5.520363565726611e-22, -1.835036158531965e-24,  5.950798824075181e-27, -1.882726549923449e-29,  1.975014889959131e-02, -1.242190438765949e-04,
  5.815086868771137e-07, -2.394604416356222e-09,  9.117821061646007e-12, -3.275280556578501e-14,  1.118548327838076e-16, -3.637000008391674e-19,  1.120341754973979e-21,
 -3.233120715043202e-24,  8.503633763511016e-27, -1.917263618058177e-29,  3.867698302732309e-02, -2.417776287307375e-04,  1.116546116703576e-06, -4.487131372532848e-09,
  1.642473981023939e-11, -5.551844652920314e-14,  1.727733790737249e-16, -4.855032808326532e-19,  1.165092590316866e-21, -1.973875067733384e-24, -6.206747641725021e-28,
  2.640583558680206e-29,  6.386085413625692e-02, -3.959240523924884e-04,  1.794729643625610e-06, -6.970678139580025e-09,  2.408534844627922e-11, -7.394364345147631e-14,
  1.941830415465180e-16, -3.812352194908939e-19,  1.674604992839782e-22,  3.360028795676318e-24, -2.310314774399498e-26,  1.052563681389620e-28,  9.525504000066966e-02,
 -5.843924091854775e-04,  2.586240198319045e-06, -9.597879468863293e-09,  3.054664910765704e-11, -8.019170688274846e-14,  1.443499150547686e-16,  4.264883922277121e-20,
 -1.964337612515951e-21,  1.154443699208132e-23, -4.702315840316048e-26,  1.454517124288643e-28,  1.327982695160259e-01, -8.043027729349309e-04,  3.454310454367060e-06,
 -1.207947831355460e-08,  3.415508297815747e-11, -6.727758801652709e-14,  4.966183926913532e-18,  7.700622702263317e-19, -4.657063617017048e-21,  1.816970514328940e-23,
 -4.888263303403486e-26,  5.152969297368368e-29,  1.764126823342081e-01, -1.052131100513788e-03,  4.355669681856372e-06, -1.409877958157495e-08,  3.334356111484914e-11,
 -3.064573367728028e-14, -2.194245544423273e-16,  1.639175518614663e-18, -6.661217467725584e-21,  1.685173576601530e-23, -6.177600440919175e-27, -2.111541345950449e-28,
  2.260012484808590e-01, -1.323675142494885e-03,  5.241191622885072e-06, -1.533003756197782e-08,  2.684720257461553e-11,  3.027466357105861e-14, -4.949390529396298e-16,
  2.344987088849530e-18, -6.360611726590439e-21,  2.337217250374209e-24,  8.276440823433081e-26, -5.287276601625497e-28,  2.814445715739016e-01, -1.614018061838530e-03,
  6.056815758521644e-06, -1.546116399007247e-08,  1.393767494478962e-11,  1.107688128898055e-13, -7.572534279391055e-16,  2.495032242926204e-18, -2.415152601057237e-21,
 -2.526446428793385e-23,  1.817080324209883e-25, -6.257146881005646e-28,  3.425969836345041e-01, -1.917492322476746e-03,  6.744829640419093e-06, -1.422099107182915e-08,
 -5.340526260638926e-12,  2.000867616814812e-13, -9.182897314083027e-16,  1.723548697261924e-18,  5.381481870311748e-21, -5.695199239641305e-23,  2.169309986291263e-25,
 -1.978680720384454e-28,  4.092818236368171e-01, -2.227647627201775e-03,  7.245617852896467e-06, -1.141099315807837e-08, -2.995751267770491e-11,  2.815991070862757e-13,
 -8.824744175983154e-16, -1.468986200311629e-19,  1.531311572946417e-20, -7.464366905860987e-23,  1.080358995138851e-25,  8.106238432456779e-28,  4.812857770697817e-01,
 -2.537228374016880e-03,  7.499999314517363e-06, -6.940775034965516e-09, -5.774624711738523e-11,  3.342372560901718e-13, -5.728473202130979e-16, -2.931136401766737e-18,
  2.346178236174128e-20, -5.686436009984610e-23, -1.708074302156215e-25,  1.925269092803466e-27,  5.583521420400208e-01, -2.838168397361987e-03,  7.452284563225643e-06,
 -8.656632852355988e-10, -8.536185069170598e-11,  3.355512722003245e-13,  3.542939572990215e-17, -5.957785539423214e-18,  2.443980406023510e-20,  8.965389846523960e-24,
 -5.239750902505089e-25,  2.136402864018979e-27,  6.401728824764052e-01, -3.121613808783042e-03,  7.054180627740276e-06,  6.576734662088612e-09, -1.084149196416434e-10,
  2.665419806337193e-13,  8.807430682099777e-16, -8.084478480512753e-18,  1.347116506713632e-20,  1.109345419481827e-22, -7.153828656679435e-25,  4.570721426158672e-28,
  7.263793366838298e-01, -3.377988672620355e-03,  6.269640419372741e-06,  1.493621913429071e-08, -1.218493560272777e-10,  1.180434545788545e-13,  1.791683270712383e-15,
 -7.944069785033790e-18, -1.037081172299643e-20,  2.026623126338043e-22, -4.612055965263355e-25, -2.982992248101563e-27,  8.165314789515398e-01, -3.597123084791176e-03,
  5.080676951663331e-06,  2.353385933695811e-08, -1.206292190988222e-10, -1.022229299887485e-13,  2.491439314451527e-15, -4.471238945414182e-18, -4.091139117091123e-20,
  2.121816245440169e-22,  3.443104395923341e-25, -6.008923074175380e-27,  9.101056967593005e-01, -3.768468805983223e-03,  3.494012669298630e-06,  3.147109151467109e-08,
 -1.007663327699558e-10, -3.637471668786178e-13,  2.648365176751003e-15,  2.359104995509126e-18, -6.388203000543761e-20,  8.011109972450120e-23,  1.367923039186635e-24,
 -4.993554037488589e-27,  1.006481165821503e+00, -3.881433374292410e-03,  1.548175607132878e-06,  3.767804067097280e-08, -6.064326150605060e-11, -6.114060340477305e-13,
  1.984347689714784e-15,  1.085198937707873e-17, -6.101160244424827e-20, -1.793388796426165e-22,  1.797419980167283e-24,  2.036206459947756e-27,  1.104925106185702e+00,
 -3.925868310285431e-03, -6.797505166187983e-07,  4.101633243922260e-08, -2.447406370946537e-12, -7.714537296536081e-13,  4.310997151884027e-16,  1.747223756669320e-17,
 -2.063629129495083e-20, -4.325712628155577e-22,  8.161025145843015e-25,  1.121907486501179e-26,  1.204577518028306e+00, -3.892748189286592e-03, -3.069090164318051e-06,
  4.044873903821660e-08,  6.667289292942222e-11, -7.686998901964790e-13, -1.715045124532140e-15,  1.787261179224472e-17,  4.835743923782052e-20, -4.617466930044054e-22,
 -1.446489056969479e-24,  1.271381993780832e-26,  1.304436462249684e+00, -3.775070857437249e-03, -5.454344514270243e-06,  3.527704517935161e-08,  1.343554829753174e-10,
 -5.553709597858949e-13, -3.738114556859842e-15,  9.306929803263384e-18,  1.095424639232959e-19, -1.248099724459272e-22, -3.279484985734155e-24, -3.106833690409999e-28,
  1.403345598797451e+00, -3.568988684845443e-03, -7.630597173953958e-06,  2.542611266250147e-08,  1.844554581584608e-10, -1.455744886961431e-13, -4.670723889089884e-15,
 -6.377789557346736e-18,  1.131101278251151e-19,  4.317870384644456e-22, -2.375961229978031e-24, -1.847885356879619e-26,  1.499986528408554e+00, -3.275138430169904e-03,
 -9.368831664516260e-06,  1.171381887771625e-08,  2.007959917647693e-10,  3.604462211243824e-13, -3.750101628256885e-15, -2.144773496822583e-17,  3.545202348381069e-20,
  7.440766021503080e-22,  1.391133404984508e-24, -1.860205586458379e-26,  1.592879441958002e+00, -2.900065090862348e-03, -1.044399347650809e-05, -4.001650277353803e-09,
  1.731369525482789e-10,  7.861166674081379e-13, -1.029195496232907e-15, -2.550968829506448e-17, -8.084381655583022e-20,  4.077545049506264e-22,  4.314366203187952e-24,
  6.340130021232191e-27,  1.680396491775688e+00, -2.457530204364351e-03, -1.067648020727773e-05, -1.894330433284409e-08,  1.037625915334992e-10,  9.418807236282032e-13,
  2.277439973341966e-15, -1.353702194161041e-17, -1.390636197838489e-19, -3.555212565739194e-22,  2.377975115932969e-24,  2.486866986379809e-26,  1.760792816390036e+00,
 -1.969368877422456e-03, -9.983125015866998e-06, -2.993766565058341e-08,  1.121962124071045e-11,  7.329254333445015e-13,  4.249253402400261e-15,  7.006014013291593e-18,
 -7.743884487273936e-20, -7.217967755242255e-22, -2.388607545576388e-24,  7.184195834580924e-27,  1.832259737527844e+00, -1.465449818490803e-03, -8.426711267325194e-06,
 -3.435253190450467e-08, -7.312477461831460e-11,  2.522286714705953e-13,  3.603135499685571e-15,  1.953567954675685e-17,  4.295201039108274e-20, -2.572832207729285e-22,
 -3.308623017652346e-24, -1.755643158269216e-26,  1.893002664062627e+00, -9.822692548055721e-04, -6.245636600159170e-06, -3.122479716074589e-08, -1.177815237883643e-10,
 -2.330903709772820e-13,  9.862493844105204e-16,  1.408715440960077e-17,  8.966365235754535e-20,  3.495632581324262e-22,  3.044192269437255e-25, -8.158823166064405e-27,
  1.941342227113253e+00, -5.598628703218640e-04, -3.842220416745789e-06, -2.207237172347982e-08, -1.088775498793806e-10, -4.469354975501213e-13, -1.319006306795829e-15,
 -4.785308398815582e-19,  3.033378075570279e-20,  2.888685742393445e-22,  1.800501648717844e-24,  8.340255224116725e-27,  1.975831530742578e+00, -2.371084656708850e-04,
 -1.715325096594974e-06, -1.078016933932252e-08, -6.162431022755290e-11, -3.249211058605390e-13, -1.576706051023167e-15, -6.912492925591152e-18, -2.601192604957546e-20,
 -7.074292567378353e-23,  4.029388186297384e-27,  1.944510951263494e-27,  1.995380520053439e+00, -4.602775160058738e-05, -3.428805380127158e-07, -2.261044966416760e-09,
 -1.390563617211512e-11, -8.158463501061371e-14, -4.618837114495077e-16, -2.538948064549270e-18, -1.359567086294523e-20, -7.102122730736632e-23, -3.619138851460626e-25,
 -1.796545642646870e-27,  7.710365096962507e-04, -4.817937295714746e-06,  2.257160831550252e-08, -9.396514876310480e-11,  3.665200405968145e-13, -1.371763936749337e-15,
  4.987295831145749e-18, -1.775096442689664e-20,  6.211874351632979e-23, -2.145626468737767e-25,  7.324083529529292e-28, -2.478637396040456e-30,  6.937715171190825e-03,
 -4.326933331373656e-05,  2.018643812745767e-07, -8.342019858383820e-10,  3.217000488382395e-12, -1.184442090071157e-14,  4.210740636776382e-17, -1.454964175520866e-19,
  4.900671927535671e-22, -1.612786432300843e-24,  5.180407564555595e-27, -1.625600040641078e-29,  1.926239830991909e-02, -1.196794841997633e-04,  5.536275910378274e-07,
 -2.253817260452104e-09,  8.488805727586404e-12, -3.018654686332549e-14,  1.021561068220239e-16, -3.296473194155706e-19,  1.009872497669879e-21, -2.909431739736086e-24,
  7.691159502531297e-27, -1.775324695238122e-29,  3.772740242594042e-02, -2.330562575207066e-04,  1.064241390426723e-06, -4.232997737564471e-09,  1.535475686336833e-11,
 -5.153086733545898e-14,  1.596905444293554e-16, -4.493599206895432e-19,  1.093846318279070e-21, -1.977625584494806e-24,  3.826803402724134e-28,  1.947090014648615e-29,
  6.230535293208751e-02, -3.818943673465950e-04,  1.713345706938518e-06, -6.596893949800091e-09,  2.265221844701524e-11, -6.941063434119180e-14,  1.836004414852087e-16,
 -3.741107219647654e-19,  2.728553343277608e-22,  2.523287438845697e-24, -1.885873367267510e-26,  8.811411610897582e-29,  9.295813233901265e-02, -5.641549977918218e-04,
  2.473945807026750e-06, -9.121775240934854e-09,  2.897752055092512e-11, -7.671971061559296e-14,  1.447240209009154e-16, -1.391112246712940e-20, -1.581090697914017e-21,
  9.787278893982401e-24, -4.093928114205399e-26,  1.311074361900424e-28,  1.296354223320277e-01, -7.772389162611430e-04,  3.312591239657531e-06, -1.154374788845126e-08,
  3.281238508798912e-11, -6.691590760121507e-14,  2.453723405792630e-17,  6.311293347773125e-19, -4.037559907128708e-21,  1.626441234322298e-23, -4.627903372091132e-26,
  6.569671718511172e-29,  1.722727898800785e-01, -1.017953463394970e-03,  4.189664197321615e-06, -1.357045687198728e-08,  3.268158008460751e-11, -3.538468854975834e-14,
 -1.764211034109741e-16,  1.435658432598707e-18, -6.061070051607515e-21,  1.643750960374707e-23, -1.409422648130509e-26, -1.507860548889554e-28,  2.207892522588383e-01,
 -1.282474106942157e-03,  5.059826454248189e-06, -1.489626186344532e-08,  2.733911044649708e-11,  1.916114148102723e-14, -4.321120200971547e-16,  2.143388729983229e-18,
 -6.222254102717483e-21,  5.208118153087321e-24,  6.140126805603152e-26, -4.435397984089288e-28,  2.750842388963300e-01, -1.566301718523900e-03,  5.872689780713534e-06,
 -1.522140205405749e-08,  1.597692059078920e-11,  9.342353669285638e-14, -6.886015529406758e-16,  2.404544485109152e-18, -3.200397764817798e-21, -1.853766259615634e-23,
  1.548859453579797e-25, -5.909631471439126e-28,  3.350338491640351e-01, -1.864217449113056e-03,  6.573793281066969e-06, -1.427560632533614e-08, -1.555178807504155e-12,
  1.786445448891224e-13, -8.679158578589712e-16,  1.864607242908722e-18,  3.484970671349919e-21, -4.848465925801991e-23,  2.056300031726322e-25, -3.086107737872691e-28,
  4.004862848293946e-01, -2.170238139942326e-03,  7.105992140129453e-06, -1.184640868418560e-08, -2.453738181328562e-11,  2.604232838571702e-13, -8.801249498017076e-16,
  3.010249558613479e-19,  1.271154157659913e-20, -6.969432514299497e-23,  1.373982535701819e-25,  5.315196574773677e-28,  4.712563145528212e-01, -2.477576740626593e-03,
  7.411384478632289e-06, -7.812010423518830e-09, -5.120520290150336e-11,  3.195869617065360e-13, -6.447244777392649e-16, -2.214271332362605e-18,  2.131131361506922e-20,
 -6.208895937474614e-23, -9.258911328688996e-26,  1.628131117999646e-27,  5.471186071067113e-01, -2.778614381054292e-03,  7.433923328488922e-06, -2.177773618545678e-09,
 -7.865537696573666e-11,  3.344882942597559e-13, -1.204188171209228e-16, -5.174408199377365e-18,  2.440805692939257e-20, -1.010356734199079e-23, -4.294354975335722e-25,
  2.141984156673342e-27,  6.277997528749100e-01, -3.064893757128403e-03,  7.122873041281159e-06,  4.885815111158321e-09, -1.028907705969379e-10,  2.850156350924081e-13,
  6.609740390285707e-16, -7.594975107612560e-18,  1.695627156008743e-20,  8.290489970085145e-23, -6.818597075228265e-25,  1.039168215765788e-27,  7.129687848577790e-01,
 -3.327147559544487e-03,  6.437262779476274e-06,  1.300777652838018e-08, -1.190766657868592e-10,  1.583437528065245e-13,  1.565673216979154e-15, -8.163001777101920e-18,
 -3.435973919083435e-21,  1.818845021218451e-22, -5.704381939086242e-25, -1.988978315521655e-27,  8.022260195167549e-01, -3.555380989570491e-03,  5.351445792865253e-06,
  2.159063986294050e-08, -1.220866073291334e-10, -4.407151792718397e-14,  2.349080644576845e-15, -5.656037403536146e-18, -3.308734849579738e-20,  2.208149882602747e-22,
  9.152620782116124e-26, -5.437968401200140e-27,  8.950900781461898e-01, -3.739034031042635e-03,  3.861763364535533e-06,  2.980410245235938e-08, -1.074014991944610e-10,
 -2.996217093957624e-13,  2.686307237419276e-15,  3.711360114046245e-19, -6.006887124749998e-20,  1.301334042544628e-22,  1.126593485757206e-24, -5.899436408488460e-27,
  9.909830421746515e-01, -3.867256830479511e-03,  1.994095468552338e-06,  3.661261038108522e-08, -7.237169011071085e-11, -5.603615048963683e-13,  2.259999346911050e-15,
  8.810327448865081e-18, -6.615856701153118e-20, -1.063623658767039e-22,  1.834011887883653e-24, -3.491271014491452e-28,  1.089213871697363e+00, -3.929339364293501e-03,
 -1.882963659974228e-07,  4.085446830588081e-08, -1.773383581270110e-11, -7.553254258908207e-13,  9.087866087603531e-16,  1.656995336783576e-17, -3.550656776443004e-20,
 -3.905332731057340e-22,  1.272730160582473e-24,  9.427875571218650e-27,  1.188960517977355e+00, -3.915342418197307e-03, -2.577818812377605e-06,  4.139045001661469e-08,
  5.092865653986520e-11, -8.036966461541608e-13, -1.195519937473198e-15,  1.914404618917623e-17,  3.083316712476240e-20, -5.078537775234818e-22, -8.466681274086664e-25,
  1.438604704235189e-26,  1.289251640803360e+00, -3.816976646055984e-03, -5.018503921268618e-06,  3.733309471832429e-08,  1.223740506204714e-10, -6.415675311442642e-13,
 -3.429301215476878e-15,  1.271513772282180e-17,  1.026975735321670e-19, -2.548552940981124e-22, -3.187677455537603e-24,  4.502148093639951e-27,  1.388949557376836e+00,
 -3.628763098059186e-03, -7.307892054118232e-06,  2.834796427002457e-08,  1.804107020623166e-10, -2.593921247271755e-13, -4.796431656921631e-15, -2.529456711652295e-18,
  1.267528568087627e-19,  3.210638645881277e-22, -3.142952802377950e-24, -1.611154510081771e-26,  1.486737041418227e+00, -3.349471688565975e-03, -9.208767920345233e-06,
  1.497913445316038e-08,  2.070570171577130e-10,  2.633906312547814e-13, -4.330661900142649e-15, -1.987563217467671e-17,  6.302971885072957e-20,  7.818895865604934e-22,
  4.648658092235270e-25, -2.334941277142913e-26,  1.581111841620997e+00, -2.983760839685053e-03, -1.047487831852892e-05, -1.107270366841586e-09,  1.885529741270454e-10,
  7.525671550120354e-13, -1.777237898614367e-15, -2.782807179732390e-17, -6.300652118001273e-20,  5.841876538763155e-22,  4.461556630396618e-24,  6.380327582078946e-29,
  1.670394149339629e+00, -2.543821650929544e-03, -1.089320776352081e-05, -1.712957023475616e-08,  1.231134431927907e-10,  9.914768737650785e-13,  1.834322300059122e-15,
 -1.817129070655897e-17, -1.498791914970118e-19, -2.377315882670824e-22,  3.528297256920072e-24,  2.716219016592031e-26,  1.752753341440346e+00, -2.050666683407726e-03,
 -1.034079807097348e-05, -2.963528126939136e-08,  2.691228895518588e-11,  8.369568651036271e-13,  4.406695493210683e-15,  4.094507377333147e-18, -1.050498092729019e-19,
 -8.090928175410233e-22, -1.925713680938599e-24,  1.411355494758417e-26,  1.826260472546323e+00, -1.534531905251898e-03, -8.845779423344219e-06, -3.547728456718326e-08,
 -6.717037882528003e-11,  3.454137169451975e-13,  4.167793640482587e-15,  2.073487272626343e-17,  3.111810488745608e-20, -4.054288664490647e-22, -4.105380053794818e-24,
 -1.846953277902975e-26,  1.888971238089366e+00, -1.033765519696865e-03, -6.631790485295766e-06, -3.314516983905789e-08, -1.221729564660015e-10, -2.043511849125539e-13,
  1.422763196491857e-15,  1.715931554162417e-17,  1.023695260301656e-19,  3.533277202166051e-22, -1.488562111139370e-25, -1.264578638865926e-26,  1.939039579886315e+00,
 -5.916904127228616e-04, -4.117841678545343e-06, -2.388764463952076e-08, -1.181332971304976e-10, -4.786326242930850e-13, -1.317148921512311e-15,  6.731766822979897e-19,
  4.212097185890326e-20,  3.685693612252893e-22,  2.192774354232756e-24,  9.468338034655817e-27,  1.974854808053369e+00, -2.513657839559384e-04, -1.850824354332040e-06,
 -1.182026923384678e-08, -6.851731540932582e-11, -3.651810554589700e-13, -1.782290782339103e-15, -7.785406979064015e-18, -2.853252728631256e-20, -6.857727394808308e-23,
  1.121853890090438e-25,  3.035582444999447e-27,  1.995190745610672e+00, -4.888323644154134e-05, -3.714038837785187e-07, -2.497216069664589e-09, -1.565420377479146e-11,
 -9.357455889050875e-14, -5.394703373395211e-16, -3.017873998075213e-18, -1.643323579129038e-20, -8.720902936413537e-23, -4.509004642713133e-25, -2.267148138855713e-27,
  7.521189029420350e-04, -4.641777106532006e-06,  2.147832770417655e-08, -8.831397194711623e-11,  3.402425849818258e-13, -1.257815479689405e-15,  4.516975921081613e-18,
 -1.588130503109001e-20,  5.489657033411588e-23, -1.873351395986877e-25,  6.316324122440003e-28, -2.112494278001640e-30,  6.767805480718453e-03, -4.169360258826278e-05,
  1.921551463259149e-07, -7.845715312278364e-10,  2.989896797840585e-12, -1.088101011299210e-14,  3.824460560601897e-17, -1.307045978875144e-19,  4.355705722948456e-22,
 -1.419202004804385e-24,  4.514859592441181e-27, -1.405206661667650e-29,  1.879237032474393e-02, -1.153563827782070e-04,  5.273772092294205e-07, -2.122696078508646e-09,
  7.908863085260858e-12, -2.784200479385240e-14,  9.336307350831867e-17, -2.989493591706578e-19,  9.104861618997315e-22, -2.616988041514515e-24,  6.941395559153427e-27,
 -1.633005356415925e-29,  3.681188934491381e-02, -2.247414107898016e-04,  1.014886126875970e-06, -3.995362537640610e-09,  1.436146626218105e-11, -4.784538949277608e-14,
  1.475878371462176e-16, -4.154914247200630e-19,  1.023118102981363e-21, -1.946888286053418e-24,  1.114423331804515e-27,  1.400709900034452e-29,  6.080469619136285e-02,
 -3.684981951635673e-04,  1.636312547335039e-06, -6.245328283924666e-09,  2.130722681996154e-11, -6.512885939103112e-14,  1.732602410919760e-16, -3.640642149428667e-19,
  3.510086902870499e-22,  1.842002433429248e-24, -1.531199560332276e-26,  7.348948901031065e-29,  9.074041320100429e-02, -5.447935100505022e-04,  2.367216321813090e-06,
 -8.670221576927988e-09,  2.747780034704840e-11, -7.325641093583123e-14,  1.436769604205826e-16, -5.917356943503225e-20, -1.256872616863615e-21,  8.260922306971305e-24,
 -3.548056809980620e-26,  1.171055223321052e-28,  1.265786032681315e-01, -7.512834627492980e-04,  3.177172208910315e-06, -1.102941852321829e-08,  3.148131406931084e-11,
 -6.612902595463949e-14,  4.048553801318533e-17,  5.109442742127988e-19, -3.484639155420351e-21,  1.447386146263992e-23, -4.318878605278482e-26,  7.392024953235188e-29,
  1.682669917759475e-01, -9.850786975695582e-04,  4.029932083859041e-06, -1.305342991379931e-08,  3.193469035794200e-11, -3.915778804460643e-14, -1.388499132529798e-16,
  1.251051330445648e-18, -5.480927678235608e-21,  1.575613428565928e-23, -1.962125830246570e-26, -1.022537900677471e-28,  2.157391914705634e-01, -1.242703054075824e-03,
  4.883706742386450e-06, -1.445631378509514e-08,  2.762337210935793e-11,  9.488321212133235e-15, -3.748533537906578e-16,  1.947713728243831e-18, -5.995042655290043e-21,
  7.297191921100063e-24,  4.361481975214433e-26, -3.663337718659813e-28,  2.689118445473168e-01, -1.520046345571665e-03,  5.691625553352215e-06, -1.495169881958784e-08,
  1.768551818477216e-11,  7.769287859866521e-14, -6.228001772770893e-16,  2.292599692349360e-18, -3.762384239608450e-21, -1.284916353195928e-23,  1.298807511106829e-25,
 -5.441268375181456e-28,  3.276810748656602e-01, -1.812312490701067e-03,  6.402450996324435e-06, -1.427301986367603e-08,  1.813699701350758e-12,  1.584521172648492e-13,
 -8.143968303747595e-16,  1.949758584492951e-18,  1.884085117032885e-21, -4.055455557350498e-23,  1.903588336097767e-25, -3.796278248326580e-28,  3.919181189069695e-01,
 -2.113965116201527e-03,  6.961647818741671e-06, -1.219848308730496e-08, -1.953923554245328e-11,  2.394451150438205e-13, -8.663708603256442e-16,  6.687524413311065e-19,
  1.030644744673986e-20, -6.380264706201279e-23,  1.554866998754543e-25,  2.982367630213395e-28,  4.614639769998337e-01, -2.418674088902093e-03,  7.312932803831767e-06,
 -8.581020196897028e-09, -4.497283008999048e-11,  3.034445532721912e-13, -6.975169426103893e-16, -1.568652510605678e-18,  1.902590425547913e-20, -6.444838543127059e-23,
 -2.756655319219661e-26,  1.328465714823745e-27,  5.361228973100292e-01, -2.719268414658719e-03,  7.400459251716909e-06, -3.382946226960700e-09, -7.200579285987913e-11,
  3.299474509592819e-13, -2.544446916393248e-16, -4.402302086861268e-18,  2.375766445464199e-20, -2.541753206682156e-23, -3.369530075187879e-25,  2.047659786690956e-27,
  6.156544762047425e-01, -3.007703801493255e-03,  7.171816016079632e-06,  3.285956025801538e-09, -9.704872162575839e-11,  2.983909861900502e-13,  4.563228564364489e-16,
 -7.009787435744987e-18,  1.946217457904568e-20,  5.667955633821340e-23, -6.263679169227889e-25,  1.456679195108024e-27,  6.997641340232078e-01, -3.275057219327980e-03,
  6.582035645473634e-06,  1.112984865471229e-08, -1.155525819702275e-10,  1.931706057688081e-13,  1.336521904279103e-15, -8.172745610100857e-18,  2.682613475192020e-21,
  1.575957209832093e-22, -6.372561148933176e-25, -1.063614695650063e-27,  7.880917126349453e-01, -3.511566327434380e-03,  5.598793840130785e-06,  1.963321000018484e-08,
 -1.224176733374664e-10,  1.029370422168501e-14,  2.177085905692787e-15, -6.587391677660034e-18, -2.512779952531666e-20,  2.199101685752767e-22, -1.310058304300560e-25,
 -4.648338754954031e-27,  8.801979535336916e-01, -3.706738973081151e-03,  4.208915647048426e-06,  2.804124162014533e-08, -1.127494810155097e-10, -2.352382161000300e-13,
  2.670551488174723e-15, -1.467931905805385e-18, -5.463703072164425e-20,  1.698416696458937e-22,  8.555782619258549e-25, -6.345000748529931e-27,  9.755486740495313e-01,
 -3.849567178736495e-03,  2.426139037243143e-06,  3.536803206763302e-08, -8.301778808870790e-11, -5.034035132422071e-13,  2.476574418624923e-15,  6.646077389992183e-18,
 -6.867684468786423e-20, -3.396617248103850e-23,  1.770061353042928e-24, -2.507509118964735e-27,  1.073496598125101e+00, -3.928890683968333e-03,  2.997605544698640e-07,
  4.045121519574987e-08, -3.258537222101511e-11, -7.280880547313266e-13,  1.354799355833724e-15,  1.521939417706488e-17, -4.855536097568903e-20, -3.319862219608722e-22,
  1.637465742555947e-24,  7.075832009284793e-27,  1.173261066812118e+00, -3.933965605336086e-03, -2.076779248485747e-06,  4.207534213867680e-08,  3.461172130083105e-11,
 -8.258623283507452e-13, -6.484612332027476e-16,  1.983290274847933e-17,  1.209589719858102e-20, -5.287997053903673e-22, -1.961314601059682e-25,  1.500276114855924e-26,
  1.273906321141695e+00, -3.855300406745872e-03, -4.559196449152837e-06,  3.918408452656834e-08,  1.087503857073421e-10, -7.192364657874347e-13, -3.028820912540999e-15,
  1.583052662120334e-17,  9.128824445747311e-20, -3.769930928141664e-22, -2.884905799844494e-24,  9.205338711113283e-27,  1.374319801863612e+00, -3.685816895493221e-03,
 -6.950588560074507e-06,  3.118676250978228e-08,  1.740683899730767e-10, -3.748882644537347e-13, -4.808914289151520e-15,  1.685978409590862e-18,  1.358868150053245e-19,
  1.822256278351908e-22, -3.769984670798908e-24, -1.213683186448431e-26,  1.473193032781845e+00, -3.422366151223514e-03, -9.008985794564689e-06,  1.832835726395140e-08,
  2.112416815639192e-10,  1.530305347097349e-13, -4.854697102608494e-15, -1.740680406629399e-17,  9.125424131559813e-20,  7.787921085292542e-22, -6.453884730271785e-25,
 -2.686124697763875e-26,  1.569009189948509e+00, -3.067560601287626e-03, -1.046957602330904e-05,  2.027401684516662e-09,  2.031135755387593e-10,  7.003560433314660e-13,
 -2.581244248839518e-15, -2.947347003714733e-17, -3.878272465417052e-20,  7.604933418977417e-22,  4.296356236239768e-24, -7.805912353682458e-27,  1.660043318845320e+00,
 -2.631754523865975e-03, -1.108628208922204e-05, -1.499890972006939e-08,  1.433391747674739e-10,  1.028846216332765e-12,  1.257301515408599e-15, -2.307476272080697e-17,
 -1.556063596135581e-19, -7.242390381861633e-23,  4.739839456591375e-24,  2.752816858565586e-26,  1.744382981715014e+00, -2.134806931661337e-03, -1.069326677176133e-05,
 -2.906499342081531e-08,  4.471624030785667e-11,  9.436860387784286e-13,  4.469802304612535e-15,  2.533642328771841e-19, -1.353925817268038e-19, -8.713291060625384e-22,
 -1.124951853839559e-24,  2.250329041698958e-26,  1.819978091125381e+00, -1.607018759314920e-03, -9.277709072875241e-06, -3.649111039451110e-08, -5.921428726850198e-11,
  4.525055459352447e-13,  4.759881636177585e-15,  2.146384179547576e-17,  1.337105646312544e-20, -5.858603267402770e-22, -4.912110433101647e-24, -1.789694252805367e-26,
  1.884727501022176e+00, -1.088444340497228e-03, -7.041389526508244e-06, -3.513060788256654e-08, -1.258776369548661e-10, -1.640574866305570e-13,  1.950982832294018e-15,
  2.063632553108979e-17,  1.148336260267282e-19,  3.346419003503540e-22, -8.275319165009576e-25, -1.842725045675015e-26,  1.936605070971204e+00, -6.258126239877046e-04,
 -4.416155647451087e-06, -2.585606686371069e-08, -1.280196971401668e-10, -5.098528157897260e-13, -1.277309584504866e-15,  2.251104444109203e-18,  5.707132217807533e-20,
  4.648994409292795e-22,  2.630232920625969e-24,  1.035673624579998e-26,  1.973818806325463e+00, -2.667589589739914e-04, -1.999494002355834e-06, -1.297737535859187e-08,
 -7.626688637036521e-11, -4.106773478777190e-13, -2.013428083890554e-15, -8.736796751209167e-18, -3.088461038429165e-20, -6.100109024332750e-23,  2.778809438837515e-25,
  4.583836120785485e-27,  1.994989074209669e+00, -5.197873877737418e-05, -4.029373992665798e-07, -2.763388566457036e-09, -1.766233225550746e-11, -1.075983056136600e-13,
 -6.318308695444817e-16, -3.597655768480871e-18, -1.992294527580769e-20, -1.074063474253113e-22, -5.633354797020635e-25, -2.867736715717875e-27,  7.338888640771032e-04,
 -4.474098883917030e-06,  2.045041184578106e-08, -8.306559862435699e-11,  3.161353308936389e-13, -1.154551731651187e-15,  4.095912926272215e-18, -1.422781968925324e-20,
  4.858574826683213e-23, -1.638342180147499e-25,  5.456589737459040e-28, -1.804062885345305e-30,  6.604047051985818e-03, -4.019322382041705e-05,  1.830202947893437e-07,
 -7.384254896786270e-10,  2.781166806955913e-12, -1.000552729164227e-14,  3.477257342602779e-17, -1.175501196102616e-19,  3.875862873144948e-22, -1.250395952383399e-24,
  3.939205371092058e-27, -1.216177797217258e-29,  1.833922448626428e-02, -1.112371448481490e-04,  5.026461181498835e-07, -2.000490032325246e-09,  7.373768762507747e-12,
 -2.569853086632469e-14,  8.538660014864701e-17, -2.712689802356616e-19,  8.211029903630915e-22, -2.353290712688481e-24,  6.253576912067091e-27, -1.494291700045483e-29,
  3.592886365270408e-02, -2.168102643517755e-04,  9.682895119900727e-07, -3.773045774969438e-09,  1.343905606511745e-11, -4.443925135028472e-14,  1.364019655218475e-16,
 -3.838633258056594e-19,  9.539687217051790e-22, -1.891322623102091e-24,  1.632696325824408e-27,  9.724609064923890e-30,  5.935641781980140e-02, -3.557017725219376e-04,
  1.563371839093283e-06, -5.914610783265154e-09,  2.004541319712401e-11, -6.109161273516349e-14,  1.632328566064766e-16, -3.518830580213627e-19,  4.070404941815179e-22,
  1.290386795600780e-24, -1.235925479614310e-26,  6.106348753474823e-29,  8.859846609131046e-02, -5.262645862856260e-04,  2.265763787654965e-06, -8.242111084043088e-09,
  2.604699803594654e-11, -6.983232581292248e-14,  1.414998340026310e-16, -9.489927249486116e-20, -9.838199531641862e-22,  6.940774865884765e-24, -3.062380812648389e-26,
  1.037900957569788e-28,  1.236234778934316e-01, -7.263870343995795e-04,  3.047797931394315e-06, -1.053624070557759e-08,  3.016954578019006e-11, -6.499782652408754e-14,
  5.330685206737635e-17,  4.074457984712132e-19, -2.993879081291098e-21,  1.281274588289178e-23, -3.983976907572553e-26,  7.767680456712527e-29,  1.643901760213750e-01,
 -9.534571799372406e-04,  3.876330256224197e-06, -1.254890961434751e-08,  3.112094777839745e-11, -4.208913325801191e-14, -1.061917867196337e-16,  1.084577631901658e-18,
 -4.928808157808390e-21,  1.489327782964204e-23, -2.324223701932925e-26, -6.387704591394708e-29,  2.108454305047901e-01, -1.204319778304229e-03,  4.712887549331310e-06,
 -1.401329235328285e-08,  2.772748017950636e-11,  1.124848474096190e-15, -3.229614319594763e-16,  1.760381981509342e-18, -5.704635128790546e-21,  8.740213238221361e-24,
  2.903508781158334e-26, -2.978446292089910e-28,  2.629215957851934e-01, -1.475226099303084e-03,  5.513951682889457e-06, -1.465709022383433e-08,  1.909503133199750e-11,
  6.350199035009994e-14, -5.603555918075549e-16,  2.165759044548069e-18, -4.137070057634706e-21, -8.117333657036936e-24,  1.071013187132979e-25, -4.905654826174313e-28,
  3.205331803747079e-01, -1.761777260317368e-03,  6.231450062492344e-06, -1.421969163565301e-08,  4.791738533786472e-12,  1.395672277807770e-13, -7.591687172590575e-16,
  1.988125930156506e-18,  5.570267812762135e-22, -3.328781879134901e-23,  1.726950447808561e-25, -4.185912056642870e-28,  3.835727106901259e-01, -2.058862418860933e-03,
  6.813544648258553e-06, -1.247392237491358e-08, -1.495656175860591e-11,  2.189121044836712e-13, -8.433651144189366e-16,  9.630308885639463e-19,  8.124125502932888e-21,
 -5.737936704997381e-23,  1.643051458428724e-25,  1.097889659353446e-28,  4.519056187425594e-01, -2.360594292793527e-03,  7.205840458989751e-06, -9.252957635237073e-09,
 -3.907455435471213e-11,  2.862437283916802e-13, -7.332652828853055e-16, -9.970494805011870e-19,  1.669921867131535e-20, -6.446772604243407e-23,  2.451090228793189e-26,
  1.041867659490768e-27,  5.253639469035370e-01, -2.660246208476900e-03,  7.353167920604637e-06, -4.482619492487100e-09, -6.547745491720676e-11,  3.224465783995878e-13,
 -3.672208138332396e-16, -3.659124952002238e-18,  2.262134244930697e-20, -3.713831509984012e-23, -2.502993550290388e-25,  1.881492971576656e-27,  6.037386231234233e-01,
 -2.950197487633485e-03,  7.202129497430468e-06,  1.781448638012896e-09, -9.098691152386118e-11,  3.070595371029534e-13,  2.690408903016087e-16, -6.359055125654444e-18,
  2.106792335460856e-20,  3.299501072142641e-23, -5.559386836380534e-25,  1.720688575343194e-27,  6.867700196134371e-01, -3.221897827174066e-03,  6.704633707503031e-06,
  9.313579900049573e-09, -1.113868686536628e-10,  2.225158536659232e-13,  1.109704215525897e-15, -8.001122945006795e-18,  7.888236450467903e-21,  1.314181461025990e-22,
 -6.656954134877330e-25, -2.502291231310631e-28,  7.741364731856986e-01, -3.465866846467432e-03,  5.822656078265400e-06,  1.767894888604912e-08, -1.217046775494307e-10,
  6.024680954731697e-14,  1.982562387590401e-15, -7.266208742829666e-18, -1.735225417035974e-20,  2.108438133943286e-22, -3.155952044647122e-25, -3.727440497205400e-27,
  8.654404276872635e-01, -3.671752671186567e-03,  4.534442572921477e-06,  2.620307675384681e-08, -1.168176385162639e-10, -1.718299008221243e-13,  2.605935102706967e-15,
 -3.112431720786447e-18, -4.797436079630011e-20,  1.984470525510983e-22,  5.745817290935327e-25, -6.360971126649618e-27,  9.601918786687584e-01, -3.828483725633527e-03,
  2.842264091230264e-06,  3.396249114223314e-08, -9.247769365675745e-11, -4.419816279373774e-13,  2.631809540817952e-15,  4.442268954481982e-18, -6.865690470419975e-20,
  3.407174534092345e-23,  1.618768345680133e-24, -4.300030519467894e-27,  1.057788891893902e+00, -3.924560898934383e-03,  7.815725136252483e-07,  3.981526340275657e-08,
 -4.678841645658603e-11, -6.906453069375372e-13,  1.757486309035528e-15,  1.348760271290912e-17, -5.925988683308495e-20, -2.610365387000446e-22,  1.890384375026617e-24,
  4.383902367430833e-27,  1.157495185278899e+00, -3.948552068377830e-03, -1.569099708518144e-06,  4.249633548410379e-08,  1.798397637193438e-11, -8.347354160445425e-13,
 -9.058618386805410e-17,  1.991515764710486e-17, -6.923450446652394e-21, -5.235055578763514e-22,  4.573191392312717e-25,  1.452060006633013e-26,  1.258415190649364e+00,
 -3.889864680304752e-03, -4.079034461898894e-06,  4.080521975809978e-08,  9.367629295431779e-11, -7.862923279540438e-13, -2.546863135314786e-15,  1.851320057430303e-17,
  7.574868868893474e-20, -4.830119502326196e-22, -2.385745238922078e-24,  1.335795521641738e-26,  1.359467761098434e+00, -3.739877903226730e-03, -6.559904518343139e-06,
  3.390562876079077e-08,  1.654228703604037e-10, -4.892393551837921e-13, -4.700056518432316e-15,  6.109256981678305e-18,  1.396172473196467e-19,  2.223540062912986e-23,
 -4.190404245189223e-24, -6.771798582042319e-27,  1.459360898730086e+00, -3.493500628014015e-03, -8.768686249829787e-06,  2.172621908292471e-08,  2.130995007768317e-10,
  3.102476299621243e-14, -5.297040012533315e-15, -1.404541968800734e-17,  1.185351081387522e-19,  7.286938336744911e-22, -1.871778252736615e-24, -2.853568574489568e-26,
  1.556571667779384e+00, -3.151163606029931e-03, -1.042529774003757e-05,  5.385627142547564e-09,  2.164337387891525e-10,  6.283893205149628e-13, -3.419528453292995e-15,
 -3.024413060476111e-17, -8.417808720164978e-21,  9.228902548138505e-22,  3.757871394210093e-24, -1.680328901642860e-26,  1.649337837435380e+00, -2.721124166624457e-03,
 -1.125182472037128e-05, -1.253945782041514e-08,  1.641626046536043e-10,  1.050704617220109e-12,  5.413790447943413e-16, -2.805694511672288e-17, -1.545128366000340e-19,
  1.409349454660286e-22,  5.911430054214853e-24,  2.522854358242166e-26,  1.735670471890376e+00, -2.221734550456416e-03, -1.103711223593955e-05, -2.819272195738697e-08,
  6.466063408907681e-11,  1.050527601443093e-12,  4.411475087832920e-15, -4.587669853489661e-18, -1.673070488983042e-19, -8.937966630505153e-22,  7.059037164903494e-26,
  3.196756557082005e-26,  1.813398777639138e+00, -1.683007382331758e-03, -9.720967649947437e-06, -3.735972627534818e-08, -4.897296264208913e-11,  5.739820244194212e-13,
  5.363409645630618e-15,  2.151483291960946e-17, -1.144093765152601e-20, -7.974570229435471e-22, -5.647340142381408e-24, -1.508431902024730e-26,  1.880258342857827e+00,
 -1.146496196437377e-03, -7.475140556154462e-06, -3.716815112166706e-08, -1.286415553385498e-10, -1.098739931977095e-13,  2.582001182148010e-15,  2.449566258841310e-17,
  1.260714051095430e-19,  2.833166718504972e-22, -1.790916209607756e-24, -2.559157753342356e-26,  1.934029146729021e+00, -6.624185674098538e-04, -4.739060171014689e-06,
 -2.798759873148087e-08, -1.385170673635545e-10, -5.395292921757589e-13, -1.186044689634500e-15,  4.366375865327605e-18,  7.581280617052588e-20,  5.793797904232133e-22,
  3.096464454684978e-24,  1.071780976758328e-26,  1.972718762173520e+00, -2.833992113116590e-04, -2.162823911673690e-06, -1.426606463508577e-08, -8.498405659274773e-11,
 -4.620488064016372e-13, -2.272207089871823e-15, -9.757666954140586e-18, -3.282670697142150e-20, -4.526449415578407e-23,  5.247517458396530e-25,  6.757060287695235e-27,
  1.994774495233721e+00, -5.533985385483348e-05, -4.378674265012362e-07, -3.064061112018836e-09, -1.997448532742115e-11, -1.240468347799727e-13, -7.421044900796217e-16,
 -4.301664290006865e-18, -2.422749486088430e-20, -1.326757041948960e-22, -7.057165367049885e-25, -3.635188152149276e-27,  7.163134812706242e-04, -4.314398469952670e-06,
  1.948322858841336e-08, -7.818695289306072e-11,  2.939959320485191e-13, -1.060859985700263e-15,  3.718442877069972e-18, -1.276338219151043e-20,  4.306219314584358e-23,
 -1.435156204621203e-25,  4.721656409595536e-28, -1.543791466890343e-30,  6.446147409364980e-03, -3.876376432749892e-05,  1.744197211598497e-07, -6.954834560827686e-10,
  2.589142145663503e-12, -9.209121388870176e-15,  3.164825249025229e-17, -1.058381924970927e-19,  3.452838419327208e-22, -1.103034582512488e-24,  3.440673486846599e-27,
 -1.053960641031817e-29,  1.790216898844284e-02, -1.073100321103775e-04,  4.793315122759970e-07, -1.886512682985961e-09,  6.879690709946119e-12, -2.373750631693253e-14,
  7.814652369739520e-17, -2.463021646855492e-19,  7.407322514529531e-22, -2.115902355392240e-24,  5.625488552202573e-27, -1.361857412923683e-29,  3.507683354898505e-02,
 -2.092414654397620e-04,  9.242743484912990e-07, -3.564956883099160e-09,  1.258215447031449e-11, -4.129119514711524e-14,  1.260710289449557e-16, -3.544123508899673e-19,
  8.871501509567952e-22, -1.818501037811312e-24,  1.984093701111641e-27,  6.386640383905369e-30,  5.795818274545256e-02, -3.434733382672631e-04,  1.494281229303904e-06,
 -5.603449297432847e-09,  1.886196653413440e-11, -5.729074538700913e-14,  1.535688179172337e-16, -3.382048530909697e-19,  4.452136685883475e-22,  8.465267325422445e-25,
 -9.910355064837013e-27,  5.054113611942250e-29,  8.652904342993563e-02, -5.085271174840384e-04,  2.169313472201856e-06, -7.836348736383425e-09,  2.468407881232085e-11,
 -6.647155080282411e-14,  1.384378316056153e-16, -1.226113322016203e-19, -7.549346562775076e-22,  5.803431977739708e-24, -2.633382432435841e-26,  9.136773802441848e-29,
  1.207659052238834e-01, -7.025022827124361e-04,  2.924216656066230e-06, -1.006385442373752e-08,  2.888325280074691e-11, -6.359197077983849e-14,  6.344126524242986e-17,
  3.187209562574024e-19, -2.560477683477681e-21,  1.128785318384582e-23, -3.640153827631597e-26,  7.814843289524141e-29,  1.606374267336200e-01, -9.230404854762982e-04,
  3.728702751910555e-06, -1.205783717449326e-08,  3.025604887543173e-11, -4.429065175580655e-14, -7.795242493674844e-17,  9.352499417428790e-19, -4.409975816605880e-21,
  1.391671882556565e-23, -2.536885262764633e-26, -3.407935968297808e-29,  2.061025032284032e-01, -1.167281775012579e-03,  4.547389302305993e-06, -1.356987744484933e-08,
  2.767635360436517e-11, -6.055067373675766e-15, -2.761776559300378e-16,  1.583067638524673e-18, -5.372073757549601e-21,  9.657705283165520e-24,  1.727388722161664e-26,
 -2.382005445571422e-28,  2.571078081299437e-01, -1.431812740445239e-03,  5.339939323263777e-06, -1.434211976204913e-08,  2.023541938344624e-11,  5.076595005892971e-14,
 -5.016060218041206e-16,  2.029482804107748e-18, -4.357233338634990e-21, -4.248513128804316e-24,  8.674938426278047e-26, -4.343643622336975e-28,  3.135846959496071e-01,
 -1.712606695858485e-03,  6.061362729177774e-06, -1.412166406919778e-08,  7.405397548508706e-12,  1.220161425679567e-13, -7.034225022913755e-16,  1.988073810417230e-18,
 -5.214878679848606e-22, -2.675408207999695e-23,  1.538906409606347e-25, -4.325789029844223e-28,  3.754453243973916e-01, -2.004956552484670e-03,  6.662562695715698e-06,
 -1.267929150186279e-08, -1.077839925236218e-11,  1.990224338177815e-13, -8.130620942729316e-16,  1.191227459416914e-18,  6.177507429550114e-21, -5.075662679092699e-23,
  1.657635902394919e-25, -3.695727238616349e-29,  4.425778173550746e-01, -2.303401910531448e-03,  7.091239610317248e-06, -9.833316119205194e-09, -3.352762175646791e-11,
  2.683686017940122e-13, -7.540484728554062e-16, -4.995337885052230e-19,  1.440635035739299e-20, -6.264980196780377e-23,  6.447029666512376e-26,  7.790398446227159e-28,
  5.148402475759951e-01, -2.601653353874760e-03,  7.293301822949454e-06, -5.479179554243040e-09, -5.912453797344645e-11,  3.124843111491326e-13, -4.597557995386440e-16,
 -2.958407581987151e-18,  2.112355763498303e-20, -4.555456353671430e-23, -1.720636651996521e-25,  1.668943407089477e-27,  5.920531683138294e-01, -2.892519221844483e-03,
  7.214975771218895e-06,  3.750792538574004e-10, -8.479517547720879e-11,  3.114570053849454e-13,  1.005746192547172e-16, -5.670017215317865e-18,  2.187415882313635e-20,
  1.231870912714309e-23, -4.769391847450669e-25,  1.849734439301084e-27,  6.739903679608819e-01, -3.167843655657494e-03,  6.805854867995585e-06,  7.568363989138816e-09,
 -1.066882038198190e-10,  2.464930888513977e-13,  8.898812362055640e-16, -7.678150504252054e-18,  1.213925957761908e-20,  1.047793831496050e-22, -6.613264267973402e-25,
  4.246008089331014e-28,  7.603674653040690e-01, -3.418470003943358e-03,  6.023167761559128e-06,  1.574382858186714e-08, -1.200407010058619e-10,  1.053310337329665e-13,
  1.772456674748579e-15, -7.702775030898714e-18, -1.002604249904284e-20,  1.952244988472736e-22, -4.582928058446489e-25, -2.756788616965172e-27,  8.508279143428134e-01,
 -3.634251396580138e-03,  4.837562512119103e-06,  2.430986722744749e-08, -1.196367391019484e-10, -1.104999644523820e-13,  2.498396970938519e-15, -4.529413158406619e-18,
 -4.048333891511322e-20,  2.159123122246745e-22,  3.012612312642259e-25, -6.008035073970155e-27,  9.449259647721664e-01, -3.804141216585034e-03,  3.240655640075540e-06,
  3.241560070557833e-08, -1.006768935142949e-10, -3.775722894554451e-13,  2.725705997944336e-15,  2.276973845135139e-18, -6.631436690779080e-20,  9.461025534095705e-23,
  1.398429485416390e-24, -5.634983981139085e-27,  1.042106160087110e+00, -3.916410946901318e-03,  1.254415925524817e-06,  3.895856169324380e-08, -6.015007836618779e-11,
 -6.441562376844051e-13,  2.107284016101239e-15,  1.145585112233767e-17, -6.725713027042385e-20, -1.823864193659966e-22,  2.021741398221125e-24,  1.589357073127649e-27,
  1.141679106364763e+00, -3.959061418927773e-03, -1.057968012522752e-06,  4.265059223546128e-08,  1.312492221365847e-12, -8.302602837834785e-13,  4.611356196954140e-16,
  1.939682716851259e-17, -2.528969239921011e-20, -4.928097887057282e-22,  1.066425865585603e-24,  1.300704048003750e-26,  1.242793602943333e+00, -3.920514041346946e-03,
 -3.580908118597854e-06,  4.217509352494933e-08,  7.738253229010153e-11, -8.409393963078515e-13, -1.997296509844415e-15,  2.064173816458462e-17,  5.679362719566168e-20,
 -5.656632628588764e-22, -1.723459689559014e-24,  1.656042063087627e-26,  1.344405930333203e+00, -3.790685457309282e-03, -6.137498947895474e-06,  3.646805475710973e-08,
  1.545265335399724e-10, -5.994835747172948e-13, -4.466561946909011e-15,  1.055699124578831e-17,  1.373452447567700e-19, -1.495247438568061e-22, -4.351271764569992e-24,
 -4.194636263562681e-28,  1.445248330265764e+00, -3.562549294782805e-03, -8.487516313233145e-06,  2.513374202115054e-08,  2.124191673878201e-10, -1.003711736138486e-13,
 -5.633381609824727e-15, -9.849477447349698e-18,  1.431175845615753e-19,  6.287209515202098e-22, -3.122172952521732e-24, -2.788681645309904e-26,  1.543800702230697e+00,
 -3.234247683119202e-03, -1.033949306969052e-05,  8.944362120631309e-09,  2.281122212951079e-10,  5.361598683233772e-13, -4.264942961171612e-15, -2.995451634556747e-17,
  2.730857554125890e-20,  1.055654930333340e-21,  2.811953090476551e-24, -2.617986492468197e-26,  1.638272423722727e+00, -2.811694405843411e-03, -1.138584360618812e-05,
 -9.744314526558550e-09,  1.852401332864639e-10,  1.053718234335142e-12, -3.123368676857579e-16, -3.287244831898153e-17, -1.449276521254415e-19,  3.982010713156659e-22,
  6.911101275746312e-24,  1.962360648752883e-26,  1.726604824227608e+00, -2.311365477391803e-03, -1.136850564263352e-05, -2.698436977116573e-08,  8.671628280463315e-11,
  1.154226923740828e-12,  4.203250217500167e-15, -1.045285295892563e-17, -1.990675773731912e-19, -8.599482314369818e-22,  1.693337656133181e-24,  4.176713573337400e-26,
  1.806508355691330e+00, -1.762580792134283e-03, -1.017358372940745e-05, -3.804425894589349e-08, -3.615764034766184e-11,  7.098633533936252e-13,  5.956065648716316e-15,
  2.064457617101715e-17, -4.436234232246033e-20, -1.035139360578465e-21, -6.193796587931557e-24, -9.168870343605995e-27,  1.875549881454156e+00, -1.208116526585783e-03,
 -7.933568912211762e-06, -3.924038740065439e-08, -1.301614047252945e-10, -3.921067520534869e-14,  3.325781008003845e-15,  2.867696724403939e-17,  1.346882155099357e-19,
  1.867521720420493e-22, -3.099101861722779e-24, -3.407067587343000e-26,  1.931301466154990e+00, -7.017129600648120e-04, -5.088569967437979e-06, -3.029169634295774e-08,
 -1.495808992334689e-10, -5.662329734075313e-13, -1.026510669277260e-15,  7.150931789643463e-18,  9.901292041747475e-20,  7.125809418602807e-22,  3.559266195866969e-24,
  1.011364778539349e-26,  1.971549442340129e+00, -3.014104114051723e-04, -2.342489965738940e-06, -1.570279535394369e-08, -9.479311208946102e-11, -5.199803996007602e-13,
 -2.560340617439856e-15, -1.082951360467466e-17, -3.399942303812551e-20, -1.750975489882116e-23,  8.849405289453167e-25,  9.776038554941307e-27,  1.994545889143866e+00,
 -5.899549630844528e-05, -4.766388318136543e-07, -3.404510661560895e-09, -2.264375550183508e-11, -1.433949245107848e-13, -8.741637813642523e-16, -5.159142249971001e-18,
 -2.955292586041030e-20, -1.643748249426958e-22, -8.863806330999240e-25, -4.616610158980037e-27,  6.993617876472437e-04, -4.162207229687322e-06,  1.857252397689734e-08,
 -7.364802549431293e-11,  2.736429962266185e-13, -9.757547869725061e-16,  3.379608570319911e-18, -1.146454066533382e-20,  3.821983857100696e-23, -1.259200992002967e-25,
  4.092117769302312e-28, -1.323823422313119e-30,  6.293831186958141e-03, -3.740109925210171e-05,  1.663165302949462e-07, -6.554903574306755e-10,  2.412321557815267e-12,
 -8.483912179081389e-15,  2.883368488631289e-17, -9.539877679242823e-20,  3.079440209675003e-22, -9.742571310923823e-25,  3.008338002762296e-27, -9.147019556810762e-30,
  1.748045738428512e-02, -1.035640967754806e-04,  4.573384674323231e-07, -1.780136027064519e-09,  6.423150685679791e-12, -2.194213764701077e-14,  7.157076281996199e-17,
 -2.237752132813929e-19,  6.684691094363215e-22, -1.902494686715778e-24,  5.053958370581033e-27, -1.237432614580158e-29,  3.425438989020378e-02, -2.020150279472665e-04,
  8.826760239767696e-07, -3.370087923236266e-09,  1.178580013151241e-11, -3.838142499769367e-14,  1.165351968037976e-16, -3.270551852494322e-19,  8.231729197518339e-22,
 -1.734327149109545e-24,  2.205778202888239e-27,  3.799806640328526e-30,  5.660777915970980e-02, -3.317830093409754e-04,  1.428813414577792e-06, -5.310627288821836e-09,
  1.775224952410905e-11, -5.371709516684760e-14,  1.443025980691218e-16, -3.235427397840875e-19,  4.690640944318384e-22,  4.918628702258252e-25, -7.887537248479555e-27,
  4.165411246829522e-29,  8.452905775999814e-02, -4.915421402462312e-04,  2.077603669166768e-06, -7.451859614552821e-09,  2.338758147846401e-11, -6.319278412774173e-14,
  1.346965068629146e-16, -1.436221051611893e-19, -5.640340195592870e-22,  4.827045821589998e-24, -2.256869072767259e-26,  7.994387570687309e-29,  1.180019296710199e-01,
 -6.795838543394011e-04,  2.806181500425317e-06, -9.611811494480095e-09,  2.762731585502300e-11, -6.197118326182798e-14,  7.127748318888702e-17,  2.430131580701895e-19,
 -2.179498858039608e-21,  9.900152143145821e-24, -3.299730154336441e-26,  7.626678798636840e-29,  1.570040191689050e-01, -8.937814779392401e-04,  3.586883749057359e-06,
 -1.158091992418608e-08,  2.935356793028800e-11, -4.586275658716768e-14, -5.366718958214611e-17,  8.019484018065947e-19, -3.927535018987763e-21,  1.287911473042609e-23,
 -2.634654014377130e-26, -1.143061956065341e-29,  2.015051136592316e-01, -1.131546498213366e-03,  4.387202580341445e-06, -1.312837000814724e-08,  2.749246100258099e-11,
 -1.217052027652692e-14, -2.342053469019721e-16,  1.416837918356587e-18, -5.014341547864595e-21,  1.015468536242627e-23,  7.947118040014727e-27, -1.871159475029850e-28,
  2.514649140631315e-01, -1.389776070564233e-03,  5.169807925228241e-06, -1.401086555852688e-08,  2.113487386298357e-11,  3.939343771573264e-14, -4.467509737351896e-16,
  1.888237507711984e-18, -4.452175455945587e-21, -1.144234107204582e-24,  6.887151926890946e-26, -3.785230730966589e-28,  3.068301808041712e-01, -1.664791440033321e-03,
  5.892691289517565e-06, -1.398455350700453e-08,  9.681394580375174e-12,  1.057992612181803e-13, -6.481266008262852e-16,  1.957126643748919e-18, -1.378420719887161e-21,
 -2.097889968655564e-23,  1.349034756836177e-25, -4.278591850980018e-28,  3.675311318157594e-01, -1.952267292951932e-03,  6.509504423704524e-06, -1.282095081226536e-08,
 -6.990275327842012e-12,  1.799298911135889e-13, -7.772058022762731e-16,  1.360946263868790e-18,  4.468905635688989e-21, -4.419337006005256e-23,  1.616022798059788e-25,
 -1.464631514431169e-28,  4.334769098698212e-01, -2.247152710823670e-03,  6.970195092579007e-06, -1.032780621507387e-08, -2.834209384430291e-11,  2.501536238474632e-13,
 -7.619165190244191e-16, -7.405638653880254e-20,  1.220498835234766e-20, -5.945622733224700e-23,  9.351423712783895e-26,  5.464741577365307e-28,  5.045498884893427e-01,
 -2.543585550837308e-03,  7.222079936600728e-06, -6.375801003267753e-09, -5.299151464572305e-11,  3.005309704604599e-13, -5.333830578083099e-16, -2.309881946752230e-18,
  1.937678200635110e-20, -5.103711136697334e-23, -1.037930220802737e-25,  1.431791636088283e-27,  5.805985276083802e-01, -2.834804002153754e-03,  7.211542227816201e-06,
 -9.317318351447366e-10, -7.855434700346121e-11,  3.120450495108382e-13, -4.834489492852464e-17, -4.966470450759530e-18,  2.199397594640340e-20, -5.118809277295762e-24,
 -3.948167876226122e-25,  1.866593218767258e-27,  6.614284217465632e-01, -3.113062172584463e-03,  6.886599414866399e-06,  5.901879763961202e-09, -1.015619436040233e-10,
  2.653175794569193e-13,  6.808623386380933e-16, -7.234400055077964e-18,  1.544119094857270e-20,  7.886544020107361e-23, -6.305485902270911e-25,  9.494001076045566e-28,
  7.467911066373758e-01, -3.369561434396633e-03,  6.200646600828395e-06,  1.384226771388127e-08, -1.175263209112918e-10,  1.452519692419310e-13,  1.553317346888948e-15,
 -7.914917346410274e-18, -3.354579360726024e-21,  1.747501231060568e-22, -5.584965162440293e-25, -1.806248286024219e-27,  8.363701111710358e-01, -3.594416711067283e-03,
  5.117733291190033e-06,  2.238121165615140e-08, -1.212581216402349e-10, -5.219945509114030e-14,  2.354619018649626e-15, -5.698695986329131e-18, -3.255577424134619e-20,
  2.228465700230379e-22,  5.013534466244368e-26, -5.366400543139758e-27,  9.297636745943384e-01, -3.776687957473048e-03,  3.619740231374908e-06,  3.074793057029766e-08,
 -1.075702302492555e-10, -3.116265542897922e-13,  2.760338533053649e-15,  2.197028957568678e-19, -6.196392050003096e-20,  1.453059946975246e-22,  1.130269550218552e-24,
 -6.470964328489318e-27,  1.026463523439610e+00, -3.904522930098305e-03,  1.715728303669527e-06,  3.789594795173790e-08, -7.250275369129221e-11, -5.899809634955179e-13,
  2.397041409154561e-15,  9.214264727139990e-18, -7.235786276821351e-20, -1.009202216273606e-22,  2.032098266527068e-24, -1.080787088760082e-27,  1.125829173492047e+00,
 -3.965478834782290e-03, -5.465804302566304e-07,  4.253953459216226e-08, -1.513858991909690e-11, -8.127832139566641e-13,  9.903149087691394e-16,  1.831301335077242e-17,
 -4.213085833339977e-20, -4.393511077620383e-22,  1.589163063288661e-24,  1.062949405604436e-26,  1.227057485564697e+00, -3.947117147916961e-03, -3.067941184488186e-06,
  4.327625922228859e-08,  6.013218855987501e-11, -8.817527785935906e-13, -1.397032060879001e-15,  2.212147441131707e-17,  3.537075402896473e-20, -6.193568082936599e-22,
 -9.470294218303454e-25,  1.850562678657127e-26,  1.329147818182769e+00, -3.837993899567730e-03, -5.685461973552273e-06,  3.883884688722346e-08,  1.414913716657197e-10,
 -7.026434454641128e-13, -4.110483871047287e-15,  1.483240349762375e-17,  1.288430520993852e-19, -3.219579226026547e-22, -4.220894763107494e-24,  6.365428359923993e-27,
  1.430864324297190e+00, -3.629185428375125e-03, -8.165609442513296e-06,  2.850895918449909e-08,  2.090401537157671e-10, -2.383442501398010e-13, -5.841833206384097e-15,
 -4.934032685712021e-18,  1.632144747397923e-19,  4.800573175570678e-22, -4.287346438488905e-24, -2.463806078060538e-26,  1.530699048002953e+00, -3.316471474347310e-03,
 -1.020992687450878e-05,  1.267409882112142e-08,  2.377445575006717e-10,  4.238711002341640e-13, -5.085581043682149e-15, -2.845329016725992e-17,  6.703479281831430e-20,
  1.142433934934267e-21,  1.463064570608384e-24, -3.493918550922520e-26,  1.626842805272340e+00, -2.903196899059667e-03, -1.148429907035394e-05, -6.612606949202547e-09,
  2.061623372869260e-10,  1.034668141002048e-12, -1.295148467662764e-15, -3.722586900003650e-17, -1.254302815458979e-19,  6.894498586690506e-22,  7.583576263501647e-24,
  1.031990823725334e-26,  1.717175451071970e+00, -2.403583395966004e-03, -1.168321407630373e-05, -2.540686472293340e-08,  1.107820546972948e-10,  1.250844896156104e-12,
  3.816848861521784e-15, -1.730151195998996e-17, -2.283383919540339e-19, -7.527078065187258e-22,  3.734320001624813e-24,  5.075409108938151e-26,  1.799292351422212e+00,
 -1.845804290862596e-03, -1.063309177293429e-05, -3.850124315286890e-08, -2.048507706602869e-11,  8.595489330841091e-13,  6.508292527684295e-15,  1.858028518647157e-17,
 -8.616102944506133e-20, -1.288363521341398e-21, -6.395399191221767e-24,  7.305915320372932e-28,  1.870587445952405e+00, -1.273504050413778e-03, -8.416960119625828e-06,
 -4.132462492828949e-08, -1.300798513690304e-10,  5.073584372316368e-14,  4.189898759787497e-15,  3.306753970380551e-17,  1.387938852728511e-19,  3.007408278019300e-23,
 -4.803780182790586e-24, -4.352971751456811e-26,  1.928410836442023e+00, -7.439170762388589e-04, -5.466807937424879e-06, -3.277685174472402e-08, -1.611337483646203e-10,
 -5.880837789297371e-13, -7.778694925568516e-16,  1.075811204278457e-17,  1.273313734631148e-19,  8.633445391434006e-22,  3.962927083328747e-24,  7.904501342137372e-27,
  1.970305089972055e+00, -3.209306616168222e-04, -2.540377937722359e-06, -1.730612600920044e-08, -1.058324000591974e-10, -5.851905490644699e-13, -2.878839601234838e-15,
 -1.191984184428622e-17, -3.387883847887038e-20,  2.761901086155447e-23,  1.401681694495915e-24,  1.392599440142508e-26,  1.994302013202311e+00, -6.297840819430800e-05,
 -5.197652323842024e-07, -3.790944957218261e-09, -2.573373064554002e-11, -1.662209130624850e-13, -1.032800258950640e-15, -6.206776331848421e-18, -3.616069178888406e-20,
 -2.042399114320480e-22, -1.116006827086381e-24, -5.871777389766335e-27,  6.830046250211034e-04, -4.017089167248074e-06,  1.771438738356556e-08, -6.942155801957926e-11,
  2.549137018462204e-13, -8.983621424294018e-16,  3.075064319974176e-18, -1.031098716795687e-20,  3.396783316527211e-23, -1.106595478584145e-25,  3.551708093108501e-28,
 -1.137695483936967e-30,  6.146838946799318e-03, -3.610138705113160e-05,  1.586767488525990e-07, -6.182139278989746e-10,  2.249352654478594e-12, -7.822875801677940e-15,
  2.629536650633520e-17, -8.608328096966826e-20,  2.749431218123070e-22, -8.616078013573953e-25,  2.632832597024117e-27, -7.951514359625117e-30,  1.707338554559299e-02,
 -9.998912122443901e-05,  4.365792723595345e-07, -1.680785117491524e-09,  6.000989622431231e-12, -2.029727254232839e-14,  6.559450681212354e-17, -2.034420662840587e-19,
  6.034900989990396e-22, -1.710879416336198e-24,  4.535206549434065e-27, -1.122091566148868e-29,  3.346020091817212e-02, -1.951122356058547e-04,  8.433415578346882e-07,
 -3.187507247980879e-09,  1.104541345851740e-11, -3.569155129782838e-14,  1.077371700178167e-16, -3.016953068000305e-19,  7.623598336403378e-22, -1.643377340048437e-24,
  2.327204859168045e-27,  1.805885259189342e-30,  5.530311124004145e-02, -3.206026639649663e-04,  1.366755250975489e-06, -5.035000910497507e-09,  1.671181527702392e-11,
 -5.036083276751245e-14,  1.354557899770836e-16, -3.083068220588174e-19,  4.815127288994095e-22,  2.107180233071519e-25, -6.224255664785053e-27,  3.416089588551440e-29,
  8.259557337201115e-02, -4.752727336510467e-04,  1.990385419514723e-06, -7.087594914092633e-09,  2.215571734117308e-11, -6.001021003280830e-14,  1.304473213881765e-16,
 -1.590583544038290e-19, -4.056907693261468e-22,  3.991515015765965e-24, -1.928354577934455e-26,  6.955044177435897e-29,  1.153277731454685e-01, -6.575883482392324e-04,
  2.693451390897732e-06, -9.179594708458423e-09,  2.640551057393737e-11, -6.018643193936771e-14,  7.715723733254254e-17,  1.787234528451584e-19, -1.846051048897660e-21,
  8.646438449526758e-24, -2.971403594688289e-26,  7.275330153082583e-29,  1.534854144265521e-01, -8.656343780618392e-04,  3.450700176635905e-06, -1.111866347591661e-08,
  2.842517988566588e-11, -4.689509532001499e-14, -3.290392244923361e-17,  6.834815984164169e-19, -3.482928447429292e-21,  1.182051575112915e-23, -2.646144915034393e-26,
  5.331715780164860e-30,  1.970481356818390e-01, -1.097071581799355e-03,  4.232292430752139e-06, -1.269073015269420e-08,  2.719596243432008e-11, -1.733318332554625e-14,
 -1.967250049459602e-16,  1.262274138554143e-18, -4.644913598593125e-21,  1.032114488212998e-23,  6.894875738515300e-28, -1.440435127723936e-28,  2.459874700719714e-01,
 -1.349084323842306e-03,  5.003730647428433e-06, -1.366696950388111e-08,  2.181972160918143e-11,  2.928974324061399e-14, -3.958774839982087e-16,  1.745608883774763e-18,
 -4.447648673114424e-21,  1.293471133652778e-24,  5.340265044395749e-26, -3.251480669827341e-28,  3.002642392014764e-01, -1.618318379530135e-03,  5.725873201812995e-06,
 -1.381354993541863e-08,  1.164623959522515e-11,  9.089617146641442e-14, -5.940509120547261e-16,  1.901938219694610e-18, -2.041028050836410e-21, -1.595476564277278e-23,
  1.164352826850541e-25, -4.097987798546716e-28,  3.598252379905684e-01, -1.900808297581787e-03,  6.355097454397285e-06, -1.290500668275240e-08, -3.575042833887730e-12,
  1.617489635808485e-13, -7.373275976992973e-16,  1.479729292885528e-18,  2.992513956351866e-21, -3.788309747247316e-23,  1.533482105512078e-25, -2.238673622619510e-28,
  4.245990268445475e-01, -2.191894220052698e-03,  6.843702459975727e-06, -1.074224861198318e-08, -2.352182950003350e-11,  2.318849268373589e-13, -7.588386390096974e-16,
  2.830217107952900e-19,  1.013712847722425e-20, -5.529586706885439e-23,  1.130525752628067e-25,  3.472298629049464e-28,  4.944905952518059e-01, -2.486128911300520e-03,
  7.140679179487931e-06, -7.176296565332648e-09, -4.711379116826932e-11,  2.870219998083425e-13, -5.896601870003552e-16, -1.719904653659531e-18,  1.747924362774048e-20,
 -5.400071796153658e-23, -4.616703510373396e-26,  1.187648083270690e-27,  5.693745959234645e-01, -2.777177280571734e-03,  7.193025848255718e-06, -2.138783074199016e-09,
 -7.233590282623238e-11,  3.092952928972377e-13, -1.776012734043042e-16, -4.268499801257778e-18,  2.154509451463321e-20, -1.928423342825824e-23, -3.139745854852787e-25,
  1.795553762087077e-27,  6.490867687284896e-01, -3.057713303172271e-03,  6.947849825319812e-06,  4.320159488458095e-09, -9.610829360253190e-11,  2.792858040183514e-13,
  4.856094151855695e-16, -6.699634119571119e-18,  1.783754145824560e-20,  5.460014008840264e-23, -5.799806202124149e-25,  1.325196143352591e-27,  7.334130784348466e-01,
 -3.319323566331053e-03,  6.355573507850832e-06,  1.198703692485260e-08, -1.142664749920310e-10,  1.798656983652068e-13,  1.331110995923841e-15, -7.926058892731162e-18,
  2.517575896013502e-21,  1.510854522644616e-22, -6.183550634581638e-25, -9.306174096361827e-28,  8.220759823885754e-01, -3.552433588459808e-03,  5.374642392531073e-06,
  2.043574394573869e-08, -1.217505037519645e-10,  2.286333250129008e-15,  2.181676742222219e-15, -6.612182047804253e-18, -2.455197680915622e-20,  2.203657299188839e-22,
 -1.680404211815531e-25, -4.525224594331391e-27,  9.147171335488553e-01, -3.746283844349841e-03,  3.978194638410613e-06,  2.898054424436981e-08, -1.131409181806580e-10,
 -2.455235393958014e-13,  2.739575714092648e-15, -1.671286337388671e-18, -5.598902603445263e-20,  1.846866878286495e-22,  8.362724327294031e-25, -6.813953993892425e-27,
  1.010875734466830e+00, -3.888998694963348e-03,  2.163140380669901e-06,  3.664471565549349e-08, -8.370754950695829e-11, -5.296204220079219e-13,  2.622189411378173e-15,
  6.856234178422308e-18, -7.454595377158372e-20, -2.130834365184678e-23,  1.931349678798315e-24, -3.432611452402566e-27,  1.109961738440237e+00, -3.967814924447137e-03,
 -3.809110425332433e-08,  4.216873462620285e-08, -3.111589239662943e-11, -7.830289830615319e-13,  1.481919411524088e-15,  1.672489286284508e-17, -5.669822765650761e-20,
 -3.672773771125577e-22,  1.992656312816073e-24,  7.631783950626265e-27,  1.211223240219881e+00, -3.969568412040816e-03, -2.543440661233536e-06,  4.409568469628296e-08,
  4.221258955617893e-11, -9.077416559030261e-13, -7.651794499354397e-16,  2.289088808923765e-17,  1.259081678211793e-20, -6.406953355344821e-22, -1.161605014395689e-25,
  1.901828387621024e-26,  1.313707879826902e+00, -3.881575947159955e-03, -5.206293340907405e-06,  4.098507524965800e-08,  1.264879846984400e-10, -7.958573331666814e-13,
 -3.639425883189342e-15,  1.873801458840550e-17,  1.142990387605987e-19, -4.832196107898199e-22, -3.794245620797392e-24,  1.293754864906183e-26,  1.416219179244709e+00,
 -3.693085426917239e-03, -7.803616163012422e-06,  3.180781265199862e-08,  2.028631517982352e-10, -3.796011641503809e-13, -5.904515793513999e-15,  5.302132520709757e-19,
  1.771620616219256e-19,  2.884196638350974e-22, -5.251967776742527e-24, -1.879879410624584e-26,  1.517270858594540e+00, -3.397477266206699e-03, -1.003475666626325e-05,
  1.653893349521626e-08,  2.449383232237654e-10,  2.925375762449643e-13, -5.845996291398149e-15, -2.564198323344798e-17,  1.088247779799581e-19,  1.167984124064977e-21,
 -2.365889115918699e-25, -4.192723142348215e-26,  1.615045847556655e+00, -2.995331060668743e-03, -1.154318234637885e-05, -3.150513759513750e-09,  2.264581971655331e-10,
  9.906481750704048e-13, -2.389512736610099e-15, -4.078328994831605e-17, -9.507248988370302e-20,  9.983080040743501e-22,  7.764678146306690e-24, -2.666978433017416e-27,
  1.707372300227831e+00, -2.498236572622823e-03, -1.197662018221120e-05, -2.342941936831291e-08,  1.366713871905140e-10,  1.335786392493374e-12,  3.226268775625575e-15,
 -2.500856857974290e-17, -2.521887346097077e-19, -5.564912962881275e-22,  6.124920722032770e-24,  5.737125021116221e-26,  1.791736072622679e+00, -1.932721294152285e-03,
 -1.109647799625941e-05, -3.868281903028602e-08, -1.691766559995654e-12,  1.021634755712017e-12,  6.982617226680843e-15,  1.503195435413206e-17, -1.371037944763063e-19,
 -1.539594130708252e-21, -6.059661757815258e-24,  1.535514592021853e-26,  1.865355567915017e+00, -1.342858580872031e-03, -8.925291218818175e-06, -4.339199735582444e-08,
 -1.279819687237660e-10,  1.629055645521594e-13,  5.177845348997888e-15,  3.748526315619884e-17,  1.359300759764877e-19, -2.032555076465004e-22, -6.933449716772228e-24,
 -5.322292126707873e-26,  1.925345145107817e+00, -7.892695569355872e-04, -5.875990118613716e-06, -3.544998838545929e-08, -1.730552077539714e-10, -6.026476631073967e-13,
 -4.147037389688874e-16,  1.536121053669397e-17,  1.613386296164334e-19,  1.027648878804389e-21,  4.218108718031988e-24,  3.192273753016767e-27,  1.968979364169224e+00,
 -3.421140800313003e-04, -2.758610061550121e-06, -1.909694456994403e-08, -1.182547944658925e-10, -6.584089353238314e-13, -3.227538889635281e-15, -1.297594680508029e-17,
 -3.171387567142028e-20,  9.747931580692595e-23,  2.132363180024364e-24,  1.956631970396045e-26,  1.994041484987748e+00, -6.732575669495890e-05, -5.678412456736063e-07,
 -4.230688296287880e-09, -2.932080370186230e-11, -1.932314680388379e-13, -1.223959811843624e-15, -7.490707624943127e-18, -4.438311111638973e-20, -2.544912416252606e-22,
 -1.408231367099987e-24, -7.475771211995597e-27,  6.672145186306158e-04, -3.878638306374623e-06,  1.690522020977480e-08, -6.548276284593905e-11,  2.376617086355019e-13,
 -8.279058480729969e-16,  2.800994374985950e-18, -9.285109473864396e-21,  3.022819152218836e-23, -9.740559057060325e-26,  3.086743802489853e-28, -9.800992307691826e-31,
  6.004926090668037e-03, -3.486104717692205e-05,  1.514690653493134e-07, -5.834424583838388e-10,  2.099015808634226e-12, -7.219744744034621e-15,  2.400368717739805e-17,
 -7.776172705384274e-20,  2.457394368357145e-22, -7.629784421513225e-25,  2.306103098482560e-27, -6.925837289879235e-30,  1.668028885377683e-02, -9.657556276762116e-05,
  4.169728216257187e-07, -1.587933210127066e-09,  5.610336487618105e-12, -1.878923437540718e-14,  6.015947735995394e-17, -1.850817844069473e-19,  5.450477109553757e-22,
 -1.539027496158035e-24,  4.065081719859773e-27, -1.016483373166108e-29,  3.269300736116874e-02, -1.885155524910885e-04,  8.061287214790632e-07, -3.016353614819535e-09,
  1.035676912576740e-11, -3.320452616700226e-14,  9.962247351927500e-17, -2.782282853687172e-19,  7.048885586501434e-22, -1.549180290008267e-24,  2.371507965176203e-27,
  2.746949842330148e-31,  5.404219232596992e-02, -3.099058318024396e-04,  1.307906900387639e-06, -4.775495868639989e-09,  1.573641779362126e-11, -4.721173838825228e-14,
  1.270397309336568e-16, -2.928222698992119e-19,  4.849615715630847e-22, -1.012812961910209e-26, -4.864029420575350e-27,  2.784512146669611e-29,  8.072579833582358e-02,
 -4.596839186136773e-04,  1.907422169483876e-06, -6.742536505910892e-09,  2.098645271626392e-11, -5.693425730800730e-14,  1.258325125401045e-16, -1.698844005544540e-19,
 -2.751687987929170e-22,  3.278543854659160e-24, -1.643335326786904e-26,  6.016626929988335e-29,  1.127398273455037e-01, -6.364742661809090e-04,  2.585791790646146e-06,
 -8.766634170393585e-09,  2.522067170902243e-11, -5.828100291635917e-14,  8.137965810102781e-17,  1.244069609821684e-19, -1.555413523776085e-21,  7.520609654729193e-24,
 -2.661094655204222e-26,  6.815421455434870e-29,  1.500772539196852e-01, -8.385548123745729e-04,  3.319973959688964e-06, -1.067140043458866e-08,  2.748086772716331e-11,
 -4.746734800116056e-14, -1.526426961975518e-17,  5.786329174982189e-19, -3.076350082825422e-21,  1.077058590547277e-23, -2.594801238235265e-26,  1.729555597474050e-29,
  1.927266119445277e-01, -1.063815028053530e-03,  4.082602242562526e-06, -1.225861287341699e-08,  2.680486225685506e-11, -2.164691212290396e-14, -1.634064228693359e-16,
  1.119575478742677e-18, -4.274282055481332e-21,  1.023299523866972e-23, -4.836660693836198e-27, -1.082911251171051e-28,  2.406701622106229e-01, -1.309704516986920e-03,
  4.841839410412113e-06, -1.331366749391416e-08,  2.231438203520183e-11,  2.035918260130296e-14, -3.489831999726359e-16,  1.604414347552423e-18, -4.365945563160574e-21,
  3.158335447093716e-24,  4.020127532920471e-26, -2.756359829060270e-28,  2.938815344728710e-01, -1.573171143316649e-03,  5.561286172930594e-06, -1.361342338966707e-08,
  1.332586412094971e-11,  7.727012101385760e-14, -5.417911632226169e-16,  1.828299421981347e-18, -2.535845137020046e-21, -1.165055905850389e-23,  9.897166487922688e-26,
 -3.828604953161473e-28,  3.523227045225495e-01, -1.850587690996572e-03,  6.199997848861376e-06, -1.293727474313178e-08, -5.136154304560013e-13,  1.445598928944955e-13,
 -6.947512309973877e-16,  1.554832624178389e-18,  1.736604309141749e-21, -3.196283818219698e-23,  1.422965823616352e-25, -2.745000424524721e-28,  4.159401242170378e-01,
 -2.137666280191709e-03,  6.712687228615963e-06, -1.108248249067150e-08, -1.906542859023926e-11,  2.138027431764051e-13, -7.466654786160143e-16,  5.764589452154141e-19,
  8.231087240068543e-21, -5.051933567566502e-23,  1.245686730988195e-25,  1.817141780158582e-28,  4.846597675520464e-01, -2.429360323849863e-03,  7.050227598495838e-06,
 -7.884977880411976e-09, -4.151845136963995e-11,  2.723536657315768e-13, -6.302810379793650e-16, -1.191931719246455e-18,  1.551392526404098e-20, -5.487307892656801e-23,
  8.163815958779225e-28,  9.499114008908894e-28,  5.583807855079426e-01, -2.719754942310696e-03,  7.160619481721874e-06, -3.246941108131951e-09, -6.620190262220160e-11,
  3.036758291226356e-13, -2.875878279590817e-16, -3.592435917266775e-18,  2.064352066353187e-20, -3.029904910344659e-23, -2.377538592897274e-25,  1.660292582637729e-27,
  6.369673731040328e-01, -3.001948850053484e-03,  6.990651551410540e-06,  2.827683155771231e-09, -9.042088555121824e-11,  2.887555125250781e-13,  3.062751373319732e-16,
 -6.101741572854196e-18,  1.940035284000399e-20,  3.264646970095166e-23, -5.159767863648156e-25,  1.562463507532477e-27,  7.202383408563287e-01, -3.267934396677750e-03,
  6.488572497682280e-06,  1.018921237583280e-08, -1.103676029393906e-10,  2.091631633489448e-13,  1.111092467015911e-15, -7.763310886282282e-18,  7.503710770469935e-21,
  1.257658586565458e-22, -6.420704029828969e-25, -1.683833041894996e-28,  8.079537487048394e-01, -3.508488628107473e-03,  5.608193820264952e-06,  1.849088215361866e-08,
 -1.211965990182175e-10,  5.234337646988051e-14,  1.986717554126018e-15, -7.272585028288929e-18, -1.678529107049864e-20,  2.099369792674451e-22, -3.464534772596371e-25,
 -3.573156654385156e-27,  8.997978078980146e-01, -3.713098345528171e-03,  4.314949115563752e-06,  2.713455872166660e-08, -1.173987007340990e-10, -1.805313710853977e-13,
  2.668738765592044e-15, -3.350686619220126e-18, -4.881049491364468e-20,  2.121417687171360e-22,  5.372498020060456e-25, -6.709693277165981e-27,  9.953571017547548e-01,
 -3.869958176523503e-03,  2.594502737093207e-06,  3.522413534863488e-08, -9.365647675599704e-11, -4.646539233418306e-13,  2.780756471856974e-15,  4.473068435133742e-18,
 -7.396434900792124e-20,  5.233160791678564e-23,  1.736878709103631e-24, -5.321746761934945e-27,  1.094093060607680e+00, -3.966105194416094e-03,  4.644364719279953e-07,
  4.154768351496112e-08, -4.638398870963217e-11, -7.420600258949969e-13,  1.922941098464986e-15,  1.471498043718928e-17, -6.841334076179138e-20, -2.818213053507456e-22,
  2.255861101425955e-24,  4.302082181405428e-27,  1.195307637176851e+00, -3.987789247806527e-03, -2.010841781077720e-06,  4.462506813766673e-08,  2.392617477692958e-11,
 -9.183903996711898e-13, -1.220582927232052e-16,  2.292548532029774e-17, -1.035758252983219e-20, -6.287799040777937e-22,  7.050538167524939e-25,  1.807600707718263e-26,
  1.298101437149289e+00, -3.921225845164667e-03, -4.702869725311462e-06,  4.287698562601036e-08,  1.097419377319640e-10, -8.765113676385633e-13, -3.066372548212291e-15,
  2.208917823523588e-17,  9.432465816904014e-20, -6.218413805280009e-22, -3.095234186983506e-24,  1.864105041554338e-26,  1.401324474147996e+00, -3.753933029381328e-03,
 -7.402722984283106e-06,  3.498520408733016e-08,  1.938585933638205e-10, -5.204826667885046e-13, -5.809038091004108e-15,  6.323496815753193e-18,  1.835845080936193e-19,
  6.403473068607168e-23, -5.908261567812374e-24, -1.070631160419530e-26,  1.503521744960730e+00, -3.476894433556746e-03, -9.812607652852408e-06,  2.049689296405666e-08,
  2.493300776754706e-10,  1.440501647411030e-13, -6.508931565844398e-15, -2.149235732167571e-17,  1.502437034968173e-19,  1.120182023503550e-21, -2.183130409456923e-24,
 -4.597708704953705e-26,  1.602879681874720e+00, -3.087764663880486e-03, -1.155860586484498e-05,  6.278111828236673e-10,  2.456035530834834e-10,  9.192882420780984e-13,
 -3.568209761441454e-15, -4.319113851167028e-17, -5.361213513709577e-20,  1.302003214617477e-21,  7.302693146916145e-24, -1.876508450253087e-26,  1.697186002570191e+00,
 -2.595134915114020e-03, -1.224375820518199e-05, -2.102499900343540e-08,  1.640999152125172e-10,  1.403885352628532e-12,  2.410402643255251e-15, -3.334685402591250e-17,
 -2.671937063944744e-19, -2.599344050953924e-22,  8.720405733116402e-24,  5.973915649261008e-26,  1.783824705376940e+00, -2.023348740882842e-03, -1.156013009262296e-05,
 -3.853718688867731e-08,  2.044806367358394e-11,  1.193719691452705e-12,  7.333432849087197e-15,  9.712685660870298e-18, -1.966805080564573e-19, -1.763035525424754e-21,
 -4.968802799858100e-24,  3.506748488393561e-26,  1.859837982379076e+00, -1.416378244300727e-03, -9.458151071068410e-06, -4.540652645826292e-08, -1.233936537452845e-10,
  3.002516332961555e-13,  6.286820425837608e-15,  4.165968152646956e-17,  1.230318921616032e-19, -5.300998688938406e-22, -9.471642681159167e-24, -6.182264848474757e-26,
  1.922091289174666e+00, -8.380270671111076e-04, -6.318402352528575e-06, -3.831567892527756e-08, -1.851696862773683e-10, -6.068204331053681e-13,  9.348465375459332e-17,
  2.114868735563315e-17,  2.013857299981469e-19,  1.197020436403528e-21,  4.189299174312411e-24, -5.230955276805276e-27,  1.967565271955832e+00, -3.651328079139562e-04,
 -2.999574382073794e-06, -2.109870096830419e-08, -1.322275885781507e-10, -7.403405891676670e-13, -3.604417948559082e-15, -1.391637586929292e-17, -2.644324727696039e-20,
  2.020634079529969e-22,  3.151900823461205e-24,  2.713403148706030e-26,  1.993762763308795e+00, -7.207983940455219e-05, -6.215572072031757e-07, -4.732408545282362e-09,
 -3.349703916556704e-11, -2.252927412338755e-13, -1.455041963804904e-15, -9.069102323770012e-18, -5.464309248151441e-20, -3.179656892373475e-22, -1.780377481032185e-24,
 -9.521465575701968e-27,  6.519655618708368e-04, -3.746476308446151e-06,  1.614170775631385e-08, -6.180907441518926e-11,  2.217553231544965e-13, -7.636956316615246e-16,
  2.554042893573728e-18, -8.371611870934779e-21,  2.693381811105166e-23, -8.588021164101511e-26,  2.685657785370306e-28, -8.466964178271786e-31,  5.867861857184565e-03,
 -3.367673973409431e-05,  1.446645957414295e-07, -5.509827884203688e-10,  1.960209922030189e-12, -6.668920355932510e-15,  2.193244440403970e-17, -7.032031733673963e-20,
  2.198616289604079e-22, -6.765604932466671e-25,  2.021190233817242e-27, -6.047392243934945e-30,  1.630053960227550e-02, -9.331450303574797e-05,  3.984440638955524e-07,
 -1.501097383031507e-09,  5.248580281815347e-12, -1.740567359936051e-14,  5.521325831517276e-17, -1.684962124818064e-19,  4.924644316526543e-22, -1.385080834704974e-24,
  3.639204128732414e-27, -9.210275180416782e-30,  3.195161787937816e-02, -1.822085402914096e-04,  7.709052266270500e-07, -2.855830728818077e-09,  9.715969930986552e-12,
 -3.090457350660778e-14,  9.213961799292974e-17, -2.565458701785471e-19,  6.508250676040925e-22, -1.454447032872835e-24,  2.356593707008469e-27, -9.022165800672029e-31,
  5.282313852099150e-02, -2.996675907946670e-04,  1.252081015399654e-06, -4.531104158410418e-09,  1.482201749720084e-11, -4.425942112940406e-14,  1.190576610221314e-16,
 -2.773445863868428e-19,  4.813751244237118e-22, -1.818203059116775e-25, -3.759398151134031e-27,  2.251251628524968e-29,  7.891707692934077e-02, -4.447425601770666e-04,
  1.828489381321250e-06, -6.415700291871347e-09,  1.987757737961051e-11, -5.397224852889829e-14,  1.209693419239068e-16, -1.769232020418161e-19, -1.683585583719055e-22,
  2.671607171751958e-24, -1.397490499205761e-26,  5.173131154300180e-29,  1.102346462540515e-01, -6.162019581654099e-04,  2.482975246370572e-06, -8.372321178143584e-09,
  2.407483689135202e-11, -5.629147179403791e-14,  8.420549815497872e-17,  7.876593852745659e-20, -1.303122486086980e-21,  6.514630906689881e-24, -2.372651162200042e-26,
  6.286969552697771e-29,  1.467753536845071e-01, -8.124998453750362e-04,  3.194523939429242e-06, -1.023931591827320e-08,  2.652911368543543e-11, -4.765004274284201e-14,
 -3.838811073023704e-19,  4.861949047984566e-19, -2.707083724200441e-21,  9.750517977980773e-24, -2.499662131370267e-26,  2.537551985673813e-29,  1.885357520616222e-01,
 -1.031735366844304e-03,  3.938057206129944e-06, -1.183340128058714e-08,  2.633516723118433e-11, -2.520760587996797e-14, -1.339181243311398e-16,  9.886465491426928e-19,
 -3.910441815692939e-21,  9.953272758301880e-24, -8.937017709930105e-27, -7.911058174246616e-29,  2.355078103404016e-01, -1.271602760167363e-03,  4.684229585169434e-06,
 -1.295381999478401e-08,  2.264136742456417e-11,  1.250699734609672e-14, -3.059963696339779e-16,  1.466810739961697e-18, -4.226099428424296e-21,  4.537373759034905e-24,
  2.907694946302585e-26, -2.308409064371197e-28,  2.876768011244973e-01, -1.529330560674612e-03,  5.399253132114485e-06, -1.338853560430929e-08,  1.474533430760916e-11,
  6.487191105318931e-14, -4.917926316304716e-16,  1.741173311241473e-18, -2.887982264160584e-21, -8.019407600412447e-24,  8.282075099851504e-26, -3.506620662914341e-28,
  3.450185705764099e-01, -1.801608623177744e-03,  6.044793760449906e-06, -1.292325406101336e-08,  2.214396575418658e-12,  1.284135421399045e-13, -6.506032095975840e-16,
  1.593067649220527e-18,  6.853917592201726e-22, -2.652248065331182e-23,  1.295103117719144e-25, -3.035448080476000e-28,  4.074960129226630e-01, -2.084501608635143e-03,
  6.578005129716380e-06, -1.135428855880138e-08, -1.496711921491360e-11,  1.961045797536411e-13, -7.271035773507500e-16,  8.117293813774961e-19,  6.503625647193375e-21,
 -4.541817314109912e-23,  1.295188177111921e-25,  4.839996920477881e-29,  4.750545152358251e-01, -2.373347866433415e-03,  6.951799155085783e-06, -8.506528763556905e-09,
 -3.622506661956637e-11,  2.568807069932672e-13, -6.570013620415694e-16, -7.270089665662423e-19,  1.354854536110391e-20, -5.407120311407018e-23,  3.766075676372671e-26,
  7.280395283568228e-28,  5.476160640666491e-01, -2.662643387561193e-03,  7.115499926805875e-06, -4.257991302484244e-09, -6.020517348164575e-11,  2.956402397488732e-13,
 -3.791039875720678e-16, -2.950991015885428e-18,  1.939872768151191e-20, -3.839809289096061e-23, -1.684963797404924e-25,  1.482365544528093e-27,  6.250716088925303e-01,
 -2.945912062111673e-03,  7.016095060958653e-06,  1.427492437800344e-09, -8.458574136338849e-11,  2.941270292474756e-13,  1.442668069625561e-16, -5.465972098383224e-18,
  2.022108975663660e-20,  1.342455049220245e-23, -4.442798955663343e-25,  1.678023594414568e-27,  7.072711528591373e-01, -3.215566427513829e-03,  6.600390296601792e-06,
  8.458172332792142e-09, -1.059351273333874e-10,  2.332520496381800e-13,  8.977267044425395e-16, -7.455710435939707e-18,  1.156899584362704e-20,  1.001294972254120e-22,
 -6.351865194344221e-25,  4.577256545811039e-28,  7.940108841867577e-01, -3.462768384631368e-03,  5.818492279516027e-06,  1.656263195069569e-08, -1.196896979201847e-10,
  9.752719401175936e-14,  1.776680777013611e-15, -7.691755468426223e-18, -9.512261361875556e-21,  1.932238878194618e-22, -4.820386930139585e-25, -2.590838835206538e-27,
  8.850164705136004e-01, -3.677308478200695e-03,  4.629185572398686e-06,  2.523073954366119e-08, -1.203773119404516e-10, -1.177767793787906e-13,  2.554226806580390e-15,
 -4.786852215137964e-18, -4.085670669691368e-20,  2.278434752622745e-22,  2.513177877726060e-25, -6.233066422421514e-27,  9.799214212613980e-01, -3.847537553215132e-03,
  3.007906518662204e-06,  3.365495099793698e-08, -1.022734019013077e-10, -3.966780638018197e-13,  2.873242390199803e-15,  2.149276077921723e-18, -7.089033336818786e-20,
  1.166876138272517e-22,  1.471156687236790e-24, -6.662045014096052e-27,  1.078239209160321e+00, -3.960409141239948e-03,  9.580745458799597e-07,  4.068945312869403e-08,
 -6.073162578363907e-11, -6.912213325499006e-13,  2.302912170288473e-15,  1.238115017237850e-17, -7.689815984394322e-20, -1.887985849688637e-22,  2.370737761261029e-24,
  9.375203739655297e-28,  1.179327705569517e+00, -4.001728866772599e-03, -1.473650109749651e-06,  4.486100261728555e-08,  5.580786306509789e-12, -9.136749718531652e-13,
  5.118597998720731e-16,  2.223883129696992e-17, -3.229944788633225e-20, -5.852493551400566e-22,  1.454930438445941e-24,  1.580884966634960e-26,  1.282344586856885e+00,
 -3.956762215057634e-03, -4.178401532876092e-06,  4.448883241349195e-08,  9.152755120769485e-11, -9.423627648823507e-13, -2.409144167564368e-15,  2.472718029790234e-17,
  6.992019359359332e-20, -7.278721713030886e-22, -2.175264433382501e-24,  2.289609544104197e-26,  1.386193030675314e+00, -3.811423633922404e-03, -6.964657972944677e-06,
  3.799616152286558e-08,  1.820725464394064e-10, -6.571105649494567e-13, -5.549717490836299e-15,  1.218871543480182e-17,  1.815472759390481e-19, -1.789534308750186e-22,
 -6.170484272188195e-24, -1.019210573848652e-27,  1.489458819228696e+00, -3.554343463298059e-03, -9.542642204946903e-06,  2.450054022397509e-08,  2.506031560910747e-10,
 -1.880578301272442e-14, -7.037489183197353e-15, -1.606017134981102e-17,  1.885071573523625e-19,  9.920499071202322e-22, -4.224395653801656e-24, -4.609313427873952e-26,
  1.590343829352444e+00, -3.180135206661341e-03, -1.152690366206758e-05,  4.699487112020769e-09,  2.630341791573702e-10,  8.189904035247199e-13, -4.794142369671763e-15,
 -4.410232124601168e-17, -1.728353255226827e-21,  1.572384881097522e-21,  6.085150952742497e-24, -3.675436579069767e-26,  1.686608030729999e+00, -2.694047392851050e-03,
 -1.247936876494442e-05, -1.817197046926712e-08,  1.926754674019535e-10,  1.449558187989109e-12,  1.356090811286991e-15, -4.197433958377716e-17, -2.696439561298967e-19,
  1.408298100517410e-22,  1.128976271410438e-23,  5.585982047617258e-26,  1.775543429828751e+00, -2.117672127733946e-03, -1.201979426957813e-05, -3.800938101718814e-08,
  4.610058059685979e-11,  1.372214410622172e-12,  7.507479615770777e-15,  2.368465782101696e-18, -2.632933341420373e-19, -1.924040558530302e-21, -2.903070765892910e-24,
  5.953734919051942e-26,  1.854017641376798e+00, -1.494256017568020e-03, -1.001464935534688e-05, -4.732418229144187e-08, -1.157830855781997e-10,  4.655574783324032e-13,
  7.504988161890842e-15,  4.521280260432230e-17,  9.645519173947082e-20, -9.652846022792843e-22, -1.232742971458267e-23, -6.724486915432575e-26,  1.918635102158037e+00,
 -8.904647251948838e-04, -6.796366313327365e-06, -4.137514831300026e-08, -1.972317567721960e-10, -5.967016725891125e-13,  7.825739484105172e-16,  2.831419916401073e-17,
  2.474073964159415e-19,  1.356403752396809e-21,  3.680459081028559e-24, -1.890917829471608e-26,  1.966055091734477e+00, -3.901792630398466e-04, -3.265956857975207e-06,
 -2.333763114991885e-08, -1.479314852954567e-10, -8.316104888574994e-13, -4.004641688287763e-15, -1.461934244085215e-17, -1.658717714865769e-20,  3.547658299447228e-22,
  4.555979315760569e-24,  3.713238606786399e-26,  1.993464126042393e+00, -7.728891908265248e-05, -6.817169095816258e-07, -5.306395418408563e-09, -3.837374069575928e-11,
 -2.634696454421236e-13, -1.735280709687815e-15, -1.101543580287607e-17, -6.747918073254607e-20, -3.982804237013378e-22, -2.254277856464614e-24, -1.212107377076500e-26,
  6.372333101218783e-04, -3.620250304087865e-06,  1.542079390989198e-08, -5.837992805525973e-11,  2.070758854809491e-13, -7.051168554765276e-16,  2.331253698140025e-18,
 -7.557194138788489e-21,  2.402683681094439e-23, -7.584809991715317e-26,  2.338604194728753e-28, -7.339827920838822e-31,  5.735428396674303e-03, -3.254534691912205e-05,
  1.382366717927521e-07, -5.206585124462732e-10,  1.831939830353274e-12, -6.165396257082814e-15,  2.005842028339229e-17, -6.365934702371267e-20,  1.968986865372746e-22,
 -6.008051583062124e-25,  1.772033998834900e-27, -5.297854778239688e-30,  1.593354459290726e-02, -9.019760158182527e-05,  3.809235001753884e-07, -1.419834580836030e-09,
  4.913344853672436e-12, -1.613543446402316e-14,  5.070868816102834e-17, -1.535078396705239e-19,  4.451264435314071e-22, -1.247359950848262e-24,  3.253026435678357e-27,
 -8.360966884762879e-30,  3.123490482867158e-02, -1.761757818158556e-04,  7.375479766011538e-07, -2.705202192211321e-09,  9.119422082815779e-12, -2.877711643624731e-14,
  8.524016096204436e-17, -2.365391316633121e-19,  6.001495255922227e-22, -1.361262706466605e-24,  2.295966163215765e-27, -1.817449698952544e-30,  5.164416269435678e-02,
 -2.898644703609593e-04,  1.199101963720986e-06, -4.300880743737331e-09,  1.396478286238051e-11, -4.149349143272804e-14,  1.115064885382592e-16, -2.620724798820341e-19,
  4.723488424171170e-22, -3.137701962590540e-25, -2.871041976103601e-27,  1.798648124699111e-29,  7.716688245162152e-02, -4.304172730608274e-04,  1.753374109911624e-06,
 -6.106138563700859e-09,  1.882676100640082e-11, -5.112895418432247e-14,  1.159537822982410e-16, -1.808754023726708e-19, -8.171501716822115e-23,  2.155845954181906e-24,
 -1.186832068671163e-26,  4.415533785383546e-29,  1.078089388617543e-01, -5.967335641016220e-04,  2.384781781737769e-06, -7.996019951611617e-09,  2.296937195957972e-11,
 -5.424857628774564e-14,  8.586112769092540e-17,  4.064059004316780e-20, -1.085027201236715e-21,  5.619242617729364e-24, -2.108438843844038e-26,  5.717639476943693e-29,
  1.435756985897401e-01, -7.874279975137957e-04,  3.074167504905922e-06, -9.822470150176172e-09,  2.557707415057370e-11, -4.750536571816872e-14,  1.206820987085127e-17,
  4.049938374354319e-19, -2.373778069022133e-21,  8.774644016025402e-24, -2.376114749062596e-26,  3.031786106378795e-29,  1.844709302318605e-01, -1.000791788695652e-03,
  3.798567389240524e-06, -1.141623728933107e-08,  2.580104533124393e-11, -2.810326732237221e-14, -1.079345609170156e-16,  8.691701367926411e-19, -3.559330615444712e-21,
  9.533445518296574e-24, -1.188438962668231e-26, -5.576508153694962e-29,  2.304953711989419e-01, -1.234744531907365e-03,  4.530964316091577e-06, -1.258994232456859e-08,
  2.282131666034632e-11,  5.640809786231925e-15, -2.667929162762297e-16,  1.334394420846843e-18, -4.044156044816527e-21,  5.509357638725660e-24,  1.981081286884080e-26,
 -1.912235171189976e-28,  2.816448551902695e-01, -1.486775080075413e-03,  5.240047039917628e-06, -1.314285566231902e-08,  1.592863625642773e-11,  5.364323454820968e-14,
 -4.443726093920138e-16,  1.644748498614743e-18, -3.120676735054832e-21, -5.005069547838787e-24,  6.814832004650515e-26, -3.160749395103776e-28,  3.379078717173753e-01,
 -1.753869797221093e-03,  5.890009340101095e-06, -1.286811073600952e-08,  4.630144918218579e-12,  1.133359670657864e-13, -6.058268241477816e-16,  1.600696630775991e-18,
 -1.794334488710787e-22, -2.161386456666534e-23,  1.158315341952638e-25, -3.158282365277117e-28,  3.992623862821763e-01, -2.032426352545704e-03,  6.440443203394967e-06,
 -1.156332574477730e-08, -1.121757621704331e-11,  1.789488771038629e-13, -7.017001905329263e-16,  9.946865937309346e-19,  4.962037618359698e-21, -4.022744081861983e-23,
  1.292610574806386e-25, -5.555946656391987e-29,  4.656716926577009e-01, -2.318151254929802e-03,  6.846409952781295e-06, -9.045891708758778e-09, -3.124653605752913e-11,
  2.409156040853205e-13, -6.715780804048703e-16, -3.242507885454749e-19,  1.163626314312152e-20, -5.198469733251872e-23,  6.520729872551341e-26,  5.280090609262709e-28,
  5.370789923773609e-01, -2.605939701509465e-03,  7.058817781985061e-06, -5.174492839650962e-09, -5.438968954738868e-11,  2.856190361798291e-13, -4.532574685932094e-16,
 -2.353525708007737e-18,  1.791026959205278e-20, -4.389175419417217e-23, -1.076604020609673e-25,  1.280262482891833e-27,  6.134002947642212e-01, -2.889737341266312e-03,
  7.025299333259691e-06,  1.213183085742346e-10, -7.868059421782950e-11,  2.958263129709064e-13,  3.276773766497207e-19, -4.814449330174606e-18,  2.040239628522850e-20,
 -2.859182294434256e-24, -3.698060288442671e-25,  1.692195345881125e-27,  6.945150960124279e-01, -3.162385765424207e-03,  6.691876138685145e-06,  6.801631074234714e-09,
 -1.010713117823924e-10,  2.523373618674001e-13,  6.946569367490768e-16, -7.032682912363843e-18,  1.472258166516128e-20,  7.527702217397008e-23, -6.039331494718257e-25,
  9.388789284543174e-28,  7.802541195378481e-01, -3.415457832731841e-03,  6.005825323180973e-06,  1.466544416337160e-08, -1.173303465467135e-10,  1.375549956320200e-13,
  1.558068119297280e-15, -7.888778180959844e-18, -2.928159725283693e-21,  1.719452425342077e-22, -5.750044057974808e-25, -1.645780585635356e-27,  8.703831746722194e-01,
 -3.639096818370255e-03,  4.920331150654894e-06,  2.328914084850066e-08, -1.221314208334693e-10, -5.822382093026998e-14,  2.403135012688110e-15, -5.961613289645210e-18,
 -3.253764672944449e-20,  2.326168221049554e-22, -7.127343198307531e-27, -5.476326059038515e-27,  9.645819152919478e-01, -3.821887260308760e-03,  3.401698058029959e-06,
  3.195887068823216e-08, -1.095138173408027e-10, -3.272501560855540e-13,  2.902372332576453e-15, -4.123531331836649e-20, -6.570349179888417e-20,  1.694047445948619e-22,
  1.159135760818205e-24, -7.426427686625601e-27,  1.062415969505647e+00, -3.950809000706494e-03,  1.440071578623651e-06,  3.961026749228567e-08, -7.397673440162109e-11,
 -6.320750626638087e-13,  2.614242893296249e-15,  9.829986793029034e-18, -8.198669066264404e-20, -9.408995770339812e-23,  2.341894712290557e-24, -2.189211838159502e-27,
  1.163300621455620e+00, -4.011364604958863e-03, -9.353826133599559e-07,  4.480498403516018e-08, -1.252011376453850e-11, -8.940539175912405e-13,  1.116997253182159e-15,
  2.088068458940090e-17, -5.216143958605521e-20, -5.140546523367856e-22,  2.080502233567092e-24,  1.247783706472633e-26,  1.266454097957212e+00, -3.988030519486453e-03,
 -3.636380381182415e-06,  4.579959330234930e-08,  7.215938445338092e-11, -9.916458234318816e-13, -1.689506163662710e-15,  2.653060308144635e-17,  4.240136486077425e-20,
 -7.938870030830718e-22, -1.108109159072074e-24,  2.527726372952934e-26,  1.370838857860873e+00, -3.865268603421757e-03, -6.491681859907145e-06,  4.079707549825665e-08,
  1.676294082445246e-10, -7.855595560343000e-13, -5.128408016504756e-15,  1.784760847910600e-17,  1.706789997266387e-19, -4.236334458837544e-22, -5.987914637113834e-24,
  9.343655561564287e-27,  1.475090721259238e+00, -3.629440499862653e-03, -9.224620344783263e-06,  2.849786469133908e-08,  2.485052768535225e-10, -1.923883628538778e-13,
 -7.397609043956278e-15, -9.493049558582254e-18,  2.206988131254368e-19,  7.834786455616223e-22, -6.171792768052720e-24, -4.164642422671477e-26,  1.577439317820906e+00,
 -3.272052113112867e-03, -1.144473939828164e-05,  9.032401600579784e-09,  2.781635644937338e-10,  6.891602560616819e-13, -6.020956901344163e-15, -4.320844344429148e-17,
  5.882002281831062e-20,  1.778070521309059e-21,  4.067610275466228e-24, -5.477410531678222e-26,  1.675630867092863e+00, -2.794699977063567e-03, -1.267797426304388e-05,
 -1.485588238449855e-08,  2.218918876507315e-10,  1.467033873625169e-12,  6.141944395846661e-17, -5.043002375046311e-17, -2.558781696593660e-19,  6.387044103930626e-22,
  1.351736492954511e-23,  4.395063843697328e-26,  1.766877556429256e+00, -2.215640243412697e-03, -1.247054379437014e-05, -3.704242307598130e-08,  7.534684109786057e-11,
  1.552172990287934e-12,  7.445300565715657e-15, -7.181979495224986e-18, -3.339449546409840e-19, -1.979746191207327e-21,  3.209001953663983e-25,  8.738067448231124e-26,
  1.847876742833986e+00, -1.576675492769545e-03, -1.059331455983992e-05, -4.909199970448336e-08, -1.045665427726669e-10,  6.611818222123640e-13,  8.808222252557284e-15,
  4.764237850466267e-17,  5.211198297285679e-20, -1.517909682888011e-21, -1.529898506030699e-23, -6.651861846107714e-26,  1.914961279962251e+00, -9.468762088092935e-04,
 -7.312192082709620e-06, -4.462502197858571e-08, -2.089089373058193e-10, -5.674656126335653e-13,  1.693742481717189e-15,  3.703898974492896e-17,  2.986379667388614e-19,
  1.481448804089499e-21,  2.420693295237401e-24, -3.968746666824811e-26,  1.964440287196800e+00, -4.174686602328986e-04, -3.560776015411781e-06, -2.584295473673183e-08,
 -1.655582208045351e-10, -9.326808262815355e-13, -4.419224042160950e-15, -1.490720905253710e-17, -1.093418530653774e-22,  5.732631488848835e-22,  6.463201955001754e-24,
  5.008942048933159e-26,  1.993143644326772e+00, -8.300821471108980e-05, -7.492590509853353e-07, -5.964902651718588e-09, -4.408590360599507e-11, -3.090754710315313e-13,
 -2.076229458321304e-15, -1.342267890623804e-17, -8.357709964133670e-20, -5.000302816062037e-22, -2.857117543328040e-24, -1.540517534374070e-26,  6.229946828620898e-04,
 -3.499630917092715e-06,  1.473965833544185e-08, -5.517656304270647e-11,  1.935163480799105e-13, -6.516215629050399e-16,  2.130018309748420e-18, -6.830279866617417e-21,
  2.145716890961937e-23, -6.711046813305279e-26,  2.037112660513872e-28, -6.392001402177313e-31,  5.607419917019449e-03, -3.146395607016861e-05,  1.321606498067283e-07,
 -4.923083758604764e-10,  1.713305143261499e-12, -5.704691232388443e-15,  1.836101257093805e-17, -5.769141686531070e-20,  1.764911746001057e-22, -5.343911336708853e-25,
  1.553289642597592e-27, -4.663041642019809e-30,  1.557874291007609e-02, -8.721705331389807e-05,  3.643467271935834e-07, -1.343738041521340e-09,  4.602466239434162e-12,
 -1.496843561695170e-14,  4.660330953111109e-17, -1.399578653563564e-19,  4.024770743892160e-22, -1.124370825141754e-24,  2.901811972345196e-27, -7.622143987942324e-30,
  3.054180031875214e-02, -1.704028102555516e-04,  7.059423759120395e-07, -2.563786837729088e-09,  8.563811947709725e-12, -2.680870423217987e-14,  7.887869050507764e-17,
 -2.181008795216724e-19,  5.527758051435343e-22, -1.271250411309402e-24,  2.199295332414344e-27, -2.553702707954519e-30,  5.050356885789466e-02, -2.804743606436386e-04,
  1.148805092506626e-06, -4.083940236449459e-09,  1.316108899078901e-11, -3.890369524032010e-14,  1.043782238487914e-16, -2.471587367262790e-19,  4.591658338465235e-22,
 -4.139681818881787e-25, -2.167130666344872e-27,  1.410199847571484e-29,  7.547281040684678e-02, -4.166783306958156e-04,  1.681874556167055e-06, -5.812941542898744e-09,
  1.783159937064011e-11, -4.840706449776390e-14,  1.108636983081129e-16, -1.823364632257020e-19, -1.220038453139269e-23,  1.717909023553339e-24, -1.007828454018193e-26,
  3.732115705879061e-29,  1.054595621287823e-01, -5.780329528650024e-04,  2.290999161535932e-06, -7.637077490905368e-09,  2.190507977272328e-11, -5.217799622430575e-14,
  8.654225087541568e-17,  8.998449274701846e-21, -8.973246790752392e-22,  4.824449626078187e-24, -1.869848743490791e-26,  5.124248570117094e-29,  1.404744364985791e-01,
 -7.632992511649746e-04,  2.958721969827983e-06, -9.420818380549274e-09,  2.463073858635826e-11, -4.708794894623501e-14,  2.239078069391461e-17,  3.339063628957127e-19,
 -2.074669177601076e-21,  7.851749373898283e-24, -2.236625022932165e-26,  3.270450314823116e-29,  1.805276823714513e-01, -9.709442546785200e-04,  3.664030460108563e-06,
 -1.100804978649815e-08,  2.521498178466906e-11, -3.041421242992301e-14, -8.514146238823582e-17,  7.606666232713216e-19, -3.225222082874886e-21,  9.014702163328621e-24,
 -1.392041683719068e-26, -3.758294165393236e-29,  2.256279404366715e-01, -1.199094920836310e-03,  4.382078484679473e-06, -1.222423418366429e-08,  2.287305418183721e-11,
 -3.282990117603452e-16, -2.312108395629458e-16,  1.208291933716451e-18, -3.833487077930301e-21,  6.143984692616677e-24,  1.216992230918719e-26, -1.569841549725266e-28,
  2.757806029850250e-01, -1.445481150388904e-03,  5.083895490845502e-06, -1.287997857353690e-08,  1.689852285139610e-11,  4.351949470992527e-14, -3.997412056895578e-16,
  1.542503441185604e-18, -3.255050466898863e-21, -2.547006190079269e-24,  5.500797199726870e-26, -2.813489639175272e-28,  3.309856567002443e-01, -1.707365965202513e-03,
  5.736108789496637e-06, -1.277666944270645e-08,  6.755089911780355e-12,  9.933262085541290e-14, -5.611984612820943e-16,  1.583372153426926e-18, -8.774909562559756e-22,
 -1.725926029133526e-23,  1.018999436264256e-25, -3.157164931018822e-28,  3.912348451941257e-01, -1.981460631629270e-03,  6.300721576032274e-06, -1.171508038552288e-08,
 -7.804663589815874e-12,  1.624589273594027e-13, -6.718366046298621e-16,  1.131292388857372e-18,  3.606099909971644e-21, -3.513065841505779e-23,  1.250084012996048e-25,
 -1.338402334202767e-28,  4.565079311863992e-01, -2.263822316677598e-03,  6.735015745707515e-06, -9.508167878661479e-09, -2.658992792637818e-11,  2.247291484621595e-13,
 -6.757215615005833e-16,  1.871205707506668e-20,  9.816872719657928e-21, -4.896516605270495e-23,  8.449350776375478e-26,  3.528571483265025e-28,  5.267677610761514e-01,
 -2.549731898711078e-03,  6.991688993260657e-06, -5.999641133722154e-09, -4.879110000065602e-11,  2.740133487600743e-13, -5.113752354456952e-16, -1.806403387194638e-18,
  1.626566325880598e-20, -4.713350376705509e-23, -5.596760184948795e-26,  1.068927715056021e-27,  6.019537297878997e-01, -2.833550075006445e-03,  7.019396940625437e-06,
 -1.090283069995343e-09, -7.277452797067928e-11,  2.942901037337659e-13, -1.253716183975711e-16, -4.165929556833436e-18,  2.005102868208194e-20, -1.617657970383768e-23,
 -2.965456224165743e-25,  1.626376395249973e-27,  6.819731015942249e-01, -3.108551380310440e-03,  6.763962161972824e-06,  5.225703933359861e-09, -9.587351184391811e-11,
  2.667017231979052e-13,  5.047121920617642e-16, -6.522775530930876e-18,  1.700869566964132e-20,  5.205564329294642e-23, -5.546709728078379e-25,  1.277471980018161e-27,
  7.666894512228276e-01, -3.366738980770645e-03,  6.170644101944993e-06,  1.281212391875489e-08, -1.142232330731473e-10,  1.722929704653367e-13,  1.336768691033741e-15,
 -7.888003811868477e-18,  2.832793392539078e-21,  1.477566335980749e-22, -6.281864666312864e-25, -7.896474223399159e-28,  8.559072356820000e-01, -3.598649578581626e-03,
  5.188047787604282e-06,  2.132879721953007e-08, -1.227332410601751e-10, -2.661614404336751e-15,  2.222888852020621e-15, -6.869341298777466e-18, -2.422423747711247e-20,
  2.277789323906145e-22, -2.279203696485460e-25, -4.537785489800163e-27,  9.493511796156497e-01, -3.793169910660190e-03,  3.774487443143034e-06,  3.015806968754189e-08,
 -1.153635474649570e-10, -2.578387199428975e-13,  2.872759460468250e-15, -2.037867340408606e-18, -5.885008324335360e-20,  2.091337087778705e-22,  8.257576488987807e-25,
 -7.641016130921693e-27,  1.046638755383104e+00, -3.937408195073040e-03,  1.907887137832242e-06,  3.832900491853507e-08, -8.597006606277021e-11, -5.663293105582865e-13,
  2.852370830753499e-15,  7.170057806064488e-18, -8.371855549167997e-20, -3.165324643959958e-24,  2.184890096455346e-24, -4.856824838542706e-27,  1.147243595506457e+00,
 -4.016701780629374e-03, -3.995095587353280e-07,  4.446326533008670e-08, -3.008680056447949e-11, -8.604351891964653e-13,  1.675626430221909e-15,  1.893249032716363e-17,
 -6.904753776880907e-20, -4.210052401458058e-22,  2.542488558614513e-24,  8.436685368278435e-27,  1.250447300267714e+00, -4.014905075056014e-03, -3.080518887353083e-06,
  4.679353199485203e-08,  5.198183730874094e-11, -1.023153024882180e-12, -9.319982834936721e-16,  2.742380603828500e-17,  1.329409449342074e-20, -8.157271936640569e-22,
  1.823033611982261e-26,  2.557017231888926e-26,  1.355277079856948e+00, -3.915199440088483e-03, -5.986564171883606e-06,  4.334694987356188e-08,  1.507310014814924e-10,
 -9.020430979194976e-13, -4.554827519649057e-15,  2.302008168786378e-17,  1.512433959351933e-19, -6.519271898202895e-22, -5.354031132985235e-24,  1.931367790924037e-26,
  1.460427626133044e+00, -3.701802327172545e-03, -8.858947897406001e-06,  3.243344480104590e-08,  2.428647817188373e-10, -3.722983258064759e-13, -7.560660980495618e-15,
 -2.030500018476691e-18,  2.440395523624932e-19,  5.023092598076410e-22, -7.820309279217403e-24, -3.254281531037942e-26,  1.564168788129765e+00, -3.363099818042706e-03,
 -1.130921857668908e-05,  1.358502619538268e-08,  2.904050971194794e-10,  5.304120928393661e-13, -7.194623913045843e-15, -4.027564233818839e-17,  1.251336255956736e-19,
  1.887699633125175e-21,  1.299264418224954e-24, -7.046442565960857e-26,  1.664248178693430e+00, -2.896774270967173e-03, -1.283397607984035e-05, -1.107130310216635e-08,
  2.511282526744011e-10,  1.450663261517160e-12, -1.461033610163571e-15, -5.814241197267229e-17, -2.227352843957880e-19,  1.212558377833395e-21,  1.502195550365335e-23,
  2.289178153829635e-26,  1.757812683653417e+00, -2.317159713785604e-03, -1.290676393236535e-05, -3.557890820656407e-08,  1.081543650432682e-10,  1.727173943660048e-12,
  7.083947124360516e-15, -1.899804741411088e-17, -4.039811283082909e-19, -1.881560822911886e-21,  4.796014904370298e-24,  1.158208752002823e-25,  1.841396778106189e+00,
 -1.663805785450925e-03, -1.119198211252871e-05, -5.064733311903068e-08, -8.912013629588307e-11,  8.887205783433573e-13,  1.015646545200288e-14,  4.831193396512155e-17,
 -1.423405215369991e-20, -2.186118821188624e-21, -1.803379118769588e-23, -5.578015697083771e-26,  1.911053307214094e+00, -1.007573416123505e-03, -7.868113965753635e-06,
 -4.805577815699992e-08, -2.197619547364228e-10, -5.132409637095866e-13,  2.872752768174995e-15,  4.746352210139557e-17,  3.532199955639146e-19,  1.535286114443740e-21,
  5.383382880568212e-26, -6.955738328147575e-26,  1.962711410583593e+00, -4.472418178378350e-04, -3.887419684810975e-06, -2.864701953110155e-08, -1.853061749193130e-10,
 -1.043730456348021e-12, -4.833190367213243e-15, -1.452603365276475e-17,  2.575384160824533e-20,  8.804290735583119e-22,  9.014304817349805e-24,  6.646057191667596e-26,
  1.992799152419178e+00, -8.930108185382515e-05, -8.252832520768230e-07, -6.722570030111607e-09, -5.079778618481469e-11, -3.637346685918925e-13, -2.492378436350930e-15,
 -1.640861363745160e-17, -1.038089847840326e-19, -6.290166528096528e-22, -3.622126643206222e-24, -1.951619149198740e-26,  6.092278733350674e-04, -3.384310461725067e-06,
  1.409569590094069e-08, -5.218184703601120e-11,  1.809800218604015e-13, -6.027206858548464e-16,  1.948030984230749e-18, -6.180786975281791e-21,  1.918130950247387e-23,
 -5.950019346972641e-26,  1.773769442752225e-28, -5.603038154932973e-31,  5.483641894368769e-03, -3.042984417301417e-05,  1.264137375773417e-07, -4.657848393690797e-10,
  1.603490341861752e-12, -5.282790411684250e-15,  1.682191203770349e-17, -5.233990857545966e-20,  1.583235159216286e-22, -4.761996786326834e-25,  1.360141997929137e-27,
 -4.133140453664963e-30,  1.523560385820414e-02, -8.436554941523445e-05,  3.486540215606027e-07, -1.272434067360053e-09,  4.313972262589047e-12, -1.389556329003836e-14,
  4.285886990918842e-17, -1.277044789499130e-19,  3.640099622984404e-22, -1.014814486003619e-24,  2.580515757734147e-27, -7.003077202732369e-30,  2.987129254355340e-02,
 -1.648760437507508e-04,  6.759816936572251e-07, -2.430954422325091e-09,  8.046084249014788e-12, -2.498694040377333e-14,  7.301274915110350e-17, -2.011275468049767e-19,
  5.085654468294059e-22, -1.185717766122554e-24,  2.072708079771207e-27, -3.190580394166840e-30,  4.939974689433723e-02, -2.714764274796151e-04,  1.101036032309527e-06,
 -3.879453617893061e-09,  1.240751382406348e-11, -3.648001719932136e-14,  9.766113256172800e-17, -2.327194546181554e-19,  4.428427370702482e-22, -4.892750462497055e-25,
 -1.622992860858845e-27,  1.069696097937674e-29,  7.383257204490395e-02, -4.034975778936290e-04,  1.613799606074241e-06, -5.535238252957253e-09,  1.688965183379200e-11,
 -4.580759046632446e-14,  1.057615722281065e-16, -1.818120651991697e-19,  4.276659691208581e-23,  1.345746330981817e-24, -8.575273988303102e-27,  3.108149732100017e-29,
  1.031835141939273e-01, -5.600656596877533e-04,  2.201423047478133e-06, -7.294831813548263e-09,  2.088229429027699e-11, -5.010104802358729e-14,  8.641731177490866e-17,
 -1.707710629204938e-20, -7.365802635609022e-22,  4.119818053222530e-24, -1.657758132867826e-26,  4.513333163897331e-29,  1.374678724273365e-01, -7.400750464964643e-04,
  2.848005725065876e-06, -9.034228390317226e-09,  2.369507300907801e-11, -4.644562459805697e-14,  3.085198607664871e-17,  2.718697199186796e-19, -1.807760862105544e-21,
  6.986096666072220e-24, -2.091461639676339e-26,  3.295114752527320e-29,  1.767017028490523e-01, -9.421535858281661e-04,  3.534334087193841e-06, -1.060958034087104e-08,
  2.458792976229160e-11, -3.221338999712159e-14, -6.523969246777140e-17,  6.625415493383864e-19, -2.911074179427125e-21,  8.429126912577575e-24, -1.525950704440927e-26,
 -2.400608968136951e-29,  2.209007537474790e-01, -1.164618837130681e-03,  4.237582325200533e-06, -1.185860808733596e-08,  2.281366724445100e-11, -5.485027552839257e-15,
 -1.990622221477214e-16,  1.089240262149796e-18, -3.605124459715854e-21,  6.501507673325574e-24,  5.915977575921707e-27, -1.281859785434482e-28,  2.700790484050190e-01,
 -1.405423566200388e-03,  4.930985080128205e-06, -1.260314587936164e-08,  1.767641211751997e-11,  3.443214653762727e-14, -3.580202660159081e-16,  1.437275794429737e-18,
 -3.310029848981431e-21, -5.843630899535338e-25,  4.336537098618457e-26, -2.482568381550992e-28,  3.242470023403075e-01, -1.662088391329644e-03,  5.583500474876911e-06,
 -1.265341157803939e-08,  8.610627051693718e-12,  8.639215116324580e-14, -5.173451123188471e-16,  1.546110716639382e-18, -1.428786569957769e-21, -1.345905161302451e-23,
  8.817362481700000e-26, -3.071034482450962e-28,  3.834089211881891e-01, -1.931619064447872e-03,  6.159495778715556e-06, -1.181482665964220e-08, -4.714097500030329e-12,
  1.467268683593174e-13, -6.387282038648031e-16,  1.227404760188697e-18,  2.429815450922446e-21, -3.026622098914163e-23,  1.178006300922594e-25, -1.905933989256520e-28,
  4.475596697834789e-01, -2.210405479363511e-03,  6.618510567051843e-06, -9.898530406485110e-09, -2.225729905975458e-11,  2.085520112929721e-13, -6.710598517046156e-16,
  3.053279254991054e-19,  8.118282801420591e-21, -4.532078529744029e-23,  9.663582083213078e-26,  2.032189829468188e-28,  5.166802263402570e-01, -2.494099228631843e-03,
  6.915187998332191e-06, -6.737139590232256e-09, -4.343736273442584e-11,  2.611906271223785e-13, -5.549251655908832e-16, -1.313394856420724e-18,  1.453932961053875e-20,
 -4.849361080323053e-23, -1.356305288080963e-26,  8.596255444267734e-28,  5.907317296201775e-01, -2.777466581673227e-03,  6.999520785758438e-06, -2.207790948396424e-09,
 -6.692789126947391e-11,  2.899533205652583e-13, -2.331378532567278e-16, -3.535765622592820e-18,  1.927210944061319e-20, -2.664040508114626e-23, -2.275600169401493e-25,
  1.501126128741648e-27,  6.696474803451311e-01, -3.054214517462262e-03,  6.817644740116402e-06,  3.734997194656716e-09, -9.043281545084281e-11,  2.766862479621830e-13,
  3.299462273705755e-16, -5.952680972549832e-18,  1.849753494292783e-20,  3.106288559974116e-23, -4.934639401553306e-25,  1.484084117673824e-27,  7.533221558241602e-01,
 -3.316789641887818e-03,  6.313543313861282e-06,  1.101378736295644e-08, -1.104743660107927e-10,  2.017400333136564e-13,  1.117938433074147e-15, -7.717150490404826e-18,
  7.693433287733249e-21,  1.221596005249931e-22, -6.463320269944478e-25, -5.772142469077864e-29,  8.415972200092851e-01, -3.556154782999899e-03,  5.432218413645233e-06,
  1.936747127560620e-08, -1.222689804993351e-10,  4.829952911326304e-14,  2.020912857453297e-15, -7.515448527476307e-18, -1.623370583428627e-20,  2.149674432314435e-22,
 -4.051748022101050e-25, -3.512227167846443e-27,  9.342411389996070e-01, -3.761558170343342e-03,  4.125151277791004e-06,  2.827472167339985e-08, -1.198365509686205e-10,
 -1.897828499283543e-13,  2.790507819858211e-15, -3.794889600252745e-18, -5.080738369151731e-20,  2.354864915262678e-22,  4.938345602906759e-25, -7.374440534643017e-27,
  1.030922527684789e+00, -3.920329525930750e-03,  2.359220514987447e-06,  3.686665348044588e-08, -9.659738440189308e-11, -4.957655108342745e-13,  3.015727043286744e-15,
  4.505650156211418e-18, -8.231691931679328e-20,  7.930308852753385e-23,  1.923545696677858e-24, -6.913038533680346e-27,  1.131173762180472e+00, -4.017773096762767e-03,
  1.306009642739844e-07,  4.384656748067449e-08, -4.685176229533632e-11, -8.141218000091432e-13,  2.172668153495674e-15,  1.650074830384708e-17, -8.229523481463952e-20,
 -3.131537668218365e-22,  2.818333566384660e-24,  4.083522704585458e-27,  1.234341965875988e+00, -4.037290559349360e-03, -2.514684750117856e-06,  4.746058317452239e-08,
  3.135742790330671e-11, -1.036285588580055e-12, -1.625770196225077e-16,  2.738167982396065e-17, -1.579099140987918e-20, -7.928739132488390e-22,  1.111486073190991e-24,
  2.379647608652546e-26,  1.339523847463809e+00, -3.960971709604251e-03, -5.452544563445143e-06,  4.560860820509777e-08,  1.316519196362496e-10, -1.003100434140051e-12,
 -3.846320686241208e-15,  2.744485012532575e-17,  1.241482210950850e-19, -8.464488892770859e-22, -4.310016791327853e-24,  2.781635915254150e-26,  1.445481231033064e+00,
 -3.771051675758902e-03, -8.446709208051041e-06,  3.624985121264483e-08,  2.336042748352738e-10, -5.535395054652886e-13, -7.505912382909747e-15,  6.005133802720513e-18,
  2.561794863375496e-19,  1.644834328919664e-22, -8.974560264696619e-24, -1.932300724479254e-26,  1.550536586321802e+00, -3.452841751806619e-03, -1.111800071742444e-05,
  1.830661741760679e-08,  2.991978898475670e-10,  3.447239829677535e-13, -8.256030530866779e-15, -3.518030997558233e-17,  1.932453953295925e-19,  1.874043895082807e-21,
 -2.060920761775945e-24, -8.125467730493311e-26,  1.652454995894615e+00, -2.999907005444765e-03, -1.294177368453542e-05, -6.823617573804506e-09,  2.796550267625895e-10,
  1.395301714384333e-12, -3.181408316931752e-15, -6.445404921163238e-17, -1.680986099243666e-19,  1.825331290931205e-21,  1.539680429266742e-23, -7.272630071429332e-27,
  1.748334877645241e+00, -2.422089510538962e-03, -1.332215871356764e-05, -3.356306099717833e-08,  1.443470941034346e-10,  1.889283525992768e-12,  6.361159266786720e-15,
 -3.296175995915879e-17, -4.669650609923192e-19, -1.580082481968339e-21,  1.045823487311273e-23,  1.404860915814100e-25,  1.834558601723297e+00, -1.755795515840821e-03,
 -1.180767493422161e-05, -5.191735795373508e-08, -6.879919463645005e-11,  1.148579279554503e-12,  1.148997277937531e-14,  4.645356845532658e-17, -1.064555611650054e-19,
 -2.950333473931928e-21, -1.999342824714808e-23, -3.050948993339498e-26,  1.906893386103389e+00, -1.072885533902146e-03, -8.466205764457187e-06, -5.164986643263153e-08,
 -2.292228488459808e-10, -4.270189858549488e-13,  4.368248021302876e-15,  5.964466418333968e-17,  4.076913707394502e-19,  1.465074521248277e-21, -3.861014807766808e-24,
 -1.102966338278003e-25,  1.960857994122186e+00, -4.797682636288481e-04, -4.249682962421649e-06, -3.178535389481125e-08, -2.073730796779690e-10, -1.164482724260536e-12,
 -5.223085807884914e-15, -1.311914187427318e-17,  6.469505164741555e-20,  1.305107350651082e-21,  1.236512079754037e-23,  8.643334426574916e-26,  1.992428212381555e+00,
 -9.624042302578167e-05, -9.110817162831134e-07, -7.596945459039524e-09, -5.870989766828770e-11, -4.294623850015987e-13, -3.001939780586012e-15, -2.012254077056468e-17,
 -1.292812615956688e-19, -7.924955706741690e-22, -4.588766830632425e-24, -2.459066846688399e-26,  5.959122651111227e-04, -3.274001296528195e-06,  1.348649809361232e-08,
 -4.938011938168658e-11,  1.693794677906812e-13, -5.579772584702426e-16,  1.783249650057154e-18, -5.599934840131148e-21,  1.716125603812473e-23, -5.287822512875635e-26,
  1.541897278838915e-28, -4.960060632980859e-31,  5.363910343160294e-03, -2.944046368507100e-05,  1.209748376547098e-07, -4.409527927671432e-10,  1.501755978475171e-12,
 -4.896093707779459e-15,  1.542481918220231e-17, -4.753769435795746e-20,  1.421170321089617e-22, -4.252974625428660e-25,  1.188098153784316e-27, -3.703513219519497e-30,
  1.490362504906784e-02, -8.163624144162448e-05,  3.337899607878141e-07, -1.205579105809715e-09,  4.046064153725612e-12, -1.290857591641693e-14,  3.944086737258500e-17,
 -1.166213650922842e-19,  3.292617603312615e-22, -9.176038787463185e-25,  2.283530407355251e-27, -6.520835575795577e-30,  2.922242236350310e-02, -1.595827248498077e-04,
  6.475664765492399e-07, -2.306121658329131e-09,  7.563421682220325e-12, -2.330041318384821e-14,  6.760271049444327e-17, -1.855207100507114e-19,  4.673364765941296e-22,
 -1.105798340450195e-24,  1.918737361426385e-27, -3.813613260994641e-30,  4.833116761486908e-02, -2.628510327841616e-04,  1.055650039946584e-06, -3.686645036235363e-09,
  1.170083254938874e-11, -3.421275913669792e-14,  9.134064914962398e-17, -2.188419742185906e-19,  4.241652317305307e-22, -5.457092243221622e-25, -1.221256447855917e-27,
  7.598979569863895e-30,  7.224398824386552e-02, -3.908483472359837e-04,  1.548968362620579e-06, -5.272196852519082e-09,  1.599847143280660e-11, -4.333020448038031e-14,
  1.006968200128654e-16, -1.797320148882310e-19,  8.535297812100412e-23,  1.028348012928948e-24, -7.337106914472328e-27,  2.524704704395214e-29,  1.009779278360376e-01,
 -5.427988226733929e-04,  2.115857063746626e-06, -6.968618793195198e-09,  1.990096155371940e-11, -4.803530136270160e-14,  8.563057082383770e-17, -3.839886405151785e-20,
 -5.997408254384128e-22,  3.494589266980351e-24, -1.472993677275558e-26,  3.880389855889502e-29,  1.345524627377694e-01, -7.177182689224032e-04,  2.741839194392642e-06,
 -8.662495817603822e-09,  2.277414877619645e-11, -4.562013888678601e-14,  3.769113532026450e-17,  2.178867204946872e-19, -1.570973474177226e-21,  6.178155249037447e-24,
 -1.949453912045607e-26,  3.129227092008424e-29,  1.729888408995793e-01, -9.143815345565878e-04,  3.409358044736595e-06, -1.022140655807111e-08,  2.392945385256503e-11,
 -3.356677897290094e-14, -4.794792279981335e-17,  5.741226716855205e-19, -2.618838692975526e-21,  7.800673733620668e-24, -1.609498825190477e-26, -1.464475170685207e-29,
  2.163091872093383e-01, -1.131281196372936e-03,  4.097464707025757e-06, -1.149471645515499e-08,  2.265859570724495e-11, -9.909354652274131e-15, -1.701431405041219e-16,
  9.776562293362360e-19, -3.368103133448912e-21,  6.632604810348802e-24,  8.086434242108994e-28, -1.048800379012801e-28,  2.645352989154179e-01, -1.366575779206704e-03,
  4.781465514945985e-06, -1.231526753306947e-08,  1.828232802752247e-11,  2.631060776432494e-14, -3.192603339300277e-16,  1.331332210370003e-18, -3.302393058182956e-21,
  9.408850435920955e-25,  3.311565259844308e-26, -2.182619976310107e-28,  3.176870265974852e-01, -1.618025282190016e-03,  5.432541029673046e-06, -1.250247879852954e-08,
  1.021778531265348e-11,  7.448977116044286e-14, -4.747622479600867e-16,  1.493291621949655e-18, -1.853050225311206e-21, -1.019859985794697e-23,  7.494853053319923e-26,
 -2.934842991688664e-28,  3.757800974131131e-01, -1.882911274460185e-03,  6.017359479465312e-06, -1.186759699189316e-08, -1.930029894581230e-12,  1.318176109961546e-13,
 -6.034297291938419e-16,  1.288617743675290e-18,  1.422908748813817e-21, -2.573467352133270e-23,  1.084885480323185e-25, -2.302360867645528e-28,  4.388231836107808e-01,
 -2.157938266941604e-03,  6.497726320406903e-06, -1.022215051585772e-08, -1.824647529899452e-11,  1.925770402568223e-13, -6.591135466085907e-16,  5.397693782797188e-19,
  6.558112805675659e-21, -4.131511567528650e-23,  1.027344388076998e-25,  7.778692531460922e-29,  5.068139442485795e-01, -2.439112530058059e-03,  6.830342346304716e-06,
 -7.391082094388781e-09, -3.834944615335202e-11,  2.474820816228586e-13, -5.854493849800230e-16, -8.761029387540004e-19,  1.279236511626863e-20, -4.833930523221422e-23,
  1.982403090113940e-26,  6.600170929261592e-28,  5.797336627120151e-01, -2.721594155147267e-03,  6.966792512252959e-06, -3.232581107841023e-09, -6.119244088123712e-11,
  2.832387369596487e-13, -3.236613535413249e-16, -2.936033300627413e-18,  1.816471030420740e-20, -3.446836317033588e-23, -1.650515566281228e-25,  1.334728808340263e-27,
  6.575399542823729e-01, -2.999518254319807e-03,  6.853967010867474e-06,  2.332716742771394e-09, -8.483305449654721e-11,  2.826726439792928e-13,  1.716997587467162e-16,
 -5.346547232843190e-18,  1.927656968307646e-20,  1.266474801137768e-23, -4.257872491731640e-25,  1.574398998316111e-27,  7.401568089910893e-01, -3.265782366857571e-03,
  6.435240894250024e-06,  9.279860787350975e-09, -1.061886022489320e-10,  2.260092978072756e-13,  9.059304576928763e-16, -7.405580136327024e-18,  1.162690071574008e-20,
  9.643934928980486e-23, -6.354000692611631e-25,  5.298719773171642e-28,  8.274609414663537e-01, -3.511800564054931e-03,  5.652930463013052e-06,  1.742145826989225e-08,
 -1.208352893305020e-10,  9.422457760545354e-14,  1.804347040613786e-15, -7.914517802690766e-18, -8.821066717348315e-21,  1.959747481577357e-22, -5.369616594314060e-25,
 -2.483818454588883e-27,  9.192630112495112e-01, -3.727232634043738e-03,  4.452830052954781e-06,  2.633057109296836e-08, -1.229720087018205e-10, -1.242615106753380e-13,
  2.662787206862568e-15, -5.281898408837441e-18, -4.205102993029714e-20,  2.489175587099695e-22,  1.824651655466214e-25, -6.724593158394449e-27,  1.015281720920478e+00,
 -3.899713164755345e-03,  2.792032645437600e-06,  3.524574293380181e-08, -1.057802265735741e-10, -4.221686677306858e-13,  3.105538742520997e-15,  1.931413989622469e-18,
 -7.815458300738702e-20,  1.497076725960248e-22,  1.586714184757283e-24, -8.281806691462763e-27,  1.115108072149512e+00, -4.014637615789431e-03,  6.517342778777606e-07,
  4.296966456283802e-08, -6.257691352151447e-11, -7.567407240438626e-13,  2.596282832161454e-15,  1.370895654307722e-17, -9.150791394740145e-20, -1.981029438348500e-22,
  2.903046211200249e-24, -1.894380851142855e-28,  1.218156185651283e+00, -4.055122975380151e-03, -1.942831365109710e-06,  4.779654363830518e-08,  1.065439355370483e-11,
 -1.031070310495536e-12,  5.928173947936695e-16,  2.643024765078508e-17, -4.329016708170021e-20, -7.284116609743864e-22,  2.085406040275329e-24,  2.020335604411749e-26,
  1.323596234671295e+00, -4.002368599565847e-03, -4.893280241315552e-06,  4.754979622741902e-08,  1.107312353747407e-10, -1.085771025291227e-12, -3.027050207836202e-15,
  3.089928258965918e-17,  9.088634935022626e-20, -9.923732547254852e-22, -2.941641862587713e-24,  3.392392488921580e-26,  1.430264720486463e+00, -3.836822720820802e-03,
 -7.989681827734051e-06,  3.988923945973128e-08,  2.207504869581987e-10, -7.307343745422732e-13, -7.222612304043428e-15,  1.422694478961861e-17,  2.554758307869970e-19,
 -2.069080765118480e-22, -9.477106559650032e-24, -3.161467951433216e-27,  1.536548838098765e+00, -3.540825205657515e-03, -1.086940654975004e-05,  2.313785207522350e-08,
  3.040350065032861e-10,  1.355190355331058e-13, -9.144517433683662e-15, -2.794002033050987e-17,  2.583495844552275e-19,  1.718469369477477e-21, -5.743659911437213e-24,
 -8.477682627373987e-26,  1.640247891044947e+00, -3.103690571579539e-03, -1.299590445311258e-05, -2.130661147003963e-09,  3.066484728937870e-10,  1.296748450144237e-12,
 -5.050710431495648e-15, -6.866420314676974e-17, -9.147399599961035e-20,  2.424178827720447e-21,  1.427120560180136e-23, -4.488708628611259e-26,  1.738430873552278e+00,
 -2.530235620846605e-03, -1.370978525977495e-05, -3.094327199287491e-08,  1.835757473902475e-10,  2.029138283799008e-12,  5.221125557685459e-15, -4.872160484109706e-17,
 -5.147782037047219e-19, -1.032781653154163e-21,  1.701693369180029e-23,  1.554956803856526e-25,  1.827342527149903e+00, -1.852765816530842e-03, -1.243648016755668e-05,
 -5.281895545774329e-08, -4.296708505603247e-11,  1.439458370670764e-12,  1.272590096721739e-14,  4.119128489697077e-17, -2.272840253218145e-19, -3.765389782454089e-21,
 -2.043675936135571e-23,  1.384477545251201e-26,  1.902462370458566e+00, -1.143157331353619e-03, -9.108271319527014e-06, -5.537946390481854e-08, -2.365717538831097e-10,
 -3.006187963452030e-13,  6.228601653556758e-15,  7.349451400112281e-17,  4.563531218905979e-19,  1.198972902672610e-21, -9.826497066968632e-24, -1.627890920287484e-25,
  1.958868428432015e+00, -5.153496446574983e-04, -4.651805975560460e-06, -3.529657140387324e-08, -2.319446226822178e-10, -1.293963860658867e-12, -5.553649574330493e-15,
 -1.019386892851448e-17,  1.215582088915498e-19,  1.882388971697527e-21,  1.666764589254938e-23,  1.095687547790574e-25,  1.992028072575655e+00, -1.039103784319490e-04,
 -1.008177881772174e-06, -8.609132660381537e-09, -6.806778149873218e-11, -5.087652768557423e-13, -3.627843235447048e-15, -2.475366207017501e-17, -1.613913539137709e-19,
 -9.994123164739689e-22, -5.801715073713440e-24, -3.072008969587402e-26,  5.830283549476773e-04, -3.168434319572339e-06,  1.290983621436967e-08, -4.675705111790081e-11,
  1.586355152821854e-13, -5.170005072960243e-16,  1.633861784405367e-18, -5.080083883801950e-21,  1.536354240464536e-23, -4.713134178855761e-26,  1.335191814311576e-28,
 -4.459406668565053e-31,  5.248051140434677e-03, -2.849342955385326e-05,  1.158244052333440e-07, -4.176884016318752e-10,  1.407430842451511e-12, -4.541370644466388e-15,
  1.415519403899660e-17, -4.322606092203892e-20,  1.276234421628946e-22, -3.809286661075476e-25,  1.032724782657877e-27, -3.376507676589843e-30,  1.458233062689604e-02,
 -7.902270831526972e-05,  3.197030776321434e-07, -1.142857109805442e-09,  3.797099972280148e-12, -1.200001917429518e-14,  3.631813481426792e-17, -1.065964543437419e-19,
  2.978040057356690e-22, -8.318948265019021e-25,  2.004217441428739e-27, -6.206565142656121e-30,  2.859428012085343e-02, -1.545108644788605e-04,  6.206040076583375e-07,
 -2.188748559808591e-09,  7.113225887487542e-12, -2.173862946389080e-14,  6.261161642268860e-17, -1.711884099595276e-19,  4.288669892146792e-22, -1.032604207721026e-24,
  1.735782683418310e-27, -4.528022323685152e-30,  4.729637812486847e-02, -2.545796600396628e-04,  1.012511379211769e-06, -3.504788704717284e-09,  1.103801063744461e-11,
 -3.209259915329603e-14,  8.540008282750203e-17, -2.055918421912838e-19,  4.037129494299407e-22, -5.887533896122898e-25, -9.527365857743531e-28,  4.603681214096522e-30,
  7.070498371940634e-02, -3.787053792169884e-04,  1.487209676395405e-06, -5.023024538735191e-09,  1.515562868081894e-11, -4.097352988688716e-14,  9.570773540746694e-17,
 -1.764629609915068e-19,  1.173432629929314e-22,  7.554073420291755e-25, -6.351304368521526e-27,  1.956003016610853e-29,  9.884006418995366e-02, -5.262011190941149e-04,
  2.034112787852487e-06, -6.657777797413870e-09,  1.896070904561879e-11, -4.599512608507603e-14,  8.430483949750313e-17, -5.568817814598906e-20, -4.841473161293311e-22,
  2.937596417967091e-24, -1.316870867076323e-26,  3.206980479232785e-29,  1.317248093937726e-01, -6.961932296114397e-04,  2.640045618206882e-06, -8.305357535506187e-09,
  2.187125753236732e-11, -4.464782214583016e-14,  4.312054592402572e-17,  1.710263306836325e-19, -1.362272102714843e-21,  5.425008018966959e-24, -1.818865787540217e-26,
  2.774060787301913e-29,  1.693850967843333e-01, -8.875908403032986e-04,  3.288976051534552e-06, -9.843963206601156e-09,  2.324786502583607e-11, -3.453383861286509e-14,
 -3.300440306830588e-17,  4.946876245249374e-19, -2.349740717978376e-21,  7.145840784410500e-24, -1.660811781381264e-26, -9.356448203229005e-30,  2.118487569399903e-01,
 -1.099047078426889e-03,  3.961696100802585e-06, -1.113397719624072e-08,  2.242172957803877e-11, -1.367625595917062e-14, -1.442417867007488e-16,  8.736948697101727e-19,
 -3.129807442482354e-21,  6.578268059321806e-24, -3.397046437183838e-27, -8.725398184266959e-29,  2.591445703563067e-01, -1.328910177786097e-03,  4.635453458599749e-06,
 -1.201894444293318e-08,  1.873487561362434e-11,  1.908378590095576e-14, -2.834556958101538e-16,  1.226434929540614e-18, -3.246919927805048e-21,  2.081327700447016e-24,
  2.409262436883103e-26, -1.927285153198002e-28,  3.113009000047371e-01, -1.575162184425014e-03,  5.283539387878155e-06, -1.232768086867498e-08,  1.159698858569209e-11,
  6.359020338446048e-14, -4.338314636780982e-16,  1.428673234062055e-18, -2.169308056410030e-21, -7.454420622136755e-24,  6.237266991260587e-26, -2.781263646665305e-28,
  3.683438276462384e-01, -1.835342372936449e-03,  5.874847517147819e-06, -1.187816117527721e-08,  5.644448415356789e-13,  1.177725917002338e-13, -5.668443915283300e-16,
  1.320144829935224e-18,  5.720498649933559e-22, -2.160647842571308e-23,  9.772387186410592e-26, -2.574095218707918e-28,  4.302946106529786e-01, -2.106451795484116e-03,
  6.373433184368542e-06, -1.048413573033703e-08, -1.455178071826150e-11,  1.769620459643092e-13, -6.412798832168329e-16,  7.266293383363523e-19,  5.145267690360869e-21,
 -3.716935741987339e-23,  1.037952890398885e-25, -2.638314161289578e-29,  4.971662036471213e-01, -2.384834623102768e-03,  6.738128658746384e-06, -7.965847054588735e-09,
 -3.354206711014158e-11,  2.331815818454701e-13, -6.045094964212253e-16, -4.943842066082798e-19,  1.107291279301919e-20, -4.702127188042796e-23,  4.472491214791156e-26,
  4.743009095843954e-28,  5.689584861615533e-01, -2.666031195639540e-03,  6.922312561494838e-06, -4.166790802854558e-09, -5.561166935065136e-11,  2.745488515510617e-13,
 -3.979274736812018e-16, -2.375778948137128e-18,  1.681866563960709e-20, -3.995107694388770e-23, -1.104881403920753e-25,  1.142130989599089e-27,  6.456516900158533e-01,
 -2.944597191550569e-03,  6.874002791707844e-06,  1.020789749543620e-09, -7.915015803291475e-11,  2.850670095175651e-13,  3.067823255585351e-17, -4.725553309777329e-18,
  1.944267829435394e-20, -2.977130025829441e-24, -3.563678258527726e-25,  1.566279580472915e-27,  7.271973083331313e-01, -3.213883538823222e-03,  6.536557919942263e-06,
  7.618116266982186e-09, -1.014675585767757e-10,  2.453084306109402e-13,  7.042703291717544e-16, -6.982821382576600e-18,  1.464813615103041e-20,  7.162894840801988e-23,
 -6.019465548423120e-25,  9.656141736450500e-28,  8.135054639352431e-01, -3.465773599420901e-03,  5.850457377184448e-06,  1.550544660347965e-08, -1.185358423559683e-10,
  1.348440973501319e-13,  1.579818613136780e-15, -8.088252117700565e-18, -2.176275067464996e-21,  1.726004912542574e-22, -6.247390651604649e-25, -1.521899946420370e-27,
  9.044272796754153e-01, -3.690379741172751e-03,  4.756920684505078e-06,  2.434655647362584e-08, -1.248308999066723e-10, -6.227307580179890e-14,  2.497409095676486e-15,
 -6.483310022532149e-18, -3.302763745872780e-20,  2.505536025675048e-22, -9.395214105497282e-26, -5.805080744577836e-27,  9.997301780278428e-01, -3.875714495468030e-03,
  3.204561183515005e-06,  3.348977531487786e-08, -1.134753280665402e-10, -3.472639899088778e-13,  3.125498424387049e-15, -4.717802066806016e-19, -7.171284384738112e-20,
  2.056396492071011e-22,  1.204945712008967e-24, -8.960930404729718e-27,  1.099063189611732e+00, -4.007379346214571e-03,  1.160874728852750e-06,  4.185086546305021e-08,
 -7.705926335954762e-11, -6.901604094432628e-13,  2.938225276113717e-15,  1.068892020741264e-17, -9.656219457286012e-20, -8.332199773764856e-23,  2.807920091600942e-24,
 -4.040839230140606e-27,  1.201908243018094e+00, -4.068370055179166e-03, -1.368927341954300e-06,  4.780306421471956e-08, -9.765702275450725e-12, -1.008142279779211e-12,
  1.309652625724107e-15,  2.464315422205582e-17, -6.780969640815088e-20, -6.285997533776982e-22,  2.868831324330164e-24,  1.522019968925916e-26,  1.307512121888096e+00,
 -4.039204006915615e-03, -4.312781066079246e-06,  4.914412499962974e-08,  8.836095807661408e-11, -1.147743174841389e-12, -2.126668570142689e-15,  3.321632147933912e-17,
  5.341343023433991e-20, -1.079048293165169e-21, -1.369756635755195e-24,  3.698855341642780e-26,  1.414792709503751e+00, -3.898766618982836e-03, -7.490331290634237e-06,
  4.329506341160118e-08,  2.044393748194129e-10, -8.983825152611582e-13, -6.711446165850788e-15,  2.220986129688888e-17,  2.412164529330901e-19, -5.836749740320474e-22,
 -9.234187369299728e-24,  1.425049839893519e-26,  1.522213502170003e+00, -3.626587016367356e-03, -1.056251483285388e-05,  2.801192230750102e-08,  3.044923993193158e-10,
 -9.234763974199426e-14, -9.802155235861003e-15, -1.873459095944492e-17,  3.151871801286942e-19,  1.415032453755272e-21, -9.388669946111112e-24, -7.934173802083837e-26,
  1.627625152650947e+00, -3.207674745552652e-03, -1.299120141179119e-05,  2.975949481297041e-09,  3.312141877003370e-10,  1.152213925484244e-12, -7.000409239354697e-15,
 -7.008945428456365e-17,  5.485850745025396e-21,  2.943424733074329e-21,  1.138785734125827e-23, -8.643597646407087e-26,  1.728088297428292e+00, -2.641346121293780e-03,
 -1.406212131546521e-05, -2.767508727179874e-08,  2.252913348202936e-10,  2.136184075496637e-12,  3.621725151183183e-15, -6.564455044953198e-17, -5.380457670720341e-19,
 -2.142715190604439e-22,  2.389848259351858e-23,  1.540007302550900e-25,  1.819728452483904e+00, -1.954802357108779e-03, -1.307342764422322e-05, -5.325914520870515e-08,
 -1.103507896046422e-11,  1.757767562432390e-12,  1.375594255894229e-14,  3.159379478597921e-17, -3.772450353550674e-19, -4.552699906850656e-21, -1.844183784527479e-23,
  8.070989319099132e-26,  1.897739708577641e+00, -1.218746464270270e-03, -9.795705889286460e-06, -5.920385904026827e-08, -2.409138933377082e-10, -1.247512229434541e-13,
  8.496755907224572e-15,  8.869749339297145e-17,  4.905530646762384e-19,  6.447518787581052e-22, -1.834472946327644e-23, -2.258980798738081e-25,  1.956729826698697e+00,
 -5.543234311490784e-04, -5.098509235229392e-06, -3.922204983211358e-08, -2.591773405679150e-10, -1.430169578273207e-12, -5.773458211719016e-15, -5.081214087142834e-18,
  2.025525615341382e-19,  2.652748376681918e-21,  2.203004028957250e-23,  1.341837555709668e-25,  1.991595618723948e+00, -1.124083595628311e-04, -1.118373759942508e-06,
 -9.784596912580588e-09, -7.917307392182343e-11, -6.047692495465960e-13, -4.398993149449503e-15, -3.054140052870837e-17, -2.018916025151175e-19, -1.260550857654940e-21,
 -7.307332448974813e-24, -3.787176699185823e-26,  5.705576814100504e-04, -3.067357591685692e-06,  1.236364616173912e-08, -4.429951978141788e-11,  1.486763909264731e-13,
 -4.794407099475833e-16,  1.498254357940781e-18, -4.614605084492501e-21,  1.375832534384959e-23, -4.217156269064602e-26,  1.147242643441352e-28, -4.110448515800944e-31,
  5.135899399885622e-03, -2.758650731904614e-05,  1.109443191567930e-07, -3.958780724517017e-10,  1.319904971697050e-12, -4.215720850916233e-15,  1.300003322943526e-17,
 -3.935383920474487e-20,  1.146184329198274e-22, -3.425196534968411e-25,  8.892685986794147e-28, -3.165159601707084e-30,  1.427126962015662e-02, -7.651892596159339e-05,
  3.063455445800523e-07, -1.083977150242417e-09,  3.565579630297734e-12, -1.116315062026382e-14,  3.346245530621458e-17, -9.753095612072990e-20,  2.692334596197081e-22,
 -7.571425004603301e-25,  1.734064123082854e-27, -6.116801228666273e-30,  2.798600267074296e-02, -1.496491900712736e-04,  5.950078072151152e-07, -2.078335083023753e-09,
  6.693099701458328e-12, -2.029195307183844e-14,  5.800497810833545e-17, -1.580464507559305e-19,  3.928926845578354e-22, -9.674145700701036e-25,  1.516775793566184e-27,
 -5.482204797477757e-30,  4.629399747801783e-02, -2.466448445917542e-04,  9.714927381056820e-07, -3.333205919898398e-09,  1.041619585251175e-11, -3.011063603682583e-14,
  7.982113790555377e-17, -1.930191626502335e-19,  3.818724417726975e-22, -6.237197544706481e-25, -8.186034338298486e-28,  1.436395759821915e-30,  6.921358154615749e-02,
 -3.670447461299210e-04,  1.428361679452580e-06, -4.786967113725613e-09,  1.435873001486914e-11, -3.873538806409495e-14,  9.082309022106662e-17, -1.723203123466853e-19,
  1.401568945596422e-22,  5.168593351332086e-25, -5.619135521999077e-27,  1.364143369618926e-29,  9.676730671670461e-02, -5.102427020138272e-04,  1.956009680150604e-06,
 -6.361656299778763e-09,  1.806090473849917e-11, -4.399217769413741e-14,  8.254386134285164e-17, -6.958786581300639e-20, -3.875546017410375e-22,  2.436930149589622e-24,
 -1.191936327671305e-26,  2.454020047803832e-29,  1.289816543076037e-01, -6.754656403370812e-04,  2.542451687322824e-06, -7.962503295530841e-09,  2.098901319772447e-11,
 -4.356021467768431e-14,  4.732735772416133e-17,  1.304203117692382e-19, -1.179786956770165e-21,  4.720360755151272e-24, -1.708544725869560e-26,  2.199738453012762e-29,
  1.658866177563909e-01, -8.617452714539295e-04,  3.173057368860114e-06, -9.477561258547015e-09,  2.255034622834237e-11, -3.516799281091366e-14, -2.016807868694695e-17,
  4.234829491800433e-19, -2.104541299151939e-21,  6.473901324723835e-24, -1.698166150348442e-26, -8.381952262926671e-30,  2.075151181626757e-01, -1.067881863784891e-03,
  3.830231247123441e-06, -1.077759769848132e-08,  2.211551040473158e-11, -1.685559704703642e-14, -1.211451117785127e-16,  7.772966181026481e-19, -2.896325119150823e-21,
  6.369441544903729e-24, -6.961050917732417e-27, -7.584550116350602e-29,  2.539021906902030e-01, -1.292398336901363e-03,  4.493036102720887e-06, -1.171649118822074e-08,
  1.905124315733711e-11,  1.268126595485820e-14, -2.505576418843177e-16,  1.123902127495951e-18, -3.156631441835396e-21,  2.881674168732188e-24,  1.606705045623562e-26,
 -1.732179159770335e-28,  3.050838555696272e-01, -1.533482350574160e-03,  5.136760702204732e-06, -1.213250687815957e-08,  1.276787180152990e-11,  5.365020690855248e-14,
 -3.948375108217605e-16,  1.355419470605209e-18, -2.395668752413053e-21, -5.199980133874321e-24,  5.044991386228092e-26, -2.643814945442584e-28,  3.610955534213076e-01,
 -1.788913416732134e-03,  5.732439139718726e-06, -1.185101301217704e-08,  2.786855847075911e-12,  1.046132711978214e-13, -5.297357436665389e-16,  1.326736991613071e-18,
 -1.382086077560958e-22, -1.793020999719090e-23,  8.594639141351232e-26, -2.771582889444234e-28,  4.219699763676243e-01, -2.055971263023544e-03,  6.246340690512537e-06,
 -1.068947928675433e-08, -1.116470796345729e-11,  1.618328736732170e-13, -6.188246506422466e-16,  8.706657609115389e-19,  3.881378086128430e-21, -3.306752290548935e-23,
  1.006603530221389e-25, -1.138186224717619e-28,  4.877340573895397e-01, -2.331320728639582e-03,  6.639469790875379e-06, -8.466003361719528e-09, -2.902443867444752e-11,
  2.185457296728823e-13, -6.136433855466466e-16, -1.667522477316243e-19,  9.416908887258939e-21, -4.486625566273081e-23,  6.178031858798020e-26,  3.032365973651954e-28,
  5.584047808948145e-01, -2.610867413645074e-03,  6.867151813796760e-06, -5.013190134202676e-09, -5.022127461549300e-11,  2.642597896905029e-13, -4.571362668450121e-16,
 -1.861351736604839e-18,  1.531243836819864e-20, -4.342591143433731e-23, -6.476971518675944e-26,  9.340562097981601e-28,  6.339833330520142e-01, -2.889577266808371e-03,
  6.878842007461463e-06, -2.000057776572070e-10, -7.345181004465038e-11,  2.842856118374027e-13, -9.296189169566155e-17, -4.107719937139296e-18,  1.909534483383183e-20,
 -1.587443901891306e-23, -2.891494188768571e-25,  1.477015267767544e-27,  7.144468996165677e-01, -3.161252626549473e-03,  6.618399128644951e-06,  6.034737552550170e-09,
 -9.640791886735165e-11,  2.599198768781291e-13,  5.156687306848019e-16, -6.477380796189766e-18,  1.680449794269776e-20,  4.849557002794917e-23, -5.526440598038076e-25,
  1.251074141930476e-27,  7.997371100383938e-01, -3.418257702750936e-03,  6.025238755242673e-06,  1.363243119490292e-08, -1.154781650418389e-10,  1.700397879399894e-13,
  1.353271629278243e-15, -8.063413369787042e-18,  3.573759396563099e-21,  1.465297173354406e-22, -6.726612573456470e-25, -6.797115418271417e-28,  8.897436737463763e-01,
 -3.651189768802561e-03,  5.037064871039530e-06,  2.234249124107960e-08, -1.254922693735384e-10, -4.624781161041382e-15,  2.302428054433120e-15, -7.397082170032124e-18,
 -2.413411742994991e-20,  2.419953752543349e-22, -3.261404487751310e-25, -4.733365509724046e-27,  9.842810940106939e-01, -3.848501863477004e-03,  3.595328840365890e-06,
  3.162267441139059e-08, -1.196728682332954e-10, -2.726627057263123e-13,  3.081335977622758e-15, -2.639616077791651e-18, -6.353787716680049e-20,  2.458944194815000e-22,
  8.074317470746448e-25, -9.012312440998911e-27,  1.083055395946415e+00, -3.996105490632748e-03,  1.655244593175699e-06,  4.051141847815484e-08, -9.013486853530286e-11,
 -6.164027008697014e-13,  3.193956476115469e-15,  7.572205596349571e-18, -9.759204237884934e-20,  2.444901949487178e-23,  2.557500335161379e-24, -7.214228780444069e-27,
  1.185616487237814e+00, -4.077031103238490e-03, -7.968872908981400e-07,  4.748744793220760e-08, -2.955969354238366e-11, -9.686958041175323e-13,  1.966045218814941e-15,
  2.213452848796333e-17, -8.822749335871747e-20, -5.021268011467199e-22,  3.412291176463146e-24,  9.390843670543791e-27,  1.291290067926640e+00, -4.071325064267990e-03,
 -3.715334536273341e-06,  5.037180747655055e-08,  6.497187349411115e-11, -1.187465585937399e-12, -1.178579036700381e-15,  3.429664293100150e-17,  1.397564089115034e-20,
 -1.101122151787816e-21,  2.641725362454779e-25,  3.673080466974198e-26,  1.399081164786080e+00, -3.956556920042475e-03, -6.951785016414318e-06,  4.641382733753646e-08,
  1.849157656956405e-10, -1.051144399247373e-12, -5.985163581760461e-15,  2.952283262740256e-17,  2.137526476208859e-19, -9.354706982308095e-22, -8.233904424012156e-24,
  3.092692569507369e-26,  1.507540399407733e+00, -3.709659965039262e-03, -1.019724328527679e-05,  3.285608579138215e-08,  3.002565192025465e-10, -3.327101581539642e-13,
 -1.017841706095188e-14, -7.912642050063406e-18,  3.585598234978305e-19,  9.733858390794895e-22, -1.258460627200668e-23, -6.438202902892006e-26,  1.614586950034852e+00,
 -3.311369732261935e-03, -1.292296438404610e-05,  8.449936567422621e-09,  3.524199339261024e-10,  9.607747394264651e-13, -8.943946381405312e-15, -6.813875045005798e-17,
  1.186208444313411e-19,  3.310733926261196e-21,  6.683979311695741e-24, -1.266456561624577e-25,  1.717295906522921e+00, -2.755106942325326e-03, -1.437117100679915e-05,
 -2.372457369617434e-08,  2.687252883467904e-10,  2.199103128494754e-12,  1.542864370565577e-15, -8.278797228299096e-17, -5.269653758311986e-19,  8.718042337768588e-22,
  3.022598322814258e-23,  1.292987849488293e-25,  1.811696019951719e+00, -2.061946429040338e-03, -1.371237776420772e-05, -5.313625166999818e-08,  2.748564272646922e-11,
  2.097005248360542e-12,  1.444595613568457e-14,  1.676563047348307e-17, -5.533410048343637e-19, -5.194483067006365e-21, -1.299189681031712e-23,  1.706304824243240e-25,
  1.892703399268052e+00, -1.300019538512220e-03, -1.052932399252494e-05, -6.306648522508989e-08, -2.411592920529084e-10,  1.107629967333520e-13,  1.120241470440379e-14,
  1.046043056996006e-16,  4.979776602314642e-19, -3.079563037554549e-22, -2.979369189581365e-23, -2.947954831928135e-25,  1.954427873498552e+00, -5.970668826125083e-04,
 -5.595023254778489e-06, -4.360527700704512e-08, -2.891737034556091e-10, -1.569612818013731e-12, -5.809350498392564e-15,  3.110490052045483e-18,  3.153993975913604e-19,
  3.658932268886368e-21,  2.844142775850138e-23,  1.563446393107643e-25,  1.991127316012982e+00, -1.218475033865933e-04, -1.243808094315622e-06, -1.115416990816943e-08,
 -9.239744366222302e-11, -7.213810667977142e-13, -5.351843643741946e-15, -3.778781695993596e-17, -2.529550201038040e-19, -1.588454082108629e-21, -9.145208925906422e-24,
 -4.573710447971778e-26,  5.584827587650547e-04, -2.970535075634154e-06,  1.184601463772985e-08, -4.199549737014306e-11,  1.394369431244323e-13, -4.449847345591364e-16,
  1.374987024410992e-18, -4.197778788186321e-21,  1.231845263086987e-23, -3.793791293777317e-26,  9.708053799674607e-29, -3.943528677842571e-31,  5.027298891514148e-03,
 -2.671760219870682e-05,  1.063177646949987e-07, -3.754175235328535e-10,  1.238623402659326e-12, -3.916539637962119e-15,  1.194766845145499e-17, -3.587674583020984e-20,
  1.028947408008421e-22, -3.097029897263764e-25,  7.520421762209267e-28, -3.100552877190664e-30,  1.397001440992331e-02, -7.411923935953985e-05,  2.936728855921479e-07,
 -1.028671256512574e-09,  3.350131333218151e-12, -1.039187326602067e-14,  3.084819985438650e-17, -8.933874091176727e-20,  2.431596650153230e-22, -6.932040358620874e-25,
  1.461146985331618e-27, -6.354783095874963e-30,  2.739677061200226e-02, -1.449870975341371e-04,  5.706971720637048e-07, -1.974418041250749e-09,  6.300830592725246e-12,
 -1.895154827825742e-14,  5.375053840726637e-17, -1.460198996296551e-19,  3.590963614241801e-22, -9.119432238166686e-25,  1.246431743904344e-27, -6.910744389380810e-30,
  4.532271260012893e-02, -2.390301084667369e-04,  9.324746810518501e-07, -3.171262214227514e-09,  9.832709484985811e-12, -2.825842328641363e-14,  7.458425999336695e-17,
 -1.811647645319542e-19,  3.588349594720804e-22, -6.562438814614878e-25, -8.348771480203510e-28, -2.318948250359151e-30,  6.776789797609438e-02, -3.558437796576386e-04,
  1.372271325989915e-06, -4.563308293434468e-09,  1.360543165942104e-11, -3.661301104751431e-14,  8.606340597993970e-17, -1.675798986464861e-19,  1.548455490171333e-22,
  3.021986156119256e-25, -5.162974899719095e-27,  6.887791941838131e-30,  9.475715542575681e-02, -4.948951376811093e-04,  1.881374963367534e-06, -6.079613621881652e-09,
  1.720070697560519e-11, -4.203583012047926e-14,  8.043432076976809e-17, -8.067599507120437e-20, -3.081695458303568e-22,  1.979230384678748e-24, -1.103147305876192e-26,
  1.547852194250308e-29,  1.263198737960007e-01, -6.555025837898039e-04,  2.448888046424533e-06, -7.633585837027128e-09,  2.012944186470995e-11, -4.238465063037910e-14,
  5.047519842054947e-17,  9.525591678296517e-20, -1.021942844394829e-21,  4.053989216137009e-24, -1.629653342686689e-26,  1.326677809448103e-29,  1.624896938824861e-01,
 -8.368096553560289e-04,  3.061468181622227e-06, -9.122404999561534e-09,  2.184306805960071e-11, -3.551713580758948e-14, -9.219292898404254e-18,  3.597347339142809e-19,
 -1.883803236193544e-21,  5.786442726959766e-24, -1.742177039260892e-26, -1.260028929247922e-29,  2.033040637673934e-01, -1.037751349689467e-03,  3.703011547100849e-06,
 -1.042659718662517e-08,  2.175103331074360e-11, -1.951217138524692e-14, -1.006443090615363e-16,  6.882228626829193e-19, -2.672824317371638e-21,  6.026022973238466e-24,
 -1.018085068640736e-26, -7.189952135199741e-29,  2.488036028053913e-01, -1.257011240513402e-03,  4.354274467828743e-06, -1.140995852685691e-08,  1.924722508301978e-11,
  7.034199211466780e-15, -2.204861583354888e-16,  1.024659148262811e-18, -3.043121996380568e-21,  3.375935268604420e-24,  8.728366897139139e-27, -1.619667645429023e-28,
  2.990311972742846e-01, -1.492967074158871e-03,  4.992430111580101e-06, -1.192013901868603e-08,  1.374914357310454e-11,  4.462070524532081e-14, -3.579845216307080e-16,
  1.276129788732963e-18, -2.549319704884891e-21, -3.411676494950299e-24,  3.902515784363019e-26, -2.562456324533966e-28,  3.540307193778462e-01, -1.743621839627283e-03,
  5.590561363362360e-06, -1.179036335650715e-08,  4.754988702723799e-12,  9.234432391165189e-14, -4.927414728625639e-16,  1.312625854352244e-18, -7.248015046499423e-22,
 -1.474150933050541e-23,  7.335628727972346e-26, -2.954545860779802e-28,  4.138452163966650e-01, -2.006516428520359e-03,  6.117099346113710e-06, -1.084301977429748e-08,
 -8.074525768360163e-12,  1.472865883731357e-13, -5.928806366684283e-16,  9.765888698582211e-19,  2.762003652912807e-21, -2.916445811959186e-23,  9.393181247678812e-26,
 -1.910019117570587e-28,  4.785143518614055e-01, -2.278618906135997e-03,  6.535233049669759e-06, -8.896228248533597e-09, -2.480100697353776e-11,  2.037948364210350e-13,
 -6.143329520166092e-16,  1.092460533867514e-19,  7.848986528258560e-21, -4.217577450092202e-23,  7.158333660706425e-26,  1.437908918809968e-28,  5.480707859064309e-01,
 -2.556184094729809e-03,  6.802344724280716e-06, -5.775061809954233e-09, -4.504973310134126e-11,  2.527170144040160e-13, -5.026322820403917e-16, -1.396790456645362e-18,
  1.371179889305570e-20, -4.525825089973551e-23, -2.843551551878348e-26,  7.159700109877811e-28,  6.225350426194514e-01, -2.834575678780910e-03,  6.869577696322252e-06,
 -1.329908133532840e-09, -6.779737063833349e-11,  2.807427765538710e-13, -1.995244381086087e-16, -3.507920092947662e-18,  1.833096962378114e-20, -2.618218256579633e-23,
 -2.273783696064249e-25,  1.320532282136192e-27,  7.019082056418560e-01, -3.108041589926404e-03,  6.681734378551940e-06,  4.534409910749202e-09, -9.110013119291702e-11,
  2.701817548827314e-13,  3.420631640801215e-16, -5.915858852627982e-18,  1.816619144546837e-20,  2.754260208360189e-23, -4.939746889457370e-25,  1.392545127101089e-27,
  7.861614751233679e-01, -3.369432576527089e-03,  6.177859759163596e-06,  1.181367511589670e-08, -1.117707851236880e-10,  1.998266101631439e-13,  1.129852820229382e-15,
 -7.869890362693862e-18,  8.359274053516681e-21,  1.192389263675600e-22, -6.868955460857894e-25,  3.970717449156700e-30,  8.752211575642755e-01, -3.609854932031076e-03,
  5.293133985203717e-06,  2.033680544413752e-08, -1.250493760646229e-10,  4.806875355958049e-14,  2.085787134186176e-15, -8.032890151524238e-18, -1.570431285531002e-20,
  2.251122366738525e-22, -5.099117644911208e-25, -3.622246543285222e-27,  9.689469686734018e-01, -3.818254283885901e-03,  3.963145317750074e-06,  2.966827139297870e-08,
 -1.243937402987984e-10, -1.998189230481766e-13,  2.980332514114813e-15, -4.525729667553009e-18, -5.419900872705313e-20,  2.703647065073702e-22,  4.194806972281010e-25,
 -8.548134712509616e-27,  1.067100500952610e+00, -3.980944412025375e-03,  2.132335514744742e-06,  3.897486682436306e-08, -1.016810170663549e-10, -5.375548742630098e-13,
  3.362526255637049e-15,  4.482419622997990e-18, -9.495394427208006e-20,  1.196475238724907e-22,  2.185345563031665e-24, -9.558618821285848e-27,  1.169299208404288e+00,
 -4.081136299040720e-03, -2.305061194490965e-07,  4.686227000630545e-08, -4.841327384647126e-11, -9.144082908036388e-13,  2.543760555748067e-15,  1.904906747643660e-17,
 -1.037639574956667e-19, -3.591656515701118e-22,  3.691292172667729e-24,  3.293122506949404e-27,  1.274949173133276e+00, -4.098614034759261e-03, -3.105423359011999e-06,
  5.122015303713563e-08,  4.101759385502315e-11, -1.204213752181302e-12, -2.179385789866023e-16,  3.411477421960050e-17, -2.509193253389143e-20, -1.059030932885152e-21,
  1.815098545294246e-24,  3.326616012720082e-26,  1.383147304835579e+00, -4.009894686368718e-03, -6.377785410981963e-06,  4.919678637446788e-08,  1.625272507477036e-10,
 -1.184129043138248e-12, -5.068262313693839e-15,  3.576344823792627e-17,  1.745154397096945e-19, -1.233243959622530e-21, -6.552951956051774e-24,  4.487759400175884e-26,
  1.492541215240318e+00, -3.789579741659166e-03, -9.774408361110958e-06,  3.759363219510419e-08,  2.911483751654169e-10, -5.783254882193353e-13, -1.023479121553724e-14,
  4.019619268925999e-18,  3.839151935165454e-19,  4.197318494351775e-22, -1.492570377609903e-23, -4.075047964361473e-26,  1.601135483026153e+00, -3.414250610736766e-03,
 -1.278713825021947e-05,  1.423007702482806e-08,  3.693370328281917e-10,  7.237660305069722e-13, -1.078046993358481e-14, -6.239583250984688e-17,  2.411813772057307e-19,
  3.456310238335289e-21,  3.580574492045749e-25, -1.590474929648063e-25,  1.706043844558954e+00, -2.871138644981383e-03, -1.462861257337598e-05, -1.907192265529438e-08,
  3.128801816071501e-10,  2.206447212038045e-12, -1.004836734242457e-15, -9.890499373013705e-17, -4.725648641829491e-19,  2.181227842801077e-21,  3.486091563936456e-23,
  7.651756699422328e-26,  1.803224812748039e+00, -2.174185204666806e-03, -1.434592877480788e-05, -5.234200165413840e-08,  7.291971575637893e-11,  2.447164588332851e-12,
  1.463876339406885e-14, -4.017091661476254e-18, -7.476082704771770e-19, -5.533146888943773e-21, -3.150553022380827e-24,  2.790098748588250e-25,  1.887329966619783e+00,
 -1.387346648729172e-03, -1.130914988618999e-05, -6.689167585730939e-08, -2.360089793242464e-10,  4.165495660895861e-13,  1.435096992589672e-14,  1.201056367408103e-16,
  4.621330721966491e-19, -1.778831201023486e-21, -4.421817322128477e-23, -3.587694348477566e-25,  1.951946657345055e+00, -6.440012119867034e-04, -6.147107603684711e-06,
 -4.849071793732476e-08, -3.219467090007039e-10, -1.706721721527449e-12, -5.559510877224494e-15,  1.554413520050245e-17,  4.693006041740217e-19,  4.938806060115335e-21,
  3.564101569170875e-23,  1.683166102581740e-25,  1.990619140367373e+00, -1.323596440966977e-04, -1.387028029576633e-06, -1.275530568007605e-08, -1.082001711991038e-10,
 -8.634921686440993e-13, -6.532349921679762e-15, -4.687200459505446e-17, -3.172301866553354e-19, -1.996839343505045e-21, -1.133044238470711e-23, -5.344991150459797e-26,
  5.467870157053941e-04, -2.877745480480663e-06,  1.135516662655026e-08, -3.983395003197172e-11,  1.308579497037757e-13, -4.133521921327578e-16,  1.262767712032973e-18,
 -3.824724997280169e-21,  1.101840515546972e-23, -3.440199419932006e-26,  7.965702766691884e-29, -4.025709700388624e-31,  4.922101503130764e-03, -2.588474907029943e-05,
  1.019291268926545e-07, -3.562109506553657e-10,  1.163080561783986e-12, -3.641488215359535e-15,  1.098758014120971e-17, -3.275696526097980e-20,  9.225383328111422e-23,
 -2.823742498710186e-25,  6.133478195406030e-28, -3.246181216725160e-30,  1.367815930558839e-02, -7.181833679785333e-05,  2.816437125019913e-07, -9.766924638283090e-10,
  3.149499263340934e-12, -9.680677690278076e-15,  2.845197622579776e-17, -8.194619371128661e-20,  2.191874360179313e-22, -6.405261863346998e-25,  1.167276168670550e-27,
 -7.111125761160875e-30,  2.682580570295296e-02, -1.405146067554730e-04,  5.475967505831346e-07, -1.876568275922886e-09,  5.934375166515698e-12, -1.770932955651680e-14,
  4.981798594326128e-17, -1.350451018927318e-19,  3.270852641134720e-22, -8.687632820451974e-25,  8.958599521944266e-28, -9.215389230538649e-30,  4.438127446514673e-02,
 -2.317198994370194e-04,  8.953451344193475e-07, -3.018364653944599e-09,  9.285036972385624e-12, -2.652799692635502e-14,  6.966880556308367e-17, -1.700667661870145e-19,
  3.345723248013211e-22, -6.930366574411013e-25, -1.041300118009727e-27, -7.354307286490107e-30,  6.636613753927151e-02, -3.450810021009196e-04,  1.318793942517956e-06,
 -4.351368827142093e-09,  1.289344951595674e-11, -3.460322758896117e-14,  8.144189371347720e-17, -1.624901777010589e-19,  1.620592692591975e-22,  9.938811356726959e-26,
 -5.040100767846552e-27, -1.728319309660781e-30,  9.280722134549632e-02, -4.801313440526358e-04,  1.810043461736278e-06, -5.811023944007216e-09,  1.637910614633870e-11,
 -4.013356507555289e-14,  7.804744416524260e-17, -8.948140396487569e-20, -2.447248579855088e-22,  1.548349597005015e-24, -1.059933803105036e-26,  3.526523199796039e-30,
  1.237364731623714e-01, -6.362724803232028e-04,  2.359189684458474e-06, -7.318229649598035e-09,  1.929406039801871e-11, -4.114480484706599e-14,  5.270558254908080e-17,
  6.476397298622762e-20, -8.876233945858273e-22,  3.410284530725128e-24, -1.598579114226857e-26, -1.129781925091473e-31,  1.591907537656715e-01, -8.127498980761569e-04,
  2.954072784976969e-06, -8.778607369755528e-09,  2.113129418619933e-11, -3.562415215695001e-14,  3.968611912557103e-20,  3.026502883490247e-19, -1.688192451828542e-21,
  5.075747793939578e-24, -1.819568603447672e-26, -2.401807680845231e-29,  1.992115224442621e-01, -1.008621848175886e-03,  3.579967194393515e-06, -1.008182746071725e-08,
  2.133814702845580e-11, -2.170585936780338e-14, -8.253947773834185e-17,  6.060786489462456e-19, -2.463987234611024e-21,  5.554577703899337e-24, -1.343539099515268e-26,
 -7.801603886591920e-29,  2.438443664807109e-01, -1.222719478663184e-03,  4.219206436532415e-06, -1.110115540936441e-08,  1.933725993053254e-11,  2.075927318564256e-15,
 -1.931403502444980e-16,  9.292772948006483e-19, -2.917012132819721e-21,  3.583364176579513e-24,  1.638310090334869e-27, -1.627247697075111e-28,  2.931383072942123e-01,
 -1.453595995321811e-03,  4.850736331470207e-06, -1.169346823893821e-08,  1.455848756938607e-11,  3.644853473499000e-14, -3.234114263963718e-16,  1.192865680582094e-18,
 -2.646756110732789e-21, -2.076021879625527e-24,  2.773578445357458e-26, -2.593776835553502e-28,  3.471447869393264e-01, -1.699461856553875e-03,  5.449592381930736e-06,
 -1.170013853735901e-08,  6.486578708653973e-12,  8.095647921667759e-14, -4.563885526407428e-16,  1.281481603564985e-18, -1.205870254944242e-21, -1.207375923864161e-23,
  5.985149984813142e-26, -3.203177604609233e-28,  4.059161973908929e-01, -1.958102076072050e-03,  5.986302684977869e-06, -1.094940998416372e-08, -5.268822857517052e-12,
  1.333946297265722e-13, -5.644515404165976e-16,  1.048881652648878e-18,  1.777487443190891e-21, -2.559741343453484e-23,  8.386508662240575e-26, -2.674804363924967e-28,
  4.695037547305801e-01, -2.226770501997768e-03,  6.426229327699652e-06, -9.261236743576980e-09, -2.087216158225983e-11,  1.891145512603494e-13, -6.079819736779994e-16,
  3.366826379482742e-19,  6.383307117330569e-21, -3.923162480997377e-23,  7.449110982617585e-26, -1.201383896209479e-29,  5.379544313403096e-01, -2.502054413620745e-03,
  6.728883844066138e-06, -6.456090674522653e-09, -4.011894264796272e-11,  2.402325880402507e-13, -5.358456942248645e-16, -9.842435101411165e-19,  1.206901654087153e-20,
 -4.583213011302515e-23, -1.929489899945740e-27,  4.863590426305437e-28,  6.113065266005432e-01, -2.779700908807901e-03,  6.847294610177093e-06, -2.370039613972453e-09,
 -6.223801828146365e-11,  2.748408827424483e-13, -2.896874979079836e-16, -2.938055186721225e-18,  1.723816817985569e-20, -3.417466029634754e-23, -1.738218701841983e-25,
  1.104042884849470e-27,  6.895832572096696e-01, -3.054394429158501e-03,  6.727581298704039e-06,  3.120427816071413e-09, -8.562747521310321e-11,  2.764700140152643e-13,
  1.846801407073465e-16, -5.322368982935238e-18,  1.881694643265025e-20,  9.019913839355986e-24, -4.321375022905530e-25,  1.395572677957521e-27,  7.727834459047931e-01,
 -3.319472730762793e-03,  6.309030319948146e-06,  1.005871381102179e-08, -1.075207647954093e-10,  2.243327987899314e-13,  9.138484100906860e-16, -7.539004581771401e-18,
  1.215883967830451e-20,  9.192713015896722e-23, -6.750775271588404e-25,  5.001304268530783e-28,  8.608679256762897e-01, -3.566567616566611e-03,  5.525211234968794e-06,
  1.834634889377928e-08, -1.236058929187492e-10,  9.537914692130613e-14,  1.855019207856307e-15, -8.409992728434582e-18, -8.002929010314034e-21,  2.018441961613434e-22,
 -6.458597174405202e-25, -2.576124491400978e-27,  9.537395685154635e-01, -3.785159158117606e-03,  4.307103357874565e-06,  2.764984037936075e-08, -1.276860776550781e-10,
 -1.299984802826027e-13,  2.830813031518937e-15, -6.101852223626378e-18, -4.425250127852829e-20,  2.798452325203685e-22,  6.062019964750482e-26, -7.716879904956366e-27,
  1.051213762675966e+00, -3.962043379945612e-03,  2.589932057941645e-06,  3.726638305769404e-08, -1.116166976035189e-10, -4.556869424196317e-13,  3.446257533495072e-15,
  1.528827660327206e-18, -8.917917815080750e-20,  1.981530059337341e-22,  1.729174988222034e-24, -1.103627125800790e-26,  1.152974516247775e+00, -4.080745494923941e-03,
  3.266011606503946e-07,  4.594484381569311e-08, -6.604971995594653e-11, -8.473436846583772e-13,  3.028908678740828e-15,  1.555041613254492e-17, -1.140172830048905e-19,
 -2.103685708057670e-22,  3.706012649966652e-24, -2.542234038638410e-27,  1.258508936289267e+00, -4.120989528147105e-03, -2.487638652714988e-06,  5.168379884115159e-08,
  1.695776950168781e-11, -1.198107103826087e-12,  7.204184605221066e-16,  3.271861099310830e-17, -6.157210844770615e-20, -9.588015770862431e-22,  3.151113259864197e-24,
  2.706426705832426e-26,  1.367009480464788e+00, -4.058513157578303e-03, -5.772623335496628e-06,  5.160150400443907e-08,  1.377124794268829e-10, -1.293162504198730e-12,
 -3.995714490385611e-15,  4.059106413040967e-17,  1.259059445748194e-19, -1.452696058769440e-21, -4.350094337879896e-24,  5.440947398912769e-26,  1.477229473389090e+00,
 -3.865892287316619e-03, -9.295759292344216e-06,  4.214619133238547e-08,  2.771418506041265e-10, -8.212118833171741e-13, -9.948815660246483e-15,  1.642843683815603e-17,
  3.879233451918177e-19, -2.046875548261968e-22, -1.607654985037630e-23, -1.077857842722854e-26,  1.587275111014341e+00, -3.515763207456413e-03, -1.258049040395424e-05,
  2.024063753475685e-08,  3.810885212276116e-10,  4.450565869894611e-13, -1.240086007783574e-14, -5.269853254294345e-17,  3.641180763424522e-19,  3.324125640294812e-21,
 -7.098790119940820e-24, -1.770142561383709e-25,  1.694323907262875e+00, -2.988994553955648e-03, -1.482598978157908e-05, -1.371508979666769e-08,  3.565351606070809e-10,
  2.147472575990524e-12, -3.972130165355471e-15, -1.124962508855472e-16, -3.683265932342838e-19,  3.620939676527868e-21,  3.652788164936581e-23, -5.348293119290436e-27,
  1.794294592137887e+00, -2.291441373467809e-03, -1.496535576590610e-05, -5.076474016025144e-08,  1.253524464910000e-10,  2.794257523288111e-12,  1.416138656583303e-14,
 -3.112593078537096e-17, -9.458027239868718e-19, -5.379734512984471e-21,  1.165937602414068e-23,  3.937574828553186e-25,  1.881594460226856e+00, -1.481094082169700e-03,
 -1.213416812262796e-05, -7.058128534472609e-08, -2.239530173470960e-10,  8.029272542561925e-13,  1.790871923280255e-14,  1.334961429171038e-16,  3.623187196388598e-19,
 -3.877645330403174e-21, -6.101753179224614e-23, -3.988091373108051e-25,  1.949268486374800e+00, -6.955958372329185e-04, -6.761052540084652e-06, -5.392200964462348e-08,
 -3.573706675297088e-10, -1.833055682024022e-12, -4.885254105814957e-15,  3.369611326096351e-17,  6.745372838882466e-19,  6.511407869000382e-21,  4.290437464674855e-23,
  1.563316798073398e-25,  1.990066496587459e+00, -1.440989236049170e-04, -1.551077682485563e-06, -1.463365309202761e-08, -1.271503062859837e-10, -1.037234330935106e-12,
 -7.998342925196133e-15, -5.826573930431640e-17, -3.978588421060052e-19, -2.498998939000839e-21, -1.381894464686534e-23, -5.907549310863378e-26,  5.354547385036480e-04,
 -2.788781201482551e-06,  1.088945401302743e-08, -3.780474824737092e-11,  1.228854967689018e-13, -3.842921553195496e-16,  1.160429655040433e-18, -3.491371827996604e-21,
  9.832929922382606e-24, -3.158022575165866e-26,  6.109564998324390e-29, -4.490557549555655e-31,  4.820166740288393e-03, -2.508610326637642e-05,  9.776389341015204e-08,
 -3.381702779401041e-10,  1.092815208688230e-12, -3.388468273070966e-15,  1.011021873302772e-17, -2.996304059220230e-20,  8.249458959576556e-23, -2.608077361019324e-25,
  4.615166517316712e-28, -3.724927198643747e-30,  1.339531921947638e-02, -6.961122614970260e-05,  2.702194837013571e-07, -9.278130488064300e-10,  2.962532336746277e-12,
 -9.024592600019842e-15,  2.625227283905884e-17, -7.529276194649792e-20,  1.968900248688936e-22, -6.004919425957406e-25,  8.226483612749938e-28, -8.739529194959884e-30,
  2.627236844858597e-02, -1.362223203804275e-04,  5.256361500993387e-07, -1.784388068052347e-09,  5.591844600493179e-12, -1.655791897974757e-14,  4.617859997893478e-17,
 -1.250727152614899e-19,  2.963482447627448e-22, -8.420362946612847e-25,  4.122329890183098e-28, -1.311490332091466e-29,  4.346849450686156e-02, -2.246995340752694e-04,
  8.599989035523944e-07, -2.873959291340061e-09,  8.770817989326053e-12, -2.491190157107942e-14,  6.505301226169580e-17, -1.597684269296411e-19,  3.087776597667749e-22,
 -7.431387982596666e-25, -1.518424714419442e-27, -1.488674903353720e-29,  6.500658841251684e-02, -3.347360611607776e-04,  1.267792789424883e-06, -4.150505487406551e-09,
  1.222056552845041e-11, -3.270263092541912e-14,  7.696502998735581e-17, -1.572862812399417e-19,  1.619608690290097e-22, -1.070040641329465e-25, -5.368748433196953e-27,
 -1.403127888347248e-29,  9.091522123683060e-02, -4.659255307372788e-04,  1.741857407753160e-06, -5.555278709363576e-09,  1.559495892209952e-11, -3.829132851093049e-14,
  7.544012486019916e-17, -9.650253945038819e-20, -1.966193938622681e-22,  1.122885596493841e-24, -1.079967247416994e-26, -1.381726150158321e-29,  1.212285814176074e-01,
 -6.177450519770377e-04,  2.273196227067403e-06, -7.016038563708404e-09,  1.848394440296962e-11, -3.986121079566868e-14,  5.413889351098181e-17,  3.820061019891842e-20,
 -7.764132537547454e-22,  2.765225649612182e-24, -1.642129385326338e-26, -2.136892478474678e-29,  1.559863602068100e-01, -7.895329953725801e-04,  2.850734596621762e-06,
 -8.446203701854536e-09,  2.041947622764273e-11, -3.552744993654424e-14,  7.784038906522915e-18,  2.514089023339682e-19, -1.518870932063135e-21,  4.321128359961411e-24,
 -1.969952250346700e-26, -4.668584909007651e-29,  1.952335564572851e-01, -9.804602680270388e-04,  3.461019067850229e-06, -9.743992065339703e-09,  2.088554967583221e-11,
 -2.349189329716526e-14, -6.664386014470067e-17,  5.303197883381652e-19, -2.274565741228537e-21,  4.943588630239744e-24, -1.726824142917722e-26, -9.933395170817209e-29,
  2.390201596088910e-01, -1.189493421333592e-03,  4.087849526579432e-06, -1.079167029864275e-08,  1.933447838695948e-11, -2.257632533367795e-15, -1.684080062095325e-16,
  8.379953541707961e-19, -2.788591169112948e-21,  3.501635933127318e-24, -5.865600058869385e-27, -1.822568935364271e-28,  2.874006520507609e-01, -1.415347378519391e-03,
  4.711835047965202e-06, -1.145511121769018e-08,  1.521249521157906e-11,  2.907783074116052e-14, -2.912067734960952e-16,  1.107165226069473e-18, -2.704316249025149e-21,
 -1.199873493970452e-24,  1.590177300330794e-26, -2.829431142153345e-28,  3.404332464289788e-01, -1.656424840551257e-03,  5.309864967663638e-06, -1.158398325574946e-08,
  7.999057258974903e-12,  7.042898554940660e-14, -4.211095092584260e-16,  1.236373134114988e-18, -1.600925658168366e-21, -9.972514522274875e-24,  4.489510990804941e-26,
 -3.639640719660478e-28,  3.981787360125375e-01, -1.910738461363474e-03,  5.854489641924426e-06, -1.101309396362882e-08, -2.733990082253871e-12,  1.202058154646389e-13,
 -5.344205975498870e-16,  1.091640090264437e-18,  9.133020398059809e-22, -2.250319612366472e-23,  7.018751231137779e-26, -3.582425643737974e-28,  4.606987808954481e-01,
 -2.175810601646976e-03,  6.313213016474204e-06, -9.565722205205382e-09, -1.723490880640414e-11,  1.746579067786348e-13, -5.959033796692046e-16,  5.189222545051367e-19,
  5.024042432968224e-21, -3.631030539635919e-23,  7.035659906781391e-26, -1.797131801336416e-28,  5.280533702344210e-01, -2.448543787002543e-03,  6.647715603818912e-06,
 -7.060263889947185e-09, -3.544490704058074e-11,  2.270837029885983e-13, -5.582455212964909e-16, -6.244115982590655e-19,  1.042217561903714e-20, -4.555337324264798e-23,
  1.402870250897039e-26,  2.334892915024595e-28,  6.002970762041904e-01, -2.725052827399379e-03,  6.813059382639276e-06, -3.322277981584794e-09, -5.681707197973493e-11,
  2.669623469735356e-13, -3.644243360825893e-16, -2.407369840466364e-18,  1.589373895787489e-20, -4.023348758891477e-23, -1.311623906146162e-25,  8.231992279962466e-28,
  6.774735256210944e-01, -3.000446867354498e-03,  6.756989309682091e-06,  1.794814795705101e-09, -8.006547033245437e-11,  2.791822472034950e-13,  4.410952019640466e-17,
 -4.718248814626459e-18,  1.884506841259153e-20, -7.067475649423819e-24, -3.732347998831270e-25,  1.257571611590888e-27,  7.596072231000222e-01, -3.268546567213306e-03,
  6.419564617884309e-06,  8.375395537451119e-09, -1.028316441379262e-10,  2.437788941781940e-13,  7.086640758293765e-16, -7.102133977973910e-18,  1.498839795925866e-20,
  6.546354063294784e-23, -6.460510515866840e-25,  7.811232792844571e-28,  8.466914056580855e-01, -3.521518762450118e-03,  5.733571821982038e-06,  1.638625371605847e-08,
 -1.212723009671601e-10,  1.370514424660568e-13,  1.617009730371776e-15, -8.555015217865360e-18, -1.226345047475915e-21,  1.740178012990370e-22, -7.390201478671703e-25,
 -1.693536980045195e-27,  9.386698976624624e-01, -3.749410043444240e-03,  4.626569571937850e-06,  2.558969391095363e-08, -1.296212786140346e-10, -6.425989753973872e-14,
  2.641650146165016e-15, -7.356920173288056e-18, -3.421359847792182e-20,  2.757728905658892e-22, -2.567605399500440e-25, -6.693485812080901e-27,  1.035409816577054e+00,
 -3.939566160235514e-03,  3.026127281268876e-06,  3.541210874678343e-08, -1.199015042112464e-10, -3.727785026302650e-13,  3.450274431314585e-15, -1.198386780885479e-18,
 -8.092010567001752e-20,  2.573536552039721e-22,  1.225886890489354e-24, -1.172164336530661e-26,  1.136660224666795e+00, -4.075946560256331e-03,  8.710524470673166e-07,
  4.475656354659372e-08, -8.223654396954256e-11, -7.698432050457380e-13,  3.412304313453169e-15,  1.180898681435982e-17, -1.189636569865317e-19, -6.594400499689398e-23,
  3.477592811529826e-24, -7.704066534671516e-27,  1.241989108047277e+00, -4.138407016001807e-03, -1.866591987829460e-06,  5.176467251831060e-08, -6.758548988617752e-12,
 -1.170077220868138e-12,  1.603952496521969e-15,  3.022255444555948e-17, -9.355389311858086e-20, -8.112405681504247e-22,  4.166992144388674e-24,  1.884729030882736e-26,
  1.350687037825239e+00, -4.102181811784779e-03, -5.141054180369116e-06,  5.359318125106540e-08,  1.109844622788557e-10, -1.375015183737326e-12, -2.810832609730148e-15,
  4.375450507911085e-17,  7.106906389449074e-20, -1.577223274363850e-21, -1.847336770354673e-24,  5.837408054141605e-26,  1.461620479873343e+00, -3.938161293537947e-03,
 -8.763982914527970e-06,  4.643627528968629e-08,  2.583743612891545e-10, -1.053072031999218e-12, -9.317024961891397e-15,  2.859961630398255e-17,  3.689521854516141e-19,
 -8.476599459301139e-22, -1.583317181980820e-23,  2.195182993743571e-26,  1.573012455721131e+00, -3.615331354972360e-03, -1.230077821010936e-05,  2.639261559864953e-08,
  3.869011917789825e-10,  1.311541243949316e-13, -1.369578336400929e-14, -3.920218599817086e-17,  4.767863264416248e-19,  2.883375929233839e-21, -1.492539069519226e-23,
 -1.751420886655906e-25,  1.682129812027777e+00, -3.108160593857087e-03, -1.495494591046824e-05, -7.673204557493790e-09,  3.982698238080492e-10,  2.013141328200248e-12,
 -7.265439721902202e-15, -1.219172582625315e-16, -2.119978598595354e-19,  5.047559450925866e-21,  3.402843572054949e-23, -1.115246340018859e-25,  1.784885576715570e+00,
 -2.413562465739491e-03, -1.556059574799650e-05, -4.829391346687667e-08,  1.845473161054745e-10,  3.120077606703466e-12,  1.283787320403450e-14, -6.436453496707813e-17,
 -1.126614105186713e-18, -4.535457020712159e-21,  3.128560064167753e-23,  4.936536194990245e-25,  1.875470488840558e+00, -1.581614865496866e-03, -1.300203393272001e-05,
 -7.401141966141593e-08, -2.032874508189152e-10,  1.278754683445162e-12,  2.178438609104371e-14,  1.423512774773023e-16,  1.745424525872174e-19, -6.670519108388865e-21,
 -7.853570430567607e-23, -3.857617289583885e-25,  1.946373687158744e+00, -7.523725446897684e-04, -7.443653703532083e-06, -5.993923204319761e-08, -3.951142503278117e-10,
 -1.936312001293074e-12, -3.601894415967397e-15,  5.937586029998652e-17,  9.413868372382301e-19,  8.352278321761395e-21,  4.871586726172793e-23,  9.766430054666063e-26,
  1.989464120499304e+00, -1.572461925174864e-04, -1.739607888969362e-06, -1.684502700069412e-08, -1.499545441371524e-10, -1.250297574703548e-12, -9.822339229791717e-15,
 -7.254845382875351e-17, -4.984045969092107e-19, -3.104261352893489e-21, -1.644228295085991e-23, -5.870105185858452e-26,  };
  constexpr double w[12288] = {  9.658121525564139e-02, -3.985964204607261e-04,  1.744961070475971e-06, -7.962360390123817e-09,  3.725011000352792e-11,
 -1.764792502406116e-13,  8.398872026356534e-16, -3.996110138319957e-18,  1.895780930509703e-20, -8.955848583622127e-23,  4.210580892060379e-25, -1.969826803577066e-27,
  9.591980347425187e-02, -6.110280834138857e-04,  4.504646850122998e-06, -3.274375072406957e-08,  2.288102896769343e-10, -1.542315429141962e-12,  1.009031036185971e-14,
 -6.439054745665624e-17,  4.022628127541391e-19, -2.466902488388525e-21,  1.488206045891749e-23, -8.846222960648285e-26,  9.461606997079115e-02, -1.025353338108072e-03,
  1.126130000823816e-05, -1.115789710406293e-07,  1.023387404714627e-09, -8.858795406916718e-12,  7.323877603408512e-14, -5.828734854923193e-16,  4.490950312303484e-18,
 -3.364240334905694e-20,  2.458457168744615e-22, -1.757091536018195e-24,  9.270700534689227e-02, -1.621267527401909e-03,  2.430213274149512e-05, -3.125953267361482e-07,
  3.628137131094095e-09, -3.900638755665235e-11,  3.946789771914139e-13, -3.798877783313913e-15,  3.505058696189976e-17, -3.117805324865023e-19,  2.685567719046312e-21,
 -2.247765866517694e-23,  9.024523984626821e-02, -2.370158721297325e-03,  4.661770924629196e-05, -7.583447521548984e-07,  1.087272641965609e-08, -1.419334156700333e-10,
  1.720746388296992e-12, -1.963346344772164e-14,  2.128250596559799e-16, -2.207205424699707e-18,  2.201931769347218e-20, -2.121905352689862e-22,  8.729593075853745e-02,
 -3.237099951032222e-03,  8.144734834141591e-05, -1.641158989426388e-06,  2.852761227915044e-08, -4.445242729835418e-10,  6.355901243974624e-12, -8.469596298773515e-14,
  1.063508313169035e-15, -1.268723002998962e-17,  1.447016801155282e-19, -1.585528166196956e-21,  8.393308926523635e-02, -4.183170647037472e-03,  1.317818204245565e-04,
 -3.231179827936484e-06,  6.705068912772796e-08, -1.229921651303388e-09,  2.047603718053349e-11, -3.148723354627829e-13,  4.528429657554399e-15, -6.147458676424640e-17,
  7.933421000979699e-19, -9.786298194756238e-21,  8.023567110098397e-02, -5.167883032724198e-03,  1.998917367591180e-04, -5.870984235555424e-06,  1.435015982796121e-07,
 -3.061853457555566e-09,  5.870721240326513e-11, -1.031254660427372e-12,  1.682505200645297e-14, -2.575607428735058e-16,  3.728478748567402e-18, -5.134807684306358e-20,
  7.628374885330123e-02, -6.151497781263530e-03,  2.869422885563384e-04, -9.953414048701413e-06,  2.831450976136669e-07, -6.952998907239773e-09,  1.520603662002380e-10,
 -3.024023748718922e-12,  5.550146960318331e-14, -9.504964441001239e-16,  1.531792332966054e-17, -2.338155450630664e-19,  7.215504210925684e-02, -7.097046915484186e-03,
  3.927386444965721e-04, -1.588287234513221e-05,  5.201163662406494e-07, -1.455782606398684e-08,  3.599697357544093e-10, -8.039180808829921e-12,  1.647293718523154e-13,
 -3.133546664405957e-15,  5.583838066582607e-17, -9.385665393941566e-19,  6.792201450674575e-02, -7.971933186999012e-03,  5.156249491101022e-04, -2.402405973815140e-05,
  8.965212524657010e-07, -2.834704203810304e-08,  7.861158395543160e-10, -1.956901414078226e-11,  4.445751827687744e-13, -9.332165668997185e-15,  1.827365366367275e-16,
 -3.362304598562024e-18,  6.364966617038754e-02, -8.749034691911899e-03,  6.525375613143962e-04, -3.464503246036475e-05,  1.459530768617495e-06, -5.170000950660635e-08,
  1.595865100069771e-09, -4.397354116425775e-11,  1.100439523841336e-12, -2.533519044878922e-14,  5.420027264990343e-16, -1.085667469160399e-17,  5.939406827404257e-02,
 -9.407302055873775e-03,  7.991936266238045e-04, -4.786296452702036e-05,  2.256381167310546e-06, -8.884225600080981e-08,  3.030832580424175e-09, -9.183772842260525e-11,
  2.516161151977767e-12, -6.317131163375642e-14,  1.468477061549459e-15, -3.185613711333900e-17,  5.520161393966529e-02, -9.931885616475667e-03,  9.503819351871181e-04,
 -6.360085842228824e-05,  3.327634774789436e-06, -1.445651638124984e-07,  5.413981412242205e-09, -1.792820100290475e-10,  5.346556558027424e-12, -1.455815790052581e-13,
  3.658285279657683e-15, -8.552527640813527e-17,  5.110890348000226e-02, -1.031386675931323e-02,  1.100315553221239e-03, -8.156182605661914e-05,  4.699487261382633e-06,
 -2.236969462139801e-07,  9.137775415410046e-09, -3.287325965079768e-10,  1.061182883234805e-11, -3.117483531599376e-13,  8.426555490546788e-15, -2.113054099921653e-16,
  4.714314551687382e-02, -1.054968897068974e-02,  1.243004844248932e-03, -1.012249021778686e-04,  6.376219076288949e-06, -3.303442597682095e-07,  1.462908930418653e-08,
 -5.685023896048755e-10,  1.975951164559167e-11, -6.231468069344452e-13,  1.803196950570052e-14, -4.828101957453404e-16,  4.332293870831121e-02, -1.064039091602431e-02,
  1.372614070625346e-03, -1.218632530927861e-04,  8.334006503260660e-06, -4.669820844278998e-07,  2.228827556792138e-08, -9.305309298111352e-10,  3.464511086611496e-11,
 -1.167214196918041e-12,  3.599245592834278e-14, -1.024497962648721e-15,  3.965929902001096e-02, -1.059073850148126e-02,  1.483773010803626e-03, -1.425826967543902e-04,
  1.051720293939986e-05, -6.335218533896620e-07,  3.240564803201624e-08, -1.445862466395518e-09,  5.737870194019431e-11, -2.055483930095865e-12,  6.724254468680237e-14,
 -2.026090757023706e-15,  3.615681043835460e-02, -1.040833901850116e-02,  1.571825000039516e-03, -1.623761210642647e-04,  1.283789625535455e-05, -8.265203949061504e-07,
  4.506551182646977e-08, -2.137924254921174e-09,  8.999958128649630e-11, -3.412536605599181e-12,  1.179206083187742e-13, -3.745554935043933e-15,  3.281479798087129e-02,
 -1.010280190558163e-02,  1.633002763073207e-03, -1.801879452912391e-04,  1.517910674640867e-05, -1.038695252687839e-06,  6.005401320058969e-08, -3.014332442391566e-09,
  1.339785189904760e-10, -5.353232045977853e-12,  1.945673592747324e-13, -6.488532446260955e-15,  2.962844636658399e-02, -9.684990767443195e-03,  1.664532059461806e-03,
 -1.949822783262500e-04,  1.740149710995690e-05, -1.258882255904286e-06,  7.679065878347551e-08, -4.058641584551007e-09,  1.896031194065828e-10, -7.948540125875886e-12,
  3.026096131124328e-13, -1.055320402489778e-14,  2.658981216673465e-02, -9.166392652772366e-03,  1.664669739891792e-03, -2.058087791808851e-04,  1.935300651097528e-05,
 -1.472513061779018e-06,  9.430296275961478e-08, -5.223954565555187e-09,  2.553629332988618e-10, -1.118456470433292e-11,  4.442137020033729e-13, -1.613712784260299e-14,
  2.368869916055052e-02, -8.558614866878256e-03,  1.632687050149530e-03, -2.118612009285623e-04,  2.088046372140393e-05, -1.662614139238988e-06,  1.112588085530808e-07,
 -6.430421358553990e-09,  3.274971844198272e-10, -1.492393850045379e-11,  6.158884279000121e-13, -2.321695746263481e-14,  2.091338455144831e-02, -7.873007576147147e-03,
  1.568811046636922e-03, -2.125249357006428e-04,  2.184202104525358e-05, -1.811248089701786e-06,  1.260623308034304e-07, -7.568256024122933e-09,  3.998784668337243e-10,
 -1.888194727498245e-11,  8.065063684827163e-13, -3.142980886818445e-14,  1.825119715788165e-02, -7.120402244972954e-03,  1.474137184543957e-03, -2.074113235520118e-04,
  2.211919327735573e-05, -1.901247385328099e-06,  1.370079897624866e-07, -8.507000426055943e-09,  4.643668043739360e-10, -2.262977144998138e-11,  9.965645605379082e-13,
 -3.999946047532774e-14,  1.568895786596141e-02, -6.310951159799782e-03,  1.350525005983560e-03, -1.963778400282131e-04,  2.162737088942624e-05, -1.918041102155258e-06,
  1.424762050357449e-07, -9.110513667297292e-09,  5.116800048463073e-10, -2.563306865629337e-11,  1.159401709528797e-12, -4.775304043607808e-14,  1.321329816491168e-02,
 -5.454051320710937e-03,  1.200486901614467e-03, -1.795344025684471e-04,  2.032387322647289e-05, -1.851354213924148e-06,  1.411447412650768e-07, -9.255836484403767e-09,
  5.327045985179430e-10, -2.732604771795689e-11,  1.264681202211852e-12, -5.325827734349228e-14,  1.081087550864276e-02, -4.558336189885796e-03,  1.027077610954416e-03,
 -1.572368728159149e-04,  1.821287703746561e-05, -1.696568618880123e-06,  1.321849104703682e-07, -8.852987923236269e-09,  5.200466393073134e-10, -2.721102166974884e-11,
  1.283804907136356e-12, -5.507810743557844e-14,  8.468506586152747e-03, -3.631721007007594e-03,  8.337899289887063e-04, -1.300693934781628e-04,  1.534686127924554e-05,
 -1.455572883724398e-06,  1.154117222385938e-07, -7.862184429672263e-09,  4.695287612796195e-10, -2.496414010688142e-11,  1.196226015596429e-12, -5.209716572065680e-14,
  6.173250157106508e-03, -2.681494569650623e-03,  6.244610723983876e-04, -9.881765509479933e-05,  1.182453361847231e-05, -1.136989024445298e-06,  9.136264866664004e-08,
 -6.305115891176107e-09,  3.813101256595515e-10, -2.052281538885433e-11,  9.951289432335447e-13, -4.383870131654756e-14,  3.912573936792930e-03, -1.714498835645450e-03,
  4.032031698645981e-04, -6.443700169066660e-05,  7.785692983774533e-06, -7.557576753650586e-07,  6.129120489987016e-08, -4.267885740997680e-09,  2.603607120825449e-10,
 -1.413189090187782e-11,  6.908760416193114e-13, -3.067749712739689e-14,  1.676915581248162e-03, -7.384001017542802e-04,  1.745971645588769e-04, -2.805579341645014e-05,
  3.408167524656670e-06, -3.325739674973311e-07,  2.710974771505252e-08, -1.897140482049433e-09,  1.162945273340107e-10, -6.341905963267345e-12,  3.114549169824756e-13,
 -1.389076807766929e-14,  9.501415777065307e-02, -3.850090544826515e-04,  1.652875726674315e-06, -7.393536943886179e-09,  3.391337680150566e-11, -1.575989658626140e-13,
  7.360267566867641e-16, -3.437957449728077e-18,  1.601710142697435e-20, -7.432755915354740e-23,  3.433364883633244e-25, -1.578383077311365e-27,  9.354536184158981e-02,
 -5.765026340238080e-04,  4.132710708386711e-06, -2.931698663360672e-08,  2.002468014635029e-10, -1.320406754285785e-12,  8.455014970282621e-15, -5.283138041121996e-17,
  3.232941861772020e-19, -1.942661447165518e-21,  1.148652173220604e-23, -6.693827565412690e-26,  9.068673339379932e-02, -9.403532385783042e-04,  1.001504561385142e-05,
 -9.653194695259166e-08,  8.625462594079598e-10, -7.281725783677743e-12,  5.876089546746595e-14, -4.567845979403997e-16,  3.439674841943795e-18, -2.519552940990782e-20,
  1.801125856500910e-22, -1.259759757278894e-24,  8.658833115577107e-02, -1.440924304571667e-03,  2.087511929039046e-05, -2.603055042295939e-07,  2.934730048482848e-09,
 -3.069344713926910e-11,  3.024630313957177e-13, -2.837901987033190e-15,  2.554346307483661e-17, -2.217973824779678e-19,  1.865996590423262e-21, -1.526197339821348e-23,
  8.145676209589467e-02, -2.030862249289547e-03,  3.847446702152407e-05, -6.050205716725974e-07,  8.406195020822777e-09, -1.065305367603606e-10,  1.255523494285197e-12,
 -1.394113682589078e-14,  1.472017293594522e-16, -1.488195353605194e-18,  1.448248017491892e-20, -1.362228131540656e-22,  7.553608748417559e-02, -2.657162854670096e-03,
  6.422350494457809e-05, -1.248295137175356e-06,  2.098867192109891e-08, -3.169800649200107e-10,  4.399441128793211e-12, -5.697794096494851e-14,  6.960815119278696e-16,
 -8.086270250670485e-18,  8.987842063322613e-20, -9.604139880781867e-22,  6.908683053784175e-02, -3.267484706320084e-03,  9.871173675891172e-05, -2.331182689151877e-06,
  4.672905953505479e-08, -8.297641664028588e-10,  1.339487655121418e-11, -2.000008354702855e-13,  2.796048898830788e-15, -3.693337225364861e-17,  4.641771474621471e-19,
 -5.580546560629525e-21,  6.236575258718863e-02, -3.815725245192792e-03,  1.414188247034218e-04, -3.997124404698051e-06,  9.429686856904762e-08, -1.946180696882298e-09,
  3.615795787198568e-11, -6.163308734962678e-13,  9.769371459101253e-15, -1.454479964347388e-16,  2.049644512118997e-18, -2.750115756700191e-20,  5.560863324500571e-02,
 -4.266117736195458e-03,  1.906657973219815e-04, -6.362830624233150e-06,  1.746380985065021e-07, -4.146768263065372e-09,  8.784752928491466e-11, -1.694782010215627e-12,
  3.021299912566588e-14, -5.031244374507034e-16,  7.891873509746036e-18, -1.173515790296477e-19,  4.901755043532497e-02, -4.595462866362505e-03,  2.438017418987044e-04,
 -9.487876499937935e-06,  2.998061663324591e-07, -8.114667715453714e-09,  1.943736142823018e-10, -4.211360038469838e-12,  8.382502139579035e-14, -1.550654911461484e-15,
  2.689790639821137e-17, -4.405034020868229e-19,  4.275329601382486e-02, -4.793482094754097e-03,  2.975665985280516e-04, -1.335105770809188e-05,  4.810196185564781e-07,
 -1.471420447199971e-08,  3.954438466590931e-10, -9.553640305492301e-12,  2.109095272525029e-13, -4.306943299567731e-15,  8.212603752810710e-17, -1.472848903169436e-18,
  3.693276269404099e-02, -4.861588301985452e-03,  3.485386486933429e-04, -1.784005981147953e-05,  7.262736248776077e-07, -2.490862253246273e-08,  7.456535456872025e-10,
 -1.995382836922723e-11,  4.855472577643500e-13, -1.088170484798148e-14,  2.268350910916434e-16, -4.431360960819060e-18,  3.163053022144164e-02, -4.810561123367646e-03,
  3.935705504922060e-04, -2.275743450073838e-05,  1.038036487092796e-06, -3.961631896897406e-08,  1.312015222040173e-09, -3.864591307547841e-11,  1.030486960063317e-12,
 -2.520621231545186e-14,  5.714209733802974e-16, -1.209962115073531e-17,  2.688352681113327e-02, -4.657676063822047e-03,  4.301362868965619e-04, -2.784161243859902e-05,
  1.411607207117541e-06, -5.952493566621393e-08,  2.166850609374653e-09, -6.983505835334004e-11,  2.029199520922718e-12, -5.389047799047045e-14,  1.322024331050719e-15,
 -3.019872432524992e-17,  2.269754293745381e-02, -4.423787125350801e-03,  4.565436104838410e-04, -3.279814105219991e-05,  1.834573628531791e-06, -8.489994153740845e-08,
  3.376122378779691e-09, -1.183745442936402e-10,  3.728216533342712e-12, -1.069611420568648e-13,  2.825941332573181e-15, -6.932246509601285e-17,  1.905447744425420e-02,
 -4.130740803922547e-03,  4.720015288944361e-04, -3.733447523229485e-05,  2.287541789686894e-06, -1.154319341886819e-07,  4.984750105705249e-09, -1.890991467373321e-10,
  6.422245901362725e-12, -1.980801347282676e-13,  5.610338565594530e-15, -1.471486498468004e-16,  1.591942588461344e-02, -3.799348342770634e-03,  4.765612056927593e-04,
 -4.119172100794326e-05,  2.745999800872279e-06, -1.501614106119422e-07,  7.001722296777362e-09, -2.858571013599487e-10,  1.041680858256102e-11, -3.437734785818224e-13,
  1.039179211684476e-14, -2.901765417516324e-16,  1.324700259556838e-02, -3.447999671933376e-03,  4.709664476296562e-04, -4.416835234992486e-05,  3.182931018272860e-06,
 -1.875027924681335e-07,  9.388388234961097e-09, -4.103890245334040e-10,  1.596849697886897e-11, -5.612973752967624e-13,  1.802965424247191e-14, -5.337720193550981e-16,
  1.098656090154243e-02, -3.091890074881352e-03,  4.564559283383312e-04, -4.613334470292473e-05,  3.571666066552567e-06, -2.253667171208539e-07,  1.205293364707006e-08,
 -5.612839180704264e-10,  2.321025187900385e-11, -8.650725780127988e-13,  2.940147112855933e-14, -9.190976764238954e-16,  9.086201645615900e-03, -2.742758876988066e-03,
  4.345557148890775e-04, -4.702861354109077e-05,  3.888476711801865e-06, -2.613582300971065e-07,  1.485280399512058e-08, -7.332671509558422e-10,  3.207597315791172e-11,
 -1.262079892794859e-12,  4.519644465343244e-14, -1.485860785124337e-15,  7.495622213446140e-03, -2.409006728423859e-03,  4.068912380399732e-04, -4.686253386345943e-05,
  4.114538071430152e-06, -2.930144649396716e-07,  1.760512839897169e-08, -9.170296359368597e-10,  4.224271490439268e-11, -1.747094151321865e-12,  6.565095368428701e-14,
 -2.260879529502162e-15,  6.167956330608316e-03, -2.096055956582797e-03,  3.750363445577506e-04, -4.569737583155368e-05,  4.237065882383259e-06, -3.180414735187261e-07,
  2.010353504679616e-08, -1.099702529505925e-09,  5.310787113252846e-11, -2.298962377063940e-12,  9.028039608456617e-14, -3.244095994011129e-15,  5.060799449043393e-03,
 -1.806836105254474e-03,  3.404063845272953e-04, -4.363373566273475e-05,  4.249617019994116e-06, -3.345154201161602e-07,  2.213858490052639e-08, -1.265948477399858e-09,
  6.381292422974257e-11, -2.879153810037870e-12,  1.176826093095960e-13, -4.395357936806554e-15,  4.136620093776652e-03, -1.542303945459083e-03,  3.041940945783013e-04,
 -4.079466905941006e-05,  4.151683070625301e-06, -3.410252200960322e-07,  2.351862312767478e-08, -1.399516522798862e-09,  7.331598074714318e-11, -3.433468830250976e-12,
  1.454894673485903e-13, -5.626349486293797e-15,  3.362738727069795e-03, -1.301936118139779e-03,  2.673418902572600e-04, -3.731151818677420e-05,  3.947788890982838e-06,
 -3.367477762411149e-07,  2.408814600084741e-08, -1.485024446785221e-09,  8.050502942984952e-11, -3.897156462733541e-12,  1.705202629870346e-13, -6.801848893757964e-15,
  2.711024649342908e-03, -1.084158224073843e-03,  2.305418285576976e-04, -3.331261384743407e-05,  3.646330987570777e-06, -3.214595973134604e-07,  2.374159949162100e-08,
 -1.509704912173744e-09,  8.433533350990431e-11, -4.202921750516279e-12,  1.891467992978980e-13, -7.752781770519354e-15,  2.157426952398488e-03, -8.866942625749315e-04,
  1.942542742987693e-04, -2.891531220115968e-05,  3.258367657943015e-06, -2.954974538598211e-07,  2.243156953293876e-08, -1.464878052952469e-09,  8.396957426846350e-11,
 -4.290610991219819e-12,  1.978268938917687e-13, -8.300620667271927e-15,  1.681423063061517e-03, -7.068343860101836e-04,  1.587374236367051e-04, -2.422128632544514e-05,
  2.796522924681167e-06, -2.596850440580486e-07,  2.017131390971923e-08, -1.346977534869647e-09,  7.889902775121111e-11, -4.116922530797890e-12,  1.937152066552500e-13,
 -8.289352096147344e-15,  1.265440934678099e-03, -5.416277296224260e-04,  1.240816310888131e-04, -1.931466369074732e-05,  2.274107365068028e-06, -2.152428734817210e-07,
  1.703233100822788e-08, -1.158038455525550e-09,  6.902771056458046e-11, -3.663403082975557e-12,  1.752317219606399e-13, -7.618523461119197e-15,  8.942905226231546e-04,
 -3.880122868530745e-04,  9.024456209339907e-05, -1.426247594001609e-05,  1.704506278401081e-06, -1.636960668398151e-07,  1.313809654524703e-08, -9.056352901599800e-10,
  5.470785548752701e-11, -2.941261755809997e-12,  1.424673650741112e-13, -6.269714694165114e-15,  5.546382552685700e-04, -2.429018510450007e-04,  5.708645275003414e-05,
 -9.117114846100108e-06,  1.100870282172890e-06, -1.067933006347534e-07,  8.655430577881199e-09, -6.023363924560278e-10,  3.672351984506229e-11, -1.992132800583490e-12,
  9.733606505084773e-14, -4.319726240309958e-15,  2.348503934181301e-04, -1.033839180286783e-04,  2.443789564809597e-05, -3.925656022975004e-06,  4.767321294501481e-07,
 -4.650581762033699e-08,  3.789764230889225e-09, -2.651283631050513e-10,  1.624756613071903e-11, -8.857752188913290e-13,  4.348865188189042e-14, -1.939039671170820e-15,
  9.350001837011154e-02, -3.721319474772498e-04,  1.567307974193160e-06, -6.875210688814851e-09,  3.093053578877706e-11, -1.410339404891635e-13,  6.465554881996211e-16,
 -2.965702298302753e-18,  1.357266012389140e-20, -6.188686662445241e-23,  2.809455732952632e-25, -1.269520533588551e-27,  9.130332092180697e-02, -5.447956343868931e-04,
  3.799293481884575e-06, -2.631376027140955e-08,  1.757538270068765e-10, -1.134130294229861e-12,  7.110658812071167e-15, -4.352171492520039e-17,  2.609655315188559e-19,
 -1.537049601894292e-21,  8.910539287296871e-24, -5.092393723550025e-26,  8.707854196833660e-02, -8.646423856560293e-04,  8.934897592650337e-06, -8.382379380328972e-08,
  7.300392680981986e-10, -6.013297000624574e-12,  4.738486235901459e-14, -3.599386953024762e-16,  2.649994630083141e-18, -1.898761943652797e-20,  1.328288667607695e-22,
 -9.094930922953813e-25,  8.113992112648638e-02, -1.285663987146191e-03,  1.801413723735999e-05, -2.178918079495012e-07,  2.387463695914182e-09, -2.430239785336835e-11,
  2.333404526477970e-13, -2.135078387541130e-15,  1.875487973201971e-17, -1.590308974970672e-19,  1.307265621562916e-21, -1.045208107981227e-23,  7.390595013870802e-02,
 -1.749972927241529e-03,  3.195586716803819e-05, -4.860528747563561e-07,  6.547845940067074e-09, -8.059569152259490e-11,  9.237979592998925e-13, -9.986828964946230e-15,
  1.027554740846251e-16, -1.013080320739207e-18,  9.620678522536061e-21, -8.835824414837534e-23,  6.584761000912297e-02, -2.198031120920383e-03,  5.106687204586870e-05,
 -9.579566877627200e-07,  1.558766164381345e-08, -2.282671121516157e-10,  3.076646692912512e-12, -3.874214343785487e-14,  4.606541952473029e-16, -5.212897692361494e-18,
  5.648491051770360e-20, -5.888114808904227e-22,  5.743552297159043e-02, -2.578133802398513e-03,  7.472767330944122e-05, -1.700549756169043e-06,  3.294241488692041e-08,
 -5.664882926339989e-10,  8.870612195565063e-12, -1.286482519330346e-13,  1.748880051471555e-15, -2.248512401659682e-17,  2.752878721854283e-19, -3.226523944237206e-21,
  4.909443439617198e-02, -2.853266483646963e-03,  1.013594563148671e-04, -2.757902192863806e-06,  6.281725159189422e-08, -1.254476840954681e-09,  2.259064653854594e-11,
 -3.737643408377004e-13,  5.757430752799891e-15, -8.338663084655705e-17,  1.144163147678547e-18, -1.496014061813633e-20,  4.117083937621755e-02, -3.004337311844524e-03,
  1.286715070642920e-04, -4.131914348285967e-06,  1.094431727894350e-07, -2.513408247242765e-09,  5.158825323745924e-11, -9.656892389379292e-13,  1.672476036287177e-14,
 -2.708653489058811e-16,  4.136038466905229e-18, -5.992312606066456e-20,  3.391616757050971e-02, -3.029786275913396e-03,  1.540962436363712e-04, -5.771094786982595e-06,
  1.759830497226721e-07, -4.606605725604162e-09,  1.069033211649752e-10, -2.247297212415890e-12,  4.345565400713455e-14, -7.818139379536037e-16,  1.320228901625344e-17,
 -2.106738312948589e-19,  2.748470628593899e-02, -2.942379703530448e-03,  1.752716922154750e-04, -7.572222207187187e-06,  2.633813902951788e-07, -7.794314312429612e-09,
  2.029982115442054e-10, -4.759672471859600e-12,  1.021068641430128e-13, -2.028441483468079e-15,  3.766522095651462e-17, -6.583837185155806e-19,  2.194309901613667e-02,
 -2.764428704352077e-03,  1.904381461260388e-04, -9.395190008711072e-06,  3.695415495917885e-07, -1.226935697993047e-08,  3.561533878196087e-10, -9.254900174282795e-12,
  2.189588615934332e-13, -4.776307704711815e-15,  9.700618666808120e-17, -1.848058367631132e-18,  1.728712443403220e-02, -2.522696421470605e-03,  1.986634902570841e-04,
 -1.108683501793296e-05,  4.891456212965749e-07, -1.808995602087506e-08,  5.814610250146965e-10, -1.664544641792408e-11,  4.318836273163554e-13, -1.029036148152919e-14,
  2.274567642012122e-16, -4.700287563388206e-18,  1.346146595465526e-02, -2.243980927576489e-03,  1.998750580899232e-04, -1.250695714674818e-05,  6.142289421075395e-07,
 -2.513078176109088e-08,  8.889181940529097e-10, -2.787346999570704e-11,  7.889051920858136e-13, -2.042878400418081e-14,  4.891103448942467e-16, -1.091372017318658e-17,
  1.037898948730166e-02, -1.951937896264535e-03,  1.947305340699222e-04, -1.354980598616357e-05,  7.353733401881809e-07, -3.306984713174664e-08,  1.279616905012606e-09,
 -4.370971342638457e-11,  1.342600303464317e-12, -3.760294547831505e-14,  9.707256795378258e-16, -2.328679642704540e-17,  7.937232237550268e-03, -1.665291097383386e-03,
  1.843916850220312e-04, -1.415655800884290e-05,  8.431962595650683e-07, -4.141822671611495e-08,  1.743198210479387e-09, -6.452231303047641e-11,  2.140221517978940e-12,
 -6.452985805919835e-14,  1.788220246019028e-15, -4.592468311072802e-17,  6.030996927362235e-03, -1.397268906093582e-03,  1.702700909430938e-04, -1.431749739247980e-05,
  9.297533544165717e-07, -4.958623475036194e-08,  2.257465150058244e-09, -9.007695922812971e-11,  3.211042094317985e-12, -1.037519087556699e-13,  3.073013401014936e-15,
 -8.414146714294769e-17,  4.560902871493999e-03, -1.155937694414470e-03,  1.538001246902874e-04, -1.406546087716563e-05,  9.895433614085535e-07, -5.696911577859343e-08,
  2.790428107471799e-09, -1.194301112363224e-10,  4.553867094314126e-12, -1.569786372316191e-13,  4.948521327118954e-15, -1.438742176224125e-16,  3.438369890545214e-03,
 -9.450640759260102e-04,  1.362714991924298e-04, -1.346380249576873e-05,  1.019957158157994e-06, -6.303119966506275e-08,  3.304338728620807e-09, -1.509543933517298e-10,
  6.128235580557449e-12, -2.243879813858982e-13,  7.496986384274980e-15, -2.305269901694774e-16,  2.587815562065067e-03, -7.651864959284233e-04,  1.187310366723065e-04,
 -1.259250109266195e-05,  1.021179522013855e-06, -6.737039747281788e-08,  3.760733005453473e-09, -1.824982950813945e-10,  7.852199437200353e-12, -3.040729632250727e-13,
  1.072316510759798e-14, -3.473508884494359e-16,  1.946905463558017e-03, -6.146668272608007e-04,  1.019466159865156e-04, -1.153538341404882e-05,  9.956766924524888e-07,
 -6.975262381616623e-08,  4.125323405679627e-09, -2.116452780712348e-10,  9.607888440402587e-12, -3.918084531090543e-13,  1.452436616453165e-14, -4.936821232741240e-16,
  1.465602785269997e-03, -4.905880573331384e-04,  8.641732518544670e-05, -1.037028716271656e-05,  9.474599914281538e-07, -7.011474565625641e-08,  4.371763396566463e-09,
 -2.360136136478312e-10,  1.125398805074418e-11, -4.812407257948654e-13,  1.867642445837840e-14, -6.635142609521923e-16,  1.104600234114204e-03, -3.894430827740972e-04,
  7.241168248176938e-05, -9.162818981777367e-06,  8.813096920283554e-07, -6.854193376418417e-08,  4.483729799178931e-09, -2.535342075835420e-10,  1.264252555374153e-11,
 -5.644951122494678e-13,  2.284205302985614e-14, -8.448955494845817e-16,  8.335420231276805e-04, -3.076137560039612e-04,  6.001807656349621e-05, -7.963472113013021e-06,
  8.020962597620629e-07, -6.522921968435623e-08,  4.455249290314028e-09, -2.626575018128619e-10,  1.363652757343948e-11, -6.330926285365002e-13,  2.660260914826423e-14,
 -1.020491228569134e-15,  6.292904871467340e-04, -2.416695388062993e-04,  4.919591560398878e-05, -6.807361708685406e-06,  7.142743293458079e-07, -6.043757011594572e-08,
  4.289582254319399e-09, -2.624646287947944e-10,  1.412531758661042e-11, -6.789991140921108e-13,  2.950850143995058e-14, -1.169375011581664e-15,  4.743741875051896e-04,
 -1.885268910094369e-04,  3.982055418843454e-05, -5.715673605124393e-06,  6.215688611184345e-07, -5.445285325714504e-08,  3.997190414257128e-09, -2.526831115211846e-10,
  1.403522199737384e-11, -6.956165191439669e-13,  3.113913435870948e-14, -1.269803281351690e-15,  3.556731421432421e-04, -1.455104391285415e-04,  3.171885775228361e-05,
 -4.697996742708018e-06,  5.268337583245200e-07, -4.755300940196233e-08,  3.593351078452371e-09, -2.336264395748311e-10,  1.333479581623842e-11, -6.785609399977116e-13,
  3.116158643613850e-14, -1.302478678117407e-15,  2.633463298124542e-04, -1.103507140790886e-04,  2.469489397225332e-05, -3.754903695312791e-06,  4.320430119768641e-07,
 -3.998568509686123e-08,  3.095888418500579e-09, -2.060865565926578e-10,  1.203491587902828e-11, -6.261362846995039e-13,  2.937825041812259e-14, -1.253694863408309e-15,
  1.899789822631974e-04, -8.114485362441765e-05,  1.854676596395964e-05, -2.880367302152491e-06,  3.383698716668951e-07, -3.195623999184605e-08,  2.523336851139162e-09,
 -1.712090633134586e-10,  1.018492566361229e-11, -5.394820834324829e-13,  2.575665395303326e-14, -1.117788647358177e-15,  1.299149903619489e-04, -5.629859106403690e-05,
  1.307629450676657e-05, -2.063801978601590e-06,  2.463154231215778e-07, -2.362465562934108e-08,  1.893692869399575e-09, -1.303755588602043e-10,  7.866364123433325e-12,
 -4.224302010133434e-13,  2.043848021068663e-14, -8.984807637036537e-16,  7.873853639436376e-05, -3.446194035169178e-05,  8.093584214581643e-06, -1.291700210098779e-06,
  1.558623124906400e-07, -1.510970329338189e-08,  1.223811697203571e-09, -8.511111442284458e-11,  5.185850270640031e-12, -2.811445000261242e-13,  1.372864551243101e-14,
 -6.089199982389447e-16,  3.291302739025016e-05, -1.448456684148271e-05,  3.422756060539437e-06, -5.496442155606213e-07,  6.672705362618272e-08, -6.507209650614307e-09,
  5.301051041591754e-10, -3.707410835212110e-11,  2.271276849563751e-12, -1.237869974536332e-13,  6.075746818180129e-15, -2.708229388971166e-16,  9.203605659320431e-02,
 -3.599152897216785e-04,  1.487684350938463e-06, -6.402071814442337e-09,  2.825854926746185e-11, -1.264659896860892e-13,  5.692762971927267e-16, -2.564959729895379e-18,
  1.153425263237777e-20, -5.169007564892443e-23,  2.306744271149926e-25, -1.024842623948353e-27,  8.918299252431773e-02, -5.156182076107050e-04,  3.499681142849551e-06,
 -2.367428556810636e-08,  1.546837405676627e-10, -9.772029008377944e-13,  6.001111034700527e-15, -3.599152062904960e-17,  2.115422055836781e-19, -1.221662567005546e-21,
  6.945958657481816e-24, -3.894206276188376e-26,  8.375682894904779e-02, -7.969969314423488e-04,  7.995318249717136e-06, -7.304676513516772e-08,  6.203763245157815e-10,
 -4.988014114487788e-12,  3.839789714371539e-14, -2.851236993251188e-16,  2.053166518490687e-18, -1.439550290461341e-20,  9.858309978244157e-23, -6.610283729319757e-25,
  7.626980205315120e-02, -1.151395364869936e-03,  1.561352536274618e-05, -1.832956667231275e-07,  1.952904378559782e-09, -1.935674593804105e-11,  1.811668297943764e-13,
 -1.617267042568410e-15,  1.386985444246855e-17, -1.148930158835320e-19,  9.231259947384587e-22, -7.217552920388935e-24,  6.738277445891468e-02, -1.515990639115561e-03,
  2.670229027038496e-05, -3.930668144883695e-07,  5.136779881637614e-09, -6.143977167720712e-11,  6.852069482614168e-13, -7.214903796792457e-15,  7.236715595614404e-17,
 -6.960406721287169e-19,  6.452528374923720e-21, -5.788332244872539e-23,  5.780530972234101e-02, -1.831560838925990e-03,  4.092920659832107e-05, -7.414058260002579e-07,
  1.168077328894412e-08, -1.659382059743343e-10,  2.172865829249621e-12, -2.661384724523945e-14,  3.081051603680104e-16, -3.397599221531229e-18,  3.590182032241786e-20,
 -3.652067091209381e-22,  4.820099116509011e-02, -2.053770027227354e-03,  5.714404325188271e-05, -1.253661806358903e-06,  2.347958699613142e-08, -3.911737751228483e-10,
  5.943952439029474e-12, -8.376001741908889e-14,  1.107594184453481e-15, -1.386478474190976e-17,  1.654094683006315e-19, -1.890532931025276e-21,  3.911534827310546e-02,
 -2.159415521741629e-03,  7.355366191782428e-05, -1.927300596793889e-06,  4.239865205189009e-08, -8.195544369629467e-10,  1.430951301956430e-11, -2.298691642691022e-13,
  3.441988178977739e-15, -4.850828916867001e-17,  6.482367577494079e-19, -8.261435489921932e-21,  3.093569778490041e-02, -2.146953518408149e-03,  8.813140755656279e-05,
 -2.723908249973275e-06,  6.964410424120115e-08, -1.547269400348526e-09,  3.077661277422055e-11, -5.591178074529128e-13,  9.409278388274580e-15, -1.482327366144612e-16,
  2.203831733622690e-18, -3.111434368489952e-20,  2.388332880520326e-02, -2.032353633919219e-03,  9.909636678354859e-05, -3.571888726258157e-06,  1.051245608533673e-07,
 -2.661648343542048e-09,  5.984948998902049e-11, -1.220865801268638e-12,  2.293712554582161e-14, -4.013830079641466e-16,  6.599192301734875e-18, -1.026176564782469e-19,
  1.803148533546360e-02, -1.842361350854109e-03,  1.052933392941001e-04, -4.379942142775502e-06,  1.470753736772192e-07, -4.210717176954452e-09,  1.062784500163225e-10,
 -2.418470542419666e-12,  5.041722443756199e-14, -9.743827529259920e-16,  1.761897804446776e-17, -3.001821901188989e-19,  1.333900520425093e-02, -1.607395358445222e-03,
  1.063680598329900e-04, -5.056860310958911e-06,  1.921449883828468e-07, -6.175147797153736e-09,  1.737998576804675e-10, -4.385238942274065e-12,  1.008639376427514e-13,
 -2.141399533194380e-15,  4.237081155834997e-17, -7.871183596446963e-19,  9.689300820730402e-03, -1.355765725644877e-03,  1.027223671763015e-04, -5.530879100000962e-06,
  2.359638426807492e-07, -8.454345713632501e-09,  2.636881273896087e-10, -7.334873776174891e-12,  1.851479370110000e-13, -4.296432034261790e-15,  9.258162931444820e-17,
 -1.866770320028341e-18,  6.926613356768076e-03, -1.110047607271708e-03,  9.530790073153431e-05, -5.762642735156827e-06,  2.740219683463570e-07, -1.087423019856595e-08,
  3.736298222873894e-10, -1.139534974384421e-11,  3.140683329235456e-13, -7.927907511317644e-15,  1.852042181810867e-16, -4.035786207960967e-18,  4.884755012111023e-03,
 -8.856477341222013e-04,  8.535068157469675e-05, -5.748893666378274e-06,  3.025701980299993e-07, -1.321610378330230e-08,  4.974002872290383e-10, -1.654598564574781e-11,
  4.954825309874604e-13, -1.354262336069473e-14,  3.414843141936428e-16, -8.008429893290368e-18,  3.406682990908765e-03, -6.910769982820088e-04,  7.409238912845569e-05,
 -5.517541324780891e-06,  3.192761353720391e-07, -1.525797042138614e-08,  6.255612577253481e-10, -2.258107152271020e-11,  7.312253462775244e-13, -2.154356212593563e-14,
  5.838678295424599e-16, -1.467672296572216e-17,  2.355523743779406e-03, -5.292414379550743e-04,  6.260286184846963e-05, -5.117240301867722e-06,  3.234839918820606e-07,
 -1.681558094847815e-08,  7.470238572416006e-10, -2.911660066414094e-11,  1.014840096179038e-12, -3.208849376060263e-14,  9.308222229511077e-16, -2.498003813392962e-17,
  1.618895488171516e-03, -3.991141893046270e-04,  5.168161258127611e-05, -4.605370733653778e-06,  3.160782638503352e-07, -1.777178696892383e-08,  8.510154378209583e-10,
 -3.564198131360407e-11,  1.331016631160207e-12, -4.497216515607639e-14,  1.390588219692080e-15, -3.968567063750456e-17,  1.108722134807014e-03, -2.973339762006583e-04,
  4.183786727038541e-05, -4.037612306495452e-06,  2.990678171285320e-07, -1.808809378173692e-08,  9.288836616370190e-10, -4.160289477346867e-11,  1.657102582763105e-12,
 -5.957458799285053e-14,  1.955626150021129e-15, -5.912078704108372e-17,  7.585059391658004e-04, -2.194852924186340e-04,  3.332420422219558e-05, -3.460871913502123e-06,
  2.750549372312317e-07, -1.779870459098892e-08,  9.752867420024711e-10, -4.649178022414868e-11,  1.966357189497259e-12, -7.489960480120615e-14,  2.599648996822832e-15,
 -8.292854537891575e-17,  5.195390234907488e-04, -1.609859998840424e-04,  2.619680529237341e-05, -2.909897143781253e-06,  2.467370191193610e-07, -1.699216449248943e-08,
  9.885710026210019e-10, -4.992222379434452e-11,  2.232062984888727e-12, -8.969904119345091e-14,  3.278497180461944e-15, -1.099293983903090e-16,  3.570100251070884e-04,
 -1.176157279314814e-04,  2.038085028237689e-05, -2.406928061393968e-06,  2.165340141870818e-07, -1.578765677302978e-08,  9.704015540317295e-10, -5.167146927167340e-11,
  2.431416937786779e-12, -1.026509478562609e-13,  3.934947814965049e-15, -1.381453559368465e-16,  2.465246417148291e-04, -8.576783313909579e-05,  1.572777132267215e-05,
 -1.963317520229134e-06,  1.863734561369980e-07, -1.431229757287351e-08,  9.248914391466187e-10, -5.168680597037457e-11,  2.548316867453258e-12, -1.125464508208451e-13,
  4.506356420092999e-15, -1.649983248101615e-16,  1.712497336067329e-04, -6.251622844152688e-05,  1.205855767094227e-05, -1.582067868947806e-06,  1.576180595617698e-07,
 -1.268353417910274e-08,  8.575327691266121e-10, -5.006181500348597e-11,  2.574600580730953e-12, -1.184423743724507e-13,  4.933278755288612e-15, -1.876426753402908e-16,
  1.197026170534166e-04, -4.557488584217054e-05,  9.192534011931997e-06, -1.260489366239468e-06,  1.310962316991580e-07, -1.099821599686718e-08,  7.741899604903142e-10,
 -4.699430962328967e-11,  2.509776855042552e-12, -1.197523673834409e-13,  5.167145948730257e-15, -2.033568468101094e-16,  8.411156362260460e-05, -3.320655257819663e-05,
  6.963872598809577e-06, -9.925059856042793e-07,  1.071907728970194e-07, -9.327925949620919e-09,  6.803183331129766e-10, -4.273875422259945e-11,  2.359640939049329e-12,
 -1.162697819441793e-13,  5.175587418311856e-15, -2.099102952632073e-16,  5.923836466005164e-05, -2.411667633820144e-05,  5.229091492877447e-06, -7.704083410889728e-07,
  8.594827348455984e-08, -7.719057015511034e-09,  5.804687277664526e-10, -3.756332359581191e-11,  2.134319769153123e-12, -1.081332127884520e-13,  4.944820849355017e-15,
 -2.058392027872967e-16,  4.155276898135432e-05, -1.735242230935282e-05,  3.868662779594143e-06, -5.860387145942091e-07,  6.718383675999990e-08, -6.195813538282547e-09,
  4.780609704583695e-10, -3.171758767927285e-11,  1.846262375011454e-12, -9.575580346997240e-14,  4.479323941113061e-15, -1.905964910905930e-16,  2.866338084029966e-05,
 -1.221568000896058e-05,  2.785214946781817e-06, -4.314917157836064e-07,  5.056759706743163e-08, -4.764538393014785e-09,  3.753663729574794e-10, -2.541280336485534e-11,
  1.508549744428306e-12, -7.974146618486791e-14,  3.799536304367468e-15, -1.645753160826272e-16,  1.892922911484737e-05, -8.192331758429334e-06,  1.900062618329003e-06,
 -2.994488237455650e-07,  3.568856428833700e-08, -3.418231372801978e-09,  2.736282582552072e-10, -1.881396048077207e-11,  1.133725111583817e-12, -6.080720029768766e-14,
  2.938536899741996e-15, -1.290300653601794e-16,  1.119520061882123e-05, -4.896654608627434e-06,  1.149163166859972e-06, -1.832657088298685e-07,  2.209753871002664e-08,
 -2.140665847105483e-09,  1.732627954163373e-10, -1.204155583397937e-11,  7.332122732084378e-13, -3.972468425628238e-14,  1.938595321158973e-15, -8.593228632117561e-17,
  4.615870720128020e-06, -2.030774947037545e-06,  4.797176586327750e-07, -7.700918482709156e-08,  9.345765072939712e-09, -9.110910666405251e-10,  7.419685665695109e-11,
 -5.187443586719773e-12,  3.176980639072491e-13, -1.730947961672937e-14,  8.493286512696244e-16, -3.784701674979830e-17,  9.061972243025083e-02, -3.483136155595162e-04,
  1.413491182004515e-06, -5.969450937677211e-09,  2.586024693718600e-11, -1.136251350312318e-13,  5.023572269056237e-16, -2.223940839241228e-18,  9.829184855952421e-21,
 -4.330445866440773e-23,  1.900223813608491e-25, -8.302606998635768e-28,  8.717477284873329e-02, -4.887164863517014e-04,  3.229818845723996e-06, -2.134820211379732e-08,
  1.365021080103676e-10, -8.445432503121718e-13,  5.081871479682561e-15, -2.987540275280844e-17,  1.721766930368848e-19, -9.752543657751582e-22,  5.440010313101801e-24,
 -2.992871820320873e-26,  8.069144338362465e-02, -7.363791572394156e-04,  7.175176190690525e-06, -6.387134202624767e-08,  5.292213093018473e-10, -4.155294881943817e-12,
  3.126145739506027e-14, -2.270065365822792e-16,  1.599421765352721e-18, -1.097731902325733e-20,  7.361628252276192e-23, -4.835549450398401e-25,  7.190081949754962e-02,
 -1.034782124324672e-03,  1.358940598057159e-05, -1.549245750945677e-07,  1.605825400058791e-09, -1.550557193153257e-11,  1.415226734430401e-13, -1.233061117598913e-15,
  1.032837823908924e-17, -8.361199411258830e-20,  6.568627542367129e-22, -5.023905762026073e-24,  6.171803178540337e-02, -1.319930226163360e-03,  2.244078647561949e-05,
 -3.198794479125472e-07,  4.057330971349589e-09, -4.717882103807656e-11,  5.121714116421304e-13, -5.254846678123528e-15,  5.140113664509258e-17, -4.824804850618218e-19,
  4.367780755829753e-21, -3.828353724015375e-23,  5.108176145264487e-02, -1.536772494222859e-03,  3.305270289026255e-05, -5.784648249346800e-07,  8.828448775400137e-09,
 -1.217214048450795e-10,  1.549129264891322e-12, -1.846297541334767e-14,  2.081869955232607e-16, -2.237936339867260e-18,  2.306892098255010e-20, -2.290683086091548e-22,
  4.081322863274329e-02, -1.650954912644258e-03,  4.411905714095905e-05, -9.335561322545256e-07,  1.691158815555354e-08, -2.730764929446397e-10,  4.028079323501127e-12,
 -5.517283895176173e-14,  7.099086141586571e-16, -8.655041531554195e-18,  1.006470989375614e-19, -1.122079243688162e-21,  3.152284909498738e-02, -1.653098736109909e-03,
  5.401038069439746e-05, -1.363374739067275e-06,  2.897857895708543e-08, -5.423667485892136e-10,  9.184604354521319e-12, -1.432959010308560e-13,  2.086330130383898e-15,
 -2.861830239868704e-17,  3.725599830222111e-19, -4.629073608866176e-21,  2.357491076181313e-02, -1.555821910113403e-03,  6.122594828604266e-05, -1.821801315031962e-06,
  4.497396000695701e-08, -9.668531810656501e-10,  1.864180373587009e-11, -3.287501091736914e-13,  5.377035362141821e-15, -8.241619496751614e-17,  1.193251394118793e-18,
 -1.641960589614454e-20,  1.710360141569984e-02, -1.386030324868573e-03,  6.479327112897325e-05, -2.248000892421833e-06,  6.386453141043217e-08, -1.564258197909533e-09,
  3.408652772917319e-11, -6.748240762687781e-13,  1.231985259103352e-14, -2.097215296179885e-16,  3.357463823879819e-18, -5.088137277275609e-20,  1.206290557551878e-02,
 -1.175849550979552e-03,  6.446728447473787e-05, -2.581979663909904e-06,  8.370327377935749e-08, -2.318452255614956e-09,  5.671288021815687e-11, -1.252587939145595e-12,
  2.537616466501081e-14, -4.771307777347701e-16,  8.401893222036467e-18, -1.395274968182239e-19,  8.290030477452994e-03, -9.550139951170081e-04,  6.069013333400992e-05,
 -2.779924215243638e-06,  1.020287029972286e-07, -3.173689180310058e-09,  8.660132324643573e-11, -2.121548132047713e-12,  4.743782505456073e-14, -9.801593271527711e-16,
  1.889320933674514e-17, -3.422261148826941e-19,  5.565559548237170e-03, -7.462068847619150e-04,  5.437295645518240e-05, -2.823694250117611e-06,  1.164618495217782e-07,
 -4.041704815509078e-09,  1.222995340393936e-10, -3.305091658699620e-12,  8.115194132340164e-14, -1.833794240149992e-15,  3.851728506875841e-17, -7.577096226236493e-19,
  3.660238265695622e-03, -5.634866880412161e-04,  4.660981410127019e-05, -2.721942421136675e-06,  1.252758934223602e-07, -4.820345904607416e-09,  1.608357731278670e-10,
 -4.769907755664951e-12,  1.279855462104554e-13, -3.148541144613278e-15,  7.175152824624924e-17, -1.526596359317248e-18,  2.365050933875480e-03, -4.130332421759514e-04,
  3.842533927393271e-05, -2.503983697003304e-06,  1.277411600377378e-07, -5.417190031770412e-09,  1.982261335909135e-10, -6.419158022614815e-12,  1.873407726748596e-13,
 -4.995343738980963e-15,  1.229963199708596e-16, -2.819047561883670e-18,  1.506117366903830e-03, -2.951308330212212e-04,  3.061440083171243e-05, -2.209879595961645e-06,
  1.241615008459576e-07, -5.769738941416435e-09,  2.303226584109541e-10, -8.104511900307924e-12,  2.560984465025222e-13, -7.369915177284478e-15,  1.952671295627586e-16,
 -4.802555967707470e-18,  9.483785636598180e-04, -2.064381445670980e-04,  2.368369896314264e-05, -1.880551592796603e-06,  1.156462310703035e-07, -5.855896809400069e-09,
  2.537085075020565e-10, -9.654431648392067e-12,  3.288464864045764e-13, -1.017050030098464e-14,  2.888110976027702e-16, -7.593359216026573e-18,  5.924759714902307e-04,
 -1.419386422621214e-04,  1.787201158073032e-05, -1.550566952877887e-06,  1.037426130131729e-07, -5.692943035160356e-09,  2.663477670309345e-10, -1.090942990521665e-11,
  3.987859507984789e-13, -1.319997755293578e-14,  4.001576049112718e-16, -1.120433766351343e-17,  3.684765864669730e-04, -9.631718667408084e-05,  1.321351877060602e-05,
 -1.244543132172544e-06,  9.006538373470108e-08, -5.327524690441472e-09,  2.678229280773800e-10, -1.175280870315703e-11,  4.590378941974702e-13, -1.619440642647501e-14,
  5.220304298917594e-16, -1.550770855081711e-17,  2.289170789774000e-04, -6.476040065141650e-05,  9.612407280501410e-06, -9.767366618542853e-07,  7.601900516966760e-08,
 -4.821492327549013e-09,  2.591628779163374e-10, -1.212822134185610e-11,  5.039345491181374e-13, -1.886998302273627e-14,  6.442546844332113e-16, -2.022841805914939e-17,
  1.425325847018363e-04, -4.330674776845035e-05,  6.908233084766367e-06, -7.526899754375822e-07,  6.264917275308111e-08, -4.238318825601860e-09,  2.423948559035417e-10,
 -1.204118072995295e-11,  5.299227069505535e-13, -2.097391182746731e-14,  7.554248083943059e-16, -2.497413859161146e-17,  8.922154043054049e-05, -2.890470264418832e-05,
  4.923176476265790e-06, -5.717482919536070e-07,  5.061134660508195e-08, -3.633180139313019e-09,  2.200023241385689e-10, -1.154727703702343e-11,  5.358882683671173e-13,
 -2.232460513791227e-14,  8.448380682823807e-16, -2.929480013175200e-17,  5.630522194515240e-05, -1.931557705648170e-05,  3.490654535505841e-06, -4.295638128057343e-07,
  4.021850812389912e-08, -3.047715239050856e-09,  1.944435234696563e-10, -1.073312458935339e-11,  5.229255340294208e-13, -2.283202119719966e-14,  9.041506252979476e-16,
 -3.275473682502891e-17,  3.590224356189703e-05, -1.295638409452279e-05,  2.469045259975436e-06, -3.201080551762760e-07,  3.152650215932819e-08, -2.508896343678179e-09,
  1.678183738545721e-10, -9.696389892111566e-12,  4.937298294795315e-13, -2.249658082754967e-14,  9.283708695401631e-16, -3.499787342317343e-17,  2.316336608148664e-05,
 -8.738505646434954e-06,  1.745453600189272e-06, -2.370466875009738e-07,  2.442459526920645e-08, -2.030660315196265e-09,  1.417024346873748e-10, -8.529499806189682e-12,
  4.518464654395369e-13, -2.139148724276858e-14,  9.160661643965869e-16, -3.579102974685390e-17,  1.512346513924781e-05, -5.928507250641590e-06,  1.233869439471881e-06,
 -1.745352500310227e-07,  1.871228882989366e-08, -1.616872655740325e-09,  1.171192710516935e-10, -7.309138874696998e-12,  4.009756786525973e-13, -1.963643158406042e-14,
  8.689022091740152e-16, -3.503923525613405e-17,  9.973644317213577e-06, -4.039200588455294e-06,  8.708393779342196e-07, -1.275804894649120e-07,  1.415510446430754e-08,
 -1.264520876342029e-09,  9.460245851350945e-11, -6.091509189172250e-12,  3.444539872107561e-13, -1.737051646772712e-14,  7.907777826808519e-16, -3.277575558932948e-17,
  6.608399881613048e-06, -2.749578840302386e-06,  6.105570528084635e-07, -9.212085432805862e-08,  1.051968830595785e-08, -9.664792323028243e-10,  7.429949391340114e-11,
 -4.912056415295925e-12,  2.849498365793855e-13, -1.472995800670091e-14,  6.868440920965596e-16, -2.913530358487261e-17,  4.347571331715986e-06, -1.848438750510984e-06,
  4.203469254742989e-07, -6.495079953185222e-08,  7.592266308512395e-09, -7.135724290265798e-10,  5.608203480714314e-11, -3.787960258046900e-12,  2.243518419146946e-13,
 -1.183322786047484e-14,  5.626384741827782e-16, -2.432066912342224e-17,  2.766832344476594e-06, -1.195792386388927e-06,  2.769158674999520e-07, -4.357453257211369e-08,
  5.185398067857988e-09, -4.959231703482594e-10,  3.964169344200333e-11, -2.721876636527620e-12,  1.637990455510141e-13, -8.773886185521551e-15,  4.234664327035293e-16,
 -1.857154401331977e-17,  1.594347983773950e-06, -6.968646056874342e-07,  1.634151779121127e-07, -2.604062268528541e-08,  3.137463232648585e-09, -3.037076054583079e-10,
  2.456362203649559e-11, -1.705919244489558e-12,  1.038013030752487e-13, -5.620035177071552e-15,  2.740812444506017e-16, -1.214145547322905e-17,  6.478319798744669e-07,
 -2.849280059910428e-07,  6.728309497472249e-08, -1.079710457017019e-08,  1.309861048611733e-09, -1.276497412318265e-10,  1.039187877924798e-11, -7.262985341804402e-13,
  4.446644553539412e-14, -2.421925427916843e-15,  1.187993990193193e-16, -5.292184658758295e-18,  8.924863985651964e-02, -3.372853543181343e-04,  1.344267427477097e-06,
 -5.573232484879120e-09,  2.370344383378778e-11, -1.022816531214651e-13,  4.442660539683037e-16, -1.932951836306370e-18,  8.398680364500488e-21, -3.638594025113662e-23,
  1.570338453552424e-25, -6.749377783193513e-28,  8.527001231840678e-02, -4.638667627340561e-04,  2.986207938974747e-06, -1.929294215918527e-08,  1.207662199908034e-10,
 -7.320248799116163e-13,  4.317502431910309e-15, -2.488794289604905e-17,  1.406867562393770e-19, -7.818470908726792e-22,  4.279930394959034e-24, -2.311297461189181e-26,
  7.785607056652072e-02, -6.819056854584688e-04,  6.456909221612776e-06, -5.602994485303935e-08,  4.531317219076355e-10, -3.475856406419260e-12,  2.556622920280648e-14,
 -1.816187824844440e-16,  1.252489822468000e-18, -8.417584111072044e-21,  5.529825443664045e-23, -3.559406647775460e-25,  6.796793423439992e-02, -9.330888967340236e-04,
  1.187480390096535e-05, -1.315388153752305e-07,  1.327064662251610e-09, -1.248859900832511e-11,  1.112053642127762e-13, -9.460451805527550e-16,  7.742487456659419e-18,
 -6.127569654593790e-20,  4.708507900877055e-22, -3.523973355102905e-24,  5.677452127348594e-02, -1.154722161989189e-03,  1.896263319899178e-05, -2.618897687195403e-07,
  3.225654318251605e-09, -3.648138960119397e-11,  3.856748191737477e-13, -3.857238380332164e-15,  3.680917185415546e-17, -3.373137432239649e-19,  2.982982743103415e-21,
 -2.555483004009392e-23,  4.542271312004872e-02, -1.297888557700849e-03,  2.688441385174849e-05, -4.548281229563653e-07,  6.727534084685125e-09, -9.006158952492974e-11,
  1.114486051520598e-12, -1.292995118375040e-14,  1.420589570635359e-16, -1.489136172722765e-18,  1.497932667933553e-20, -1.452384431366579e-22,  3.485035045221235e-02,
 -1.338596580409157e-03,  3.437534863010130e-05, -7.018928389011228e-07,  1.230380437603772e-08, -1.926359716040478e-10,  2.759464316516470e-12, -3.675133849466112e-14,
  4.602877299700617e-16, -5.467237724272923e-18,  6.198905478749955e-20, -6.743086757930718e-22,  2.568113500283149e-02, -1.279328350999623e-03,  4.010923573583470e-05,
 -9.757591348043838e-07,  2.004584866657711e-08, -3.633976959799840e-10,  5.970520941273968e-12, -9.049749900672804e-14,  1.281539287860489e-15, -1.711453120952363e-17,
  2.171016122828002e-19, -2.630518896435025e-21,  1.820829537950294e-02, -1.142553783420364e-03,  4.311467260042965e-05, -1.235417576809736e-06,  2.945527231635068e-08,
 -6.129106149507207e-10,  1.145798259410507e-11, -1.961943078857911e-13,  3.119506320389083e-15, -4.652964702018876e-17,  6.561766028915252e-19, -8.801989314494794e-21,
  1.244704201586249e-02, -9.603348620082765e-04,  4.304402426405340e-05, -1.437704746737185e-06,  3.943331923032289e-08, -9.345213315973217e-10,  1.973791302931805e-11,
 -3.792967978906629e-13,  6.729825160958454e-15, -1.114603179392337e-16,  1.737729732031616e-18, -2.566837824919962e-20,  8.222789629610079e-03, -7.643757243831707e-04,
  4.019940957514326e-05, -1.550182452097559e-06,  4.851890891641465e-08, -1.300271128067427e-09,  3.082774996293610e-11, -6.608899867378934e-13,  1.301232927911835e-14,
 -2.380420168538030e-16,  4.082307463562031e-18, -6.608265951854059e-20,  5.263376670503935e-03, -5.793568520631325e-04,  3.534839292374102e-05, -1.559809712407295e-06,
  5.529261094946185e-08, -1.664599162936210e-09,  4.403633436829394e-11, -1.047395245846064e-12,  2.276667707960026e-14, -4.577937154293815e-16,  8.596199047112207e-18,
 -1.518218608458069e-19,  3.273857712017593e-03, -4.203274002036379e-04,  2.944325196625682e-05, -1.474372193023379e-06,  5.877549756636430e-08, -1.975369664021432e-09,
  5.798200401007470e-11, -1.522124132324061e-12,  3.634965787089596e-14, -7.997660101274799e-16,  1.637216343217231e-17, -3.141844658121763e-19,  1.985103850093472e-03,
 -2.933464508666558e-04,  2.336432303734334e-05, -1.317306712737817e-06,  5.866164556112078e-08, -2.187943562179568e-09,  7.087434514834959e-11, -2.043403371113789e-12,
  5.336577581629640e-14, -1.279185712860901e-15,  2.843130946161757e-17, -5.905003875602187e-19,  1.177414037914671e-03, -1.978912930626752e-04,  1.776096036043320e-05,
 -1.119148160249481e-06,  5.531559146308315e-08, -2.276575540044955e-09,  8.096448670235889e-11, -2.551500505367448e-12,  7.254892698559324e-14, -1.886654641629760e-15,
  4.534750031390065e-17, -1.015493306324955e-18,  6.856494273510025e-04, -1.296614996742945e-04,  1.300357818840479e-05, -9.092887455576858e-07,  4.957648749572278e-08,
 -2.239060278446622e-09,  8.698685170754300e-11, -2.982450243420383e-12,  9.192883002662040e-14, -2.583037306917579e-15,  6.688189738160157e-17, -1.608897275868405e-18,
  3.935556023316244e-04, -8.291318590405360e-05,  9.218171408016770e-06, -7.104976132012099e-07,  4.247746451200497e-08, -2.093959916470530e-09,  8.842869355457599e-11,
 -3.283598494458805e-12,  1.092492522064627e-13, -3.303451979287766e-15,  9.179219354579250e-17, -2.363410428612362e-18,  2.235786376803620e-04, -5.199547546594147e-05,
  6.360492082864241e-06, -5.368546944196888e-07,  3.499061908506160e-08, -1.872796120603071e-09,  8.555480544201106e-11, -3.425138703513825e-12,  1.224892713198048e-13,
 -3.969923617992849e-15,  1.179318470012400e-16, -3.238194225632504e-18,  1.262491203979188e-04, -3.213262413886762e-05,  4.293942813594729e-06, -3.943913315603328e-07,
  2.786446160305140e-08, -1.610863768614767e-09,  7.922289322977083e-11, -3.404151151209123e-12,  1.302997631137667e-13, -4.508419896091546e-15,  1.426367828550114e-16,
 -4.161605422176005e-18,  7.116893800068310e-05, -1.966384397026469e-05,  2.850779136877688e-06, -2.831819196203973e-07,  2.156675053134937e-08, -1.339739716702389e-09,
  7.059342718593324e-11, -3.241086912753374e-12,  1.322192075817610e-13, -4.864307550750549e-15,  1.632744490558509e-16, -5.043221815767481e-18,  4.022593579798265e-05,
 -1.197296649757740e-05,  1.870589115483999e-06, -1.997511119915682e-07,  1.630784330264870e-08, -1.082990935710106e-09,  6.084561118668526e-11, -2.971354134149782e-12,
  1.286360600859371e-13, -5.011430745433197e-15,  1.777690935406109e-16, -5.791407720107656e-18,  2.289360551453114e-05, -7.286861210914334e-06,  1.218910382214008e-06,
 -1.390935598963873e-07,  1.210619775930153e-08, -8.550477935474046e-10,  5.097412246213898e-11, -2.635616875156988e-12,  1.205600658892507e-13, -4.953036970789708e-15,
  1.849432448670450e-16, -6.330661225792372e-18,  1.317150378694464e-05, -4.451867113943336e-06,  7.922493779899299e-07, -9.604221696932632e-08,  8.862669199516410e-09,
 -6.622949194235961e-10,  4.169059610438181e-11, -2.271735270273374e-12,  1.093117027127877e-13, -4.715890987864891e-15,  1.846033529244999e-16, -6.613610996822193e-18,
  7.687393018819411e-06, -2.740556664599935e-06,  5.156181287251037e-07, -6.601589276728575e-08,  6.423254361614042e-09, -5.052161903443331e-10,  3.341454277101335e-11,
 -1.909798312454108e-12,  9.623217012480275e-14, -4.340749521052415e-15,  1.773955670531110e-16, -6.625101871194257e-18,  4.563615133146240e-06, -1.704923664324435e-06,
  3.370404963470876e-07, -4.530889013492399e-08,  4.622581836630608e-09, -3.806699431429511e-10,  2.632024772826271e-11, -1.570294526361219e-12,  8.247673101426588e-14,
 -3.872546624195312e-15,  1.645219175920901e-16, -6.378816941422520e-18,  2.759542274297396e-06, -1.073627597967811e-06,  2.216486344237859e-07, -3.110339226287230e-08,
  3.308845694571027e-09, -2.837662289569071e-10,  2.040615003851250e-11, -1.264612105017397e-12,  6.890878204627267e-14, -3.352643496461918e-15,  1.474220654650307e-16,
 -5.908993901915716e-18,  1.698560187777656e-06, -6.840604080539445e-07,  1.465913681046498e-07, -2.134752316644550e-08,  2.354704220743126e-09, -2.091649467911748e-10,
  1.556278142425130e-11, -9.968115784073066e-13,  5.607922910553702e-14, -2.814120493823753e-15,  1.275020221009838e-16, -5.260457719392174e-18,  1.059818069202877e-06,
 -4.392381981964024e-07,  9.711840906533034e-08, -1.459095910204733e-08,  1.659294612448709e-09, -1.518315515378113e-10,  1.162681949441006e-11, -7.657738794920620e-13,
  4.426118496968144e-14, -2.279959354744781e-15,  1.059513159506634e-16, -4.479646400044105e-18,  6.631522371493386e-07, -2.812337447021668e-07,  6.377551929111018e-08,
 -9.826902205395108e-09,  1.145555760155294e-09, -1.073814784545680e-10,  8.417778849717940e-12, -5.671496495477812e-13,  3.351010808990594e-14, -1.763346993400612e-15,
  8.365379107856488e-17, -3.608178697050886e-18,  4.057877088408163e-07, -1.751172500113410e-07,  4.048626036660294e-08, -6.360308849050525e-09,  7.556613939947073e-10,
 -7.215688445813884e-11,  5.759089175816494e-12, -3.948466922947353e-13,  2.372738416316997e-14, -1.269195119318801e-15,  6.117474501395978e-17, -2.679401569241003e-18,
  2.274489246577427e-07, -9.934086103486672e-08,  2.327623753607534e-08, -3.706042964393589e-09,  4.461512384113804e-10, -4.315306315419388e-11,  3.487464782421398e-12,
 -2.420173663164007e-13,  1.471535106896853e-14, -7.961512146878485e-16,  3.880013735106052e-17, -1.717637115389253e-18,  9.099314487351590e-08, -4.000734503154851e-08,
  9.443879907196870e-09, -1.514918607478939e-09,  1.837155477425997e-10, -1.789705988968615e-11,  1.456463886281305e-12, -1.017578003751205e-13,  6.227803457641760e-15,
 -3.390909687721246e-16,  1.662745047079082e-17, -7.404670213848979e-19,  8.792059205420028e-02, -3.267924345143521e-04,  1.279598489957710e-06, -5.209780995506493e-09,
  2.176020266133541e-11, -9.223953840888712e-14,  3.937174089592121e-16, -1.683995801255099e-18,  7.195049183477262e-21, -3.065990728778362e-23,  1.301733592877018e-25,
 -5.505025462714605e-28,  8.346090328282574e-02, -4.408713892742523e-04,  2.765820664836479e-06, -1.747240469949286e-08,  1.071080000623563e-10, -6.362833205142993e-13,
  3.679660878972985e-15, -2.080515926881325e-17,  1.153917307751300e-19, -6.293616253565649e-22,  3.382023453822234e-24, -1.793296047464052e-26,  7.522766739614498e-02,
 -6.328216721799092e-04,  5.825859919551120e-06, -4.930428693532512e-08,  3.893608489669013e-10, -2.919027277923755e-12,  2.099933786296739e-14, -1.459895675321394e-16,
  9.857683728500989e-19, -6.489533614538061e-21,  4.177576551815001e-23, -2.635852908850443e-25,  6.441606426018601e-02, -8.440614503699229e-04,  1.041594012965882e-05,
 -1.121674723649473e-07,  1.101972831423810e-09, -1.011146005661381e-11,  8.787736973746655e-14, -7.302282549516386e-16,  5.841283102562233e-18, -4.521060203326266e-20,
  3.399157296271101e-22, -2.490259000069428e-24,  5.244030058149643e-02, -1.014766784654767e-03,  1.610707529426838e-05, -2.156478642743217e-07,  2.580483374357762e-09,
 -2.839857246776841e-11,  2.924893868452214e-13, -2.852640797660414e-15,  2.656781004203205e-17, -2.377710781762225e-19,  2.054748713429065e-21, -1.721048274694270e-23,
  4.062915665408064e-02, -1.102943134880522e-03,  2.201727119514204e-05, -3.602585895620083e-07,  5.166912533070758e-09, -6.719039245093095e-11,  8.087879686416949e-13,
 -9.137602646455962e-15,  9.785464809083944e-17, -1.000617732777815e-18,  9.825309849064266e-21, -9.305124130487209e-23,  2.999699193820072e-02, -1.094209064345791e-03,
  2.701742736412193e-05, -5.325774828997646e-07,  9.037892450987150e-09, -1.372589641623706e-10,  1.910149970094888e-12, -2.474526853140172e-14,  3.017682907039064e-16,
 -3.493187243421880e-18,  3.862907454262671e-20, -4.101125390856938e-22,  2.113843991071631e-02, -1.000344177301091e-03,  3.010773646678243e-05, -7.061685365058109e-07,
  1.402730649805448e-08, -2.463928467778966e-10,  3.928851406462138e-12, -5.787311851787098e-14,  7.973445292387335e-16, -1.036982719587482e-17,  1.282119500911925e-19,
 -1.515284069868355e-21,  1.424421770268530e-02, -8.497676768387747e-04,  3.075659053504208e-05, -8.489407173412855e-07,  1.955434044919080e-08, -3.939439759541165e-10,
  7.142417752450070e-12, -1.187772456157830e-13,  1.836361219080336e-15, -2.666077884708660e-17,  3.662908206878495e-19, -4.790713923895827e-21,  9.198601732383814e-03,
 -6.755361863268796e-04,  2.903484761144563e-05, -9.337730756482904e-07,  2.473136588524179e-08, -5.671976436008217e-10,  1.161354558187035e-11, -2.166654914436610e-13,
  3.736770339028305e-15, -6.022262194389221e-17,  9.144887789697186e-19, -1.316805672265988e-20,  5.706983559629523e-03, -5.057354211531820e-04,  2.551171872046624e-05,
 -9.472604097104381e-07,  2.862651313883867e-08, -7.423295459636593e-10,  1.705959672870059e-11, -3.550225466036133e-13,  6.794022598917852e-15, -1.209336500261297e-16,
  2.019961740957952e-18, -3.187515349027414e-20,  3.411290553951729e-03, -3.586022009992210e-04,  2.100207863080890e-05, -8.927045677484027e-07,  3.056240179099721e-08,
 -8.904710628895293e-10,  2.283796700476461e-11, -5.273819874066946e-13,  1.114370507399026e-14, -2.180699521244662e-16,  3.988933539794103e-18, -6.869104772712990e-20,
  1.970740259525418e-03, -2.421390513034996e-04,  1.629984148598824e-05, -7.868418115316594e-07,  3.031255079245853e-08, -9.864700054525571e-10,  2.808412654117905e-11,
 -7.160927154527000e-13,  1.663072647621521e-14, -3.562408057905689e-16,  7.106975535112423e-18, -1.330316655269485e-19,  1.104226761014624e-03, -1.565160092728204e-04,
  1.199764472044300e-05, -6.528294334554091e-07,  2.811990548840904e-08, -1.016375197747672e-09,  3.195621964880093e-11, -8.955025774874227e-13,  2.275873909518043e-14,
 -5.314477361682808e-16,  1.151828263600727e-17, -2.334886266086661e-19,  6.023848477255742e-04, -9.735522840157212e-05,  8.424390520348849e-06, -5.130396476915745e-07,
  2.455770458800282e-08, -9.805092410484071e-10,  3.388000941741604e-11, -1.038708397461992e-12,  2.876628544401991e-14, -7.293800752631293e-16,  1.710939264172915e-17,
 -3.742494253745933e-19,  3.212864791418402e-04, -5.858035616608646e-05,  5.675844869480096e-06, -3.842391319745692e-07,  2.031891102101669e-08, -8.914650431662352e-10,
  3.369071271640801e-11, -1.125080312425446e-12,  3.381392372493881e-14, -9.273456176881930e-16,  2.345749129175315e-17, -5.517395883645934e-19,  1.682947191172727e-04,
 -3.428203577539057e-05,  3.690606765869819e-06, -2.759265733675892e-07,  1.602758809403260e-08, -7.687399937168071e-10,  3.162717421618513e-11, -1.145435131650519e-12,
  3.720843542565143e-14, -1.099517694973129e-15,  2.988310602195320e-17, -7.531808437204302e-19,  8.699524608691620e-05, -1.961949625335754e-05,  2.329625384938554e-06,
 -1.911461959075259e-07,  1.212789651508881e-08, -6.327107781065122e-10,  2.820606080224985e-11, -1.103100134027173e-12,  3.857345970686581e-14, -1.223507821796886e-15,
  3.559918663119884e-17, -9.581432202892124e-19,  4.460338405429093e-05, -1.104219191858297e-05,  1.436033516435092e-06, -1.285164872976534e-07,  8.857913034477685e-09,
 -5.001248915241463e-10,  2.404685978866000e-11, -1.011151079138787e-12,  3.790779506676359e-14, -1.285688510611845e-15,  3.990180637333164e-17, -1.142831792889379e-18,
  2.280208046245164e-05, -6.146822381572380e-06,  8.695945072775335e-07, -8.437402395500607e-08,  6.282953977346765e-09, -3.819976220514009e-10,  1.971792941056183e-11,
 -8.875871200230926e-13,  3.552855996024841e-14, -1.283459032827050e-15,  4.233023352957345e-17, -1.285572699269214e-18,  1.168563439151545e-05, -3.403858232100516e-06,
  5.203768545346876e-07, -5.441579338260389e-08,  4.354117253144254e-09, -2.836349014545726e-10,  1.564367119613689e-11, -7.505153715170113e-13,  3.194210416644645e-14,
 -1.224160333338364e-15,  4.274357662025222e-17, -1.371491975702913e-18,  6.035813194356882e-06, -1.885764782893381e-06,  3.095246529201405e-07, -3.467792080653135e-08,
  2.965379735914533e-09, -2.059182132137299e-10,  1.207754372697996e-11, -6.147693117972611e-13,  2.770094323883489e-14, -1.121678358917560e-15,  4.130198711566210e-17,
 -1.394903300867362e-18,  3.158531364129091e-06, -1.050934412763777e-06,  1.840202554829412e-07, -2.195911233727691e-08,  1.995764791961334e-09, -1.469737761006704e-10,
  9.122517679385103e-12, -4.904060918169074e-13,  2.329203344861702e-14, -9.923299473121915e-16,  3.837788464535882e-17, -1.359019275081246e-18,  1.682618241471644e-06,
 -5.921388831556037e-07,  1.099115601005614e-07, -1.388729475749378e-08,  1.334038141397853e-09, -1.036421971538262e-10,  6.773930794752198e-12, -3.827638400775646e-13,
  1.907591016791864e-14, -8.513842723974495e-16,  3.444015050271425e-17, -1.273626539723413e-18,  9.162239989697867e-07, -3.387572009701378e-07,  6.623707238566243e-08,
 -8.808833996782868e-09,  8.893642415279086e-10, -7.250399503198323e-11,  4.964552429178420e-12, -2.934283221522075e-13,  1.527323358690938e-14, -7.109123628185230e-16,
  2.995005524828958e-17, -1.151872579886558e-18,  5.113964072060591e-07, -1.973690292765667e-07,  4.039752714127840e-08, -5.620958152107689e-09,  5.930583681738923e-10,
 -5.045678605002360e-11,  3.600637619130777e-12, -2.214900509477209e-13,  1.198298531348663e-14, -5.790042451943527e-16,  2.529102085108438e-17, -1.007243242205934e-18,
  2.928046664160381e-07, -1.172185643862176e-07,  2.495785679998278e-08, -3.611349090178386e-09,  3.958723963073915e-10, -3.495354051851689e-11,  2.585603972066199e-12,
 -1.646828630322079e-13,  9.214746736143797e-15, -4.599943080683513e-16,  2.073644523110676e-17, -8.513914502877680e-19,  1.714883850734771e-07, -7.077544458567713e-08,
  1.557752012174919e-08, -2.329735619935210e-09,  2.637673144269144e-10, -2.403218030649187e-11,  1.832682779881307e-12, -1.202218492983570e-13,  6.921849836009816e-15,
 -3.552224075667047e-16,  1.644785998350275e-17, -6.930012899070213e-19,  1.017625842073964e-07, -4.303876246732385e-08,  9.730736923143097e-09, -1.494897033593370e-09,
  1.737573591872101e-10, -1.624148123529949e-11,  1.269702889943645e-12, -8.531978500587894e-14,  5.028214448125101e-15, -2.639361539481963e-16,  1.249124851107348e-17,
 -5.375325506467793e-19,  5.972803067835660e-08, -2.573478498388254e-08,  5.939325952480436e-09, -9.314189863630214e-10,  1.104706708094612e-10, -1.053102628337422e-11,
  8.391539652822763e-13, -5.744248864607683e-14,  3.446618001808793e-15, -1.840904768454830e-16,  8.860437434723931e-18, -3.875451252866327e-19,  3.250727150063893e-08,
 -1.418674404633916e-08,  3.321129820298572e-09, -5.283232778843592e-10,  6.354683346791841e-11, -6.141222482421033e-12,  4.959000581648723e-13, -3.438602153466902e-14,
  2.089137252005087e-15, -1.129438331757160e-16,  5.500222351358623e-18, -2.433147496075322e-19,  1.279110709009520e-08, -5.621998784236251e-09,  1.326581294500547e-09,
 -2.127172417570695e-10,  2.578639484989493e-11, -2.511078596603799e-12,  2.042750262103688e-13, -1.426669638145806e-14,  8.728387510862230e-16, -4.750748029518313e-17,
  2.328741487241600e-18, -1.036703922973120e-19,  8.663350812380324e-02, -3.167999342536110e-04,  1.219110839729000e-06, -4.875878247845613e-09,  2.000621502925330e-11,
 -8.333111096549705e-14,  3.496298767928480e-16, -1.470454885606605e-18,  6.179465210169413e-21, -2.590638813128573e-23,  1.082306478512889e-25, -4.504616731415765e-28,
  8.174038284607479e-02, -4.195553029354297e-04,  2.566029248664851e-06, -1.585587456941991e-08,  9.522033704491968e-11, -5.545647748556417e-13,  3.145583392072364e-15,
 -1.745049447558538e-17,  9.499105608122547e-20, -5.086200011158261e-22,  2.683836540813502e-24, -1.397686310761757e-26,  7.278599122115731e-02, -5.884797581094091e-04,
  5.269745612113338e-06, -4.351550292591027e-08,  3.357065864138758e-10, -2.460736000142172e-12,  1.732030726731077e-14, -1.178818187374818e-16,  7.796258371960378e-19,
 -5.029116386267980e-21,  3.173412550279748e-23, -1.963300161122476e-25,  6.119835256458944e-02, -7.658328893525577e-04,  9.169399363313044e-06, -9.604573872245638e-08,
  9.192811468582311e-10, -8.228052904743032e-12,  6.982073142572185e-14, -5.669245073907465e-16,  4.434166018818502e-18, -3.357513249397635e-20,  2.470746930196575e-22,
 -1.772408600800075e-24,  4.862349436979198e-02, -8.956002043111176e-04,  1.374944949175123e-05, -1.785480204632504e-07,  2.076704478266585e-09, -2.224862198615878e-11,
  2.233360684591062e-13, -2.124935036069098e-15,  1.932157975823262e-17, -1.689362085729820e-19,  1.427086313265943e-21, -1.169056171905687e-23,  3.654413837966601e-02,
 -9.427876621822817e-04,  1.814903914306946e-05, -2.873648173852396e-07,  3.998186452383769e-09, -5.052663174605621e-11,  5.918563448221899e-13, -6.514099501649509e-15,
  6.802004072914113e-17, -6.787225448007454e-19,  6.507751764110350e-21, -6.021814376998599e-23,  2.601517316195799e-02, -9.013686033952079e-04,  2.141101333841361e-05,
 -4.076591354439469e-07,  6.700209446460571e-09, -9.874492919754492e-11,  1.335507393714830e-12, -1.683458339221083e-14,  1.999654368238778e-16, -2.256579926486045e-18,
  2.434551970973136e-20, -2.523344527735579e-22,  1.757004971811396e-02, -7.899067188412189e-04,  2.283292213186196e-05, -5.165344398675590e-07,  9.924673883123160e-09,
 -1.689751176469236e-10,  2.615860103360235e-12, -3.745850875872865e-14,  5.022534238774610e-16, -6.363012581808140e-18,  7.669971529390705e-20, -8.844127449565914e-22,
  1.127952226584412e-02, -6.396887759834120e-04,  2.221386018755785e-05, -5.908103266580776e-07,  1.315114681686931e-08, -2.565899149860656e-10,  4.513056417501551e-12,
 -7.290916863714307e-14,  1.096324791507470e-15, -1.549619807005563e-17,  2.074602350018816e-19, -2.646132318553934e-21,  6.898520508023119e-03, -4.821246672722602e-04,
  1.987338492814935e-05, -6.155217189766614e-07,  1.574543499768740e-08, -3.495363157119904e-10,  6.939509280297631e-12, -1.257140765142370e-13,  2.107905153624760e-15,
 -3.306241683934393e-17,  4.890787034088182e-19, -6.866144131251235e-21,  4.029906081380891e-03, -3.403227197626097e-04,  1.646658813091190e-05, -5.887475722609915e-07,
  1.718076195696125e-08, -4.311459889612319e-10,  9.605266065410138e-12, -1.940635416276765e-13,  3.609984016548771e-15, -6.253010162146343e-17,  1.017343965453354e-18,
 -1.565090560738545e-20,  2.255237415115733e-03, -2.263047250723014e-04,  1.272021506366725e-05, -5.207796545300511e-07,  1.721904620755791e-08, -4.855481192240211e-10,
  1.207290700455328e-11, -2.706797411336809e-13,  5.560106712649195e-15, -1.058893627730124e-16,  1.886875066565678e-18, -3.168147629118578e-20,  1.213107794820431e-03,
 -1.425551434229092e-04,  9.218983085692253e-06, -4.289242988241675e-07,  1.596607906570198e-08, -5.030605763171788e-10,  1.388958714711394e-11, -3.439648115536760e-13,
  7.768110925290367e-15, -1.619895122636640e-16,  3.149168122635052e-18, -5.749460015830616e-20,  6.295669960981878e-04, -8.553321980208864e-05,  6.307210462350005e-06,
 -3.311033712268758e-07,  1.379134875506006e-08, -4.829541616868067e-10,  1.473561651827225e-11, -4.012794349953216e-13,  9.922638990610615e-15, -2.256894555111461e-16,
  4.769085437691716e-18, -9.434134138374838e-20,  3.165380243806255e-04, -4.915210039485125e-05,  4.098318376283450e-06, -2.411053672975169e-07,  1.117249788593957e-08,
 -4.326082086445938e-10,  1.451884406707960e-11, -4.329205018833820e-13,  1.167449524725360e-14, -2.885413220196535e-16,  6.603957261544627e-18, -1.410693956599899e-19,
  1.548963008445820e-04, -2.720537316518591e-05,  2.544813830559543e-06, -1.666889254325294e-07,  8.544990345619320e-09, -3.640273455601306e-10,  1.337765441152590e-11,
 -4.349529076162340e-13,  1.274187308214102e-14, -3.409573719629514e-16,  8.422913059552060e-18, -1.936480819786380e-19,  7.414146681404439e-05, -1.458840961656045e-05,
  1.519513247225960e-06, -1.101241597898690e-07,  6.211181229326842e-09, -2.897011154931188e-10,  1.160564654674087e-11, -4.097603457403451e-13,  1.299010481326765e-14,
 -3.749765112284020e-16,  9.964166584429362e-18, -2.457475141386160e-19,  3.490106919801105e-05, -7.624981011930193e-06,  8.780799348392244e-07, -6.998370745698212e-08,
  4.319610752847314e-09, -2.195196831062428e-10,  9.544260425083542e-12, -3.644333921640802e-13,  1.245442751923849e-14, -3.864253320662196e-16,  1.100734721038572e-17,
 -2.902680660456478e-19,  1.625146897290126e-05, -3.909220820267100e-06,  4.943127300179649e-07, -4.306893224824211e-08,  2.893759183803794e-09, -1.594592933702385e-10,
  7.490998298094787e-12, -3.080604422396805e-13,  1.130523497401925e-14, -3.756464659334926e-16,  1.143042942280588e-17, -3.212173440407645e-19,  7.531584728529823e-06,
 -1.978805662384258e-06,  2.729190308028155e-07, -2.584321585154865e-08,  1.880172493689106e-09, -1.117994633275922e-10,  5.649390118721207e-12, -2.491702314924963e-13,
  9.780522775905562e-15, -3.467320859063192e-16,  1.123040257078389e-17, -3.351729114369061e-19,  3.496178108319881e-06, -9.956179211908252e-07,  1.488007151673876e-07,
 -1.522426146376354e-08,  1.192981927177626e-09, -7.617313916108178e-11,  4.121468651133410e-12, -1.941252905299472e-13,  8.117269828409175e-15, -3.058454850522841e-16,
  1.050572509267490e-17, -3.318234574026444e-19,  1.636237343314155e-06, -5.013091673033793e-07,  8.066774445430657e-08, -8.865785044490726e-09,  7.442714819589805e-10,
 -5.077600803120541e-11,  2.927964957626236e-12, -1.466275163758058e-13,  6.504117382838941e-15, -2.594239606080018e-16,  9.414609905576079e-18, -3.135470863391164e-19,
  7.770709877056588e-07, -2.543039016652606e-07,  4.377727893798671e-08, -5.138114577687649e-09,  4.595869167290952e-10, -3.333012866415706e-11,  2.038504091123220e-12,
 -1.080439747484057e-13,  5.062142575462072e-15, -2.128562946431057e-16,  8.128745423819752e-18, -2.843721476186248e-19,  3.768162838190689e-07, -1.308003175329693e-07,
  2.393478864693859e-08, -2.982256649557860e-09,  2.826463627546139e-10, -2.167591044427577e-11,  1.399139497918895e-12, -7.811529454744212e-14,  3.848316706458172e-15,
 -1.698544456985350e-16,  6.797634236777421e-18, -2.488008839363675e-19,  1.876148675225818e-07, -6.860540912517295e-08,  1.325928462170545e-08, -1.743328045665489e-09,
  1.740762190954489e-10, -1.404080095270181e-11,  9.515919094385335e-13, -5.569017449401026e-14,  2.871254695788443e-15, -1.324255719735575e-16,  5.529833886248584e-18,
 -2.108736072985328e-19,  9.633266696772191e-08, -3.686093472351403e-08,  7.475988990681787e-09, -1.030878538809458e-09,  1.078185384105675e-10, -9.095869480183357e-12,
  6.438191985736446e-13, -3.929405628394945e-14,  2.109839514862416e-15, -1.012036831991096e-16,  4.389592859608947e-18, -1.736402442546252e-19,  5.112764301060994e-08,
 -2.033757370981767e-08,  4.300509903496384e-09, -6.180497245634543e-10,  6.730255741516195e-11, -5.904512989646883e-12,  4.340782577767997e-13, -2.748290846007773e-14,
  1.528967179609064e-15, -7.590255893502742e-17,  3.403396353237781e-18, -1.390172599378218e-19,  2.801250068085759e-08, -1.150930973163344e-08,  2.520821826361659e-09,
 -3.751823580340711e-10,  4.227681675876768e-11, -3.834284749084453e-12,  2.911087460134830e-13, -1.901492103420909e-14,  1.090287830908228e-15, -5.573008507556774e-17,
  2.570568704374860e-18, -1.079061480233472e-19,  1.571610141359972e-08, -6.627486279076906e-09,  1.493629204236708e-09, -2.287290909163567e-10,  2.650323325198896e-11,
 -2.469830764435540e-12,  1.925183361392785e-13, -1.290002929875325e-14,  7.581712696779763e-16, -3.969221736559754e-17,  1.873717873410740e-18, -8.043319978978410e-20,
  8.825226044723602e-09, -3.796048764154109e-09,  8.744466294590705e-10, -1.368756788414801e-10,  1.620430365458687e-11, -1.541978990987773e-12,  1.226584564935471e-13,
 -8.382258753448875e-15,  5.021303187732498e-16, -2.677768090505988e-17,  1.286877697350651e-18, -5.620409906360363e-20,  4.655037274460184e-09, -2.029837318422375e-09,
  4.747424619084505e-10, -7.545079977606794e-11,  9.066859133228327e-12, -8.754399010087847e-13,  7.062928505079537e-14, -4.893307655122226e-15,  2.970490750014492e-16,
 -1.604629828267865e-17,  7.808252734980301e-19, -3.451549642811867e-20,  1.799606252433502e-09, -7.906866835015629e-10,  1.864970213531895e-10, -2.989252846975914e-11,
  3.622213335719163e-12, -3.525899542023711e-13,  2.867176374743745e-14, -2.001683966261351e-15,  1.224172330209686e-16, -6.660555494901876e-18,  3.263721245485583e-19,
 -1.452424723306902e-20,  8.538545111251707e-02, -3.072757717703162e-04,  1.162467338395797e-06, -4.568669475242181e-09,  1.842028091948028e-11, -7.541255462702879e-14,
  3.110910750208203e-16, -1.286835784520900e-18,  5.320214622601774e-21, -2.194855876359901e-23,  9.024815473959642e-26, -3.697583672320401e-28,  8.010204854169910e-02,
 -3.997630680832548e-04,  2.384546740876444e-06, -1.441713785853236e-08,  8.484610984352387e-11, -4.846068586077971e-13,  2.696913926927536e-15, -1.468417135724589e-17,
  7.847366078213909e-20, -4.126144211976158e-22,  2.138526364376866e-24, -1.094120723529631e-26,  7.051320509859108e-02, -5.483228241152801e-04,  4.778233535761639e-06,
 -3.851640319781701e-08,  2.903952745514232e-10, -2.081996719970784e-12,  1.434332465331816e-14, -9.560151557994488e-17,  6.194885554691732e-19, -3.916908057114227e-21,
  2.423458207275826e-23, -1.470579722276214e-25,  5.827476914958600e-02, -6.968497862232079e-04,  8.099951814261911e-06, -8.256780491808937e-08,  7.702696426174963e-10,
 -6.727860281452905e-12,  5.576440742406521e-14, -4.426057059158994e-16,  3.386048891156975e-18, -2.509104560825258e-20,  1.807795215884813e-22, -1.270230338473465e-24,
  4.524827022992345e-02, -7.936420711099908e-04,  1.179244375963919e-05, -1.486083387802659e-07,  1.680851935909749e-09, -1.753791682496164e-11,  1.716527563206288e-13,
 -1.593867204850211e-15,  1.415446968252196e-17, -1.209481791542302e-19,  9.990722534587805e-22, -8.006988424690304e-24,  3.304297264049826e-02, -8.103734306938270e-04,
  1.505348026860132e-05, -2.307641761332505e-07,  3.116106866681468e-09, -3.828575766730356e-11,  4.365915569961644e-13, -4.682922360812627e-15,  4.769652270494103e-17,
 -4.645759850141095e-19,  4.351059684257844e-21, -3.934996918800847e-23,  2.272368120466165e-02, -7.479652020774238e-04,  1.710238479248584e-05, -3.146616269593366e-07,
  5.011093073685277e-09, -7.169494097059869e-11,  9.427348904373549e-13, -1.156728876322664e-14,  1.338754086133904e-16, -1.473267639184772e-18,  1.551158628940508e-20,
 -1.570023593575989e-22,  1.473999133344862e-02, -6.295738107695769e-04,  1.748590212503596e-05, -3.816910421762463e-07,  7.096581434482559e-09, -1.171566178799645e-10,
  1.761412980051933e-12, -2.452793933910742e-14,  3.201604577532471e-16, -3.952258291998650e-18,  4.645866814361045e-20, -5.227977326085885e-22,  9.035867455721099e-03,
 -4.871146379231847e-04,  1.623462199719737e-05, -4.161901919663226e-07,  8.955616534597748e-09, -1.692731098234551e-10,  2.889110114128660e-12, -4.535405334835685e-14,
  6.634614308026251e-16, -9.132222467984373e-18,  1.191626617724476e-19, -1.482555411402347e-21,  5.246629547049422e-03, -3.488778056908496e-04,  1.379433635220925e-05,
 -4.115439819636371e-07,  1.017024529460298e-08, -2.185839538791786e-10,  4.208765706611811e-12, -7.405071215509006e-14,  1.207371263423762e-15, -1.843416243370943e-17,
  2.656847994784984e-19, -3.637142935395869e-21,  2.893161552618564e-03, -2.327590001943787e-04,  1.080245104268239e-05, -3.719502295235232e-07,  1.048253151402286e-08,
 -2.546005624804281e-10,  5.499395503469775e-12, -1.078828482110837e-13,  1.950996921044867e-15, -3.288919969120484e-17,  5.212670449009860e-19, -7.818728967383885e-21,
  1.519716602149398e-03, -1.455040656284687e-04,  7.848162628232880e-06, -3.094751794576284e-07,  9.882340216472896e-09, -2.697033272406374e-10,  6.501658284432100e-12,
 -1.415342373054752e-13,  2.826369523624584e-15, -5.238618990549318e-17,  9.093923100151632e-19, -1.488825727228734e-20,  7.630461418250753e-04, -8.571027180655258e-05,
  5.323419011945503e-06, -2.386752386779297e-07,  8.583372421586287e-09, -2.618210695917419e-10,  7.010312581940850e-12, -1.685987791584027e-13,  3.702486795954951e-15,
 -7.515938348868731e-17,  1.423767909673815e-18, -2.535186483385797e-20,  3.676505697793218e-04, -4.784314400767784e-05,  3.392362406999736e-06, -1.717585155091804e-07,
  6.916506334327283e-09, -2.346167158691138e-10,  6.945566959750031e-12, -1.837748683105823e-13,  4.420820816379675e-15, -9.792634029016233e-17,  2.017265013607245e-18,
 -3.893703007626122e-20,  1.707352258042645e-04, -2.545200752036510e-05,  2.043750958552163e-06, -1.160991920882291e-07,  5.206220346332430e-09, -1.954393023060457e-10,
  6.369030826994756e-12, -1.846564079971063e-13,  4.847641958695123e-15, -1.167621661608800e-16,  2.606873714319231e-18, -5.437002333125862e-20,  7.679642519648485e-05,
 -1.298131340802146e-05,  1.171520023188316e-06, -7.420612002364034e-08,  3.685903612346384e-09, -1.524058889946458e-10,  5.444042814040682e-12, -1.722737747266809e-13,
  4.917511674239002e-15, -1.283502857840077e-16,  3.095646630137895e-18, -6.954650375685186e-20,  3.363889780185737e-05, -6.387261793332427e-06,  6.431908634718836e-07,
 -4.515588159474322e-08,  2.471560470824875e-09, -1.120431189416372e-10,  4.368524856549198e-12, -1.502978573345410e-13,  4.647998787610984e-15, -1.310135647065634e-16,
  3.402536372467894e-18, -8.208583124738774e-20,  1.443466929474685e-05, -3.051862664052940e-06,  3.405536885827456e-07, -2.634558440946193e-08,  1.580859862902577e-09,
 -7.821085737274263e-11,  3.314540525164304e-12, -1.235021985418500e-13,  4.122851409897140e-15, -1.250719079805356e-16,  3.486315666705688e-18, -9.003754294660151e-20,
  6.107187814181181e-06, -1.425886897082013e-06,  1.751468554215485e-07, -1.484499316764823e-08,  9.715922215525094e-10, -5.221767811489190e-11,  2.395211283535913e-12,
 -9.627693315492468e-14,  3.456648265710411e-15, -1.124651215712680e-16,  3.353580556591934e-18, -9.242348616965651e-20,  2.565420764520029e-06, -6.562204831051419e-07,
  8.815251037055187e-08, -8.139491624807197e-09,  5.781017083917924e-10, -3.359512349871177e-11,  1.660751808931465e-12, -7.172445160588903e-14,  2.759119806240405e-15,
 -9.593594156442623e-17,  3.049847417197871e-18, -8.940306179075435e-20,  1.077833852624110e-06, -2.997609070530466e-07,  4.375635009149225e-08, -4.376419000557542e-09,
  3.355748881513303e-10, -2.098649301421052e-11,  1.113153942780504e-12, -5.144059779589992e-14,  2.111954125512174e-15, -7.818690465758774e-17,  2.640593394314753e-18,
 -8.205484236998557e-20,  4.563995656452453e-07, -1.369868283532625e-07,  2.159027592357039e-08, -2.325747528814798e-09,  1.915209410868772e-10, -1.282715664253847e-11,
  7.266985712540280e-13, -3.577912773641773e-14,  1.561412990296110e-15, -6.130916067288594e-17,  2.191579362704105e-18, -7.193593727935101e-20,  1.962999084768752e-07,
 -6.312697403681399e-08,  1.067425518040506e-08, -1.231241432673247e-09,  1.083035560747920e-10, -7.729234874377901e-12,  4.654935844790583e-13, -2.430909744273138e-14,
  1.122838388899110e-15, -4.657124255302790e-17,  1.755187569873411e-18, -6.062802522970155e-20,  8.641789404552459e-08, -2.956434569951387e-08,  5.328987933669464e-09,
 -6.542960479128949e-10,  6.113803769476621e-11, -4.625074197963406e-12,  2.946488828978977e-13, -1.624432090415006e-14,  7.906170195360452e-16, -3.449047634335236e-17,
  1.364876720675399e-18, -4.941817421476465e-20,  3.921969824320451e-08, -1.417407641397960e-08,  2.705845355312077e-09, -3.514912869499903e-10,  3.468960080822853e-11,
 -2.766693755957495e-12,  1.854866975650454e-13, -1.074263039721564e-14,  5.483314655265052e-16, -2.504631725173165e-17,  1.036186254836446e-18, -3.916115797414836e-20,
  1.846124003884480e-08, -6.999633598692657e-09,  1.405888146640150e-09, -1.920122122653512e-10,  1.989668555711097e-11, -1.663559319273939e-12,  1.167364646007827e-13,
 -7.065715887809220e-15,  3.763555320535587e-16, -1.791397023636558e-17,  7.712366247172773e-19, -3.029035554114724e-20,  9.049876404512046e-09, -3.575338723570881e-09,
  7.504941742068559e-10, -1.070773089123594e-10,  1.157821139109060e-11, -1.008863439159075e-12,  7.368165969399175e-14, -4.635536302540555e-15,  2.563190624454461e-16,
 -1.264969936414043e-17,  5.639867329777805e-19, -2.291136567001556e-20,  4.622158941500717e-09, -1.889955067845121e-09,  4.117879206837608e-10, -6.097072588818511e-11,
  6.835776303663391e-12, -6.169454769351836e-13,  4.661946135189292e-14, -3.031294426436907e-15,  1.730479310009986e-16, -8.807936410901687e-18,  4.046111089346744e-19,
 -1.691786430814934e-20,  2.443824781738458e-09, -1.027339516510192e-09,  2.307368311989153e-10, -3.521367380766845e-11,  4.066684477582921e-12, -3.777501760388760e-13,
  2.935295117864027e-14, -1.960915111911903e-15,  1.149129665494856e-16, -5.999077061993522e-18,  2.824247793908114e-19, -1.209196964444246e-20,  1.309349448927127e-09,
 -5.621757059512092e-10,  1.292411878872332e-10, -2.018934187255098e-11,  2.385467240387580e-12, -2.265651224779501e-13,  1.798910135422273e-14, -1.227146497388376e-15,
  7.338388758365817e-17, -3.906888138172818e-18,  1.874532711025634e-19, -8.174223111102452e-21,  6.679841994071642e-10, -2.910153057038566e-10,  6.799543519228828e-11,
 -1.079570441865427e-11,  1.296036421994538e-12, -1.250174081761859e-13,  1.007683901638862e-14, -6.975078858966855e-16,  4.230517589556561e-17, -2.283338005138946e-18,
  1.110171976082671e-19, -4.903466664099307e-21,  2.534163880362063e-10, -1.113007700912798e-10,  2.624105925196256e-11, -4.204219725050597e-12,  5.092274034902728e-13,
 -4.954795077265952e-14,  4.027464543838071e-15, -2.810593834715630e-16,  1.718201704739547e-17, -9.344902159973517e-19,  4.577345929119446e-20, -2.036266966786140e-21,
  8.417460720947856e-02, -2.981904309325179e-04,  1.109363160763900e-06, -4.285617240185403e-09,  1.698386955563122e-11, -6.836021370676837e-14,  2.773291326219970e-16,
 -1.128565163079118e-18,  4.591310256824764e-21, -1.864379334210365e-23,  7.546549986162950e-26, -3.044392988949087e-28,  7.854008495245611e-02, -3.813563530596373e-04,
  2.219377494309466e-06, -1.313375528093933e-08,  7.576933866292929e-11, -4.245442026179490e-13,  2.318792731375876e-15, -1.239506759143923e-17,  6.505001425641126e-20,
 -3.359687407224266e-22,  1.710781694186685e-24, -8.601174259205554e-27,  6.839354577927395e-02, -5.118698031468029e-04,  4.342598718829607e-06, -3.418536601515015e-08,
  2.519919613278836e-10, -1.767762870247016e-12,  1.192407883120581e-14, -7.785888238095496e-17,  4.944754672820424e-19, -3.065445611949843e-21,  1.860257340375806e-23,
 -1.107503509862372e-25,  5.561097695209238e-02, -6.358136869743016e-04,  7.178868196852493e-06, -7.125123503697607e-08,  6.481519751379638e-10, -5.526773376553066e-12,
  4.476195616333922e-14, -3.474113343347645e-16,  2.600509669253996e-18, -1.886454615161180e-20,  1.331171395815701e-22, -9.164256319658213e-25,  4.225169885732515e-02,
 -7.060038047229013e-04,  1.015961616606434e-05, -1.243112410317450e-07,  1.367923768274453e-09, -1.390637109860334e-11,  1.327623477743659e-13, -1.203517217429108e-15,
  1.044218616788756e-17, -8.723058225733419e-20,  7.048165206143475e-22, -5.528018894705688e-24,  3.002592078868148e-02, -7.002293928641610e-04,  1.255991722504242e-05,
 -1.865045373281160e-07,  2.445382712402331e-09, -2.922288309694081e-11,  3.245446970316854e-13, -3.393755239621169e-15,  3.372791356798908e-17, -3.207881691536732e-19,
  2.935577207550390e-21, -2.595534899880348e-23,  1.998333428640873e-02, -6.249883673783668e-04,  1.376389244321230e-05, -2.448280013088757e-07,  3.779524500116664e-09,
 -5.251685675436948e-11,  6.716350856360003e-13, -8.024446744616606e-15,  9.052028371266499e-17, -9.717371932482201e-19,  9.987564118728383e-21, -9.874735302431029e-23,
  1.247496978911283e-02, -5.062417291948800e-04,  1.351640696012412e-05, -2.848081592294382e-07,  5.126027450917449e-09, -8.208607066680839e-11,  1.198991121673575e-12,
 -1.624127172413375e-14,  2.064395234806949e-16, -2.483891851452408e-18,  2.848145619001202e-20, -3.128571059491521e-22,  7.318660547604248e-03, -3.750136629554579e-04,
  1.199947850042152e-05, -2.966088245829509e-07,  6.171897822431565e-09, -1.130481413713289e-10,  1.872890718238343e-12, -2.857758090512287e-14,  4.067998231219665e-16,
 -5.454098531408002e-18,  6.938107251988105e-20, -8.421707143066223e-22,  4.044058693853951e-03, -2.558107163933709e-04,  9.703911617268435e-06, -2.789388652746822e-07,
  6.660928324488414e-09, -1.386356946431201e-10,  2.589472219584722e-12, -4.425878563423354e-14,  7.018502432802199e-16, -1.043300914509359e-17,  1.465312694069853e-19,
 -1.956395070508593e-21,  2.110264657217736e-03, -1.616867844489993e-04,  7.198035725037661e-06, -2.387074438627109e-07,  6.497989560066310e-09, -1.527741304781470e-10,
  3.199937217754346e-12, -6.095996650731216e-14,  1.071892626546581e-15, -1.758800774267035e-17,  2.715837549957564e-19, -3.972205410166148e-21,  1.043067196533252e-03,
 -9.524645700712820e-05,  4.929340821011943e-06, -1.872157213164281e-07,  5.773918058140461e-09, -1.525189200735331e-10,  3.564889619951669e-12, -7.535353541271322e-14,
  1.462974798611236e-15, -2.639169671061911e-17,  4.463413405676214e-19, -7.125395374871287e-21,  4.900779107081868e-04, -5.259032141820953e-05,  3.136260974905817e-06,
 -1.354839425118373e-07,  4.706901560794116e-09, -1.389897456707982e-10,  3.608797478762960e-12, -8.428663294362057e-14,  1.799798481056719e-15, -3.556481562642837e-17,
  6.564656106815660e-19, -1.140011991919272e-20,  2.197526820544223e-04, -2.737278605372026e-05,  1.865566719963717e-06, -9.107484665924428e-08,  3.544889441369368e-09,
 -1.164595535646764e-10,  3.344629024392582e-12, -8.597468357647919e-14,  2.011743120181822e-15, -4.339432954437502e-17,  8.713425534894299e-19, -1.640873912147881e-20,
  9.446987409197188e-05, -1.350937867630228e-05,  1.044130693487260e-06, -5.725079519028653e-08,  2.483602339989446e-09, -9.036368320820716e-11,  2.858715142032341e-12,
 -8.057081427048510e-14,  2.058675286530856e-15, -4.831409799154041e-17,  1.052033801876613e-18, -2.141898894934385e-20,  3.913531380085393e-05, -6.361026446142531e-06,
  5.534856384679681e-07, -3.388503328725588e-08,  1.630113361170249e-09, -6.539434948807025e-11,  2.269758232668312e-12, -6.988284118970935e-14,  1.943117912289732e-15,
 -4.945492651863548e-17,  1.164223566642811e-18, -2.555156962760369e-20,  1.571282519334777e-05, -2.876292808380099e-06,  2.798071319107239e-07, -1.901752031511506e-08,
  1.009567449983750e-09, -4.446020214312616e-11,  1.686375538220171e-12, -5.651279863906334e-14,  1.704193974017394e-15, -4.688844102359068e-17,  1.189726356687578e-18,
 -2.806602996416564e-20,  6.153493506890381e-06, -1.257734790214604e-06,  1.358840717789227e-07, -1.019608447007840e-08,  5.943947042232191e-10, -2.861129472396919e-11,
  1.181260012909477e-12, -4.292918370142858e-14,  1.399221310968135e-15, -4.148327670089015e-17,  1.131053879665891e-18, -2.859576106861433e-20,  2.367151118781074e-06,
 -5.358567909946801e-07,  6.388169089666997e-08, -5.262840971006721e-09,  3.352854444940889e-10, -1.756326321913640e-11,  7.861398240432064e-13, -3.086807421426346e-14,
  1.083665651189047e-15, -3.450616679912915e-17,  1.007816772249523e-18, -2.722624379199497e-20,  9.013608780906071e-07, -2.242282966102064e-07,  2.931003496168761e-08,
 -2.636679462364668e-09,  1.826756798327783e-10, -1.036737941481403e-11,  5.010391185223037e-13, -2.117519315547434e-14,  7.978268994452943e-16, -2.719268110296576e-17,
  8.480268043168265e-19, -2.440394331947377e-20,  3.425532581021721e-07, -9.294104362753441e-08,  1.323757028241599e-08, -1.293154192590370e-09,  9.694848158664801e-11,
 -5.933973404053487e-12,  3.083320440656804e-13, -1.397012985133342e-14,  5.628017055372395e-16, -2.045982647687241e-17,  6.789920882102799e-19, -2.074682423337417e-20,
  1.310743054003856e-07, -3.850141778453594e-08,  5.937844329802810e-09, -6.263819599467890e-10,  5.055661380884921e-11, -3.321600003365242e-12,  1.847463320222574e-13,
 -8.936807493985335e-15,  3.834477590717775e-16, -1.481269032890070e-17,  5.212570643229874e-19, -1.685336988507665e-20,  5.095833099826641e-08, -1.608775397953307e-08,
  2.669635217086230e-09, -3.023715993258332e-10,  2.613557519954615e-11, -1.834115708177800e-12,  1.086928874491077e-13, -5.588989147522186e-15,  2.543441237462643e-16,
 -1.039942553588528e-17,  3.865755320539375e-19, -1.317748005093624e-20,  2.031431339086628e-08, -6.843486201499175e-09,  1.214081946635631e-09, -1.467744435806732e-10,
  1.351153460895718e-11, -1.007583882750079e-12,  6.331141043722018e-14, -3.444509750394183e-15,  1.655244866025690e-16, -7.133042722502602e-18,  2.789628013636579e-19,
 -9.986497564373233e-21,  8.377626434785597e-09, -2.990109675016805e-09,  5.634068810344767e-10, -7.225730666273867e-11,  7.043721356516893e-12, -5.551361719501574e-13,
  3.679460414831131e-14, -2.107681332520137e-15,  1.064490080536841e-16, -4.813029901877303e-18,  1.971750718078287e-19, -7.381977453741816e-21,  3.602559329347400e-09,
 -1.352633027041505e-09,  2.688802116659670e-10, -3.635105005451238e-11,  3.729819467739526e-12, -3.088994886745580e-13,  2.147881977752419e-14, -1.288646632901152e-15,
  6.806010246710822e-17, -3.213210006122528e-18,  1.372517077272225e-19, -5.349933963756650e-21,  1.625119173646552e-09, -6.373561864074363e-10,  1.327414405433906e-10,
 -1.879295212645009e-11,  2.016859142015391e-12, -1.744675577083820e-13,  1.265328875325704e-14, -7.907095447797070e-16,  4.343884812234042e-17, -2.130399364486383e-18,
  9.441296587920060e-20, -3.813254808088785e-21,  7.708917789551135e-10, -3.135864496144021e-10,  6.794367666153087e-11, -1.000434609743613e-11,  1.115609769648409e-12,
 -1.001624941960020e-13,  7.530756296687919e-15, -4.872935093638150e-16,  2.768827982778180e-17, -1.402955470105078e-18,  6.416789540915879e-20, -2.671822594594220e-21,
  3.827938606576493e-10, -1.603792831918668e-10,  3.588828991902646e-11, -5.457046552589481e-12,  6.279672132876718e-13, -5.812991758861346e-14,  4.501900384912374e-15,
 -2.997797465686542e-16,  1.751301880630210e-17, -9.115329412086987e-19,  4.278902147177981e-20, -1.826902396378369e-21,  1.951149960576675e-10, -8.361032223495925e-11,
  1.918021518731768e-11, -2.989793602173756e-12,  3.525169732621179e-13, -3.341287235041265e-14,  2.647723616059111e-15, -1.802728608666138e-16,  1.076051869021777e-17,
 -5.718590437762946e-19,  2.739066686153817e-20, -1.192434997844330e-21,  9.606575772213277e-11, -4.181223432456875e-11,  9.759001961552263e-12, -1.547794811527734e-12,
  1.856200835081686e-13, -1.788690650585806e-14,  1.440318855254828e-15, -9.960148131442624e-17,  6.035387325326240e-18, -3.254536314205801e-19,  1.580987318435413e-20,
 -6.977071177195933e-22,  3.571897787860695e-11, -1.568161060271123e-11,  3.695560276417814e-12, -5.918182437619275e-13,  7.165073138784566e-14, -6.968571751236431e-15,
  5.661908363439418e-16, -3.949537341374081e-17,  2.413477913440068e-18, -1.312106156788904e-19,  6.424463848700154e-21, -2.856874213203955e-22,  8.299927597711854e-02,
 -2.895167172715632e-04,  1.059522230402095e-06, -4.024461777290297e-09,  1.568074793208005e-11, -6.206751020900461e-14,  2.476893216334983e-16, -9.918246692913835e-19,
  3.971391470400917e-21, -1.587666882705083e-23,  6.327673153913350e-26, -2.514021979003492e-28,  7.704919968341636e-02, -3.642117703300426e-04,  2.068775570320198e-06,
 -1.198646313680712e-08,  6.780802274597537e-11, -3.728334200834480e-13,  1.999145027272474e-15, -1.049448354658740e-17,  5.410091874238158e-20, -2.745396353162210e-22,
  1.373855213990021e-24, -6.789364625168282e-27,  6.641304340360446e-02, -4.787039586838380e-04,  3.955447248171833e-06, -3.042149799958789e-08,  2.193307249160268e-10,
 -1.506054600306769e-12,  9.949936196461908e-15, -6.366676313257926e-17,  3.964173883371058e-19, -2.410299338914427e-21,  1.435040820841776e-23, -8.384523281429916e-26,
  5.317740727465173e-02, -5.816345405760563e-04,  6.382608723654751e-06, -6.170986345176326e-08,  5.476175114471582e-10, -4.560405823817585e-12,  3.610426652141646e-14,
 -2.741072885133931e-16,  2.008253700289465e-18, -1.426619302789026e-20,  9.862498013428438e-23, -6.654410293371070e-25,  3.958128860775336e-02, -6.303418068679019e-04,
  8.790554790696711e-06, -1.044871715101660e-07,  1.119113235532582e-09, -1.108941584974079e-11,  1.033060762750727e-13, -9.146132294396540e-16,  7.755760775361009e-18,
 -6.336020076964748e-20,  5.009226561457728e-22, -3.846066905554322e-24,  2.741267129033340e-02, -6.080789499398630e-04,  1.053862001217866e-05, -1.516611124043147e-07,
  1.931706549176637e-09, -2.246206448206295e-11,  2.430430530393952e-13, -2.478632298152614e-15,  2.404418662711588e-17, -2.233778194693172e-19,  1.997963987810638e-21,
 -1.727565454710930e-23,  1.768634899363884e-02, -5.256754334711930e-04,  1.115677123315781e-05, -1.919533865523618e-07,  2.873744218843653e-09, -3.879627130815916e-11,
  4.827487632468737e-13, -5.618177652152373e-15,  6.179195229949216e-17, -6.472815479486314e-19,  6.496351988481435e-21, -6.275875980320510e-23,  1.064643577819231e-02,
 -4.105023152007057e-04,  1.054130311570022e-05, -2.145041795958384e-07,  3.738762650570629e-09, -5.809624741115088e-11,  8.247019696189679e-13, -1.087041990885400e-14,
  1.345916264865346e-16, -1.578866148045542e-18,  1.766449889720819e-20, -1.894585202074482e-22,  5.990217201110105e-03, -2.917335191089833e-04,  8.965289745080410e-06,
 -2.137516550571476e-07,  4.302511585068327e-09, -7.639377164732436e-11,  1.228883505595218e-12, -1.823088809064457e-14,  2.526007386018254e-16, -3.299645426104139e-18,
  4.093005743705195e-20, -4.848268029015316e-22,  3.157184319154410e-03, -1.899474254469732e-04,  6.914482424706097e-06, -1.915488135469150e-07,  4.421087245359132e-09,
 -8.913183371771105e-11,  1.615376015162394e-12, -2.682716567511312e-14,  4.138534013396491e-16, -5.990761275958915e-18,  8.200919961698884e-20, -1.068067059404170e-21,
  1.562764339623413e-03, -1.140007315508822e-04,  4.868606197662150e-06, -1.555281778179197e-07,  4.090031591894406e-09, -9.309998715757117e-11,  1.891255443656137e-12,
 -3.499363246769936e-14,  5.983618900441365e-16, -9.557841045434581e-18,  1.438085956776251e-19, -2.051248106376249e-21,  7.286680836856889e-04, -6.343241699165977e-05,
  3.149690617977226e-06, -1.152197773281897e-07,  3.432230297704543e-09, -8.775859734599122e-11,  1.988988457483739e-12, -4.082680993411092e-14,  7.706876161342900e-16,
 -1.353265961991390e-17,  2.229858993426016e-19, -3.471319488322001e-21,  3.211631016221833e-04, -3.290743217622165e-05,  1.883886134835088e-06, -7.840487252814723e-08,
  2.631259737208137e-09, -7.521434670231211e-11,  1.893745838358092e-12, -4.295306614099903e-14,  8.918330353309167e-16, -1.715478252509874e-17,  3.085383926155155e-19,
 -5.225513729599762e-21,  1.343480739113131e-04, -1.600790748832228e-05,  1.048284981848170e-06, -4.933272551198405e-08,  1.855663984294045e-09, -5.903536734640419e-11,
  1.644595505889951e-12, -4.106594201429614e-14,  9.346054873483429e-16, -1.962972358779088e-17,  3.841716237070335e-19, -7.057660780945519e-21,  5.358644230873120e-05,
 -7.345293062402000e-06,  5.461689745391271e-07, -2.889474198313232e-08,  1.212265510782659e-09, -4.273887263526279e-11,  1.312258831128313e-12, -3.594637348718274e-14,
  8.937749961914364e-16, -2.043393948570730e-17,  4.338828310668138e-19, -8.621840778477345e-21,  2.048735990170957e-05, -3.199256258408342e-06,  2.682294846401694e-07,
 -1.586371968388355e-08,  7.388222405453026e-10, -2.874545140760599e-11,  9.691392109174070e-13, -2.902285308710652e-14,  7.858676610899905e-16, -1.949861420035833e-17,
  4.479122604186373e-19, -9.601195091593930e-21,  7.553017215843553e-06, -1.331648344787132e-06,  1.250538791459699e-07, -8.223341200830706e-09,  4.231798885431813e-10,
 -1.809584431056000e-11,  6.674348323079323e-13, -2.177728828688513e-14,  6.401382430647858e-16, -1.718559294511445e-17,  4.258877240167270e-19, -9.821043195100485e-21,
  2.703217736303884e-06, -5.335929364489351e-07,  5.576840802524302e-08, -4.055899767074646e-09,  2.295682235936300e-10, -1.074525059482242e-11,  4.319660497616736e-13,
 -1.530388633192346e-14,  4.867974738767771e-16, -1.409847262664152e-17,  3.758434553187506e-19, -9.298554815673962e-21,  9.463081451201193e-07, -2.074744156219964e-07,
  2.398334561987256e-08, -1.919001270821701e-09,  1.189188040730867e-10, -6.067574915431761e-12,  2.648599891114265e-13, -1.015343394535798e-14,  3.483544580631351e-16,
 -1.085034140814934e-17,  3.102518946817710e-19, -8.212097848478432e-21,  3.267294437735372e-07, -7.895868016792836e-08,  1.003348453433242e-08, -8.786183885759323e-10,
  5.933385786456304e-11, -3.286215776330667e-12,  1.551613142232814e-13, -6.412997347724685e-15,  2.365180314191302e-16, -7.897639147633831e-18,  2.414816863402053e-19,
 -6.818508406617294e-21,  1.122795787860187e-07, -2.968640769988954e-08,  4.121617470339345e-09, -3.929052633534200e-10,  2.877687806585614e-11, -1.722554307545146e-12,
  8.761845603672939e-14, -3.889721835822569e-15,  1.536653570079134e-16, -5.482256203228160e-18,  1.786773112120312e-19, -5.365417568043261e-21,  3.878212983919856e-08,
 -1.113660384529420e-08,  1.679015892590122e-09, -1.732935406866724e-10,  1.369762879212526e-11, -8.821310192683360e-13,  4.813376638073688e-14, -2.286067989236398e-15,
  9.637536961575864e-17, -3.660541381879520e-18,  1.267340855322219e-19, -4.033942148255511e-21,  1.360470326008928e-08, -4.212302385252100e-09,  6.853353328376874e-10,
 -7.615473565421690e-11,  6.462872670025805e-12, -4.456448528418158e-13,  2.596852982926153e-14, -1.313894103406762e-15,  5.887187598906083e-17, -2.371457317107028e-18,
  8.689699482112457e-20, -2.921510631776332e-21,  4.899139220465551e-09, -1.623720492970669e-09,  2.832684108026098e-10, -3.369131350725479e-11,  3.053196351468247e-12,
 -2.242772326751377e-13,  1.389000634721973e-14, -7.452704165453702e-16,  3.533868533954060e-17, -1.503442436789469e-18,  5.807531550849187e-20, -2.054467311918523e-21,
  1.830351420117747e-09, -6.446627121936537e-10,  1.198001162189856e-10, -1.515809338116088e-11,  1.458470061057318e-12, -1.135124456103256e-13,  7.433424563903243e-15,
 -4.208955118900656e-16,  2.102176902779608e-17, -9.403470558591435e-19,  3.812743113884045e-20, -1.413344000996476e-21,  7.165248122485761e-10, -2.662371157571820e-10,
  5.234363109082040e-11, -7.000465613806856e-12,  7.108125508289554e-13, -5.827841192708676e-14,  4.013189335755550e-15, -2.385404825076318e-16,  1.248600102982062e-17,
 -5.844113891051380e-19,  2.475627139944792e-20, -9.572906860878826e-22,  2.963116957690231e-10, -1.153037426696036e-10,  2.381393957163504e-11, -3.343760973147809e-12,
  3.559912808072843e-13, -3.055791699196247e-14,  2.199788422738165e-15, -1.364844797838114e-16,  7.446451534454482e-18, -3.627838306577225e-19,  1.597498298138445e-20,
 -6.412597376456233e-22,  1.300456772531931e-10, -5.260807930385623e-11,  1.133030321438829e-11, -1.658461637600984e-12,  1.838761068310212e-13, -1.641717059484676e-14,
  1.227716531953499e-15, -7.903170593486979e-17,  4.468278081468441e-18, -2.253204995705434e-19,  1.025800760608386e-20, -4.252248729811176e-22,  6.042910426917357e-11,
 -2.522663988443322e-11,  5.622751636359572e-12, -8.516283998299791e-13,  9.762695219766424e-14, -9.003798651199620e-15,  6.948169879190832e-16, -4.610840638929841e-17,
  2.684698380175175e-18, -1.392884348781913e-19,  6.518276684477422e-21, -2.774754017905253e-22,  2.921223226038761e-11, -1.249176006282968e-11,  2.858997051723678e-12,
 -4.446320872920640e-13,  5.230730018092768e-14, -4.947069596835198e-15,  3.911917422227297e-16, -2.658037567132134e-17,  1.583463215824899e-18, -8.399184454094796e-20,
  4.015617864580321e-21, -1.745080549846866e-22,  1.384823966556793e-11, -6.021235361933051e-12,  1.403764231154365e-12, -2.223861194193815e-13,  2.664000756287713e-14,
 -2.564321494092346e-15,  2.062706767327210e-16, -1.424951801793421e-17,  8.625986639197682e-19, -4.647029068573721e-20,  2.255330743487359e-21, -9.944071031552161e-23,
  5.039543675034116e-12, -2.211576673809779e-12,  5.209404226283825e-13, -8.338542582272012e-14,  1.009063735906832e-14, -9.809378875548662e-16,  7.966443066322384e-17,
 -5.554641533726593e-18,  3.392857838210848e-19, -1.843775788568850e-20,  9.023957014530555e-22, -4.011223356075873e-23,  8.185786150423496e-02, -2.812295407202617e-04,
  1.012694097367233e-06, -3.783186815539193e-09,  1.449666574494266e-11, -5.644237020438893e-14,  2.216148511824868e-16, -8.734174315933146e-19,  3.442847561745532e-21,
 -1.355347643665056e-23,  5.319729412951752e-26, -2.082037814329239e-28,  7.562456735189212e-02, -3.482190224680146e-04,  1.931209692435659e-06, -1.095867773620562e-08,
  6.080832128306970e-11, -3.281932240374872e-13,  1.728123256457440e-15, -8.911340264847683e-18,  4.513872990221134e-20, -2.251197102478945e-22,  1.107391341634952e-24,
 -5.380516002586492e-27,  6.455928399849416e-02, -4.484631624602555e-04,  3.610491458080330e-06, -2.714078172770423e-08,  1.914603032687026e-10, -1.287291105547277e-12,
  8.332567245520338e-15, -5.226578269444689e-17,  3.191482174964488e-19, -1.903738887063715e-21,  1.112340856743436e-23, -6.379901101597788e-26,  5.094850241849083e-02,
 -5.333934306560060e-04,  5.691797451595986e-06, -5.363305291025348e-08,  4.644883548528193e-10, -3.779190312757069e-12,  2.925686543557930e-14, -2.173528751640785e-16,
  1.559152693940292e-18, -1.084965245521948e-20,  7.350500155356319e-23, -4.862117347774269e-25,  3.719303780029957e-02, -5.647443759466048e-04,  7.637238321001695e-06,
 -8.822918340945433e-08,  9.201805083943248e-10, -8.891312357689811e-12,  8.085434783318892e-14, -6.993654402630689e-16,  5.798104487459790e-18, -4.633758367644938e-20,
  3.585657773721015e-22, -2.695857200768361e-24,  2.513814638567146e-02, -5.305564934456496e-04,  8.890271237399853e-06, -1.240529321766393e-07,  1.535593756852018e-09,
 -1.738182154604226e-11,  1.833061453213540e-13, -1.823832435509615e-15,  1.727506103937629e-17, -1.568161927508594e-19,  1.371338626712034e-21, -1.159932961131833e-23,
  1.574859775865507e-02, -4.449084983355526e-04,  9.105506600174554e-06, -1.516011023273471e-07,  2.202005993673385e-09, -2.889443226260884e-11,  3.499480418905714e-13,
 -3.968461165116181e-15,  4.257035463132082e-17, -4.352736634991671e-19,  4.267100758827570e-21, -4.029016177396894e-23,  9.158112524090187e-03, -3.355329472920772e-04,
  8.291051132614116e-06, -1.629993235469969e-07,  2.752420983664577e-09, -4.151719701124495e-11,  5.729677804119337e-13, -7.351334213229440e-15,  8.868904035346365e-17,
 -1.014636275142341e-18,  1.107928873905474e-20, -1.160556828674977e-22,  4.951993844250454e-03, -2.292075043597337e-04,  6.767644390256810e-06, -1.556904363186589e-07,
  3.032513425050630e-09, -5.221215746130993e-11,  8.157582589334120e-13, -1.176977088868798e-14,  1.587757708152855e-16, -2.021242511878896e-18,  2.445430663549166e-20,
 -2.827376109848680e-22,  2.495003517416047e-03, -1.427463351343269e-04,  4.987679207295599e-06, -1.331968782518417e-07,  2.972260926606790e-09, -5.805896949056564e-11,
  1.021231528406234e-12, -1.648320799824673e-14,  2.474216358644409e-16, -3.488471139157465e-18,  4.655449714218708e-20, -5.915453105284276e-22,  1.174241310550967e-03,
 -8.153174405833968e-05,  3.340629061799496e-06, -1.028153994580139e-07,  2.612532278071177e-09, -5.758625333458880e-11,  1.134770504604149e-12, -2.039663423766147e-14,
  3.392138718973830e-16, -5.275546739465222e-18,  7.735591250081522e-20, -1.076194845010331e-21,  5.177379653048824e-04, -4.295016141269905e-05,  2.046075456461049e-06,
 -7.209557496351746e-08,  2.074515217667773e-09, -5.134915047303708e-11,  1.128601544185998e-12, -2.249847869443080e-14,  4.129785274433256e-16, -7.059039054338026e-18,
  1.133366419147664e-19, -1.720662189699371e-21,  2.145944431171783e-04, -2.098417387057944e-05,  1.152994271661437e-06, -4.622701390115178e-08,  1.498577054130208e-09,
 -4.146724283949407e-11,  1.012447058494333e-12, -2.230119409053553e-14,  4.502452495480870e-16, -8.430679376571496e-18,  1.477490406058198e-19, -2.440452816671811e-21,
  8.394943241256834e-05, -9.562378765073431e-06,  6.014812528850870e-07, -2.728078297844530e-08,  9.915597912360526e-10, -3.054395813254826e-11,  8.252925821806273e-13,
 -2.001693998558186e-14,  4.430561667304470e-16, -9.060278518249014e-18,  1.728143944741672e-19, -3.096966053886451e-21,  3.114001681663425e-05, -4.088488115920524e-06,
  2.923329472737028e-07, -1.491725162465380e-08,  6.051058075555083e-10, -2.066685093109317e-11,  6.157533080247600e-13, -1.639063419662290e-14,  3.965173374052266e-16,
 -8.829946072669551e-18,  1.828014517403628e-19, -3.544896686142169e-21,  1.101135308258470e-05, -1.650591454848689e-06,  1.332656073524499e-07, -7.610487564550202e-09,
  3.430088698768931e-10, -1.293887271638636e-11,  4.236055720279525e-13, -1.233559559207509e-14,  3.251919373893438e-16, -7.863822490453711e-18,  1.762323290151221e-19,
 -3.688694275589761e-21,  3.734592003060998e-06, -6.335663899261183e-07,  5.739489432757332e-08, -3.649451330132524e-09,  1.819627008721057e-10, -7.551991474365527e-12,
  2.707473169116469e-13, -8.598060430233335e-15,  2.462734695909480e-16, -6.449261182901924e-18,  1.560465168338448e-19, -3.516531417885439e-21,  1.223372684433091e-06,
 -2.329723017220785e-07,  2.353575735587020e-08, -1.657913349314761e-09,  9.105553714734604e-11, -4.142062080737027e-12,  1.620533316531193e-13, -5.594404406015074e-15,
  1.735899128731283e-16, -4.909154960263285e-18,  1.279075511138787e-19, -3.095504620192092e-21,  3.901401218532303e-07, -8.275428756695151e-08,  9.267528398668966e-09,
 -7.196349604248353e-10,  4.334764293119249e-11, -2.152923142573238e-12,  9.159715462282456e-14, -3.426322264883769e-15,  1.148249286700181e-16, -3.496773922963533e-18,
  9.784159733571816e-20, -2.536319620931592e-21,  1.222031134446694e-07, -2.865677163624238e-08,  3.536628169773327e-09, -3.012147314946872e-10,  1.981175293282643e-11,
 -1.070075235632969e-12,  4.932886287527658e-14, -1.992661192578675e-15,  7.189633824532604e-17, -2.350665333093804e-18,  7.043357990360477e-20, -1.950393421579880e-21,
  3.796855121427222e-08, -9.771678520386824e-09,  1.321167733082111e-09, -1.227912718019256e-10,  8.778742498237857e-12, -5.135190169846381e-13,  2.555177831563402e-14,
 -1.110698571397959e-15,  4.300144992090095e-17, -1.504680305168998e-18,  4.813432458173662e-20, -1.419712309710267e-21,  1.182869905294542e-08, -3.316973199816346e-09,
  4.883841898270399e-10, -4.927315160269276e-11,  3.810934669295475e-12, -2.403789505842483e-13,  1.285824467922779e-14, -5.991732634456262e-16,  2.480260899605662e-17,
 -9.256725579594979e-19,  3.151211986181115e-20, -9.868902069263595e-22,  3.738296425730125e-09, -1.133969787089401e-09,  1.807140178436281e-10, -1.968342288873678e-11,
  1.638715884034563e-12, -1.109418171725429e-13,  6.352103776130726e-15, -3.160159019412814e-16,  1.393249150729142e-17, -5.525650860019245e-19,  1.994699677166738e-20,
 -6.610539323521122e-22,  1.213247428059526e-09, -3.952234146074577e-10,  6.774098759030042e-11, -7.919886923306999e-12,  7.059782705083124e-13, -5.104451494551338e-14,
  3.113683241834031e-15, -1.646492987811482e-16,  7.698761917009054e-18, -3.231598648237104e-19,  1.232264800923783e-20, -4.305389817103993e-22,  4.094198990578548e-10,
 -1.421787212242775e-10,  2.603716863482603e-11, -3.247673656443216e-12,  3.082053366835986e-13, -2.367197038131158e-14,  1.530581095167391e-15, -8.561235485648559e-17,
  4.226036499884038e-18, -1.869174771485205e-19,  7.496909884991464e-21, -2.750173139869967e-22,  1.453927307093178e-10, -5.342480554983361e-11,  1.038124637559023e-11,
 -1.372542774496100e-12,  1.378270424441453e-13, -1.118014895971899e-14,  7.620243368623424e-16, -4.484905012869952e-17,  2.325366646036721e-18, -1.078500999298420e-19,
  4.528662050852842e-21, -1.736444114982728e-22,  5.490575298212503e-11, -2.118692512260285e-11,  4.336826522142393e-12, -6.036054872235185e-13,  6.371673291524030e-14,
 -5.424587835173846e-15,  3.874239182485124e-16, -2.385511756528041e-17,  1.292009437921701e-18, -6.250316183563576e-20,  2.733671713572007e-21, -1.090202650372260e-22,
  2.220601201095190e-11, -8.929791408182394e-12,  1.910916439637721e-12, -2.779387787017422e-13,  3.062613398878623e-14, -2.718192287829345e-15,  2.021104666554296e-16,
 -1.293877432104119e-17,  7.276495756505742e-19, -3.650553911867289e-20,  1.653784913266985e-21, -6.823011646177673e-23,  9.619379040549846e-12, -4.000101660844570e-12,
  8.878077145885564e-13, -1.339037443400129e-13,  1.528739868290671e-14, -1.404329718281399e-15,  1.079576664734531e-16, -7.137771829075125e-18,  4.141289928662991e-19,
 -2.141256982532072e-20,  9.987433386351639e-22, -4.238070053552473e-23,  4.395648238532391e-12, -1.875437100511560e-12,  4.281684777802656e-13, -6.642445799418168e-14,
  7.795458441136346e-15, -7.355491064341223e-16,  5.803252142770654e-17, -3.934547152102903e-18,  2.338980018484377e-19, -1.238147830324839e-20,  5.907930630253140e-22,
 -2.562583061108240e-23,  2.001307714698046e-12, -8.692198770543445e-13,  2.023999151774452e-13, -3.202545626065706e-14,  3.831811522024947e-15, -3.684159658977675e-16,
  2.960156617606823e-17, -2.042696235191897e-18,  1.235246891762121e-19, -6.647774924148104e-21,  3.223154812482448e-22, -1.419776273373078e-23,  7.117600696258280e-13,
 -3.122150288979421e-13,  7.350646002733897e-14, -1.176009634571473e-14,  1.422410665827827e-15, -1.382093747786183e-16,  1.121900937479666e-17, -7.818884541699468e-19,
  4.773729420436751e-20, -2.593034057252127e-21,  1.268555912882525e-22, -5.636465482239867e-24,  8.074886438063875e-02, -2.733057217706599e-04,  9.686511974366013e-07,
 -3.559990053675989e-09,  1.341908747326502e-11, -5.140506928755985e-14,  1.986310348572480e-16, -7.706596848747611e-19,  2.991116898751884e-21, -1.159789965333770e-23,
  4.483840323401234e-26, -1.729129985599049e-28,  7.426178046823004e-02, -3.332793062191017e-04,  1.805333625573035e-06, -1.003608403119864e-08,  5.463980831708541e-11,
 -2.895564483730193e-13,  1.497667904437087e-15, -7.588462914773872e-18,  3.777785105690001e-20, -1.852153978203458e-22,  8.958282791108788e-25, -4.280447069907487e-27,
  6.282120753960652e-02, -4.208317995937167e-04,  3.302366539828634e-06, -2.427299537424109e-08,  1.676014647782773e-10, -1.103777141060255e-12,  7.002382558830955e-15,
 -4.306892176501608e-17,  2.579896303609526e-19, -1.510211771064278e-21,  8.662152664100624e-24, -4.878437401458048e-26,  4.890209243327777e-02, -4.903126031319973e-04,
  5.090415594824873e-06, -4.676973092792037e-08,  3.954609166198650e-10, -3.144759816214653e-12,  2.381458281944290e-14, -1.731812592949809e-16,  1.216712039770682e-18,
 -8.296319816031044e-21,  5.509812275716626e-23, -3.574003049035590e-25,  3.504988704715584e-02, -5.076440424692676e-04,  6.661281386437194e-06, -7.482977075204126e-08,
  7.602753008301694e-10, -7.166276709802808e-12,  6.363735659808304e-14, -5.379647543846755e-16,  4.361890894069179e-18, -3.411261269986061e-20,  2.584423482791280e-22,
 -1.903269902434875e-24,  2.314929341998568e-02, -4.649961320465810e-04,  7.538310460112499e-06, -1.020417946134117e-07,  1.228116352585806e-09, -1.353767628188773e-11,
  1.391994437065863e-13, -1.351693108857549e-15,  1.250532031691121e-17, -1.109546998971910e-19,  9.489374132665207e-22, -7.854041638797915e-24,  1.410392137161834e-02,
 -3.787834845208344e-04,  7.479996859559798e-06, -1.205709681451096e-07,  1.699842550327811e-09, -2.168852945614182e-11,  2.557631521640332e-13, -2.827165189663680e-15,
  2.958876646463483e-17, -2.953997820803633e-19,  2.829453580697289e-21, -2.611870315331135e-23,  7.937229050946001e-03, -2.763384246452534e-04,  6.574132310645215e-06,
 -1.249208083498091e-07,  2.044441073676228e-09, -2.994624212777266e-11,  4.019283690215734e-13, -5.021262194409207e-15,  5.904485940438220e-17, -6.589639188914129e-19,
  7.024702112462401e-21, -7.188483436609201e-23,  4.132681590031218e-03, -1.817876150405713e-04,  5.159183138570573e-06, -1.145629360969956e-07,  2.160063082291960e-09,
 -3.607551113031457e-11,  5.476142965659036e-13, -7.686310665091158e-15,  1.009818445020485e-16, -1.253117728494990e-18,  1.479098795418706e-20, -1.669590436055820e-22,
  1.994733100325818e-03, -1.085102129115548e-04,  3.640255460045271e-06, -9.374064573967506e-08,  2.022967623654315e-09, -3.829744217100392e-11,  6.539618144902113e-13,
 -1.026109019575240e-14,  1.499044825261030e-16, -2.059060390249023e-18,  2.679359222873995e-20, -3.322245378377073e-22,  8.946492715508534e-04, -5.911004090029989e-05,
  2.323951763195778e-06, -6.892310543076873e-08,  1.692558088263572e-09, -3.613465704456983e-11,  6.908563798029404e-13, -1.206512178397898e-14,  1.951930171060546e-16,
 -2.956165593653670e-18,  4.224971793115400e-20, -5.733880377246245e-22,  3.738998399256556e-04, -2.954733024936726e-05,  1.350432243004282e-06, -4.583754464605693e-08,
  1.274194493813303e-09, -3.053571597376213e-11,  6.509283011549230e-13, -1.260365158526771e-14,  2.249888398961859e-16, -3.744021070984971e-18,  5.857821661500806e-20,
 -8.673782640134837e-22,  1.460944040861332e-04, -1.362690260027529e-05,  7.185250100048453e-07, -2.775055382494517e-08,  8.689978691318621e-10, -2.327794798657206e-11,
  5.511541146017964e-13, -1.179040234991896e-14,  2.314715226423447e-16, -4.219276060851443e-18,  7.205292743848987e-20, -1.160739049829125e-21,  5.357760587166558e-05,
 -5.830578123801486e-06,  3.521697577380631e-07, -1.539185464220025e-08,  5.405079556756955e-10, -1.612008565660036e-11,  4.224342421980231e-13, -9.951618558151909e-15,
  2.142148240023961e-16, -4.264914442815029e-18,  7.927882718050345e-20, -1.385847182872783e-21,  1.852636237483280e-05, -2.328142408868300e-06,  1.600053383684162e-07,
 -7.872875547396050e-09,  3.087013979362497e-10, -1.021213757287153e-11,  2.951984241781878e-13, -7.634715779348293e-15,  1.796775972321820e-16, -3.896783926143047e-18,
  7.864584264567909e-20, -1.488139869227863e-21,  6.072525821143433e-06, -8.730573257630819e-07,  6.784186318264945e-08, -3.739390782540084e-09,  1.630415449235844e-10,
 -5.961007375833766e-12,  1.894594133983645e-13, -5.363553845937974e-15,  1.376269777120003e-16, -3.242974613748282e-18,  7.088733239584609e-20, -1.448517643959597e-21,
  1.898487463047582e-06, -3.096220058092993e-07,  2.703889302739178e-08, -1.661521283400853e-09,  8.022953211327221e-11, -3.230417152117688e-12,  1.125307963952254e-13,
 -3.476958962641143e-15,  9.701171658987451e-17, -2.477342962186628e-18,  5.850835351240928e-20, -1.288116045710463e-21,  5.701730168200807e-07, -1.046468766660061e-07,
  1.021059300961757e-08, -6.961933675590542e-10,  3.708018908832175e-11, -1.638444104485058e-12,  6.235553412879031e-14, -2.096638831935932e-15,  6.343651291865542e-17,
 -1.751099439537598e-18,  4.457522269223932e-20, -1.054874543912912e-21,  1.658531491126394e-07, -3.399848198742313e-08,  3.685329796408118e-09, -2.775079805907140e-10,
  1.623721677905377e-11, -7.845227085323098e-13,  3.251359887342154e-14, -1.186128527592110e-15,  3.880824573029204e-17, -1.154944170083997e-18,  3.160879328914798e-20,
 -8.021272783837870e-22,  4.716376697340427e-08, -1.072001556682647e-08,  1.283667165114054e-09, -1.062456622541942e-10,  6.800987052402221e-12, -3.579800235693780e-13,
  1.610144376046745e-14, -6.353163579069030e-16,  2.241232265698083e-17, -7.171141576021903e-19,  2.104538595562293e-20, -5.712468971071335e-22,  1.325032297160138e-08,
 -3.315593098690166e-09,  4.361080128351400e-10, -3.948232272617578e-11,  2.753089560469016e-12, -1.572572842524255e-13,  7.649113444652210e-15, -3.253502127549426e-16,
  1.233662681736572e-17, -4.231344260164509e-19,  1.327837344508735e-20, -3.844747466230605e-22,  3.721020764506206e-09, -1.017791729731846e-09,  1.462025795931039e-10,
 -1.440532021610071e-11,  1.089260354187177e-12, -6.724027558711034e-14,  3.523392291627690e-15, -1.609755728239790e-16,  6.538623197508049e-18, -2.396376420529064e-19,
  8.016564428614459e-21, -2.468806430908258e-22,  1.058004864936672e-09, -3.140812472103082e-10,  4.897854106496766e-11, -5.224316780283636e-12,  4.263193256374539e-13,
 -2.831439606511743e-14,  1.591720619870952e-15, -7.780874115502868e-17,  3.373096468771349e-18, -1.316295538518308e-19,  4.678299545671170e-21, -1.527397179496230e-22,
  3.088015945837921e-10, -9.877335149372400e-11,  1.661728109354609e-11, -1.908057344771280e-12,  1.671629880812056e-13, -1.188742168353616e-14,  7.136790033279785e-16,
 -3.716733857303371e-17,  1.712622147465255e-18, -7.088377358059645e-20,  2.666592869229029e-21, -9.196428920010085e-23,  9.385429938541150e-11, -3.210713538821904e-11,
  5.789239419258725e-12, -7.112767686409048e-13,  6.652559629090991e-14, -5.038689506933966e-15,  3.214543659557489e-16, -1.775059795240057e-17,  8.654551756432109e-19,
 -3.782726117205201e-20,  1.499954415119671e-21, -5.442422160209163e-23,  3.012874634042131e-11, -1.094000931318920e-11,  2.099478910808466e-12, -2.742157011120298e-13,
  2.721375774811377e-14, -2.182653971907004e-15,  1.471575361238697e-16, -8.570954953101707e-18,  4.399536391227050e-19, -2.020895099561929e-20,  8.407374065015977e-22,
 -3.195053085455759e-23,  1.034894987330695e-11, -3.957683547063022e-12,  8.024103950502553e-13, -1.106369145451212e-13,  1.157321173243372e-14, -9.767094061395839e-16,
  6.917168796225530e-17, -4.224816149770135e-18,  2.270447806191478e-19, -1.090175656082324e-20,  4.733827002795009e-22, -1.874859291934354e-23,  3.841106332930674e-12,
 -1.534785949577974e-12,  3.261809591615546e-13, -4.712104167153323e-14,  5.158159856310047e-15, -4.549044830122258e-16,  3.361774511189197e-17, -2.139503198202770e-18,
  1.196406947718697e-19, -5.969597709402964e-21,  2.690194373911545e-22, -1.104305320583471e-23,  1.544966526503002e-12, -6.397699516176290e-13,  1.413489294556506e-13,
 -2.122289439219129e-14,  2.412335998073136e-15, -2.206629939608120e-16,  1.689413968748517e-17, -1.112583493164274e-18,  6.430670068569375e-20, -3.312843676517225e-21,
  1.539770568661981e-22, -6.511783909133970e-24,  6.650017476515104e-13, -2.830398540112787e-13,  6.444670196365665e-14, -9.971501204361448e-15,  1.167211378567622e-15,
 -1.098576345982941e-16,  8.646449295734838e-18, -5.848517996842207e-19,  3.468952490148766e-20, -1.832314197748282e-21,  8.724729184755723e-23, -3.776749809301143e-24,
  2.900030605285171e-13, -1.258081028989698e-13,  2.925659535409786e-14, -4.623204975871565e-15,  5.524566403043121e-16, -5.305107369011718e-17,  4.257440561350127e-18,
 -2.934488870724056e-19,  1.772529794378680e-20, -9.528905862907372e-22,  4.615196252816149e-23, -2.030893819184505e-24,  1.006353057137566e-13, -4.412344430690938e-14,
  1.038281464437350e-14, -1.660244848246147e-15,  2.007061201940838e-16, -1.949179130432513e-17,  1.581438272588827e-18, -1.101618052994755e-19,  6.722604899083181e-21,
 -3.649946630841964e-22,  1.784807003028084e-23, -7.926786007683815e-25,  7.967087440546114e-02, -2.657238182105050e-04,  9.271864412731745e-07, -3.353257597232459e-09,
  1.243696398450764e-11, -4.688642400156337e-14,  1.783322006092332e-16, -6.812925207752996e-19,  2.604124646262893e-21, -9.947598838292137e-24,  3.788709141401919e-26,
 -1.439984607931048e-28,  7.295680625594907e-02, -3.193039350066580e-04,  1.689961066048182e-06, -9.206293031953131e-09,  4.919158973300666e-11, -2.560314600618338e-13,
  1.301160288095169e-15, -6.479691941015515e-18,  3.171218094145670e-20, -1.528800045879794e-22,  7.272165537468881e-25, -3.418016178062828e-27,  6.118893567753958e-02,
 -3.955340038413096e-04,  3.026480339843548e-06, -2.175923902653763e-08,  1.471134299755178e-10, -9.493061716188568e-13,  5.904312361054442e-15, -3.562024461226036e-17,
  2.093742870329921e-19, -1.203096279627708e-21,  6.775838487600276e-24, -3.748096830119723e-26,  4.701887997014757e-02, -4.517312462419889e-04,  4.565163801337598e-06,
 -4.091603653850667e-08,  3.379100649454725e-10, -2.627260589903670e-12,  1.946855830109167e-14, -1.386287397928731e-16,  9.541989362243248e-19, -6.377300015712799e-21,
  4.153015136799182e-23, -2.642482375805633e-25,  3.312048255083230e-02, -4.577492034192497e-04,  5.831836287066477e-06, -6.373383861904049e-08,  6.310795752849435e-10,
 -5.805030954058755e-12,  5.035718284115577e-14, -4.161908787579461e-16,  3.301367309815667e-18, -2.527328842045040e-20,  1.875223533736718e-22, -1.353077812788327e-24,
  2.140261256133593e-02, -4.092730655684408e-04,  6.423327906691105e-06, -8.438854449649038e-08,  9.879239936501959e-10, -1.060928396621696e-11,  1.064024946707800e-13,
 -1.008733099670688e-15,  9.118389865310885e-18, -7.910149782121767e-20,  6.618271371047894e-22, -5.361570271135811e-24,  1.269991584083266e-02, -3.242994849010587e-04,
  6.183026874427019e-06, -9.653524517942570e-08,  1.321557039369773e-09, -1.640224578668273e-11,  1.884032106992855e-13, -2.030696661173111e-15,  2.074205601279057e-17,
 -2.022537075054358e-19,  1.893378553977358e-21, -1.709189122059280e-23,  6.928296558504517e-03, -2.292278127840381e-04,  5.253160236576498e-06, -9.652125933958944e-08,
  1.531607828684366e-09, -2.179372288750330e-11,  2.845723565940391e-13, -3.462794345726092e-15,  3.970037136412238e-17, -4.323537052472134e-19,  4.500799035462155e-21,
 -4.500565829971833e-23,  3.480133876747791e-03, -1.454761674385737e-04,  3.970112035845626e-06, -8.512702011190953e-08,  1.554271800537301e-09, -2.518814882902137e-11,
  3.715934055002957e-13, -5.075472716093555e-15,  6.495792803763673e-17, -7.859761770391510e-19,  9.052968805710798e-21, -9.979076340583991e-23,  1.612518550017963e-03,
 -8.339059299289193e-05,  2.686813412960408e-06, -6.673673147816818e-08,  1.393233048175763e-09, -2.556977873089596e-11,  4.239889964233330e-13, -6.468891290580110e-15,
  9.199839808113656e-17, -1.231373398402610e-18,  1.562713280370758e-20, -1.891216617804074e-22,  6.907384427604834e-04, -4.341595452067563e-05,  1.638143574701798e-06,
 -4.682615971538119e-08,  1.111576113810499e-09, -2.298995498837547e-11,  4.265483551382970e-13, -7.239236694982047e-15,  1.139528053040527e-16, -1.680882725354182e-18,
  2.341930501583523e-20, -3.100944323036989e-22,  2.742681636933701e-04, -2.063893451516830e-05,  9.050045300361817e-07, -2.959413638174771e-08,  7.948474232633576e-10,
 -1.844475156280910e-11,  3.813960391865637e-13, -7.173790838795941e-15,  1.245544293946704e-16, -2.018124265218357e-18,  3.077283713734397e-20, -4.444592116581410e-22,
  1.012664664948929e-04, -9.005576585862964e-06,  4.556327845062370e-07, -1.695116072846786e-08,  5.127706222707736e-10, -1.329750911423207e-11,  3.053405829271576e-13,
 -6.344030962039605e-15,  1.211174832303153e-16, -2.149301071147339e-18,  3.576708796376636e-20, -5.619818061017273e-22,  3.489947433890118e-05, -3.626354055378753e-06,
  2.102724857958929e-07, -8.854513516848214e-09,  3.003925384363692e-10, -8.673425289339596e-12,  2.204327250544019e-13, -5.043636490429406e-15,  1.055806254225428e-16,
 -2.046508173285720e-18,  3.707310685365829e-20, -6.321318735029830e-22,  1.127637663899949e-05, -1.355371026946245e-06,  8.949938223952577e-08, -4.245119390470621e-09,
  1.608684173772175e-10, -5.153643088147058e-12,  1.445166159623372e-13, -3.631067699431494e-15,  8.312318894736433e-17, -1.755520575059604e-18,  3.453660117191496e-20,
 -6.376003373831122e-22,  3.433985812878341e-06, -4.731429205857654e-07,  3.536654156060841e-08, -1.880751026104140e-09,  7.930376522351629e-11, -2.809487716515582e-12,
  8.666638937722019e-14, -2.384682595225075e-15,  5.954770921404628e-17, -1.366999190795329e-18,  2.913984818651847e-20, -5.812106677992136e-22,  9.917077673237393e-07,
 -1.553402611848513e-07,  1.306865766483427e-08, -7.756809058440753e-10,  3.625714084988748e-11, -1.415780245989299e-12,  4.790363605323448e-14, -1.439629203578200e-15,
  3.911598232505946e-17, -9.737880193410539e-19,  2.244233368996464e-20, -4.825809820323430e-22,  2.735615784211398e-07, -4.834036171837519e-08,  4.551970231097515e-09,
 -3.002237072944791e-10,  1.549827967035351e-11, -6.648718846653761e-13,  2.460300528234950e-14, -8.053954121396033e-16,  2.375205163927769e-17, -6.397384006311837e-19,
  1.590473695633864e-20, -3.679255063971357e-22,  7.268589856533396e-08, -1.438401039927028e-08,  1.507859987580038e-09, -1.100238154575166e-10,  6.249127053032537e-12,
 -2.935524395880741e-13,  1.184442920330429e-14, -4.211928692132609e-16,  1.344778749659274e-17, -3.909290216157552e-19,  1.046043278372266e-20, -2.597536054003118e-22,
  1.878309961249656e-08, -4.133335617399955e-09,  4.797762405248751e-10, -3.855735057654789e-11,  2.400252389711985e-12, -1.230389468906182e-13,  5.396272045004063e-15,
 -2.078529564511626e-16,  7.165327531895544e-18, -2.242472847378889e-19,  6.442563682239910e-21, -1.713337159871392e-22,  4.773203234005317e-09, -1.159917315843497e-09,
  1.482744001427141e-10, -1.306421319440398e-11,  8.877665253960111e-13, -4.947988833163268e-14,  2.351046146413622e-15, -9.778712604698935e-17,  3.629254397363526e-18,
 -1.219456016386454e-19,  3.751861262050820e-21, -1.065899181754860e-22,  1.207848888932511e-09, -3.218814628930187e-10,  4.506295058877753e-11, -4.332110850101676e-12,
  3.199794691870970e-13, -1.931551053948990e-14,  9.907413612502135e-16, -4.434895284122903e-17,  1.766460182390595e-18, -6.353438686138231e-20,  2.087352326618013e-21,
 -6.317632867065396e-23,  3.086265933609659e-10, -8.956248149691056e-11,  1.365267472708623e-11, -1.424775795865211e-12,  1.138609598155739e-13, -7.412652516651264e-15,
  4.088257539241797e-16, -1.962261961412377e-17,  8.358758108328845e-19, -3.207415914059313e-20,  1.121663951402055e-21, -3.605586081534141e-23,  8.085225804011455e-11,
 -2.536669702527992e-11,  4.184740338676324e-12, -4.714836816721370e-13,  4.056212565595579e-14, -2.834719827991955e-15,  1.673739208118733e-16, -8.578474090631892e-18,
  3.892746044768547e-19, -1.587638268996696e-20,  5.888699904103120e-22, -2.003470679971544e-23,  2.207107873430219e-11, -7.430953892441411e-12,  1.318052848234534e-12,
 -1.593745906605250e-13,  1.467926695676907e-14, -1.095571279118732e-15,  6.891491755866820e-17, -3.754291585592774e-18,  1.806828261909642e-19, -7.799324194546211e-21,
  3.055762072790708e-22, -1.096050309184957e-23,  6.382559992685194e-12, -2.288333655399775e-12,  4.333678364819820e-13, -5.587468851300861e-14,  5.476333567301249e-15,
 -4.339874505235145e-16,  2.892506372081820e-17, -1.666175520406713e-18,  8.462301670167970e-20, -3.847651548322012e-21,  1.585088007394549e-22, -5.967361819870661e-24,
  1.986129446894826e-12, -7.522570841620150e-13,  1.509695736015839e-13, -2.060834702845861e-14,  2.134969892313260e-15, -1.785072443769950e-16,  1.252936367784197e-17,
 -7.587020318376714e-19,  4.043745876169435e-20, -1.926268703839747e-21,  8.300669008846926e-23, -3.263493066613222e-24,  6.736184512014206e-13, -2.673107019891950e-13,
  5.639240306155240e-14, -8.087529281721940e-15,  8.790877352438958e-16, -7.700239639038775e-17,  5.653414261942737e-18, -3.575382208415188e-19,  1.987288265455581e-20,
 -9.858253856706575e-22,  4.417815332893065e-23, -1.803762050321053e-24,  2.505146916446845e-13, -1.032706529936725e-13,  2.270475277448881e-14, -3.392511803732383e-15,
  3.838018431309682e-16, -3.494793557467993e-17,  2.663931677098047e-18, -1.746971376088133e-19,  1.005644690329775e-20, -5.160487691685415e-22,  2.389520580194372e-23,
 -1.006895701275645e-24,  1.011895366303059e-13, -4.295591599918399e-14,  9.752776521281162e-15, -1.504692133536716e-15,  1.756419373997069e-16, -1.648692104115783e-17,
  1.294250697518362e-18, -8.732491527442574e-20,  5.167040072129555e-21, -2.722905637314727e-22,  1.293630675678560e-23, -5.587787229023283e-25,  4.214477375336659e-14,
 -1.826006012540585e-14,  4.240437955792928e-15, -6.691505878024720e-16,  7.985202763335797e-17, -7.657834627251154e-18,  6.137656147702738e-19, -4.225195043455839e-20,
  2.549094931430799e-21, -1.368771580132874e-22,  6.622017037359319e-24, -2.910830525279024e-25,  1.424516727287664e-14, -6.242722220885579e-15,  1.468186003786908e-15,
 -2.346373984544719e-16,  2.834965883282564e-17, -2.751729784455647e-18,  2.231404769977558e-19, -1.553583792596638e-20,  9.475981240859622e-22, -5.142347721479635e-23,
  2.513389141281707e-24, -1.115744677097282e-25,  7.862256395180058e-02, -2.584639699788440e-04,  8.881110895612722e-07, -3.161541776759244e-09,  1.154053736002326e-11,
 -4.282626969756882e-14,  1.603708371881697e-16, -6.034098082954361e-19,  2.271830198900861e-21, -8.551503101063374e-24,  3.209061132343143e-26, -1.202417723318683e-28,
  7.170594860471446e-02, -3.062131468738858e-04,  1.584044293894901e-06, -8.458555603631267e-09,  4.436911482513120e-11, -2.268710101200089e-13,  1.133146970127047e-15,
 -5.547628192118102e-18,  2.669780001234802e-20, -1.265876292982252e-22,  5.923412170694832e-25, -2.739242783765503e-27,  5.965362429561526e-02, -3.723279842968883e-04,
  2.778889863698152e-06, -1.954993988951497e-08,  1.294673043201376e-10, -8.188522061361976e-13,  4.994589107201820e-15, -2.956400270305603e-17,  1.705687879284707e-19,
 -9.623560093451519e-22,  5.323378754347679e-24, -2.892938326376642e-26,  4.528201267972769e-02, -4.170858288550773e-04,  4.104955510025610e-06, -3.590571047146529e-08,
  2.897398690372554e-10, -2.203345274239585e-12,  1.598208138547207e-14, -1.114685091750522e-16,  7.519145051913108e-19, -4.927122133408087e-21,  3.147151013344440e-23,
 -1.964784028613364e-25,  3.137818256171168e-02, -4.139904995874179e-04,  5.123984919726769e-06, -5.450346224429599e-08,  5.261790672706697e-10, -4.725152631721890e-12,
  4.005575601653081e-14, -3.237657412205127e-16,  2.513337350918138e-18, -1.883989902581212e-20,  1.369428212601294e-22, -9.684205952333405e-25,  1.986223919812801e-02,
 -3.616836471734829e-04,  5.498928511605666e-06, -7.014953910295512e-08,  7.991469754804919e-10, -8.364045681757570e-12,  8.184882881998415e-14, -7.578258704187701e-16,
  6.695411039438557e-18, -5.680589572047071e-20,  4.651030948035599e-22, -3.689019909227381e-24,  1.149478616019058e-02, -2.791329242039144e-04,  5.141393988685784e-06,
 -7.778707822897763e-08,  1.034484144704478e-09, -1.249411893893802e-11,  1.398378210924096e-13, -1.470185909116439e-15,  1.466051266816243e-17, -1.396648468083198e-19,
  1.278209762526870e-21, -1.128698918153513e-23,  6.088647567405656e-03, -1.914498233525442e-04,  4.228673417065208e-06, -7.516200314836235e-08,  1.156862243967538e-09,
 -1.599715780134868e-11,  2.032869514094965e-13, -2.410207167530677e-15,  2.694969812091884e-17, -2.864767275662075e-19,  2.913018244561099e-21, -2.847096015825409e-23,
  2.955831401658992e-03, -1.174139678508661e-04,  3.082620785188699e-06, -6.384862178872675e-08,  1.129291517628161e-09, -1.776422136046873e-11,  2.547802125499247e-13,
 -3.387422983976552e-15,  4.224523020299914e-17, -4.985387570749293e-19,  5.604875738418052e-21, -6.034691357751218e-23,  1.317361139669782e-03, -6.475604657897600e-05,
  2.004482957280595e-06, -4.803936965009382e-08,  9.704833404155806e-10, -1.727194260197750e-11,  2.781853419989863e-13, -4.128165825297476e-15,  5.716677601294109e-17,
 -7.457768509914431e-19,  9.232535567223437e-21, -1.090770832813357e-22,  5.401110751604168e-04, -3.228775825409584e-05,  1.169397430024058e-06, -3.222527731012471e-08,
  7.396438910043046e-10, -1.482317812289269e-11,  2.669529279394604e-13, -4.403841054647042e-15,  6.746060574732964e-17, -9.693756176735100e-19,  1.316881848765738e-20,
 -1.701506537852343e-22,  2.042152946642485e-04, -1.462833206043232e-05,  6.154489073845008e-07, -1.939137215297353e-08,  5.032882237342423e-10, -1.131074883372628e-11,
  2.269033611546741e-13, -4.146560437417605e-15,  7.003355870091704e-17, -1.105005586412799e-18,  1.642329092829482e-20, -2.314018589236875e-22,  7.141917987495615e-05,
 -6.052592535180302e-06,  2.938103660114832e-07, -1.052961123860790e-08,  3.077064176300006e-10, -7.725669927226238e-12,  1.720560951252915e-13, -3.472241283350419e-15,
  6.446984892351410e-17, -1.113852577977610e-18,  1.806403892944304e-20, -2.768436507991491e-22,  2.318553583449002e-05, -2.299013382146389e-06,  1.279462757576403e-07,
 -5.190464502153312e-09,  1.701064800679033e-10, -4.754968422151058e-12,  1.171984846937140e-13, -2.604480305838594e-15,  5.302071161648148e-17, -1.000558697398755e-18,
  1.766384378721753e-20, -2.937795549588475e-22,  7.017055571564978e-06, -8.061466778077182e-07,  5.112745605672712e-08, -2.337182028992124e-09,  8.558067995563462e-11,
 -2.654776574428375e-12,  7.220887607490118e-14, -1.762397957470721e-15,  3.924111632808615e-17, -8.069771293730126e-19,  1.547408561197912e-20, -2.787025091577474e-22,
  1.989968237148223e-06, -2.625509788492783e-07,  1.886867464372843e-08, -9.677362628240053e-10,  3.945109673543735e-11, -1.353939761032298e-12,  4.052828853788545e-14,
 -1.083674561142997e-15,  2.632936701187400e-17, -5.887550939373762e-19,  1.223710012893326e-20, -2.382037804799376e-22,  5.320180848328857e-07, -7.996687009670199e-08,
  6.476984154776285e-09, -3.711469568994599e-10,  1.678651223539480e-11, -6.354574718943926e-13,  2.087763022667297e-14, -6.100865144647228e-16,  1.613826268526561e-17,
 -3.915656538933810e-19,  8.803887163049729e-21, -1.848586792882061e-22,  1.350562354150501e-07, -2.295459497716179e-08,  2.084479832526913e-09, -1.329054760979083e-10,
  6.646282585002999e-12, -2.766911984513650e-13,  9.951046519096351e-15, -3.170245589204503e-16,  9.109679452375073e-18, -2.393232385305381e-19,  5.809089598611911e-21,
 -1.313200111683964e-22,  3.283096343979613e-08, -6.265221387178531e-09,  6.346130670945740e-10, -4.483796076790129e-11,  2.470576986726322e-12, -1.127686974843242e-13,
  4.427500159079818e-15, -1.533962912966582e-16,  4.777104575157750e-18, -1.355923653710906e-19,  3.545798904098896e-21, -8.612560149772539e-23,  7.718474661824481e-09,
 -1.642528041704610e-09,  1.846378542711042e-10, -1.439599784012453e-11,  8.708870846086033e-13, -4.344669820177161e-14,  1.856890611624396e-15, -6.978100892476498e-17,
  2.349451821750537e-18, -7.188304229131392e-20,  2.020741030222237e-21, -5.262725836896615e-23,  1.775205005614385e-09, -4.184397873417449e-10,  5.193244652039938e-11,
 -4.449124565490225e-12,  2.943983364131610e-13, -1.599857677223322e-14,  7.420718766184681e-16, -3.016244622169641e-17,  1.095036494414836e-18, -3.602417423136220e-20,
  1.086052525903769e-21, -3.025792892918086e-23,  4.047336728219804e-10, -1.049594081332714e-10,  1.430595378170642e-11, -1.340595675620016e-12,  9.664026815771307e-14,
 -5.700078901696431e-15,  2.859785974929031e-16, -1.253362420311437e-17,  4.892202835479172e-19, -1.725733885902183e-20,  5.564878689280926e-22, -1.654349172404083e-23,
  9.285275195187323e-11, -2.630999115848225e-11,  3.916361233203174e-12, -3.994828423810687e-13,  3.123652199113114e-14, -1.991719934788183e-15,  1.076864699099923e-16,
 -5.071309536893493e-18,  2.121239575933751e-19, -7.998488510131619e-21,  2.750538984526757e-22, -8.700055227662930e-24,  2.179514857690183e-11, -6.699877803431617e-12,
  1.082712178625721e-12, -1.195824271357818e-13,  1.009356226548093e-14, -6.926567463762726e-16,  4.019035962392273e-17, -2.025772312595422e-18,  9.046535422188876e-20,
 -3.633313397114748e-21,  1.327875290011769e-22, -4.454132581828532e-24,  5.329812735776441e-12, -1.764312527871175e-12,  3.075533722610826e-13, -3.656705186711553e-14,
  3.313968558498834e-15, -2.435295796254424e-16,  1.509295230454782e-17, -8.105998504900774e-19,  3.848264536814661e-20, -1.639499835007283e-21,  6.343121285632509e-23,
 -2.247826007594417e-24,  1.383708434884866e-12, -4.894237918722230e-13,  9.139061681807187e-14, -1.162231008016898e-14,  1.124138924635790e-15, -8.796106638874888e-17,
  5.791568244858114e-18, -3.297361846226423e-19,  1.656009053998894e-20, -7.448888583102330e-22,  3.037058802894780e-23, -1.132055674310018e-24,  3.885032298862713e-13,
 -1.456348004494160e-13,  2.891028232872930e-14, -3.904503054582819e-15,  4.003440674637762e-16, -3.314276940325557e-17,  2.304222248801288e-18, -1.382592611968092e-19,
  7.304530125575867e-21, -3.450330997835335e-22,  1.474805716155631e-23, -5.753404869342781e-25,  1.198745699071073e-13, -4.721855043280641e-14,  9.882710861764332e-15,
 -1.406320260666591e-15,  1.517125108036485e-16, -1.319273994294606e-17,  9.618447210519287e-19, -6.042250964354953e-20,  3.336824959184276e-21, -1.645045345904001e-22,
  7.328155076087098e-24, -2.974955668411356e-25,  4.103753730571224e-14, -1.683484440401663e-14,  3.681775590107474e-15, -5.472629770698984e-16,  6.160027110956007e-17,
 -5.581813050293787e-18,  4.234812489054867e-19, -2.764598436470851e-20,  1.584532901438480e-21, -8.097111088595529e-23,  3.734236732850692e-24, -1.567463946352638e-25,
  1.549343562877528e-14, -6.558537521290892e-15,  1.484456218710716e-15, -2.283238445475092e-16,  2.657248006890590e-17, -2.487062656043736e-18,  1.946944581883050e-19,
 -1.310103795794426e-20,  7.731875152098207e-22, -4.064364275817328e-23,  1.926314747349571e-24, -8.301462781363486e-26,  6.143672209264650e-15, -2.658259935713842e-15,
  6.163880227379810e-16, -9.712179862523797e-17,  1.157292079443012e-17, -1.108271041743411e-18,  8.870445294650941e-20, -6.098351142086398e-21,  3.674463981589841e-22,
 -1.970607803741689e-23,  9.522236740890039e-25, -4.180844374395516e-26,  2.018893596861775e-15, -8.842903721596932e-16,  2.078498220586296e-16, -3.319795468145820e-17,
  4.008767114861707e-18, -3.888864432941247e-19,  3.151774532460773e-20, -2.193194464254088e-21,  1.337020967791564e-22, -7.251916924835186e-24,  3.542697834135110e-25,
 -1.571912230565958e-26,  7.760268191956306e-02, -2.515077600066762e-04,  8.512528765472516e-07, -2.983541858801945e-09,  1.072117371387048e-11, -3.917217621199414e-14,
  1.444485698892476e-16, -5.353991500011971e-19,  1.985861738804337e-21, -7.367655965335645e-24,  2.724419942178755e-26, -1.006705662525483e-28,  7.050581447056738e-02,
 -2.939350702917142e-04,  1.486655972982311e-06, -7.783522633333834e-09,  4.009154951187354e-11, -2.014469996325248e-13,  9.891201901828195e-16, -4.761865764350953e-18,
  2.253962144288030e-20, -1.051375158395990e-22,  4.840665556643836e-25, -2.202988583404215e-27,  5.820733692693086e-02, -3.510012510900458e-04,  2.556199357754156e-06,
 -1.760323717797281e-08,  1.142249673314407e-10, -7.083293975710990e-13,  4.238282772998132e-15, -2.462138700067771e-17,  1.394688733712960e-19, -7.728361092040628e-22,
  4.199904035572452e-24, -2.242867940731398e-26,  4.367672682744297e-02, -3.858940683945641e-04,  3.700512526048643e-06, -3.160258145714860e-08,  2.492692391303903e-10,
 -1.854665427335927e-12,  1.317279425965605e-14, -9.001825354860635e-17,  5.952593442412425e-19, -3.825443315599397e-21,  2.397303797162576e-23, -1.468873797890431e-25,
  2.980025505207890e-02, -3.754785232558469e-04,  4.517499113047646e-06, -4.679131529577548e-08,  4.405995365598300e-10, -3.864102405835031e-12,  3.202140980779510e-14,
 -2.532115527982149e-16,  1.924231969910673e-18, -1.412780041833881e-20,  1.006303442285614e-22, -6.976351448104762e-25,  1.849844704336861e-02, -3.208540830356058e-04,
  4.728658896925934e-06, -5.860150585564928e-08,  6.499085804631166e-10, -6.631861335510295e-12,  6.334568696271729e-14, -5.729973037317544e-16,  4.949538839724909e-18,
 -4.108301366088473e-20,  3.292607868584332e-22, -2.557624607281973e-24,  1.045497856495013e-02, -2.414720445266969e-04,  4.299568014564094e-06, -6.306514105539873e-08,
  8.150839340015565e-10, -9.583296930604596e-12,  1.045497616754300e-13, -1.072524212926539e-15,  1.044459695453531e-17, -9.724188648160119e-20,  8.702953961610840e-22,
 -7.519423207602212e-24,  5.385208951813042e-03, -1.609362462660650e-04,  3.428029989599521e-06, -5.896797284097763e-08,  8.807075486864000e-10, -1.183943255098474e-11,
  1.464713839598797e-13, -1.692579636195120e-15,  1.846344798428321e-17, -1.916304124064059e-19,  1.903884830620423e-21, -1.819257086957833e-23,  2.531045552279262e-03,
 -9.553556087608222e-05,  2.414119182571373e-06, -4.831969763581658e-08,  8.281960195931245e-10, -1.265006753002105e-11,  1.764409563240846e-13, -2.284173722053221e-15,
  2.776598525320098e-17, -3.196646320213578e-19,  3.508787224870560e-21, -3.690965446916725e-23,  1.087098488868031e-03, -5.078617880289865e-05,  1.510853419722364e-06,
 -3.494826883534796e-08,  6.834179362767666e-10, -1.179831687482614e-11,  1.846297798695992e-13, -2.665558704030424e-15,  3.595176282266375e-17, -4.572397891014270e-19,
  5.523009098718950e-21, -6.371334156552542e-23,  4.274782123406574e-04, -2.429867024360700e-05,  8.449394053169019e-07, -2.245249272500902e-08,  4.983971480857252e-10,
 -9.681003872756162e-12,  1.692694415707764e-13, -2.714839335553525e-15,  4.047993440854948e-17, -5.667564896669751e-19,  7.508438645974238e-21, -9.468443052572158e-23,
  1.542482034010865e-04, -1.051408126885044e-05,  4.244636197108186e-07, -1.288794739388913e-08,  3.232935138524924e-10, -7.037743790567190e-12,  1.369947114490989e-13,
 -2.432746285616876e-15,  3.997517346854480e-17, -6.143017777047136e-19,  8.900472864797364e-21, -1.223537673116815e-22,  5.121385674372864e-05, -4.134268748458336e-06,
  1.925415016699294e-07, -6.647346025112652e-09,  1.876754494190242e-10, -4.562471858132120e-12,  9.855898312579327e-14, -1.932132785089978e-15,  3.489225286397462e-17,
 -5.869733281526852e-19,  9.277719175406112e-21, -1.386991266977674e-22,  1.569905509200401e-05, -1.484661592029794e-06,  7.928740456375102e-08, -3.098457176391106e-09,
  9.809333305106278e-11, -2.654555321379642e-12,  6.345424323647359e-14, -1.369616557709543e-15,  2.711539112464968e-17, -4.981825168524760e-19,  8.571067092782912e-21,
 -1.390476623056852e-22,  4.461105257409265e-06, -4.895313361583716e-07,  2.980950298761047e-08, -1.313026286070994e-09,  4.645142440722364e-11, -1.395133295585982e-12,
  3.680461160852770e-14, -8.725342765772212e-16,  1.889480421574395e-17, -3.783318799594394e-19,  7.070691646016471e-21, -1.242337226519372e-22,  1.180928518914540e-06,
 -1.490818987756516e-07,  1.029618354943213e-08, -5.091251505555535e-10,  2.006109726475750e-11, -6.668223032278405e-13,  1.936534369801155e-14, -5.031015413379830e-16,
  1.189156140838077e-17, -2.589778200804030e-19,  5.247737232670670e-21, -9.968006075744643e-23,  2.929398660586668e-07, -4.221422487356524e-08,  3.289847644643067e-09,
 -1.819153927628589e-10,  7.958365995695077e-12, -2.919662891226343e-13,  9.311601815536894e-15, -2.645140564975502e-16,  6.810360000295602e-18, -1.610110618794019e-19,
  3.530991009430971e-21, -7.238241869747539e-23,  6.857682753900215e-08, -1.119958403847459e-08,  9.800600170243961e-10, -6.037298764621967e-11,  2.923207310366367e-12,
 -1.180450991412504e-13,  4.124516394227129e-15, -1.278329068065675e-16,  3.577865220806028e-18, -9.165315395512956e-20,  2.171388340899175e-21, -4.795374991864197e-23,
  1.527862266257115e-08, -2.808603406362086e-09,  2.746562377295852e-10, -1.877724316897980e-11,  1.003085984145013e-12, -4.446459015300443e-14,  1.697888178766488e-15,
 -5.728675218144406e-17,  1.739387947411475e-18, -4.818513335294815e-20,  1.230978087272970e-21, -2.923566140641242e-23,  3.272252395598842e-09, -6.726283602585495e-10,
  7.315527298934281e-11, -5.529279177125610e-12,  3.248237983878521e-13, -1.576051427186505e-14,  6.560235850342581e-16, -2.403910713080230e-17,  7.900804600804863e-19,
 -2.362036124643932e-20,  6.494121011576365e-22, -1.655549241739872e-23,  6.816914994140162e-10, -1.556746543541498e-10,  1.873915672585368e-11, -1.559613196186446e-12,
  1.004093173036421e-13, -5.316392319272043e-15,  2.405573878429338e-16, -9.549130298193832e-18,  3.389167302744159e-19, -1.091013001871544e-20,  3.221288590187793e-22,
 -8.796584633732185e-24,  1.400511384061845e-10, -3.530024522295572e-11,  4.679327995087148e-12, -4.270235647890561e-13,  3.001739172775755e-14, -1.728569563249388e-15,
  8.476466736632586e-17, -3.634755705884699e-18,  1.389392331374668e-19, -4.803837493422458e-21,  1.519525524214476e-22, -4.434522198767115e-24,  2.882936303559087e-11,
 -7.966584840492217e-12,  1.156741779178336e-12, -1.152158142743658e-13,  8.806846891888286e-15, -5.495264298603328e-16,  2.910377379346980e-17, -1.343781335703723e-18,
  5.515450095789552e-20, -2.042290301275117e-21,  6.901720000625426e-23, -2.146805920792370e-24,  6.054009698648719e-12, -1.821328973301623e-12,  2.880166775233624e-13,
 -3.115337110263616e-14,  2.577581147616285e-15, -1.735414718686539e-16,  9.887558277098194e-18, -4.897561706717538e-19,  2.150851521652383e-20, -8.500902449382058e-22,
  3.059349635252533e-23, -1.011144666310489e-24,  1.322979692357319e-12, -4.301349057428674e-13,  7.361656323581196e-14, -8.598559224484343e-15,  7.660916382510494e-16,
 -5.538570914030954e-17,  3.379382143728667e-18, -1.788022066768156e-19,  8.367642277950448e-21, -3.516197620125156e-22,  1.342533186404897e-23, -4.697612969253427e-25,
  3.073270129359223e-13, -1.071423478748361e-13,  1.970930653163697e-14, -2.470190335178496e-15,  2.355959010800696e-16, -1.818855271265386e-17,  1.182243713555026e-18,
 -6.648328097703611e-20,  3.299611565108994e-21, -1.467414270102045e-22,  5.917942205406558e-24, -2.182905745296023e-25,  7.753892322229782e-14, -2.874597451812312e-14,
  5.640316767829125e-15, -7.531245237535142e-16,  7.637653678581218e-17, -6.256463735639569e-18,  4.305899584778367e-19, -2.558656830741659e-20,  1.339241218305971e-21,
 -6.269569146122423e-23,  2.656900912330904e-24, -1.027974148659862e-25,  2.166720220549529e-14, -8.466903339875631e-15,  1.757090966831924e-15, -2.479543260676810e-16,
  2.653369630853173e-17, -2.289458424095590e-18,  1.656750615241600e-19, -1.033319499690922e-20,  5.667310208313146e-22, -2.775539321629440e-23,  1.228577654411535e-24,
 -4.957243075689319e-26,  6.796380784739685e-15, -2.773450183713482e-15,  6.031143622779699e-16, -8.914572949500584e-17,  9.979836775383846e-18, -8.995755299473675e-19,
  6.790549030449151e-20, -4.411601350376724e-21,  2.516756148845425e-22, -1.280337253468724e-23,  5.879301333727371e-25, -2.457691192718626e-26,  2.388152239042385e-15,
 -1.007844636095613e-15,  2.273540697538326e-16, -3.485356292104181e-17,  4.043230380132469e-18, -3.772516735929900e-19,  2.944389761388488e-20, -1.975574190516751e-21,
  1.162694585596882e-22, -6.095538661458459e-24,  2.881568401420501e-25, -1.238748384901314e-26,  8.985759845889368e-16, -3.882303605906829e-16,  8.987625483307494e-17,
 -1.413865776192277e-17,  1.682099580067293e-18, -1.608395102711690e-19,  1.285440912944171e-20, -8.824720394042451e-22,  5.309892763834535e-23, -2.843910244727140e-24,
  1.372456281410470e-25, -6.018496900551580e-27,  2.864960733240937e-16, -1.254185113551000e-16,  2.946111819334503e-17, -4.702639132774839e-18,  5.675128600314763e-19,
 -5.502092292758180e-20,  4.456630754347597e-21, -3.099427762494877e-22,  1.888434188380552e-23, -1.023721873446640e-24,  4.998444821160831e-26, -2.216701809056735e-27,
  7.661004821632082e-02, -2.448380891870012e-04,  8.164543498101144e-07, -2.818087237512946e-09,  9.971219659638280e-12, -3.587836154000091e-14,  1.303086368261689e-16,
 -4.758933804743332e-19,  1.739220205782321e-21, -6.361496284184260e-24,  2.318144023234303e-26, -8.450660059480842e-29,  6.935328413899171e-02, -2.824048247316628e-04,
  1.396973592728436e-06, -7.173043458494586e-09,  3.628960530486504e-11, -1.792299669264369e-13,  8.653422796477977e-16, -4.097601630144912e-18,  1.908105608218974e-20,
 -8.758117633622305e-23,  3.968446526501665e-25, -1.777769214437221e-27,  5.684293575301919e-02, -3.313665843033583e-04,  2.355475894280526e-06, -1.588366932407657e-08,
  1.010222273166165e-10, -6.144036720396287e-13,  3.607403856322830e-15, -2.057294848423439e-17,  1.144472376592204e-19, -6.230188993324307e-22,  3.327071950707928e-24,
 -1.746404732651536e-26,  4.219004909630228e-02, -3.577418024574234e-04,  3.344040706457904e-06, -2.789466259137243e-08,  2.151438471571363e-10, -1.566732973113299e-12,
  1.089950580405486e-14, -7.300027194675499e-17,  4.733530689270891e-19, -2.984229900273443e-21,  1.835301314331246e-23, -1.103941038001326e-25,  2.836722657918445e-02,
 -3.414702840414665e-04,  3.995879538060722e-06, -4.032051432557607e-08,  3.704624053881741e-10, -3.174153218082687e-12,  2.572229216785324e-14, -1.990531533451355e-16,
  1.481254105251847e-18, -1.065523004517614e-20,  7.439311793683810e-23, -5.057362535268486e-25,  1.728647245826922e-02, -2.856704786045156e-04,  4.083708427941866e-06,
 -4.918661319366383e-08,  5.312617728582568e-10, -5.287475280694963e-12,  4.931373800644063e-14, -4.359387958335259e-16,  3.682799332340494e-18, -2.991483233298028e-20,
  2.347524354020689e-22, -1.786325988624032e-24,  9.553385368730715e-03, -2.098946532856954e-04,  3.615124673114644e-06, -5.143036286534204e-08,  6.462597415413174e-10,
 -7.399712664587218e-12,  7.871638849353583e-14, -7.881873573170222e-16,  7.498210040701605e-18, -6.824518325273286e-20,  5.974567583348011e-22, -5.052234676380946e-24,
  4.792146817215359e-03, -1.361197470126094e-04,  2.797725605667229e-06, -4.659495155168061e-08,  6.755530504263205e-10, -8.831947478763427e-12,  1.064100473956798e-13,
 -1.198864914913274e-15,  1.276232956912951e-17, -1.293667182101748e-19,  1.256144722697491e-21, -1.173816726769304e-23,  2.184151354765420e-03, -7.833451794806460e-05,
  1.906130524183071e-06, -3.688255936578897e-08,  6.128370502498700e-10, -9.092303221661793e-12,  1.233693939785095e-13, -1.555587682523192e-15,  1.843647352736735e-17,
 -2.071268627174859e-19,  2.220265180064864e-21, -2.282372217414289e-23,  9.057119759206658e-04, -4.020746504822159e-05,  1.150011199648981e-06, -2.568377338820978e-08,
  4.863297274705138e-10, -8.146639086699849e-12,  1.239008715309654e-13, -1.740774798766184e-15,  2.287342150189804e-17, -2.836732980707364e-19,  3.344019900757258e-21,
 -3.767549901491152e-23,  3.422698179831640e-04, -1.849471010201914e-05,  6.176163827992124e-07, -1.582980601175420e-08,  3.399279145919476e-10, -6.401313363089046e-12,
  1.086920752135060e-13, -1.695243625713044e-15,  2.460929519586027e-17, -3.357836484836346e-19,  4.339050329964184e-21, -5.341266582496458e-23,  1.181151867073954e-04,
 -7.658699961444226e-06,  2.967206368333902e-07, -8.683447680801905e-09,  2.105684179532517e-10, -4.440938543056970e-12,  8.389704150074333e-14, -1.447980420060072e-15,
  2.315285155959670e-17, -3.465753281283043e-19,  4.895858544637617e-21, -6.567357966994802e-23,  3.731612217061152e-05, -2.868144486467441e-06,  1.281499809330142e-07,
 -4.262364435068808e-09,  1.162757586544435e-10, -2.737314375953128e-12,  5.736319355715452e-14, -1.092507254966699e-15,  1.919149125636016e-17, -3.143841400303970e-19,
  4.843511923287931e-21, -7.063882580443119e-23,  1.082647855628895e-05, -9.759624944794793e-07,  5.000710228623372e-08, -1.882414241358086e-09,  5.756911529230123e-11,
 -1.508267358326594e-12,  3.496690673102385e-14, -7.330807674026115e-16,  1.411490834987884e-17, -2.524888402227000e-19,  4.233569466541953e-21, -6.699464487558381e-23,
  2.895531306702622e-06, -3.032913341656781e-07,  1.772714503028617e-08, -7.522528275954158e-10,  2.570899933612206e-11, -7.475395946728287e-13,  1.912585061512721e-14,
 -4.404011973374792e-16,  9.274998823502171e-18, -1.808168886080408e-19,  3.293496092953120e-21, -5.644945525207796e-23,  7.171945089174875e-07, -8.656430645590008e-08,
  5.742804250159607e-09, -2.737002840528251e-10,  1.042163627582230e-11, -3.354500881342091e-13,  9.450011340524397e-15, -2.385026911662525e-16,  5.483574987929474e-18,
 -1.162962260953009e-19,  2.297161327174224e-21, -4.257409055731334e-23,  1.654518940955276e-07, -2.283852250401379e-08,  1.711554077918083e-09, -9.128904820862756e-11,
  3.861560129339759e-12, -1.372545873740641e-13,  4.248182578925601e-15, -1.172842836803803e-16,  2.938479874972551e-18, -6.767951654556177e-20,  1.447385420700636e-21,
 -2.896072854782561e-23,  3.579468874690263e-08, -5.611596759334359e-09,  4.728846890098284e-10, -2.812860304456409e-11,  1.318083429674947e-12, -5.160902715447109e-14,
  1.751230238490189e-15, -5.278524253631307e-17,  1.438563854744243e-18, -3.592246622236328e-20,  8.304262406858761e-22, -1.791145557559171e-23,  7.323008797262617e-09,
 -1.295333792244022e-09,  1.221941904618856e-10, -8.077993203368103e-12,  4.181276582114431e-13, -1.799055432284902e-14,  6.678185526231691e-16, -2.193323417141672e-17,
  6.490227967274926e-19, -1.754103724471919e-20,  4.376144042358145e-22, -1.015887938643010e-23,  1.430975116154837e-09, -2.837953345215090e-10,  2.983566641810788e-11,
 -2.184324983690232e-12,  1.245240741472241e-13, -5.872606003196284e-15,  2.379302675651058e-16, -8.496983582631634e-18,  2.724734914836675e-19, -7.955904589076019e-21,
  2.138345450772863e-22, -5.333771395825043e-24,  2.702992045848026e-10, -5.973002861734340e-11,  6.966447116311568e-12, -5.627623821304857e-13,  3.522365498924337e-14,
 -1.815770663529476e-15,  8.009594312985378e-17, -3.103206237844910e-18,  1.076102798433217e-19, -3.387838413702605e-21,  9.791238122997717e-23, -2.619392116860062e-24,
  5.006000808430753e-11, -1.224843217348778e-11,  1.577359121235312e-12, -1.400461435571624e-13,  9.591277055905060e-15, -5.388096862311580e-16,  2.580580984984333e-17,
 -1.081918586593665e-18,  4.047466051546364e-20, -1.370796124413047e-21,  4.250849806368004e-23, -1.217135353169388e-24,  9.242595283002853e-12, -2.487735917177940e-12,
  3.519594135461242e-13, -3.419759131089001e-14,  2.552998465763078e-15, -1.557591528678585e-16,  8.074194759703500e-18, -3.652388884228088e-19,  1.469970267991558e-20,
 -5.341654485001211e-22,  1.772850810276667e-23, -5.419735409149349e-25,  1.734153843076236e-12, -5.099802701962229e-13,  7.883012613115466e-14, -8.342144011084358e-15,
  6.759468086937303e-16, -4.461138065279864e-17,  2.493802299451095e-18, -1.212953980913016e-19,  5.234814016706948e-21, -2.034668519463399e-22,  7.205858214133109e-24,
 -2.345199522902649e-25,  3.378915945926505e-13, -1.077799897275595e-13,  1.809192306258518e-14, -2.073942459383419e-15,  1.814920175630762e-16, -1.289799321270026e-17,
  7.741670583891038e-19, -4.032263001591109e-20,  1.858847304161918e-21, -7.699209518592471e-23,  2.899217677714013e-24, -1.001063468576893e-25,  7.000714941683818e-14,
 -2.403262331985146e-14,  4.351085001315676e-15, -5.369592193549461e-16,  5.045776737836390e-17, -3.840424622612230e-18,  2.462472910930717e-19, -1.366814379570845e-20,
  6.699273785195815e-22, -2.943790121493707e-23,  1.173606278571657e-24, -4.281443720604529e-26,  1.580752606739494e-14, -5.791064771199498e-15,  1.122217845681943e-15,
 -1.480335674427562e-16,  1.483770921610157e-17, -1.201861871245655e-18,  8.182953448532888e-20, -4.812518645042467e-21,  2.494120485127080e-22, -1.156561714053894e-23,
  4.856727870772010e-25, -1.862739423142289e-26,  3.981741215239635e-15, -1.542633987855471e-15,  3.172237038254506e-16, -4.436597791006477e-17,  4.706691390708606e-18,
 -4.027502043122276e-19,  2.891282332134370e-20, -1.789530660704985e-21,  9.742881398139212e-23, -4.737966650513572e-24,  2.083067030662168e-25, -8.350629478322835e-27,
  1.138835225053896e-15, -4.620971801193104e-16,  9.987358442085813e-17, -1.467326001625616e-17,  1.633079342260918e-18, -1.463771228636116e-19,  1.098974259161756e-20,
 -7.102629714512029e-22,  4.031754924126159e-23, -2.041236514579123e-24,  9.330233591555303e-26, -3.883066474433162e-27,  3.707655683736260e-16, -1.559530058732541e-16,
  3.505379516995663e-17, -5.354590931429084e-18,  6.190119356846778e-19, -5.756331031190769e-20,  4.478248215319720e-21, -2.995421734216623e-22,  1.757656022040209e-23,
 -9.188269675690154e-25,  4.331632885951269e-26, -1.857186393691178e-27,  1.318963790067203e-16, -5.689610514589038e-17,  1.314868433512667e-17, -2.064870165444511e-18,
  2.452460768770147e-19, -2.341164468542438e-20,  1.868117868679561e-21, -1.280531194410381e-22,  7.693704584037897e-24, -4.114801455493538e-25,  1.983063289110546e-26,
 -8.684677110786494e-28,  4.071145603766536e-17, -1.781174123246770e-17,  4.181292981438379e-18, -6.669875595183767e-19,  8.043975947501011e-20, -7.793779181204965e-21,
  6.308976139163946e-22, -4.385031849298594e-23,  2.670170752897134e-24, -1.446678109117490e-25,  7.059666510269519e-27, -3.129125617392034e-28,  7.564354871295161e-02,
 -2.384390638573506e-04,  7.835713986399969e-07, -2.664122758349561e-09,  9.283878802808849e-12, -3.290477079772886e-14,  1.177295994243345e-16, -4.237306176670369e-19,
  1.526038733761101e-21, -5.504482534571706e-24,  1.976664898915424e-26, -7.112541945368394e-29,  6.824548485128210e-02, -2.715637365903238e-04,  1.314266133085509e-06,
 -6.619995966086087e-09,  3.290373936417343e-11, -1.597723567009507e-13,  7.587047455994109e-16, -3.534537546277269e-18,  1.619597854102443e-20, -7.316662744029169e-23,
  3.263451776480449e-25, -1.439389552245721e-27,  5.555398746986351e-02, -3.132586195055114e-04,  2.174179209682595e-06, -1.436110288557468e-08,  8.955532542974515e-11,
 -5.343444906261550e-13,  3.079436660028492e-15, -1.724524085522109e-17,  9.423986831023786e-20, -5.041101879032737e-22,  2.646070612708658e-24, -1.365544331169398e-26,
  4.081054613117989e-02, -3.322721939067097e-04,  3.028968733009103e-06, -2.468949074846763e-08,  1.862679469703124e-10, -1.328055707833136e-12,  9.052367418799437e-15,
 -5.943918301819483e-17,  3.780431662899755e-19, -2.338718870379600e-21,  1.411890552005464e-23, -8.339249889151090e-26,  2.706235131658463e-02, -3.113424824758208e-04,
  3.545606511599980e-06, -3.486924145256796e-08,  3.127274876762765e-10, -2.618678780874003e-12,  2.075859537030543e-14, -1.572569654277459e-16,  1.146269630482383e-18,
 -8.080911653925495e-21,  5.531783622820509e-23, -3.688615703091708e-25,  1.620558560677796e-02, -2.552249042620449e-04,  3.541177977889495e-06, -4.147203844406628e-08,
  4.364236809557971e-10, -4.238037905436844e-12,  3.860752903823634e-14, -3.336511197757403e-16,  2.757523078124125e-18, -2.192633219685009e-20,  1.685222338649162e-22,
 -1.256546411710397e-24,  8.767974174380916e-03, -1.832771467146043e-04,  3.055430553200669e-06, -4.217855813119641e-08,  5.155008735600862e-10, -5.750352125120525e-12,
  5.966752506155534e-14, -5.833436644133009e-16,  5.422884256111622e-18, -4.826417060860442e-20,  4.134299397917804e-22, -3.422584570638097e-24,  4.289133006006024e-03,
 -1.158033259389380e-04,  2.298030370641768e-06, -3.707109046166316e-08,  5.219549147689734e-10, -6.638756375213504e-12,  7.792291938087349e-14, -8.562154086958542e-16,
  8.897536572983392e-18, -8.811045496123174e-20,  8.363793904774992e-22, -7.645103495084142e-24,  1.898726637710634e-03, -6.470198898303998e-05,  1.516854603050319e-06,
 -2.838475376191656e-08,  4.573889559025497e-10, -6.593771333538112e-12,  8.706320706190154e-14, -1.069573735170907e-15,  1.236281904397610e-17, -1.355721049877914e-19,
  1.419566488985656e-21, -1.426399962586921e-23,  7.615019815784912e-04, -3.211932471715485e-05,  8.835982028620543e-07, -1.905958976861482e-08,  3.495756140564182e-10,
 -5.683795711132214e-12,  8.403806798178286e-14, -1.149333144898007e-15,  1.471648171334086e-17, -1.780169363396951e-19,  2.048476467910358e-21, -2.254507715977542e-23,
  2.770885479933930e-04, -1.423003257752369e-05,  4.564855062537307e-07, -1.128810491422826e-08,  2.345594550022186e-10, -4.283394837310547e-12,  7.064755160770923e-14,
 -1.071774705851791e-15,  1.515093671911116e-17, -2.015094412153575e-19,  2.540382426698784e-21, -3.053167918916243e-23,  9.164075228695633e-05, -5.650567991724124e-06,
  2.101228581167566e-07, -5.927915362370782e-09,  1.389891825583939e-10, -2.840515332454524e-12,  5.209031485110565e-14, -8.739333902701553e-16,  1.360022708410355e-17,
 -1.983418019903391e-19,  2.732210097903208e-21, -3.576824930592621e-23,  2.760972328957549e-05, -2.019632856085119e-06,  8.657407454273199e-08, -2.774395041468199e-09,
  7.313752922642288e-11, -1.667541121794301e-12,  3.390439023684423e-14, -6.274130087326982e-16,  1.072219888869001e-17, -1.710601054405514e-19,  2.569049194456453e-21,
 -3.655523255455250e-23,  7.599097664033241e-06, -6.526303475187464e-07,  3.207993827043893e-08, -1.163192120772157e-09,  3.436517507463333e-11, -8.716960424621487e-13,
  1.960102641397984e-14, -3.991677482904784e-16,  7.475085173773349e-18, -1.301953268855055e-19,  2.127647185727537e-21, -3.284405401117933e-23,  1.917384625655939e-06,
 -1.915822950011951e-07,  1.074543157628377e-08, -4.392332591832919e-10,  1.450035031144796e-11, -4.081686762721130e-13,  1.012775795198087e-14, -2.265058089201332e-16,
  4.639195961426244e-18, -8.805527873606174e-20,  1.563130922375282e-21, -2.613451447855840e-23,  4.454392447162800e-07, -5.136460325825474e-08,  3.271955760522668e-09,
 -1.502610754453826e-10,  5.527821596370239e-12, -1.722728961080647e-13,  4.707127872743979e-15, -1.153983338318556e-16,  2.580557832097288e-18, -5.329082267358009e-20,
  1.026017966104430e-21, -1.855185183686442e-23,  9.579187954339477e-08, -1.265511251230074e-08,  9.115051177071984e-10, -4.687591818493365e-11,  1.916670654347894e-12,
 -6.598615176180331e-14,  1.981591511509833e-15, -5.315856780945655e-17,  1.295790475235064e-18, -2.906966551737895e-20,  6.061474794125398e-22, -1.183640623316978e-23,
  1.919544690790398e-08, -2.885944571221599e-09,  2.340355734661483e-10, -1.343535813644967e-11,  6.090208359694656e-13, -2.311240917844996e-14,  7.613929009518082e-16,
 -2.231228167257484e-17,  5.919316754427305e-19, -1.440472413913397e-20,  3.248426194590490e-22, -6.841320280877097e-24,  3.613401551559511e-09, -6.143690236197105e-10,
  5.586253895468677e-11, -3.568623417420739e-12,  1.788803512232434e-13, -7.466953667146114e-15,  2.693287242138104e-16, -8.606914688765461e-18,  2.481151399154397e-19,
 -6.539886285323731e-21,  1.592781204492409e-22, -3.612920506678369e-24,  6.453275120413874e-10, -1.233374993866583e-10,  1.252244595368055e-11, -8.873494391403188e-13,
  4.905628261530530e-14, -2.247317878843624e-15,  8.857541932744875e-17, -3.081217834646131e-18,  9.635637954776786e-20, -2.746626355758225e-21,  7.213660307573880e-23,
 -1.759820160321358e-24,  1.106641223383086e-10, -2.363415641681378e-11,  2.668130774449227e-12, -2.090201495149897e-13,  1.270901218027802e-14, -6.374047224959953e-16,
  2.739242348505292e-17, -1.035197136052396e-18,  3.505369247197348e-20, -1.078703038402373e-21,  3.050076594100779e-23, -7.989885610293396e-25,  1.848754989963394e-11,
 -4.385477669281831e-12,  5.480775098006661e-13, -4.729764640172364e-14,  3.153218142163961e-15, -1.726690759038403e-16,  8.071100068767862e-18, -3.306203065455878e-19,
  1.209700281153565e-20, -4.010785680375841e-22,  1.218609111685447e-23, -3.421464849803819e-25,  3.061157738283559e-12, -8.015226914388217e-13,  1.103675071640879e-13,
 -1.045039966794917e-14,  7.612617622683696e-16, -4.537348010891760e-17,  2.300320783737274e-18, -1.018690109108186e-19,  4.017434723007718e-21, -1.431723071176847e-22,
  4.663784215753394e-24, -1.400406012328511e-25,  5.126502859145715e-13, -1.471868942359825e-13,  2.221415124975025e-14, -2.297561653090205e-15,  1.821453353739909e-16,
 -1.177364623873454e-17,  6.452088819243462e-19, -3.079200882824520e-20,  1.304980926896524e-21, -4.984640633230653e-23,  1.736073985193753e-24, -5.560323782326225e-26,
  8.888083462211278e-14, -2.778272982472328e-14,  4.569071218522122e-15, -5.135311705666876e-16,  4.409900697258620e-17, -3.077959269006073e-18,  1.815906158634275e-19,
 -9.303614578011274e-21,  4.221774688320814e-22, -1.722384026832154e-23,  6.392381835394913e-25, -2.176711572586832e-26,  1.637400307967587e-14, -5.529220470609216e-15,
  9.842752937572689e-16, -1.194927975955045e-16,  1.105350310476323e-17, -8.287374850813756e-19,  5.237912591906349e-20, -2.867565298993214e-21,  1.387076906862078e-22,
 -6.018460658089916e-24,  2.370441275270095e-25, -8.547602600492579e-27,  3.295534976990050e-15, -1.192016242217237e-15,  2.279411749521598e-16, -2.968070698468775e-17,
  2.938075702225327e-18, -2.351564197127942e-19,  1.582842520445742e-20, -9.207357077441772e-22,  4.721865378374017e-23, -2.167635795651120e-24,  9.014877451624076e-26,
 -3.425648140286971e-27,  7.447225976905910e-16, -2.858654011234271e-16,  5.821067852997500e-17, -8.063279347277491e-18,  8.475183577451555e-19, -7.187876797108663e-20,
  5.116177904301855e-21, -3.140783234210364e-22,  1.696588001476805e-23, -8.188611873077200e-25,  3.574232500782311e-26, -1.422958237176962e-27,  1.932391253560104e-16,
 -7.792820919668080e-17,  1.673168345186491e-17, -2.442234581893940e-18,  2.701046021746886e-19, -2.406387420718367e-20,  1.796189971933225e-21, -1.154405751079896e-22,
  6.517877259962416e-24, -3.283007510786199e-25,  1.493230366497766e-26, -6.185216770600592e-28,  5.800971400471037e-17, -2.431292639368685e-17,  5.443555724150214e-18,
 -8.283160248149008e-19,  9.539834869140436e-20, -8.839302282255611e-21,  6.852840283679912e-22, -4.568456764152026e-23,  2.672092293179754e-24, -1.392553663123402e-25,
  6.545497725720519e-27, -2.798417050357807e-28,  1.943487226414439e-17, -8.369332267863249e-18,  1.930522670972844e-18, -3.026033999637617e-19,  3.587504089058298e-20,
 -3.418669218020080e-21,  2.723271503153957e-22, -1.863652218003617e-23,  1.117954410687662e-24, -5.970026655164093e-26,  2.872940798544200e-27, -1.256409214365210e-28,
  5.793535242377981e-18, -2.533168485948049e-18,  5.942473811499947e-19, -9.472653039461243e-20,  1.141633442529655e-20, -1.105383204872096e-21,  8.942109415387291e-23,
 -6.211232837349082e-24,  3.779859155297088e-25, -2.046668042088750e-26,  9.981728973276748e-28, -4.421792193623650e-29,  7.470213062687156e-02, -2.322958943830754e-04,
  7.524719472578708e-07, -2.520695878364632e-09,  8.653105230688749e-12, -3.021629353608499e-14,  1.065200707489506e-16, -3.779212753888858e-19,  1.341386530127889e-21,
 -4.772989103343815e-24,  1.688882443137412e-26, -6.002494659274315e-29,  6.717976736610705e-02, -2.613586541040232e-04,  1.237882606014605e-06, -6.118142987803390e-09,
  2.988265769891968e-11, -1.426948294767505e-13,  6.666147846789955e-16, -3.056009593635029e-18,  1.378245752976208e-20, -6.129554519475309e-23,  2.691752842717997e-25,
 -1.169181894739877e-27,  5.433468176569441e-02, -2.965309466235833e-04,  2.010103192194481e-06, -1.300985546342258e-08,  7.957008077498434e-11, -4.659077067877387e-13,
  2.636200242892990e-15, -1.450062398874452e-17,  7.786074151201207e-20, -4.093649535061690e-22,  2.112540138596772e-24, -1.072091495600690e-26,  3.952811341274874e-02,
 -3.091768193828011e-04,  2.749736798342332e-06, -2.191043044952267e-08,  1.617513413145272e-10, -1.129477519867065e-12,  7.545513941593359e-15, -4.858669462605076e-17,
  3.031891509243350e-19, -1.841005471212907e-21,  1.091283471161285e-23, -6.330803444243293e-26,  2.587117608085976e-02, -2.845701037622658e-04,  3.155552891022700e-06,
 -3.025894685947590e-08,  2.649996501456623e-10, -2.169420206855508e-12,  1.682806556368993e-14, -1.248337145362285e-16,  8.915634244973619e-19, -6.161517726399718e-21,
  4.136608245576886e-23, -2.706214336229437e-25,  1.523835244974222e-02, -2.287735608498565e-04,  3.082767896532930e-06, -3.512000726528673e-08,  3.602206078023174e-10,
 -3.414278167615207e-12,  3.039068768193169e-14, -2.568398579700939e-16,  2.077276470301636e-18, -1.617352137831719e-20,  1.217820569132305e-22, -8.900006555391807e-25,
  8.080733939365569e-03, -1.607263180801201e-04,  2.595218375328246e-06, -3.477801417740679e-08,  4.135859369954608e-10, -4.496224082213909e-12,  4.552330551114732e-14,
 -4.346927213461995e-16,  3.950010942828777e-18, -3.438734730635017e-20,  2.882957867051042e-22, -2.337116983511555e-24,  3.860058696828792e-03, -9.906599256692866e-05,
  1.899211568098888e-06, -2.968800908216208e-08,  4.060940223613537e-10, -5.026836552367507e-12,  5.750061670307320e-14, -6.163939994756995e-16,  6.254639108432038e-18,
 -6.052686786439637e-20,  5.618236056180562e-22, -5.024710469737508e-24,  1.662194408748857e-03, -5.381454295147710e-05,  1.216136759235065e-06, -2.201743565956222e-08,
  3.441961401742571e-10, -4.823073420844846e-12,  6.199152587141057e-14, -7.422140265902243e-16,  8.369191321111888e-18, -8.960823161250098e-20,  9.167723228487146e-22,
 -9.006511007294209e-24,  6.458374068001113e-04, -2.587829291626541e-05,  6.850183095042831e-07, -1.427625651469089e-08,  2.537139565281433e-10, -4.005243954549494e-12,
  5.758872203991461e-14, -7.668851607240928e-16,  9.571328472355373e-18, -1.129555042930130e-19,  1.269107061609351e-21, -1.364727663646366e-23,  2.266964733412455e-04,
 -1.106213655740253e-05,  3.409916490175508e-07, -8.137669477327605e-09,  1.636732409168375e-10, -2.899245937761632e-12,  4.646085569258226e-14, -6.857601714339079e-16,
  9.442294423855067e-18, -1.224400742384807e-19,  1.506208192389229e-21, -1.767757042829137e-23,  7.199811343759743e-05, -4.220234265276144e-06,  1.506553512910865e-07,
 -4.098157844314121e-09,  9.292715414496048e-11, -1.840724298903846e-12,  3.277390306069101e-14, -5.346158674971145e-16,  8.098748140239328e-18, -1.150901913890137e-19,
  1.546249197766931e-21, -1.975845239705027e-23,  2.073059486250634e-05, -1.442592292779219e-06,  5.933038470165513e-08, -1.832131736726072e-09,  4.667937022130253e-11,
 -1.030926946553536e-12,  2.033963774508995e-14, -3.657717797005829e-16,  6.081996260285350e-18, -9.451051892438386e-20,  1.383822176532768e-21, -1.921321909822685e-23,
  5.425090356020132e-06, -4.436527212825632e-07,  2.091884210828008e-08, -7.306249321847412e-10,  2.085343791311929e-11, -5.121685945748358e-13,  1.117108402087564e-14,
 -2.209977963334664e-16,  4.025463666375243e-18, -6.827176944681956e-20,  1.087460805639159e-21, -1.637646833903680e-23,  1.294447137919356e-06, -1.233021558522143e-07,
  6.634815003902937e-09, -2.612162516929911e-10,  8.329600228234668e-12, -2.269806027441058e-13,  5.461942066196824e-15, -1.186457163045473e-16,  2.363279916610113e-18,
 -4.367340309380999e-20,  7.555785525328917e-22, -1.232294529230031e-23,  2.827340430719426e-07, -3.112474083977921e-08,  1.903034446925626e-09, -8.419241494060857e-11,
  2.991971085440135e-12, -9.026895135797873e-14,  2.392044411427959e-15, -5.695850145734293e-17,  1.238747815674718e-18, -2.490734501257498e-20,  4.673866510841470e-22,
 -8.244355102283679e-24,  5.681515333988839e-08, -7.177500742360239e-09,  4.966099822921291e-10, -2.461566794387970e-11,  9.726152390250709e-13, -3.242553063556645e-14,
  9.445970239749756e-16, -2.461786499032821e-17,  5.837391652043667e-19, -1.275343999749887e-20,  2.592461736271175e-22, -4.939776464578620e-24,  1.056970105298082e-08,
 -1.522500927391004e-09,  1.187397121721954e-10, -6.575417213773207e-12,  2.882164404021725e-13, -1.059769701930463e-14,  3.388344513999117e-16, -9.650883990624552e-18,
  2.491683850601395e-19, -5.907673408981081e-21,  1.299320947431323e-22, -2.671300607270980e-24,  1.834683304965674e-09, -2.995249457351353e-10,  2.623068871125686e-11,
 -1.618250489981394e-12,  7.851170588345014e-14, -3.178035387540886e-15,  1.113375437722594e-16, -3.460671653805075e-18,  9.715369824273736e-20, -2.496614301804177e-21,
  5.934001110164753e-23, -1.314813446414101e-24,  3.000259434163460e-10, -5.519661893385055e-11,  5.407301448390623e-12, -3.705826992690274e-13,  1.985485641469894e-14,
 -8.830333723443153e-16,  3.383970160319409e-17, -1.146088301423305e-18,  3.493629305693663e-20, -9.717688570089644e-22,  2.492925650045573e-23, -5.945767305915870e-25,
  4.677704460090734e-11, -9.643054523278096e-12,  1.052676353369390e-12, -7.990421235673141e-14,  4.716034593535508e-15, -2.299633515780011e-16,  9.622000142206892e-18,
 -3.544834314949929e-19,  1.171482213337477e-20, -3.521905898218904e-22,  9.737924846048090e-24, -2.496654579990561e-25,  7.055357353295963e-12, -1.620484488007374e-12,
  1.963240962225614e-13, -1.645182807407504e-14,  1.066758009493474e-15, -5.689689400148537e-17,  2.593756560818904e-18, -1.037416941816822e-19,  3.710108053484828e-21,
 -1.203484865617622e-22,  3.580642828307638e-24, -9.852755836305747e-26,  1.047844950369912e-12, -2.665500831149467e-13,  3.568179345779094e-14, -3.289155047893974e-15,
  2.335763104403452e-16, -1.358911640065914e-17,  6.732461445008529e-19, -2.916629632096197e-20,  1.126315250644992e-21, -3.933926309473446e-23,  1.256944546543965e-24,
 -3.704941631443471e-26,  1.565132112063084e-13, -4.381498457593975e-14,  6.449165843748370e-15, -6.512337305306189e-16,  5.046433329103912e-17, -3.191895128098099e-18,
  1.713358582098542e-19, -8.016797847916411e-21,  3.333921004791309e-22, -1.250599911551985e-23,  4.280617401345628e-25, -1.348345058969914e-26,  2.410233987738618e-14,
 -7.374015596630940e-15,  1.186793641808114e-15, -1.306443223113893e-16,  1.099856182120716e-17, -7.532684271036635e-19,  4.364486740464170e-20, -2.197819782770056e-21,
  9.809784112363782e-23, -3.939304352541823e-24,  1.439986096195442e-25, -4.832546023849355e-27,  3.936653563606303e-15, -1.306203505026703e-15,  2.283846853527461e-16,
 -2.724898963387849e-17,  2.479045904090985e-18, -1.829349475093688e-19,  1.138776136708136e-20, -6.144430410000002e-22,  2.931075370299536e-23, -1.254939917400717e-24,
  4.879945260579963e-26, -1.738245885429133e-27,  7.034309024829032e-16, -2.509783620970547e-16,  4.731553620549956e-17, -6.076454766870926e-18,  5.935669278583455e-19,
 -4.690712689403554e-20,  3.119126546359336e-21, -1.793371860047908e-22,  9.095015619728230e-24, -4.130786859066339e-25,  1.700409063837157e-26, -6.398410020814300e-28,
  1.419220474417693e-16, -5.393597036726661e-17,  1.086775669641225e-17, -1.489943489830440e-18,  1.550569908107707e-19, -1.302574257599331e-20,  9.187149030153253e-22,
 -5.590794327609466e-23,  2.994826018309985e-24, -1.433890945094157e-25,  6.210723328796522e-27, -2.454413602025972e-28,  3.323317800677172e-17, -1.331303007098118e-17,
  2.838050648607569e-18, -4.113566212673255e-19,  4.518731977946781e-20, -3.999615257042323e-21,  2.966799695052888e-22, -1.895351470733478e-23,  1.063996510284614e-24,
 -5.329801671613308e-26,  2.411395604187556e-27, -9.937953811703166e-29,  9.152265628504381e-18, -3.820975816037868e-18,  8.518893590255510e-19, -1.290868403343585e-19,
  1.480703538911484e-20, -1.366631129452417e-21,  1.055543430196577e-22, -7.011518099728648e-24,  4.086896548783845e-25, -2.122822767137333e-26,  9.946293956389033e-28,
 -4.239414607896084e-29,  2.875627153912135e-18, -1.236060565198999e-18,  2.845391514996713e-19, -4.451071963294239e-20,  5.266599870220613e-21, -5.009224513034580e-22,
  3.982991587045598e-23, -2.720931657829814e-24,  1.629444734180583e-25, -8.687243514494037e-27,  4.173965481337918e-28, -1.822622344212281e-29,  8.257325497104172e-19,
 -3.608052803686401e-19,  8.457767715489014e-20, -1.347219104937904e-20,  1.622470536412949e-21, -1.569835204646352e-22,  1.269055039809830e-23, -8.808985801572507e-25,
  5.357221326533107e-26, -2.898913781719739e-27,  1.412945410961739e-28, -6.255441178900517e-30,  7.378479829096300e-02, -2.263948036063939e-04,  7.230347923819230e-07,
 -2.386945412000949e-09,  8.073511462163538e-12, -2.778209716491685e-14,  9.651428527690998e-17, -3.376207600294590e-19,  1.181108447822901e-21, -4.147418995218534e-24,
  1.445682432591812e-26, -5.080103207607881e-29,  6.615368508844247e-02, -2.517413474258933e-04,  1.167242185103428e-06, -5.662010593639236e-09,  2.718206680505190e-11,
 -1.276750235573793e-13,  5.869035783383638e-16, -2.648295686727668e-18,  1.175784433315671e-20, -5.149021400418871e-23,  2.226667826566461e-25, -9.526875662735048e-28,
  5.317976052981362e-02, -2.810536375975006e-04,  1.861326925245172e-06, -1.180797494846467e-08,  7.085312661181674e-11, -4.072426222533885e-13,  2.262960044660238e-15,
 -1.222944497637943e-17,  6.453749477216169e-20, -3.335872024242559e-22,  1.692867187671371e-24, -8.450273261610178e-27,  3.833379665813697e-02, -2.881882843919676e-04,
  2.501624960792915e-06, -1.949372961827830e-08,  1.408679363203785e-10, -9.636723393735277e-13,  6.311522228007007e-15, -3.986597256051523e-17,  2.441425867314873e-19,
 -1.455466739074157e-21,  8.473315760941184e-24, -4.829201065299223e-26,  2.478118241711851e-02, -2.607091908032016e-04,  2.816521646476290e-06, -2.634524882526957e-08,
  2.253826904801206e-10, -1.804460958280005e-12,  1.370094457422270e-14, -9.955527998297425e-17,  6.968711682335943e-19, -4.722466189650060e-21,  3.110226629052959e-23,
 -1.996824022807983e-25,  1.437004516478956e-02, -2.057041418673000e-04,  2.693777564374538e-06, -2.986544914099618e-08,  2.986829504292239e-10, -2.764194609452362e-12,
  2.404854459257103e-14, -1.988143630308887e-16,  1.574033090962412e-18, -1.200357207016575e-20,  8.857159977049520e-23, -6.346002696625558e-25,  7.476859300498810e-03,
 -1.415278885205581e-04,  2.214800518610659e-06, -2.882456785647689e-08,  3.336704039510501e-10, -3.536507261938399e-12,  3.495018468968895e-14, -3.260604508150856e-16,
  2.897041164232955e-18, -2.467657954539315e-20,  2.025375324977813e-22, -1.608239789440519e-24,  3.492072269276346e-03, -8.519404809612277e-05,  1.578850548273558e-06,
 -2.392530328023923e-08,  3.180683328174117e-10, -3.833181726040927e-12,  4.274467897784160e-14, -4.471700531504592e-16,  4.432029796324065e-18, -4.192365648065242e-20,
  3.806300924344199e-22, -3.331624339123551e-24,  1.464844227144975e-03, -4.505550331263406e-05,  9.820309101675982e-07, -1.720770945836096e-08,  2.610739146250155e-10,
 -3.557143352255014e-12,  4.452027105973196e-14, -5.196453264088810e-16,  5.717852631267639e-18, -5.978968153539330e-20,  5.978321208522016e-22, -5.743670232054882e-24,
  5.522895054603534e-04, -2.102003051029632e-05,  5.356410171506129e-07, -1.078929952052673e-08,  1.858551878505945e-10, -2.849612211525441e-12,  3.985616932939261e-14,
 -5.169327120796082e-16,  6.290354599043825e-18, -7.244310946259374e-20,  7.948994099482016e-22, -8.353806337369185e-24,  1.873428301328153e-04, -8.684335702526353e-06,
  2.573185293726244e-07, -5.928154532962480e-09,  1.154441990197460e-10, -1.984149393980246e-12,  3.090192360933194e-14, -4.438726736330571e-16,  5.954370384848188e-18,
 -7.529549247009717e-20,  9.040232070208718e-22, -1.036309179081579e-23,  5.724851853180624e-05, -3.188970372585280e-06,  1.093092856543331e-07, -2.867709915872896e-09,
  6.290242866977479e-11, -1.207936697665960e-12,  2.088620322462173e-14, -3.313270030692403e-16,  4.886830812707127e-18, -6.768325371845385e-20,  8.870336539111966e-22,
 -1.106560055907559e-23,  1.578632648202855e-05, -1.044605251466226e-06,  4.122288341217046e-08, -1.226810525633847e-09,  3.021436334926284e-11, -6.464816177791203e-13,
  1.237881902354807e-14, -2.163637283506848e-16,  3.500993571078292e-18, -5.299756228371803e-20,  7.566413236013350e-22, -1.025194287033698e-23,  3.936742423292787e-06,
 -3.063931752539643e-07,  1.385725216494313e-08, -4.662182167293836e-10,  1.285648453803665e-11, -3.057641716929087e-13,  6.469635395298148e-15, -1.243455273263542e-16,
  2.203258505716080e-18, -3.638935909849271e-20,  5.650021708835324e-22, -8.301149085163858e-24,  8.903389434141424e-07, -8.080014372920733e-08,  4.170372714699903e-09,
 -1.581296811173958e-10,  4.870448795301177e-12, -1.284811109663239e-13,  2.998403618755080e-15, -6.326216540931068e-17,  1.225511543334991e-18, -2.205049796401670e-20,
  3.718025108005269e-22, -5.915206140642329e-24,  1.832756211828372e-07, -1.924722657563950e-08,  1.129172732296405e-09, -4.811581108924156e-11,  1.651553607634104e-12,
 -4.823378743316778e-14,  1.239489256285549e-15, -2.866499367804497e-17,  6.062662084471168e-19, -1.186839216587216e-20,  2.170530132297372e-22, -3.734845152066985e-24,
  3.449744857999190e-08, -4.163932018591211e-09,  2.766226337964344e-10, -1.321134640147759e-11,  5.043135943512430e-13, -1.627797272821635e-14,  4.599214588389334e-16,
 -1.164303439586819e-17,  2.685227218555294e-19, -5.712627245700226e-21,  1.131913028374106e-22, -2.104301716820267e-24,  5.972367472767682e-09, -8.234443607265062e-10,
  6.172336501466901e-11, -3.295616965142838e-12,  1.396314816560083e-13, -4.973004907186905e-15,  1.542719127601290e-16, -4.269741593075706e-18,  1.072567475296579e-19,
 -2.477098119236500e-21,  5.312321277448639e-23, -1.065963505538661e-24,  9.580827108258662e-10, -1.500287906248381e-10,  1.264475501416197e-11, -7.529123007212860e-13,
  3.533812309527933e-14, -1.386509354835071e-15,  4.716072841925425e-17, -1.425274871158415e-18,  3.895354266574594e-20, -9.756157403249910e-22,  2.262331714905934e-23,
 -4.895116873742758e-25,  1.437512758036730e-10, -2.542737065486176e-11,  2.401387465543876e-12, -1.590565549971040e-13,  8.253613980540959e-15, -3.561679553187858e-16,
  1.326438732480799e-17, -4.371801429933402e-19,  1.298471738450235e-20, -3.522970814480378e-22,  8.824247831956406e-24, -2.056843775110741e-25,  2.041045203669330e-11,
 -4.056420923012675e-12,  4.277652759123473e-13, -3.143458795016432e-14,  1.799602872090976e-15, -8.526028822420182e-17,  3.471203537731551e-18, -1.245957098143401e-19,
  4.016446922650911e-21, -1.179073984406669e-22,  3.186423044086949e-24, -7.992094121354776e-26,  2.782569845404937e-12, -6.180056474588531e-13,  7.250246424055998e-14,
 -5.894202407724704e-15,  3.714039613587226e-16, -1.927955804790206e-17,  8.565492149853460e-19, -3.342852512353619e-20,  1.167794731443032e-21, -3.703983055301209e-23,
  1.078533187323564e-24, -2.907026276351523e-26,  3.708387284216827e-13, -9.152434752776837e-14,  1.189722934279636e-14, -1.066556750071848e-15,  7.376804379530915e-17,
 -4.185572276545508e-18,  2.024840262206788e-19, -8.574946194834462e-21,  3.240266046300513e-22, -1.108455071763194e-23,  3.471745765052439e-25, -1.003933475464836e-26,
  4.938108366711203e-14, -1.346101531883644e-14,  1.930033945451530e-15, -1.900768368737923e-16,  1.438294452289661e-17, -8.893841533312978e-19,  4.672321295328892e-20,
 -2.141690746344229e-21,  8.733246366759924e-23, -3.214889169729795e-24,  1.080729281107295e-25, -3.345780395585337e-27,  6.744215622482929e-15, -2.016979141512257e-15,
  3.173101068790759e-16, -3.417514123635193e-17,  2.817791110066953e-18, -1.891917470419250e-19,  1.075632879574198e-20, -5.319511125754453e-22,  2.333625647272644e-23,
 -9.217267595398411e-25,  3.316260609199712e-26, -1.096129924106625e-27,  9.739783647885046e-16, -3.171782921679960e-16,  5.441103320702884e-17, -6.373612143699721e-18,
  5.697479300071206e-19, -4.134315292241172e-20,  2.532695561627230e-21, -1.345776198299798e-22,  6.326355758431283e-24, -2.670883565400235e-25,  1.024719561065547e-26,
 -3.603351498009559e-28,  1.539151267153500e-16, -5.411558242527905e-17,  1.004838049345016e-17, -1.271573239640996e-18,  1.224671085201305e-19, -9.548040024934649e-21,
  6.267472128639344e-22, -3.559254899340386e-23,  1.783827222471429e-24, -8.010512011648452e-26,  3.261847652017889e-27, -1.214694525021590e-28,  2.758973058681013e-17,
 -1.037278247351936e-17,  2.066494121456777e-18, -2.801936879001294e-19,  2.885064412143262e-20, -2.399027004591187e-21,  1.675605428928836e-22, -1.010194650388467e-23,
  5.363111162429410e-25, -2.545884926645317e-26,  1.093697091745968e-27, -4.288336738813398e-29,  5.798452895021457e-18, -2.306107626291163e-18,  4.878328372444040e-19,
 -7.017452112622910e-20,  7.652485876333133e-21, -6.725984763554587e-22,  4.955693328855928e-23, -3.145628459439950e-24,  1.754999397047201e-25, -8.739343657815281e-27,
  3.931637146509519e-28, -1.611556927106034e-29,  1.457033654303394e-18, -6.057279098690340e-19,  1.344296888958812e-19, -2.027819111720127e-20,  2.315865891934931e-21,
 -2.128465255100382e-22,  1.637323390174003e-23, -1.083390670299307e-24,  6.291443175792527e-26, -3.256265968780138e-27,  1.520476486348665e-28, -6.459517521102659e-30,
  4.273956467815647e-19, -1.833442512696712e-19,  4.211285162635511e-20, -6.573390900663013e-21,  7.761287357312550e-22, -7.366889361092794e-23,  5.846096724876782e-24,
 -3.986112731835634e-25,  2.382749139390502e-26, -1.268112008592034e-27,  6.082614592617929e-29, -2.651755710591560e-30,  1.178819478074481e-19, -5.147240892316996e-20,
  1.205635069134250e-20, -1.918914314869283e-21,  2.309178463361554e-22, -2.232576784501734e-23,  1.803488943673060e-24, -1.250975388963243e-25,  7.602585136700808e-27,
 -4.111162382846076e-28,  2.002492237812777e-29, -8.859893871995384e-31,  7.289060927092822e-02, -2.207229440787668e-04,  6.951485674294929e-07, -2.262091648564628e-09,
  7.540288724760513e-12, -2.557505808063314e-14,  8.756836583689854e-17, -3.021068251380920e-19,  1.041693269933698e-21, -3.611489705354269e-24,  1.239549187085271e-26,
 -4.312847592664254e-29,  6.516497544906276e-02, -2.426679821473150e-04,  1.101825682865431e-06, -5.246784674465178e-09,  2.476362953799274e-11, -1.144383019446149e-13,
  5.177519452406444e-16, -2.300062750524532e-18,  1.005491090969845e-20, -4.336793215288017e-23,  1.847137567607440e-25, -7.786661734220309e-28,  5.208445621908313e-02,
 -2.667111333410558e-04,  1.726173596324496e-06, -1.073664520576216e-08,  6.322480883061420e-11, -3.568179536930083e-13,  1.947732138464163e-15, -1.034401604608695e-17,
  5.366269430357883e-20, -2.727572163235008e-22,  1.361467634871743e-24, -6.686092635334667e-27,  3.721964022371246e-02, -2.690740807811658e-04,  2.280613163318937e-06,
 -1.738616422544164e-08,  1.230232041283378e-10, -8.247541278862113e-13,  5.297217263086871e-15, -3.283028338016841e-17,  1.973672805984516e-19, -1.155476358500542e-21,
  6.608266711338846e-24, -3.700947690774221e-26,  2.378149083284250e-02, -2.393829167174409e-04,  2.520879842693676e-06, -2.301087786053902e-08,  1.923682931091200e-10,
 -1.506717886862034e-12,  1.120165432643211e-14, -7.975161575860038e-17,  5.472897665936920e-19, -3.637735108735995e-21,  2.350894131637075e-23, -1.481558848270067e-25,
  1.358816866468629e-02, -1.855102279830206e-04,  2.362338014786035e-06, -2.549922896571819e-08,  2.487476039892383e-10, -2.248515588340878e-12,  1.912652202152895e-14,
 -1.547266795048444e-16,  1.199477453501480e-18, -8.961810976981665e-21,  6.481876581944968e-23, -4.554244786920544e-25,  6.944115284899923e-03, -1.251073993523600e-04,
  1.898743548231474e-06, -2.400903312923435e-08,  2.706396476797756e-10, -2.797551623336040e-12,  2.699521145970510e-14, -2.461338541502153e-16,  2.138932879825404e-18,
 -1.783116341540410e-20,  1.433170831855247e-22, -1.114957070731676e-24,  3.174854250884557e-03, -7.363062800721546e-05,  1.319921147753529e-06, -1.939776558024096e-08,
  2.507265085210017e-10, -2.942828524039930e-12,  3.200197519742515e-14, -3.268191973164685e-16,  3.164837638922328e-18, -2.927113964843607e-20,  2.600106297192203e-22,
 -2.227900724762279e-24,  1.299120493280036e-03, -3.795926679620733e-05,  7.984291574396977e-07, -1.354621431231296e-08,  1.995363363844884e-10, -2.644417218006941e-12,
  3.223846618196977e-14, -3.669503474189054e-16,  3.941201065171964e-18, -4.025944797902142e-20,  3.935240914358860e-22, -3.698301569301246e-24,  4.760257081139838e-04,
 -1.720625275934063e-05,  4.222866047482904e-07, -8.224122837631780e-09,  1.373640945223483e-10, -2.046214535802447e-12,  2.784798279806772e-14, -3.518853650142843e-16,
  4.175974028983286e-18, -4.694358789812850e-20,  5.031754818171101e-22, -5.169095774343425e-24,  1.563127043408936e-04, -6.881711679308562e-06,  1.960736303246443e-07,
 -4.362083233709727e-09,  8.227245886429552e-11, -1.372388984890864e-12,  2.077857575275529e-14, -2.905279958427029e-16,  3.797891804697585e-18, -4.684484602580110e-20,
  5.490539931016577e-22, -6.148726868995838e-24,  4.604557871685898e-05, -2.436710280523506e-06,  8.021847335201879e-08, -2.030168238655190e-09,  4.308752630045883e-11,
 -8.023511770498768e-13,  1.347585464212673e-14, -2.079373512393471e-16,  2.986669836471017e-18, -4.032359554971391e-20,  5.156030208974494e-22, -6.280389764550733e-24,
  1.218466143105241e-05, -7.663779350647995e-07,  2.902222104149335e-08, -8.325284999284005e-10,  1.982357602736215e-11, -4.110026006783064e-13,  7.639293178218207e-15,
 -1.297989298931958e-16,  2.044181002370560e-18, -3.014955202148973e-20,  4.197698940699567e-22, -5.551134220746430e-24,  2.901839824006769e-06, -2.148319637860964e-07,
  9.319459051781668e-09, -3.020548611737009e-10,  8.048451657706456e-12, -1.853765844685276e-13,  3.805476662931818e-15, -7.106670872431860e-17,  1.225055216935261e-18,
 -1.970572582285847e-20,  2.982720178719777e-22, -4.275824541611475e-24,  6.234879560664087e-07, -5.387520947086889e-08,  2.666775057904339e-09, -9.738056616176459e-11,
  2.897091485047119e-12, -7.398627148313985e-14,  1.674603039374173e-15, -3.431893750261864e-17,  6.466009523687297e-19, -1.132802735434052e-20,  1.861640093775436e-22,
 -2.889282185307205e-24,  1.212459609243959e-07, -1.213820603186162e-08,  6.830728047215853e-10, -2.803003993735287e-11,  9.291927312708939e-13, -2.626721117961667e-14,
  6.545546817795356e-16, -1.470141856658553e-17,  3.023741097653152e-19, -5.762947315825239e-21,  1.027143552212610e-22, -1.724054485883094e-24,  2.142896852189943e-08,
 -2.469255294464805e-09,  1.574342694379828e-10, -7.242598540257956e-12,  2.670415139737402e-13, -8.343691802508994e-15,  2.286144336909113e-16, -5.620960285677290e-18,
  1.260730391359177e-19, -2.611420588607447e-21,  5.043144089140073e-23, -9.146444259420396e-25,  3.460779794615939e-09, -4.562960039123887e-10,  3.285373460703227e-11,
 -1.690621127908921e-12,  6.921452521298571e-14, -2.387000631984038e-15,  7.182985272927536e-17, -1.931337064051687e-18,  4.719423039050596e-20, -1.061496219645943e-21,
  2.219322750410194e-23, -4.345626354600640e-25,  5.142854842924826e-10, -7.716486864059944e-11,  6.254606854626329e-12, -3.592423463694724e-13,  1.630401864369970e-14,
 -6.198036356315220e-16,  2.046118382060770e-17, -6.010437503245478e-19,  1.598717798824612e-20, -3.901387451799295e-22,  8.823879536646793e-24, -1.863986404999454e-25,
  7.095123309062776e-11, -1.205269077806831e-11,  1.096390145745920e-12, -7.013529169587980e-14,  3.522750507670319e-15, -1.474229658080708e-16,  5.333039255452668e-18,
 -1.709781571816146e-19,  4.945951021452091e-21, -1.308430546394302e-22,  3.198775451683363e-24, -7.284185523871017e-26,  9.191120014683299e-12, -1.758833586530745e-12,
  1.789962541067621e-13, -1.272376880348653e-14,  7.060475055957452e-16, -3.247976885451473e-17,  1.285931575263718e-18, -4.494667769672385e-20,  1.412587527295069e-21,
 -4.047282608293010e-23,  1.068568038556494e-24, -2.620810286071543e-26,  1.134136919653974e-12, -2.432524847954098e-13,  2.760436648279213e-14, -2.175076914159954e-15,
  1.330773438169478e-16, -6.718231555613121e-18,  2.906858143016997e-19, -1.106241392340772e-20,  3.772708260898718e-22, -1.169382897557221e-23,  3.330661698176608e-25,
 -8.789019016930262e-27,  1.357300509166811e-13, -3.245655723334524e-14,  4.092105043403850e-15, -3.564006549759625e-16,  2.398611479547133e-17, -1.326179726491395e-18,
  6.259665207702531e-20, -2.589449456083984e-21,  9.568173725266916e-23, -3.203729901127159e-24,  9.830105195647780e-26, -2.787096011657913e-27,  1.611043785437765e-14,
 -4.270441328186226e-15,  5.957177764704690e-16, -5.715617136496617e-17,  4.219117997935128e-18, -2.548258413734615e-19,  1.309064893574093e-20, -5.873690942057907e-22,
  2.346764333323135e-23, -8.471876034141262e-25,  2.795127642323039e-26, -8.499438028518914e-28,  1.948988299604075e-15, -5.690185115266056e-16,  8.739678644045169e-17,
 -9.199273398457185e-18,  7.421016418969866e-19, -4.880073705412846e-20,  2.720094541658212e-21, -1.320022237053112e-22,  5.687145226886742e-24, -2.207781281218528e-25,
  7.812793261094841e-27, -2.541712226483558e-28,  2.482611843538405e-16, -7.925014701162367e-17,  1.332329014392354e-17, -1.530602919470997e-18,  1.343050804628910e-19,
 -9.574596302013431e-21,  5.767150112063009e-22, -3.015391384897236e-23,  1.395808344293162e-24, -5.806525744049212e-26,  2.196466026736731e-27, -7.619850040143895e-29,
  3.456604002247131e-17, -1.196337164046364e-17,  2.185678589454676e-18, -2.722767833391121e-19,  2.583177240216715e-20, -1.985207060822521e-21,  1.285349530515867e-22,
 -7.204276800660030e-24,  3.565626770035552e-25, -1.582082609355389e-26,  6.368512259625087e-28, -2.345648517994188e-29,  5.477994556614666e-18, -2.035716609703130e-18,
  4.006492373031466e-19, -5.368241242134891e-20,  5.464798296749022e-21, -4.494803919721886e-22,  3.106790918678421e-23, -1.854422016885643e-24,  9.751506855641707e-26,
 -4.586937279585294e-27,  1.953339740589273e-28, -7.595083818284902e-30,  1.027466067149560e-18, -4.054440791726849e-19,  8.505463113720921e-20, -1.213542083057060e-20,
  1.312970139196348e-21, -1.145316134389152e-22,  8.377815922307200e-24, -5.281115952539337e-25,  2.926954677336394e-26, -1.448308037828406e-27,  6.476115195663500e-29,
 -2.639135647853406e-30,  2.342266474388441e-19, -9.692689895094279e-20,  2.140425891785836e-20, -3.212953579427288e-21,  3.651989131648377e-22, -3.341207823252815e-23,
  2.559017583178578e-24, -1.686183504084315e-25,  9.752746694484339e-27, -5.028355407702757e-28,  2.339290775636583e-29, -9.903130925389296e-31,  6.383129231033023e-20,
 -2.732280904616214e-20,  6.260900702624641e-21, -9.749556475970190e-22,  1.148503019084634e-22, -1.087729176584105e-23,  8.613452282441148e-25, -5.860994618741944e-26,
  3.496594534803629e-27, -1.857389944100982e-28,  8.892955728299452e-30, -3.870188800064549e-31,  1.685834589558463e-20, -7.355540182751039e-21,  1.721437340584399e-21,
 -2.737570074833519e-22,  3.291609916216957e-23, -3.179857833310993e-24,  2.566700305250784e-25, -1.779020130552262e-26,  1.080372910514733e-27, -5.838038077778558e-29,
  2.841661270648256e-30, -1.256431843135198e-31,  7.201867079786263e-02, -2.152683231261467e-04,  6.687108180161820e-07, -2.145427658906507e-09,  7.049137762220000e-12,
 -2.357127523195917e-14,  7.955716927347240e-17, -2.707607579130340e-19,  9.201651025915931e-22, -3.151658698310126e-24,  1.064251694359258e-26, -3.674645471354443e-29,
  6.421154326105946e-02, -2.340986563074722e-04,  1.041168174618544e-06, -4.868222842083963e-09,  2.259408938864337e-11, -1.027501110036958e-13,  4.576298726285748e-16,
 -2.001923908723642e-18,  8.618802273171559e-21, -3.662111762763456e-23,  1.536481628670207e-25, -6.383480937685394e-28,  5.104443806169438e-02, -2.534004327295509e-04,
  1.603175901963322e-06, -9.779694390922096e-09,  5.653341091277686e-11, -3.133626384385856e-13,  1.680736146022562e-15, -8.773956665247526e-18,  4.475675109874233e-20,
 -2.237524375775031e-22,  1.098784082263793e-24, -5.309928950861039e-27,  3.617855800552295e-02, -2.516314592953612e-04,  2.083266633819982e-06, -1.554314622784137e-08,
  1.077285263258397e-10, -7.079748963431483e-13,  4.460482513131535e-15, -2.713209021254270e-17,  1.601603645133053e-19, -9.210332074334091e-22,  5.175851151169628e-24,
 -2.849121202517680e-26,  2.286261538181445e-02, -2.202702748782148e-04,  2.262267554441147e-06, -2.016017819472969e-08,  1.647511926626465e-10, -1.262810545154900e-12,
  9.195331177399797e-15, -6.416420883646487e-17,  4.317969614411670e-19, -2.815818593840376e-21,  1.786058274896298e-23, -1.105160532019786e-25,  1.288207842820792e-02,
 -1.677710902194229e-04,  2.078819962427158e-06, -2.185548742555868e-08,  2.080379503846086e-10, -1.837411052924620e-12,  1.528639247983587e-14, -1.210417140182453e-16,
  9.190665647718511e-19, -6.729397123809978e-21,  4.772169275821886e-23, -3.288898380487279e-25,  6.472339491627224e-03, -1.110003052409508e-04,  1.634878117271906e-06,
 -2.009341653993085e-08,  2.206468265570024e-10, -2.225188972250914e-12,  2.097256867429416e-14, -1.869416265651783e-16,  1.589380310776246e-18, -1.297128805739182e-20,
  1.021208168019466e-22, -7.785734822719526e-25,  2.900066952224412e-03, -6.393837059317664e-05,  1.109402583684573e-06, -1.581818065990224e-08,  1.988644457018167e-10,
 -2.274054701829131e-12,  2.412374211946795e-14, -2.405744706939614e-16,  2.276847068642814e-18, -2.059556812300284e-20,  1.790387435507974e-22, -1.502147619107106e-24,
  1.159100426942852e-03, -3.217154068875191e-05,  6.534119706238883e-07, -1.073795383698167e-08,  1.536213224444610e-10, -1.980975926295742e-12,  2.353157673054566e-14,
 -2.612753756260141e-16,  2.739923564053207e-18, -2.734892803247696e-20,  2.613997149433187e-22, -2.403600135033436e-24,  4.133811747667337e-04, -1.418824469550177e-05,
  3.355426717574373e-07, -6.320474874696573e-09,  1.023971303931207e-10, -1.482429029029519e-12,  1.963728569891748e-14, -2.418143067839142e-16,  2.799438283495449e-18,
 -3.072531097817776e-20,  3.217896551150777e-22, -3.232132237234477e-24,  1.316205658640978e-04, -5.502047311366867e-06,  1.508017763770764e-07, -3.240748183029528e-09,
  5.921749493111643e-11, -9.590062430797699e-13,  1.411913169691866e-14, -1.922175175409977e-16,  2.449241286219929e-18, -2.947390389900325e-20,  3.373096092628398e-22,
 -3.691043241787543e-24,  3.744301078574538e-05, -1.881805262850220e-06,  5.951525125902801e-08, -1.453372634146491e-09,  2.985370719539079e-11, -5.392091567556753e-13,
  8.798933052094810e-15, -1.320941980185752e-16,  1.848058602626866e-18, -2.432727997205395e-20,  3.035496088146884e-22, -3.610893990984297e-24,  9.527096306184648e-06,
 -5.693351619974968e-07,  2.069286690453487e-08, -5.722645540722330e-10,  1.317690305966116e-11, -2.647781043205482e-13,  4.778149417303514e-15, -7.893505263804594e-17,
  1.210137601901725e-18, -1.739258174804702e-20,  2.361876929591845e-22, -3.048907195515035e-24,  2.171423125318888e-06, -1.528383403571283e-07,  6.359504314880445e-09,
 -1.985820574650692e-10,  5.113440232523545e-12, -1.140752038100411e-13,  2.272291263600320e-15, -4.123668875998981e-17,  6.916408486600647e-19, -1.083665716054255e-20,
  1.599213992604461e-22, -2.237054040166688e-24,  4.442348896855950e-07, -3.652700574699663e-08,  1.733770590630132e-09, -6.097024049381545e-11,  1.752089161228245e-12,
 -4.331983865760715e-14,  9.510080258251282e-16, -1.893222572428132e-17,  3.469446431897066e-19, -5.918619283615844e-21,  9.480530686320844e-23, -1.435437684719277e-24,
  8.180241334356817e-08, -7.801328567785069e-09,  4.210034016475052e-10, -1.663466017338205e-11,  5.325286515468748e-13, -1.457082749599180e-14,  3.520850869191976e-16,
 -7.679973392264264e-18,  1.536084294412818e-19, -2.850250579364225e-21,  4.950830211829671e-23, -8.105982040981669e-25,  1.360843275531789e-08, -1.495772010823812e-09,
  9.148925607977910e-11, -4.053111294578079e-12,  1.443192968107586e-13, -4.364384882237676e-15,  1.159526938222560e-16, -2.768656984844404e-18,  6.038635918988722e-20,
 -1.217746040969813e-21,  2.291888330259245e-23, -4.054762270373871e-25,  2.055231617483169e-09, -2.588895071707875e-10,  1.789513938263636e-11, -8.871574058067641e-13,
  3.508518587314055e-14, -1.171358070832738e-15,  3.418473502462761e-17, -8.927691553447026e-19,  2.121778437836724e-20, -4.646943721524446e-22,  9.470228147676864e-24,
 -1.809249176213744e-25,  2.836041095823560e-10, -4.073040337706936e-11,  3.172791702841827e-12, -1.756922131400751e-13,  7.706900488432621e-15, -2.837647287447258e-16,
  9.088902382994287e-18, -2.594265591685142e-19,  6.713940801383088e-21, -1.595979319843610e-22,  3.519842107209863e-24, -7.257366692077177e-26,  3.605814761478474e-11,
 -5.875721315552129e-12,  5.143991643574184e-13, -3.175878113911781e-14,  1.543180498423477e-15, -6.259762943823793e-17,  2.198628361878106e-18, -6.853830822828567e-20,
  1.930256450370442e-21, -4.977200414970845e-23,  1.187230967268604e-24, -2.640368987577285e-26,  4.270268469927285e-12, -7.858376151645283e-13,  7.710626344393418e-14,
 -5.297645510243979e-15,  2.847401970130949e-16, -1.271066336576735e-17,  4.891036352826392e-19, -1.663842965503758e-20,  5.095641232694935e-22, -1.424288992428405e-23,
  3.672188337540888e-25, -8.803484440782621e-27,  4.776952221066599e-13, -9.881130418873230e-14,  1.083472479113302e-14, -8.266804584249401e-16,  4.907052231150983e-17,
 -2.407421555402397e-18,  1.013775514714864e-19, -3.759737446591529e-21,  1.251009737360400e-22, -3.787263032526881e-24,  1.054583314994334e-25, -2.723126561286829e-27,
  5.138821651120855e-14, -1.188934525366613e-14,  1.452203506081720e-15, -1.227513029595771e-16,  8.031269338514871e-18, -4.323323408189183e-19,  1.989494702808651e-20,
 -8.033440178970431e-22,  2.900692135214325e-23, -9.500368364720197e-25,  2.853986170147341e-26, -7.929235378580907e-28,  5.437754274470736e-15, -1.399643448273753e-15,
  1.897273815971097e-16, -1.771463209707441e-17,  1.274370919518543e-18, -7.511010311151376e-20,  3.769814354969915e-21, -1.654434511762761e-22,  6.471754476574164e-24,
 -2.289520723739100e-25,  7.408770438844722e-27, -2.211388618022905e-28,  5.821796606052086e-16, -1.656985231350494e-16,  2.481602969896923e-17, -2.549937406198791e-18,
  2.010475033577791e-19, -1.293638197598015e-20,  7.062789671105615e-22, -3.360452398902224e-23,  1.420759055145687e-24, -5.416861370103067e-26,  1.884054296622423e-27,
 -6.028743853103810e-29,  6.526607985268511e-17, -2.039635286717278e-17,  3.356362871926951e-18, -3.777374355465360e-19,  3.250168100666638e-20, -2.274180228667645e-21,
  1.345667276099501e-22, -6.917464458199739e-24,  3.150543930273284e-25, -1.290444185950162e-26,  4.809458656073367e-28, -1.644919965845074e-29,  7.977768381909726e-18,
 -2.714892284605166e-18,  4.874941687486206e-19, -5.972123890608287e-20,  5.576006539594381e-21, -4.220302301328376e-22,  2.692972064927897e-23, -1.488539719193485e-24,
  7.269992438773049e-26, -3.184980324943686e-27,  1.266574359325120e-28, -4.611070703858923e-30,  1.112325930735133e-18, -4.082002879527709e-19,  7.929225128935630e-20,
 -1.048976226589238e-20,  1.054869509212040e-21, -8.575501071509999e-23,  5.861544614062476e-24, -3.461595818793343e-25,  1.801821592654409e-26, -8.393205007144878e-28,
  3.541026754300081e-29, -1.364613919844271e-30,  1.851066581254878e-19, -7.242516258406333e-20,  1.505686828246030e-20, -2.129391125925888e-21,  2.284352572222671e-22,
 -1.976499552681983e-23,  1.434561612136301e-24, -8.975930245337244e-26,  4.939424756314571e-27, -2.427514067465937e-28,  1.078406224094878e-29, -4.367397468268132e-31,
  3.805135101121907e-20, -1.566745508691446e-20,  3.441158880858832e-21, -5.138042913576620e-22,  5.810198313846291e-23, -5.289594099984897e-24,  4.032175128295992e-25,
 -2.644878075451111e-26,  1.523162777491738e-27, -7.820666434757293e-29,  3.623900632872332e-30, -1.528322852358614e-31,  9.583390942860058e-21, -4.092431457802406e-21,
  9.353350183617694e-22, -1.452783855243893e-22,  1.707134199768213e-23, -1.612928476545473e-24,  1.274297617822411e-25, -8.651751352183142e-27,  5.150572599836304e-28,
 -2.730408866489587e-29,  1.304728701706193e-30, -5.667498665732372e-32,  2.415431418846701e-21, -1.053036098551272e-21,  2.462235479783338e-22, -3.912125091621815e-23,
  4.699728399493163e-24, -4.536273917225681e-25,  3.658515314362604e-26, -2.533726735150794e-27,  1.537491202353386e-28, -8.301879761929379e-30,  4.037964847161639e-31,
 -1.784105434879269e-32,  7.116813648641000e-02, -2.100197349110621e-04,  6.436271754405104e-07, -2.036311635293898e-09,  6.596208654428360e-12, -2.174965344286360e-14,
  7.237161317693583e-17, -2.430517332387905e-19,  8.139933349579583e-22, -2.756662735212217e-24,  9.145855736916509e-27, -3.144761994609006e-29,  6.329144581667769e-02,
 -2.259969924101532e-04,  9.848526002926678e-07, -4.522579193077919e-09,  2.064453402364244e-11, -9.240965198220329e-14,  4.052471822637227e-16, -1.746082636314870e-18,
  7.404622893659094e-21, -3.100178944832206e-23,  1.281441361987395e-25, -5.248683893183426e-28,  5.005576498672983e-02, -2.410295362320430e-04,  1.491046835386920e-06,
 -8.923186867333855e-09,  5.065044138465726e-11, -2.758183305230517e-13,  1.453963367207374e-15, -7.462575905409784e-18,  3.743957847975042e-20, -1.841375161553381e-22,
  8.898031139915083e-25, -4.232272861379789e-27,  3.520422315042923e-02, -2.356831346585865e-04,  1.906641713753317e-06, -1.392719757775217e-08,  9.458087670297770e-11,
 -6.094898255336849e-13,  3.767822489188511e-15, -2.249984399823329e-17,  1.304463949730235e-19, -7.370401204362838e-22,  4.070804286048997e-24, -2.202980641827029e-26,
  2.201625921798146e-02, -2.030968551634029e-04,  2.035365312778950e-06, -1.771480199272136e-08,  1.415640259923855e-10, -1.062209354476777e-12,  7.577869769071204e-15,
 -5.183970878809306e-17,  3.421960718369561e-19, -2.189893017272744e-21,  1.363674875682869e-23, -8.286821368997915e-26,  1.224267053052464e-02, -1.521356764400689e-04,
  1.835374624374933e-06, -1.880202780114312e-08,  1.747002123432042e-10, -1.508095647649931e-12,  1.227501819337036e-14, -9.516584807221869e-17,  7.079457786737539e-19,
 -5.081254073559434e-21,  3.533922567482543e-23, -2.389559356357090e-25,  6.053049703509784e-03, -9.882896140155247e-05,  1.413554552209892e-06, -1.689343086820460e-08,
  1.807804489057317e-10, -1.779317375710902e-12,  1.638530018919674e-14, -1.428269772981736e-16,  1.188373295053602e-18, -9.497288081507203e-21,  7.325836206582116e-23,
 -5.474902123720301e-25,  2.660933780468592e-03, -5.577159445093444e-05,  9.372705056715313e-07, -1.297089138035387e-08,  1.586672395887008e-10, -1.768323529720866e-12,
  1.830537444295433e-14, -1.783158839154597e-16,  1.649832941327886e-18, -1.459991584767343e-20,  1.242391617720067e-22, -1.020922963884337e-24,  1.040108028826942e-03,
 -2.742070509551307e-05,  5.380897335325859e-07, -8.568603723921803e-09,  1.191044001836858e-10, -1.494941441978483e-12,  1.730861187672463e-14, -1.875229255479983e-16,
  1.920594805279747e-18, -1.873770612632103e-20,  1.751672336259202e-22, -1.576308117286215e-24,  3.615530688163684e-04, -1.178153175339263e-05,  2.686257639517900e-07,
 -4.895834632959284e-09,  7.696134498481570e-11, -1.083200671083888e-12,  1.397056914251224e-14, -1.676996546725226e-16,  1.894395390562847e-18, -2.030549947152630e-20,
  2.078389774014440e-22, -2.041575787905939e-24,  1.117998661726211e-04, -4.436428405537855e-06,  1.170197307262671e-07, -2.429980188607697e-09,  4.303193872567920e-11,
 -6.767703327366696e-13,  9.691663294516684e-15, -1.285023754538624e-16,  1.596401623585080e-18, -1.874724127691126e-20,  2.095380317961140e-22, -2.240912475852153e-24,
  3.076804751424316e-05, -1.468075772869682e-06,  4.461885651098490e-08, -1.051659882713594e-09,  2.091306301119431e-11, -3.664683741240838e-13,  5.811631163727651e-15,
 -8.490457494556388e-17,  1.157274293371224e-18, -1.485628771256787e-20,  1.809304071850839e-22, -2.102281003674935e-24,  7.541925534028392e-06, -4.280422249209430e-07,
  1.493422559316091e-08, -3.982474470336215e-10,  8.869450187449027e-12, -1.727681518777606e-13,  3.027603654073623e-15, -4.863911616988604e-17,  7.260169082728959e-19,
 -1.016994884356595e-20,  1.347240753396439e-22, -1.697909817746073e-24,  1.648486624525481e-06, -1.102593133864110e-07,  4.400744812519321e-09, -1.324077744114607e-10,
  3.295303619259500e-12, -7.121543940618224e-14,  1.376670488381389e-15, -2.428145297076238e-17,  3.963127500671510e-19, -6.049038540742475e-21,  8.704440761081081e-23,
 -1.188287832029660e-24,  3.218286049576733e-07, -2.516544470706681e-08,  1.145311071411109e-09, -3.878782428829816e-11,  1.076730583431682e-12, -2.577579746745479e-14,
  5.488852290583827e-16, -1.061524864933212e-17,  1.892252386865524e-19, -3.143503434378333e-21,  4.908253588000217e-23, -7.250423094704700e-25,  5.624756905721361e-08,
 -5.106408285143508e-09,  2.642025733248518e-10, -1.005062793496582e-11,  3.107073688473372e-13, -8.228504314693408e-15,  1.928044767654400e-16, -4.084437180305986e-18,
  7.944429405915163e-20, -1.435170847222931e-21,  2.429467521721133e-23, -3.880153136664856e-25,  8.828903706883645e-09, -9.249205014188518e-10,  5.425228326612435e-11,
 -2.313993795309392e-12,  7.955807307146927e-14, -2.328382273118991e-15,  5.997728514982865e-17, -1.390672146028138e-18,  2.949334320739823e-20, -5.789999317496987e-22,
  1.061943745847892e-23, -1.832603034245874e-25,  1.250016485739057e-09, -1.502968347775672e-10,  9.968443044824229e-12, -4.759286941312672e-13,  1.817689446757565e-14,
 -5.873553311699793e-16,  1.662081079990663e-17, -4.215418718162822e-19,  9.742385213186484e-21, -2.077343126299004e-22,  4.126032784272198e-24, -7.689861380370113e-26,
  1.605692519113133e-10, -2.205003790333362e-11,  1.649626434873597e-12, -8.802473718784447e-14,  3.730601928288087e-15, -1.329933928758371e-16,  4.131715637130254e-18,
 -1.145629816258871e-19,  2.884009865336924e-21, -6.676478054477101e-23,  1.435496143282941e-24, -2.888266236425235e-26,  1.885916219778726e-11, -2.944520316669403e-12,
  2.478906317249315e-13, -1.476179314533104e-14,  6.935351396910288e-16, -2.725627810269863e-17,  9.291054107194217e-19, -2.815126437735581e-20,  7.716125624556603e-22,
 -1.938630036696289e-23,  4.510507168398277e-25, -9.793900591909112e-27,  2.046264776205252e-12, -3.616718404470411e-13,  3.418203296946234e-14, -2.268167956410410e-15,
  1.180046745758523e-16, -5.108609264589001e-18,  1.909550058336457e-19, -6.319178532318079e-21,  1.885023363875397e-22, -5.137827776888697e-24,  1.293053198821137e-25,
 -3.028807824652294e-27,  2.078953929527448e-13, -4.141688409745818e-14,  4.383422916782909e-15, -3.235649807715628e-16,  1.861881711587689e-17, -8.870613799776744e-19,
  3.633126928150994e-20, -1.312271172901128e-21,  4.257761447572955e-23, -1.258276606896307e-24,  3.423684281051795e-26, -8.646652724911732e-28,  2.012834269647463e-14,
 -4.499376242337431e-15,  5.317835830667417e-16, -4.358083938155507e-17,  2.769451393239572e-18, -1.450301900876591e-19,  6.501727808758147e-21, -2.560839470438847e-22,
  9.029684750087905e-24, -2.891021785611398e-25,  8.497944398121266e-27, -2.312240149685075e-28,  1.899741091622790e-15, -4.741231831528399e-16,  6.237402411452436e-17,
 -5.661115821606650e-18,  3.964916218346451e-19, -2.278332299157445e-20,  1.116277873796683e-21, -4.787803015446533e-23,  1.832308163926689e-24, -6.347860285816149e-26,
  2.013344484565883e-27, -5.895096855058829e-29,  1.798936666341867e-16, -4.984190100306043e-17,  7.269333677501830e-18, -7.283273673441643e-19,  5.606527177410311e-20,
 -3.526416503465263e-21,  1.884113546163465e-22, -8.781777599347746e-24,  3.640545241228262e-25, -1.362166779511423e-26,  4.653283067864827e-28, -1.463557189522956e-29,
  1.771566991353194e-17, -5.412555918796281e-18,  8.707182043170207e-19, -9.588871861884989e-20,  8.081766252016165e-21, -5.544805587326864e-22,  3.220101459385666e-23,
 -1.626031143877126e-24,  7.280633166996147e-26, -2.933936231545462e-27,  1.076561182340547e-28, -3.627540161609076e-30,  1.894696782929829e-18, -6.332109280756392e-19,
  1.116210564514618e-19, -1.343297125697929e-20,  1.233051142297726e-21, -9.182532244206292e-23,  5.769545451822923e-24, -3.142465140058523e-25,  1.513329298489050e-26,
 -6.541324728471990e-28,  2.568038674872304e-29, -9.234881188780794e-31,  2.312934591055753e-19, -8.373639807612720e-20,  1.603815946998004e-20, -2.092923381676056e-21,
  2.077299028119119e-22, -1.667741783064817e-23,  1.126416082553399e-24, -6.576827509035185e-26,  3.386315914933908e-27, -1.561090288795858e-28,  6.520940085699308e-30,
 -2.489230519347753e-31,  3.394641060023368e-20, -1.315966743040338e-20,  2.709218197116195e-21, -3.795065849883901e-22,  4.034062052304765e-23, -3.459903276915243e-24,
  2.490256551617687e-25, -1.545699455690658e-26,  8.441070359900778e-28, -4.118175904307523e-29,  1.816710609277410e-30, -7.308423323405530e-32,  6.252353280913812e-21,
 -2.560313606600929e-21,  5.590395268432214e-22, -8.298975538054926e-23,  9.332462169358455e-24, -8.450952625131791e-25,  6.409152085983769e-26, -4.183517150967475e-27,
  2.398002105015956e-28, -1.225751465768645e-29,  5.655537115175796e-31, -2.375391868843916e-32,  1.447042976314944e-21, -6.163402054542908e-22,  1.404690940314492e-22,
 -2.175721657169811e-23,  2.549745204229811e-24, -2.402786551217454e-25,  1.893594789505512e-26, -1.282568454425716e-27,  7.617895869002807e-29, -4.029498288886748e-30,
  1.921436861053060e-31, -8.329506567266010e-33,  3.467721602512210e-22, -1.510482616414918e-22,  3.528446110332741e-23, -5.600773323499985e-24,  6.721995305430256e-25,
 -6.482258107767854e-26,  5.223308561275025e-27, -3.614319345737340e-28,  2.191377836704723e-29, -1.182307639662775e-30,  5.746152481858988e-32, -2.536923120490575e-33,
  7.033820331200492e-02, -2.049666987548956e-04,  6.198106165769328e-07, -1.934160130837745e-09,  6.178048363172490e-12, -2.009154594787572e-14,  6.591640271852891e-17,
 -2.185238026975963e-19,  7.210174322103234e-22, -2.417151802149245e-24,  7.861557281063669e-27, -2.707046740991105e-29,  6.240287951916165e-02, -2.183297772058573e-04,
  9.325042023481757e-07, -4.206539904550837e-09,  1.888977431912766e-11, -8.324462521827929e-14,  3.595131577908755e-16, -1.526045901213734e-18,  6.375518478580062e-21,
 -2.630942145191833e-23,  1.071440722776742e-25, -4.328367464626516e-28,  4.911484434109359e-02, -2.295161048674920e-04,  1.388654948375314e-06, -8.155083453986457e-09,
  4.546677540514909e-11, -2.433011419752485e-13,  1.260834565388681e-15, -6.364051467068023e-18,  3.140883901234528e-20, -1.520056805185234e-22,  7.229523016612123e-25,
 -3.385190600615985e-27,  3.429097354879142e-02, -2.210736759673955e-04,  1.748208193480479e-06, -1.250671469756651e-08,  8.324666563398784e-11, -5.261737777248167e-13,
  3.192491523783739e-15, -1.872046934413193e-17,  1.066245828340768e-19, -5.920479667743150e-22,  3.214619150906604e-24, -1.710628813098185e-26,  2.123514362728682e-02,
 -1.876272904631265e-04,  1.835707489281722e-06, -1.561032168079232e-08,  1.220270541918482e-10, -8.965904911369808e-13,  6.268521277356014e-15, -4.205227354862264e-17,
  2.723592830273846e-19, -1.710888605067906e-21,  1.046195307084015e-23, -6.245084475704404e-26,  1.166212905302822e-02, -1.383098509512999e-04,  1.625575648573359e-06,
 -1.623297507903504e-08,  1.472810144055510e-10, -1.243070758664097e-12,  9.901866593118833e-15, -7.518487387514086e-17,  5.481205014951269e-19, -3.857470872701070e-21,
  2.631752388963164e-23, -1.746373568722693e-25,  5.679132850924242e-03, -8.828480957964732e-05,  1.227079629374062e-06, -1.426555429257065e-08,  1.488235796266233e-10,
 -1.430059683232891e-12,  1.287091161057352e-14, -1.097478753367977e-16,  8.938867049065916e-19, -6.997412900291133e-21,  5.289728482356747e-23, -3.876086338938272e-25,
  2.451915513083866e-03, -4.885541648390971e-05,  7.957576995787994e-07, -1.069287323843680e-08,  1.273185278759136e-10, -1.383396300136719e-12,  1.397900114392135e-14,
 -1.330530981272177e-16,  1.203827605010539e-18, -1.042467589215521e-20,  8.685955236145898e-23, -6.992425022446685e-25,  9.384263450093328e-04, -2.349701786355578e-05,
  4.457823679117325e-07, -6.881221326711699e-09,  9.296774918181310e-11, -1.136175689975331e-12,  1.282589679201956e-14, -1.356294195130379e-16,  1.357058948900224e-18,
 -1.294415563309998e-20,  1.183836211228558e-22, -1.042834847181017e-24,  3.183803930082965e-04, -9.848127778721294e-06,  2.166040533867643e-07, -3.821028976861686e-09,
  5.830265729041625e-11, -7.980261063755537e-13,  1.002427120293483e-14, -1.173310772957378e-16,  1.293655053909459e-18, -1.354534776818350e-20,  1.355333540689513e-22,
 -1.302284867956981e-24,  9.575705425992281e-05, -3.606157182424391e-06,  9.158219480127789e-08, -1.838241434521514e-09,  3.155847136755979e-11, -4.821448373867680e-13,
  6.717829262371557e-15, -8.677330291456399e-17,  1.051281918748118e-18, -1.205055359200311e-20,  1.315723921837006e-22, -1.375501218897777e-24,  2.553707365803397e-05,
 -1.156427765536927e-06,  3.378723098568303e-08, -7.688463229935327e-10,  1.480562195208951e-11, -2.517808414679761e-13,  3.881359818331646e-15, -5.519513346328689e-17,
  7.331244279773445e-19, -9.179957650259078e-21,  1.091426788931101e-22, -1.238940527792682e-24,  6.041526798830727e-06, -3.255108859748141e-07,  1.090432479476848e-08,
 -2.804509598174976e-10,  6.042655397833880e-12, -1.141275617519529e-13,  1.942570880600903e-15, -3.035487907318039e-17,  4.412343603247017e-19, -6.025079518519201e-21,
  7.787471558527165e-23, -9.583359155780999e-25,  1.268934385416799e-06, -8.061024099653629e-08,  3.086438806683497e-09, -8.948994499772867e-11,  2.152957836229852e-12,
 -4.508034988593136e-14,  8.458575689618593e-16, -1.450223497928109e-17,  2.303718771320513e-19, -3.425880624890629e-21,  4.807585790351802e-23, -6.405776343164459e-25,
  2.369110389265721e-07, -1.760688603823814e-08,  7.682806156603073e-10, -2.505848053746624e-11,  6.720090074152780e-13, -1.557745542774515e-14,  3.217968492824293e-16,
 -6.046509859347096e-18,  1.048541167269164e-19, -1.696422688887290e-21,  2.582166569916242e-23, -3.721675625491969e-25,  3.938999601279687e-08, -3.401753317495664e-09,
  1.687115231951586e-10, -6.178720742384131e-12,  1.844509265428487e-13, -4.728074918985819e-15,  1.074297990854958e-16, -2.210326432711075e-18,  4.180958913289149e-20,
 -7.353647130548637e-22,  1.213205869743879e-23, -1.890132237803735e-25,  5.847847226619420e-09, -5.834238677766031e-10,  3.280650364909900e-11, -1.346936579203900e-12,
  4.470991378287251e-14, -1.266222652282846e-15,  3.162213998915270e-17, -7.119637060579513e-19,  1.468142918722717e-20, -2.805707121907759e-22,  5.014581695923186e-24,
 -8.440711133285990e-26,  7.781123460546320e-10, -8.921934715385053e-11,  5.675220162939094e-12, -2.608594620197321e-13,  9.619143153090967e-15, -3.007817506479962e-16,
  8.251692543248506e-18, -2.032136332613927e-19,  4.566528275765654e-21, -9.478792846196123e-23,  1.834675927673744e-24, -3.335374126660720e-26,  9.327757083148082e-11,
 -1.223537696315665e-11,  8.785606958166057e-13, -4.515429805785270e-14,  1.848256012759647e-15, -6.377543977347731e-17,  1.921258022919722e-18, -5.173762665965912e-20,
  1.266637669355334e-21, -2.855051140889103e-23,  5.983306391897928e-25, -1.174552973458470e-26,  1.014563669385936e-11, -1.516029963872760e-12,  1.226366185840785e-13,
 -7.039667173465215e-15,  3.196254210771127e-16, -1.216492745949967e-17,  4.022964936016156e-19, -1.184347388925984e-20,  3.158346650185236e-22, -7.729454817267298e-24,
  1.753614016798328e-25, -3.716587952834627e-27,  1.010910501760055e-12, -1.713932031041116e-13,  1.558836926435796e-14, -9.982440576148797e-16,  5.023913120885175e-17,
 -2.108075620970957e-18,  7.650517114359410e-20, -2.461710914964200e-21,  7.149492385347341e-23, -1.899437342081094e-24,  4.664489726163026e-26, -1.067147549298000e-27,
  9.346724029098695e-14, -1.790922352613633e-14,  1.827578681825726e-15, -1.303966392674332e-16,  7.268227550173191e-18, -3.360470895457227e-19,  1.337799933375839e-20,
 -4.703371846043790e-22,  1.487257442838769e-23, -4.288339126427170e-25,  1.139615475603332e-26, -2.813706772188045e-28,  8.157098403285712e-15, -1.759144873137063e-15,
  2.009483404570500e-16, -1.595018365791531e-17,  9.835870355500647e-19, -5.006740842197552e-20,  2.184975565794190e-21, -8.388691378484741e-23,  2.886643314914664e-24,
 -9.029141827613747e-26,  2.595424368101532e-27, -6.912369735160107e-29,  6.872195873897260e-16, -1.660507750427578e-16,  2.117391425592014e-17, -1.865989527882714e-18,
  1.271077551662935e-19, -7.114370111460623e-21,  3.399827615404677e-22, -1.424006892838150e-23,  5.327731506852983e-25, -1.806233448439064e-26,  5.611331940356785e-28,
 -1.610714955047198e-29,  5.754398195500137e-17, -1.549687982931919e-17,  2.198149397847293e-18, -2.144910651551934e-19,  1.610296651427647e-20, -9.890989563884052e-22,
  5.166815802357846e-23, -2.357101568856331e-24,  9.573534477809225e-26, -3.512700529319001e-27,  1.177713269765613e-28, -3.638378373572605e-30,  4.970240810099157e-18,
 -1.482440371594038e-18,  2.328318085989456e-19, -2.506002156215274e-20,  2.066641432451752e-21, -1.388875110928719e-22,  7.908679443106459e-24, -3.919462964511763e-25,
  1.723870649654377e-26, -6.829209803158717e-28,  2.465267962429419e-29, -8.178123389507762e-31,  4.636520737601374e-19, -1.519753794461266e-19,  2.626755548570743e-20,
 -3.101836396794147e-21,  2.796304012381312e-22, -2.046915581823770e-23,  1.265232973252605e-24, -6.784606434332005e-26,  3.219021604013113e-27, -1.371772476128035e-28,
  5.312684968113081e-30, -1.885832782571564e-31,  4.932003902956118e-20, -1.759593390605419e-20,  3.319525993535159e-21, -4.268814040633965e-22,  4.177934898689034e-23,
 -3.309651121036780e-24,  2.207062836672710e-25, -1.273068323098549e-26,  6.479232570902991e-28, -2.954005832523003e-29,  1.220936453149982e-30, -4.613771494508441e-32,
  6.345068540946412e-21, -2.435115547041431e-21,  4.960426512476303e-22, -6.877215988108407e-23,  7.238268763677871e-24, -6.149586728373677e-25,  4.386350637475240e-26,
 -2.699236276232819e-27,  1.461974568335129e-28, -7.076750723706028e-30,  3.098506924549780e-31, -1.237592655778580e-32,  1.040071740545453e-21, -4.233634428634739e-22,
  9.184951277100617e-23, -1.354963878054895e-23,  1.514500612756651e-24, -1.363515464286349e-25,  1.028364781499048e-26, -6.677097964955290e-28,  3.808007470526483e-29,
 -1.937090472849207e-30,  8.896365173811949e-32, -3.720121888648344e-33,  2.198547551706524e-22, -9.337856530151784e-23,  2.121635852062833e-23, -3.276229551298789e-24,
  3.828175629688076e-25, -3.597360189469117e-26,  2.827351915706383e-27, -1.910058855735062e-28,  1.131675738343681e-29, -5.971782208657996e-31,  2.841110509765092e-32,
 -1.228948608121103e-33,  4.989157385699580e-23, -2.171165150815052e-23,  5.066531946742795e-24, -8.033891782717215e-25,  9.632452659576871e-26, -9.279796356683517e-27,
  7.470415186999945e-28, -5.164472712152578e-29,  3.128457790258930e-30, -1.686435823146693e-31,  8.189454631684406e-33, -3.612737180731039e-34,  6.952810882347883e-02,
 -2.000994030702530e-04,  5.971808000867748e-07, -1.838442083838444e-09,  5.791554909781440e-12, -1.858044737202223e-14,  6.010808996563018e-17, -1.967850955269015e-19,
  6.393834145460672e-22, -2.125404205869307e-24,  6.751854933176799e-27, -2.349495830333221e-29,  6.154416787114490e-02, -2.110666430403909e-04,  8.837856802382002e-07,
 -3.917167974437818e-09,  1.730781943729059e-11, -7.510685345945790e-14,  3.195034066460401e-16, -1.336392228295746e-18,  5.501146058523726e-21, -2.238140666555544e-23,
  8.980126956337148e-26, -3.580100577155585e-28,  4.821839559921989e-02, -2.187863017520267e-04,  1.295003343617568e-06, -7.464957707234334e-09,  4.088948540864035e-11,
 -2.150707230909466e-13,  1.095927795975202e-15, -5.441221352480267e-18,  2.642318023907344e-20, -1.258583699474984e-22,  5.892759983856238e-25, -2.716908045558690e-27,
  3.343373061099184e-02, -2.076664632268185e-04,  1.605785036609478e-06, -1.125496436899231e-08,  7.344884216763255e-11, -4.554773460927437e-13,  2.713050794129683e-15,
 -1.562608547762964e-17,  8.745488532961241e-20, -4.773345326403377e-22,  2.548465547927942e-24, -1.333802655151618e-26,  2.051286452699358e-02, -1.736590462594886e-04,
  1.659531902078930e-06, -1.379355246110451e-08,  1.055091733709392e-10, -7.593448442544867e-13,  5.204361393122236e-15, -3.424656362603016e-17,  2.176818765771045e-19,
 -1.342578628794178e-21,  8.063772908244847e-24, -4.729448624633296e-26,  1.113371931979577e-02, -1.260461771237395e-04,  1.444138450475012e-06, -1.406313981217077e-08,
  1.246352519961823e-10, -1.028827480657657e-12,  8.022737412432242e-15, -5.967787604292048e-17,  4.264844458433336e-19, -2.943724606098214e-21,  1.970624164593869e-23,
 -1.283601707942256e-25,  5.344597118267594e-03, -7.911450874627035e-05,  1.069287847847046e-06, -1.209739239002951e-08,  1.230782644264640e-10, -1.155019743169928e-12,
  1.016329147353876e-14, -8.479680638869628e-17,  6.762862286963767e-19, -5.186911133623676e-21,  3.843732949301364e-23, -2.762228438142930e-25,  2.268459571841424e-03,
 -4.296997248070591e-05,  6.788085234500445e-07, -8.860084149045813e-09,  1.027249060927910e-10, -1.088577274821898e-12,  1.074086439635246e-14, -9.992053558685856e-17,
  8.843123706246565e-19, -7.495625113066690e-21,  6.116746180431388e-23, -4.825165234764721e-25,  8.510813708077122e-04, -2.023739471226641e-05,  3.714335896606084e-07,
 -5.560008598178003e-09,  7.303848888392318e-11, -8.694185177436762e-13,  9.572212316166365e-15, -9.882821164463048e-17,  9.662963984489985e-19, -9.013520936502696e-21,
  8.066830826641496e-23, -6.957712768094757e-25,  2.821840381234107e-04, -8.283979716497094e-06,  1.758615447449957e-07, -3.003837243276356e-09,  4.450424500206192e-11,
 -5.926047451939303e-13,  7.252108468848615e-15, -8.279256707365592e-17,  8.912122932935430e-19, -9.117850163242527e-21,  8.920648784933192e-23, -8.386437511822219e-25,
  8.266925353572619e-05, -2.953831095650916e-06,  7.226096832303698e-08, -1.402451505789020e-09,  2.334912054429323e-11, -3.466385934396933e-13,  4.700542908238778e-15,
 -5.916530046586821e-17,  6.992184650564083e-19, -7.825241587079392e-21,  8.348080559245689e-23, -8.533173445019828e-25,  2.139874521780636e-05, -9.193596637554617e-07,
  2.583130542802847e-08, -5.676614112363106e-10,  1.058885551753449e-11, -1.748004749682502e-13,  2.620095251571768e-15, -3.627644370783844e-17,  4.696496356779320e-19,
 -5.737476095800116e-21,  6.660657003359552e-23, -7.388122131987447e-25,  4.894748957559682e-06, -2.502526742765814e-07,  8.051163729202597e-09, -1.997584151602738e-10,
  4.164943797549149e-12, -7.629040007260765e-14,  1.261551048525329e-15, -1.917846327952799e-17,  2.715323089127398e-19, -3.615084594266962e-21,  4.559703982726629e-23,
 -5.480022838312975e-25,  9.898198594913265e-07, -5.969062866241927e-08,  2.192719195186962e-09, -6.127689071595896e-11,  1.425331462868249e-12, -2.892143181673305e-14,
  5.268183515150892e-16, -8.781429870870993e-18,  1.357877550278769e-19, -1.967720692028741e-21,  2.693271426139414e-23, -3.503049213564646e-25,  1.771014903685629e-07,
 -1.250187358851657e-08,  5.230275554425689e-10, -1.643050608026903e-11,  4.257213262746571e-13, -9.556828944907930e-15,  1.915430904390397e-16, -3.497149390195162e-18,
  5.900310066285334e-20, -9.297847651420642e-22,  1.379786779622396e-23, -1.940542071724364e-25,  2.807516952467121e-08, -2.304840022000077e-09,  1.095558470805910e-10,
 -3.862515105106978e-12,  1.113481098108586e-13, -2.762721737015709e-15,  6.087553207372351e-17, -1.216503438067415e-18,  2.237916565433425e-20, -3.832459782501755e-22,
  6.162438493470646e-24, -9.365844668873854e-26,  3.951620347294245e-09, -3.751506019026302e-10,  2.021682512813592e-11, -7.988683244731164e-13,  2.559931972257666e-14,
 -7.015328226442784e-16,  1.698490206155323e-17, -3.713194860466962e-19,  7.444934545938913e-21, -1.384989298391192e-22,  2.412125842721356e-24, -3.960157704771943e-26,
  4.953817842142441e-10, -5.411823762366623e-11,  3.300033657035842e-12, -1.459914757150508e-13,  5.196623961759875e-15, -1.572180584032681e-16,  4.180983381020998e-18,
 -9.996801980311354e-20,  2.184033133160703e-21, -4.412745337737901e-23,  8.322569851013563e-25, -1.475716192153756e-26,  5.556110791789914e-11, -6.954382283587738e-12,
  4.789942562611912e-13, -2.370181078329486e-14,  9.366787097848000e-16, -3.127550611016605e-17,  9.134118139216778e-19, -2.388378750187583e-20,  5.685369730685603e-22,
 -1.247533633155013e-23,  2.547869556657088e-25, -4.879011134280710e-27,  5.610743898372708e-12, -8.014718200062032e-13,  6.225015748925368e-14, -3.442530579917869e-15,
  1.509820411633693e-16, -5.562774440348968e-18,  1.784079358843119e-19, -5.101627437486018e-21,  1.323246505377944e-22, -3.153573319971560e-24,  6.974744660871058e-26,
 -1.442476000987492e-27,  5.146464799719174e-13, -8.359297179236134e-14,  7.309846622434172e-15, -4.514303043370576e-16,  2.196415839267307e-17, -8.928314947818371e-19,
  3.144446438647910e-20, -9.833733071927884e-22,  2.779477518372251e-23, -7.195066490806934e-25,  1.723453214921251e-26, -3.849767465219284e-28,  4.339871695871625e-14,
 -7.986980165195560e-15,  7.850369096550485e-16, -5.409364179836873e-17,  2.918468923688890e-18, -1.308603972072792e-19,  5.060597138860757e-21, -1.730828405067207e-22,
  5.331202579608489e-24, -1.499079614560697e-25,  3.889060694978311e-27, -9.382950244663030e-29,  3.420097565469968e-15, -7.105396886447287e-16,  7.835366469461647e-17,
 -6.017621206265556e-18,  3.597798651622715e-19, -1.778735087183274e-20,  7.551059323342616e-22, -2.823950332003171e-23,  9.477442604289352e-25, -2.894419089643351e-26,
  8.131643914335459e-28, -2.118670234066235e-29,  2.574846505924395e-16, -6.014216033337546e-17,  7.423842042948005e-18, -6.345399362129666e-19,  4.199683733710893e-20,
 -2.287524868227902e-21,  1.065335547415560e-22, -4.354051034073037e-24,  1.591379830449807e-25, -5.276043781524876e-27,  1.604418869079737e-28, -4.512112093056354e-30,
  1.906746890566066e-17, -4.983425156845706e-18,  6.865411027789913e-19, -6.516505640686866e-20,  4.766132679810671e-21, -2.856003433858642e-22,  1.457298749063785e-23,
 -6.501414245736077e-25,  2.584990614989387e-26, -9.293940818647233e-28,  3.055992554451964e-29, -9.266994806049577e-31,  1.442738326523285e-18, -4.194559462072176e-19,
  6.423179671732548e-20, -6.748412725448910e-21,  5.439239541740694e-22, -3.576840563489304e-23,  1.995147196255057e-24, -9.695387802284348e-26,  4.185133374389134e-27,
 -1.628577861661798e-28,  5.779306136187690e-30, -1.886105736555062e-31,  1.170596976292200e-19, -3.758017711505933e-20,  6.360515005911647e-21, -7.361166629641812e-22,
  6.510121396967109e-23, -4.679429533397171e-24,  2.842748840107455e-25, -1.499434551182009e-26,  7.003186539256598e-28, -2.939904350929416e-29,  1.122363051181281e-30,
 -3.929806183658828e-32,  1.080044948037769e-20, -3.792789393569771e-21,  7.039686870745639e-22, -8.911603324912779e-23,  8.591891362547452e-24, -6.709620136156486e-25,
  4.413834745700569e-26, -2.513150856546143e-27,  1.263333491627597e-28, -5.692179195060413e-30,  2.326282662905193e-31, -8.696658142245376e-33,  1.210428586514256e-21,
 -4.594826648137299e-22,  9.253024151740825e-23, -1.268616753442180e-23,  1.321015742256461e-24, -1.110930259417666e-25,  7.847272407295346e-27, -4.784406379838601e-28,
  2.568532658311015e-29, -1.232856980883691e-30,  5.354633646104029e-32, -2.122347053822158e-33,  1.753368826987939e-22, -7.090525402328405e-23,  1.527576788656602e-23,
 -2.238103786778476e-24,  2.485206826897809e-25, -2.223402909934650e-26,  1.666840150436446e-27, -1.076074467211923e-28,  6.103425295594964e-30, -3.088548466118042e-31,
  1.411390743059977e-32, -5.873852143538708e-34,  3.362959019321180e-23, -1.423928198218543e-23,  3.224416366514470e-24, -4.962671057020002e-25,  5.780201362065202e-26,
 -5.415028553861042e-27,  4.243447746409822e-28, -2.858662727607727e-29,  1.689149671209492e-30, -8.890584508634216e-32,  4.219319589915294e-33, -1.820807182798742e-34,
  7.194725202027785e-24, -3.127821540736153e-24,  7.290803014485318e-25, -1.154801290366332e-25,  1.383076671825667e-26, -1.331037152313916e-27,  1.070419051092883e-28,
 -7.392773066794003e-30,  4.474026371476460e-31, -2.409566652297622e-32,  1.169064451446804e-33, -5.152857525096819e-35,  6.873712856975304e-02, -1.954086543288268e-04,
  5.756634701327778e-07, -1.748673528598048e-09,  5.433937250748398e-12, -1.720172987945431e-14,  5.487340855148163e-17, -1.774989025624747e-19,  5.674892555896986e-22,
 -1.875115205745308e-24,  5.783370666627175e-27, -2.064191749088640e-29,  6.071375066412403e-02, -2.041797854516979e-04,  8.383929603489934e-07, -3.651855701420911e-09,
  1.587943198214298e-11, -6.786862779535875e-14,  2.844325793755992e-16, -1.172583644281794e-18,  4.756449304111750e-21, -1.908555237864355e-23,  7.543518318590941e-26,
 -2.970431899775559e-28,  4.736341839087484e-02, -2.087737889061749e-04,  1.209211786738915e-06, -6.843758300049031e-09,  3.683922953278920e-11, -1.905051896530948e-13,
  9.547611663535723e-16, -4.663848587492870e-18,  2.228926350810907e-20, -1.045135174268849e-22,  4.818167502249822e-25, -2.187806734028757e-27,  3.262792926103694e-02,
 -1.953411131953143e-04,  1.477487004707941e-06, -1.014926471897524e-08,  6.495655692593268e-11, -3.953134569381473e-13,  2.312250747703004e-15, -1.308389216810227e-17,
  7.197266821495462e-20, -3.862255741633533e-22,  2.028054222921076e-24, -1.044154282681298e-26,  1.984377158983092e-02, -1.610172947416825e-04,  1.503658110878154e-06,
 -1.222042679162588e-08,  9.149753833268511e-11, -6.452024091127272e-13,  4.336134391571651e-15, -2.799566847930861e-17,  1.746863872805677e-19, -1.058078316593138e-21,
  6.243485124933621e-24, -3.598660860486937e-26,  1.065161790835789e-02, -1.151356980036480e-04,  1.286699130643188e-06, -1.222366811827202e-08,  1.058563835191733e-10,
 -8.548841236741464e-13,  6.527914354537373e-15, -4.758422127044208e-17,  3.334360880379825e-19, -2.257788487229662e-21,  1.483407609925320e-23, -9.486850245148299e-26,
  5.044373338200366e-03, -7.110907687341344e-05,  9.352131648210790e-07, -1.030045576509098e-08,  1.022366834580579e-10, -9.373095120470551e-13,  8.065871072723478e-15,
 -6.586880720467855e-17,  5.145346496200458e-19, -3.867489292682286e-21,  2.810157648107164e-23, -1.981011793820132e-25,  2.106804625887444e-03, -3.793841529825577e-05,
  5.816735457647114e-07, -7.377548677200301e-09,  8.332007458672269e-11, -8.614055810367249e-13,  8.301835635720721e-15, -7.550641062706469e-17,  6.538335169850002e-19,
 -5.426099697430806e-21,  4.337778677762619e-23, -3.353861272840873e-25,  7.756785699530849e-04, -1.751418478748553e-05,  3.111893708688209e-07, -4.518899187551976e-09,
  5.774016949697493e-11, -6.696765312108484e-13,  7.193257818925400e-15, -7.253106521885481e-17,  6.931996683104384e-19, -6.325071468802401e-21,  5.540805195908896e-23,
 -4.680360717932650e-25,  2.516495872815769e-04, -7.010009401347245e-06,  1.437253970764614e-07, -2.377863195449748e-09,  3.422033476421353e-11, -4.434301707547936e-13,
  5.288355313036777e-15, -5.890320333266060e-17,  6.191991843291112e-19, -6.191446509998329e-21,  5.924466763218566e-23, -5.450690967332742e-25,  7.191183669205759e-05,
 -2.437199750787135e-06,  5.746270309841380e-08, -1.078719130307599e-09,  1.742233290244166e-11, -2.514156838733803e-13,  3.319016005089938e-15, -4.072008570225233e-17,
  4.695466233394177e-19, -5.131754609649044e-21,  5.350390255554031e-23, -5.348493711845187e-25,  1.809520701219001e-05, -7.373218970955837e-07,  1.993072252766098e-08,
 -4.231082683443940e-10,  7.647423052981351e-12, -1.225827484519951e-13,  1.787034600943897e-15, -2.409574231466213e-17,  3.041337326540049e-19, -3.625702370824169e-21,
  4.110758160209806e-23, -4.456422047388002e-25,  4.008834130602929e-06, -1.944050169083019e-07,  6.008415005367393e-09, -1.438470551182160e-10,  2.903017736940873e-12,
 -5.158402138198683e-14,  8.288962843363189e-16, -1.226202950002172e-17,  1.691325930016970e-19, -2.195901532389414e-21,  2.703309049528613e-23, -3.173519814946468e-25,
  7.819783326784126e-07, -4.474235494056402e-08,  1.577156613099488e-09, -4.248758143702542e-11,  9.557076450866625e-13, -1.879604784594421e-14,  3.324461937846126e-16,
 -5.388538638641756e-18,  8.112254786026523e-20, -1.145709504481816e-21,  1.529744062693661e-23, -1.942529980956659e-25,  1.343599032217575e-07, -9.003575832596147e-09,
  3.611497785019015e-10, -1.092810138387881e-11,  2.736076058292122e-13, -5.948978165762031e-15,  1.156968049462922e-16, -2.052819858970568e-18,  3.370122845743998e-20,
 -5.173249935409913e-22,  7.485488832964931e-24, -1.027382783919856e-25,  2.035295900803666e-08, -1.587242988013074e-09,  7.230036196671114e-11, -2.453872362257498e-12,
  6.831450518606062e-14, -1.640758846916680e-15,  3.506273197813613e-17, -6.805907011620867e-19,  1.217748257470605e-20, -2.030608660250853e-22,  3.182515297038712e-24,
 -4.718727487974080e-26,  2.722359402752672e-09, -2.457368689086228e-10,  1.268806293326699e-11, -4.824798465236035e-13,  1.492464645713616e-14, -3.957545967821382e-16,
  9.289043560140783e-18, -1.971847390392814e-19,  3.844057903678642e-21, -6.961259880306684e-23,  1.181415564755199e-24, -1.891829946062991e-26,  3.223339347520362e-10,
 -3.351983450147102e-11,  1.958613169365648e-12, -8.337475934877432e-14,  2.864303139302739e-15, -8.383237657256614e-17,  2.160871140838884e-18, -5.015883894058811e-20,
  1.065313257341676e-21, -2.094974431145874e-23,  3.849812187465773e-25, -6.657560516809402e-27,  3.391168869955606e-11, -4.046134068117730e-12,  2.671675267780110e-13,
 -1.272302852384464e-14,  4.853090572075507e-16, -1.567657434832622e-17,  4.437672534353884e-19, -1.126494712628084e-20,  2.606888134618913e-22, -5.567760142133058e-24,
  1.107996795007846e-25, -2.069443479474610e-27,  3.187702836830708e-12, -4.347991678235369e-13,  3.240165818474170e-14, -1.725353033686453e-15,  7.306304756769957e-17,
 -2.604981537162685e-18,  8.099817448392386e-20, -2.249089036289677e-21,  5.672501632640048e-23, -1.316138279558630e-24,  2.837030093421111e-26, -5.724197073125828e-28,
  2.698549843481090e-13, -4.193938090985072e-14,  3.522982546685718e-15, -2.096722887339682e-16,  9.856780871849236e-18, -3.879588051412008e-19,  1.325373072262220e-20,
 -4.026844071354553e-22,  1.107269307251121e-23, -2.791859840491275e-25,  6.520761080268960e-27, -1.421701093682114e-28,  2.080419980878365e-14, -3.672356034803078e-15,
  3.473062521621900e-16, -2.309241860404107e-17,  1.205071055563464e-18, -5.236866990331469e-20,  1.966157958430014e-21, -6.538464381261898e-23,  1.960776131183752e-24,
 -5.374318272060190e-26,  1.360516401903910e-27, -3.206199256494861e-29,  1.483453655244812e-15, -2.964568409112669e-16,  3.152179617425840e-17, -2.340082723198517e-18,
  1.355291598380767e-19, -6.502841124880179e-21,  2.683480980445507e-22, -9.769361417397920e-24,  3.195738153125922e-25, -9.523782277583189e-27,  2.613638163174375e-28,
 -6.658428306105982e-30,  9.994327741758831e-17, -2.253108990391130e-17,  2.688802426326762e-18, -2.226508514207234e-19,  1.430354871856606e-20, -7.575054616568001e-22,
  3.435156502340136e-23, -1.368899286617239e-24,  4.884154063998162e-26, -1.582458702331934e-27,  4.707388061534572e-29, -1.296241028522766e-30,  6.548559812206840e-18,
 -1.658338576947145e-18,  2.215836959431860e-19, -2.043390414612511e-20,  1.454382047820686e-21, -8.493605543000074e-23,  4.229453576081404e-24, -1.843617933547458e-25,
  7.170116691678537e-27, -2.524100098598189e-28,  8.133882091520209e-30, -2.419375978361742e-31,  4.337166755098886e-19, -1.227203758607098e-19,  1.829643352478478e-20,
 -1.874034533985424e-21,  1.474559442129384e-22, -9.478115317671268e-24,  5.173688343635799e-25, -2.462946565677603e-26,  1.042525374821278e-27, -3.981644297513895e-29,
  1.387923237108017e-30, -4.452830608799954e-32,  3.053164984190682e-20, -9.585883312992193e-21,  1.586577533692118e-21, -1.797330949513390e-22,  1.557567296564625e-23,
 -1.098182750746766e-24,  6.550318399371982e-26, -3.395323067566186e-27,  1.559686953300365e-28, -6.444588840184518e-30,  2.423394099795448e-31, -8.363516347500815e-33,
  2.432581532466630e-21, -8.397722340443582e-22,  1.531649730923736e-22, -1.906521608813919e-23,  1.808821608218169e-24, -1.391127377396667e-25,  9.019275861724865e-27,
 -5.064835606869838e-28,  2.512698537334641e-29, -1.118000126606432e-30,  4.514549681114618e-32, -1.668533106285720e-33,  2.360094077414040e-22, -8.852850829387369e-23,
  1.760731854786812e-23, -2.385045654627870e-24,  2.455037457351395e-25, -2.042002651139212e-26,  1.427368661570825e-27, -8.616094516826049e-29,  4.581808057649382e-30,
 -2.179344575677372e-31,  9.383925867977977e-33, -3.688842978420660e-34,  2.998869667581595e-23, -1.204051434922615e-23,  2.574251472530273e-24, -3.743578322203360e-25,
  4.127217634042588e-26, -3.667250401422992e-27,  2.731377668580921e-28, -1.752378610870847e-29,  9.880588025776889e-31, -4.971711328063996e-32,  2.259711935738324e-33,
 -9.356088269473722e-35,  5.182079741253201e-24, -2.186726369878103e-24,  4.933535440141466e-25, -7.565709394331388e-26,  8.781324647021795e-27, -8.199050741896576e-28,
  6.404581654762519e-29, -4.301356474476255e-30,  2.534195640551706e-31, -1.330110662480389e-32,  6.295617906539161e-34, -2.709889210870381e-35,  1.040120384048839e-24,
 -4.516871214936330e-25,  1.051593667508886e-25, -1.663637933415235e-26,  1.990168015666695e-27, -1.913117337693649e-28,  1.536844524581992e-29, -1.060290226254224e-30,
  6.410225926385311e-32, -3.448948249542726e-33,  1.671760232793944e-34, -7.361847207712473e-36,  6.796457372150688e-02, -1.908858305561891e-04,  5.551899198792899e-07,
 -1.664412908096477e-09,  5.102680049930123e-12, -1.594241648511046e-14,  5.014783457798785e-17, -1.603763995761913e-19,  5.039365911071207e-22, -1.661258333997374e-24,
  4.925238468490865e-27, -1.847766212324601e-29,  5.991017423331202e-02, -1.976437124418683e-04,  7.960514957774102e-07, -3.408283731562034e-09,  1.458775009390395e-11,
 -6.141964933085287e-14,  2.536318441130053e-16, -1.030812814790257e-18,  4.120674271644291e-21, -1.631416464985892e-23,  6.349625879501485e-26, -2.473003463405080e-28,
  4.654716427262618e-02, -1.994188564340783e-04,  1.130501434739518e-06, -6.283609442349289e-09,  3.324809306983687e-11, -1.690807248755153e-13,  8.336188367545174e-16,
 -4.007252642733272e-18,  1.885168867210027e-20, -8.703537952526980e-23,  3.951490395383787e-25, -1.767450681353077e-27,  3.186945743126637e-02, -1.839912955676795e-04,
  1.361680188195692e-06, -9.170314821902440e-09,  5.757684617558749e-11, -3.439676826965447e-13,  1.976161899963623e-15, -1.098843204054779e-17,  5.942447549759958e-20,
 -3.135919345991018e-22,  1.619893153376592e-24, -8.205820877252398e-27,  1.922286607498621e-02, -1.495506682607074e-04,  1.365388533483529e-06, -1.085429983329079e-08,
  7.957378945119540e-11, -5.499436086512036e-13,  3.625115367145790e-15, -2.296989113239528e-17,  1.407339353373101e-19, -8.373346344381400e-22,  4.855362950319156e-24,
 -2.750854661420225e-26,  1.021077230634486e-02, -1.054012943753826e-04,  1.149639488867501e-06, -1.065866727436658e-08,  9.022340631593888e-11, -7.130679746797571e-13,
  5.333487899666254e-15, -3.810792393715095e-17,  2.619017348721720e-19, -1.740173099803856e-21,  1.122394068748788e-23, -7.049201535835909e-26,  4.774155069662304e-03,
 -6.409534441283953e-05,  8.208362269662370e-07, -8.804715627900091e-09,  8.528600847086771e-11, -7.641212620465582e-13,  6.432578465444574e-15, -5.143039430965744e-17,
  3.936005792112529e-19, -2.900129572323773e-21,  2.066727856676036e-23, -1.429523895877109e-25,  1.963827400821517e-03, -3.361772861535251e-05,  5.006063615739860e-07,
 -6.172105267733081e-09,  6.792464930341520e-11, -6.853366163026611e-13,  6.453437715301942e-15, -5.740116454279799e-17,  4.864696050768098e-19, -3.953736472328590e-21,
  3.097152073015159e-23, -2.347628304234117e-25,  7.102783273862296e-04, -1.522683187635487e-05,  2.620922509911926e-07, -3.693472663203054e-09,  4.592063463518603e-11,
 -5.190982164623737e-13,  5.441541465255984e-15, -5.360143071549023e-17,  5.008812553839757e-19, -4.471752405510907e-21,  3.835232683798779e-23, -3.173536731062975e-25,
  2.257407436283930e-04, -5.965667567067042e-06,  1.182044243012334e-07, -1.894913612831894e-09,  2.649809781246275e-11, -3.342527859650840e-13,  3.885966692214491e-15,
 -4.224084905425517e-17,  4.337531937770160e-19, -4.239996233525828e-21,  3.968996809021452e-23, -3.574407451011394e-25,  6.300667783653184e-05, -2.024893610546578e-06,
  4.603771249491198e-08, -8.362194744786500e-10,  1.310633075180215e-11, -1.839003675795009e-13,  2.364135595894834e-15, -2.827945299494876e-17,  3.182565267961945e-19,
 -3.397602456823197e-21,  3.462765024153775e-23, -3.385993335179031e-25,  1.543536348283860e-05, -5.962774642527465e-07,  1.551363743267755e-08, -3.182434921009302e-10,
  5.575217565787937e-12, -8.680048132071620e-14,  1.231041697562991e-15, -1.616927638784298e-17,  1.990188086434629e-19, -2.315797852214027e-21,  2.564819972481243e-23,
 -2.718043547256124e-25,  3.317435900260946e-06, -1.525246578938673e-07,  4.530101474880485e-09, -1.046779326366847e-10,  2.045338066202448e-12, -3.526517671433645e-14,
  5.507900026878614e-16, -7.930496089354971e-18,  1.065898333216191e-19, -1.349825929890342e-21,  1.622213523796599e-23, -1.860506664988441e-25,  6.253469479862279e-07,
 -3.393054180086069e-08,  1.147923981392819e-09, -2.981658798542752e-11,  6.487210063203649e-13, -1.236881770597725e-14,  2.124635369467140e-16, -3.349365958752841e-18,
  4.910062578124437e-20, -6.759647919635935e-22,  8.805732452832304e-24, -1.091848584104346e-25,  1.033877303939948e-07, -6.572656293689793e-09,  2.527927066291551e-10,
 -7.368899643372811e-12,  1.783031408060064e-13, -3.755480605452207e-15,  7.088210327818685e-17, -1.222393859637860e-18,  1.952991673869511e-20, -2.920685711452256e-22,
  4.121180342528539e-24, -5.520570025606664e-26,  1.499758171093983e-08, -1.110270548328034e-09,  4.846132104909661e-11, -1.583405510622664e-12,  4.257261662801998e-14,
 -9.898652813907493e-16,  2.051687938841494e-17, -3.868654765495258e-19,  6.733016914009548e-21, -1.093323105661995e-22,  1.670300551197508e-24, -2.416232401511403e-26,
  1.910779305558516e-09, -1.638631425562072e-10,  8.104523748262013e-12, -2.965471912895290e-13,  8.854791107460651e-15, -2.271972751729860e-16,  5.169930629856032e-18,
 -1.065648032852460e-19,  2.019964262547889e-21, -3.560928885561349e-23,  5.889081252811997e-25, -9.198142481313223e-27,  2.142082903809789e-10, -2.118506278157182e-11,
  1.185731848686063e-12, -4.855750403007601e-14,  1.609801594412174e-15, -4.557593840597318e-17,  1.138577353753626e-18, -2.565614859116870e-20,  5.297005757434821e-22,
 -1.013823737286033e-23,  1.815159576952275e-25, -3.061254438195295e-27,  2.119398550709551e-11, -2.408034912870306e-12,  1.523519595477163e-13, -6.980049073036433e-15,
  2.569173025972917e-16, -8.027057724616453e-18,  2.202051734791484e-19, -5.425913977908262e-21,  1.220516806955265e-22, -2.536939293832966e-24,  4.918663336939806e-26,
 -8.959210856538820e-28,  1.859392296794339e-12, -2.418961042085556e-13,  1.728361817345255e-14, -8.857331736985326e-16,  3.620137083391948e-17, -1.248620718185222e-18,
  3.762921570589822e-20, -1.014336448670091e-21,  2.487042987973036e-23, -5.616664215031747e-25,  1.179739277273051e-26, -2.321764773532028e-28,  1.456589137839589e-13,
 -2.163262968158538e-14,  1.744128480203227e-15, -9.997094393401893e-17,  4.538425566615011e-18, -1.728825052756733e-19,  5.726688011216234e-21, -1.689743566950541e-22,
  4.518590366337170e-24, -1.109356331723347e-25,  2.525700022903251e-27, -5.373262755704914e-29,  1.029220222407602e-14, -1.740147719557179e-15,  1.581886346767731e-16,
 -1.014098482341663e-17,  5.115157622936428e-19, -2.153086792145949e-20,  7.843789347974737e-22, -2.534966476039782e-23,  7.397832846817450e-25, -1.975634794635673e-26,
  4.878294487133349e-28, -1.122470722528753e-29,  6.655272596611683e-16, -1.277428863106300e-16,  1.308154547892112e-17, -9.378058626190555e-19,  5.257011058551685e-20,
 -2.446132718926861e-21,  9.805702279900886e-23, -3.472901376099574e-24,  1.106660319230905e-25, -3.216485242895436e-27,  8.618069440379009e-29, -2.145661167123237e-30,
  4.019353572154251e-17, -8.731527003965996e-18,  1.006071655597203e-18, -8.062044918058233e-20,  5.022252145156691e-21, -2.583731096498172e-22,  1.139974043355229e-23,
 -4.425991976808189e-25,  1.540494646247328e-26, -4.874429131912351e-28,  1.417544969214661e-29, -3.819675047164131e-31,  2.332235548500701e-18, -5.713103921646978e-19,
  7.393537676501106e-20, -6.615992082418513e-21,  4.577378816635160e-22, -2.602634838670567e-23,  1.263583702791141e-24, -5.377034142070067e-26,  2.043858542194497e-27,
 -7.039463642993487e-29,  2.221551656494767e-30, -6.477133967884499e-32,  1.351525995496612e-19, -3.715595566673492e-20,  5.385566412699513e-21, -5.370746775952147e-22,
  4.120517434329302e-23, -2.586044709738051e-24,  1.379997928494644e-25, -6.429666822518865e-27,  2.666391623733722e-28, -9.986535615019114e-30,  3.416738247933755e-31,
 -1.076808314840684e-32,  8.237159682371361e-21, -2.525287273641326e-21,  4.081451761487606e-22, -4.519880251310976e-23,  3.833549562408035e-24, -2.648323158610621e-25,
  1.549361274860160e-26, -7.884642016404840e-28,  3.559041527943010e-29, -1.446240275133406e-30,  5.352388978473096e-32, -1.819315216276537e-33,  5.643714560085102e-22,
 -1.912680038871139e-22,  3.423574276429122e-23, -4.185224482428088e-24,  3.903090752298682e-25, -2.953183053287864e-26,  1.885212406878686e-27, -1.043158665023688e-28,
  5.103053252398308e-30, -2.240387479580558e-31,  8.932120262618531e-33, -3.261322715951712e-34,  4.710544190950717e-23, -1.744155264817806e-23,  3.422425936965765e-24,
 -4.575773256491288e-25,  4.651659545443756e-26, -3.823399885288120e-27,  2.642564920543398e-28, -1.578101295312563e-29,  8.306546822962506e-31, -3.912720760164386e-32,
  1.669181820924751e-33, -6.503818680135005e-35,  5.210074392088508e-24, -2.075439664876279e-24,  4.400354560403118e-25, -6.347274096519175e-26,  6.943332224423311e-27,
 -6.123755191209733e-28,  4.528762506929359e-29, -2.885981540395666e-30,  1.616797675038608e-31, -8.085698383316008e-33,  3.653652049208928e-34, -1.504365165657759e-35,
  8.049682058072810e-25, -3.384115985970302e-25,  7.604218924427239e-26, -1.161511414041129e-26,  1.342997165550088e-27, -1.249369447334446e-28,  9.725266456005718e-30,
 -6.509813594924783e-31,  3.823150939432751e-32, -2.000551282604723e-33,  9.441476476807915e-35, -4.052767619179798e-36,  1.507726861262954e-25, -6.539779451959920e-26,
  1.520572401744311e-26, -2.402452771165613e-27,  2.870367557257193e-28, -2.755872495709539e-29,  2.211240114084014e-30, -1.523834113750807e-31,  9.202613199103105e-33,
 -4.946142506899892e-34,  2.395038534664337e-35, -1.053660683198565e-36,  6.720978887062580e-02, -1.865228389028397e-04,  5.356965080021901e-07, -1.585256915852806e-09,
  4.795512654748453e-12, -1.479098663029191e-14,  4.587433027489782e-17, -1.451708510652615e-19,  4.474860007507681e-22, -1.480028019261622e-24,  4.146854590355281e-27,
 -1.702708434330982e-29,  5.913208265917307e-02, -1.914350214834917e-04,  7.565130231970316e-07, -3.184385690073049e-09,  1.341796563289867e-11, -5.566446348144936e-14,
  2.265302304406938e-16, -9.078785263649975e-19,  3.576574649182787e-21, -1.397938847257122e-23,  5.353796172186866e-26, -2.067151270473783e-28,  4.576711175262928e-02,
 -1.906676648529063e-04,  1.058181764930438e-06, -5.777642788913910e-09,  3.005779904435991e-11, -1.503549317041097e-13,  7.294111830980725e-16, -3.451226204748560e-18,
  1.598513852148753e-20, -7.268063970060507e-23,  3.250263721158892e-25, -1.432369295577468e-27,  3.115460362875253e-02, -1.735228748643467e-04,  1.256944839395316e-06,
 -8.301644070496323e-09,  5.114791744677468e-11, -3.000270324486788e-13,  1.693496040260382e-15, -9.255645347790249e-18,  4.921946851359822e-20, -2.554752988066983e-22,
  1.298545344900091e-24, -6.473054039890094e-27,  1.864571418334630e-02, -1.391277285660784e-04,  1.242427792771438e-06, -9.664592890790505e-09,  6.939536579262662e-11,
 -4.701763986576366e-13,  3.040729698294986e-15, -1.891347104521922e-17,  1.138126021478446e-19, -6.653165722053552e-22,  3.791995743994518e-24, -2.112173856846782e-26,
  9.806784573554489e-03, -9.669229413952479e-05,  1.029947880564987e-06, -9.322575242242094e-09,  7.716031474777235e-11, -5.969764218275254e-13,  4.374964531343823e-15,
 -3.064847952733885e-17,  2.066414801696912e-19, -1.347593462457625e-21,  8.534768617232627e-24, -5.265185889057949e-26,  4.530269197586489e-03, -5.792919245139428e-05,
  7.228886686690860e-07, -7.554476005018469e-09,  7.143772399954482e-11, -6.256877875283655e-13,  5.154235052755145e-15, -4.035763405694396e-17,  3.026761377917154e-19,
 -2.186733168108320e-21,  1.528733920752902e-23, -1.037746584539622e-25,  1.836921883505251e-03, -2.989165289921236e-05,  4.326353814007972e-07, -5.187065870184081e-09,
  5.564511883402337e-11, -5.481052716648066e-13,  5.044340309453115e-15, -4.389122252749702e-17,  3.641514812950440e-19, -2.899191108219351e-21,  2.225941738461636e-23,
 -1.654517390452926e-25,  6.533004203584102e-04, -1.329563547957738e-05,  2.218580204102726e-07, -3.035181960040021e-09,  3.673183794989049e-11, -4.048389169120222e-13,
  4.142857751283137e-15, -3.987818499164365e-17,  3.644484085914094e-19, -3.184393416038610e-21,  2.674569532926335e-23, -2.168466075333524e-25,  2.036348753075187e-04,
 -5.104257573620105e-06,  9.780405124632760e-08, -1.519732812071950e-09,  2.065741690867198e-11, -2.537448595191746e-13,  2.876615955527634e-15, -3.052489958911366e-17,
  3.062664182053961e-19, -2.927475974053428e-21,  2.681460606920351e-23, -2.364368949799544e-25,  5.558484210373414e-05, -1.693426280266371e-06,  3.714920967624080e-08,
 -6.531092832911094e-10,  9.937078749700522e-12, -1.356163290461938e-13,  1.698251490705204e-15, -1.981158856270405e-17,  2.176578439633774e-19, -2.270302906678476e-21,
  2.262380922184568e-23, -2.164418530033025e-25,  1.327626451939971e-05, -4.860498154472815e-07,  1.217745656802530e-08, -2.414647151775961e-10,  4.101402436369260e-12,
 -6.203919787889584e-14,  8.562161428231095e-16, -1.095781434360266e-17,  1.315565179725645e-19, -1.494505365821773e-21,  1.617239477449253e-23, -1.675706741721907e-25,
  2.772583560140051e-06, -1.208013402183126e-07,  3.449179490884165e-09, -7.694581971282625e-11,  1.456054298303028e-12, -2.436622446725006e-14,  3.699910628157107e-16,
 -5.186321089015086e-18,  6.793930430156729e-20, -8.393628516920056e-22,  9.849461537707038e-24, -1.103808037417343e-25,  5.059519142936686e-07, -2.601904093439581e-08,
  8.450561507592024e-10, -2.116796775640881e-11,  4.455698717483690e-13, -8.237800749297481e-15,  1.374552225355474e-16, -2.107926550884096e-18,  3.009651915723539e-20,
 -4.039569820220821e-22,  5.135074225013557e-24, -6.218134735100635e-26,  8.064338625649610e-08, -4.860684202108124e-09,  1.792748122219554e-10, -5.034976793896682e-12,
  1.177603853383985e-13, -2.403099695272917e-15,  4.402578465485350e-17, -7.380671381125327e-19,  1.147743680644756e-20, -1.672467375940109e-22,  2.301612742185037e-24,
 -3.009528630474870e-26,  1.122610463468296e-08, -7.883511237703396e-10,  3.297167640346379e-11, -1.037155440603351e-12,  2.693387187689767e-14, -6.063229462899182e-16,
  1.219047109011163e-17, -2.233180298740377e-19,  3.780906691038758e-21, -5.979247113325769e-23,  8.904984350048688e-25, -1.256904993426249e-26,  1.365456076244325e-09,
 -1.111588059558026e-10,  5.265419207369514e-12, -1.853773102560520e-13,  5.343197101369198e-15, -1.326601556340075e-16,  2.926680389120523e-18, -5.858002204591422e-20,
  1.079719835738665e-21, -1.852975689040527e-23,  2.986338845490407e-25, -4.549654104625245e-27,  1.452870311290805e-10, -1.365281783616017e-11,  7.317190500206086e-13,
 -2.882178421089259e-14,  9.219846807231533e-16, -2.524812443627512e-17,  6.112887731385263e-19, -1.337121621549665e-20,  2.683530782044349e-22, -4.998706145697844e-24,
  8.719464643800762e-26, -1.434071772896236e-27,  1.355363525574788e-11, -1.464943222003874e-12,  8.876358004070216e-14, -3.911229557019389e-15,  1.388861386063752e-16,
 -4.196408456690786e-18,  1.115461224145370e-19, -2.667582573900327e-21,  5.832004263419194e-23, -1.179632790617197e-24,  2.228020363789297e-26, -3.957366908763930e-28,
  1.112779214172549e-12, -1.379168006367221e-13,  9.442053449607226e-15, -4.654713899851855e-16,  1.835538933274437e-17, -6.122672997353869e-19,  1.787929195079799e-20,
 -4.677725313788226e-22,  1.114754507947640e-23, -2.449955410435109e-25,  5.013376287684370e-27, -9.622012182401777e-29,  8.088558578778380e-14, -1.146495829351782e-14,
  8.864745080207473e-16, -4.890563116154659e-17,  2.142944290514761e-18, -7.897094209909470e-20,  2.535459285799126e-21, -7.263010187599794e-23,  1.888233764528438e-24,
 -4.512561095709150e-26,  1.001192607693851e-27, -2.077794934125369e-29,  5.252301439893231e-15, -8.493836080853130e-16,  7.414561595730161e-17, -4.579304385661055e-18,
  2.231156582917456e-19, -9.091357570729220e-21,  3.212099620753807e-22, -1.008373940815638e-23,  2.862501838410344e-25, -7.445224713693593e-27,  1.792471270987173e-28,
 -4.025488948545625e-30,  3.087483510557108e-16, -5.683255343229104e-17,  5.598765650604886e-18, -3.872298695724122e-19,  2.099258337321252e-20, -9.465961748561221e-22,
  3.683693090380899e-23, -1.268477251072779e-24,  3.935308004404058e-26, -1.114927451044968e-27,  2.915083649298965e-29, -7.089577216319412e-31,  1.674845519605575e-17,
 -3.500299392211647e-18,  3.889020711227133e-19, -3.012503186349527e-20,  1.817999018318227e-21, -9.077606679946471e-23,  3.893686636929205e-24, -1.471799120674342e-25,
  4.993812025384953e-27, -1.542184054662060e-28,  4.381768954671987e-30, -1.154702453705582e-31,  8.616845537876425e-19, -2.038350075997350e-19,  2.551262286916719e-20,
 -2.212521722666956e-21,  1.486356344510740e-22, -8.219880739329214e-24,  3.887350510095761e-25, -1.613512325313916e-26,  5.989420856167534e-28, -2.016759600789507e-29,
  6.228540465359159e-31, -1.778847729150320e-32,  4.369206026300752e-20, -1.165067157924405e-20,  1.639288125036510e-21, -1.589536212521234e-22,  1.187667644049422e-23,
 -7.269811618695709e-25,  3.788659463265907e-26, -1.725986644178625e-27,  7.006310821354749e-29, -2.571169757410657e-30,  8.627335280838232e-32, -2.668899485819209e-33,
  2.301612183636394e-21, -6.878567329666849e-22,  1.083992431590727e-22, -1.171908802930913e-23,  9.715901709111355e-25, -6.568962548984235e-26,  3.765388568504810e-27,
 -1.879394008464801e-28,  8.328345058182001e-30, -3.325328182692231e-31,  1.210208033108632e-32, -4.048320295311504e-34,  1.350864831620834e-22, -4.487791408435349e-23,
  7.872417938250687e-24, -9.439493431306289e-25,  8.642933366148954e-26, -6.426536964241178e-27,  4.035228223287621e-28, -2.198058903185495e-29,  1.059336888869410e-30,
 -4.585133717065281e-32,  1.803417584961295e-33, -6.500212680044458e-35,  9.639755047213347e-24, -3.519104314589838e-24,  6.804925531920497e-25, -8.970473792422141e-26,
  8.997188931776158e-27, -7.301084815689924e-28,  4.985181722819021e-29, -2.942867046285360e-30,  1.532084569154814e-31, -7.141631269508870e-33,  3.016431103997879e-34,
 -1.164231735692478e-35,  9.206761362338779e-25, -3.635914528924937e-25,  7.638709921930602e-26, -1.092087701574748e-26,  1.184520393786820e-27, -1.036268926176851e-28,
  7.604771538521269e-30, -4.810786808210580e-31,  2.676387613343023e-32, -1.329619148931869e-33,  5.970216193008035e-35, -2.443453666471990e-36,  1.261462518625372e-25,
 -5.281419002895251e-26,  1.181493605442154e-26, -1.796843734374992e-27,  2.068925899424753e-28, -1.917008889240818e-29,  1.486546022562171e-30, -9.914399480436680e-32,
  5.802484914184269e-33, -3.026263421769881e-34,  1.423728740457504e-35, -6.093051837075337e-37,  2.191941190245683e-26, -9.495344518335870e-27,  2.204652791175529e-27,
 -3.478386764400792e-28,  4.150184573349022e-29, -3.979387579802454e-30,  3.188902490412446e-31, -2.194885797415387e-32,  1.323958270737857e-33, -7.107842445231397e-35,
  3.438032449829526e-36, -1.510926030063349e-37,  6.647214999193395e-02, -1.823120768917387e-04,  5.171242222413492e-07, -1.510836804645392e-09,  4.510381671674350e-12,
 -1.373721012333626e-14,  4.200223009823374e-17, -1.316732306873958e-19,  3.970125631841773e-22, -1.328887523930422e-24,  3.414751541752943e-27, -1.640195307613613e-29,
  5.837820981161134e-02, -1.855322008571924e-04,  7.195527148663826e-07, -2.978317574822694e-09,  1.235704946826106e-11, -5.052030290421923e-14,  2.026391274509409e-16,
 -8.010841212228860e-19,  3.109765985185876e-21, -1.200955634910983e-23,  4.519401975395595e-26, -1.736929301378981e-28,  4.502094414907842e-02, -1.824715843849154e-04,
  9.916393596139086e-07, -5.319855486943104e-09,  2.721822050130714e-11, -1.339532039506755e-13,  6.395620442693697e-16, -2.979174825262323e-18,  1.358823128285224e-20,
 -6.085685345545460e-23,  2.681130447613123e-25, -1.164397595989381e-27,  3.048001137887689e-02, -1.638523249496350e-04,  1.162044212829809e-06, -7.529158414844980e-09,
  4.553370905762705e-11, -2.623231997578065e-13,  1.455074032391248e-15, -7.818282743299582e-18,  4.089255200426632e-20, -2.088083811415620e-22,  1.044610901776297e-24,
 -5.124682492080235e-27,  1.810837334168898e-02, -1.296340209150420e-04,  1.132816686065469e-06, -8.625703075913260e-09,  6.068075388298380e-11, -4.031633935471305e-13,
  2.558738503766443e-15, -1.562714077652021e-17,  9.238149130245213e-20, -5.307034398176229e-22,  2.973822136595079e-24, -1.628790032515109e-26,  9.435814525573256e-03,
 -8.888007883637955e-05,  9.251080772112928e-07, -8.178100362082950e-09,  6.620494677381013e-11, -5.015705247386355e-13,  3.602534079109101e-15, -2.475055439881548e-17,
  1.637532077051253e-19, -1.048380582482655e-21,  6.521332595235609e-24, -3.952525740828194e-26,  4.309570737282706e-03, -5.249017609871643e-05,  6.387007913280450e-07,
 -6.505226750105685e-09,  6.007481597304523e-11, -5.145205653642637e-13,  4.148778006496675e-15, -3.182192101593212e-17,  2.339427261863323e-19, -1.657636813302274e-21,
  1.137105475405028e-23, -7.577188759567902e-26,  1.723903541740855e-03, -2.666520590418587e-05,  3.753909929326556e-07, -4.378258324154474e-09,  4.580052709812798e-11,
 -4.405624129959069e-13,  3.963982904734778e-15, -3.374975671931516e-17,  2.741957701658662e-19, -2.138985316140379e-21,  1.610025468201383e-23, -1.173764329083086e-25,
  6.034502686900751e-04, -1.165705104032625e-05,  1.887114160222562e-07, -2.507201711374966e-09,  2.954528853376219e-11, -3.175905361258400e-13,  3.173678183202598e-15,
 -2.986088589301388e-17,  2.669701530851847e-19, -2.283555955604324e-21,  1.878701767483242e-23, -1.492808202798371e-25,  1.846746631142782e-04, -4.389516208653798e-06,
  8.139430011106067e-08, -1.226334062662924e-09,  1.620901276902009e-11, -1.939454361577554e-13,  2.144648494209870e-15, -2.222235611764913e-17,  2.179145800155690e-19,
 -2.037328183015056e-21,  1.826443043070287e-23, -1.577137480463624e-25,  4.935944914181880e-05, -1.425071594315432e-06,  3.018304122822011e-08, -5.137754716759360e-10,
  7.591168307778240e-12, -1.007976432228753e-13,  1.229895912606625e-15, -1.399664320278721e-17,  1.501551603623857e-19, -1.530630355995564e-21,  1.491710487773569e-23,
 -1.396587473982519e-25,  1.151001240131065e-05, -3.991924187219836e-07,  9.636019668247609e-09, -1.847483973596075e-10,  3.043520777365343e-12, -4.474170993235236e-14,
  6.010594407028615e-16, -7.497113781711049e-18,  8.781611246110131e-20, -9.741786185906888e-22,  1.030223104145994e-23, -1.043924791608608e-25,  2.339231153422705e-06,
 -9.653938730603678e-08,  2.650967004510748e-09, -5.711036505316500e-11,  1.046925449784515e-12, -1.700879433664160e-14,  2.511598961246306e-16, -3.428281465986562e-18,
  4.378067688411461e-20, -5.278009200602037e-22,  6.048567086313137e-24, -6.624812075933105e-26,  4.139438279525535e-07, -2.016490834695551e-08,  6.289084403674436e-10,
 -1.519592497060480e-11,  3.095325209439848e-13, -5.550451712507314e-15,  8.998469324865119e-17, -1.342672824376168e-18,  1.867469082947174e-20, -2.444190608112521e-22,
  3.032446058054474e-24, -3.586695537930684e-26,  6.372722303289614e-08, -3.639445571909932e-09,  1.287424618600550e-10, -3.484242161735712e-12,  7.878364873372225e-14,
 -1.557955774767901e-15,  2.770976129459475e-17, -4.516585418806439e-19,  6.837376700347174e-21, -9.709499000068378e-23,  1.303380917156775e-24, -1.663793719945703e-26,
  8.530669004672685e-09, -5.678631313159604e-10,  2.275751430163755e-11, -6.892320592119283e-13,  1.728967415735304e-14, -3.768822615350161e-16,  7.351200087231701e-18,
 -1.308487052315155e-19,  2.155334979963593e-21, -3.319898215383119e-23,  4.820548940885952e-25, -6.639449200041090e-27,  9.927929886139937e-10, -7.665957076483103e-11,
  3.477274582424432e-12, -1.177899848458864e-13,  3.277371705458824e-15, -7.874115527828974e-17,  1.684286628748029e-18, -3.273878591070875e-20,  5.867894442997774e-22,
 -9.804036925770603e-24,  1.539863934549630e-25, -2.288383260719429e-27,  1.005020834639841e-10, -8.965497365152562e-12,  4.599764921782764e-13, -1.742435993375698e-14,
  5.377936923676838e-16, -1.424450897903524e-17,  3.342313003839050e-19, -7.096806366599510e-21,  1.384499042036396e-22, -2.509922313501753e-24,  4.265494021976617e-26,
 -6.841360978113636e-28,  8.862802058476613e-12, -9.103423420937028e-13,  5.280219374839415e-14, -2.237070070868499e-15,  7.662228680747372e-17, -2.238564014356821e-18,
  5.765054980153926e-20, -1.337961159418818e-21,  2.842728376908532e-23, -5.594898252738456e-25,  1.029357193449711e-26, -1.782724342999925e-28,  6.827975023161595e-13,
 -8.052899528301050e-14,  5.279314815380200e-15, -2.502535562914342e-16,  9.518358018492917e-18, -3.069729799493929e-19,  8.684183163125391e-21, -2.204735154922294e-22,
  5.105835035731369e-24, -1.091834550247875e-25,  2.176326588456204e-27, -4.072823195088016e-29,  4.618054669335656e-14, -6.239300334614670e-15,  4.622879282758181e-16,
 -2.453305560827516e-17,  1.037108355327485e-18, -3.695918859887995e-20,  1.149742494308092e-21, -3.196462859759234e-23,  8.076855143616366e-25, -1.878421187399897e-26,
  4.060327637139742e-28, -8.218046157952727e-30,  2.763452551381026e-15, -4.268460694509554e-16,  3.574603610459149e-17, -2.125334275460325e-18,  9.996343323774969e-20,
 -3.940978389410813e-21,  1.349750299995213e-22, -4.114185392095930e-24,  1.135599249613454e-25, -2.875562289361624e-27,  6.747677001336887e-29, -1.478531577683950e-30,
  1.480638045445955e-16, -2.609721602259371e-17,  2.470411186021326e-18, -1.646907775202732e-19,  8.627746212072346e-21, -3.767510970038453e-22,  1.422404943795481e-23,
 -4.759488037624104e-25,  1.436812119522095e-26, -3.965992186249639e-28,  1.011409055108318e-29, -2.401695758820435e-31,  7.230796325548720e-18, -1.451414396077840e-18,
  1.552953088386056e-19, -1.161564209127526e-20,  6.784377343354725e-22, -3.285099137086755e-23,  1.368816361341019e-24, -5.033796724732463e-26,  1.663892739103861e-27,
 -5.011859035990797e-29,  1.390450994269090e-30, -3.581481828296672e-32,  3.303755911137827e-19, -7.533678991791395e-20,  9.106535315934397e-21, -7.644251276156209e-22,
  4.980864446840482e-23, -2.676458679198610e-24,  1.231826124294211e-25, -4.982878659765481e-27,  1.804903598596581e-28, -5.937188820273778e-30,  1.793175113222931e-31,
 -5.013148632137600e-33,  1.466442730600081e-20, -3.785982086844289e-21,  5.163154551049382e-22, -4.861283151918264e-23,  3.533057775693722e-24, -2.106868825946408e-25,
  1.071204601081666e-26, -4.767055248799964e-28,  1.892472035842719e-29, -6.799157199847571e-31,  2.235650816479951e-32, -6.783596463484831e-34,  6.668655432127630e-22,
 -1.939443900922845e-22,  2.975437204519794e-23, -3.135893203455357e-24,  2.538092872353734e-25, -1.677457879572121e-26,  9.410666652707572e-28, -4.602184062580989e-29,
  2.000228036431168e-30, -7.840309317204766e-32,  2.803550091885507e-33, -9.222076915777756e-35,  3.341125350636343e-23, -1.086348891339616e-23,  1.864845349129731e-24,
 -2.190267575840016e-25,  1.966485544547428e-26, -1.435289323129456e-27,  8.854937560912432e-29, -4.743538959088565e-30,  2.250112267032243e-31, -9.593194715671580e-33,
  3.719277970581401e-34, -1.322331626472767e-35,  2.026057821875281e-24, -7.283053699295272e-25,  1.386142507871143e-25, -1.799526460235494e-26,  1.778811373688783e-27,
 -1.423684452168311e-28,  9.594420067712075e-30, -5.593824410994608e-31,  2.878002281628761e-32, -1.326561631905731e-33,  5.543441381433546e-35, -2.117921847549078e-36,
  1.657186279199771e-25, -6.482488466570157e-26,  1.348333227592195e-26, -1.909031965107047e-27,  2.051473072031651e-28, -1.778938649722558e-29,  1.294589735882961e-30,
 -8.124605700799651e-32,  4.485877493896784e-33, -2.212581418500543e-34,  9.867040471930912e-36, -4.012124558543017e-37,  1.995986687538868e-26, -8.318705441210654e-27,
  1.851876585157749e-27, -2.802937008474511e-28,  3.212580110865324e-29, -2.963673667749668e-30,  2.288613105592615e-31, -1.520320985248663e-32,  8.864218447154400e-34,
 -4.606475814787082e-35,  2.159725231860837e-36, -9.212728260202812e-38,  3.196770972743283e-27, -1.382878826791432e-27,  3.205862156664676e-28, -5.050329957491157e-29,
  6.016806281578936e-30, -5.760956667949205e-31,  4.610234166244990e-32, -3.168985415467532e-33,  1.909112512846022e-34, -1.023682520302909e-35,  4.945703254568941e-37,
 -2.171063627985327e-38,  6.575106255322367e-02, -1.782463969874531e-04,  4.994182847206977e-07, -1.440815108868525e-09,  4.245426604654240e-12, -1.277200650563268e-14,
  3.848622909766002e-17, -1.197093185194694e-19,  3.514570713403926e-22, -1.206774016294879e-24,  2.687657759012282e-27, -1.685819357642548e-29,  5.764737214546641e-02,
 -1.799154523755573e-04,  6.849666729035114e-07, -2.788431219381369e-09,  1.139351640632766e-11, -4.591527056906859e-14,  1.815393548822464e-16, -7.081546614796887e-19,
  2.708195906958111e-21, -1.034637352644034e-23,  3.815903765574589e-26, -1.470560122405277e-28,  4.430652992228792e-02, -1.747866175432067e-04,  9.303282599127659e-07,
 -4.904989985614579e-09,  2.468614015270452e-11, -1.195575353319860e-13,  5.619175160536404e-16, -2.577431290792965e-18,  1.157869235967577e-20, -5.109029270198052e-23,
  2.217794138548788e-25, -9.494294122332089e-28,  2.984263954478318e-02, -1.549053724449410e-04,  1.075898363688429e-06, -6.840765221297545e-09,  4.061946670638979e-11,
 -2.298871665422400e-13,  1.253406947877034e-15, -6.622351298522368e-18,  3.407625743419290e-20, -1.712047485840118e-22,  8.432357157783280e-25, -4.071210366226845e-27,
  1.760732929147659e-02, -1.209696078547851e-04,  1.034877929295833e-06, -7.716123540441523e-09,  5.319779529230417e-11, -3.466872031995862e-13,  2.159849211994685e-15,
 -1.295499155175860e-17,  7.525525140597336e-20, -4.249291326355100e-22,  2.341627735248736e-24, -1.261268679323431e-26,  9.094498858457475e-03, -8.185448828511807e-05,
  8.330101092076100e-07, -7.194600194952878e-09,  5.698492872951890e-11, -4.228669156310552e-13,  2.977546318860412e-15, -2.006718795802489e-17,  1.303160863878982e-19,
 -8.192394256318314e-22,  5.006332538040889e-24, -2.981633792529975e-26,  4.109356928458910e-03, -4.767722866954573e-05,  5.660824009295879e-07, -5.621231380355361e-09,
  5.071208813818387e-11, -4.248482770261134e-13,  3.354189467283790e-15, -2.520889599329432e-17,  1.817107165721427e-19, -1.263065654377903e-21,  8.503888895327718e-24,
 -5.563719929060268e-26,  1.622932971335073e-03, -2.386041421465572e-05,  3.269738794538442e-07, -3.711075172038730e-09,  3.786892794133826e-11, -3.558421948066931e-13,
  3.131084156846340e-15, -2.609269402267772e-17,  2.076393857668474e-19, -1.587510329452446e-21,  1.171748940593512e-23, -8.380519538440392e-26,  5.596616410232470e-04,
 -1.026012627006286e-05,  1.612644020912511e-07, -2.081420936180272e-09,  2.389212079624150e-11, -2.505612292414242e-13,  2.445781534764389e-15, -2.250007109510563e-17,
  1.968426704371988e-19, -1.648677502418267e-21,  1.328941613037322e-23, -1.035139073605827e-25,  1.683315629591365e-04, -3.793094614511699e-06,  6.811486587251805e-08,
 -9.954227076289700e-10,  1.279822152082755e-11, -1.492156500519153e-13,  1.609954031892809e-15, -1.629412582121295e-17,  1.562045369509060e-19, -1.428755591740334e-21,
  1.253931855027021e-23, -1.060609289967739e-25,  4.410576986205916e-05, -1.206347106101105e-06,  2.468481445058929e-08, -4.069647108069017e-10,  5.841250207601150e-12,
 -7.548712911478371e-14,  8.977319632257938e-16, -9.969193012371650e-18,  1.044600949541557e-19, -1.040896142291496e-21,  9.923271256550831e-24, -9.093734882631043e-26,
  1.005446322098597e-05, -3.302075945231308e-07,  7.684044126352363e-09, -1.424930053047803e-10,  2.277450669450307e-12, -3.254753968165572e-14,  4.257285502964860e-16,
 -5.176783661092958e-18,  5.917516692798327e-20, -6.411869905490203e-22,  6.628104135051953e-24, -6.569501790769327e-26,  1.991519117994512e-06, -7.781206181139547e-08,
  2.055899782523961e-09, -4.278345099337395e-11,  7.600019216583145e-13, -1.199056683092981e-14,  1.722278678101345e-16, -2.289780611876923e-18,  2.851308338343042e-20,
 -3.354942478500651e-22,  3.755570863176497e-24, -4.020878137628956e-26,  3.423004651122473e-07, -1.578658557722544e-08,  4.729570472170322e-10, -1.102580068555121e-11,
  2.173919417176357e-13, -3.781793388213068e-15,  5.958390007493184e-17, -8.652319666507667e-19,  1.172539392993581e-20, -1.496772800470524e-22,  1.812756066013494e-24,
 -2.094609802591691e-26,  5.099192019213705e-08, -2.757473358256639e-09,  9.357282002600716e-11, -2.440736246092711e-12,  5.336579022767791e-14, -1.022857377030700e-15,
  1.766520454984341e-17, -2.800039882684653e-19,  4.127135519092128e-21, -5.712433400638899e-23,  7.481037349148373e-25, -9.324245891472071e-27,  6.576910570487918e-09,
 -4.146996064217764e-10,  1.592575296692396e-11, -4.644308720612699e-13,  1.125558738708624e-14, -2.376091136041165e-16,  4.496905437593228e-18, -7.778442998302634e-20,
  1.246717399143202e-21, -1.870642900683281e-23,  2.648485476387709e-25, -3.559964199957292e-27,  7.339560304040243e-10, -5.371067121054190e-11,  2.332799666571925e-12,
 -7.603160650552732e-14,  2.042248273271662e-15, -4.748471394001347e-17,  9.848788750739821e-19, -1.859247616425843e-20,  3.240778657490849e-22, -5.271912877924237e-24,
  8.070184086103514e-26, -1.169940810145494e-27,  7.085663080743139e-11, -5.994897098937767e-12,  2.943577444696920e-13, -1.072246348016519e-14,  3.192951410450978e-16,
 -8.179877524134890e-18,  1.860080523269160e-19, -3.833935593229396e-21,  7.270684290731710e-23, -1.282820461794275e-24,  2.124012520420625e-26, -3.322200883964591e-28,
  5.921733542575757e-12, -5.774335719857431e-13,  3.204833593256439e-14, -1.305208615658561e-15,  4.311415993032641e-17, -1.217821349130747e-18,  3.038359340049779e-20,
 -6.842681377740241e-22,  1.412810395924339e-23, -2.705477933144634e-25,  4.848367572572891e-27, -8.186914054012388e-29,  4.292525709804831e-13, -4.811989727935449e-14,
  3.019088203766406e-15, -1.375593075734956e-16,  5.045011871805509e-18, -1.572769471854627e-19,  4.309557863454341e-21, -1.061529443484781e-22,  2.388598952373673e-24,
 -4.969165113756305e-26,  9.646890965615149e-28, -1.760101302279321e-29,  2.709027630276718e-14, -3.484249602200428e-15,  2.471966574137960e-16, -1.261231234724298e-17,
  5.141676135605274e-19, -1.771301110807292e-20,  5.337362086603996e-22, -1.439744721438056e-23,  3.534937315971558e-25, -7.998573521601246e-27,  1.684053553035273e-28,
 -3.323463226436930e-30,  1.498202349648295e-15, -2.207187567185777e-16,  1.771602279358520e-17, -1.013312032047446e-18,  4.598210802841633e-20, -1.753073848704373e-21,
  5.817647524078514e-23, -1.721082948179955e-24,  4.617417643502681e-26, -1.137918867279814e-27,  2.601694535422465e-29, -5.560381705918993e-31,  7.337135354368758e-17,
 -1.236370433072490e-17,  1.123361734391685e-18, -7.212026322101294e-20,  3.648304475936083e-21, -1.541778248882059e-22,  5.643975246262400e-24, -1.834112082308300e-25,
  5.385077592298078e-27, -1.447516712022840e-28,  3.598947105496599e-30, -8.340713538470010e-32,  3.233916789472881e-18, -6.224082281493304e-19,  6.404904508993743e-20,
 -4.620940836333973e-21,  2.609734885098885e-22, -1.224444193020754e-23,  4.952442433628326e-25, -1.770660230832831e-26,  5.698147391732938e-28, -1.673077709465547e-29,
  4.529703026540255e-31, -1.139797997934879e-32,  1.314749955984546e-19, -2.884890111159081e-20,  3.362897654856460e-21, -2.729013394715931e-22,  1.722800496139170e-23,
 -8.986217298939111e-25,  4.021390141556773e-26, -1.584012496870237e-27,  5.594441309226006e-29, -1.796488739385771e-30,  5.302448982010704e-32, -1.450156482956819e-33,
  5.113252921739742e-21, -1.275753042293540e-21,  1.683645939025767e-22, -1.537118592352093e-23,  1.085289472184424e-24, -6.298002913399623e-26,  3.120768703824942e-27,
 -1.355341915935358e-28,  5.257342901840189e-30, -1.847609783322048e-31,  5.948621512057027e-33, -1.769069067043539e-34,  2.005834005726955e-22, -5.666392228730935e-23,
  8.449259651215962e-24, -8.668399779553177e-25,  6.840182328969733e-26, -4.413830249748820e-27,  2.420769325204816e-28, -1.158723053147712e-29,  4.934532953331311e-31,
 -1.897052154860711e-32,  6.659292200713623e-34, -2.152277703756878e-35,  8.552531679908704e-24, -2.716996959685697e-24,  4.557023748050758e-25, -5.235149513339168e-26,
  4.602930477530241e-27, -3.293747575456962e-28,  1.994359442741962e-29, -1.049569518309511e-30,  4.895465042751479e-32, -2.053969821520544e-33,  7.842661758538458e-35,
 -2.748146398423384e-36,  4.381278337121776e-25, -1.548634910407148e-25,  2.897089354743255e-26, -3.699367319853012e-27,  3.599780193146861e-28, -2.838544752467044e-29,
  1.886152956161885e-30, -1.085078203306853e-31,  5.512301889104202e-33, -2.510346662718262e-34,  1.037064430074128e-35, -3.919262953151374e-37,  3.043095444643852e-26,
 -1.177956339469939e-26,  2.423334260165453e-27, -3.394775985288934e-28,  3.611276811539563e-29, -3.101526173455244e-30,  2.236564357331752e-31, -1.391521807009892e-32,
  7.620173263672478e-34, -3.729283184486045e-35,  1.650779327099147e-36, -6.665248859359017e-38,  3.191816181529024e-27, -1.323564450440119e-27,  2.930598520518844e-28,
 -4.412341973857647e-29,  5.031731426958248e-30, -4.619609591498731e-31,  3.551085411842510e-32, -2.348745995829801e-33,  1.363785935942281e-34, -7.059389067181952e-36,
  3.297400488887314e-37, -1.401579317490523e-38,  4.678356753689170e-28, -2.020688981572994e-28,  4.676600792882351e-29, -7.355009136704929e-30,  8.748426559438058e-31,
 -8.363443513497264e-32,  6.682927861652407e-33, -4.587154594459988e-34,  2.759682167123386e-35, -1.477818574494690e-36,  7.130744179647129e-38, -3.126462989207448e-39,
  6.504595976093376e-02, -1.743190741718381e-04,  4.825277943499147e-07, -1.374882735467626e-09,  3.998958069061598e-12, -1.188732790622616e-14,  3.528542929093129e-17,
 -1.091385214022582e-19,  3.097655788295091e-22, -1.114565494069588e-24,  1.907943300819456e-27, -1.890869116571814e-29,  5.693846216695148e-02, -1.745665329403765e-04,
  6.525697205837931e-07, -2.613251242606980e-09,  1.051722353302788e-11, -4.178680711722725e-14,  1.628703305050723e-16, -6.271695708474381e-19,  2.361702167012993e-21,
 -8.942844622315042e-24,  3.217043311817008e-26, -1.260409328772355e-28,  4.362190517077112e-02, -1.675728934388152e-04,  8.737616498291771e-07, -4.528432013445083e-09,
  2.242421342324333e-11, -1.068973035259439e-13,  4.946719430117330e-16, -2.234707454092003e-18,  9.889548593457796e-21, -4.300097938490603e-23,  1.839449237300179e-25,
 -7.764786064036255e-28,  2.923972768085210e-02, -1.466158328849830e-04,  9.975620516190298e-07, -6.226062156616415e-09,  3.630813502133646e-11, -2.019127606806429e-13,
  1.082365174685619e-15, -5.624349881662875e-18,  2.847921893535123e-20, -1.408001979678278e-22,  6.830053999677086e-25, -3.244728596367838e-27,  1.713944223705563e-02,
 -1.130469978093772e-04,  9.471714192252483e-07, -6.917730935498853e-09,  4.675438177733646e-11, -2.989450906931344e-13,  1.828646946812474e-15, -1.077453698890808e-17,
  6.151815259005354e-20, -3.414821514100861e-22,  1.851140943555123e-24, -9.805692011738176e-27,  8.779883342896382e-03, -7.552086676733547e-05,  7.518784427032019e-07,
 -6.346800219083764e-09,  4.919901369286758e-11, -3.577030864915870e-13,  2.469874314886057e-15, -1.633273276541269e-17,  1.041328974012004e-19, -6.429448344330453e-22,
  3.860890276470708e-24, -2.259855630919135e-26,  3.927296775054783e-03, -4.340521337834324e-05,  5.032291246541299e-07, -4.873668514647017e-09,  4.296617999590181e-11,
 -3.522006336501778e-13,  2.723352794098181e-15, -2.006053329638879e-17,  1.418159516490144e-19, -9.672425577441793e-22,  6.393137765912135e-24, -4.107589611612220e-26,
  1.532454715369107e-03, -2.141296997311250e-05,  2.858541167030831e-07, -3.158259682549702e-09,  3.144803351945383e-11, -2.887622389537403e-13,  2.485525016075409e-15,
 -2.027892916052759e-17,  1.581067939600148e-19, -1.185010235330424e-21,  8.579029163544230e-24, -6.020836930031571e-26,  5.210518756988881e-04, -9.063781747588185e-06,
  1.384253991154497e-07, -1.736249563873273e-09,  1.942031217536923e-11, -1.987620958178823e-13,  1.895725337229280e-15, -1.705643877069661e-17,  1.460541983355176e-19,
 -1.198134664684140e-21,  9.464642900221836e-24, -7.228382063127960e-26,  1.541780020073540e-04, -3.292688760370069e-06,  5.730634012086978e-08, -8.125718216580980e-10,
  1.016607179689748e-11, -1.155310223318334e-13,  1.216606402754076e-15, -1.203018408168813e-17,  1.127758049552675e-19, -1.009433655327202e-21,  8.674969783412099e-24,
 -7.188945252910613e-26,  3.964650995193687e-05, -1.026921656455481e-06,  2.031572457985323e-08, -3.245005346133461e-10,  4.526167773398860e-12, -5.694555057469359e-14,
  6.602633265224671e-16, -7.156614133976982e-18,  7.326299737883087e-20, -7.137970645816477e-22,  6.658193771577715e-24, -5.973698854887119e-26,  8.846561658901540e-06,
 -2.750015346100367e-07,  6.172954275123190e-09, -1.107519404266112e-10,  1.717955379084690e-12, -2.387510623333256e-14,  3.041534687207263e-16, -3.606498034613108e-18,
  4.024138913086512e-20, -4.259917460248510e-22,  4.305410093442823e-24, -4.174980230071748e-26,  1.710183251113784e-06, -6.322861638091395e-08,  1.608216882508165e-09,
 -3.233740294677767e-11,  5.568210630565272e-13, -8.533563951642129e-15,  1.192604331229242e-16, -1.544753477832785e-18,  1.876097918917926e-20, -2.154990711011158e-22,
  2.356868044464088e-24, -2.467115618987234e-26,  2.859599639598637e-07, -1.247831855905130e-08,  3.592519641591282e-10, -8.082452537064461e-12,  1.542935484174700e-13,
 -2.604618505268339e-15,  3.989054941526764e-17, -5.638629351785178e-19,  7.446842868592745e-21, -9.273295136841008e-23,  1.096540468992203e-24, -1.238019690701422e-26,
  4.129231217447963e-08, -2.112947948905839e-09,  6.879994647261398e-11, -1.729924953542025e-12,  3.658299987596048e-14, -6.797620540806829e-16,  1.140184357087457e-17,
 -1.757813053362701e-19,  2.523141501715560e-21, -3.404501957392248e-23,  4.350411304269863e-25, -5.295066748596187e-27,  5.141517293254913e-09, -3.068511854862465e-10,
  1.129344767340029e-11, -3.171616756535202e-13,  7.427149167710300e-15, -1.518669032358325e-16,  2.789207073323034e-18, -4.689142094117725e-20,  7.314105669222936e-22,
 -1.069192027947535e-23,  1.476224221898828e-25, -1.936706714907124e-27,  5.513583347650180e-10, -3.820693264221746e-11,  1.588859071029640e-12, -4.982686883326397e-14,
  1.292143158056795e-15, -2.907818087155355e-17,  5.848641698597107e-19, -1.072409491777450e-20,  1.818053759968835e-22, -2.879789892814035e-24,  4.296848344401716e-26,
 -6.077116477597376e-28,  5.087986092056998e-11, -4.078886398785759e-12,  1.916380669808574e-13, -6.712230242703875e-15,  1.928410997542889e-16, -4.778426028093846e-18,
  1.053097706391449e-19, -2.107145525818333e-21,  3.884556885767825e-23, -6.670675694985626e-25,  1.076109278682016e-26, -1.641466125637725e-28,  4.039980935092856e-12,
 -3.735924972583610e-13,  1.983355608983833e-14, -7.763117553455628e-16,  2.472807740275856e-17, -6.752593267861730e-19,  1.632016781495360e-20, -3.566488889462361e-22,
  7.155642246977546e-24, -1.333206661850573e-25,  2.327084282312132e-27, -3.831140018811896e-29,  2.762865349107108e-13, -2.940479795880301e-14,  1.764669829262904e-15,
 -7.725777226283404e-17,  2.731497117705071e-18, -8.229772426212527e-20,  2.183874502998955e-21, -5.218441497968690e-23,  1.140775271851887e-24, -2.308558737148730e-26,
  4.364494963087668e-28, -7.762761854576062e-30,  1.631679725350601e-14, -1.995213370841917e-15,  1.354471569711020e-16, -6.640788495674396e-18,  2.609766971410565e-19,
 -8.688460065759752e-21,  2.535221399266006e-22, -6.633756904525721e-24,  1.582278483059879e-25, -3.482598094399232e-27,  7.140615059666780e-29, -1.373771264477423e-30,
  8.364503904888928e-16, -1.173648564373089e-16,  9.020800355873040e-18, -4.960314047939764e-19,  2.170463402830311e-20, -7.998588039873221e-22,  2.570887083996947e-23,
 -7.379085976276219e-25,  1.923575540793908e-26, -4.612092368615695e-28,  1.027130147977734e-29, -2.140522242787285e-31,  3.755229658391076e-17, -6.040212556633136e-18,
  5.261937866127337e-19, -3.250499659456831e-20,  1.586646787575168e-21, -6.485090830397763e-23,  2.300559664879456e-24, -7.257027058883008e-26,  2.071322439475054e-27,
 -5.419608850693548e-29,  1.313153238736456e-30, -2.968972359926504e-32,  1.497971914282389e-18, -2.759598828796785e-19,  2.727704565662382e-20, -1.896242116392258e-21,
  1.034594516335774e-22, -4.699735681568411e-24,  1.843857477811966e-25, -6.405064299637701e-27,  2.005513727950902e-28, -5.736776064057020e-30,  1.514894421459706e-31,
 -3.721915373092117e-33,  5.431276883687384e-20, -1.144654283126152e-20,  1.284880689326366e-21, -1.006768595390244e-22,  6.151065949808963e-24, -3.111424537073826e-25,
  1.352655533466409e-26, -5.184045491112097e-28,  1.783868875339994e-29, -5.588084931844814e-31,  1.610768786353587e-32, -4.306696503805826e-34,  1.853279732363172e-21,
 -4.459929902277233e-22,  5.686717863380082e-23, -5.027279850553928e-24,  3.444057591046576e-25, -1.942719032755742e-26,  9.372270848188555e-28, -3.968505466020855e-29,
  1.502779999580764e-30, -5.161713247485903e-32,  1.625973431161063e-33, -4.735743216476562e-35,  6.270043444839296e-23, -1.717170197770674e-23,  2.484451297615096e-24,
 -2.477471135129270e-25,  1.903404914503133e-26, -1.197692018641057e-27,  6.414399843775711e-29, -3.001955213805787e-30,  1.251384864365019e-31, -4.714103971061877e-33,
  1.623080499158718e-34, -5.149902502238006e-36,  2.269346056448333e-24, -7.031095708825483e-25,  1.150309444485423e-25, -1.290634486620668e-26,  1.109746417876445e-27,
 -7.775667419087855e-29,  4.615398820012392e-30, -2.383604918690627e-31,  1.092081917978722e-32, -4.504853539538883e-34,  1.692515628649029e-35, -5.840288949843087e-37,
  9.766006422166813e-26, -3.389113110419237e-26,  6.222781253205432e-27, -7.805133118604428e-28,  7.467331455113634e-29, -5.794563330060173e-30,  3.792390226664638e-31,
 -2.150589843725075e-32,  1.077739284452692e-33, -4.845053841933804e-35,  1.977121134913272e-36, -7.385229195608405e-38,  5.710503507163535e-27, -2.185053325743688e-27,
  4.441290294290232e-28, -6.149662928865422e-29,  6.469794156485885e-30, -5.498514019806710e-31,  3.925840160368693e-32, -2.419634972628432e-33,  1.313245687870809e-34,
 -6.372741439163290e-36,  2.798304401109713e-37, -1.121264280486620e-38,  5.163834345115566e-28, -2.129351294296667e-28,  4.686671556988803e-29, -7.015388316734453e-30,
  7.955822396092931e-31, -7.265679581697511e-32,  5.557142972808722e-33, -3.658111151460752e-34,  2.114473074436732e-35, -1.089824493869038e-36,  5.069754264565220e-38,
 -2.146592047985527e-39,  6.872469387813361e-29, -2.963381149637418e-29,  6.845722474418965e-30, -1.074690429367469e-30,  1.276048618136092e-31, -1.217837360256988e-32,
  9.715564536074634e-34, -6.658419767681373e-35,  3.999830376121499e-36, -2.138873678867381e-37,  1.030637080098070e-38, -4.512910130309984e-40,  6.435630093001618e-02,
 -1.705237762466248e-04,  4.664054021167424e-07, -1.312756385944417e-09,  3.769438121156658e-12, -1.107606462383067e-14,  3.236238892429698e-17, -9.985497396641356e-20,
  2.708045536939156e-22, -1.056014962151289e-24,  9.860735962747588e-28, -2.353774578106950e-29,  5.625044250020068e-02, -1.694686127156912e-04,  6.221934518510430e-07,
 -2.451454993042297e-09,  9.719196754060923e-12, -3.808039710422680e-14,  1.463209357673232e-16, -5.565083649747355e-19,  2.061632173893503e-21, -7.761940497719514e-24,
  2.698894464740911e-26, -1.103708804054566e-28,  4.296525802440925e-02, -1.607942239868870e-04,  8.215046708110034e-07, -4.186123763896893e-09,  2.040009922829272e-11,
 -9.574165921056413e-14,  4.363076810285628e-16, -1.941654604079609e-18,  8.466117576881000e-21, -3.628324476708388e-23,  1.529571108447627e-25, -6.369718704741313e-28,
  2.866876571034044e-02, -1.389246096389283e-04,  9.262060542223464e-07, -5.676078383046286e-09,  3.251740443392024e-11, -1.777272989398319e-13,  9.369160937014919e-16,
 -4.789109872742236e-18,  2.386963688532703e-20, -1.161324128726495e-22,  5.551233178414796e-25, -2.593370615702544e-27,  1.670190061448444e-02, -1.057893997463604e-04,
  8.684572181540542e-07, -6.215206198036565e-09,  4.119102182549028e-11, -2.584662270181309e-13,  1.552769144788256e-15, -8.989161690013114e-18,  5.045986160108659e-20,
 -2.753902468218774e-22,  1.469122975646333e-24, -7.651859937262795e-27,  8.489365775126850e-03, -6.979762703377443e-05,  6.802138849844032e-07, -5.613776754677001e-09,
  4.260253817225354e-11, -3.035577240825700e-13,  2.055931471386820e-15, -1.334285100596708e-17,  8.354279023166052e-20, -5.066946535960115e-22,  2.990841806070334e-24,
 -1.720566644388496e-26,  3.761373009882354e-03, -3.960214285362331e-05,  4.486484063113362e-07, -4.239192629740704e-09,  3.653279458400397e-11, -2.930981927820948e-13,
  2.220289114122989e-15, -1.603352854953449e-17,  1.111937719674535e-19, -7.443021089084850e-22,  4.830888222253236e-24, -3.048566607316370e-26,  1.451147996378001e-03,
 -1.926959841874181e-05,  2.507934237189577e-07, -2.698235232002849e-09,  2.622611778954175e-11, -2.353888170807220e-13,  1.982577366896191e-15, -1.584070168057346e-17,
  1.210342072543272e-19, -8.895001415730527e-22,  6.317808158643614e-24, -4.351665250350492e-26,  4.868866785003467e-04, -8.034723035882395e-06,  1.193311570152000e-07,
 -1.455007840079265e-09,  1.586392971461699e-11, -1.585049076931910e-13,  1.477580034435742e-15, -1.300555903054213e-17,  1.090333254808447e-19, -8.762570435877802e-22,
  6.785204104873898e-24, -5.082044574864685e-26,  1.418660775208987e-04, -2.870642155600643e-06,  4.846001346340124e-08, -6.669207800096400e-10,  8.122125747508128e-12,
 -8.999814131974491e-14,  9.252656451761725e-16, -8.941553196889213e-18,  8.198828356179614e-20, -7.183200272107602e-22,  6.046240588151061e-24, -4.910149352554831e-26,
  3.584084346407099e-05, -8.788220512262200e-07,  1.682125984635298e-08, -2.603958067151111e-10,  3.530763446558625e-12, -4.326095980030595e-14,  4.891755889866223e-16,
 -5.176678776847805e-18,  5.178779860128797e-20, -4.934650541382845e-22,  4.504776375484635e-24, -3.957809550200436e-26,  7.837520540587585e-06, -2.305005834812662e-07,
  4.994293996665424e-09, -8.671994162529643e-11,  1.305966507058892e-12, -1.765475857398023e-14,  2.191118690859528e-16, -2.534195507675366e-18,  2.760858459728641e-20,
 -2.855998525905978e-22,  2.822782318578568e-24, -2.678589211184123e-26,  1.480740520385344e-06, -5.177565033064942e-08,  1.268457040848300e-09, -2.465169191251278e-11,
  4.115911836289216e-13, -6.129077823054883e-15,  8.336435489703891e-17, -1.052265050469773e-18,  1.246724894322831e-20, -1.398320260701132e-22,  1.494470324211668e-24,
 -1.529809955546820e-26,  2.412348792327876e-07, -9.953938601292613e-09,  2.755105822727933e-10, -5.983397688971818e-12,  1.106231687709124e-13, -1.812581932053389e-15,
  2.699139875265027e-17, -3.714748284570362e-19,  4.782185594676335e-21, -5.810463865407374e-23,  6.709534629495477e-25, -7.403096334251175e-27,  3.382264314354442e-08,
 -1.636578529307256e-09,  5.114812673954890e-11, -1.240013580441738e-12,  2.536827962180848e-14, -4.570794386928885e-16,  7.447623244741931e-18, -1.117005873581756e-19,
  1.561679036014485e-21, -2.054571899215419e-23,  2.562167095843144e-25, -3.045835975903862e-27,  4.073278387668456e-09, -2.299164251948435e-10,  8.110948954637984e-12,
 -2.193918762419904e-13,  4.965166545491824e-15, -9.835535986806197e-17,  1.753306279051861e-18, -2.865337761474586e-20,  4.350146636725396e-22, -6.196317140895882e-24,
  8.344104768798298e-26, -1.068587888866684e-27,  4.206090938192189e-10, -2.757599346388474e-11,  1.098008311732577e-12, -3.313381005059761e-14,  8.296551361288306e-16,
 -1.807244018480405e-17,  3.525458037056604e-19, -6.279472976315954e-21,  1.035503493835747e-22, -1.597299278143949e-24,  2.323227649756759e-26, -3.205864807688421e-28,
  3.718588350423324e-11, -2.821977392112686e-12,  1.268458232335819e-13, -4.271787313489071e-15,  1.184094927392060e-16, -2.838062047847433e-18,  6.062171342435244e-20,
 -1.177583372802328e-21,  2.110470841079995e-23, -3.527509702606532e-25,  5.544608395342324e-27, -8.248432217782572e-29,  2.812246167453342e-12, -2.463642511096029e-13,
  1.250670682496149e-14, -4.704033692065742e-16,  1.444785801237074e-17, -3.814002151554734e-19,  8.929401997828704e-21, -1.893480055236240e-22,  3.691589681746066e-24,
 -6.691848596333315e-26,  1.137675439258972e-27, -1.826075551969470e-29,  1.819350614507360e-13, -1.836163184031988e-14,  1.053510405018075e-15, -4.430503380953480e-17,
  1.509769193910907e-18, -4.395582549620198e-20,  1.129472859537164e-21, -2.617927115177777e-23,  5.559351537205679e-25, -1.094277150740587e-26,  2.014524313818271e-28,
 -3.492608707071300e-30,  1.008356937106202e-14, -1.170743272123442e-15,  7.599728730921703e-17, -3.578892730450259e-18,  1.355361851053870e-19, -4.359436682622766e-21,
  1.231516963750412e-22, -3.125203795339293e-24,  7.240121358294677e-26, -1.549808246503246e-27,  3.094031010792278e-29, -5.801961842932156e-31,  4.805942249109972e-16,
 -6.413268082832959e-17,  4.716195065097560e-18, -2.491556564407127e-19,  1.050741076832494e-20, -3.741317284063541e-22,  1.164280708483109e-23, -3.241148873599620e-25,
  8.206964921739697e-27, -1.913919342589953e-28,  4.150642412859998e-30, -8.432213417355335e-32,  1.984041647571346e-17, -3.041370444902054e-18,  2.537605222262238e-19,
 -1.507095298516611e-20,  7.093737827816858e-22, -2.802619527552218e-23,  9.629679888916303e-25, -2.947254394910050e-26,  8.174110540107049e-28, -2.080999140713327e-29,
  4.911866485698681e-31, -1.083025993856271e-32,  7.184139303295381e-19, -1.264607772803889e-19,  1.199145698193426e-20, -8.024271193890400e-22,  4.225888382401951e-23,
 -1.857176865811653e-24,  7.062929999248051e-26, -2.382266663816856e-27,  7.253446142162917e-29, -2.020272435290318e-30,  5.200692548579862e-32, -1.246973690550341e-33,
  2.329098388448828e-20, -4.705735736692543e-21,  5.079083499182111e-22, -3.837937064958191e-23,  2.266996576504988e-24, -1.111009421828392e-25,  4.688166558541493e-27,
 -1.746794733861460e-28,  5.852124997333694e-30, -1.787091799584581e-31,  5.027503103810343e-33, -1.313308503842802e-34,  6.985407763255615e-22, -1.618191972534391e-22,
  1.990233167378757e-23, -1.701298581817130e-24,  1.129478829537842e-25, -6.186061149674879e-27,  2.902558042649537e-28, -1.197146192811459e-29,  4.421641426482086e-31,
 -1.483121451470672e-32,  4.567409196351131e-34, -1.301871970806798e-35,  2.038902379419661e-23, -5.402411940964583e-24,  7.570975115272934e-25, -7.326881916065726e-26,
  5.473122030103744e-27, -3.354041901135213e-28,  1.752062653876997e-29, -8.008541347615301e-31,  3.264562669288407e-32, -1.203925428297002e-33,  4.062067568318785e-35,
 -1.264241417048192e-36,  6.251482929691362e-25, -1.885337413937260e-25,  3.003457350106287e-26, -3.285993003489632e-27,  2.759177265933747e-28, -1.890514979642710e-29,
  1.098707378106882e-30, -5.562031976471146e-32,  2.500541818640318e-33, -1.013105993863789e-34,  3.741835474839989e-36, -1.270368556586161e-37,  2.248185623228447e-26,
 -7.647077323649919e-27,  1.375928847063285e-27, -1.692752373712293e-28,  1.590145082927454e-29, -1.212811523455391e-30,  7.809105639658416e-32, -4.360588364547951e-33,
  2.153548247947392e-34, -9.548170262237098e-36,  3.845372822338890e-37, -1.418550752911257e-38,  1.097088429829696e-27, -4.144571217158252e-28,  8.313314955140125e-29,
 -1.136523730756224e-29,  1.181297559973783e-30, -9.925184110793172e-32,  7.010040467813739e-33, -4.276477010343304e-34,  2.298620349770750e-35, -1.105230222892331e-36,
  4.810958149806475e-38, -1.911851030881734e-39,  8.461983516315095e-29, -3.467692609792075e-29,  7.581973886029451e-30, -1.127655843269963e-30,  1.270998028056049e-31,
 -1.154000759190169e-32,  8.777754836383984e-34, -5.747994319371278e-35,  3.306033964044021e-36, -1.695970013580999e-37,  7.854319740974188e-39, -3.311562007689925e-40,
  1.013740182336422e-29, -4.363107294720098e-30,  1.005889075396415e-30, -1.575976288030318e-31,  1.867665374715695e-32, -1.779183534914989e-33,  1.416881229103029e-34,
 -9.694018276885164e-36,  5.813976921470794e-37, -3.104174227461841e-38,  1.493566072734357e-39, -6.530729370422616e-41,  };
  int offset = -32;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 32;
    if (std::isnan(t)) {
      fill_n(rr+offset, 32, 0.5);
      fill_n(ww+offset, 32, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 32; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=32; ++j) {
        const int boxof = it*384+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
