//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_17.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot17(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[17] = {3.576185855633747e-02,3.223028970154079e-01,8.977874382442501e-01,1.767133009504831e+00,2.938010436924722e+00,
    4.421236648583512e+00,6.231373602508013e+00,8.387620778171520e+00,1.091515015247613e+01,1.384714511079395e+01,1.722802494768479e+01,2.111880175525220e+01,
    2.560659579591730e+01,3.082316423852849e+01,3.698606526093494e+01,4.451103562790855e+01,5.446279044099501e+01};
  constexpr double aw[17] = {3.649924469966446e-01,2.746277156351368e-01,1.551104166233093e-01,6.544513410875273e-02,2.047315172701939e-02,
    4.698463629266589e-03,7.798175996231924e-04,9.186118982872301e-05,7.493448783302285e-06,4.097974035224618e-07,1.438773291253986e-08,3.056252041915478e-10,
    3.609881747486046e-12,2.087840373116021e-14,4.799901997894967e-17,2.956708922360592e-20,1.813800111959740e-24};
  constexpr double x[6528] = {  4.026240143647612e-03, -5.740535841783749e-05,  6.126161432004804e-07, -5.796143374385052e-09,  5.123822914691198e-11,
 -4.330765783046556e-13,  3.541526279012360e-15, -2.821039236987832e-17,  2.197434819173199e-19, -1.677701215292747e-21,  1.256837728093071e-23, -9.240936751190407e-26,
  3.605235737786457e-02, -5.060081385011388e-04,  5.230317321647526e-06, -4.685924149854957e-08,  3.803862449519052e-10, -2.830101386435453e-12,  1.916089105394783e-14,
 -1.145431055212881e-16,  5.525695103427682e-19, -1.386634723439960e-21, -1.163463103273540e-23,  2.435142835706440e-25,  9.912897156970975e-02, -1.347825649402261e-03,
  1.303996283804460e-05, -1.036239581747277e-07,  6.806866082122198e-10, -3.367202931767769e-12,  6.647532400666864e-15,  1.028304889392349e-16, -1.730972955606671e-18,
  1.660413975744783e-20, -1.128858519245068e-22,  4.476554304232451e-25,  1.913273010481679e-01, -2.478469683297407e-03,  2.157491026980766e-05, -1.380448653594610e-07,
  5.288353357207712e-10,  1.203925173041005e-12, -4.371837725547546e-14,  4.371861970772549e-16, -2.383763280031713e-18, -6.857979557914833e-22,  1.758904092041787e-22,
 -2.145562120931292e-24,  3.098105618476319e-01, -3.756713483422153e-03,  2.800109993448882e-05, -1.188732850617015e-07, -1.956528527105824e-10,  8.344304845953493e-12,
 -7.033643505937142e-14,  1.614275367151789e-16,  3.255904735002490e-18, -4.621419587089468e-20,  2.481324880163471e-22,  9.154463245411256e-25,  4.509022438229195e-01,
 -5.021227641139134e-03,  2.990760664660297e-05, -3.873554153980127e-08, -1.149139040660493e-09,  1.104367600337815e-11, -1.346024611359909e-14, -6.647087626561356e-16,
  6.574056202633864e-18, -4.464956523690439e-21, -4.904531849070133e-22,  4.669494313513287e-24,  6.101779605500103e-01, -6.110169001380425e-03,  2.600632192745842e-05,
  7.963336717135076e-08, -1.712846757154385e-09,  4.668566638565385e-12,  8.906709161157171e-14, -8.694835815130348e-16, -1.649701285972901e-18,  8.073986473574151e-20,
 -3.666501827842918e-22, -4.661136234091670e-24,  7.825811592851407e-01, -6.881487170080425e-03,  1.654635117638152e-05,  1.917022201807092e-07, -1.421420098017770e-09,
 -7.383018921112374e-12,  1.233185290398391e-13,  1.376134163502099e-16, -1.033518110561176e-17,  2.510003133949031e-20,  8.041942815157996e-22, -5.163287460909042e-24,
  9.625625186648181e-01, -7.231562187045562e-03,  3.313651131567294e-06,  2.508743966106106e-07, -3.282512753833632e-10, -1.556479101556872e-11,  3.405127411053298e-14,
  1.166731089452832e-15, -3.629269399848671e-18, -9.623545408757043e-20,  3.929247818768607e-22,  8.395062468778210e-24,  1.144242044191590e+00, -7.109761887996844e-03,
 -1.080789253465873e-05,  2.306402652221911e-07,  9.760574917125218e-10, -1.268920140699643e-11, -9.386853274986833e-14,  7.841590661500062e-16,  9.230808287915738e-18,
 -4.738802651616676e-20, -9.123218437092977e-22,  2.340660276062758e-24,  1.321591648089886e+00, -6.526768723570923e-03, -2.261449111715920e-05,  1.382225605979762e-07,
  1.737615563116376e-09, -9.781264430573402e-13, -1.258782510215909e-13, -5.154375272349566e-16,  7.627111822700427e-18,  8.034121173708114e-20, -2.656927481051631e-22,
 -8.508612228719631e-24,  1.488634373887856e+00, -5.555113592860753e-03, -2.949197898059535e-05,  1.223408608732357e-08,  1.553653123953969e-09,  9.725787896348313e-12,
 -3.756055735569162e-14, -9.860545526464292e-16, -4.326772096792464e-18,  4.797414720643465e-20,  7.296040433983501e-22,  1.439924615752871e-24,  1.639654480826120e+00,
 -4.321265710345358e-03, -3.019123005979309e-05, -9.543022762863926e-08,  6.466584553045746e-10,  1.124489840513240e-11,  6.115092177510016e-14, -2.141940083344343e-16,
 -6.629004830398046e-18, -4.843146161788542e-20,  5.246274398997123e-23,  4.551053667604602e-24,  1.769410535297879e+00, -2.989793265085169e-03, -2.522239100768408e-05,
 -1.448855459552539e-07, -3.199899912350477e-10,  4.502418774952988e-12,  6.906057550205602e-14,  4.834208647230659e-16,  7.531511196486261e-19, -2.651021949816050e-20,
 -3.734522561056141e-22, -2.444644814877040e-24,  1.873341826981437e+00, -1.741379241479333e-03, -1.672175916837236e-05, -1.276757429180690e-07, -7.509536005212571e-10,
 -2.541380522366840e-12,  1.079028497354553e-14,  2.911654832096980e-16,  3.082462531296505e-18,  2.112911966064319e-20,  6.860002450229412e-23, -5.808396626309207e-25,
  1.947757756157970e+00, -7.476200063827973e-04, -7.805716892677158e-06, -6.966587236569284e-08, -5.518270177149475e-10, -3.872294643162463e-12, -2.315271537701299e-14,
 -1.024719224794111e-16, -8.521606966184589e-20,  4.927418221747056e-21,  7.516773910168135e-23,  7.656861714846730e-25,  1.990009645379135e+00, -1.461617860867855e-04,
 -1.595759263854818e-06, -1.538158351711217e-08, -1.378008813398292e-10, -1.172545880952903e-12, -9.574163268290458e-15, -7.536986706859838e-17, -5.727184709608594e-19,
 -4.193843640550133e-21, -2.945117251770427e-23, -1.964332995765408e-25,  3.805998905201302e-03, -5.276933690612269e-05,  5.477097206822853e-07, -5.041260759736059e-09,
  4.336656449473649e-11, -3.568165721178995e-13,  2.841648975134016e-15, -2.205535259633107e-17,  1.674952357611199e-19, -1.247682099251035e-21,  9.127367876080587e-24,
 -6.560552169633591e-26,  3.410858919350273e-02, -4.663155231542028e-04,  4.702733677565138e-06, -4.120194712001091e-08,  3.281331678576685e-10, -2.406777251258495e-12,
  1.619320103501377e-14, -9.773061135305972e-17,  4.965309095629957e-19, -1.672656590632081e-21, -3.435730689102166e-24,  1.375386572289188e-25,  9.393868766882288e-02,
 -1.248299807336937e-03,  1.185962939815464e-05, -9.326218341894481e-08,  6.151410619041252e-10, -3.178848174507232e-12,  8.835186080924356e-15,  5.617123523424875e-17,
 -1.209634323446904e-18,  1.249446737044243e-20, -9.247611860714875e-23,  4.653987766468395e-25,  1.817483345128454e-01, -2.312351231847041e-03,  1.996976100094128e-05,
 -1.294438736400041e-07,  5.433684850692045e-10,  2.929803723652993e-13, -3.254013213152526e-14,  3.616956642967203e-16, -2.302789543492851e-18,  4.655368713615403e-21,
  9.581498541669936e-23, -1.508721482895116e-24,  2.952226319941403e-01, -3.538451723328380e-03,  2.656105264735428e-05, -1.207586310370784e-07, -4.522680518974088e-11,
  6.720776138912306e-12, -6.459393214565311e-14,  2.409681613488159e-16,  1.777060118773831e-18, -3.585866879324732e-20,  2.614395242659132e-22, -2.127237869378349e-25,
  4.312924917457877e-01, -4.784122017117204e-03,  2.933967850276570e-05, -5.537823368885293e-08, -9.328817744775109e-10,  1.052078575980853e-11, -2.917575714812076e-14,
 -4.602978924689234e-16,  6.109225686646850e-18, -2.003864405405522e-20, -2.912843970832750e-22,  4.258200275019483e-24,  5.861587903539204e-01, -5.898754109271657e-03,
  2.680092371576216e-05,  5.308258172921967e-08, -1.600091141589805e-09,  6.510640604085765e-12,  6.439720358745699e-14, -8.789470818729315e-16,  9.514870403184125e-19,
  6.284423701884384e-20, -5.069959439899072e-22, -1.769545740224481e-24,  7.553339622922747e-01, -6.740311453984588e-03,  1.870597158270625e-05,  1.679396734405365e-07,
 -1.539360752420870e-09, -4.413463013093981e-12,  1.227188712111819e-13, -1.729313550509860e-16, -8.913340282341015e-18,  5.208714151023595e-20,  5.326042258789635e-22,
 -6.886455809965529e-24,  9.337081979778810e-01, -7.193123607255969e-03,  6.282532532544175e-06,  2.431872438829312e-07, -6.288096013662356e-10, -1.437173781735409e-11,
  6.459861441196003e-14,  9.988768905607154e-16, -6.728323741461168e-18, -7.386824814453374e-20,  7.043641999418535e-22,  5.516448196684691e-24,  1.115647947442358e+00,
 -7.184908851322173e-03, -7.955257412189463e-06,  2.441125514007992e-07,  7.016884077705325e-10, -1.464701188987534e-11, -6.808181877084342e-14,  1.045482775536709e-15,
  6.904165571834247e-18, -8.057838604279159e-20, -7.174511618489532e-22,  6.405286052015461e-24,  1.295133910166001e+00, -6.700579913589093e-03, -2.079019870923777e-05,
  1.656993867219786e-07,  1.686826791690840e-09, -4.142231044356753e-12, -1.364776672171337e-13, -2.278869266669083e-16,  1.023649950165170e-17,  6.210309940731354e-20,
 -6.456506262021502e-22, -8.423032642718824e-24,  1.465943593277604e+00, -5.790025177610017e-03, -2.918978516166166e-05,  3.859003687784510e-08,  1.736844630188072e-09,
  8.479173939424660e-12, -6.680820875582721e-14, -1.091171275857411e-15, -2.066773577555996e-18,  7.756625543521150e-20,  7.264246453372191e-22, -1.791605585571193e-24,
  1.621879377096198e+00, -4.567182712280105e-03, -3.126664029954279e-05, -8.320725858887964e-08,  8.856162192783153e-10,  1.261499466910134e-11,  5.192691484486364e-14,
 -4.533865240119967e-16, -8.281115134146102e-18, -4.173740822291146e-20,  2.966178272392552e-22,  6.515146489825927e-24,  1.757036679591673e+00, -3.198606484867443e-03,
 -2.698846062411710e-05, -1.491903050034189e-07, -2.122607383973344e-10,  6.324035294384516e-12,  8.276853176460260e-14,  4.891600262277495e-16, -4.957226855467108e-19,
 -4.355757686333792e-20, -4.767163972670276e-22, -2.136356218151647e-24,  1.866098765186194e+00, -1.881489766740891e-03, -1.832758328548765e-05, -1.400805692746464e-07,
 -7.984705273603508e-10, -2.172715579009643e-12,  2.044164013237194e-14,  4.024421986653724e-16,  3.884477445346109e-18,  2.315162566871200e-20,  2.661884625256380e-23,
 -1.393874982548414e-24,  1.944636870141195e+00, -8.135658872420394e-04, -8.697338940127733e-06, -7.914584169303785e-08, -6.350627844619332e-10, -4.462512133678088e-12,
 -2.602889273349451e-14, -1.017088815096382e-16,  1.552672271991586e-19,  8.703479342800376e-21,  1.161955891101013e-22,  1.117553204525274e-24,  1.989398241714192e+00,
 -1.597055251482913e-04, -1.794383526495732e-06, -1.778724631814363e-08, -1.637318629613422e-10, -1.429869095948279e-12, -1.196551872176509e-14, -9.635786797971666e-17,
 -7.471515487615589e-19, -5.563340668793642e-21, -3.951728208636890e-23, -2.642745039252016e-25,  3.603317744095998e-03, -4.861836323827098e-05,  4.911537373598136e-07,
 -4.400980447323318e-09,  3.686517004443019e-11, -2.954610490033194e-13,  2.292856004139137e-15, -1.734898451400493e-17,  1.285101525024528e-19, -9.343303607402393e-22,
  6.676055174400480e-24, -4.691540831818625e-26,  3.231556083903568e-02, -4.305856205768510e-04,  4.238288557356971e-06, -3.631668367315226e-08,  2.836713785357612e-10,
 -2.049238775572038e-12,  1.367001017888392e-14, -8.282109372608176e-17,  4.350999429916838e-19, -1.710531612209609e-21,  1.071271503577109e-24,  7.267563030592118e-26,
  8.912838452482841e-02, -1.157736793231485e-03,  1.079747730191383e-05, -8.391655991771158e-08,  5.537910076689485e-10, -2.951913137078345e-12,  9.928824081580985e-15,
  2.398534759263612e-17, -8.215673581590317e-19,  9.194884299767863e-21, -7.282810690746829e-23,  4.213608847739151e-25,  1.728088169405671e-01, -2.158658467401772e-03,
  1.846866286195394e-05, -1.207422376005849e-07,  5.421964956706517e-10, -3.746016702590181e-13, -2.341453757107865e-14,  2.913077049762934e-16, -2.080702035433836e-18,
  7.323880182826667e-21,  4.142749197884538e-23, -9.848976292910542e-25,  2.814846197136071e-01, -3.331762337982670e-03,  2.511177668354119e-05, -1.204887711727067e-07,
  7.426109830054586e-11,  5.256791571829037e-12, -5.723055025966161e-14,  2.791662438065421e-16,  6.701531918576994e-19, -2.579846502828841e-20,  2.372147066813288e-22,
 -8.132755201205318e-25,  4.126208923086496e-01, -4.552300763910672e-03,  2.859239249174786e-05, -6.866305539601427e-08, -7.304011203146305e-10,  9.687260303388330e-12,
 -3.944959495025041e-14, -2.782417847154328e-16,  5.221007472181926e-18, -2.819585723799412e-20, -1.234607474809639e-22,  3.319211863963345e-24,  5.629960222218205e-01,
 -5.682223579868629e-03,  2.728885232495299e-05,  2.859851961117444e-08, -1.456390319712667e-09,  7.766235436956884e-12,  4.052450121872523e-14, -8.163222343959724e-16,
  2.836907869180523e-18,  4.174701223669603e-20, -5.308960545099829e-22,  5.559380203117926e-25,  7.286841767747151e-01, -6.583026962359276e-03,  2.057106866760835e-05,
  1.427615700697420e-07, -1.598728424476385e-09, -1.556680914865665e-12,  1.141913454068013e-13, -4.246463265411326e-16, -6.729028423398688e-18,  6.721442362111776e-20,
  2.237914503626573e-22, -6.889012151638429e-24,  9.050544367807872e-01, -7.131382647932968e-03,  9.131226119411325e-06,  2.309200909197493e-07, -8.986106608879042e-10,
 -1.251233023317589e-11,  8.919430348098727e-14,  7.468699337489564e-16, -8.831877341876419e-18, -4.193906387877504e-20,  8.639013444565337e-22,  1.663329628558088e-24,
  1.086799819903822e+00, -7.236665438039786e-03, -4.968471115957282e-06,  2.529176313295867e-07,  3.948966653864894e-10, -1.590759148081085e-11, -3.618732557005350e-14,
  1.215074942199944e-15,  3.563616903272833e-18, -1.026834459930388e-19, -3.671553259165577e-22,  9.225835356148489e-24,  1.268012178459841e+00, -6.858496576222909e-03,
 -1.864318532146182e-05,  1.918464125732296e-07,  1.570910043581506e-09, -7.455379761995330e-12, -1.379760526061648e-13,  1.297704299693680e-16,  1.192237317138291e-17,
  2.937469566717586e-20, -9.740559604139309e-22, -6.130610625456656e-24,  1.442320072011615e+00, -6.021206445046948e-03, -2.855468220891025e-05,  6.763861345330251e-08,
  1.887892401662622e-09,  6.504445485895959e-12, -9.782838468328605e-14, -1.107246274954629e-15,  1.218891445741479e-18,  1.038555221896588e-19,  5.573058898235668e-22,
 -5.996075104570467e-24,  1.603104422133073e+00, -4.821049304436296e-03, -3.217157613713394e-05, -6.695615907493224e-08,  1.149189987152415e-09,  1.367766620152042e-11,
  3.531599159455086e-14, -7.395424432256811e-16, -9.496527094926985e-18, -2.365869504634465e-20,  6.176203898521813e-22,  7.914990183605959e-24,  1.743799031895540e+00,
 -3.421722702752613e-03, -2.879458523424311e-05, -1.514620963332286e-07, -6.482207552588003e-11,  8.471460528006947e-12,  9.597996359721251e-14,  4.443586226720902e-16,
 -2.427317774062416e-18, -6.423144981720913e-20, -5.482487588525937e-22, -9.307220870939757e-25,  1.858268607939200e+00, -2.035054593597693e-03, -2.008653983591663e-05,
 -1.531729824391791e-07, -8.360302291389108e-10, -1.532075229559637e-12,  3.357623925980297e-14,  5.401467865543880e-16,  4.719302997451479e-18,  2.265112467945901e-20,
 -6.095163218920882e-23, -2.673542903149036e-24,  1.941237180994656e+00, -8.871233445291591e-04, -9.711112884374556e-06, -9.005574398709207e-08, -7.307863820777427e-10,
 -5.120494193608576e-12, -2.875308893088491e-14, -9.072632806049084e-17,  5.652684327709440e-19,  1.446442294983273e-20,  1.752862761196678e-22,  1.589228331662092e-24,
  1.988729291774468e+00, -1.749611957834063e-04, -2.024545625980033e-06, -2.065230663258788e-08, -1.954342986986218e-10, -1.752316044411335e-12, -1.503068550878987e-14,
 -1.238004573739226e-16, -9.789072095026697e-19, -7.401141034157317e-21, -5.302145223147037e-23, -3.534038170008855e-25,  3.416381864056448e-03, -4.489078353768723e-05,
  4.416952770579723e-07, -3.855578792893646e-09,  3.146916312265553e-11, -2.458264030612447e-13,  1.859945732064475e-15, -1.372707433023780e-17,  9.922239202091812e-20,
 -7.043740847838777e-22,  4.917159193427723e-24, -3.379000360134023e-26,  3.065837587006906e-02, -3.983483571519704e-04,  3.828423962365256e-06, -3.208875500300624e-08,
  2.457874584541529e-10, -1.747469561061770e-12,  1.153677812850277e-14, -6.986944077768461e-17,  3.749423327299625e-19, -1.616643139776755e-21,  3.341841764919584e-24,
  3.389916590000363e-26,  8.466402617739194e-02, -1.075238740399516e-03,  9.841736699726235e-06, -7.551508409106402e-08,  4.971759355641984e-10, -2.708246434938359e-12,
  1.027831046455943e-14,  2.464358503302646e-18, -5.386909510592370e-19,  6.633549783714316e-21, -5.573133460494134e-23,  3.540230914866857e-25,  1.644607124857127e-01,
 -2.016558068996907e-03,  1.707146799286947e-05, -1.121549213903334e-07,  5.297078440721707e-10, -8.459419016558031e-13, -1.614861239996219e-14,  2.291865095757992e-16,
 -1.796504248886067e-18,  8.239180057204687e-21,  7.195335970417062e-24, -5.922861285147872e-25,  2.685502400983677e-01, -3.136623867710606e-03,  2.367627557940747e-05,
 -1.185314446876325e-07,  1.663038614730712e-10,  3.978686967978125e-12, -4.924066587703764e-14,  2.875068243819694e-16, -9.726186767049417e-20, -1.711332218145420e-20,
  1.954373982474967e-22, -1.035975717983827e-24,  3.948636876444552e-01, -4.327041741135660e-03,  2.770453782939597e-05, -7.885327544050479e-08, -5.466613815615443e-10,
  8.664894688613449e-12, -4.505918338099974e-14, -1.280967724436698e-16,  4.149373954362843e-18, -3.053095820360961e-20, -1.176886578792351e-24,  2.240813254686472e-24,
  5.407053797230822e-01, -5.462924060268835e-03,  2.749749722651837e-05,  6.584145644391876e-09, -1.293132768661033e-09,  8.476041364738133e-12,  1.913555929724886e-14,
 -7.055144756524689e-16,  3.968107114535037e-18,  2.149924755883288e-20, -4.707456438939459e-22,  2.031877691686575e-24,  7.026914400641625e-01, -6.412042132259824e-03,
  2.213017247831113e-05,  1.170773005748401e-07, -1.603535303585099e-09,  1.019181251658057e-12,  9.965937312861750e-14, -6.001078985988588e-16, -4.218539983226766e-18,
  7.041508365000886e-20, -5.411521595606732e-23, -5.575536694722325e-24,  8.766921865847539e-01, -7.047511326889495e-03,  1.180813721599677e-05,  2.146631770096467e-07,
 -1.125926825707188e-09, -1.015380907581770e-11,  1.059710436513187e-13,  4.468361988575245e-16, -9.712533001996406e-18, -7.065423673819024e-21,  8.523694087368198e-22,
 -2.085413196657955e-24,  1.057793003800066e+00, -7.264190176672463e-03, -1.906169258316849e-06,  2.566553298356024e-07,  7.086746586761420e-11, -1.635843290701122e-11,
 -1.139926769202993e-15,  1.267950642062943e-15, -2.957358701476445e-19, -1.088691443993654e-19,  6.315504765635985e-23,  9.948025726080847e-24,  1.240295068344825e+00,
 -6.998018635250819e-03, -1.619571910336007e-05,  2.156102125509012e-07,  1.389208449039120e-09, -1.067939445097780e-11, -1.288986277080295e-13,  5.202250649855038e-16,
  1.222376291751777e-17, -1.383263624972933e-20, -1.154616149922089e-21, -1.794171241624947e-24,  1.417784248729032e+00, -6.245874736436885e-03, -2.755792998139574e-05,
  9.874761889752683e-08,  1.992029217832869e-09,  3.792531274350848e-12, -1.276958475342734e-13, -1.004712199649786e-15,  5.283591743668961e-18,  1.195832603165471e-19,
  1.980600173068711e-22, -1.023211845912946e-23,  1.583300860059296e+00, -5.081302177735215e-03, -3.285557211539740e-05, -4.634230715525726e-08,  1.429361732010869e-09,
  1.424182484914786e-11,  1.026430847320201e-14, -1.051599759597988e-15, -9.818288914387824e-18,  8.132272143377482e-21,  9.715584741919025e-22,  7.848061855029365e-24,
  1.729639909735617e+00, -3.659353486831726e-03, -3.061234561039490e-05, -1.510146144618358e-07,  1.285951476702625e-10,  1.091321771981954e-11,  1.069564810665788e-13,
  3.254106177620217e-16, -5.138650912785072e-18, -8.634370651418964e-20, -5.389149749186293e-22,  1.607721282251155e-24,  1.849795040065858e+00, -2.203328633151535e-03,
 -2.200572906078851e-05, -1.667453560741907e-07, -8.572970728830820e-10, -5.269607516548959e-13,  5.093235538027596e-14,  7.034817631264905e-16,  5.458028499295914e-18,
  1.736005967792635e-20, -2.170378061514087e-22, -4.518241910059738e-24,  1.937526174378528e+00, -9.693417280745852e-04, -1.086544054110312e-05, -1.026059194749586e-07,
 -8.402899814982856e-10, -5.838475272258397e-12, -3.095141647681428e-14, -6.280643797654256e-17,  1.230547905053684e-18,  2.304102791546936e-20,  2.578768467447234e-22,
  2.183511162191523e-24,  1.987995405959740e+00, -1.922048266205837e-04, -2.292358397235760e-06, -2.408047155967330e-08, -2.343881579019730e-10, -2.158450791803193e-12,
 -1.897880727584327e-14, -1.598301457416403e-16, -1.287556242813619e-18, -9.864660985396058e-21, -7.098455292560510e-23, -4.673753021080444e-25,  3.243604440961191e-03,
 -4.153408801316843e-05,  3.982946400291332e-07, -3.389103552208746e-09,  2.696964859467650e-11, -2.054633560234389e-13,  1.516481908647737e-15, -1.092244269341473e-17,
  7.707440300321859e-20, -5.344576242422618e-22,  3.646138513274266e-24, -2.450743152494623e-26,  2.912388947914301e-02, -3.691969331242465e-04,  3.465848139572629e-06,
 -2.842134828277912e-08,  2.134552123815065e-10, -1.492760016867416e-12,  9.739857171888729e-15, -5.877422690754549e-17,  3.194383058989245e-19, -1.460684355477726e-21,
  4.293152780357511e-24,  1.142911930927308e-26,  8.051498545450572e-02, -9.999983684568241e-04,  8.981540538997024e-06, -6.798019453847060e-08,  4.454742061928281e-10,
 -2.462480858427419e-12,  1.013898258630016e-14, -1.135385771112600e-17, -3.364461846835575e-19,  4.694938251300479e-21, -4.171195357015000e-23,  2.837722693430737e-25,
  1.566593014764489e-01, -1.885227093020009e-03,  1.577584004375668e-05, -1.038339358777539e-07,  5.094007274698116e-10, -1.162723197502824e-12, -1.049150579510534e-14,
  1.764541674196365e-16, -1.500173628530229e-18,  8.094273096420438e-21, -1.244844461920734e-23, -3.183543657365793e-25,  2.563736279719847e-01, -2.952852293793501e-03,
  2.227228880320423e-05, -1.152954788582891e-07,  2.347078625098447e-10,  2.892644040465294e-12, -4.131642937098816e-14,  2.759559613373436e-16, -5.837215195508930e-19,
 -1.021683641509932e-20,  1.494820093226708e-22, -1.024710382446323e-24,  3.779926073957261e-01, -4.109326303722013e-03,  2.671134482143235e-05, -8.627319408382050e-08,
 -3.843949681894015e-10,  7.554426439940862e-12, -4.695124425768085e-14, -1.273701171733731e-17,  3.070427279993823e-18, -2.890539211252983e-20,  7.536192598018458e-23,
  1.268661597261982e-24,  5.192936644205414e-01, -5.242966762148449e-03,  2.745802353143964e-05, -1.273130969574600e-08, -1.120542781594358e-09,  8.713180450552169e-12,
  1.250401652766683e-15, -5.695950442841080e-16,  4.427014123046281e-18,  4.701601800185648e-21, -3.644974659074149e-22,  2.672076916233715e-24,  6.774056394822792e-01,
 -6.229814839513189e-03,  2.338223811121728e-05,  9.170780283177205e-08, -1.560663461208203e-09,  3.196431783003151e-12,  8.134193542164260e-14, -6.954068246572800e-16,
 -1.776639702662274e-18,  6.390428481983379e-20, -2.568198557609242e-22, -3.580362004941599e-24,  8.487069343235859e-01, -6.943063166215270e-03,  1.426976257259931e-05,
  1.951655458668731e-07, -1.302738197960072e-09, -7.495492836060474e-12,  1.141386029325979e-13,  1.383105048537425e-16, -9.383676985609417e-18,  2.429147009636213e-20,
  6.954476891163162e-22, -4.827735415884871e-24,  1.028725244681742e+00, -7.267125613741579e-03,  1.169729430726840e-06,  2.551823791698555e-07, -2.537198258211445e-10,
 -1.596441216118554e-11,  3.364936605211010e-14,  1.197106972697296e-15, -4.066568795118157e-18, -9.789550101050702e-20,  4.739527502878611e-22,  8.367581440368065e-24,
  1.212060759387041e+00, -7.116874530098266e-03, -1.348260998256080e-05,  2.359664995440923e-07,  1.146090076961011e-09, -1.355474569710572e-11, -1.089949315871929e-13,
  8.944427395139308e-16,  1.088963491205349e-17, -6.002750704816723e-20, -1.115269705849143e-21,  3.653667087458186e-24,  1.392368098843271e+00, -6.461051821737864e-03,
 -2.617978526153488e-05,  1.310512061693260e-07,  2.035069897723008e-09,  4.133626134473185e-13, -1.528080632398139e-13, -7.661710170631813e-16,  9.613394219520033e-18,
  1.175072901751207e-19, -3.228612660831960e-22, -1.309143732155422e-23,  1.562447017640564e+00, -5.345960716754306e-03, -3.326504699286435e-05, -2.119108655079347e-08,
  1.714095327613611e-09,  1.409988270963620e-11, -2.347781231294404e-14, -1.352952936195261e-15, -8.747267909001855e-18,  5.336964499916267e-20,  1.272148847748205e-21,
  5.343851676250812e-24,  1.714501293556872e+00, -3.911448467212420e-03, -3.240451376521823e-05, -1.470687806116126e-07,  3.731583424426391e-10,  1.356791357453690e-11,
  1.132700209031747e-13,  1.072816239150380e-16, -8.608137598721841e-18, -1.053789518965709e-19, -3.824248666239534e-22,  5.783192289443649e-24,  1.840616631548946e+00,
 -2.387611762299477e-03, -2.408908733996427e-05, -1.804729482190831e-07, -8.539128271495113e-10,  9.520290938963508e-13,  7.315460395116810e-14,  8.860343749850735e-16,
  5.872789999592981e-18,  4.034025465234489e-21, -4.666774225707853e-22, -6.904552547285622e-24,  1.933466827662531e+00, -1.061428034722968e-03, -1.218136496359289e-05,
 -1.170255831797802e-07, -9.646037482100133e-10, -6.597120089961243e-12, -3.201867427829673e-14, -7.966924104112420e-18,  2.270622243190298e-18,  3.547292334291180e-20,
  3.686271369774104e-22,  2.855291587450340e-24,  1.987187984260300e+00, -2.117667595555761e-04, -2.605334431833133e-06, -2.820239232660041e-08, -2.825001112476676e-10,
 -2.672649667557555e-12, -2.408841538900249e-14, -2.073045287464734e-16, -1.699102948279270e-18, -1.315455025204123e-20, -9.452273713429931e-23, -6.063056677468814e-25,
  3.083593191453307e-03, -3.850337207232559e-05,  3.600850109505128e-07, -2.988585004947218e-09,  2.320093346071199e-11, -1.724758515612083e-13,  1.242479468988858e-15,
 -8.737740929856531e-18,  6.021876993385106e-20, -4.080703195880518e-22,  2.721279581210160e-24, -1.789725049186019e-26,  2.770047437037482e-02, -3.427785020822551e-04,
  3.144338099970654e-06, -2.523274507334184e-08,  1.858100456767958e-10, -1.277643879965973e-12,  8.229622630360391e-15, -4.935969340262375e-17,  2.700263496959047e-19,
 -1.283130099451988e-21,  4.494414968668934e-24, -1.009695112050610e-27,  7.665369636925187e-02, -9.312915821909629e-04,  8.206960974144642e-06, -6.123351102834950e-08,
  3.986265294640906e-10, -2.224031519369302e-12,  9.693595538778621e-15, -1.971461668114550e-17, -1.946294430362293e-19,  3.256802731775259e-21, -3.065833206455355e-23,
  2.201835906956942e-25,  1.493631083434699e-01, -1.763867692862099e-03,  1.457792793206433e-05, -9.588165521550825e-08,  4.840015929917381e-10, -1.360390162384443e-12,
 -6.179886508226903e-15,  1.329910480467803e-16, -1.220572588282816e-18,  7.374925171998017e-21, -2.221672975422370e-23, -1.391543858919426e-25,  2.449099084607207e-01,
 -2.780140266153692e-03,  2.091301671421227e-05, -1.111286214737850e-07,  2.832584609552558e-10,  1.991359456620091e-12, -3.389873751351239e-14,  2.524596530166214e-16,
 -8.544747685193883e-19, -5.105988008415670e-21,  1.070360818101227e-22, -8.919526951615126e-25,  3.619759939657518e-01, -3.899870128773515e-03,  2.564395229798934e-05,
 -9.127596336348611e-08, -2.445502419133266e-10,  6.433481328946650e-12, -4.608405718481525e-14,  6.954350299809647e-17,  2.095340696635341e-18, -2.501334619165967e-20,
  1.137664202350636e-22,  5.173586770891380e-25,  4.987597453236154e-01, -5.024205235518795e-03,  2.720341756831505e-05, -2.926938828567398e-08, -9.471878699078202e-10,
  8.567875784924910e-12, -1.270822631138926e-14, -4.278034133098355e-16,  4.362577888424652e-18, -7.489852758613634e-21, -2.451419255582649e-22,  2.667018210058790e-24,
  6.528668736654568e-01, -6.038773946088601e-03,  2.433534297697731e-05,  6.734797703887653e-08, -1.478814405824186e-09,  4.910605097592039e-12,  6.140472288196567e-14,
 -7.177039651504236e-16,  3.066966052786543e-19,  5.110050602158620e-20, -3.683038309407022e-22, -1.518897644533413e-24,  8.211773163920928e-01, -6.819901886290349e-03,
  1.648222350658403e-05,  1.732720109826322e-07, -1.425112370851431e-09, -4.742636314697148e-12,  1.139745896779852e-13, -1.430531678666078e-16, -8.064281470589401e-18,
  4.737470450336526e-20,  4.494543530815235e-22, -6.099780187054878e-24,  9.996947227640391e-01, -7.245611961352339e-03,  4.197196914506597e-06,  2.486235264039902e-07,
 -5.623064659708235e-10, -1.477241282209248e-11,  6.484673672332423e-14,  1.014916833401519e-15, -7.168747147211341e-18, -7.246446667709034e-20,  7.729951162935254e-22,
  5.006562133324131e-24,  1.183395884787432e+00, -7.213118763043929e-03, -1.055036895751480e-05,  2.520022470837413e-07,  8.510589170138621e-10, -1.583300939379891e-11,
 -7.945593939765195e-14,  1.200135329309313e-15,  7.978857647130400e-18, -9.984778829303741e-20, -8.386270015173919e-22,  8.724421249003956e-24,  1.366115755507324e+00,
 -6.663646806702114e-03, -2.441219503630464e-05,  1.634725812568096e-07,  2.005121365292526e-09, -3.472910983554551e-12, -1.693425009203494e-13, -3.944971936010187e-16,
  1.346963257254325e-17,  9.281759565959288e-20, -9.119182397792578e-22, -1.311712442959419e-23,  1.540530009636685e+00, -5.612610864172235e-03, -3.334561663388883e-05,
  8.446381946660455e-09,  1.987235185394280e-09,  1.305232926916223e-11, -6.491813768695813e-14, -1.591923515335889e-15, -5.865752493619889e-18,  1.075514439943297e-19,
  1.396521438508341e-21, -2.011498177146314e-25,  1.698326021935463e+00, -4.177620794244953e-03, -3.412408131350645e-05, -1.387792613621548e-07,  6.717686501392297e-10,
  1.628771681731440e-11,  1.118294369547576e-13, -2.312389540121856e-16, -1.260158472266702e-17, -1.140065490420045e-19, -7.554857092446486e-24,  1.145198527592541e-23,
  1.830666717997199e+00, -2.589217316541650e-03, -2.633577703753111e-05, -1.938790177557744e-07, -8.151958132183788e-10,  3.026672963987689e-12,  1.005870541794892e-13,
  1.072044110954489e-15,  5.601762017065096e-18, -2.148183291145319e-20, -8.282445625293687e-22, -9.517832780076305e-24,  1.929016935770048e+00, -1.164768853249470e-03,
 -1.368276308426697e-05, -1.335564466842892e-07, -1.104200869441403e-09, -7.358746574184161e-12, -3.101076034227525e-14,  8.822849143401515e-17,  3.845083707123239e-18,
  5.292040285672084e-20,  5.081312400541949e-22,  3.451712874716569e-24,  1.986296974383743e+00, -2.340442666440043e-04, -2.972754519944504e-06, -3.318351929353647e-08,
 -3.422381999632763e-10, -3.327034918152418e-12, -3.073085064224332e-14, -2.700374189433687e-16, -2.247560742036738e-18, -1.751399433549529e-20, -1.245770433798630e-22,
 -7.606460023180007e-25,  2.935122507170132e-03, -3.576008544571766e-05,  3.263404764541930e-07, -2.643425445053924e-09,  2.003086469002938e-11, -1.453873335509822e-13,
  1.022733571561080e-15, -7.026228195123912e-18,  4.731172964785132e-20, -3.134596587581907e-22,  2.043701964601900e-24, -1.315885064091170e-26,  2.637782095874371e-02,
 -3.187863032743724e-04,  2.858573197616269e-06, -2.245392880731392e-08,  1.621251993581402e-10, -1.095782824879269e-12,  6.961824892362451e-15, -4.142346295583944e-17,
  2.270380970626177e-19, -1.106460456718354e-21,  4.292836409847401e-24, -7.395994965573138e-27,  7.305533638712243e-02, -8.684699758935606e-04,  7.508999533147637e-06,
 -5.519889018849028e-08,  3.564244423771111e-10, -1.998612794789864e-12,  9.070435472562769e-15, -2.428557543731002e-17, -9.727533399453864e-20,  2.207730867317567e-21,
 -2.218429529504546e-23,  1.667723503855080e-25,  1.425337804848691e-01, -1.651717054597767e-03,  1.347289153600040e-05, -8.836216097697040e-08,  4.555904484707784e-10,
 -1.468197103270661e-12, -2.964321485460401e-15,  9.799946338631337e-17, -9.722067161430432e-19,  6.400292992720898e-21, -2.571993732345479e-23, -2.966531156738889e-26,
  2.341156223027396e-01, -2.618090508593316e-03,  1.960784360672604e-05, -1.063197266117738e-07,  3.155059440421079e-10,  1.259384270782453e-12, -2.723484410673169e-14,
  2.229279822259569e-16, -9.702213566287523e-19, -1.558452017788642e-21,  7.164244561250896e-23, -7.139305845798786e-25,  3.467797982124288e-01, -3.699156882024885e-03,
  2.452921746751757e-05, -9.421871580336177e-08, -1.267473201065558e-10,  5.357607591147021e-12, -4.332703025212732e-14,  1.230992036050997e-16,  1.280708623608352e-18,
 -2.017421972803646e-20,  1.244867011838282e-22,  8.360451435269736e-27,  4.790956078800852e-01, -4.808227564283510e-03,  2.676684553881834e-05, -4.307389829289734e-08,
 -7.797703444301026e-10,  8.134600272062690e-12, -2.278501123249269e-14, -2.941834497955359e-16,  3.943871871315532e-18, -1.504633312916908e-20, -1.356349535706555e-22,
  2.265226760253559e-24,  6.291057044052423e-01, -5.841252786320728e-03,  2.500503431596687e-05,  4.454592327984532e-08, -1.367480357153343e-09,  6.145874453885158e-12,
  4.170210078206739e-14, -6.813971259965738e-16,  1.869962731837947e-18,  3.556673289994356e-20, -3.960302513404509e-22,  1.742193029135697e-25,  7.941740375541214e-01,
 -6.680120924308305e-03,  1.842202320174887e-05,  1.498581489033649e-07, -1.493079248670749e-09, -2.082785643274224e-12,  1.066343670480994e-13, -3.708821163830752e-16,
 -6.100450176730353e-18,  5.994024853390247e-20,  1.801099741673050e-22, -5.929693518768142e-24,  9.707980806758311e-01, -7.200275262839351e-03,  7.117247145109812e-06,
  2.373567639805376e-07, -8.400330649759455e-10, -1.290318901722090e-11,  8.970532449152035e-14,  7.501047312149958e-16, -9.178667115135591e-18, -3.833500126504878e-20,
  9.033767524119297e-22,  8.923301350672071e-25,  1.154394050303523e+00, -7.285218799466574e-03, -7.455393374211303e-06,  2.629941974173809e-07,  5.181854461576261e-10,
 -1.731138781424707e-11, -4.285945939539884e-14,  1.392293034447368e-15,  3.883483428721992e-18, -1.246019887623449e-19, -3.759259118728319e-22,  1.188769553665380e-23,
  1.339083758257429e+00, -6.850559018532502e-03, -2.226104790544208e-05,  1.947751922425177e-07,  1.894390043434648e-09, -7.618167291527086e-12, -1.739082254401346e-13,
  8.186785317252568e-17,  1.602221972800649e-17,  4.560185133359368e-20, -1.422127184142285e-21, -9.450487074996297e-24,  1.517547466707870e+00, -5.878410630005193e-03,
 -3.304518736977237e-05,  4.223037721209939e-08,  2.228997892939825e-09,  1.094215730021957e-11, -1.114616669612324e-13, -1.707046590073498e-15, -1.010892070470785e-18,
  1.609663827062767e-19,  1.214012537162390e-21, -8.440380607224424e-24,  1.681059298009310e+00, -4.457066437904209e-03, -3.571372849293743e-05, -1.252821722673401e-07,
  1.023586087206917e-09,  1.884459171495119e-11,  9.909806467086666e-14, -6.991204219468945e-16, -1.657312556177977e-17, -1.023977865386066e-19,  6.330327194227856e-22,
  1.760042570816881e-23,  1.819873435660303e+00, -2.809425954128883e-03, -2.873813282631897e-05, -2.062961588478024e-07, -7.279893116325051e-10,  5.820260819539490e-12,
  1.329470812203914e-13,  1.231672040723910e-15,  4.124885632462693e-18, -6.366094721773628e-20, -1.295333973180194e-21, -1.149902845248572e-23,  1.924128346773135e+00,
 -1.280953452750156e-03, -1.539642854087417e-05, -1.524403840175126e-07, -1.258538419380696e-09, -8.057548149754574e-12, -2.650163819180492e-14,  2.459797741004139e-16,
  6.153631523259441e-18,  7.637955189422947e-20,  6.660268532637748e-22,  3.604957221409216e-24,  1.985310572866275e+00, -2.595175313487942e-04, -3.406144662010800e-06,
 -3.923445389434438e-08, -4.168113525578706e-10, -4.164053725925108e-12, -3.940084027917490e-14, -3.530772715808778e-16, -2.976226335343553e-18, -2.320994327311044e-20,
 -1.612274103292048e-22, -8.976595981888177e-25,  2.797110123696584e-03, -3.327101030443366e-05,  2.964505228727462e-07, -2.344923878794518e-09,  1.735348047315763e-11,
 -1.230413509328679e-13,  8.456046492572672e-16, -5.678094043581141e-18,  3.736915766199859e-20, -2.422044490899908e-22,  1.543905135279122e-24, -9.741454679714051e-27,
  2.514676655032544e-02, -2.969530167307338e-04,  2.603995218194221e-06, -2.002655269093434e-08,  1.417905233858812e-10, -9.418319787085707e-13,  5.897925095971559e-15,
 -3.476312653700402e-17,  1.902081978310832e-19, -9.422841376281326e-22,  3.895530634303019e-24, -1.022784734249530e-26,  6.969753831756324e-02, -8.109535411262633e-04,
  6.879548181414704e-06, -4.980428595369531e-08,  3.185724838637324e-10, -1.789366389243223e-12,  8.357666339164651e-15, -2.628445673110951e-17, -3.212421410106843e-20,
  1.453761497399725e-21, -1.582625990097782e-23,  1.239038084696724e-25,  1.361359349850025e-01, -1.548053637823775e-03,  1.245530315866357e-05, -8.131061844967335e-08,
  4.257200408874665e-10, -1.509722736801631e-12, -6.226706312385778e-16,  7.037561577269866e-17, -7.604334108831172e-19,  5.366291978244219e-21, -2.553581760128897e-23,
  3.159921583861239e-26,  2.239490288668297e-01, -2.466243595191233e-03,  1.836301725742905e-05, -1.011035855862452e-07,  3.346445833409194e-10,  6.771099653783981e-13,
 -2.143235098870737e-14,  1.914780783472638e-16, -9.818258121637543e-19,  7.323994392417193e-22,  4.419911871086552e-23, -5.359290703132187e-25,  3.323684391521600e-01,
 -3.507472333289718e-03,  2.338978152733072e-05, -9.544470719327647e-08, -2.969325553811253e-11,  4.363114422400703e-12, -3.940885356940827e-14,  1.534169472132434e-16,
  6.432079935034817e-19, -1.528872624507126e-20,  1.176251757133994e-22, -2.894536586102221e-25,  4.602874101463265e-01, -4.596360285952433e-03,  2.618036634921239e-05,
 -5.428095020900049e-08, -6.231424918507497e-10,  7.502642117884372e-12, -2.934310712987489e-14, -1.775079842519767e-16,  3.327097572643593e-18, -1.864120935195424e-20,
 -4.830788480773814e-23,  1.691278732129196e-24,  6.061436469094821e-01, -5.639436598765420e-03,  2.541252230711204e-05,  2.369760585321523e-08, -1.236060201866103e-09,
  6.925611815019798e-12,  2.363161631314832e-14, -6.040910144659522e-16,  2.870553636237816e-18,  2.025280004154993e-20, -3.614994953015990e-22,  1.295554467887545e-24,
  7.677591190459150e-01, -6.525959946581695e-03,  2.007605061951912e-05,  1.257707846921230e-07, -1.510089277175040e-09,  3.317947735416238e-13,  9.384810087941138e-14,
 -5.306740583553928e-16, -3.873175166866525e-18,  6.222722245769766e-20, -5.681259674265341e-23, -4.710051266379332e-24,  9.421285472597895e-01, -7.132191469886378e-03,
  9.876765992762617e-06,  2.219752304345803e-07, -1.075042361680884e-09, -1.053244134500185e-11,  1.064385637767027e-13,  4.412867401713828e-16, -9.909507747440325e-18,
 -2.576536920271533e-21,  8.572249760677520e-22, -2.845114636214308e-24,  1.125154040285705e+00, -7.332123888313293e-03, -4.261287049687080e-06,  2.684729071489132e-07,
  1.648838315278563e-10, -1.786238443609886e-11, -2.824448081290381e-15,  1.442937365100578e-15, -7.436072795191541e-19, -1.288708941318175e-19,  1.645476695499805e-22,
  1.217117501400409e-23,  1.311340858664262e+00, -7.018795963263214e-03, -1.974764206002496e-05,  2.236415869942470e-07,  1.700778771234558e-09, -1.170541456983423e-11,
 -1.642736368380166e-13,  6.091607228381343e-16,  1.655632775106005e-17, -1.773557501143358e-20, -1.693405577482584e-21, -2.429827823569955e-24,  1.493509187273955e+00,
 -6.140123176355431e-03, -3.231773244179369e-05,  7.948349750428288e-08,  2.417223640666641e-09,  7.695522727959342e-12, -1.587788886874488e-13, -1.638195540924476e-15,
  5.543699335350429e-18,  1.993759768484935e-19,  6.392727113157532e-22, -1.761525891194368e-23,  1.662650522990238e+00, -4.748481948930347e-03, -3.710601514717421e-05,
 -1.057682117259045e-07,  1.422352441648345e-09,  2.092492023304347e-11,  7.158784229814243e-14, -1.281944878578235e-15, -1.960280333485017e-17, -6.006436859666092e-20,
  1.516071846200473e-21,  2.199867106112725e-23,  1.808159976817365e+00, -3.049421213134707e-03, -3.127913814819478e-05, -2.168274200682601e-07, -5.768166456596306e-10,
  9.437248243703882e-12,  1.688602180155911e-13,  1.315997097481093e-15,  7.767901955066285e-19, -1.257398604404522e-19, -1.806464890671486e-21, -1.116175713830561e-23,
  1.918746104943639e+00, -1.411796800584409e-03, -1.735195532514356e-05, -1.738979881072225e-07, -1.425365419091447e-09, -8.585954677668712e-12, -1.640559741897656e-14,
  4.923336932588517e-16,  9.419584952105979e-18,  1.060090716550722e-19,  8.079875009605754e-22,  2.558920771004030e-24,  1.984214853765659e+00, -2.887699957952699e-04,
 -3.919896376032851e-06, -4.662462808384007e-08, -5.104084722526135e-10, -5.239888388667777e-12, -5.075529469117361e-14, -4.630089073773239e-16, -3.937608928703655e-18,
 -3.047136505577031e-20, -2.021225513505341e-22, -9.330509166025256e-25,  2.668597502500079e-03, -3.100742243867778e-05,  2.698995929317500e-07, -2.085903862431904e-09,
  1.508338630692655e-11, -1.045272024916180e-13,  7.021289476724247e-16, -4.610661928303134e-18,  2.966538403630565e-20, -1.882337159490924e-22,  1.172639543833330e-24,
 -7.264856903882811e-27,  2.399914901001633e-02, -2.770451457035202e-04,  2.376690904552319e-06, -1.790122550084129e-08,  1.242939685097398e-10, -8.113046852656064e-13,
  5.004880377946396e-15, -2.919004991756377e-17,  1.589788861104373e-19, -7.958155120899674e-22,  3.421904447723621e-24, -1.106646649035124e-26,  6.656013063184248e-02,
 -7.582237599646446e-04,  6.311333341913627e-06, -4.498277817671985e-08,  2.847309726295624e-10, -1.597685893844609e-12,  7.614365187178488e-15, -2.658721931382357e-17,
  1.003366596968885e-20,  9.192739467542399e-22, -1.114145212341963e-23,  9.046618053534540e-26,  1.301369861254356e-01, -1.452200623309712e-03,  1.151944753039677e-05,
 -7.474084267329671e-08,  3.955222781868058e-10, -1.503598815997921e-12,  1.034828414273695e-15,  4.893898296464886e-17, -5.851981028297401e-19,  4.383215476660302e-21,
 -2.340383683914168e-23,  6.119014560432928e-26,  2.143703085321289e-01, -2.324100549488976e-03,  1.718226130059354e-05, -9.566712302329247e-08,  3.434590866212154e-10,
  2.235553674097642e-13, -1.650467915567983e-14,  1.607795039812297e-16, -9.288807069567323e-19,  2.076495097077777e-21,  2.413616851879536e-23, -3.808387547324122e-25,
  3.187055294556096e-01, -3.324937198120365e-03,  2.224431175883354e-05, -9.527159394503654e-08,  4.846883593506779e-11,  3.470699094428137e-12, -3.490145073689654e-14,
  1.660732321244093e-16,  1.739567295585230e-19, -1.088894258473256e-20,  1.013594783176687e-22, -4.282433932063081e-25,  4.423165049381005e-01, -4.389681187643897e-03,
  2.547399695216924e-05, -6.309055222459199e-08, -4.804750753469005e-10,  6.750165643676285e-12, -3.292554482738785e-14, -8.201611196621852e-17,  2.637566442567601e-18,
 -1.926048181527200e-20,  1.307686258467130e-23,  1.106814786070231e-24,  5.839938413395057e-01, -5.435324444231709e-03,  2.558288727454930e-05,  5.053999613313773e-09,
 -1.093190306138411e-09,  7.300752861616878e-12,  8.093496317100872e-15, -5.032342814657569e-16,  3.354994953745446e-18,  7.131749431740485e-21, -2.906181559926750e-22,
  1.837750933476571e-24,  7.419854764096258e-01, -6.359724014848260e-03,  2.144093251107826e-05,  1.017795436331173e-07, -1.482197092318476e-09,  2.393882046499030e-12,
  7.758548483137048e-14, -6.195878902690397e-16, -1.719428224015876e-18,  5.629946989807457e-20, -2.269538467393904e-22, -2.985341295851108e-24,  9.137742469885930e-01,
 -7.042830031727316e-03,  1.243077280549409e-05,  2.032317154671058e-07, -1.259329808272228e-09, -7.865332408244003e-12,  1.143866903554165e-13,  1.290185584056330e-16,
 -9.423139478154863e-18,  2.836042027612892e-20,  6.712461068174424e-22, -5.362874811228322e-24,  1.095777795652330e+00, -7.353309743704899e-03, -1.035547121566486e-06,
  2.682630179998572e-07, -1.898009827944651e-10, -1.745224906458876e-11,  3.656218986175123e-14,  1.347199206912224e-15, -5.140354101333336e-18, -1.121587850387331e-19,
  6.518735784380631e-22,  9.552431828948604e-24,  1.282967337227392e+00, -7.165598842572769e-03, -1.690906930696626e-05,  2.487738323119025e-07,  1.428931573763367e-09,
 -1.538449595727910e-11, -1.399895720306200e-13,  1.115614425512409e-15,  1.469559468172905e-17, -8.509774525408096e-20, -1.611312760552134e-21,  6.230140327320969e-24,
  1.468438593444178e+00, -6.394182066822764e-03, -3.112751019555828e-05,  1.191681631008024e-07,  2.529443991955065e-09,  3.361209951710184e-12, -2.010600768233168e-13,
 -1.342682356328727e-15,  1.297294350379769e-17,  2.071018177095015e-19, -3.044704540396063e-22, -2.462581111006987e-23,  1.643055449368808e+00, -5.049987717880159e-03,
 -3.822461148183344e-05, -7.958273537486311e-08,  1.854751338503398e-09,  2.213987913296902e-11,  2.668081170941699e-14, -1.930208115551028e-15, -2.043680940921522e-17,
  2.022793373887300e-20,  2.493868931600001e-21,  2.129792684447558e-23,  1.795445146163107e+00, -3.310203091207231e-03, -3.392946551135256e-05, -2.243138127707988e-07,
 -3.445656689985414e-10,  1.393017336509916e-11,  2.052709128304088e-13,  1.253578760423954e-15, -5.159689577823725e-18, -2.067290833535928e-19, -2.204842109865700e-21,
 -5.870662284546347e-24,  1.912807505518872e+00, -1.559360409725704e-03, -1.958128790517933e-05, -1.980936332554157e-07, -1.599713418693462e-09, -8.776449712409936e-12,
  2.218975066273561e-15,  8.612350048072799e-16,  1.383776671469218e-17,  1.397633634889336e-19,  8.535529991060895e-22, -1.070414080098974e-24,  1.982993304901502e+00,
 -3.225143976561211e-04, -4.532076532989269e-06, -5.570040824027718e-08, -6.285157116844655e-10, -6.628896187623717e-12, -6.566008390362512e-14, -6.082024282303948e-16,
 -5.189641037639526e-18, -3.933242728177280e-20, -2.390820993097618e-22, -6.729525718286111e-25,  2.548733267322987e-03, -2.894439954280567e-05,  2.462506140515485e-07,
 -1.860420498490565e-09,  1.315142517043371e-11, -8.912397270227916e-14,  5.853628789541604e-16, -3.761329681058257e-18,  2.366151404622473e-20, -1.471499187977722e-22,
  8.946175948485318e-25, -5.467998124723111e-27,  2.292768114334489e-02, -2.588582614522653e-04,  2.173293363925876e-06, -1.603607226699174e-08,  1.092057050888457e-10,
 -7.004460964590994e-13,  4.254657386740160e-15, -2.453565158638460e-17,  1.326758661167206e-19, -6.686767545857661e-22,  2.936289177886596e-24, -1.090473686546627e-26,
  6.362490444897702e-02, -7.098171849836144e-04,  5.797851178335145e-06, -4.067303532014955e-08,  2.545447092492548e-10, -1.423810466105331e-12,  6.878822674092137e-15,
 -2.581535907243169e-17,  3.599062523145483e-20,  5.451593991994626e-22, -7.751403382388074e-24,  6.474203675277844e-26,  1.245069633696700e-01, -1.363527295993596e-03,
  1.065954073822303e-05, -6.865128298324769e-08,  3.657993137440599e-10, -1.464296033054274e-12,  2.165416821521923e-15,  3.256222602722297e-17, -4.435658730062309e-19,
  3.504887966854697e-21, -2.044318490115771e-23,  7.083023435498677e-26,  2.053416839827661e-01, -2.191140852784360e-03,  1.606730976618458e-05, -9.015605974471828e-08,
  3.443166748498266e-10, -1.218188848472139e-13, -1.240660331293708e-14,  1.324073016209125e-16, -8.404303196873982e-19,  2.745538117259527e-21,  1.021508036746259e-23,
 -2.574048481441881e-25,  3.057544742145826e-01, -3.151537569378202e-03,  2.110785321497413e-05, -9.398470424402846e-08,  1.098849364858824e-10,  2.689158743099673e-12,
 -3.022703864533896e-14,  1.661123864781401e-16, -1.497625717514570e-19, -7.227207733278780e-21,  8.148922151127707e-23, -4.616610039768478e-25,  4.251603979263818e-01,
 -4.189038269655117e-03,  2.467509901192354e-05, -6.974167919348274e-08, -3.535133134343438e-10,  5.941297705889203e-12, -3.414337913495295e-14, -8.521274056672627e-18,
  1.963910283293532e-18, -1.791909443658812e-20,  5.032933923603992e-23,  6.043907955144163e-25,  5.626618487670112e-01, -5.230704958994859e-03,  2.554342912472652e-05,
 -1.126294115351274e-08, -9.463107196028686e-10,  7.338202722523432e-12, -4.470489665960380e-15, -3.938483228513038e-16,  3.422498972919232e-18, -2.824669249453145e-21,
 -2.066657378169396e-22,  1.914081763400829e-24,  7.168968069412234e-01, -6.183710027926593e-03,  2.252188746206725e-05,  7.854259574187603e-08, -1.417128592962942e-09,
  4.043339023996742e-12,  5.975758803168462e-14, -6.441586390899670e-16,  1.170664900272838e-19,  4.511679774012777e-20, -3.195523995384227e-22, -1.257107963902569e-24,
  8.858167667174373e-01, -6.933982247214586e-03,  1.474395168964763e-05,  1.819737746251225e-07, -1.389062496594603e-09, -5.109658951570926e-12,  1.139652719652199e-13,
 -1.514917383036010e-16, -7.979543247290324e-18,  5.009511985463399e-20,  4.085260811569677e-22, -6.321698187869920e-24,  1.066368268521073e+00, -7.348795277188862e-03,
  2.154058292296731e-06,  2.624939645853231e-07, -5.271267685507185e-10, -1.614421699538974e-11,  7.141417035462797e-14,  1.123885918196641e-15, -8.618680204360142e-18,
 -7.893556129700972e-20,  9.755351856663451e-22,  4.942141163417581e-24,  1.254053820013419e+00, -7.288566097642703e-03, -1.379731973831129e-05,  2.690042079285204e-07,
  1.090435421170580e-09, -1.831951936907215e-11, -1.027141419552522e-13,  1.525101859821000e-15,  1.056033549831631e-17, -1.416415341751398e-19, -1.159623307618889e-21,
  1.391173881638230e-23,  1.442373857617854e+00, -6.636790721864271e-03, -2.945332919842947e-05,  1.599030268318207e-07,  2.545639762153144e-09, -1.861711735802024e-12,
 -2.317518284881328e-13, -8.127912769609148e-16,  1.993910227686768e-17,  1.723430393831638e-19, -1.443432479218119e-21, -2.595453802518320e-23,  1.622238613185660e+00,
 -5.359066306590224e-03, -3.898687653389650e-05, -4.634923091477847e-08,  2.299198183881477e-09,  2.205917389351470e-11, -3.626386264567493e-14, -2.551556214830416e-15,
 -1.770426799032171e-17,  1.367115261991083e-19,  3.262965388394350e-21,  1.202222099960367e-23,  1.781644312364068e+00, -3.592476629693138e-03, -3.664421699443076e-05,
 -2.273188581841397e-07, -1.398191854028013e-11,  1.925172585261197e-11,  2.368173563619297e-13,  9.520480858153226e-16, -1.422323881321063e-17, -2.968364820041989e-19,
 -2.203312999264440e-21,  7.515075719143791e-24,  1.906241076357313e+00, -1.725967606242059e-03, -2.211774237220072e-05, -2.250812253573213e-07, -1.772477404578532e-09,
 -8.378901636866823e-12,  3.333516799061103e-14,  1.390930156652755e-15,  1.945458669308018e-17,  1.709198430404514e-19,  6.430207299884113e-22, -9.530433771943672e-24,
  1.981626245483506e+00, -3.616262481611423e-04, -5.265488031067430e-06, -6.690904888459003e-08, -7.783342390633914e-10, -8.429235532711819e-12, -8.524101758726646e-14,
 -7.988185163872541e-16, -6.783056058895272e-18, -4.927437626138051e-20, -2.510111068726198e-22,  3.018693774625784e-25,  2.436759164598955e-03, -2.706024830765289e-05,
  2.251316613706334e-07, -1.663528547087751e-09,  1.150132439001258e-11, -7.625816939817778e-14,  4.898962701718369e-16, -3.082458421930424e-18,  1.895407095302735e-20,
 -1.157649098422931e-22,  6.840162633130583e-25, -4.178076630744298e-27,  2.192584262519548e-02, -2.422129718160620e-04,  1.990899303610418e-06, -1.439552951289604e-08,
  9.616464201064842e-11, -6.061199976950278e-13,  3.623635268364270e-15, -2.065344404388149e-17,  1.106032229172127e-19, -5.606854218533151e-22,  2.466741682897735e-24,
 -1.043870162099359e-26,  6.087540514099906e-02, -6.653195522157893e-04,  5.333299722414353e-06, -3.681940287050429e-08,  2.276616103119907e-10, -1.267246414850528e-12,
  6.174670581475309e-15, -2.440429599131600e-17,  5.066451664364604e-20,  2.858474331993109e-22, -5.359573524675184e-24,  4.474581581311277e-26,  1.192183268973400e-01,
 -1.281448940215386e-03,  9.869885568573945e-06, -6.302967505044202e-08,  3.370991295634401e-10, -1.402877960252083e-12,  2.896320269158186e-15,  2.023521663897419e-17,
 -3.313575146095303e-19,  2.749385552495211e-21, -1.735312001737681e-23,  6.797972129265655e-26,  1.968274775157929e-01, -2.066836495620344e-03,  1.501836195923833e-05,
 -8.468145514378471e-08,  3.391877023034438e-10, -3.780338752920130e-13, -9.060410058083253e-15,  1.071534492724525e-16, -7.366974351106232e-19,  2.956615571758263e-21,
  9.976222645482791e-25, -1.669239357862176e-25,  2.934789540228075e-01, -2.987152281520060e-03,  1.999223717488081e-05, -9.183412713853290e-08,  1.567866247917749e-10,
  2.018763141468121e-12, -2.567784308942301e-14,  1.577466933727579e-16, -3.561284278820342e-19, -4.369215286003818e-21,  6.160339623199122e-23, -4.357406120166927e-25,
  4.087936218572993e-01, -3.995072492182388e-03,  2.380803868790666e-05, -7.449176838814030e-08, -2.428668700580354e-10,  5.125513937120536e-12, -3.359608672614867e-14,
  4.443553526445523e-17,  1.360341169776563e-18, -1.549620319229395e-20,  6.801005471278718e-23,  2.191300610358977e-25,  5.421465190666050e-01, -5.027144445210351e-03,
  2.532224261976350e-05, -2.523915826332941e-08, -8.014494644601338e-10,  7.110806721090658e-12, -1.399068389269254e-14, -2.873888072220101e-16,  3.191873533808146e-18,
 -9.458270412638885e-21, -1.267251560384553e-22,  1.681523257507256e-24,  6.925277507923813e-01, -6.000143720820618e-03,  2.333125858849539e-05,  5.658728995469572e-08,
 -1.323372715278754e-09,  5.262917536778080e-12,  4.199968262504995e-14, -6.169733852466536e-16,  1.501933629505561e-18,  3.166946747349851e-20, -3.426860514588943e-22,
  1.309880104338364e-25,  8.583300285278184e-01, -6.807680527873514e-03,  1.679139085821867e-05,  1.590779009842078e-07, -1.464389276865261e-09, -2.452482030160237e-12,
  1.064391178937262e-13, -3.753718601189591e-16, -5.948797246474206e-18,  6.091510068988343e-20,  1.357518993181987e-22, -5.879639455140914e-24,  1.037027267940676e+00,
 -7.319130362486896e-03,  5.243055984631103e-06,  2.515800934336812e-07, -8.304939328140839e-10, -1.408616400014920e-11,  9.865031524231867e-14,  8.104861581972718e-16,
 -1.071950889922550e-17, -3.709655630245055e-20,  1.078623648288928e-21, -2.237916878477420e-25,  1.224699623836511e+00, -7.385764496343684e-03, -1.047707100283170e-05,
  2.834012550758638e-07,  7.030288640879617e-10, -2.023903848855135e-11, -5.610322133853166e-14,  1.773790897297580e-15,  4.788517822061712e-18, -1.742309665491280e-19,
 -4.391827651154602e-22,  1.809953214429951e-23,  1.415368565374516e+00, -6.864054422257208e-03, -2.729233697693691e-05,  2.000268132253760e-07,  2.451337001392989e-09,
 -7.619473408474898e-12, -2.447366062905046e-13, -8.877843219801866e-17,  2.484015723409173e-17,  9.311389073302117e-20, -2.469678348189449e-21, -1.932513458962424e-23,
  1.600175961952548e+00, -5.672527602367032e-03, -3.930800740144836e-05, -6.105255560247606e-09,  2.725583193113176e-09,  2.027296832371291e-11, -1.147148615315906e-13,
 -3.013407216942067e-15, -1.035004472188635e-17,  2.728115947767011e-19,  3.400502769126438e-21, -7.367076261844071e-24,  1.766670857928739e+00, -3.896514164201209e-03,
 -3.935965685174476e-05, -2.241454769745459e-07,  4.297381604312751e-10,  2.519333968289678e-11,  2.553804160846310e-13,  3.099192969144756e-16, -2.636109761365225e-17,
 -3.721730650423481e-19, -1.391900703668505e-21,  3.105097050245803e-23,  1.898965518900947e+00, -1.914207940266618e-03, -2.499422478497333e-05, -2.547234373751139e-07,
 -1.928512105024149e-09, -7.035318869586271e-12,  8.195138925766097e-14,  2.115835935661745e-15,  2.593316515697256e-17,  1.841224891040123e-19, -1.017997412515977e-22,
 -2.590969622969512e-23,  1.980090090864167e+00, -4.071870678917023e-04, -6.149061946457222e-06, -8.083029637470693e-08, -9.693224800181909e-10, -1.076965762293199e-11,
 -1.109269252254816e-13, -1.046137321735268e-15, -8.729303232263197e-18, -5.845479369427065e-20, -1.895661227869832e-22,  2.860592250446184e-24,  2.331998118524191e-03,
 -2.533602792957733e-05,  2.062251075604992e-07, -1.491097998673730e-09,  1.008708362381570e-11, -6.547149760467790e-14,  4.114879919369194e-16, -2.537669975629513e-18,
  1.523738827770282e-20, -9.179350527995235e-23,  5.209847525447987e-25, -3.294487650029815e-27,  2.098778681661911e-02, -2.269514975718798e-04,  1.826999501701435e-06,
 -1.294933887769404e-08,  8.486706272723125e-11, -5.257103591259087e-13,  3.091985246180272e-15, -1.741894480503702e-17,  9.208478988034510e-20, -4.711126191001210e-22,
  2.013081554978950e-24, -1.028670669040538e-26,  5.829674640007901e-02, -6.243604368586724e-04,  4.912511475100713e-06, -3.337175368635179e-08,  2.037442360820213e-10,
 -1.127062842622741e-12,  5.515320813203933e-15, -2.265621321100991e-17,  5.752445213317430e-20,  1.058082649099695e-22, -3.762450713625556e-24,  2.822029502794032e-26,
  1.142457857169462e-01, -1.205425696070074e-03,  9.144977795938343e-06, -5.785660044162416e-08,  3.097767593925443e-10, -1.327678621784293e-12,  3.328415848003035e-15,
  1.108714792791878e-17, -2.441778644505773e-19,  2.112240585912873e-21, -1.458889479027042e-23,  5.634991950894593e-26,  1.887941189338221e-01, -1.950662697235371e-03,
  1.403446141805623e-05, -7.932577866788816e-08,  3.296822002724265e-10, -5.620457643873561e-13, -6.374175003123192e-15,  8.527669079116960e-17, -6.311290779072370e-19,
  2.869169428912069e-21, -4.942540896387641e-24, -1.082301559780896e-25,  2.818433052844659e-01, -2.831576917928766e-03,  1.890650712945809e-05, -8.903454606800252e-08,
  1.913497616860901e-10,  1.454080787491755e-12, -2.144095002530681e-14,  1.442727979980283e-16, -4.735626688291109e-19, -2.274783168488178e-21,  4.347638560456021e-23,
 -3.870086557049535e-25,  3.931885157882555e-01, -3.808242338758018e-03,  2.289406453191993e-05, -7.760086026563314e-08, -1.482955680894071e-10,  4.338560860778503e-12,
 -3.182249859253960e-14,  7.957913371728180e-17,  8.529557132164739e-19, -1.267077321015789e-20,  7.127404267660985e-23, -5.422605032081891e-26,  5.224408853202299e-01,
 -4.825985300960830e-03,  2.494706062268381e-05, -3.694539710702423e-08, -6.631846935222217e-10,  6.689663353543109e-12, -2.066496708214496e-14, -1.915367773781106e-16,
  2.776986514683759e-18, -1.315667161326584e-20, -6.110209005131831e-23,  1.283989705175261e-24,  6.689042794655047e-01, -5.811129092837149e-03,  2.388689743359923e-05,
  3.630439759257454e-08, -1.209401540421512e-09,  6.069997353344514e-12,  2.554998581439376e-14, -5.532854947472163e-16,  2.399484850657539e-18,  1.837683117909640e-20,
 -3.154840711863931e-22,  1.018050193447754e-24,  8.313794924627969e-01, -6.666114820886648e-03,  1.855856462153355e-05,  1.353901377149872e-07, -1.488847348004898e-09,
 -4.352741527590195e-14,  9.359795555487475e-14, -5.300841779796757e-16, -3.717337722390726e-18,  6.152412497721482e-20, -9.534777241124610e-23, -4.522820775712701e-24,
  1.007853409431320e+00, -7.265356504250091e-03,  8.173428893965905e-06,  2.361740498450683e-07, -1.086907439009916e-09, -1.148593314239649e-11,  1.163996618761346e-13,
  4.543179382153702e-16, -1.129343314838302e-17,  4.475863628846681e-21,  9.682819709966288e-22, -4.564385754315134e-24,  1.195010700119215e+00, -7.455817734075730e-03,
 -7.022313190409972e-06,  2.913554350494920e-07,  2.888708569669039e-10, -2.097808466933019e-11, -5.249815150130834e-15,  1.824850786898135e-15, -1.605896687209305e-18,
 -1.757021395329633e-19,  3.607578242221631e-22,  1.743740636903646e-23,  1.387491795766645e+00, -7.072138719897788e-03, -2.466274783262173e-05,  2.377107564711556e-07,
  2.240484150500342e-09, -1.343078118749455e-11, -2.357346207613551e-13,  7.392218122414582e-16,  2.624178360463625e-17, -1.900414132392204e-20, -3.033930797905997e-21,
 -5.346657333713742e-24,  1.576857545275564e+00, -5.986513656898122e-03, -3.910679861186422e-05,  4.056892656715432e-08,  3.096525016677474e-09,  1.647987062902780e-11,
 -2.020693008645120e-13, -3.162294051227522e-15,  1.773592337083805e-18,  3.948250411762602e-19,  2.505423986587914e-21, -3.396561046903771e-23,  1.750438229947300e+00,
 -4.221993048549317e-03, -4.199043780022236e-05, -2.129046422412795e-07,  9.950528222161245e-10,  3.131859246132093e-11,  2.501756189381694e-13, -7.555557318936461e-16,
 -4.035183277551409e-17, -3.916064082164075e-19,  6.510049065060708e-22,  6.257586665717759e-23,  1.890888666919638e+00, -2.126922911100026e-03, -2.824028107517190e-05,
 -2.865765099234477e-07, -2.044241106019128e-09, -4.257756479231811e-12,  1.537887967518772e-13,  3.048322785794105e-15,  3.214969465835931e-17,  1.500720427359234e-19,
 -1.799662155398538e-21, -5.323512498399326e-23,  1.978356419449760e+00, -4.605404348955022e-04, -7.219685624875763e-06, -9.821780246397595e-08, -1.213882285308585e-09,
 -1.381696039347323e-11, -1.444544851595013e-13, -1.360283866540475e-15, -1.092757591412856e-17, -6.211637673833632e-20,  4.893886179202693e-23,  8.740292047042997e-24,
  2.233844031563976e-03, -2.375515223288017e-05,  1.892587548349911e-07, -1.339666725049065e-09,  8.870927655084860e-12, -5.639626094657526e-14,  3.467898846567725e-16,
 -2.099196930315493e-18,  1.227467305689702e-20, -7.367405631747409e-23,  3.887996779132113e-25, -2.770368982018293e-27,  2.010826023605464e-02, -2.129347596674219e-04,
  1.679420325791885e-06, -1.167170761585730e-08,  7.505708216975470e-11, -4.570376375738334e-13,  2.643064755686726e-15, -1.472894377938476e-17,  7.646390802267502e-20,
 -3.997856732446464e-22,  1.547635387361424e-24, -1.106424523100203e-26,  5.587544461969059e-02, -5.866084382678175e-04,  4.530888732521358e-06, -3.028519589503583e-08,
  1.824763582826270e-10, -1.002097086096447e-12,  4.907096070838668e-15, -2.078137570484880e-17,  5.888230708541083e-20, -2.441295940605495e-23, -2.861113143437883e-24,
  1.274992183785008e-26,  1.095661218054615e-01, -1.134960720655862e-03,  8.479575202923089e-06, -5.310817009095266e-08,  2.840428730777604e-10, -1.244887957313265e-12,
  3.540119413731219e-15,  4.382031177203734e-18, -1.780898341831653e-19,  1.573091166490439e-21, -1.251095233752177e-23,  3.681389958096718e-26,  1.812101161767115e-01,
 -1.842105874152118e-03,  1.311380581256257e-05, -7.414833072754192e-08,  3.170934953048060e-10, -6.885613012121122e-13, -4.253968200502905e-15,  6.668639689315227e-17,
 -5.324464757026951e-19,  2.586648543937511e-21, -8.979644542564737e-24, -8.018762220024869e-26,  2.708128112729513e-01, -2.684544436723360e-03,  1.785733495728180e-05,
 -8.576691414259009e-08,  2.156036301892282e-10,  9.861967670498134e-13, -1.762357463292325e-14,  1.281117030498698e-16, -5.281265756596050e-19, -8.622934395701440e-22,
  2.746982665977066e-23, -3.430790966522462e-25,  3.783159052145549e-01, -3.628848671209201e-03,  2.195134905832911e-05, -7.932010827825773e-08, -6.896704251203822e-11,
  3.604241777504033e-12, -2.927685552793459e-14,  1.001171820832723e-16,  4.469876773149767e-19, -9.928290819057151e-21,  6.447194009176911e-23, -2.439486480781662e-25,
  5.035330477486079e-01, -4.628352596401417e-03,  2.444437345593082e-05, -4.651460170397554e-08, -5.347354378108884e-10,  6.138937451585090e-12, -2.485787274448983e-14,
 -1.106205900301631e-16,  2.271757928351894e-18, -1.460426228557819e-20, -1.463399045438389e-23,  8.241578921844299e-25,  6.460442605829617e-01, -5.618610842139297e-03,
  2.421054777733353e-05,  1.795338551887763e-08, -1.083077322296311e-09,  6.506496183384845e-12,  1.121560687204640e-14, -4.682554593656301e-16,  2.846083381712674e-18,
  6.798475992453567e-21, -2.607304835461324e-22,  1.390674363198577e-24,  8.050216890263168e-01, -6.511551842928521e-03,  2.004066924419997e-05,  1.116784051360933e-07,
 -1.468517528334398e-09,  2.013284461277295e-12,  7.741584047507606e-14, -6.146972459394342e-16, -1.614627843421191e-18,  5.422088434339725e-20, -2.574963464573215e-22,
 -2.839532926384779e-24,  9.789402683790096e-01, -7.188944811506318e-03,  1.089609539263331e-05,  2.171011615246079e-07, -1.287869271006421e-09, -8.580122157620253e-12,
  1.241360619864056e-13,  1.025308826966479e-16, -1.049214771197625e-17,  3.827146273429285e-20,  7.021285545774186e-22, -7.221209678194771e-24,  1.165097284119589e+00,
 -7.497964451439589e-03, -3.512137022959738e-06,  2.926312239762427e-07, -1.278663640200227e-10, -2.050244632870809e-11,  4.420388494604366e-14,  1.676475019871695e-15,
 -7.497278945283919e-18, -1.471662431263459e-19,  1.028221929136802e-21,  1.227617448456967e-23,  1.358827533904879e+00, -7.257443544671560e-03, -2.160496903119617e-05,
  2.711109081499462e-07,  1.917453426366099e-09, -1.874661868997287e-11, -2.035511235336048e-13,  1.544430351677136e-15,  2.336228403255558e-17, -1.400183311760228e-19,
 -2.889953239873712e-21,  1.196437684950946e-23,  1.552290084862410e+00, -6.296555293431403e-03, -3.831276351782529e-05,  9.245679246143464e-08,  3.370544850187609e-09,
  1.058783358814512e-11, -2.875635750661338e-13, -2.862182011439927e-15,  1.735827206296314e-17,  4.572351667738774e-19,  4.299592582081672e-22, -5.917736455989450e-23,
  1.732862677471213e+00, -4.567815642606452e-03, -4.442806775467096e-05, -1.916565752375262e-07,  1.678944961741832e-09,  3.691032555401898e-11,  2.088928897894146e-13,
 -2.261400429169259e-15, -5.323153800105631e-17, -3.011772848430181e-19,  4.085341204251594e-21,  9.174895108189194e-23,  1.881906559269401e+00, -2.367161881874528e-03,
 -3.187752240011447e-05, -3.197338984219113e-07, -2.084953538664692e-09,  5.780348865790512e-13,  2.542284656581613e-13,  4.144458533159104e-15,  3.559669949677865e-17,
  2.062717979180710e-20, -4.952371413192076e-21, -9.151749908117124e-23,  1.976390782743657e+00, -5.233648432634670e-04, -8.524598475654459e-06, -1.200526883085860e-07,
 -1.528188558002977e-09, -1.778246856875004e-11, -1.877662842060926e-13, -1.744444207030695e-15, -1.300916353044660e-17, -4.942193092842421e-20,  6.763848674605153e-22,
  2.127360009927270e-23,  2.141753045040528e-03, -2.230305618507231e-05,  1.739985537490841e-07, -1.206322286500879e-09,  7.821690391493231e-12, -4.873659784800709e-14,
  2.931327458606525e-16, -1.746075120516670e-18,  9.873769494272715e-21, -6.047521327964178e-23,  2.728275602244032e-25, -2.534349853741918e-27,  1.928253280621630e-02,
 -2.000398964819871e-04,  1.546274462236621e-06, -1.054060917812543e-08,  6.651863371879793e-11, -3.982894104432047e-13,  2.262826053213302e-15, -1.250140737138845e-17,
  6.306432089979600e-20, -3.480978989299066e-22,  1.023590875827031e-24, -1.283698759280615e-26,  5.359927152536004e-02, -5.517668668225206e-04,  4.184342924291338e-06,
 -2.751970486903353e-08,  1.635660816008876e-10, -8.910979838757842e-13,  4.351312231393063e-15, -1.893246890296364e-17,  5.603687552754536e-20, -1.322181007378276e-22,
 -2.641173526148218e-24, -2.545043701317541e-27,  1.051580225208450e-01, -1.069597913610886e-03,  7.868738692549969e-06, -4.875801911123424e-08,  2.600015625998109e-10,
 -1.159047756983171e-12,  3.590873257330183e-15, -5.045886157003866e-19, -1.301417841675205e-19,  1.097770820705343e-21, -1.144153505467975e-23,  1.142269543754329e-26,
  1.740459986422758e-01, -1.740669377733681e-03,  1.225399605377520e-05, -6.918995049348434e-08,  3.024429668546471e-10, -7.700918389385520e-13, -2.611819545652558e-15,
  5.106195569292928e-17, -4.466202482663128e-19,  2.159063734317764e-21, -1.238264415684828e-23, -7.746060774619536e-26,  2.603539171871686e-01, -2.545742569129913e-03,
  1.684940963302637e-05, -8.218126075116735e-08,  2.313784989017065e-10,  6.043449803962133e-13, -1.427637067922586e-14,  1.108980712599467e-16, -5.429453112439953e-19,
 -5.648057598060908e-23,  1.301265635232171e-23, -3.163349574750252e-25,  3.641456842194293e-01, -3.457058767725639e-03,  2.099514472240811e-05, -7.988410115804933e-08,
 -3.674571663611012e-12,  2.936539896381722e-12, -2.632364198994661e-14,  1.091761817543907e-16,  1.330050566409605e-19, -7.606968155848288e-21,  5.062778770663085e-23,
 -3.763329436574046e-25,  4.854070189216208e-01, -4.435166641735645e-03,  2.383880779719645e-05, -5.412146494744620e-08, -4.181330820955569e-10,  5.512906433975987e-12,
 -2.701697482336799e-14, -4.638660763913423e-17,  1.742966525226425e-18, -1.460019210876892e-20,  1.154357810983049e-23,  3.734092976849460e-25,  6.239581476670802e-01,
 -5.424349330926227e-03,  2.432634291322197e-05,  1.675542478966431e-09, -9.512637615665898e-10,  6.628785522374151e-12, -5.973581099525093e-16, -3.751568310697372e-16,
  2.917998682896549e-18, -2.395790496634648e-21, -1.993502389818712e-22,  1.343666128378092e-24,  7.793040608355331e-01, -6.346261675638374e-03,  2.124147200191574e-05,
  8.859926584944460e-08, -1.411088968086681e-09,  3.660614877746888e-12,  5.975896115129819e-14, -6.373376785014089e-16,  1.261570330498935e-19,  4.189500787742187e-20,
 -3.476277136058345e-22, -1.308925616828469e-24,  9.503748159386403e-01, -7.091717481022847e-03,  1.337253641407699e-05,  1.952846186660984e-07, -1.429636539430760e-09,
 -5.602894901380021e-12,  1.225484929601086e-13, -2.063987172985561e-16, -8.688940400007003e-18,  5.964094061887264e-20,  3.606914999611604e-22, -8.001894496079070e-24,
  1.135071382472654e+00, -7.512080740699382e-03, -2.614010005595774e-08,  2.873780251897644e-07, -5.236638843779043e-10, -1.890995537223871e-11,  8.705202565116736e-14,
  1.360660225842916e-15, -1.194448149030265e-17, -9.742537059199374e-20,  1.401621280347336e-21,  4.466135638715974e-24,  1.329473381308386e+00, -7.416778566405349e-03,
 -1.818075148583672e-05,  2.985414289088594e-07,  1.497585573726051e-09, -2.303386339516287e-11, -1.507502258615032e-13,  2.190379979806388e-15,  1.641112676923825e-17,
 -2.403910414203129e-19, -2.021952578809122e-21,  2.652971279461857e-23,  1.526499198468295e+00, -6.597689160082170e-03, -3.687400770819902e-05,  1.476786567312470e-07,
  3.507183776342555e-09,  2.802578199827610e-12, -3.574610117756384e-13, -2.045436524600593e-15,  3.345464669905063e-17,  4.175441152999337e-19, -2.499961574317612e-21,
 -7.073363652929776e-23,  1.713866720681926e+00, -4.931925275145652e-03, -4.654159217744974e-05, -1.586405146364419e-07,  2.461124360502284e-09,  4.096274987504171e-11,
  1.203681316207788e-13, -4.098545592804243e-15, -6.011534388382745e-17, -5.260566119473099e-20,  8.393899994506777e-21,  9.828628410264912e-23,  1.871902775106580e+00,
 -2.638093157851593e-03, -3.591291598743707e-05, -3.526273907842824e-07, -2.002315880657257e-09,  8.199884368896039e-12,  3.860104310688585e-13,  5.248587467703892e-15,
  3.169109797599428e-17, -2.702471644017685e-19, -9.883831687129406e-21, -1.312261399017034e-22,  1.974151181221670e+00, -5.977685334566690e-04, -1.012451384628179e-05,
 -1.476112196954570e-07, -1.933107484285694e-09, -2.292343941003510e-11, -2.426567656218600e-13, -2.181800403376064e-15, -1.402105918524651e-17,  2.579431924093521e-21,
  2.106338569300127e-21,  4.651116874727096e-23,  2.055236025558111e-03, -2.096691540125830e-05,  1.602425966993889e-07, -1.088606856144824e-09,  6.913526436742288e-12,
 -4.225433132610178e-14,  2.483525678483306e-16, -1.463056907555094e-18,  7.866728740316525e-21, -5.173309133139267e-23,  1.663364036985305e-25, -2.234560000561482e-27,
  1.850633729381765e-02, -1.881581437602251e-04,  1.425919312473799e-06, -9.537201675544108e-09,  5.906870091999588e-11, -3.479653419280190e-13,  1.939205365313447e-15,
 -1.067708177947891e-17,  5.113001470081788e-20, -3.188031743667915e-22,  4.395081081237094e-25, -1.291101041067938e-26,  5.145712311626707e-02, -5.195698977725622e-04,
  3.869238581137071e-06, -2.503972578481228e-08,  1.467465238883084e-10, -7.928303073019432e-13,  3.845444297794754e-15, -1.723627984041009e-17,  4.931513602829100e-20,
 -2.435924076054416e-22, -2.990175274388729e-24, -1.072949849545698e-26,  1.010019226321517e-01, -1.008919399950216e-03,  7.307852777005464e-06, -4.477877208542726e-08,
  2.376789840570126e-10, -1.073473558338569e-12,  3.523756314847506e-15, -4.124561985265874e-18, -9.879917864155218e-20,  6.438162426705347e-22, -1.137137111803147e-23,
 -3.539027664728855e-27,  1.672742412017316e-01, -1.645877452808638e-03,  1.145223313994834e-05, -6.447702559134466e-08,  2.865220472442714e-10, -8.171654343798243e-13,
 -1.371206194175539e-15,  3.791142574640043e-17, -3.786357136206603e-19,  1.595371809715640e-21, -1.575767172654099e-23, -6.989607849488139e-26,  2.504343816032739e-01,
 -2.414828254877062e-03,  1.588578820386392e-05, -7.840010552554250e-08,  2.402804427695079e-10,  2.970115925907290e-13, -1.141420913740023e-14,  9.356497757315757e-17,
 -5.388916709587968e-19,  1.941354386665898e-22, -1.876244559793980e-25, -2.737741624792798e-25,  3.506473044715826e-01, -3.292928800574319e-03,  2.003801252881244e-05,
 -7.950632905030584e-08,  4.898762381639804e-11,  2.341696735997925e-12, -2.324570030766106e-14,  1.094076556761393e-16, -1.086084443100515e-19, -5.936004047440658e-21,
  3.257754524907291e-23, -4.205700135716495e-25,  4.680435102423829e-01, -4.247159592897300e-03,  2.315273289334446e-05, -5.996509375975046e-08, -3.144337067603587e-10,
  4.854733895606553e-12, -2.761318011173738e-14,  1.092896786620946e-18,  1.228584482840108e-18, -1.392225048253447e-20,  1.991889479413824e-23,  4.365839902565878e-26,
  6.026497471429338e-01, -5.229906851596982e-03,  2.425949127219028e-05, -1.248823417578771e-08, -8.196282707475752e-10,  6.498815791956569e-12, -9.817773576842355e-15,
 -2.845881260368137e-16,  2.701859710433354e-18, -9.255061464129435e-21, -1.453700384897272e-22,  1.110419418568236e-24,  7.542650773080510e-01, -6.172454910679770e-03,
  2.217185055718544e-05,  6.667942406443120e-08, -1.324972087528856e-09,  4.882435955002515e-12,  4.217708779534435e-14, -6.119425097826246e-16,  1.373672213791714e-18,
  2.721463579486032e-20, -3.775584016884746e-22, -8.987849201823075e-26,  9.222361893128780e-01, -6.975759879282525e-03,  1.557551979204915e-05,  1.716712701522491e-07,
 -1.512904563763851e-09, -2.760433746190088e-12,  1.132153537530255e-13, -4.479891246967039e-16, -6.365878207459187e-18,  6.717479160669266e-20,  2.249224634894858e-23,
 -7.111490292094266e-24,  1.105044244019210e+00, -7.498666097472879e-03,  3.360045046623696e-06,  2.760994647993008e-07, -8.781200671495840e-10, -1.640956322327662e-11,
  1.193507782256893e-13,  9.333802311414440e-16, -1.441717225249100e-17, -3.982168361176388e-20,  1.421535397033921e-21, -3.316313514276166e-24,  1.299538591602733e+00,
 -7.547523427565748e-03, -1.447026593003116e-05,  3.186426142947187e-07,  1.005966951158184e-09, -2.586505315931029e-11, -8.346560664792220e-14,  2.563915163405098e-15,
  6.607751815895092e-18, -2.952874711618557e-19, -6.744446828567069e-22,  3.315840123759269e-23,  1.499531029735996e+00, -6.884637547970187e-03, -3.476488199296081e-05,
  2.037587542849148e-07,  3.473486790516732e-09, -6.329731419178119e-12, -3.976583902037990e-13, -7.597048349738370e-16,  4.594827168965020e-17,  2.569999750132434e-19,
 -5.437254345969486e-21, -5.834132005759688e-23,  1.693383325617971e+00, -5.311140257904283e-03, -4.818158259041935e-05, -1.125944519086867e-07,  3.298850440734371e-09,
  4.225786640977023e-11, -2.109834763324305e-14, -5.979668076371283e-15, -5.498720654784118e-17,  3.618516131641560e-19,  1.203618696378194e-20,  5.787476968084366e-23,
  1.860748248112308e+00, -2.942851240369505e-03, -4.032948338992147e-05, -3.827972217125251e-07, -1.733228660789157e-09,  1.933024866412493e-11,  5.450940709925493e-13,
  6.018964294417172e-15,  1.338479552122492e-17, -7.881151955026812e-19, -1.610092815796371e-20, -1.428249554700502e-22,  1.971586105442013e+00, -6.864127942256493e-04,
 -1.209764018656061e-05, -1.825467893930402e-07, -2.455021408774190e-09, -2.953020827082670e-11, -3.098722223183534e-13, -2.608041138678749e-15, -1.181225412971573e-17,
  1.398048732776836e-19,  5.102986992492877e-21,  9.453304898018528e-23,  1.973852084064163e-03, -1.973540946725466e-05,  1.478161372738509e-07, -9.844407125681293e-10,
  6.124866077031035e-12, -3.675869016837077e-14,  2.106394020792765e-16, -1.240012912643381e-18,  6.102848429360734e-21, -4.675212152358635e-23,  9.350280485267515e-26,
 -7.128964613935496e-28,  1.777581660560302e-02, -1.771930212241832e-04,  1.316921751714116e-06, -8.645346646067570e-09,  5.255149862211067e-11, -3.048375357535895e-13,
  1.661446166369594e-15, -9.222172267190812e-18,  3.984886347256669e-20, -3.105619495049174e-22,  5.564962170802952e-26, -1.142454270730879e-27,  4.943890312520895e-02,
 -4.897791542321134e-04,  3.582342072296390e-06, -2.281378078558218e-08,  1.317746166348826e-10, -7.061616593121325e-13,  3.383434081849371e-15, -1.582235530930908e-17,
  3.830689650007440e-20, -3.688900890418236e-22, -3.086110892990785e-24,  1.616891414074271e-26,  9.707985664493111e-02, -9.525429121573441e-04,  6.792630964023436e-06,
 -4.114311458150463e-08,  2.170440929766262e-10, -9.906282430064022e-13,  3.366864588157862e-15, -7.003081015680328e-18, -8.379219449082925e-20,  1.932043104828633e-22,
 -1.078915895190126e-23,  4.929128760484500e-26,  1.608691752410928e-01, -1.557277802934875e-03,  1.070547075647561e-05, -6.002487043771481e-08,  2.699287651625656e-10,
 -8.386567041227287e-13, -4.715785357919117e-16,  2.658732617708711e-17, -3.331287173616766e-19,  9.233519650712494e-22, -1.705145181230334e-23,  4.229193843960323e-26,
  2.410233755333193e-01, -2.291439438994362e-03,  1.496820402368356e-05, -7.452212495688262e-08,  2.436834244267513e-10,  5.256563158562868e-14, -9.034899626058342e-15,
  7.640931838374973e-17, -5.346085473442405e-19, -1.442868161581132e-23, -8.791925137255163e-24, -6.958727136869007e-26,  3.377901782509290e-01, -3.136424311929281e-03,
  1.909008954565210e-05, -7.837713593682424e-08,  9.048788938530593e-11,  1.819978840702660e-12, -2.026147693343196e-14,  1.027300749976501e-16, -3.030155297439721e-19,
 -4.965385900326808e-21,  1.762706446666332e-23, -1.833295435836556e-25,  4.514206469420423e-01, -4.064894434606762e-03,  2.240605382667762e-05, -6.425519877678214e-08,
 -2.239426986140177e-10,  4.196369786389410e-12, -2.710641288917576e-14,  3.254395565897253e-17,  7.419359994611657e-19, -1.310655214340632e-20,  2.149936130836958e-23,
  1.412464073286551e-25,  5.821170206571310e-01, -5.036643513277452e-03,  2.403518890729819e-05, -2.457781618268763e-08, -6.926046191228063e-10,  6.176991880012486e-12,
 -1.663335483295091e-14, -2.044882314983889e-16,  2.275525434722305e-18, -1.411300480192488e-20, -9.686277758274216e-23,  1.217846072108550e-24,  7.299345763209200e-01,
 -5.992232136170800e-03,  2.284819120982276e-05,  4.631033358349560e-08, -1.218559619312968e-09,  5.694841823199910e-12,  2.578466383813923e-14, -5.552111547517218e-16,
  2.083781433684482e-18,  1.238773075243739e-20, -3.541676140654880e-22,  1.251353240026030e-24,  8.945948198222228e-01, -6.843330269475437e-03,  1.748897994345130e-05,
  1.471661101202660e-07, -1.542067100951336e-09, -2.145824407408867e-13,  9.818115550749061e-14, -6.134081762820235e-16, -4.001362069582746e-18,  6.243961757791448e-20,
 -2.404428562350434e-22, -4.513778232550982e-24,  1.075123955149431e+00, -7.458795702585503e-03,  6.578634915591858e-06,  2.595875816984605e-07, -1.175823887532377e-09,
 -1.328460268095118e-11,  1.388870619580968e-13,  4.596732516143710e-16, -1.487867064152534e-17,  1.239341076484593e-20,  1.154134587635910e-21, -8.081515636898203e-24,
  1.269141524192589e+00, -7.647756986025002e-03, -1.056733777475699e-05,  3.305155491444040e-07,  4.745304563581514e-10, -2.699279634245656e-11, -1.033436010989099e-14,
  2.602929075176563e-15, -4.156630610850300e-18, -2.932093875059563e-19,  7.607623191723734e-22,  3.082520271422259e-23,  1.471453043958943e+00, -7.152044408888143e-03,
 -3.199219189955957e-05,  2.577990900118118e-07,  3.250620258011043e-09, -1.595571123897970e-11, -3.972801689971109e-13,  8.122127873261973e-16,  5.075069341346849e-17,
 -2.263347417413305e-21, -7.245203207030209e-21, -1.993528714791274e-23,  1.671360652943595e+00, -5.701036408301461e-03, -4.918838904937552e-05, -5.313941458894069e-08,
  4.124418177685712e-09,  3.955896052066001e-11, -2.105204927284518e-13, -7.434343740154896e-15, -3.290034606274344e-17,  8.693193559331488e-19,  1.262227565486494e-20,
 -3.985697993986945e-23,  1.848301858172543e+00, -3.284298525602271e-03, -4.507422172418078e-05, -4.066674482419729e-07, -1.202028346994134e-09,  3.445232416727501e-11,
  7.144017435299688e-13,  5.857372782933368e-15, -2.798802790638901e-17, -1.544553186027263e-18, -2.118076169970083e-20, -6.729032582085231e-23,  1.968632013098703e+00,
 -7.926715647195286e-04, -1.454475208133353e-05, -2.269815605148365e-07, -3.126105114166260e-09, -3.787987360988557e-11, -3.870985944578033e-13, -2.856727240304290e-15,
 -1.909441051162016e-18,  4.489394577613561e-19,  1.097201811259073e-20,  1.796664987076943e-22,  1.897202967359852e-03, -1.859852170543012e-05,  1.365674335293265e-07,
 -8.920609995461752e-10,  5.437540923838346e-12, -3.209945072518317e-14,  1.784051854351443e-16, -1.070927706265905e-18,  4.489473154979376e-21, -4.248006789874764e-23,
  1.578070980485395e-25,  4.521250643312691e-27,  1.708747780848115e-02, -1.670587795449457e-04,  1.218028127069191e-06, -7.851215482812214e-09,  4.683328003346109e-11,
 -2.679276922744680e-13,  1.419401943867849e-15, -8.125020940069146e-18,  2.878228726539850e-20, -2.993086812334660e-22,  8.378011028242836e-25,  4.478805774181106e-26,
  4.753541935560993e-02, -4.621806818752710e-04,  3.320774885065798e-06, -2.081410908867596e-08,  1.184281834150593e-10, -6.301500981326813e-13,  2.955418183944455e-15,
 -1.483002193689081e-17,  2.320338824281785e-20, -4.514041722795806e-22, -1.445616764242031e-25,  1.404971365554888e-25,  9.337532161023213e-02, -9.001191755355659e-04,
  6.319110033802862e-06, -3.782459128763384e-08,  1.980221436276164e-10, -9.124759175477584e-13,  3.133729182078358e-15, -9.649379507422804e-18, -8.363393465340050e-20,
 -1.422317805648979e-22, -4.210931059615822e-24,  2.954395720349468e-25,  1.548068916396776e-01, -1.474443087623528e-03,  1.001053060749266e-05, -5.584057841842766e-08,
  2.530966405204392e-10, -8.422196535579514e-13,  1.277288999058210e-16,  1.633613452536070e-17, -3.109114126427414e-19,  3.727921700845949e-22, -7.364929346874805e-24,
  4.744664779613727e-25,  2.320915389478152e-01, -2.175204580085231e-03,  1.409733056661996e-05, -7.062586856708895e-08,  2.427296557877927e-10, -1.405344809318316e-13,
 -7.135500148084640e-15,  5.922800917612356e-17, -5.408765737651359e-19, -2.734622457255523e-22,  8.421199952355224e-25,  6.248192558023913e-25,  3.255440039577842e-01,
 -2.987438485902354e-03,  1.815936897358409e-05, -7.666359785001405e-08,  1.222513569348708e-10,  1.366964502598578e-12, -1.754672491322290e-14,  9.030529286672639e-17,
 -4.691998324275223e-19, -4.208093749593405e-21,  2.730600058287658e-23,  7.981690735380349e-25,  4.355146047980704e-01, -3.888785015397126e-03,  2.161614899952613e-05,
 -6.720185698671321e-08, -1.464349938619993e-10,  3.559003960514159e-12, -2.593241478653231e-14,  4.892714861146750e-17,  2.890880198673236e-19, -1.188195135039274e-20,
  4.826860714717327e-23,  1.329012999324509e-24,  5.623528879424208e-01, -4.845720886627685e-03,  2.367776664862896e-05, -3.469466622637581e-08, -5.734801213949614e-10,
  5.716818275654399e-12, -2.142062451727959e-14, -1.404287586088801e-16,  1.713012368415030e-18, -1.662897941323395e-20, -1.847383682473568e-23,  2.676975203936312e-24,
  7.063342821503669e-01, -5.807546309764869e-03,  2.329078689320580e-05,  2.775303186290300e-08, -1.099693337687368e-09,  6.134975380399476e-12,  1.122063115939052e-14,
 -4.839854511875972e-16,  2.293618201649725e-18, -3.378399670251395e-23, -2.472017225771382e-22,  3.988610011356841e-24,  8.675119154752827e-01, -6.696773423227192e-03,
  1.910719138998071e-05,  1.225806574630220e-07, -1.524252714777240e-09,  1.923193549501779e-12,  7.953591147816056e-14, -7.076576721347154e-16, -1.963067225042044e-18,
  5.015291385306803e-20, -3.356405568835630e-22,  7.706396269854051e-25,  1.045413282519278e+00, -7.394045241559281e-03,  9.572635268422265e-06,  2.388333882079068e-07,
 -1.407415707165032e-09, -9.849951085868729e-12,  1.452187357211377e-13, -1.109094051466647e-18, -1.368934078766398e-17,  5.132001054424276e-20,  8.027902563568866e-22,
 -6.573255601883415e-24,  1.238406666189868e+00, -7.716342864682969e-03, -6.573388370181664e-06,  3.338001001585449e-07, -6.202037057479790e-11, -2.639074683325263e-11,
  5.915533977322596e-14,  2.309445207954490e-15, -1.385429020241408e-17, -2.375094383873093e-19,  1.977131750794246e-21,  2.452005442189382e-23,  1.442353796069685e+00,
 -7.394750985758826e-03, -2.859872312242141e-05,  3.067490600816233e-07,  2.838941629929543e-09, -2.503611794426357e-11, -3.522183569385148e-13,  2.378205090767956e-15,
  4.538282938858204e-17, -2.938690208350087e-19, -6.921761728449456e-21,  3.659162400263137e-23,  1.647767114859003e+00, -6.095914383442369e-03, -4.940509586313087e-05,
  1.883367948953500e-08,  4.847731542455671e-09,  3.192183690908153e-11, -4.280526827690799e-13, -7.894622716781966e-15,  6.723233663473132e-18,  1.301937518187588e-18,
  8.077584485247491e-21, -1.664028241602488e-22,  1.834412185210024e+00, -3.664680601694910e-03, -5.004372323196055e-05, -4.194027248045174e-07, -3.290035801971199e-10,
  5.340752653786157e-11,  8.563260981331639e-13,  3.905911256966419e-15, -9.906425405494671e-17, -2.394271778584214e-18, -1.954336816797237e-20,  1.755358928303224e-22,
  1.965210079576841e+00, -9.208359885330269e-04, -1.759534684416708e-05, -2.835918946870867e-07, -3.983045247458793e-09, -4.811862222236897e-11, -4.648091379540926e-13,
 -2.556992278541583e-15,  2.437849492004260e-17,  1.081950177829896e-18,  2.166644460608377e-20,  3.152486560321132e-22,  1.824928188370615e-03, -1.754736948325024e-05,
  1.263642462171505e-07, -8.099735372564497e-10,  4.836018391106934e-12, -2.816268090860580e-14,  1.502123414045084e-16, -9.499578648616820e-19,  3.147941767645572e-21,
 -2.920094750044509e-23,  5.945046768410625e-25,  1.666868361869814e-26,  1.643815190969839e-02, -1.576790698211667e-04,  1.128138492323118e-06, -7.142976134948232e-09,
  4.179745196828440e-11, -2.364975785899840e-13,  1.203251637942937e-15, -7.364568140108008e-18,  1.931931470693591e-20, -1.996640036700764e-22,  4.936776472777906e-24,
  1.537224673341739e-25,  4.573829139827292e-02, -4.365822810504155e-04,  3.081970883691376e-06, -1.901636816654634e-08,  1.065012182665182e-10, -5.641337275050152e-13,
  2.548211761904377e-15, -1.433240267349646e-17,  8.985842309312629e-21, -2.595767795872131e-22,  1.193728547480780e-23,  4.431532024697750e-25,  8.987315024445479e-02,
 -8.513293745167195e-04,  5.883635802664491e-06, -3.479824412257838e-08,  1.805012506802083e-10, -8.408161456079903e-13,  2.825264013197522e-15, -1.240644056602333e-17,
 -8.736732578841135e-20,  9.631872678298793e-23,  2.051707655912283e-23,  8.974634198280575e-25,  1.490651393984527e-01, -1.396971626642726e-03,  9.364185995085770e-06,
 -5.192548531431606e-08,  2.363141916330932e-10, -8.347778422165930e-13,  4.477693630871551e-16,  6.599828335584148e-18, -2.955525025080194e-19,  7.481563021470491e-22,
  3.363000870852429e-23,  1.505270747059495e-24,  2.236110032041785e-01, -2.065750226185408e-03,  1.327300075336887e-05, -6.677345572129688e-08,  2.383306350444817e-10,
 -2.938488164954996e-13, -5.720443174285015e-15,  4.184500251319908e-17, -5.400121464331323e-19,  7.069255387537396e-22,  5.992399728460918e-23,  2.240005616829000e-24,
  3.138790229860245e-01, -2.845808201172946e-03,  1.725197228066551e-05, -7.451091526721156e-08,  1.455749175986253e-10,  9.743588922819449e-13, -1.524909626801229e-14,
  7.317872437201769e-17, -5.875408157042877e-19, -1.839347865303539e-21,  1.081794052018564e-22,  3.142314550340136e-24,  4.203001664066893e-01, -3.719116150496248e-03,
  2.079790966760383e-05, -6.900871243386528e-08, -8.136394233136135e-11,  2.953732540667348e-12, -2.449372465456108e-14,  5.186340806579119e-17, -8.317533703296487e-20,
 -8.020590722548720e-21,  1.677171248386982e-22,  4.480574871648534e-24,  5.433460028716083e-01, -4.658111582131530e-03,  2.321005578157695e-05, -4.298482226149593e-08,
 -4.645735300967270e-10,  5.161181904614227e-12, -2.467461704054986e-14, -9.504852819650467e-17,  1.137975153019177e-18, -1.403320342616023e-20,  1.780533386641955e-22,
  6.775323794039685e-24,  6.834784488368436e-01, -5.620177587724843e-03,  2.352233696337059e-05,  1.114970728866869e-08, -9.753559160856974e-10,  6.249885759520908e-12,
 -1.314824185547312e-15, -4.120920987849440e-16,  2.169520785985292e-18, -4.951565689899397e-21,  4.437265810611757e-23,  9.914082793936905e-24,  8.410392723231110e-01,
 -6.538443054098982e-03,  2.043341761617412e-05,  9.859719569821806e-08, -1.468335123718527e-09,  3.588763851719817e-12,  5.909607027830605e-14, -7.439703485870326e-16,
 -3.689940131548931e-19,  3.990041326840521e-20, -1.059216696123788e-22,  1.054020044777679e-23,  1.016007856413409e+00, -7.306396719069875e-03,  1.229763433446138e-05,
  2.149272327603074e-07, -1.569812561517368e-09, -6.412657743285404e-12,  1.393741398675697e-13, -4.038437412990102e-16, -1.131256736052718e-17,  8.009254177859654e-20,
  7.148766455007370e-22,  4.289877534890935e-24,  1.207461413381595e+00, -7.752963943989868e-03, -2.590851450246474e-06,  3.286833824958169e-07, -5.706904872379256e-10,
 -2.425244616418619e-11,  1.164483631041471e-13,  1.746605415892942e-15, -2.073114003166052e-17, -1.378233724990839e-19,  3.000208223414589e-21,  2.369602384189768e-23,
  1.412341561858334e+00, -7.608085538720031e-03, -2.466313895362138e-05,  3.477325042961517e-07,  2.259880619382043e-09, -3.253776495909944e-11, -2.672449140617147e-13,
  3.611988421713941e-15,  3.037348762639426e-17, -5.203503438219646e-19, -3.953519706270644e-21,  9.799404673839830e-23,  1.622596327632641e+00, -6.488888025391178e-03,
 -4.869465221653479e-05,  1.008725514172902e-07,  5.365846924455471e-09,  1.906543713777065e-11, -6.386918422667067e-13, -6.883422854691045e-15,  5.736209596654184e-17,
  1.448763548786602e-18, -1.316833843644056e-21, -2.445190444165015e-22,  1.818920878644103e+00, -4.085162618343375e-03, -5.506919042381771e-05, -4.149752582000109e-07,
  9.513164603935232e-10,  7.482898329291378e-11,  9.073980686524966e-13, -7.721748467317224e-16, -1.964097086814754e-16, -2.902324545567559e-18, -2.538419751993424e-21,
  6.298847861266320e-22,  1.961222026072073e+00, -1.076371753321947e-03, -2.141460512814624e-05, -3.556479406107445e-07, -5.062138732776457e-09, -6.000234195377799e-11,
 -5.182636357374180e-13, -9.563089515411431e-16,  8.272622625480154e-17,  2.276392763553768e-18,  3.934659181170443e-20,  4.911561468896060e-22,  1.756700782530575e-03,
 -1.657406042507945e-05,  1.170908444225410e-07, -7.369162443674120e-10,  4.306716665599564e-12, -2.486615371691043e-14,  1.249082973383322e-16, -8.597109883243028e-19,
  2.748937793531953e-21,  1.454108744830156e-23,  1.733244873060089e-24,  3.581902425460441e-26,  1.582495856880753e-02, -1.489858054557164e-04,  1.046284139531039e-06,
 -6.510556398495471e-09,  3.733991696910751e-11, -2.100290764175160e-13,  1.004980088619645e-15, -6.807237240675131e-18,  1.774327038611005e-20,  1.807787952925812e-22,
  1.535368083649385e-23,  3.264079082455078e-25,  4.403986835654457e-02, -4.128111678916203e-04,  2.863636646465321e-06, -1.739942313225330e-08,  9.579775538802594e-11,
 -5.077640938892007e-13,  2.150441066898360e-15, -1.405631731660783e-17,  1.412907852242898e-20,  7.411897373760638e-22,  4.164945335074602e-23,  9.262623120332049e-25,
  8.655939390957114e-02, -8.058827621871095e-04,  5.482841652352955e-06, -3.204119423016259e-08,  1.643332618007801e-10, -7.774832328322778e-13,  2.440916381201864e-15,
 -1.489562248896720e-17, -5.723148892814400e-20,  1.972444924749842e-21,  8.036514897305605e-23,  1.860842291867413e-24,  1.436232226077418e-01, -1.324487549350513e-03,
  8.763217398034800e-06, -4.827739477036063e-08,  2.197356956995021e-10, -8.228446964586066e-13,  5.069359389157061e-16, -2.011369661791132e-18, -2.243855334622121e-19,
  3.871046032991478e-21,  1.345768231485389e-22,  3.147676213949570e-24,  2.155553864001418e-01, -1.962707013377402e-03,  1.249438192727410e-05, -6.301427708943506e-08,
  2.311657426438277e-10, -4.189866389458537e-13, -4.782267376888492e-15,  2.566832598455324e-17, -4.413367447202419e-19,  5.781496199668899e-21,  2.126043364885486e-22,
  4.800066303214489e-24,  3.027662166029387e-01, -2.711327995345870e-03,  1.637239696474102e-05, -7.204504597615677e-08,  1.615571755711211e-10,  6.308205481912865e-13,
 -1.346545182981863e-14,  5.448353414689951e-17, -5.333143390095794e-19,  6.284049772301086e-21,  3.254648427586464e-22,  6.883809083441118e-24,  4.057511981143208e-01,
 -3.556063137762881e-03,  1.996384151158400e-05, -6.986939266976873e-08, -2.805264206321006e-11,  2.382799033868055e-12, -2.311035293619758e-14,  4.634477490888161e-17,
 -1.909522708729762e-19,  4.050092492916938e-21,  4.738021806637980e-22,  9.652983375991422e-24,  5.250814822673991e-01, -4.474613139605153e-03,  2.265293870400518e-05,
 -4.962522153696828e-08, -3.674678532979189e-10,  4.540768475471716e-12, -2.688840125096054e-14, -6.464951453864359e-17,  8.496587689825849e-19,  9.348072459850055e-22,
  6.209940902492858e-22,  1.367133645295046e-23,  6.613745812061060e-01, -5.431719533100367e-03,  2.356660827008759e-05, -3.461503957925123e-09, -8.515684178715735e-10,
  6.087583437944135e-12, -1.190013428987087e-14, -3.441724893356038e-16,  2.151625110454102e-18,  8.149218233725269e-21,  6.801991734480933e-22,  1.938555493140163e-23,
  8.152193721143945e-01, -6.370636514548515e-03,  2.147822262557820e-05,  7.574800752433842e-08, -1.384065399875424e-09,  4.757085958061449e-12,  3.831609775238063e-14,
 -7.324722103911990e-16,  1.138860016604450e-18,  4.894218557889137e-20,  6.636263410097388e-22,  2.493865993636954e-23,  9.869947519578987e-01, -7.198134714651975e-03,
  1.472240328608898e-05,  1.889614060389152e-07, -1.665731179715989e-09, -3.241399822641227e-12,  1.234749473116984e-13, -7.135127371983344e-16, -7.820893509557704e-18,
  1.178650269753247e-19,  1.321076376320066e-21,  2.436472743959446e-23,  1.176432817509117e+00, -7.758104981316280e-03,  1.283090191439758e-06,  3.158390208094231e-07,
 -1.024234195565592e-09, -2.094949357499872e-11,  1.554974201646593e-13,  1.029153414401696e-15, -2.326050608799604e-17,  5.513443567437912e-21,  4.250829981173746e-21,
  3.513611613780352e-23,  1.381541837103730e+00, -7.788136346171945e-03, -2.029590592025550e-05,  3.783721959498782e-07,  1.553669453284625e-09, -3.764635677558071e-11,
 -1.554818202331081e-13,  4.263140349491394e-15,  9.985908423761060e-18, -5.757190716808143e-19,  1.566156884277171e-21,  1.499961633739191e-22,  1.595871418909588e+00,
 -6.872120589883839e-03, -4.695934367696090e-05,  1.888825290204400e-07,  5.579531502416679e-09,  1.678731288456058e-12, -7.980829221506777e-13, -4.244457542585593e-15,
  1.060054282740285e-16,  1.186400708817792e-18, -1.136706098829831e-20, -1.845133902272977e-22,  1.801668107839633e+00, -4.545254861197267e-03, -5.990440069864025e-05,
 -3.866196705972680e-07,  2.659842482178233e-09,  9.554114762245959e-11,  7.823005406492272e-13, -8.684623359688084e-15, -2.945505896357527e-16, -2.285648208279874e-18,
  3.740100353945323e-20,  1.176264850713716e-21,  1.956544806471606e+00, -1.266232211140188e-03, -2.621014599712807e-05, -4.469209880290433e-07, -6.386827356379083e-09,
 -7.237516802304511e-11, -4.932342694390867e-13,  3.351045570344289e-15,  1.986445156343314e-16,  4.328090404457448e-18,  6.412421608415355e-20,  6.078279797286837e-22,
  1.692223593938259e-03, -1.567157100069558e-05,  1.086453883331475e-07, -6.718324759676148e-10,  3.837477189687317e-12, -2.214623250436306e-14,  1.022615546532989e-16,
 -7.465649700694039e-19,  4.951248573521570e-21,  1.208469718454813e-22,  3.694101497486181e-24,  5.069950310463257e-26,  1.524527501889963e-02, -1.409181936358225e-04,
  9.716075465956359e-07, -5.945475411257983e-09,  3.336546679553852e-11, -1.881216218598817e-13,  8.243278536295641e-16, -5.985623088235632e-18,  3.922830127117496e-20,
  1.131421682379589e-21,  3.319014204159670e-23,  4.607444221735657e-25,  4.243315530608795e-02, -3.907119442828010e-04,  2.663713750084849e-06, -1.594522957754301e-08,
  8.612711700472446e-11, -4.607870539545045e-13,  1.770002243128173e-15, -1.276738163745048e-17,  8.191401851807234e-20,  3.360341528101535e-21,  9.214422808112311e-23,
  1.302813258123687e-24,  8.342121476757233e-02, -7.635144694546614e-04,  5.113620092129824e-06, -2.953322084160040e-08,  1.493349371876904e-10, -7.240210365206691e-13,
  2.014310479348090e-15, -1.479310207989255e-17,  9.395275802075290e-20,  7.100336229568901e-21,  1.816981734318161e-22,  2.613513905360735e-24,  1.384618975414639e-01,
 -1.256640603582505e-03,  8.204442268357196e-06, -4.489264942142064e-08,  2.033924162122251e-10, -8.119922627035652e-13,  3.801649208347925e-16, -5.622759291565345e-18,
  4.964869817081392e-20,  1.249463551583578e-20,  3.062941871744494e-22,  4.434839084879383e-24,  2.078997672507222e-01, -1.865714442445420e-03,  1.176010638728476e-05,
 -5.938868036932573e-08,  2.216892990279528e-10, -5.264702873539409e-13, -4.215661724170073e-15,  1.697596987253796e-17, -2.235545432595292e-20,  1.924446010504610e-20,
  4.757217447275411e-22,  6.816850617837671e-24,  2.921774507108999e-01, -2.583762191068567e-03,  1.552372670693707e-05, -6.937627115691937e-08,  1.710567453097068e-10,
  3.243425012344914e-13, -1.212314964947505e-14,  4.420942992712214e-17,  1.033152736554135e-20,  2.643965724704198e-20,  7.046932257161446e-22,  9.858444412411366e-24,
  3.918410507125156e-01, -3.399710338622973e-03,  1.912419195744214e-05, -6.996669103391189e-08,  1.415951471742779e-11,  1.843319748945182e-12, -2.184497141875762e-14,
  4.714956944517634e-17,  4.124278383928790e-19,  3.300361342355823e-20,  1.005215342745559e-21,  1.381889338954177e-23,  5.075415729130469e-01, -4.295864920517301e-03,
  2.202504091836276e-05, -5.481380456920371e-08, -2.832355898160761e-10,  3.877030967306992e-12, -2.827126114725355e-14, -3.082504848157441e-17,  1.494334587100874e-18,
  3.983254165156534e-20,  1.366109208761139e-21,  1.928000348754339e-23,  6.400241907828358e-01, -5.243575309110193e-03,  2.344727858968024e-05, -1.613123395121721e-08,
 -7.334111784184389e-10,  5.694621884416069e-12, -2.048097784315597e-14, -2.635348983577574e-16,  3.166118868475335e-18,  5.518031769413403e-20,  1.728985892044471e-21,
  2.704625016244842e-23,  7.900857128860171e-01, -6.195543773826270e-03,  2.225761113668496e-05,  5.440718312636586e-08, -1.281360020330803e-09,  5.436548908102367e-12,
  1.863219537877601e-14, -6.603105710366062e-16,  3.681758523811220e-18,  1.015863242757394e-19,  2.056422750704633e-21,  3.666029438525401e-23,  9.584514877565543e-01,
 -7.071742336205427e-03,  1.682839253255898e-05,  1.619448473356409e-07, -1.702671438956437e-09, -5.416773041724806e-13,  1.007174837294936e-13, -8.832088558629253e-16,
 -2.309954662117590e-18,  1.984371356939326e-19,  2.845862022297828e-21,  4.288038508204435e-23,  1.145444497215296e+00, -7.732989061802018e-03,  4.961685270841036e-06,
  2.963104221469237e-07, -1.403999950125781e-09, -1.695443287748000e-11,  1.741757958781969e-13,  3.241313639310191e-16, -1.958373241847409e-17,  2.113594500582850e-19,
  6.150552304857517e-21,  4.948523307296271e-23,  1.350093833265523e+00, -7.931977466441961e-03, -1.563167871708194e-05,  3.970457381656017e-07,  7.732034729550770e-10,
 -3.992778311674493e-11, -3.459189380708932e-14,  4.276697525249177e-15, -7.930494069661480e-18, -3.716498035350519e-19,  8.789105571195311e-21,  1.700677916800919e-22,
  1.567648079301218e+00, -7.237215725971386e-03, -4.415947421406124e-05,  2.773498908307960e-07,  5.414075757732965e-09, -1.848209287959884e-11, -8.637194926778950e-13,
 -2.695210583807313e-16,  1.390474461152169e-16,  6.231162471911229e-19, -1.524344055133586e-20,  2.638795565236589e-23,  1.782500455484783e+00, -5.042172974938352e-03,
 -6.422240418713239e-05, -3.278581787891705e-07,  4.732939724139086e-09,  1.102701708036872e-10,  3.974837252709505e-13, -1.902959200405809e-14, -3.363766267073207e-16,
  3.538636159876894e-19,  9.621307032772175e-20,  1.389601731834008e-21,  1.951023946714350e+00, -1.499216774679500e-03, -3.223606164164583e-05, -5.612865774337822e-07,
 -7.940714981218179e-09, -8.220559456367822e-11, -2.831615918081067e-13,  1.274671707014879e-14,  4.068299758790360e-16,  7.393376565919788e-18,  8.716184068918356e-20,
  3.232576561711266e-22,  1.631226007140940e-03, -1.483364488876016e-05,  1.009375933610305e-07, -6.138496119101216e-10,  3.417515751099341e-12, -1.991975026263268e-14,
  8.445833493061150e-17, -4.856894268272856e-19,  1.248682895121015e-20,  3.111587928195592e-22,  5.672885212455086e-24,  2.943469290813771e-26,  1.469670855278105e-02,
 -1.334219199075558e-04,  9.033440998568864e-07, -5.440706329908044e-09,  2.978822697345127e-11, -1.701592991451595e-13,  6.824827507239270e-16, -3.783231104509879e-18,
  1.086303568673692e-19,  2.845701006798187e-21,  5.117721015052874e-23,  2.680522574717250e-25,  4.091174727909209e-02, -3.701448647028733e-04,  2.480342239813552e-06,
 -1.463872806448516e-08,  7.730932672884682e-11, -4.221606638397383e-13,  1.473115583807942e-15, -7.388493455243492e-18,  2.827299515045449e-19,  8.139680735963783e-21,
  1.430354735117452e-22,  7.608731561023679e-25,  8.044678620080943e-02, -7.239835683240522e-04,  4.773087888157921e-06, -2.725720970853624e-08,  1.353073588032606e-10,
 -6.800164519054121e-13,  1.691915800508984e-15, -6.071928608360072e-18,  5.074779315473240e-19,  1.656321180194098e-20,  2.839031787281058e-22,  1.534079934583894e-24,
  1.335632708413003e-01, -1.193105821109529e-03,  7.684721713128973e-06, -4.176783786020099e-08,  1.872340879206951e-10, -8.040684448890472e-13,  3.316459779533978e-16,
  5.904745413859584e-18,  7.659918028509325e-19,  2.847490450344461e-20,  4.800262379299592e-22,  2.617651283888653e-24,  2.006206416730932e-01, -1.774424783636242e-03,
  1.106835957700381e-05, -5.593121429455041e-08,  2.101894595908465e-10, -6.212371454983687e-13, -3.616636317242401e-15,  3.159840311534716e-17,  1.083761614644832e-18,
  4.401318259449564e-20,  7.433672780864648e-22,  4.045429223625097e-24,  2.820855751863269e-01, -2.462855518562887e-03,  1.470779693881434e-05, -6.660284213361893e-08,
  1.747390075933183e-10,  4.937358974089528e-14, -1.069388867665845e-14,  6.604979021542512e-17,  1.572052402199190e-18,  6.294168968605556e-20,  1.092658870409558e-21,
  5.880600485290125e-24,  3.785428878618752e-01, -3.250068733574317e-03,  1.828707662399025e-05, -6.947320076956227e-08,  4.590352317634573e-11,  1.337778705607173e-12,
 -2.009921452646580e-14,  8.829613010737681e-17,  2.468118383585413e-18,  8.487923130548945e-20,  1.550064650805205e-21,  8.296872317221566e-24,  4.907062467406933e-01,
 -4.122367043288041e-03,  2.134252354686512e-05, -5.876229001880864e-08, -2.125149301118351e-10,  3.195310051392254e-12, -2.816456830039927e-14,  5.212775125849340e-17,
  4.112565181160883e-18,  1.107637963174190e-19,  2.127830267499909e-21,  1.173129658578774e-23,  6.194235495795281e-01, -5.056962396674321e-03,  2.318696195032293e-05,
 -2.698365472759711e-08, -6.249629914339887e-10,  5.128349668472852e-12, -2.603430202686789e-14, -1.147785057154693e-16,  6.679425234865302e-18,  1.472515477785180e-19,
  2.804277036367309e-21,  1.695701236867703e-23,  7.656633135295579e-01, -6.015211478528828e-03,  2.279113710438586e-05,  3.479356984355027e-08, -1.169569435430282e-09,
  5.679195669769021e-12,  2.474213685237360e-15, -4.649532119092435e-16,  9.205012017240295e-18,  2.152674157914258e-19,  3.541425392906350e-21,  2.423462911314150e-23,
  9.304454266129029e-01, -6.929804982010037e-03,  1.860831903173439e-05,  1.347383060994995e-07, -1.691347904565265e-09,  1.577910532065900e-12,  7.620508213987481e-14,
 -8.171109785398166e-16,  7.342417226929123e-18,  3.498994452368662e-19,  4.636730536785791e-21,  2.963450523747386e-23,  1.114613876283594e+00, -7.679478851967638e-03,
  8.372177730313167e-06,  2.713627581566144e-07, -1.700880910303387e-09, -1.272728676585660e-11,  1.759849510308104e-13, -1.290995722606953e-16, -7.031498958124746e-18,
  4.990547646329128e-19,  8.079016100136693e-21,  2.702072320571628e-23,  1.318146208785490e+00, -8.037823173125798e-03, -1.081929106732428e-05,  4.030235071623592e-07,
 -2.414537644772690e-11, -3.935927609244792e-11,  8.015795914362077e-14,  3.890901299661228e-15, -1.325349981658240e-17,  1.198372909068604e-19,  1.534628997930193e-20,
  1.084063901202784e-22,  1.538015776180087e+00, -7.575741481731151e-03, -4.032735552086619e-05,  3.598983830310676e-07,  4.839201518010790e-09, -3.878246704983244e-11,
 -8.064048984696387e-13,  4.427849555539315e-15,  1.514394733070567e-16,  1.073956619985165e-19, -8.975533593972933e-21,  2.364773809246241e-22,  1.761281329367890e+00,
 -5.570232050176519e-03, -6.762842961369634e-05, -2.341722078606340e-07,  6.984449818607817e-09,  1.122406806835387e-10, -2.781681139914667e-13, -2.873399406815111e-14,
 -2.407250459482446e-16,  5.287150281402560e-18,  1.447228983436583e-19,  5.949027672039732e-22,  1.944465428729101e+00, -1.786333527816074e-03, -3.978885833829927e-05,
 -7.017089501472961e-07, -9.615140640077300e-09, -8.297708998880749e-11,  3.008984203985787e-13,  3.070784774466456e-14,  7.365004848217345e-16,  1.084729376855619e-17,
  7.456822638890576e-20, -1.207260837911776e-21,  1.573461049793908e-03, -1.405470894059610e-05,  9.388667888982378e-08, -5.622500494073633e-10,  3.038572318794442e-12,
 -1.799883297119993e-14,  7.845794915949203e-17,  1.381687132615941e-19,  2.788235968129210e-20,  5.401950816327506e-22,  4.992647086499518e-24, -7.931092035735816e-26,
  1.417707198985239e-02, -1.264484716204000e-04,  8.408057928918849e-07, -4.990457823825565e-09,  2.654274095789733e-11, -1.545489178207585e-13,  6.435149630499050e-16,
  1.738669291198781e-18,  2.489293364822152e-19,  4.913331679164407e-21,  4.508470696113494e-23, -7.166184943536227e-25,  3.946976960895587e-02, -3.509843870598019e-04,
  2.311826655263538e-06, -1.346745168122181e-08,  6.920948408294936e-11, -3.879547823193008e-13,  1.445049884667136e-15,  7.484559556084508e-18,  6.816497064648979e-19,
  1.392523609635061e-20,  1.262251176586549e-22, -2.007597408902651e-24,  7.762520039895586e-02, -6.870714271002582e-04,  4.458549152414181e-06, -2.519890528824245e-08,
  1.221114328250465e-10, -6.389841480770410e-13,  1.854973914649745e-15,  2.196673830584804e-17,  1.314131032713277e-18,  2.806132345733413e-20,  2.510534226660537e-22,
 -3.991117615721738e-24,  1.289106990393058e-01, -1.133583194796485e-03,  7.200953149660473e-06, -3.890019142988095e-08,  1.712645352669235e-10, -7.902717822905133e-13,
  1.021452287157169e-15,  5.063946734227720e-17,  2.147033526229541e-18,  4.793484206733816e-20,  4.253160973327729e-22, -6.739582476769441e-24,  1.936958649509354e-01,
 -1.688506406842633e-03,  1.041693893714520e-05, -5.267190484292351e-08,  1.969956217432510e-10, -6.918255747583954e-13, -1.966028877987865e-15,  9.754862798890196e-17,
  3.219534678817726e-18,  7.416073705270619e-20,  6.597814120693517e-22, -1.037080683230444e-23,  2.724644831361127e-01, -2.348342562375853e-03,  1.392532722243761e-05,
 -6.381230215746697e-08,  1.733491365850032e-10, -1.769989415366987e-13, -7.737668479162893e-15,  1.613067702714969e-16,  4.648134755640376e-18,  1.072587564477810e-19,
  9.718681330410223e-22, -1.505061922365160e-23,  3.658299462896920e-01, -3.107092480353724e-03,  1.745860575871567e-05, -6.854986757610376e-08,  6.809524479131579e-11,
  8.972527306090542e-13, -1.597401475970927e-14,  2.285054602541529e-16,  6.673485976944834e-18,  1.478076775665010e-19,  1.384803164491855e-21, -2.096629220861225e-23,
  4.745537175118546e-01, -3.954500626901443e-03,  2.061896668574867e-05, -6.168718898945514e-08, -1.551553130994575e-10,  2.556034956498490e-12, -2.414236620752132e-14,
  2.644999700640473e-16,  9.682325163188874e-18,  1.974930084398813e-19,  1.919598436867562e-21, -2.825045655984546e-23,  5.995644106356299e-01, -4.872924335321512e-03,
  2.280643460138798e-05, -3.619706298452353e-08, -5.287560338646818e-10,  4.494810975397196e-12, -2.529898192229215e-14,  2.062607393195816e-16,  1.407951837550910e-17,
  2.626199165108599e-19,  2.574638146036586e-21, -3.692477742969954e-23,  7.419693323897769e-01, -5.831521779083018e-03,  2.310012956425329e-05,  1.698863066148519e-08,
 -1.056240130309841e-09,  5.623813136556007e-12, -5.052543944364942e-15, -1.780125708753094e-17,  1.962957954986414e-17,  3.627428416029285e-19,  3.314246677784182e-21,
 -4.744345049119091e-23,  9.030335343543021e-01, -6.774928029782141e-03,  2.006415286389379e-05,  1.080214375140215e-07, -1.643162264821972e-09,  3.171796958825486e-12,
  5.877398645340686e-14, -3.433235186072452e-16,  2.342249345930223e-17,  5.414909761131398e-19,  4.266038422882335e-21, -6.403844005801754e-23,  1.084049862514678e+00,
 -7.599956519025308e-03,  1.145758566136869e-05,  2.423403303978864e-07, -1.913535781769445e-09, -8.553588783882818e-12,  1.723721244923017e-13, -3.417852006735213e-18,
  1.680486913924749e-17,  8.185397429364639e-19,  6.971217188269825e-21, -1.009269977444241e-22,  1.285852350150503e+00, -8.105097907157443e-03, -6.010866139767734e-06,
  3.964804962476565e-07, -7.834831622009758e-10, -3.616766363098647e-11,  1.846994052082506e-13,  3.660805007296263e-15,  2.815424894949016e-18,  7.775402797250836e-19,
  1.590122187570161e-20, -1.177255038197127e-22,  1.507096697072194e+00, -7.879834472524209e-03, -3.557287530883073e-05,  4.301208913636709e-07,  3.882895295116587e-09,
 -5.609920054441046e-11, -6.143696525569198e-13,  9.287804309317340e-15,  1.514655119730845e-16, -3.674478027906495e-20,  1.165233916689638e-21,  1.491421355109337e-22,
  1.737903451474995e+00, -6.120433146156783e-03, -6.969586446696619e-05, -1.051117903944346e-07,  9.093729986425852e-09,  9.525609086026600e-11, -1.153838421340055e-12,
 -3.225436988720388e-14,  5.527849058968613e-17,  1.104736250133294e-17,  1.270965234237628e-19, -1.618066890345031e-21,  1.936626289735849e+00, -2.141063655764150e-03,
 -4.918498856907360e-05, -8.680901145347353e-07, -1.111746270001897e-08, -6.239665435037422e-11,  1.552612781595183e-12,  6.094042107626554e-14,  1.159212598280518e-15,
  1.176718133200691e-17, -5.954662173280931e-20, -5.485429510139557e-21,  1.518702801487122e-03, -1.332980369897452e-05,  8.741984190306804e-08, -5.164070252254073e-10,
  2.698340547547645e-12, -1.594947832412488e-14,  9.796022069703365e-17,  1.369855556638153e-18,  4.955155599271742e-20,  6.097932142938293e-22, -3.249355211020265e-24,
 -3.172833508427843e-25,  1.368436161101387e-02, -1.199545769342078e-04,  7.833692070550178e-07, -4.589627705859676e-09,  2.361553382264038e-11, -1.374464403490126e-13,
  8.322834221438277e-16,  1.278991280141321e-17,  4.458584689217923e-19,  5.539965119500014e-21, -2.947787263555611e-23, -2.871435074244213e-24,  3.810182357594592e-02,
 -3.331179634121222e-04,  2.156611714289443e-06, -1.242016652756965e-08,  6.182898826496564e-11, -3.478017230462066e-13,  2.040885424923052e-15,  3.803292748508614e-17,
  1.239019009374270e-18,  1.567191380992705e-20, -8.310904009180819e-23, -8.066908071425629e-24,  7.494638199198345e-02, -6.525803211367601e-04,  4.167471896878139e-06,
 -2.334463377873900e-08,  1.098554995971268e-10, -5.813409577495629e-13,  3.221628640867301e-15,  8.160313213256694e-17,  2.435757250581350e-18,  3.152530260442047e-20,
 -1.661457749423100e-22, -1.609003773064293e-23,  1.244886892924233e-01, -1.077797384358781e-03,  6.750076683215573e-06, -3.628442718760412e-08,  1.558663544859091e-10,
 -7.392861564461840e-13,  3.679276190091273e-15,  1.493639038867052e-16,  4.061654673190974e-18,  5.381977705787428e-20, -2.807515316051193e-22, -2.725130345790943e-23,
  1.871045815274774e-01, -1.607646626624002e-03,  9.803325863100081e-06, -4.963205942397785e-08,  1.829797069040386e-10, -6.919733739418064e-13,  2.637988071800788e-15,
  2.470369658008607e-16,  6.183745983552889e-18,  8.340806982248526e-20, -4.284041310198167e-22, -4.202477030105521e-23,  2.632891345269411e-01, -2.239956109708537e-03,
  1.317607663870691e-05, -6.107523969914084e-08,  1.684208048951467e-10, -2.879041089734545e-13, -5.154382692232786e-16,  3.773749828345065e-16,  8.946862508236565e-18,
  1.212285229505049e-19, -6.094335854331652e-22, -6.110280109404520e-23,  3.536757320622081e-01, -2.970694264736289e-03,  1.664307633699640e-05, -6.733493755990902e-08,
  8.287156429638120e-11,  6.200231189486554e-13, -5.724912464260220e-15,  5.351556307055413e-16,  1.262546746605766e-17,  1.684240683469943e-19, -8.246382867915027e-22,
 -8.546496881403254e-23,  4.590608755485082e-01, -3.792548384726800e-03,  1.986541910297443e-05, -6.378895341075132e-08, -1.090184053825592e-10,  2.107517740388276e-12,
 -1.124439993338607e-14,  6.992138521831204e-16,  1.767796891895221e-17,  2.270943831041935e-19, -1.083226118716488e-21, -1.164646139630192e-22,  5.804346709832612e-01,
 -4.692347507518303e-03,  2.232417680558435e-05, -4.396798205500991e-08, -4.441613363641238e-10,  4.017187604873718e-12, -1.167971229393019e-14,  8.230666300937288e-16,
  2.473068242883094e-17,  3.029897387206008e-19, -1.425020125190697e-21, -1.560001668270940e-22,  7.190137441081943e-01, -5.646184075314882e-03,  2.320628741887760e-05,
  9.832801541226196e-10, -9.445959234170863e-10,  5.580390270219390e-12,  5.353944384408994e-15,  8.385024127598868e-16,  3.421595523202038e-17,  4.131908355902100e-19,
 -1.957742297105171e-21, -2.072256749212303e-22,  8.762624343080048e-01, -6.609671408146507e-03,  2.120500344563553e-05,  8.231346619808580e-08, -1.565881381841542e-09,
  4.570710116170562e-12,  6.277290605957278e-14,  7.424722344915230e-16,  4.483468482446217e-17,  6.019154697776758e-19, -2.805643492946772e-21, -2.779459816731836e-22,
  1.053851025581253e+00, -7.497195515183552e-03,  1.417705626024464e-05,  2.105813830512565e-07, -2.042810308370704e-09, -4.328177221398157e-12,  1.845483017389658e-13,
  1.046807552206392e-15,  4.957678496949811e-17,  9.353109074231414e-19, -3.257286199411659e-21, -3.921311093484925e-22,  1.253365546028268e+00, -8.134420114907028e-03,
 -1.351308585637984e-06,  3.784341930617459e-07, -1.454028675841127e-09, -3.046478536772446e-11,  2.934553979315115e-13,  4.304697797943376e-15,  3.996941459144686e-17,
  1.192564635810560e-18,  1.513440260328337e-21, -5.749090540565363e-22,  1.475042255000149e+00, -8.142805521453996e-03, -3.007802194342130e-05,  4.825684687509166e-07,
  2.637354513185863e-09, -6.717638966066526e-11, -2.865519850606510e-13,  1.412761170269138e-14,  1.513337861811035e-16, -2.307304367265787e-21, -4.053875824977591e-21,
 -4.825542076299035e-22,  1.712302265313411e+00, -6.680438411878698e-03, -7.002703210732771e-05,  5.382581020508038e-08,  1.065148401071182e-08,  5.732455076693779e-11,
 -1.966471762050084e-12, -2.333186684282708e-14,  5.194523750587973e-16,  1.383768210757498e-17, -9.366133336270813e-21, -4.575829846963373e-21,  1.927204726763623e+00,
 -2.579314325634275e-03, -6.070219278102236e-05, -1.053268064506180e-06, -1.183133538258133e-08, -1.051648183729642e-13,  3.835350215777273e-12,  1.037589470088921e-13,
  1.462831414098014e-15,  2.419043767517329e-18, -4.677810832313115e-19, -1.366908388602535e-20,  1.466744062568727e-03, -1.265452188692308e-05,  8.147192935186324e-08,
 -4.756412432817339e-10,  2.406974621760547e-12, -1.294037366830846e-14,  1.614513096696787e-16,  3.248804999568289e-18,  6.495134659619871e-20,  1.067632634073621e-22,
 -2.427756716025065e-23, -6.393223950586319e-25,  1.321673720157506e-02, -1.139017031198170e-04,  7.304739741490047e-07, -4.232532306268603e-09,  2.110442274017015e-11,
 -1.113928981348286e-13,  1.416828100464675e-15,  2.972345387865462e-17,  5.859385504848544e-19,  9.841551476922063e-22, -2.198246417339651e-22, -5.787867923095494e-24,
  3.680293664679422e-02, -3.164449294275011e-04,  2.013285567574708e-06, -1.148344069966619e-08,  5.547424550590400e-11, -2.810825256830208e-13,  3.736417093589063e-15,
  8.523135402770731e-17,  1.636211960410947e-18,  2.858541563545603e-21, -6.180686186858934e-22, -1.627039269259276e-23,  7.240100712502535e-02, -6.203320594869114e-04,
  3.897514874566284e-06, -2.167481133861044e-08,  9.923662412770743e-11, -4.668321811873491e-13,  6.749803796212869e-15,  1.747562399956576e-16,  3.237250370427388e-18,
  5.946210873873137e-21, -1.233691522289314e-21, -3.247905350847029e-23,  1.202828017858423e-01, -1.025497112085121e-03,  6.329158908261381e-06, -3.390234569712209e-08,
  1.423854213619732e-10, -5.844643886857209e-13,  9.940979531905905e-15,  3.053455169557408e-16,  5.434823843980249e-18,  1.051080016461295e-20, -2.089794690075823e-21,
 -5.505886087145780e-23,  1.808271451202380e-01, -1.531553604114182e-03,  9.224869110356957e-06, -4.680887226354236e-08,  1.704602132733711e-10, -5.207436751305264e-13,
  1.272859981695097e-14,  4.852964731028318e-16,  8.319270966419480e-18,  1.678429889601891e-20, -3.219639216685434e-21, -8.498640716162257e-23,  2.545355497119977e-01,
 -2.137433719255089e-03,  1.245916129027810e-05, -5.842302012323601e-08,  1.635781256703301e-10, -1.374103781011165e-13,  1.464607483860359e-14,  7.224621841824522e-16,
  1.205970318690419e-17,  2.486971143455627e-20, -4.670116950180777e-21, -1.236947032244490e-22,  3.420541598085982e-01, -2.840758267176429e-03,  1.584341383640946e-05,
 -6.591127018603362e-08,  9.537000343463838e-11,  7.132562779895722e-13,  1.573179122446280e-14,  1.020952300117723e-15,  1.695790232506157e-17,  3.469861491290894e-20,
 -6.509124350198338e-21, -1.732670770390373e-22,  4.442036430414140e-01, -3.636713408468847e-03,  1.909085051798757e-05, -6.520280959222442e-08, -6.762046632115718e-11,
  2.143480592047830e-12,  1.735457078022727e-14,  1.375264048327506e-15,  2.352250111288591e-17,  4.632588400009263e-20, -8.842118537875885e-21, -2.367448082001857e-22,
  5.620189636389931e-01, -4.515979315056665e-03,  2.175654909228239e-05, -5.043747705163013e-08, -3.642517162672545e-10,  4.112152820756288e-12,  2.391543067262780e-14,
  1.761753183231401e-15,  3.253118076049462e-17,  6.148006863910038e-20, -1.184981681617639e-20, -3.186693687601159e-22,  6.968000317100940e-01, -5.460734931799514e-03,
  2.313113878033226e-05, -1.322003537747653e-08, -8.291072861040963e-10,  6.127040326035654e-12,  4.616753670516164e-14,  2.134709939551151e-15,  4.490964177386111e-17,
  8.898565899966740e-20, -1.586770897022168e-20, -4.263224873044503e-22,  8.501686931430236e-01, -6.436498726856430e-03,  2.204574911771965e-05,  5.808276218529534e-08,
 -1.456799917806659e-09,  6.507415634909629e-12,  1.065879397318766e-13,  2.473251342472639e-15,  6.076282519671294e-17,  1.594852899165448e-19, -2.149611630274910e-20,
 -5.737198063395801e-22,  1.024104289539941e+00, -7.374231754542225e-03,  1.650588183370721e-05,  1.774581337816915e-07, -2.081655918369373e-09,  6.612302520518617e-13,
  2.407227341666779e-13,  3.106213348664153e-15,  7.568904286201325e-17,  3.430783377696578e-19, -2.933391521043737e-20, -7.963781740141138e-22,  1.220834389625935e+00,
 -8.127504842678334e-03,  3.031567105164091e-06,  3.507221165614765e-07, -1.982219728540161e-09, -2.179227713587019e-11,  4.380930588175959e-13,  6.222412690908524e-15,
  7.630073775774142e-17,  5.709715692990096e-19, -3.704888428076385e-20, -1.179768762244957e-21,  1.442027335693074e+00, -8.359652878205982e-03, -2.407916995386071e-05,
  5.137885726630975e-07,  1.259915163333476e-09, -6.876207646086461e-11,  1.762580199884264e-13,  1.887881329391188e-14,  1.405524019628626e-16, -8.856862493959810e-19,
 -4.789846391876722e-20, -1.538553028236311e-21,  1.684468352818125e+00, -7.235104298151878e-03, -6.832956499381203e-05,  2.306746640845109e-07,  1.128472267150249e-08,
  4.615194777462397e-12, -2.315174011053615e-12,  7.513848255648023e-16,  9.558694307374451e-16,  8.753986043949810e-18, -2.577890832864292e-19, -6.319634855822988e-21,
  1.915831689929218e+00, -3.118669235390122e-03, -7.445815935636736e-05, -1.236502498067148e-06, -1.065052372902326e-08,  1.320149204735511e-10,  7.375643726638630e-12,
  1.470056161087470e-13,  1.042554567291547e-15, -3.109184749239819e-17, -1.269049312040615e-18, -2.179188478827941e-20,  1.417394277432486e-03, -1.202494066560311e-05,
  7.598753994467872e-08, -4.389544542091272e-10,  2.195483582592265e-12, -7.743679068808710e-15,  2.804160027615498e-16,  5.141747169164679e-18,  4.387032899603545e-20,
 -1.495006695382242e-21, -5.678165458577135e-23, -7.611499536511904e-25,  1.277250419811064e-02, -1.082554882291653e-04,  6.816429408731787e-07, -3.910516055722235e-09,
  1.929484221402119e-11, -6.532425298466373e-14,  2.501719543713042e-15,  4.680395578930345e-17,  3.956923364251219e-19, -1.351888399935996e-20, -5.141319668716255e-22,
 -6.893077827897607e-24,  3.556851754079238e-02, -3.008751521772301e-04,  1.880642546918059e-06, -1.063503658686234e-08,  5.097288127384068e-11, -1.569666482873609e-13,
  6.828674771363073e-15,  1.329487998366395e-16,  1.104608914646629e-18, -3.791883085984422e-20, -1.445643480685802e-21, -1.939007337018933e-23,  6.998042909386012e-02,
 -5.901659823614648e-04,  3.646669306777990e-06, -2.015104386409484e-08,  9.197614140632251e-11, -2.346292882128876e-13,  1.304018566977295e-14,  2.692217168838734e-16,
  2.184698221586038e-18, -7.545844050149407e-20, -2.886408784414524e-21, -3.874468423090632e-23,  1.162795569318865e-01, -9.764532128804378e-04,  5.935664794822505e-06,
 -3.170147192941758e-08,  1.338750409510879e-10, -2.239845499648231e-13,  2.083788430382030e-14,  4.640476916488482e-16,  3.667002298317891e-18, -1.274432571378992e-19,
 -4.893064167160109e-21, -6.576644168093988e-23,  1.748450357148216e-01, -1.459955770486558e-03,  8.679250819981386e-06, -4.414307159318163e-08,  1.643548414350204e-10,
 -2.263836506156330e-14,  2.991212171725338e-14,  7.284000130615484e-16,  5.614781695944966e-18, -1.959481685608688e-19, -7.549635341015439e-21, -1.016822003316447e-22,
  2.461807840064418e-01, -2.040520288106014e-03,  1.177378039778409e-05, -5.580099916078669e-08,  1.662068084239571e-10,  4.997081286940098e-13,  4.008916177727060e-14,
  1.075106021866004e-15,  8.150231379061285e-18, -2.841803597307247e-19, -1.097764966173854e-20, -1.483004544768477e-22,  3.309396503882320e-01, -2.717147486660182e-03,
  1.506220051831917e-05, -6.423989813759472e-08,  1.160402823310929e-10,  1.494143294101660e-12,  5.165242914373191e-14,  1.517172613912818e-15,  1.149919680287507e-17,
 -3.970176293585333e-19, -1.535410886822296e-20, -2.082777415818326e-22,  4.299572662034121e-01, -3.487131255634700e-03,  1.830345268493200e-05, -6.590453545249359e-08,
 -1.703114206941260e-11,  3.105699180982750e-12,  6.603738205799358e-14,  2.064303009307329e-15,  1.606026457631915e-17, -5.417011191706128e-19, -2.094531742082122e-20,
 -2.855592957232920e-22,  5.442991866510359e-01, -4.344440452760089e-03,  2.111919714552529e-05, -5.555749770625562e-08, -2.716709111707730e-10,  5.393755246626800e-12,
  8.732833874612661e-14,  2.716907269233510e-15,  2.248897883218844e-17, -7.283650590401822e-19, -2.817495690146185e-20, -3.861532244098363e-22,  6.753258800118990e-01,
 -5.276536083464214e-03,  2.289720545748987e-05, -2.542199165700360e-08, -6.898119731472061e-10,  8.112327862291787e-12,  1.254386407523134e-13,  3.460698696612847e-15,
  3.170023907167036e-17, -9.690304721993693e-19, -3.776792064411151e-20, -5.196993430598848e-22,  8.247792994402748e-01, -6.257730083642809e-03,  2.260770845513093e-05,
  3.598163845602265e-08, -1.294328908531309e-09,  1.011432339793258e-11,  2.024329389509924e-13,  4.289861906682450e-15,  4.430649155931564e-17, -1.270943489760000e-18,
 -5.104474290501667e-20, -7.036204892986161e-22,  9.948841481905717e-01, -7.234229708352163e-03,  1.843708647974011e-05,  1.446058859947678e-07, -2.002185350308319e-09,
  7.757459728021929e-12,  3.614206835080947e-13,  5.424915972527934e-15,  5.759840325763123e-17, -1.621612755439831e-18, -7.032164079081334e-20, -9.778015235779683e-22,
  1.188398730424131e+00, -8.086985906009352e-03,  7.037581107286131e-06,  3.161554328790210e-07, -2.297349838149205e-09, -8.905325372288685e-12,  6.469219033282033e-13,
  8.596541606937931e-15,  5.637307346751292e-17, -2.083367451505268e-18, -9.780645578960955e-20, -1.454186652607025e-21,  1.408242854411815e+00, -8.527383786884637e-03,
 -1.783688173397948e-05,  5.233634583179875e-07, -2.776533256687576e-11, -5.772665061948075e-11,  7.595500722427295e-13,  2.234699898894123e-14,  5.532256555580649e-17,
 -4.422756394177836e-18, -1.338121644991057e-19, -2.174174644336240e-21,  1.654456512091031e+00, -7.767611290118862e-03, -6.448469314598146e-05,  4.090219334164447e-07,
  1.084188550408555e-08, -4.703346748095944e-11, -1.835849312015927e-12,  3.385277360546762e-14,  1.019530611362630e-15, -6.936137266190381e-18, -5.146924659386877e-19,
 -4.643151884187399e-21,  1.902067970450113e+00, -3.776313257543511e-03, -9.019640440932962e-05, -1.374720387259129e-06, -5.892993642250142e-09,  3.607630171421408e-10,
  1.170987302656471e-11,  1.507934392083658e-13, -1.218075902653543e-15, -1.002299502165880e-16, -2.110115709365615e-18, -1.045640943474470e-20,  1.370477785717566e-03,
 -1.143752213112971e-05,  7.092706546103313e-08, -4.046490425658700e-10,  2.120118128899212e-12,  8.056456208578709e-16,  4.324719622061692e-16,  5.186904869662935e-18,
 -5.784678677668526e-20, -4.302358832097799e-21, -7.791090427148408e-23,  3.557580843435554e-26,  1.235009864082865e-02, -1.029848770819756e-04,  6.365377701561069e-07,
 -3.608524165551185e-09,  1.869984611282736e-11,  1.126861027629134e-14,  3.884862699131294e-15,  4.717379686625496e-17, -5.246959271198043e-19, -3.894051960237858e-20,
 -7.056013157760872e-22,  3.159729963506247e-25,  3.439431828988290e-02, -2.863268031645979e-04,  1.757844338316609e-06, -9.834363406404872e-09,  4.978766959673349e-11,
  5.388754787478002e-14,  1.075238545941212e-14,  1.337854943769373e-16, -1.480124397973612e-18, -1.094139281593143e-19, -1.984931156956513e-21,  8.530921236817456e-25,
  6.767661539783665e-02, -5.619350934980376e-04,  3.413593974413390e-06, -1.869729735617627e-08,  9.105081835442199e-11,  1.733094176103175e-13,  2.097202776998409e-14,
  2.703678794647934e-16, -2.967505478167186e-18, -2.182548831922055e-19, -3.966131433727234e-21,  1.593413622999320e-24,  1.124663566143724e-01, -9.304532924119613e-04,
  5.568051822861101e-06, -2.956354851306852e-08,  1.354940963004119e-10,  4.395833486165905e-13,  3.448466407503617e-14,  4.650853566930456e-16, -5.051306438815468e-18,
 -3.696360357661862e-19, -6.730872783685985e-21,  2.439870680233056e-24,  1.691407892019933e-01, -1.392595672287932e-03,  8.165443033017670e-06, -4.147081678470044e-08,
  1.728020147676238e-10,  9.514929004599707e-13,  5.129980563500492e-14,  7.289934987890108e-16, -7.815208650585870e-18, -5.699087283534060e-19, -1.040142983220786e-20,
  3.227617599896628e-24,  2.382029077810219e-01, -1.948962132991235e-03,  1.112065231872881e-05, -5.299884862069646e-08,  1.883609090502093e-10,  1.839775196334887e-12,
  7.163272456535212e-14,  1.075899189160571e-15, -1.135734822341277e-17, -8.284972125678212e-19, -1.515625471241094e-20,  3.684130087848458e-24,  3.203072216127952e-01,
 -2.599699051949100e-03,  1.430370672832283e-05, -6.206185843879362e-08,  1.619027449231198e-10,  3.267291226097135e-12,  9.619481837612725e-14,  1.521646453561481e-15,
 -1.578053758534105e-17, -1.159362171953926e-18, -2.125683574777321e-20,  3.365635395094142e-24,  4.162965881906109e-01, -3.343866303374478e-03,  1.751334755813611e-05,
 -6.557360425189439e-08,  6.581440781274565e-11,  5.417903154093274e-12,  1.268160822735032e-13,  2.082147889729945e-15, -2.117680833384649e-17, -1.583388387615923e-18,
 -2.909621440494654e-20,  1.557761516718796e-24,  5.272550172060138e-01, -4.178218458596018e-03,  2.043042887001426e-05, -5.890042015200326e-08, -1.363884386851906e-10,
  8.451055922309767e-12,  1.678049737594086e-13,  2.769196169379792e-15, -2.761888385749918e-17, -2.132235580117625e-18, -3.929263315033951e-20, -2.882566915121280e-24,
  6.545839118093209e-01, -5.094752760635812e-03,  2.253189745819986e-05, -3.496295418458853e-08, -4.891970076112242e-10,  1.235657429205968e-11,  2.289751322239180e-13,
  3.584479352506486e-15, -3.524035958333789e-17, -2.854281413962185e-18, -5.288426933193778e-20, -1.183289683628109e-23,  8.001123627111001e-01, -6.075476053910677e-03,
  2.292288011582928e-05,  1.719767097651062e-08, -1.033136445714937e-09,  1.651653566913671e-11,  3.323825765418893e-13,  4.526003450852537e-15, -4.480945199681987e-17,
 -3.822857895383419e-18, -7.175758576104055e-20, -2.893109237766717e-23,  9.662524636792399e-01, -7.080321406514775e-03,  1.998694209343432e-05,  1.143379016248941e-07,
 -1.747221084141260e-09,  1.838727696391867e-11,  5.260187447698899e-13,  5.713688942102397e-15, -6.063948501041812e-17, -5.148517630028109e-18, -9.954436481822226e-20,
 -6.522243140521526e-23,  1.156186523294563e+00, -8.016142313662846e-03,  1.060798572577857e-05,  2.789008998579756e-07, -2.300046597727028e-09,  9.613836395621219e-12,
  8.955389062596331e-13,  8.329534688054252e-15, -1.028851822592175e-16, -7.071249036331199e-18, -1.424760665338678e-19, -1.701003989201101e-22,  1.373887587835356e+00,
 -8.645045193462970e-03, -1.159349191340493e-05,  5.148874622148301e-07, -9.490627652831386e-10, -3.197733658901123e-11,  1.377712103763620e-12,  2.036024446236121e-14,
 -2.214213414794266e-16, -1.143551038893335e-17, -2.042090817979104e-19, -3.892878174491838e-22,  1.622389449198189e+00, -8.260991979151769e-03, -5.857337480153905e-05,
  5.729569862346421e-07,  9.554919492929688e-09, -7.641383737543340e-11, -4.989870808898199e-13,  5.819638413201242e-14,  3.637171867705709e-16, -3.002095567579869e-17,
 -5.892364285259114e-19,  2.311718530245901e-21,  1.885413689340542e+00, -4.564819760809742e-03, -1.069675835747948e-04, -1.394708723061361e-06,  4.435570230154944e-09,
  6.841368204673242e-10,  1.472628992292332e-11,  3.766991354293091e-14, -6.332567308532919e-15, -1.792434602653690e-16, -1.352839922396537e-18,  5.669959783129428e-20,
  1.325832597540963e-03, -1.088894697800671e-05,  6.627728822304534e-08, -3.699907290643199e-10,  2.250023554073780e-12,  1.255466757371688e-14,  5.244003489877394e-16,
  2.936418953889305e-19, -2.630437526969715e-19, -6.764412670552617e-21, -2.607769643473318e-23,  2.652448799140909e-24,  1.194807673624878e-02, -9.806064565411893e-05,
  5.950556172649026e-07, -3.302061288603244e-09,  1.994858214285222e-11,  1.169745424664653e-13,  4.722736264421908e-15,  2.845159050000735e-18, -2.382295705436004e-18,
 -6.124612808478218e-20, -2.366251136271911e-22,  2.400882733005184e-23,  3.327640852326066e-02, -2.727223768982176e-04,  1.644695713438198e-06, -9.013992101224045e-09,
  5.370436888795300e-11,  3.473745457001151e-13,  1.313851392048651e-14,  9.024035250544266e-18, -6.701583066307810e-18, -1.722074314070911e-19, -6.682181384064455e-22,
  6.746554667916214e-23,  6.548210708170923e-02, -5.354985934088686e-04,  3.198176598645837e-06, -1.718312987871516e-08,  1.000733363847246e-10,  7.484308646274659e-13,
  2.582257612133879e-14,  2.095766715320270e-17, -1.338894966433957e-17, -3.438630762282857e-19, -1.342994643247296e-21,  1.345827207638624e-22,  1.088314387473935e-01,
 -8.872900933979091e-04,  5.226743389132865e-06, -2.727641796124049e-08,  1.534637230374286e-10,  1.391122782143251e-12,  4.288855292307576e-14,  4.173851005068194e-17,
 -2.271365673100096e-17, -5.831289148394448e-19, -2.297273640114687e-21,  2.278955037058626e-22,  1.636979706680021e-01, -1.329213812738926e-03,  7.685244053682413e-06,
 -3.848068953187297e-08,  2.055604862359725e-10,  2.377629719080568e-12,  6.457707576364263e-14,  7.517771291932229e-17, -3.506994531883625e-17, -9.004790973722554e-19,
 -3.586124011032098e-21,  3.511938940051638e-22,  2.305810386124816e-01, -1.862486175177399e-03,  1.050429096678793e-05, -4.958819045835959e-08,  2.444443412408024e-10,
  3.847777543173920e-12,  9.138543093826990e-14,  1.251850659324062e-16, -5.101511792496672e-17, -1.311383394960146e-18, -5.291255324379635e-21,  5.099907558173546e-22,
  3.101326378368323e-01, -2.488198482676777e-03,  1.357710574730739e-05, -5.881030078994046e-08,  2.533069907625615e-10,  5.985916970597623e-12,  1.243329271910589e-13,
  1.943223134558327e-16, -7.133081544515980e-17, -1.838709374375883e-18, -7.534915208266232e-21,  7.123084837236140e-22,  4.031963905380340e-01, -3.206879754563296e-03,
  1.673694319330024e-05, -6.347064856801420e-08,  2.086827922011801e-10,  9.024041949384027e-12,  1.655196159553557e-13,  2.805886211665039e-16, -9.712668052633324e-17,
 -2.516808962047796e-18, -1.050566616090369e-20,  9.700463552188693e-22,  5.108645203020340e-01, -4.017624958103041e-03,  1.971688255635870e-05, -5.948809546681921e-08,
  7.833063841227483e-11,  1.322747780000196e-11,  2.193467782014625e-13,  3.705825223657954e-16, -1.300344562950485e-16, -3.398658025442264e-18, -1.450983420790239e-20,
  1.301486671696052e-21,  6.345625934861934e-01, -4.916287987041260e-03,  2.207458640723515e-05, -4.048399602344037e-08, -1.800954487779105e-10,  1.881976776687459e-11,
  2.952974204863163e-13,  4.260619583798175e-16, -1.726355330518246e-16, -4.568687154141421e-18, -2.008326907112544e-20,  1.736211015357857e-21,  7.761781717616872e-01,
 -5.891520420983153e-03,  2.304248273795453e-05,  3.781912878123081e-09, -6.142167406746198e-10,  2.570592998260515e-11,  4.145282750225984e-13,  3.640083023553052e-16,
 -2.296282465115486e-16, -6.166465969986277e-18, -2.825248879202652e-20,  2.325500510744493e-21,  9.382590306364436e-01, -6.915380243944823e-03,  2.120575499812338e-05,
  9.005824703810044e-08, -1.242230777156804e-09,  3.251411224935379e-11,  6.256588336597012e-13,  7.497835782907383e-17, -3.118277769762411e-16, -8.433112554389107e-18,
 -4.113382600683622e-20,  3.165758019065523e-21,  1.124312024319436e+00, -7.918494242444203e-03,  1.374431314757900e-05,  2.448753601777114e-07, -1.877011407355061e-09,
  3.325959665205458e-11,  1.036759096667964e-12, -9.154177481012504e-17, -4.525600308404723e-16, -1.184566508795800e-17, -6.257129848434108e-20,  4.452273772194712e-21,
  1.339160629900281e+00, -8.713372724051396e-03, -5.520754786937991e-06,  4.965566241045219e-07, -1.217737127043108e-09,  6.692114471524520e-12,  1.775703205841629e-12,
  5.166441095203267e-15, -7.702716657504350e-16, -1.832159729690443e-17, -8.851454384008764e-20,  6.696719605998226e-21,  1.588455366057034e+00, -8.699595683056114e-03,
 -5.083161979895050e-05,  7.135221746490969e-07,  8.040869220992713e-09, -6.867289415629885e-11,  1.100719814146526e-12,  4.840327599746204e-14, -1.084086291931695e-15,
 -4.783840234656881e-17, -1.932877214087274e-19,  1.719123633206117e-20,  1.865340162386333e+00, -5.485135490085604e-03, -1.227647230232989e-04, -1.195206808751955e-06,
  2.159354110921435e-08,  1.021147394283043e-09,  1.193743586549415e-11, -2.718042173784347e-13, -1.285458873155847e-14, -1.497310164488231e-16,  3.693851788078127e-18,
  1.725454741045866e-19,  1.283310021632548e-03, -1.037585276070803e-05,  6.206386299411435e-08, -3.313150040293278e-10,  2.621763844276457e-12,  2.406241213100041e-14,
  3.783752957506795e-16, -1.192815417669072e-17, -4.873250270429045e-19, -4.389873156215683e-21,  1.706207563221515e-22,  6.092093114502631e-24,  1.156511203123259e-02,
 -9.345305641751268e-05,  5.574427413067742e-07, -2.958163751040340e-09,  2.337477538580877e-11,  2.206211933528602e-13,  3.405498841482452e-15, -1.078382824588895e-16,
 -4.413383111724734e-18, -3.976889501757132e-20,  1.544395086135929e-21,  5.517466458541600e-23,  3.221117054062699e-02, -2.599822375054981e-04,  1.541967215894754e-06,
 -8.082433548926370e-09,  6.367590245712178e-11,  6.357595221524395e-13,  9.461864440938246e-15, -3.023152110242345e-16, -1.241476388529807e-17, -1.119465060694521e-19,
  4.339882772500194e-21,  1.552236351027856e-22,  6.339001781577634e-02, -5.107093975827120e-04,  3.002187245652793e-06, -1.542935388234307e-08,  1.209879040056725e-10,
  1.315338771579824e-12,  1.855955702247902e-14, -6.010304151575663e-16, -2.480408203876475e-17, -2.239261526863708e-19,  8.657774413288034e-21,  3.102042643960216e-22,
  1.053638954300985e-01, -8.467411992547142e-04,  4.915255175671305e-06, -2.454382248828799e-08,  1.911668654546457e-10,  2.332897375686782e-12,  3.074034566384107e-14,
 -1.013483364614949e-15, -4.208810228155107e-17, -3.806598046386339e-19,  1.466210473285652e-20,  5.265997836909483e-22,  1.585012391704027e-01, -1.269518866917649e-03,
  7.245047214790366e-06, -3.472904464088250e-08,  2.679988580690818e-10,  3.795891283436921e-12,  4.611764414324754e-14, -1.554504751317853e-15, -6.502138364080716e-17,
 -5.896974406533827e-19,  2.259888724572939e-20,  8.141843242822781e-22,  2.232954964064954e-01, -1.780758978405559e-03,  9.935618921169821e-06, -4.494495989781570e-08,
  3.424766960539408e-10,  5.854857178396919e-12,  6.496383210083204e-14, -2.246929442884913e-15, -9.469463650440414e-17, -8.622853389493407e-19,  3.282717058369961e-20,
  1.187323689596366e-21,  3.003927185933336e-01, -2.382325492101463e-03,  1.290016765617239e-05, -5.364109214400946e-08,  4.017116497773459e-10,  8.715870410970976e-12,
  8.789440725438082e-14, -3.126403230842780e-15, -1.326804509121570e-16, -1.215221734768879e-18,  4.587079436892742e-20,  1.667173799756332e-21,  3.906319388076261e-01,
 -3.075958935764986e-03,  1.600197370795643e-05, -5.847676834280878e-08,  4.273517545572292e-10,  1.265547836336036e-11,  1.162676078421716e-13, -4.250307953770556e-15,
 -1.812817120794075e-16, -1.674056882869171e-18,  6.250690094138238e-20,  2.285516084209560e-21,  4.951050283975130e-01, -3.862702078153360e-03,  1.902018789309051e-05,
 -5.583877332199628e-08,  3.934501967927105e-10,  1.803243586925910e-11,  1.530866287497611e-13, -5.715028126816894e-15, -2.439814377364837e-16, -2.278777331562231e-18,
  8.392396933769908e-20,  3.091798212340521e-21,  6.152475298087244e-01, -4.741652438061242e-03,  2.158513742942954e-05, -3.997843332310023e-08,  2.642606039308905e-10,
  2.527281739400005e-11,  2.051398486528265e-13, -7.690752511420664e-15, -3.263374937115567e-16, -3.094212246988043e-18,  1.120213697217139e-19,  4.166977418159746e-21,
  7.529808772442480e-01, -5.707123562023980e-03,  2.304758547367313e-05, -1.406191469549140e-09, -4.956704733812002e-12,  3.473973072546435e-11,  2.883758882704919e-13,
 -1.049320190644375e-14, -4.380303300229351e-16, -4.229452895534032e-18,  1.500277882713244e-19,  5.653238974046759e-21,  9.109432408776242e-01, -6.741694664343789e-03,
  2.219124707489600e-05,  7.617745891469009e-08, -4.486533073264215e-10,  4.614396667670193e-11,  4.421460089264666e-13, -1.472180902382110e-14, -5.985927529887040e-16,
 -5.873839024990494e-18,  2.039771680188464e-19,  7.825125046827565e-21,  1.092875923663201e+00, -7.797237070784867e-03,  1.652887053685672e-05,  2.214812079243206e-07,
 -9.733602683397648e-10,  5.607502033065024e-11,  7.667133642337009e-13, -2.137429019213725e-14, -8.581657335253156e-16, -8.369006092782106e-18,  2.875057810920015e-19,
  1.128314022484076e-20,  1.304256110004656e+00, -8.734010039945252e-03,  3.329358007981522e-07,  4.804502505237326e-07, -6.630224190938282e-10,  4.764351677551780e-11,
  1.475530834204019e-12, -2.995035963870081e-14, -1.393150774222635e-15, -1.271543223106354e-17,  4.503615061142545e-19,  1.760169566190639e-20,  1.552900869278575e+00,
 -9.069905588368959e-03, -4.153706054330378e-05,  8.329934613069163e-07,  7.014293394463163e-09, -3.151364166329388e-11,  1.711116535646823e-12, -1.349867052207963e-14,
 -2.708759343850880e-15, -3.445805369313075e-17,  1.008309551386695e-18,  3.669606397430907e-20,  1.841354994917227e+00, -6.517112905417375e-03, -1.343190402552539e-04,
 -6.742346886475956e-07,  4.400863012040370e-08,  1.166268313413221e-09, -1.946767250845809e-12, -7.248504102390493e-13, -1.359534001291331e-14,  1.640042518815228e-16,
  1.186039402418754e-17,  1.486185169719949e-19,  1.242775510627509e-03, -9.894492774043345e-06,  5.835686218237523e-08, -2.851699563176483e-10,  3.157256992417315e-12,
  2.728787682350733e-14, -1.851593521243274e-16, -2.819114994451582e-17, -4.557988012690616e-19,  7.903737717986684e-21,  4.297564338058661e-22,  3.973994516509428e-24,
  1.120000351570759e-02, -8.912879051897307e-05,  5.243452265755437e-07, -2.545752716857470e-09,  2.827379424513318e-11,  2.493856265446433e-13, -1.692932061348663e-15,
 -2.551341970940106e-16, -4.128775820275593e-18,  7.154798286817138e-20,  3.892213827741092e-21,  3.603202833048962e-23,  3.119532460622712e-02, -2.480161079189107e-04,
  1.451540584839250e-06, -6.953278236511441e-09,  7.773394306751096e-11,  7.141905803637084e-13, -4.851670881343861e-15, -7.167294795721653e-16, -1.161938170307446e-17,
  2.010896199726300e-19,  1.095009682455301e-20,  1.016002933179154e-22,  6.139409184112145e-02, -4.873974785479780e-04,  2.829576687870527e-06, -1.326629354488353e-08,
  1.499015909764133e-10,  1.464754881407790e-12, -9.956772025500938e-15, -1.429243487786559e-15, -2.323119340407574e-17,  4.012515172586369e-19,  2.188339460619109e-20,
  2.037495191373201e-22,  1.020537877245198e-01, -8.085415169433988e-04,  4.640717673961535e-06, -2.108430334945014e-08,  2.420821139838921e-10,  2.570490218080763e-12,
 -1.747384279790365e-14, -2.419386731616205e-15, -3.945801087595214e-17,  6.797020003674678e-19,  3.715016061209468e-20,  3.475380091524407e-22,  1.535365559506890e-01,
 -1.213146518487472e-03,  6.856675642197279e-06, -2.979278759432743e-08,  3.501894364158312e-10,  4.133701557515566e-12, -2.806494198002437e-14, -3.727692336545062e-15,
 -6.103859587755264e-17,  1.047889898005699e-18,  5.744145937420772e-20,  5.406693482227398e-22,  2.163281583557723e-01, -1.703328913859328e-03,  9.433221918145660e-06,
 -3.847165166639899e-08,  4.682191816524363e-10,  6.299603447749033e-12, -4.261922667497551e-14, -5.414288796703774e-15, -8.904725343917077e-17,  1.522435296328930e-18,
  8.377374601876495e-20,  7.946081189621890e-22,  2.910659150228613e-01, -2.281575849102748e-03,  1.230105968255687e-05, -4.574331147553505e-08,  5.874399215406658e-10,
  9.271013128377278e-12, -6.227469631315074e-14, -7.568835388922856e-15, -1.250437793237551e-16,  2.127456551276544e-18,  1.176446505592536e-19,  1.126481398197423e-21,
  3.785798808108635e-01, -2.950613820592092e-03,  1.534998189818567e-05, -4.951541100210361e-08,  6.951808425022730e-10,  1.332890441606115e-11, -8.839016166340693e-14,
 -1.032820021117342e-14, -1.713290976050122e-16,  2.898604649175982e-18,  1.613036081287474e-19,  1.562421181941930e-21,  4.799544877910222e-01, -3.713085448529366e-03,
  1.840025345160993e-05, -4.652972425824657e-08,  7.731032124715848e-10,  1.885823865340468e-11, -1.223463210514650e-13, -1.390952087932556e-14, -2.314045965048622e-16,
  3.890494114643794e-18,  2.182451213696868e-19,  2.143732840411920e-21,  5.966233976566279e-01, -4.570778725083514e-03,  2.114805853276324e-05, -3.153449828405731e-08,
  7.951148517553081e-10,  2.636928173214419e-11, -1.648132325039256e-13, -1.867602989980618e-14, -3.108656891790858e-16,  5.191652496491533e-18,  2.941684177891157e-19,
  2.939040902305988e-21,  7.305211075378034e-01, -5.522757092566511e-03,  2.305403718209116e-05,  4.319212532304054e-09,  7.266578222716814e-10,  3.646440638332565e-11,
 -2.133561653493081e-13, -2.527795339799725e-14, -4.193594572513091e-16,  6.958565160665702e-18,  3.990131563775602e-19,  4.070249238265544e-21,  8.843372355242097e-01,
 -6.560557179320087e-03,  2.309414773374231e-05,  7.677769346283483e-08,  5.351974617460983e-10,  4.952278455387340e-11, -2.547045573540404e-13, -3.497674326079093e-14,
 -5.757229516710180e-16,  9.507556759718347e-18,  5.518258793537390e-19,  5.773857330309190e-21,  1.061968015154187e+00, -7.654549279308645e-03,  1.913275434092724e-05,
  2.156173418727615e-07,  2.668257784786635e-10,  6.401745175517990e-11, -2.397710659343384e-13, -5.041017433526653e-14, -8.256268507154009e-16,  1.362250854021027e-17,
  7.947733423967116e-19,  8.561934434908041e-21,  1.269361765479956e+00, -8.708382162667011e-03,  6.071360000823983e-06,  4.790093014941968e-07,  5.487974550584564e-10,
  6.769615994383613e-11, -2.195758376015179e-14, -7.676881445195078e-14, -1.327542357956893e-15,  2.179986749568472e-17,  1.250900420271618e-18,  1.365899769936814e-20,
  1.516022608378477e+00, -9.360345297505525e-03, -3.088213873897544e-05,  9.420952346918230e-07,  6.709862817542756e-09, -5.564028715722943e-12,  7.661277236362701e-15,
 -1.089532575517558e-13, -2.818199963808703e-15,  3.918966375982237e-17,  2.598354769793790e-18,  2.512932852872653e-20,  1.813105366912430e+00, -7.610339414838053e-03,
 -1.374442769456129e-04,  2.062866569567891e-07,  6.500458432660176e-08,  8.357936368837256e-10, -2.674271835705612e-11, -9.661186713863680e-13,  1.619730944266904e-15,
  6.744875831327882e-16,  1.054410773418993e-17, -2.738341054754651e-19,  1.204110839755176e-03, -9.440428789133150e-06,  5.525435236136495e-08, -2.308226865490016e-10,
  3.587686382414811e-12,  1.211039723650356e-14, -1.111184125748749e-15, -3.474951018665806e-17,  1.510263532370568e-19,  2.519225774116019e-20,  3.284857969403259e-22,
 -1.038776054158572e-23,  1.085169572305065e-02, -8.504818265118631e-05,  4.966607272551079e-07, -2.058333927015387e-09,  3.221357484224598e-11,  1.116020782602236e-13,
 -1.007498389027743e-14, -3.145704746715742e-16,  1.366330305090112e-18,  2.281639019787050e-19,  2.976721879063527e-21, -9.406500246310089e-23,  3.022598755955763e-02,
 -2.367153890501266e-04,  1.375994362734618e-06, -5.609053892474715e-09,  8.905051994867425e-11,  3.247586757521280e-13, -2.840646684812321e-14, -8.841569133976867e-16,
  3.835654541912051e-18,  6.419156142424514e-19,  8.384160072445263e-21, -2.645528349097112e-22,  5.948882721819000e-02, -4.653548047358550e-04,  2.685656080534392e-06,
 -1.066137606318622e-08,  1.732109546754581e-10,  6.812184268393327e-13, -5.695055004064906e-14, -1.764460984836020e-15,  7.640904450895865e-18,  1.282879275256945e-18,
  1.678494291691102e-20, -5.284482319019363e-22,  9.889236850650282e-02, -7.723583401193739e-04,  4.412500361173948e-06, -1.684770224909400e-08,  2.832085035055344e-10,
  1.228847074068861e-12, -9.707363575418563e-14, -2.989798193989978e-15,  1.291720579681046e-17,  2.177909095013973e-18,  2.856339848956239e-20, -8.965425637040350e-22,
  1.487915546607025e-01, -1.159622060433594e-03,  6.535284850454375e-06, -2.360381122374221e-08,  4.167409100999587e-10,  2.038352634195908e-12, -1.508012124248345e-13,
 -4.612038691916564e-15,  1.987110785407308e-17,  3.367461594566935e-18,  4.430193452938824e-20, -1.385118934851894e-21,  2.096630420346919e-01, -1.629573484301232e-03,
  9.020335963932716e-06, -3.008423586581782e-08,  5.703416683773675e-10,  3.210372458733918e-12, -2.210377339607917e-13, -6.707706873559039e-15,  2.881224801924423e-17,
  4.910934801602230e-18,  6.486171110408957e-20, -2.018143967253375e-21,  2.821331951105023e-01, -2.185190089192127e-03,  1.181417618134901e-05, -3.502106860705794e-08,
  7.388350747374929e-10,  4.885887305746457e-12, -3.119119246809237e-13, -9.390073682891050e-15,  4.020905403715386e-17,  6.895664068468344e-18,  9.151884994590342e-20,
 -2.830991758219855e-21,  3.670195541424568e-01, -2.829982632587037e-03,  1.483066616823117e-05, -3.648293357786669e-08,  9.144976869890794e-10,  7.260797804836980e-12,
 -4.293204040755329e-13, -1.283042855148270e-14,  5.479033354684901e-17,  9.452556607847053e-18,  1.262009824196411e-19, -3.876986688629110e-21,  4.653933462855211e-01,
 -3.567879646515582e-03,  1.792765112153581e-05, -3.144749278654008e-08,  1.085812162935516e-09,  1.060415305095466e-11, -5.817908023851086e-13, -1.729743057436378e-14,
  7.374020908313495e-17,  1.278467899180830e-17,  1.719170111870736e-19, -5.239530904992486e-21,  5.786766103181179e-01, -4.402853911095869e-03,  2.086215515312646e-05,
 -1.500346730297212e-08,  1.235821025190550e-09,  1.527248066340656e-11, -7.818548561733166e-13, -2.323488121857361e-14,  9.909542106237103e-17,  1.722333830506846e-17,
  2.335862622459157e-19, -7.056294392516721e-21,  7.087996202843925e-01, -5.337867495414917e-03,  2.319807771744383e-05,  2.123799342928960e-08,  1.340975834193306e-09,
  2.168136170685509e-11, -1.048171531029392e-12, -3.142862075963460e-14,  1.346079045509342e-16,  2.334906600525204e-17,  3.197658738908885e-19, -9.572450820413429e-21,
  8.584706481419617e-01, -6.371901764069769e-03,  2.409748019389559e-05,  9.256754735387967e-08,  1.376362307613588e-09,  3.005263699821890e-11, -1.408391485772387e-12,
 -4.340168222946281e-14,  1.877050698511704e-16,  3.228914400346833e-17,  4.466243790861668e-19, -1.327483650045091e-20,  1.031672554084526e+00, -7.490972334026597e-03,
  2.178559309099522e-05,  2.292911314823084e-07,  1.362633758646910e-09,  3.902447205863509e-11, -1.901018237262080e-12, -6.245144456519849e-14,  2.736415489569420e-16,
  4.660011079320576e-17,  6.484277755622388e-19, -1.930485304819431e-20,  1.234662124672030e+00, -8.636570787145892e-03,  1.191456551370123e-05,  4.977884562302594e-07,
  1.702931386488823e-09,  3.766453297745212e-11, -2.575161718995048e-12, -9.640335576362701e-14,  4.162797028266774e-16,  7.370407598222601e-17,  1.013007636808580e-18,
 -3.122733178689355e-20,  1.478161270654064e+00, -9.560370959606830e-03, -1.893971322064883e-05,  1.047376238505586e-06,  6.308906389169819e-09, -5.012509405823840e-11,
 -3.943493219793313e-12, -1.555044596678278e-13,  5.449322814247097e-16,  1.436152557653112e-16,  1.929595852426669e-18, -6.866398040742817e-20,  1.780506875982538e+00,
 -8.681310946208711e-03, -1.283139376656512e-04,  1.336432451554423e-06,  7.324470355746846e-08, -1.002124645224724e-10, -4.902312283783038e-11, -4.777997120640144e-13,
  2.911632581370864e-14,  6.987129028065638e-16, -1.238462512938670e-17, -6.705208888778415e-19,  1.167217039885447e-03, -9.008490177698455e-06,  5.283134179941418e-08,
 -1.732406072919495e-10,  3.491018595215153e-12, -2.478701244131256e-14, -1.868798044930231e-15, -1.407159103706050e-17,  1.138447447603486e-18,  2.433750541402882e-20,
 -4.632886779877423e-22, -2.237805409233983e-23,  1.051930559956486e-02, -8.116486463895608e-05,  4.750765800902437e-07, -1.541000674625482e-09,  3.137410791710082e-11,
 -2.227942506979708e-13, -1.693293299626450e-14, -1.273283783240727e-16,  1.031036307924472e-17,  2.204681419947584e-19, -4.196241515214899e-21, -2.027777729384414e-22,
  2.930075011955356e-02, -2.259522337901463e-04,  1.317307152156253e-06, -4.177203141299671e-09,  8.689134322576787e-11, -6.172483548846142e-13, -4.767991051722443e-14,
 -3.575692813057303e-16,  2.900475805497319e-17,  6.205230989821825e-19, -1.180738538409848e-20, -5.710775125781119e-22,  5.766963540540996e-02, -4.443337151633401e-04,
  2.574513427956435e-06, -7.870988855061593e-09,  1.695016505164841e-10, -1.204939906665006e-12, -9.540720120620373e-14, -7.126456682829452e-16,  5.796006414069378e-17,
  1.240910547554608e-18, -2.360296490428788e-20, -1.143108358674501e-21,  9.587236474088269e-02, -7.377890832704845e-04,  4.237843349135007e-06, -1.227297054392648e-08,
  2.782768128620506e-10, -1.980868781135913e-12, -1.622222298790248e-13, -1.205412495156101e-15,  9.838507839738886e-17,  2.108463321898278e-18, -4.008520732689257e-20,
 -1.944872363443788e-21,  1.442559993375591e-01, -1.108357797789902e-03,  6.292641034481275e-06, -1.684755293628668e-08,  4.117349890704344e-10, -2.938158907822411e-12,
 -2.512702134728112e-13, -1.855294789094146e-15,  1.521052595982864e-16,  3.263633806864224e-18, -6.201467260559733e-20, -3.015815761945020e-21,  2.032870097883407e-01,
 -1.558697001566760e-03,  8.715097989579936e-06, -2.079309968028719e-08,  5.675666201030225e-10, -4.068325586698419e-12, -3.671067988625272e-13, -2.690944946866490e-15,
  2.218093771346101e-16,  4.765843123863804e-18, -9.051619568562113e-20, -4.414368654298557e-21,  2.735790896308044e-01, -2.092152366240880e-03,  1.146652753873282e-05,
 -2.290834935600079e-08,  7.421898788241348e-10, -5.362684002791355e-12, -5.163033521427482e-13, -3.754777253681452e-15,  3.114670599839357e-16,  6.702451715162334e-18,
 -1.272602192657597e-19, -6.227363684808434e-21,  3.559345019990183e-01, -2.712832918587038e-03,  1.448332558321906e-05, -2.136336966970161e-08,  9.300292285860587e-10,
 -6.817032888792954e-12, -7.084475114386387e-13, -5.110962182135636e-15,  4.270579281672921e-16,  9.204233022091489e-18, -1.747843144534587e-19, -8.586558099244580e-21,
  4.514067111514407e-01, -3.425662164908342e-03,  1.765863466172655e-05, -1.329056000279894e-08,  1.122345439986282e-09, -8.445622483433395e-12, -9.578506986700638e-13,
 -6.860246781326148e-15,  5.779094534595434e-16,  1.247333216431011e-17, -2.370958548030154e-19, -1.169909093815957e-20,  5.613983444337570e-01, -4.236325147634350e-03,
  2.080695779382895e-05,  5.986801003151688e-09,  1.305385985287852e-09, -1.032244756103078e-11, -1.286588164677932e-12, -9.169278048728581e-15,  7.793209703970205e-16,
  1.683709939302897e-17, -3.208906598329929e-19, -1.590751761388162e-20,  6.878214791057350e-01, -5.150876042195158e-03,  2.359077618146635e-05,  4.451597868064281e-08,
  1.457812102549435e-09, -1.270923378021447e-11, -1.730194984278700e-12, -1.233337277187418e-14,  1.058174292598432e-15,  2.286087210460369e-17, -4.382789893960508e-19,
 -2.181899219471095e-20,  8.333762072377107e-01, -6.174272512561359e-03,  2.535323960984515e-05,  1.171749380812933e-07,  1.549365809371377e-09, -1.649204154083136e-11,
 -2.348977701203683e-12, -1.692309045291745e-14,  1.466348805986657e-15,  3.161284231579994e-17, -6.137780552527668e-19, -3.061763118807721e-20,  1.002075238105161e+00,
 -7.305270572955980e-03,  2.468409023650434e-05,  2.543027262200734e-07,  1.557414831747306e-09, -2.491821911144056e-11, -3.251974196979866e-12, -2.414801491265745e-14,
  2.117847988564290e-15,  4.539561653370463e-17, -9.060682955215385e-19, -4.495295958846405e-20,  1.200345003127957e+00, -8.516866117139785e-03,  1.806311988931751e-05,
  5.268464799796588e-07,  1.638470637026382e-09, -5.238031068036599e-11, -4.654029748055403e-12, -3.653171071690106e-14,  3.313112906232114e-15,  7.032216008411803e-17,
 -1.498132220691780e-18, -7.217471290074686e-20,  1.439698623554796e+00, -9.660015163775954e-03, -5.819101455207041e-06,  1.133776448639221e-06,  4.039092501958187e-09,
 -1.899232537643909e-10, -7.214498696946711e-12, -4.841103790698871e-14,  6.071030206739856e-15,  1.282730783445058e-16, -3.273040032781326e-18, -1.426592022732871e-19,
  1.743857562700120e+00, -9.624332765809695e-03, -1.055257782173029e-04,  2.425986237397750e-06,  5.901712713586471e-08, -1.313565197167447e-09, -4.657321393537964e-11,
  7.073622247265961e-13,  3.900843964854052e-14, -2.838782171927408e-16, -3.186964394059287e-17, -1.262617404860418e-20,  1.132016484874896e-03, -8.593259277221226e-06,
  5.106317072515678e-08, -1.238382959557900e-10,  2.538949671605746e-12, -6.961343285504793e-14, -1.657089804134518e-15,  3.101786882262579e-17,  1.468955694641825e-18,
 -1.054005942757699e-20, -1.125979186020905e-21, -1.460022761657188e-24,  1.020214166694272e-02, -7.743017138782084e-05,  4.593763957969020e-07, -1.097204748754962e-09,
  2.278378156529492e-11, -6.289218389552037e-13, -1.501226636016167e-14,  2.810432478147819e-16,  1.330407619243016e-17, -9.551396233154201e-20, -1.020189850471211e-20,
 -1.323261321433230e-23,  2.841773224130107e-02, -2.155919984818211e-04,  1.274909235468718e-06, -2.949170089425771e-09,  6.290622165302167e-11, -1.760608218091886e-12,
 -4.225801192896636e-14,  7.913494622191545e-16,  3.742900848252496e-17, -2.690306463344962e-19, -2.872493832573279e-20, -3.727732460476908e-23,  5.593295619921192e-02,
 -4.240719673332497e-04,  2.495126988623280e-06, -5.478731550137084e-09,  1.221158872764012e-10, -3.492141513691519e-12, -8.451638207213644e-14,  1.583528726390240e-15,
  7.480068445990768e-17, -5.386508190436596e-19, -5.747802302376620e-20, -7.462520866302097e-23,  9.298818227764903e-02, -7.044041613145816e-04,  4.115275409976953e-06,
 -8.353335488641442e-09,  1.990753268958480e-10, -5.868347405103403e-12, -1.436079563686205e-13,  2.692895135872046e-15,  1.269831532695634e-16, -9.168725823188248e-19,
 -9.774548184066198e-20, -1.269016075265355e-22,  1.399221194713297e-01, -1.058719998220251e-03,  6.126974570451002e-06, -1.106414892939458e-08,  2.916801101825662e-10,
 -8.956706148896505e-12, -2.222456891621194e-13,  4.172695790102614e-15,  1.963327310706336e-16, -1.422838575298578e-18, -1.514722597041524e-19, -1.964130954255800e-22,
  1.971902888710245e-01, -1.489829264772451e-03,  8.515799974081580e-06, -1.285114802122460e-08,  3.966891494537055e-10, -1.285642681501940e-11, -3.243509561912793e-13,
  6.101165442290577e-15,  2.863081301125158e-16, -2.085286527956196e-18, -2.215326568018923e-19, -2.862334260476171e-22,  2.653924722075953e-01, -2.001330483041418e-03,
  1.125711378910458e-05, -1.257767434188463e-08,  5.091052500845423e-10, -1.771416738363367e-11, -4.555646299887898e-13,  8.593367399567860e-15,  4.019908721378205e-16,
 -2.947705681584918e-18, -3.121857327551251e-19, -4.002067455184892e-22,  3.453136156807564e-01, -2.597755268514600e-03,  1.430869749831073e-05, -8.515009482947884e-09,
  6.211171097615547e-10, -2.375238893335446e-11, -6.240865604503986e-13,  1.182164497891876e-14,  5.509836353759100e-16, -4.077701050216053e-18, -4.298710118641055e-19,
 -5.426171890528322e-22,  4.379859942022935e-01, -3.284746864373685e-03,  1.759719502488150e-05,  2.043396926765115e-09,  7.202347022562934e-10, -3.132374405556191e-11,
 -8.420948524272930e-13,  1.605264746575181e-14,  7.450342910539203e-16, -5.585012628979487e-18, -5.846685721146874e-19, -7.167519341233263e-22,  5.447868767581570e-01,
 -4.069253849868128e-03,  2.099176603787234e-05,  2.351312504736425e-08,  7.858727118675631e-10, -4.102436228396394e-11, -1.128235164377578e-12,  2.171884366188262e-14,
  1.003160998287204e-15, -7.658957935425296e-18, -7.931619118381538e-19, -9.198619727153572e-22,  6.675993260922396e-01, -4.959650791242233e-03,  2.424908453166271e-05,
  6.351094170026251e-08,  7.828256567545169e-10, -5.395660334128068e-11, -1.512160187763204e-12,  2.956912980338823e-14,  1.358172221364534e-15, -1.065439997865114e-17,
 -1.084561313158134e-18, -1.125735394253848e-21,  8.090942106875606e-01, -5.965446111697510e-03,  2.688708567692921e-05,  1.362085875692796e-07,  6.484346423135764e-10,
 -7.243162021832054e-11, -2.043029608879638e-12,  4.102612455343049e-14,  1.871768214642401e-15, -1.531691662105365e-17, -1.515406149637192e-18, -1.219608214574446e-21,
  9.732689410120839e-01, -7.095233653901505e-03,  2.785479180034058e-05,  2.709179129002726e-07,  2.685873604401653e-10, -1.022527345726220e-10, -2.804659187322580e-12,
  5.919735523424108e-14,  2.674605002732264e-15, -2.348961581841851e-17, -2.210977535244236e-18, -7.133256663636076e-22,  1.166607062484672e+00, -8.346746672822649e-03,
  2.448796475873950e-05,  5.385047866398824e-07, -5.390949000723615e-10, -1.625917315487267e-10, -3.928214672876134e-12,  9.273571189245970e-14,  4.092060458818073e-15,
 -4.101575672569077e-17, -3.512609862339729e-18,  2.891080389706271e-21,  1.401052717000608e+00, -9.651398404920245e-03,  8.017933963155647e-06,  1.158584091735316e-06,
 -1.473292358267948e-09, -3.543020597872438e-10, -5.400722901540886e-12,  1.836413245089102e-13,  7.063871666837774e-15, -9.714213443268445e-17, -6.715646824725874e-18,
  2.949064287243174e-20,  1.703875779540648e+00, -1.033838712049519e-02, -7.178790243727275e-05,  3.108425294720631e-06,  2.383049026602894e-08, -2.070467694140076e-09,
 -1.248373933438836e-11,  1.566140669033533e-12,  8.900078183521053e-15, -1.225263687731381e-15, -7.744422049613245e-18,  9.693062616585531e-19,  };
  constexpr double w[6528] = {  1.789953244950015e-01, -1.446170682553805e-03,  1.278756405960936e-05, -1.187028412022730e-07,  1.122563970133637e-09,
 -1.063932792680963e-11,  1.002683962079018e-13, -9.367874833357893e-16,  8.668385374054127e-18, -7.945392866285748e-20,  7.217113072401306e-22, -6.500057463956412e-24,
  1.748809514102090e-01, -2.715773765940973e-03,  4.605621030227956e-05, -7.277674728721081e-07,  1.076837937793378e-08, -1.513718357253331e-10,  2.041940392252876e-12,
 -2.661206926044938e-14,  3.366964407836813e-16, -4.150384134850675e-18,  4.998586613254055e-20, -5.894323607433529e-22,  1.670375204482480e-01, -5.047321615460571e-03,
  1.327581621688897e-04, -2.995762203547541e-06,  6.090630263338000e-08, -1.144878432548123e-09,  2.021161105875282e-11, -3.386651569548645e-13,  5.426951906733881e-15,
 -8.364091754625011e-17,  1.245268543268598e-18, -1.796871504496005e-20,  1.561595492179963e-01, -8.073768211582906e-03,  3.026929211747105e-04, -9.251433306923238e-06,
  2.465110810147059e-07, -5.926811618095609e-09,  1.313076359062528e-10, -2.718656050496500e-12,  5.313295558935598e-14, -9.875463428641651e-16,  1.755616730795622e-17,
 -2.998068602386393e-19,  1.431218748819971e-01, -1.134904349992354e-02,  5.792250102454148e-04, -2.309031622775180e-05,  7.795428064530392e-07, -2.324550714167513e-08,
  6.281204383307251e-10, -1.564467866602839e-11,  3.635603415857098e-13, -7.954035361005011e-15,  1.649730686415042e-16, -3.260524339623145e-18,  1.288348258285101e-01,
 -1.443537947168811e-02,  9.649405117346683e-04, -4.861238349129725e-05,  2.023595504891244e-06, -7.303830574175410e-08,  2.353802260083636e-09, -6.907000853505231e-11,
  1.871360865121914e-12, -4.730143400078692e-14,  1.124362608258607e-15, -2.528183181662191e-17,  1.141193660644252e-01, -1.697390367417280e-02,  1.434882839061072e-03,
 -8.885293209512334e-05,  4.454186909440032e-06, -1.905579057390809e-07,  7.185798766435546e-09, -2.440693444332378e-10,  7.583042185434768e-12, -2.180038034085476e-13,
  5.851037953824843e-15, -1.475621734102940e-16,  9.962545407262392e-02, -1.872443103927396e-02,  1.939319214017349e-03, -1.439494473643164e-04,  8.506676042509580e-06,
 -4.233039996142737e-07,  1.836092172532147e-08, -7.105498508955949e-10,  2.494526025041449e-11, -8.044309588465518e-13,  2.405951297312618e-14, -6.720939201377442e-16,
  8.579968662447025e-02, -1.957265657562682e-02,  2.413940277998076e-03, -2.098884410392224e-04,  1.433573899950472e-05, -8.153573945213990e-07,  4.004029498161163e-08,
 -1.739884708663825e-09,  6.808908124862654e-11, -2.431763110079279e-12,  8.007898911389271e-14, -2.449601686494585e-15,  7.289402849823311e-02, -1.951248762617094e-02,
  2.793109643332635e-03, -2.784834414431382e-04,  2.158147950378894e-05, -1.380004165940918e-06,  7.558349461249657e-08, -3.637299748701519e-09,  1.566482165246090e-10,
 -6.121947149793079e-12,  2.194643339225722e-13, -7.272983193791169e-15,  6.100012544491399e-02, -1.861538054297577e-02,  3.021800368891780e-03, -3.387023491969994e-04,
  2.926588588048144e-05, -2.071110594343895e-06,  1.247131102725177e-07, -6.559014301155646e-09,  3.070572232093015e-10, -1.298041489564820e-11,  5.010938978100570e-13,
 -1.780645848849805e-14,  5.009336011844092e-02, -1.699766931939347e-02,  3.063474422514059e-03, -3.789225425146258e-04,  3.590363750485375e-05, -2.769894219316300e-06,
  1.808457752047617e-07, -1.026189536015376e-08,  5.159874506085159e-10, -2.333121464639029e-11,  9.597002843807532e-13, -3.620540898749427e-14,  4.007485718184486e-02,
 -1.479319123446048e-02,  2.903195799189313e-03, -3.894092095125040e-04,  3.982303678394348e-05, -3.300679556480231e-06,  2.305274602563154e-07, -1.393738825658567e-08,
  7.439212120997594e-10, -3.558540310859593e-11,  1.543606268168543e-12, -6.122226604378687e-14,  3.080500782594133e-02, -1.213437342462958e-02,  2.546799750457677e-03,
 -3.643488061453589e-04,  3.960418248635977e-05, -3.476925435095537e-06,  2.563631996240802e-07, -1.631162892727451e-08,  9.136001711480185e-10, -4.573296541001782e-11,
  2.070693468648447e-12, -8.551355796943530e-14,  2.212664721901935e-02, -9.141835053289917e-03,  2.017626488372380e-03, -3.030183487753236e-04,  3.449477014001517e-05,
 -3.163571776214615e-06,  2.430784981447056e-07, -1.608003449442383e-08,  9.343136728794410e-10, -4.841931567865076e-11,  2.265264307758306e-12, -9.647857996464380e-14,
  1.387922062370980e-02, -5.921051420344077e-03,  1.352322415073636e-03, -2.099750030558789e-04,  2.467393719094274e-05, -2.331993623030667e-06,  1.843520027599210e-07,
 -1.252725211551639e-08,  7.465862979744791e-10, -3.962887882199347e-11,  1.896447490407442e-12, -8.251143448991868e-14,  5.914191264856602e-03, -2.567508176255871e-03,
  5.975522391953806e-04, -9.450308428771103e-05,  1.130169856445361e-05, -1.086100138047290e-06,  8.722466757710537e-08, -6.016187397109351e-09,  3.636323093496794e-10,
 -1.956018449691736e-11,  9.478974719897157e-13, -4.173293592382226e-14,  1.734066321358335e-01, -1.349277933457215e-03,  1.146427460329231e-05, -1.023217464418737e-07,
  9.318686553952167e-10, -8.518758887368982e-12,  7.752848694943533e-14, -7.001069818648693e-16,  6.265569385503123e-18, -5.557197409453631e-20,  4.886334340123573e-22,
 -4.261526933200829e-24,  1.647032974489751e-01, -2.379541883485964e-03,  3.826484168603848e-05, -5.772632909511372e-07,  8.176405003348308e-09, -1.102148468184354e-10,
  1.427663960145957e-12, -1.788801879042764e-14,  2.178032641432046e-16, -2.586085186213110e-18,  3.002434431898340e-20, -3.415428441722602e-22,  1.487659780917115e-01,
 -4.114070059014118e-03,  1.019777439228157e-04, -2.180989542279252e-06,  4.218217940882458e-08, -7.564406386714734e-10,  1.276812320747419e-11, -2.049234152558416e-13,
  3.150170307031981e-15, -4.663667755011348e-17,  6.677439570868962e-19, -9.276065658480018e-21,  1.280884968979181e-01, -6.037254726817672e-03,  2.119205055628388e-04,
 -6.107123418820088e-06,  1.541921121005023e-07, -3.525341879758301e-09,  7.447926861091081e-11, -1.473854373402756e-12,  2.758391479560666e-14, -4.917749826399386e-16,
  8.398404446699499e-18, -1.379590621481295e-19,  1.054971011493289e-01, -7.642208599531308e-03,  3.639318714751186e-04, -1.364611966794809e-05,  4.357168421866939e-07,
 -1.233774047595071e-08,  3.175757723043590e-10, -7.554594301337543e-12,  1.680438097559513e-13, -3.525905758828468e-15,  7.025429975227711e-17, -1.335975135953512e-18,
  8.349016239864836e-02, -8.592740426908951e-03,  5.360521324088420e-04, -2.540491026596617e-05,  1.000364544470449e-06, -3.429735691767894e-08,  1.053428636777297e-09,
 -2.954307139074436e-11,  7.668063251202552e-13, -1.860649777285562e-14,  4.253611149846703e-16, -9.214084204772804e-18,  6.382226140789025e-02, -8.786825071470765e-03,
  6.954982054239941e-04, -4.061432959341220e-05,  1.930017958508957e-06, -7.858977040639347e-08,  2.830072686022031e-09, -9.205141174416459e-11,  2.745365895393216e-12,
 -7.592384483888324e-14,  1.963913082022128e-15, -4.781804949595983e-17,  4.739659248364247e-02, -8.321513915347464e-03,  8.115315125656887e-04, -5.705748169550027e-05,
  3.208576014409160e-06, -1.525012390236593e-07,  6.337747799232965e-09, -2.356187431948843e-10,  7.964987316179014e-12, -2.478326356370634e-13,  7.165179763930104e-15,
 -1.938112430362814e-16,  3.439643035072039e-02, -7.403856733725184e-03,  8.660197082144458e-04, -7.174943698678264e-05,  4.687773960895143e-06, -2.558738394423376e-07,
  1.209246166706938e-08, -5.069057652609062e-10,  1.917779328582239e-11, -6.634096483875603e-13,  2.119636760629770e-14, -6.301046495697298e-16,  2.452830051870944e-02,
 -6.259968202076837e-03,  8.568229309763513e-04, -8.197211423301672e-05,  6.114559205386258e-06, -3.773625044755656e-07,  1.999534453750884e-08, -9.328526990614883e-10,
  3.902125514605116e-11, -1.483662795613971e-12,  5.182496980934793e-14, -1.675852989475124e-15,  1.726466751540292e-02, -5.074515353419087e-03,  7.944223307016989e-04,
 -8.608737007789680e-05,  7.208584935925830e-06, -4.954384414347195e-07,  2.902880928439534e-08, -1.488102790639962e-09,  6.800859345835617e-11, -2.810561737021611e-12,
  1.062037173131195e-13, -3.698618535641321e-15,  1.202435535268026e-02, -3.967140399309757e-03,  6.953872983111001e-04, -8.379086089991982e-05,  7.747492765529597e-06,
 -5.841948354867682e-07,  3.733449224568910e-08, -2.076419680179481e-09,  1.024564235284568e-10, -4.551255508603446e-12,  1.841045780406831e-13, -6.836873101126458e-15,
  8.277035617951466e-03, -2.995804161452471e-03,  5.763075012887579e-04, -7.584806462856897e-05,  7.619602393912069e-06, -6.210767139241608e-07,  4.270318678341322e-08,
 -2.544084278006519e-09,  1.339284596164111e-10, -6.323630039794855e-12,  2.709598554780121e-13, -1.062339660788997e-14,  5.586167820557395e-03, -2.172740334793155e-03,
  4.500731146205998e-04, -6.358331507584704e-05,  6.829841194151981e-06, -5.929471015608651e-07,  4.326326551529917e-08, -2.725691237146043e-09,  1.512530870779623e-10,
 -7.505516510944186e-12,  3.370445766180152e-13, -1.381135826822053e-14,  3.613092651892865e-03, -1.482079390395264e-03,  3.246224584882150e-04, -4.839720852942495e-05,
  5.471189859301905e-06, -4.984859850488695e-07,  3.806557878192291e-08, -2.503446008248985e-09,  1.446618596484321e-10, -7.458044062020640e-12,  3.472127677678056e-13,
 -1.471974448471617e-14,  2.101795869295977e-03, -8.936350068979020e-04,  2.033616342762563e-04, -3.146476020837192e-05,  3.684952131164881e-06, -3.471610665874288e-07,
  2.736114613226779e-08, -1.853933951335357e-09,  1.101883786542507e-10, -5.833728233064986e-12,  2.784910509810628e-13, -1.208862728246575e-14,  8.579915703097403e-04,
 -3.720166834279465e-04,  8.646430003472907e-05, -1.365597586357744e-05,  1.630998639425593e-06, -1.565428500970331e-07,  1.255674358493011e-08, -8.650750870903892e-10,
  5.222870843062056e-11, -2.806421213544266e-12,  1.358601631829994e-13, -5.975560332015178e-15,  1.681855138978149e-01, -1.262234035390736e-03,  1.032056085730371e-05,
 -8.868003205403053e-08,  7.786221820278326e-10, -6.872377066035540e-12,  6.045662457856393e-14, -5.281838079114501e-16,  4.575947880963530e-18, -3.930938921900205e-20,
  3.348827284375278e-22, -2.830707616635028e-24,  1.557564285103137e-01, -2.099064028705297e-03,  3.205547228486279e-05, -4.623706628241807e-07,  6.277910654044688e-09,
 -8.125211871282288e-11,  1.011876263733253e-12, -1.220257471837436e-14,  1.431386039499623e-16, -1.638711226532574e-18,  1.835792070580637e-20, -2.016416638939710e-22,
  1.337903939707804e-01, -3.392512588143506e-03,  7.940516326231011e-05, -1.612219677105051e-06,  2.970585000989771e-08, -5.088539328898436e-10,  8.221746244230026e-12,
 -1.265294286460237e-13,  1.867775437925730e-15, -2.658596630318267e-17,  3.663948938384865e-19, -4.904046104785053e-21,  1.069189274883394e-01, -4.597882919352568e-03,
  1.513909087385627e-04, -4.119408815085085e-06,  9.867125367322777e-08, -2.147614682783638e-09,  4.330902894258779e-11, -8.198472299267413e-13,  1.470515760240691e-14,
 -2.516567737675264e-16,  4.131230277869326e-18, -6.531751056959340e-20,  7.985966318900263e-02, -5.283632606377726e-03,  2.350326581168992e-04, -8.296889287743724e-06,
  2.507515375338611e-07, -6.747023671565183e-09,  1.655381272956324e-10, -3.762992316349932e-12,  8.015791764876246e-14, -1.613629181413835e-15,  3.089789444631023e-17,
 -5.654931529370579e-19,  5.609042192275187e-02, -5.296085352374007e-03,  3.083780109218182e-04, -1.375126018684094e-05,  5.123122065184406e-07, -1.668733128383922e-08,
  4.885542624133713e-10, -1.309577562096949e-11,  3.256424907107516e-13, -7.585456106415654e-15,  1.667700852899089e-16, -3.479926084355455e-18,  3.732552251335116e-02,
 -4.746565827089076e-03,  3.514672641791358e-04, -1.934344642381335e-05,  8.709452570228451e-07, -3.374058050573940e-08,  1.159808480582686e-09, -3.611050491147074e-11,
  1.033380387279332e-12, -2.747948887507959e-14,  6.847561805166907e-16, -1.608921347128514e-17,  2.374134642254695e-02, -3.882743774135601e-03,  3.559067056734647e-04,
 -2.366994961141604e-05,  1.265159239571446e-06, -5.737546325464576e-08,  2.282403089964874e-09, -8.144224106855350e-11,  2.648684758429120e-12, -7.945321266262869e-14,
  2.218679011995563e-15, -5.806377734827804e-17,  1.457659033646559e-02, -2.950801044096763e-03,  3.265541746979057e-04, -2.572866327066281e-05,  1.605235754784575e-06,
 -8.395809869961561e-08,  3.813107383934848e-09, -1.539962727589593e-10,  5.625457228407645e-12, -1.882645321331506e-13,  5.829625996915563e-15, -1.682267353399944e-16,
  8.729224175628022e-03, -2.116689319031259e-03,  2.762605216359679e-04, -2.530088527763756e-05,  1.812804989450178e-06, -1.077771215614683e-07,  5.515383120737087e-09,
 -2.490585924613989e-10,  1.010382309344294e-11, -3.732342129536394e-13,  1.268641960924336e-14, -3.997945800422828e-16,  5.151371501026773e-03, -1.453518351777514e-03,
  2.188369411988152e-04, -2.287050994015742e-05,  1.851818718258510e-06, -1.233586960306021e-07,  7.020131848284681e-09, -3.501797992861841e-10,  1.559866824031416e-11,
 -6.292686145738174e-13,  2.324321106403044e-14, -7.922625406853574e-16,  3.022768250088975e-03, -9.669074800425458e-04,  1.644158560771448e-04, -1.925520724363450e-05,
  1.733745854483004e-06, -1.275349261181614e-07,  7.963999301410064e-09, -4.334322710135068e-10,  2.095593470927330e-11, -9.132419941288162e-13,  3.628158029718719e-14,
 -1.324651179972012e-15,  1.773988497113149e-03, -6.281531057541354e-04,  1.182003221814911e-04, -1.523470690395475e-05,  1.500784848418572e-06, -1.201089390987046e-07,
  8.117855947915814e-09, -4.759143745253434e-10,  2.467816397656507e-11, -1.148788870416442e-12,  4.857045344704291e-14, -1.880475044867475e-15,  1.040260795664084e-03,
 -3.988955431152815e-04,  8.142766247574409e-05, -1.134375136876225e-05,  1.202549608508623e-06, -1.031190073155265e-07,  7.437112498602608e-09, -4.634815928789018e-10,
  2.545752167051082e-11, -1.251157453470916e-12,  5.567775454540142e-14, -2.262183844533385e-15,  5.997498736964767e-04, -2.440280341762771e-04,  5.299614062720439e-05,
 -7.836483726286624e-06,  8.790399545236339e-07, -7.950626325988404e-08,  6.029626322051122e-09, -3.939875673504027e-10,  2.262817072234877e-11, -1.159910825874760e-12,
  5.370834860533274e-14, -2.265325333792526e-15,  3.208855518157322e-04, -1.359174184842072e-04,  3.080517509937853e-05, -4.747539700182661e-06,  5.539182852351511e-07,
 -5.199958120002584e-08,  4.084525125667034e-09, -2.758794813105975e-10,  1.634757960978723e-11, -8.630307210715322e-13,  4.108837352448904e-14, -1.779001133983469e-15,
  1.248528088310685e-04, -5.406162980219187e-05,  1.254639755558499e-05, -1.978644454834372e-06,  2.359834494568615e-07, -2.261868760505257e-08,  1.811928648080859e-09,
 -1.246725535630675e-10,  7.517984739746014e-12, -4.034977727863182e-13,  1.951176136407813e-14, -8.572730805847700e-16,  1.632952528823356e-01, -1.183724362472552e-03,
  9.326854744760662e-06, -7.724756853448295e-08,  6.545665945010619e-10, -5.583562047702744e-12,  4.752187365058946e-14, -4.020353440385951e-16,  3.374712350728691e-18,
 -2.810317175545462e-20,  2.321593883999345e-22, -1.903643720090411e-24,  1.478401778079859e-01, -1.863221922353148e-03,  2.706005509484529e-05, -3.737124527302243e-07,
  4.870503965375289e-09, -6.059940560075329e-11,  7.263798016195536e-13, -8.439990838787210e-15,  9.547557179935842e-17, -1.054936591098166e-18,  1.141407005491846e-20,
 -1.211625497708243e-22,  1.213787658333840e-01, -2.827287161993245e-03,  6.260615216453973e-05, -1.208715008709025e-06,  2.124651123747865e-08, -3.480847991049458e-10,
  5.389765327382248e-12, -7.961920247639812e-14,  1.129709935832771e-15, -1.547483434786789e-17,  2.054515212087267e-19, -2.651637652748205e-21,  9.067058039437735e-02,
 -3.560581356661570e-03,  1.101767187468904e-04, -2.834757437996821e-06,  6.449674617262548e-08, -1.337848778233982e-09,  2.577778256548710e-11, -4.672216499482545e-13,
  8.037987600411928e-15, -1.321404069473651e-16,  2.086602847279437e-18, -3.177266885928715e-20,  6.193943170991993e-02, -3.742429476718604e-03,  1.557016544914330e-04,
 -5.179747987008908e-06,  1.483035481163610e-07, -3.794837546842234e-09,  8.880721678996513e-11, -1.930254425916466e-12,  3.939645036927690e-14, -7.612419167571304e-16,
  1.401341660886630e-17, -2.469245889205073e-19,  3.896286924653321e-02, -3.371541452454241e-03,  1.832989861119590e-04, -7.693481756485042e-06,  2.712788002655592e-07,
 -8.397444390441988e-09,  2.344018779032622e-10, -6.006635577684382e-12,  1.431143245611196e-13, -3.200569079777997e-15,  6.767522611671516e-17, -1.360326964301433e-18,
  2.277004001401479e-02, -2.669345160767402e-03,  1.847871707444361e-04, -9.581058950193068e-06,  4.086141151103907e-07, -1.505611738130983e-08,  4.938910756137097e-10,
 -1.471536782495913e-11,  4.039487393591551e-13, -1.032544976623717e-14,  2.477850629363216e-16, -5.616294100422231e-18,  1.249718146082001e-02, -1.898649595457370e-03,
  1.633286352545202e-04, -1.026292541301130e-05,  5.208869937122664e-07, -2.251990041767154e-08,  8.568135457127432e-10, -2.932191654525674e-11,  9.167594805643791e-13,
 -2.649286434458766e-14,  7.140290502667047e-16, -1.806666730968987e-17,  6.524343086991452e-03, -1.238060215993436e-03,  1.293345170081400e-04, -9.672807135867325e-06,
  5.753918343452263e-07, -2.879652250365402e-08,  1.255226830351494e-09, -4.878058825901080e-11,  1.718597555426020e-12, -5.558253100117495e-14,  1.666278209398846e-15,
 -4.662992689058363e-17,  3.287041453151710e-03, -7.546245662521150e-04,  9.365856233081785e-05, -8.192340815435776e-06,  5.626848719661647e-07, -3.216889320447593e-08,
  1.587244985279184e-09, -6.926971203297409e-11,  2.721434737249599e-12, -9.753603093994809e-14,  3.221932374353102e-15, -9.882833218653896e-17,  1.623159262238681e-03,
 -4.381424683553896e-04,  6.325643384982483e-05, -6.359742982150447e-06,  4.968293168892501e-07, -3.201366787917758e-08,  1.766223899092707e-09, -8.558406753663416e-11,
  3.709923465599206e-12, -1.458768251465265e-13,  5.259583934455391e-15, -1.752358707301872e-16,  7.978858714429782e-04, -2.466849294182091e-04,  4.058131314651632e-05,
 -4.607990943114470e-06,  4.031558852697591e-07, -2.887360086281841e-08,  1.758575461960631e-09, -9.349862100901681e-11,  4.422562912576683e-12, -1.888020210418517e-13,
  7.356670170183331e-15, -2.637321516597082e-16,  3.957080293050057e-04, -1.367373067826498e-04,  2.511031903114402e-05, -3.162896868521503e-06,  3.049578210412379e-07,
 -2.392131461551088e-08,  1.586746240403657e-09, -9.140499934999490e-11,  4.662321476698824e-12, -2.137029878945594e-13,  8.904722598500966e-15, -3.400724417802042e-16,
  1.994576377149208e-04, -7.527077380444249e-05,  1.511598865297999e-05, -2.073301732322693e-06,  2.166008411363195e-07, -1.832101176318628e-08,  1.304505585780891e-09,
 -8.032559153789039e-11,  4.362534860579323e-12, -2.121446690853681e-13,  9.346996626363156e-15, -3.762269957844097e-16,  1.013909886377486e-04, -4.087792990570578e-05,
  8.792888745515893e-06, -1.288290203431678e-06,  1.432613374268307e-07, -1.285215139882992e-08,  9.672417624572317e-10, -6.274795125163204e-11,  3.579536269288442e-12,
 -1.823208405339678e-13,  8.391684712300168e-15, -3.519566758157886e-16,  4.943791256338203e-05, -2.085120222247614e-05,  4.704385861776786e-06, -7.218255484765740e-07,
  8.386636660883388e-08, -7.841868222905916e-09,  6.136704855871562e-10, -4.130269243506318e-11,  2.439289354111705e-12, -1.283709862196366e-13,  6.093470720676555e-15,
 -2.630871874644337e-16,  1.822918354683849e-05, -7.881529656254136e-06,  1.826137007262207e-06, -2.875309757600171e-07,  3.423926601395514e-08, -3.276899209221837e-09,
  2.621299006831174e-10, -1.801160139974553e-11,  1.084710741630581e-12, -5.814446698248865e-14,  2.808283125916239e-15, -1.232432984000640e-16,  1.587039549422662e-01,
 -1.112647468249300e-03,  8.459227942709372e-06, -6.760952363150994e-08,  5.534481077220764e-10, -4.566792569919612e-12,  3.763655041621245e-14, -3.085913350943260e-16,
  2.511800539372772e-18, -2.029440971122002e-20,  1.626970924513046e-22, -1.295227942092365e-24,  1.407936049798369e-01, -1.663441234606861e-03,  2.300594115253544e-05,
 -3.046076527690898e-07,  3.815351138787607e-09, -4.568906847420178e-11,  5.276964861842557e-13, -5.913749799633843e-15,  6.457755914936096e-17, -6.893005149802580e-19,
  7.209466590912655e-21, -7.402425375853701e-23,  1.109869676392718e-01, -2.379164126786160e-03,  4.993236006470817e-05, -9.181267002908582e-07,  1.541689995402114e-08,
 -2.418606730075664e-10,  3.592900401527277e-12, -5.099875460998248e-14,  6.962104443200934e-16, -9.185867702547050e-18,  1.175860077299309e-19, -1.464549323640099e-21,
  7.799797709631513e-02, -2.799528128124001e-03,  8.156621535174830e-05, -1.987227235604277e-06,  4.300023998470700e-08, -8.509837893782415e-10,  1.568220527550362e-11,
 -2.723947861324513e-13,  4.498503566842306e-15, -7.109401136195118e-17,  1.080614988516125e-18, -1.585711173945386e-20,  4.911747084115845e-02, -2.710203200577529e-03,
  1.056076699149381e-04, -3.314363752537796e-06,  8.998406176772793e-08, -2.191494193617589e-09,  4.895344103574789e-11, -1.018035484033843e-12,  1.991981676875808e-14,
 -3.696418154991371e-16,  6.544774133937663e-18, -1.110730221013461e-19,  2.791432060893499e-02, -2.211677433787000e-03,  1.123312937577979e-04, -4.440025330882302e-06,
  1.482458007141823e-07, -4.362851258096771e-09,  1.161511389008303e-10, -2.846237122873373e-12,  6.499301911897833e-14, -1.395706352311591e-15,  2.838716328205298e-17,
 -5.497142821426219e-19,  1.445236301752562e-02, -1.559098874256323e-03,  1.008626582713764e-04, -4.925799869411935e-06,  1.989580179776275e-07, -6.971816600666167e-09,
  2.182181812252871e-10, -6.220955831729123e-12,  1.637811250847850e-13, -4.023397669787812e-15,  9.296063077532253e-17, -2.032073207696694e-18,  6.898452179203970e-03,
 -9.711086690695137e-04,  7.829434559686931e-05, -4.643753641044538e-06,  2.236256664183329e-07, -9.210428380980534e-09,  3.349401892513686e-10, -1.098619373628516e-11,
  3.300079288192259e-13, -9.181739433140402e-15,  2.386997761426375e-16, -5.835811494067814e-18,  3.080606017809291e-03, -5.462304860351080e-04,  5.375123145924886e-05,
 -3.809592044669412e-06,  2.157554336699643e-07, -1.031904599797337e-08,  4.312022404452955e-10, -1.610738157460363e-11,  5.467401639659961e-13, -1.707129426047683e-14,
  4.949889234205728e-16, -1.342055150761970e-17,  1.309727253762563e-03, -2.836642134017475e-04,  3.338986347716772e-05, -2.783277438939667e-06,  1.829018942422922e-07,
 -1.003768304783237e-08,  4.767742157597122e-10, -2.007925833468739e-11,  7.629110673643538e-13, -2.649393518731827e-14,  8.494798504242258e-16, -2.533206723340990e-17,
  5.408525459118669e-04, -1.391624307489443e-04,  1.920983302072036e-05, -1.853286089034309e-06,  1.393755362949931e-07, -8.669582294483212e-09,  4.628542715985963e-10,
 -2.174974254949937e-11,  9.160377202691950e-13, -3.505596523837720e-14,  1.232036484919957e-15, -4.006989607241728e-17,  2.216909198553708e-04, -6.602813176620277e-05,
  1.047820177095515e-05, -1.150670709322006e-06,  9.759986322108375e-08, -6.791502577173466e-09,  4.026835334160605e-10, -2.087880454921986e-11,  9.646175420999625e-13,
 -4.027971966075641e-14,  1.537169775926298e-15, -5.403734889220703e-17,  9.214189136192899e-05, -3.098664904093708e-05,  5.539396860130633e-06, -6.803475877209306e-07,
  6.407174822241519e-08, -4.916874780381054e-09,  3.195390904232692e-10, -1.805824164303886e-11,  9.047335971800035e-13, -4.077741293851509e-14,  1.672464170973789e-15,
 -6.292881500854616e-17,  3.948913023668345e-05, -1.463682653325996e-05,  2.886199475433947e-06, -3.890749336689234e-07,  3.999326223557070e-08, -3.331903895317286e-09,
  2.339020352627918e-10, -1.421286502917918e-11,  7.623744746444893e-13, -3.664338943810248e-14,  1.596890687067827e-15, -6.361863602517358e-17,  1.749348161245203e-05,
 -6.980056467214689e-06,  1.485302810797806e-06, -2.153838213692005e-07,  2.371948234129449e-08, -2.108583708832561e-09,  1.573394126486809e-10, -1.012561073489951e-11,
  5.733002684437320e-13, -2.899502923195474e-14,  1.325718442695922e-15, -5.525635460101715e-17,  7.694809115914483e-06, -3.229768351310424e-06,  7.249634867551437e-07,
 -1.106861966466988e-07,  1.279993928541887e-08, -1.191554664918593e-09,  9.285722777086699e-11, -6.225156215018910e-12,  3.662899819677739e-13, -1.920923088801791e-14,
  9.088124141275268e-16, -3.911634055615111e-17,  2.671367248250492e-06, -1.153085685889832e-06,  2.666893599567300e-07, -4.191705338334462e-08,  4.983010525596346e-09,
 -4.761267229577051e-10,  3.802761548464223e-11, -2.609082441712124e-12,  1.569028352723883e-13, -8.399114156384243e-15,  4.051347805262267e-16, -1.775745916871646e-17,
  1.543837781494073e-01, -1.048075000574824e-03,  7.698181919438088e-06, -5.943874526461822e-08,  4.704893742196655e-10, -3.758752154175047e-12,  3.001979557416028e-14,
 -2.387506697691186e-16,  1.885823374638787e-18, -1.479542365693446e-20,  1.151876259418847e-22, -8.910836606618864e-25,  1.344861637621380e-01, -1.493042337357630e-03,
  1.968885291464631e-05, -2.502365423096885e-07,  3.015920838595040e-09, -3.479894616350068e-11,  3.876745311542718e-13, -4.194439293491259e-15,  4.425543226429196e-17,
 -4.567460298427353e-19,  4.621912224785029e-21, -4.594031619787408e-23,  1.022049222732525e-01, -2.019921359402327e-03,  4.024918493565683e-05, -7.059126996210493e-07,
  1.133814044795813e-08, -1.705251170295575e-10,  2.432933062076163e-12, -3.321578720835831e-14,  4.366794906220135e-16, -5.554482999191706e-18,  6.861037397460421e-20,
 -8.253151442408024e-22,  6.796885444397362e-02, -2.231861665877496e-03,  6.134566221093163e-05, -1.417259354253214e-06,  2.920152153372898e-08, -5.519661260564654e-10,
  9.738136198355885e-12, -1.622459864362238e-13,  2.574232178818588e-15, -3.913993928295215e-17,  5.730560917767520e-19, -8.109066652705169e-21,  3.974512068188552e-02,
 -2.002915324964280e-03,  7.321049533841319e-05, -2.169959779209292e-06,  5.592007455672304e-08, -1.297342097056183e-09,  2.768357420602837e-11, -5.512084771674392e-13,
  1.034634673292724e-14, -1.844817563136809e-16,  3.143215554981252e-18, -5.140113936861832e-20,  2.057674668876285e-02, -1.491592148830637e-03,  7.082871113600868e-05,
 -2.638081607586187e-06,  8.345253514361428e-08, -2.336167096327861e-09,  5.934525051215923e-11, -1.391147546111833e-12,  3.045435627445600e-14, -6.281646252572751e-16,
  1.229189629765322e-17, -2.293543084904830e-19,  9.519853270281303e-03, -9.435238592077544e-04,  5.703392402578114e-05, -2.623466766703043e-06,  1.003589264822761e-07,
 -3.344518865729359e-09,  9.988575262547605e-11, -2.724464256429153e-12,  6.878769007507043e-14, -1.623841655663959e-15,  3.611884109457937e-17, -7.613252242865114e-19,
  3.984247565066309e-03, -5.184340421925722e-04,  3.913178427214325e-05, -2.189119923711633e-06,  9.996241655697729e-08, -3.920072888763748e-09,  1.361843118316288e-10,
 -4.279223458980900e-12,  1.234359766125763e-13, -3.304869361707122e-15,  8.283315547474747e-17, -1.955779113643826e-18,  1.532165535514350e-03, -2.530659249800095e-04,
  2.341257754417858e-05, -1.570165135868434e-06,  8.455811250404330e-08, -3.860547797797017e-09,  1.544908598137227e-10, -5.541732247704769e-12,  1.810628218136634e-13,
 -5.453173241790133e-15,  1.527997126473497e-16, -4.010402319973442e-18,  5.520299503604020e-04, -1.123919878162881e-04,  1.251463387553378e-05, -9.920347597114810e-07,
  6.225913909992330e-08, -3.274585434009177e-09,  1.495067081438412e-10, -6.067785628643457e-12,  2.226707847977028e-13, -7.483512922122502e-15,  2.326249161188147e-16,
 -6.736524912024877e-18,  1.907803022576070e-04, -4.661701642980223e-05,  6.134386353994826e-06, -5.664775598238568e-07,  4.092082369301663e-08, -2.452320570910331e-09,
  1.264652968396132e-10, -5.753281242322134e-12,  2.350621819254196e-13, -8.742197900794163e-15,  2.990725366853153e-16, -9.482509012012181e-18,  6.498695622397900e-05,
 -1.858002822826257e-05,  2.835759163784156e-06, -3.003788768854826e-07,  2.464256116948154e-08, -1.662533266703232e-09,  9.577770566835959e-11, -4.834232929929136e-12,
  2.177897258622858e-13, -8.881678830571168e-15,  3.314829016423357e-16, -1.141120621398990e-17,  2.246595851876029e-05, -7.330536528756761e-06,  1.272231697976713e-06,
 -1.519899276763286e-07,  1.395018468230547e-08, -1.045237038041268e-09,  6.643089817056808e-11, -3.676896180622900e-12,  1.806611957785149e-13, -7.995166885317571e-15,
  3.223351284997828e-16, -1.193428416914017e-17,  8.097540982932326e-06, -2.941293806535032e-06,  5.682805025761466e-07, -7.514626188979837e-08,  7.586629261512919e-09,
 -6.215400008692963e-10,  4.295483692350604e-11, -2.572212959778207e-12,  1.360969011211155e-13, -6.458070812340745e-15,  2.780681663834987e-16, -1.095353737820099e-17,
  3.087590643328775e-06, -1.217552402904073e-06,  2.559512019923656e-07, -3.668721602313897e-08,  3.996432778338003e-09, -3.516638464775628e-10,  2.599145377587972e-11,
 -1.657815727360517e-12,  9.308169606103995e-14, -4.670878148105241e-15,  2.119957065292970e-16, -8.775218185639107e-18,  1.211468862797500e-06, -5.057129182864286e-07,
  1.128577148758865e-07, -1.713497407383390e-08,  1.971078087998063e-09, -1.825790277633380e-10,  1.416196352201304e-11, -9.452589356001927e-13,  5.539006072570776e-14,
 -2.893531886007055e-15,  1.363959646630445e-16, -5.850442399142122e-18,  3.930633590620887e-07, -1.693545428282524e-07,  3.909126438847284e-08, -6.132246981608988e-09,
  7.276254409102293e-10, -6.940033685174677e-11,  5.533458709593258e-12, -3.790340000322550e-13,  2.275864399339353e-14, -1.216479644083572e-15,  5.859429770669468e-17,
 -2.564777330877492e-18,  1.503103051557401e-01, -9.892201016648194e-04,  7.027724055182474e-06, -5.247532603567942e-08,  4.020108593244074e-10, -3.112140308023748e-12,
  2.410547540585256e-14, -1.861085177388924e-16,  1.427487516649907e-18, -1.088434740533426e-20,  8.233857506679045e-23, -6.195686520217058e-25,  1.288110903673506e-01,
 -1.346772334815262e-03,  1.695411046443650e-05, -2.070813474515934e-07,  2.404237737307987e-09, -2.675807023063223e-11,  2.878179786185073e-13, -3.009274607518976e-15,
  3.070555218890283e-17, -3.066756722122924e-19,  3.004939065099785e-21, -2.893708590950259e-23,  9.471961072143530e-02, -1.728967763885457e-03,  3.276362372018264e-05,
 -5.489039254278027e-07,  8.443648965106734e-09, -1.218836413161851e-10,  1.671864375206848e-12, -2.197536622136856e-14,  2.784749511450077e-16, -3.417742400634360e-18,
  4.077057363935732e-20, -4.740127136162971e-22,  5.992542923123452e-02, -1.801945532116746e-03,  4.681488157943572e-05, -1.027043419859956e-06,  2.017448522821850e-08,
 -3.646165638506780e-10,  6.164595853243717e-12, -9.860521621579855e-14,  1.504311059675767e-15, -2.202163937926653e-17,  3.107945048652704e-19, -4.243778981377337e-21,
  3.275905043461251e-02, -1.507940163906174e-03,  5.178712123620591e-05, -1.451359216923763e-06,  3.553730153519820e-08, -7.860971663057262e-10,  1.603686504027488e-11,
 -3.059440389188249e-13,  5.512456585555234e-15, -9.450126786685354e-17,  1.550229100842137e-18, -2.443914758680443e-20,  1.557106912218778e-02, -1.031998030394201e-03,
  4.586003871546716e-05, -1.610741838986607e-06,  4.830834100626240e-08, -1.287118133983506e-09,  3.121423381062956e-11, -7.002826057214555e-13,  1.470270843638111e-14,
 -2.913808876695688e-16,  5.487124029149496e-18, -9.867465032140932e-20,  6.491680657974853e-03, -5.902314100118302e-04,  3.333988472555969e-05, -1.444663111352857e-06,
  5.235003040197169e-08, -1.659403718296911e-09,  4.729291813005609e-11, -1.234291025827701e-12,  2.988723689183320e-14, -6.779880236608389e-16,  1.451711168051969e-17,
 -2.950404244260618e-19,  2.402017120266421e-03, -2.882464284617884e-04,  2.035207665739490e-05, -1.073268972990694e-06,  4.645176325710514e-08, -1.733770482913999e-09,
  5.751886689779546e-11, -1.730801054994354e-12,  4.792498759448819e-14, -1.234299264832438e-15,  2.981411517502499e-17, -6.795575050023504e-19,  8.012824401298340e-04,
 -1.229136619231988e-04,  1.067264069327125e-05, -6.764127207168313e-07,  3.460023111481831e-08, -1.506508557289510e-09,  5.768372053208130e-11, -1.985323417904302e-12,
  6.238691022100616e-14, -1.810960129258551e-15,  4.899983273422378e-17, -1.244009852437422e-18,  2.459515808292908e-04, -4.690622025947708e-05,  4.928549744049111e-06,
 -3.707997304057617e-07,  2.218692261531191e-08, -1.116694738888984e-09,  4.894019447545712e-11, -1.911669459085517e-12,  6.767484953363318e-14, -2.198566035044849e-15,
  6.618440002509722e-17, -1.859243790481557e-18,  7.128857093379519e-05, -1.647914849851555e-05,  2.061120354597237e-06, -1.817330620867721e-07,  1.258276075391065e-08,
 -7.250866368812248e-10,  3.605496574032687e-11, -1.585383666615991e-12,  6.274036477434988e-14, -2.264388967269995e-15,  7.530287874840712e-17, -2.324609789322746e-18,
  2.014054540807509e-05, -5.506771898040168e-06,  8.057994088555459e-07, -8.210864311084838e-08,  6.499555344280988e-09, -4.242272648008241e-10,  2.369916758420845e-11,
 -1.162329129172903e-12,  5.097617317435219e-14, -2.027065452163579e-15,  7.387937947528164e-17, -2.487072022643010e-18,  5.753085082205746e-06, -1.815381575133465e-06,
  3.049795119948900e-07, -3.534866052778714e-08,  3.154691384048189e-09, -2.302969034540955e-10,  1.428654208953209e-11, -7.730872727037433e-13,  3.719106449516160e-14,
 -1.613629822624451e-15,  6.385731467875070e-17, -2.323376953922647e-18,  1.725417897375524e-06, -6.126220635064114e-07,  1.157000598893030e-07, -1.497559795692998e-08,
  1.482069775659171e-09, -1.191883874185314e-10,  8.096070363375738e-12, -4.770559563889297e-13,  2.486385497389256e-14, -1.163316994907151e-15,  4.943140889982543e-17,
 -1.923198454410263e-18,  5.589437062687535e-07, -2.174799166691130e-07,  4.509373271891344e-08, -6.379704405490047e-09,  6.865069721692463e-10, -5.972277010981577e-11,
  4.367302513206094e-12, -2.758002298818730e-13,  1.534188241880376e-14, -7.631785860232333e-16,  3.435613545919267e-17, -1.411270366939769e-18,  1.932127124811228e-07,
 -8.015167218514926e-08,  1.776986594325374e-08, -2.680986919203895e-09,  3.065695124255468e-10, -2.823894295377300e-11,  2.178937920461826e-12, -1.447230050217967e-13,
  8.441415008836699e-15, -4.390657974811475e-16,  2.061260143526842e-17, -8.807603878927024e-19,  5.809577105516603e-08, -2.498008895694755e-08,  5.753341155869820e-09,
 -9.005833905132414e-10,  1.066385527354552e-10, -1.015106669938491e-11,  8.078517844103946e-13, -5.523794061533143e-14,  3.311060835802952e-15, -1.766940707439885e-16,
  8.497702012597444e-18, -3.714130423319276e-19,  1.464620285915851e-01, -9.354123125855317e-04,  6.434656366987615e-06, -4.651134450592007e-08,  3.451564923523637e-10,
 -2.591320147998559e-12,  1.947928644164901e-14, -1.461123084182672e-16,  1.088915558733871e-18, -8.076604408087795e-21,  5.938780008617142e-23, -4.352397034828411e-25,
  1.236804011245577e-01, -1.220463771533308e-03,  1.468342279651267e-05, -1.725462939241562e-07,  1.931860982646192e-09, -2.075995326020578e-11,  2.158066764179232e-13,
 -2.182420701897140e-15,  2.155399022133799e-17, -2.084985577484206e-19,  1.979752031467854e-21, -1.848462621135974e-23,  8.828925571121232e-02, -1.491081558931915e-03,
  2.691345468700616e-05, -4.313192554323447e-07,  6.362143119572668e-09, -8.823902101541316e-11,  1.164842354691095e-12, -1.475470080780878e-14,  1.803829143459246e-16,
 -2.137873836915650e-18,  2.464865170383622e-20, -2.771874216872234e-22,  5.339570676261701e-02, -1.471743387580939e-03,  3.621015521222280e-05, -7.554011359266252e-07,
  1.416331003518886e-08, -2.450130134184051e-10,  3.973602611707631e-12, -6.107508916316503e-14,  8.966510664477415e-16, -1.264755006983842e-17,  1.721809231252372e-19,
 -2.270161970031452e-21,  2.745780650106696e-02, -1.154714425480191e-03,  3.732413214941268e-05, -9.902162699803910e-07,  2.306140800720936e-08, -4.868390081590204e-10,
  9.503095604556553e-12, -1.738367691812850e-13,  3.008647198907023e-15, -4.962000839680686e-17,  7.841428385515947e-19, -1.192330712500396e-20,  1.207068918706202e-02,
 -7.310150361099657e-04,  3.043493139456917e-05, -1.008864880160257e-06,  2.870769546214015e-08, -7.284710364930995e-10,  1.687524706177879e-11, -3.625141290978978e-13,
  7.302809306244170e-15, -1.391110978995568e-16,  2.521910593263614e-18, -4.372077938835229e-20,  4.571617672461447e-03, -3.807899174945051e-04,  2.010610393312765e-05,
 -8.209572965920864e-07,  2.818851347885647e-08, -8.501189701729354e-10,  2.312561735159657e-11, -5.776092398626114e-13,  1.341519683178050e-14, -2.924653958225598e-16,
  6.028670113199755e-18, -1.181385929287193e-19,  1.507986476434280e-03, -1.665306271646292e-04,  1.099236949628399e-05, -5.462540010980688e-07,  2.240270966588245e-08,
 -7.956473317179325e-10,  2.520142154711901e-11, -7.260334341788893e-13,  1.929295220824894e-14, -4.778421074134099e-16,  1.112014800091477e-17, -2.446063806425947e-19,
  4.397682055240322e-04, -6.246995595827413e-05,  5.083348107014521e-06, -3.041294478311176e-07,  1.476358945006535e-08, -6.125436229588314e-10,  2.242464761420762e-11,
 -7.400028670284795e-13,  2.235002783591367e-14, -6.248830800088492e-16,  1.631588021117744e-17, -4.004227962173015e-19,  1.157147839557246e-04, -2.059937345832863e-05,
  2.037740923879780e-06, -1.452427920783855e-07,  8.273052036985539e-09, -3.979177606939442e-10,  1.671889435475743e-11, -6.278045971925475e-13,  2.141608122604623e-14,
 -6.718357247438187e-16,  1.956603928515540e-17, -5.326685599095218e-19,  2.822673609645637e-05, -6.148709772736052e-06,  7.288373090756707e-07, -6.121217846308320e-08,
  4.053747178265073e-09, -2.242044344046419e-10,  1.073158264188152e-11, -4.553824457777170e-13,  1.742997054921396e-14, -6.096287298393712e-16,  1.968159139709556e-17,
 -5.908085318635468e-19,  6.610719888108332e-06, -1.721711497026040e-06,  2.407693462434861e-07, -2.353598245527679e-08,  1.793309028366395e-09, -1.129943623588728e-10,
  6.109019328200643e-12, -2.906082329254414e-13,  1.238620431363775e-14, -4.795055444029935e-16,  1.704088550005862e-17, -5.601994012409088e-19,  1.551943281451856e-06,
 -4.718826636317101e-07,  7.649823808975023e-08, -8.578560665598089e-09,  7.425958485084838e-10, -5.270095338190034e-11,  3.184668599786311e-12, -1.681706002163679e-13,
  7.907550439061512e-15, -3.358289493988857e-16,  1.302585726392800e-17, -4.650852116952240e-19,  3.833492717000612e-07, -1.326678059821240e-07,  2.442775990921948e-08,
 -3.087559871046693e-09,  2.988945381838432e-10, -2.354988174210339e-11,  1.569494963085733e-12, -9.085566959988208e-14,  4.657589759839042e-15, -2.145689955945175e-16,
  8.986133273593300e-18, -3.449023914159935e-19,  1.040851030876690e-07, -3.988515900728091e-08,  8.142391211784733e-09, -1.135126645331555e-09,  1.204815024963132e-10,
 -1.034803276117610e-11,  7.477483161110664e-13, -4.669944091269698e-14,  2.570936120746891e-15, -1.266565642160844e-16,  5.650193878682185e-18, -2.301346679891633e-19,
  3.126784127077841e-08, -1.287857954450076e-08,  2.833930545076309e-09, -4.245123562194954e-10,  4.821703347049755e-11, -4.413494128989280e-12,  3.385468239100730e-13,
 -2.236227831105635e-14,  1.297628916628276e-15, -6.716791014071629e-17,  3.138998209261039e-18, -1.335567234796893e-19,  8.629789592592728e-09, -3.702186106587819e-09,
  8.505827478822165e-10, -1.328246938083221e-10,  1.569180613000472e-11, -1.490469024102376e-12,  1.183704774986356e-13, -8.077838443372284e-15,  4.832964635912347e-16,
 -2.574525651960762e-17,  1.236069465809180e-18, -5.393881643215685e-20,  1.428199265278115e-01, -8.860775040277238e-04,  5.908023628052781e-06, -4.137937429786914e-08,
  2.976930018610672e-10, -2.169226639716711e-12,  1.583532953458731e-14, -1.154956169719433e-16,  8.366781595105034e-19, -6.043470635045938e-21,  4.318649709976458e-23,
 -3.089592453802047e-25,  1.190210697002552e-01, -1.110782969644994e-03,  1.278548234483107e-05, -1.446961569972252e-07,  1.563881030209174e-09, -1.624237312199743e-11,
  1.633271002311672e-13, -1.598962614251781e-15,  1.529736905980613e-17, -1.434336953603850e-19,  1.320797224236637e-21, -1.196581603853563e-23,  8.272504235317092e-02,
 -1.294871650212881e-03,  2.229471449055109e-05, -3.422538325381494e-07,  4.846553428291609e-09, -6.465297690105581e-11,  8.221822560509448e-13, -1.004508485937806e-14,
  1.185783571326747e-16, -1.358239155529363e-18,  1.514692891502440e-20, -1.648761981292018e-22,  4.803567206253805e-02, -1.214810402626704e-03,  2.835863610621921e-05,
 -5.633367388423224e-07,  1.009332614067545e-08, -1.673030964540507e-10,  2.605206340416206e-12, -3.851131598859868e-14,  5.445320714522693e-16, -7.406386349566207e-18,
  9.733010128733132e-20, -1.239932403370604e-21,  2.336885069846696e-02, -8.980460200588568e-04,  2.737016655039317e-05, -6.882143399256535e-07,  1.526104406990806e-08,
 -3.077516595211451e-10,  5.752865482682574e-12, -1.009827738081188e-13,  1.679986547321299e-15, -2.667228860747506e-17,  4.062849928465721e-19, -5.961748458521086e-21,
  9.566639392144376e-03, -5.291323060753133e-04,  2.066657890337658e-05, -6.471209365666984e-07,  1.748525529092994e-08, -4.228772041237342e-10,  9.363333235833497e-12,
 -1.927092807557236e-13,  3.726695643301832e-15, -6.826435378431148e-17,  1.191827774594330e-18, -1.992577139171572e-20,  3.317100935548292e-03, -2.528001646031048e-04,
  1.248415157006076e-05, -4.805404547052128e-07,  1.564102322210592e-08, -4.489573056595058e-10,  1.166070552451258e-11, -2.788038863781693e-13,  6.212250298490559e-15,
 -1.301787643119155e-16,  2.583628893576749e-18, -4.882088823787787e-20,  9.834671825129787e-04, -9.974404656303050e-05,  6.153050619351971e-06, -2.880853686006418e-07,
  1.119426068724064e-08, -3.782743179979121e-10,  1.143808081977818e-11, -3.154474443179032e-13,  8.043285858760818e-15, -1.915459103411188e-16,  4.293775447455122e-18,
 -9.112843013768560e-20,  2.527525485476680e-04, -3.315664913399775e-05,  2.525290479021888e-06, -1.424959826475473e-07,  6.559797304062883e-09, -2.591863466167579e-10,
  9.066729886312366e-12, -2.867087847458241e-13,  8.318128369863673e-15, -2.238777412359537e-16,  5.637779983516945e-18, -1.336759801548483e-19,  5.741009610798031e-05,
 -9.506890160656120e-06,  8.835263625613024e-07, -5.956376731016380e-08,  3.225305633879448e-09, -1.480675847742395e-10,  5.957618208904780e-12, -2.148352398748152e-13,
  7.054894760256468e-15, -2.135059856581116e-16,  6.009974543877872e-18, -1.584199285899810e-19,  1.184137312463400e-05, -2.421129991489186e-06,  2.712150801849652e-07,
 -2.164713535897749e-08,  1.368478966396070e-09, -7.251614322992854e-11,  3.335810970748424e-12, -1.363989542678495e-13,  5.042355034812030e-15, -1.706845962563646e-16,
  5.342917587698824e-18, -1.557729062370835e-19,  2.301289624683277e-06, -5.685528132369519e-07,  7.573612971195518e-08, -7.082812963585814e-09,  5.182134574047763e-10,
 -3.145273374096572e-11,  1.642474961300707e-12, -7.564639356921757e-14,  3.128087485392558e-15, -1.177074920266294e-16,  4.072874699156963e-18, -1.305653309748543e-19,
  4.422625239646650e-07, -1.290728211840445e-07,  2.012461827116425e-08, -2.177204602549207e-09,  1.823393848279495e-10, -1.255107350089205e-11,  7.372636739193481e-13,
 -3.791902602442107e-14,  1.739635788831355e-15, -7.219839331943992e-17,  2.740484053891011e-18, -9.588350246580264e-20,  8.912699724476923e-08, -2.996830222973287e-08,
  5.364150957588548e-09, -6.603786771467386e-10,  6.238889191635947e-11, -4.805879448613630e-12,  3.136501884034896e-13, -1.780635604860921e-14,  8.963862782276686e-16,
 -4.060047366675112e-17,  1.673551491237397e-18, -6.328614675285019e-20,  2.000255096803256e-08, -7.532546135933018e-09,  1.510883901959212e-09, -2.071648778572787e-10,
  2.165131568176783e-11, -1.833124550362632e-12,  1.307076617335732e-13, -8.062532271850935e-15,  4.387651111842435e-16, -2.138374856617018e-17,  9.443654200586813e-19,
 -3.810379949662987e-20,  5.144487036479794e-09, -2.101563816377743e-09,  4.585127423189254e-10, -6.812630104884435e-11,  7.679072923707013e-12, -6.979034779415030e-13,
  5.317947201526460e-14, -3.490971193906017e-15,  2.014014795540654e-16, -1.036855711111283e-17,  4.821042588805387e-19, -2.041508868462580e-20,  1.289100879327170e-09,
 -5.516048391230433e-10,  1.263829621468205e-10, -1.968277668054342e-11,  2.319370948089908e-12, -2.197694897792257e-13,  1.741369477355928e-14, -1.185765182878241e-15,
  7.079827424488385e-17, -3.764072011770236e-18,  1.803840418295659e-19, -7.857658402388425e-21,  1.393671101868772e-01, -8.407217207869909e-04,  5.438681984873332e-06,
 -3.694376081056667e-08,  2.578618282491793e-10, -1.825149566327545e-12,  1.294580831878349e-14, -9.189442281027860e-17,  6.471904594591360e-19, -4.559914165799914e-21,
  3.162376994342069e-23, -2.219376358194532e-25,  1.147720782673155e-01, -1.015042527215303e-03,  1.118919164415934e-05, -1.220741463283743e-07,  1.274872505424973e-09,
 -1.280888942748175e-11,  1.247002518817895e-13, -1.182814288662388e-15,  1.097039154306270e-17, -9.978198907852986e-20,  8.917028726932625e-22, -7.844383098472519e-24,
  7.787799963536331e-02, -1.131715608046604e-03,  1.861349565499297e-05, -2.740697834801515e-07,  3.730073816409307e-09, -4.790829758001026e-11,  5.874504287209888e-13,
 -6.928823245603073e-15,  7.904216949091469e-17, -8.756961060759530e-19,  9.452885482249411e-21, -9.966833251093927e-23,  4.359092134209529e-02, -1.012470008460804e-03,
  2.246721602885049e-05, -4.255489404398050e-07,  7.294390798231652e-09, -1.159708423520187e-10,  1.735553675088468e-12, -2.469599699393694e-14,  3.365789671950280e-16,
 -4.417688164055194e-18,  5.607937505283978e-20, -6.907453989674418e-22,  2.016758456057278e-02, -7.083913815591573e-04,  2.039545229453476e-05, -4.866385805893282e-07,
  1.028567129101208e-08, -1.983248609564835e-10,  3.553338103473499e-12, -5.989949516194153e-14,  9.585581964030969e-16, -1.465965778188612e-17,  2.153701877877906e-19,
 -3.051458110864992e-21,  7.737551015269865e-03, -3.906771531009711e-04,  1.433567728390813e-05, -4.244257236868335e-07,  1.089892953306719e-08, -2.514115491014738e-10,
  5.324436030924861e-12, -1.050521183580267e-13,  1.951263558687911e-15, -3.438686410807057e-17,  5.784280764576593e-19, -9.329509654125981e-21,  2.474342196603644e-03,
 -1.723338704523326e-04,  7.965759672780896e-06, -2.892109578432114e-07,  8.928136104912150e-09, -2.440239408639140e-10,  6.053843223871453e-12, -1.386073143525044e-13,
  2.963795401673661e-15, -5.971132691094293e-17,  1.141231407831390e-18, -2.079792080154675e-20,  6.646919753218286e-04, -6.179400974132385e-05,  3.562225644742016e-06,
 -1.571369586733138e-07,  5.785518633678976e-09, -1.860216420044934e-10,  5.369824152381142e-12, -1.417659240799931e-13,  3.468365712439477e-15, -7.941207359286103e-17,
  1.714544853903351e-18, -3.510453330072345e-20,  1.517829710212059e-04, -1.833866081174839e-05,  1.305977837409217e-06, -6.945642653118796e-08,  3.030546359887230e-09,
 -1.139759042837743e-10,  3.808091795257803e-12, -1.153427815022034e-13,  3.213107909763158e-15, -8.321152433903503e-17,  2.020092097997497e-18, -4.625448971330042e-20,
  2.998699894661836e-05, -4.603609287528779e-06,  4.011773754639562e-07, -2.554421226499309e-08,  1.313348490324434e-09, -5.748725839957279e-11,  2.212896223997590e-12,
 -7.656194990981609e-14,  2.418176598958104e-15, -7.054026288014989e-17,  1.917631053219999e-18, -4.890292905530581e-20,  5.260359163313729e-06, -1.005538163779833e-06,
  1.061611511772984e-07, -8.035123782161592e-09,  4.840027662119564e-10, -2.453247908430518e-11,  1.082943910057897e-12, -4.260983311800497e-14,  1.519383933893709e-15,
 -4.971448937153066e-17,  1.507103459453792e-18, -4.262754471378735e-20,  8.505074254386070e-07, -1.984723143884317e-07,  2.510133429579488e-08, -2.239667821007994e-09,
  1.569765566907364e-10, -9.158223266817735e-12,  4.610406070863723e-13, -2.052150936270994e-14,  8.219424287808980e-16, -3.001665905666809e-17,  1.009768952056683e-18,
 -3.152267674958565e-20,  1.334904295917601e-07, -3.723736567674980e-08,  5.564617572378567e-09, -5.790480153460526e-10,  4.679414706880935e-11, -3.116711968486867e-12,
  1.775820462663929e-13, -8.878167574658199e-15,  3.966798850484765e-16, -1.606070462701453e-17,  5.956438916253542e-19, -2.039144297289251e-20,  2.176372002832793e-08,
 -7.084605355360487e-09,  1.228847899229651e-09, -1.469375385561934e-10,  1.351359863064670e-11, -1.015431957535039e-12,  6.476402338399707e-14, -3.599031178395766e-15,
  1.776099138265789e-16, -7.896616630042311e-18,  3.198964721611740e-19, -1.190225894751815e-20,  3.981115796207193e-09, -1.469640544401979e-09,  2.889543072389504e-10,
 -3.888520066181944e-11,  3.994034577278340e-12, -3.327634050878195e-13,  2.337600347685752e-14, -1.422095783837592e-15,  7.640064212457545e-17, -3.679061888955257e-18,
  1.606675871980569e-19, -6.415317914361929e-21,  8.624688828309360e-10, -3.490005169267328e-10,  7.540151324924328e-11, -1.109956027239888e-11,  1.240303577593603e-12,
 -1.118161423592492e-13,  8.456447283713438e-15, -5.512522297811389e-16,  3.159608402374733e-17, -1.616754510583776e-18,  7.474711401702185e-20, -3.148446263960425e-21,
  1.937787768252750e-10, -8.267645597099917e-11,  1.888388386050260e-11, -2.932113209931863e-12,  3.445253662514656e-13, -3.255689770345488e-14,  2.573101225609673e-15,
 -1.747900872543902e-16,  1.041239248148182e-17, -5.523940054764372e-19,  2.641811435071778e-20, -1.148570477202287e-21,  1.360885299840658e-01, -7.989180957388736e-04,
  5.018959381963257e-06, -3.309394874685596e-08,  2.242688957337032e-10, -1.543129855358662e-12,  1.063966337039012e-14, -7.358461720262614e-17,  5.036277455151444e-19,
 -3.471004106002549e-21,  2.325601206144078e-23, -1.621993163356111e-25,  1.108821227375899e-01, -9.310602539622764e-04,  9.838733378137735e-06, -1.035735863403220e-07,
  1.046131929781587e-09, -1.017692879488423e-11,  9.600160068870139e-14, -8.829740190111083e-16,  7.945092745658089e-18, -7.015494409821226e-20,  6.088115653529145e-22,
 -5.204860048382123e-24,  7.362946606362641e-02, -9.950165638893571e-04,  1.565343863445564e-05, -2.213490639151837e-07,  2.898543788495379e-09, -3.587847292365800e-11,
  4.245895623575765e-13, -4.838680005034301e-15,  5.338560368062174e-17, -5.724926061841984e-19,  5.986352972018880e-21, -6.117980338365313e-23,  3.987076088306293e-02,
 -8.513372115477788e-04,  1.799108698057762e-05, -3.253458106982530e-07,  5.341214694669605e-09, -8.153116398625894e-11,  1.173718361663619e-12, -1.609024874993265e-14,
  2.115401343168424e-16, -2.681303680382735e-18,  3.290211939879614e-20, -3.920884553077567e-22,  1.762694874092660e-02, -5.660626602506521e-04,  1.542590813391751e-05,
 -3.496798569608262e-07,  7.052164687268524e-09, -1.301389320158605e-10,  2.236738278223414e-12, -3.623801882488499e-14,  5.582231448024806e-16, -8.229053512977855e-18,
  1.166721051651354e-19, -1.597022033165151e-21,  6.375689572100249e-03, -2.937411937836306e-04,  1.014296851831168e-05, -2.842120143909365e-07,  6.942439670586193e-09,
 -1.528688613745259e-10,  3.098764662798017e-12, -5.864829107161084e-14,  1.046899001149368e-15, -1.775870642643172e-17,  2.879428510772208e-19, -4.482325390686300e-21,
  1.893475674428981e-03, -1.203869420912341e-04,  5.213653702156865e-06, -1.786597897663769e-07,  5.234196300107247e-09, -1.362971905724716e-10,  3.231236895963975e-12,
 -7.087321057200212e-14,  1.454819646913605e-15, -2.818810021025601e-17,  5.189438977721851e-19, -9.122809925517158e-21,  4.644680944794733e-04, -3.950826607604586e-05,
  2.128689881019527e-06, -8.848355884836160e-08,  3.087435964037632e-09, -9.447132215803367e-11,  2.603773289873296e-12, -6.581013712353079e-14,  1.544955199206275e-15,
 -3.401007094068505e-17,  7.072264206106900e-19, -1.396852660661111e-20,  9.501548323276662e-05, -1.054613011073748e-05,  7.017297277023151e-07, -3.515777205692883e-08,
  1.453426818467714e-09, -5.201359205931380e-11,  1.659333392503131e-12, -4.812547808377962e-14,  1.286831925362576e-15, -3.205596206614699e-17,  7.499574065794676e-19,
 -1.657674062935090e-20,  1.645901926789491e-05, -2.334784852994867e-06,  1.904646778663216e-07, -1.144010677689209e-08,  5.579279356582676e-10, -2.326405115484012e-11,
  8.560418211482378e-13, -2.839411009962076e-14,  8.619215771752716e-16, -2.421748031896119e-17,  6.353463494565625e-19, -1.566406888424784e-20,  2.472315311979420e-06,
 -4.400760734251507e-07,  4.367727372611858e-08, -3.128630721941426e-09,  1.792637650204224e-10, -8.678248896633220e-12,  3.671134694837314e-13, -1.388179251317720e-14,
  4.768886076856678e-16, -1.506572580119316e-17,  4.418241026893547e-19, -1.211073331044324e-20,  3.339030207412280e-07, -7.327269894055465e-08,  8.769750183227148e-09,
 -7.445559702062787e-10,  4.987643241623710e-11, -2.791303363474975e-12,  1.352110608253626e-13, -5.806514168273415e-15,  2.249013720909109e-16, -7.958914306083468e-18,
  2.599303018423200e-19, -7.891215630997559e-21,  4.277550586006981e-08, -1.135408903201512e-08,  1.620316877697594e-09, -1.616777733370611e-10,  1.257336816994244e-11,
 -8.083767321699371e-13,  4.457854127002458e-14, -2.162061283466604e-15,  9.390615455162714e-17, -3.702739377840694e-18,  1.339570448051787e-19, -4.480356781125651e-21,
  5.602380371398149e-09, -1.758574303406532e-09,  2.945695680105730e-10, -3.410770393171765e-11,  3.045433176360902e-12, -2.226874456991027e-13,  1.384966469825665e-14,
 -7.518750705188639e-16,  3.630708602235976e-17, -1.581855906731453e-18,  6.288008451710856e-20, -2.298525069071476e-21,  8.238277838306571e-10, -2.972637184920996e-10,
  5.713858826021487e-11, -7.528603274283123e-12,  7.583450317822657e-13, -6.205311719737386e-14,  4.287059396618833e-15, -2.568088184503853e-16,  1.360031033741850e-17,
 -6.462384649960263e-19,  2.787282102158270e-20, -1.100111875120754e-21,  1.477168629005218e-10, -5.912115552126940e-11,  1.263001442151398e-11, -1.839531603943123e-12,
  2.035295669172466e-13, -1.818081710988538e-14,  1.363312157226038e-15, -8.816999121014171e-17,  5.016581845585219e-18, -2.549426541111122e-19,  1.171161459263465e-20,
 -4.903788280462419e-22,  2.933687039037758e-11, -1.247517179415124e-11,  2.839379957156914e-12, -4.393743597642070e-13,  5.146068454041569e-14, -4.848180452862645e-15,
  3.820777069153034e-16, -2.588471253752222e-17,  1.538070129528666e-18, -8.140213981140169e-20,  3.884251405610110e-21, -1.685145078996735e-22,  1.329707289473991e-01,
 -7.602961878513151e-04,  4.642386448909217e-06, -2.973934225075552e-08,  1.958018720731518e-10, -1.310790619192268e-12,  8.787337374933258e-15, -5.930144962032326e-17,
  3.938163046571000e-19, -2.670542017076782e-21,  1.705517122233801e-23, -1.225912116778013e-25,  1.073078121593519e-01, -8.570520665354580e-04,  8.689945959362273e-06,
 -8.834651534023106e-08,  8.637703062088398e-10, -8.143016236470954e-12,  7.448913646283156e-14, -6.648537706368812e-16,  5.807841591327102e-18, -4.982549223031853e-20,
  4.200836636017568e-22, -3.493986932486002e-24,  6.988407770594156e-02, -8.796765595174202e-04,  1.325350574086256e-05, -1.802020739908974e-07,  2.272824181735654e-09,
 -2.713859012253667e-11,  3.102262950536168e-13, -3.418671836421268e-15,  3.650853113382892e-17, -3.792306300308112e-19,  3.844105891577863e-21, -3.810338221839782e-23,
  3.673044244577396e-02, -7.216869961561263e-04,  1.455045334572706e-05, -2.515413095487259e-07,  3.959396491310152e-09, -5.808419726018390e-11,  8.050829870694525e-13,
 -1.064164873333928e-14,  1.350665008015711e-16, -1.654469079329556e-18,  1.963844897191349e-20, -2.265616413725246e-22,  1.558540613820581e-02, -4.577022775895297e-04,
  1.182945168669210e-05, -2.550626289025283e-07,  4.913393102503622e-09, -8.685928232454896e-11,  1.433327416172615e-12, -2.233553138560604e-14,  3.314367673240092e-16,
 -4.712668768763601e-18,  6.452191160728659e-20, -8.537274511954623e-22,  5.343801718985326e-03, -2.245599061021081e-04,  7.309717613479072e-06, -1.940482872731883e-07,
  4.513070794919541e-09, -9.493860096018551e-11,  1.843377566825279e-12, -3.348918925849754e-14,  5.748476923665327e-16, -9.391275329129092e-18,  1.468490744739322e-19,
 -2.207234266611248e-21,  1.483535825713892e-03, -8.601248084283197e-05,  3.494272317029895e-06, -1.130974762381827e-07,  3.146682976080646e-09, -7.811198345974679e-11,
  1.770572980241059e-12, -3.722101434543025e-14,  7.337663034826023e-16, -1.367782894072044e-17,  2.426293242415286e-19, -4.115548921636010e-21,  3.347900006362933e-04,
 -2.601045981399459e-05,  1.310430238344904e-06, -5.134346170544977e-08,  1.698354811021321e-09, -4.946865252184638e-11,  1.302085368382234e-12, -3.151279665224018e-14,
  7.099721863547678e-16, -1.502818250167188e-17,  3.010044671981905e-19, -5.735266751701112e-21,  6.185581896532235e-05, -6.291512550623376e-06,  3.909690061132943e-07,
 -1.844765683490216e-08,  7.224238465394080e-10, -2.459646121086426e-11,  7.490941442406675e-13, -2.079959525676238e-14,  5.337331541975410e-16, -1.278620610905545e-17,
  2.882054118441304e-19, -6.147907691611419e-21,  9.473223581183626e-06, -1.237690628011473e-06,  9.438304025060207e-08, -5.342294480154392e-09,  2.469338325248378e-10,
 -9.801437637205237e-12,  3.445314907817115e-13, -1.094877821750200e-14,  3.192264210711311e-16, -8.633863157145988e-18,  2.184616014639960e-19, -5.203890000934170e-21,
  1.227762934949390e-06, -2.027023977294676e-07,  1.886773405855402e-08, -1.276741716529876e-09,  6.948078132919362e-11, -3.208243093766834e-12,  1.298991947182531e-13,
 -4.715150689777006e-15,  1.558867527232253e-16, -4.749944530041957e-18,  1.346206593489651e-19, -3.572595924468233e-21,  1.392681765388044e-07, -2.860922279303867e-08,
  3.230075430708750e-09, -2.602726881537613e-10,  1.662711117956846e-11, -8.908703907527868e-13,  4.145006689724024e-14, -1.714544908372903e-15,  6.412153661126811e-17,
 -2.195728553848701e-18,  6.952318831092464e-20, -2.049910440100100e-21,  1.458024193432074e-08, -3.665116183470793e-09,  4.976339765471997e-10, -4.746520884701177e-11,
  3.542587221702849e-12, -2.193245703107828e-13,  1.168032821774689e-14, -5.484537226071475e-16,  2.311347856732216e-17, -8.860213988918028e-19,  3.121760773608025e-20,
 -1.018514379780627e-21,  1.525844385040178e-09, -4.598331395574478e-10,  7.410609925999281e-11, -8.282216645566339e-12,  7.159191262337816e-13, -5.081237049234834e-14,
  3.074473266487080e-15, -1.627108851936231e-16,  7.673361812346946e-18, -3.270290875840740e-19,  1.273474105222915e-20, -4.566386989470647e-22,  1.779951819554169e-10,
 -6.257087794251693e-11,  1.172240549574542e-11, -1.508215102597037e-12,  1.486268933787350e-13, -1.191871549171837e-14,  8.082367576162402e-16, -4.758938113385082e-17,
  2.480366106728491e-18, -1.161230479864553e-19,  4.939807422320972e-21, -1.924799362527238e-22,  2.592425043357110e-11, -1.024404964883814e-11,  2.160166242866043e-12,
 -3.108019751047257e-13,  3.400043136222382e-14, -3.005538107881892e-15,  2.232020980383386e-16, -1.430636307406667e-17,  8.072427962149365e-19, -4.070827161051826e-20,
  1.856664208101296e-21, -7.722243420964614e-23,  4.477459263386918e-12, -1.896742065075391e-12,  4.299680455180044e-13, -6.627773921126792e-14,  7.734361150378195e-15,
 -7.261740772327206e-16,  5.704519954866361e-17, -3.853027119816824e-18,  2.282997072533136e-19, -1.205059064275599e-20,  5.735747718340092e-22, -2.482529788440912e-23,
  1.300016348407402e-01, -7.245332472368783e-04,  4.303481834255715e-06, -2.680532013184809e-08,  1.715675239772437e-10, -1.118480146943999e-12,  7.289753593834440e-15,
 -4.811594831853711e-17,  3.087307827478923e-19, -2.088284457256489e-21,  1.222614480738983e-23, -9.943007013649290e-26,  1.040122448209644e-01, -7.915499623458298e-04,
  7.707633547318031e-06, -7.573791092123121e-08,  7.173813891689872e-10, -6.559215145888121e-12,  5.822697965603358e-14, -5.047374770165480e-16,  4.282915289439816e-18,
 -3.573255292480826e-20,  2.927044146782507e-22, -2.372949382890095e-24,  6.656455370543388e-02, -7.817187798493555e-04,  1.129258735914298e-05, -1.478048488135826e-07,
  1.797385501457872e-09, -2.072144744277091e-11,  2.290009251988145e-13, -2.442150474933276e-15,  2.526312322583820e-17, -2.543591206974072e-19,  2.501350248683135e-21,
 -2.405892354055433e-23,  3.405879660104304e-02, -6.163623332951327e-04,  1.187686769902173e-05, -1.965277858102988e-07,  2.969106081303907e-09, -4.189945891644376e-11,
  5.596503253452660e-13, -7.138427052618492e-15,  8.753577345229241e-17, -1.036943713901364e-18,  1.191460046499329e-20, -1.331474608796462e-22,  1.392621027792867e-02,
 -3.740940848900114e-04,  9.188579986271958e-06, -1.886696839111567e-07,  3.475137175730678e-09, -5.890630358803109e-11,  9.340783559701604e-13, -1.401110455721409e-14,
  2.004248350357757e-16, -2.750606051821058e-18,  3.638842387191489e-20, -4.656813597804128e-22,  4.549330577177329e-03, -1.742990610294539e-04,  5.358730824625116e-06,
 -1.349106231256760e-07,  2.990306819891288e-09, -6.014736736944410e-11,  1.119488356715577e-12, -1.953574065252693e-14,  3.226611430623165e-16, -5.079584263268481e-18,
  7.663910213815004e-20, -1.112782256659941e-21,  1.187867600803549e-03, -6.273639706265016e-05,  2.394244370147451e-06, -7.325147941296836e-08,  1.936963875130525e-09,
 -4.586703561593916e-11,  9.946377415946359e-13, -2.005046939742874e-14,  3.797826500469395e-16, -6.813531345464483e-18,  1.164995015433156e-19, -1.907299873172376e-21,
  2.483782548280020e-04, -1.759503446531305e-05,  8.294804427923350e-07, -3.064633711968302e-08,  9.614253181457724e-10, -2.666723569345448e-11,  6.705511475623592e-13,
 -1.554365682489872e-14,  3.361507230762065e-16, -6.843029972955843e-18,  1.320348044864584e-19, -2.427159987515888e-21,  4.177831423574922e-05, -3.884647878739285e-06,
  2.254123834867975e-07, -1.001553815237511e-08,  3.715258115292562e-10, -1.203405288246880e-11,  3.498658108539689e-13, -9.299627369842338e-15,  2.289888067148534e-16,
 -5.274815862649726e-18,  1.145338196308827e-19, -2.357453326092568e-21,  5.704889002840667e-06, -6.843140714650195e-07,  4.872572117918634e-08, -2.596942082246669e-09,
  1.136963308563319e-10, -4.293551701905355e-12,  1.440987102294672e-13, -4.385123910227651e-15,  1.227417952357299e-16, -3.193943695153920e-18,  7.790530645394398e-20,
 -1.792079065950375e-21,  6.432124958141387e-07, -9.810910631653878e-08,  8.546225364362892e-09, -5.454373735795573e-10,  2.815479454748919e-11, -1.238535148014101e-12,
  4.794593754359242e-14, -1.668964003702592e-15,  5.305000311498873e-17, -1.557645650654887e-18,  4.262506534304969e-20, -1.094224980525406e-21,  6.169175691107890e-08,
 -1.180894179073742e-08,  1.253842094824316e-09, -9.565481534316907e-11,  5.815500791355793e-12, -2.977665385086590e-13,  1.328524152512847e-14, -5.284995446708247e-16,
  1.905685672040058e-17, -6.305885986766395e-19,  1.933216686560497e-20, -5.529214453149970e-22,  5.294425212600195e-09, -1.254116165025765e-09,  1.613960603125519e-10,
 -1.466953197811014e-11,  1.047930009094144e-12, -6.232482852835074e-14,  3.198456815320047e-15, -1.451114842681588e-16,  5.922748778897732e-18, -2.203444678537267e-19,
  7.548598428365983e-21, -2.398779138462508e-22,  4.412283319667903e-10, -1.270477685190435e-10,  1.962080855758269e-11, -2.109385322688758e-12,  1.759926438954571e-13,
 -1.209203400281583e-14,  7.100858521792306e-16, -3.655450171351601e-17,  1.680179182743612e-18, -6.991501051461483e-20,  2.662433196955186e-21, -9.349895835617878e-23,
  4.033422196774317e-11, -1.376073589048845e-11,  2.504170409729680e-12, -3.136664943572668e-13,  3.015963774740680e-14, -2.364595539608024e-15,  1.570523408464183e-16,
 -9.071699956544117e-18,  4.645021169410404e-19, -2.139146358364145e-20,  8.961574291542643e-22, -3.442545998470237e-23,  4.678182429660897e-12, -1.821231840742873e-12,
  3.783094461802333e-13, -5.367041878687991e-14,  5.795573050577641e-15, -5.062201395971096e-16,  3.718147634563411e-17, -2.359042783362776e-18,  1.318621422166822e-19,
 -6.591845396619980e-21,  2.982199391149886e-22, -1.231059536341789e-23,  6.897056813166365e-13, -2.908880806533223e-13,  6.563635683495339e-14, -1.007292584427179e-14,
  1.170601745141016e-15, -1.094811999543462e-16,  8.569245019592267e-18, -5.768359235986186e-19,  3.407030457182918e-20, -1.793019893113199e-21,  8.510426492943145e-23,
 -3.673796432769142e-24,  1.271703840724228e-01, -6.913470220892433e-04,  3.997579864877474e-06, -2.423012957020248e-08,  1.508438213374369e-10, -9.586429463744693e-13,
  6.070141183242266e-15, -3.935335052966099e-17,  2.413358928379488e-19, -1.683076958982083e-21,  8.104002905639859e-24, -8.970883096835355e-26,  1.009638739504931e-01,
 -7.333386854365419e-04,  6.863551608204472e-06, -6.523789607495155e-08,  5.991020907761166e-10, -5.316985002277389e-12,  4.583469296175182e-14, -3.861958358464120e-16,
  3.184359459058117e-18, -2.587203869130007e-20,  2.057094226254124e-22, -1.631066373165354e-24,  6.360777779621143e-02, -6.980134904746922e-04,  9.678709533777367e-06,
 -1.220852028922710e-07,  1.432816549216362e-09, -1.596245489856430e-11,  1.706885599448319e-13, -1.762824468248359e-15,  1.767860998771872e-17, -1.726222888040847e-19,
  1.648406714985164e-21, -1.538786954638648e-23,  3.176950279659336e-02, -5.300323900913944e-04,  9.778105894339684e-06, -1.550588925693026e-07,  2.250743650297345e-09,
 -3.058130030364874e-11,  3.939734225911500e-13, -4.852921773681330e-15,  5.753986282172379e-17, -6.595898441963475e-19,  7.341785183114575e-21, -7.951381559843610e-23,
  1.256373794624513e-02, -3.087785896395179e-04,  7.222888893974474e-06, -1.413958868340006e-07,  2.492803623046648e-09, -4.055377994369548e-11,  6.184640793921718e-13,
 -8.936614488494241e-15,  1.233225456473633e-16, -1.634596425572190e-18,  2.090828466832465e-20, -2.589381025976301e-22,  3.928659476097833e-03, -1.371743455947483e-04,
  3.991442289555272e-06, -9.539644270365508e-08,  2.017112544782901e-09, -3.882687669903818e-11,  6.932711140802715e-13, -1.162880416401280e-14,  1.849260718156887e-16,
 -2.806982936708516e-18,  4.088564729057549e-20, -5.737496578361597e-22,  9.703242545704277e-04, -4.663380678148167e-05,  1.674636426424997e-06, -4.847056506300894e-08,
  1.219102614501692e-09, -2.755752601868391e-11,  5.720650132305068e-13, -1.106450686621529e-14,  2.014651917465959e-16, -3.480221702056774e-18,  5.737942043914916e-20,
 -9.070112259611557e-22,  1.892627839772419e-04, -1.220421568059906e-05,  5.388958724035421e-07, -1.878459236182405e-08,  5.591937196124667e-10, -1.477691782205250e-11,
  3.551033922177161e-13, -7.886740832284898e-15,  1.637684639221154e-16, -3.206996894998649e-18,  5.962081689837542e-20, -1.057559852343064e-21,  2.920695132802021e-05,
 -2.476753308710032e-06,  1.342173761497456e-07, -5.615956197334092e-09,  1.973565779939946e-10, -6.082162076103291e-12,  1.688116950720877e-13, -4.295629057319033e-15,
  1.014973708517991e-16, -2.248064581402378e-18,  4.701894388723685e-20, -9.337363743869452e-22,  3.586250612463460e-06, -3.937204972585625e-07,  2.615475510092738e-08,
 -1.311801820868359e-09,  5.437404926169681e-11, -1.952779177195147e-12,  6.255173400314921e-14, -1.822157044960273e-15,  4.894529534813886e-17, -1.224917759403846e-18,
  2.879015748595910e-20, -6.392820537944613e-22,  3.548216940845119e-07, -4.980543032611804e-08,  4.052576880934616e-09, -2.436062255759183e-10,  1.191381347865865e-11,
 -4.988013795812637e-13,  1.844496586534355e-14, -6.151819908324881e-16,  1.878478120065579e-17, -5.310589943665483e-19,  1.402068226085063e-20, -3.478898717799133e-22,
  2.900050948214101e-08, -5.148611602784725e-09,  5.126046441777384e-10, -3.694129994633831e-11,  2.133328430479537e-12, -1.042095097727679e-13,  4.451633632523039e-15,
 -1.700707247887223e-16,  5.904834794793383e-18, -1.885695992249589e-19,  5.590650443627475e-21, -1.549229346230348e-22,  2.050233038548173e-09, -4.552513662127105e-10,
  5.532165553206392e-11, -4.776821802183620e-12,  3.257455585865285e-13, -1.856746618771260e-14,  9.162697158823242e-16, -4.008809722291243e-17,  1.581786946984489e-18,
 -5.701534668473508e-20,  1.896149167177900e-21, -5.860005096922434e-23,  1.359057365767691e-10, -3.719467797816589e-11,  5.481463351395774e-12, -5.648522529438276e-13,
  4.534681738064994e-14, -3.007824968656187e-15,  1.709988575042753e-16, -8.543221486580051e-18,  3.819232143242097e-19, -1.548698786717403e-20,  5.757059646397852e-22,
 -1.976731600767390e-23,  9.631377338327070e-12, -3.175173799016011e-12,  5.591278268912278e-13, -6.795602981170731e-14,  6.356743351795507e-15, -4.859895368170581e-16,
  3.154059856311528e-17, -1.783447659888557e-18,  8.953822371215959e-20, -4.048915335944719e-21,  1.667725614599190e-22, -6.306469210229006e-24,  8.715155613402712e-13,
 -3.334041430460780e-13,  6.805663162957220e-14, -9.499702866137930e-15,  1.010634529831999e-15, -8.707485763641554e-17,  6.315648690437474e-18, -3.960941075733614e-19,
  2.190497401524220e-20, -1.084274428096232e-21,  4.860640702989154e-23, -1.989546409509432e-24,  1.073782213460141e-13, -4.505552606037107e-14,  1.011211695474110e-14,
 -1.543986584938991e-15,  1.785795932131285e-16, -1.662798619328865e-17,  1.296144309020714e-18, -8.691525666613247e-20,  5.115217353652455e-21, -2.682989518271204e-22,
  1.269472675766634e-23, -5.464027431185442e-25,  1.244671718375491e-01, -6.604898073798907e-04,  3.720691265427680e-06, -2.196245547620447e-08,  1.330428229386151e-10,
 -8.253635518288770e-13,  5.067658792260570e-15, -3.254512405199458e-17,  1.856423335266923e-19, -1.436312157025203e-21,  4.283227850755469e-24, -8.242156881705891e-26,
  9.813559782219183e-02, -6.814064467679420e-04,  6.134885481653044e-06, -5.644669169630519e-08,  5.029428783253322e-10, -4.336006648624027e-12,  3.631834141486826e-14,
 -2.977410177757345e-16,  2.385270898894754e-18, -1.891828902764768e-20,  1.455952095654938e-22, -1.132957422235604e-24,  6.096182464950306e-02, -6.260770735894663e-04,
  8.341380018121567e-06, -1.015072543119304e-07,  1.150842188325755e-09, -1.239963048214405e-11,  1.283988658399518e-13, -1.285027628314196e-15,  1.250445270239333e-17,
 -1.184461820992370e-19,  1.099772447936655e-21, -9.962609745815402e-24,  2.979484539717297e-02, -4.586815284248809e-04,  8.114833261010180e-06, -1.234689797234060e-07,
  1.723653908807941e-09, -2.256852716355464e-11,  2.806674555284187e-13, -3.341084807738244e-15,  3.833486330365394e-17, -4.254576584905270e-19,  4.591725587085487e-21,
 -4.821391084678696e-23,  1.143432581078754e-02, -2.571612326411609e-04,  5.741079738290707e-06, -1.072708539477177e-07,  1.811984450924153e-09, -2.831651949439941e-11,
  4.156744924121596e-13, -5.790314465761554e-15,  7.714090437120754e-17, -9.881157228635392e-19,  1.222879822013556e-20, -1.466364302506310e-22,  3.437278584953216e-03,
 -1.093268299784763e-04,  3.017354489366332e-06, -6.853068631733816e-08,  1.383683111053204e-09, -2.551015385550445e-11,  4.373137008244168e-13, -7.055858489656172e-15,
  1.081047511914845e-16, -1.583062635790665e-18,  2.227313435102630e-20, -3.022305406430722e-22,  8.073178827202481e-04, -3.526922192240052e-05,  1.193992724809704e-06,
 -3.272172329659945e-08,  7.834791455929383e-10, -1.691880882326209e-11,  3.364376196987725e-13, -6.247034799511533e-15,  1.094034705622311e-16, -1.820594495676262e-18,
  2.895657031826641e-20, -4.421103999429196e-22,  1.478291252647028e-04, -8.662394707174942e-06,  3.587283634049935e-07, -1.180439331592675e-08,  3.336542749288290e-10,
 -8.404418903947047e-12,  1.931070664198137e-13, -4.110906008197164e-15,  8.199252077821580e-17, -1.544992066198004e-18,  2.768189820612362e-20, -4.739056126340842e-22,
  2.108578215046826e-05, -1.626893108985569e-06,  8.237326452478058e-08, -3.246402191332867e-09,  1.081066824623320e-10, -3.170545883452081e-12,  8.402502785765152e-14,
 -2.047151261600819e-15,  4.641910186490204e-17, -9.886311988963619e-19,  1.991788204081873e-20, -3.816176017573376e-22,  2.347690091603996e-06, -2.351722793606190e-07,
  1.456769396506067e-08, -6.873103433408168e-10,  2.696510650767502e-11, -9.207740464928887e-13,  2.814374634310182e-14, -7.846001788313029e-16,  2.021978860766301e-17,
 -4.865351972334142e-19,  1.101592183755511e-20, -2.360428331480334e-22,  2.056689343128672e-07, -2.646406582852919e-08,  2.008243794316437e-09, -1.135690353130532e-10,
  5.257461053622366e-12, -2.093245585842103e-13,  7.388396956559971e-15, -2.359364083955008e-16,  6.916063152185360e-18, -1.881272040590234e-19,  4.788656337730432e-21,
 -1.147688878408352e-22,  1.444984448938545e-08, -2.368092777215757e-09,  2.204858254672827e-10, -1.497899939586336e-11,  8.202555431039971e-13, -3.816835211599732e-14,
  1.558963104014812e-15, -5.712467537711179e-17,  1.907421433843429e-18, -5.871870765330375e-20,  1.681664294444426e-21, -4.510187678176407e-23,  8.470951021621416e-10,
 -1.753704717403460e-10,  2.004787208007979e-11, -1.639595572903893e-12,  1.064624419022079e-13, -5.802844164033266e-15,  2.748022646883359e-16, -1.157260310891801e-17,
  4.406750470474847e-19, -1.536445429166013e-20,  4.952715939362409e-22, -1.486391675031941e-23,  4.471764599986113e-11, -1.156653608962316e-11,  1.619469243076653e-12,
 -1.593738302159839e-13,  1.227223907895257e-14, -7.836259221182918e-16,  4.302073448335307e-17, -2.081138304945337e-18,  9.029660739231352e-20, -3.561088987081826e-21,
  1.289867868772878e-22, -4.322812239079959e-24,  2.435424744655554e-12, -7.719875357199127e-13,  1.309890669859689e-13, -1.539137227594170e-14,  1.396179330070807e-15,
 -1.037908072263159e-16,  6.565202397699300e-18, -3.625611473590463e-19,  1.781003817820612e-20, -7.892895990960203e-22,  3.190773106342092e-23, -1.185812604485946e-24,
  1.683775242496579e-13, -6.310288648414840e-14,  1.262198977554856e-14, -1.729100180093272e-15,  1.808226257344981e-16, -1.533697636202991e-17,  1.096546378073837e-18,
 -6.787052485736965e-20,  3.708139496161837e-21, -1.815063073762588e-22,  8.052897021213657e-24, -3.264818666672714e-25,  1.692475225854990e-14, -7.058860870585184e-15,
  1.574416243153346e-15, -2.389795783277732e-16,  2.748961187583623e-17, -2.546658671551170e-18,  1.975788538024608e-19, -1.319126370012921e-20,  7.731988274147714e-22,
 -4.040206542556758e-23,  1.904911926441068e-24, -8.172114568321026e-26,  1.218831240083381e-01, -6.317435005821375e-04,  3.469389757756699e-06, -1.995951860445879e-08,
  1.176812479694313e-10, -7.140503840185547e-13,  4.231986278384986e-15, -2.740551677222778e-17,  1.362095231738305e-19, -1.329641186300415e-21,  1.355158780807716e-24,
 -3.913803944637070e-26,  9.550402506611516e-02, -6.349063001633896e-04,  5.503091953789013e-06, -4.904869459092047e-08,  4.243059151224241e-10, -3.556373696765469e-12,
  2.895529099450884e-14, -2.312759882179002e-16,  1.798052428301214e-18, -1.398057561595781e-20,  1.038288140262905e-22, -7.831926577374810e-25,  5.858368225860369e-02,
 -5.639231698176231e-04,  7.226100844899653e-06, -8.492175566556364e-08,  9.309688685605626e-10, -9.708267256746748e-12,  9.743496694322320e-14, -9.454077199910294e-16,
  8.937028327421062e-18, -8.209892239156229e-20,  7.424585860664662e-22, -6.537087420015084e-24,  2.808119244306364e-02, -3.992526142248579e-04,  6.784885314335987e-06,
 -9.916497394936440e-08,  1.332726626233909e-09, -1.682947447063635e-11,  2.022191216197583e-13, -2.327750854371777e-15,  2.587059450027155e-17, -2.780568484671027e-19,
  2.912714399564327e-21, -2.967948985554239e-23,  1.049002875190602e-02, -2.159285101277068e-04,  4.610707511454730e-06, -8.231820173944990e-08,  1.333596994715976e-09,
 -2.003671707540242e-11,  2.833636212139185e-13, -3.807864352512547e-15,  4.901438396510611e-17, -6.070544812884927e-19,  7.274210235286259e-21, -8.450976279616330e-23,
  3.043525108518821e-03, -8.813648280882444e-05,  2.312662377882478e-06, -4.996388175322474e-08,  9.642499183043345e-10, -1.704158544304376e-11,  2.807032832732817e-13,
 -4.359407232111709e-15,  6.439493372147299e-17, -9.102518751834651e-19,  1.237797877396706e-20, -1.624958254858970e-22,  6.831282403157857e-04, -2.709795163117442e-05,
  8.666538302309927e-07, -2.250741009521843e-08,  5.134936092860648e-10, -1.060112473564083e-11,  2.020779993140924e-13, -3.604424527442449e-15,  6.074754783748476e-17,
 -9.743181221106362e-19,  1.495615160215973e-20, -2.206534956874735e-22,  1.181351944270803e-04, -6.279738141078234e-06,  2.442798307564345e-07, -7.593212469450564e-09,
  2.039271419191150e-10, -4.899281768284855e-12,  1.076889439668866e-13, -2.198393468046848e-15,  4.213296388045034e-17, -7.642039379937845e-19,  1.320024358102335e-20,
 -2.181627690149851e-22,  1.568540637041322e-05, -1.098522455890451e-06,  5.201023905601393e-08, -1.931255991080648e-09,  6.096444732677746e-11, -1.702041334806380e-12,
  4.308157772291587e-14, -1.005181938456985e-15,  2.187689918748118e-17, -4.480881062402338e-19,  8.696742773560298e-21, -1.607676884376884e-22,  1.596618605970582e-06,
 -1.454806373379071e-07,  8.402147111779704e-09, -3.728279710407940e-10,  1.384348790459922e-11, -4.494158245378575e-13,  1.310622204957566e-14, -3.496327455536437e-16,
  8.643321500407553e-18, -1.999336594828037e-19,  4.359902829138554e-21, -9.013049085528072e-23,  1.249798454994560e-07, -1.468454598219317e-08,  1.037979990974708e-09,
 -5.517216752570814e-11,  2.415902652145343e-12, -9.141474117060326e-14,  3.078009062972291e-15, -9.405586458901880e-17,  2.645251728625591e-18, -6.919455060441526e-20,
  1.697167997815617e-21, -3.926682969588019e-23,  7.619188784211082e-09, -1.147167752361583e-09,  9.964245243874518e-11, -6.369812937568687e-12,  3.302637384712401e-13,
 -1.461990699999685e-14,  5.702583786237072e-16, -2.001912040869935e-17,  6.421613903649362e-19, -1.903660259130953e-20,  5.261238848989200e-22, -1.364331388551732e-23,
  3.734043989628112e-10, -7.167225753876260e-11,  7.680010050493601e-12, -5.932290527643607e-13,  3.658994283618099e-14, -1.903088508608773e-15,  8.632088296925682e-17,
 -3.492838447286278e-18,  1.281458237358032e-19, -4.315019756802808e-21,  1.346213122323955e-22, -3.917930729267876e-24,  1.575520670966354e-11, -3.828192923345790e-12,
  5.069291278680637e-13, -4.746588661779336e-14,  3.494583445418673e-15, -2.142068949871733e-16,  1.132730922177361e-17, -5.293427908746920e-19,  2.224308953389244e-20,
 -8.514615356359680e-22,  2.999516864905341e-23, -9.794728327679166e-25,  6.553486416157863e-13, -1.986216894676231e-13,  3.232270272665630e-14, -3.657217040595574e-15,
  3.206049114041283e-16, -2.310386141248786e-17,  1.420463442830879e-18, -7.642411840501516e-20,  3.664971046434022e-21, -1.588499973680897e-22,  6.290660369519735e-24,
 -2.293586063324250e-25,  3.391255960685704e-14, -1.240471650146160e-14,  2.423176544362425e-15, -3.248238265455763e-16,  3.330427576892194e-17, -2.774438905564159e-18,
  1.951340488773089e-19, -1.189767617454714e-20,  6.411329560187669e-22, -3.098649525327453e-23,  1.358778597691083e-24, -5.449612438749115e-26,  2.706301106210244e-15,
 -1.120687146270594e-15,  2.481345541542294e-16, -3.740595518546016e-17,  4.275492997029337e-18, -3.937692395577938e-19,  3.038523832376494e-20, -2.018544592260293e-21,
  1.177697281425864e-22, -6.127471476839246e-24,  2.877519775533895e-25, -1.229887926286088e-26,  1.194101871209870e-01, -6.049154808781095e-04,  3.240718844194432e-06,
 -1.818560079075130e-08,  1.043561202722181e-10, -6.212423376726645e-13,  3.518522043664717e-15, -2.380363929622758e-17,  8.921358839131179e-20, -1.273416643205621e-21,
  2.675121897803305e-24,  1.305641262507809e-25,  9.304887773865678e-02, -5.931256615191331e-04,  4.953010340243589e-06, -4.279315250125409e-08,  3.596349049174427e-10,
 -2.933091652847038e-12,  2.321477770516391e-14, -1.810518115499383e-16,  1.361984126744833e-18, -1.043149972476658e-20,  7.566354010674796e-23, -5.021268605936287e-25,
  5.643749216411736e-02, -5.099513573333617e-04,  6.290393632404053e-06, -7.146097327406271e-08,  7.581998610638415e-10, -7.657707870288799e-12,  7.456084429990329e-14,
 -7.014987159675919e-16,  6.453304220697910e-18, -5.744536361393194e-20,  5.058145637729993e-22, -4.389660496990719e-24,  2.658568368554858e-02, -3.493949199901715e-04,
  5.712537362090552e-06, -8.029095829281080e-08,  1.039837344035830e-09, -1.267329606760694e-11,  1.472739377693274e-13, -1.639891972510062e-15,  1.767726338995209e-17,
 -1.839876713731456e-19,  1.871115404769084e-21, -1.859900901039225e-23,  9.694304614952881e-03, -1.826596083565149e-04,  3.738795195484841e-06, -6.385032081095717e-08,
  9.930707496623091e-10, -1.435654818044620e-11,  1.957783766178524e-13, -2.539450467316957e-15,  3.161142280133427e-17, -3.787111959013777e-19,  4.396108900198832e-21,
 -4.956667856726970e-23,  2.724523404170114e-03, -7.179488950402107e-05,  1.795497937732380e-06, -3.693416870056750e-08,  6.819862004106981e-10, -1.156379425000829e-11,
  1.831706259812901e-13, -2.739931610078588e-15,  3.904933814823726e-17, -5.331053628299533e-19,  7.010337545655944e-21, -8.910516161310932e-23,  5.870702352054712e-04,
 -2.111996375328666e-05,  6.396320554385983e-07, -1.575492268002239e-08,  3.428063687873520e-10, -6.771383574650952e-12,  1.238209551147127e-13, -2.122880807459679e-15,
  3.445219016765775e-17, -5.328426552071010e-19,  7.897837562899200e-21, -1.126467837287097e-22,  9.641715947644913e-05, -4.641133881925235e-06,  1.699084079525726e-07,
 -4.992317739661848e-09,  1.274923196680526e-10, -2.923247829448325e-12,  6.150423868084666e-14, -1.204621274757605e-15,  2.219446633399793e-17, -3.876474170058590e-19,
  6.457480198845167e-21, -1.030626509475067e-22,  1.199711239167188e-05, -7.608229435229554e-07,  3.372328902823840e-08, -1.180288946065623e-09,  3.533678623000457e-11,
 -9.395256175411067e-13,  2.272121132379608e-14, -5.078371745541023e-16,  1.061128755551964e-17, -2.090608361419605e-19,  3.909479748586156e-21, -6.973812462548416e-23,
  1.125332884622754e-06, -9.298035531532159e-08,  5.008026882586614e-09, -2.089891014351798e-10,  7.344837717616915e-12, -2.267037481450582e-13,  6.308120796488441e-15,
 -1.610273589928179e-16,  3.818489732857409e-18, -8.490495676738436e-20,  1.783049072894199e-21, -3.555698495861070e-23,  7.942892279305623e-08, -8.488554576884768e-09,
  5.584199412123506e-10, -2.787914419374383e-11,  1.154149346787579e-12, -4.148531200764750e-14,  1.331940640086015e-15, -3.893023676447987e-17,  1.050022052677343e-18,
 -2.640126158223981e-20,  6.236957121484570e-22, -1.392395573013714e-23,  4.243319714206621e-09, -5.841393273407323e-10,  4.723427639974669e-11, -2.836850963838924e-12,
  1.390861688692280e-13, -5.850704895003514e-15,  2.177112727653415e-16, -7.315029003049909e-18,  2.252086879332197e-19, -6.423201941260495e-21,  1.711593706230136e-22,
 -4.287758146176707e-24,  1.755007351767005e-10, -3.105274570499916e-11,  3.108306406575412e-12, -2.261668745240648e-13,  1.322170180509318e-14, -6.549251401770346e-16,
  2.840263883676037e-17, -1.102460223470448e-18,  3.890998257495979e-20, -1.263536369654034e-21,  3.809968796422396e-23, -1.073841073823180e-24,  5.954686419738738e-12,
 -1.350417311861770e-12,  1.683485439480018e-13, -1.494249853540687e-14,  1.048506657573433e-15, -6.152512866739379e-17,  3.125942305094978e-18, -1.407936355846433e-19,
  5.717543113048340e-21, -2.120225595851442e-22,  7.250879917519606e-24, -2.303021305201432e-25,  1.885713015118652e-13, -5.430127750943328e-14,  8.432278449625013e-15,
 -9.148269372128470e-16,  7.721733321111087e-17, -5.376702870804846e-18,  3.203739926136800e-19, -1.674889251284509e-20,  7.822503990464563e-22, -3.308701118887430e-23,
  1.280976959428182e-24, -4.573526004287593e-26,  7.162195234532847e-15, -2.545672473861946e-15,  4.837331219109185e-16, -6.323384657152709e-17,  6.337516414368094e-18,
 -5.171716611878234e-19,  3.569800806009720e-20, -2.139621827131059e-21,  1.135051481031418e-22, -5.407415858849507e-24,  2.339980748487793e-25, -9.271105403438807e-27,
  4.401235938904906e-16, -1.807049503518629e-16,  3.966470739533030e-17, -5.931229958454477e-18,  6.729181313654351e-19, -6.155430660529382e-20,  4.720232278095796e-21,
 -3.117750001376702e-22,  1.809396797305169e-23, -9.368133303688291e-25,  4.379434640466865e-26, -1.863967841794108e-27,  1.170410334573059e-01, -5.798351696805688e-04,
  3.032114058173203e-06, -1.661093482679532e-08,  9.272322351057041e-11, -5.445144745468762e-13,  2.885336199209458e-15, -2.164463876062091e-17,  4.758358103714918e-20,
 -9.480267118971554e-22,  1.672398599833986e-23,  5.617592715793495e-25,  9.075250343804715e-02, -5.554620992590243e-04,  4.472175174309278e-06, -3.747965587158514e-08,
  3.061580461602183e-10, -2.432172552781848e-12,  1.870297851296183e-14, -1.429311267291752e-16,  1.036339810522838e-18, -7.765601393608640e-21,  5.969049287308958e-23,
 -2.187238634144868e-25,  5.449317855885503e-02, -4.628631441971268e-04,  5.500892710068804e-06, -6.046406302875956e-08,  6.214622775762812e-10, -6.082396132192082e-12,
  5.752485113274308e-14, -5.245276466794104e-16,  4.706916590208550e-18, -4.064649359938430e-20,  3.433947437091473e-22, -3.113736979676470e-24,  2.527377787326578e-02,
 -3.072838401339229e-04,  4.841087907459444e-06, -6.550377830898824e-08,  8.183040351736505e-10, -9.631445065809094e-12,  1.083750297257488e-13, -1.167215339912999e-15,
  1.222417964422035e-17, -1.233121999305594e-19,  1.210546420962316e-21, -1.199770600534392e-23,  9.018988801244287e-03, -1.555642224649217e-04,  3.059216348664373e-06,
 -5.002521078071071e-08,  7.477085213330872e-10, -1.040829746814809e-11,  1.370054206192253e-13, -1.715933932258881e-15,  2.067975938318882e-17, -2.398086898107078e-19,
  2.693331411773638e-21, -2.965227414148798e-23,  2.463505333511015e-03, -5.903439091627081e-05,  1.410834581473591e-06, -2.765749533810773e-08,  4.891180850136638e-10,
 -7.963086268762370e-12,  1.214070698892114e-13, -1.750134501436158e-15,  2.408500935435895e-17, -3.177630587048067e-19,  4.041096646969129e-21, -4.982313360963379e-23,
  5.117463958081515e-04, -1.667523571889791e-05,  4.794860208238560e-07, -1.121015547273972e-08,  2.328568917810058e-10, -4.404152052553612e-12,  7.731549917146531e-14,
 -1.274882582101850e-15,  1.993612737103363e-17, -2.974884569403983e-19,  4.259229082379222e-21, -5.877398242514957e-23,  8.023543450714856e-05, -3.490793827250918e-06,
  1.205421212181970e-07, -3.350132091393418e-09,  8.142219973130280e-11, -1.782953356876261e-12,  3.592993917888053e-14, -6.755234788445237e-16,  1.197099036690171e-17,
 -2.014261090207371e-19,  3.237053471640309e-21, -4.991169583179436e-23,  9.415594022354655e-06, -5.393359583519399e-07,  2.241631758315993e-08, -7.398198192308538e-10,
  2.101988332458366e-11, -5.324865502465611e-13,  1.230898139054287e-14, -2.636399631173146e-16,  5.290479635663008e-18, -1.002862545161021e-19,  1.807311883492404e-21,
 -3.111540863580722e-23,  8.200819347348576e-07, -6.124768280840829e-08,  3.078622268822986e-09, -1.208349482218452e-10,  4.020452434302096e-12, -1.180049639412424e-13,
  3.133399920736643e-15, -7.654595449775921e-17,  1.741257354399763e-18, -3.721764380098237e-20,  7.526801907473212e-22, -1.447828035686100e-23,  5.266292613414059e-08,
 -5.098835862218774e-09,  3.120446175169187e-10, -1.462562439788347e-11,  5.722543787851836e-13, -1.953413313747796e-14,  5.978632193472748e-16, -1.670958008794416e-17,
  4.320916342383985e-19, -1.043960522105726e-20,  2.374539289242011e-22, -5.113301248083638e-24,  2.490557426741493e-09, -3.119456418729071e-10,  2.344231913348947e-11,
 -1.321013100336539e-12,  6.118094553278192e-14, -2.443323275209698e-15,  8.666216536951498e-17, -2.784670688051187e-18,  8.221870457736942e-20, -2.254355715142020e-21,
  5.787490130873750e-23, -1.399547936355127e-24,  8.784857912635254e-11, -1.424428399521866e-11,  1.327729782025172e-12, -9.078532782066545e-14,  5.020281114671363e-15,
 -2.364166598529530e-16,  9.787294107300549e-18, -3.638851889614735e-19,  1.233749224461733e-20, -3.858538161977724e-22,  1.123060805624053e-23, -3.061688951041455e-25,
  2.417030387156090e-12, -5.081169010470485e-13,  5.936194831098352e-14, -4.976537661990485e-15,  3.318010713345814e-16, -1.858795019999548e-17,  9.051908261114072e-19,
 -3.920738675259197e-20,  1.535562549621162e-21, -5.505623436778335e-23,  1.824530893226002e-24, -5.627066744539496e-26,  5.828509633319381e-14, -1.583507652162438e-14,
  2.333709699321663e-15, -2.416783225146957e-16,  1.956559473158881e-17, -1.311920864308671e-18,  7.553159399633343e-20, -3.826457580822119e-21,  1.736170460627664e-22,
 -7.149977268309222e-24,  2.700510298684788e-25, -9.423188801649979e-27,  1.596489353040235e-15, -5.484510208361531e-16,  1.009119897110007e-16, -1.281292922487230e-17,
  1.250961218531934e-18, -9.969923433044502e-20,  6.735886848974751e-21, -3.959311195615050e-22,  2.063312374007494e-23, -9.670623570277207e-25,  4.122567096295918e-26,
 -1.611031457599495e-27,  7.302526325461197e-17, -2.967444789797113e-17,  6.446363733448274e-18, -9.547558583640880e-19,  1.073768014741495e-19, -9.744158713258877e-21,
  7.418036446839392e-22, -4.867151028345415e-23,  2.807458120064278e-24, -1.445406359334593e-25,  6.722036411898353e-27, -2.847350093384903e-28,  1.147689787165369e-01,
 -5.563511655991817e-04,  2.841336521477726e-06, -1.521092639718148e-08,  8.247710136710456e-11, -4.823924535455455e-13,  2.296730069525572e-15, -2.047894854344716e-17,
  3.324758054875336e-20,  4.167997004574022e-22,  5.703733244884694e-23,  1.315404404542539e-24,  8.859947427224397e-02, -5.214039913011577e-04,  4.050280681253631e-06,
 -3.294718249111574e-08,  2.616974719003827e-10, -2.027820728012715e-12,  1.512636285506163e-14, -1.137937937632218e-16,  7.982697389060115e-19, -5.478358944966921e-21,
  5.701146921177982e-23,  1.014499969652473e-25,  5.272537203412048e-02, -4.215980212990993e-04,  4.831199993015296e-06, -5.142354128844847e-08,  5.125132404740629e-10,
 -4.862284428990210e-12,  4.474421778262747e-14, -3.949211020111560e-16,  3.460039094130280e-18, -2.942009486733155e-20,  2.226924107800332e-22, -2.455011086781234e-24,
  2.411741765238632e-02, -2.714905132891495e-04,  4.127672221920828e-06, -5.382098999491314e-08,  6.492500747126659e-10, -7.382217865009411e-12,  8.056311425443415e-14,
 -8.386762226322417e-16,  8.541337367718564e-18, -8.415992811027169e-20,  7.749501727112364e-22, -8.151466050536227e-24,  8.442145088134824e-03, -1.333030609492943e-04,
  2.524361466539237e-06, -3.956363264511511e-08,  5.688872646001457e-10, -7.629235472534214e-12,  9.706060570927011e-14, -1.173831939521145e-15,  1.370718293718930e-17,
 -1.543375193971984e-19,  1.663193978006269e-21, -1.820443783111489e-23,  2.248012218681593e-03, -4.895338604560127e-05,  1.121115132695796e-06, -2.096260456841726e-08,
  3.554337429309080e-10, -5.559822720365743e-12,  8.167349430859942e-14, -1.135083395993923e-15,  1.509452272082466e-17, -1.927246397501618e-19,  2.365703594109109e-21,
 -2.843156831635702e-23,  4.519466060085622e-04, -1.332019263069436e-05,  3.647079619611360e-07, -8.099246145034708e-09,  1.607726215676615e-10, -2.913685721680671e-12,
  4.914824431454505e-14, -7.798647520925242e-16,  1.175830917870003e-17, -1.694203269930899e-19,  2.342664593384958e-21, -3.132297168974349e-23,  6.797436414377356e-05,
 -2.667551088610873e-06,  8.711621814756622e-08, -2.291526798989645e-09,  5.305245409597298e-11, -1.110226267962735e-12,  2.144421703396532e-14, -3.872249473394050e-16,
  6.603542596474947e-18, -1.070994813801999e-19,  1.660879356384377e-21, -2.475518370757861e-23,  7.567807170168966e-06, -3.905156562061042e-07,  1.525082703472256e-08,
 -4.748525988261200e-10,  1.281270911931894e-11, -3.094198492421223e-13,  6.840306479727680e-15, -1.404557026111963e-16,  2.707853128863958e-18, -4.940372959204940e-20,
  8.582202070952422e-22, -1.426434393389749e-23,  6.165025935487228e-07, -4.148124773677496e-08,  1.948169207304264e-09, -7.193202300441447e-11,  2.266718061664360e-12,
 -6.328384972100838e-14,  1.603953888922772e-15, -3.750477691138995e-17,  8.185393100761335e-19, -1.681962646865600e-20,  3.275917850926101e-22, -6.078524520700525e-24,
  3.633488566587241e-08, -3.174171776730425e-09,  1.807308577435143e-10, -7.950247541308679e-12,  2.939706755599619e-13, -9.528578811665814e-15,  2.779697088905593e-16,
 -7.427714222353264e-18,  1.841136392398548e-19, -4.273524991173314e-21,  9.356777623946693e-23, -1.942975720286723e-24,  1.536838854722898e-09, -1.742669549962716e-10,
  1.215562274154034e-11, -6.420277130919757e-13,  2.806589423175830e-14, -1.063342928766654e-15,  3.592592346076831e-17, -1.103265982545107e-18,  3.121960357421164e-20,
 -8.224095226478251e-22,  2.032812221818342e-23, -4.742235447233125e-25,  4.675622851545815e-11, -6.905489603242914e-12,  5.977203168862116e-13, -3.832482689934486e-14,
  2.001199144302711e-15, -8.945801373803973e-17,  3.530304936759147e-18, -1.255571021255043e-19,  4.084381382770185e-21, -1.228771194211588e-22,  3.448221006720288e-24,
 -9.082444012797045e-26,  1.054101653118020e-12, -2.039461114175684e-13,  2.222975021742103e-14, -1.754096592434658e-15,  1.108008480876184e-16, -5.910981508067883e-18,
  2.752626317631699e-19, -1.144144236849307e-20,  4.313181886468443e-22, -1.492450345301376e-23,  4.784338669233825e-25, -1.430395714367270e-26,  1.943063441221241e-14,
 -4.942025648912448e-15,  6.872770094497391e-16, -6.762259054955711e-17,  5.229972459813345e-18, -3.365223730940108e-19,  1.866223967910274e-20, -9.135861375940671e-22,
  4.016658514330153e-23, -1.606761870490389e-24,  5.907463127673012e-26, -2.010548694743955e-27,  3.782729582962452e-16, -1.248037627782470e-16,  2.211623582144440e-17,
 -2.715268133170042e-18,  2.572419163372351e-19, -1.995468898003639e-20,  1.315643922010217e-21, -7.563718939428729e-23,  3.862857189815138e-24, -1.777369081254747e-25,
  7.449631799440354e-27, -2.866290634071008e-28,  1.240954528665025e-17, -4.979522752246786e-18,  1.068300519538513e-18, -1.564221269511828e-19,  1.741051672976262e-20,
 -1.565190189821104e-21,  1.181437384892421e-22, -7.691793677681218e-24,  4.405441529213721e-25, -2.253447448294214e-26,  1.041761102825735e-27, -4.388609850343812e-29,
  1.125879101359124e-01, -5.343288788594594e-04,  2.666414002064514e-06, -1.396567307230866e-08,  7.333476860277803e-11, -4.339989452471093e-13,  1.744339511542353e-15,
 -1.860633627683292e-17,  1.055479231518108e-19,  4.103401917612333e-21,  1.329376482140255e-22,  2.073093639588394e-24,  8.657625539525941e-02, -4.905149882103644e-04,
  3.678760140973199e-06, -2.906578304159342e-08,  2.245275031709751e-10, -1.700302367084001e-12,  1.227132867795900e-14, -9.095025116973724e-17,  6.440152106276062e-19,
 -3.017533971102339e-21,  6.807105655622389e-23,  3.769731359880368e-25,  5.111255847653141e-02, -3.852843771278786e-04,  4.260288903463347e-06, -4.394649501221413e-08,
  4.251711988586765e-10, -3.909527460901245e-12,  3.508836959461084e-14, -2.996312070474950e-16,  2.536224693610297e-18, -2.256554568354156e-20,  1.223718299111895e-22,
 -2.126034678875530e-24,  2.309364329158991e-02, -2.408865229545643e-04,  3.539595831698309e-06, -4.451655177330406e-08,  5.191872135632374e-10, -5.702214960434324e-12,
  6.049004588798111e-14, -6.085020997244958e-16,  5.990056729193885e-18, -5.958887655089734e-20,  4.700322763968284e-22, -5.877774903369024e-24,  7.946519927685504e-03,
 -1.148633124621570e-04,  2.099557218781655e-06, -3.156589173368663e-08,  4.371707783300681e-10, -5.649334313883932e-12,  6.958200983785678e-14, -8.126890089012532e-16,
  9.176217520297703e-18, -1.016071743995484e-19,  1.021760019859398e-21, -1.151821966468034e-23,  2.068669513987967e-03, -4.090180094510560e-05,  9.003336940836528e-07,
 -1.606863422355289e-08,  2.615216368086134e-10, -3.932278807539088e-12,  5.572775724454983e-14, -7.470020548278448e-16,  9.595598834385729e-18, -1.191209435484044e-19,
  1.400372876966342e-21, -1.657070423947017e-23,  4.039420008231247e-04, -1.075160900070183e-05,  2.812171594721771e-07, -5.935710283763175e-09,  1.127237338448360e-10,
 -1.958694341871848e-12,  3.177770211384708e-14, -4.854891358146745e-16,  7.059467455054533e-18, -9.839956033563372e-20,  1.311671905433910e-21, -1.704241435319607e-23,
  5.854221893508804e-05, -2.067706933605988e-06,  6.405963364331917e-08, -1.595658766610019e-09,  3.522611827365670e-11, -7.049460817691030e-13,  1.306108747733147e-14,
 -2.266427610595268e-16,  3.721027779734048e-18, -5.822103340305264e-20,  8.711036218383931e-22, -1.256301259027965e-23,  6.218034662269645e-06, -2.882352645274259e-07,
  1.060402116160366e-08, -3.116165850722550e-10,  7.991837029052081e-12, -1.840877004620436e-13,  3.894260459430774e-15, -7.669438457176193e-17,  1.421073838445645e-18,
 -2.496582468192860e-20,  4.181246067407871e-22, -6.711847072372677e-24,  4.770402622328378e-07, -2.881626540964352e-08,  1.266736219343885e-09, -4.400855867470355e-11,
  1.314143809752471e-12, -3.491124647199488e-14,  8.448931269743996e-16, -1.891484552964884e-17,  3.961510856490937e-19, -7.827400051263956e-21,  1.468363542278384e-22,
 -2.628499390979476e-24,  2.602205268067092e-08, -2.042413300776328e-09,  1.082664610179050e-10, -4.469147202836493e-12,  1.561855235256558e-13, -4.807204362772204e-15,
  1.336684485356043e-16, -3.414811736511712e-18,  8.113118298217460e-20, -1.809000463129092e-21,  3.812085463767155e-23, -7.632236453238448e-25,  9.944416439966429e-10,
 -1.015622610299079e-10,  6.571085032420027e-12, -3.250352476522758e-13,  1.340399058060912e-14, -4.815423467266858e-16,  1.548974235334530e-17, -4.543952795842575e-19,
  1.231736852350716e-20, -3.115806257180119e-22,  7.411354756778680e-24, -1.667027459162662e-25,  2.640583510871563e-11, -3.530072153231428e-12,  2.830829696286563e-13,
 -1.698932666659065e-14,  8.364639762147168e-16, -3.544783935183801e-17,  1.331900745677033e-18, -4.526240980088355e-20,  1.411153787990619e-21, -4.079542664183891e-23,
  1.102639449679041e-24, -2.803196931067268e-26,  4.937757596092932e-13, -8.726508245045628e-14,  8.837215457683607e-15, -6.542275290417357e-16,  3.904708036193944e-17,
 -1.978978536413638e-18,  8.793842975463097e-20, -3.500745184785310e-21,  1.267923024880150e-22, -4.226697110550530e-24,  1.308522526959008e-25, -3.786449651351533e-27,
  7.010405131212330e-15, -1.655083165718412e-15,  2.159090715673867e-16, -2.008809291762032e-17,  1.478276390019324e-18, -9.095912849606988e-20,  4.843552125307345e-21,
 -2.284724773980114e-22,  9.708227170633318e-24, -3.763213189093327e-25,  1.343846434685736e-26, -4.451681105476022e-28,  9.599643434789826e-17, -3.018856215368130e-17,
  5.120824928839839e-18, -6.048059343865372e-19,  5.535820735900672e-20, -4.163825473974143e-21,  2.670090409741499e-22, -1.496946313925144e-23,  7.472283534190345e-25,
 -3.367148395852129e-26,  1.384594154019694e-27, -5.234839298797632e-29,  2.170336370136017e-18, -8.574230575192896e-19,  1.811758962475539e-19, -2.616479298803756e-20,
  2.876410247014966e-21, -2.557228665732099e-22,  1.910958773972088e-23, -1.232877919362680e-24,  7.003172385454310e-26, -3.555348036987125e-27,  1.632339787114077e-28,
 -6.833291047189997e-30,  1.104922231617563e-01, -5.136486178379482e-04,  2.505586528920056e-06, -1.285965010897831e-08,  6.503393187053926e-11, -3.978271615873366e-13,
  1.301229611398696e-15, -1.165619478342443e-17,  3.714997341843308e-19,  1.128011053848541e-20,  2.235419595156860e-22,  1.715439349389480e-24,  8.467092954223389e-02,
 -4.624214778170059e-04,  3.350452751947981e-06, -2.573021460069718e-08,  1.932719800885299e-10, -1.434101748337325e-12,  1.000085408100964e-14, -7.152005355533052e-17,
  5.886357978352841e-19,  5.672284241661431e-23,  8.517019522885441e-23,  3.029630396758206e-25,  4.963640144585701e-02, -3.532015098318706e-04,  3.771307906365681e-06,
 -3.772622179921365e-08,  3.547666152068834e-10, -3.159632950542482e-12,  2.771850568566653e-14, -2.307017147749590e-16,  1.790422560172305e-18, -1.942631650514340e-20,
  3.831144262112209e-23, -1.601025628246667e-24,  2.218353602806258e-02, -2.145735140211888e-04,  3.051716287724731e-06, -3.704845918748099e-08,  4.183844073031017e-10,
 -4.435114886133743e-12,  4.583613522781646e-14, -4.479887698852676e-16,  4.125804312893082e-18, -4.542707887080060e-20,  2.514155925718972e-22, -4.021428720916939e-24,
  7.518417836342392e-03, -9.947114068159659e-05,  1.759280474636415e-06, -2.539149836100032e-08,  3.391986910439464e-10, -4.222369196676510e-12,  5.043867868836106e-14,
 -5.705948465487216e-16,  6.144550570424423e-18, -6.950697811019564e-20,  6.140779752631100e-22, -7.258339539493410e-24,  1.918339531635319e-03, -3.440482982455652e-05,
  7.302382187122197e-07, -1.244731806948712e-08,  1.947203313159818e-10, -2.814716221434618e-12,  3.853536303157624e-14, -4.990307056987789e-16,  6.160925853452439e-18,
 -7.542363645199362e-20,  8.337267275793562e-22, -9.772127021273681e-24,  3.650235992954109e-04, -8.758854174052812e-06,  2.196399974731091e-07, -4.408284740403269e-09,
  8.019465422909854e-11, -1.336571202992335e-12,  2.087861381059162e-14, -3.074431254651056e-16,  4.304946086790658e-18, -5.834760330403254e-20,  7.459453248399142e-22,
 -9.438814490543987e-24,  5.118731679397784e-05, -1.623210653959710e-06,  4.787797899322910e-08, -1.129738790250045e-09,  2.380994883885378e-11, -4.558972341954942e-13,
  8.109356420674334e-15, -1.353300695139361e-16,  2.138643041880848e-18, -3.234541916433261e-20,  4.663876431426096e-22, -6.514170407380262e-24,  5.213812583011947e-06,
 -2.164370159542591e-07,  7.524996425628171e-09, -2.087703961298163e-10,  5.094174123312664e-12, -1.119840597624523e-13,  2.268396202909343e-15, -4.287298703417441e-17,
  7.636513318839059e-19, -1.292947183245735e-20,  2.087549913314725e-22, -3.237771597134645e-24,  3.791410376897058e-07, -2.048404631410454e-08,  8.448822038329868e-10,
 -2.762359056662974e-11,  7.822241499414458e-13, -1.978153216329765e-14,  4.573283564403767e-16, -9.806121914031364e-18,  1.971313360552218e-19, -3.746687471884457e-21,
  6.770295558358486e-23, -1.169419402881180e-24,  1.929660169719337e-08, -1.354635082011058e-09,  6.694474989159907e-11, -2.592937671193514e-12,  8.567156967469394e-14,
 -2.504246233967653e-15,  6.638074821649800e-17, -1.621433920895538e-18,  3.692484468359301e-20, -7.909157507598233e-22,  1.604028570676919e-23, -3.096118849054202e-25,
  6.729519203565843e-10, -6.156873114130576e-11,  3.694911263658610e-12, -1.710592116752968e-13,  6.652766919004264e-15, -2.265513227983358e-16,  6.936128158529108e-18,
 -1.943043679466805e-19,  5.043719146622004e-21, -1.224720642040744e-22,  2.802278451994291e-24, -6.074863087303553e-26,  1.578583788587701e-11, -1.897793536706967e-12,
  1.407529150157202e-13, -7.894656053609871e-15,  3.660638696682419e-16, -1.469104736628115e-17,  5.250471686967074e-19, -1.703309207489952e-20,  5.084932675083758e-22,
 -1.411320906843587e-23,  3.670802916245789e-25, -8.999360952389224e-27,  2.481881595713398e-13, -3.974978846621247e-14,  3.725807822366063e-15, -2.580183227728387e-16,
  1.451545018284583e-17, -6.974193464838491e-19,  2.951488661891453e-20, -1.123286777438273e-21,  3.902144393626263e-23, -1.251177542087091e-24,  3.734981302844175e-26,
 -1.044511273582497e-27,  2.744332441013202e-15, -5.958677123564250e-16,  7.248156545038899e-17, -6.346826069161400e-18,  4.426546545258195e-19, -2.595562233725896e-20,
  1.323045963641585e-21, -5.996654817823500e-23,  2.456316196872861e-24, -9.204416280454956e-26,  3.185368604139580e-27, -1.024916367773335e-28,  2.629786164309470e-17,
 -7.812594249996735e-18,  1.259778531943759e-18, -1.423228719896098e-19,  1.252522106589799e-20, -9.096878097748486e-22,  5.652946473594447e-23, -3.080527151976950e-24,
  1.498580408133496e-25, -6.596106340418372e-27,  2.654708429096324e-28, -9.841325448606298e-30,  3.930294012978783e-19, -1.522804124858765e-19,  3.158259680890606e-20,
 -4.485368417584406e-21,  4.858039479586630e-22, -4.261930906321492e-23,  3.147139635281911e-24, -2.008772875408100e-25,  1.130056165432810e-26, -5.686849209928307e-28,
  2.590153026945209e-29, -1.076408534186656e-30,  1.084767649305967e-01, -4.942040936897474e-04,  2.357256682274971e-06, -1.188114410435086e-08,  5.737201694120533e-11,
 -3.687308706294523e-13,  1.215314809560359e-15,  8.564450114477112e-18,  9.506064222869946e-19,  2.100252127274436e-20,  2.370207420593721e-22, -1.833057916207444e-24,
  8.287296682398136e-02, -4.368024344550816e-04,  3.059338255613432e-06, -2.285492040299661e-08,  1.668390382297902e-10, -1.215957621924781e-12,  8.267097702080080e-15,
 -5.197792383349738e-17,  6.535270644570681e-19,  3.528915887692308e-21,  8.134181957018738e-23, -6.820991547092026e-25,  4.828119932169703e-02, -3.247499869782025e-04,
  3.350676826538754e-06, -3.252144029579238e-08,  2.977339118442027e-10, -2.566069116580500e-12,  2.195723458241441e-14, -1.844205181681597e-16,  1.104723796451796e-18,
 -1.894910655236558e-20, -3.094415860431186e-24, -2.606108639033080e-26,  2.137140598589260e-02, -1.918306824014425e-04,  2.644555068657903e-06, -3.100817191059709e-08,
  3.397376614609477e-10, -3.472102491471544e-12,  3.490698823625810e-14, -3.404937624142907e-16,  2.635073634831936e-18, -3.820025157890082e-20,  1.302611906103684e-22,
 -1.206808655931618e-24,  7.146874305220611e-03, -8.652944288974533e-05,  1.484557916445743e-06, -2.057918672256853e-08,  2.656680697590624e-10, -3.183498972247745e-12,
  3.686910080352805e-14, -4.098262385828944e-16,  4.017033717593838e-18, -5.028310707081331e-20,  3.728932163860746e-22, -3.697972896156874e-24,  1.791527543884304e-03,
 -2.911140537262956e-05,  5.978565325604690e-07, -9.736277243180071e-09,  1.466479568969398e-10, -2.037561923934147e-12,  2.695584443383329e-14, -3.396446470322659e-16,
  3.955118269817480e-18, -4.929670870903413e-20,  5.034870727340597e-22, -5.511002986607158e-24,  3.331957155354233e-04, -7.193387094591007e-06,  1.736379481953721e-07,
 -3.314465731765739e-09,  5.784972107978032e-11, -9.249721186692312e-13,  1.391983496854353e-14, -1.982585779787903e-16,  2.654606582481955e-18, -3.540522887293071e-20,
  4.315618891348967e-22, -5.240778795502822e-24,  4.538297046107425e-05, -1.288568114645391e-06,  3.633701735448959e-08, -8.123103931455988e-10,  1.636715007491859e-11,
 -2.999700899437375e-13,  5.125926476400417e-15, -8.241821505290707e-17,  1.250833010870043e-18, -1.836665033023681e-20,  2.548071547239853e-22, -3.435707392358535e-24,
  4.454351615904972e-06, -1.650252482412072e-07,  5.443458021671531e-09, -1.425865341551635e-10,  3.314307743847713e-12, -6.956519524268744e-14,  1.350150100396285e-15,
 -2.451447323312887e-17,  4.195384534384855e-19, -6.856937414223588e-21,  1.067055631489446e-22, -1.598335171104085e-24,  3.088886782824711e-07, -1.486476592902948e-08,
  5.771412275420405e-10, -1.775865338965028e-11,  4.773279740228097e-13, -1.149584560703828e-14,  2.540095631882994e-16, -5.219691923703550e-18,  1.007207512497785e-19,
 -1.842582284852878e-21,  3.207545442518358e-23, -5.346207459320862e-25,  1.478061883254201e-08, -9.235474305119710e-10,  4.264450774843796e-11, -1.549643485699630e-12,
  4.843325194412107e-14, -1.344852310807072e-15,  3.399180474557012e-17, -7.940663994401790e-19,  1.733380331323070e-20, -3.567312442174651e-22,  6.962816234015224e-24,
 -1.295677600773252e-25,  4.749599523677951e-10, -3.870433722913025e-11,  2.156276050921349e-12, -9.338558453354751e-14,  3.425148456652546e-15, -1.105452094687092e-16,
  3.220826419371369e-18, -8.614659703284990e-20,  2.140868404863427e-21, -4.988982533344582e-23,  1.097771906809174e-24, -2.292896355538167e-26,  9.962604454885115e-12,
 -1.069715438739862e-12,  7.330608423657329e-14, -3.837765153784232e-15,  1.674492397730910e-16, -6.358831142429186e-18,  2.160006017745373e-19, -6.684326167453475e-21,
  1.909335522339694e-22, -5.084016597677871e-24,  1.271549724970161e-25, -3.003930731086995e-27,  1.336295063149406e-13, -1.923439529075682e-14,  1.663349514150501e-15,
 -1.074728761563539e-16,  5.687089339541644e-18, -2.585571412706833e-19,  1.040338648860329e-20, -3.779206205924790e-22,  1.257292313774533e-23, -3.871943810666805e-25,
  1.112960020582603e-26, -3.003916905798881e-28,  1.167474871600139e-15, -2.308036059206251e-16,  2.602622453485378e-17, -2.135120881827338e-18,  1.405964549037675e-19,
 -7.830259836382478e-21,  3.809370366512630e-22, -1.654518154444200e-23,  6.516667469969904e-25, -2.355128677966687e-26,  7.881308397345558e-28, -2.458017816722794e-29,
  7.837641334036533e-18, -2.176757518733851e-18,  3.311076643424045e-19, -3.555997207197816e-20,  2.993325749657114e-21, -2.089800729825635e-22,  1.253492921168812e-23,
 -6.616338520683245e-25,  3.126894444088147e-26, -1.340554228937113e-27,  5.266971253778126e-29, -1.909994932303532e-30,  7.426125745446555e-20, -2.807380519013961e-20,
  5.689509753786307e-21, -7.916672384391150e-22,  8.421179858938928e-23, -7.270860243213932e-24,  5.293316719910180e-25, -3.336009182610663e-26,  1.855410698228724e-27,
 -9.241401256922222e-29,  4.170004914235158e-30, -1.718334951406088e-31,  1.065367830015206e-01, -4.759012794458161e-04,  2.219952830153284e-06, -1.102045108183288e-08,
  5.032944814570196e-11, -3.324903241463517e-13,  2.006195744799258e-15,  5.263048531179890e-17,  1.838726527501910e-18,  2.667817609635011e-20, -1.830065090738312e-23,
 -1.076815114822097e-23,  8.117303123915519e-02, -4.133811648660008e-04,  2.800326900632286e-06, -2.036971932118272e-08,  1.443988898659323e-10, -1.032510934276395e-12,
  7.127566457888019e-15, -2.849734605673297e-17,  8.265608594839068e-19,  5.572353206928894e-21,  2.739538500622788e-24, -3.166320528449175e-24,  4.703344798498035e-02,
 -2.994283407320600e-04,  2.987396498505883e-06, -2.814132842082842e-08,  2.512819696365698e-10, -2.097696449078790e-12,  1.718587832926064e-14, -1.599609671377818e-16,
  4.277175565458754e-19, -1.822313881729827e-20,  6.491839965981750e-23,  3.479874097392890e-24,  2.064416337115773e-02, -1.720752227761113e-04,  2.302919201629528e-06,
 -2.608547301838553e-08,  2.779450275407927e-10, -2.740448225650625e-12,  2.635386357263370e-14, -2.771988986020502e-16,  1.352343025188205e-18, -3.275342211733114e-20,
  1.789189497388339e-22,  3.854174619391706e-24,  6.823041449969585e-03, -7.557306374943554e-05,  1.261156360118866e-06, -1.679344081261314e-08,  2.099855141881188e-10,
 -2.423392918591736e-12,  2.694047501795451e-14, -3.076164345082630e-16,  2.446426583098469e-18, -3.747591446890328e-20,  2.975046489357655e-22,  4.326528422128497e-25,
  1.683960168648059e-03, -2.475888997672127e-05,  4.938602214475973e-07, -7.683765254061495e-09,  1.116632332720647e-10, -1.491952019620695e-12,  1.897615411925447e-14,
 -2.380032458212107e-16,  2.493560242740875e-18, -3.302265324333740e-20,  3.334059994146017e-22, -2.316221593030258e-24,  3.069689734857717e-04, -5.948939486941574e-06,
  1.388614763407558e-07, -2.520442987545261e-09,  4.228640089047199e-11, -6.489807232681588e-13,  9.387638360078100e-15, -1.307731733200030e-16,  1.642783725470820e-18,
 -2.193694925648043e-20,  2.598295128662528e-22, -2.759533462031347e-24,  4.075408885388932e-05, -1.032827127686535e-06,  2.798224694189751e-08, -5.924574327909055e-10,
  1.143206357695243e-11, -2.006646522119046e-13,  3.291673148050309e-15, -5.126480086435759e-17,  7.418197554053559e-19, -1.064709217327339e-20,  1.428852083594805e-22,
 -1.816326546926282e-24,  3.871655777275470e-06, -1.275156037602296e-07,  4.009805354516270e-09, -9.913618674081668e-11,  2.198410725412202e-12, -4.408311995054731e-14,
  8.197512416051523e-16, -1.433526511773351e-17,  2.351558104534389e-19, -3.719901150168988e-21,  5.588384567607820e-23, -8.039201124381822e-25,  2.574769115659167e-07,
 -1.098576255379293e-08,  4.032249964483253e-10, -1.167335785006673e-11,  2.981861988077254e-13, -6.842683844817692e-15,  1.445396520990526e-16, -2.849997703521772e-18,
  5.275678086047389e-20, -9.299360194203969e-22,  1.560370031511514e-23, -2.506943962478271e-25,  1.166719350731275e-08, -6.453900347854970e-10,  2.793611899436589e-11,
 -9.521294266302841e-13,  2.817307937675984e-14, -7.433648201118711e-16,  1.791994275771623e-17, -4.005729422714175e-19,  8.381084686666792e-21, -1.657826541033894e-22,
  3.114707326001346e-24, -5.586742389616461e-26,  3.486694446470290e-10, -2.514931004291037e-11,  1.303161616887619e-12, -5.276994758016134e-14,  1.825792921377538e-15,
 -5.584838776363076e-17,  1.548464821468407e-18, -3.954530440860828e-20,  9.407204918834664e-22, -2.103700996055750e-23,  4.450843743209809e-25, -8.954862520013549e-27,
  6.618499571040593e-12, -6.300408388108969e-13,  3.989550027717629e-14, -1.947404720908008e-15,  7.991311130534370e-17, -2.869843931882095e-18,  9.260312369492335e-20,
 -2.732145047233533e-21,  7.462930394576605e-23, -1.905328795204453e-24,  4.579613156029741e-26, -1.041893204129837e-27,  7.689589448362661e-14, -9.859311287343392e-15,
  7.847628487860085e-16, -4.720160278811578e-17,  2.345368268166932e-18, -1.007397042478712e-19,  3.848244761046906e-21, -1.332516028688926e-22,  4.239937077134476e-24,
 -1.252495018587561e-25,  3.462319868855573e-27, -9.008022932356269e-29,  5.399905175463854e-16, -9.615118124930597e-17,  9.996566579012612e-18, -7.650412883464614e-19,
  4.739670509390363e-20, -2.499432449068138e-21,  1.157285306859951e-22, -4.804297558246825e-24,  1.815210409589164e-25, -6.312790464718232e-27,  2.038487239847646e-28,
 -6.150116042035326e-30,  2.559992410260537e-18, -6.566753917774567e-19,  9.344524723347076e-20, -9.477579891679473e-21,  7.588972295210955e-22, -5.068971622208637e-23,
  2.922555495167668e-24, -1.488650664717987e-25,  6.812066709878267e-27, -2.835957302187825e-28,  1.084741908323899e-29, -3.838292122362814e-31,  1.478046380874336e-20,
 -5.414609736136763e-21,  1.066169398376515e-21, -1.446669181923967e-22,  1.505451377607778e-23, -1.275009737225627e-24,  9.125694524206195e-26, -5.664979809195082e-27,
  3.108445096450423e-28, -1.529577404506348e-29,  6.826795315065701e-31, -2.785433684049314e-32,  1.046678782600015e-01, -4.586574342232867e-04,  2.092329756043444e-06,
 -1.026513051531862e-08,  4.431851825047400e-11, -2.591536294486669e-13,  4.440507277366318e-15,  1.255431038428616e-16,  2.637169766270165e-18,  1.261477981444485e-20,
 -7.863276690061497e-22, -2.456524448492453e-23,  7.956281716614715e-02, -3.919185298425883e-04,  2.569100605083290e-06, -1.821545968788573e-08,  1.254108661980830e-10,
 -8.678573759298479e-13,  6.728365001857604e-15,  8.483970386317007e-19,  9.859551645197652e-19,  1.825367084535942e-21, -2.182521787891684e-22, -6.996542360814238e-24,
  4.588148668785413e-02, -2.768146541859470e-04,  2.672507629656926e-06, -2.443554047393254e-08,  2.130953745866393e-10, -1.738014890506990e-12,  1.280569496938376e-14,
 -1.558833844722243e-16, -1.313912354344121e-19, -1.108568470806392e-20,  3.307175608825955e-22,  8.752183202565623e-24,  1.999082819600679e-02, -1.548323258228347e-04,
  2.014871842910190e-06, -2.204502319989808e-08,  2.288531650525629e-10, -2.197233995920623e-12,  1.903323304619690e-14, -2.509578848699151e-16,  3.611723782385854e-19,
 -2.017586186421770e-20,  5.027572225651829e-22,  1.103983866524124e-23,  6.539727443678660e-03, -6.623625123090801e-05,  1.078300385198926e-06, -1.378906956787726e-08,
  1.673264311455190e-10, -1.872496374886700e-12,  1.923739822889551e-14, -2.484985076199674e-16,  1.328986277068271e-18, -2.376944337152374e-20,  4.239751669103965e-22,
  5.362641742435426e-24,  1.592282484462527e-03, -2.114857417531784e-05,  4.114643463654975e-07, -6.113237706730979e-09,  8.588093881003266e-11, -1.108487130752460e-12,
  1.326790696411055e-14, -1.748048186016889e-16,  1.527965072750431e-18, -2.088086207800921e-20,  2.938815750114649e-22,  4.495389509556595e-25,  2.852184760425308e-04,
 -4.948439734441190e-06,  1.122838176292411e-07, -1.936602779906522e-09,  3.129107387776129e-11, -4.623401582057859e-13,  6.356318329024283e-15, -8.903930200878745e-17,
  1.015690910986575e-18, -1.345239745727137e-20,  1.760406124222940e-22, -1.157250820337401e-24,  3.702948970029920e-05, -8.345769524766886e-07,  2.185047471261681e-08,
 -4.378023759846120e-10,  8.104995938174421e-12, -1.365252948855681e-13,  2.138024014503096e-15, -3.269381930317502e-17,  4.449411407629442e-19, -6.230544509883316e-21,
  8.437887444131654e-23, -9.275700371389782e-25,  3.418979735124331e-06, -9.965841206613053e-08,  3.005247075195206e-09, -7.006857786399296e-11,  1.484896879724793e-12,
 -2.848528108136643e-14,  5.062994176863106e-16, -8.582119190186559e-18,  1.342318108527492e-19, -2.055551040531061e-21,  3.019640374438742e-23, -4.078252386052162e-25,
  2.192004702614840e-07, -8.248475473026702e-09,  2.877982829015781e-10, -7.832785945215588e-12,  1.904270210414917e-13, -4.167668918096620e-15,  8.409025139399868e-17,
 -1.595643456881657e-18,  2.828628595261467e-20, -4.806489980275951e-22,  7.802190984535170e-24, -1.201773434181303e-25,  9.469748727741422e-09, -4.609352546260590e-10,
  1.879100867569668e-11, -6.002621732976173e-13,  1.683408104200411e-14, -4.223332533939982e-16,  9.708523479625470e-18, -2.079257220980150e-19,  4.167901002865492e-21,
 -7.926632822340815e-23,  1.434883363642593e-24, -2.478047089925771e-26,  2.655159681415788e-10, -1.683377820513325e-11,  8.139804362782718e-13, -3.079696743548918e-14,
  1.005771549929114e-15, -2.916444853032099e-17,  7.694435708372888e-19, -1.876973237159077e-20,  4.273275246382398e-22, -9.170558376673972e-24,  1.865735199088982e-25,
 -3.614689103518436e-27,  4.614448297941239e-12, -3.863054229417215e-13,  2.263442938908038e-14, -1.029073529018452e-15,  3.970998378878255e-17, -1.348162929880514e-18,
  4.130695999136801e-20, -1.161582289202806e-21,  3.032798364118513e-23, -7.420958201666085e-25,  1.713417368256417e-26, -3.752094214586648e-28,  4.716080692006542e-14,
 -5.334805347248109e-15,  3.903635897651380e-16, -2.181396867126223e-17,  1.016443646625929e-18, -4.119578218553707e-20,  1.492259145479121e-21, -4.919870885977295e-23,
  1.495579999539441e-24, -4.233301769593646e-26,  1.124203680062295e-27, -2.816415128222998e-29,  2.713852056422724e-16, -4.301441959967684e-17,  4.103902106934627e-18,
 -2.918463101520833e-19,  1.695734740323654e-20, -8.443625188644586e-22,  3.711482852044584e-23, -1.469221836055597e-24,  5.313352238435773e-26, -1.774438853202188e-27,
  5.518065013280502e-29, -1.607404331743152e-30,  9.223016331533892e-19, -2.154865518389003e-19,  2.843800814936579e-20, -2.705396700250486e-21,  2.049084353265850e-22,
 -1.303082071587345e-23,  7.190850796030955e-25, -3.521115826683367e-26,  1.554721790318329e-27, -6.265463886647492e-29,  2.326354289345184e-30, -8.010799046217323e-32,
  3.135884320036600e-21, -1.102985974158811e-21,  2.094694060221020e-22, -2.755291838878820e-23,  2.791383974818282e-24, -2.309588597577238e-25,  1.619579477274975e-26,
 -9.873891759775401e-28,  5.331641703831444e-29, -2.586186162174800e-30,  1.139494742135026e-31, -4.595747383378554e-33,  1.028659622037189e-01, -4.423998174548638e-04,
  1.973254168137257e-06, -9.590338849715038e-09,  4.053599128500736e-11, -1.007171306162822e-13,  9.148751323787894e-15,  2.087808262326976e-16,  2.229940558420133e-18,
 -4.412424186774714e-20, -2.120113022335463e-21, -3.366716293750094e-23,  7.803491077227291e-02, -3.722072171506869e-04,  2.362010343471313e-06, -1.633889694203333e-08,
  1.096888626299126e-10, -7.025419941637598e-13,  7.187883799912386e-15,  3.109847582267839e-17,  8.106807413732511e-19, -1.408223449788502e-20, -5.965002955201111e-22,
 -9.534066029633852e-24,  4.481520956537317e-02, -2.565520778579525e-04,  2.398641217744623e-06, -2.128889446170542e-08,  1.810512772271245e-10, -1.483787289537034e-12,
  8.345107916694759e-15, -1.630782763297027e-16, -1.863615691195455e-19,  1.123887252470665e-20,  8.119560955377803e-22,  1.221963677958098e-23,  1.940214508554184e-02,
 -1.397124544693565e-04,  1.770925203313722e-06, -1.871248331611224e-08,  1.889117780111247e-10, -1.823958832616576e-12,  1.209279681949448e-14, -2.460705070992841e-16,
  1.317273296633344e-19,  1.153600353784049e-20,  1.118908538015197e-21,  1.577939635144665e-23,  6.291047967859996e-03, -5.822890533982921e-05,  9.277340235334637e-07,
 -1.138864864579918e-08,  1.339518328862455e-10, -1.490149422639306e-12,  1.277258967909758e-14, -2.158481023633146e-16,  8.472550942222187e-19, -8.361256129232072e-22,
  7.471610594060430e-22,  8.598610320743808e-24,  1.513837900078240e-03, -1.812851558037967e-05,  3.456701806296915e-07, -4.900772100739177e-09,  6.652494443369746e-11,
 -8.438784029251854e-13,  8.961495156394984e-15, -1.355891089013282e-16,  9.987007072319027e-19, -8.082485609247719e-21,  3.591406834357280e-22,  2.206825160113427e-24,
  2.670852286194054e-04, -4.135267819544466e-06,  9.176806334559594e-08, -1.502418232044903e-09,  2.338509847897649e-11, -3.364339518532389e-13,  4.254658860983450e-15,
 -6.300553749424329e-17,  6.489918083424288e-19, -7.097170814276037e-21,  1.486828217264807e-22, -2.082594878770926e-25,  3.401037628974988e-05, -6.787739512764748e-07,
  1.729306402103357e-08, -3.274632438125672e-10,  5.820980830373227e-12, -9.477467773647802e-14,  1.392444875507912e-15, -2.146246336335324e-17,  2.731209588503028e-19,
 -3.504801881760422e-21,  5.544157441522355e-23, -4.413164888898097e-25,  3.063622891615007e-06, -7.861521647736902e-08,  2.290108590248540e-09, -5.028142768296246e-11,
  1.019485037819125e-12, -1.879313298571156e-14,  3.164917284757375e-16, -5.268320936135758e-18,  7.829931911240012e-20, -1.137258680497771e-21,  1.717407178941498e-23,
 -2.066371421634470e-25,  1.902816347192568e-07, -6.275957824135204e-09,  2.096528975741904e-10, -5.356662751522243e-12,  1.241042443441910e-13, -2.597421130457398e-15,
  4.985951199236621e-17, -9.160894777117243e-19,  1.552815374392431e-20, -2.528492055036354e-22,  4.031871996545514e-24, -5.866648681664836e-26,  7.886754666949002e-09,
 -3.354094280614579e-10,  1.296138082582756e-11, -3.875688472626466e-13,  1.031387605757197e-14, -2.464083127033730e-16,  5.392976294650835e-18, -1.109615442416407e-19,
  2.129851961954780e-21, -3.889028075599787e-23,  6.811399590468446e-25, -1.128494473925273e-26,  2.091989934346445e-10, -1.156521692810249e-11,  5.245435642645871e-13,
 -1.852192348539281e-14,  5.714361543142565e-16, -1.571954564201801e-17,  3.944137072876799e-19, -9.199511380675744e-21,  2.004134276055686e-22, -4.126181815317173e-24,
  8.079640109441019e-26, -1.506102363493988e-27,  3.366097089204818e-12, -2.455715163385918e-13,  1.335632615885876e-14, -5.649161445721003e-16,  2.050290666756212e-17,
 -6.580701953542870e-19,  1.913744459202631e-20, -5.129562909579919e-22,  1.279728983488033e-23, -3.000162389756124e-25,  6.653025506982277e-27, -1.401627692862550e-28,
  3.073079595231414e-14, -3.034454274454691e-15,  2.042091053998328e-16, -1.058276715290373e-17,  4.620244978147506e-19, -1.765322981442821e-20,  6.057979776225863e-22,
 -1.900093888583614e-23,  5.513234614208118e-25, -1.493965002200049e-26,  3.808009640496680e-28, -9.177796469434854e-30,  1.479546716393994e-16, -2.060605697859840e-17,
  1.797857033563865e-18, -1.183889494993064e-19,  6.434089147800992e-21, -3.017748354515205e-22,  1.256461289315949e-23, -4.732980270367113e-25,  1.635072887239726e-26,
 -5.233627810481400e-28,  1.564496693658689e-29, -4.392477096427449e-31,  3.683685107919769e-19, -7.715121064857485e-20,  9.361417376844725e-21, -8.296875971441557e-22,
  5.911002385360505e-23, -3.561643647712057e-24,  1.873123321722718e-25, -8.783425262175206e-27,  3.729069703637123e-28, -1.450058403797110e-29,  5.210963731194096e-31,
 -1.741476671923812e-32,  7.195979245994223e-22, -2.400006425902193e-22,  4.354945081522020e-23, -5.512248485278064e-24,  5.404250342427144e-25, -4.346739504452875e-26,
  2.973936519652782e-27, -1.774291775377869e-28,  9.399294390280757e-30, -4.482411865771959e-31,  1.945206677823295e-32, -7.739216545749976e-34,  1.011272216090904e-01,
 -4.270631597942318e-04,  1.862039454481882e-06, -8.943840193811711e-09,  4.122395128335479e-11,  1.949438954441947e-13,  1.562189610960338e-14,  2.355847789814663e-16,
 -1.219150606545740e-18, -1.553922179026529e-19, -3.276641214900578e-21, -1.001207412137397e-23,  7.658267310435275e-02, -3.540665713957888e-04,  2.176041314122867e-06,
 -1.468656783492105e-08,  9.744614471422495e-11, -5.173051545190466e-13,  8.308179035241759e-15,  4.353831981020124e-17, -2.205172017813576e-19, -4.545334921611855e-20,
 -9.255672031866206e-22, -2.930472146178538e-24,  4.382582818725726e-02, -2.383377614926946e-04,  2.159607101038116e-06, -1.862015541030673e-08,  1.530074977885007e-10,
 -1.338349557429660e-12,  3.806833787238751e-15, -1.552946073598123e-16,  9.240093477227365e-19,  5.330350157081488e-20,  1.229518932442982e-21,  3.456274328984845e-24,
  1.887027692404131e-02, -1.263945495740099e-04,  1.563351838537810e-06, -1.596828508751095e-08,  1.547821056572974e-10, -1.615209704998730e-12,  5.393475264173278e-15,
 -2.252720285238999e-16,  1.509411428695542e-18,  6.870015294072133e-20,  1.659461379815516e-21,  4.439569500361171e-24,  6.072159128967202e-03, -5.131942017836353e-05,
  8.029945901671771e-07, -9.469185713531513e-09,  1.067412470593992e-10, -1.252872195768743e-12,  7.149183507229552e-15, -1.827373715980269e-16,  1.440969322038395e-18,
  3.584246875243245e-20,  1.041827268232015e-21,  2.203165042420262e-24,  1.446506044540372e-03, -1.558150933815632e-05,  2.927248276775098e-07, -3.960936013875747e-09,
  5.150851816734273e-11, -6.709141778686344e-13,  5.589538832101786e-15, -1.053262536657950e-16,  9.889240714576971e-19,  8.067203052809084e-21,  4.348124066099471e-22,
  2.681050781186459e-25,  2.519066102013034e-04, -3.467356790962175e-06,  7.577839623290940e-08, -1.177098228573701e-09,  1.754591595756192e-11, -2.533406087425754e-13,
  2.750953073714363e-15, -4.519001052980660e-17,  4.991171042028224e-19, -1.266772969380056e-21,  1.418968215430642e-22, -3.552332853642412e-25,  3.154914133427987e-05,
 -5.546975757265020e-07,  1.386513117798304e-08, -2.478636549768167e-10,  4.215659512149888e-12, -6.768191242946891e-14,  8.977418113077079e-16, -1.434653190893346e-17,
  1.828888669712694e-19, -1.603065305268892e-21,  4.082517857748337e-23, -2.810683865797506e-25,  2.782339292261828e-06, -6.245667046143296e-08,  1.773409668210419e-09,
 -3.660936486512871e-11,  7.089505323993503e-13, -1.271784612354172e-14,  1.987549928409939e-16, -3.300853053722938e-18,  4.785168090559665e-20, -5.983294752547409e-22,
  1.044867300462151e-23, -1.134104166473285e-25,  1.681680780011985e-07, -4.825663310004720e-09,  1.557616484070283e-10, -3.729374088283141e-12,  8.230259853343400e-14,
 -1.659859858906210e-15,  2.999308614391776e-17, -5.381080431149249e-19,  8.802386448744012e-21, -1.330116269661364e-22,  2.169491059124357e-24, -2.967853334092608e-26,
  6.726562309328040e-09, -2.478498973053879e-10,  9.158251664734007e-12, -2.558724084379986e-13,  6.463291106663629e-15, -1.476855587302870e-16,  3.062288869837986e-18,
 -6.078539113952881e-20,  1.120555569408838e-21, -1.945538623133069e-23,  3.338321206824067e-25, -5.289164078847501e-27,  1.701148216849805e-10, -8.123429696801111e-12,
  3.482181074315010e-13, -1.145585981832624e-14,  3.340749070014611e-16, -8.737745469816135e-18,  2.080764459730697e-19, -4.649145723825247e-21,  9.699449467900723e-23,
 -1.911053122281140e-24,  3.613621316398870e-26, -6.473294514715138e-28,  2.561311194506631e-12, -1.611194834456579e-13,  8.180536288328474e-15, -3.213683293834761e-16,
  1.097375026182926e-17, -3.332533343999979e-19,  9.190629126950697e-21, -2.349284181932419e-22,  5.600275231362105e-24, -1.257022712175835e-25,  2.678537929900815e-27,
 -5.425852373494661e-29,  2.120359536823849e-14, -1.805555900893723e-15,  1.120580338737990e-16, -5.375421646716028e-18,  2.197797144957722e-19, -7.913380843552024e-21,
  2.570384971066548e-22, -7.665973612610624e-24,  2.121678108650324e-25, -5.499738240965216e-27,  1.344690819264354e-28, -3.115322335799208e-30,  8.727570875276633e-17,
 -1.052676076022223e-17,  8.385997867417696e-19, -5.097225817817710e-20,  2.585510470195345e-21, -1.140012815189369e-22,  4.487336256000654e-24, -1.605659491151278e-25,
  5.289630461944723e-27, -1.620073165214980e-28,  4.647795935557506e-30, -1.255691461521924e-31,  1.636399930850919e-19, -3.016817560506865e-20,  3.339074689898261e-21,
 -2.739048914754123e-22,  1.825828827782349e-23, -1.037572957295313e-24,  5.179007599222980e-26, -2.316928788796682e-27,  9.425770333881083e-29, -3.525350186496320e-30,
  1.222526870873932e-31, -3.954199353138696e-33,  1.817152159830864e-22, -5.650697215477759e-23,  9.682713859235109e-24, -1.168744537864122e-24,  1.100871441584612e-25,
 -8.556327595281150e-27,  5.683065114077060e-28, -3.303966907329051e-29,  1.710870147590714e-30, -7.996097312470170e-32,  3.408295229446245e-33, -1.334472812698874e-34,
  9.944809826960517e-02, -4.125844963543971e-04,  1.758871295983101e-06, -8.230606649248016e-09,  4.935837184254140e-11,  6.385442570294457e-13,  2.065160631400208e-14,
  8.212869681008314e-17, -9.085729954034568e-18, -2.728372309049129e-19, -1.881078353638124e-21,  8.810135637770900e-23,  7.520014377429729e-02, -3.373374047799670e-04,
  2.008852052983032e-06, -1.319898622149997e-08,  8.918127930144371e-11, -3.058450044088739e-13,  9.131701769422328e-15,  3.245810669868966e-18, -2.500103671301010e-18,
 -7.874535858653949e-20, -5.374157571565553e-22,  2.476654600548187e-23,  4.290567182799015e-02, -2.219150631510381e-04,  1.949982886742739e-06, -1.638259951016145e-08,
  1.268279673421269e-10, -1.293711469845945e-12,  2.282539268846625e-16, -8.568588269091264e-17,  3.693435667665464e-18,  9.722574195251286e-20,  7.027061677957962e-22,
 -3.276642034443825e-23,  1.838855501012990e-02, -1.146145313752772e-04,  1.385542692841896e-06, -1.374518448114775e-08,  1.233010025564771e-10, -1.553257384649830e-12,
  2.245947181961356e-16, -1.247992599171395e-16,  5.130753642969868e-18,  1.280787198304021e-19,  9.615249818231403e-22, -4.333886599346009e-23,  5.879048247755388e-03,
 -4.532280274435471e-05,  6.988103351474105e-07, -7.954090603019792e-09,  8.301819187641459e-11, -1.136002599454552e-12,  2.928852437874176e-15, -1.080956318437948e-16,
  3.449841721457790e-18,  7.305548460002407e-20,  6.136618305688848e-22, -2.597752362041577e-23,  1.388581061963274e-03, -1.341680246474237e-05,  2.497166450986976e-07,
 -3.237790997827005e-09,  3.921289656086694e-11, -5.681921092007392e-13,  3.150590092450493e-15, -6.577509089563651e-17,  1.576062200936060e-18,  2.345285158587659e-20,
  2.616250265202363e-22, -9.741091229626744e-24,  2.391664347589657e-04, -2.913221623281910e-06,  6.318094291113932e-08, -9.337087300854639e-10,  1.304612922785760e-11,
 -2.007009325367419e-13,  1.709896558201447e-15, -2.890791460857005e-17,  5.479319857096015e-19,  3.625470642282556e-21,  8.671312843425150e-23, -2.554569672769650e-24,
  2.953484748018092e-05, -4.546232249909064e-07,  1.125424681412590e-08, -1.901968116050861e-10,  3.048171940625711e-12, -5.033790038784544e-14,  5.713963303209570e-16,
 -9.128251511969683e-18,  1.512845738555587e-19, -2.575091240356809e-22,  2.465269795915791e-23, -5.282441417889200e-25,  2.558353548813322e-06, -4.985159953030033e-08,
  1.394523433167318e-09, -2.707037469682915e-11,  4.956280316015258e-13, -8.901028608134053e-15,  1.250524856465240e-16, -2.042666212522461e-18,  3.272749451767908e-20,
 -2.707911673675102e-22,  6.026569387007510e-24, -9.967868169865040e-26,  1.511027481763619e-07, -3.738485945272788e-09,  1.179286606745380e-10, -2.643600493867936e-12,
  5.523102962521788e-14, -1.092884165296440e-15,  1.825571681133979e-17, -3.185663922359103e-19,  5.303583689043079e-21, -6.789984047237736e-23,  1.172102027434888e-24,
 -1.776640224360263e-26,  5.864463885007159e-09, -1.853088858900951e-10,  6.622299270210942e-12, -1.726094585339746e-13,  4.125165289585072e-15, -9.112774511144801e-17,
  1.773051373739115e-18, -3.395197559992091e-20,  6.133434278741538e-22, -9.813142690187913e-24,  1.673722807699220e-25, -2.642007170888868e-27,  1.424347017669021e-10,
 -5.808412948962209e-12,  2.378236422238111e-13, -7.276044760408531e-15,  2.002892951433958e-16, -5.010111075928022e-18,  1.127184157256526e-19, -2.414651167027247e-21,
  4.856413215701994e-23, -9.069008897138468e-25,  1.665100741158645e-26, -2.889245631288268e-28,  2.026930038963785e-12, -1.085544849961929e-13,  5.191132691875667e-15,
 -1.890435748088288e-16,  6.070893745451095e-18, -1.749068015607634e-19,  4.565438858701130e-21, -1.113560448873147e-22,  2.540639081776497e-24, -5.445906426298318e-26,
  1.116781888556231e-27, -2.177008143864256e-29,  1.543666492851609e-14, -1.117495914449889e-15,  6.434407986467759e-17, -2.851111046961822e-18,  1.091201008947773e-19,
 -3.704561694231457e-21,  1.137703139046755e-22, -3.225801074485623e-24,  8.514361002047805e-26, -2.109184091226155e-27,  4.945768380788975e-29, -1.100806971035890e-30,
  5.551680537795170e-17, -5.703034940900682e-18,  4.153784199579677e-19, -2.323552692712585e-20,  1.098201830437830e-21, -4.545920754399643e-23,  1.688841274685949e-24,
 -5.732242146882622e-26,  1.798243874312047e-27, -5.262096075498315e-29,  1.446831085925676e-30, -3.756123223695040e-32,  8.095131205738258e-20, -1.286406696117144e-20,
  1.290752050328327e-21, -9.740157199364196e-23,  6.045839162868287e-24, -3.226631216207469e-25,  1.522703209905078e-26, -6.476205202373875e-28,  2.516330412015144e-29,
 -9.024438727954587e-31,  3.011265753461626e-32, -9.400923099559821e-34,  5.150004161873844e-23, -1.459698298496046e-23,  2.328784938459904e-24, -2.651937909773324e-25,
  2.379515601609538e-26, -1.774683644467771e-27,  1.137610590914002e-28, -6.412658331423232e-30,  3.231968915171080e-31, -1.474886078761396e-32,  6.154821077557097e-34,
 -2.364818575721288e-35,  9.782529715386211e-02, -3.988940230144808e-04,  1.665351544365853e-06, -7.311704657049722e-09,  6.706245887685773e-11,  1.119565586414797e-12,
  1.735759180476189e-14, -3.700489147436109e-16, -1.892082874519760e-17, -2.255151703337355e-19,  5.376855579932140e-21,  2.394034217971515e-22,  7.388196639448515e-02,
 -3.218762705342401e-04,  1.858861953444236e-06, -1.180927945303964e-08,  8.520518184917953e-11, -9.733503286767603e-14,  7.662837909214887e-15, -1.233742581505010e-16,
 -5.343128242312285e-18, -6.558923682143152e-20,  1.519776671066696e-21,  6.826354854659984e-23,  4.204801233218458e-02, -2.070690350601335e-04,  1.764712734595280e-06,
 -1.456058102310058e-08,  1.008973597889503e-10, -1.300327976818637e-12,  2.746684397593876e-17,  9.013542544393689e-17,  7.202773112872441e-18,  8.000253960550503e-20,
 -1.975764453540459e-21, -8.790629279931651e-23,  1.795126516559656e-02, -1.041587842110404e-04,  1.231410854033055e-06, -1.202139477449767e-08,  9.212127553195166e-11,
 -1.566837154609844e-12, -2.530723961641321e-16,  1.155530231755186e-16,  9.775535016740436e-18,  1.064121653836128e-19, -2.596866650136148e-21, -1.172749037289709e-22,
  5.708363119933348e-03, -4.009324146032750e-05,  6.105914028555176e-07, -6.804513110303140e-09,  6.083108391676095e-11, -1.087025644716871e-12,  1.860127543242289e-15,
  4.610760612472411e-17,  6.127721633815942e-18,  6.162308537523575e-20, -1.516165183683163e-21, -7.031255664373459e-23,  1.338677195775836e-03, -1.156465698019264e-05,
  2.142644512403314e-07, -2.697700165805225e-09,  2.848896331273514e-11, -5.081528655852384e-13,  2.150065616506891e-15, -9.311301522627792e-19,  2.462467396363373e-18,
  2.058174121593620e-20, -5.261346086637001e-22, -2.595311241844985e-23,  2.284581057591843e-04, -2.449335346638048e-06,  5.310296415056476e-08, -7.550909351530952e-10,
  9.387740294929461e-12, -1.672572515644577e-13,  1.168751169708380e-15, -8.901364784717087e-18,  7.037937356092746e-19,  3.734727963829503e-21, -1.097925095561715e-22,
 -6.380153885357908e-24,  2.788304281165135e-05, -3.729616590744125e-07,  9.233486269857340e-09, -1.488121357052889e-10,  2.160657703591078e-12, -3.914749077695670e-14,
  3.832357044115942e-16, -4.299868669425457e-18,  1.527350306631213e-19,  1.040668213126791e-22, -1.079548137027247e-23, -1.093071199261560e-24,  2.379375887366618e-06,
 -3.987253759746233e-08,  1.111864540119783e-09, -2.041884015988847e-11,  3.435660232481681e-13, -6.475328237921992e-15,  8.133367162367018e-17, -1.113955874686685e-18,
  2.617540503238607e-20, -1.274147270548217e-22,  8.361548983830482e-25, -1.400636885732426e-25,  1.378539459309226e-07, -2.908446911999963e-09,  9.085592896044022e-11,
 -1.913673792151881e-12,  3.712279955676952e-14, -7.445789118243177e-16,  1.140045344506710e-17, -1.803623946658804e-19,  3.526261427908881e-21, -3.548183837538692e-23,
  4.659538287939921e-25, -1.526138318955261e-26,  5.217485397135957e-09, -1.396186495596189e-10,  4.893551301945102e-12, -1.191622834969433e-13,  2.661368129271441e-15,
 -5.804990461890086e-17,  1.052086497261343e-18, -1.888742483788397e-20,  3.562956864358644e-22, -5.049600377556381e-24,  7.857495695309994e-26, -1.559773398027348e-27,
  1.225211972957149e-10, -4.207358200761677e-12,  1.668523618076108e-13, -4.746222744760138e-15,  1.224575625240932e-16, -2.966705685656942e-18,  6.274640269228454e-20,
 -1.275855955728839e-21,  2.535095310300808e-23, -4.411565612771159e-25,  7.720115803810217e-27, -1.383021647182821e-28,  1.663426639671587e-12, -7.468007599539263e-14,
  3.406717658291392e-15, -1.148563597927892e-16,  3.456689344545138e-18, -9.510903224149945e-20,  2.343029542387334e-21, -5.438229556989380e-23,  1.196876970114183e-24,
 -2.435388680346840e-26,  4.793857092152560e-28, -9.113315823868965e-30,  1.181503208807397e-14, -7.147157348866795e-16,  3.856953495638910e-17, -1.575514269885823e-18,
  5.635415872337136e-20, -1.808600944328194e-21,  5.243421572591512e-23, -1.412376604476373e-24,  3.560880086352583e-26, -8.413392944799558e-28,  1.891383771994438e-29,
 -4.050476628225218e-31,  3.793063591891048e-17, -3.253693678151697e-18,  2.178585504809769e-19, -1.118329128959085e-20,  4.917430196911527e-22, -1.910364262831699e-23,
  6.687863170212151e-25, -2.150829173202164e-26,  6.419531668580978e-28, -1.792204658571629e-29,  4.717616812899329e-31, -1.175638841582761e-32,  4.455132052377566e-20,
 -5.955386156922501e-21,  5.400899662276633e-22, -3.728279735507870e-23,  2.146002040058407e-24, -1.071764293203139e-25,  4.765307258148371e-27, -1.920696239537406e-28,
  7.106364871081746e-30, -2.436788887660354e-31,  7.802673130335315e-33, -2.345093710374085e-34,  1.672427296751065e-23, -4.192789613200796e-24,  6.128676328967868e-25,
 -6.504114230387580e-26,  5.505910069342712e-27, -3.909237392004013e-28,  2.402351954449629e-29, -1.305544944812751e-30,  6.372758720404129e-32, -2.827398603910764e-33,
  1.150835119761176e-34, -4.324899263815034e-36,  9.625583915019566e-02, -3.859021054678357e-04,  1.584848555197787e-06, -6.041771549428828e-09,  9.240203408108990e-11,
  1.337916045450253e-12, -2.277957883004819e-15, -1.041865575825273e-15, -2.043588696529619e-17,  2.170522225945846e-19,  1.655395641144116e-20,  2.054396643635549e-22,
  7.262333819498855e-02, -3.075491348647168e-04,  1.725294327811161e-06, -1.045312254157304e-08,  8.471066177684848e-11,  2.419065293998714e-14,  1.579615238772638e-15,
 -3.140934024869265e-16, -5.827284074557261e-18,  6.050338584227644e-20,  4.741546622143176e-21,  6.032517150286206e-23,  4.124690113813497e-02, -1.936247669954216e-04,
  1.598817341656739e-06, -1.315288608395085e-08,  7.524509660106765e-11, -1.241419983876295e-12,  6.055847679322363e-15,  3.433846249141796e-16,  7.660820275247510e-18,
 -8.213468198144228e-20, -6.046029505092605e-21, -7.375725469380870e-23,  1.755345121822618e-02, -9.486184290287834e-05,  1.094967195177605e-06, -1.079670608279255e-08,
  6.118011595597147e-11, -1.496178297087881e-12,  7.732654245543718e-15,  4.588189473799052e-16,  1.039796546890308e-17, -1.089422511293633e-19, -8.076083633835920e-21,
 -1.009111521961206e-22,  5.557263678800993e-03, -3.552021345843423e-05,  5.340696554799358e-07, -6.001855782095744e-09,  3.976275328402958e-11, -1.003260058198697e-12,
  6.109072282196481e-15,  2.594971004946688e-16,  6.449601434876113e-18, -6.613434447392013e-20, -4.823894032464151e-21, -6.171448807627003e-23,  1.295651718980935e-03,
 -9.973035525751461e-06,  1.843010675209724e-07, -2.320219311599837e-09,  1.888801655120075e-11, -4.474791591328134e-13,  3.295803864996346e-15,  8.326166788558286e-17,
  2.526694349364310e-18, -2.533364296197613e-20, -1.755808955765976e-21, -2.329707756974051e-23,  2.194563067829546e-04, -2.058447092775106e-06,  4.483752435062474e-08,
 -6.301619742030634e-10,  6.316430262597750e-12, -1.395736671161704e-13,  1.245587589228865e-15,  1.433353075101360e-17,  6.858933255047144e-19, -6.783403172647401e-21,
 -4.136991423579526e-22, -5.862430953147190e-24,  2.652837736447402e-05, -3.057054728090625e-07,  7.630857297110306e-09, -1.200364743172003e-10,  1.462782610872256e-12,
 -3.084427776015512e-14,  3.306553452038542e-16,  4.637503516072241e-19,  1.362302199175615e-19, -1.370565911162274e-21, -6.261133687592364e-23, -1.017721385801812e-24,
  2.236243502368399e-06, -3.187347500819897e-08,  8.958656377842702e-10, -1.586073364367425e-11,  2.315241151688317e-13, -4.807275761726299e-15,  6.115338854354478e-17,
 -3.558537082940747e-19,  2.063462486374642e-20, -2.233992422514238e-22, -5.562196234960589e-24, -1.265804537776345e-25,  1.275412892795603e-07, -2.264401238460344e-09,
  7.100819537528964e-11, -1.425477188172844e-12,  2.461952283658943e-14, -5.199027632662087e-16,  7.756154281252168e-18, -8.565975662719327e-20,  2.425394881086869e-21,
 -2.988959749548322e-23, -1.655456823601863e-25, -1.214061446444199e-26,  4.729167162911049e-09, -1.055462646450238e-10,  3.684786503367808e-12, -8.465504971769498e-14,
  1.716048639677681e-15, -3.800704815652798e-17,  6.591298400561744e-19, -9.911701583115759e-21,  2.161182926314435e-22, -3.108933181112263e-24,  2.245646048835784e-26,
 -9.948055485908405e-28,  1.080423711574583e-10, -3.071081544861617e-12,  1.199310405128965e-13, -3.190419423888951e-15,  7.570732294103277e-17, -1.810621417289684e-18,
  3.635539180331415e-20, -6.695737670072926e-22,  1.377872638475770e-23, -2.309513684792589e-25,  3.270437432335219e-27, -7.135199790075303e-29,  1.411643714265437e-12,
 -5.212622262144362e-14,  2.306161077083205e-15, -7.216053498041339e-17,  2.012852122294650e-18, -5.351586014964800e-20,  1.247149530267666e-21, -2.707677406701142e-23,
  5.859763514572083e-25, -1.136840894330358e-26,  2.065084951436324e-28, -4.015266137159029e-30,  9.472046271162431e-15, -4.688191110546994e-16,  2.406931600877073e-17,
 -9.062921593916112e-19,  3.012634181936519e-20, -9.194931912335377e-22,  2.515580816524054e-23, -6.404429382031554e-25,  1.551719399069829e-26, -3.493412412040212e-28,
  7.473303742206319e-30, -1.555788217388998e-31,  2.770828609678902e-17, -1.938110780079775e-18,  1.206095831089206e-19, -5.669414117130156e-21,  2.312696041471436e-22,
 -8.445519420496974e-24,  2.782397574872853e-25, -8.463815647321215e-27,  2.404715564962536e-28, -6.395667173614939e-30,  1.609062901769612e-31, -3.850957123999534e-33,
  2.718866944967811e-20, -2.970570306130182e-21,  2.440312981201049e-22, -1.533325751204871e-23,  8.154299819458235e-25, -3.801281749437473e-26,  1.587490947056142e-27,
 -6.046804591183842e-29,  2.125043056384589e-30, -6.948689302648146e-32,  2.129828441981045e-33, -6.148218745279560e-35,  6.343926545430180e-24, -1.353157774577883e-24,
  1.783133508590220e-25, -1.740329340550730e-26,  1.375568615777951e-27, -9.218081644197895e-29,  5.391018446265273e-30, -2.806691544962059e-31,  1.319622703907825e-32,
 -5.664793573768833e-34,  2.239425077958532e-35, -8.200738155780764e-37,  9.473716720390148e-02, -3.734862285493472e-04,  1.522061290567225e-06, -4.363350851509696e-09,
  1.159171604858082e-10,  8.713982626682245e-13, -3.844745951599552e-14, -1.431679422371722e-15,  4.590799452268622e-19,  9.403938429014689e-19,  1.567200274497790e-20,
 -3.293465515438778e-22,  7.141998450191141e-02, -2.942254549256082e-04,  1.608002719926763e-06, -9.095151456689659e-09,  8.476595060884465e-11, -6.108656776211388e-14,
 -9.215602507962428e-15, -4.257063735536097e-16,  1.187487601525252e-19,  2.695471412940365e-19,  4.589712956621678e-21, -9.188967627959778e-23,  4.049701002121082e-02,
 -1.814469177019291e-04,  1.447422501188864e-06, -1.213597986008665e-08,  5.277400211507614e-11, -9.575178048376241e-13,  1.829983705531937e-14,  4.905609948250768e-16,
 -5.448645813864878e-20, -3.446127189772198e-19, -5.628989742827918e-21,  1.227414226051409e-22,  1.719072337886106e-02, -8.660589072116016e-05,  9.703386135161019e-07,
 -1.004215461814481e-08,  3.432327127269933e-11, -1.124846334998228e-12,  2.416821859984331e-14,  6.608789032224565e-16,  8.750016594439988e-20, -4.623639599738371e-19,
 -7.668142423453371e-21,  1.605730837266318e-22,  5.423285138794349e-03, -3.152638919386961e-05,  4.652359341162820e-07, -5.515359193140061e-09,  2.185828225828998e-11,
 -7.497604835418643e-13,  1.561893867673610e-14,  3.870770199897328e-16,  2.349592345995891e-19, -2.787545146464538e-19, -4.657284189215402e-21,  9.440353723883597e-23,
  1.258538454244438e-03, -8.605507668433369e-06,  1.579927983359419e-07, -2.084368825857208e-09,  1.096001460644588e-11, -3.326328754865247e-13,  6.516877369722402e-15,
  1.346279327427657e-16,  2.097717788611443e-19, -1.035071272678159e-19, -1.732810892290355e-21,  3.377243489212261e-23,  2.118941866136218e-04, -1.728477358081628e-06,
  3.779557224182952e-08, -5.496296461891243e-10,  3.867818497844806e-12, -1.027329134461055e-13,  1.892545705690211e-15,  2.883361895364384e-17,  1.068439769118364e-19,
 -2.550808453607692e-20, -4.218777231927260e-22,  7.824799483430448e-24,  2.541902990982496e-05, -2.500665149960928e-07,  6.311917954334249e-09, -1.011233528867074e-10,
  9.285898282650322e-13, -2.232473330512476e-14,  3.934178100814542e-16,  3.487532039122681e-18,  3.500251598245283e-20, -4.297547290509747e-21, -6.761580747553076e-23,
  1.177129107157474e-24,  2.121957946426346e-06, -2.541169127826473e-08,  7.248423924693466e-10, -1.284792530999161e-11,  1.495960931817255e-13, -3.393736796718823e-15,
  5.886806148486290e-17,  1.245960067044796e-19,  7.671566321781577e-21, -5.066287339160446e-22, -6.866417408497207e-24,  1.097510966386840e-25,  1.195199697429768e-07,
 -1.758790066257920e-09,  5.595369209461346e-11, -1.105306298035180e-12,  1.592953526853050e-14, -3.548288016771944e-16,  6.268292776938417e-18, -2.738410299408249e-20,
  1.133738108942843e-21, -4.338845155111640e-23, -3.823840169360561e-25,  5.232014091567269e-27,  4.360094226935185e-09, -7.971725216185460e-11,  2.811139314832602e-12,
 -6.250147232276585e-14,  1.095235484685558e-15, -2.483588579580004e-17,  4.624001932280103e-19, -4.685976699480287e-21,  1.118378270993787e-22, -2.854896304993193e-24,
 -2.840755725127723e-27, -4.452078384013646e-29,  9.746026623544675e-11, -2.246653426830252e-12,  8.785700744956561e-14, -2.226962830124937e-15,  4.692933513028604e-17,
 -1.120161059998902e-18,  2.267887323666782e-20, -3.417335686697189e-22,  7.190273644177969e-24, -1.489476024120349e-25,  1.172374783204818e-27, -2.396734512724726e-29,
  1.235230805328720e-12, -3.666506237716417e-14,  1.602793843826079e-15, -4.711515001536311e-17,  1.189969502374929e-18, -3.089194104792726e-20,  6.996074014515042e-22,
 -1.357464195679837e-23,  2.903399969344362e-25, -5.840286354779213e-27,  8.682981545528667e-29, -1.662838260629303e-30,  7.922962423546955e-15, -3.127833828332925e-16,
  1.557081407427385e-17, -5.438048711580324e-19,  1.656858781963870e-20, -4.846800547982617e-22,  1.262921637046326e-23, -2.986189424460172e-25,  6.996347620386874e-27,
 -1.531124505777855e-28,  3.014748819808108e-30, -6.124500000616113e-32,  2.152915106197668e-17, -1.193285389323615e-18,  7.019206183030762e-20, -3.024835890871362e-21,
  1.136707529556927e-22, -3.917421094644230e-24,  1.216172780708394e-25, -3.480165254452660e-27,  9.434371339316013e-29, -2.395280768990954e-30,  5.719597549091269e-32,
 -1.317788427639974e-33,  1.829653138049181e-20, -1.579233724216883e-21,  1.186358428030860e-22, -6.760467913139199e-24,  3.307181451237668e-25, -1.437865720942356e-26,
  5.626908352318677e-28, -2.019510936027662e-29,  6.730429765494320e-31, -2.094104211596012e-32,  6.127436906382192e-34, -1.696077491840556e-35,  2.849852241074197e-24,
 -4.927599712123849e-25,  5.780057342257380e-26, -5.118783051241515e-27,  3.738173519974470e-28, -2.343909184452285e-29,  1.294574294708789e-30, -6.413764030612356e-32,
  2.887587584304604e-33, -1.193071497509436e-34,  4.559514847639072e-36, -1.620271119677051e-37,  9.326728942324140e-02, -3.614867168419714e-04,  1.481205626166345e-06,
 -2.432551863141206e-09,  1.210247970134507e-10, -4.960609117284285e-13, -7.260486850693046e-14, -7.955905218471916e-16,  4.016397533067489e-17,  1.069298617239914e-18,
 -1.355447340565383e-20, -8.970958117092328e-22,  7.026815179958397e-02, -2.817751346811530e-04,  1.506908406911912e-06, -7.764606995921478e-09,  8.041101868890311e-11,
 -4.149016740895749e-13, -1.943512427398938e-14, -2.428746664936849e-16,  1.158798849557587e-17,  3.115811257663945e-19, -3.767285237109499e-21, -2.598531160031420e-22,
  3.979347734521146e-02, -1.704369879663102e-04,  1.306314789570852e-06, -1.141642849518057e-08,  3.907397611865841e-11, -3.663582694105671e-13,  2.992058095812626e-14,
  2.620994159764707e-16, -1.451046284935771e-17, -3.866562444145130e-19,  5.071738613221030e-21,  3.252888053627983e-22,  1.685907325116005e-02, -7.931734379812342e-05,
  8.525042193521366e-07, -9.635359322539003e-09,  1.905569913249894e-11, -3.394737113011421e-13,  3.989899928118911e-14,  3.583052953396523e-16, -1.942486871154827e-17,
 -5.257551553698878e-19,  6.623079800461118e-21,  4.393097755282576e-22,  5.304211269272169e-03, -2.806428291065690e-05,  4.007309760622541e-07, -5.261650299368476e-09,
  1.145072663660962e-11, -2.542838216402865e-13,  2.486340164246456e-14,  2.100351353475441e-16, -1.157586066011786e-17, -3.200279842648439e-19,  3.895852029570428e-21,
  2.653587098059312e-22,  1.226489515541884e-03, -7.439077999551090e-06,  1.338439539037622e-07, -1.952484582004880e-09,  6.164620801112461e-12, -1.340571396414393e-13,
  9.748756622187765e-15,  7.267462101326867e-17, -4.191355368782793e-18, -1.199982399945981e-19,  1.399478159960308e-21,  9.830412861693804e-23,  2.055445356944796e-04,
 -1.451581726690586e-06,  3.151225851189678e-08, -5.014443242345766e-10,  2.330810492474525e-12, -4.817915460492414e-14,  2.592106333496420e-15,  1.532550864717932e-17,
 -9.795789649714081e-19, -2.981810671156968e-20,  3.288421684737637e-22,  2.392742485238012e-23,  2.451238540456607e-05, -2.042029491945791e-07,  5.174601700538639e-09,
 -8.929136473968731e-11,  5.844158770806728e-13, -1.174236968476762e-14,  4.806395082713083e-16,  1.768900783966147e-18, -1.472426277056775e-19, -5.028647246617611e-21,
  5.163138849791055e-23,  3.885123793368303e-24,  2.030983498019153e-06, -2.019361504994622e-08,  5.830412448600415e-10, -1.091916831928630e-11,  9.619832042083449e-14,
 -1.929695501277106e-15,  6.275964060889693e-17,  4.102624055579951e-20, -1.338989666858941e-20, -5.808042900673516e-22,  5.484831686942063e-24,  4.166421068432848e-25,
  1.133015367327704e-07, -1.360369694768780e-09,  4.401096524066313e-11, -8.992388028347474e-13,  1.028998163219777e-14, -2.110203234584411e-16,  5.758480356756781e-18,
 -1.813328415229796e-20, -5.775648760219455e-22, -4.639632525022032e-23,  4.081575993192025e-25,  2.853033888267804e-26,  4.081828829633639e-09, -5.996433352808361e-11,
  2.151718704270898e-12, -4.838703302705339e-14,  7.005511397894499e-16, -1.500378140786789e-17,  3.657805871741577e-19, -2.754217558721458e-21,  1.005918585197105e-23,
 -2.623683208766420e-24,  2.338230910440911e-26,  1.149893796658563e-27,  8.972611588287154e-11, -1.639451776810278e-12,  6.498726316049768e-14, -1.628592094018379e-15,
  2.930839897320654e-17, -6.693567533051250e-19,  1.558227475847975e-20, -1.895931412000213e-22,  2.548049497005458e-24, -1.089927706766869e-25,  1.154389767915616e-27,
  2.029173736433521e-29,  1.111036312621846e-12, -2.582216866992954e-14,  1.133902940882839e-15, -3.221867987300582e-17,  7.139280933394640e-19, -1.778588418847357e-20,
  4.220747957915995e-22, -7.091830884695677e-24,  1.292846670159981e-25, -3.367064594188531e-27,  4.699768196161711e-29, -2.717932905975015e-31,  6.885143316971363e-15,
 -2.104550366557521e-16,  1.036239741879522e-17, -3.422334513327038e-19,  9.340525591426635e-21, -2.609906454926466e-22,  6.713465867836388e-24, -1.440330874851004e-25,
  3.138138078825496e-27, -7.236061044180049e-29,  1.308833751511074e-30, -2.157624473976285e-32,  1.768611737147532e-17, -7.510893954735352e-19,  4.265693436489115e-20,
 -1.702180834855123e-21,  5.809205260190038e-23, -1.893100468056240e-24,  5.606964535894591e-26, -1.492156086714964e-27,  3.835670600365584e-29, -9.484080887602957e-31,
  2.128175299415489e-32, -4.602433532368872e-34,  1.346717704138397e-20, -8.825858170550005e-22,  6.170956273944474e-23, -3.191792823772734e-24,  1.425270121373866e-25,
 -5.783628220119726e-27,  2.122292577808166e-28, -7.143192441779019e-30,  2.254245889245688e-31, -6.679200404020097e-33,  1.858060469281334e-34, -4.916898233726847e-36,
  1.522025413035951e-24, -2.014519804938826e-25,  2.095367359593643e-26, -1.663309586132827e-27,  1.110648994505517e-28, -6.464983146245424e-30,  3.347171794755231e-31,
 -1.567258971705128e-32,  6.716652674814285e-34, -2.656638828219281e-35,  9.765717953801943e-37, -3.352739814712739e-38,  9.184490164497650e-02, -3.497223102600527e-04,
  1.462985787783125e-06, -6.747589437491793e-10,  9.275581952458574e-11, -2.330717270207980e-12, -7.228411260252172e-14,  9.263694412023453e-16,  5.992497318934714e-17,
 -1.801185460169817e-19, -4.396394269986188e-20, -2.234550394199796e-22,  6.916460151433007e-02, -2.700715000690287e-04,  1.421092409597591e-06, -6.571198507000941e-09,
  6.715269542479447e-11, -9.122714809869820e-13, -1.969259180245252e-14,  2.565902012953101e-16,  1.747161853057776e-17, -4.628436197981826e-20, -1.274343199976645e-20,
 -7.150723852324434e-23,  3.913177738089103e-02, -1.605241254347824e-04,  1.172957561244427e-06, -1.080944011285517e-08,  3.920374003455337e-11,  3.765493206709331e-13,
  2.910310699587911e-14, -3.588925671650756e-16, -2.154453656164384e-17,  7.045127512712409e-20,  1.593816372088447e-20,  7.453793337931143e-23,  1.655471873277368e-02,
 -7.295479101683696e-05,  7.386595748434589e-07, -9.330806941247408e-09,  2.222703630211525e-11,  6.535139355508480e-13,  3.896256436615664e-14, -4.784565229977293e-16,
 -2.918477192488944e-17,  8.591684446634207e-20,  2.154422309120852e-20,  1.105887171539276e-22,  5.197970108623280e-03, -2.510804914813275e-05,  3.386310206977131e-07,
 -5.085577072824791e-09,  1.255284612504102e-11,  3.621400268939998e-13,  2.417072120182202e-14, -2.924812618388778e-16, -1.761964898424303e-17,  4.691297078278592e-20,
  1.302869286129547e-20,  7.163053384757421e-23,  1.198728523262193e-03, -6.460487860781373e-06,  1.109597767953007e-07, -1.862213894065147e-09,  5.894817827024024e-12,
  1.057782590711155e-13,  9.381855152526809e-15, -1.115049687328996e-16, -6.506864576803928e-18,  1.493252148571186e-20,  4.836649371716563e-21,  2.869763191601061e-23,
  2.002051218265434e-04, -1.222969852468563e-06,  2.569805532440518e-08, -4.684091496423125e-10,  2.002070665322595e-12,  1.478835968579164e-14,  2.450928559077455e-15,
 -2.863324788787467e-17, -1.571500797958155e-18,  2.784529904351977e-21,  1.182157304964652e-21,  7.650834627019137e-24,  2.377178715230968e-05, -1.669468985355639e-07,
  4.153508190896308e-09, -8.118741120355574e-11,  4.655510810262243e-13, -2.898091469661145e-16,  4.417673676801176e-16, -5.109065105601211e-18, -2.509020453558576e-19,
  2.436603723213866e-22,  1.936966496759655e-22,  1.380079822510171e-24,  1.958741580987038e-06, -1.602964305810990e-08,  4.602362352410753e-10, -9.607613840177701e-12,
  7.243597331404626e-14, -4.750034277781196e-16,  5.527814081352840e-17, -6.436366567481909e-19, -2.597258809064775e-20, -1.037303118484164e-23,  2.122122040979867e-23,
  1.669917565120284e-25,  1.084994798699711e-07, -1.048919599008606e-09,  3.409238615101232e-11, -7.610816567854752e-13,  7.393753096422330e-15, -8.236624549568212e-17,
  4.777967205767083e-18, -5.767662248353421e-20, -1.647398047910242e-21, -5.313150099687229e-24,  1.534882144130158e-24,  1.315544696393416e-26,  3.872964268145135e-09,
 -4.490244957496707e-11,  1.629897438723829e-12, -3.912844157646359e-14,  4.818657465468566e-16, -7.192323275715508e-18,  2.808631994919721e-19, -3.658204174249528e-21,
 -5.467598088905362e-23, -6.367015521851433e-25,  7.227775737476534e-26,  6.330357810502129e-28,  8.409440101440365e-11, -1.190648055120569e-12,  4.787718147623748e-14,
 -1.248117575193508e-15,  1.926456690934085e-17, -3.531281821923122e-19,  1.090080596247356e-20, -1.598304067592728e-22, -2.824057615712875e-25, -4.081378070851653e-26,
  2.224705852223041e-27,  1.576662128287015e-29,  1.023684101759826e-12, -1.812701769237382e-14,  8.056929352999960e-16, -2.315159959372363e-17,  4.454110416320697e-19,
 -9.670794556242024e-21,  2.657209160326347e-22, -4.541129578399197e-24,  4.098626858358704e-26, -1.529795220665148e-27,  4.729155266215302e-29,  5.437950205689405e-32,
  6.186239742067803e-15, -1.417883448524219e-16,  7.005074465116356e-18, -2.269838201167597e-19,  5.454897739579961e-21, -1.389995401457881e-22,  3.757999226112101e-24,
 -7.666530463832870e-26,  1.302707991901656e-27, -3.314742141385001e-29,  7.586248485855319e-31, -6.846430513240348e-33,  1.525394155680375e-17, -4.782016898815803e-19,
  2.676140789525957e-20, -1.014552432186602e-21,  3.090412468420985e-23, -9.366118597562173e-25,  2.731854526285572e-26, -6.790965756209792e-28,  1.572644652582807e-29,
 -3.898488862286194e-31,  8.798062302438158e-33, -1.602916274282353e-34,  1.072666463689758e-20, -5.106277307189614e-22,  3.401406786644340e-23, -1.615745829518095e-24,
  6.501652530148776e-26, -2.454820378413627e-27,  8.527109199712394e-29, -2.679494484548381e-30,  7.927376910117855e-32, -2.253755779129816e-33,  5.984765954917564e-35,
 -1.488067596054276e-36,  9.575998192651344e-25, -9.103866918354351e-26,  8.480398192074260e-27, -5.988475633727825e-28,  3.614631393285720e-29, -1.940811329455215e-30,
  9.365526124460031e-32, -4.115361811072700e-33,  1.668730677343531e-34, -6.288404480890519e-36,  2.212148465406702e-37, -7.300227933338514e-39,  };
  int offset = -17;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 17;
    if (std::isnan(t)) {
      fill_n(rr+offset, 17, 0.5);
      fill_n(ww+offset, 17, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 17; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=17; ++j) {
        const int boxof = it*204+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
