/*
 * Network Utility Routines Interface for Tcl
 *
 *  by Kern Sibbald
 *
 *
 */
/*
   Copyright (C) 2000-2003 Kern Sibbald and John Walker

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <tcl.h>

#include "bacula.h"
#include "console_conf.h"
#include "jcr.h"

#define BnetVersion "1.0"
#define MAXCON 100
static BSOCK *confd[MAXCON];

int authenticate_director(JCR *jcr, DIRRES *director);

/* Forward referenced functions */
extern "C" int Tcl_BnetConnect(ClientData dummy, Tcl_Interp *interp,
   int argc, char **argv);
extern "C" int Tcl_BnetGet(ClientData dummy, Tcl_Interp *interp,
   int argc, char **argv);
extern "C" int Tcl_BnetPut(ClientData dummy, Tcl_Interp *interp,
   int argc, char **argv);
extern "C" int Tcl_BnetClose(ClientData dummy, Tcl_Interp *interp,
   int argc, char **argv);

/*
 * Entry point called by Tcl when tclbnet.so is loaded
 */
extern "C" int Tclbnet_Init(Tcl_Interp *interp)
{
   int stat;
   int con;

   for (con=0; con<MAXCON; con++) {
      confd[con] = NULL;
   }
   stat = Tcl_PkgProvide(interp, "Bnet", BnetVersion);
   if (stat == TCL_OK) {
      Tcl_CreateCommand(interp, "BnetConnect", Tcl_BnetConnect,
	 (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
      Tcl_CreateCommand(interp, "BnetGet", Tcl_BnetGet,
	 (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
      Tcl_CreateCommand(interp, "BnetPut", Tcl_BnetPut,
	 (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
      Tcl_CreateCommand(interp, "BnetClose", Tcl_BnetClose,
	 (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   }
   return stat;
}

extern "C" int
Tcl_BnetConnect(ClientData dummy, Tcl_Interp *interp,
   int argc, char **argv)
{
   int i, j, con;
   char *host;
   int port;
   JCR jcr;
   DIRRES director;
   char sig[50];
   struct MD5Context md5c;
   unsigned char signature[16];

   
   my_name_is(argc, argv, "BaculaGUI");
   init_msg(NULL, NULL);
   working_directory = "/tmp";

   memset(&jcr, 0, sizeof(jcr));
   memset(&director, 0, sizeof(director));
   if (argc < 4) {
      Tcl_AppendResult(interp, "usage: ", argv[0], (char *)NULL);
      Tcl_AppendResult(interp, " Host Port Password", (char *)NULL);
      return TCL_ERROR;
   }
   for (con=0; con<MAXCON; con++) {
      if (confd[con] == NULL)
	 break;
   }
   if (con > MAXCON-1) {
      Tcl_AppendResult(interp, "Too many connections.", (char *)NULL);
      return TCL_ERROR;
   }
   host = argv[1];
   port = atoi(argv[2]);
   confd[con] = bnet_connect(NULL, 10, 60, "BaculaGUI", host, NULL, port, 0); 
   if (confd[con] == NULL) {
      Tcl_AppendResult(interp, "Could not connect to Director", (char *)NULL);
      return TCL_ERROR;
   }
   jcr.dir_bsock = confd[con];

   /* Hash password */
   MD5Init(&md5c);
   MD5Update(&md5c, (unsigned char *) argv[3], strlen(argv[3]));
   MD5Final(signature, &md5c);
   for (i = j = 0; i < sizeof(signature); i++) {
      sprintf(&sig[j], "%02x", signature[i]); 
      j += 2;
   }

   director.password = sig;
   if (!authenticate_director(&jcr, &director)) {
      Tcl_AppendResult(interp, "Could not authenticate Director", (char *)NULL);
      return TCL_ERROR;
   }
   sprintf(interp->result, "%d", con);
   return TCL_OK;
}

extern "C" int
Tcl_BnetGet(ClientData dummy, Tcl_Interp *interp,
   int argc, char **argv)
{
   int i;
   int len;
   char msg[1000];

   i = atoi(argv[1]);
   while (bnet_recv(confd[i]) > 0) {
      Tcl_AppendResult(interp, confd[i]->msg, NULL);  
   }
   return TCL_OK;
}

extern "C" int
Tcl_BnetPut(ClientData dummy, Tcl_Interp *interp,
   int argc, char **argv)
{
   int i;

   i = atoi(argv[1]);
   strcpy(confd[i]->msg, argv[2]);
   confd[i]->msglen = strlen(argv[2]);
   bnet_send(confd[i]); 	 
   return TCL_OK;
}

extern "C" int
Tcl_BnetClose(ClientData dummy, Tcl_Interp *interp,
   int argc, char **argv)
{
   int i;

   i = atoi(argv[1]);
   bnet_close(confd[i]);
   confd[i] = NULL;
   return TCL_OK;
}
