#
# Bacula Graphic Interface
#            
# This is the main program. Call it with:
#   
#      wish bacula.tcl
#
#  Some of the menu items work such as connect, the output
#   it not put in the resulting text box.
#
global ua
global console
global connectvar

proc RealConnect {} {
   global connectvar ua
   set host [.d.info.host get]
   set port [.d.info.port get]
   set password [.d.info.password get]
#  puts "host=$host"
#  puts "port=$port"
   set ua [BnetConnect $host $port $password] 
#  puts "ua=$ua"
   set connectvar 1
#  puts "End of RealConnect"
}

proc ConnectCmd {} {
   global console connectvar ua
   dialog_create Dialog .d
   wm title .d "Connect" 
   label .d.info.hostlabel -text "Host:"
   entry .d.info.host
   .d.info.host insert 0 "localhost"
   label .d.info.portlabel -text "Port:"
   entry .d.info.port
   .d.info.port insert 0 "8101"
   label .d.info.passwordlabel -text "Password:"
   entry .d.info.password
   .d.info.password insert 0 "UA_password"
   grid .d.info.hostlabel -row 0 -column 0 -sticky e
   grid .d.info.host -row 0 -column 1 -sticky ew
   grid .d.info.portlabel -row 1 -column 0 -sticky e
   grid .d.info.port -row 1 -column 1 -sticky ew
   grid .d.info.passwordlabel -row 2 -column 0 -sticky e
   grid .d.info.password -row 2 -column 1 -sticky ew
   grid columnconfigure .d.info 1 -weight 1
   bind .d.info.host <KeyPress-Return> {focus .d.info.port}
   bind .d.info.port <KeyPress-Return> {focus .d.info.password}
   bind .d.info.password <KeyPress-Return> {focus .d.info.connect}
   set ctrl [dialog_controls .d]
   button $ctrl.connect -text "Connect" -command {RealConnect}
   pack $ctrl.connect -pady 4
   dialog_wait .d connectvar
   destroy .d

#  puts "After vwait connectvar" 
   set console [dialog_create Textdisplay]
   wm title $console "Director Console"
   set info [dialog_info $console]
   scrollbar $info.sbar -command "$info.text yview"
   pack $info.sbar -side right -fill y
   text $info.text -wrap word -yscrollcommand "$info.sbar set"
   pack $info.text -side left -expand yes -fill both
   set ctrl [dialog_controls $console]
   button $ctrl.exit -text "Exit" -command "ExitConsole"
   pack $ctrl.exit -pady 4
   focus $ctrl.exit
}

proc ExitConsole {} {
   global console ua
   BnetClose $ua  
   destroy $console
}

proc MessageBox {msg type} {
   tk_messageBox -icon $type -message $msg
}

proc JobCmd {} {
   MessageBox {Job Command not yet implemented}  error
} 

proc BackupCmd {} {
   MessageBox {Backup Command not yet implemented} error
} 

proc RestoreCmd {} {
   MessageBox {Restore Command not yet implemented} error 
} 

proc ScheduleCmd {} {
   MessageBox {Schudele Command not yet implemented} error
} 

proc ExitCmd {} {
   exit 0
}


proc HelpCmd {} {
   exec netscape file:///home/kern/bacula/k/doc/index.html &
}

load ./tclbnet.so

wm title . "Bacula"
wm minsize . 600 390

foreach File [list \
   mainwindow.tcl \
   about.tcl \
   dialog.tcl \
             ] {
      if {![file exists "$File"]} {
         puts "Unable to find required source file $File"
         exit 1
      } else {
         source $File
      }
}
unset File

CreateMainWindow

# Now wait for user to connect

# The lines below show how to connect, send data (BnetPut),
#  and how to get data (BnetGet)
#
# puts {Open connection}
# set ua [BnetConnect localhost 8101 UA_password]
# BnetPut $ua "status dir"
# set msg [BnetGet $ua]
# puts $msg
# BnetPut $ua "quit"
# set msg [BnetGet $ua]
# puts $msg 
# BnetClose $ua  
