
# All Volumes not written in 10 days
select VolumeName from Media where 
  (to_days(current_date) - to_days(LastWritten)) > 10;

# All files on a Volume 1
select FilenameId from File, JobMedia, Media where JobMedia.MediaId=1
  and JobMedia.JobId=File.JobId group by FilenameId;

# Files appearing only once
select Filename.Name,count(*) as count from Filename,File,
  JobMedia, Media where JobMedia.JobId=File.JobId and 
  Media.MediaId=JobMedia.MediaId and              
  Filename.FilenameId=File.FilenameId
  group by Filename.Name having count = 1;


# Files appearing only once
select Filename.FilenameId,Filename.Name,VolumeName, count(*) as count  
  from Filename,File,JobMedia,Media where
  JobMedia.JobId=File.JobId and Media.MediaId=JobMedia.MediaId and
  Filename.FilenameId=File.FilenameId
  and (to_days(current_date) - to_days(LastWritten)) > 3
  group by Filename.Name,VolumeName having count > 1;

select Job.JobId,Path.Path,Filename.Name,VolumeName, count(*) as count  
  from Filename,File,Path,JobMedia,Media,Job where
  JobMedia.JobId=File.JobId 
  and Job.JobId=File.JobId
  and Media.MediaId=JobMedia.MediaId 
  and Filename.FilenameId=File.FilenameId
  and Path.PathId=File.PathId
  and (to_days(current_date) - to_days(LastWritten)) > 2
  group by Job.JobId having count > 1;

# First create table with all files older than 2 days
drop table if exists retension;
create temporary table retension
  select Job.JobId,File.FileId,Path.PathId,Filename.FilenameId
  from Filename,File,Path,JobMedia,Media,Job
  where JobMedia.JobId=File.JobId 
  and Job.JobId=File.JobId
  and Media.MediaId=JobMedia.MediaId 
  and Filename.FilenameId=File.FilenameId
  and Path.PathId=File.PathId
  and (to_days(current_date) - to_days(EndTime)) > 2;
# Now select entries that have a more recent backup
select retension.JobId,retension.FileId,Path.Path,Filename.Name
  from retension,Filename,File,Path,Job
  where Job.JobId!=retension.JobId
  and (to_days(current_date) - to_days(Job.EndTime)) <= 2
  and Job.JobId=File.JobId
  and Filename.FilenameId=File.FilenameId
  and Path.PathId=File.PathId
  and retension.PathId=File.PathId
  and retension.FilenameId=File.FilenameId;
