/*
 * Created on 2004-3-11
 */
package org.cneclipse.bdcc.ui;

import org.cneclipse.bdcc.*;
import org.eclipse.swt.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.gudy.azureus2.plugins.*;

/**
 * @author Leon
 */
public class BDCCPluginView extends PluginView {

	private static Display display;
	private Composite composite;
	private PluginInterface pluginInterface;

	/**
	 * @return Returns the display.
	 */
	public static Display getDisplay() {
		return display;
	}

	/**
	 * @param pluginInterface
	 */
	public BDCCPluginView(PluginInterface pluginInterface) {
		this.pluginInterface = pluginInterface;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.gudy.azureus2.ui.swt.views.IView#getFullTitle()
	 */
	public String getFullTitle() {
		return "BDCC Control Panel";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.gudy.azureus2.plugins.PluginView#getPluginViewName()
	 */
	public String getPluginViewName() {
		return "BDCC Control Panel";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.gudy.azureus2.ui.swt.views.AbstractIView#initialize(org.eclipse.swt.widgets.Composite)
	 */
	public void initialize(Composite parent) {
		display = parent.getDisplay();
		FillLayout fillLayout = new FillLayout();
		fillLayout.type = SWT.VERTICAL;
		RowLayout rowLayout = new RowLayout();
		rowLayout.type = SWT.HORIZONTAL;
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 1;
		composite = new Composite(parent, SWT.NONE);
		composite.setLayout(fillLayout);
		Group group1 = new Group(composite, SWT.NONE);
		Group group2 = new Group(composite, SWT.NONE);
		Group group3 = new Group(composite, SWT.NONE);
		group1.setText("Server 1");
		group2.setText("Server 2");
		group3.setText("Server 3");
		group1.setLayout(gridLayout);
		group2.setLayout(gridLayout);
		group3.setLayout(gridLayout);
		Composite buttons1 = new Composite(group1, SWT.NONE);
		Composite buttons2 = new Composite(group2, SWT.NONE);
		Composite buttons3 = new Composite(group3, SWT.NONE);
		buttons1.setLayout(rowLayout);
		buttons2.setLayout(rowLayout);
		buttons3.setLayout(rowLayout);
		Button connectButton1 = new Button(buttons1, SWT.PUSH);
		Button connectButton2 = new Button(buttons2, SWT.PUSH);
		Button connectButton3 = new Button(buttons3, SWT.PUSH);
		connectButton1.setText("Connect");
		connectButton2.setText("Connect");
		connectButton3.setText("Connect");
		connectButton1.addSelectionListener(new BDCCConnectListener(BDCCPlugin.getClient1()));
		connectButton2.addSelectionListener(new BDCCConnectListener(BDCCPlugin.getClient2()));
		connectButton3.addSelectionListener(new BDCCConnectListener(BDCCPlugin.getClient3()));
		Button disconnectButton1 = new Button(buttons1, SWT.PUSH);
		Button disconnectButton2 = new Button(buttons2, SWT.PUSH);
		Button disconnectButton3 = new Button(buttons3, SWT.PUSH);
		disconnectButton1.setText("Disconnect");
		disconnectButton2.setText("Disconnect");
		disconnectButton3.setText("Disconnect");
		disconnectButton1.addSelectionListener(new BDCCDisconnectListener(BDCCPlugin.getClient1(),parent.getShell()));
		disconnectButton2.addSelectionListener(new BDCCDisconnectListener(BDCCPlugin.getClient2(),parent.getShell()));
		disconnectButton3.addSelectionListener(new BDCCDisconnectListener(BDCCPlugin.getClient3(),parent.getShell()));
		Text status1 = new Text(group1, SWT.READ_ONLY | SWT.V_SCROLL | SWT.BORDER);
		Text status2 = new Text(group2, SWT.READ_ONLY | SWT.V_SCROLL | SWT.BORDER);
		Text status3 = new Text(group3, SWT.READ_ONLY | SWT.V_SCROLL | SWT.BORDER);
	    GridData gridData = new GridData(GridData.FILL_BOTH | GridData.CENTER);
	    gridData.grabExcessHorizontalSpace = true;
	    status1.setLayoutData(gridData);
	    status2.setLayoutData(gridData);
	    status3.setLayoutData(gridData);
		if (BDCCPlugin.getClient1() != null)
			BDCCPlugin.getClient1().setStatusListener(status1);
		if (BDCCPlugin.getClient2() != null)
			BDCCPlugin.getClient2().setStatusListener(status2);
		if (BDCCPlugin.getClient3() != null)
			BDCCPlugin.getClient3().setStatusListener(status3);
	}

	public Composite getComposite() {
		return composite;
	}
	
	/* (non-Javadoc)
	 * @see org.gudy.azureus2.ui.swt.views.AbstractIView#delete()
	 */
	public void delete() {
		if (BDCCPlugin.getClient1() != null)
			BDCCPlugin.getClient1().setStatusListener(null);
		if (BDCCPlugin.getClient2() != null)
			BDCCPlugin.getClient2().setStatusListener(null);
		if (BDCCPlugin.getClient3() != null)
			BDCCPlugin.getClient3().setStatusListener(null);
		super.delete();
	}
}
