/*
 * Created on 2004-2-20
 */
package org.cneclipse.bdcc;

import java.util.*;
import org.gudy.azureus2.plugins.download.*;

/**
 * @author Leon
 */
public class BDCCHelper {

	/**
	 * @param message
	 * @return
	 */
	public static String[] splitWords(String message) {
		if (message == null || message.length() == 0)
			return new String[0];
		StringTokenizer st = new StringTokenizer(message, " ");
		Vector v = new Vector();
		while (st.hasMoreTokens()) {
			String word = st.nextToken();
			v.add(word);
		}
		String[] words = new String[v.size()];
		v.toArray(words);
		return words;
	}

	public static String formatTime(long time) {
		int secs = (int) time % 60;
		int mins = (int) (time / 60) % 60;
		int hours = (int) (time / 3600) % 24;
		int days = (int) (time / 86400);
		String result = "";
		if (days > 0)
			result = days + "d ";
		if (hours > 0 || days > 0)
			result += hours + "h ";
		if ((days == 0) && ((mins > 0 || hours > 0) && mins < 10))
			result += "0" + mins + "m ";
		if ((days == 0) && ((mins > 0 || hours > 0) && mins >= 10))
			result += mins + "m ";
		if ((hours == 0 && days == 0) && ((secs > 0 || mins > 0) && secs < 10))
			result += "0" + secs + "s ";
		if ((hours == 0 && days == 0) && ((secs > 0 || mins > 0) && secs >= 10))
			result += secs + "s ";
		return result;
	}

	public static String getDescriptionOfStatus(int status) {
		switch (status) {
			case Download.ST_DOWNLOADING :
				return "Downloading";
			case Download.ST_ERROR :
				return "Error";
			case Download.ST_PREPARING :
				return "Preparing";
			case Download.ST_READY :
				return "Ready";
			case Download.ST_SEEDING :
				return "Seeding";
			case Download.ST_STOPPED :
				return "Stopped";
			case Download.ST_STOPPING :
				return "Stopping";
			case Download.ST_WAITING :
				return "Waiting";
			case Download.ST_QUEUED :
				return "Quered";
		}
		return "";
	}
}
