#---------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#---------------------------------------------------------------------------------------------
#pylint: skip-file

# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.pipeline import ClientRawResponse
from msrestazure.azure_exceptions import CloudError
from msrestazure.azure_operation import AzureOperationPoller
import uuid

from .. import models


class NicOperations(object):
    """NicOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An objec model deserializer.
    """

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer

        self.config = config

    def create_or_update(
            self, resource_group_name, deployment_name, network_interface_name, subnet, enable_ip_forwarding=False, content_version=None, internal_dns_name_label=None, load_balancer_backend_address_pool_ids=None, load_balancer_inbound_nat_rule_ids=None, location=None, network_security_group=None, network_security_group_type="none", private_ip_address=None, private_ip_address_allocation="dynamic", private_ip_address_version="ipv4", public_ip_address=None, public_ip_address_type="none", subnet_type="existingName", tags=None, use_dns_settings="false", virtual_network_name=None, custom_headers=None, raw=False, **operation_config):
        """
        Create or update a virtual machine.

        :param resource_group_name: The name of the resource group. The name
         is case insensitive.
        :type resource_group_name: str
        :param deployment_name: The name of the deployment.
        :type deployment_name: str
        :param enable_ip_forwarding: Enable IP forwarding.
        :type enable_ip_forwarding: bool
        :param network_interface_name: Name of the new NIC.
        :type network_interface_name: str
        :param subnet: Name or ID of an existing subnet to associate with the
         NIC.
        :type subnet: str
        :param content_version: If included it must match the ContentVersion
         in the template.
        :type content_version: str
        :param internal_dns_name_label: The internal DNS name label.
        :type internal_dns_name_label: str
        :param load_balancer_backend_address_pool_ids: Array of load balancer
         backend address pool IDs.
        :type load_balancer_backend_address_pool_ids: list of object
        :param load_balancer_inbound_nat_rule_ids: Array of load balancer
         inbound NAT rule IDs.
        :type load_balancer_inbound_nat_rule_ids: list of object
        :param location: Location for NIC resource.
        :type location: str
        :param network_security_group: Name or ID of an existing network
         security group to associate with the NIC.
        :type network_security_group: str
        :param network_security_group_type: Identifies whether to use an
         existing NSG. Possible values include: 'none', 'existingName',
         'existingId'
        :type network_security_group_type: str or
         :class:`networkSecurityGroupType
         <niccreationclient.models.networkSecurityGroupType>`
        :param private_ip_address: Static private IP address to use.
        :type private_ip_address: str
        :param private_ip_address_allocation: Private IP address allocation
         method. Possible values include: 'dynamic', 'static'
        :type private_ip_address_allocation: str or
         :class:`privateIpAddressAllocation
         <niccreationclient.models.privateIpAddressAllocation>`
        :param private_ip_address_version: The private IP address version to
         use. Possible values include: 'ipv4', 'ipv6'
        :type private_ip_address_version: str or
         :class:`privateIpAddressVersion
         <niccreationclient.models.privateIpAddressVersion>`
        :param public_ip_address: Name or ID an existing public IP address to
         associate with the NIC.
        :type public_ip_address: str
        :param public_ip_address_type: Specify whether to associate an
         existing public IP address with the NIC. Possible values include:
         'none', 'existingName', 'existingId'
        :type public_ip_address_type: str or :class:`publicIpAddressType
         <niccreationclient.models.publicIpAddressType>`
        :param subnet_type: Specify whether supplied subnet is by name or ID.
         Possible values include: 'existingName', 'existingId'
        :type subnet_type: str or :class:`subnetType
         <niccreationclient.models.subnetType>`
        :param tags: Tags object.
        :type tags: object
        :param use_dns_settings: Flag to specify whether to use DNS settings.
         Possible values include: 'true', 'false'
        :type use_dns_settings: str or :class:`useDnsSettings
         <niccreationclient.models.useDnsSettings>`
        :param virtual_network_name: Virtual network to associate with the
         NIC.
        :type virtual_network_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :rtype:
         :class:`AzureOperationPoller<msrestazure.azure_operation.AzureOperationPoller>`
         instance that returns :class:`DeploymentExtended
         <default.models.DeploymentExtended>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        """
        parameters = models.DeploymentNic(content_version=content_version, enable_ip_forwarding=enable_ip_forwarding, internal_dns_name_label=internal_dns_name_label, load_balancer_backend_address_pool_ids=load_balancer_backend_address_pool_ids, load_balancer_inbound_nat_rule_ids=load_balancer_inbound_nat_rule_ids, location=location, network_interface_name=network_interface_name, network_security_group=network_security_group, network_security_group_type=network_security_group_type, private_ip_address=private_ip_address, private_ip_address_allocation=private_ip_address_allocation, private_ip_address_version=private_ip_address_version, public_ip_address=public_ip_address, public_ip_address_type=public_ip_address_type, subnet=subnet, subnet_type=subnet_type, tags=tags, use_dns_settings=use_dns_settings, virtual_network_name=virtual_network_name)

        # Construct URL
        url = '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deployments/{deploymentName}'
        path_format_arguments = {
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str', max_length=64, min_length=1, pattern='^[-\w\._]+$'),
            'deploymentName': self._serialize.url("deployment_name", deployment_name, 'str', max_length=64, min_length=1, pattern='^[-\w\._]+$'),
            'subscriptionId': self._serialize.url("self.config.subscription_id", self.config.subscription_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.config.api_version", self.config.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct body
        body_content = self._serialize.body(parameters, 'DeploymentNic')

        # Construct and send request
        def long_running_send():

            request = self._client.put(url, query_parameters)
            return self._client.send(
                request, header_parameters, body_content, **operation_config)

        def get_long_running_status(status_link, headers=None):

            request = self._client.get(status_link)
            if headers:
                request.headers.update(headers)
            return self._client.send(
                request, header_parameters, **operation_config)

        def get_long_running_output(response):

            if response.status_code not in [200, 201]:
                exp = CloudError(response)
                exp.request_id = response.headers.get('x-ms-request-id')
                raise exp

            deserialized = None

            if response.status_code == 200:
                deserialized = self._deserialize('DeploymentExtended', response)
            if response.status_code == 201:
                deserialized = self._deserialize('DeploymentExtended', response)

            if raw:
                client_raw_response = ClientRawResponse(deserialized, response)
                return client_raw_response

            return deserialized

        if raw:
            response = long_running_send()
            return get_long_running_output(response)

        long_running_operation_timeout = operation_config.get(
            'long_running_operation_timeout',
            self.config.long_running_operation_timeout)
        return AzureOperationPoller(
            long_running_send, get_long_running_output,
            get_long_running_status, long_running_operation_timeout)
