<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    setup-story-categories.php                              */
/* Author:      Paul Waite                                              */
/* Description: Story category maintenance page                         */
/*                                                                      */
/* ******************************************************************** */
include_once("application.php");

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page("Story Categories", "maint", $theme);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");
include_once("maintainer-defs.php");

//debug_on(DBG_SQL|DBG_DUMP|DBG_DIAGNOSTIC);
//debug_on(DBG_ALL);

// -----------------------------------------------------------------------
// AUTHORISATION
// No guests allowed to see content..
if (!$RESPONSE->ismemberof_group_in("Admin,Editor")) {
  $RESPONSE->send();
  exit;
}

// Meta-elements maintainer form..
$maint = new maintainer("Story Categories", "ax_story_category");
$maint->setalign("center");
$maint->view_primary_keys();
$maint->linked_table("Default locations", "ax_content_location", "ax_story_category_locs", "combo");

// #######################################################################
// OUTPUT..
$RESPONSE->plugin("MAIN_CONTENT",  $maint->render());

// -----------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>