<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    axyl-plugin-areas.php                                   */
/* Author:      Paul Waite                                              */
/* Description: Manage Axyl plugin areas. Plugin areas are positions in */
/*              the template which contain dynamically 'plugged-in'     */
/*              content. This page maintains a list of these areas.     */
/*                                                                      */
/* ******************************************************************** */
include_once("application.php");
include_once("maintainer-defs.php");

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page("Plugin Areas", "maint", $theme);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");

// User type form widget..
$maint = new maintainer("Plugin Areas", "ax_plugin_area");
$maint->set_allowed_groups("Admin,Editor");
$maint->setalign("center");
$maint->view_primary_keys();

$RESPONSE->plugin("MAIN_CONTENT", $maint->render());

// -----------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>