#!/bin/bash
# Detect the database installation settings. This is ENTIRELY database
# dependent. This script is used to set WHATEVER environment variables
# that you want to be used by subsequent scripts to do stuff with the
# database.

# NOTE: This is not normally run standalone. The main DB manipulation
# scripts usually call this to set up environment vars for themselves.
# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

# Variables to be set by this detaction script:


# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

# The database type this remove script is for. This is just
# for messages and display..
DBTYPE="Oracle"

# INCOMING PARAMETERS
#  $1  - DBNAME
#  $2  - DBUSER
#  $3  - DBPASSWD ('none' means a blank password)
#  $4  - DBHOST ('direct' means a local database server)
#  $5  - DBPORT
DBNAME=""
DBUSER=""
DBPASSWD=""
DBHOST=""
DBPORT=5432

POS=0
while [ $# -gt 0 ] ; do
  POS=`expr $POS + 1`
  case $POS in
    1)  DBNAME=$1
        ;;
    2)  DBUSER=$1
        ;;
    3)  DBPASSWD=$1
        ;;
    4)  DBHOST=$1
        ;;
    5)  DBPORT=$1
        ;;
  esac
  shift
done

if [ "$DBNAME" = "" -o "$DBUSER" = "" ]
then
  echo "ERROR: $DBTYPE detect-db.sh: parameters."
  echo "usage: detect-db.sh dbname dbuser [dbpasswd] [dbhost] [dbport]"
  exit 1
fi

# Optional host settings for remotely accessed databases..
HOSTOPTS=""
[ "$DBHOST" != "direct" ] && HOSTOPTS="--host $DBHOST --port $DBPORT"


# Do no detection for this database at present.

exit 0

# END