#!/bin/sh
# Install a POSTGRESQL database for an Axyl website.

# NOTE: This is not normally run standalone. The main DB installation
# script 'install/install-db.sh normally runs this.
# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

# The database type this install script is for. This is just
# for messages and display..
DBTYPE="ORACLE"

# INCOMING PARAMETERS
#  $1 - INSTALLTYPE
#  $2 - DBNAME
#  $3 - DBUSER
#  $4 - DBPASSWD ('none' means a blank password)
#  $5 - DBHOST ('direct' means a local database server)
#  $6 - DBPORT
#  $7 - META ('y' or 'n')
INSTALLTYPE=
DBNAME=
DBUSER=
DBPASSWD=
DBHOST=
DBPORT=5432
META=n
[ ! -z $1 ] && INSTALLTYPE=$1
[ ! -z $2 ] && DBNAME=$2
[ ! -z $3 ] && DBUSER=$3
[ ! -z $4 ] && DBPASSWD=$4
[ ! -z $5 ] && DBHOST=$5
[ ! -z $6 ] && DBPORT=$6
[ ! -z $7 ] && META=$7
if [ "$INSTALLTYPE" = "" -o "$AXUSER" = "" -o "$AXYL_HOME" = "" -o "$AXYL_DATA" = "" ]
then
  echo "ERROR: $DBTYPE install-db.sh: parameters."
  echo "usage: install-db.sh empty|demo dbname dbuser [dbpasswd] [dbhost] [dbport]"
  exit 1
fi

echo " $DBTYPE database - $INSTALLTYPE version"
echo " database name: $DBNAME"
echo " connecting as: $DBUSER"
[ "$DBPASSWD" != "none" ] && echo " password: $DBPASSWD"
[ "$DBHOST" != "direct" ] && echo " remote host: $DBHOST"
[ "$DBHOST" != "direct" ] && echo " port: $DBPORT"

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# INSTALL
echo ""
echo "*********************************************************************"
echo "IMPORTANT NOTICE!"
echo "You have chosen a database type which does not currently have an"
echo "Axyl installer. At the present time we only provide an automatic"
echo "installation process for Postgresql."
echo ""
echo "In the directory $AXYL_HOME/db/oracle you will find the Axyl core"
echo "schema in 'axyl_core.sql'. This SQL definition may, with some editing,"
echo "suit your database creation needs. Failing that, if you have the"
echo "Sybase Powerdesigner package there is a PDM file there also, called"
echo "'axyl_core.pdm' which might be used to produce a new definition."
echo ""
echo "Note also the file 'axyl_core_data.sql', is an SQL definition, which"
echo "has the mandatory initial dataset for Axyl. This must be loaded."
echo "*********************************************************************"
echo -n "[ENTER] to continue.."
read ANS

# END
