/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.server;

import java.io.File;
import java.io.IOException;
import nz.net.catalyst.Log;
import nz.net.catalyst.lucene.server.Application;
import nz.net.catalyst.lucene.server.ApplicationMissingException;
import nz.net.catalyst.lucene.server.Constants;
import nz.net.catalyst.lucene.server.ECommand;
import nz.net.catalyst.lucene.server.IPackage;
import nz.net.catalyst.lucene.server.Transmission;
import nz.net.catalyst.lucene.server.WriterControl;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;

public class EXPERIMENTAL
implements IPackage,
Constants {
    private final Transmission input;
    private Application application;

    EXPERIMENTAL(Transmission transmission) {
        this.input = transmission;
    }

    Transmission execute() {
        Transmission response = new Transmission(ECommand.CONTROL_RESPONSE);
        response.setSerial(this.input.getSerial());
        String appName = this.input.get("Application", NO_APP);
        try {
            this.application = Application.getAppOrDefault(appName);
        }
        catch (ApplicationMissingException e) {
            return this.error(e.getMessage());
        }
        try {
            this.input.setApplication(this.application);
            Analyzer analyzer = Application.getAnalyzer(this.input);
            File luceneStoreDir = Application.getIndexDirectory(this.application);
            if (luceneStoreDir == null) {
                return this.error("Application's Index Directory could not be retreived.");
            }
            Log.info(" Index Directory: " + luceneStoreDir);
            WriterControl writerControl = WriterControl.getWriterControl(luceneStoreDir, analyzer);
            Log.info("EXP: got WriterControl.");
            IndexWriter writer = writerControl.getIndexWriter();
            Log.info("EXP: got IndexWriter.");
            Log.info("EXP: about to sleep for 2 minutes.");
            Thread.sleep(120000L);
            Log.info("EXP: done sleeping");
            writerControl.release();
            Log.info("EXP: WriterControl.release'd, exiting.");
        }
        catch (IOException e) {
            Log.error("EXP: IOError on index writer open");
        }
        catch (InterruptedException e) {
            Log.error("EXP: Interrupted while sleeping!");
        }
        long afterWriterClose = System.currentTimeMillis();
        response.add("Open", "blah");
        return response;
    }

    private Transmission error(String message) {
        Transmission response = new Transmission(ECommand.CONTROL_RESPONSE);
        response.setSerial(this.input.getSerial());
        response.add("Error", message);
        Log.error("ERROR during BACKUP: " + message);
        return response;
    }
}

