/*
 * ManagedSearcher.java
 *
 * Created on 2002. ???prilis 6., 23:21
 */

package hu.origo.lucenetools.iac;
import java.io.IOException;

import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopFieldDocs;

/**
 * The Searcher object used in conjuction with the IndexAccessControl component.
 *
 * @author  Peter Halacsy
 * @version
 */
public class ManagedSearcher extends Searcher {
    protected Searcher m_searcher;
    
    protected long m_lastUsed;
    
    /** object that is interested in the fact that this searcher is closed */
    protected SearcherListener m_manager;
    
    /** Creates new ManagedSearcher */
    public ManagedSearcher(SearcherListener manager, Searcher searcher) {
        m_manager = manager;
        m_searcher = searcher;
    }
    
    Searcher getRealSearcher() {
        return m_searcher;
    }
    /** Notify listener  */
    public void close() throws IOException {
        // do not close the searcher but notify listener
        m_manager.searcherClosed(new SearcherEvent(this));
    }
    
    
    
    
    // implementing methods of Searcher
    
    /** For use by {@link HitCollector} implementations.  */
    public Document doc(int i) throws IOException {
        return m_searcher.doc(i);
    }

    public void search(Query query, Filter filter, HitCollector results) throws IOException {
        m_searcher.search(query, filter, results);
    }
    public TopDocs search(Query query, Filter filter, int n) throws IOException {
        return m_searcher.search(query, filter, n);
    }
    public TopFieldDocs search(Query query, Filter filter, int n, Sort sort) throws IOException {
        return m_searcher.search(query, filter, n, sort);
    }
    
    public int docFreq(Term term) throws IOException {
        return m_searcher.docFreq(term);
    }
    
    public int maxDoc() throws IOException {
        return m_searcher.maxDoc();
    }

	public Query rewrite(Query original) throws IOException {
	  return m_searcher.rewrite(original);
	}

	public Explanation explain(Query query, int doc) throws IOException {
	  return m_searcher.explain(query, doc);
	}       
}
