/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.server;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nz.net.catalyst.Log;
import nz.net.catalyst.Util;
import nz.net.catalyst.lucene.server.Application;
import nz.net.catalyst.lucene.server.Constants;
import nz.net.catalyst.lucene.server.DateField;
import nz.net.catalyst.lucene.server.ECommand;
import nz.net.catalyst.lucene.server.FieldDef;
import nz.net.catalyst.lucene.server.IPackage;
import nz.net.catalyst.lucene.server.QueryException;
import nz.net.catalyst.lucene.server.RangeDef;
import nz.net.catalyst.lucene.server.Transmission;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.queryParser.TokenMgrError;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;

public class Query
implements IPackage,
Constants {
    private final Transmission input;
    private Application application;

    Query(Transmission transmission) {
        this.input = transmission;
    }

    /*
     * Exception decompiling
     */
    Transmission execute() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 12[TRYBLOCK] [10 : 776->779)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private org.apache.lucene.search.Query buildQuery(Analyzer a, String field, Map fieldMap) {
        try {
            int clauseLimitSystem = Integer.parseInt(System.getProperty(String.valueOf(IPackage.PACKAGE) + "ClauseLimitSystem"));
            BooleanQuery.setMaxClauseCount((int)clauseLimitSystem);
            Log.debug("setting max clause count to:" + clauseLimitSystem);
        }
        catch (NumberFormatException e) {
            Log.error("invalid setting for ClauseLimitSystem:" + System.getProperty(String.valueOf(IPackage.PACKAGE) + "ClauseLimitSystem"));
        }
        QueryParser qp = new QueryParser(field, a);
        BooleanQuery result = new BooleanQuery();
        boolean anyTerms = false;
        String domain = this.input.get("Domain");
        if (domain != null) {
            Term domainSearch = new Term("Domain", domain);
            result.add((org.apache.lucene.search.Query)new TermQuery(domainSearch), true, false);
            anyTerms = true;
        }
        String query = this.input.get("Query");
        Log.debug("Query (Unparsed): " + query);
        if (query != null) {
            try {
                result.add(qp.parse(query), true, false);
                anyTerms = true;
            }
            catch (BooleanQuery.TooManyClauses e) {
                Log.error("Too many clauses in query: " + query);
                BooleanClause[] b = result.getClauses();
                Log.error(" - Number of clauses before error: " + b.length);
                Log.error(" - Try increasing ClauseLimitSystem in Server.config.");
                throw new QueryException("Too many clauses in query \"" + query + "\"", e);
            }
            catch (ParseException e) {
                Log.warn("Error parsing query: " + query);
                Log.info(e.getMessage());
                BooleanClause[] b = result.getClauses();
                Log.error(" Number of clauses before error: " + b.length);
                throw new QueryException("Error parsing query \"" + query + "\": " + e.getMessage(), e);
            }
            catch (TokenMgrError e) {
                Log.warn("Error parsing query: " + query);
                Log.info(e.getMessage());
                throw new QueryException("Error parsing query \"" + query + "\": " + e.getMessage(), e);
            }
        }
        Iterator it = this.getRangeQueries(fieldMap).iterator();
        while (it.hasNext()) {
            org.apache.lucene.search.Query theRange = null;
            try {
                theRange = (org.apache.lucene.search.Query)it.next();
                result.add(theRange, true, false);
                anyTerms = true;
            }
            catch (BooleanQuery.TooManyClauses e) {
                Log.error("Too many clauses in query when adding range: " + theRange);
                BooleanClause[] b = result.getClauses();
                Log.error(" - Number of clauses before error: " + b.length);
                Log.error(" - Try increasing ClauseLimitSystem in Server.config.");
                throw new QueryException("Too many clauses in query when adding range \"" + theRange + "\"", e);
            }
        }
        if (!anyTerms) {
            throw new QueryException("No search expression!");
        }
        if (Log.willDebug()) {
            Log.debug("Query (Parsed):   " + result.toString(""));
            BooleanClause[] b = result.getClauses();
            Log.debug(" Number of clauses in query: " + b.length);
        }
        return result;
    }

    private Map mapFields(List fieldList) {
        HashMap<String, FieldDef> result = new HashMap<String, FieldDef>();
        Iterator it = fieldList.iterator();
        while (it.hasNext()) {
            FieldDef field = (FieldDef)it.next();
            result.put(field.name, field);
        }
        return result;
    }

    private List getReturnFields(Map fieldMap) {
        List<String> requestedFields = Arrays.asList(this.input.get("Return", Constants.USE_APP, Constants.SPLIT));
        LinkedList<String> returnFields = new LinkedList<String>(requestedFields);
        if (!returnFields.contains("Id")) {
            returnFields.add(0, "Id");
        }
        LinkedList<FieldDef> result = new LinkedList<FieldDef>();
        Iterator it = returnFields.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            FieldDef field = (FieldDef)fieldMap.get(name);
            if (field == null) {
                field = new FieldDef(name);
            }
            result.add(field);
        }
        return result;
    }

    private List getRangeQueries(Map fieldMap) {
        LinkedList<RangeQuery> result = new LinkedList<RangeQuery>();
        Iterator it = this.input.getRanges().iterator();
        while (it.hasNext()) {
            RangeDef range = (RangeDef)it.next();
            if (range.from == null && range.to == null) {
                throw new QueryException("Missing From or To value for Range field." + range.name);
            }
            FieldDef field = (FieldDef)fieldMap.get(range.name);
            boolean date = field != null && field.date;
            try {
                String from = range.from;
                if (date && from != null) {
                    from = DateField.dateToString(Application.makeDate(from));
                }
                String to = range.to;
                if (date && to != null) {
                    to = DateField.dateToString(Application.makeDate(to));
                }
                result.add(new RangeQuery(from == null ? null : new Term(range.name, from), to == null ? null : new Term(range.name, to), true));
            }
            catch (IllegalArgumentException e) {
                throw new QueryException("Error in range field \"" + range.name + "\": " + e.getMessage());
            }
        }
        return result;
    }

    private SortField[] getSortFields() {
        String[] fieldSpecs = this.input.get("Sort", Constants.USE_APP, Constants.SPLIT);
        if (fieldSpecs.length == 0) {
            return null;
        }
        SortField[] result = new SortField[fieldSpecs.length];
        int i = 0;
        while (i < result.length) {
            String[] subSpec = Util.split(fieldSpecs[i], ":");
            if (subSpec.length < 1 || subSpec.length > 2) {
                throw new QueryException("Invalid sort spec: \"" + this.input.get("Sort") + "\"");
            }
            String field = subSpec[0];
            if (field.equals("RANK")) {
                result[i] = new SortField(null, 0);
            } else {
                boolean descending = false;
                if (subSpec.length == 2) {
                    String direction = subSpec[1].toLowerCase();
                    if (direction.startsWith("d")) {
                        Log.debug("Setting sort order for field(" + field + ") to descending.");
                    }
                    descending = true;
                }
                result[i] = new SortField(field, descending);
            }
            ++i;
        }
        if (result.length == 1 && result[0].getType() == 0 && !result[0].getReverse()) {
            Log.debug("Sort term specified was default ordering.  Ignoring sort request.");
            return null;
        }
        return result;
    }

    private Transmission error(String message) {
        Transmission response = new Transmission(ECommand.QUERY_RESPONSE);
        response.setSerial(this.input.getSerial());
        response.add("Error", message);
        return response;
    }
}

