/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
/*
 * SocketTest.java
 *
 * Created on 29 October 2002, 16:03
 */

package nz.net.catalyst.lucene.testclient;

import java.io.BufferedReader;
//import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
//import java.net.UnknownHostException;

/**
 *
 * @author  hamish
 */
public class StuffDataMake {
    
    /** Creates a new instance of SocketTest */
    public StuffDataMake() {
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws java.lang.Exception {
        int id      = 10000;  //THIS THE ID TO START INCREMENTING FROM
        int numDocs =  1000;  //This is the number of documents to create.

        
        System.out.println("About to create adverts...\n");
        
        long tStart = System.currentTimeMillis();
        long tOpenedConnection = 9999L;
        long tAfterPreparing   = 9999L;
        long tAfterCreating    = 9999L;
        long tClosedConnection = 9999L;

        //open the socket for transmission.
        Socket echoSocket = null;
        PrintWriter out = null;
        BufferedReader in = null;

        tOpenedConnection = System.currentTimeMillis();
        
        java.util.Random r = new java.util.Random();
        
        String locations        = "";
        String categories       = "";

        String boolean1         = "";
        String date1 			= "";
        String date2			= "";
        
        String title			= "";
    	String body				= "";
    	
        String index            = "";
        int year = 2002;
        int month = 1;
        int day = 1;
        int previewDays = 1;
        int saleDays = 1;
        
        java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        java.util.Calendar c = new java.util.GregorianCalendar();
        
        int counter  = 0;  //LEAVE THIS AT ZERO ALWAYS
        int miniLoop = 0;
        tAfterPreparing = System.currentTimeMillis();
        
        for (counter = 0; counter < numDocs; counter++) {

            //System.out.println("Count: " + counter);
            if (miniLoop > 49) {
                System.out.println("Upto: " + counter + "\t\tId: " + id);
                miniLoop = 0;
            }
        	miniLoop++;
            
            id++;

            locations  = "";
            categories = "";
            
            for (int i = 0; i < (r.nextInt(4) + 1); i++) locations  += all_locations[r.nextInt(all_locations.length)] + " ";
            for (int i = 0; i < (r.nextInt(4) + 1); i++) categories += all_categories[r.nextInt(all_categories.length)] + " ";
            
            //manage the dates
            month = r.nextInt(11) + 1;
            day   = r.nextInt(27) + 1;
            previewDays = r.nextInt(7);
            saleDays   = r.nextInt(90) + 20;
            
            c.clear();
            c.set(year, month, day, 12, 12, 12);
            date1 = sdf.format(c.getTime());
           
            c.add(java.util.Calendar.DAY_OF_MONTH, saleDays);
            date2 = sdf.format(c.getTime());
            
            //manage cancelled or not.
            //we want around 1/5 to be cancelled only.
            if (r.nextInt(10) > 8) { 
                boolean1 = "Y";
            } else {
                boolean1 = "N";
            }
            
            //READ FROM TEXT FILE.
            // this code is really really crappy and definately inflates the index times.
        	//open txt file for text input.
        	//java.io.FileReader fr     = new java.io.FileReader("/home/lucene/bible.txt");
        	java.io.FileReader fr     = new java.io.FileReader("c:/temp/bible.txt");
        	java.io.BufferedReader br = new java.io.BufferedReader(fr);
            long offset = (long) (r.nextInt(64000) * 5);
            br.skip(offset);
            body = "";
            for (int i = 0; i < 70; i++) {
                body += br.readLine() + " ";
            }
            br.close();
            fr.close();
            br = null;
            fr = null;
            
        	//connect to luceneserver
			echoSocket = new Socket("localhost", 22222);
			//echoSocket = new Socket("192.168.4.20", 22224);
			//echoSocket = new Socket("democritus.servers.cat-it.co.nz", 22223);
			out = new PrintWriter(echoSocket.getOutputStream(), true);
			in = new BufferedReader(new InputStreamReader(
										echoSocket.getInputStream()));
        				
            index = "<LuceneIndexRequest>" +
            		"<Application>stuff</Application>" +
            		"<Id>" + id + "</Id>" +
            		"<Fields>\n" +
            			"<Field name=\"Title\">" 		+ all_names1[r.nextInt(all_names1.length)] + " " + all_names2[r.nextInt(all_names2.length)] + " " + all_names3[r.nextInt(all_names3.length)] + "</Field>" +
			        	"<Field name=\"Body\">" 		+ body + "</Field>\n" +
			        	"<Field name=\"Source\">" 		+ all_locations[r.nextInt(all_locations.length)] + "</Field>" +
			        	"<Field name=\"Sections\">" + categories + "</Field>" +
			        	"<Field name=\"Date1\">"     	+ date1 		+ "</Field>" +
			        	"<Field name=\"Date2\">"   		+ date2 		+ "</Field>" +
			        	"<Field name=\"Boolean1\">" 	+ boolean1		+ "</Field>" +
			        "</Fields>" +
			        "</LuceneIndexRequest>\n\n";

        	String index_old = "INDEX\n" +
        			"Application:stuff\n" +
        			"Id:" 			+ id + "\n" +
    				"Title:" 		+ all_names1[r.nextInt(all_names1.length)] + " " + all_names2[r.nextInt(all_names2.length)] + " " + all_names3[r.nextInt(all_names3.length)] + "\n" +
    				"Body:" 		+ body + "\n" +
    				"Source:" 		+ all_locations[r.nextInt(all_locations.length)]+ "\n" +
    				"Sections:" 	+ categories+ "\n" +
    				"Date1:"     	+ date1 + "\n" +
    				"Date2:"   		+ date2 + "\n" +
    				"Boolean1:" 	+ boolean1	+ "\n" +
        			"END\n";

            //send command to server.
            out.println(index);
            
            String serverOutput;
            try {
	            while ( ((serverOutput = in.readLine()) != null && !serverOutput.startsWith("END"))  ) {
	                //don't do anything here just wait for end of output from server.
	                //System.out.println("from server: " + serverOutput);
	            }
            } catch (java.net.SocketException e) {
            	System.out.println("Socket reset too early.  Not sure if this is an error or what.");
            }

        	//close server connection.
        	out.close();
        	in.close();
        	echoSocket.close();

        }

        tAfterCreating = System.currentTimeMillis();
        
        System.out.println("================= Time Statistics =================");
        System.out.println(" Created & Indexed " + counter + " documents.");
        System.out.println(" Preparing:          " + (tAfterPreparing - tStart));
        System.out.println(" Creating:           " + (tAfterCreating - tAfterPreparing));
    	System.out.println(" Average Time:       " + (tAfterCreating - tAfterPreparing) / numDocs);
        System.out.println("===================================================");
    }
    

    
    static private void numDocs() throws java.lang.Exception {
            org.apache.lucene.index.IndexReader r = org.apache.lucene.index.IndexReader.open( "c:\\temp\\index");
            System.out.println("Number of documents in the index: " + r.numDocs());
            r.close();
    }
        
    private static String[] all_names1   = { "Super", "New", "Mini", "Huge", "Special", "", "", "", "", "", "", "Smalled", "Best"};
	private static String[] all_names2   = { "Green", "Red", "Blue", "Black", "Clear", "Crystal", "", "", "", "", "", "", "", ""};
    private static String[] all_names3   = { "Cat", "Mouse", "House", "DVD", "Canned Tomatoes", "Flat Screen TV", "Walkman",
    										 "CD Player", "Camera", "Computer", "Readio", "Cellphone", "Wallet", "Newspaper", 
    										 "Desk", "Cup", "Table", "Saucer", "Clothes", "Wine" };

    private static String[] all_teasers = { "This product is amazing.", 
                                            "Just like mother used to make.",
                                            "Just what the doctor orderd.",
                                            "This is a once in a lifetime offer!",
                                            "Professional quality at an affordable price.",
                                            "The best thing since sliced bread.",
                                            "Needed by home handymen everywhere.",
                                            "This is essential when heading bush for the weekend.",
                                            "You just have to have this!",
                                            "Phone 0900 5UCK3R now and get a free set of ginzu 2000 steak knives.",
                                            "I cannot think of any more descriptions."};
    private static String[] all_features   = { "USB", "240v", "Red", "Fault tolerant", "Magic", "very pretty" };
    private static String[] all_locations  = { "11", "12", "13", "14", "15", "16", "17", "18", "19", "10" };
    private static String[] all_categories = { "11", "12", "13", "14", "15", "16", "17", "18", "19", "10" };
    
}
