/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
package nz.net.catalyst.lucene.server;

// Taken from Effective Java
// Ordinal-based typesafe enum - Page 106, serializable as per Page 107

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * Enumeration for option retrieve header values from Application
 *
 * @author Adrian Pronk
 * @version 1
 */

public class ESplit implements Serializable
{
  // Unique SerialVersionUID (should NEVER change)
  static final long serialVersionUID = 0L;

  private final transient String name;

  // Ordinal of next type to be created
  private static int nextOrdinal = 0;

  // Assign an ordinal to this type
  private final int ordinal = nextOrdinal++;

  public static final ESplit SPLIT    = new ESplit("Split words");
  public static final ESplit NO_SPLIT = new ESplit("Don't split words");

  // Exporting constants - Page 106
  private static final ESplit[] PRIVATE_VALUES =
      { SPLIT, NO_SPLIT };

  public static final List VALUES =
      Collections.unmodifiableList(Arrays.asList(PRIVATE_VALUES));

  private ESplit(String name)
  {
    this.name = name;
  }

  public String toString()
  {
    return "ESplit[" + name + "]" ;
  }

  private Object readResolve() throws ObjectStreamException {
      return PRIVATE_VALUES[ordinal]; // Canonicalize
  }
}
