/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
package nz.net.catalyst.lucene.server;

/**
 * Read, store and write a Transmission.  A transmission consists of a
 * Command word and an ordered list of headers.  The headers consist
 * of a keyword and value.  The header list may contain duplicate
 * keywords.  Only one keyword is treated specially by this class:
 * Content-Length.  This is used in case a body is requested.
 */

public class Control implements IPackage, Constants
{
  private final Transmission input;

  Control(Transmission transmission)
  {
    input = transmission;
  }

  Transmission execute()
  {
    Transmission response;

    String subCommand = input.get(SUB_COMMAND, NO_APP);

    if (APPLICATION_SUB_COMMAND.equalsIgnoreCase(subCommand))
      response = application();
    else if (GC_SUB_COMMAND.equalsIgnoreCase(subCommand))
      response = gc();
    else if (OPTIMIZE_SUB_COMMAND.equalsIgnoreCase(subCommand))
      response = optimize();
	else if (BACKUP_SUB_COMMAND.equalsIgnoreCase(subCommand))
	  response = backup();
	else if (subCommand.equalsIgnoreCase("EXPERIMENTAL"))
	  response = experimentalCommand();
    else
    {
      response = new Transmission(ECommand.CONTROL_RESPONSE);
      response.setSerial(input.getSerial());

      if (subCommand == null)
        response.add(ERROR, '"' + SUB_COMMAND + "\" header required.");
      else
        response.add(ERROR, "\" Unrecognised \"" + SUB_COMMAND +
                     "\" header in: " + subCommand);
    }
    return response;
  }

 /* 
  * This method has been deprecated because of security and implementation
  * issues.
  * It was found that any comments were lost when writing properties files
  * to disk and also the case was often mixed up which caused parsing 
  * problems.  
  * 
  * To re-enable the application subcommadn edit this method and remove the
  * comments.
  */
  private Transmission application()
  {
  	Transmission response = new Transmission(ECommand.CONTROL_RESPONSE);
  	response.setSerial(input.getSerial());
	response.add(ERROR, "Application sub-command no longer supported.");
  	response.add(ERROR, "Please consult the System Administrator to edit the server configuration file");
	return response;
    //ApplicationMessage application = new ApplicationMessage(input);
    //return application.execute();
  }
  private Transmission optimize()
  {
    Optimize optimize = new Optimize(input);
    return optimize.execute();
  }
  private Transmission backup()
  {
	Backup backup = new Backup(input);
	return backup.execute();
  }
  private Transmission gc()
  {
    GarbageCollect gc = new GarbageCollect(input);
    return gc.execute();
  }
  
  private Transmission experimentalCommand()
  {
	EXPERIMENTAL expCommand = new EXPERIMENTAL(input);
	return expCommand.execute();
  }
}

