/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
/*
 * SocketTest.java
 *
 * Created on 29 October 2002, 16:03
 */

package nz.net.catalyst.lucene.testclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;

/**
 *
 * @author  hamish
 */
public class SocketTestSOS {
    
    /** Creates a new instance of SocketTest */
    public SocketTestSOS() {
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws java.lang.Exception {

        //listAll();
        long tStart = System.currentTimeMillis();
        long tOpenedConnection = 9999L;
        long tAfterExecuting   = 9999L;
        long tClosedConnection = 9999L;
        
        Socket echoSocket = null;
        PrintWriter out = null;
        BufferedReader in = null;

        try {
            //echoSocket = new Socket("localhost", 22222);
            //echoSocket = new Socket("democritus.servers.catalyst.net.nz", 22223);
        	//echoSocket = new Socket("192.168.4.20", 22222); //production
            //echoSocket = new Socket("192.168.4.20", 22223); //staging/test
            echoSocket = new Socket("192.168.4.20", 22224); //development
        	//echoSocket = new Socket("192.168.4.20", 22225); //NEWSQUEST
            out = new PrintWriter(echoSocket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(
                                        echoSocket.getInputStream()));
        } catch (UnknownHostException e) {
            System.err.println("Don't know about host: localhost.");
            System.exit(1);
        } catch (IOException e) {
            System.err.println("Couldn't get I/O for "
                               + "the connection to: localhost.");
            System.exit(1);
        }

        tOpenedConnection = System.currentTimeMillis();
        
	String control = "CONTROL\n" +
                         "Sub-Command: APPLICATION\n" +
                         "Application: name\n" +
                         "Field-Name: Id\n" +
                         "Field-Type: Text\n" +
                         "Field-Indexed: Yes\n" +
                         "Field-Stored: Yes\n" +
                         "Field-Name: Name\n" +
                         "Field-Type: Text\n" +
                         "Field-Indexed: Yes\n" +
                         "Field-Stored: Yes\n" +
                         "Domain: name\n" +
                         "Sort:\n" +
                         "Query: Domain:name\n" +
                         "Return: Id Name\n" +
                         "Default-Field: Name\n" +
                         "END\n";
	String control2 = "CONTROL\n" +
                         "Sub-Command: APPLICATION\n" +
                         "Application: sos2\n" +
                         "Field-Name: Name\n" +
                         "Field-Type: Text\n" +
                         "Field-Indexed: Yes\n" +
                         "Field-Stored: Yes\n" +
                         "Field-Name: Location\n" +
                         "Field-Type: Text\n" +
                         "Field-Indexed: Yes\n" +
                         "Field-Stored: No\n" +
                         "Field-Name: Category\n" +
                         "Field-Type: Text\n" +
                         "Field-Indexed: Yes\n" +
                         "Field-Stored: No\n" +
                         "Domain: sos2\n" +
                         "Sort: Rank\n" +
                         "Return: Id Name\n" +
                         "Default-Field: Name\n" +
                         "END\n";
        String delete = "CONTROL\n" + 
                        "Sub-Command: DELETE\n" +
                        "Application: sos\n" +
                        "Id: 1\n" +
                        "END\n";
        String gc = "CONTROL\n" + 
                        "Sub-Command: GC\n" +
                        "END\n";

        String unindex = "UNINDEX\n" + 
                        "Application: sos\n" +
                        "Id: 2\n" +
                        "END\n";
        String purge = "UNINDEX\n" + 
                        "Application: sos\n" +
                        "Purge: sdfsd\n" +
                        "Id: 1\n" +
                        "END\n";
        
        String query = "QUERY\n" +
                         "Application: sos\n" +
                         "Query: Details:egypt\n" +
                         "Query: Name:mouse\n" +
                         "Return: Id Name\n" +
                         "Query: Location:10 13\n" +
                         "Range-Field: DisplayStartDate\nRange-From: 2002-01-01\nRange-To: 2002-03-01\nQuery: Cancelled:N\n" +
                         //"Sort: SaleStartDate Name RANK\n" +
                         "Limit: 5\n" +
                         "END\n";
        
        String query2 = "QUERY\nApplication:sos\nQuery: Cancelled:n\nSort: Cancelled\nLimit: 1\nEND\n";
        //String query3 = "QUERY\nApplication: sos\nLimit: 1\nSort: Cancelled\nSort-Limit: 100\nRange-Field: DisplayStartDate\nRange-From: 2002-01-01\nRange-To: 2003-03-01\nQuery: Cancelled:Y\nEND\n";
    	String query3 = "QUERY\nApplication: stuffonsale\nLimit: 10\nQuery: "+
    	
    	"(Name:(infinity*) Teaser:(infinity*) Details:(infinity*)) AND Location:23 AND NOT Cancelled:Y" +
    	"\nEND\n";
    	
        String query_count = "QUERY\n" +
                         "Query: \n" +
                         "Query: Domain:sos*\n" +
                         "Limit: 0\n" +
                         "Return: Id Name\n" +
                         "END\n";
        
        String index =  "INDEX\n" +                        "Application: sos\n" +                        "Id: 1\n" +                        "Name: USB Mouse\n" +                        "Location: 10 11 23 24 21\n" +                         "Category: aa ab ac dd\n" +                        "END";
        String index2 = "INDEX\nApplication: stuffonsale\nId: t8\nName: Broken Keyboard\nDetails: This is a keyboard. It has been broken in a fit of computer rage.\nTeaser: Lucky dip.\nLocation: 23 24 21\nCategory: aa\nDisplayStartDate:2002-10-31 12:12:00\nSaleStartDate:2002-10-31 12:12:00\nEndDate:2002-11-10 12:12:00\nCancelled:N\nEND";
        String optimize = "CONTROL\n" + "Sub-Command: OPTIMIZE\n" + "Application: sos\n" + "END\n";

        String purge_optimize = "UNINDEX\n" + 
                        "Application: sos\nPurge: true\nEND\n" +
                        "CONTROL\n" + "Sub-Command: OPTIMIZE\n" + "Application: sos\n" + "END\n";
        
        String davidi = "INDEX\nApplication: david\nId: 1\nName: Red Person\nEND";
        String davidq = "QUERY\nApplication: david\nQuery: Name:red\nLimit: 3\nEND";
        
        
        String index_01 = "INDEX\nApplication: app1\nId: c001\nName: c\nDetails: computer"       + "\nLocation: 10 14\nCategory: 10 17 13\nDisplayStartDate:2002-04-08 12:12:12\nSaleStartDate:2002-04-08 12:12:12\nEndDate:2002-08-18 12:12:12\nCancelled: N\nEND";
    	String index_02 = "INDEX\nApplication: app1\nId: c002\nName: g\nDetails: game"           + "\nLocation: 10 14\nCategory: 10 17 13\nDisplayStartDate:2002-04-08 12:12:12\nSaleStartDate:2002-04-08 12:12:12\nEndDate:2002-08-18 12:12:12\nCancelled: N\nEND";
    	String index_03 = "INDEX\nApplication: app1\nId: c003\nName: cg\nDetails: computer game" + "\nLocation: 10 14\nCategory: 10 17 13\nDisplayStartDate:2002-04-08 12:12:12\nSaleStartDate:2002-04-08 12:12:12\nEndDate:2002-08-18 12:12:12\nCancelled: N\nEND";
    	String index_04 = "INDEX\nApplication: app2\nId: c001\nName: c\nDetails: computer"       + "\nLocation: 10 14\nCategory: 10 17 13\nDisplayStartDate:2002-04-08 12:12:12\nSaleStartDate:2002-04-08 12:12:12\nEndDate:2002-08-18 12:12:12\nCancelled: N\nEND";
    	String index_05 = "INDEX\nApplication: app2\nId: c002\nName: g\nDetails: game" 			 + "\nLocation: 10 14\nCategory: 10 17 13\nDisplayStartDate:2002-04-08 12:12:12\nSaleStartDate:2002-04-08 12:12:12\nEndDate:2002-08-18 12:12:12\nCancelled: N\nEND";
    	String index_06 = "INDEX\nApplication: app2\nId: c003\nName: cg\nDetails: computer game" + "\nLocation: 10 14\nCategory: 10 17 13\nDisplayStartDate:2002-04-08 12:12:12\nSaleStartDate:2002-04-08 12:12:12\nEndDate:2002-08-18 12:12:12\nCancelled: N\nEND";


        String index_both = "INDEX\nApplication: sos\nId:nospace\nName: Wireless Keyboard\nDetails: This is a keyboard. It uses no wires!\nTeaser: Surf the net from your couch.\nFeatures: black color, wireless\nLocation: 23 24 21\nCategory: aa\nDisplayStartDate:2002-11-10 12:12:00\nSaleStartDate:2002-10-31 12:12:00\nEndDate:2002-11-31 12:12:00\nCancelled:N\nEND\nINDEX\nApplication: sos\nId:   lotsaspace\nName: Broken Keyboard\nDetails: This is a keyboard. It has been broken in a fit of computer rage.\nTeaser: Lucky dip.\nFeatures: lots of keys\nLocation: 23 24 21\nCategory: aa\nDisplayStartDate:2002-10-31 12:12:00\nSaleStartDate:2002-10-31 12:12:00\nEndDate:2002-11-31 12:12:00\nCancelled:N\nEND";

        String command = //"QUERY\nQuery: Domian:nonexistant\nEND\n";
    					  query3;
                         
                        //"QUERY\nApplication: sos\nQuery: Details:god Details:game \nLimit:5\nReturn: \nEND\n";
                //"QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 1900/01/01\nRange-To: 1037234637\nRange-Field: EndDate\nRange-From: 1037234637\nRange-To: 2100/12/31\nReturn: Id Name\n" +                "Query: (Name:(goo*^2 OR plan*^2) Teaser:(goo* OR plan*) Details:(goo* OR plan*)) AND NOT (Cancel:Y)\nLimit: 5\nEND";
        
        System.out.println("About to send command to server...\n");
	//send command to server.
        out.println(command);
                
        String serverOutput;

        
        java.io.BufferedReader br = new java.io.BufferedReader(in);
        
        //while ( (serverOutput = br.readLine()) != null ) {
        while ( ((serverOutput = br.readLine()) != null && !serverOutput.startsWith("END"))  ) {            
            System.out.println("from server: " + serverOutput);
        }
        
        tAfterExecuting = System.currentTimeMillis();
        
	out.close();
        br.close();
	in.close();
        
	echoSocket.close();
        
        tClosedConnection = System.currentTimeMillis();
        
        System.out.println("program has completed successfully");
        
        System.out.println("================= Time Statistics =================");
        System.out.println(" Opening Connection: " + (tOpenedConnection - tStart));
        System.out.println(" Executing:          " + (tAfterExecuting - tOpenedConnection));
        System.out.println(" Closing Connection: " + (tClosedConnection - tAfterExecuting));
        System.out.println("===================================================");
        
    }
    

    
    static private void listAll() throws java.lang.Exception {
        //try {
            System.out.println("============= beginning of listing ============");
            org.apache.lucene.index.IndexReader r = org.apache.lucene.index.IndexReader.open( "c:\\temp\\index");

            int num = r.numDocs();
            System.out.println("numDocs: " + num);
            for ( int i = 0; i < num; i++)
            {
                    if ( ! r.isDeleted( i))
                    {
                            org.apache.lucene.document.Document d = r.document( i);
                            System.out.println( "d=" +d);
                    }
            }
            r.close();
            System.out.println("============= end of listing ============");
        //}
        //catch (java.lang.Exception e) {
            //do nothing
        //    System.out.println(" listing currently unavailable.");
        //}
    }
    
    
   
    
    
}
