# Arch Perl library, Copyright (C) 2005 Mikhael Goikhman
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.005;
use strict;

package AXP::Command::triggers::edit;
use base 'AXP::Command::triggers';

use Arch::Util qw(load_file save_file);

sub optusage {
	"[options] limit"
}

sub infoline {
	"change the command to be executed for new revisions"
}

sub options {
	(
		var     => { sh => 'v', desc => 'set user vars: -v LABEL=prj1 -v EMAIL=me@me.org', type => "=s%", arg => 'VAR=VALUE' },
		no_edit => { sh => 'n', desc => "do not actually invoke editor to edit action" },
	)
}

sub helptext {
	q{
		This command may be used to change the trigger data, i.e. action
		commands, and user variables to be defined for this action.

		User shell variables is a completely optional mechanism that
		enables to customize the same action (send email, write log)
		for different watched limits; see also 'add --master'.

		The parameter is either arch limit or number, as displayed by
		'list' subcommand.
	}
}

sub execute {
	my $self = shift;
	my %opt = %{$self->{options}};

	my $name = shift @ARGV;
	my $trigger = $self->load_trigger($name);

	$self->apply_vars($trigger, $opt{var});
	$self->edit_trigger($trigger) unless $opt{no_edit};
	$self->save_trigger($trigger);

	print "* trigger for $trigger->{name} is updated\n";
}

1;
