--------------------------------------------------------------------------------
--
-- sm_famr0.as: A general category for distributed polynomials.
--
--------------------------------------------------------------------------------
--  Copyright (c) 1990-2007 Aldor Software Organization Ltd (Aldor.org).
-- Copyright: INRIA, UWO and University of Lille I, 2001
-- Copyright: Marc Moreno Maza
--------------------------------------------------------------------------------

-- cat FiniteAbelianMonoidRing0

#include "algebra"

+++ `FiniteAbelianMonoidRing0(R,V,E)' is a model for (distributed) polynomials. 
+++ Such polynomials' are looked as sums of terms `c_i m_i' where the `r_i' 
+++ are coefficients from `R' and the `m_i' are monomials from the free abelian 
+++ monoid generated by `V'. Moreover these monomials are coded by exponents
+++ from `E'. These exponents commute with each other, and with the coefficients,
+++ which themselves may or may not commute. 
+++ Author: Marc Moreno Maza
+++ Date Createds: 09/12/97
+++ Date Last Update: 12/07/01

define FiniteAbelianMonoidRing0(R: Join(ArithmeticType, ExpressionType),
  V: VariableType, E: ExponentCategory(V)): Category == 
     Join(PolynomialRing0(R,V), IndexedFreeAlgebra(R,E)) with { 
        -------------------------------------------------------------
        --% SHOULD BE DECLARED in IndexedFreeLinearArithmeticType %--
        -------------------------------------------------------------
        add!: (R, %, R, E, %) -> %;
          ++ `add!(c1,x,c2,e,y)' returns `c1*x+term(c2,e)*y' and may
          ++ modify `x' to compute this result..
        map: (E -> E) ->  % -> %;
          ++ `map(f)(p)' maps function `f' onto the exponents
          ++ of the non-zero terms of `p'.
        map!: (E -> E) -> % -> %;
          ++ `map(f)(p)' maps function `f' onto the exponents
          ++ of the non-zero terms of `p' and may moddify 
          ++ the value of `p'.
        default {
           add!(c1: R, x: %, c2: R, e: E, y: %): % == {
              c1*x+term(c2,e)*y;
           }
           setCoefficient!(p: %, e: E, r: R): % == {
              c: R := coefficient(p, e);
              r = c => p;
              zero? c => add!(p, r, e);
              zero? r => minus!(p, term(c, e));
              add!(p,r-c,e);
           }
           map(f:E -> E)(p:%):% == {
              q: % := 0;
              for cross in terms(p) repeat {
                  (r: R, e: E) := cross;
                  q := add!(q,r,f(e));
              }
              q;
           }
           map!(f:E -> E)(p:%):% == map(f) p;
           
         }
}


#if ALDOC
\thistype{FiniteAbelianMonoidRing0}
\History{Marc Moreno Maza}{08/07/01}{created}
\Usage{\this~(R,V,E): Category}
\Params{
{\em R} &  \altype{ArithmeticType}  & The coefficient domain \\
        & \altype{ExpressionType} & \\
{\em V} & \altype{VariableType} & The variable type \\ 
{\em E} & \altype{ExponentCategory} V & The exponent domain \\
}
\Descr{\this~(R,V,E) is 
a model for {\em distributed} polynomials. 
 Such polynomials are looked as sums of terms $c_i m_i$ where the $r_i$ 
 are coefficients from $R$ and the $m_i$ are monomials from the free abelian 
 monoid generated by $V.$ Moreover these monomials are coded by means of exponents
 from $E.$ These exponents commute with each other  and with the coefficients.
 However the coefficients may or may not commute. 
}
\begin{exports}
\category{\altype{IndexedFreeAlgebra}(R,E)} \\
\category{\altype{PolynomialRing0}(R,V)} \\
\alexp{add!}: &  (R, \%, R, E, \%) $\to$ \%
              &  \alexp{add!}$(c_1,x,c_2,e,y)$ is $c_1 x+$\alexp{term}$(c_2,e) y$ and may modify $x$ \\
\alexp{map}: &   (E $\to$ E) $\to$  \% $\to$ \%
         &  \alexp{map}$(f)(x)$ maps $f$ on the exponents of $x$ \\
\alexp{map!}: &   (E $\to$ E) $\to$  \% $\to$ \%
          & \alexp{map}$(f)(x)$ returns  \alexp{map}$(f)(x)$ and may modify $x$ \\
\end{exports}
#endif



