--------------------------------------------------------------------------------
--
-- sm_mievc.as: A basic category for multivariate polynomial exponents 
--              when the set of variables is finite.
--
--------------------------------------------------------------------------------
--  Copyright (c) 1990-2007 Aldor Software Organization Ltd (Aldor.org).
-- Copyright: INRIA, and UWO, University of Lille I, 2001
-- Copyright: Marc Moreno Maza
--------------------------------------------------------------------------------

-- cat MachineIntegerExponentVectorCategory

#include "algebra"

macro { 
      MI == MachineInteger;
}

+++ `MachineIntegerExponentVectorCategory(V)' is a category for the 
+++  exponents of the monomials (or power products) generated by the 
+++  finite set of variables `V' and coded as direct products of
+++  positive machine integers.
+++ Author: Marc Moreno Maza
+++ Date Created: 09/07/01
+++ Date Last Update: 12/07/01

define MachineIntegerExponentVectorCategory(V: FiniteVariableType): Category == 
     Join(ExponentCategory(V), CopyableType, HashType) with {
         free!: % -> ();
           ++ `free!(x)'
         exponent: Tuple MI -> %;
           ++ `exponent(t)' assumes that `t' has length `n'
           ++ where `n' is `#$V' and returns the exponent 
           ++ vector `e' such that `element(t,i)' is
           ++ `degree(e,variable(i)$V)' for `i' in `1..n'.
         exponent: PrimitiveArray MI -> %;
           ++ `exponent(p)' assumes that `p' has length `n+1'
           ++ where `n' is `#$V' and that `p.0' is the sum of 
           ++ the `p.i' for `i in `1..n'. Then returns 
           ++ the exponent vector `e' such that `p.i' is
           ++ `degree(e,variable(i)$V)' for `i' in `1..n'.
         parray: % -> PrimitiveArray MI;
           ++ `parray(e)' returns `p' such that 
           ++ `exponent(p)' returns `e'.
}

#if ALDOC
\thistype{MachineIntegerExponentVectorCategory}
\History{Marc Moreno Maza}{08/07/01}{created}
\Usage{\this~V: Category}
\Params{
{\em V} & \astype{FiniteVariableType} & The type of variables \\
}
\Descr{\this~V is a category for the 
  exponents of the monomials (or power products) generated by the 
  finite set of variables $V$ and coded as direct products of
  non-negative machine integers.}
\begin{exports}
\category{\astype{CopyableType}} \\
\category{\astype{ExponentCategory} V } \\
\category{\astype{HashType}} \\
\alexp{free!}: & \% $\to$ ()   &  Asserts that the input will no longer be used \\
\alexp{exponent}: & \astype{Tuple} I  $\to$ \%  &  Creation from a tuple \\
\alexp{exponent}: & \astype{PrimitiveArray} I  $\to$ \% &  Creation from a primitive array \\
                  &      & Degrees start at slot 1 \\
                  &      & Slot $0$ must be the total degree \\
\alexp{parray}: & \%  $\to$  \astype{PrimitiveArray} I  & Inverse mapping of \alexp{exponent} \\
\end{exports}
\begin{aswhere}
I &==& \altype{MachineInteger}\\
\end{aswhere}
#endif

