#!/bin/sh
###############################################################################
# This file is a convertor of libraries from a to lib
# Requires: 
#  1. ar (Cygwin/MingW) 
#  2. lib from Visual C++
###############################################################################

usage() 
{
	name=`basename $0`;
	echo "Converts libraries from gcc format to Visual Studio";
	echo "Usage: $name <a library>";
};

if [ $# -ne 1 ]; then
	usage;
	exit 1;
fi

files=`ar t $1`

for i in $files; do
	j="$i"bj;
	echo "copy $i into $j";
	ar x $1 $i;
	mv $i $j;
	if [ ! -f `basename $1.lib` ]; then
		lib /nologo /out:`basename $1`.lib $j;
	else
		lib /nologo `basename $1`.lib $j;
	fi
	rm $j
done

