--------------------------------------------------------------------------------
--
-- sm_zevc.as: A basic category for multivariate polynomial exponents 
--              when the set of variables is finite.
--
--------------------------------------------------------------------------------
--  Copyright (c) 1990-2007 Aldor Software Organization Ltd (Aldor.org).
-- Copyright: INRIA, UWO, and University of Lille I, 2001
-- Copyright: Marc Moreno Maza
--------------------------------------------------------------------------------

-- cat IntegerExponentVectorCategory

#include "algebra"

macro { 
      Z == Integer;
      MI == MachineInteger;
}

+++ `IntegerExponentVectorCategory(V)' is a category for the 
+++  exponents of the monomials (or power products) generated by the 
+++  finite set of variables `V' and coded as direct products of
+++  positive integers.
+++ Author: Marc Moreno Maza
+++ Date Created: 09/07/01
+++ Date Last Update: 10/07/01

define IntegerExponentVectorCategory(V: FiniteVariableType): Category == 
(    Join(ExponentCategory(V), DirectProductCategory(dim, Z)) with {
         exponent: PrimitiveArray Z -> %;
           ++ `exponent(p)' assumes that `p' has length `dim'
           ++ and that `p.0' is the sum of the `p.i' for
           ++ `i in `1..(dim-1)'. Then returns 
           ++ the exponent vector `e' such that `p.i' is
           ++ `degree(e,variable(i)$V)' for `i' in `1..(dim-1)'.
         parray: % -> PrimitiveArray Z;
           ++ `parray(e)' returns `p' such that 
           ++ `exponent(p)' returns `e'.
}   where {
      import from V;
      dim: MI == next(#$V);
})

#if ALDOC
\thistype{IntegerExponentVectorCategory}
\History{Marc Moreno Maza}{08/07/01}{created}
\Usage{\this~V: Category}
\Params{
{\em V} & \astype{FiniteVariableType} & The type of variables \\
}
\Descr{\this~V is a category for the 
  exponents of the monomials (or power products) generated by the 
  finite set of variables $V$ and coded as direct products of
  non-negative integers.}
\begin{exports}
\category{\astype{CopyableType}} \\
\category{\astype{ExponentCategory} V } \\
\category{\astype{HashType}} \\
\alexp{free!}: & \% $\to$ ()   &  Asserts that the input will no longer be used \\
\alexp{exponent}: & \astype{Tuple} \astype{Integer}  $\to$ \%  &  Creation from a tuple \\
\alexp{exponent}: & \astype{PrimitiveArray} \astype{Integer}  $\to$ \% &  Creation from a primitive array \\
                  &      & Degrees start at slot 1 \\
                  &      & Slot $0$ must be the total degree \\
\alexp{parray}: & \%  $\to$  \astype{PrimitiveArray} \astype{Integer}  & Inverse mapping of \alexp{exponent} \\
\end{exports}
#endif

