#!/bin/bsh
#
# ASHARP BUG FILE FORWARDING
# ==========================
#
# ** Bug files are accepted by mail at the account
#       asbugs@watson.ibm.com
#    This account needs to have up-to-date "extnet" privledges to
#    receive bugs from non-IBM sites.
#
# ** These messages are forwarded to the local account
#       asbugs@asharp.watson.ibm.com
#    This is set up using the command "xforward" on a Yorktown mainframe.
#
# ** The messages are forwarded to the bug file directory 
#       /asharp/bugs
#    by placing the following line in asharp:/u/asbugs/.forward
# 	|/asharp/server/bugs/forwbug
#
# ** This causes the forwarded mail to be piped through this program,
#    which forwards the bug report to ax-bugs@nag.co.uk, notifies the fixers,
#    and replies to the sender.
#
# ** The true source of this program, forwbug.{c,sh}, is in the directory
#      /asharp/version/current/tools/unix.
#    The makefile in that directory should 
#    1. Copy    forwbug.sh to asharp:$BugDir/forwbug.sh
#    2. Compile forwbug.c  to asharp:$BugDir/forwbug
#	with setuid asbugs and setgid asharp.
#
# ** SSD August 95.  [derived from recvbug.sh]


InfoAddr="infodesk@nag.co.uk"
BugsAddr="ax-bugs@nag.co.uk"

BugDir=/asharp/bugs

Maintainers="`cat $BugDir/Maintainers`"
Fixers="`cat $BugDir/Fixers`"

cd $BugDir

#
# Utilities
#
GetMessageSender() {
	# Arg 1 is the "From" pattern.
	# Arg 2 is the message file name.
	
	egrep -e "$1" "$2" | sed -e "s/$1//" | head -1 | awk '
	!/<.*>/	{ print $1 }
	/<.*>/	{
		  name = substr($0, index($0, "<")+1)
		  name = substr(name, 1, index(name, ">")-1)
		  print name
		}
'
}

GetMessageSubject() {
	# Arg 1 is the "Subject" pattern.
	# Arg 2 is the message file name.
	
	egrep -e "$1" "$2" | sed -e "s/$1//" | head -1 
}

GetMessageFilename() {
	# Arg 1 is the "Subject" pattern.
	# Arg 2 is the message file name.

	egrep -e "$1" "$2" | sed -e "s/.*name: \(.*\.as\).*/\1/"
}

#
# Step 1.  Capture message.  If it is from a daemon or is a reply, ignore it.
#
cat > /tmp/asbug.$$

Sender=`GetMessageSender "^From:" /tmp/asbug.$$`
Subject=`GetMessageSubject "^Subject: " /tmp/asbug.$$`
Filename=`GetMessageFilename "^-- Original bug file name: .*\.as" /tmp/asbug.$$`

for who in daemon forward postmaster
do
	if egrep -i "^From:.*$who.*" /tmp/asbug.$$
	then
		mail -s "Ignored daemon" $Maintainers < /tmp/asbug.$$
		exit 0
	fi
done

for what in "Received A# bug" "Forwarded A# bug" "A# fix notification" "Received AXIOM-XL bug" "AXIOM-XL fix notification"
do
	if egrep -i "^Subject:.*$what.*" /tmp/asbug.$$
	then
		mail -s "Sorry, this address cannot handle replies." \
			$Sender $Maintainers < /tmp/asbug.$$
		exit 0
	fi
done

if [ X"$Filename" = X"" ]
then
	Filename="unknown.as"
fi


#
# Step 2.  Save message with mail header as comments.
#
awk < /tmp/asbug.$$ '
BEGIN				{ seenblank = 0 }
seenblank == 1			{ print $0 }
(seenblank == 0) && !/^$/	{ print "--* " $0 }
(seenblank == 0) && /^$/	{
	print ""
	seenblank = 1
}
' > $Filename.$$


#
# Step 3a.  Construct forwarded message.
#
cat > /tmp/asforw.$$ << EOF

  Reporter:    $Sender
  Description: $Subject

------------------------------ $Filename ---------------------------------
EOF
cat $Filename.$$ >> /tmp/asforw.$$

#
# Step 3b.  Construct confirmation message.
#
cat > /tmp/asinfo.$$ <<EOF

  Reporter:    $Sender
  Description: $Subject

Thank you for your bug report.  It has been forwarded to $BugsAddr.
You should receive a separate confirmation message from the mail server there.

Please send future bug reports directly to $BugsAddr using axlbug.
If you wish to discuss this bug via E-mail, please contact $InfoAddr.

------------------------------ $Filename ---------------------------------
EOF
cat $Filename.$$ >> /tmp/asinfo.$$


#
# Step 4.  Forward the bug.
#
mail -s forwbug $BugsAddr < /tmp/asforw.$$


#
# Step 5.  Notify the sender and bug fixers that a bug has been forwarded.
#
mail -s "Forwarded A# bug" $Fixers "$Sender" < /tmp/asinfo.$$


#
# Step 6. Clean up
#
rm /tmp/asbug.$$
rm /tmp/asforw.$$
rm /tmp/asinfo.$$
rm $Filename.$$
