/* related-applet.c generated by valac 0.9.7, the Vala compiler
 * generated from related-applet.vala, do not modify */

/*
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Author : Michal Hruby <michal.mhr@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus.h>
#include <libawn/libawn.h>
#include <libwnck/libwnck.h>
#include <awn-desktop-lookup-cached.h>
#include <zeitgeist.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <pango/pango.h>
#include <gio/gdesktopappinfo.h>
#include <gdk/gdk.h>


#define TYPE_WNCK_SYNC_MATCHER (wnck_sync_matcher_get_type ())
#define WNCK_SYNC_MATCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WNCK_SYNC_MATCHER, WnckSyncMatcher))
#define IS_WNCK_SYNC_MATCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WNCK_SYNC_MATCHER))
#define WNCK_SYNC_MATCHER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_WNCK_SYNC_MATCHER, WnckSyncMatcherIface))

typedef struct _WnckSyncMatcher WnckSyncMatcher;
typedef struct _WnckSyncMatcherIface WnckSyncMatcherIface;
typedef struct _DBusObjectVTable _DBusObjectVTable;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _WnckSyncMatcherDBusProxy WnckSyncMatcherDBusProxy;
typedef DBusGProxyClass WnckSyncMatcherDBusProxyClass;

#define TYPE_DESKTOP_FILE_INFO (desktop_file_info_get_type ())
typedef struct _DesktopFileInfo DesktopFileInfo;

#define TYPE_RELATED_APPLET (related_applet_get_type ())
#define RELATED_APPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RELATED_APPLET, RelatedApplet))
#define RELATED_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RELATED_APPLET, RelatedAppletClass))
#define IS_RELATED_APPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RELATED_APPLET))
#define IS_RELATED_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RELATED_APPLET))
#define RELATED_APPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RELATED_APPLET, RelatedAppletClass))

typedef struct _RelatedApplet RelatedApplet;
typedef struct _RelatedAppletClass RelatedAppletClass;
typedef struct _RelatedAppletPrivate RelatedAppletPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
#define _g_ptr_array_free0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_free (var, TRUE), NULL)))
#define _g_array_free0(var) ((var == NULL) ? NULL : (var = (g_array_free (var, TRUE), NULL)))
typedef struct _RelatedAppletUpdateStarData RelatedAppletUpdateStarData;
typedef struct _RelatedAppletGetRecentByMimetypeData RelatedAppletGetRecentByMimetypeData;
typedef struct _RelatedAppletGetEventsForActorData RelatedAppletGetEventsForActorData;
typedef struct _RelatedAppletBuildDialogData RelatedAppletBuildDialogData;
#define __g_list_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_free (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _WnckSyncMatcherIface {
	GTypeInterface parent_iface;
	char* (*desktop_file_for_xid) (WnckSyncMatcher* self, guint32 xid, GError** error);
	gboolean (*window_match_is_ready) (WnckSyncMatcher* self, guint32 xid, GError** error);
	void (*register_desktop_file_for_pid) (WnckSyncMatcher* self, const char* filename, gint32 pid, GError** error);
	guint32* (*xids_for_desktop_file) (WnckSyncMatcher* self, const char* filename, int* result_length1, GError** error);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _WnckSyncMatcherDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _DesktopFileInfo {
	char* name;
	char** mimetypes;
	gint mimetypes_length1;
	gint _mimetypes_size_;
};

struct _RelatedApplet {
	AwnAppletSimple parent_instance;
	RelatedAppletPrivate * priv;
};

struct _RelatedAppletClass {
	AwnAppletSimpleClass parent_class;
};

struct _RelatedAppletPrivate {
	WnckScreen* wnck_screen;
	AwnDesktopLookupCached* lookup;
	ZeitgeistLog* zg_log;
	AwnOverlay* throbber;
	AwnOverlay* star_overlay;
	GHashTable* desktop_file_info;
	AwnDialog* dialog;
	GtkVBox* vbox;
	char* current_desktop_file_path;
};

struct _RelatedAppletUpdateStarData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RelatedApplet* self;
	char* desktop_file;
	GPtrArray* ptr_array;
	const char* actor;
	ZeitgeistEvent* event;
	GList* helper_event_list;
	char* _tmp0_;
	DesktopFileInfo* df_data;
	gboolean _tmp1_;
	ZeitgeistEvent* mime_event;
	ZeitgeistSubject* subject;
	char** mimetype_collection;
	int mimetype_collection_length1;
	int mimetype_it;
	const char* mimetype;
	GArray* events;
	ZeitgeistTimeRange* _tmp2_;
	GPtrArray* _tmp3_;
	GArray* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	GError * _inner_error_;
};

struct _RelatedAppletGetRecentByMimetypeData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RelatedApplet* self;
	char** mimetypes;
	gint mimetypes_length1;
	gboolean result;
	GList* helper_event_list;
	GPtrArray* ptr_array;
	ZeitgeistEvent* event;
	ZeitgeistSubject* subject;
	char** mimetype_collection;
	int mimetype_collection_length1;
	int mimetype_it;
	const char* mimetype;
	ZeitgeistResultSet* events;
	ZeitgeistTimeRange* _tmp0_;
	GPtrArray* _tmp1_;
	ZeitgeistResultSet* _tmp2_;
	gint results_pushed;
	ZeitgeistResultSet* _e_it;
	ZeitgeistEvent* e;
	ZeitgeistSubject* s;
	gboolean _tmp3_;
	GError * _inner_error_;
};

struct _RelatedAppletGetEventsForActorData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RelatedApplet* self;
	char* actor;
	gboolean result;
	GPtrArray* ptr_array;
	ZeitgeistEvent* event;
	char* _tmp0_;
	ZeitgeistResultSet* events;
	ZeitgeistTimeRange* _tmp1_;
	GPtrArray* _tmp2_;
	ZeitgeistResultSet* _tmp3_;
	gint results_pushed;
	ZeitgeistResultSet* _e_it;
	ZeitgeistEvent* e;
	ZeitgeistSubject* s;
	gboolean _tmp4_;
	GError * _inner_error_;
};

struct _RelatedAppletBuildDialogData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RelatedApplet* self;
	char* desktop_file;
	GtkVBox* _tmp0_;
	gboolean found1;
	gboolean found2;
	char* _tmp1_;
	DesktopFileInfo* df_data;
	gboolean _tmp2_;
	char** _tmp3_;
	char** _tmp4_;
	gint _tmp4__length1;
	GtkHSeparator* _tmp5_;
	const char* actor;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	GtkLabel* l;
};

struct _Block1Data {
	int _ref_count_;
	RelatedApplet * self;
	GFile* f;
	char* desktop_file;
};


static gpointer related_applet_parent_class = NULL;

WnckSyncMatcher* wnck_sync_matcher_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType wnck_sync_matcher_get_type (void) G_GNUC_CONST;
char* wnck_sync_matcher_desktop_file_for_xid (WnckSyncMatcher* self, guint32 xid, GError** error);
gboolean wnck_sync_matcher_window_match_is_ready (WnckSyncMatcher* self, guint32 xid, GError** error);
void wnck_sync_matcher_register_desktop_file_for_pid (WnckSyncMatcher* self, const char* filename, gint32 pid, GError** error);
guint32* wnck_sync_matcher_xids_for_desktop_file (WnckSyncMatcher* self, const char* filename, int* result_length1, GError** error);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void wnck_sync_matcher_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _wnck_sync_matcher_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult wnck_sync_matcher_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_wnck_sync_matcher_introspect (WnckSyncMatcher* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_wnck_sync_matcher_property_get_all (WnckSyncMatcher* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_wnck_sync_matcher_desktop_file_for_xid (WnckSyncMatcher* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_wnck_sync_matcher_window_match_is_ready (WnckSyncMatcher* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_wnck_sync_matcher_register_desktop_file_for_pid (WnckSyncMatcher* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_wnck_sync_matcher_xids_for_desktop_file (WnckSyncMatcher* self, DBusConnection* connection, DBusMessage* message);
GType wnck_sync_matcher_dbus_proxy_get_type (void) G_GNUC_CONST;
DBusHandlerResult wnck_sync_matcher_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	WNCK_SYNC_MATCHER_DBUS_PROXY_DUMMY_PROPERTY
};
static char* wnck_sync_matcher_dbus_proxy_desktop_file_for_xid (WnckSyncMatcher* self, guint32 xid, GError** error);
static gboolean wnck_sync_matcher_dbus_proxy_window_match_is_ready (WnckSyncMatcher* self, guint32 xid, GError** error);
static void wnck_sync_matcher_dbus_proxy_register_desktop_file_for_pid (WnckSyncMatcher* self, const char* filename, gint32 pid, GError** error);
static guint32* wnck_sync_matcher_dbus_proxy_xids_for_desktop_file (WnckSyncMatcher* self, const char* filename, int* result_length1, GError** error);
static void wnck_sync_matcher_dbus_proxy_wnck_sync_matcher__interface_init (WnckSyncMatcherIface* iface);
static void wnck_sync_matcher_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void wnck_sync_matcher_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType desktop_file_info_get_type (void) G_GNUC_CONST;
DesktopFileInfo* desktop_file_info_dup (const DesktopFileInfo* self);
void desktop_file_info_free (DesktopFileInfo* self);
void desktop_file_info_copy (const DesktopFileInfo* self, DesktopFileInfo* dest);
void desktop_file_info_destroy (DesktopFileInfo* self);
static char** _vala_array_dup1 (char** self, int length);
GType related_applet_get_type (void) G_GNUC_CONST;
#define RELATED_APPLET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_RELATED_APPLET, RelatedAppletPrivate))
enum  {
	RELATED_APPLET_DUMMY_PROPERTY
};
RelatedApplet* related_applet_new (const char* canonical_name, const char* uid, gint panel_id);
RelatedApplet* related_applet_construct (GType object_type, const char* canonical_name, const char* uid, gint panel_id);
static void related_applet_window_opened (RelatedApplet* self, WnckWindow* window);
static void _related_applet_window_opened_wnck_screen_window_opened (WnckScreen* _sender, WnckWindow* window, gpointer self);
static void related_applet_window_changed (RelatedApplet* self, WnckWindow* old_window);
static void _related_applet_window_changed_wnck_screen_active_window_changed (WnckScreen* _sender, WnckWindow* previous_window, gpointer self);
static void related_applet_on_clicked (RelatedApplet* self);
static void _related_applet_on_clicked_awn_applet_simple_clicked (AwnAppletSimple* _sender, gpointer self);
static void related_applet_update_star (RelatedApplet* self, const char* desktop_file, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void related_applet_update_star_finish (RelatedApplet* self, GAsyncResult* _res_);
static void related_applet_update_star_data_free (gpointer _data);
static void related_applet_update_star_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean related_applet_update_star_co (RelatedAppletUpdateStarData* data);
static void _g_list_free_g_object_unref (GList* self);
static void related_applet_get_recent_by_mimetype_data_free (gpointer _data);
static char** _vala_array_dup2 (char** self, int length);
static void related_applet_get_recent_by_mimetype_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void related_applet_get_recent_by_mimetype (RelatedApplet* self, char** mimetypes, int mimetypes_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean related_applet_get_recent_by_mimetype_finish (RelatedApplet* self, GAsyncResult* _res_);
static gboolean related_applet_get_recent_by_mimetype_co (RelatedAppletGetRecentByMimetypeData* data);
static gboolean related_applet_push_result (RelatedApplet* self, ZeitgeistEvent* event, ZeitgeistSubject* subject);
static void related_applet_get_events_for_actor_data_free (gpointer _data);
static void related_applet_get_events_for_actor_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void related_applet_get_events_for_actor (RelatedApplet* self, const char* actor, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean related_applet_get_events_for_actor_finish (RelatedApplet* self, GAsyncResult* _res_);
static gboolean related_applet_get_events_for_actor_co (RelatedAppletGetEventsForActorData* data);
static void related_applet_build_dialog_data_free (gpointer _data);
static void related_applet_build_dialog_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void related_applet_build_dialog (RelatedApplet* self, const char* desktop_file, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void related_applet_build_dialog_finish (RelatedApplet* self, GAsyncResult* _res_);
static gboolean related_applet_build_dialog_co (RelatedAppletBuildDialogData* data);
static void _lambda0_ (Block1Data* _data1_);
static void _g_list_free_g_free (GList* self);
static void __lambda0__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static GObject * related_applet_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void related_applet_finalize (GObject* obj);
AwnApplet* awn_applet_factory_initp (const char* canonical_name, const char* uid, gint panel_id);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const DBusObjectPathVTable _wnck_sync_matcher_dbus_path_vtable = {_wnck_sync_matcher_dbus_unregister, wnck_sync_matcher_dbus_message};
static const _DBusObjectVTable _wnck_sync_matcher_dbus_vtable = {wnck_sync_matcher_dbus_register_object};


char* wnck_sync_matcher_desktop_file_for_xid (WnckSyncMatcher* self, guint32 xid, GError** error) {
	return WNCK_SYNC_MATCHER_GET_INTERFACE (self)->desktop_file_for_xid (self, xid, error);
}


gboolean wnck_sync_matcher_window_match_is_ready (WnckSyncMatcher* self, guint32 xid, GError** error) {
	return WNCK_SYNC_MATCHER_GET_INTERFACE (self)->window_match_is_ready (self, xid, error);
}


void wnck_sync_matcher_register_desktop_file_for_pid (WnckSyncMatcher* self, const char* filename, gint32 pid, GError** error) {
	WNCK_SYNC_MATCHER_GET_INTERFACE (self)->register_desktop_file_for_pid (self, filename, pid, error);
}


guint32* wnck_sync_matcher_xids_for_desktop_file (WnckSyncMatcher* self, const char* filename, int* result_length1, GError** error) {
	return WNCK_SYNC_MATCHER_GET_INTERFACE (self)->xids_for_desktop_file (self, filename, result_length1, error);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _wnck_sync_matcher_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_wnck_sync_matcher_introspect (WnckSyncMatcher* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.wncksync.Matcher\">\n  <method name=\"DesktopFileForXid\">\n    <arg name=\"xid\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"WindowMatchIsReady\">\n    <arg name=\"xid\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"RegisterDesktopFileForPid\">\n    <arg name=\"filename\" type=\"s\" direction=\"in\"/>\n    <arg name=\"pid\" type=\"i\" direction=\"in\"/>\n  </method>\n  <method name=\"XidsForDesktopFile\">\n    <arg name=\"filename\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_wnck_sync_matcher_property_get_all (WnckSyncMatcher* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.wncksync.Matcher") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_wnck_sync_matcher_desktop_file_for_xid (WnckSyncMatcher* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 xid = 0U;
	dbus_uint32_t _tmp1_;
	char* result;
	DBusMessage* reply;
	const char* _tmp2_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	xid = _tmp1_;
	result = wnck_sync_matcher_desktop_file_for_xid (self, xid, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp2_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp2_);
	_g_free0 (result);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_wnck_sync_matcher_window_match_is_ready (WnckSyncMatcher* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 xid = 0U;
	dbus_uint32_t _tmp3_;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp4_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp3_);
	dbus_message_iter_next (&iter);
	xid = _tmp3_;
	result = wnck_sync_matcher_window_match_is_ready (self, xid, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp4_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp4_);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_wnck_sync_matcher_register_desktop_file_for_pid (WnckSyncMatcher* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* filename = NULL;
	const char* _tmp5_;
	gint32 pid = 0;
	dbus_int32_t _tmp6_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "si")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp5_);
	dbus_message_iter_next (&iter);
	filename = g_strdup (_tmp5_);
	dbus_message_iter_get_basic (&iter, &_tmp6_);
	dbus_message_iter_next (&iter);
	pid = _tmp6_;
	wnck_sync_matcher_register_desktop_file_for_pid (self, filename, pid, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (filename);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_wnck_sync_matcher_xids_for_desktop_file (WnckSyncMatcher* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* filename = NULL;
	const char* _tmp7_;
	guint32* result;
	int result_length1;
	DBusMessage* reply;
	guint32* _tmp8_;
	DBusMessageIter _tmp9_;
	int _tmp10_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp7_);
	dbus_message_iter_next (&iter);
	filename = g_strdup (_tmp7_);
	result_length1 = 0;
	result = wnck_sync_matcher_xids_for_desktop_file (self, filename, &result_length1, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (filename);
	_tmp8_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp9_);
	for (_tmp10_ = 0; _tmp10_ < result_length1; _tmp10_++) {
		dbus_uint32_t _tmp11_;
		_tmp11_ = *_tmp8_;
		dbus_message_iter_append_basic (&_tmp9_, DBUS_TYPE_UINT32, &_tmp11_);
		_tmp8_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp9_);
	result = (g_free (result), NULL);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult wnck_sync_matcher_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_wnck_sync_matcher_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_wnck_sync_matcher_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.wncksync.Matcher", "DesktopFileForXid")) {
		result = _dbus_wnck_sync_matcher_desktop_file_for_xid (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.wncksync.Matcher", "WindowMatchIsReady")) {
		result = _dbus_wnck_sync_matcher_window_match_is_ready (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.wncksync.Matcher", "RegisterDesktopFileForPid")) {
		result = _dbus_wnck_sync_matcher_register_desktop_file_for_pid (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.wncksync.Matcher", "XidsForDesktopFile")) {
		result = _dbus_wnck_sync_matcher_xids_for_desktop_file (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void wnck_sync_matcher_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_wnck_sync_matcher_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void wnck_sync_matcher_base_init (WnckSyncMatcherIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_type_set_qdata (TYPE_WNCK_SYNC_MATCHER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_wnck_sync_matcher_dbus_vtable));
	}
}


GType wnck_sync_matcher_get_type (void) {
	static volatile gsize wnck_sync_matcher_type_id__volatile = 0;
	if (g_once_init_enter (&wnck_sync_matcher_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WnckSyncMatcherIface), (GBaseInitFunc) wnck_sync_matcher_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType wnck_sync_matcher_type_id;
		wnck_sync_matcher_type_id = g_type_register_static (G_TYPE_INTERFACE, "WnckSyncMatcher", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (wnck_sync_matcher_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (wnck_sync_matcher_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &wnck_sync_matcher_dbus_proxy_get_type);
		g_once_init_leave (&wnck_sync_matcher_type_id__volatile, wnck_sync_matcher_type_id);
	}
	return wnck_sync_matcher_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (WnckSyncMatcherDBusProxy, wnck_sync_matcher_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_WNCK_SYNC_MATCHER, wnck_sync_matcher_dbus_proxy_wnck_sync_matcher__interface_init) );
WnckSyncMatcher* wnck_sync_matcher_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	WnckSyncMatcher* self;
	self = g_object_new (wnck_sync_matcher_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.wncksync.Matcher", NULL);
	return self;
}


static GObject* wnck_sync_matcher_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (wnck_sync_matcher_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), wnck_sync_matcher_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult wnck_sync_matcher_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void wnck_sync_matcher_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((WnckSyncMatcherDBusProxy*) self)->disposed) {
		return;
	}
	((WnckSyncMatcherDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), wnck_sync_matcher_dbus_proxy_filter, self);
	G_OBJECT_CLASS (wnck_sync_matcher_dbus_proxy_parent_class)->dispose (self);
}


static void wnck_sync_matcher_dbus_proxy_class_init (WnckSyncMatcherDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = wnck_sync_matcher_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = wnck_sync_matcher_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = wnck_sync_matcher_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = wnck_sync_matcher_dbus_proxy_set_property;
}


static void wnck_sync_matcher_dbus_proxy_init (WnckSyncMatcherDBusProxy* self) {
}


static char* wnck_sync_matcher_dbus_proxy_desktop_file_for_xid (WnckSyncMatcher* self, guint32 xid, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp0_;
	char* _result;
	const char* _tmp1_;
	if (((WnckSyncMatcherDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.wncksync.Matcher", "DesktopFileForXid");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp0_ = xid;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp0_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp2_;
			_edomain = DBUS_GERROR;
			_tmp2_ = _dbus_error.name + 27;
			if (strcmp (_tmp2_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp2_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp2_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp2_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp2_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp2_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp2_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp2_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp2_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp2_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp2_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp2_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp2_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp2_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp2_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp2_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp2_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp2_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp2_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp2_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp2_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp2_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp2_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp2_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp2_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp2_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp2_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp2_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp2_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp2_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp2_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp2_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp2_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "s")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "s", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp1_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp1_);
	dbus_message_unref (_reply);
	return _result;
}


static gboolean wnck_sync_matcher_dbus_proxy_window_match_is_ready (WnckSyncMatcher* self, guint32 xid, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp3_;
	gboolean _result;
	dbus_bool_t _tmp4_;
	if (((WnckSyncMatcherDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.wncksync.Matcher", "WindowMatchIsReady");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp3_ = xid;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp3_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp5_;
			_edomain = DBUS_GERROR;
			_tmp5_ = _dbus_error.name + 27;
			if (strcmp (_tmp5_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp5_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp5_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp5_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp5_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp5_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp5_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp5_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp5_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp5_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp5_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp5_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp5_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp5_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp5_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp5_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp5_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp5_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp5_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp5_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp5_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp5_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp5_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp5_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp5_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp5_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp5_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp5_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp5_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp5_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp5_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp5_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp5_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return FALSE;
	}
	if (strcmp (dbus_message_get_signature (_reply), "b")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "b", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp4_);
	dbus_message_iter_next (&_iter);
	_result = _tmp4_;
	dbus_message_unref (_reply);
	return _result;
}


static void wnck_sync_matcher_dbus_proxy_register_desktop_file_for_pid (WnckSyncMatcher* self, const char* filename, gint32 pid, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp6_;
	dbus_int32_t _tmp7_;
	if (((WnckSyncMatcherDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.wncksync.Matcher", "RegisterDesktopFileForPid");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp6_ = filename;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp6_);
	_tmp7_ = pid;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_INT32, &_tmp7_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp8_;
			_edomain = DBUS_GERROR;
			_tmp8_ = _dbus_error.name + 27;
			if (strcmp (_tmp8_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp8_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp8_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp8_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp8_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp8_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp8_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp8_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp8_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp8_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp8_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp8_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp8_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp8_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp8_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp8_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp8_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp8_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp8_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp8_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp8_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp8_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp8_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp8_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp8_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp8_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp8_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp8_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp8_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp8_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp8_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp8_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp8_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static guint32* wnck_sync_matcher_dbus_proxy_xids_for_desktop_file (WnckSyncMatcher* self, const char* filename, int* result_length1, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp9_;
	guint32* _result;
	int _result_length1;
	guint32* _tmp10_;
	int _tmp10__length;
	int _tmp10__size;
	int _tmp10__length1;
	DBusMessageIter _tmp11_;
	if (((WnckSyncMatcherDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.wncksync.Matcher", "XidsForDesktopFile");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp9_ = filename;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp9_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp13_;
			_edomain = DBUS_GERROR;
			_tmp13_ = _dbus_error.name + 27;
			if (strcmp (_tmp13_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp13_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp13_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp13_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp13_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp13_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp13_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp13_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp13_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp13_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp13_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp13_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp13_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp13_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp13_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp13_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp13_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp13_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp13_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp13_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp13_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp13_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp13_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp13_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp13_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp13_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp13_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp13_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp13_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp13_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp13_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp13_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp13_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "au")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "au", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp10_ = g_new (guint32, 5);
	_tmp10__length = 0;
	_tmp10__size = 4;
	_tmp10__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp11_);
	for (; dbus_message_iter_get_arg_type (&_tmp11_); _tmp10__length1++) {
		dbus_uint32_t _tmp12_;
		if (_tmp10__size == _tmp10__length) {
			_tmp10__size = 2 * _tmp10__size;
			_tmp10_ = g_renew (guint32, _tmp10_, _tmp10__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp11_, &_tmp12_);
		dbus_message_iter_next (&_tmp11_);
		_tmp10_[_tmp10__length++] = _tmp12_;
	}
	_result_length1 = _tmp10__length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp10_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static void wnck_sync_matcher_dbus_proxy_wnck_sync_matcher__interface_init (WnckSyncMatcherIface* iface) {
	iface->desktop_file_for_xid = wnck_sync_matcher_dbus_proxy_desktop_file_for_xid;
	iface->window_match_is_ready = wnck_sync_matcher_dbus_proxy_window_match_is_ready;
	iface->register_desktop_file_for_pid = wnck_sync_matcher_dbus_proxy_register_desktop_file_for_pid;
	iface->xids_for_desktop_file = wnck_sync_matcher_dbus_proxy_xids_for_desktop_file;
}


static void wnck_sync_matcher_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void wnck_sync_matcher_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


static char** _vala_array_dup1 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


void desktop_file_info_copy (const DesktopFileInfo* self, DesktopFileInfo* dest) {
	char** _tmp0_;
	dest->name = g_strdup (self->name);
	dest->mimetypes = (_tmp0_ = self->mimetypes, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup1 (_tmp0_, (*self).mimetypes_length1));
	dest->mimetypes_length1 = self->mimetypes_length1;
}


void desktop_file_info_destroy (DesktopFileInfo* self) {
	_g_free0 (self->name);
	self->mimetypes = (_vala_array_free (self->mimetypes, (*self).mimetypes_length1, (GDestroyNotify) g_free), NULL);
}


DesktopFileInfo* desktop_file_info_dup (const DesktopFileInfo* self) {
	DesktopFileInfo* dup;
	dup = g_new0 (DesktopFileInfo, 1);
	desktop_file_info_copy (self, dup);
	return dup;
}


void desktop_file_info_free (DesktopFileInfo* self) {
	desktop_file_info_destroy (self);
	g_free (self);
}


GType desktop_file_info_get_type (void) {
	static volatile gsize desktop_file_info_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_file_info_type_id__volatile)) {
		GType desktop_file_info_type_id;
		desktop_file_info_type_id = g_boxed_type_register_static ("DesktopFileInfo", (GBoxedCopyFunc) desktop_file_info_dup, (GBoxedFreeFunc) desktop_file_info_free);
		g_once_init_leave (&desktop_file_info_type_id__volatile, desktop_file_info_type_id);
	}
	return desktop_file_info_type_id__volatile;
}


static void _related_applet_window_opened_wnck_screen_window_opened (WnckScreen* _sender, WnckWindow* window, gpointer self) {
	related_applet_window_opened (self, window);
}


static void _related_applet_window_changed_wnck_screen_active_window_changed (WnckScreen* _sender, WnckWindow* previous_window, gpointer self) {
	related_applet_window_changed (self, previous_window);
}


static void _related_applet_on_clicked_awn_applet_simple_clicked (AwnAppletSimple* _sender, gpointer self) {
	related_applet_on_clicked (self);
}


RelatedApplet* related_applet_construct (GType object_type, const char* canonical_name, const char* uid, gint panel_id) {
	RelatedApplet * self;
	GHashTable* _tmp0_;
	AwnDialog* _tmp1_;
	g_return_val_if_fail (canonical_name != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	self = (RelatedApplet*) g_object_new (object_type, "canonical-name", canonical_name, "uid", uid, "panel-id", panel_id, NULL);
	self->priv->desktop_file_info = (_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, desktop_file_info_free), _g_hash_table_unref0 (self->priv->desktop_file_info), _tmp0_);
	self->priv->wnck_screen = wnck_screen_get_default ();
	wnck_set_client_type (WNCK_CLIENT_TYPE_PAGER);
	g_signal_connect_object (self->priv->wnck_screen, "window-opened", (GCallback) _related_applet_window_opened_wnck_screen_window_opened, self, 0);
	g_signal_connect_object (self->priv->wnck_screen, "active-window-changed", (GCallback) _related_applet_window_changed_wnck_screen_active_window_changed, self, 0);
	awn_overlayable_add_overlay ((AwnOverlayable*) self, self->priv->throbber);
	awn_overlayable_add_overlay ((AwnOverlayable*) self, self->priv->star_overlay);
	awn_applet_simple_set_icon_name ((AwnAppletSimple*) self, "zeitgeist-logo");
	g_signal_connect_object ((AwnAppletSimple*) self, "clicked", (GCallback) _related_applet_on_clicked_awn_applet_simple_clicked, self, 0);
	self->priv->dialog = (_tmp1_ = g_object_ref_sink ((AwnDialog*) awn_dialog_new_for_widget ((GtkWidget*) self)), _g_object_unref0 (self->priv->dialog), _tmp1_);
	return self;
}


RelatedApplet* related_applet_new (const char* canonical_name, const char* uid, gint panel_id) {
	return related_applet_construct (TYPE_RELATED_APPLET, canonical_name, uid, panel_id);
}


static gpointer _desktop_file_info_dup0 (gpointer self) {
	return self ? desktop_file_info_dup (self) : NULL;
}


static void related_applet_window_opened (RelatedApplet* self, WnckWindow* window) {
	char* desktop_file;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	desktop_file = g_strdup (awn_desktop_lookup_search_by_wnck_window (self->priv->lookup, window));
	if (desktop_file == NULL) {
		{
			DBusGConnection* con;
			WnckSyncMatcher* matcher;
			char* df;
			gboolean _tmp0_ = FALSE;
			con = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch0_g_error;
			}
			matcher = wnck_sync_matcher_dbus_proxy_new (con, "org.wncksync.Matcher", "/org/wncksync/Matcher");
			df = wnck_sync_matcher_desktop_file_for_xid (matcher, (guint32) wnck_window_get_xid (window), &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (matcher);
				_dbus_g_connection_unref0 (con);
				goto __catch0_g_error;
			}
			if (df != NULL) {
				_tmp0_ = _vala_strcmp0 (df, "") != 0;
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				char* _tmp1_;
				g_debug ("related-applet.vala:107: wncksync found match: %s", df);
				desktop_file = (_tmp1_ = g_strdup (df), _g_free0 (desktop_file), _tmp1_);
			}
			_g_free0 (df);
			_g_object_unref0 (matcher);
			_dbus_g_connection_unref0 (con);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				_g_error_free0 (err);
			}
		}
		__finally0:
		if (_inner_error_ != NULL) {
			_g_free0 (desktop_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (desktop_file != NULL) {
		DesktopFileInfo* df_data = NULL;
		df_data = (DesktopFileInfo*) g_hash_table_lookup (self->priv->desktop_file_info, desktop_file);
		if (df_data == NULL) {
			GKeyFile* keyfile;
			gint mimetypes_length1;
			gint _mimetypes_size_;
			char** _tmp3_;
			char** _tmp2_ = NULL;
			char** mimetypes;
			char* app_name;
			DesktopFileInfo w = {0};
			char* _tmp10_;
			char* _tmp11_;
			char** _tmp12_;
			char** _tmp13_;
			keyfile = g_key_file_new ();
			mimetypes = (_tmp3_ = (_tmp2_ = g_new0 (char*, 0 + 1), _tmp2_), mimetypes_length1 = 0, _mimetypes_size_ = mimetypes_length1, _tmp3_);
			app_name = g_strdup ("");
			{
				char* _tmp4_;
				char* _tmp5_;
				gint _tmp7__length1;
				gint __tmp7__size_;
				char** _tmp8_;
				gsize _tmp6_;
				char** _tmp7_;
				char** _tmp9_;
				g_key_file_load_from_file (keyfile, desktop_file, G_KEY_FILE_NONE, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch1_g_error;
				}
				_tmp4_ = g_key_file_get_locale_string (keyfile, "Desktop Entry", "Name", NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch1_g_error;
				}
				app_name = (_tmp5_ = _tmp4_, _g_free0 (app_name), _tmp5_);
				_tmp7_ = (_tmp8_ = g_key_file_get_string_list (keyfile, "Desktop Entry", "MimeType", &_tmp6_, &_inner_error_), _tmp7__length1 = _tmp6_, __tmp7__size_ = _tmp7__length1, _tmp8_);
				if (_inner_error_ != NULL) {
					goto __catch1_g_error;
				}
				mimetypes = (_tmp9_ = _tmp7_, mimetypes = (_vala_array_free (mimetypes, mimetypes_length1, (GDestroyNotify) g_free), NULL), mimetypes_length1 = _tmp7__length1, _mimetypes_size_ = mimetypes_length1, _tmp9_);
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (err);
				}
			}
			__finally1:
			if (_inner_error_ != NULL) {
				_g_free0 (app_name);
				mimetypes = (_vala_array_free (mimetypes, mimetypes_length1, (GDestroyNotify) g_free), NULL);
				_g_key_file_free0 (keyfile);
				_g_free0 (desktop_file);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			memset (&w, 0, sizeof (DesktopFileInfo));
			w.name = (_tmp11_ = (_tmp10_ = app_name, app_name = NULL, _tmp10_), _g_free0 (w.name), _tmp11_);
			w.mimetypes = (_tmp13_ = (_tmp12_ = mimetypes, mimetypes = NULL, _tmp12_), w.mimetypes = (_vala_array_free (w.mimetypes, w.mimetypes_length1, (GDestroyNotify) g_free), NULL), w.mimetypes_length1 = mimetypes_length1, w._mimetypes_size_ = w.mimetypes_length1, _tmp13_);
			g_hash_table_insert (self->priv->desktop_file_info, g_strdup (desktop_file), _desktop_file_info_dup0 (&w));
			desktop_file_info_destroy (&w);
			_g_free0 (app_name);
			mimetypes = (_vala_array_free (mimetypes, mimetypes_length1, (GDestroyNotify) g_free), NULL);
			_g_key_file_free0 (keyfile);
		}
	}
	g_object_set_data_full ((GObject*) window, "desktop-file-path", g_strdup (desktop_file), g_free);
	_g_free0 (desktop_file);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void related_applet_window_changed (RelatedApplet* self, WnckWindow* old_window) {
	WnckWindow* active;
	g_return_if_fail (self != NULL);
	active = _g_object_ref0 (wnck_screen_get_active_window (self->priv->wnck_screen));
	if (active != NULL) {
		char* desktop_file;
		desktop_file = g_strdup ((const char*) g_object_get_data ((GObject*) active, "desktop-file-path"));
		if (desktop_file != NULL) {
			related_applet_update_star (self, desktop_file, NULL, NULL);
		} else {
			g_object_set (self->priv->star_overlay, "active", FALSE, NULL);
		}
		_g_free0 (desktop_file);
	}
	_g_object_unref0 (active);
}


static void related_applet_update_star_data_free (gpointer _data) {
	RelatedAppletUpdateStarData* data;
	data = _data;
	_g_free0 (data->desktop_file);
	g_object_unref (data->self);
	g_slice_free (RelatedAppletUpdateStarData, data);
}


static void related_applet_update_star (RelatedApplet* self, const char* desktop_file, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RelatedAppletUpdateStarData* _data_;
	_data_ = g_slice_new0 (RelatedAppletUpdateStarData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, related_applet_update_star);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, related_applet_update_star_data_free);
	_data_->self = g_object_ref (self);
	_data_->desktop_file = g_strdup (desktop_file);
	related_applet_update_star_co (_data_);
}


static void related_applet_update_star_finish (RelatedApplet* self, GAsyncResult* _res_) {
	RelatedAppletUpdateStarData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void related_applet_update_star_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RelatedAppletUpdateStarData* data;
	data = _user_data_;
	data->_res_ = _res_;
	related_applet_update_star_co (data);
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static gboolean related_applet_update_star_co (RelatedAppletUpdateStarData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 1:
		goto _state_1;
	}
	_state_0:
	data->ptr_array = g_ptr_array_new ();
	data->actor = g_utf8_offset_to_pointer (g_utf8_strrchr (data->desktop_file, (gssize) (-1), (gunichar) '/'), (glong) 1);
	data->event = g_object_ref_sink (zeitgeist_event_new ());
	data->helper_event_list = NULL;
	zeitgeist_event_set_actor (data->event, data->_tmp0_ = g_strconcat ("application://", data->actor, NULL));
	_g_free0 (data->_tmp0_);
	g_ptr_array_add (data->ptr_array, data->event);
	data->df_data = (DesktopFileInfo*) g_hash_table_lookup (data->self->priv->desktop_file_info, data->desktop_file);
	if (data->df_data != NULL) {
		data->_tmp1_ = (*data->df_data).mimetypes_length1 > 0;
	} else {
		data->_tmp1_ = FALSE;
	}
	if (data->_tmp1_) {
		{
			data->mimetype_collection = (*data->df_data).mimetypes;
			data->mimetype_collection_length1 = (*data->df_data).mimetypes_length1;
			for (data->mimetype_it = 0; data->mimetype_it < (*data->df_data).mimetypes_length1; data->mimetype_it = data->mimetype_it + 1) {
				data->mimetype = data->mimetype_collection[data->mimetype_it];
				{
					data->mime_event = g_object_ref_sink (zeitgeist_event_new ());
					data->subject = g_object_ref_sink (zeitgeist_subject_new ());
					zeitgeist_subject_set_mimetype (data->subject, data->mimetype);
					zeitgeist_event_add_subject (data->mime_event, data->subject);
					data->helper_event_list = g_list_prepend (data->helper_event_list, _g_object_ref0 (data->mime_event));
					g_ptr_array_add (data->ptr_array, data->mime_event);
					_g_object_unref0 (data->subject);
					_g_object_unref0 (data->mime_event);
				}
			}
		}
	}
	data->_state_ = 1;
	zeitgeist_log_find_event_ids (data->self->priv->zg_log, data->_tmp2_ = g_object_ref_sink (zeitgeist_time_range_new_to_now ()), (data->_tmp3_ = data->ptr_array, data->ptr_array = NULL, data->_tmp3_), ZEITGEIST_STORAGE_STATE_ANY, (guint32) 1, ZEITGEIST_RESULT_TYPE_MOST_RECENT_EVENTS, NULL, related_applet_update_star_ready, data);
	return FALSE;
	_state_1:
	data->events = (data->_tmp4_ = zeitgeist_log_find_event_ids_finish (data->self->priv->zg_log, data->_res_, &data->_inner_error_), _g_object_unref0 (data->_tmp2_), data->_tmp4_);
	if (data->_inner_error_ != NULL) {
		__g_list_free_g_object_unref0 (data->helper_event_list);
		_g_object_unref0 (data->event);
		_g_ptr_array_free0 (data->ptr_array);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	g_object_set (data->self->priv->star_overlay, "active", data->events->len > 0, NULL);
	if (data->events->len > 0) {
		data->_tmp5_ = (data->_tmp6_ = g_strdup_printf ("Show items related to %s", (*data->df_data).name), _g_free0 (data->_tmp5_), data->_tmp6_);
	} else {
		data->_tmp5_ = (data->_tmp7_ = NULL, _g_free0 (data->_tmp5_), data->_tmp7_);
	}
	awn_applet_simple_set_tooltip_text ((AwnAppletSimple*) data->self, data->_tmp5_);
	_g_free0 (data->_tmp5_);
	_g_array_free0 (data->events);
	__g_list_free_g_object_unref0 (data->helper_event_list);
	_g_object_unref0 (data->event);
	_g_ptr_array_free0 (data->ptr_array);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void related_applet_get_recent_by_mimetype_data_free (gpointer _data) {
	RelatedAppletGetRecentByMimetypeData* data;
	data = _data;
	data->mimetypes = (_vala_array_free (data->mimetypes, data->mimetypes_length1, (GDestroyNotify) g_free), NULL);
	g_object_unref (data->self);
	g_slice_free (RelatedAppletGetRecentByMimetypeData, data);
}


static char** _vala_array_dup2 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void related_applet_get_recent_by_mimetype (RelatedApplet* self, char** mimetypes, int mimetypes_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RelatedAppletGetRecentByMimetypeData* _data_;
	char** _tmp0_;
	_data_ = g_slice_new0 (RelatedAppletGetRecentByMimetypeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, related_applet_get_recent_by_mimetype);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, related_applet_get_recent_by_mimetype_data_free);
	_data_->self = g_object_ref (self);
	_data_->mimetypes = (_tmp0_ = mimetypes, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup2 (_tmp0_, mimetypes_length1));
	_data_->mimetypes_length1 = mimetypes_length1;
	related_applet_get_recent_by_mimetype_co (_data_);
}


static gboolean related_applet_get_recent_by_mimetype_finish (RelatedApplet* self, GAsyncResult* _res_) {
	gboolean result;
	RelatedAppletGetRecentByMimetypeData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void related_applet_get_recent_by_mimetype_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RelatedAppletGetRecentByMimetypeData* data;
	data = _user_data_;
	data->_res_ = _res_;
	related_applet_get_recent_by_mimetype_co (data);
}


static gboolean related_applet_get_recent_by_mimetype_co (RelatedAppletGetRecentByMimetypeData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 2:
		goto _state_2;
	}
	_state_0:
	data->helper_event_list = NULL;
	data->ptr_array = g_ptr_array_new ();
	{
		data->mimetype_collection = data->mimetypes;
		data->mimetype_collection_length1 = data->mimetypes_length1;
		for (data->mimetype_it = 0; data->mimetype_it < data->mimetypes_length1; data->mimetype_it = data->mimetype_it + 1) {
			data->mimetype = data->mimetype_collection[data->mimetype_it];
			{
				data->event = g_object_ref_sink (zeitgeist_event_new ());
				data->subject = g_object_ref_sink (zeitgeist_subject_new ());
				zeitgeist_subject_set_mimetype (data->subject, data->mimetype);
				zeitgeist_event_add_subject (data->event, data->subject);
				data->helper_event_list = g_list_prepend (data->helper_event_list, _g_object_ref0 (data->event));
				g_ptr_array_add (data->ptr_array, data->event);
				_g_object_unref0 (data->subject);
				_g_object_unref0 (data->event);
			}
		}
	}
	data->_state_ = 2;
	zeitgeist_log_find_events (data->self->priv->zg_log, data->_tmp0_ = g_object_ref_sink (zeitgeist_time_range_new_to_now ()), (data->_tmp1_ = data->ptr_array, data->ptr_array = NULL, data->_tmp1_), ZEITGEIST_STORAGE_STATE_ANY, (guint32) 16, ZEITGEIST_RESULT_TYPE_MOST_RECENT_SUBJECTS, NULL, related_applet_get_recent_by_mimetype_ready, data);
	return FALSE;
	_state_2:
	data->events = (data->_tmp2_ = zeitgeist_log_find_events_finish (data->self->priv->zg_log, data->_res_, &data->_inner_error_), _g_object_unref0 (data->_tmp0_), data->_tmp2_);
	if (data->_inner_error_ != NULL) {
		_g_ptr_array_free0 (data->ptr_array);
		__g_list_free_g_object_unref0 (data->helper_event_list);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->results_pushed = 0;
	{
		data->_e_it = _vala_zeitgeist_result_set_iterator (data->events);
		while (TRUE) {
			if (!((data->e = _vala_zeitgeist_result_set_next_value (data->_e_it)) != NULL)) {
				break;
			}
			if (zeitgeist_event_num_subjects (data->e) > 0) {
				data->s = _g_object_ref0 (zeitgeist_event_get_subject (data->e, 0));
				if (data->results_pushed < 3) {
					data->_tmp3_ = related_applet_push_result (data->self, data->e, data->s);
				} else {
					data->_tmp3_ = FALSE;
				}
				if (data->_tmp3_) {
					data->results_pushed++;
				}
				_g_object_unref0 (data->s);
			}
		}
		_g_object_unref0 (data->_e_it);
	}
	data->result = zeitgeist_result_set_size (data->events) > 0;
	_g_object_unref0 (data->events);
	_g_ptr_array_free0 (data->ptr_array);
	__g_list_free_g_object_unref0 (data->helper_event_list);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_object_unref0 (data->events);
	_g_ptr_array_free0 (data->ptr_array);
	__g_list_free_g_object_unref0 (data->helper_event_list);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void related_applet_get_events_for_actor_data_free (gpointer _data) {
	RelatedAppletGetEventsForActorData* data;
	data = _data;
	_g_free0 (data->actor);
	g_object_unref (data->self);
	g_slice_free (RelatedAppletGetEventsForActorData, data);
}


static void related_applet_get_events_for_actor (RelatedApplet* self, const char* actor, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RelatedAppletGetEventsForActorData* _data_;
	_data_ = g_slice_new0 (RelatedAppletGetEventsForActorData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, related_applet_get_events_for_actor);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, related_applet_get_events_for_actor_data_free);
	_data_->self = g_object_ref (self);
	_data_->actor = g_strdup (actor);
	related_applet_get_events_for_actor_co (_data_);
}


static gboolean related_applet_get_events_for_actor_finish (RelatedApplet* self, GAsyncResult* _res_) {
	gboolean result;
	RelatedAppletGetEventsForActorData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void related_applet_get_events_for_actor_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RelatedAppletGetEventsForActorData* data;
	data = _user_data_;
	data->_res_ = _res_;
	related_applet_get_events_for_actor_co (data);
}


static gboolean related_applet_get_events_for_actor_co (RelatedAppletGetEventsForActorData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 3:
		goto _state_3;
	}
	_state_0:
	data->ptr_array = g_ptr_array_new ();
	data->event = g_object_ref_sink (zeitgeist_event_new ());
	if (data->actor != NULL) {
		zeitgeist_event_set_actor (data->event, data->_tmp0_ = g_strconcat ("application://", data->actor, NULL));
		_g_free0 (data->_tmp0_);
	}
	g_ptr_array_add (data->ptr_array, data->event);
	data->_state_ = 3;
	zeitgeist_log_find_events (data->self->priv->zg_log, data->_tmp1_ = g_object_ref_sink (zeitgeist_time_range_new_to_now ()), (data->_tmp2_ = data->ptr_array, data->ptr_array = NULL, data->_tmp2_), ZEITGEIST_STORAGE_STATE_ANY, (guint32) 16, ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS, NULL, related_applet_get_events_for_actor_ready, data);
	return FALSE;
	_state_3:
	data->events = (data->_tmp3_ = zeitgeist_log_find_events_finish (data->self->priv->zg_log, data->_res_, &data->_inner_error_), _g_object_unref0 (data->_tmp1_), data->_tmp3_);
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->event);
		_g_ptr_array_free0 (data->ptr_array);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->results_pushed = 0;
	{
		data->_e_it = _vala_zeitgeist_result_set_iterator (data->events);
		while (TRUE) {
			if (!((data->e = _vala_zeitgeist_result_set_next_value (data->_e_it)) != NULL)) {
				break;
			}
			if (zeitgeist_event_num_subjects (data->e) > 0) {
				data->s = _g_object_ref0 (zeitgeist_event_get_subject (data->e, 0));
				if (data->results_pushed < 4) {
					data->_tmp4_ = related_applet_push_result (data->self, data->e, data->s);
				} else {
					data->_tmp4_ = FALSE;
				}
				if (data->_tmp4_) {
					data->results_pushed++;
				}
				_g_object_unref0 (data->s);
			}
		}
		_g_object_unref0 (data->_e_it);
	}
	data->result = zeitgeist_result_set_size (data->events) > 0;
	_g_object_unref0 (data->events);
	_g_object_unref0 (data->event);
	_g_ptr_array_free0 (data->ptr_array);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_object_unref0 (data->events);
	_g_object_unref0 (data->event);
	_g_ptr_array_free0 (data->ptr_array);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void related_applet_build_dialog_data_free (gpointer _data) {
	RelatedAppletBuildDialogData* data;
	data = _data;
	_g_free0 (data->desktop_file);
	g_object_unref (data->self);
	g_slice_free (RelatedAppletBuildDialogData, data);
}


static void related_applet_build_dialog (RelatedApplet* self, const char* desktop_file, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RelatedAppletBuildDialogData* _data_;
	_data_ = g_slice_new0 (RelatedAppletBuildDialogData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, related_applet_build_dialog);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, related_applet_build_dialog_data_free);
	_data_->self = g_object_ref (self);
	_data_->desktop_file = g_strdup (desktop_file);
	related_applet_build_dialog_co (_data_);
}


static void related_applet_build_dialog_finish (RelatedApplet* self, GAsyncResult* _res_) {
	RelatedAppletBuildDialogData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void related_applet_build_dialog_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RelatedAppletBuildDialogData* data;
	data = _user_data_;
	data->_res_ = _res_;
	related_applet_build_dialog_co (data);
}


static gboolean related_applet_build_dialog_co (RelatedAppletBuildDialogData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
	}
	_state_0:
	if (data->self->priv->vbox != NULL) {
		gtk_object_destroy ((GtkObject*) data->self->priv->vbox);
	}
	data->self->priv->vbox = (data->_tmp0_ = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 3)), _g_object_unref0 (data->self->priv->vbox), data->_tmp0_);
	gtk_container_add ((GtkContainer*) data->self->priv->dialog, (GtkWidget*) data->self->priv->vbox);
	data->found1 = FALSE;
	data->found2 = FALSE;
	data->self->priv->current_desktop_file_path = (data->_tmp1_ = g_strdup (data->desktop_file), _g_free0 (data->self->priv->current_desktop_file_path), data->_tmp1_);
	g_object_set (data->self->priv->throbber, "active", TRUE, NULL);
	if (data->desktop_file != NULL) {
		data->df_data = (DesktopFileInfo*) g_hash_table_lookup (data->self->priv->desktop_file_info, data->desktop_file);
		if (data->df_data != NULL) {
			data->_tmp2_ = (*data->df_data).mimetypes_length1 > 0;
		} else {
			data->_tmp2_ = FALSE;
		}
		if (data->_tmp2_) {
			data->_state_ = 4;
			related_applet_get_recent_by_mimetype (data->self, (*data->df_data).mimetypes, (*data->df_data).mimetypes_length1, related_applet_build_dialog_ready, data);
			return FALSE;
			_state_4:
			data->found1 = related_applet_get_recent_by_mimetype_finish (data->self, data->_res_);
		}
	} else {
		data->_tmp3_ = NULL;
		data->_state_ = 5;
		related_applet_get_recent_by_mimetype (data->self, (data->_tmp4_ = (data->_tmp3_ = g_new0 (char*, 0 + 1), data->_tmp3_), data->_tmp4__length1 = 0, data->_tmp4_), 0, related_applet_build_dialog_ready, data);
		return FALSE;
		_state_5:
		data->found1 = related_applet_get_recent_by_mimetype_finish (data->self, data->_res_);
		data->_tmp4_ = (_vala_array_free (data->_tmp4_, data->_tmp4__length1, (GDestroyNotify) g_free), NULL);
	}
	if (data->found1) {
		gtk_container_add ((GtkContainer*) data->self->priv->vbox, (GtkWidget*) (data->_tmp5_ = g_object_ref_sink ((GtkHSeparator*) gtk_hseparator_new ())));
		_g_object_unref0 (data->_tmp5_);
	}
	data->actor = NULL;
	if (data->desktop_file != NULL) {
		data->actor = g_utf8_offset_to_pointer (g_utf8_strrchr (data->desktop_file, (gssize) (-1), (gunichar) '/'), (glong) 1);
	}
	data->_state_ = 6;
	related_applet_get_events_for_actor (data->self, data->actor, related_applet_build_dialog_ready, data);
	return FALSE;
	_state_6:
	data->found2 = related_applet_get_events_for_actor_finish (data->self, data->_res_);
	if (data->desktop_file != NULL) {
		data->_tmp7_ = !data->found1;
	} else {
		data->_tmp7_ = FALSE;
	}
	if (data->_tmp7_) {
		data->_tmp6_ = !data->found2;
	} else {
		data->_tmp6_ = FALSE;
	}
	if (data->_tmp6_) {
		related_applet_build_dialog (data->self, NULL, NULL, NULL);
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	g_object_set (data->self->priv->throbber, "active", FALSE, NULL);
	if (!data->found1) {
		data->_tmp8_ = !data->found2;
	} else {
		data->_tmp8_ = FALSE;
	}
	if (data->_tmp8_) {
		data->l = g_object_ref_sink ((GtkLabel*) gtk_label_new ("There are no items to display..."));
		gtk_container_add ((GtkContainer*) data->self->priv->vbox, (GtkWidget*) data->l);
		_g_object_unref0 (data->l);
	}
	gtk_widget_show_all ((GtkWidget*) data->self->priv->dialog);
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


static void related_applet_on_clicked (RelatedApplet* self) {
	GtkWidgetFlags dialog_flags;
	WnckWindow* active;
	char* desktop_file;
	g_return_if_fail (self != NULL);
	dialog_flags = GTK_WIDGET_FLAGS ((GtkWidget*) self->priv->dialog) & GTK_VISIBLE;
	if (dialog_flags != 0) {
		gtk_widget_hide ((GtkWidget*) self->priv->dialog);
		return;
	}
	g_object_set (self->priv->dialog, "hide-on-unfocus", TRUE, NULL);
	active = _g_object_ref0 (wnck_screen_get_active_window (self->priv->wnck_screen));
	desktop_file = g_strdup ((const char*) g_object_get_data ((GObject*) active, "desktop-file-path"));
	related_applet_build_dialog (self, desktop_file, NULL, NULL);
	_g_free0 (desktop_file);
	_g_object_unref0 (active);
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static void _lambda0_ (Block1Data* _data1_) {
	RelatedApplet * self;
	GAppLaunchContext* context;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	context = g_app_launch_context_new ();
	if (_data1_->desktop_file == NULL) {
		char* _tmp0_;
		g_app_info_launch_default_for_uri (_tmp0_ = g_file_get_uri (_data1_->f), context, &_inner_error_);
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	} else {
		GDesktopAppInfo* app_info;
		app_info = g_desktop_app_info_new_from_filename (_data1_->desktop_file);
		if (g_app_info_supports_uris ((GAppInfo*) app_info)) {
			GList* l;
			l = NULL;
			l = g_list_append (l, g_file_get_uri (_data1_->f));
			g_app_info_launch_uris ((GAppInfo*) app_info, l, context, &_inner_error_);
			if (_inner_error_ != NULL) {
				__g_list_free_g_free0 (l);
				_g_object_unref0 (app_info);
				_g_object_unref0 (context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			__g_list_free_g_free0 (l);
		} else {
			GList* l;
			l = NULL;
			l = g_list_append (l, _g_object_ref0 (_data1_->f));
			g_app_info_launch ((GAppInfo*) app_info, l, context, &_inner_error_);
			if (_inner_error_ != NULL) {
				__g_list_free_g_object_unref0 (l);
				_g_object_unref0 (app_info);
				_g_object_unref0 (context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			__g_list_free_g_object_unref0 (l);
		}
		_g_object_unref0 (app_info);
	}
	gtk_widget_hide ((GtkWidget*) self->priv->dialog);
	_g_object_unref0 (context);
}


static void __lambda0__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda0_ (self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_free0 (_data1_->desktop_file);
		_g_object_unref0 (_data1_->f);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean related_applet_push_result (RelatedApplet* self, ZeitgeistEvent* event, ZeitgeistSubject* subject) {
	gboolean result = FALSE;
	Block1Data* _data1_;
	gboolean _tmp0_ = FALSE;
	char* text;
	GIcon* icon;
	GtkButton* button;
	GtkHBox* hbox;
	GtkImage* image;
	GtkLabel* label;
	char* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	g_return_val_if_fail (subject != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->f = g_file_new_for_uri (zeitgeist_subject_get_uri (subject));
	if (g_file_is_native (_data1_->f)) {
		_tmp0_ = !g_file_query_exists (_data1_->f, NULL);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		block1_data_unref (_data1_);
		return result;
	}
	text = g_strdup (zeitgeist_subject_get_text (subject));
	if (text == NULL) {
		char* _tmp1_;
		text = (_tmp1_ = g_file_get_basename (_data1_->f), _g_free0 (text), _tmp1_);
	}
	icon = NULL;
	if (g_file_is_native (_data1_->f)) {
		GFileInfo* fi;
		GIcon* _tmp2_;
		fi = g_file_query_info (_data1_->f, G_FILE_ATTRIBUTE_STANDARD_ICON, 0, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (icon);
			_g_free0 (text);
			block1_data_unref (_data1_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		icon = (_tmp2_ = _g_object_ref0 (g_file_info_get_icon (fi)), _g_object_unref0 (icon), _tmp2_);
		_g_object_unref0 (fi);
	} else {
		GIcon* _tmp3_;
		icon = (_tmp3_ = g_content_type_get_icon (zeitgeist_subject_get_mimetype (subject)), _g_object_unref0 (icon), _tmp3_);
	}
	button = g_object_ref_sink ((GtkButton*) gtk_button_new ());
	hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
	image = g_object_ref_sink ((GtkImage*) gtk_image_new_from_gicon (icon, GTK_ICON_SIZE_BUTTON));
	label = g_object_ref_sink ((GtkLabel*) gtk_label_new (text));
	gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_MIDDLE);
	gtk_label_set_max_width_chars (label, 35);
	g_object_set ((GtkMisc*) label, "xalign", 0.0f, NULL);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) image, FALSE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
	gtk_button_set_relief (button, GTK_RELIEF_NONE);
	gtk_button_set_focus_on_click (button, FALSE);
	gtk_container_add ((GtkContainer*) button, (GtkWidget*) hbox);
	_tmp4_ = NULL;
	if (g_file_is_native (_data1_->f)) {
		char* _tmp5_;
		_tmp4_ = (_tmp5_ = g_file_get_path (_data1_->f), _g_free0 (_tmp4_), _tmp5_);
	} else {
		char* _tmp6_;
		_tmp4_ = (_tmp6_ = g_file_get_uri (_data1_->f), _g_free0 (_tmp4_), _tmp6_);
	}
	gtk_widget_set_tooltip_text ((GtkWidget*) button, _tmp4_);
	_data1_->desktop_file = g_strdup (self->priv->current_desktop_file_path);
	g_signal_connect_data (button, "clicked", (GCallback) __lambda0__gtk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	gtk_container_add ((GtkContainer*) self->priv->vbox, (GtkWidget*) button);
	result = TRUE;
	_g_free0 (_tmp4_);
	_g_object_unref0 (label);
	_g_object_unref0 (image);
	_g_object_unref0 (hbox);
	_g_object_unref0 (button);
	_g_object_unref0 (icon);
	_g_free0 (text);
	block1_data_unref (_data1_);
	return result;
}


static GObject * related_applet_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	RelatedApplet * self;
	parent_class = G_OBJECT_CLASS (related_applet_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = RELATED_APPLET (obj);
	{
		AwnOverlay* _tmp1_;
		AwnOverlay* _tmp2_;
		g_object_set (self->priv->star_overlay, "active", FALSE, NULL);
		g_object_set (self->priv->star_overlay, "gravity", GDK_GRAVITY_SOUTH_EAST, NULL);
		g_object_set ((_tmp1_ = self->priv->star_overlay, AWN_IS_OVERLAY_THEMED_ICON (_tmp1_) ? ((AwnOverlayThemedIcon*) _tmp1_) : NULL), "scale", 0.3, NULL);
		g_object_set (self->priv->throbber, "gravity", GDK_GRAVITY_SOUTH_WEST, NULL);
		g_object_set ((_tmp2_ = self->priv->throbber, AWN_IS_OVERLAY_THROBBER (_tmp2_) ? ((AwnOverlayThrobber*) _tmp2_) : NULL), "scale", 0.3, NULL);
	}
	return obj;
}


static void related_applet_class_init (RelatedAppletClass * klass) {
	related_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RelatedAppletPrivate));
	G_OBJECT_CLASS (klass)->constructor = related_applet_constructor;
	G_OBJECT_CLASS (klass)->finalize = related_applet_finalize;
}


static void related_applet_instance_init (RelatedApplet * self) {
	self->priv = RELATED_APPLET_GET_PRIVATE (self);
	self->priv->lookup = awn_desktop_lookup_cached_new ();
	self->priv->zg_log = zeitgeist_log_new ();
	self->priv->throbber = (AwnOverlay*) g_object_ref_sink ((AwnOverlayThrobber*) awn_overlay_throbber_new ());
	self->priv->star_overlay = (AwnOverlay*) g_object_ref_sink (awn_overlay_themed_icon_new (GTK_STOCK_ABOUT));
}


static void related_applet_finalize (GObject* obj) {
	RelatedApplet * self;
	self = RELATED_APPLET (obj);
	_g_object_unref0 (self->priv->lookup);
	_g_object_unref0 (self->priv->zg_log);
	_g_object_unref0 (self->priv->throbber);
	_g_object_unref0 (self->priv->star_overlay);
	_g_hash_table_unref0 (self->priv->desktop_file_info);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->vbox);
	_g_free0 (self->priv->current_desktop_file_path);
	G_OBJECT_CLASS (related_applet_parent_class)->finalize (obj);
}


GType related_applet_get_type (void) {
	static volatile gsize related_applet_type_id__volatile = 0;
	if (g_once_init_enter (&related_applet_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RelatedAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) related_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RelatedApplet), 0, (GInstanceInitFunc) related_applet_instance_init, NULL };
		GType related_applet_type_id;
		related_applet_type_id = g_type_register_static (AWN_TYPE_APPLET_SIMPLE, "RelatedApplet", &g_define_type_info, 0);
		g_once_init_leave (&related_applet_type_id__volatile, related_applet_type_id);
	}
	return related_applet_type_id__volatile;
}


AwnApplet* awn_applet_factory_initp (const char* canonical_name, const char* uid, gint panel_id) {
	AwnApplet* result = NULL;
	g_return_val_if_fail (canonical_name != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	result = (AwnApplet*) g_object_ref_sink (related_applet_new (canonical_name, uid, panel_id));
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




