/*
Copyright (C) 2000-2001 Jos Roberto B. de A. Monteiro <jrm@autsens.com>
                        and Pedro Zorzenon Neto <pzn@autsens.com>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef _AVRSERIAL_H
#define _AVR_SERIAL_H

#include "avrpp.h"

/*#define DELAY1 2
#define DELAY2 10
#define DELAY3 200
#define DELAY_LONG 30000 */

/*microsec clock period of chip*/
#define TCLCL 1

#define MAXTRIES 10

int exchange (ASPP *aspp, int wr_data);
int programming_enable (ASPP *aspp);
void power_up (ASPP * aspp);
void power_off (ASPP * aspp, int reset);
int read_signature_byte(ASPP *aspp, int address);
int read_program_memory(ASPP *aspp, int sb, int address);
int write_program_memory(ASPP *aspp, int sb, int address, int data);
int read_eeprom_memory(ASPP *aspp, int address);
int write_eeprom_memory(ASPP *aspp, int address, int data);
void change_reset_pin (ASPP *aspp, int i);
void write_lock_bits(ASPP * aspp, int lock);
void chip_erase(ASPP * aspp);

#endif
