/*
 * avrdude - A Downloader/Uploader for AVR device programmers
 * Copyright (C) 2006 Joerg Wunsch <j@uriah.heep.sax.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* $Id: stk500generic.c,v 1.1 2006/09/19 22:27:30 joerg_wunsch Exp $ */

/*
 * avrdude interface for Atmel STK500 programmer
 *
 * This is a wrapper around the STK500[v1] and STK500v2 programmers.
 * Try to select the programmer type that actually responds, and
 * divert to the actual programmer implementation if successful.
 */

#include "ac_cfg.h"

#include <stdio.h>
#include <string.h>

#include "pgm.h"
#include "stk500.h"
#include "stk500v2.h"

extern char *progname;

static int stk500generic_open(PROGRAMMER * pgm, char * port)
{
  stk500_initpgm(pgm);
  if (pgm->open(pgm, port) >= 0)
    {
      fprintf(stderr,
	      "%s: successfully opened stk500v1 device -- please use -c stk500v1\n",
	      progname);
      return 0;
    }

  stk500v2_initpgm(pgm);
  if (pgm->open(pgm, port) >= 0)
    {
      fprintf(stderr,
	      "%s: successfully opened stk500v2 device -- please use -c stk500v2\n",
	      progname);
      return 0;
    }

  fprintf(stderr,
	  "%s: cannot open either stk500v1 or stk500v2 programmer\n",
	  progname);
  return -1;
}

void stk500generic_initpgm(PROGRAMMER * pgm)
{
  strcpy(pgm->type, "STK500GENERIC");

  pgm->open           = stk500generic_open;
}
