/* Copyright (c) 2007  Dmitry Xmelkov
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the
     distribution.
   * Neither the name of the copyright holders nor the names of
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE. */

/* $Id: memrchr_P.S,v 1.1.2.1 2007/03/31 23:14:26 dmix Exp $ */

/** \file */
/** \ingroup avr_pgmspace
    \fn PGM_VOID_P memrchr_P(PGM_VOID_P src, int val, size_t len)

    The memrchr_P() function is like the memchr_P() function, except
    that it searches backwards from the end of the \p len bytes pointed
    to by \p src instead of forwards from the front. (Glibc, GNU extension.)

    \return The memrchr_P() function returns a pointer to the matching
    byte or \c NULL if the character does not occur in the given memory
    area.	*/

#if !defined(__DOXYGEN__)

#include "asmdef.h"

#define src_hi	r25
#define src_lo	r24
#define val	r22
#define len_hi	r21
#define len_lo	r20

#define ret_lo	r24

ENTRY memrchr_P
	X_movw	ZL, len_lo
	adiw	ZL, 0
	breq	2f			; len is 0, return NULL
	add	ZL, src_lo
	adc	ZH, src_hi

1:	sbiw	ZL, 1
	lpm
	cp	r0, val
	breq	2f			; val is found
	subi	len_lo, lo8(1)
	sbci	len_hi, hi8(1)
	brne	1b

	X_movw	ZL, len_lo		; is zero
2:	X_movw	ret_lo, ZL
	ret
ENDFUNC

#endif /* not __DOXYGEN__ */
