dnl Che
dnl currently needed only by ffmpeg
dnl AC_FUNC_LRINTF([ACTION-IF-FOUND-LRINTF [, ACTION-IF-NOT-FOUND-LRINTF]])
dnl
AC_DEFUN([AC_FUNC_LRINTF],
[
    AC_CACHE_CHECK([whether system declares lrintf function in math.h],
		   ac_cv_val_have_lrintf,
		   [ac_save_CFLAGS=$CFLAGS
		   ac_save_LIBS=$LIBS
                   CFLAGS="$CFLAGS -O2"
		   LIBS="$LIBS -lm"
                   AC_RUN_IFELSE(AC_LANG_SOURCE([
		    #define _ISOC9X_SOURCE  1
		    #include <math.h>
		    int main( void ) { return (lrintf(3.999f) > 0)?0:1; }]),
                    ac_cv_val_have_lrintf=yes, ac_cv_val_have_lrintf=no,
                    [ echo $ac_n "cross compiling; assumed OK... $ac_c" ])
                   CFLAGS=$ac_save_CFLAGS
                   LIBS=$ac_save_LIBS
		   ])
    if test "$ac_cv_val_have_lrintf" = yes; then
        ifelse([$1], , :, [$1])
    else
        ifelse([$2], , :, [$2])
    fi
])

dnl
dnl AC_CHECK_IPV6([ACTION-IF-FOUND-IPV6 [, ACTION-IF-NOT-FOUND-IPV6]])
dnl
AC_DEFUN([AC_CHECK_IPV6],
[
    AC_CACHE_CHECK([whether system supports IPv6],
		   ac_cv_val_have_ipv6,
		   AC_COMPILE_IFELSE(AC_LANG_PROGRAM([
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
                   ], [
  struct sockaddr_storage saddr;
  struct ipv6_mreq mreq6;
  getaddrinfo(0,0,0,0);
  getnameinfo(0,0,0,0,0,0,0);
  IN6_IS_ADDR_MULTICAST((const struct in6_addr *)0);
                   ]), ac_cv_val_have_ipv6=yes, ac_cv_val_have_ipv6=no)
		   )
    if test "$ac_cv_val_have_ipv6" = yes; then
        ifelse([$1], , :, [$1])
    else
        ifelse([$2], , :, [$2])
    fi
])

dnl Usage:
dnl AM_PATH_FFMPEG([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl Test for ffmpeg, and define FFMPEG_CFLAGS and FFMPEG_LIBS

AC_DEFUN([AM_PATH_FFMPEG],
[
    AC_FUNC_LRINTF([    
	AC_DEFINE(HAVE_LRINTF, 1, [Define if you have lrintf on your system.])
        AC_DEFINE(_ISOC9X_SOURCE, 1, [Define for proper lrintf prototype.])])

    AC_CHECK_FUNCS(mkstemp)

    AC_CHECK_ALIGN_POWER([
        AC_DEFINE(ASMALIGN(ZEROBITS), [".align " #ZEROBITS "\n\t"], 
                   [ffmpeg Define if your .align arg is power-of-two.])],[
        AC_DEFINE(ASMALIGN(ZEROBITS), [".align 1<<" #ZEROBITS "\n\t"], 
                   [ffmpeg Define if your .align arg is not power-of-two.])
    ])

    AC_CHECK_RESTRICT_KEYWORD(AC_DEFINE_UNQUOTED(restrict, $have_restrict_keyword, [Define restrict keyword.]))

    AC_CHECK_HEADERS(sys/poll.h)
    
    dnl !!! - it really sucks - Makefile.am can not be optimized even by
    dnl !!! preparing some extra variable forward
    dnl !!! FFAVFORMAT_SRC=

    ac_enablef_mmx=0
    ac_enablef_armv4l=0
    ac_enablef_mlib=0
    ac_enablef_sparc=0
    ac_enablef_alpha=0
    ac_enablef_powerpc=0
    ac_enablef_mmi=0
    ac_enablef_sh4=0
    ac_enablef_bfin=0
    case "$target" in
        i?86*|ia64*|x86_64*|amd64*) ac_enablef_mmx=1 ;;
        alpha*) ac_enablef_alpha=1 ;;
        arm*) ac_enablef_armv4l=1 ;;
        sparc*) ac_enablef_sparc=1 ;;
        mips*) ac_enablef_mmi=1 ;;
        ppc*|powerpc*) ac_enablef_powerpc=1 ;;
    esac

    AC_DEFINE_UNQUOTED(ENABLE_MMX, $ac_enablef_mmx, [ffmpeg])
    AC_DEFINE_UNQUOTED(ENABLE_ARMV4L, $ac_enablef_armv4l, [ffmpeg])
    AC_DEFINE_UNQUOTED(ENABLE_MLIB, $ac_enablef_mlib, [ffmpeg])
    AC_DEFINE_UNQUOTED(ENABLE_SPARC, $ac_enablef_sparc, [ffmpeg])
    AC_DEFINE_UNQUOTED(ENABLE_ALPHA, $ac_enablef_alpha, [ffmpeg])
    AC_DEFINE_UNQUOTED(ENABLE_POWERPC, $ac_enablef_powerpc, [ffmpeg])
    AC_DEFINE_UNQUOTED(ENABLE_MMI, $ac_enablef_mmi, [ffmpeg])
    AC_DEFINE_UNQUOTED(ENABLE_SH4, $ac_enablef_sh4, [ffmpeg])
    AC_DEFINE_UNQUOTED(ENABLE_BFIN, $ac_enablef_bfin, [ffmpeg])


    AC_DEFINE(CONFIG_ENCODERS, 1, [ffmpeg Define if you want to build encoders.])
    AC_DEFINE(CONFIG_DECODERS, 1, [ffmpeg Define if you want to build decoders.])
    AC_DEFINE(CONFIG_MUXERS, 1, [ffmpeg Define if you want to build muxers.])
    AC_DEFINE(CONFIG_DEMUXERS, 1, [ffmpeg Define if you want to build demuxers.])

dnl GPL
    AC_ARG_ENABLE(ffmpeg_gpl, [  --disable-ffmpeg-gpl   disable GPL code in ffmpeg. [[enabled]]],
		  [], enable_ffmpeg_gpl=yes)
    if test "$enable_ffmpeg_threads" = yes; then
	AC_DEFINE(CONFIG_GPL, 1, [ffmpeg])
    fi
    AC_DEFINE(RUNTIME_CPUDETECT, 1, [ffmpeg for libpostprocess and libswscale])

dnl SMALL
    AC_ARG_ENABLE(ffmpeg_small, [  --enable-ffmpeg-small   optimize ffmpeg for size. [[disabled]]],
		  [], enable_ffmpeg_small=no)
    if test "$enable_ffmpeg_small" = yes; then
        ac_enablef_small=1
    else
        ac_enablef_small=0
    fi
    AC_DEFINE_UNQUOTED(ENABLE_SMALL, $ac_enablef_small, [ffmpeg])

dnl THREADS
    AC_ARG_ENABLE(ffmpeg_threads, [  --disable-ffmpeg-threads   support threads in ffmpeg. [[enabled]]],
		  [], enable_ffmpeg_threads=yes)
    if test "$enable_ffmpeg_threads" = yes; then
        ac_enablef_threads=1
    else
        ac_enablef_threads=0
    fi
    AC_DEFINE_UNQUOTED(ENABLE_THREADS, $ac_enablef_threads, [ffmpeg])

dnl LIBAC3
    AC_ARG_ENABLE(ffmpeg_a52, [  --disable-ffmpeg-a52    do not build ffmpeg with A52 (AC3) support. [[enabled]]],
		  [], enable_ffmpeg_a52=yes)
    if test "$enable_ffmpeg_a52" = yes; then
        enablef_ac3=1
	AC_DEFINE(CONFIG_LIBA52_DECODER, 1, [ffmpeg Define if you want to use A52 audio decoder.])

	AC_ARG_ENABLE(ffmpeg_a52bin, [  --enable-ffmpeg-a52bin  A52 plugin dlopens liba52.so.0 at runtime [[disabled]]],
		      [], enable_ffmpeg_a52bin=no)
        if test "$enable_ffmpeg_a52bin" = yes; then
            AC_DEFINE(CONFIG_LIBA52BIN, 1, [ffmpeg Define if you want to build with A52 dlopened decoder.])
        fi
    else
        enablef_ac3=0
    fi
    AC_DEFINE_UNQUOTED(ENABLE_LIBA52_DECODER, $enablef_ac3, [ffmpeg Define if you want to use A52 audio decoder.])

dnl DTS
    AC_REQUIRE([AM_PATH_DTS])
    AC_ARG_ENABLE(ffmpeg_dts, [  --disable-ffmpeg-dts    disable DTS support in ffmpeg. [[enabled]]],
                  [], enable_ffmpeg_dts=yes)
    if test "$enable_ffmpeg_dts" = yes -a "$have_dts" = yes; then
        enablef_dts=1
        AC_DEFINE(CONFIG_LIBDTS_DECODER, 1, [ffmpeg Define if you want to build with DTS decoder.])
    else
        enablef_dts=0
    fi
    AC_DEFINE_UNQUOTED(ENABLE_LIBDTS_DECODER, $enablef_dts, [ffmpeg Define if you want to build with DTS decoder.])

dnl DV1394
    AC_ARG_ENABLE(ffmpeg_dv1394, [  --disable-ffmpeg-dv1394 disable ffmpeg DV1394 support. [[enabled]]],
                  [], enable_ffmpeg_dv1394=yes)
    if test "$enable_ffmpeg_dv1394" = yes; then
        enablef_dv1394=1
        AC_DEFINE(CONFIG_DV1394_DEMUXER, 1, [ffmpeg Define if you want to have DV1394 support compiled.])
    else
        enablef_dv1394=0
    fi
    AC_DEFINE_UNQUOTED(ENABLE_DV1394_DEMUXER, $enablef_dv1394, [ffmpeg Define if you want to have DV1394 support compiled.])

dnl DC1394
    AC_ARG_ENABLE(ffmpeg_dc1394, [  --enable-ffmpeg-dc1394 ffmpeg DC1394 support. [[disabled]]],
                  [], enable_ffmpeg_dc1394=no)
    enablef_dc1394=0
    if test "$enable_ffmpeg_dc1394" = yes; then
        AM_PATH_DC1394([
            enablef_dc1394=1
            AC_DEFINE(CONFIG_DC1394_DEMUXER, 1, [ffmpeg Define if you want to have DV1394 demuxer.])
            ], [])
    fi
    AC_DEFINE_UNQUOTED(ENABLE_DC1394_DEMUXER, $enablef_dc1394, [ffmpeg Define if you want to have DV1394 support compiled.])

dnl LIBFAAD
    AC_REQUIRE([AM_PATH_FAAD])
    if test "$have_faad" = yes; then
        enablef_aac=1
dnl fix ffmpeg - MOV.C needs libfaad
        AC_DEFINE(CONFIG_LIBFAAD, 1, [ffmpeg Define if you want to have AAC support compiled.])
        AC_DEFINE(CONFIG_MPEG4AAC_DECODER, 1, [ffmpeg Define if you want to have AAC support compiled.])

        AC_ARG_ENABLE(ffmpeg_faadbin, [  --disable-ffmpeg-faadbin do not build ffmpeg with FAAD bin.support. [[enabled]]],
                      [], enable_ffmpeg_faadbin=yes)
        if test "$enable_ffmpeg_faadbin" = yes; then
            AC_DEFINE(CONFIG_LIBFAADBIN, 1, [ffmpeg Define if you want to build support for runtime linked libfaad.])
        fi
    else
        enablef_aac=0
    fi
    AC_DEFINE_UNQUOTED(ENABLE_LIBFAAD_DECODER, $enablef_aac, [ffmpeg Define if you want to have AAC support compiled.])
    AC_DEFINE_UNQUOTED(ENABLE_MPEG4AAC_DECODER, $enablef_aac, [ffmpeg Define if you want to have AAC support compiled.])


dnl OSS audio
    AC_REQUIRE([AC_CHECK_OSS])
    if test "$enable_oss" = yes; then
        enablef_audio=1
        AC_DEFINE(CONFIG_AUDIO_DEMUXER, 1, [ffmpeg Define if you want to have OSS audio demuxer.])
        AC_DEFINE(CONFIG_AUDIO_MUXER, 1, [ffmpeg Define if you want to have OSS audio muxer.])
    else
        enablef_audio=0
    fi
    AC_DEFINE_UNQUOTED(ENABLE_AUDIO_DEMUXER, $enablef_audio, [ffmpeg Define if you want to have OSS audio demuxer.])
    AC_DEFINE_UNQUOTED(ENABLE_AUDIO_MUXER, $enablef_audio, [ffmpeg Define if you want to have OSS audio muxer.])

dnl UNUSED!!!
    AC_ARG_ENABLE(ffmpeg_pp, [  --disable-ffmpeg-pp     disable postprocessing support in ffmpeg. [[enabled]]],
                  [], enable_ffmpeg_pp=yes)
    if test "$enable_ffmpeg_pp" = yes; then
        AC_DEFINE(CONFIG_PP, 1, [ffmpeg Define if you want to build with PP support.])
    fi

    AC_ARG_ENABLE(ffmpeg_swscaler, [  --enable-ffmpeg-swscaler build ffmpeg with SWScaler. [[disabled]]],
                  [], enable_ffmpeg_swscaler=no)
    if test "$enable_ffmpeg_swscaler" = yes; then
        AC_DEFINE(CONFIG_SWSCALER, 1, [ffmpeg Define if you want to build with SWScaler.])
    fi

    AC_ARG_ENABLE(ffmpeg_mpegaudiohp, [  --disable-ffmpeg-mpegaudiohp build ffmpeg with MPEG HighPrecision. [[enabled]]],
                  [], enable_ffmpeg_mpegaudiohp=yes)
    if test "$enable_ffmpeg_mpegaudiohp" = yes; then
        AC_DEFINE(CONFIG_MPEGAUDIO_HP, 1, [ffmpeg Define if you want to have highprecision mpeg audio support compiled.])
    fi

    AC_REQUIRE([AC_CHECK_V4L])
    if test "$enable_v4l" = yes; then
	AC_DEFINE(CONFIG_VIDEO4LINUX, 1, [ffmpeg Define if you have video4linux device.])
    fi
 
    AC_REQUIRE([AC_CHECK_V4L2])
    if test "$enable_v4l2" = yes; then
	AC_DEFINE(CONFIG_VIDEO4LINUX2, 1, [ffmpeg Define if you have video4linux2 device.])
    fi

    AC_ARG_ENABLE(ffmpeg_network, [  --disable-ffmpeg-network disable network support. [[enabled]]],
                  [], enable_ffmpeg_network=yes)
    if test "$enable_ffmpeg_network" = yes; then
        AC_DEFINE(CONFIG_NETWORK, 1, [ffmpeg Define if you want to build with network support.])
    fi

    AC_CHECK_IPV6([
       if test "$enable_ffmpeg_network" = yes; then
            AC_DEFINE(CONFIG_IPV6, 1, [ffmpeg Define if you want to build with IPv6 support.])
       fi], [])

    AC_ARG_ENABLE(ffmpeg_protocol, [  --disable-ffmpeg-protocol disable ffmpeg protocol support. [[enabled]]],
                  [], enable_ffmpeg_protocol=yes)
    if test "$enable_ffmpeg_protocol" = yes; then
        AC_DEFINE(CONFIG_PROTOCOLS, 1, [ffmpeg Define if you want to build with protocols registered.])
    fi
    
    AC_REQUIRE([AC_FIND_ZLIB])
    if  test "$have_zlib" = yes; then
	AC_DEFINE(CONFIG_ZLIB, 1, [ffmpeg Define if you have z library (-lz)])
    fi

    AC_DEFINE(CONFIG_FFSERVER, 1, [ffmpeg Define if you want to build server.])

    AC_DEFINE(SIMPLE_IDCT, 1, [ffmpeg Define if you want to build with simples idct.])
    AC_DEFINE(HAVE_PTHREADS, 1, [ffmpeg Define if you want to have pthread support compiled.])

    if test -n "$ffmpeg_profiling" ; then
	AC_DEFINE(HAVE_GPROF, 1, [ffmpeg Define if you want to build with gprof support.])
    fi

    test -z "$FFMPEG_CFLAGS" && FFMPEG_CFLAGS="-O4 $DEFAULT_FLAGS"
    FFMPEG_CFLAGS="$FFMPEG_CFLAGS $DEFAULT_DEFINES"

    AC_CHECK_GNU_VECTOR(FFMPEG_SSE="-msse";
		        AC_DEFINE(HAVE_BUILTIN_VECTOR, 1, [ffmpeg Define if your compiler supports vector builtins (MMX).]), [])
    AC_SUBST(FFMPEG_CFLAGS)
    AC_SUBST(FFMPEG_SSE)

dnl ffmpeg_x86opt=
dnl test x$enable_x86opt = xno && ffmpeg_x86opt="--disable-mmx"
dnl AC_MSG_RESULT([=== configuring ffmpeg ===])
dnl    ( cd $srcdir/ffmpeg ; \
dnl      ./configure --prefix=$prefix --cc=$CC \
dnl		$ffmpeg_profiling $ffmpeg_cpu \
dnl		$ffmpeg_x86opt --disable-mp3lib \
dnl		--enable-simple_idct )
])
