#!/bin/sh
# This script file generates necessary defines for ffmpeg compilation
# As it has got a little bit tricky it must be carefully checked 
# which codecs are checked by ffmpeg.m4 file

source_path=ffmpeg
result_file="include/configff.h"

gendefine() {
    prune="$1"
    shift
    for i in "$@"
    do
	test $prune -eq 1 && echo "#define CONFIG_"`echo $i | tr a-z A-Z`" $prune"
        echo "#define ENABLE_"`echo $i | tr a-z A-Z`" $prune"
    done
}

prune() {
    pattern="$1"
    shift
    echo "$@" | sed "s%\\<$pattern\\>%%g"
}

haspattern() {
    pattern="$1"
    shift
    echo "$@" | grep $pattern >/dev/null
}

createlist() {

ENCODER_LIST=`sed -n 's/^[^#]*ENC.*, *\(.*\)).*/\1_encoder/p' "$source_path/libavcodec/allcodecs.c"`
DECODER_LIST=`sed -n 's/^[^#]*DEC.*, *\(.*\)).*/\1_decoder/p' "$source_path/libavcodec/allcodecs.c"`
PARSER_LIST=`sed -n 's/^[^#]*PARSER.*, *\(.*\)).*/\1_parser/p' "$source_path/libavcodec/allcodecs.c"`
BSF_LIST=`sed -n 's/^[^#]*BSF.*(.*, *\(.*\)).*/\1_bsf/p' "$source_path/libavcodec/allcodecs.c"`
MUXER_LIST=`sed -n 's/^[^#]*_MUX.*, *\(.*\)).*/\1_muxer/p' "$source_path/libavformat/allformats.c"`
DEMUXER_LIST=`sed -n 's/^[^#]*DEMUX.*, *\(.*\)).*/\1_demuxer/p' "$source_path/libavformat/allformats.c"`
PROTOCOL_LIST=`sed -n 's/^[^#]*PROTOCOL.*, *\(.*\)).*/\1_protocol/p' "$source_path/libavformat/allformats.c"`

#echo $BSF_LIST
DETECT_ENCODER=""
PRUNE_ENCODER="$DETECT_ENCODER libfaac libamr_nb libamr_wb libgsm libgsm_ms libmp3lame oggvorbis libvorbis libxvid libx264 snow libtheora"
DETECT_DECODER="liba52 libfaad mpeg4aac"
PRUNE_DECODER="$DETECT_DECODER libamr_nb libamr_wb libgsm libgsm_ms oggvorbis libvorbis libxvid xvmc mpeg_xvmc snow"
DETECT_PARSER=""
PRUNE_PARSER="$DETECT_PARSER"
DETECT_BSF=""
PRUNE_BSF="$DETECT_BSF"
DETECT_MUXER="audio"
PRUNE_MUXER="$DETECT_MUXER libnut ogg"
DETECT_DEMUXER="audio dc1394 dv1394"
PRUNE_DEMUXER="$DETECT_DEMUXER libnut ogg video_grab_bktr"
DETECT_PROTOCOL=""
PRUNE_PROTOCOL="$DETECT_PROTOCOL"

for i in $PRUNE_ENCODER; do
    ENCODER_LIST=`prune ${i}_encoder $ENCODER_LIST`
    haspattern $i $DETECT_ENCODER || ENCODER_PRUNE="$ENCODER_PRUNE ${i}_encoder"
done

for i in $PRUNE_DECODER; do
    DECODER_LIST=`prune ${i}_decoder $DECODER_LIST`
    haspattern $i $DETECT_DECODER || DECODER_PRUNE="$DECODER_PRUNE ${i}_decoder"
done

for i in $PRUNE_PARSER; do
    PARSER_LIST=`prune ${i}_parser $PARSER_LIST`
    haspattern $i $DETECT_PARSER || PARSER_PRUNE="$PARSER_PRUNE ${i}_parser"
done

for i in $PRUNE_BSF; do
    BSF_LIST=`prune ${i}_bsf $BSF_LIST`
    haspattern $i $DETECT_BSF || BSF_PRUNE="$BSF_PRUNE ${i}_bsf"
done

for i in $PRUNE_MUXER; do
    MUXER_LIST=`prune ${i}_muxer $MUXER_LIST`
    haspattern $i $DETECT_MUXER || MUXER_PRUNE="$MUXER_PRUNE ${i}_muxer"
done

for i in $PRUNE_DEMUXER; do
    DEMUXER_LIST=`prune ${i}_demuxer $DEMUXER_LIST`
    haspattern $i $DETECT_DEMUXER || DEMUXER_PRUNE="$DEMUXER_PRUNE ${i}_demuxer"
done

for i in $PRUNE_PROTOCOL; do
    PROTOCOL_LIST=`prune ${i}_protocol $PROTOCOL_LIST`
    haspattern $i $DETECT_PROTOCOL || PROTOCOL_PRUNE="$PROTOCOL_PRUNE ${i}_protocol"
done

cat <<_ACEOF
/*
 * This file is generated by admin/gendefs.sh script 
 * do not modify it by hand!
 */

_ACEOF

gendefine 1 $DECODER_LIST
gendefine 0 $DECODER_PRUNE

gendefine 1 $DEMUXER_LIST
gendefine 0 $DEMUXER_PRUNE

gendefine 1 $PARSER_LIST
gendefine 0 $PARSER_PRUNE

gendefine 1 $BSF_LIST
gendefine 0 $BSF_PRUNE

gendefine 1 $ENCODER_LIST
gendefine 0 $ENCODER_PRUNE

gendefine 1 $MUXER_LIST
gendefine 0 $MUXER_PRUNE

gendefine 1 $PROTOCOL_LIST
gendefine 0 $PROTOCOL_PRUNE

echo

}

echo -n "Creating list of $result_file, wait..."
createlist >$result_file
echo "done"

