
#include "include/settings.h"
extern "C"
{
  #include <audacious/configdb.h>
}

#define CUBE_CONFIG_TAG "cube"

static ConfigDb *GetConfigFile( void )
{
  ConfigDb *cfg = bmp_cfg_db_open();
  return cfg;
}

bool LoadSettings(LPSETTINGS pSettings)
{
  bool bRet;
  ConfigDb *cfg = GetConfigFile();
  if (!cfg)
    return false;
  
  bRet = (bmp_cfg_db_get_int(cfg,CUBE_CONFIG_TAG,"looptimes",&pSettings->looptimes) && 
	  bmp_cfg_db_get_int(cfg,CUBE_CONFIG_TAG,"fadelength",&pSettings->fadelength) &&
	  bmp_cfg_db_get_int(cfg,CUBE_CONFIG_TAG,"fadedelay",&pSettings->fadedelay) &&
	  bmp_cfg_db_get_int(cfg,CUBE_CONFIG_TAG,"adxonechan",(int*)&pSettings->ADXChannel) &&
	  bmp_cfg_db_get_int(cfg,CUBE_CONFIG_TAG,"adxvolume",(int*)&pSettings->ADXVolume));
  
  bmp_cfg_db_close(cfg); 
  return bRet;
}

bool SaveSettings(LPSETTINGS pSettings)
{
  ConfigDb *cfg = GetConfigFile();
  if (!cfg)
    return false;

  bmp_cfg_db_set_int(cfg,CUBE_CONFIG_TAG,"looptimes",pSettings->looptimes);
  bmp_cfg_db_set_int(cfg,CUBE_CONFIG_TAG,"fadelength",pSettings->fadelength);
  bmp_cfg_db_set_int(cfg,CUBE_CONFIG_TAG,"fadedelay",pSettings->fadedelay);
  bmp_cfg_db_set_int(cfg,CUBE_CONFIG_TAG,"adxonechan",pSettings->ADXChannel);
  bmp_cfg_db_set_int(cfg,CUBE_CONFIG_TAG,"adxvolume",pSettings->ADXVolume);

  bmp_cfg_db_close(cfg);
  return true;
}
