/****************************************************************
**
** Attal : Lords of Doom
**
** propertiesCreature.cpp
** Allow selection of specific creature panels
**
** Author(s) : Nickolay Semenov
**
** Date : 18/06/2003
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "propertiesCreature.h"

// generic include files
// include files for QT
#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
// application specific include files
#include "libClient/gui.h"
#include "libClient/imageTheme.h"
#include "libCommon/genericMapCreature.h"

extern ImageTheme ImageTheme;

PropertiesCreature::PropertiesCreature (QWidget * parent, const char * name)
    :QDialog (parent, name, true)
{
	_creatureStacks.setAutoDelete( false );
	_creaturePix = new QLabel( this );

	_creatureBehaviour = new AskCombo( tr( "Behaviour of Creatures: " ), this );
	_creatureBehaviour->insertItem( GenericMapCreature::getBehaviourString( GenericMapCreature::Obedient ) );
	_creatureBehaviour->insertItem( GenericMapCreature::getBehaviourString( GenericMapCreature::Friendly ) );
	_creatureBehaviour->insertItem( GenericMapCreature::getBehaviourString( GenericMapCreature::Neutral ) );
	_creatureBehaviour->insertItem( GenericMapCreature::getBehaviourString( GenericMapCreature::Aggressive ) );
	_creatureBehaviour->insertItem( GenericMapCreature::getBehaviourString( GenericMapCreature::Hostile ) );

	_creatureFlee = new AskBool( tr( "Never flee: " ), this );
	_lookingRight = new AskBool( tr( "Looking at right side: " ), this );

	QVBoxLayout * layV1 = new QVBoxLayout();
	layV1->setMargin( 5 );
	layV1->addWidget( _creaturePix, 1 );
	layV1->addSpacing( 10 );
	layV1->addWidget( _creatureBehaviour, 1 );
	layV1->addWidget( _creatureFlee, 1 );
	layV1->addWidget( _lookingRight, 1 );

	QVBoxLayout * layV2 = new QVBoxLayout();
	layV2->setMargin( 5 );
	layV2->setSpacing( 5 );
	layV2->addStretch( 1 );
	AskInt * stack;
	QString label;
	_creatureStacks.resize( MAX_UNIT );
	for( uint i = 0; i < MAX_UNIT; i++ ) {
		label.sprintf( tr( "Number of creatures in stack %d: " ), i );
		stack = new AskInt( label, this );
		stack->setMinValue( 0 );
		stack->setMaxValue( 10000 );
		layV2->addWidget( stack );
		layV2->addStretch( 1 );
		_creatureStacks.insert( i, stack );
	}

	QHBoxLayout * layH1 = new QHBoxLayout();
	layH1->setSpacing( 5 );
	layH1->setMargin( 5 );
	layH1->addLayout( layV1, 1 );
	layH1->addLayout( layV2, 1 );

	QPushButton * butOk = new QPushButton( this );
	butOk->setText( tr( "Ok" ) );
	FIXEDSIZE( butOk );

	QPushButton * butCan = new QPushButton( this );
	butCan->setText( tr( "Cancel" ) );
	FIXEDSIZE( butCan );

	QHBoxLayout * layH2 = new QHBoxLayout();
	layH2->setMargin( 5 );
	layH2->setSpacing( 5 );
	layH2->addStretch( 1 );
	layH2->addWidget( butOk );
	layH2->addStretch( 1 );
	layH2->addWidget( butCan );
	layH2->addStretch( 1 );

	QVBoxLayout * layout = new QVBoxLayout( this );
	layout->setMargin( 5 );
	layout->setSpacing( 5 );
	layout->addLayout( layH1, 1 );
	layout->addLayout( layH2 );
	layout->activate();

	connect( butOk, SIGNAL( clicked() ), this, SLOT( slotAccept() ) );
	connect( butCan, SIGNAL( clicked() ), this, SLOT( reject() ) );
}

void PropertiesCreature::init( GenericMapCreature * creature )
{
	_creature = creature;
	_creaturePix->setPixmap( * ImageTheme.getMapCreature( creature ) );
	_creatureBehaviour->setCurrentItem( (int)creature->getBehaviour() );
	_creatureFlee->setValue( ! creature->isFleeing() );
	_lookingRight->setValue( creature->isLookingRight() );
	for( uint i = 0; i < MAX_UNIT; i++ ) {
		_creatureStacks[i]->setValue( creature->getStack( i ) );
	}
}

void PropertiesCreature::slotAccept()
{
	_creature->setBehaviour( (GenericMapCreature::CreatureBehaviour)_creatureBehaviour->currentItem() );
	_creature->setFleeing( ! _creatureFlee->getValue() );
	_creature->setLookingRight( _lookingRight->getValue() );
	for( uint i = 0; i < MAX_UNIT; i++ ) {
		_creature->setStack( i, _creatureStacks[i]->getValue() );
	}
	accept();
}
