/****************************************************************
**
** Attal : Lords of Doom
**
** propertiesBuilding.cpp
** Defines properties box for buildings on map
**
** Version : $Id: propertiesBuilding.cpp,v 1.3 2004/07/31 19:29:47 audoux Exp $
**
** Author(s) : Sardi Carlo - Pascal Audoux
**
** Date : 22/04/2004
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "propertiesBuilding.h"

// generic include files
// include files for QT
#include <qcombobox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlistbox.h>
// application specific include files
#include "libCommon/genericLord.h"
#include "libCommon/genericPlayer.h"
#include "libCommon/dataTheme.h"
#include "libClient/gui.h"
#include "libCommon/action.h"

extern DataTheme DataTheme;


//
// ----- propertiesBuilding -----
//

PropertiesBuilding::PropertiesBuilding( QPtrList<GenericPlayer> * players, QWidget * parent, const char * name )
	: QDialog( parent, name, true )
{
        setCaption( tr( "building properties" ) );
	_building = 0;

	QLabel * ownerLabel = new QLabel( this );
	ownerLabel->setText( tr( "Owner:" ) );

	_name = new QLabel( this );
	
	_ownerList = new QComboBox( this );
	refresh( players );

	_listBuilding = new QListBox( this );

	QPushButton * pb = new QPushButton( this );
	pb->setText( tr( "Ok" ) );
	FIXEDSIZE( pb );

	QHBoxLayout * layH1 = new QHBoxLayout();
	layH1->setSpacing( 5 );
	layH1->addWidget( ownerLabel );
	layH1->addWidget( _ownerList, 1 );

	QHBoxLayout * layH2 = new QHBoxLayout();
	layH2->setSpacing( 5 );
	layH2->addWidget( _listBuilding, 1 );

	QHBoxLayout * layH = new QHBoxLayout();
	layH->setMargin( 5 );
	layH->addStretch( 1 );
	layH->addWidget( pb );

	QVBoxLayout * layout = new QVBoxLayout( this );
	layout->setMargin( 5 );
	layout->setSpacing( 5 );
	layout->addLayout( layH1 );
	layout->addStretch( 1 );
	layout->addWidget( _name );
	layout->addLayout( layH2, 1 );
	layout->addLayout( layH );
	layout->activate();

	connect( pb, SIGNAL( clicked() ), SLOT( slot_accept() ) );
	connect( _ownerList, SIGNAL( activated( int ) ), SLOT( slot_owner( int ) ) );
}

void PropertiesBuilding::refresh( QPtrList<GenericPlayer> * players )
{
	_players = players;
	_ownerList->clear();
	_ownerList->insertItem( tr( "None" ) );
	
	for( uint i = 0; i < players->count(); i++ ) {
		GenericPlayer * player = players->at( i );
		if( player ) {
			_ownerList->insertItem( player->getName() );
		}
	}
}


void PropertiesBuilding::slot_accept()
{
	accept();
}

void PropertiesBuilding::slot_owner( int num )
{
	if( _building->getOwner() ) {
		_building->getOwner()->removeBuilding( _building );
	}
	if( num == 0 ) {
		_building->setOwner( 0 );
	} else {
		_building->setOwner( _players->at( num-1 ) );
		_players->at( num-1 )->addBuilding( _building );
	}
}

void PropertiesBuilding::init( GenericBuilding * building )
{
	_building = building;
	_listBuilding->clear();
	_name->setText( _building->getName() );
	for (int  type = Action::DATE; type<= Action::NEXTTIME; type++){
		QPtrList<Action>  action = _building->getActionList((Action::ActionType) type);
		if(action.count()){
			switch( (Action::ActionType) type)  {
				case Action::DATE:
					{
						QString tmp = "Date ";
						_listBuilding->insertItem(tmp);
					}
					break;
				case Action::FIRSTTIME:
					{
						QString tmp = "First time ";
						_listBuilding->insertItem(tmp);
					}
					break;
				case Action::FIRSTTIMELORD:
					{
						QString tmp = "First time lord ";
						_listBuilding->insertItem(tmp);
					}
					break;
				case Action::NEXTTIME:
					{
						QString tmp = "Next time ";
						_listBuilding->insertItem(tmp);
					}
					break;
				default:
					break;
			}
		}
		for( uint i = 0; i < action.count(); i++ ) {
			for( int j = 0; j < action.at(i)->getElementaryNumber(); j++ ) {
				ElementaryAction * elementary = action.at(i)->getElementaryAction( j );
				switch( elementary->getType() ) {
					case ElementaryAction::ATTACK:
						{
							QString tmp = _building->getName().append(" add %1 ").arg(elementary->getCoeff()).append("Attack ");
							_listBuilding->insertItem(tmp);
						}
						break;
					case ElementaryAction::DEFENSE:
						{
							QString tmp = _building->getName().append(" add %1 ").arg(elementary->getCoeff()).append("Defense ");
							_listBuilding->insertItem(tmp);
						}
						break;
					case ElementaryAction::POWER:
						{
							QString tmp = _building->getName().append(" add %1 ").arg(elementary->getCoeff()).append("Power ");
							_listBuilding->insertItem(tmp);
						}
						break;
					case ElementaryAction::KNOWLEDGE:
						{
							QString tmp = _building->getName().append(" add %1 ").arg(elementary->getCoeff()).append("Knowledge ");
							_listBuilding->insertItem(tmp);
						}
						break;
					case ElementaryAction::MOVE:
						{
							QString tmp = _building->getName().append(" add %1 ").arg(elementary->getCoeff()).append("Move ");
							_listBuilding->insertItem(tmp);
						}
						break;
					case ElementaryAction::MAXMOVE:
						{
							QString tmp = _building->getName().append(" add %1 ").arg(elementary->getCoeff()).append("MaxMove ");
							_listBuilding->insertItem(tmp);
						}
						break;
					case ElementaryAction::TECHNICPOINT:
						{
							QString tmp = _building->getName().append(" add %1 ").arg(elementary->getCoeff()).append("TechPoint ");
							_listBuilding->insertItem(tmp);
						}
						break;
					case ElementaryAction::MAXTECHNICPOINT:
						{
							QString tmp = _building->getName().append(" add %1 ").arg(elementary->getCoeff()).append("MaxTechPoint ");
							_listBuilding->insertItem(tmp);
						}
						break;
					case ElementaryAction::MORALE:
						{
							QString tmp = _building->getName().append(" add %1 ").arg(elementary->getCoeff()).append("Morale ");
							_listBuilding->insertItem(tmp);
						}
						break;
					case ElementaryAction::LUCK:
						{
							QString tmp = _building->getName().append(" add %1 ").arg(elementary->getCoeff()).append("Luck ");
							_listBuilding->insertItem(tmp);
						}
						break;
					case ElementaryAction::VISION:
						{
							QString tmp = _building->getName().append(" add %1 ").arg(elementary->getCoeff()).append("Vision ");
							_listBuilding->insertItem(tmp);
						}
						break;
					case ElementaryAction::EXPERIENCE:
						{
							QString tmp = _building->getName().append(" add %1 ").arg(elementary->getCoeff()).append("Experience ");
							_listBuilding->insertItem(tmp);
						}
						break;
					case ElementaryAction::SKILL:
						break;
					case ElementaryAction::ARTEFACT:
						break;
					case ElementaryAction::UNIT:
						break;				
					case ElementaryAction::RESSOURCE:
						{
							QString tmp1 =DataTheme.resources.getRessource(elementary->getArg());
							QString tmp2 = _building->getName().append(" give %1").arg(elementary->getCoeff()).append(" ").append(tmp1);
							_listBuilding->insertItem(tmp2);
						}

						break;
					case ElementaryAction::RANDRESSOURCE:
						{
							QString tmp3 =DataTheme.resources.getRessource(elementary->getArg());
							QString tmp4 = _building->getName().append(" give between %1 and %2").arg(elementary->getCoeff()-1).arg(elementary->getCoeff()+1).append(" ").append(tmp3);
							_listBuilding->insertItem(tmp4);
						}
						break;
					default:
						break;
				}
			}
		}
	}

	if( _building->getOwner() ) {
		_ownerList->setCurrentItem( _building->getOwner()->getNum()+1 );
	} else {
		_ownerList->setCurrentItem( 0 );
	}
}




