/****************************************************************
**
** Attal : Lords of Doom
**
** graphicalCell.cpp
** this class draws an animated cell
**
** Version : $Id: graphicalCell.cpp,v 1.5 2004/07/31 19:29:46 audoux Exp $
**
** Author(s) : Pascal Audoux - Cyrille Verrier
**
** Date : 02/08/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "graphicalCell.h"

// generic include files
// include files for QT
#include <qapplication.h>
#include <qcanvas.h>
#include <qcolor.h>
#include <qpointarray.h>
// application specific include
#include "libClient/cell.h"
#include "libClient/imageTheme.h"

#include "libCommon/dataTheme.h"
#include "libCommon/genericDecoration.h"
#include "libCommon/log.h"

#include "conf.h"

/** size in pixel of a cell */
const int GraphicalCell::_size = 30 ;

/** rtti number for GraphicalCell class */
const int GraphicalCell::RTTI = 2345;

extern QString IMAGE_PATH;
extern ImageTheme ImageTheme;
extern DataTheme DataTheme;


//
// ----- GraphicalCell -----
//

/** create an animated cell from pixmaps at position row,col */
GraphicalCell::GraphicalCell( int row, int col , QCanvas *canvas)
	: QCanvasSprite( ImageTheme.cells[0], canvas )
{
	collisions( true );
	setFrame( 0 );
	move( _size*col, _size*row );
	setZ( CAN_GROUND );
	show();
}

GraphicalCell::~GraphicalCell()
{

}

void GraphicalCell::setType( int type )
{
	setSequence( ImageTheme.cells[type] );
	setFrame( 0 );
}

void GraphicalCell::setDiversification( uint divers )
{
	setFrame( divers );
}

/** return if a point is on the cell */
bool GraphicalCell::hit( const QPoint &p ) const
{
	return boundingRect().contains( p );
}

//
// ----- Transition -----
//

Transition::Transition( Cell * parent, QCanvas *canvas)
	: GraphicalCell( parent->getRow(), parent->getCol(), canvas )
{
	_parent = parent;
}

void Transition::setTransition( int transition, int type )
{
	setZ( CAN_TRANS );

	// XXX: Ugly
	if( type == 0) {
		type = 1;
	}
	setSequence( ImageTheme.transition[type-1] );
	
	setFrame( transition - 1 );	
}

//
// ----- Decoration -----
//

Decoration::Decoration( Cell * parent, QCanvas *canvas)
	: GraphicalCell( parent->getRow(), parent->getCol(), canvas )
{
	_parent = parent;
	setZ( CAN_DECO );
	setSequence( ImageTheme.decoration );
	setFrame( 0 );
}

void Decoration::setDecoration( int decoration )
{
	setFrame( decoration - 1 );

	GenericDecoration * decor = DataTheme.decorations.at( decoration - 1 );
	if( ( decor->getWidth() > 1 ) || ( decor->getHeight() > 1 ) ) {
		int offsetRow = decor->getHeight() - ( 1 + decor->getDoorRow() );
		int offsetCol = 0 - decor->getDoorCol();

		QRect rect = _parent->boundingRect();
		move( rect.x() + ( offsetCol * rect.width() ),
		rect.y() + rect.height() - boundingRect().height() + ( offsetRow * rect.height() ) );

		canvas()->update();
	}
}
