/****************************************************************
**
** Attal : Lords of Doom
**
** clientInterface.h
** Manages the whole game
**
** Version : $Id: clientInterface.h,v 1.14 2004/09/12 15:06:28 lusum Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 17/08/2000
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/


#ifndef CLIENTINTERFACE_H
#define CLIENTINTERFACE_H

// include files for QT
#include <qapplication.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qmainwindow.h>
#include <qptrvector.h>
#include <qstring.h>
// application specific includes
#include "libCommon/genericBuilding.h"
#include "libClient/player.h"
#include "libClient/game.h"
#include "libClient/gui.h"


class QAction;
class QPopupMenu;

class AttalSocket;
class DisplayBase;
class Fight;
class GainLevel;
class GenericLord;
class ConfigConnection;

/*              ------------------------------
 *                      ClientInterface
 *              ------------------------------ */


/** comment for the class */
class ClientInterface : public QMainWindow
{
	Q_OBJECT
public:
	/** Constructor */
	ClientInterface();

	/** Destructor */
	~ClientInterface();

public slots:
	/** Slot for managing 'actions' */
	void slot_action( int num );

	/** Slot for writing in the StatusBar */
	void slot_status( const QString & text );

	/** Slot for reading the socket */
	void slot_readSocket();
	
	/** when connection is closed by server **/
	void slot_connectionClosed();
	
	void slot_hostfound();
	
	/** manage connection's errors **/
	void slot_error(int e);

	/** Slot for displaying the base */
	void slot_base( GenericBase * base );

	/** Slot for quitting the base */
	void slot_map();

	/** Slot for beginning fight */
	void slot_fight( GenericLord * lord, CLASS_FIGHTER cla );

protected:
	void closeEvent( QCloseEvent* );

private:
	enum MENU_ACTIONS {
		ACTION_CONNECT = 0,
		ACTION_FASTCONNECT ,
		ACTION_DISCONNECT,
		ACTION_MINIMAP,
		ACTION_TAB,
		ACTION_FULL,
		ACTION_QUIT,

		NB_ACTIONS
	};

	enum StateGame {
		SG_MAP,
		SG_FIGHT,
		SG_BASE
	};

	enum choice	{ 
		END_GAME,
		QUIT_GAME
	};

	/** Define menus */
	void initMenuBar();

	/** Define statusBar */
	void initStatusBar();

	void initActions();

	/** Manage socket SO_FIGHT */
	void socketFight();

	/** Manage socket QR */
	void socketQR();

	void showFightResults( char result );

	void updateUnits();

	void actionConnect(bool fast);
	
	void actionFastConnect();

	void actionDisconnect(int choice);

	void actionMinimap();
	
	void actionTab();
	
	void actionFullScreen();

	void actionQuit();

	Game * _game;
	Fight * _fight;
	DisplayBase * _base;
	AttalSocket * _socket;
	GainLevel * _level;
	ConfigConnection * _config;
	bool _mini;
	bool _tab,_full;
	QPtrVector<QAction> _actions;

	StateGame _state;
};

/** Dialog for configuring connection to server */
class ConfigConnection : public QDialog
{
	Q_OBJECT
public:
	/** Constructor */
	ConfigConnection( QWidget * parent = 0, const char * name = 0 );

	/** Setting hostname */
	void setHost( QString host ) { _host->setText( host ); }

	/** Getting hostname */
	QString getHost() { return _host->text(); }

	int getPort() { return _port->text().toInt(); }

	/** Setting port number */
	void setPort( int port ) { _port->setText( QString::number( port ) ); }

	/** Getting player's name */
	QString getPlayerName() { return _name->text(); }

	/** Setting player's name */
	void setPlayerName( QString name ) { _name->setText( name ); }
	
	void accept() { QDialog::accept(); }

private:
	QLineEdit * _host, * _port, * _name;
};

#endif // CLIENTINTERFACE_H
