/****************************************************************
**
** Attal : Lords of Doom
**
** aiInterface.h
** interface for the ai-client
**
** Version : $Id: aiInterface.h,v 1.8 2004/09/25 19:50:49 lusum Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 05/02/2001
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/


#ifndef AIINTERFACE_H
#define AIINTERFACE_H

// generic include files
#include <stdio.h>
// include files for QT
#include <qdialog.h>
#include <qlineedit.h>
#include <qmainwindow.h>
#include <qptrvector.h>
#include <qstring.h>
// application specific include files

class QAction;
class QMultiLineEdit;
class QPopupMenu;
class AttalSocket;
class Analyst;
class ConfigConnection;

enum IALogLevel {
	LOG_VERBOSE,
	LOG_NORMAL,
	LOG_CRITICAL,
	LOG_QUIET
};


/*              ------------------------------
 *                         Interface
 *              ------------------------------ */


/** comment for the class */
class AiInterface : public QMainWindow
{
	Q_OBJECT
public:
	/** Constructor */
	AiInterface();

	/** Destructor */
	virtual ~AiInterface();

public slots:
	/** Slot managing 'File' menu */
	void slot_action( int num );

	/** Slot managing 'Log' sub-menu */
	void slot_menuLogActivated( int num );

	/** Slot for reading sockets */
	void slot_readSocket();
	
	void slot_connectionClosed();
	
	void slot_error(int e);
	
	void slot_log( QString msg );

private:
	enum MENU_ACTIONS {
		ACTION_CONNECT=0,
		ACTION_DISCONNECT,
		ACTION_QUIT,

		NB_ACTIONS
	};

	/** Defines menus */
	void initMenuBar();

	/** Defines statusBar */
	void initStatusBar();

	/** Defines actions */
	void initActions();

	void actionConnect(bool fast);

	void actionDisconnect();

	void actionQuit();

	QPopupMenu * _menuLog;
	QMultiLineEdit * _edit;
	AttalSocket * _socket;
	Analyst * _analyst;
	QPtrVector<QAction> _actions;
	ConfigConnection * _config;
};

/** Dialog for configuring connection to server */
class ConfigConnection : public QDialog
{
	Q_OBJECT
public:
	/** Constructor */
	ConfigConnection( QWidget * parent = 0, const char * name = 0 );

	/** Setting hostname */
	void setHost( QString host ) { _host->setText( host ); }

	/** Getting hostname */
	QString getHost() { return _host->text(); }

	int getPort() { return _port->text().toInt(); }

	/** Setting port number */
	void setPort( int port ) { _port->setText( QString::number( port ) ); }

	/** Getting player's name */
	QString getPlayerName() { return _name->text(); }

	/** Setting player's name */
	void setPlayerName( QString name ) { _name->setText( name ); }
	
	void accept() { QDialog::accept(); }

private:
	QLineEdit * _host, * _port, * _name;
};

#define FIXEDSIZE( wid ) (wid)->setFixedSize( (wid)->sizeHint() )


/** Log function for the IA */
#ifdef WIN32
void ialog( char * cformat, ... );
#define ialogV ialog
#define ialogN ialog
#define ialogC ialog

#else
void ialog( IALogLevel level, char *fmt, ... );
#define ialogV( format, args... ) ialog( LOG_VERBOSE, format, ## args )
#define ialogN( format, args... ) ialog( LOG_NORMAL, format, ## args )
#define ialogC( format, args... ) ialog( LOG_CRITICAL, format, ## args )
#endif // WIN32

#endif // INTERFACE_H
