/****************************************************************
**
** Attal : Lords of Doom
**
** serverInterface.cpp
** interface for the server
**
** Version : $Id: serverInterface.cpp,v 1.3 2004/02/14 19:29:44 lusum Exp $
**
** Author(s) : Pascal Audoux - Carlo
**
** Date : 01/11/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/


#include "serverInterface.h"

#include <stdlib.h>
// include files for QT
#include <qapplication.h>
#include <qmenubar.h>
#include <qstatusbar.h>
#include <qpopupmenu.h>
#include <qmessagebox.h>
#include <qfiledialog.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qvbuttongroup.h>
#include <qhbuttongroup.h>
#include <qlistview.h>
#include <qpushbutton.h>
// application specific includes
#include "conf.h"
#include "libCommon/log.h"
#include "libCommon/dataTheme.h"
#include "libClient/gui.h"

extern DataTheme DataTheme;
extern QString DATA_PATH;
extern QString SCENAR_PATH;

#define CLIENT

/** add comments here */
ServerInterface::ServerInterface()
	:QMainWindow()
{
	setCaption( tr( "Attal - Lords of Doom (Server)" ) );
	initMenuBar();
	initStatusBar();
	DataTheme.init();

	_widget = new ServerWidget( this );
	setCentralWidget( _widget );

	connect( _widget, SIGNAL( sig_stop() ), SLOT( slot_stop() ) );
	connect( _widget, SIGNAL( sig_load( QString ) ), SLOT( slot_load( QString ) ) );
	connect( _widget, SIGNAL( sig_save() ), SLOT( slot_save() ) );

	_config = 0;

	if( !init() ) {
		logDD( "quit" );
		//XXX ugly hack, but qApp->quit() seem not work in constructor
		exit(0);
	}

	setMinimumSize( 350, 200 );
	
}


bool ServerInterface::init()
{
	bool ret = false;
	_config = new ConfigConnection( this );
	_config->setHost( "localhost" );
	_config->setPort( ATTAL_PORT );
	if( _config->exec() ) {
		_server = new AttalServer( _config->getPort() );
		if( _server->ok() ) {
			ret = true;
			_engine = new Engine( _server );
			_server->setEngine( _engine );
			connect( _engine, SIGNAL( sig_newPlayer( AttalPlayerSocket * ) ), _widget, SLOT( slot_newPlayer( AttalPlayerSocket * ) ) );
			connect( _server, SIGNAL( sig_endConnection( QString ) ), _widget, SLOT( slot_endConnection( QString ) ) );
		} else {
			delete _server;
			_server = 0;
			if( QMessageBox::warning( this,
						tr( "Server error" ),
						tr( "Could not listen for sockets." ),
						tr( "Try again" ),
						tr( "Quit" ),
						0, 0, 1 )  == 0 ) {
				ret = init();
			} else {
				ret = false;
			}
		}
	} 

	delete _config;
	_config = 0;
	return ret;
}

void ServerInterface::initStatusBar()
{
	statusBar()->message( tr( "Status Bar" ), 0 );
}

/*!
  define menus
*/

void ServerInterface::initMenuBar()
{
	QPopupMenu * menuFile = new QPopupMenu();
	CHECK_PTR( menuFile );
	menuFile->insertItem( tr( "Load Game" ), FIL_LOAD );
	menuFile->insertItem( tr( "Save Game" ), FIL_SAVE );
	menuFile->insertItem( tr( "End Game" ), FIL_END );
	menuFile->insertItem( tr( "Quit" ), FIL_QUIT );
	connect( menuFile, SIGNAL( activated( int ) ), this, SLOT( slot_menuFileActivated( int ) ) );

	menuBar()->insertItem( tr( "&File" ), menuFile );
}

void ServerInterface::slot_menuFileActivated( int num )
{
	switch( num ) {
	case FIL_LOAD:{
		QString filename;
		filename = QFileDialog::getOpenFileName( "", "*.scn", this );
		slot_load( filename );
		break;
	}
	case FIL_SAVE:
		slot_save();
		break;
	case FIL_END:
		slot_stop();
		break;
	case FIL_QUIT:
		qApp->quit();
	}
}

void ServerInterface::slot_status( QString text )
{
	statusBar()->message( text, 0 );
}

void ServerInterface::slot_stop()
{
	_engine->endGame();
	_widget->setGameLoaded( false );
}

void ServerInterface::slot_load( QString filename )
{
	if( ( _server->getNbSocket() > 0 ) && ( !filename.isNull() ) ) {
		if( _engine->loadGame( filename ) ) {
			_engine->startGame();
			_widget->setGameLoaded( true );
		}
	}
}

void ServerInterface::slot_save()
{
	QString filename;
	filename = QFileDialog::getSaveFileName( "", "*.gam", this );
	if (!filename.isNull()) {
		_engine->saveGame( filename );
	}
}

//
// ----- ChooseFileRadioButton -----
//

ChooseFileRadioButton::ChooseFileRadioButton( QWidget * parent, const char * name )
	:QRadioButton( parent, name )
{
	QHBoxLayout * layout = new QHBoxLayout( this );
	layout->addSpacing( 20 );
	
	_edit = new QLineEdit( this );
	layout->addWidget( _edit, 1 );
	layout->addSpacing( 10 );
	
	_choose = new QPushButton( this );
	_choose->setText( tr( "Choose" ) );
	FIXEDSIZE( _choose );
	layout->addWidget( _choose );
	
	layout->activate();
	
	connect( _choose, SIGNAL( clicked() ), SLOT( slot_choose() ) );
	connect( this, SIGNAL( toggled( bool ) ), SLOT( slot_toggle( bool ) ) );
	setFixedHeight( _choose->size().height() + 4 );
}

void ChooseFileRadioButton::slot_choose()
{
	QString filename = QFileDialog::getOpenFileName( "", "*.scn", this ); 
	if( ! filename.isNull() ) {
		_edit->setText( filename );
	}
}

void ChooseFileRadioButton::slot_toggle( bool st )
{
	_choose->setEnabled( st );
	_edit->setEnabled( st );
}

//
// ----- ServerWidget -----
//

ServerWidget::ServerWidget( QWidget * parent, const char * name )
	: QWidget( parent, name )
{
	_group = new QVButtonGroup( this );

	QRadioButton * radio1 = new QRadioButton( _group );
	radio1->setText( "Demo 1 player" );
	radio1->setChecked( true );

	QRadioButton * radio2 = new QRadioButton( _group );
	radio2->setText( "Demo 2 players" );

	_radio3 = new ChooseFileRadioButton( _group );
	_radio3->slot_toggle( false );

	_playerList = new QListView( this );
	_playerList->addColumn( tr( "Name" ) );
	_playerList->addColumn( tr( "Address" ) );
	_playerList->setMinimumHeight( 50 );

	_groupBottom = new QHButtonGroup( this );

	QPushButton * butStart = new QPushButton( _groupBottom );
	butStart->setText( tr( "Start" ) );
	FIXEDSIZE( butStart );

	QPushButton * butStop = new QPushButton( _groupBottom );
	butStop->setText( tr( "Save" ) );
	FIXEDSIZE( butStop );

	QPushButton * butSave = new QPushButton( _groupBottom );
	butSave->setText( tr( "End" ) );
	FIXEDSIZE( butSave );

	_groupBottom->find( 0 )->setEnabled( true );
	_groupBottom->find( 1 )->setEnabled( false );
	_groupBottom->find( 2 )->setEnabled( false );

	QVBoxLayout * layout = new QVBoxLayout( this );
	layout->addWidget( _group );
	layout->addSpacing( 5 );
	layout->addWidget( _playerList, 1 );
	layout->addSpacing( 5 );
	layout->addWidget( _groupBottom );
	layout->activate();

	connect( _groupBottom, SIGNAL( clicked( int ) ), SLOT( slot_choice( int ) ) );
}

void ServerWidget::slot_newPlayer( AttalPlayerSocket * player )
{
	_playerList->insertItem( new QListViewItem( _playerList, player->getPlayer()->getName(), player->address().toString() )  );
}

void ServerWidget::slot_endConnection( QString name )
{
	bool found = false;
	QListViewItem * item = _playerList->firstChild();

	do {
		if( item ) {
			if( item->text( 0 ) == name ) {
				found = true;
				_playerList->takeItem( item );
			} else {
				item = item->nextSibling();
			}
		} else {
			found = true;
		}
	} while( !found );
}

void ServerWidget::setGameLoaded( bool b )
{
	_loaded = b;
	if( _loaded ) {
		_groupBottom->find( 0 )->setEnabled( false );
		_groupBottom->find( 1 )->setEnabled( true );
		_groupBottom->find( 2 )->setEnabled( true );
		_group->setEnabled( false );
	} else {
		_groupBottom->find( 0 )->setEnabled( true );
		_groupBottom->find( 1 )->setEnabled( false );
		_groupBottom->find( 2 )->setEnabled( false );
		_group->setEnabled( true );
	}
}

void ServerWidget::slot_choice( int choice )
{
	switch( choice ) {
	case 0: {
		QString filename;
		switch( _group->id( _group->selected() ) ) {
		case 0:
			filename = SCENAR_PATH + "demo_1player.scn";
			break;
		case 1:
			filename = SCENAR_PATH + "demo_2players.scn";
			break;
		case 2:
			filename = _radio3->getText();
			break;
		}
		emit sig_load( filename );

		break;
	}
	case 1:
		emit sig_save();
		break;
	case 2:
		emit sig_stop();
		break;
	}
}

//
// ----- ConfigConnection -----
//

ConfigConnection::ConfigConnection( QWidget * parent, const char * name )
	: QDialog( parent, name, true )
{
	setCaption( tr( "Start server" ) );
	QVBoxLayout * layout = new QVBoxLayout( this );

	QHBoxLayout * layH1 = new QHBoxLayout();
	layH1->addSpacing( 5 );
	QLabel * labHost = new QLabel( tr( "Host : " ), this );
	FIXEDSIZE( labHost );
	layH1->addWidget( labHost );
	layH1->addSpacing( 5 );
	_host = new QLineEdit( this );
	_host->setFixedSize( 160, 20 );
	_host->setEnabled(false);
	layH1->addWidget( _host );
	layH1->addStretch( 1 );
	layout->addLayout( layH1, 1 );

	QHBoxLayout * layH2 = new QHBoxLayout();
	layH2->addSpacing( 5 );
	QLabel * labPort = new QLabel( tr( "Port : " ), this );
	FIXEDSIZE( labPort );
	layH2->addWidget( labPort );
	layH2->addSpacing( 5 );
	_port = new QLineEdit( this );
	_port->setFixedSize( 80, 20 );
	layH2->addWidget( _port );
	layH2->addStretch( 1 );
	layout->addLayout( layH2, 1 );

	
	QHBoxLayout * layH3 = new QHBoxLayout();
	QPushButton * pbOk = new QPushButton( this );
	pbOk->setText( tr( "Start" ) );
	FIXEDSIZE( pbOk );
	layH3->addStretch( 1 );
	layH3->addWidget( pbOk );
	layH3->addStretch( 1 );
	QPushButton * pbCan = new QPushButton( this );
	pbCan->setText( tr( "Quit" ) );
	FIXEDSIZE( pbCan );
	layH3->addWidget( pbCan );
	layH3->addStretch( 1 );
	layout->addLayout( layH3, 2 );

	layout->activate();

	connect( pbOk, SIGNAL( clicked() ), SLOT( accept() ) );
	connect( pbCan, SIGNAL( clicked() ), SLOT( reject() ) );

	setFixedSize( 250, 150 );
}
