/****************************************************************
**
** Attal : Lords of Doom
**
** scenarioInterface.h
** Manages the scenario editor
**
** Version : $Id: scenarioInterface.h,v 1.9 2004/02/29 18:36:51 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 27/08/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

 
#ifndef SCENARIOINTERFACE_H
#define SCENARIOINTERFACE_H
 
// include files for QT
#include <qaction.h>
#include <qdialog.h>
#include <qmainwindow.h>
#include <qptrvector.h>
#include <qstring.h>

// application specific includes

class QComboBox;
class QPopupMenu;
class QSignalMapper;

class Screen;

/*              ------------------------------
 *                         ScenarioInterface
 *              ------------------------------ */


/** comment for the class */
class ScenarioInterface : public QMainWindow
{
	Q_OBJECT
public:
	/** Constructor */
	ScenarioInterface();
	
	~ScenarioInterface();
		
public slots:
	/** Slot managing the actions */
	void slot_action( int num );
	
	/** Slot managing the status bar */
	void slot_status( const QString & text );

private:
	enum MENU_ACTION {
		ACTION_NEW,
		ACTION_OPEN,
		ACTION_SAVE,
		ACTION_SAVEAS,
		ACTION_QUIT,
		ACTION_INFO,
		ACTION_PLAYERS,
		ACTION_CLEAR,
		ACTION_FILL,
		ACTION_HELP,

		NB_ACTIONS
	};

	void actionNew();
	void actionOpen();
	void actionSave();
	void actionSaveAs();
	void actionQuit();
	void actionInfo();
	void actionPlayers();
	void actionClear();
	void actionFill();
	void actionHelp();

	/** Defines actions */
	void initActions();

	/** Define menus */
	void initMenuBar();

	/** Define statusBar */
	void initStatusBar();

	void activateMenuForScenario( bool state = true );

	void addAction( const QString & text, const QString & menuText,	const QString & key,
			MENU_ACTION num, QSignalMapper * sigmap );

	Screen * _screen;
	QString _filename;
	QPtrVector<QAction> _actions;
};

/** Dialog asking to choose a tile for filling the map with */
class FillDialog : public QDialog
{
	Q_OBJECT
public:
	/** Constructor */
	FillDialog( QWidget * parent = 0, const char * name = 0 );

	/** \return Returns the num of the tile choosen */
	int getTileNumber();
	
private:
	QComboBox * _combo;
};

#endif // SCENARIOINTERFACE_H   
