/****************************************************************
**
** Attal : FightUnits of Doom
**
** graphicalFightUnit.h
** draw a hero on the map
**
** Version : $Id: graphicalFightUnit.h,v 1.7 2004/04/06 20:39:17 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 09/08/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#ifndef GRAPHICALFIGHTUNIT_H
#define GRAPHICALFIGHTUNIT_H
 
// generic include files
// include files for QT
#include <qcanvas.h>
#include <qptrqueue.h>
// application specific includes
#include "libFight/graphicalFightCell.h"
#include "libFight/fightCell.h"

/** build the graphical part of the FightUnit */
class GraphicalFightUnit : public QCanvasSprite
{
public:
	/** Constructor */
	GraphicalFightUnit( QCanvas * canvas );

	/** Destructor */
	virtual ~GraphicalFightUnit();

	/** Set the FightUnit on the cell */
	void setPosition( GraphicalFightCell * cell );

	/** Move the lord at the given cell, path != 0 for animation, no animation
	by default */
	void goTo( GraphicalFightCell * cell );

	/** Advance animation */
	void advance( int stage );

	/** Highlight (or not) the unit if active (or not) */
	void setActive( bool /*state = true*/ ) {}

	/** Draw destroyed unit (or not) if destroyed (or not) */
	void setDestroyed( bool state );

	/** Return RTTI */
	int rtti() const { return RTTI; };

	static const int RTTI;

protected:
	void initCreatureForMove( GraphicalFightCell *cell );

	QCanvasPixmap* imageAdvanced() const;
	uint _cpt;
	GraphicalFightCell * _moving;
	QPtrQueue<GraphicalFightCell> _fifo;

 //private:
//	QCanvasRectangle * _numBox;

};

#endif // GRAPHICALFIGHTUNIT_H
