/****************************************************************
**
** Attal : Lords of Doom
**
** fightUnit.cpp
** Manage Units
**
** Version : $Id: fightUnit.cpp,v 1.8 2004/04/06 20:39:17 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 28/12/2000
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "fightUnit.h"


#include <qimage.h>
#include <qpainter.h>
// generic include files
// include files for QT
// application specific include files
#include "libCommon/creature.h"
#include "libCommon/log.h"

#include "libFight/fightCell.h"

#include "libClient/imageTheme.h"

extern ImageTheme ImageTheme;

FightUnit::FightUnit( QCanvas * canvas )
	: GraphicalFightUnit( canvas ),
	  GenericFightUnit()
{

}

FightUnit::FightUnit( QCanvas * canvas, GenericFightUnit * unit, bool mirror )
	: GraphicalFightUnit( canvas ),
	  GenericFightUnit( *unit )
{
	QCanvasPixmapArray * sequence = (*ImageTheme.creatures[computeSequence( unit )])[ (mirror) ? 1 : 0 ];

	if( sequence ) {
		GraphicalFightUnit::setSequence( sequence );
	}
	
	_lookingToRight = mirror;
}

/*!

*/

int FightUnit::hit( int nb )
{
	int ret = GenericFightUnit::hit( nb );
	if( _number == 0 ) {
		GraphicalFightUnit::setDestroyed( true );
	}

	return ret;
}


/*!

*/

void FightUnit::goTo( FightCell * cell )
{
	if( _currentFightCell ) {
		_currentFightCell->setUnit( NULL );
	}

	GraphicalFightUnit::goTo( (GraphicalFightCell *)cell );
	GenericFightUnit::goTo( (GenericFightCell *)cell );
	cell->setUnit( (GenericFightUnit *)this );
}

void FightUnit::setPosition( FightCell * cell )
{
	if( _currentFightCell ) {
		_currentFightCell->setUnit( NULL );
	}

	GraphicalFightUnit::setPosition( (GraphicalFightCell *)cell );
	GenericFightUnit::goTo( (GenericFightCell *)cell );
	cell->setUnit( (GenericFightUnit *)this );
}


void FightUnit::draw ( QPainter& painter )
{
	QCanvasSprite::draw ( painter );

	int numItems = getNumber ();

	QRect r = boundingRect ();

	int x = r.width () - 30;
	int y = r.height () - 16;

	QFont oldFont = painter.font ();
	QPen oldPen = painter.pen ();
	QBrush oldBrush = painter.brush ();
	QFont f = oldFont;
	QPen pen ( QColor ( 100, 255 , 255 ) );
	painter.setPen ( pen );
	QBrush br ( QColor ( 200, 150, 150 ) );
	painter.setBrush ( br );

	painter.drawRect ( r.left () + x, r.top () + y, 30, 16 );

	QPen fontPen ( QColor ( 120, 130, 240 ) );
	painter.setPen ( fontPen );

	f.setPixelSize ( 12 );
	painter.setFont ( f );

	QString s = QString::number ( numItems );
	painter.drawText ( r.left () + x, r.top () + y, 30, 16, Qt::AlignCenter, s );

	painter.setFont ( oldFont );
	painter.setPen ( oldPen );
	painter.setBrush ( oldBrush );
}



