/****************************************************************
**
** Attal : Lords of Doom
**
** market.cpp
** display market place
**
** Version : $Id: market.cpp,v 1.6 2004/04/08 18:02:36 lusum Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 14/01/2001
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "market.h"
 
// generic include files
// include files for QT
#include <qlayout.h>
#include <qpushbutton.h>
#include <qpixmap.h>
#include <qsignalmapper.h>
#include <qscrollbar.h>
// application specific include files
#include "libCommon/dataTheme.h"
#include "libCommon/log.h"
#include "libCommon/attalSocket.h"

#include "libClient/gui.h"
#include "libClient/widget.h"

extern QString IMAGE_PATH;
extern DataTheme DataTheme;

Market::Market( QWidget * parent, const char * name )
	: QDialog( parent, name, true )
{
	_socket=0;
	_prices = new PriceMarket();
	
	setCaption( "Marketplace" );
	
	QVBoxLayout * layout = new QVBoxLayout( this );
		     
	QHBoxLayout * layH1 = new QHBoxLayout();
	_own = new DisplayResources( this );
	_own->setTitle( "Kingdom resources" );
	layH1->addWidget( _own, 1 );

	_other = new DisplayResources( this );
	_other->setTitle( "Available for trade" );
	layH1->addWidget( _other, 1 );
	
	layout->addLayout( layH1, 1 );
	
	_exchange = new ExchangeResources( this );
	layout->addWidget( _exchange );
	
	layout->setMargin( 2 );
	layout->activate();
	
	connect( _exchange, SIGNAL( sig_buy(int , int , int ) ), SLOT( slot_buy(int , int,int) ) );
	connect( _exchange, SIGNAL( sig_quit() ), SLOT( accept() ) );
	connect( _own, SIGNAL( sig_resource( int ) ), SLOT( slot_ownResource( int ) ) );
	connect( _other, SIGNAL( sig_resource( int ) ), SLOT( slot_otherResource( int ) ) );
}

void Market::setPrices( PriceMarket * prices )
{
	_prices = prices;
	_exchange->setPrices( prices );
}

void Market::slot_ownResource( int num )
{
	_exchange->slot_ownResource( num );
	_other->setPrices( _prices, num );
}

void Market::slot_otherResource( int num )
{
	_exchange->slot_otherResource( num );
}

void Market::slot_buy( int own,int other, int value )
{
	//logDD("own %d, other %d, value %d",own,other,value);
	_socket->sendBaseMarket(own,other,value);
}

/*!  Constructs an empty

*/

DisplayResources::DisplayResources( QWidget * parent, const char * name )
	: QWidget( parent, name )
{
	uint nbResources = DataTheme.resources.count();

	QVBoxLayout * layout = new QVBoxLayout( this );
	_title = new Sentence( this );

	layout->addWidget( _title );
	layout->addStretch( 1 );

	_resources = new ResourceIcon * [ nbResources ];

	QSignalMapper * sigmap = new QSignalMapper( this );

	for( uint i = 0; i < nbResources; i+=3 ) {
		if( nbResources-i == 1 ) {
			_resources[i] = new ResourceIcon( this );
			_resources[i]->setResource( i );
			layout->addWidget( _resources[i] );
			sigmap->setMapping( _resources[i], i );
			connect( _resources[i], SIGNAL( sig_clicked() ), sigmap, SLOT( map() ) );
		} else if( nbResources-i == 2 ) {
			QHBoxLayout * layH = new QHBoxLayout();
			_resources[i] = new ResourceIcon( this );
			_resources[i]->setResource( i );
			layH->addStretch( 1 );
			layH->addWidget( _resources[i] );
			layH->addStretch( 1 );
			sigmap->setMapping( _resources[i], i );
			connect( _resources[i], SIGNAL( sig_clicked() ), sigmap, SLOT( map() ) );
			_resources[i+1] = new ResourceIcon( this );
			_resources[i+1]->setResource( i+1 );
			layH->addWidget( _resources[i+1] );
			layH->addStretch( 1 );
			sigmap->setMapping( _resources[i+1], i+1 );
			connect( _resources[i+1], SIGNAL( sig_clicked() ), sigmap, SLOT( map() ) );
			layout->addLayout( layH );
		} else {
			QHBoxLayout * layH = new QHBoxLayout();

			_resources[i] = new ResourceIcon( this );
			_resources[i]->setResource( i );
			layH->addWidget( _resources[i] );
			sigmap->setMapping( _resources[i], i );
			connect( _resources[i], SIGNAL( sig_clicked() ), sigmap, SLOT( map() ) );

			_resources[i+1] = new ResourceIcon( this );
			_resources[i+1]->setResource( i+1 );
			layH->addWidget( _resources[i+1] );
			sigmap->setMapping( _resources[i+1], i+1 );
			connect( _resources[i+1], SIGNAL( sig_clicked() ), sigmap, SLOT( map() ) );

			_resources[i+2] = new ResourceIcon( this );
			_resources[i+2]->setResource( i+2 );
			layH->addWidget( _resources[i+2] );
			sigmap->setMapping( _resources[i+2], i+2 );
			connect( _resources[i+2], SIGNAL( sig_clicked() ), sigmap, SLOT( map() ) );

			layout->addLayout( layH );
		}
	}


	layout->activate();

	connect( sigmap, SIGNAL( mapped( int ) ), SIGNAL( sig_resource( int ) ) );
}

void DisplayResources::setResources( GenericPlayer * player )
{
	uint nbResources = DataTheme.resources.count();
	for( uint i = 0; i < nbResources; i++ ) {
		_resources[i]->setValue( QString::number( player->getResource( i ) ) );
	}
}

void DisplayResources::setPrices( PriceMarket * prices, uchar resource )
{
	uint nbResources = DataTheme.resources.count();
	for( uint i = 0; i < nbResources; i++ ) {
		if( resource == i ) {
			_resources[i]->setValue( "n/a" );
		} else {
			_resources[i]->setValue( QString::number( prices->getResourceInResource( i, resource ) ) );
		}
	}
}

void DisplayResources::setTitle( QString title )
{
	_title->setText( title );
}

/*!  Constructs an empty

*/

ExchangeResources::ExchangeResources( QWidget * parent, const char * name )
	: QWidget( parent, name )
{
	_prices = new PriceMarket();
	setFixedHeight( 200 );
	
	QVBoxLayout * layout = new QVBoxLayout( this );
	
	QHBoxLayout * layH1 = new QHBoxLayout();
	
	layH1->addStretch( 2 );
	_icoLeft = new ResourceIcon( this );
	layH1->addWidget( _icoLeft );
	layH1->addSpacing( 25 );
	
	_scroll = new QScrollBar( QScrollBar::Horizontal, this );
	layH1->addWidget( _scroll, 1 );
	layH1->addSpacing( 25 );
	
	_icoRight = new ResourceIcon( this );
	layH1->addWidget( _icoRight );
	layH1->addStretch( 2 );
	
	layout->addLayout( layH1 );
	
	QHBoxLayout * layH2 = new QHBoxLayout();
	
	layH2->addStretch( 1 );
	
	_butAll = new QPushButton( this );
	_butAll->setText( "All" );
	_butAll->setFixedSize( 50, 40 );
	layH2->addWidget( _butAll );
	layH2->addSpacing( 50 );
	
	_butBuy = new QPushButton( this );
	_butBuy->setText( "Buy" );
	_butBuy->setFixedSize( 50, 40 );
	layH2->addWidget( _butBuy );
	
	layH2->addStretch( 1 );

	QPushButton * butOk = createButtonOk( this );
	layH2->addWidget( butOk );
	
	layout->addLayout( layH2 );
	
	layout->activate();
	
	connect( butOk, SIGNAL( clicked() ), SIGNAL( sig_quit() ) );
	connect( _butAll, SIGNAL( clicked() ), SLOT( slot_all() ) );
	connect( _butBuy, SIGNAL( clicked() ), SLOT( slot_buy() ) );
	connect( _scroll, SIGNAL( valueChanged( int ) ), SLOT( slot_value( int ) ) );
	
	clear();
}

void ExchangeResources::slot_all()
{
	
}

void ExchangeResources::slot_buy()
{
	emit sig_buy(_resource, _other, _value);
	clear();
}

void ExchangeResources::slot_ownResource( int num )
{
	_icoLeft->setResource( num );
	_isLeft = true;
	_resource = num;
	setValue( 0 );
	if( _isRight ) {
		_cost = _prices->getResourceInResource( num, _resource );
		_icoRight->setValue( QString::number( 0 ) );
		_scroll->setEnabled( true );
		_butBuy->setEnabled( true );
		_butAll->setEnabled( true );
	}
}

void ExchangeResources::slot_otherResource( int num )
{
	_other= num;
	_icoRight->setResource( num );
	_isRight = true;
	_icoRight->setValue( QString::number( 0 ) );
	if( _isLeft ) {
		_cost = _prices->getResourceInResource( num, _resource );
		_icoRight->setValue( QString::number( 0 ) );
		_scroll->setEnabled( true );
		_butBuy->setEnabled( true );
		_butAll->setEnabled( true );
	}
}

void ExchangeResources::clear()
{
	_icoRight->clear();
	_icoLeft->clear();
	_scroll->setEnabled( false );
	_butBuy->setEnabled( false );
	_butAll->setEnabled( false );
	_isRight = false;
	_isLeft = false;
}

void ExchangeResources::setValue( int val )
{
	_value=val;
	_scroll->setValue( val );
	_icoLeft->setValue( QString::number( val * _cost ) );
	_icoRight->setValue( QString::number( val ) );
}
