/****************************************************************
**
** Attal : Lords of Doom
**
** bonus.cpp
** Displays bonus on map
**
** Version : $Id: bonus.cpp,v 1.1 2003/08/29 12:48:32 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 29/08/2003
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "bonus.h"

// generic include files
// include files for QT
// application specific include files

// generic include files
// include files for QT
// application specific include files
#include "conf.h"

#include "libCommon/genericCell.h"
#include "libCommon/log.h"

#include "libClient/imageTheme.h"
#include "libClient/cell.h"
#include "libClient/lord.h"

extern ImageTheme ImageTheme;

const int Bonus::RTTI = 1008;

Bonus::Bonus( QCanvas * canvas )
	:QCanvasSprite( ImageTheme.bonus[0], canvas )
{
       collisions( true );
       setFrame( 0 );
       setZ( CAN_ARTEFACT );
       show();
}

void Bonus::setCell( GenericCell * cell )
{
	QRect rect = ( (Cell*)cell )->boundingRect();
	move( rect.x() , rect.y() + rect.height() - boundingRect().height() );
	show();
        canvas()->update();
}

void Bonus::setupBonus()
{
	setFrame( 0 );
	setSequence( ImageTheme.bonus[ (uint)_type ] );
	if( _type == BonusResource ) {
		setFrame( getParam( 0 ) );
	}
}




