/****************************************************************
**
** Attal : Lords of Doom
**
** gameData.cpp
** Manage data of a whole game
**
** Version : $Id: gameData.cpp,v 1.24 2005/12/10 18:13:49 audoux Exp $
**
** Author(s) : Pascal Audoux - Sardi Carlo
**
** Date : 05/01/2002
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "gameData.h"

// generic include files
// include files for QT
#include <QTextStream>

// application specific include files
#include "libCommon/artefact.h"
#include "libCommon/calendar.h"
#include "libCommon/dataTheme.h"
#include "libCommon/genericBase.h"
#include "libCommon/genericBonus.h"
#include "libCommon/genericBuilding.h"
#include "libCommon/genericCell.h"
#include "libCommon/genericChest.h"
#include "libCommon/genericEvent.h"
#include "libCommon/genericLord.h"
#include "libCommon/genericMap.h"
#include "libCommon/genericMapCreature.h"
#include "libCommon/genericPlayer.h"
#include "libServer/parser.h"
#include "libCommon/quest.h"
#include "libServer/questManager.h"

extern DataTheme DataTheme;

GameData::GameData()
	:_nbPlayer( 0 ), _map( 0 )
{
	_quests = new QuestManager();
	_calendar = new Calendar();
	_nbArtefact = 0;
	_nbBonus = 0;
	_nbChest = 0;

	reinit();
}

GameData::~GameData()
{
	while( ! _bases.isEmpty() ) {
		delete _bases.takeFirst();
	}
	while( ! _buildings.isEmpty() ) {
		delete _buildings.takeFirst();
	}
	while( ! _lords.isEmpty() ) {
		delete _lords.takeFirst();
	}
	while( ! _events.isEmpty() ) {
		delete _events.takeFirst();
	}
	while( ! _creatures.isEmpty() ) {
		delete _creatures.takeFirst();
	}

	if( _quests ) {
		delete _quests;
	}
	if( _calendar ) {
		delete _calendar;
	}
}

void GameData::save( QTextStream * ts )
{
	*ts << "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE scenario>" << endl;
	*ts << "<scenario nbPlayer=\"" << getNbPlayer() << "\">" << endl;
	*ts << "\t<name>" << getScenarioName() << "</name>" << endl;
	*ts << "\t<theme>" << getScenarioTheme() << "</theme>" << endl;
	*ts << "\t<description>" << endl;
	*ts << "\t\t" << getScenarioDescription() << endl;
	*ts << "\t</description>" << endl;
	
	_calendar->save( ts, 1 );

	_map->save( ts );

	for( int i = 0; i < _events.count(); i++ ) {
		_events.at( i )->save( ts, 1 );
	}

	for( int i = 0; i < _bases.count(); i++ ) {
		_bases.at( i )->save( ts, 1 );
	}

	for( int i = 0; i < _buildings.count(); i++ ) {
		_buildings.at( i )->save( ts, 1 );
	}

	for( int i = 0; i < _lords.count(); i++ ) {
		_lords.at( i )->save( ts, 1 );
	}

	for( int i = 0; i < _creatures.count(); i++ ) {
		_creatures.at( i )->save( ts, 1 );
	}

	for( uint i = 0; i < getNbPlayer(); i++ ) {
		_players.at( i )->save( ts, 1 );
	}

	_quests->save( ts, 1 );

	*ts << "</scenario>" << endl;
}

void GameData::reinit()
{
	if( _map ) {
		_map->clear();
	}
	
	if( _calendar ) {
		_calendar->reinit();
	}
	
	while( ! _bases.isEmpty() ) {
		delete _bases.takeFirst();
	}
	while( ! _buildings.isEmpty() ) {
		delete _buildings.takeFirst();
	}
	while( ! _lords.isEmpty() ) {
		delete _lords.takeFirst();
	}
	while( ! _events.isEmpty() ) {
		delete _events.takeFirst();
	}
	while( ! _creatures.isEmpty() ) {
		delete _creatures.takeFirst();
	}
	_quests->clear();
	
	_nbPlayer = 0;
	_nbArtefact = 0;
	_nbBonus = 0;
	_nbChest = 0;
	
	uint nbLords = DataTheme.lords.count();
	for( uint i = 0; i < nbLords; i++ ) {
		GenericLord * lord = new GenericLord();
		lord->setId( i );
		_lords.append( lord );
	}
}

GenericCell * GameData::getCell( uint row, uint col )
{
	if( ( row < _map->getHeight() ) && ( col < _map->getWidth() ) ) {
		return _map->at( row, col );
	} else {
		return 0;
	}
}

uint GameData::getBaseNumber()
{
	return _bases.count();
}

GenericBase * GameData::getBase( uint num )
{
	GenericBase * ret = 0;
	
	if( (int)num < _bases.count() ) {
		ret = _bases.at( num );
	}	
	
	return ret;
}

void GameData::loadMap( QTextStream * stream, int width, int height )
{
	if( _map ) {
		delete _map;
	}
	_map = new GenericMap();
	_map->load( stream, width, height );
}

GenericBase * GameData::getNewBase() 
{
	GenericBase * base = new GenericBase();
	_bases.append( base );
	base->setOwner(0);
	return base;
}
	
void GameData::setBase2Player( int idBase, int player ) 
{
	if( ( _players.count() > player  ) && ( _bases.count() > idBase ) ) {
		if( ( _players.at( player ) ) && ( _bases.at( idBase ) ) ) {
			_bases.at( idBase )->setOwner( _players.at( player ) );
			_players.at( player )->addBase( _bases.at( idBase ) );
		}
	}
}
	
void GameData::setBuilding2Player( int idBuild, int player )
{
	if( ( _players.count() > player  ) && ( _buildings.count() > idBuild ) ) {
		if( ( _players.at( player ) ) && ( _buildings.at( idBuild ) ) ) {
			_buildings.at( idBuild )->setOwner( _players.at( player ) );
			_players.at( player )->addBuilding( _buildings.at( idBuild ) );		
		}
	}
}

void GameData::setDateByType( int type, int value )
{
	_calendar->setDateByType(type,value);
}

uint GameData::getDateByType( int type )
{
	return _calendar->getDateByType(type);
}

GenericLord * GameData::getLord( int idLord )
{
	return _lords.at( idLord );
}

uint GameData::getLordNumber()
{
	return _lords.count();
}

GenericPlayer * GameData::getPlayer( int num )
{
	if( ( num >= 0 ) && (num < _players.count() ) ) {
		return _players.at( num );
	} else {
		return 0;
	}
}

void GameData::setLord2Player( int idLord, int player )
{
	if( ( _players.count() > player  ) && ( _lords.count() > idLord ) ) {
		if( ( _players.value( player ) ) && ( _lords.at( idLord ) ) ) {
			_lords.at( idLord )->setOwner( _players.at( player ) );
			_players.at( player )->addLord( _lords.at( idLord ) );		
		}
	}
}

GenericEvent * GameData::getNewArtefact()
{
	GenericEvent * ret = new GenericEvent();
	GenericArtefact * artefact = new GenericArtefact();
	ret->setArtefact( artefact );
	_events.append( ret );
	return ret;
}

GenericEvent * GameData::getNewBonus()
{
	GenericEvent * ret = new GenericEvent();
	GenericBonus * bonus = new GenericBonus();
	ret->setBonus( bonus );
	_events.append( ret );
	return ret;

}

GenericEvent * GameData::getNewChest()
{
	GenericEvent * ret = new GenericEvent();
	GenericChest * chest = new GenericChest();
	ret->setChest( chest );
	_events.append( ret );
	return ret;

}

GenericBuilding * GameData::getNewBuilding()
{
	GenericBuilding * ret = new GenericBuilding();
	ret->setId( _buildings.count() );
	_buildings.append( ret );
	return ret;
}

Quest * GameData::getNewQuest()
{
	Quest * ret = new Quest();
	_quests->appendSecondaryQuest( ret );
	return ret;
}

Quest * GameData::getMainQuest()
{
	Quest * ret = _quests->getMainQuest();

	if( ! ret ) {
		ret = new Quest();
		_quests->setMainQuest( ret );
	}

	return ret;
}


GenericMapCreature * GameData::getNewMapCreature()
{
	GenericMapCreature * ret = new GenericMapCreature();
	_creatures.append( ret );
	return ret;
}

